/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import com.mysql.clusterj.tie.NdbRecordScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

class NdbRecordScanResultDataImpl
extends NdbRecordResultDataImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordScanResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordScanResultDataImpl.class);
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    private NdbRecordScanOperationImpl scanOperation = null;
    private NdbScanOperation ndbScanOperation = null;
    protected long skip = 0L;
    protected long limit = Long.MAX_VALUE;
    protected long recordCounter = 0L;

    public NdbRecordScanResultDataImpl(NdbRecordScanOperationImpl scanOperation, long skip, long limit) {
        super(scanOperation);
        this.scanOperation = scanOperation;
        this.ndbScanOperation = (NdbScanOperation)scanOperation.ndbOperation;
        this.skip = skip;
        this.limit = limit;
    }

    public boolean next() {
        if (this.recordCounter >= this.limit) {
            this.ndbScanOperation.close(true, true);
            return false;
        }
        boolean done = false;
        boolean fetch = false;
        boolean force = true;
        block5: while (!done) {
            int result = this.scanOperation.nextResultCopyOut(fetch, force);
            switch (result) {
                case 0: {
                    if (++this.recordCounter <= this.skip) continue block5;
                    this.scanOperation.lockCurrentTuple();
                    return true;
                }
                case 1: {
                    this.ndbScanOperation.close(true, true);
                    return false;
                }
                case 2: {
                    fetch = true;
                    continue block5;
                }
            }
            Utility.throwError(result, this.ndbScanOperation.getNdbError());
        }
        return true;
    }
}

