/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexHandlerImpl {
    static final I18NHelper local = I18NHelper.getInstance(IndexHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexHandlerImpl.class);
    static final String UNIQUE_SUFFIX = "$unique";
    protected String className;
    protected String tableName;
    private String indexName;
    protected Index storeIndex;
    protected boolean unique = true;
    protected AbstractDomainFieldHandlerImpl[] fields;
    protected final String[] columnNames;
    private boolean usable = true;
    private String reason = null;

    public IndexHandlerImpl(DomainTypeHandler<?> domainTypeHandler, Dictionary dictionary, Index storeIndex, String[] columnNames) {
        this.className = domainTypeHandler.getName();
        this.storeIndex = storeIndex;
        this.indexName = storeIndex.getName();
        this.tableName = domainTypeHandler.getTableName();
        this.columnNames = columnNames;
        int numberOfColumns = columnNames.length;
        this.fields = new AbstractDomainFieldHandlerImpl[numberOfColumns];
        this.unique = storeIndex.isUnique();
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    public IndexHandlerImpl(DomainTypeHandler<?> domainTypeHandler, Dictionary dictionary, String indexName, AbstractDomainFieldHandlerImpl fmd) {
        this.className = domainTypeHandler.getName();
        this.indexName = indexName;
        this.tableName = domainTypeHandler.getTableName();
        this.storeIndex = this.getIndex(dictionary, this.tableName, indexName);
        this.unique = this.isUnique(this.storeIndex);
        this.columnNames = fmd.getColumnNames();
        this.fields = new AbstractDomainFieldHandlerImpl[]{fmd};
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    public CandidateIndexImpl toCandidateIndexImpl() {
        if (!this.usable) {
            return CandidateIndexImpl.getIndexForNullWhereClause();
        }
        return new CandidateIndexImpl(this.className, this.storeIndex, this.unique, this.fields);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("IndexHandler for class ");
        buffer.append(this.className);
        buffer.append(" index: ");
        buffer.append(this.indexName);
        buffer.append(" unique: ");
        buffer.append(this.unique);
        buffer.append(" columns: ");
        buffer.append(Arrays.toString(this.columnNames));
        return buffer.toString();
    }

    public void setDomainFieldHandlerFor(int i, AbstractDomainFieldHandlerImpl fmd) {
        this.fields[i] = fmd;
        fmd.validateIndexType(this.indexName, this.unique);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void assertAllColumnsHaveFields() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            AbstractDomainFieldHandlerImpl fmd = this.fields[i];
            if (fmd != null && this.columnNames[i].equals(fmd.getColumnName())) continue;
            this.usable = false;
            this.reason = local.message("ERR_Index_Mismatch", this.className, this.indexName, this.columnNames[i]);
        }
    }

    protected boolean isUnique(Index storeIndex) {
        return storeIndex.isUnique();
    }

    public boolean isUsable() {
        return this.usable;
    }

    public String getReason() {
        return this.reason;
    }

    protected Index getIndex(Dictionary dictionary, String tableName, String indexName) {
        return dictionary.getIndex(indexName, tableName, indexName);
    }

    public String getIndexName() {
        return this.indexName;
    }
}

