/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;

class NdbRecordBlobImpl
extends BlobImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordBlobImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordBlobImpl.class);
    private Column storeColumn;
    private byte[] data;
    private NdbRecordOperationImpl operation;

    public NdbRecordBlobImpl(NdbRecordOperationImpl operation, Column storeColumn) {
        this.storeColumn = storeColumn;
        this.operation = operation;
    }

    protected void setNdbBlob() {
        this.ndbBlob = this.operation.getNdbBlob(this.storeColumn);
    }

    public void setValue() {
        this.setValue(this.data);
    }

    public void setData(byte[] bytes) {
        this.data = bytes;
    }

    public void setData(String string) {
        this.data = this.storeColumn.encode(string);
    }

    public byte[] getBytesData() {
        return this.data;
    }

    public String getStringData() {
        return this.storeColumn.decode(this.data);
    }

    public void readData() {
        int length = this.getLength().intValue();
        this.data = new byte[length];
        this.readData(this.data, length);
    }
}

