/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import java.util.Arrays;

class IndexImpl
implements Index {
    static final I18NHelper local = I18NHelper.getInstance(IndexImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexImpl.class);
    private String tableName;
    private String name;
    private int noOfColumns;
    private String[] columnNames;
    private boolean unique;
    private String internalName;

    public IndexImpl(NdbDictionary.IndexConst ndbIndex, String indexAlias) {
        this.internalName = ndbIndex.getName();
        this.tableName = ndbIndex.getTable();
        this.name = indexAlias;
        this.unique = ndbIndex.getType() == 3;
        this.noOfColumns = ndbIndex.getNoOfColumns();
        this.columnNames = new String[this.noOfColumns];
        for (int i = 0; i < this.noOfColumns; ++i) {
            String columnName;
            this.columnNames[i] = columnName = ndbIndex.getColumn(i).getName();
        }
        if (logger.isDetailEnabled()) {
            logger.detail(this.toString());
        }
    }

    public IndexImpl(NdbDictionary.TableConst ndbTable) {
        this.internalName = "PRIMARY";
        this.name = "PRIMARY";
        this.tableName = ndbTable.getName();
        this.unique = true;
        this.noOfColumns = ndbTable.getNoOfPrimaryKeys();
        this.columnNames = new String[this.noOfColumns];
        for (int i = 0; i < this.noOfColumns; ++i) {
            this.columnNames[i] = ndbTable.getPrimaryKey(i);
        }
        if (logger.isDetailEnabled()) {
            logger.detail(this.toString());
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getName() {
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String toString() {
        return "IndexImpl name: " + this.name + " internal name: " + this.internalName + " table: " + this.tableName + " unique: " + this.unique + " columns: " + Arrays.toString(this.columnNames);
    }
}

