/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.SessionFactoryImpl;
import com.mysql.clusterj.core.StateManager;
import com.mysql.clusterj.core.StoreManager;
import com.mysql.clusterj.core.TransactionImpl;
import com.mysql.clusterj.core.query.QueryBuilderImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.query.QueryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.SmartValueHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements SessionSPI,
CacheManager,
StoreManager {
    static final I18NHelper local = I18NHelper.getInstance(SessionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(SessionImpl.class);
    protected SessionFactoryImpl factory;
    protected Db db;
    protected Dictionary dictionary;
    protected TransactionImpl transactionImpl;
    protected PartitionKey partitionKey = null;
    protected boolean rollbackOnly = false;
    protected ClusterTransaction clusterTransaction;
    protected String joinTransactionId = null;
    protected Map properties;
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    protected List<StateManager> changeList = new ArrayList<StateManager>();
    protected List<Runnable> postExecuteOperations = new ArrayList<Runnable>();
    protected TransactionState transactionState;
    private ClusterJException transactionException;
    protected int nestedAutoTransactionCounter = 0;
    protected int numberOfRetries = 5;
    private LockMode lockmode = LockMode.READ_COMMITTED;
    protected TransactionState transactionStateNotActive = new TransactionState(){

        public boolean isActive() {
            return false;
        }

        public TransactionState begin() {
            try {
                SessionImpl.this.internalBegin();
                return SessionImpl.this.transactionStateActive;
            }
            catch (ClusterJException ex) {
                SessionImpl.this.transactionException = ex;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        public TransactionState commit() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active_For_Method", (Object)"commit"));
            return SessionImpl.this.transactionStateNotActive;
        }

        public TransactionState rollback() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active_For_Method", (Object)"rollback"));
            return SessionImpl.this.transactionStateNotActive;
        }

        public TransactionState start() {
            try {
                SessionImpl.this.internalBegin();
                SessionImpl.this.clusterTransaction.setAutocommit(true);
                SessionImpl.this.nestedAutoTransactionCounter = 1;
                return SessionImpl.this.transactionStateAutocommit;
            }
            catch (ClusterJException ex) {
                SessionImpl.this.transactionException = ex;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        public TransactionState end() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_Start", (Object)"end"));
        }

        public TransactionState fail() {
            return SessionImpl.this.transactionStateNotActive;
        }
    };
    protected TransactionState transactionStateActive = new TransactionState(){

        public boolean isActive() {
            return true;
        }

        public TransactionState begin() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Not_Be_Active_For_Method", (Object)"begin"));
            return SessionImpl.this.transactionStateActive;
        }

        public TransactionState commit() {
            try {
                SessionImpl.this.flush();
                SessionImpl.this.internalCommit();
            }
            catch (ClusterJException ex) {
                SessionImpl.this.transactionException = ex;
            }
            return SessionImpl.this.transactionStateNotActive;
        }

        public TransactionState rollback() {
            try {
                SessionImpl.this.internalRollback();
                return SessionImpl.this.transactionStateNotActive;
            }
            catch (ClusterJException ex) {
                SessionImpl.this.transactionException = ex;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        public TransactionState start() {
            return SessionImpl.this.transactionStateActive;
        }

        public TransactionState end() {
            return SessionImpl.this.transactionStateActive;
        }

        public TransactionState fail() {
            return SessionImpl.this.transactionStateActive;
        }
    };
    protected TransactionState transactionStateAutocommit = new TransactionState(){

        public boolean isActive() {
            return true;
        }

        public TransactionState begin() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"begin"));
        }

        public TransactionState commit() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"commit"));
        }

        public TransactionState rollback() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"rollback"));
        }

        public TransactionState start() {
            ++SessionImpl.this.nestedAutoTransactionCounter;
            return SessionImpl.this.transactionStateAutocommit;
        }

        public TransactionState end() {
            if (--SessionImpl.this.nestedAutoTransactionCounter > 0) {
                return SessionImpl.this.transactionStateAutocommit;
            }
            if (SessionImpl.this.nestedAutoTransactionCounter == 0) {
                try {
                    SessionImpl.this.internalCommit();
                }
                catch (ClusterJException ex) {
                    SessionImpl.this.transactionException = ex;
                }
                return SessionImpl.this.transactionStateNotActive;
            }
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_Start", (Object)"end"));
        }

        public TransactionState fail() {
            try {
                SessionImpl.this.nestedAutoTransactionCounter = 0;
                SessionImpl.this.internalRollback();
                return SessionImpl.this.transactionStateNotActive;
            }
            catch (ClusterJException ex) {
                return SessionImpl.this.transactionStateNotActive;
            }
        }
    };

    SessionImpl(SessionFactoryImpl factory, Map properties, Db db, Dictionary dictionary) {
        this.factory = factory;
        this.db = db;
        this.dictionary = dictionary;
        this.properties = properties;
        this.transactionImpl = new TransactionImpl(this);
        this.transactionState = this.transactionStateNotActive;
    }

    @Override
    public <T> Query<T> createQuery(QueryDefinition<T> qd) {
        if (!(qd instanceof QueryDomainTypeImpl)) {
            throw new ClusterJUserException(local.message("ERR_Exception_On_Method", (Object)"createQuery"));
        }
        return new QueryImpl(this, (QueryDomainTypeImpl)qd);
    }

    @Override
    public <T> T find(Class<T> cls, Object key) {
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(cls);
        ValueHandler keyHandler = domainTypeHandler.createKeyValueHandler(key, this.db);
        return this.initializeFromDatabase(domainTypeHandler, null, null, keyHandler);
    }

    @Override
    public <T> T initializeFromDatabase(DomainTypeHandler<T> domainTypeHandler, T instance, ValueHandler instanceHandler, ValueHandler keyHandler) {
        this.startAutoTransaction();
        if (keyHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)keyHandler;
                this.setPartitionKey(domainTypeHandler, smartValueHandler);
                Operation operation = smartValueHandler.load(this.clusterTransaction);
                this.endAutoTransaction();
                if (this.isActive()) {
                    this.clusterTransaction.executeNoCommit(false, true);
                }
                if (smartValueHandler.found().booleanValue()) {
                    return domainTypeHandler.newInstance(smartValueHandler);
                }
                return null;
            }
            catch (ClusterJException ex) {
                this.failAutoTransaction();
                throw ex;
            }
        }
        try {
            ResultData rs = this.selectUnique(domainTypeHandler, keyHandler, null);
            if (rs.next()) {
                if (instanceHandler == null) {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Creating instanceHandler for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + keyHandler.pkToString(domainTypeHandler));
                    }
                    instance = domainTypeHandler.newInstance(this.db);
                    instanceHandler = domainTypeHandler.getValueHandler(instance);
                } else if (instance == null) {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Creating instance for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + keyHandler.pkToString(domainTypeHandler));
                    }
                    instance = domainTypeHandler.getInstance(instanceHandler);
                }
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("No instance found in database for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + keyHandler.pkToString(domainTypeHandler));
                }
                if (instanceHandler != null) {
                    instanceHandler.found(Boolean.FALSE);
                }
                this.endAutoTransaction();
                return null;
            }
            instanceHandler.found(Boolean.TRUE);
            domainTypeHandler.objectSetValues(rs, instanceHandler);
            domainTypeHandler.objectSetCacheManager(this, instanceHandler);
            domainTypeHandler.objectResetModified(instanceHandler);
        }
        catch (ClusterJException ex) {
            this.failAutoTransaction();
            throw ex;
        }
        this.endAutoTransaction();
        return instance;
    }

    private void setPartitionKey(DomainTypeHandler<?> domainTypeHandler, ValueHandler keyHandler) {
        if (!this.isEnlisted()) {
            PartitionKey partitionKey = domainTypeHandler.createPartitionKey(keyHandler);
            this.clusterTransaction.setPartitionKey(partitionKey);
        }
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        return this.factory.newInstance(cls, this.dictionary, this.db);
    }

    @Override
    public <T> T newInstance(Class<T> cls, Object key) {
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(cls);
        T instance = this.factory.newInstance(cls, this.dictionary, this.db);
        domainTypeHandler.objectSetKeys(key, instance);
        return instance;
    }

    @Override
    public <T> T newInstance(ResultData resultData, DomainTypeHandler<T> domainTypeHandler) {
        T result = domainTypeHandler.newInstance(resultData, this.db);
        return result;
    }

    @Override
    public <T> T load(T object) {
        if (object == null) {
            return null;
        }
        if (Iterable.class.isAssignableFrom(object.getClass())) {
            Iterable instances = (Iterable)object;
            for (Object instance : instances) {
                this.load(instance);
            }
            return object;
        }
        if (object.getClass().isArray()) {
            Object[] instances;
            for (Object instance : instances = (Object[])object) {
                this.load(instance);
            }
            return object;
        }
        this.assertActive();
        final DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(object);
        final ValueHandler instanceHandler = domainTypeHandler.getValueHandler(object);
        this.setPartitionKey(domainTypeHandler, instanceHandler);
        if (instanceHandler instanceof SmartValueHandler) {
            Operation operation = ((SmartValueHandler)instanceHandler).load(this.clusterTransaction);
            return object;
        }
        Table storeTable = domainTypeHandler.getStoreTable();
        Operation op = this.clusterTransaction.getSelectOperation(storeTable);
        op.beginDefinition();
        domainTypeHandler.operationSetKeys(instanceHandler, op);
        domainTypeHandler.operationGetValues(op);
        op.endDefinition();
        final ResultData rs = op.resultData(false);
        final SessionImpl cacheManager = this;
        Runnable postExecuteOperation = new Runnable(){

            public void run() {
                if (rs.next()) {
                    instanceHandler.found(Boolean.TRUE);
                    domainTypeHandler.objectSetValues(rs, instanceHandler);
                    domainTypeHandler.objectSetCacheManager(cacheManager, instanceHandler);
                    domainTypeHandler.objectResetModified(instanceHandler);
                } else {
                    instanceHandler.found(Boolean.FALSE);
                }
            }
        };
        this.clusterTransaction.postExecuteCallback(postExecuteOperation);
        return object;
    }

    @Override
    public Boolean found(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof DynamicObject) {
            return ((DynamicObject)instance).found();
        }
        this.getDomainTypeHandler(instance);
        return true;
    }

    @Override
    public <T> T makePersistent(T object) {
        if (object == null) {
            return null;
        }
        if (Iterable.class.isAssignableFrom(object.getClass())) {
            this.startAutoTransaction();
            Iterable instances = (Iterable)object;
            for (Object instance : instances) {
                this.makePersistent(instance);
            }
            this.endAutoTransaction();
            return object;
        }
        if (object.getClass().isArray()) {
            Object[] instances;
            this.startAutoTransaction();
            for (Object instance : instances = (Object[])object) {
                this.makePersistent(instance);
            }
            this.endAutoTransaction();
            return object;
        }
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(object);
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        this.insert(domainTypeHandler, valueHandler);
        return object;
    }

    @Override
    public Operation insert(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation result = smartValueHandler.insert(this.clusterTransaction);
                valueHandler.resetModified();
                this.endAutoTransaction();
                return result;
            }
            catch (ClusterJException cjex) {
                this.failAutoTransaction();
                throw cjex;
            }
        }
        Operation op = null;
        Table storeTable = null;
        try {
            storeTable = domainTypeHandler.getStoreTable();
            op = this.clusterTransaction.getInsertOperation(storeTable);
            op.beginDefinition();
            domainTypeHandler.operationSetKeys(valueHandler, op);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, op);
            op.endDefinition();
            domainTypeHandler.objectResetModified(valueHandler);
        }
        catch (ClusterJUserException cjuex) {
            this.failAutoTransaction();
            throw cjuex;
        }
        catch (ClusterJException cjex) {
            this.failAutoTransaction();
            logger.error(local.message("ERR_Insert", (Object)storeTable.getName()));
            throw new ClusterJException(local.message("ERR_Insert", (Object)storeTable.getName()), cjex);
        }
        catch (RuntimeException rtex) {
            this.failAutoTransaction();
            logger.error(local.message("ERR_Insert", (Object)storeTable.getName()));
            throw new ClusterJException(local.message("ERR_Insert", (Object)storeTable.getName()), rtex);
        }
        this.endAutoTransaction();
        return op;
    }

    public Iterable makePersistentAll(Iterable instances) {
        this.startAutoTransaction();
        ArrayList result = new ArrayList();
        for (Object instance : instances) {
            result.add(this.makePersistent(instance));
        }
        this.endAutoTransaction();
        return result;
    }

    @Override
    public <T> void deletePersistent(Class<T> cls, Object key) {
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(cls);
        ValueHandler keyValueHandler = domainTypeHandler.createKeyValueHandler(key, this.db);
        this.delete((DomainTypeHandler)domainTypeHandler, keyValueHandler);
    }

    @Override
    public void deletePersistent(Object object) {
        if (object == null) {
            return;
        }
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(object);
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        this.delete((DomainTypeHandler)domainTypeHandler, valueHandler);
    }

    public Operation delete(DomainTypeHandler domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        Table storeTable = domainTypeHandler.getStoreTable();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation result = smartValueHandler.delete(this.clusterTransaction);
                this.endAutoTransaction();
                return result;
            }
            catch (ClusterJException cjex) {
                this.failAutoTransaction();
                throw cjex;
            }
        }
        Operation op = null;
        try {
            op = this.clusterTransaction.getDeleteOperation(storeTable);
            op.beginDefinition();
            domainTypeHandler.operationSetKeys(valueHandler, op);
            op.endDefinition();
        }
        catch (ClusterJException ex) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Delete", (Object)storeTable.getName()), ex);
        }
        this.endAutoTransaction();
        return op;
    }

    public void deletePersistentAll(Iterable objects) {
        this.startAutoTransaction();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.deletePersistent(it.next());
        }
        this.endAutoTransaction();
    }

    @Override
    public <T> int deletePersistentAll(Class<T> cls) {
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(cls);
        return this.deletePersistentAll(domainTypeHandler);
    }

    @Override
    public int deletePersistentAll(DomainTypeHandler<?> domainTypeHandler) {
        this.startAutoTransaction();
        Table storeTable = domainTypeHandler.getStoreTable();
        String tableName = storeTable.getName();
        ScanOperation op = null;
        int count = 0;
        try {
            op = this.clusterTransaction.getTableScanOperationLockModeExclusiveScanFlagKeyInfo(storeTable);
            count = this.deletePersistentAll(op, true);
        }
        catch (ClusterJException ex) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Delete_All", (Object)tableName), ex);
        }
        this.endAutoTransaction();
        return count;
    }

    @Override
    public int deletePersistentAll(ScanOperation op, boolean abort) {
        int cacheCount = 0;
        int count = 0;
        boolean done = false;
        boolean fetch = true;
        this.clusterTransaction.setAutocommit(false);
        this.clusterTransaction.executeNoCommit(true, true);
        block5: while (!done) {
            int result = op.nextResult(fetch);
            switch (result) {
                case 0: {
                    op.deleteCurrentTuple();
                    ++count;
                    ++cacheCount;
                    fetch = false;
                    continue block5;
                }
                case 1: {
                    done = true;
                    if (cacheCount != 0) {
                        this.clusterTransaction.executeNoCommit(abort, true);
                    }
                    op.close();
                    continue block5;
                }
                case 2: {
                    this.clusterTransaction.executeNoCommit(abort, true);
                    cacheCount = 0;
                    fetch = true;
                    continue block5;
                }
            }
            throw new ClusterJException(local.message("ERR_Next_Result_Illegal", result));
        }
        return count;
    }

    @Override
    public ResultData selectUnique(DomainTypeHandler<?> domainTypeHandler, ValueHandler keyHandler, BitSet fields) {
        this.assertActive();
        this.setPartitionKey(domainTypeHandler, keyHandler);
        Table storeTable = domainTypeHandler.getStoreTable();
        Operation op = this.clusterTransaction.getSelectOperation(storeTable);
        op.beginDefinition();
        domainTypeHandler.operationSetKeys(keyHandler, op);
        domainTypeHandler.operationGetValues(op);
        op.endDefinition();
        ResultData rs = op.resultData();
        return rs;
    }

    @Override
    public void updatePersistent(Object object) {
        if (object == null) {
            return;
        }
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(object);
        if (logger.isDetailEnabled()) {
            logger.detail("UpdatePersistent on object " + object);
        }
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        this.update(domainTypeHandler, valueHandler);
    }

    @Override
    public Operation update(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation result = smartValueHandler.update(this.clusterTransaction);
                this.endAutoTransaction();
                return result;
            }
            catch (ClusterJException cjex) {
                this.failAutoTransaction();
                throw cjex;
            }
        }
        Table storeTable = null;
        Operation op = null;
        try {
            storeTable = domainTypeHandler.getStoreTable();
            op = this.clusterTransaction.getUpdateOperation(storeTable);
            domainTypeHandler.operationSetKeys(valueHandler, op);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, op);
            if (logger.isDetailEnabled()) {
                logger.detail("Updated object " + valueHandler);
            }
        }
        catch (ClusterJException ex) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Update", (Object)storeTable.getName()), ex);
        }
        this.endAutoTransaction();
        return op;
    }

    public void updatePersistentAll(Iterable objects) {
        this.startAutoTransaction();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.updatePersistent(it.next());
        }
        this.endAutoTransaction();
    }

    @Override
    public <T> T savePersistent(T instance) {
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(instance);
        if (logger.isDetailEnabled()) {
            logger.detail("UpdatePersistent on object " + instance);
        }
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(instance);
        this.startAutoTransaction();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                smartValueHandler.write(this.clusterTransaction);
                valueHandler.resetModified();
                this.endAutoTransaction();
                return instance;
            }
            catch (ClusterJException cjex) {
                this.failAutoTransaction();
                throw cjex;
            }
        }
        Table storeTable = null;
        try {
            storeTable = domainTypeHandler.getStoreTable();
            Operation op = null;
            op = this.clusterTransaction.getWriteOperation(storeTable);
            domainTypeHandler.operationSetKeys(valueHandler, op);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, op);
        }
        catch (ClusterJException ex) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Write", (Object)storeTable.getName()), ex);
        }
        this.endAutoTransaction();
        return instance;
    }

    public Iterable savePersistentAll(Iterable instances) {
        ArrayList result = new ArrayList();
        this.startAutoTransaction();
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            result.add(this.savePersistent(it.next()));
        }
        this.endAutoTransaction();
        return result;
    }

    @Override
    public Transaction currentTransaction() {
        return this.transactionImpl;
    }

    @Override
    public void close() {
        if (this.clusterTransaction != null) {
            this.clusterTransaction.close();
            this.clusterTransaction = null;
        }
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.db == null;
    }

    protected void assertNotClosed() {
        if (this.isClosed()) {
            throw new ClusterJUserException(local.message("ERR_Session_Closed"));
        }
    }

    @Override
    public void begin() {
        if (logger.isDebugEnabled()) {
            logger.debug("begin transaction.");
        }
        this.transactionState = this.transactionState.begin();
        this.handleTransactionException();
    }

    protected void internalBegin() {
        try {
            this.clusterTransaction = this.db.startTransaction(this.joinTransactionId);
            this.clusterTransaction.setLockMode(this.lockmode);
            if (this.partitionKey != null) {
                this.clusterTransaction.setPartitionKey(this.partitionKey);
            }
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Ndb_Start"), ex);
        }
    }

    @Override
    public void commit() {
        if (logger.isDebugEnabled()) {
            logger.debug("commit transaction.");
        }
        this.transactionState = this.transactionState.commit();
        this.handleTransactionException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit() {
        if (this.rollbackOnly) {
            try {
                this.internalRollback();
                throw new ClusterJException(local.message("ERR_Transaction_Rollback_Only"));
            }
            catch (ClusterJException ex) {
                throw new ClusterJException(local.message("ERR_Transaction_Rollback_Only"), ex);
            }
        }
        try {
            this.clusterTransaction.executeCommit(false, true);
        }
        finally {
            this.clusterTransaction.close();
            this.clusterTransaction = null;
            this.partitionKey = null;
        }
    }

    @Override
    public void rollback() {
        if (logger.isDebugEnabled()) {
            logger.debug("roll back transaction.");
        }
        this.transactionState = this.transactionState.rollback();
        this.handleTransactionException();
    }

    protected void internalRollback() {
        try {
            this.clusterTransaction.executeRollback();
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Transaction_Execute", (Object)"rollback"), ex);
        }
        finally {
            if (this.clusterTransaction != null) {
                this.clusterTransaction.close();
            }
            this.clusterTransaction = null;
            this.partitionKey = null;
        }
    }

    @Override
    public void startAutoTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug("start AutoTransaction");
        }
        this.transactionState = this.transactionState.start();
        this.handleTransactionException();
    }

    @Override
    public void endAutoTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug("end AutoTransaction");
        }
        this.transactionState = this.transactionState.end();
        this.handleTransactionException();
    }

    @Override
    public void failAutoTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug("fail AutoTransaction");
        }
        this.transactionState = this.transactionState.fail();
    }

    protected void handleTransactionException() {
        if (this.transactionException == null) {
            return;
        }
        ClusterJException ex = this.transactionException;
        this.transactionException = null;
        throw ex;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    protected synchronized <T> DomainTypeHandler<T> getDomainTypeHandler(T object) {
        DomainTypeHandler<T> domainTypeHandler = this.factory.getDomainTypeHandler(object, this.dictionary);
        return domainTypeHandler;
    }

    public synchronized <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> cls) {
        DomainTypeHandler<Class<T>> domainTypeHandler = this.factory.getDomainTypeHandler(cls, this.dictionary);
        return domainTypeHandler;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    boolean isActive() {
        return this.transactionState.isActive();
    }

    @Override
    public boolean isEnlisted() {
        return this.clusterTransaction == null ? false : this.clusterTransaction.isEnlisted();
    }

    private void assertActive() {
        if (!this.transactionState.isActive()) {
            throw new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active"));
        }
    }

    private void assertNotActive(String methodName) {
        if (this.transactionState.isActive()) {
            throw new ClusterJUserException(local.message("ERR_Transaction_Must_Not_Be_Active_For_Method", (Object)methodName));
        }
    }

    public Query createQuery(Class cls) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return new QueryBuilderImpl(this);
    }

    @Override
    public IndexScanOperation getIndexScanOperation(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexScanOperation result = this.clusterTransaction.getIndexScanOperation(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public IndexScanOperation getIndexScanOperationMultiRange(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexScanOperation result = this.clusterTransaction.getIndexScanOperationMultiRange(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public IndexScanOperation getIndexScanDeleteOperation(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexScanOperation result = this.clusterTransaction.getIndexScanOperationLockModeExclusiveScanFlagKeyInfo(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public ScanOperation getTableScanOperation(Table storeTable) {
        this.assertActive();
        try {
            ScanOperation result = this.clusterTransaction.getTableScanOperation(storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Table_Scan", (Object)storeTable.getName()), ex);
        }
    }

    @Override
    public ScanOperation getTableScanDeleteOperation(Table storeTable) {
        this.assertActive();
        try {
            ScanOperation result = this.clusterTransaction.getTableScanOperationLockModeExclusiveScanFlagKeyInfo(storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Table_Scan", (Object)storeTable.getName()), ex);
        }
    }

    @Override
    public IndexOperation getUniqueIndexOperation(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexOperation result = this.clusterTransaction.getUniqueIndexOperation(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Unique_Index", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public IndexOperation getUniqueIndexUpdateOperation(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexOperation result = this.clusterTransaction.getUniqueIndexUpdateOperation(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Unique_Index_Update", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public Operation getSelectOperation(Table storeTable) {
        this.assertActive();
        try {
            Operation result = this.clusterTransaction.getSelectOperation(storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Select", (Object)storeTable), ex);
        }
    }

    @Override
    public Operation getDeleteOperation(Table storeTable) {
        this.assertActive();
        try {
            Operation result = this.clusterTransaction.getDeleteOperation(storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Delete", (Object)storeTable), ex);
        }
    }

    @Override
    public Operation getUpdateOperation(Table storeTable) {
        this.assertActive();
        try {
            Operation result = this.clusterTransaction.getUpdateOperation(storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Update", (Object)storeTable), ex);
        }
    }

    @Override
    public IndexOperation getUniqueIndexDeleteOperation(Index storeIndex, Table storeTable) {
        this.assertActive();
        try {
            IndexOperation result = this.clusterTransaction.getUniqueIndexDeleteOperation(storeIndex, storeTable);
            return result;
        }
        catch (ClusterJException ex) {
            throw new ClusterJException(local.message("ERR_Unique_Index_Delete", (Object)storeTable.getName(), (Object)storeIndex.getName()), ex);
        }
    }

    @Override
    public void flush() {
        if (logger.isDetailEnabled()) {
            logger.detail("flush changes with changeList size: " + this.changeList.size());
        }
        if (!this.changeList.isEmpty()) {
            for (StateManager sm : this.changeList) {
                sm.flush(this);
            }
            this.changeList.clear();
        }
        if (this.clusterTransaction != null) {
            this.executeNoCommit();
        }
    }

    public List getChangeList() {
        return Collections.unmodifiableList(this.changeList);
    }

    @Override
    public void persist(Object instance) {
        this.makePersistent(instance);
    }

    @Override
    public void remove(Object instance) {
        this.deletePersistent(instance);
    }

    @Override
    public void markModified(StateManager instance) {
        this.changeList.add(instance);
    }

    @Override
    public void setPartitionKey(Class<?> domainClass, Object key) {
        DomainTypeHandler<?> domainTypeHandler = this.getDomainTypeHandler(domainClass);
        String tableName = domainTypeHandler.getTableName();
        if (this.isEnlisted()) {
            throw new ClusterJUserException(local.message("ERR_Set_Partition_Key_After_Enlistment", (Object)tableName));
        }
        if (this.partitionKey != null) {
            throw new ClusterJUserException(local.message("ERR_Set_Partition_Key_Twice", (Object)tableName));
        }
        ValueHandler handler = domainTypeHandler.createKeyValueHandler(key, this.db);
        this.partitionKey = domainTypeHandler.createPartitionKey(handler);
        if (this.clusterTransaction != null) {
            this.clusterTransaction.setPartitionKey(this.partitionKey);
        }
    }

    @Override
    public void markModified(Object instance, String fieldName) {
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(instance);
        ValueHandler handler = domainTypeHandler.getValueHandler(instance);
        domainTypeHandler.objectMarkModified(handler, fieldName);
    }

    @Override
    public void executeNoCommit(boolean abort, boolean force) {
        if (this.clusterTransaction != null) {
            this.clusterTransaction.executeNoCommit(abort, force);
        }
    }

    @Override
    public void executeNoCommit() {
        this.executeNoCommit(false, true);
    }

    @Override
    public <T> QueryDomainType<T> createQueryDomainType(DomainTypeHandler<T> domainTypeHandler) {
        QueryBuilderImpl builder = (QueryBuilderImpl)this.getQueryBuilder();
        return builder.createQueryDefinition(domainTypeHandler);
    }

    @Override
    public String getCoordinatedTransactionId() {
        return this.clusterTransaction.getCoordinatedTransactionId();
    }

    @Override
    public void setCoordinatedTransactionId(String coordinatedTransactionId) {
        this.clusterTransaction.setCoordinatedTransactionId(coordinatedTransactionId);
    }

    @Override
    public void setLockMode(LockMode lockmode) {
        this.lockmode = lockmode;
        if (this.clusterTransaction != null) {
            this.clusterTransaction.setLockMode(lockmode);
        }
    }

    @Override
    public String unloadSchema(Class<?> cls) {
        return this.factory.unloadSchema(cls, this.dictionary);
    }

    protected static interface TransactionState {
        public boolean isActive();

        public TransactionState begin();

        public TransactionState commit();

        public TransactionState rollback();

        public TransactionState start();

        public TransactionState end();

        public TransactionState fail();
    }
}

