/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.annotation.PersistenceCapable;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.StringTypes;

public class SchemaChangeTest
extends AbstractClusterJModelTest {
    private static final String modifyTableStatement = "alter table stringtypes drop column string_not_null_none";
    private static final String restoreTableStatement = "alter table stringtypes add string_not_null_none varchar(20) DEFAULT NULL";

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(StringTypes.class);
        this.session.makePersistent(this.session.newInstance(StringTypes.class, (Object)0));
        this.addTearDownClasses(StringTypes.class);
    }

    public void testFind() {
        logger.info("PLEASE IGNORE THE FOLLOWING EXPECTED SEVERE ERROR.");
        this.executeSQL(modifyTableStatement);
        try {
            this.session.find(StringTypes.class, (Object)0);
        }
        catch (ClusterJDatastoreException dex) {
            ColumnMetadata[] metadatas;
            if (!dex.getMessage().contains("code 284")) {
                this.error("ClusterJDatastoreException must contain code 284 but contains only " + dex.getMessage());
            }
            String tableName = this.session.unloadSchema(StringTypes.class);
            this.errorIfNotEqual("Table name mismatch", "stringtypes", tableName);
            StringTypes2 zero = (StringTypes2)((Object)this.session.find(StringTypes2.class, (Object)0));
            for (ColumnMetadata metadata : metadatas = zero.columnMetadata()) {
                if (!"string_not_null_none".equals(metadata.name())) continue;
                this.error("Column string_not_null_none should not exist after schema change.");
            }
            try {
                this.session.find(StringTypes.class, (Object)0);
                this.error("Unexpected success using StringTypes class without column string_not_null_none defined");
            }
            catch (ClusterJUserException uex) {
                this.executeSQL(restoreTableStatement);
                this.session.find(StringTypes.class, (Object)0);
            }
        }
        logger.info("PLEASE IGNORE THE PRECEDING EXPECTED SEVERE ERROR.\n");
        this.failOnError();
    }

    @PersistenceCapable(table="stringtypes")
    public static class StringTypes2
    extends DynamicObject {
    }
}

