/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.math.BigInteger;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.BigIntegerTypes;
import testsuite.clusterj.model.IdBase;

public class QueryBigIntegerTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return BigIntegerTypes.class;
    }

    void createInstances(int number) {
        this.createAllBigIntegerTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanDecimal();
        this.hashIndexScanDecimal();
        this.bothIndexScanDecimal();
        this.noneIndexScanDecimal();
        this.failOnError();
    }

    public void btreeIndexScanDecimal() {
        this.equalQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void hashIndexScanDecimal() {
        this.equalQuery("decimal_null_hash", "idx_decimal_null_hash", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_hash", "none", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_hash", "none", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void bothIndexScanDecimal() {
        this.equalQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void noneIndexScanDecimal() {
        this.equalQuery("decimal_null_none", "none", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_none", "none", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_none", "none", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_none", "none", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    private void createAllBigIntegerTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            BigIntegerTypes instance = (BigIntegerTypes)this.session.newInstance(BigIntegerTypes.class);
            instance.setId(i);
            instance.setDecimal_null_hash(this.getBigInteger(i));
            instance.setDecimal_null_btree(this.getBigInteger(i));
            instance.setDecimal_null_both(this.getBigInteger(i));
            instance.setDecimal_null_none(this.getBigInteger(i));
            this.instances.add(instance);
        }
    }

    protected BigInteger getBigInteger(int number) {
        return BigInteger.valueOf(number * 10000);
    }

    protected void printResultInstance(IdBase instance) {
        if (instance instanceof BigIntegerTypes) {
            BigIntegerTypes bigIntegerTypes = (BigIntegerTypes)instance;
        }
    }

    public static String toString(IdBase idBase) {
        BigIntegerTypes instance = (BigIntegerTypes)idBase;
        StringBuffer buffer = new StringBuffer("BigIntegerTypes id: ");
        buffer.append(instance.getId());
        buffer.append("; decimal_null_both: ");
        buffer.append(instance.getDecimal_null_both().toString());
        buffer.append("; decimal_null_btree: ");
        buffer.append(instance.getDecimal_null_btree().toString());
        buffer.append("; decimal_null_hash: ");
        buffer.append(instance.getDecimal_null_hash().toString());
        buffer.append("; decimal_null_none: ");
        buffer.append(instance.getDecimal_null_none().toString());
        return buffer.toString();
    }
}

