/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.LongIntStringPK;

public class LongIntStringPKTest
extends AbstractClusterJTest {
    protected int PK_MODULUS = 2;
    protected int NUMBER_OF_INSTANCES = this.PK_MODULUS * this.PK_MODULUS * this.PK_MODULUS;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;
    protected List<LongIntStringPK> instances = new ArrayList<LongIntStringPK>();

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(LongIntStringPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(LongIntStringPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            Object[] key = new Object[]{this.getPK1(i), this.getPK2(i), this.getPK3(i)};
            LongIntStringPK result = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)key);
            this.verify(result, i, false);
        }
    }

    protected void update() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            LongIntStringPK instance = this.createInstance(i);
            instance.setStringvalue(this.getValue(this.NUMBER_OF_INSTANCES - i));
            this.session.updatePersistent((Object)instance);
            this.verify(instance, i, true);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 4) continue;
            Object[] key = new Object[]{this.getPK1(i), this.getPK2(i), this.getPK3(i)};
            LongIntStringPK instance = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)key);
            this.verify(instance, i, true);
        }
    }

    protected void delete() {
        int i;
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            LongIntStringPK instance = this.createInstance(i);
            this.session.deletePersistent((Object)instance);
        }
        for (i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            if (0 != i % 5) continue;
            Object[] key = new Object[]{this.getPK1(i), this.getPK2(i), this.getPK3(i)};
            LongIntStringPK instance = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)key);
            this.errorIfNotEqual("Failed to delete instance: " + i, null, instance);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            LongIntStringPK instance = this.createInstance(i);
            this.instances.add(instance);
        }
    }

    protected LongIntStringPK createInstance(int index) {
        LongIntStringPK instance = (LongIntStringPK)this.session.newInstance(LongIntStringPK.class);
        instance.setLongpk(this.getPK1(index));
        instance.setIntpk(this.getPK2(index));
        instance.setStringpk(this.getPK3(index));
        instance.setStringvalue(this.getValue(index));
        return instance;
    }

    protected String toString(LongIntStringPK instance) {
        StringBuffer result = new StringBuffer();
        result.append("LongIntStringPK[");
        result.append(instance.getLongpk());
        result.append(",");
        result.append(instance.getIntpk());
        result.append(",\"");
        result.append(instance.getStringpk());
        result.append("\"]: ");
        result.append(instance.getStringvalue());
        result.append(".");
        return result.toString();
    }

    protected long getPK1(int index) {
        return this.PRETTY_BIG_NUMBER * (long)(index / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected int getPK2(int index) {
        return index / this.PK_MODULUS % this.PK_MODULUS;
    }

    protected String getPK3(int index) {
        return "" + index % this.PK_MODULUS;
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected void verify(LongIntStringPK instance, int index, boolean updated) {
        this.errorIfNotEqual("PK1 failed", this.getPK1(index), instance.getLongpk());
        this.errorIfNotEqual("PK2 failed", this.getPK2(index), instance.getIntpk());
        this.errorIfNotEqual("PK3 failed", this.getPK3(index), instance.getStringpk());
        if (updated) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - index), instance.getStringvalue());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(index), instance.getStringvalue());
        }
    }
}

