/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.BitTypes;
import testsuite.clusterj.model.IdBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitTypesTest
extends AbstractClusterJModelTest {
    static int NUMBER_OF_INSTANCES = 10;
    static AbstractClusterJModelTest.ColumnDescriptor bit1 = new AbstractClusterJModelTest.ColumnDescriptor("bit1", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit1((Boolean)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit1();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setBoolean(j, (Boolean)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Byte.parseByte(value) == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit2 = new AbstractClusterJModelTest.ColumnDescriptor("bit2", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit2((Byte)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit2();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setByte(j, (Byte)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Byte.parseByte(value);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit4 = new AbstractClusterJModelTest.ColumnDescriptor("bit4", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit4((Short)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit4();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setShort(j, (Short)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Short.parseShort(value);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit8 = new AbstractClusterJModelTest.ColumnDescriptor("bit8", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit8((Integer)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit8();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setInt(j, (Integer)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Integer.parseInt(value) & 0xFF;
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit16 = new AbstractClusterJModelTest.ColumnDescriptor("bit16", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit16((Long)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit16();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setLong(j, (Long)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Long.parseLong(value);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit32 = new AbstractClusterJModelTest.ColumnDescriptor("bit32", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit32((Integer)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit32();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setInt(j, (Integer)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Integer.parseInt(value);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor bit64 = new AbstractClusterJModelTest.ColumnDescriptor("bit64", new AbstractClusterJModelTest.InstanceHandler(){

        public void setFieldValue(IdBase instance, Object value) {
            ((BitTypes)instance).setBit64((Long)value);
        }

        public Object getFieldValue(IdBase instance) {
            return ((BitTypes)instance).getBit64();
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setLong(j, (Long)value);
        }

        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            String value = rs.getString(j);
            if (value.length() == 0) {
                value = "0";
            }
            return Long.parseLong(value);
        }
    });
    protected static AbstractClusterJModelTest.ColumnDescriptor[] columnDescriptors = new AbstractClusterJModelTest.ColumnDescriptor[]{bit1, bit2, bit4, bit8, bit16, bit32, bit64};

    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    protected int getNumberOfInstances() {
        return NUMBER_OF_INSTANCES;
    }

    @Override
    protected String getTableName() {
        return "bittypes";
    }

    @Override
    Class<? extends IdBase> getModelClass() {
        return BitTypes.class;
    }

    @Override
    protected Object getColumnValue(int i, int j) {
        int length = (int)Math.pow(2.0, j);
        switch (length) {
            case 1: {
                boolean data;
                boolean bl = data = i % 2 == 0;
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + i + ", " + j + " " + columnDescriptors[j].getColumnName() + "  is (boolean)" + data);
                }
                return data;
            }
            case 2: {
                int data = 0;
                for (int d = 0; d < length; ++d) {
                    data = data * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + i + ", " + j + " " + columnDescriptors[j].getColumnName() + "  is (byte)" + data);
                }
                return (byte)data;
            }
            case 4: {
                int data = 0;
                for (int d = 0; d < length; ++d) {
                    data = data * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + i + ", " + j + " " + columnDescriptors[j].getColumnName() + "  is (short)" + data);
                }
                return (short)data;
            }
            case 8: 
            case 32: {
                int data = 0;
                for (int d = 0; d < length; ++d) {
                    data = data * 2 + (int)(Math.random() * 2.0);
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + i + ", " + j + " " + columnDescriptors[j].getColumnName() + "  is (int)" + data);
                }
                data = Math.abs(data);
                return data;
            }
            case 16: 
            case 64: {
                long data = 0L;
                for (int d = 0; d < length / 8; ++d) {
                    data = data * 256L + (long)(i * 16) + (long)d;
                }
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.getColumnValue Column data for " + i + ", " + j + " " + columnDescriptors[j].getColumnName() + "  is (long)" + data);
                }
                return data;
            }
        }
        BitTypesTest.fail((String)("Bad length: " + length));
        return null;
    }

    @Override
    protected void verify(String where, List<Object[]> expecteds, List<Object[]> actuals) {
        for (int i = 0; i < expecteds.size(); ++i) {
            Object[] expected = expecteds.get(i);
            Object[] actual = actuals.get(i);
            this.errorIfNotEqual(where + " got failure on id for row " + i, i, actual[0]);
            block8: for (int j = 1; j < expected.length; ++j) {
                if (this.getDebug()) {
                    System.out.println("BitTypesTest.verify for " + i + ", " + j + " " + columnDescriptors[j - 1].getColumnName() + "  is (" + actual[j].getClass().getName() + ")" + actual[j]);
                }
                switch (j) {
                    case 1: {
                        Boolean expectedColumn = (Boolean)expected[j];
                        Boolean actualColumn = (Boolean)actual[j];
                        this.errorIfNotEqual(where + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), expectedColumn, actualColumn);
                        continue block8;
                    }
                    case 2: {
                        byte expectedColumn = (Byte)expected[j];
                        byte actualColumn = (Byte)actual[j];
                        this.errorIfNotEqual(where + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(expectedColumn), Integer.toHexString(actualColumn));
                        continue block8;
                    }
                    case 3: {
                        short expectedColumn = (Short)expected[j];
                        short actualColumn = (Short)actual[j];
                        this.errorIfNotEqual(where + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(expectedColumn), Integer.toHexString(actualColumn));
                        continue block8;
                    }
                    case 4: 
                    case 6: {
                        int expectedColumn = (Integer)expected[j];
                        int actualColumn = (Integer)actual[j];
                        this.errorIfNotEqual(where + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Integer.toHexString(expectedColumn), Integer.toHexString(actualColumn));
                        continue block8;
                    }
                    case 5: 
                    case 7: {
                        long expectedColumn = (Long)expected[j];
                        long actualColumn = (Long)actual[j];
                        this.errorIfNotEqual(where + " got failure on comparison of data for row " + i + " column " + j + " " + columnDescriptors[j - 1].getColumnName(), Long.toHexString(expectedColumn), Long.toHexString(actualColumn));
                        continue block8;
                    }
                    default: {
                        BitTypesTest.fail((String)("Bad value for j: " + j));
                    }
                }
            }
        }
    }

    public void testWriteJDBCReadNDB() {
        this.writeJDBCreadNDB();
        this.failOnError();
    }

    public void testWriteNDBReadJDBC() {
        this.writeNDBreadJDBC();
        this.failOnError();
    }

    public void testWriteNDBReadNDB() {
        this.writeNDBreadNDB();
        this.failOnError();
    }

    public void testWriteJDBCReadJDBC() {
        this.writeJDBCreadJDBC();
        this.failOnError();
    }

    @Override
    protected AbstractClusterJModelTest.ColumnDescriptor[] getColumnDescriptors() {
        return columnDescriptors;
    }
}

