/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.IdBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryTest
extends AbstractClusterJModelTest {
    protected QueryHolder holder;
    private boolean autotransaction;
    protected Long skip = null;
    protected Long limit = null;
    protected Query.Ordering ordering = null;
    protected String[] orderingFields = null;
    PredicateProvider extraEqualPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraEqual;
        }

        public String toString() {
            return " equal";
        }
    };
    PredicateProvider extraNotEqualPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraEqual.not();
        }

        public String toString() {
            return " not equal";
        }
    };
    PredicateProvider extraBetweenPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraBetween;
        }

        public String toString() {
            return " between";
        }
    };
    PredicateProvider extraInPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraIn;
        }

        public String toString() {
            return " in";
        }
    };
    PredicateProvider extraIsNullPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraIsNull;
        }

        public String toString() {
            return " isNull";
        }
    };
    PredicateProvider extraIsNotNullPredicateProvider = new PredicateProvider(){

        public Predicate getPredicate(QueryHolder holder) {
            return holder.extraIsNotNull;
        }

        public String toString() {
            return " isNotNull";
        }
    };

    abstract void createInstances(int var1);

    @Override
    protected int getNumberOfInstances() {
        return 10;
    }

    abstract Class<?> getInstanceType();

    @Override
    public void localSetUp() {
        this.setAutotransaction(false);
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        int numberOfInstances = this.getNumberOfInstances();
        this.createInstances(numberOfInstances);
        this.session.deletePersistentAll(this.getInstanceType());
        this.session.makePersistentAll((Iterable)this.instances);
        if (this.getCleanupAfterTest()) {
            this.addTearDownClasses(this.getInstanceType());
        }
    }

    protected void setAutotransaction(boolean b) {
        this.autotransaction = b;
    }

    protected void setLimit(long limit) {
        this.skip = null;
        this.limit = limit;
    }

    protected void setLimits(long skip, long limit) {
        this.skip = skip;
        this.limit = limit;
    }

    protected void setOrdering(Query.Ordering ordering, String ... orderingFields) {
        this.ordering = ordering;
        this.orderingFields = orderingFields;
    }

    protected void printResultInstance(IdBase instance) {
    }

    public void noWhereQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " noWhere");
        this.tx.commit();
    }

    public void equalQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.equal);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " equal");
        this.tx.commit();
    }

    public void isNullQuery(String propertyName, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.isNull);
        holder.createQuery(this.session);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " isNull");
        this.tx.commit();
    }

    public void isNotNullQuery(String propertyName, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.isNotNull);
        holder.createQuery(this.session);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " isNotNull");
        this.tx.commit();
    }

    public void likeQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.like);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " like");
        this.tx.commit();
    }

    public void deleteEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int expected) {
        if (!this.autotransaction) {
            this.tx.begin();
        }
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.equal);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.checkDeletePersistentAll(propertyName + " delete equal", expected);
        if (!this.autotransaction) {
            this.tx.commit();
        }
    }

    public void equalOrEqualQuery(String propertyName, Object parameterValue1, String extraPropertyName, Object parameterValue2, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        holder.dobj.where(holder.equalOrEqual);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue1);
        holder.setExtraParameterEqual(parameterValue2);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " equal or equal");
        this.tx.commit();
    }

    public void equalOrInQuery(String propertyName, Object parameterValue1, String extraPropertyName, Object parameterValue2, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        holder.dobj.where(holder.equalOrIn);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue1);
        holder.setExtraParameterIn(parameterValue2);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " equal or in");
        this.tx.commit();
    }

    public void inQuery(String propertyName, Object parameterValue1, String expectedIndex, int ... expected) {
        this.inQuery("", propertyName, parameterValue1, expectedIndex, expected);
    }

    public void inQuery(String extraInfo, String propertyName, Object parameterValue1, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.in);
        holder.createQuery(this.session);
        holder.setParameterIn(parameterValue1);
        holder.setExpectedResultIds(expected);
        holder.checkResults(extraInfo + propertyName + " in");
        this.tx.commit();
    }

    public void inAndInQuery(String propertyName, Object parameterValue1, String extraPropertyName, Object parameterValue2, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        holder.dobj.where(holder.inAndIn);
        holder.createQuery(this.session);
        holder.setParameterIn(parameterValue1);
        holder.setExtraParameterIn(parameterValue2);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " in and " + extraPropertyName + " in");
        this.tx.commit();
    }

    public void inAndBetweenQuery(String propertyName, Object parameterValue1, String extraPropertyName, Object parameterValue2, Object parameterValue3, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        holder.dobj.where(holder.inAndBetween);
        holder.createQuery(this.session);
        holder.setParameterIn(parameterValue1);
        holder.setExtraParameterLower(parameterValue2);
        holder.setExtraParameterUpper(parameterValue3);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " in and " + extraPropertyName + " between");
        this.tx.commit();
    }

    public void betweenAndInQuery(String propertyName, Object parameterValue1, Object parameterValue2, String extraPropertyName, Object parameterValue3, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        holder.dobj.where(holder.betweenAndIn);
        holder.createQuery(this.session);
        holder.setParameterLower(parameterValue1);
        holder.setParameterUpper(parameterValue2);
        holder.setExtraParameterIn(parameterValue3);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " between and " + extraPropertyName + " in");
        this.tx.commit();
    }

    public void greaterThanQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThan);
        holder.createQuery(this.session);
        holder.setParameterLower(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterThan");
        this.tx.commit();
    }

    public void greaterEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqual);
        holder.createQuery(this.session);
        holder.setParameterLower(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterEqual");
        this.tx.commit();
    }

    public void lessThanQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.lessThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessThan");
        this.tx.commit();
    }

    public void lessEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.lessEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessEqual");
        this.tx.commit();
    }

    public void betweenQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.between);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " between");
        this.tx.commit();
    }

    public void greaterThanAndLessThanQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndLessThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessThanAndGreaterThan");
        this.tx.commit();
    }

    public void greaterThanAndLikeQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndLike);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterThanAndLike");
        this.tx.commit();
    }

    public void deleteGreaterThanAndLessThanQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int expected) {
        if (!this.autotransaction) {
            this.tx.begin();
        }
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndLessThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.checkDeletePersistentAll(propertyName + " delete lessThanAndGreaterThan", expected);
        if (!this.autotransaction) {
            this.tx.commit();
        }
    }

    public void greaterEqualAndLessThanQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqualAndLessThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessThanAndGreaterEqual");
        this.tx.commit();
    }

    public void greaterThanAndLessEqualQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndLessEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessEqualAndGreaterThan");
        this.tx.commit();
    }

    public void greaterEqualAndLessEqualQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqualAndLessEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " lessEqualAndGreaterEqual");
        this.tx.commit();
    }

    public void greaterEqualAndLikeQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqualAndLike);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterEqualAndLike");
        this.tx.commit();
    }

    public void equalAnd1ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue, String expectedIndex, int ... expected) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.equal.and(extraPredicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(parameterValue);
        this.holder.setParameterLower(parameterValue);
        this.holder.setParameterUpper(parameterValue);
        this.holder.setExtraParameterEqual(extraParameterValue);
        this.holder.setExtraParameterLower(extraParameterValue);
        this.holder.setExtraParameterUpper(extraParameterValue);
        this.holder.setExpectedResultIds(expected);
        this.holder.checkResults(propertyName + " equal and " + extraPredicate);
        this.tx.commit();
    }

    public void greaterThanAnd1ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue, String expectedIndex, int ... expected) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.greaterThan.and(extraPredicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(parameterValue);
        this.holder.setParameterLower(parameterValue);
        this.holder.setParameterUpper(parameterValue);
        this.holder.setExtraParameterEqual(extraParameterValue);
        this.holder.setExtraParameterLower(extraParameterValue);
        this.holder.setExtraParameterUpper(extraParameterValue);
        this.holder.setExpectedResultIds(expected);
        this.holder.checkResults(propertyName + " greater than and " + extraPropertyName + extraPredicateProvider.toString());
        this.tx.commit();
    }

    public void greaterEqualAnd1ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue, String expectedIndex, int ... expected) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.greaterEqual.and(extraPredicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(parameterValue);
        this.holder.setParameterLower(parameterValue);
        this.holder.setParameterUpper(parameterValue);
        this.holder.setExtraParameterEqual(extraParameterValue);
        this.holder.setExtraParameterLower(extraParameterValue);
        this.holder.setExtraParameterUpper(extraParameterValue);
        this.holder.setExpectedResultIds(expected);
        this.holder.checkResults(propertyName + " greater equal and " + extraPropertyName + extraPredicateProvider.toString());
        this.tx.commit();
    }

    public void lessThanAnd1ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue, String expectedIndex, int ... expected) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.lessThan.and(extraPredicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(parameterValue);
        this.holder.setParameterLower(parameterValue);
        this.holder.setParameterUpper(parameterValue);
        this.holder.setExtraParameterEqual(extraParameterValue);
        this.holder.setExtraParameterLower(extraParameterValue);
        this.holder.setExtraParameterUpper(extraParameterValue);
        this.holder.setExpectedResultIds(expected);
        this.holder.checkResults(propertyName + " less than and " + extraPropertyName + extraPredicateProvider.toString());
        this.tx.commit();
    }

    public void lessEqualAnd1ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue, String expectedIndex, int ... expected) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.lessEqual.and(extraPredicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(parameterValue);
        this.holder.setParameterLower(parameterValue);
        this.holder.setParameterUpper(parameterValue);
        this.holder.setExtraParameterEqual(extraParameterValue);
        this.holder.setExtraParameterLower(extraParameterValue);
        this.holder.setExtraParameterUpper(extraParameterValue);
        this.holder.setExpectedResultIds(expected);
        this.holder.checkResults(propertyName + " less equal and " + extraPropertyName + extraPredicateProvider.toString());
        this.tx.commit();
    }

    public void equalAnd2ExtraQuery(String propertyName, Object parameterValue, String extraPropertyName, PredicateProvider extraPredicateProvider, Object extraParameterValue1, Object extraParameterValue2, String expectedIndex, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex, extraPropertyName);
        Predicate extraPredicate = extraPredicateProvider.getPredicate(holder);
        holder.dobj.where(holder.equal.and(extraPredicate));
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setParameterLower(parameterValue);
        holder.setParameterUpper(parameterValue);
        holder.setExtraParameterEqual(extraParameterValue1);
        holder.setExtraParameterLower(extraParameterValue1);
        holder.setExtraParameterUpper(extraParameterValue2);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " equal and " + extraPredicate);
        this.tx.commit();
    }

    public void notEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notEqual);
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not equal");
        this.tx.commit();
    }

    public void notNotEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notEqual.not());
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not not equal");
        this.tx.commit();
    }

    public void notNotNotEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.dobj.not(holder.notEqual.not()));
        holder.createQuery(this.session);
        holder.setParameterEqual(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not not not equal");
        this.tx.commit();
    }

    public void notGreaterThanQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notGreaterThan);
        holder.createQuery(this.session);
        holder.setParameterLower(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not greaterThan");
        this.tx.commit();
    }

    public void notGreaterEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notGreaterEqual);
        holder.createQuery(this.session);
        holder.setParameterLower(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not greaterEqual");
        this.tx.commit();
    }

    public void notLessThanQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notLessThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not lessThan");
        this.tx.commit();
    }

    public void notLessEqualQuery(String propertyName, String expectedIndex, Object parameterValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notLessEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not lessEqual");
        this.tx.commit();
    }

    public void notBetweenQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.notBetween);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " not between");
        this.tx.commit();
    }

    public void greaterThanAndNotGreaterThanQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndNotGreaterThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterThanAndNotGreaterThan");
        this.tx.commit();
    }

    public void greaterEqualAndNotGreaterThanQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqualAndNotGreaterThan);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterEqualAndNotGreaterThan");
        this.tx.commit();
    }

    public void greaterThanAndNotGreaterEqualQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterThanAndNotGreaterEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterThanAndNotGreaterEqual");
        this.tx.commit();
    }

    public void greaterEqualAndNotGreaterEqualQuery(String propertyName, String expectedIndex, Object parameterLowerValue, Object parameterUpperValue, int ... expected) {
        this.tx.begin();
        QueryHolder holder = new QueryHolder(this.getInstanceType(), propertyName, expectedIndex);
        holder.dobj.where(holder.greaterEqualAndNotGreaterEqual);
        holder.createQuery(this.session);
        holder.setParameterUpper(parameterUpperValue);
        holder.setParameterLower(parameterLowerValue);
        holder.setExpectedResultIds(expected);
        holder.checkResults(propertyName + " greaterEqualAndNotGreaterEqual");
        this.tx.commit();
    }

    public static interface PredicateProvider {
        public Predicate getPredicate(QueryHolder var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryHolder {
        public QueryBuilder builder;
        public QueryDomainType<?> dobj;
        public String propertyName;
        public String extraPropertyName;
        public PredicateOperand propertyPredicate;
        public PredicateOperand paramEqualPredicate;
        public PredicateOperand paramLowerPredicate;
        public PredicateOperand paramUpperPredicate;
        public PredicateOperand paramInPredicate;
        public Predicate equal;
        public Predicate isNull;
        public Predicate isNotNull;
        public Predicate equalOrEqual;
        public Predicate greaterThan;
        public Predicate greaterEqual;
        public Predicate in;
        public Predicate lessThan;
        public Predicate lessEqual;
        public Predicate between;
        public Predicate greaterThanAndLessThan;
        public Predicate greaterEqualAndLessThan;
        public Predicate greaterThanAndLessEqual;
        public Predicate greaterThanAndLike;
        public Predicate greaterEqualAndLessEqual;
        public Predicate greaterEqualAndLike;
        public Predicate notEqual;
        public Predicate notGreaterThan;
        public Predicate notGreaterEqual;
        public Predicate notLessThan;
        public Predicate notLessEqual;
        public Predicate notBetween;
        public Predicate like;
        public Predicate greaterThanAndNotGreaterThan;
        public Predicate greaterEqualAndNotGreaterThan;
        public Predicate greaterThanAndNotGreaterEqual;
        public Predicate greaterEqualAndNotGreaterEqual;
        public PredicateOperand extraParamEqualPredicate;
        public PredicateOperand extraParamLowerPredicate;
        public PredicateOperand extraParamUpperPredicate;
        public PredicateOperand extraParamInPredicate;
        public PredicateOperand extraProperty;
        public Predicate extraEqual;
        public Predicate extraIsNull;
        public Predicate extraIsNotNull;
        public Predicate extraGreaterThan;
        public Predicate extraGreaterEqual;
        public Predicate extraLessThan;
        public Predicate extraLessEqual;
        public Predicate extraBetween;
        public Predicate extraGreaterThanAndLessThan;
        public Predicate extraGreaterEqualAndLessThan;
        public Predicate extraGreaterThanAndLessEqual;
        public Predicate extraGreaterEqualAndLessEqual;
        public Query<?> query;
        public Set<Integer> expectedSet = new HashSet<Integer>();
        public List<Integer> expectedList = new ArrayList<Integer>();
        public String expectedIndex;
        private Predicate equalOrIn;
        private Predicate extraIn;
        private Predicate inAndIn;
        private Predicate inAndBetween;
        private Predicate betweenAndIn;

        public QueryHolder(Class<?> type, String propertyName, String expectedIndex) {
            this.propertyName = propertyName;
            this.builder = AbstractQueryTest.this.session.getQueryBuilder();
            this.dobj = this.builder.createQueryDefinition(type);
            this.expectedIndex = expectedIndex;
            this.paramEqualPredicate = this.dobj.param("equal");
            this.paramLowerPredicate = this.dobj.param("lower");
            this.paramUpperPredicate = this.dobj.param("upper");
            this.paramInPredicate = this.dobj.param("in");
            this.propertyPredicate = this.dobj.get(propertyName);
            this.equal = this.propertyPredicate.equal(this.paramEqualPredicate);
            this.isNull = this.propertyPredicate.isNull();
            this.isNotNull = this.propertyPredicate.isNotNull();
            this.greaterThan = this.propertyPredicate.greaterThan(this.paramLowerPredicate);
            this.greaterEqual = this.propertyPredicate.greaterEqual(this.paramLowerPredicate);
            this.lessThan = this.propertyPredicate.lessThan(this.paramUpperPredicate);
            this.lessEqual = this.propertyPredicate.lessEqual(this.paramUpperPredicate);
            this.between = this.propertyPredicate.between(this.paramLowerPredicate, this.paramUpperPredicate);
            this.greaterThanAndLessThan = this.lessThan.and(this.greaterThan);
            this.greaterEqualAndLessThan = this.lessThan.and(this.greaterEqual);
            this.greaterThanAndLessEqual = this.lessEqual.and(this.greaterThan);
            this.greaterEqualAndLessEqual = this.lessEqual.and(this.greaterEqual);
            this.in = this.propertyPredicate.in(this.paramInPredicate);
            this.notEqual = this.equal.not();
            this.notGreaterThan = this.greaterThan.not();
            this.notGreaterEqual = this.greaterEqual.not();
            this.notLessThan = this.lessThan.not();
            this.notLessEqual = this.lessEqual.not();
            this.notBetween = this.between.not();
            this.like = this.propertyPredicate.like(this.paramEqualPredicate);
            this.greaterThanAndNotGreaterThan = this.greaterThan.and(this.propertyPredicate.greaterThan(this.paramUpperPredicate).not());
            this.greaterEqualAndNotGreaterThan = this.greaterEqual.and(this.propertyPredicate.greaterThan(this.paramUpperPredicate).not());
            this.greaterThanAndNotGreaterEqual = this.greaterThan.and(this.propertyPredicate.greaterEqual(this.paramUpperPredicate).not());
            this.greaterEqualAndNotGreaterEqual = this.greaterEqual.and(this.propertyPredicate.greaterEqual(this.paramUpperPredicate).not());
            this.greaterThanAndLike = this.greaterThan.and(this.propertyPredicate.like(this.paramUpperPredicate));
            this.greaterEqualAndLike = this.greaterEqual.and(this.propertyPredicate.like(this.paramUpperPredicate));
        }

        public QueryHolder(Class<?> type, String propertyName, String expectedIndex, String extraPropertyName) {
            this(type, propertyName, expectedIndex);
            this.extraPropertyName = extraPropertyName;
            this.extraParamEqualPredicate = this.dobj.param("extraEqual");
            this.extraParamLowerPredicate = this.dobj.param("extraLower");
            this.extraParamUpperPredicate = this.dobj.param("extraUpper");
            this.extraParamInPredicate = this.dobj.param("extraIn");
            this.extraProperty = this.dobj.get(extraPropertyName);
            this.extraEqual = this.extraProperty.equal(this.extraParamEqualPredicate);
            this.extraIsNull = this.extraProperty.isNull();
            this.extraIsNotNull = this.extraProperty.isNotNull();
            this.extraGreaterThan = this.extraProperty.greaterThan(this.extraParamLowerPredicate);
            this.extraGreaterEqual = this.extraProperty.greaterEqual(this.extraParamLowerPredicate);
            this.extraLessThan = this.extraProperty.lessThan(this.extraParamUpperPredicate);
            this.extraLessEqual = this.extraProperty.lessEqual(this.extraParamUpperPredicate);
            this.extraBetween = this.extraProperty.between(this.extraParamLowerPredicate, this.extraParamUpperPredicate);
            this.extraGreaterThanAndLessThan = this.extraLessThan.and(this.extraGreaterThan);
            this.extraGreaterEqualAndLessThan = this.extraLessThan.and(this.extraGreaterEqual);
            this.extraGreaterThanAndLessEqual = this.extraLessEqual.and(this.extraGreaterThan);
            this.extraGreaterEqualAndLessEqual = this.extraLessEqual.and(this.extraGreaterEqual);
            this.equalOrEqual = this.equal.or(this.extraEqual);
            this.extraIn = this.extraProperty.in(this.extraParamInPredicate);
            this.equalOrIn = this.equal.or(this.extraIn);
            this.inAndIn = this.in.and(this.extraIn);
            this.inAndBetween = this.in.and(this.extraBetween);
            this.betweenAndIn = this.between.and(this.extraIn);
        }

        public void createQuery(Session session) {
            this.query = session.createQuery(this.dobj);
        }

        public void setParameterEqual(Object parameter) {
            this.query.setParameter("equal", parameter);
        }

        public void setParameterLower(Object parameter) {
            this.query.setParameter("lower", parameter);
        }

        public void setParameterUpper(Object parameter) {
            this.query.setParameter("upper", parameter);
        }

        public void setParameterIn(Object parameter) {
            this.query.setParameter("in", parameter);
        }

        public void setExpectedResultIds(int ... expecteds) {
            for (int expected : expecteds) {
                this.expectedSet.add(expected);
                this.expectedList.add(expected);
            }
        }

        public void setExtraParameterEqual(Object parameter) {
            this.query.setParameter("extraEqual", parameter);
        }

        public void setExtraParameterLower(Object parameter) {
            this.query.setParameter("extraLower", parameter);
        }

        public void setExtraParameterUpper(Object parameter) {
            this.query.setParameter("extraUpper", parameter);
        }

        public void setExtraParameterIn(Object parameter) {
            this.query.setParameter("extraIn", parameter);
        }

        public void checkResults(String theQuery) {
            if (AbstractQueryTest.this.limit != null) {
                if (AbstractQueryTest.this.skip != null) {
                    this.query.setLimits(AbstractQueryTest.this.skip.longValue(), AbstractQueryTest.this.limit.longValue());
                } else {
                    this.query.setLimits(0L, AbstractQueryTest.this.limit.longValue());
                }
            }
            if (AbstractQueryTest.this.ordering != null) {
                this.query.setOrdering(AbstractQueryTest.this.ordering, AbstractQueryTest.this.orderingFields);
            }
            HashSet<Integer> actualSet = new HashSet<Integer>();
            ArrayList<Integer> actualList = new ArrayList<Integer>();
            List resultList = this.query.getResultList();
            for (IdBase result : resultList) {
                AbstractQueryTest.this.printResultInstance(result);
                actualSet.add(result.getId());
                actualList.add(result.getId());
            }
            AbstractQueryTest.this.errorIfNotEqual("Wrong index used for " + theQuery + " query: ", this.expectedIndex, this.query.explain().get("IndexUsed"));
            if (AbstractQueryTest.this.ordering != null) {
                AbstractQueryTest.this.errorIfNotEqual("Wrong ids returned from ordered " + AbstractQueryTest.this.ordering + " " + theQuery + " query: ", this.expectedList, actualList);
            } else {
                AbstractQueryTest.this.errorIfNotEqual("Wrong ids returned from " + theQuery + " query: ", this.expectedSet, actualSet);
            }
        }

        public void checkDeletePersistentAll(String where, int expectedNumberOfDeletedInstances) {
            if (AbstractQueryTest.this.limit != null) {
                if (AbstractQueryTest.this.skip != null) {
                    this.query.setLimits(AbstractQueryTest.this.skip.longValue(), AbstractQueryTest.this.limit.longValue());
                } else {
                    this.query.setLimits(0L, AbstractQueryTest.this.limit.longValue());
                }
            }
            int result = this.query.deletePersistentAll();
            AbstractQueryTest.this.errorIfNotEqual("Wrong index used for " + where + " delete  query: ", this.expectedIndex, this.query.explain().get("IndexUsed"));
            AbstractQueryTest.this.errorIfNotEqual("Wrong number of instances deleted for " + where, expectedNumberOfDeletedInstances, result);
        }
    }
}

