/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

class ScanFilterImpl
implements ScanFilter {
    static final I18NHelper local = I18NHelper.getInstance(ScanFilterImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ScanFilterImpl.class);
    private NdbScanFilter ndbScanFilter;

    public ScanFilterImpl(NdbScanFilter ndbScanFilter) {
        this.ndbScanFilter = ndbScanFilter;
    }

    public void begin() {
        int returnCode = this.ndbScanFilter.begin(1);
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void begin(ScanFilter.Group group) {
        int returnCode = this.ndbScanFilter.begin(this.convertGroup(group));
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpBigInteger(ScanFilter.BinaryCondition condition, Column storeColumn, BigInteger value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpBoolean(ScanFilter.BinaryCondition condition, Column storeColumn, boolean value) {
        byte byteValue = value ? (byte)1 : 0;
        this.cmpByte(condition, storeColumn, byteValue);
    }

    public void cmpByte(ScanFilter.BinaryCondition condition, Column storeColumn, byte value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpBytes(ScanFilter.BinaryCondition condition, Column storeColumn, byte[] value) {
        ByteBuffer buffer = condition == ScanFilter.BinaryCondition.COND_LIKE ? Utility.convertValueForLikeFilter(storeColumn, value) : Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpDecimal(ScanFilter.BinaryCondition condition, Column storeColumn, BigDecimal value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpDouble(ScanFilter.BinaryCondition condition, Column storeColumn, double value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpFloat(ScanFilter.BinaryCondition condition, Column storeColumn, float value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpShort(ScanFilter.BinaryCondition condition, Column storeColumn, short value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpInt(ScanFilter.BinaryCondition condition, Column storeColumn, int value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpLong(ScanFilter.BinaryCondition condition, Column storeColumn, long value) {
        ByteBuffer buffer = Utility.convertValue(storeColumn, value);
        if (logger.isDetailEnabled()) {
            int bufferLength = buffer.limit() - buffer.position();
            byte[] array = new byte[bufferLength];
            buffer.get(array);
            buffer.flip();
            logger.detail("column: " + storeColumn.getName() + " condition: " + condition.toString() + " value: " + value + Arrays.toString(array) + "(" + buffer.capacity() + ")");
        }
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.capacity());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void cmpString(ScanFilter.BinaryCondition condition, Column storeColumn, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug(storeColumn.getName() + " " + (Object)((Object)condition) + " " + value);
        }
        ByteBuffer buffer = condition == ScanFilter.BinaryCondition.COND_LIKE ? Utility.convertValueForLikeFilter(storeColumn, value) : Utility.convertValue(storeColumn, value);
        int returnCode = this.ndbScanFilter.cmp(this.convertCondition(condition), storeColumn.getColumnId(), buffer, buffer.limit());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void isNull(Column storeColumn) {
        int returnCode = this.ndbScanFilter.isnull(storeColumn.getColumnId());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void isNotNull(Column storeColumn) {
        int returnCode = this.ndbScanFilter.isnotnull(storeColumn.getColumnId());
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    public void end() {
        int returnCode = this.ndbScanFilter.end();
        ScanFilterImpl.handleError(returnCode, this.ndbScanFilter);
    }

    private int convertCondition(ScanFilter.BinaryCondition condition) {
        switch (condition) {
            case COND_EQ: {
                return 4;
            }
            case COND_LE: {
                return 0;
            }
            case COND_LT: {
                return 1;
            }
            case COND_GE: {
                return 2;
            }
            case COND_GT: {
                return 3;
            }
            case COND_LIKE: {
                return 6;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    private int convertGroup(ScanFilter.Group group) {
        switch (group) {
            case GROUP_AND: {
                return 1;
            }
            case GROUP_NAND: {
                return 3;
            }
            case GROUP_OR: {
                return 2;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected static void handleError(int returnCode, NdbScanFilter ndbScanFilter) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbScanFilter.getNdbError());
    }

    protected static void handleError(Object object, NdbScanFilter ndbScanFilter) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbScanFilter.getNdbError());
    }

    public void delete() {
        NdbScanFilter.delete(this.ndbScanFilter);
    }
}

