/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.Dbug;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.ndbjtie.mysql.Utils;
import java.nio.ByteBuffer;

public class DbugImpl
implements Dbug {
    static final I18NHelper local = I18NHelper.getInstance(DbugImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbugImpl.class);
    private static final int DBUG_SIZE = 256;
    boolean propertyTrace = false;
    String fileName = "";
    Character fileStrategy = Character.valueOf('o');
    String debugList;

    public DbugImpl() {
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
    }

    public String get() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        String result = Utils.dbugExplain(buffer, 256);
        return result;
    }

    public void pop() {
        Utils.dbugPop();
    }

    public void push(String state) {
        Utils.dbugPush(state);
    }

    public void set(String state) {
        Utils.dbugSet(state);
    }

    public void set() {
        this.set(this.toState());
    }

    public void push() {
        this.push(this.toState());
    }

    public void print(String keyword, String message) {
        Utils.dbugPrint(keyword, message);
    }

    public Dbug trace(boolean trace) {
        this.propertyTrace = trace;
        return this;
    }

    public Dbug trace() {
        return this.trace(true);
    }

    public Dbug output(String fileName) {
        this.fileName = fileName;
        this.fileStrategy = Character.valueOf('o');
        return this;
    }

    public Dbug append(String fileName) {
        this.fileName = fileName;
        this.fileStrategy = Character.valueOf('a');
        return this;
    }

    public Dbug flush() {
        this.fileStrategy = Character.valueOf(Character.toUpperCase(this.fileStrategy.charValue()));
        return this;
    }

    public Dbug debug(String debugList) {
        this.debugList = debugList;
        return this;
    }

    public Dbug debug(String[] debugList) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (String debug : debugList) {
            builder.append(sep);
            builder.append(debug);
            sep = ",";
        }
        this.debugList = builder.toString();
        return this;
    }

    private String toState() {
        String separator = "";
        StringBuilder builder = new StringBuilder();
        if (this.propertyTrace) {
            builder.append("t");
            separator = ":";
        }
        if (this.fileName != null) {
            builder.append(separator);
            builder.append(this.fileStrategy);
            builder.append(',');
            builder.append(this.fileName);
            separator = ":";
        }
        if (this.debugList != null) {
            builder.append(separator);
            builder.append("d,");
            builder.append(this.debugList);
            separator = ":";
        }
        return builder.toString();
    }
}

