/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class Driver {
    protected static final PrintWriter out = new PrintWriter(System.out, true);
    protected static final PrintWriter err = new PrintWriter(System.err, true);
    protected static final String endl = System.getProperty("line.separator");
    private static final Runtime rt = Runtime.getRuntime();
    private static final List<String> propFileNames = new ArrayList<String>();
    private static String logFileName = "log_" + new SimpleDateFormat("yyyyMMdd_HHMMss").format(new Date()) + ".txt";
    private PrintWriter log;
    protected final Properties props = new Properties();
    protected String descr = "";
    protected boolean logRealTime = false;
    protected boolean logMemUsage = false;
    protected boolean includeFullGC = false;
    protected boolean logSumOfOps = false;
    protected boolean renewOperations = false;
    protected boolean renewConnection = false;
    protected boolean allowExtendedPC = false;
    protected int aStart = 256;
    protected int aEnd = 4096;
    protected int aIncr = 4;
    protected int bStart = 256;
    protected int bEnd = 4096;
    protected int bIncr = 4;
    protected int maxStringLength = 100;
    protected int warmupRuns = 0;
    protected int hotRuns = 0;
    protected final Set<String> exclude = new HashSet<String>();
    protected final List<Op> ops = new ArrayList<Op>();
    boolean logHeader;
    private StringBuilder header;
    private StringBuilder rtimes;
    private StringBuilder musage;
    private long t0 = 0L;
    private long t1 = 0L;
    private long ta = 0L;
    private long m0 = 0L;
    private long m1 = 0L;
    private long ma = 0L;

    protected abstract void initConnection() throws Exception;

    protected abstract void closeConnection() throws Exception;

    protected abstract void initOperations() throws Exception;

    protected abstract void closeOperations() throws Exception;

    protected abstract void clearPersistenceContext() throws Exception;

    protected abstract void clearData() throws Exception;

    protected abstract void beginTransaction() throws Exception;

    protected abstract void commitTransaction() throws Exception;

    protected abstract void rollbackTransaction() throws Exception;

    protected static final void verify(boolean cond) {
        if (!cond) {
            throw new RuntimeException("wrong data; verification failed");
        }
    }

    protected static void loadSystemLibrary(String name) {
        out.print("loading libary ...");
        out.flush();
        try {
            System.loadLibrary(name);
        }
        catch (UnsatisfiedLinkError e) {
            String path;
            try {
                path = System.getProperty("java.library.path");
            }
            catch (Exception ex) {
                path = "<exception caught: " + ex.getMessage() + ">";
            }
            err.println("NdbBase: failed loading library '" + name + "'; java.library.path='" + path + "'");
            throw e;
        }
        catch (SecurityException e) {
            err.println("NdbBase: failed loading library '" + name + "'; caught exception: " + e);
            throw e;
        }
        out.println("          [" + name + "]");
    }

    public void run() {
        try {
            int i;
            this.init();
            for (i = 0; i < this.warmupRuns; ++i) {
                this.runTests();
            }
            out.println();
            out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            out.println("start logging results ...");
            out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            out.println();
            this.header = new StringBuilder();
            this.rtimes = new StringBuilder();
            this.musage = new StringBuilder();
            this.closeLogFile();
            this.openLogFile();
            for (i = 0; i < this.hotRuns; ++i) {
                this.runTests();
            }
            if (this.logRealTime) {
                this.log.println(this.descr + ", rtime[ms]" + this.header.toString() + endl + this.rtimes.toString() + endl + endl + endl);
            }
            if (this.logMemUsage) {
                this.log.println(this.descr + ", net musage[KiB]" + this.header.toString() + endl + this.musage.toString() + endl + endl + endl);
            }
            this.close();
        }
        catch (Exception ex) {
            out.println("caught " + ex);
            ex.printStackTrace();
            System.exit(2);
        }
    }

    protected void init() throws Exception {
        this.loadProperties();
        this.initProperties();
        this.printProperties();
        this.openLogFile();
        this.logHeader = true;
        this.header = new StringBuilder();
        this.rtimes = new StringBuilder();
        this.musage = new StringBuilder();
    }

    protected void close() throws Exception {
        this.header = null;
        this.rtimes = null;
        this.musage = null;
        this.closeLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        if (propFileNames.size() == 0) {
            propFileNames.add("crund.properties");
        }
        out.println();
        for (String fn : propFileNames) {
            out.println("reading properties file:    " + fn);
            FileInputStream is = null;
            try {
                is = new FileInputStream(fn);
                this.props.load(is);
            }
            catch (Exception e) {
                out.println("error reading file.");
            }
            finally {
                if (is == null) continue;
                ((InputStream)is).close();
            }
        }
    }

    protected boolean parseBoolean(String k) {
        return Boolean.parseBoolean(this.props.getProperty(k));
    }

    protected int parseInt(String k, int vdefault) {
        String v = this.props.getProperty(k);
        try {
            return v == null ? vdefault : Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("invalid value of benchmark property ('" + k + "', '" + v + "').");
            nfe.initCause(e);
            throw nfe;
        }
    }

    protected void initProperties() {
        this.logRealTime = this.parseBoolean("logRealTime");
        this.logMemUsage = this.parseBoolean("logMemUsage");
        this.includeFullGC = this.parseBoolean("includeFullGC");
        this.logSumOfOps = this.parseBoolean("logSumOfOps");
        this.renewOperations = this.parseBoolean("renewOperations");
        this.renewConnection = this.parseBoolean("renewConnection");
        this.allowExtendedPC = this.parseBoolean("allowExtendedPC");
        this.aStart = this.parseInt("aStart", 256);
        this.aEnd = this.parseInt("aEnd", 4096);
        this.aIncr = this.parseInt("aIncr", 4);
        this.bStart = this.parseInt("bStart", 256);
        this.bEnd = this.parseInt("bEnd", 4096);
        this.bIncr = this.parseInt("bIncr", 4);
        this.maxStringLength = this.parseInt("maxStringLength", 100);
        this.warmupRuns = this.parseInt("warmupRuns", 0);
        this.hotRuns = this.parseInt("hotRuns", 1);
        String[] e = this.props.getProperty("exclude", "").split(",");
        for (int i = 0; i < e.length; ++i) {
            this.exclude.add(e[i]);
        }
    }

    protected void printProperties() {
        out.println();
        out.println("main settings:");
        out.println("logRealTime:                " + this.logRealTime);
        out.println("logMemUsage:                " + this.logMemUsage);
        out.println("includeFullGC:              " + this.includeFullGC);
        out.println("logSumOfOps:                " + this.logSumOfOps);
        out.println("renewOperations:            " + this.renewOperations);
        out.println("renewConnection:            " + this.renewConnection);
        out.println("allowExtendedPC:            " + this.allowExtendedPC);
        out.println("aStart:                     " + this.aStart);
        out.println("aEnd:                       " + this.aEnd);
        out.println("aIncr:                      " + this.aIncr);
        out.println("bStart:                     " + this.bStart);
        out.println("bEnd:                       " + this.bEnd);
        out.println("bIncr:                      " + this.bIncr);
        out.println("maxStringLength:            " + this.maxStringLength);
        out.println("warmupRuns:                 " + this.warmupRuns);
        out.println("hotRuns:                    " + this.hotRuns);
        out.println("exclude:                    " + this.exclude);
    }

    private void openLogFile() throws IOException {
        out.println();
        out.println("writing results to file:    " + logFileName);
        this.log = new PrintWriter(new FileWriter(logFileName, false));
    }

    private void closeLogFile() throws IOException {
        out.print("closing files ...    ");
        out.flush();
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        out.println("       [ok]");
    }

    protected void runTests() throws Exception {
        this.initConnection();
        this.initOperations();
        for (int i = this.aStart; i <= this.aEnd; i *= this.aIncr) {
            int j;
            int n = j = i > this.bStart ? i : this.bStart;
            while (j <= this.bEnd) {
                this.runOperations(i, j);
                j *= this.bIncr;
            }
        }
        out.println();
        out.println("------------------------------------------------------------");
        out.println();
        this.clearData();
        this.closeOperations();
        this.closeConnection();
    }

    protected void runOperations(int countA, int countB) throws Exception {
        out.println();
        out.println("------------------------------------------------------------");
        out.println("countA = " + countA + ", countB = " + countB);
        out.println();
        if (this.logRealTime) {
            this.rtimes.append("A=" + countA + ", B=" + countB);
            this.ta = 0L;
        }
        if (this.logMemUsage) {
            this.musage.append("A=" + countA + ", B=" + countB);
            this.ma = 0L;
        }
        if (this.renewConnection) {
            this.closeOperations();
            this.closeConnection();
            this.initConnection();
            this.initOperations();
        } else if (this.renewOperations) {
            this.closeOperations();
            this.initOperations();
        }
        this.clearData();
        for (Op op : this.ops) {
            if (!this.allowExtendedPC) {
                this.clearPersistenceContext();
            }
            this.runOp(op, countA, countB);
        }
        if (this.logHeader && this.logSumOfOps) {
            this.header.append("\ttotal");
        }
        this.logHeader = false;
        if (this.logRealTime) {
            if (this.logSumOfOps) {
                this.rtimes.append("\t" + this.ta);
                out.println();
                out.println("total");
                out.println("tx real time      = " + this.ta + "\tms [begin..commit]");
            }
            this.rtimes.append(endl);
        }
        if (this.logMemUsage) {
            if (this.logSumOfOps) {
                this.musage.append("\t" + this.ma);
                out.println();
                out.println("total");
                out.println("net mem usage     = " + (this.ma >= 0L ? "+" : "") + this.ma + "\tKiB");
            }
            this.musage.append(endl);
        }
    }

    protected void runOp(Op op, int countA, int countB) throws Exception {
        String name = op.getName();
        if (!this.exclude.contains(name)) {
            this.begin(name);
            op.run(countA, countB);
            this.commit(name);
        }
    }

    protected void begin(String name) throws Exception {
        out.println();
        out.println(name);
        Driver.gc();
        if (this.logMemUsage) {
            this.m0 = rt.totalMemory() - rt.freeMemory();
        }
        if (this.logRealTime) {
            this.t0 = System.nanoTime() / 1000000L;
        }
        this.beginTransaction();
    }

    protected void commit(String name) throws Exception {
        this.commitTransaction();
        if (this.includeFullGC) {
            rt.gc();
        }
        if (this.logRealTime) {
            this.t1 = System.nanoTime() / 1000000L;
            long t = this.t1 - this.t0;
            out.println("tx real time      = " + t + "\tms [begin..commit]");
            this.rtimes.append("\t" + t);
            this.ta += t;
        }
        if (this.logMemUsage) {
            Driver.gc();
            this.m1 = rt.totalMemory() - rt.freeMemory();
            long m0K = this.m0 / 1024L;
            long m1K = this.m1 / 1024L;
            long mK = m1K - m0K;
            out.println("net mem usage     = " + (mK >= 0L ? "+" : "") + mK + "\tKiB [" + m0K + "K->" + m1K + "K]");
            this.musage.append("\t" + mK);
            this.ma += mK;
        }
        if (this.logHeader) {
            this.header.append("\t" + name);
        }
    }

    private static void gc() {
        int nFullGCs = 10;
        for (int i = 0; i < 10; ++i) {
            long oldfree;
            long newfree = rt.freeMemory();
            do {
                oldfree = newfree;
                rt.runFinalization();
                rt.gc();
            } while ((newfree = rt.freeMemory()) > oldfree);
        }
    }

    private static void exitUsage() {
        out.println("usage: [options]");
        out.println("    [-p <file name>]...    a properties file name");
        out.println("    [-l <file name>]       log file name for data output");
        out.println("    [-h|--help]            print usage message and exit");
        out.println();
        System.exit(1);
    }

    public static void parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-p")) {
                if (i >= args.length) {
                    Driver.exitUsage();
                }
                propFileNames.add(args[++i]);
                continue;
            }
            if (arg.equals("-l")) {
                if (i >= args.length) {
                    Driver.exitUsage();
                }
                logFileName = args[++i];
                continue;
            }
            if (arg.equals("-h") || arg.equals("--help")) {
                Driver.exitUsage();
                continue;
            }
            out.println("unknown option: " + arg);
            Driver.exitUsage();
        }
    }

    public static void clearPropFileNames() {
        propFileNames.clear();
    }

    protected abstract class Op {
        protected final String name;

        public Op(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract void run(int var1, int var2) throws Exception;
    }
}

