/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.IndexImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;

class DictionaryImpl
implements Dictionary {
    static final I18NHelper local = I18NHelper.getInstance(DictionaryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DictionaryImpl.class);
    private NdbDictionary.Dictionary ndbDictionary;
    private ClusterConnectionImpl clusterConnection;

    public DictionaryImpl(NdbDictionary.Dictionary ndbDictionary, ClusterConnectionImpl clusterConnection) {
        this.ndbDictionary = ndbDictionary;
        this.clusterConnection = clusterConnection;
    }

    public Table getTable(String tableName) {
        NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(tableName);
        if (ndbTable == null) {
            ndbTable = this.ndbDictionary.getTable(tableName.toLowerCase());
        }
        if (ndbTable == null) {
            return null;
        }
        return new TableImpl(ndbTable, this.getIndexNames(ndbTable.getName()));
    }

    public Index getIndex(String indexName, String tableName, String indexAlias) {
        if ("PRIMARY$KEY".equals(indexName)) {
            NdbDictionary.TableConst ndbTable = this.ndbDictionary.getTable(tableName);
            if (ndbTable == null) {
                ndbTable = this.ndbDictionary.getTable(tableName.toLowerCase());
            }
            DictionaryImpl.handleError(ndbTable, (NdbDictionary.DictionaryConst)this.ndbDictionary, "");
            return new IndexImpl(ndbTable);
        }
        NdbDictionary.IndexConst ndbIndex = this.ndbDictionary.getIndex(indexName, tableName);
        if (ndbIndex == null) {
            ndbIndex = this.ndbDictionary.getIndex(indexName, tableName.toLowerCase());
        }
        DictionaryImpl.handleError(ndbIndex, (NdbDictionary.DictionaryConst)this.ndbDictionary, indexAlias);
        return new IndexImpl(ndbIndex, indexAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexNames(String tableName) {
        String[] result;
        NdbDictionary.DictionaryConst.List indexList = NdbDictionary.DictionaryConst.List.create();
        try {
            int returnCode = this.ndbDictionary.listIndexes(indexList, tableName);
            DictionaryImpl.handleError(returnCode, (NdbDictionary.DictionaryConst)this.ndbDictionary, tableName);
            int count = indexList.count();
            result = new String[count];
            if (logger.isDetailEnabled()) {
                logger.detail("Found " + count + " indexes for " + tableName);
            }
            NdbDictionary.DictionaryConst.ListConst.ElementArray elementArray = indexList.elements();
            for (int i = 0; i < count; ++i) {
                String indexName;
                NdbDictionary.DictionaryConst.ListConst.Element element = elementArray.at(i);
                DictionaryImpl.handleError(element, (NdbDictionary.DictionaryConst)this.ndbDictionary, String.valueOf(i));
                result[i] = indexName = element.name();
            }
        }
        finally {
            NdbDictionary.DictionaryConst.List.delete(indexList);
        }
        return result;
    }

    protected static void handleError(int returnCode, NdbDictionary.DictionaryConst ndbDictionary, String extra) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbDictionary.getNdbError(), extra);
    }

    protected static void handleError(Object object, NdbDictionary.DictionaryConst ndbDictionary, String extra) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbDictionary.getNdbError(), extra);
    }

    public void removeCachedTable(String tableName) {
        this.ndbDictionary.removeCachedTable(tableName);
        this.clusterConnection.unloadSchema(tableName);
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }
}

