/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandlerBatching;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDomainTypeImpl<T>
implements QueryDomainType<T> {
    static final I18NHelper local = I18NHelper.getInstance(QueryDomainTypeImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(QueryDomainTypeImpl.class);
    protected Class<T> cls;
    protected DomainTypeHandler<T> domainTypeHandler;
    protected PredicateImpl where;
    protected Map<String, ParameterImpl> parameters = new HashMap<String, ParameterImpl>();
    protected Map<String, PropertyImpl> properties = new HashMap<String, PropertyImpl>();
    CandidateIndexImpl index = null;
    String[] orderingFields = null;
    Query.Ordering ordering = null;
    private ResultData resultDataEmpty = new ResultData(){

        public boolean next() {
            return false;
        }

        public BigInteger getBigInteger(Column columnName) {
            return null;
        }

        public BigInteger getBigInteger(int columnNumber) {
            return null;
        }

        public Blob getBlob(Column storeColumn) {
            return null;
        }

        public Blob getBlob(int columnNumber) {
            return null;
        }

        public boolean getBoolean(Column storeColumn) {
            return false;
        }

        public boolean getBoolean(int columnNumber) {
            return false;
        }

        public boolean[] getBooleans(Column storeColumn) {
            return null;
        }

        public boolean[] getBooleans(int columnNumber) {
            return null;
        }

        public byte getByte(Column storeColumn) {
            return 0;
        }

        public byte getByte(int columnNumber) {
            return 0;
        }

        public byte[] getBytes(Column storeColumn) {
            return null;
        }

        public byte[] getBytes(int columnNumber) {
            return null;
        }

        public Column[] getColumns() {
            return null;
        }

        public BigDecimal getDecimal(Column storeColumn) {
            return null;
        }

        public BigDecimal getDecimal(int columnNumber) {
            return null;
        }

        public double getDouble(Column storeColumn) {
            return 0.0;
        }

        public double getDouble(int columnNumber) {
            return 0.0;
        }

        public float getFloat(Column storeColumn) {
            return 0.0f;
        }

        public float getFloat(int columnNumber) {
            return 0.0f;
        }

        public int getInt(Column storeColumn) {
            return 0;
        }

        public int getInt(int columnNumber) {
            return 0;
        }

        public long getLong(Column storeColumn) {
            return 0L;
        }

        public long getLong(int columnNumber) {
            return 0L;
        }

        public Object getObject(Column storeColumn) {
            return null;
        }

        public Object getObject(int column) {
            return null;
        }

        public Boolean getObjectBoolean(Column storeColumn) {
            return null;
        }

        public Boolean getObjectBoolean(int columnNumber) {
            return null;
        }

        public Byte getObjectByte(Column storeColumn) {
            return null;
        }

        public Byte getObjectByte(int columnNumber) {
            return null;
        }

        public Double getObjectDouble(Column storeColumn) {
            return null;
        }

        public Double getObjectDouble(int columnNumber) {
            return null;
        }

        public Float getObjectFloat(Column storeColumn) {
            return null;
        }

        public Float getObjectFloat(int columnNumber) {
            return null;
        }

        public Integer getObjectInteger(Column storeColumn) {
            return null;
        }

        public Integer getObjectInteger(int columnNumber) {
            return null;
        }

        public Long getObjectLong(Column storeColumn) {
            return null;
        }

        public Long getObjectLong(int columnNumber) {
            return null;
        }

        public Short getObjectShort(Column storeColumn) {
            return null;
        }

        public Short getObjectShort(int columnNumber) {
            return null;
        }

        public short getShort(Column storeColumn) {
            return 0;
        }

        public short getShort(int columnNumber) {
            return 0;
        }

        public String getString(Column storeColumn) {
            return null;
        }

        public String getString(int columnNumber) {
            return null;
        }
    };

    public QueryDomainTypeImpl(DomainTypeHandler<T> domainTypeHandler, Class<T> cls) {
        this.cls = cls;
        this.domainTypeHandler = domainTypeHandler;
    }

    public QueryDomainTypeImpl(DomainTypeHandler<T> domainTypeHandler) {
        this.domainTypeHandler = domainTypeHandler;
    }

    @Override
    public PredicateOperand get(String propertyName) {
        PropertyImpl property = this.properties.get(propertyName);
        if (property != null) {
            return property;
        }
        DomainFieldHandler fmd = this.domainTypeHandler.getFieldHandler(propertyName);
        property = new PropertyImpl(this, fmd);
        this.properties.put(propertyName, property);
        return property;
    }

    @Override
    public QueryDefinition<T> where(Predicate predicate) {
        if (predicate == null) {
            throw new ClusterJUserException(local.message("ERR_Query_Where_Must_Not_Be_Null"));
        }
        if (!(predicate instanceof PredicateImpl)) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }
        if (this.where != null) {
            this.where.unmarkParameters();
            this.where = null;
        }
        this.where = (PredicateImpl)predicate;
        this.where.markParameters();
        this.where.prepare();
        return this;
    }

    @Override
    public PredicateOperand param(String parameterName) {
        ParameterImpl parameter = this.parameters.get(parameterName);
        if (parameter != null) {
            return parameter;
        }
        ParameterImpl result = new ParameterImpl(this, parameterName);
        this.parameters.put(parameterName, result);
        return result;
    }

    @Override
    public Predicate not(Predicate predicate) {
        return predicate.not();
    }

    public List<T> getResultList(QueryExecutionContext context, long skip, long limit, Query.Ordering ordering, String[] orderingFields) {
        this.assertAllParametersBound(context);
        SessionSPI session = context.getSession();
        session.startAutoTransaction();
        ArrayList<T> resultList = new ArrayList<T>();
        try {
            ResultData resultData = this.getResultData(context, skip, limit, ordering, orderingFields);
            while (resultData.next()) {
                T row = session.newInstance(resultData, this.domainTypeHandler);
                resultList.add(row);
            }
            session.endAutoTransaction();
            return resultList;
        }
        catch (ClusterJException ex) {
            session.failAutoTransaction();
            throw ex;
        }
        catch (Exception ex) {
            session.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), ex);
        }
    }

    public ResultData getResultData(QueryExecutionContext context, long skip, long limit, Query.Ordering ordering, String[] orderingFields) {
        SessionSPI session = context.getSession();
        this.ordering = ordering;
        this.orderingFields = orderingFields;
        this.index = this.getCandidateIndex(context);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        if (logger.isDebugEnabled()) {
            logger.debug("using index " + this.index.getIndexName() + " with scanType " + (Object)((Object)scanType));
        }
        Map<String, Object> explain = this.newExplain(this.index, scanType);
        context.setExplain(explain);
        ResultData result = null;
        Operation op = null;
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    if (skip > 0L || limit < 1L) {
                        return this.resultDataEmpty;
                    }
                    op = session.getSelectOperation(this.domainTypeHandler.getStoreTable());
                    op.beginDefinition();
                    this.index.operationSetKeys(context, op);
                    this.domainTypeHandler.operationGetValues(op);
                    op.endDefinition();
                    result = op.resultData();
                    break;
                }
                case INDEX_SCAN: {
                    Index storeIndex = this.index.getStoreIndex();
                    op = this.index.isMultiRange() ? session.getIndexScanOperationMultiRange(storeIndex, this.domainTypeHandler.getStoreTable()) : session.getIndexScanOperation(storeIndex, this.domainTypeHandler.getStoreTable());
                    op.beginDefinition();
                    if (ordering == null && (skip != 0L || limit != Long.MAX_VALUE)) {
                        ordering = Query.Ordering.ASCENDING;
                    }
                    ((ScanOperation)op).setOrdering(ordering);
                    this.domainTypeHandler.operationGetValues(op);
                    this.index.operationSetBounds(context, (IndexScanOperation)op);
                    if (this.where != null) {
                        this.where.filterCmpValue(context, (IndexScanOperation)op);
                    }
                    op.endDefinition();
                    result = ((ScanOperation)op).resultData(true, skip, limit);
                    break;
                }
                case TABLE_SCAN: {
                    if (ordering != null) {
                        throw new ClusterJUserException(local.message("ERR_Cannot_Use_Ordering_With_Table_Scan"));
                    }
                    op = session.getTableScanOperation(this.domainTypeHandler.getStoreTable());
                    op.beginDefinition();
                    this.domainTypeHandler.operationGetValues(op);
                    if (this.where != null) {
                        this.where.filterCmpValue(context, (ScanOperation)op);
                    }
                    op.endDefinition();
                    result = ((ScanOperation)op).resultData(true, skip, limit);
                    break;
                }
                case UNIQUE_KEY: {
                    if (skip > 0L || limit < 1L) {
                        return this.resultDataEmpty;
                    }
                    Index storeIndex = this.index.getStoreIndex();
                    op = session.getUniqueIndexOperation(storeIndex, this.domainTypeHandler.getStoreTable());
                    op.beginDefinition();
                    this.where.operationEqual(context, op);
                    this.domainTypeHandler.operationGetValues(op);
                    op.endDefinition();
                    result = op.resultData();
                    break;
                }
                default: {
                    session.failAutoTransaction();
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
        }
        catch (ClusterJException ex) {
            if (op != null) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw ex;
        }
        catch (Exception ex) {
            if (op != null) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), ex);
        }
        return result;
    }

    public int deletePersistentAll(QueryExecutionContext context) {
        SessionSPI session = context.getSession();
        this.index = this.getCandidateIndex(context);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        Map<String, Object> explain = this.newExplain(this.index, scanType);
        context.setExplain(explain);
        int result = 0;
        int errorCode = 0;
        session.startAutoTransaction();
        Operation op = null;
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by primary key.");
                    }
                    op = session.getDeleteOperation(this.domainTypeHandler.getStoreTable());
                    op.beginDefinition();
                    this.index.operationSetKeys(context, op);
                    op.endDefinition();
                    session.executeNoCommit(false, true);
                    errorCode = op.errorCode();
                    result = errorCode == 0 ? 1 : 0;
                    break;
                }
                case UNIQUE_KEY: {
                    Index storeIndex = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by unique key  " + this.index.getIndexName());
                    }
                    op = session.getUniqueIndexDeleteOperation(storeIndex, this.domainTypeHandler.getStoreTable());
                    this.where.operationEqual(context, op);
                    session.executeNoCommit(false, true);
                    errorCode = op.errorCode();
                    result = errorCode == 0 ? 1 : 0;
                    break;
                }
                case INDEX_SCAN: {
                    Index storeIndex = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by index scan with index " + this.index.getIndexName());
                    }
                    op = session.getIndexScanDeleteOperation(storeIndex, this.domainTypeHandler.getStoreTable());
                    this.domainTypeHandler.operationGetValues(op);
                    this.index.operationSetBounds(context, (IndexScanOperation)op);
                    this.where.filterCmpValue(context, (IndexScanOperation)op);
                    result = session.deletePersistentAll((IndexScanOperation)op, false);
                    break;
                }
                case TABLE_SCAN: {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by table scan");
                    }
                    op = session.getTableScanDeleteOperation(this.domainTypeHandler.getStoreTable());
                    this.domainTypeHandler.operationGetValues(op);
                    if (this.where != null) {
                        this.where.filterCmpValue(context, (ScanOperation)op);
                    }
                    result = session.deletePersistentAll((ScanOperation)op, false);
                    break;
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
            session.endAutoTransaction();
            return result;
        }
        catch (ClusterJException e) {
            if (op != null) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw e;
        }
        catch (Exception e) {
            if (op != null) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), e);
        }
    }

    public long[] updatePersistentAll(QueryExecutionContext context, ValueHandlerBatching valueHandler) {
        SessionSPI session = context.getSession();
        this.index = this.getCandidateIndex(context);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        Map<String, Object> explain = this.newExplain(this.index, scanType);
        context.setExplain(explain);
        long[] result = null;
        ArrayList<Operation> ops = new ArrayList<Operation>();
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    result = new long[valueHandler.getNumberOfStatements()];
                    session.startAutoTransaction();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Update by primary key.");
                    }
                    while (valueHandler.next()) {
                        Operation op = session.getUpdateOperation(this.domainTypeHandler.getStoreTable());
                        this.index.operationSetKeys(context, op);
                        this.domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, op);
                        ops.add(op);
                    }
                    session.endAutoTransaction();
                    if (session.currentTransaction().isActive()) {
                        session.executeNoCommit(false, true);
                    }
                    for (int i = 0; i < result.length; ++i) {
                        int errorCode = ((Operation)ops.get(i)).errorCode();
                        result[i] = errorCode == 0 ? 1 : 0;
                    }
                    break;
                }
                case UNIQUE_KEY: {
                    result = new long[valueHandler.getNumberOfStatements()];
                    session.startAutoTransaction();
                    Index storeIndex = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Update by unique key.");
                    }
                    while (valueHandler.next()) {
                        IndexOperation op = session.getUniqueIndexUpdateOperation(storeIndex, this.domainTypeHandler.getStoreTable());
                        this.index.operationSetKeys(context, op);
                        this.domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, op);
                        ops.add(op);
                    }
                    session.endAutoTransaction();
                    if (session.currentTransaction().isActive()) {
                        session.executeNoCommit(false, true);
                    }
                    for (int i = 0; i < result.length; ++i) {
                        int errorCode = ((Operation)ops.get(i)).errorCode();
                        result[i] = errorCode == 0 ? 1 : 0;
                    }
                    break;
                }
                case INDEX_SCAN: {
                    break;
                }
                case TABLE_SCAN: {
                    break;
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
            return result;
        }
        catch (ClusterJException e) {
            for (Operation op : ops) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw e;
        }
        catch (Exception e) {
            for (Operation op : ops) {
                op.freeResourcesAfterExecute();
            }
            session.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), e);
        }
    }

    protected CandidateIndexImpl[] createCandidateIndexes() {
        return this.domainTypeHandler.createCandidateIndexes();
    }

    public void explain(QueryExecutionContext context) {
        this.assertAllParametersBound(context);
        CandidateIndexImpl index = this.getCandidateIndex(context);
        PredicateImpl.ScanType scanType = index.getScanType();
        Map<String, Object> explain = this.newExplain(index, scanType);
        context.setExplain(explain);
    }

    private CandidateIndexImpl getCandidateIndex(QueryExecutionContext context) {
        if (this.where == null) {
            CandidateIndexImpl[] candidateIndexImpls;
            for (CandidateIndexImpl candidateIndexImpl : candidateIndexImpls = this.domainTypeHandler.createCandidateIndexes()) {
                if (!candidateIndexImpl.containsAllOrderingFields(this.orderingFields)) continue;
                this.index = candidateIndexImpl;
                return this.index;
            }
            this.index = CandidateIndexImpl.getIndexForNullWhereClause();
        } else {
            this.index = this.where.getBestCandidateIndex(context, this.orderingFields);
        }
        return this.index;
    }

    protected Map<String, Object> newExplain(CandidateIndexImpl index, PredicateImpl.ScanType scanType) {
        HashMap<String, Object> explain = new HashMap<String, Object>();
        explain.put("ScanType", scanType.toString());
        explain.put("IndexUsed", index.getIndexName());
        return explain;
    }

    protected void assertAllParametersBound(QueryExecutionContext context) {
        if (this.where != null) {
            for (ParameterImpl param : this.parameters.values()) {
                if (!param.isMarkedAndUnbound(context)) continue;
                throw new ClusterJUserException(local.message("ERR_Parameter_Not_Bound", (Object)param.getName()));
            }
        }
    }

    @Override
    public Class<T> getType() {
        return this.cls;
    }
}

