/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CHAIN_SYM = 309,
     CHANGE = 310,
     CHANGED = 311,
     CHARSET = 312,
     CHAR_SYM = 313,
     CHECKSUM_SYM = 314,
     CHECK_SYM = 315,
     CIPHER_SYM = 316,
     CLIENT_SYM = 317,
     CLOSE_SYM = 318,
     COALESCE = 319,
     CODE_SYM = 320,
     COLLATE_SYM = 321,
     COLLATION_SYM = 322,
     COLUMNS = 323,
     COLUMN_SYM = 324,
     COMMENT_SYM = 325,
     COMMITTED_SYM = 326,
     COMMIT_SYM = 327,
     COMPACT_SYM = 328,
     COMPLETION_SYM = 329,
     COMPRESSED_SYM = 330,
     CONCURRENT = 331,
     CONDITION_SYM = 332,
     CONNECTION_SYM = 333,
     CONSISTENT_SYM = 334,
     CONSTRAINT = 335,
     CONTAINS_SYM = 336,
     CONTEXT_SYM = 337,
     CONTINUE_SYM = 338,
     CONTRIBUTORS_SYM = 339,
     CONVERT_SYM = 340,
     COUNT_SYM = 341,
     CPU_SYM = 342,
     CREATE = 343,
     CROSS = 344,
     CUBE_SYM = 345,
     CURDATE = 346,
     CURRENT_USER = 347,
     CURSOR_SYM = 348,
     CURTIME = 349,
     DATABASE = 350,
     DATABASES = 351,
     DATAFILE_SYM = 352,
     DATA_SYM = 353,
     DATETIME = 354,
     DATE_ADD_INTERVAL = 355,
     DATE_SUB_INTERVAL = 356,
     DATE_SYM = 357,
     DAY_HOUR_SYM = 358,
     DAY_MICROSECOND_SYM = 359,
     DAY_MINUTE_SYM = 360,
     DAY_SECOND_SYM = 361,
     DAY_SYM = 362,
     DEALLOCATE_SYM = 363,
     DECIMAL_NUM = 364,
     DECIMAL_SYM = 365,
     DECLARE_SYM = 366,
     DEFAULT = 367,
     DEFINER_SYM = 368,
     DELAYED_SYM = 369,
     DELAY_KEY_WRITE_SYM = 370,
     DELETE_SYM = 371,
     DESC = 372,
     DESCRIBE = 373,
     DES_KEY_FILE = 374,
     DETERMINISTIC_SYM = 375,
     DIRECTORY_SYM = 376,
     DISABLE_SYM = 377,
     DISCARD = 378,
     DISK_SYM = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSE = 390,
     ELSEIF_SYM = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     END = 394,
     ENDS_SYM = 395,
     END_OF_INPUT = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EVENT_SYM = 406,
     EVERY_SYM = 407,
     EXECUTE_SYM = 408,
     EXISTS = 409,
     EXIT_SYM = 410,
     EXPANSION_SYM = 411,
     EXTENDED_SYM = 412,
     EXTENT_SIZE_SYM = 413,
     EXTRACT_SYM = 414,
     FALSE_SYM = 415,
     FAST_SYM = 416,
     FAULTS_SYM = 417,
     FETCH_SYM = 418,
     COLUMN_FORMAT_SYM = 419,
     FILE_SYM = 420,
     FIRST_SYM = 421,
     FIXED_SYM = 422,
     FLOAT_NUM = 423,
     FLOAT_SYM = 424,
     FLUSH_SYM = 425,
     FORCE_SYM = 426,
     FOREIGN = 427,
     FOR_SYM = 428,
     FOUND_SYM = 429,
     FRAC_SECOND_SYM = 430,
     FROM = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     GE = 435,
     GEOMETRYCOLLECTION = 436,
     GEOMETRY_SYM = 437,
     GET_FORMAT = 438,
     GLOBAL_SYM = 439,
     GRANT = 440,
     GRANTS = 441,
     GROUP_SYM = 442,
     GROUP_CONCAT_SYM = 443,
     GT_SYM = 444,
     HANDLER_SYM = 445,
     HASH_SYM = 446,
     HAVING = 447,
     HELP_SYM = 448,
     HEX_NUM = 449,
     HIGH_PRIORITY = 450,
     HOST_SYM = 451,
     HOSTS_SYM = 452,
     HOUR_MICROSECOND_SYM = 453,
     HOUR_MINUTE_SYM = 454,
     HOUR_SECOND_SYM = 455,
     HOUR_SYM = 456,
     IDENT = 457,
     IDENTIFIED_SYM = 458,
     IDENT_QUOTED = 459,
     IF = 460,
     IGNORE_SYM = 461,
     IMPORT = 462,
     INDEXES = 463,
     INDEX_SYM = 464,
     INFILE = 465,
     INITIAL_SIZE_SYM = 466,
     INNER_SYM = 467,
     INNOBASE_SYM = 468,
     INOUT_SYM = 469,
     INSENSITIVE_SYM = 470,
     INSERT = 471,
     INSERT_METHOD = 472,
     INSTALL_SYM = 473,
     INTERVAL_SYM = 474,
     INTO = 475,
     INT_SYM = 476,
     INVOKER_SYM = 477,
     IN_SYM = 478,
     IO_SYM = 479,
     IPC_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_BLOCK_SIZE = 487,
     KEY_SYM = 488,
     KILL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_SYM = 491,
     LE = 492,
     LEADING = 493,
     LEAVES = 494,
     LEAVE_SYM = 495,
     LEFT = 496,
     LESS_SYM = 497,
     LEVEL_SYM = 498,
     LEX_HOSTNAME = 499,
     LIKE = 500,
     LIMIT = 501,
     LINEAR_SYM = 502,
     LINES = 503,
     LINESTRING = 504,
     LIST_SYM = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATOR_SYM = 508,
     LOCKS_SYM = 509,
     LOCK_SYM = 510,
     LOGFILE_SYM = 511,
     LOGS_SYM = 512,
     LONGBLOB = 513,
     LONGTEXT = 514,
     LONG_NUM = 515,
     LONG_SYM = 516,
     LOOP_SYM = 517,
     LOW_PRIORITY = 518,
     LT = 519,
     MASTER_CONNECT_RETRY_SYM = 520,
     MASTER_HOST_SYM = 521,
     MASTER_LOG_FILE_SYM = 522,
     MASTER_LOG_POS_SYM = 523,
     MASTER_PASSWORD_SYM = 524,
     MASTER_PORT_SYM = 525,
     MASTER_SERVER_ID_SYM = 526,
     MASTER_SSL_CAPATH_SYM = 527,
     MASTER_SSL_CA_SYM = 528,
     MASTER_SSL_CERT_SYM = 529,
     MASTER_SSL_CIPHER_SYM = 530,
     MASTER_SSL_KEY_SYM = 531,
     MASTER_SSL_SYM = 532,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 533,
     MASTER_SYM = 534,
     MASTER_USER_SYM = 535,
     MATCH = 536,
     MAX_CONNECTIONS_PER_HOUR = 537,
     MAX_QUERIES_PER_HOUR = 538,
     MAX_ROWS = 539,
     MAX_SIZE_SYM = 540,
     MAX_SYM = 541,
     MAX_UPDATES_PER_HOUR = 542,
     MAX_USER_CONNECTIONS_SYM = 543,
     MAX_VALUE_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MEMORY_SYM = 549,
     MERGE_SYM = 550,
     MICROSECOND_SYM = 551,
     MIGRATE_SYM = 552,
     MINUTE_MICROSECOND_SYM = 553,
     MINUTE_SECOND_SYM = 554,
     MINUTE_SYM = 555,
     MIN_ROWS = 556,
     MIN_SYM = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MULTILINESTRING = 563,
     MULTIPOINT = 564,
     MULTIPOLYGON = 565,
     MUTEX_SYM = 566,
     NAMES_SYM = 567,
     NAME_SYM = 568,
     NATIONAL_SYM = 569,
     NATURAL = 570,
     NCHAR_STRING = 571,
     NCHAR_SYM = 572,
     NDBCLUSTER_SYM = 573,
     NE = 574,
     NEG = 575,
     NEW_SYM = 576,
     NEXT_SYM = 577,
     NODEGROUP_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WAIT_SYM = 584,
     NO_WRITE_TO_BINLOG = 585,
     NULL_SYM = 586,
     NUM = 587,
     NUMERIC_SYM = 588,
     NVARCHAR_SYM = 589,
     OFFLINE_SYM = 590,
     OFFSET_SYM = 591,
     OLD_PASSWORD = 592,
     ON = 593,
     ONE_SHOT_SYM = 594,
     ONE_SYM = 595,
     ONLINE_SYM = 596,
     OPEN_SYM = 597,
     OPTIMIZE = 598,
     OPTIONS_SYM = 599,
     OPTION = 600,
     OPTIONALLY = 601,
     OR2_SYM = 602,
     ORDER_SYM = 603,
     OR_OR_SYM = 604,
     OR_SYM = 605,
     OUTER = 606,
     OUTFILE = 607,
     OUT_SYM = 608,
     OWNER_SYM = 609,
     PACK_KEYS_SYM = 610,
     PAGE_SYM = 611,
     PARAM_MARKER = 612,
     PARSER_SYM = 613,
     PARTIAL = 614,
     PARTITIONING_SYM = 615,
     PARTITIONS_SYM = 616,
     PARTITION_SYM = 617,
     PASSWORD = 618,
     PHASE_SYM = 619,
     PLUGINS_SYM = 620,
     PLUGIN_SYM = 621,
     POINT_SYM = 622,
     POLYGON = 623,
     PORT_SYM = 624,
     POSITION_SYM = 625,
     PRECISION = 626,
     PREPARE_SYM = 627,
     PRESERVE_SYM = 628,
     PREV_SYM = 629,
     PRIMARY_SYM = 630,
     PRIVILEGES = 631,
     PROCEDURE = 632,
     PROCESS = 633,
     PROCESSLIST_SYM = 634,
     PROFILE_SYM = 635,
     PROFILES_SYM = 636,
     PURGE = 637,
     QUARTER_SYM = 638,
     QUERY_SYM = 639,
     QUICK = 640,
     RANGE_SYM = 641,
     READS_SYM = 642,
     READ_ONLY_SYM = 643,
     READ_SYM = 644,
     READ_WRITE_SYM = 645,
     REAL = 646,
     REBUILD_SYM = 647,
     RECOVER_SYM = 648,
     REDOFILE_SYM = 649,
     REDO_BUFFER_SIZE_SYM = 650,
     REDUNDANT_SYM = 651,
     REFERENCES = 652,
     REGEXP = 653,
     RELAY_LOG_FILE_SYM = 654,
     RELAY_LOG_POS_SYM = 655,
     RELAY_THREAD = 656,
     RELEASE_SYM = 657,
     RELOAD = 658,
     REMOVE_SYM = 659,
     RENAME = 660,
     REORGANIZE_SYM = 661,
     REPAIR = 662,
     REPEATABLE_SYM = 663,
     REPEAT_SYM = 664,
     REPLACE = 665,
     REPLICATION = 666,
     REQUIRE_SYM = 667,
     RESET_SYM = 668,
     RESOURCES = 669,
     RESTORE_SYM = 670,
     RESTRICT = 671,
     RESUME_SYM = 672,
     RETURNS_SYM = 673,
     RETURN_SYM = 674,
     REVOKE = 675,
     RIGHT = 676,
     ROLLBACK_SYM = 677,
     ROLLUP_SYM = 678,
     ROUTINE_SYM = 679,
     ROWS_SYM = 680,
     ROW_FORMAT_SYM = 681,
     ROW_SYM = 682,
     RTREE_SYM = 683,
     SAVEPOINT_SYM = 684,
     SCHEDULE_SYM = 685,
     SECOND_MICROSECOND_SYM = 686,
     SECOND_SYM = 687,
     SECURITY_SYM = 688,
     SELECT_SYM = 689,
     SENSITIVE_SYM = 690,
     SEPARATOR_SYM = 691,
     SERIALIZABLE_SYM = 692,
     SERIAL_SYM = 693,
     SESSION_SYM = 694,
     SERVER_SYM = 695,
     SERVER_OPTIONS = 696,
     SET = 697,
     SET_VAR = 698,
     SHARE_SYM = 699,
     SHIFT_LEFT = 700,
     SHIFT_RIGHT = 701,
     SHOW = 702,
     SHUTDOWN = 703,
     SIGNED_SYM = 704,
     SIMPLE_SYM = 705,
     SLAVE = 706,
     SMALLINT = 707,
     SNAPSHOT_SYM = 708,
     SOCKET_SYM = 709,
     SONAME_SYM = 710,
     SOUNDS_SYM = 711,
     SOURCE_SYM = 712,
     SPATIAL_SYM = 713,
     SPECIFIC_SYM = 714,
     SQLEXCEPTION_SYM = 715,
     SQLSTATE_SYM = 716,
     SQLWARNING_SYM = 717,
     SQL_BIG_RESULT = 718,
     SQL_BUFFER_RESULT = 719,
     SQL_CACHE_SYM = 720,
     SQL_CALC_FOUND_ROWS = 721,
     SQL_NO_CACHE_SYM = 722,
     SQL_SMALL_RESULT = 723,
     SQL_SYM = 724,
     SQL_THREAD = 725,
     SSL_SYM = 726,
     STARTING = 727,
     STARTS_SYM = 728,
     START_SYM = 729,
     STATUS_SYM = 730,
     STDDEV_SAMP_SYM = 731,
     STD_SYM = 732,
     STOP_SYM = 733,
     STORAGE_SYM = 734,
     STRAIGHT_JOIN = 735,
     STRING_SYM = 736,
     SUBDATE_SYM = 737,
     SUBJECT_SYM = 738,
     SUBPARTITIONS_SYM = 739,
     SUBPARTITION_SYM = 740,
     SUBSTRING = 741,
     SUM_SYM = 742,
     SUPER_SYM = 743,
     SUSPEND_SYM = 744,
     SWAPS_SYM = 745,
     SWITCHES_SYM = 746,
     SYSDATE = 747,
     TABLES = 748,
     TABLESPACE = 749,
     TABLE_REF_PRIORITY = 750,
     TABLE_SYM = 751,
     TEMPORARY = 752,
     TEMPTABLE_SYM = 753,
     TERMINATED = 754,
     TEXT_STRING = 755,
     TEXT_SYM = 756,
     THAN_SYM = 757,
     THEN_SYM = 758,
     TIMESTAMP = 759,
     TIMESTAMP_ADD = 760,
     TIMESTAMP_DIFF = 761,
     TIME_SYM = 762,
     TINYBLOB = 763,
     TINYINT = 764,
     TINYTEXT = 765,
     TO_SYM = 766,
     TRAILING = 767,
     TRANSACTION_SYM = 768,
     TRANSACTIONAL_SYM = 769,
     TRIGGERS_SYM = 770,
     TRIGGER_SYM = 771,
     TRIM = 772,
     TRUE_SYM = 773,
     TRUNCATE_SYM = 774,
     TYPES_SYM = 775,
     TYPE_SYM = 776,
     UDF_RETURNS_SYM = 777,
     ULONGLONG_NUM = 778,
     UNCOMMITTED_SYM = 779,
     UNDEFINED_SYM = 780,
     UNDERSCORE_CHARSET = 781,
     UNDOFILE_SYM = 782,
     UNDO_BUFFER_SIZE_SYM = 783,
     UNDO_SYM = 784,
     UNICODE_SYM = 785,
     UNINSTALL_SYM = 786,
     UNION_SYM = 787,
     UNIQUE_SYM = 788,
     UNKNOWN_SYM = 789,
     UNLOCK_SYM = 790,
     UNSIGNED = 791,
     UNTIL_SYM = 792,
     UPDATE_SYM = 793,
     UPGRADE_SYM = 794,
     USAGE = 795,
     USER = 796,
     USE_FRM = 797,
     USE_SYM = 798,
     USING = 799,
     UTC_DATE_SYM = 800,
     UTC_TIMESTAMP_SYM = 801,
     UTC_TIME_SYM = 802,
     VALUES = 803,
     VALUE_SYM = 804,
     VARBINARY = 805,
     VARCHAR = 806,
     VARIABLES = 807,
     VARIANCE_SYM = 808,
     VARYING = 809,
     VAR_SAMP_SYM = 810,
     VIEW_SYM = 811,
     WAIT_SYM = 812,
     WARNINGS = 813,
     WEEK_SYM = 814,
     WHEN_SYM = 815,
     WHERE = 816,
     WHILE_SYM = 817,
     WITH = 818,
     WORK_SYM = 819,
     WRAPPER_SYM = 820,
     WRITE_SYM = 821,
     X509_SYM = 822,
     XA_SYM = 823,
     XOR = 824,
     YEAR_MONTH_SYM = 825,
     YEAR_SYM = 826,
     ZEROFILL = 827
   };
#endif
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CHAIN_SYM 309
#define CHANGE 310
#define CHANGED 311
#define CHARSET 312
#define CHAR_SYM 313
#define CHECKSUM_SYM 314
#define CHECK_SYM 315
#define CIPHER_SYM 316
#define CLIENT_SYM 317
#define CLOSE_SYM 318
#define COALESCE 319
#define CODE_SYM 320
#define COLLATE_SYM 321
#define COLLATION_SYM 322
#define COLUMNS 323
#define COLUMN_SYM 324
#define COMMENT_SYM 325
#define COMMITTED_SYM 326
#define COMMIT_SYM 327
#define COMPACT_SYM 328
#define COMPLETION_SYM 329
#define COMPRESSED_SYM 330
#define CONCURRENT 331
#define CONDITION_SYM 332
#define CONNECTION_SYM 333
#define CONSISTENT_SYM 334
#define CONSTRAINT 335
#define CONTAINS_SYM 336
#define CONTEXT_SYM 337
#define CONTINUE_SYM 338
#define CONTRIBUTORS_SYM 339
#define CONVERT_SYM 340
#define COUNT_SYM 341
#define CPU_SYM 342
#define CREATE 343
#define CROSS 344
#define CUBE_SYM 345
#define CURDATE 346
#define CURRENT_USER 347
#define CURSOR_SYM 348
#define CURTIME 349
#define DATABASE 350
#define DATABASES 351
#define DATAFILE_SYM 352
#define DATA_SYM 353
#define DATETIME 354
#define DATE_ADD_INTERVAL 355
#define DATE_SUB_INTERVAL 356
#define DATE_SYM 357
#define DAY_HOUR_SYM 358
#define DAY_MICROSECOND_SYM 359
#define DAY_MINUTE_SYM 360
#define DAY_SECOND_SYM 361
#define DAY_SYM 362
#define DEALLOCATE_SYM 363
#define DECIMAL_NUM 364
#define DECIMAL_SYM 365
#define DECLARE_SYM 366
#define DEFAULT 367
#define DEFINER_SYM 368
#define DELAYED_SYM 369
#define DELAY_KEY_WRITE_SYM 370
#define DELETE_SYM 371
#define DESC 372
#define DESCRIBE 373
#define DES_KEY_FILE 374
#define DETERMINISTIC_SYM 375
#define DIRECTORY_SYM 376
#define DISABLE_SYM 377
#define DISCARD 378
#define DISK_SYM 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSE 390
#define ELSEIF_SYM 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define END 394
#define ENDS_SYM 395
#define END_OF_INPUT 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EVENT_SYM 406
#define EVERY_SYM 407
#define EXECUTE_SYM 408
#define EXISTS 409
#define EXIT_SYM 410
#define EXPANSION_SYM 411
#define EXTENDED_SYM 412
#define EXTENT_SIZE_SYM 413
#define EXTRACT_SYM 414
#define FALSE_SYM 415
#define FAST_SYM 416
#define FAULTS_SYM 417
#define FETCH_SYM 418
#define COLUMN_FORMAT_SYM 419
#define FILE_SYM 420
#define FIRST_SYM 421
#define FIXED_SYM 422
#define FLOAT_NUM 423
#define FLOAT_SYM 424
#define FLUSH_SYM 425
#define FORCE_SYM 426
#define FOREIGN 427
#define FOR_SYM 428
#define FOUND_SYM 429
#define FRAC_SECOND_SYM 430
#define FROM 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define GE 435
#define GEOMETRYCOLLECTION 436
#define GEOMETRY_SYM 437
#define GET_FORMAT 438
#define GLOBAL_SYM 439
#define GRANT 440
#define GRANTS 441
#define GROUP_SYM 442
#define GROUP_CONCAT_SYM 443
#define GT_SYM 444
#define HANDLER_SYM 445
#define HASH_SYM 446
#define HAVING 447
#define HELP_SYM 448
#define HEX_NUM 449
#define HIGH_PRIORITY 450
#define HOST_SYM 451
#define HOSTS_SYM 452
#define HOUR_MICROSECOND_SYM 453
#define HOUR_MINUTE_SYM 454
#define HOUR_SECOND_SYM 455
#define HOUR_SYM 456
#define IDENT 457
#define IDENTIFIED_SYM 458
#define IDENT_QUOTED 459
#define IF 460
#define IGNORE_SYM 461
#define IMPORT 462
#define INDEXES 463
#define INDEX_SYM 464
#define INFILE 465
#define INITIAL_SIZE_SYM 466
#define INNER_SYM 467
#define INNOBASE_SYM 468
#define INOUT_SYM 469
#define INSENSITIVE_SYM 470
#define INSERT 471
#define INSERT_METHOD 472
#define INSTALL_SYM 473
#define INTERVAL_SYM 474
#define INTO 475
#define INT_SYM 476
#define INVOKER_SYM 477
#define IN_SYM 478
#define IO_SYM 479
#define IPC_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_BLOCK_SIZE 487
#define KEY_SYM 488
#define KILL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_SYM 491
#define LE 492
#define LEADING 493
#define LEAVES 494
#define LEAVE_SYM 495
#define LEFT 496
#define LESS_SYM 497
#define LEVEL_SYM 498
#define LEX_HOSTNAME 499
#define LIKE 500
#define LIMIT 501
#define LINEAR_SYM 502
#define LINES 503
#define LINESTRING 504
#define LIST_SYM 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATOR_SYM 508
#define LOCKS_SYM 509
#define LOCK_SYM 510
#define LOGFILE_SYM 511
#define LOGS_SYM 512
#define LONGBLOB 513
#define LONGTEXT 514
#define LONG_NUM 515
#define LONG_SYM 516
#define LOOP_SYM 517
#define LOW_PRIORITY 518
#define LT 519
#define MASTER_CONNECT_RETRY_SYM 520
#define MASTER_HOST_SYM 521
#define MASTER_LOG_FILE_SYM 522
#define MASTER_LOG_POS_SYM 523
#define MASTER_PASSWORD_SYM 524
#define MASTER_PORT_SYM 525
#define MASTER_SERVER_ID_SYM 526
#define MASTER_SSL_CAPATH_SYM 527
#define MASTER_SSL_CA_SYM 528
#define MASTER_SSL_CERT_SYM 529
#define MASTER_SSL_CIPHER_SYM 530
#define MASTER_SSL_KEY_SYM 531
#define MASTER_SSL_SYM 532
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 533
#define MASTER_SYM 534
#define MASTER_USER_SYM 535
#define MATCH 536
#define MAX_CONNECTIONS_PER_HOUR 537
#define MAX_QUERIES_PER_HOUR 538
#define MAX_ROWS 539
#define MAX_SIZE_SYM 540
#define MAX_SYM 541
#define MAX_UPDATES_PER_HOUR 542
#define MAX_USER_CONNECTIONS_SYM 543
#define MAX_VALUE_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MEMORY_SYM 549
#define MERGE_SYM 550
#define MICROSECOND_SYM 551
#define MIGRATE_SYM 552
#define MINUTE_MICROSECOND_SYM 553
#define MINUTE_SECOND_SYM 554
#define MINUTE_SYM 555
#define MIN_ROWS 556
#define MIN_SYM 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MULTILINESTRING 563
#define MULTIPOINT 564
#define MULTIPOLYGON 565
#define MUTEX_SYM 566
#define NAMES_SYM 567
#define NAME_SYM 568
#define NATIONAL_SYM 569
#define NATURAL 570
#define NCHAR_STRING 571
#define NCHAR_SYM 572
#define NDBCLUSTER_SYM 573
#define NE 574
#define NEG 575
#define NEW_SYM 576
#define NEXT_SYM 577
#define NODEGROUP_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WAIT_SYM 584
#define NO_WRITE_TO_BINLOG 585
#define NULL_SYM 586
#define NUM 587
#define NUMERIC_SYM 588
#define NVARCHAR_SYM 589
#define OFFLINE_SYM 590
#define OFFSET_SYM 591
#define OLD_PASSWORD 592
#define ON 593
#define ONE_SHOT_SYM 594
#define ONE_SYM 595
#define ONLINE_SYM 596
#define OPEN_SYM 597
#define OPTIMIZE 598
#define OPTIONS_SYM 599
#define OPTION 600
#define OPTIONALLY 601
#define OR2_SYM 602
#define ORDER_SYM 603
#define OR_OR_SYM 604
#define OR_SYM 605
#define OUTER 606
#define OUTFILE 607
#define OUT_SYM 608
#define OWNER_SYM 609
#define PACK_KEYS_SYM 610
#define PAGE_SYM 611
#define PARAM_MARKER 612
#define PARSER_SYM 613
#define PARTIAL 614
#define PARTITIONING_SYM 615
#define PARTITIONS_SYM 616
#define PARTITION_SYM 617
#define PASSWORD 618
#define PHASE_SYM 619
#define PLUGINS_SYM 620
#define PLUGIN_SYM 621
#define POINT_SYM 622
#define POLYGON 623
#define PORT_SYM 624
#define POSITION_SYM 625
#define PRECISION 626
#define PREPARE_SYM 627
#define PRESERVE_SYM 628
#define PREV_SYM 629
#define PRIMARY_SYM 630
#define PRIVILEGES 631
#define PROCEDURE 632
#define PROCESS 633
#define PROCESSLIST_SYM 634
#define PROFILE_SYM 635
#define PROFILES_SYM 636
#define PURGE 637
#define QUARTER_SYM 638
#define QUERY_SYM 639
#define QUICK 640
#define RANGE_SYM 641
#define READS_SYM 642
#define READ_ONLY_SYM 643
#define READ_SYM 644
#define READ_WRITE_SYM 645
#define REAL 646
#define REBUILD_SYM 647
#define RECOVER_SYM 648
#define REDOFILE_SYM 649
#define REDO_BUFFER_SIZE_SYM 650
#define REDUNDANT_SYM 651
#define REFERENCES 652
#define REGEXP 653
#define RELAY_LOG_FILE_SYM 654
#define RELAY_LOG_POS_SYM 655
#define RELAY_THREAD 656
#define RELEASE_SYM 657
#define RELOAD 658
#define REMOVE_SYM 659
#define RENAME 660
#define REORGANIZE_SYM 661
#define REPAIR 662
#define REPEATABLE_SYM 663
#define REPEAT_SYM 664
#define REPLACE 665
#define REPLICATION 666
#define REQUIRE_SYM 667
#define RESET_SYM 668
#define RESOURCES 669
#define RESTORE_SYM 670
#define RESTRICT 671
#define RESUME_SYM 672
#define RETURNS_SYM 673
#define RETURN_SYM 674
#define REVOKE 675
#define RIGHT 676
#define ROLLBACK_SYM 677
#define ROLLUP_SYM 678
#define ROUTINE_SYM 679
#define ROWS_SYM 680
#define ROW_FORMAT_SYM 681
#define ROW_SYM 682
#define RTREE_SYM 683
#define SAVEPOINT_SYM 684
#define SCHEDULE_SYM 685
#define SECOND_MICROSECOND_SYM 686
#define SECOND_SYM 687
#define SECURITY_SYM 688
#define SELECT_SYM 689
#define SENSITIVE_SYM 690
#define SEPARATOR_SYM 691
#define SERIALIZABLE_SYM 692
#define SERIAL_SYM 693
#define SESSION_SYM 694
#define SERVER_SYM 695
#define SERVER_OPTIONS 696
#define SET 697
#define SET_VAR 698
#define SHARE_SYM 699
#define SHIFT_LEFT 700
#define SHIFT_RIGHT 701
#define SHOW 702
#define SHUTDOWN 703
#define SIGNED_SYM 704
#define SIMPLE_SYM 705
#define SLAVE 706
#define SMALLINT 707
#define SNAPSHOT_SYM 708
#define SOCKET_SYM 709
#define SONAME_SYM 710
#define SOUNDS_SYM 711
#define SOURCE_SYM 712
#define SPATIAL_SYM 713
#define SPECIFIC_SYM 714
#define SQLEXCEPTION_SYM 715
#define SQLSTATE_SYM 716
#define SQLWARNING_SYM 717
#define SQL_BIG_RESULT 718
#define SQL_BUFFER_RESULT 719
#define SQL_CACHE_SYM 720
#define SQL_CALC_FOUND_ROWS 721
#define SQL_NO_CACHE_SYM 722
#define SQL_SMALL_RESULT 723
#define SQL_SYM 724
#define SQL_THREAD 725
#define SSL_SYM 726
#define STARTING 727
#define STARTS_SYM 728
#define START_SYM 729
#define STATUS_SYM 730
#define STDDEV_SAMP_SYM 731
#define STD_SYM 732
#define STOP_SYM 733
#define STORAGE_SYM 734
#define STRAIGHT_JOIN 735
#define STRING_SYM 736
#define SUBDATE_SYM 737
#define SUBJECT_SYM 738
#define SUBPARTITIONS_SYM 739
#define SUBPARTITION_SYM 740
#define SUBSTRING 741
#define SUM_SYM 742
#define SUPER_SYM 743
#define SUSPEND_SYM 744
#define SWAPS_SYM 745
#define SWITCHES_SYM 746
#define SYSDATE 747
#define TABLES 748
#define TABLESPACE 749
#define TABLE_REF_PRIORITY 750
#define TABLE_SYM 751
#define TEMPORARY 752
#define TEMPTABLE_SYM 753
#define TERMINATED 754
#define TEXT_STRING 755
#define TEXT_SYM 756
#define THAN_SYM 757
#define THEN_SYM 758
#define TIMESTAMP 759
#define TIMESTAMP_ADD 760
#define TIMESTAMP_DIFF 761
#define TIME_SYM 762
#define TINYBLOB 763
#define TINYINT 764
#define TINYTEXT 765
#define TO_SYM 766
#define TRAILING 767
#define TRANSACTION_SYM 768
#define TRANSACTIONAL_SYM 769
#define TRIGGERS_SYM 770
#define TRIGGER_SYM 771
#define TRIM 772
#define TRUE_SYM 773
#define TRUNCATE_SYM 774
#define TYPES_SYM 775
#define TYPE_SYM 776
#define UDF_RETURNS_SYM 777
#define ULONGLONG_NUM 778
#define UNCOMMITTED_SYM 779
#define UNDEFINED_SYM 780
#define UNDERSCORE_CHARSET 781
#define UNDOFILE_SYM 782
#define UNDO_BUFFER_SIZE_SYM 783
#define UNDO_SYM 784
#define UNICODE_SYM 785
#define UNINSTALL_SYM 786
#define UNION_SYM 787
#define UNIQUE_SYM 788
#define UNKNOWN_SYM 789
#define UNLOCK_SYM 790
#define UNSIGNED 791
#define UNTIL_SYM 792
#define UPDATE_SYM 793
#define UPGRADE_SYM 794
#define USAGE 795
#define USER 796
#define USE_FRM 797
#define USE_SYM 798
#define USING 799
#define UTC_DATE_SYM 800
#define UTC_TIMESTAMP_SYM 801
#define UTC_TIME_SYM 802
#define VALUES 803
#define VALUE_SYM 804
#define VARBINARY 805
#define VARCHAR 806
#define VARIABLES 807
#define VARIANCE_SYM 808
#define VARYING 809
#define VAR_SAMP_SYM 810
#define VIEW_SYM 811
#define WAIT_SYM 812
#define WARNINGS 813
#define WEEK_SYM 814
#define WHEN_SYM 815
#define WHERE 816
#define WHILE_SYM 817
#define WITH 818
#define WORK_SYM 819
#define WRAPPER_SYM 820
#define WRITE_SYM 821
#define X509_SYM 822
#define XA_SYM 823
#define XOR 824
#define YEAR_MONTH_SYM 825
#define YEAR_SYM 826
#define ZEROFILL 827




/* Copy the first part of user declarations.  */
#line 23 "sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "event_data_objects.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str= {0,0};

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->get_tok_start();
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 461 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum column_format_type column_format_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum ha_build_method build_method;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1713 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 507 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1728 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  549
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   46514

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  592
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  825
/* YYNRULES -- Number of rules. */
#define YYNRULES  2370
/* YYNRULES -- Number of states. */
#define YYNSTATES  4056

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   827

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   585,     2,     2,     2,   579,   574,     2,
     582,   583,   577,   576,   584,   575,   589,   578,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   591,   590,
       2,     2,     2,     2,   588,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   580,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   586,   573,   587,   581,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   108,   110,   112,   114,   118,   120,
     122,   127,   129,   132,   133,   138,   139,   142,   146,   148,
     151,   152,   156,   157,   163,   165,   169,   173,   177,   181,
     185,   189,   193,   197,   201,   205,   209,   213,   217,   219,
     223,   227,   231,   235,   236,   244,   245,   259,   260,   267,
     268,   272,   277,   282,   286,   289,   300,   302,   306,   309,
     312,   315,   318,   321,   324,   327,   328,   341,   342,   349,
     352,   353,   355,   359,   361,   362,   365,   366,   369,   370,
     372,   376,   381,   382,   385,   386,   389,   391,   393,   395,
     397,   399,   401,   403,   405,   407,   409,   411,   413,   415,
     416,   420,   422,   423,   426,   427,   430,   433,   436,   439,
     442,   446,   450,   452,   454,   456,   459,   463,   467,   468,
     473,   474,   478,   479,   481,   485,   487,   488,   490,   494,
     496,   497,   501,   502,   504,   508,   510,   515,   516,   518,
     520,   522,   523,   527,   530,   534,   535,   539,   540,   546,
     552,   553,   561,   567,   568,   571,   573,   575,   577,   581,
     583,   585,   589,   590,   592,   594,   596,   598,   601,   603,
     605,   609,   610,   613,   615,   617,   619,   621,   623,   625,
     627,   629,   631,   633,   635,   637,   639,   640,   646,   647,
     650,   651,   655,   656,   659,   662,   665,   668,   669,   676,
     679,   680,   683,   685,   687,   691,   692,   693,   694,   702,
     703,   706,   709,   711,   713,   714,   715,   724,   725,   732,
     734,   737,   739,   742,   743,   744,   751,   752,   753,   760,
     761,   764,   765,   771,   772,   774,   775,   781,   782,   785,
     786,   792,   797,   798,   799,   808,   809,   817,   819,   821,
     823,   825,   827,   830,   835,   841,   842,   847,   852,   857,
     861,   865,   868,   871,   872,   875,   877,   880,   884,   886,
     888,   890,   892,   894,   897,   901,   903,   905,   907,   909,
     911,   913,   915,   917,   919,   921,   924,   928,   930,   932,
     934,   936,   938,   940,   942,   945,   949,   951,   953,   955,
     957,   959,   961,   963,   965,   967,   970,   974,   976,   978,
     980,   983,   986,   989,   991,   993,   995,   997,  1000,  1004,
    1008,  1012,  1016,  1020,  1024,  1028,  1032,  1037,  1038,  1040,
    1042,  1044,  1046,  1048,  1051,  1055,  1058,  1063,  1069,  1070,
    1076,  1077,  1078,  1084,  1085,  1093,  1094,  1096,  1097,  1101,
    1102,  1106,  1112,  1118,  1119,  1124,  1125,  1129,  1130,  1134,
    1135,  1137,  1138,  1140,  1142,  1146,  1148,  1154,  1160,  1161,
    1164,  1165,  1166,  1174,  1175,  1185,  1187,  1191,  1193,  1195,
    1196,  1199,  1200,  1204,  1206,  1210,  1211,  1218,  1220,  1221,
    1226,  1232,  1234,  1236,  1238,  1242,  1246,  1248,  1252,  1254,
    1256,  1257,  1261,  1263,  1267,  1268,  1273,  1275,  1276,  1278,
    1281,  1283,  1287,  1292,  1296,  1300,  1304,  1309,  1314,  1318,
    1319,  1320,  1327,  1328,  1330,  1331,  1333,  1335,  1338,  1340,
    1342,  1343,  1345,  1347,  1350,  1352,  1353,  1357,  1358,  1360,
    1362,  1365,  1367,  1370,  1374,  1378,  1382,  1386,  1390,  1394,
    1398,  1402,  1406,  1410,  1414,  1418,  1422,  1426,  1432,  1434,
    1436,  1440,  1445,  1450,  1453,  1456,  1459,  1462,  1466,  1470,
    1474,  1479,  1484,  1486,  1488,  1490,  1492,  1494,  1496,  1498,
    1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,  1519,
    1521,  1523,  1525,  1527,  1529,  1533,  1535,  1537,  1540,  1543,
    1551,  1560,  1569,  1572,  1575,  1576,  1578,  1581,  1582,  1584,
    1587,  1588,  1593,  1597,  1601,  1605,  1607,  1612,  1614,  1616,
    1622,  1625,  1631,  1634,  1639,  1641,  1647,  1653,  1658,  1662,
    1664,  1666,  1669,  1671,  1673,  1676,  1678,  1680,  1682,  1685,
    1689,  1692,  1696,  1699,  1702,  1706,  1710,  1714,  1715,  1722,
    1723,  1730,  1733,  1735,  1737,  1739,  1741,  1743,  1745,  1747,
    1749,  1751,  1753,  1755,  1758,  1761,  1763,  1766,  1768,  1771,
    1775,  1778,  1780,  1782,  1784,  1786,  1788,  1790,  1792,  1795,
    1796,  1800,  1802,  1808,  1809,  1811,  1814,  1816,  1818,  1820,
    1822,  1823,  1827,  1828,  1830,  1831,  1833,  1836,  1838,  1840,
    1843,  1846,  1849,  1852,  1855,  1858,  1863,  1865,  1869,  1872,
    1874,  1877,  1880,  1883,  1886,  1888,  1891,  1893,  1895,  1897,
    1899,  1901,  1902,  1905,  1907,  1909,  1911,  1913,  1915,  1916,
    1919,  1921,  1923,  1924,  1926,  1927,  1930,  1932,  1935,  1939,
    1942,  1943,  1945,  1946,  1948,  1950,  1953,  1954,  1956,  1957,
    1962,  1964,  1969,  1973,  1975,  1976,  1978,  1981,  1983,  1987,
    1991,  1994,  1997,  2000,  2002,  2004,  2007,  2010,  2013,  2015,
    2018,  2021,  2024,  2027,  2029,  2031,  2032,  2034,  2036,  2038,
    2040,  2041,  2043,  2045,  2047,  2048,  2050,  2053,  2054,  2056,
    2058,  2061,  2064,  2067,  2069,  2073,  2077,  2079,  2081,  2083,
    2088,  2091,  2093,  2098,  2099,  2101,  2102,  2105,  2107,  2111,
    2112,  2120,  2121,  2127,  2135,  2136,  2142,  2143,  2149,  2150,
    2156,  2157,  2162,  2163,  2174,  2178,  2183,  2187,  2191,  2199,
    2200,  2204,  2206,  2211,  2212,  2216,  2217,  2220,  2221,  2223,
    2224,  2227,  2230,  2233,  2236,  2238,  2240,  2242,  2246,  2251,
    2252,  2259,  2264,  2265,  2271,  2272,  2279,  2284,  2286,  2287,
    2289,  2291,  2294,  2296,  2298,  2299,  2305,  2306,  2310,  2313,
    2314,  2320,  2321,  2322,  2329,  2331,  2335,  2337,  2339,  2343,
    2346,  2350,  2353,  2358,  2359,  2366,  2367,  2368,  2377,  2382,
    2387,  2391,  2395,  2398,  2401,  2408,  2414,  2418,  2424,  2426,
    2428,  2430,  2431,  2433,  2434,  2436,  2437,  2439,  2441,  2442,
    2445,  2447,  2448,  2450,  2452,  2454,  2455,  2461,  2465,  2466,
    2472,  2476,  2480,  2481,  2485,  2486,  2489,  2491,  2495,  2496,
    2498,  2500,  2501,  2504,  2506,  2510,  2511,  2518,  2519,  2526,
    2527,  2533,  2534,  2536,  2538,  2539,  2546,  2547,  2549,  2551,
    2554,  2556,  2558,  2560,  2561,  2567,  2570,  2571,  2577,  2578,
    2580,  2582,  2585,  2587,  2589,  2591,  2593,  2595,  2598,  2599,
    2605,  2606,  2608,  2610,  2611,  2616,  2621,  2625,  2631,  2633,
    2637,  2641,  2647,  2649,  2653,  2656,  2658,  2660,  2661,  2668,
    2670,  2674,  2678,  2679,  2682,  2683,  2688,  2689,  2692,  2694,
    2697,  2702,  2705,  2709,  2710,  2714,  2715,  2716,  2723,  2726,
    2728,  2730,  2733,  2736,  2745,  2750,  2751,  2753,  2756,  2758,
    2760,  2762,  2764,  2766,  2768,  2770,  2772,  2774,  2776,  2778,
    2779,  2782,  2787,  2791,  2793,  2795,  2800,  2801,  2802,  2804,
    2806,  2807,  2810,  2813,  2815,  2817,  2818,  2821,  2825,  2829,
    2833,  2836,  2840,  2845,  2849,  2854,  2858,  2863,  2865,  2869,
    2874,  2878,  2882,  2889,  2891,  2897,  2904,  2910,  2918,  2925,
    2934,  2940,  2947,  2952,  2957,  2963,  2967,  2972,  2974,  2978,
    2982,  2986,  2990,  2994,  2998,  3004,  3010,  3014,  3018,  3022,
    3026,  3030,  3034,  3036,  3038,  3040,  3042,  3044,  3046,  3048,
    3050,  3052,  3054,  3056,  3058,  3060,  3062,  3064,  3066,  3068,
    3070,  3072,  3074,  3076,  3078,  3082,  3084,  3086,  3088,  3090,
    3094,  3097,  3100,  3103,  3106,  3110,  3114,  3120,  3127,  3132,
    3137,  3145,  3148,  3155,  3161,  3168,  3175,  3180,  3185,  3191,
    3196,  3203,  3206,  3211,  3216,  3221,  3232,  3239,  3248,  3255,
    3260,  3265,  3272,  3277,  3282,  3287,  3294,  3299,  3307,  3315,
    3323,  3330,  3337,  3344,  3351,  3355,  3360,  3367,  3376,  3379,
    3382,  3387,  3396,  3405,  3412,  3419,  3422,  3427,  3434,  3441,
    3450,  3459,  3466,  3475,  3482,  3485,  3490,  3499,  3508,  3511,
    3514,  3517,  3522,  3527,  3532,  3537,  3541,  3550,  3555,  3562,
    3567,  3572,  3577,  3584,  3593,  3600,  3605,  3612,  3614,  3621,
    3626,  3631,  3636,  3641,  3646,  3653,  3658,  3659,  3665,  3672,
    3675,  3679,  3680,  3685,  3686,  3690,  3691,  3693,  3695,  3699,
    3704,  3709,  3715,  3720,  3725,  3730,  3736,  3741,  3742,  3743,
    3751,  3756,  3762,  3767,  3773,  3778,  3783,  3788,  3793,  3798,
    3804,  3805,  3814,  3815,  3819,  3823,  3825,  3830,  3831,  3833,
    3834,  3837,  3838,  3840,  3841,  3845,  3848,  3852,  3855,  3857,
    3860,  3862,  3865,  3867,  3869,  3871,  3874,  3875,  3877,  3879,
    3883,  3885,  3889,  3891,  3895,  3896,  3898,  3899,  3902,  3907,
    3913,  3915,  3917,  3919,  3921,  3926,  3928,  3932,  3936,  3940,
    3941,  3948,  3949,  3956,  3957,  3966,  3971,  3972,  3981,  3982,
    3993,  4000,  4001,  4010,  4011,  4022,  4029,  4031,  4034,  4037,
    4038,  4043,  4047,  4054,  4055,  4059,  4060,  4061,  4067,  4068,
    4070,  4071,  4073,  4074,  4077,  4081,  4085,  4087,  4089,  4090,
    4098,  4099,  4107,  4109,  4112,  4113,  4114,  4117,  4118,  4121,
    4122,  4124,  4126,  4128,  4130,  4134,  4136,  4140,  4142,  4144,
    4146,  4148,  4150,  4152,  4154,  4156,  4158,  4160,  4162,  4164,
    4166,  4168,  4170,  4172,  4174,  4176,  4178,  4180,  4182,  4184,
    4186,  4188,  4190,  4192,  4193,  4195,  4197,  4198,  4201,  4202,
    4204,  4205,  4206,  4210,  4211,  4212,  4216,  4219,  4220,  4221,
    4226,  4231,  4234,  4235,  4238,  4241,  4245,  4249,  4251,  4254,
    4255,  4257,  4258,  4263,  4268,  4271,  4272,  4274,  4276,  4277,
    4279,  4280,  4282,  4285,  4287,  4291,  4295,  4297,  4299,  4301,
    4303,  4304,  4307,  4309,  4311,  4313,  4315,  4317,  4319,  4321,
    4323,  4325,  4327,  4329,  4331,  4333,  4335,  4337,  4339,  4341,
    4343,  4345,  4347,  4349,  4351,  4353,  4354,  4355,  4362,  4363,
    4365,  4369,  4371,  4375,  4376,  4379,  4383,  4385,  4388,  4390,
    4391,  4395,  4396,  4402,  4405,  4407,  4408,  4412,  4419,  4420,
    4428,  4433,  4440,  4445,  4450,  4455,  4461,  4466,  4471,  4477,
    4484,  4489,  4491,  4495,  4497,  4499,  4503,  4505,  4506,  4509,
    4510,  4512,  4513,  4514,  4523,  4524,  4525,  4532,  4533,  4535,
    4537,  4539,  4541,  4543,  4546,  4548,  4550,  4552,  4556,  4561,
    4562,  4566,  4570,  4572,  4575,  4578,  4579,  4583,  4584,  4590,
    4594,  4596,  4600,  4602,  4606,  4608,  4610,  4611,  4613,  4614,
    4619,  4620,  4622,  4626,  4628,  4630,  4632,  4633,  4634,  4641,
    4642,  4643,  4655,  4659,  4661,  4665,  4669,  4671,  4675,  4676,
    4678,  4679,  4684,  4685,  4692,  4693,  4699,  4700,  4707,  4709,
    4713,  4717,  4723,  4724,  4727,  4728,  4731,  4733,  4735,  4737,
    4741,  4742,  4744,  4745,  4747,  4749,  4753,  4755,  4757,  4760,
    4763,  4766,  4768,  4770,  4772,  4774,  4775,  4779,  4780,  4784,
    4787,  4792,  4797,  4801,  4806,  4811,  4814,  4816,  4820,  4824,
    4831,  4848,  4851,  4854,  4855,  4862,  4868,  4871,  4874,  4877,
    4879,  4881,  4883,  4889,  4895,  4898,  4901,  4903,  4908,  4912,
    4915,  4918,  4921,  4925,  4928,  4931,  4933,  4937,  4942,  4946,
    4950,  4953,  4956,  4960,  4964,  4968,  4972,  4976,  4980,  4984,
    4988,  4990,  4992,  4994,  4996,  4998,  4999,  5001,  5002,  5005,
    5006,  5008,  5010,  5012,  5013,  5016,  5017,  5020,  5021,  5024,
    5027,  5028,  5033,  5034,  5039,  5041,  5043,  5044,  5046,  5048,
    5049,  5051,  5053,  5054,  5059,  5063,  5065,  5066,  5070,  5075,
    5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,  5094,  5095,
    5097,  5098,  5102,  5106,  5108,  5110,  5112,  5115,  5116,  5120,
    5124,  5127,  5130,  5134,  5135,  5137,  5139,  5142,  5143,  5148,
    5154,  5155,  5156,  5157,  5158,  5177,  5180,  5181,  5183,  5184,
    5186,  5188,  5189,  5191,  5193,  5194,  5197,  5200,  5202,  5206,
    5211,  5215,  5219,  5220,  5223,  5226,  5228,  5232,  5236,  5237,
    5241,  5242,  5246,  5249,  5253,  5255,  5257,  5260,  5261,  5264,
    5266,  5268,  5271,  5274,  5276,  5278,  5280,  5282,  5284,  5287,
    5290,  5292,  5294,  5296,  5298,  5300,  5302,  5304,  5307,  5310,
    5313,  5316,  5319,  5321,  5323,  5325,  5327,  5329,  5331,  5333,
    5337,  5343,  5345,  5347,  5349,  5351,  5353,  5357,  5362,  5368,
    5370,  5376,  5380,  5383,  5385,  5389,  5392,  5394,  5396,  5398,
    5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,  5418,
    5420,  5422,  5426,  5429,  5431,  5433,  5435,  5437,  5439,  5441,
    5443,  5445,  5447,  5449,  5451,  5453,  5455,  5457,  5459,  5461,
    5463,  5465,  5467,  5469,  5471,  5473,  5475,  5477,  5479,  5481,
    5483,  5485,  5487,  5489,  5491,  5493,  5495,  5497,  5499,  5501,
    5503,  5505,  5507,  5509,  5511,  5513,  5515,  5517,  5519,  5521,
    5523,  5525,  5527,  5529,  5531,  5533,  5535,  5537,  5539,  5541,
    5543,  5545,  5547,  5549,  5551,  5553,  5555,  5557,  5559,  5561,
    5563,  5565,  5567,  5569,  5571,  5573,  5575,  5577,  5579,  5581,
    5583,  5585,  5587,  5589,  5591,  5593,  5595,  5597,  5599,  5601,
    5603,  5605,  5607,  5609,  5611,  5613,  5615,  5617,  5619,  5621,
    5623,  5625,  5627,  5629,  5631,  5633,  5635,  5637,  5639,  5641,
    5643,  5645,  5647,  5649,  5651,  5653,  5655,  5657,  5659,  5661,
    5663,  5665,  5667,  5669,  5671,  5673,  5675,  5677,  5679,  5681,
    5683,  5685,  5687,  5689,  5691,  5693,  5695,  5697,  5699,  5701,
    5703,  5705,  5707,  5709,  5711,  5713,  5715,  5717,  5719,  5721,
    5723,  5725,  5727,  5729,  5731,  5733,  5735,  5737,  5739,  5741,
    5743,  5745,  5747,  5749,  5751,  5753,  5755,  5757,  5759,  5761,
    5763,  5765,  5767,  5769,  5771,  5773,  5775,  5777,  5779,  5781,
    5783,  5785,  5787,  5789,  5791,  5793,  5795,  5797,  5799,  5801,
    5803,  5805,  5807,  5809,  5811,  5813,  5815,  5817,  5819,  5821,
    5823,  5825,  5827,  5829,  5831,  5833,  5835,  5837,  5839,  5841,
    5843,  5845,  5847,  5849,  5851,  5853,  5855,  5857,  5859,  5861,
    5863,  5865,  5867,  5869,  5871,  5873,  5875,  5877,  5879,  5881,
    5883,  5885,  5887,  5889,  5891,  5893,  5895,  5897,  5899,  5901,
    5903,  5905,  5907,  5909,  5911,  5913,  5915,  5917,  5919,  5921,
    5923,  5925,  5927,  5929,  5931,  5933,  5935,  5937,  5939,  5941,
    5943,  5945,  5947,  5949,  5951,  5953,  5955,  5957,  5959,  5961,
    5963,  5965,  5967,  5969,  5971,  5973,  5975,  5977,  5979,  5981,
    5983,  5985,  5987,  5989,  5991,  5993,  5995,  5997,  5999,  6001,
    6003,  6005,  6007,  6009,  6011,  6013,  6015,  6017,  6019,  6021,
    6023,  6025,  6027,  6029,  6031,  6033,  6035,  6037,  6039,  6041,
    6043,  6045,  6047,  6049,  6051,  6053,  6054,  6059,  6060,  6062,
    6064,  6068,  6069,  6072,  6074,  6076,  6078,  6080,  6081,  6083,
    6084,  6086,  6088,  6090,  6091,  6094,  6097,  6100,  6102,  6105,
    6110,  6116,  6121,  6128,  6131,  6135,  6139,  6143,  6149,  6151,
    6155,  6159,  6162,  6165,  6168,  6170,  6172,  6177,  6182,  6184,
    6186,  6188,  6190,  6192,  6193,  6198,  6200,  6202,  6204,  6208,
    6212,  6214,  6216,  6219,  6222,  6223,  6227,  6232,  6236,  6237,
    6245,  6247,  6250,  6252,  6254,  6256,  6258,  6260,  6262,  6263,
    6269,  6271,  6273,  6275,  6277,  6279,  6283,  6290,  6297,  6304,
    6312,  6316,  6325,  6334,  6343,  6344,  6346,  6348,  6351,  6352,
    6354,  6356,  6360,  6361,  6365,  6366,  6370,  6371,  6375,  6376,
    6380,  6382,  6384,  6386,  6388,  6390,  6392,  6394,  6396,  6398,
    6400,  6402,  6405,  6408,  6410,  6414,  6417,  6420,  6423,  6426,
    6429,  6432,  6435,  6438,  6440,  6442,  6443,  6445,  6449,  6451,
    6454,  6457,  6460,  6462,  6466,  6470,  6472,  6474,  6478,  6480,
    6484,  6489,  6495,  6497,  6498,  6502,  6506,  6508,  6510,  6511,
    6514,  6517,  6520,  6523,  6524,  6527,  6530,  6532,  6535,  6538,
    6541,  6544,  6547,  6548,  6552,  6553,  6555,  6556,  6560,  6563,
    6564,  6566,  6569,  6570,  6572,  6577,  6582,  6588,  6591,  6595,
    6596,  6598,  6599,  6604,  6605,  6607,  6609,  6610,  6613,  6616,
    6618,  6619,  6621,  6623,  6624,  6630,  6637,  6638,  6639,  6642,
    6645,  6649,  6651,  6653,  6655,  6657,  6659,  6661,  6663,  6665,
    6667,  6669,  6671,  6673,  6675,  6676,  6680,  6682,  6685,  6687,
    6690,  6694,  6698,  6702,  6703,  6707,  6711,  6712,  6713,  6722,
    6723,  6727,  6729,  6733,  6734,  6738,  6741,  6746,  6747,  6751,
    6756,  6761,  6762,  6763,  6764,  6781,  6790,  6798,  6799,  6800,
    6801,  6802,  6803,  6819,  6820,  6821,  6822,  6823,  6836,  6841,
    6846,  6850,  6855,  6859,  6862,  6864,  6868,  6874,  6876,  6878,
    6879,  6881,  6883,  6884,  6887,  6888,  6889,  6893,  6894,  6897,
    6903
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     593,     0,    -1,   141,    -1,   594,   141,    -1,   595,    -1,
    1350,    -1,   908,    -1,   970,    -1,   960,    -1,   972,    -1,
     640,    -1,   607,    -1,   973,    -1,   962,    -1,  1356,    -1,
     612,    -1,   596,    -1,  1192,    -1,  1222,    -1,  1146,    -1,
    1148,    -1,   600,    -1,  1228,    -1,  1325,    -1,  1316,    -1,
     605,    -1,  1156,    -1,  1415,    -1,  1242,    -1,  1245,    -1,
    1308,    -1,   978,    -1,   986,    -1,   772,    -1,   990,    -1,
     598,    -1,  1238,    -1,  1359,    -1,   981,    -1,   965,    -1,
    1159,    -1,  1234,    -1,   958,    -1,  1323,    -1,  1357,    -1,
    1358,    -1,   998,    -1,  1291,    -1,  1209,    -1,   947,    -1,
     950,    -1,  1203,    -1,  1416,    -1,  1314,    -1,  1184,    -1,
    1244,    -1,  1407,    -1,   597,   372,  1285,    -1,   108,    -1,
     129,    -1,   372,  1285,   176,   599,    -1,  1282,    -1,   588,
    1287,    -1,    -1,   153,  1285,   601,   602,    -1,    -1,   544,
     603,    -1,   603,   584,   604,    -1,   604,    -1,   588,  1287,
      -1,    -1,   193,   606,  1287,    -1,    -1,    55,   279,   511,
     608,   609,    -1,   610,    -1,   609,   584,   610,    -1,   266,
     145,  1282,    -1,   280,   145,  1282,    -1,   269,   145,  1282,
      -1,   270,   145,  1127,    -1,   265,   145,  1127,    -1,   277,
     145,  1127,    -1,   273,   145,  1282,    -1,   272,   145,  1282,
      -1,   274,   145,  1282,    -1,   275,   145,  1282,    -1,   276,
     145,  1282,    -1,   278,   145,  1127,    -1,   611,    -1,   267,
     145,  1282,    -1,   268,   145,  1129,    -1,   399,   145,  1282,
      -1,   400,   145,  1127,    -1,    -1,    88,   820,   496,   823,
    1279,   613,   763,    -1,    -1,    88,   924,   895,   209,  1285,
     897,   338,  1279,   614,   582,   903,   583,   898,    -1,    -1,
      88,    95,   823,  1285,   615,   817,    -1,    -1,    88,   616,
    1372,    -1,    88,   541,   633,  1341,    -1,    88,   256,   187,
     726,    -1,    88,   494,   723,    -1,    88,   617,    -1,   440,
    1287,   172,    98,   565,  1287,   344,   582,   618,   583,    -1,
     619,    -1,   618,   584,   619,    -1,   541,  1282,    -1,   196,
    1282,    -1,    95,  1282,    -1,   354,  1282,    -1,   363,  1282,
      -1,   454,  1282,    -1,   369,  1127,    -1,    -1,   151,   823,
     634,   621,   338,   430,   622,   627,   624,   629,   128,   630,
      -1,    -1,   152,  1019,  1099,   623,   625,   626,    -1,    22,
    1019,    -1,    -1,   137,    -1,   122,   338,   451,    -1,   122,
      -1,    -1,   473,  1019,    -1,    -1,   140,  1019,    -1,    -1,
     628,    -1,   338,    74,   373,    -1,   338,    74,   326,   373,
      -1,    -1,    70,  1282,    -1,    -1,   631,   632,    -1,   672,
      -1,   674,    -1,   670,    -1,   691,    -1,   709,    -1,   711,
      -1,   706,    -1,   676,    -1,   678,    -1,   679,    -1,   680,
      -1,   681,    -1,   683,    -1,    -1,  1285,   589,  1285,    -1,
    1285,    -1,    -1,   635,   637,    -1,    -1,   636,   638,    -1,
      70,  1282,    -1,   235,   469,    -1,   328,   469,    -1,    81,
     469,    -1,   387,   469,    98,    -1,   304,   469,    98,    -1,
     639,    -1,   637,    -1,   120,    -1,  1025,   120,    -1,   469,
     433,   113,    -1,   469,   433,   222,    -1,    -1,    49,   634,
     641,   642,    -1,    -1,   582,   643,   583,    -1,    -1,   644,
      -1,   644,   584,  1019,    -1,  1019,    -1,    -1,   646,    -1,
     646,   584,   648,    -1,   648,    -1,    -1,  1285,   647,   847,
      -1,    -1,   650,    -1,   650,   584,   651,    -1,   651,    -1,
     652,   647,  1285,   847,    -1,    -1,   223,    -1,   353,    -1,
     214,    -1,    -1,   653,   669,   590,    -1,   669,   590,    -1,
     654,   669,   590,    -1,    -1,   655,   656,   590,    -1,    -1,
     111,   667,   657,   847,   668,    -1,   111,  1285,    77,   173,
     664,    -1,    -1,   111,   661,   190,   173,   658,   662,   669,
      -1,   111,  1285,    93,   173,   659,    -1,    -1,   660,   998,
      -1,   155,    -1,    83,    -1,   663,    -1,   662,   584,   663,
      -1,   666,    -1,  1127,    -1,   461,   665,  1283,    -1,    -1,
     549,    -1,   664,    -1,  1285,    -1,   462,    -1,  1025,   174,
      -1,   460,    -1,  1285,    -1,   667,   584,  1285,    -1,    -1,
     112,  1019,    -1,   672,    -1,   674,    -1,   670,    -1,   691,
      -1,   709,    -1,   711,    -1,   706,    -1,   676,    -1,   678,
      -1,   679,    -1,   680,    -1,   681,    -1,   683,    -1,    -1,
     205,   671,   686,   139,   205,    -1,    -1,   673,   595,    -1,
      -1,   419,   675,  1019,    -1,    -1,   677,   715,    -1,   240,
    1286,    -1,   229,  1286,    -1,   342,  1285,    -1,    -1,   163,
     684,  1285,   220,   682,   685,    -1,    63,  1285,    -1,    -1,
     322,   176,    -1,   176,    -1,  1285,    -1,   685,   584,  1285,
      -1,    -1,    -1,    -1,   687,  1019,   503,   688,   654,   689,
     690,    -1,    -1,   136,   686,    -1,   135,   654,    -1,   692,
      -1,   695,    -1,    -1,    -1,    52,   693,  1019,   694,   697,
     705,   139,    52,    -1,    -1,    52,   696,   698,   705,   139,
      52,    -1,   699,    -1,   697,   699,    -1,   702,    -1,   698,
     702,    -1,    -1,    -1,   560,   700,  1019,   701,   503,   654,
      -1,    -1,    -1,   560,   703,  1019,   704,   503,   654,    -1,
      -1,   135,   654,    -1,    -1,  1286,   591,   707,   715,   708,
      -1,    -1,  1286,    -1,    -1,  1286,   591,   710,   713,   708,
      -1,    -1,   712,   713,    -1,    -1,    30,   714,   655,   653,
     139,    -1,   262,   654,   139,   262,    -1,    -1,    -1,   562,
     716,  1019,   128,   717,   654,   139,   562,    -1,    -1,   409,
     654,   537,   718,  1019,   139,   409,    -1,    29,    -1,     8,
      -1,   216,    -1,   538,    -1,   116,    -1,   748,   750,    -1,
     748,    55,   745,   729,    -1,   748,     6,   745,   724,   733,
      -1,    -1,   543,   256,   187,  1285,    -1,   748,     6,   745,
     736,    -1,   748,   129,   745,   736,    -1,   749,   728,   739,
      -1,   749,   728,   742,    -1,     6,   746,    -1,     6,   747,
      -1,    -1,   730,   731,    -1,   732,    -1,   731,   732,    -1,
     731,   584,   732,    -1,   751,    -1,   752,    -1,   753,    -1,
     734,    -1,   735,    -1,   734,   735,    -1,   734,   584,   735,
      -1,   751,    -1,   752,    -1,   753,    -1,   754,    -1,   757,
      -1,   759,    -1,   761,    -1,   758,    -1,   737,    -1,   738,
      -1,   737,   738,    -1,   737,   584,   738,    -1,   751,    -1,
     752,    -1,   753,    -1,   759,    -1,   761,    -1,   740,    -1,
     741,    -1,   740,   741,    -1,   740,   584,   741,    -1,   751,
      -1,   755,    -1,   756,    -1,   757,    -1,   759,    -1,   761,
      -1,   758,    -1,   743,    -1,   744,    -1,   743,   744,    -1,
     743,   584,   744,    -1,   751,    -1,   759,    -1,   761,    -1,
      97,  1282,    -1,   527,  1282,    -1,   394,  1282,    -1,  1285,
      -1,  1285,    -1,   388,    -1,   390,    -1,   326,     4,    -1,
     211,  1176,   762,    -1,    24,  1176,   762,    -1,   285,  1176,
     762,    -1,   158,  1176,   762,    -1,   528,  1176,   762,    -1,
     395,  1176,   762,    -1,   323,  1176,  1128,    -1,    70,  1176,
    1282,    -1,  1215,   143,  1176,   830,    -1,    -1,   761,    -1,
     557,    -1,   329,    -1,  1128,    -1,   202,    -1,   582,   764,
      -1,   824,   769,   766,    -1,   245,  1279,    -1,   582,   245,
    1279,   583,    -1,   837,   583,   824,   769,   766,    -1,    -1,
     769,   813,   583,   765,  1363,    -1,    -1,    -1,  1254,   816,
     813,   767,  1360,    -1,    -1,  1254,   816,   582,   813,   583,
     768,  1363,    -1,    -1,   770,    -1,    -1,   362,   771,   774,
      -1,    -1,   362,   773,   774,    -1,    46,   775,   785,   786,
     793,    -1,   779,   233,   582,   780,   583,    -1,    -1,   779,
     191,   776,   783,    -1,    -1,   386,   777,   783,    -1,    -1,
     250,   778,   783,    -1,    -1,   247,    -1,    -1,   781,    -1,
     782,    -1,   781,   584,   782,    -1,  1285,    -1,   582,  1014,
     791,  1015,   583,    -1,   582,  1014,   791,  1015,   583,    -1,
      -1,   361,  1128,    -1,    -1,    -1,   485,    46,   779,   191,
     784,   787,   792,    -1,    -1,   485,    46,   779,   233,   582,
     789,   583,   788,   792,    -1,   790,    -1,   789,   584,   790,
      -1,  1285,    -1,  1022,    -1,    -1,   484,  1128,    -1,    -1,
     582,   794,   583,    -1,   795,    -1,   794,   584,   795,    -1,
      -1,   362,   796,   797,   798,   810,   805,    -1,  1285,    -1,
      -1,   548,   242,   502,   799,    -1,   548,   223,   582,   802,
     583,    -1,   800,    -1,   801,    -1,   289,    -1,   582,   289,
     583,    -1,   582,   804,   583,    -1,   803,    -1,   802,   584,
     803,    -1,   804,    -1,  1022,    -1,    -1,   582,   806,   583,
      -1,   807,    -1,   806,   584,   807,    -1,    -1,   485,   808,
     809,   810,    -1,  1287,    -1,    -1,   811,    -1,   811,   812,
      -1,   812,    -1,   494,  1176,  1287,    -1,  1215,   143,  1176,
     830,    -1,   323,  1176,  1128,    -1,   284,  1176,  1130,    -1,
     301,  1176,  1130,    -1,    98,   121,  1176,  1282,    -1,   209,
     121,  1176,  1282,    -1,    70,  1176,  1282,    -1,    -1,    -1,
     434,   814,  1008,  1012,   815,   835,    -1,    -1,    18,    -1,
      -1,   818,    -1,   819,    -1,   818,   819,    -1,   829,    -1,
     828,    -1,    -1,   821,    -1,   822,    -1,   822,   821,    -1,
     497,    -1,    -1,   205,  1025,   154,    -1,    -1,   826,    -1,
     827,    -1,   827,   825,    -1,   827,    -1,   827,   826,    -1,
     827,   584,   826,    -1,   143,  1176,   830,    -1,   521,  1176,
     830,    -1,   284,  1176,  1129,    -1,   301,  1176,  1129,    -1,
      26,  1176,  1127,    -1,   363,  1176,  1282,    -1,    70,  1176,
    1282,    -1,    25,  1176,  1129,    -1,   355,  1176,  1127,    -1,
     355,  1176,   112,    -1,    59,  1176,  1127,    -1,   115,  1176,
    1127,    -1,   426,  1176,   833,    -1,   532,  1176,   582,  1150,
     583,    -1,   828,    -1,   829,    -1,   217,  1176,   834,    -1,
      98,   121,  1176,  1282,    -1,   209,   121,  1176,  1282,    -1,
     494,  1285,    -1,   479,   112,    -1,   479,   124,    -1,   479,
     294,    -1,    78,  1176,  1282,    -1,   232,  1176,  1127,    -1,
     514,  1176,  1127,    -1,   877,   868,  1176,   870,    -1,   877,
      66,  1176,   876,    -1,  1287,    -1,  1287,    -1,   112,    -1,
     167,    -1,   133,    -1,   112,    -1,   167,    -1,   133,    -1,
      75,    -1,   396,    -1,    73,    -1,   356,    -1,   328,    -1,
     166,    -1,   236,    -1,  1122,    -1,  1007,  1011,    -1,   481,
      -1,   391,    -1,   110,    -1,   221,    -1,   838,    -1,   837,
     584,   838,    -1,   839,    -1,   840,    -1,   845,   841,    -1,
     845,   882,    -1,   890,   905,   897,   582,   903,   583,   898,
      -1,   843,   891,   905,   897,   582,   903,   583,   898,    -1,
     843,   172,   233,   905,   582,   903,   583,   882,    -1,   844,
     841,    -1,   843,   842,    -1,    -1,   842,    -1,    60,  1019,
      -1,    -1,   844,    -1,    80,   905,    -1,    -1,  1278,   846,
     847,   864,    -1,   855,   862,   859,    -1,   856,   863,   859,
      -1,   169,   857,   859,    -1,    38,    -1,    38,   582,   332,
     583,    -1,    43,    -1,    42,    -1,   851,   582,   332,   583,
     878,    -1,   851,   878,    -1,   852,   582,   332,   583,   879,
      -1,   852,   879,    -1,    33,   582,   332,   583,    -1,    33,
      -1,   853,   582,   332,   583,   878,    -1,   854,   582,   332,
     583,   879,    -1,   550,   582,   332,   583,    -1,   571,   862,
     859,    -1,   102,    -1,   507,    -1,   504,   862,    -1,    99,
      -1,   508,    -1,    40,   862,    -1,   850,    -1,   290,    -1,
     258,    -1,   261,   550,    -1,   261,   853,   878,    -1,   510,
     878,    -1,   501,   862,   878,    -1,   292,   878,    -1,   259,
     878,    -1,   110,   857,   859,    -1,   333,   857,   859,    -1,
     167,   857,   859,    -1,    -1,   144,   848,   582,   907,   583,
     878,    -1,    -1,   442,   849,   582,   907,   583,   878,    -1,
     261,   878,    -1,   438,    -1,   182,    -1,   181,    -1,   367,
      -1,   309,    -1,   249,    -1,   308,    -1,   368,    -1,   310,
      -1,    58,    -1,   317,    -1,   314,    58,    -1,   851,   554,
      -1,   551,    -1,   314,   551,    -1,   334,    -1,   317,   551,
      -1,   314,    58,   554,    -1,   317,   554,    -1,   221,    -1,
     509,    -1,   452,    -1,   291,    -1,    32,    -1,   391,    -1,
     127,    -1,   127,   371,    -1,    -1,   582,   332,   583,    -1,
     858,    -1,   582,   332,   584,   332,   583,    -1,    -1,   860,
      -1,   860,   861,    -1,   861,    -1,   449,    -1,   536,    -1,
     572,    -1,    -1,   582,   332,   583,    -1,    -1,   858,    -1,
      -1,   865,    -1,   865,   866,    -1,   866,    -1,   331,    -1,
     479,   112,    -1,   479,   124,    -1,   479,   294,    -1,   164,
     832,    -1,  1025,   331,    -1,   112,   867,    -1,   338,   538,
     327,  1018,    -1,    25,    -1,   438,   112,   549,    -1,   881,
     233,    -1,   533,    -1,   533,   233,    -1,    70,  1282,    -1,
      66,   874,    -1,   327,  1018,    -1,  1269,    -1,    58,   442,
      -1,    57,    -1,  1287,    -1,    33,    -1,   869,    -1,   112,
      -1,    -1,   868,   870,    -1,  1287,    -1,    33,    -1,   872,
      -1,   112,    -1,  1287,    -1,    -1,    66,   876,    -1,   874,
      -1,   112,    -1,    -1,   112,    -1,    -1,    20,   879,    -1,
      47,    -1,   530,   879,    -1,   868,   869,   879,    -1,    33,
     880,    -1,    -1,    33,    -1,    -1,    20,    -1,   530,    -1,
     868,   869,    -1,    -1,   375,    -1,    -1,   397,  1279,   883,
     884,    -1,   886,    -1,   582,   885,   583,   886,    -1,   885,
     584,  1285,    -1,  1285,    -1,    -1,   887,    -1,   887,   888,
      -1,   888,    -1,   338,   116,   889,    -1,   338,   538,   889,
      -1,   281,   177,    -1,   281,   359,    -1,   281,   450,    -1,
     416,    -1,    50,    -1,   442,   331,    -1,   328,     5,    -1,
     442,   112,    -1,   892,    -1,   178,   893,    -1,   458,   893,
      -1,   375,   233,    -1,   533,   893,    -1,   233,    -1,   209,
      -1,    -1,   892,    -1,   231,    -1,   209,    -1,   208,    -1,
      -1,   533,    -1,   178,    -1,   458,    -1,    -1,   896,    -1,
     896,   900,    -1,    -1,   899,    -1,   901,    -1,   899,   901,
      -1,   544,   902,    -1,   521,   902,    -1,   900,    -1,   232,
    1176,  1127,    -1,   563,   358,  1281,    -1,    45,    -1,   428,
      -1,   191,    -1,   903,   584,   904,  1120,    -1,   904,  1120,
      -1,  1285,    -1,  1285,   582,   332,   583,    -1,    -1,  1278,
      -1,    -1,   589,  1285,    -1,  1267,    -1,   907,   584,  1267,
      -1,    -1,    13,   924,   943,   496,  1279,   909,   920,    -1,
      -1,    13,    95,   919,   910,   818,    -1,    13,    95,  1285,
     539,    98,   121,   313,    -1,    -1,    13,   377,   634,   911,
     635,    -1,    -1,    13,   179,   634,   912,   635,    -1,    -1,
      13,  1380,  1375,   913,  1382,    -1,    -1,    13,  1375,   914,
    1382,    -1,    -1,    13,  1375,   151,   634,   915,   916,   917,
     624,   629,   918,    -1,    13,   494,   725,    -1,    13,   256,
     187,   727,    -1,    13,   494,   722,    -1,    13,   494,   721,
      -1,    13,   440,  1287,   344,   582,   618,   583,    -1,    -1,
     338,   430,   622,    -1,   628,    -1,   338,   430,   622,   628,
      -1,    -1,   405,   511,   634,    -1,    -1,   128,   630,    -1,
      -1,  1285,    -1,    -1,   123,   494,    -1,   207,   494,    -1,
     936,   769,    -1,   936,   925,    -1,   925,    -1,   770,    -1,
     927,    -1,   129,   362,   934,    -1,   392,   362,   980,   926,
      -1,    -1,   343,   362,   980,   926,   921,   980,    -1,    14,
     362,   980,   926,    -1,    -1,    60,   362,   926,   922,   975,
      -1,    -1,   407,   362,   980,   926,   923,   967,    -1,    64,
     362,   980,  1128,    -1,   930,    -1,    -1,   341,    -1,   335,
      -1,   404,   360,    -1,    12,    -1,   934,    -1,    -1,     6,
     362,   980,   928,   929,    -1,    -1,   582,   794,   583,    -1,
     361,  1128,    -1,    -1,   406,   362,   980,   931,   932,    -1,
      -1,    -1,   934,   933,   220,   582,   794,   583,    -1,   935,
      -1,   934,   584,   935,    -1,  1285,    -1,   938,    -1,   936,
     584,   938,    -1,     6,   942,    -1,   937,   839,   945,    -1,
       6,   840,    -1,   937,   582,   837,   583,    -1,    -1,    55,
     942,  1278,   939,   845,   945,    -1,    -1,    -1,   305,   942,
    1278,   940,   847,   864,   941,   945,    -1,   129,   942,  1278,
     944,    -1,   129,   172,   233,   905,    -1,   129,   375,   233,
      -1,   129,   892,  1278,    -1,   122,   231,    -1,   137,   231,
      -1,    13,   942,  1278,   442,   112,  1269,    -1,    13,   942,
    1278,   129,   112,    -1,   405,   946,  1279,    -1,    85,   511,
     868,   870,   875,    -1,   825,    -1,   171,    -1,  1113,    -1,
      -1,    69,    -1,    -1,   206,    -1,    -1,   416,    -1,    50,
      -1,    -1,     8,  1285,    -1,   166,    -1,    -1,   511,    -1,
     145,    -1,    18,    -1,    -1,   474,   451,   952,   948,   956,
      -1,   478,   451,   952,    -1,    -1,   451,   474,   952,   949,
     956,    -1,   451,   478,   952,    -1,   474,   513,   951,    -1,
      -1,   563,    79,   453,    -1,    -1,   953,   954,    -1,   955,
      -1,   954,   584,   955,    -1,    -1,   470,    -1,   401,    -1,
      -1,   537,   957,    -1,   611,    -1,   957,   584,   611,    -1,
      -1,   415,  1310,   959,  1150,   176,  1282,    -1,    -1,    28,
    1310,   961,  1150,   511,  1282,    -1,    -1,    59,  1310,   963,
    1150,   964,    -1,    -1,   385,    -1,   157,    -1,    -1,   407,
     980,  1310,   966,  1150,   967,    -1,    -1,   968,    -1,   969,
      -1,   969,   968,    -1,   385,    -1,   157,    -1,   542,    -1,
      -1,    14,   980,  1310,   971,  1150,    -1,    34,  1282,    -1,
      -1,    60,  1310,   974,  1150,   975,    -1,    -1,   976,    -1,
     977,    -1,   977,   976,    -1,   385,    -1,   161,    -1,   293,
      -1,   157,    -1,    56,    -1,   173,   539,    -1,    -1,   343,
     980,  1310,   979,  1150,    -1,    -1,   330,    -1,   252,    -1,
      -1,   405,  1310,   982,   984,    -1,   405,   541,   633,   983,
      -1,  1288,   511,  1288,    -1,   983,   584,  1288,   511,  1288,
      -1,   985,    -1,   984,   584,   985,    -1,  1279,   511,  1279,
      -1,    48,   209,   987,   223,   989,    -1,   988,    -1,   987,
     584,   988,    -1,  1279,   994,    -1,  1285,    -1,   112,    -1,
      -1,   251,   209,   220,    48,   991,   992,    -1,   993,    -1,
     992,   584,   993,    -1,  1279,   994,   997,    -1,    -1,   995,
     996,    -1,    -1,   892,   582,  1095,   583,    -1,    -1,   206,
     239,    -1,   999,    -1,   434,  1001,    -1,   582,  1000,   583,
    1363,    -1,   434,  1003,    -1,   582,  1000,   583,    -1,    -1,
    1003,  1002,  1360,    -1,    -1,    -1,  1004,  1008,  1012,  1005,
    1006,  1011,    -1,  1116,  1122,    -1,  1142,    -1,  1007,    -1,
    1142,  1007,    -1,  1007,  1142,    -1,   176,  1063,  1105,  1110,
    1107,  1116,  1122,  1133,    -1,   176,   130,  1105,  1122,    -1,
      -1,  1009,    -1,  1009,  1010,    -1,  1010,    -1,   480,    -1,
     195,    -1,   125,    -1,   468,    -1,   463,    -1,   464,    -1,
     466,    -1,   467,    -1,   465,    -1,    12,    -1,    -1,   173,
     538,    -1,   255,   223,   444,   303,    -1,  1012,   584,  1013,
      -1,  1013,    -1,   577,    -1,  1014,  1016,  1015,  1017,    -1,
      -1,    -1,  1273,    -1,  1019,    -1,    -1,    18,  1285,    -1,
      18,  1282,    -1,  1285,    -1,  1282,    -1,    -1,   582,   583,
      -1,  1019,  1023,  1019,    -1,  1019,   569,  1019,    -1,  1019,
    1024,  1019,    -1,   326,  1019,    -1,  1020,   226,   518,    -1,
    1020,   226,  1025,   518,    -1,  1020,   226,   160,    -1,  1020,
     226,  1025,   160,    -1,  1020,   226,   534,    -1,  1020,   226,
    1025,   534,    -1,  1020,    -1,  1020,   226,   331,    -1,  1020,
     226,  1025,   331,    -1,  1020,   146,  1021,    -1,  1020,  1027,
    1021,    -1,  1020,  1027,  1028,   582,  1369,   583,    -1,  1021,
      -1,  1022,   223,   582,  1369,   583,    -1,  1022,  1025,   223,
     582,  1369,   583,    -1,  1022,   223,   582,  1019,   583,    -1,
    1022,   223,   582,  1019,   584,  1056,   583,    -1,  1022,  1025,
     223,   582,  1019,   583,    -1,  1022,  1025,   223,   582,  1019,
     584,  1056,   583,    -1,  1022,    31,  1022,    16,  1021,    -1,
    1022,  1025,    31,  1022,    16,  1021,    -1,  1022,   456,   245,
    1022,    -1,  1022,   245,  1029,  1109,    -1,  1022,  1025,   245,
    1029,  1109,    -1,  1022,   398,  1022,    -1,  1022,  1025,   398,
    1022,    -1,  1022,    -1,  1022,   573,  1022,    -1,  1022,   574,
    1022,    -1,  1022,   445,  1022,    -1,  1022,   446,  1022,    -1,
    1022,   576,  1022,    -1,  1022,   575,  1022,    -1,  1022,   576,
     219,  1019,  1099,    -1,  1022,   575,   219,  1019,  1099,    -1,
    1022,   577,  1022,    -1,  1022,   578,  1022,    -1,  1022,   579,
    1022,    -1,  1022,   126,  1022,    -1,  1022,   306,  1022,    -1,
    1022,   580,  1022,    -1,  1029,    -1,   350,    -1,   347,    -1,
      16,    -1,    15,    -1,   326,    -1,   325,    -1,   585,    -1,
     325,    -1,   145,    -1,   180,    -1,   189,    -1,   237,    -1,
     264,    -1,   319,    -1,    12,    -1,    17,    -1,  1275,    -1,
    1030,    -1,  1031,    -1,  1034,    -1,  1032,    -1,  1029,    66,
    1287,    -1,  1270,    -1,  1268,    -1,  1046,    -1,  1042,    -1,
    1029,   349,  1029,    -1,   576,  1029,    -1,   575,  1029,    -1,
     581,  1029,    -1,  1026,  1029,    -1,   582,  1369,   583,    -1,
     582,  1019,   583,    -1,   582,  1019,   584,  1056,   583,    -1,
     427,   582,  1019,   584,  1056,   583,    -1,   154,   582,  1369,
     583,    -1,   586,  1285,  1019,   587,    -1,   281,  1057,     9,
     582,  1022,  1036,   583,    -1,    33,  1029,    -1,    53,   582,
    1019,    18,  1054,   583,    -1,    52,  1059,  1061,  1060,   139,
      -1,    85,   582,  1019,   584,  1054,   583,    -1,    85,   582,
    1019,   544,   869,   583,    -1,   112,   582,  1275,   583,    -1,
     548,   582,  1276,   583,    -1,   219,  1019,  1099,   576,  1019,
      -1,    58,   582,  1056,   583,    -1,    58,   582,  1056,   544,
     869,   583,    -1,    92,  1018,    -1,   102,   582,  1019,   583,
      -1,   107,   582,  1019,   583,    -1,   201,   582,  1019,   583,
      -1,   216,   582,  1019,   584,  1019,   584,  1019,   584,  1019,
     583,    -1,   219,   582,  1019,   584,  1019,   583,    -1,   219,
     582,  1019,   584,  1019,   584,  1056,   583,    -1,   241,   582,
    1019,   584,  1019,   583,    -1,   300,   582,  1019,   583,    -1,
     307,   582,  1019,   583,    -1,   421,   582,  1019,   584,  1019,
     583,    -1,   432,   582,  1019,   583,    -1,   507,   582,  1019,
     583,    -1,   504,   582,  1019,   583,    -1,   504,   582,  1019,
     584,  1019,   583,    -1,   517,   582,  1019,   583,    -1,   517,
     582,   238,  1019,   176,  1019,   583,    -1,   517,   582,   512,
    1019,   176,  1019,   583,    -1,   517,   582,    44,  1019,   176,
    1019,   583,    -1,   517,   582,   238,   176,  1019,   583,    -1,
     517,   582,   512,   176,  1019,   583,    -1,   517,   582,    44,
     176,  1019,   583,    -1,   517,   582,  1019,   176,  1019,   583,
      -1,   541,   582,   583,    -1,   571,   582,  1019,   583,    -1,
       7,   582,  1019,   584,  1019,   583,    -1,     7,   582,  1019,
     584,   219,  1019,  1099,   583,    -1,    91,  1018,    -1,    94,
    1018,    -1,    94,   582,  1019,   583,    -1,   100,   582,  1019,
     584,   219,  1019,  1099,   583,    -1,   101,   582,  1019,   584,
     219,  1019,  1099,   583,    -1,   159,   582,  1099,   176,  1019,
     583,    -1,   183,   582,  1101,   584,  1019,   583,    -1,   327,
    1018,    -1,   327,   582,  1019,   583,    -1,   370,   582,  1022,
     223,  1019,   583,    -1,   482,   582,  1019,   584,  1019,   583,
      -1,   482,   582,  1019,   584,   219,  1019,  1099,   583,    -1,
     486,   582,  1019,   584,  1019,   584,  1019,   583,    -1,   486,
     582,  1019,   584,  1019,   583,    -1,   486,   582,  1019,   176,
    1019,   173,  1019,   583,    -1,   486,   582,  1019,   176,  1019,
     583,    -1,   492,  1018,    -1,   492,   582,  1019,   583,    -1,
     505,   582,  1100,   584,  1019,   584,  1019,   583,    -1,   506,
     582,  1100,   584,  1019,   584,  1019,   583,    -1,   545,  1018,
      -1,   547,  1018,    -1,   546,  1018,    -1,    20,   582,  1019,
     583,    -1,    57,   582,  1019,   583,    -1,    64,   582,  1056,
     583,    -1,    67,   582,  1019,   583,    -1,    95,   582,   583,
      -1,   205,   582,  1019,   584,  1019,   584,  1019,   583,    -1,
     296,   582,  1019,   583,    -1,   306,   582,  1019,   584,  1019,
     583,    -1,   337,   582,  1019,   583,    -1,   363,   582,  1019,
     583,    -1,   383,   582,  1019,   583,    -1,   409,   582,  1019,
     584,  1019,   583,    -1,   410,   582,  1019,   584,  1019,   584,
    1019,   583,    -1,   519,   582,  1019,   584,  1019,   583,    -1,
     559,   582,  1019,   583,    -1,   559,   582,  1019,   584,  1019,
     583,    -1,  1033,    -1,    81,   582,  1019,   584,  1019,   583,
      -1,   181,   582,  1056,   583,    -1,   249,   582,  1056,   583,
      -1,   308,   582,  1056,   583,    -1,   309,   582,  1056,   583,
      -1,   310,   582,  1056,   583,    -1,   367,   582,  1019,   584,
    1019,   583,    -1,   368,   582,  1056,   583,    -1,    -1,  1281,
     582,  1035,  1039,   583,    -1,  1285,   589,  1285,   582,  1055,
     583,    -1,  1037,  1038,    -1,   223,    42,   303,    -1,    -1,
     223,   315,   235,   303,    -1,    -1,   563,   384,   156,    -1,
      -1,  1040,    -1,  1041,    -1,  1040,   584,  1041,    -1,  1014,
    1019,  1015,  1017,    -1,    27,   582,  1052,   583,    -1,    27,
     582,   125,  1052,   583,    -1,    36,   582,  1052,   583,    -1,
      37,   582,  1052,   583,    -1,    39,   582,  1052,   583,    -1,
      86,   582,  1104,   577,   583,    -1,    86,   582,  1052,   583,
      -1,    -1,    -1,    86,   582,   125,  1043,  1056,  1044,   583,
      -1,   302,   582,  1052,   583,    -1,   302,   582,   125,  1052,
     583,    -1,   286,   582,  1052,   583,    -1,   286,   582,   125,
    1052,   583,    -1,   477,   582,  1052,   583,    -1,   553,   582,
    1052,   583,    -1,   476,   582,  1052,   583,    -1,   555,   582,
    1052,   583,    -1,   487,   582,  1052,   583,    -1,   487,   582,
     125,  1052,   583,    -1,    -1,   188,   582,  1049,  1045,  1056,
    1051,  1050,   583,    -1,    -1,   588,  1047,  1048,    -1,  1287,
     443,  1019,    -1,  1287,    -1,   588,  1300,  1287,   906,    -1,
      -1,   125,    -1,    -1,   436,  1267,    -1,    -1,  1117,    -1,
      -1,  1104,  1053,  1019,    -1,    33,   862,    -1,    58,   862,
     878,    -1,   317,   862,    -1,   449,    -1,   449,   221,    -1,
     536,    -1,   536,   221,    -1,   102,    -1,   507,    -1,    99,
      -1,   110,   857,    -1,    -1,  1056,    -1,  1019,    -1,  1056,
     584,  1019,    -1,  1058,    -1,   582,  1058,   583,    -1,  1275,
      -1,  1058,   584,  1275,    -1,    -1,  1019,    -1,    -1,   135,
    1019,    -1,   560,  1019,   503,  1019,    -1,  1061,   560,  1019,
     503,  1019,    -1,  1075,    -1,  1066,    -1,  1065,    -1,  1062,
      -1,   586,  1285,  1062,   587,    -1,  1064,    -1,  1065,   584,
    1064,    -1,  1062,  1074,  1062,    -1,  1062,   480,  1075,    -1,
      -1,  1062,  1074,  1062,   338,  1067,  1019,    -1,    -1,  1062,
     480,  1075,   338,  1068,  1019,    -1,    -1,  1062,  1074,  1062,
     544,  1069,   582,  1098,   583,    -1,  1062,   315,   230,  1075,
      -1,    -1,  1062,   241,  1084,   230,  1062,   338,  1070,  1019,
      -1,    -1,  1062,   241,  1084,   230,  1075,  1071,   544,   582,
    1098,   583,    -1,  1062,   315,   241,  1084,   230,  1075,    -1,
      -1,  1062,   421,  1084,   230,  1062,   338,  1072,  1019,    -1,
      -1,  1062,   421,  1084,   230,  1075,  1073,   544,   582,  1098,
     583,    -1,  1062,   315,   421,  1084,   230,  1075,    -1,   230,
      -1,   212,   230,    -1,    89,   230,    -1,    -1,  1076,  1279,
    1103,  1093,    -1,  1083,  1082,  1079,    -1,   582,  1082,  1077,
    1363,   583,  1103,    -1,    -1,  1082,  1078,  1065,    -1,    -1,
      -1,  1080,  1008,  1012,  1081,   835,    -1,    -1,   434,    -1,
      -1,   351,    -1,    -1,   173,   230,    -1,   173,   348,    46,
      -1,   173,   187,    46,    -1,   171,    -1,   206,    -1,    -1,
    1086,   892,  1085,  1088,   582,  1097,   583,    -1,    -1,   543,
     892,  1085,  1089,   582,  1095,   583,    -1,  1087,    -1,  1090,
    1087,    -1,    -1,    -1,  1092,  1090,    -1,    -1,  1094,  1091,
      -1,    -1,  1097,    -1,  1285,    -1,   375,    -1,  1096,    -1,
    1097,   584,  1096,    -1,  1285,    -1,  1098,   584,  1285,    -1,
    1100,    -1,   103,    -1,   104,    -1,   105,    -1,   106,    -1,
     198,    -1,   199,    -1,   200,    -1,   296,    -1,   298,    -1,
     299,    -1,   431,    -1,   570,    -1,   107,    -1,   559,    -1,
     201,    -1,   175,    -1,   300,    -1,   307,    -1,   383,    -1,
     432,    -1,   571,    -1,   102,    -1,   507,    -1,    99,    -1,
     504,    -1,    -1,    18,    -1,   145,    -1,    -1,  1102,  1285,
      -1,    -1,    12,    -1,    -1,    -1,   561,  1106,  1019,    -1,
      -1,    -1,   192,  1108,  1019,    -1,   149,  1029,    -1,    -1,
      -1,   187,    46,  1111,  1112,    -1,  1111,   584,  1274,  1120,
      -1,  1274,  1120,    -1,    -1,   563,    90,    -1,   563,   423,
      -1,   348,    46,  1114,    -1,  1114,   584,  1115,    -1,  1115,
      -1,  1276,  1120,    -1,    -1,  1117,    -1,    -1,   348,    46,
    1118,  1119,    -1,  1119,   584,  1274,  1120,    -1,  1274,  1120,
      -1,    -1,    19,    -1,   117,    -1,    -1,  1123,    -1,    -1,
    1123,    -1,   246,  1124,    -1,  1125,    -1,  1125,   584,  1125,
      -1,  1125,   336,  1125,    -1,  1268,    -1,   523,    -1,   260,
      -1,   332,    -1,    -1,   246,  1125,    -1,   332,    -1,   194,
      -1,   260,    -1,   523,    -1,   109,    -1,   168,    -1,   332,
      -1,   194,    -1,   260,    -1,   523,    -1,  1131,    -1,   332,
      -1,   523,    -1,   260,    -1,   109,    -1,   168,    -1,   332,
      -1,   523,    -1,   260,    -1,  1131,    -1,  1132,    -1,   109,
      -1,   168,    -1,    -1,    -1,   377,  1285,  1134,   582,  1135,
     583,    -1,    -1,  1136,    -1,  1136,   584,  1137,    -1,  1137,
      -1,  1014,  1019,  1015,    -1,    -1,  1139,  1140,    -1,  1140,
     584,  1141,    -1,  1141,    -1,   588,  1287,    -1,  1287,    -1,
      -1,   220,  1143,  1144,    -1,    -1,   352,  1284,  1145,  1255,
    1258,    -1,   131,  1284,    -1,  1138,    -1,    -1,   128,  1147,
    1056,    -1,   129,  1155,  1310,  1154,  1150,   944,    -1,    -1,
     129,   924,   209,  1285,   338,  1279,  1149,    -1,   129,    95,
    1154,  1285,    -1,   129,   179,  1154,  1285,   589,  1285,    -1,
     129,   179,  1154,  1285,    -1,   129,   377,  1154,   634,    -1,
     129,   541,   633,  1340,    -1,   129,   556,  1154,  1150,   944,
      -1,   129,   151,  1154,   634,    -1,   129,   516,  1154,   634,
      -1,   129,   494,   748,   759,   760,    -1,   129,   256,   187,
     749,   759,   760,    -1,   129,   440,  1154,  1287,    -1,  1151,
      -1,  1150,   584,  1151,    -1,  1279,    -1,  1153,    -1,  1152,
     584,  1153,    -1,  1279,    -1,    -1,   205,   154,    -1,    -1,
     497,    -1,    -1,    -1,   216,  1157,  1162,   943,  1164,  1158,
    1166,  1182,    -1,    -1,    -1,   410,  1160,  1163,  1164,  1161,
    1166,    -1,    -1,   263,    -1,   114,    -1,   195,    -1,  1191,
      -1,   114,    -1,   220,  1165,    -1,  1165,    -1,  1151,    -1,
    1169,    -1,   582,   583,  1169,    -1,   582,  1168,   583,  1169,
      -1,    -1,   442,  1167,  1173,    -1,  1168,   584,  1272,    -1,
    1272,    -1,   548,  1172,    -1,   549,  1172,    -1,    -1,   813,
    1170,  1360,    -1,    -1,   582,   813,   583,  1171,  1363,    -1,
    1172,   584,  1177,    -1,  1177,    -1,  1173,   584,  1174,    -1,
    1174,    -1,  1276,  1175,  1181,    -1,   145,    -1,   443,    -1,
      -1,  1175,    -1,    -1,   582,  1178,  1179,   583,    -1,    -1,
    1180,    -1,  1180,   584,  1181,    -1,  1181,    -1,  1019,    -1,
     112,    -1,    -1,    -1,   338,   132,  1183,   233,   538,  1189,
      -1,    -1,    -1,   538,  1185,  1191,   943,  1063,   442,  1187,
    1186,  1105,  1116,  1126,    -1,  1187,   584,  1188,    -1,  1188,
      -1,  1276,  1175,  1181,    -1,  1189,   584,  1190,    -1,  1190,
      -1,  1276,  1175,  1181,    -1,    -1,   263,    -1,    -1,   116,
    1193,  1201,  1194,    -1,    -1,   176,  1279,  1195,  1105,  1116,
    1126,    -1,    -1,  1198,  1196,   176,  1063,  1105,    -1,    -1,
     176,  1152,  1197,   544,  1063,  1105,    -1,  1199,    -1,  1198,
     584,  1199,    -1,  1285,  1200,  1103,    -1,  1285,   589,  1285,
    1200,  1103,    -1,    -1,   589,   577,    -1,    -1,  1202,  1201,
      -1,   385,    -1,   263,    -1,   206,    -1,   519,  1204,  1151,
      -1,    -1,   496,    -1,    -1,  1206,    -1,  1207,    -1,  1206,
     584,  1207,    -1,    87,    -1,   294,    -1,    41,   224,    -1,
      82,   491,    -1,   356,   162,    -1,   225,    -1,   490,    -1,
     457,    -1,    12,    -1,    -1,   173,   384,   332,    -1,    -1,
     447,  1210,  1211,    -1,    96,  1221,    -1,  1217,   493,  1216,
    1221,    -1,  1217,   515,  1216,  1221,    -1,   150,  1216,  1221,
      -1,   496,   475,  1216,  1221,    -1,   342,   493,  1216,  1221,
      -1,  1217,   366,    -1,   365,    -1,   143,   831,  1213,    -1,
     143,    12,  1213,    -1,  1217,    68,  1218,  1279,  1216,  1221,
      -1,   321,   279,   173,   451,   563,   267,   145,  1282,    16,
     268,   145,  1129,    16,   271,   145,  1127,    -1,  1214,   257,
      -1,   451,   197,    -1,    -1,    34,   150,  1219,  1220,  1212,
    1121,    -1,   894,  1218,  1279,  1216,  1105,    -1,    69,   520,
      -1,   496,   520,    -1,  1215,   142,    -1,    23,    -1,    84,
      -1,   376,    -1,    86,   582,   577,   583,   558,    -1,    86,
     582,   577,   583,   147,    -1,   558,  1121,    -1,   147,  1121,
      -1,   381,    -1,   380,  1205,  1208,  1121,    -1,  1299,   475,
    1221,    -1,   213,   475,    -1,   311,   475,    -1,  1217,   379,
      -1,  1299,   552,  1221,    -1,   868,  1221,    -1,    67,  1221,
      -1,   186,    -1,   186,   173,  1288,    -1,    88,    95,   823,
    1285,    -1,    88,   496,  1279,    -1,    88,   556,  1279,    -1,
     279,   475,    -1,   451,   475,    -1,    88,   377,   634,    -1,
      88,   179,   634,    -1,    88,   516,   634,    -1,   377,   475,
    1221,    -1,   179,   475,  1221,    -1,   377,    65,   634,    -1,
     179,    65,   634,    -1,    88,   151,   634,    -1,   475,    -1,
     311,    -1,   257,    -1,   279,    -1,    33,    -1,    -1,   479,
      -1,    -1,  1218,  1285,    -1,    -1,   177,    -1,   176,    -1,
     223,    -1,    -1,   223,  1282,    -1,    -1,   176,  1129,    -1,
      -1,   245,  1282,    -1,   561,  1019,    -1,    -1,  1225,  1279,
    1223,  1227,    -1,    -1,  1225,  1226,  1224,   998,    -1,   117,
      -1,   118,    -1,    -1,   157,    -1,   361,    -1,    -1,  1267,
      -1,  1285,    -1,    -1,   170,   980,  1229,  1230,    -1,  1230,
     584,  1231,    -1,  1231,    -1,    -1,  1310,  1232,  1233,    -1,
     493,   563,   389,   255,    -1,   384,    48,    -1,   197,    -1,
     376,    -1,   257,    -1,   475,    -1,   451,    -1,   279,    -1,
     119,    -1,   414,    -1,    -1,  1150,    -1,    -1,   413,  1235,
    1236,    -1,  1236,   584,  1237,    -1,  1237,    -1,   451,    -1,
     279,    -1,   384,    48,    -1,    -1,   382,  1239,  1240,    -1,
    1214,   257,  1241,    -1,   511,  1282,    -1,    29,  1019,    -1,
     234,  1243,  1019,    -1,    -1,    78,    -1,   384,    -1,   543,
    1285,    -1,    -1,   251,    98,  1246,  1247,    -1,   251,   496,
    1279,   176,   279,    -1,    -1,    -1,    -1,    -1,  1253,  1252,
     210,  1284,  1248,  1254,   220,  1249,   496,  1279,  1250,   871,
    1251,  1255,  1258,  1261,  1262,  1265,    -1,   176,   279,    -1,
      -1,   252,    -1,    -1,    76,    -1,   263,    -1,    -1,   410,
      -1,   206,    -1,    -1,    68,  1256,    -1,  1256,  1257,    -1,
    1257,    -1,   499,    46,  1267,    -1,   346,   138,    46,  1267,
      -1,   138,    46,  1267,    -1,   148,    46,  1267,    -1,    -1,
     248,  1259,    -1,  1259,  1260,    -1,  1260,    -1,   499,    46,
    1267,    -1,   472,    46,  1267,    -1,    -1,   206,   332,   248,
      -1,    -1,   582,  1263,   583,    -1,   582,   583,    -1,  1263,
     584,  1264,    -1,  1264,    -1,  1276,    -1,   588,  1287,    -1,
      -1,   442,  1189,    -1,   500,    -1,   316,    -1,   526,   500,
      -1,  1266,  1283,    -1,  1283,    -1,   194,    -1,    35,    -1,
     357,    -1,  1270,    -1,   576,  1271,    -1,   575,  1271,    -1,
    1266,    -1,  1271,    -1,   331,    -1,   160,    -1,   518,    -1,
     194,    -1,    35,    -1,   526,   194,    -1,   526,    35,    -1,
     102,  1266,    -1,   507,  1266,    -1,   504,  1266,    -1,   332,
      -1,   260,    -1,   523,    -1,   109,    -1,   168,    -1,  1276,
      -1,  1273,    -1,  1285,   589,   577,    -1,  1285,   589,  1285,
     589,   577,    -1,  1019,    -1,  1285,    -1,  1277,    -1,  1285,
      -1,  1277,    -1,  1285,   589,  1285,    -1,   589,  1285,   589,
    1285,    -1,  1285,   589,  1285,   589,  1285,    -1,  1285,    -1,
    1285,   589,  1285,   589,  1285,    -1,  1285,   589,  1285,    -1,
     589,  1285,    -1,  1285,    -1,  1285,   589,  1285,    -1,   589,
    1285,    -1,  1285,    -1,   202,    -1,   204,    -1,   500,    -1,
     500,    -1,   500,    -1,  1281,    -1,   388,    -1,  1289,    -1,
    1281,    -1,  1290,    -1,  1285,    -1,  1282,    -1,   244,    -1,
    1287,    -1,  1287,   588,  1287,    -1,    92,  1018,    -1,  1290,
      -1,    20,    -1,    28,    -1,    30,    -1,    47,    -1,    48,
      -1,    57,    -1,    59,    -1,    63,    -1,    70,    -1,    72,
      -1,    81,    -1,   108,    -1,   128,    -1,   139,    -1,   153,
      -1,   170,    -1,   190,    -1,   193,    -1,   196,    -1,   218,
      -1,   235,    -1,   328,    -1,   342,    -1,   344,    -1,   354,
      -1,   358,    -1,   362,    -1,   369,    -1,   372,    -1,   404,
      -1,   407,    -1,   413,    -1,   415,    -1,   422,    -1,   429,
      -1,   433,    -1,   440,    -1,   449,    -1,   454,    -1,   451,
      -1,   455,    -1,   474,    -1,   478,    -1,   519,    -1,   530,
      -1,   531,    -1,   565,    -1,   568,    -1,   539,    -1,     5,
      -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,
      -1,    17,    -1,    22,    -1,    23,    -1,    25,    -1,    24,
      -1,    26,    -1,    27,    -1,    34,    -1,    38,    -1,    41,
      -1,    43,    -1,    42,    -1,    45,    -1,    51,    -1,    54,
      -1,    56,    -1,    61,    -1,    62,    -1,    64,    -1,    65,
      -1,    67,    -1,    68,    -1,   164,    -1,    71,    -1,    73,
      -1,    74,    -1,    75,    -1,    76,    -1,    78,    -1,    79,
      -1,    82,    -1,    84,    -1,    87,    -1,    90,    -1,    98,
      -1,    97,    -1,    99,    -1,   102,    -1,   107,    -1,   113,
      -1,   115,    -1,   119,    -1,   121,    -1,   122,    -1,   123,
      -1,   124,    -1,   131,    -1,   132,    -1,   133,    -1,   140,
      -1,   144,    -1,   143,    -1,   142,    -1,   147,    -1,   149,
      -1,   151,    -1,   150,    -1,   152,    -1,   156,    -1,   157,
      -1,   158,    -1,   162,    -1,   161,    -1,   174,    -1,   137,
      -1,   177,    -1,   165,    -1,   166,    -1,   167,    -1,   175,
      -1,   182,    -1,   181,    -1,   183,    -1,   186,    -1,   184,
      -1,   191,    -1,   197,    -1,   201,    -1,   203,    -1,   222,
      -1,   207,    -1,   208,    -1,   211,    -1,   224,    -1,   225,
      -1,   227,    -1,   228,    -1,   213,    -1,   217,    -1,   232,
      -1,   236,    -1,   239,    -1,   242,    -1,   243,    -1,   249,
      -1,   250,    -1,   252,    -1,   254,    -1,   256,    -1,   257,
      -1,   284,    -1,   279,    -1,   266,    -1,   270,    -1,   267,
      -1,   268,    -1,   280,    -1,   269,    -1,   271,    -1,   265,
      -1,   277,    -1,   273,    -1,   272,    -1,   274,    -1,   275,
      -1,   276,    -1,   282,    -1,   283,    -1,   285,    -1,   287,
      -1,   288,    -1,   289,    -1,   293,    -1,   294,    -1,   295,
      -1,   296,    -1,   297,    -1,   300,    -1,   301,    -1,   305,
      -1,   303,    -1,   307,    -1,   308,    -1,   309,    -1,   310,
      -1,   311,    -1,   313,    -1,   312,    -1,   314,    -1,   317,
      -1,   318,    -1,   322,    -1,   321,    -1,   329,    -1,   323,
      -1,   324,    -1,   334,    -1,   335,    -1,   336,    -1,   337,
      -1,   339,    -1,   340,    -1,   341,    -1,   355,    -1,   356,
      -1,   359,    -1,   360,    -1,   361,    -1,   363,    -1,   364,
      -1,   366,    -1,   365,    -1,   367,    -1,   368,    -1,   373,
      -1,   374,    -1,   376,    -1,   378,    -1,   379,    -1,   380,
      -1,   381,    -1,   383,    -1,   384,    -1,   385,    -1,   392,
      -1,   393,    -1,   395,    -1,   394,    -1,   396,    -1,   399,
      -1,   400,    -1,   401,    -1,   403,    -1,   406,    -1,   408,
      -1,   411,    -1,   414,    -1,   417,    -1,   418,    -1,   423,
      -1,   424,    -1,   425,    -1,   426,    -1,   427,    -1,   428,
      -1,   430,    -1,   432,    -1,   438,    -1,   437,    -1,   439,
      -1,   450,    -1,   444,    -1,   448,    -1,   453,    -1,   456,
      -1,   457,    -1,   465,    -1,   464,    -1,   467,    -1,   470,
      -1,   473,    -1,   475,    -1,   479,    -1,   481,    -1,   482,
      -1,   483,    -1,   485,    -1,   484,    -1,   488,    -1,   489,
      -1,   490,    -1,   491,    -1,   493,    -1,   494,    -1,   497,
      -1,   498,    -1,   501,    -1,   502,    -1,   513,    -1,   514,
      -1,   515,    -1,   504,    -1,   505,    -1,   506,    -1,   507,
      -1,   520,    -1,   521,    -1,   522,    -1,   179,    -1,   524,
      -1,   525,    -1,   528,    -1,   527,    -1,   534,    -1,   537,
      -1,   541,    -1,   542,    -1,   552,    -1,   556,    -1,   549,
      -1,   558,    -1,   557,    -1,   559,    -1,   564,    -1,   567,
      -1,   571,    -1,    -1,   442,  1293,  1292,  1294,    -1,    -1,
     345,    -1,  1295,    -1,  1294,   584,  1295,    -1,    -1,  1296,
    1301,    -1,  1298,    -1,   184,    -1,   252,    -1,   439,    -1,
      -1,   339,    -1,    -1,   184,    -1,   252,    -1,   439,    -1,
      -1,   184,   589,    -1,   252,   589,    -1,   439,   589,    -1,
    1302,    -1,  1298,  1303,    -1,  1297,  1304,  1175,  1307,    -1,
    1297,   513,   227,   243,  1305,    -1,   588,  1287,  1175,  1019,
      -1,   588,   588,  1300,  1304,  1175,  1307,    -1,   868,   873,
      -1,   312,  1175,  1019,    -1,   312,   870,   875,    -1,   363,
    1175,  1306,    -1,   363,   173,  1288,  1175,  1306,    -1,  1285,
      -1,  1285,   589,  1285,    -1,   112,   589,  1285,    -1,   389,
     524,    -1,   389,    71,    -1,   408,   389,    -1,   437,    -1,
     500,    -1,   363,   582,   500,   583,    -1,   337,   582,   500,
     583,    -1,  1019,    -1,   112,    -1,   338,    -1,    12,    -1,
      33,    -1,    -1,   255,  1310,  1309,  1311,    -1,   496,    -1,
     493,    -1,  1312,    -1,  1311,   584,  1312,    -1,  1279,  1103,
    1313,    -1,   389,    -1,   566,    -1,   263,   566,    -1,   389,
     252,    -1,    -1,   535,  1315,  1310,    -1,   190,  1279,   342,
    1103,    -1,   190,  1280,    63,    -1,    -1,   190,  1280,   389,
    1317,  1318,  1105,  1122,    -1,  1319,    -1,  1285,  1320,    -1,
     166,    -1,   322,    -1,   166,    -1,   322,    -1,   374,    -1,
     236,    -1,    -1,  1322,  1321,   582,  1180,   583,    -1,   145,
      -1,   180,    -1,   237,    -1,   189,    -1,   264,    -1,   420,
     633,  1324,    -1,  1328,   338,  1327,  1339,   176,  1341,    -1,
    1328,   338,   179,  1339,   176,  1341,    -1,  1328,   338,   377,
    1339,   176,  1341,    -1,    12,  1329,   584,   185,   345,   176,
    1341,    -1,   185,   633,  1326,    -1,  1328,   338,  1327,  1339,
     511,  1341,  1346,  1347,    -1,  1328,   338,   179,  1339,   511,
    1341,  1346,  1347,    -1,  1328,   338,   377,  1339,   511,  1341,
    1346,  1347,    -1,    -1,   496,    -1,  1330,    -1,    12,  1329,
      -1,    -1,   376,    -1,  1331,    -1,  1330,   584,  1331,    -1,
      -1,   434,  1332,  1343,    -1,    -1,   216,  1333,  1343,    -1,
      -1,   538,  1334,  1343,    -1,    -1,   397,  1335,  1343,    -1,
     116,    -1,   540,    -1,   209,    -1,    13,    -1,    88,    -1,
     129,    -1,   153,    -1,   403,    -1,   448,    -1,   378,    -1,
     165,    -1,   185,   345,    -1,   447,    96,    -1,   488,    -1,
      88,   497,   493,    -1,   255,   493,    -1,   411,   451,    -1,
     411,    62,    -1,    88,   556,    -1,   447,   556,    -1,    88,
     424,    -1,    13,   424,    -1,    88,   541,    -1,   151,    -1,
     516,    -1,    -1,    16,    -1,  1338,  1336,  1337,    -1,  1338,
      -1,   483,   500,    -1,   228,   500,    -1,    61,   500,    -1,
     577,    -1,  1285,   589,   577,    -1,   577,   589,   577,    -1,
    1279,    -1,  1288,    -1,  1340,   584,  1288,    -1,  1342,    -1,
    1341,   584,  1342,    -1,  1288,   203,    46,   500,    -1,  1288,
     203,    46,   363,   500,    -1,  1288,    -1,    -1,   582,  1344,
     583,    -1,  1344,   584,  1345,    -1,  1345,    -1,  1285,    -1,
      -1,   412,  1337,    -1,   412,   471,    -1,   412,   567,    -1,
     412,   324,    -1,    -1,   563,  1348,    -1,  1348,  1349,    -1,
    1349,    -1,   185,   345,    -1,   283,  1127,    -1,   287,  1127,
      -1,   282,  1127,    -1,   288,  1127,    -1,    -1,    30,  1351,
    1352,    -1,    -1,   564,    -1,    -1,    16,   328,    54,    -1,
      16,    54,    -1,    -1,   402,    -1,   328,   402,    -1,    -1,
     429,    -1,    72,  1352,  1353,  1354,    -1,   422,  1352,  1353,
    1354,    -1,   422,  1352,   511,  1355,  1285,    -1,   429,  1285,
      -1,   402,   429,  1285,    -1,    -1,  1361,    -1,    -1,   532,
    1367,  1362,   999,    -1,    -1,  1361,    -1,  1364,    -1,    -1,
    1365,  1366,    -1,  1117,  1121,    -1,  1123,    -1,    -1,   125,
      -1,    12,    -1,    -1,   434,  1370,  1001,  1368,  1371,    -1,
     582,  1370,  1000,  1368,  1371,   583,    -1,    -1,    -1,  1377,
    1373,    -1,  1376,  1374,    -1,  1378,  1375,  1382,    -1,  1382,
      -1,  1391,    -1,  1402,    -1,  1396,    -1,   620,    -1,  1382,
      -1,  1391,    -1,  1402,    -1,  1396,    -1,  1395,    -1,   620,
      -1,  1376,    -1,  1377,    -1,    -1,   113,   145,  1288,    -1,
    1379,    -1,  1379,  1380,    -1,  1380,    -1,   350,   410,    -1,
      11,   145,   525,    -1,    11,   145,   295,    -1,    11,   145,
     498,    -1,    -1,   469,   433,   113,    -1,   469,   433,   222,
      -1,    -1,    -1,  1381,   556,  1279,  1383,  1385,    18,  1384,
    1387,    -1,    -1,   582,  1386,   583,    -1,  1285,    -1,  1386,
     584,  1285,    -1,    -1,  1388,  1389,  1390,    -1,   434,  1001,
      -1,   582,  1000,   583,  1363,    -1,    -1,   563,    60,   345,
      -1,   563,    51,    60,   345,    -1,   563,   252,    60,   345,
      -1,    -1,    -1,    -1,   516,  1014,   634,   719,   720,   338,
    1014,  1392,  1279,   173,  1014,  1393,   134,   427,  1394,   669,
      -1,    10,  1014,   179,  1285,   418,   836,   455,  1282,    -1,
    1014,   179,  1285,   418,   836,   455,  1282,    -1,    -1,    -1,
      -1,    -1,    -1,  1014,   179,   634,   582,  1397,   645,   583,
    1398,   418,  1399,   847,  1400,   636,  1401,   669,    -1,    -1,
      -1,    -1,    -1,   377,  1014,   634,  1403,   582,  1404,   649,
     583,  1405,   636,  1406,   669,    -1,   568,  1409,  1408,  1410,
      -1,   568,   139,  1408,  1412,    -1,   568,   372,  1408,    -1,
     568,    72,  1408,  1411,    -1,   568,   422,  1408,    -1,   568,
     393,    -1,  1267,    -1,  1267,   584,  1267,    -1,  1267,   584,
    1267,   584,  1127,    -1,    30,    -1,   474,    -1,    -1,   230,
      -1,   417,    -1,    -1,   340,   364,    -1,    -1,    -1,   489,
    1413,  1414,    -1,    -1,   173,   297,    -1,   218,   366,  1285,
     455,  1282,    -1,   531,   366,  1285,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1350,  1350,  1364,  1368,  1369,  1374,  1375,  1376,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,  1384,  1385,  1386,  1387,
    1388,  1389,  1390,  1391,  1392,  1393,  1394,  1395,  1396,  1397,
    1398,  1399,  1400,  1401,  1402,  1403,  1404,  1405,  1406,  1407,
    1408,  1409,  1410,  1411,  1412,  1413,  1414,  1415,  1416,  1417,
    1418,  1419,  1420,  1421,  1422,  1423,  1424,  1428,  1438,  1439,
    1443,  1453,  1460,  1471,  1470,  1481,  1483,  1487,  1488,  1492,
    1505,  1504,  1524,  1523,  1534,  1535,  1539,  1543,  1547,  1551,
    1555,  1559,  1564,  1568,  1572,  1576,  1580,  1584,  1589,  1593,
    1597,  1613,  1617,  1629,  1628,  1663,  1661,  1691,  1690,  1703,
    1702,  1710,  1714,  1718,  1722,  1729,  1742,  1743,  1747,  1751,
    1755,  1759,  1763,  1767,  1771,  1783,  1778,  1829,  1828,  1835,
    1842,  1843,  1848,  1853,  1862,  1865,  1871,  1873,  1880,  1881,
    1885,  1891,  1900,  1901,  1909,  1909,  1967,  1968,  1969,  1970,
    1971,  1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1984,
    1998,  2012,  2030,  2031,  2035,  2036,  2041,  2043,  2045,  2047,
    2049,  2051,  2053,  2059,  2060,  2061,  2065,  2069,  2077,  2076,
    2089,  2091,  2094,  2096,  2100,  2104,  2111,  2113,  2117,  2118,
    2123,  2142,  2168,  2170,  2174,  2175,  2179,  2205,  2206,  2207,
    2208,  2212,  2213,  2217,  2218,  2223,  2226,  2253,  2252,  2308,
    2323,  2322,  2366,  2390,  2390,  2412,  2413,  2418,  2420,  2425,
    2448,  2454,  2469,  2470,  2474,  2478,  2487,  2492,  2497,  2505,
    2520,  2538,  2539,  2543,  2544,  2545,  2546,  2547,  2548,  2549,
    2550,  2551,  2552,  2553,  2554,  2555,  2560,  2559,  2566,  2566,
    2619,  2618,  2644,  2644,  2658,  2711,  2752,  2771,  2770,  2790,
    2807,  2809,  2810,  2814,  2834,  2857,  2859,  2873,  2857,  2891,
    2893,  2894,  2898,  2899,  2904,  2910,  2903,  2929,  2928,  2944,
    2945,  2949,  2950,  2955,  2959,  2954,  2976,  2980,  2975,  2995,
    3003,  3008,  3007,  3043,  3044,  3049,  3048,  3081,  3081,  3096,
    3095,  3122,  3133,  3135,  3132,  3159,  3158,  3176,  3178,  3183,
    3185,  3187,  3204,  3209,  3215,  3222,  3223,  3231,  3237,  3246,
    3252,  3258,  3259,  3263,  3263,  3268,  3269,  3270,  3274,  3275,
    3276,  3280,  3284,  3285,  3286,  3290,  3291,  3292,  3293,  3294,
    3295,  3296,  3297,  3301,  3305,  3306,  3307,  3311,  3312,  3313,
    3314,  3315,  3319,  3323,  3324,  3325,  3329,  3330,  3331,  3332,
    3333,  3334,  3335,  3339,  3343,  3344,  3345,  3349,  3350,  3351,
    3356,  3364,  3372,  3380,  3390,  3400,  3405,  3410,  3418,  3426,
    3434,  3442,  3450,  3458,  3466,  3479,  3492,  3505,  3507,  3511,
    3516,  3529,  3530,  3581,  3582,  3585,  3594,  3606,  3611,  3609,
    3616,  3618,  3617,  3621,  3620,  3650,  3651,  3656,  3655,  3688,
    3687,  3704,  3708,  3715,  3714,  3718,  3717,  3721,  3720,  3726,
    3727,  3732,  3733,  3737,  3738,  3742,  3753,  3765,  3778,  3779,
    3795,  3797,  3796,  3801,  3799,  3810,  3811,  3815,  3826,  3842,
    3843,  3859,  3860,  3883,  3884,  3889,  3888,  3913,  3924,  3944,
    3959,  3977,  3989,  4005,  4006,  4010,  4020,  4021,  4025,  4042,
    4101,  4109,  4136,  4137,  4142,  4141,  4162,  4167,  4168,  4172,
    4173,  4177,  4179,  4185,  4187,  4189,  4191,  4193,  4195,  4205,
    4221,  4204,  4235,  4236,  4240,  4241,  4245,  4246,  4250,  4251,
    4255,  4256,  4260,  4261,  4265,  4269,  4270,  4273,  4275,  4279,
    4280,  4284,  4285,  4286,  4290,  4295,  4302,  4307,  4312,  4317,
    4322,  4327,  4332,  4347,  4353,  4358,  4363,  4369,  4384,  4385,
    4386,  4391,  4396,  4401,  4403,  4408,  4413,  4418,  4424,  4429,
    4438,  4456,  4473,  4496,  4510,  4511,  4512,  4515,  4516,  4517,
    4518,  4519,  4520,  4521,  4525,  4526,  4527,  4531,  4532,  4536,
    4537,  4538,  4539,  4543,  4544,  4548,  4549,  4553,  4554,  4561,
    4574,  4584,  4604,  4608,  4614,  4616,  4620,  4624,  4625,  4629,
    4634,  4633,  4659,  4660,  4661,  4662,  4667,  4672,  4677,  4682,
    4687,  4692,  4698,  4704,  4710,  4716,  4721,  4727,  4733,  4735,
    4737,  4739,  4752,  4754,  4759,  4764,  4776,  4781,  4786,  4791,
    4793,  4795,  4797,  4799,  4801,  4803,  4805,  4808,  4807,  4812,
    4811,  4815,  4817,  4826,  4827,  4828,  4833,  4834,  4835,  4836,
    4837,  4841,  4845,  4846,  4850,  4851,  4855,  4856,  4857,  4858,
    4859,  4863,  4864,  4865,  4866,  4867,  4871,  4876,  4878,  4884,
    4885,  4887,  4892,  4901,  4902,  4906,  4907,  4911,  4912,  4913,
    4917,  4918,  4922,  4923,  4927,  4928,  4932,  4933,  4937,  4938,
    4943,  4948,  4953,  4958,  4959,  4964,  4966,  4967,  4973,  4979,
    4985,  4991,  4992,  5008,  5010,  5015,  5016,  5020,  5028,  5032,
    5033,  5037,  5038,  5042,  5051,  5055,  5056,  5060,  5071,  5072,
    5076,  5077,  5081,  5082,  5086,  5087,  5088,  5089,  5098,  5099,
    5103,  5104,  5108,  5109,  5110,  5119,  5122,  5124,  5129,  5128,
    5141,  5142,  5146,  5147,  5151,  5152,  5156,  5157,  5161,  5162,
    5163,  5164,  5165,  5169,  5170,  5171,  5172,  5173,  5177,  5178,
    5179,  5192,  5193,  5197,  5198,  5202,  5203,  5207,  5208,  5209,
    5213,  5214,  5215,  5216,  5229,  5241,  5242,  5246,  5247,  5251,
    5252,  5256,  5257,  5261,  5262,  5264,  5277,  5278,  5279,  5283,
    5284,  5288,  5289,  5301,  5302,  5306,  5307,  5311,  5312,  5320,
    5319,  5347,  5346,  5360,  5372,  5371,  5390,  5389,  5408,  5407,
    5426,  5420,  5444,  5439,  5493,  5498,  5503,  5508,  5513,  5523,
    5524,  5525,  5526,  5530,  5531,  5543,  5544,  5548,  5549,  5552,
    5554,  5555,  5556,  5558,  5560,  5561,  5570,  5571,  5575,  5584,
    5582,  5591,  5600,  5599,  5608,  5606,  5615,  5622,  5627,  5630,
    5634,  5641,  5648,  5652,  5657,  5656,  5672,  5674,  5679,  5688,
    5687,  5703,  5707,  5706,  5718,  5719,  5723,  5738,  5739,  5743,
    5752,  5753,  5757,  5762,  5761,  5769,  5780,  5768,  5793,  5800,
    5804,  5811,  5818,  5824,  5830,  5836,  5843,  5862,  5883,  5888,
    5892,  5900,  5901,  5905,  5906,  5910,  5911,  5912,  5916,  5917,
    5922,  5930,  5931,  5932,  5933,  5942,  5941,  5952,  5960,  5959,
    5969,  5978,  5987,  5988,  5995,  5995,  6001,  6002,  6006,  6007,
    6008,  6012,  6013,  6029,  6030,  6035,  6034,  6046,  6045,  6057,
    6056,  6066,  6067,  6068,  6073,  6072,  6084,  6085,  6089,  6090,
    6094,  6095,  6096,  6101,  6100,  6112,  6121,  6120,  6137,  6138,
    6142,  6143,  6147,  6148,  6149,  6150,  6151,  6152,  6157,  6156,
    6168,  6169,  6170,  6175,  6174,  6180,  6187,  6192,  6200,  6201,
    6205,  6218,  6227,  6228,  6232,  6241,  6242,  6247,  6246,  6256,
    6257,  6261,  6270,  6270,  6281,  6282,  6287,  6288,  6297,  6306,
    6307,  6311,  6341,  6346,  6345,  6365,  6373,  6365,  6380,  6381,
    6382,  6383,  6384,  6388,  6395,  6402,  6404,  6415,  6416,  6420,
    6421,  6427,  6428,  6429,  6430,  6436,  6442,  6448,  6462,  6465,
    6467,  6473,  6483,  6484,  6485,  6498,  6524,  6532,  6540,  6541,
    6545,  6546,  6547,  6548,  6549,  6553,  6554,  6559,  6608,  6613,
    6654,  6656,  6658,  6660,  6662,  6664,  6666,  6668,  6672,  6674,
    6676,  6678,  6680,  6682,  6686,  6690,  6696,  6700,  6706,  6710,
    6718,  6720,  6726,  6731,  6733,  6735,  6736,  6738,  6742,  6744,
    6746,  6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,  6764,
    6766,  6768,  6770,  6774,  6775,  6779,  6780,  6784,  6785,  6789,
    6790,  6794,  6795,  6796,  6797,  6798,  6799,  6803,  6804,  6808,
    6809,  6810,  6811,  6812,  6813,  6821,  6822,  6823,  6824,  6825,
    6827,  6828,  6830,  6832,  6834,  6838,  6839,  6844,  6849,  6853,
    6854,  6861,  6866,  6874,  6876,  6883,  6885,  6897,  6902,  6914,
    6916,  6918,  6924,  6926,  6928,  6930,  6932,  6941,  6949,  6951,
    6953,  6955,  6957,  6959,  6961,  6963,  6965,  6967,  6969,  6971,
    6973,  6975,  6977,  6979,  6981,  6987,  7004,  7009,  7011,  7016,
    7021,  7026,  7028,  7030,  7032,  7034,  7039,  7044,  7046,  7051,
    7053,  7055,  7057,  7059,  7061,  7069,  7077,  7079,  7081,  7086,
    7091,  7104,  7106,  7108,  7110,  7112,  7117,  7119,  7121,  7123,
    7125,  7135,  7137,  7139,  7141,  7143,  7152,  7154,  7167,  7173,
    7180,  7187,  7194,  7201,  7208,  7210,  7230,  7229,  7297,  7329,
    7331,  7336,  7337,  7341,  7342,  7346,  7347,  7351,  7356,  7364,
    7384,  7386,  7388,  7390,  7392,  7394,  7396,  7399,  7401,  7398,
    7404,  7411,  7413,  7415,  7417,  7419,  7421,  7423,  7425,  7427,
    7430,  7429,  7445,  7444,  7459,  7465,  7471,  7484,  7485,  7490,
    7493,  7498,  7501,  7513,  7512,  7529,  7531,  7533,  7535,  7537,
    7539,  7541,  7543,  7545,  7547,  7549,  7554,  7555,  7559,  7564,
    7572,  7573,  7577,  7582,  7590,  7591,  7595,  7596,  7600,  7606,
    7616,  7617,  7626,  7637,  7638,  7643,  7644,  7664,  7666,  7670,
    7668,  7685,  7683,  7701,  7699,  7706,  7715,  7713,  7731,  7730,
    7740,  7751,  7749,  7768,  7767,  7778,  7789,  7790,  7791,  7796,
    7796,  7809,  7831,  7876,  7875,  7898,  7915,  7898,  7922,  7926,
    7952,  7953,  7958,  7962,  7963,  7964,  7968,  7969,  7974,  7973,
    7979,  7978,  7986,  7987,  7990,  7992,  7992,  7996,  7996,  8001,
    8002,  8006,  8008,  8013,  8014,  8018,  8026,  8036,  8037,  8038,
    8039,  8040,  8041,  8042,  8043,  8044,  8045,  8046,  8047,  8048,
    8052,  8053,  8054,  8055,  8056,  8057,  8058,  8059,  8060,  8064,
    8065,  8066,  8067,  8070,  8072,  8073,  8077,  8078,  8082,  8084,
    8088,  8090,  8089,  8103,  8106,  8105,  8120,  8126,  8138,  8140,
    8144,  8146,  8151,  8152,  8165,  8183,  8187,  8188,  8192,  8205,
    8207,  8212,  8211,  8246,  8248,  8253,  8254,  8255,  8260,  8266,
    8270,  8271,  8275,  8279,  8286,  8293,  8303,  8307,  8308,  8309,
    8314,  8318,  8327,  8328,  8329,  8330,  8331,  8332,  8336,  8337,
    8338,  8339,  8340,  8344,  8345,  8346,  8347,  8348,  8352,  8353,
    8354,  8355,  8359,  8364,  8365,  8368,  8371,  8370,  8399,  8400,
    8404,  8405,  8409,  8421,  8421,  8431,  8432,  8436,  8448,  8481,
    8480,  8493,  8492,  8501,  8513,  8525,  8524,  8541,  8548,  8548,
    8561,  8568,  8584,  8603,  8615,  8619,  8625,  8631,  8638,  8643,
    8648,  8658,  8659,  8663,  8671,  8672,  8676,  8686,  8687,  8691,
    8692,  8700,  8710,  8699,  8720,  8727,  8719,  8737,  8749,  8750,
    8751,  8755,  8756,  8760,  8761,  8765,  8774,  8775,  8776,  8778,
    8777,  8788,  8789,  8793,  8794,  8796,  8795,  8799,  8798,  8804,
    8805,  8809,  8810,  8814,  8824,  8825,  8829,  8830,  8835,  8834,
    8848,  8849,  8853,  8858,  8866,  8867,  8870,  8872,  8872,  8880,
    8889,  8879,  8911,  8912,  8916,  8924,  8925,  8929,  8939,  8940,
    8947,  8946,  8960,  8959,  8968,  8967,  8975,  8974,  8984,  8985,
    8989,  8997,  9009,  9010,  9014,  9015,  9019,  9020,  9021,  9025,
    9035,  9037,  9040,  9042,  9045,  9046,  9049,  9053,  9057,  9061,
    9065,  9069,  9073,  9077,  9081,  9089,  9092,  9102,  9101,  9115,
    9122,  9130,  9138,  9146,  9154,  9162,  9170,  9177,  9179,  9181,
    9190,  9203,  9207,  9212,  9211,  9216,  9225,  9230,  9238,  9245,
    9250,  9255,  9260,  9262,  9264,  9266,  9268,  9270,  9277,  9285,
    9297,  9309,  9311,  9319,  9326,  9333,  9343,  9350,  9356,  9365,
    9373,  9377,  9381,  9388,  9395,  9401,  9410,  9419,  9429,  9439,
    9447,  9449,  9451,  9456,  9457,  9460,  9462,  9466,  9467,  9471,
    9472,  9476,  9477,  9481,  9482,  9486,  9487,  9490,  9492,  9497,
    9508,  9507,  9521,  9520,  9530,  9531,  9535,  9536,  9537,  9541,
    9542,  9543,  9556,  9555,  9567,  9568,  9573,  9572,  9575,  9577,
    9579,  9581,  9583,  9585,  9587,  9589,  9591,  9593,  9598,  9599,
    9604,  9603,  9613,  9614,  9618,  9619,  9620,  9625,  9624,  9635,
    9639,  9643,  9655,  9665,  9666,  9667,  9673,  9685,  9684,  9699,
    9717,  9728,  9735,  9745,  9716,  9749,  9759,  9760,  9764,  9765,
    9777,  9781,  9782,  9783,  9786,  9788,  9792,  9793,  9797,  9802,
    9809,  9814,  9821,  9823,  9827,  9828,  9832,  9837,  9844,  9846,
    9854,  9855,  9856,  9860,  9862,  9867,  9868,  9873,  9874,  9880,
    9898,  9906,  9911,  9930,  9936,  9947,  9960,  9981,  9982,  9983,
    9991,  9992,  9993,  9998,  9999, 10000, 10001, 10002, 10022, 10041,
   10042, 10043, 10047, 10052, 10057, 10059, 10067, 10082, 10083, 10087,
   10093, 10104, 10108, 10145, 10149, 10157, 10161, 10229, 10244, 10268,
   10269, 10285, 10295, 10299, 10300, 10301, 10305, 10313, 10314, 10340,
   10353, 10366, 10379, 10380, 10386, 10395, 10396, 10405, 10406, 10407,
   10411, 10425, 10439, 10454, 10455, 10456, 10457, 10458, 10459, 10460,
   10461, 10462, 10463, 10464, 10465, 10466, 10467, 10468, 10469, 10470,
   10471, 10472, 10473, 10474, 10475, 10476, 10477, 10478, 10479, 10480,
   10481, 10482, 10483, 10484, 10485, 10486, 10487, 10488, 10489, 10490,
   10491, 10492, 10493, 10494, 10495, 10496, 10497, 10498, 10499, 10500,
   10501, 10502, 10503, 10513, 10514, 10515, 10516, 10517, 10518, 10519,
   10520, 10521, 10522, 10523, 10524, 10525, 10526, 10527, 10528, 10529,
   10530, 10531, 10532, 10533, 10534, 10535, 10536, 10537, 10538, 10539,
   10540, 10541, 10542, 10543, 10544, 10545, 10546, 10547, 10548, 10549,
   10550, 10551, 10552, 10553, 10554, 10555, 10556, 10557, 10558, 10559,
   10560, 10561, 10562, 10563, 10564, 10565, 10566, 10567, 10568, 10569,
   10570, 10571, 10572, 10573, 10574, 10575, 10576, 10577, 10578, 10579,
   10580, 10581, 10582, 10583, 10584, 10585, 10586, 10587, 10588, 10589,
   10590, 10591, 10592, 10593, 10594, 10595, 10596, 10597, 10598, 10599,
   10600, 10601, 10602, 10603, 10604, 10605, 10606, 10607, 10608, 10609,
   10610, 10611, 10612, 10613, 10614, 10615, 10616, 10617, 10618, 10619,
   10620, 10621, 10622, 10623, 10624, 10625, 10626, 10627, 10628, 10629,
   10630, 10631, 10632, 10633, 10634, 10635, 10636, 10637, 10638, 10639,
   10640, 10641, 10642, 10643, 10644, 10645, 10646, 10647, 10648, 10649,
   10650, 10651, 10652, 10653, 10654, 10655, 10656, 10657, 10658, 10659,
   10660, 10661, 10662, 10663, 10664, 10665, 10666, 10667, 10668, 10669,
   10670, 10671, 10672, 10673, 10674, 10675, 10676, 10677, 10678, 10679,
   10680, 10681, 10682, 10683, 10684, 10685, 10686, 10687, 10688, 10689,
   10690, 10691, 10692, 10693, 10694, 10695, 10696, 10697, 10698, 10699,
   10700, 10701, 10702, 10703, 10704, 10705, 10706, 10707, 10708, 10709,
   10710, 10711, 10712, 10713, 10714, 10715, 10716, 10717, 10718, 10719,
   10720, 10721, 10722, 10723, 10724, 10725, 10726, 10727, 10728, 10729,
   10730, 10731, 10732, 10733, 10734, 10735, 10736, 10737, 10738, 10739,
   10740, 10741, 10742, 10743, 10744, 10745, 10746, 10747, 10748, 10749,
   10750, 10751, 10752, 10753, 10754, 10755, 10756, 10757, 10758, 10759,
   10760, 10761, 10762, 10763, 10764, 10765, 10766, 10767, 10768, 10769,
   10770, 10771, 10772, 10773, 10774, 10781, 10780, 10795, 10796, 10800,
   10801, 10805, 10805, 10885, 10886, 10887, 10888, 10892, 10893, 10897,
   10898, 10899, 10900, 10904, 10905, 10906, 10907, 10911, 10912, 10916,
   10997, 11009, 11013, 11018, 11025, 11040, 11053, 11077, 11087, 11119,
   11162, 11176, 11177, 11178, 11179, 11183, 11184, 11191, 11200, 11201,
   11202, 11203, 11204, 11211, 11210, 11226, 11227, 11231, 11232, 11236,
   11244, 11245, 11246, 11247, 11252, 11251, 11271, 11283, 11296, 11295,
   11318, 11319, 11323, 11324, 11328, 11329, 11330, 11331, 11333, 11332,
   11345, 11346, 11347, 11348, 11349, 11355, 11360, 11366, 11377, 11388,
   11395, 11400, 11407, 11419, 11433, 11435, 11439, 11440, 11447, 11449,
   11453, 11454, 11459, 11458, 11462, 11461, 11465, 11464, 11468, 11467,
   11470, 11471, 11472, 11473, 11474, 11475, 11476, 11477, 11478, 11479,
   11480, 11481, 11482, 11483, 11484, 11485, 11486, 11487, 11488, 11489,
   11490, 11491, 11492, 11493, 11494, 11498, 11499, 11503, 11504, 11508,
   11518, 11528, 11541, 11556, 11569, 11582, 11594, 11599, 11607, 11612,
   11620, 11645, 11647, 11653, 11657, 11661, 11662, 11666, 11686, 11688,
   11692, 11696, 11700, 11707, 11708, 11712, 11713, 11717, 11718, 11724,
   11730, 11736, 11746, 11745, 11755, 11756, 11761, 11762, 11763, 11768,
   11769, 11770, 11774, 11775, 11779, 11789, 11796, 11806, 11815, 11829,
   11830, 11835, 11834, 11869, 11870, 11871, 11875, 11875, 11899, 11900,
   11904, 11905, 11906, 11910, 11915, 11920, 11927, 11948, 11971, 11973,
   11975, 11980, 11981, 11982, 11983, 11984, 11988, 11989, 11990, 11991,
   11992, 11993, 12003, 12004, 12009, 12022, 12035, 12037, 12039, 12044,
   12049, 12051, 12053, 12059, 12060, 12062, 12068, 12077, 12067, 12101,
   12102, 12106, 12111, 12119, 12119, 12143, 12144, 12149, 12150, 12152,
   12154, 12172, 12181, 12189, 12165, 12260, 12278, 12303, 12340, 12348,
   12356, 12379, 12299, 12446, 12475, 12487, 12496, 12445, 12524, 12528,
   12532, 12536, 12540, 12544, 12551, 12558, 12565, 12575, 12576, 12580,
   12581, 12582, 12586, 12587, 12592, 12594, 12593, 12599, 12600, 12604,
   12614
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CHAIN_SYM", "CHANGE",
  "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM",
  "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM",
  "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM", "COMMENT_SYM",
  "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM",
  "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM",
  "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM", "CONTEXT_SYM",
  "CONTINUE_SYM", "CONTRIBUTORS_SYM", "CONVERT_SYM", "COUNT_SYM",
  "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER",
  "CURSOR_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM", "DELAYED_SYM",
  "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP",
  "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM",
  "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EVENT_SYM",
  "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM", "EXPANSION_SYM",
  "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM",
  "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "COLUMN_FORMAT_SYM", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM", "FRAC_SECOND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE",
  "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM",
  "GRANT", "GRANTS", "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM",
  "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM",
  "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT",
  "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM",
  "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM",
  "INVOKER_SYM", "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION",
  "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE",
  "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM", "MICROSECOND_SYM",
  "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM",
  "MINUTE_SYM", "MIN_ROWS", "MIN_SYM", "MODE_SYM", "MODIFIES_SYM",
  "MODIFY_SYM", "MOD_SYM", "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT",
  "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFLINE_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM",
  "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARTIAL", "PARTITIONING_SYM",
  "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD", "PHASE_SYM",
  "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON", "PORT_SYM",
  "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM",
  "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS", "PROCESSLIST_SYM",
  "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR",
  "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM",
  "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SECOND_MICROSECOND_SYM",
  "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM",
  "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM",
  "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM",
  "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES", "VALUE_SYM", "VARBINARY",
  "VARCHAR", "VARIABLES", "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM",
  "VIEW_SYM", "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM",
  "XA_SYM", "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'",
  "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','",
  "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'", "$accept", "query",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "@1", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "@2", "change", "@3",
  "master_defs", "master_def", "master_file_def", "create", "@4", "@5",
  "@6", "@7", "server_def", "server_options_list", "server_option",
  "event_tail", "@8", "ev_schedule_time", "@9", "opt_ev_status",
  "ev_starts", "ev_ends", "opt_ev_on_completion", "ev_on_completion",
  "opt_ev_comment", "ev_sql_stmt", "@10", "ev_sql_stmt_inner",
  "clear_privileges", "sp_name", "sp_a_chistics", "sp_c_chistics",
  "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@11",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@12", "@13", "sp_cursor_stmt",
  "@14", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "sp_proc_stmt_if", "@15", "sp_proc_stmt_statement",
  "@16", "sp_proc_stmt_return", "@17", "sp_proc_stmt_unlabeled", "@18",
  "sp_proc_stmt_leave", "sp_proc_stmt_iterate", "sp_proc_stmt_open",
  "sp_proc_stmt_fetch", "@19", "sp_proc_stmt_close", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@20", "@21", "@22", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@23", "@24",
  "searched_case_stmt", "@25", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@26", "@27",
  "searched_when_clause", "@28", "@29", "else_clause_opt",
  "sp_labeled_control", "@30", "sp_opt_label", "sp_labeled_block", "@31",
  "sp_unlabeled_block", "@32", "sp_block_content", "@33",
  "sp_unlabeled_control", "@34", "@35", "@36", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "@37", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "@38", "create3", "@39", "@40", "opt_partitioning",
  "partitioning", "@41", "partition_entry", "@42", "partition",
  "part_type_def", "@43", "@44", "@45", "opt_linear", "part_field_list",
  "part_field_item_list", "part_field_item", "part_func", "sub_part_func",
  "opt_no_parts", "opt_sub_part", "@46", "@47", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_no_subparts", "part_defs",
  "part_def_list", "part_definition", "@48", "part_name",
  "opt_part_values", "part_func_max", "max_value_sym", "part_range_func",
  "part_list_func", "part_list_item", "part_bit_expr", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "@49", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "@50", "@51", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "column_format_types", "row_types", "merge_insert_types",
  "opt_select_from", "udf_type", "field_list", "field_list_item",
  "column_def", "key_def", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "@52", "type", "@53",
  "@54", "spatial_type", "char", "nchar", "varchar", "nvarchar",
  "int_type", "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "opt_len", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@55", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext",
  "init_key_options", "key_alg", "key_options", "key_opts",
  "key_using_alg", "key_opt", "btree_or_rtree", "key_list", "key_part",
  "opt_ident", "opt_component", "string_list", "alter", "@56", "@57",
  "@58", "@59", "@60", "@61", "@62", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "@63", "@64", "@65", "build_method",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "@66", "add_part_extra", "reorg_partition_rule", "@67",
  "reorg_parts_rule", "@68", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "@69", "@70", "@71",
  "opt_column", "opt_ignore", "opt_restrict", "opt_place", "opt_to",
  "slave", "@72", "@73", "start", "start_transaction_opts",
  "slave_thread_opts", "@74", "slave_thread_opt_list", "slave_thread_opt",
  "slave_until", "slave_until_opts", "restore", "@75", "backup", "@76",
  "checksum", "@77", "opt_checksum_type", "repair", "@78",
  "opt_mi_repair_type", "mi_repair_types", "mi_repair_type", "analyze",
  "@79", "binlog_base64_event", "check", "@80", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "@81",
  "opt_no_write_to_binlog", "rename", "@82", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@83", "preload_list",
  "preload_keys", "cache_keys_spec", "@84", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@85", "select_part2", "@86", "@87", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@88", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "@89", "@90", "@91", "variable",
  "@92", "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "in_sum_expr", "@93", "cast_type", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "@94", "@95", "@96", "@97", "@98",
  "@99", "@100", "normal_join", "table_factor", "@101", "select_derived",
  "@102", "select_derived2", "@103", "@104", "get_select_lex",
  "select_derived_init", "opt_outer", "index_hint_clause",
  "index_hint_type", "index_hint_definition", "@105", "@106",
  "index_hints_list", "opt_index_hints_list", "@107", "opt_key_definition",
  "@108", "opt_key_usage_list", "key_usage_element", "key_usage_list",
  "using_list", "interval", "interval_time_st", "date_time_type",
  "table_alias", "opt_table_alias", "opt_all", "where_clause", "@109",
  "having_clause", "@110", "opt_escape", "group_clause", "group_list",
  "olap_opt", "alter_order_clause", "alter_order_list", "alter_order_item",
  "opt_order_clause", "order_clause", "@111", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_clause", "@112", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@113",
  "select_var_list", "select_var_ident", "into", "@114",
  "into_destination", "@115", "do", "@116", "drop", "@117", "table_list",
  "table_name", "table_alias_ref_list", "table_alias_ref", "if_exists",
  "opt_temporary", "insert", "@118", "@119", "replace", "@120", "@121",
  "insert_lock_option", "replace_lock_option", "insert2", "insert_table",
  "insert_field_spec", "@122", "fields", "insert_values", "@123", "@124",
  "values_list", "ident_eq_list", "ident_eq_value", "equal", "opt_equal",
  "no_braces", "@125", "opt_values", "values", "expr_or_default",
  "opt_insert_update", "@126", "update", "@127", "@128", "update_list",
  "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@129", "single_multi", "@130", "@131",
  "@132", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@133", "show_param", "@134", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@135", "@136",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@137", "flush_options", "flush_option", "@138",
  "opt_table_list", "reset", "@139", "reset_options", "reset_option",
  "purge", "@140", "purge_options", "purge_option", "kill", "kill_option",
  "use", "load", "@141", "load_data", "@142", "@143", "@144", "@145",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_ignore_lines", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "@146",
  "opt_option", "option_value_list", "option_type_value", "@147",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "@148", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "@149",
  "handler", "@150", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "@151", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "@152", "@153", "@154", "@155", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "@156", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@157", "union_opt",
  "union_order_or_limit", "@158", "order_or_limit", "union_option",
  "take_first_select", "subselect", "subselect_start", "subselect_end",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "@159",
  "@160", "view_list_opt", "view_list", "view_select", "@161",
  "view_select_aux", "view_check_option", "trigger_tail", "@162", "@163",
  "@164", "udf_tail", "sf_tail", "@165", "@166", "@167", "@168", "@169",
  "sp_tail", "@170", "@171", "@172", "@173", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@174",
  "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    64,    46,
      59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   592,   593,   593,   594,   594,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   595,   595,   595,
     595,   595,   595,   595,   595,   595,   595,   596,   597,   597,
     598,   599,   599,   601,   600,   602,   602,   603,   603,   604,
     606,   605,   608,   607,   609,   609,   610,   610,   610,   610,
     610,   610,   610,   610,   610,   610,   610,   610,   610,   611,
     611,   611,   611,   613,   612,   614,   612,   615,   612,   616,
     612,   612,   612,   612,   612,   617,   618,   618,   619,   619,
     619,   619,   619,   619,   619,   621,   620,   623,   622,   622,
     624,   624,   624,   624,   625,   625,   626,   626,   627,   627,
     628,   628,   629,   629,   631,   630,   632,   632,   632,   632,
     632,   632,   632,   632,   632,   632,   632,   632,   632,   633,
     634,   634,   635,   635,   636,   636,   637,   637,   637,   637,
     637,   637,   637,   638,   638,   638,   639,   639,   641,   640,
     642,   642,   643,   643,   644,   644,   645,   645,   646,   646,
     647,   648,   649,   649,   650,   650,   651,   652,   652,   652,
     652,   653,   653,   654,   654,   655,   655,   657,   656,   656,
     658,   656,   656,   660,   659,   661,   661,   662,   662,   663,
     664,   664,   665,   665,   666,   666,   666,   666,   666,   667,
     667,   668,   668,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   671,   670,   673,   672,
     675,   674,   677,   676,   678,   679,   680,   682,   681,   683,
     684,   684,   684,   685,   685,   687,   688,   689,   686,   690,
     690,   690,   691,   691,   693,   694,   692,   696,   695,   697,
     697,   698,   698,   700,   701,   699,   703,   704,   702,   705,
     705,   707,   706,   708,   708,   710,   709,   712,   711,   714,
     713,   715,   716,   717,   715,   718,   715,   719,   719,   720,
     720,   720,   721,   722,   723,   724,   724,   725,   725,   726,
     727,   728,   728,   730,   729,   731,   731,   731,   732,   732,
     732,   733,   734,   734,   734,   735,   735,   735,   735,   735,
     735,   735,   735,   736,   737,   737,   737,   738,   738,   738,
     738,   738,   739,   740,   740,   740,   741,   741,   741,   741,
     741,   741,   741,   742,   743,   743,   743,   744,   744,   744,
     745,   746,   747,   748,   749,   750,   750,   750,   751,   752,
     753,   754,   755,   756,   757,   758,   759,   760,   760,   761,
     761,   762,   762,   763,   763,   763,   763,   764,   765,   764,
     766,   767,   766,   768,   766,   769,   769,   771,   770,   773,
     772,   774,   775,   776,   775,   777,   775,   778,   775,   779,
     779,   780,   780,   781,   781,   782,   783,   784,   785,   785,
     786,   787,   786,   788,   786,   789,   789,   790,   791,   792,
     792,   793,   793,   794,   794,   796,   795,   797,   798,   798,
     798,   799,   799,   800,   800,   801,   802,   802,   803,   804,
     805,   805,   806,   806,   808,   807,   809,   810,   810,   811,
     811,   812,   812,   812,   812,   812,   812,   812,   812,   814,
     815,   813,   816,   816,   817,   817,   818,   818,   819,   819,
     820,   820,   821,   821,   822,   823,   823,   824,   824,   825,
     825,   826,   826,   826,   827,   827,   827,   827,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   827,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   827,   827,   827,
     828,   829,   830,   831,   832,   832,   832,   833,   833,   833,
     833,   833,   833,   833,   834,   834,   834,   835,   835,   836,
     836,   836,   836,   837,   837,   838,   838,   839,   839,   840,
     840,   840,   840,   840,   841,   841,   842,   843,   843,   844,
     846,   845,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   848,   847,   849,
     847,   847,   847,   850,   850,   850,   850,   850,   850,   850,
     850,   851,   852,   852,   853,   853,   854,   854,   854,   854,
     854,   855,   855,   855,   855,   855,   856,   856,   856,   857,
     857,   857,   858,   859,   859,   860,   860,   861,   861,   861,
     862,   862,   863,   863,   864,   864,   865,   865,   866,   866,
     866,   866,   866,   866,   866,   866,   866,   866,   866,   866,
     866,   866,   866,   867,   867,   868,   868,   869,   869,   870,
     870,   871,   871,   872,   872,   873,   873,   874,   875,   875,
     876,   876,   877,   877,   878,   878,   878,   878,   878,   878,
     879,   879,   880,   880,   880,   880,   881,   881,   883,   882,
     884,   884,   885,   885,   886,   886,   887,   887,   888,   888,
     888,   888,   888,   889,   889,   889,   889,   889,   890,   890,
     890,   891,   891,   892,   892,   893,   893,   894,   894,   894,
     895,   895,   895,   895,   896,   897,   897,   898,   898,   899,
     899,   900,   900,   901,   901,   901,   902,   902,   902,   903,
     903,   904,   904,   905,   905,   906,   906,   907,   907,   909,
     908,   910,   908,   908,   911,   908,   912,   908,   913,   908,
     914,   908,   915,   908,   908,   908,   908,   908,   908,   916,
     916,   916,   916,   917,   917,   918,   918,   919,   919,   920,
     920,   920,   920,   920,   920,   920,   920,   920,   920,   921,
     920,   920,   922,   920,   923,   920,   920,   920,   924,   924,
     924,   925,   926,   926,   928,   927,   929,   929,   929,   931,
     930,   932,   933,   932,   934,   934,   935,   936,   936,   937,
     938,   938,   938,   939,   938,   940,   941,   938,   938,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   942,   942,   943,   943,   944,   944,   944,   945,   945,
     945,   946,   946,   946,   946,   948,   947,   947,   949,   947,
     947,   950,   951,   951,   953,   952,   954,   954,   955,   955,
     955,   956,   956,   957,   957,   959,   958,   961,   960,   963,
     962,   964,   964,   964,   966,   965,   967,   967,   968,   968,
     969,   969,   969,   971,   970,   972,   974,   973,   975,   975,
     976,   976,   977,   977,   977,   977,   977,   977,   979,   978,
     980,   980,   980,   982,   981,   981,   983,   983,   984,   984,
     985,   986,   987,   987,   988,   989,   989,   991,   990,   992,
     992,   993,   995,   994,   996,   996,   997,   997,   998,   999,
     999,  1000,  1000,  1002,  1001,  1004,  1005,  1003,  1006,  1006,
    1006,  1006,  1006,  1007,  1007,  1008,  1008,  1009,  1009,  1010,
    1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1011,
    1011,  1011,  1012,  1012,  1012,  1013,  1014,  1015,  1016,  1016,
    1017,  1017,  1017,  1017,  1017,  1018,  1018,  1019,  1019,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1020,  1020,
    1020,  1020,  1020,  1020,  1021,  1021,  1021,  1021,  1021,  1021,
    1021,  1021,  1021,  1021,  1021,  1021,  1021,  1021,  1022,  1022,
    1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,
    1022,  1022,  1022,  1023,  1023,  1024,  1024,  1025,  1025,  1026,
    1026,  1027,  1027,  1027,  1027,  1027,  1027,  1028,  1028,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1030,
    1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,
    1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,  1030,
    1030,  1030,  1030,  1030,  1030,  1030,  1031,  1031,  1031,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1032,  1032,  1032,  1032,  1032,  1032,  1032,  1032,  1032,
    1032,  1032,  1032,  1032,  1032,  1032,  1032,  1032,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1035,  1034,  1034,  1036,
    1036,  1037,  1037,  1038,  1038,  1039,  1039,  1040,  1040,  1041,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1043,  1044,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1045,  1042,  1047,  1046,  1048,  1048,  1048,  1049,  1049,  1050,
    1050,  1051,  1051,  1053,  1052,  1054,  1054,  1054,  1054,  1054,
    1054,  1054,  1054,  1054,  1054,  1054,  1055,  1055,  1056,  1056,
    1057,  1057,  1058,  1058,  1059,  1059,  1060,  1060,  1061,  1061,
    1062,  1062,  1063,  1064,  1064,  1065,  1065,  1066,  1066,  1067,
    1066,  1068,  1066,  1069,  1066,  1066,  1070,  1066,  1071,  1066,
    1066,  1072,  1066,  1073,  1066,  1066,  1074,  1074,  1074,  1076,
    1075,  1075,  1075,  1078,  1077,  1080,  1081,  1079,  1082,  1083,
    1084,  1084,  1085,  1085,  1085,  1085,  1086,  1086,  1088,  1087,
    1089,  1087,  1090,  1090,  1091,  1092,  1091,  1094,  1093,  1095,
    1095,  1096,  1096,  1097,  1097,  1098,  1098,  1099,  1099,  1099,
    1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,  1099,
    1100,  1100,  1100,  1100,  1100,  1100,  1100,  1100,  1100,  1101,
    1101,  1101,  1101,  1102,  1102,  1102,  1103,  1103,  1104,  1104,
    1105,  1106,  1105,  1107,  1108,  1107,  1109,  1109,  1110,  1110,
    1111,  1111,  1112,  1112,  1112,  1113,  1114,  1114,  1115,  1116,
    1116,  1118,  1117,  1119,  1119,  1120,  1120,  1120,  1121,  1121,
    1122,  1122,  1123,  1124,  1124,  1124,  1125,  1125,  1125,  1125,
    1126,  1126,  1127,  1127,  1127,  1127,  1127,  1127,  1128,  1128,
    1128,  1128,  1128,  1129,  1129,  1129,  1129,  1129,  1130,  1130,
    1130,  1130,  1131,  1132,  1132,  1133,  1134,  1133,  1135,  1135,
    1136,  1136,  1137,  1139,  1138,  1140,  1140,  1141,  1141,  1143,
    1142,  1145,  1144,  1144,  1144,  1147,  1146,  1148,  1149,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1150,  1150,  1151,  1152,  1152,  1153,  1154,  1154,  1155,
    1155,  1157,  1158,  1156,  1160,  1161,  1159,  1162,  1162,  1162,
    1162,  1163,  1163,  1164,  1164,  1165,  1166,  1166,  1166,  1167,
    1166,  1168,  1168,  1169,  1169,  1170,  1169,  1171,  1169,  1172,
    1172,  1173,  1173,  1174,  1175,  1175,  1176,  1176,  1178,  1177,
    1179,  1179,  1180,  1180,  1181,  1181,  1182,  1183,  1182,  1185,
    1186,  1184,  1187,  1187,  1188,  1189,  1189,  1190,  1191,  1191,
    1193,  1192,  1195,  1194,  1196,  1194,  1197,  1194,  1198,  1198,
    1199,  1199,  1200,  1200,  1201,  1201,  1202,  1202,  1202,  1203,
    1204,  1204,  1205,  1205,  1206,  1206,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1208,  1208,  1210,  1209,  1211,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,
    1211,  1211,  1211,  1212,  1211,  1211,  1211,  1211,  1211,  1211,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,
    1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,  1211,
    1213,  1213,  1213,  1214,  1214,  1215,  1215,  1216,  1216,  1217,
    1217,  1218,  1218,  1219,  1219,  1220,  1220,  1221,  1221,  1221,
    1223,  1222,  1224,  1222,  1225,  1225,  1226,  1226,  1226,  1227,
    1227,  1227,  1229,  1228,  1230,  1230,  1232,  1231,  1231,  1231,
    1231,  1231,  1231,  1231,  1231,  1231,  1231,  1231,  1233,  1233,
    1235,  1234,  1236,  1236,  1237,  1237,  1237,  1239,  1238,  1240,
    1241,  1241,  1242,  1243,  1243,  1243,  1244,  1246,  1245,  1245,
    1248,  1249,  1250,  1251,  1247,  1247,  1252,  1252,  1253,  1253,
    1253,  1254,  1254,  1254,  1255,  1255,  1256,  1256,  1257,  1257,
    1257,  1257,  1258,  1258,  1259,  1259,  1260,  1260,  1261,  1261,
    1262,  1262,  1262,  1263,  1263,  1264,  1264,  1265,  1265,  1266,
    1266,  1266,  1266,  1267,  1267,  1267,  1268,  1269,  1269,  1269,
    1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,
    1270,  1270,  1271,  1271,  1271,  1271,  1271,  1272,  1272,  1273,
    1273,  1274,  1275,  1275,  1276,  1276,  1277,  1277,  1277,  1278,
    1278,  1278,  1278,  1279,  1279,  1279,  1280,  1281,  1281,  1282,
    1283,  1284,  1285,  1285,  1285,  1286,  1286,  1287,  1287,  1287,
    1288,  1288,  1288,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1292,  1291,  1293,  1293,  1294,
    1294,  1296,  1295,  1297,  1297,  1297,  1297,  1298,  1298,  1299,
    1299,  1299,  1299,  1300,  1300,  1300,  1300,  1301,  1301,  1302,
    1302,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1304,  1304,
    1304,  1305,  1305,  1305,  1305,  1306,  1306,  1306,  1307,  1307,
    1307,  1307,  1307,  1309,  1308,  1310,  1310,  1311,  1311,  1312,
    1313,  1313,  1313,  1313,  1315,  1314,  1316,  1316,  1317,  1316,
    1318,  1318,  1319,  1319,  1320,  1320,  1320,  1320,  1321,  1320,
    1322,  1322,  1322,  1322,  1322,  1323,  1324,  1324,  1324,  1324,
    1325,  1326,  1326,  1326,  1327,  1327,  1328,  1328,  1329,  1329,
    1330,  1330,  1332,  1331,  1333,  1331,  1334,  1331,  1335,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1336,  1336,  1337,  1337,  1338,
    1338,  1338,  1339,  1339,  1339,  1339,  1340,  1340,  1341,  1341,
    1342,  1342,  1342,  1343,  1343,  1344,  1344,  1345,  1346,  1346,
    1346,  1346,  1346,  1347,  1347,  1348,  1348,  1349,  1349,  1349,
    1349,  1349,  1351,  1350,  1352,  1352,  1353,  1353,  1353,  1354,
    1354,  1354,  1355,  1355,  1356,  1357,  1357,  1358,  1359,  1360,
    1360,  1362,  1361,  1363,  1363,  1363,  1365,  1364,  1366,  1366,
    1367,  1367,  1367,  1368,  1369,  1369,  1370,  1371,  1372,  1372,
    1372,  1373,  1373,  1373,  1373,  1373,  1374,  1374,  1374,  1374,
    1374,  1374,  1375,  1375,  1376,  1377,  1378,  1378,  1378,  1379,
    1380,  1380,  1380,  1381,  1381,  1381,  1383,  1384,  1382,  1385,
    1385,  1386,  1386,  1388,  1387,  1389,  1389,  1390,  1390,  1390,
    1390,  1392,  1393,  1394,  1391,  1395,  1395,  1397,  1398,  1399,
    1400,  1401,  1396,  1403,  1404,  1405,  1406,  1402,  1407,  1407,
    1407,  1407,  1407,  1407,  1408,  1408,  1408,  1409,  1409,  1410,
    1410,  1410,  1411,  1411,  1412,  1413,  1412,  1414,  1414,  1415,
    1416
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     3,
       3,     3,     3,     0,     7,     0,    13,     0,     6,     0,
       3,     4,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    12,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     3,     0,     1,     1,     1,     1,     2,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     0,     2,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     3,     2,     4,     5,     0,     5,
       0,     0,     5,     0,     7,     0,     1,     0,     3,     0,
       3,     5,     5,     0,     4,     0,     3,     0,     3,     0,
       1,     0,     1,     1,     3,     1,     5,     5,     0,     2,
       0,     0,     7,     0,     9,     1,     3,     1,     1,     0,
       2,     0,     3,     1,     3,     0,     6,     1,     0,     4,
       5,     1,     1,     1,     3,     3,     1,     3,     1,     1,
       0,     3,     1,     3,     0,     4,     1,     0,     1,     2,
       1,     3,     4,     3,     3,     3,     4,     4,     3,     0,
       0,     6,     0,     1,     0,     1,     1,     2,     1,     1,
       0,     1,     1,     2,     1,     0,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     5,     1,     1,
       3,     4,     4,     2,     2,     2,     2,     3,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     3,     1,     1,     2,     2,     7,
       8,     8,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     4,     3,     3,     3,     1,     4,     1,     1,     5,
       2,     5,     2,     4,     1,     5,     5,     4,     3,     1,
       1,     2,     1,     1,     2,     1,     1,     1,     2,     3,
       2,     3,     2,     2,     3,     3,     3,     0,     6,     0,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     2,     1,     2,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       3,     1,     5,     0,     1,     2,     1,     1,     1,     1,
       0,     3,     0,     1,     0,     1,     2,     1,     1,     2,
       2,     2,     2,     2,     2,     4,     1,     3,     2,     1,
       2,     2,     2,     2,     1,     2,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     0,     1,     0,     2,     1,     2,     3,     2,
       0,     1,     0,     1,     1,     2,     0,     1,     0,     4,
       1,     4,     3,     1,     0,     1,     2,     1,     3,     3,
       2,     2,     2,     1,     1,     2,     2,     2,     1,     2,
       2,     2,     2,     1,     1,     0,     1,     1,     1,     1,
       0,     1,     1,     1,     0,     1,     2,     0,     1,     1,
       2,     2,     2,     1,     3,     3,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     0,     2,     1,     3,     0,
       7,     0,     5,     7,     0,     5,     0,     5,     0,     5,
       0,     4,     0,    10,     3,     4,     3,     3,     7,     0,
       3,     1,     4,     0,     3,     0,     2,     0,     1,     0,
       2,     2,     2,     2,     1,     1,     1,     3,     4,     0,
       6,     4,     0,     5,     0,     6,     4,     1,     0,     1,
       1,     2,     1,     1,     0,     5,     0,     3,     2,     0,
       5,     0,     0,     6,     1,     3,     1,     1,     3,     2,
       3,     2,     4,     0,     6,     0,     0,     8,     4,     4,
       3,     3,     2,     2,     6,     5,     3,     5,     1,     1,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     2,
       1,     0,     1,     1,     1,     0,     5,     3,     0,     5,
       3,     3,     0,     3,     0,     2,     1,     3,     0,     1,
       1,     0,     2,     1,     3,     0,     6,     0,     6,     0,
       5,     0,     1,     1,     0,     6,     0,     1,     1,     2,
       1,     1,     1,     0,     5,     2,     0,     5,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     0,     5,
       0,     1,     1,     0,     4,     4,     3,     5,     1,     3,
       3,     5,     1,     3,     2,     1,     1,     0,     6,     1,
       3,     3,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     0,     3,     0,     0,     6,     2,     1,
       1,     2,     2,     8,     4,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     4,     0,     0,     1,     1,
       0,     2,     2,     1,     1,     0,     2,     3,     3,     3,
       2,     3,     4,     3,     4,     3,     4,     1,     3,     4,
       3,     3,     6,     1,     5,     6,     5,     7,     6,     8,
       5,     6,     4,     4,     5,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     5,     5,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     1,     3,
       2,     2,     2,     2,     3,     3,     5,     6,     4,     4,
       7,     2,     6,     5,     6,     6,     4,     4,     5,     4,
       6,     2,     4,     4,     4,    10,     6,     8,     6,     4,
       4,     6,     4,     4,     4,     6,     4,     7,     7,     7,
       6,     6,     6,     6,     3,     4,     6,     8,     2,     2,
       4,     8,     8,     6,     6,     2,     4,     6,     6,     8,
       8,     6,     8,     6,     2,     4,     8,     8,     2,     2,
       2,     4,     4,     4,     4,     3,     8,     4,     6,     4,
       4,     4,     6,     8,     6,     4,     6,     1,     6,     4,
       4,     4,     4,     4,     6,     4,     0,     5,     6,     2,
       3,     0,     4,     0,     3,     0,     1,     1,     3,     4,
       4,     5,     4,     4,     4,     5,     4,     0,     0,     7,
       4,     5,     4,     5,     4,     4,     4,     4,     4,     5,
       0,     8,     0,     3,     3,     1,     4,     0,     1,     0,
       2,     0,     1,     0,     3,     2,     3,     2,     1,     2,
       1,     2,     1,     1,     1,     2,     0,     1,     1,     3,
       1,     3,     1,     3,     0,     1,     0,     2,     4,     5,
       1,     1,     1,     1,     4,     1,     3,     3,     3,     0,
       6,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     2,     0,
       4,     3,     6,     0,     3,     0,     0,     5,     0,     1,
       0,     1,     0,     2,     3,     3,     1,     1,     0,     7,
       0,     7,     1,     2,     0,     0,     2,     0,     2,     0,
       1,     1,     1,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     0,     2,     0,     1,
       0,     0,     3,     0,     0,     3,     2,     0,     0,     4,
       4,     2,     0,     2,     2,     3,     3,     1,     2,     0,
       1,     0,     4,     4,     2,     0,     1,     1,     0,     1,
       0,     1,     2,     1,     3,     3,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     0,     6,     0,     1,
       3,     1,     3,     0,     2,     3,     1,     2,     1,     0,
       3,     0,     5,     2,     1,     0,     3,     6,     0,     7,
       4,     6,     4,     4,     4,     5,     4,     4,     5,     6,
       4,     1,     3,     1,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     6,     0,     5,     0,     6,     1,     3,
       3,     5,     0,     2,     0,     2,     1,     1,     1,     3,
       0,     1,     0,     1,     1,     3,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     0,     3,     0,     3,     2,
       4,     4,     3,     4,     4,     2,     1,     3,     3,     6,
      16,     2,     2,     0,     6,     5,     2,     2,     2,     1,
       1,     1,     5,     5,     2,     2,     1,     4,     3,     2,
       2,     2,     3,     2,     2,     1,     3,     4,     3,     3,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     0,     1,     0,     2,     0,
       1,     1,     1,     0,     2,     0,     2,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     0,     1,     1,     0,
       1,     1,     0,     4,     3,     1,     0,     3,     4,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     3,     3,     1,     1,     1,     2,     0,     3,     3,
       2,     2,     3,     0,     1,     1,     2,     0,     4,     5,
       0,     0,     0,     0,    18,     2,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     3,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     0,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     1,     2,     4,
       5,     4,     6,     2,     3,     3,     3,     5,     1,     3,
       3,     2,     2,     2,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     3,     3,
       1,     1,     2,     2,     0,     3,     4,     3,     0,     7,
       1,     2,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     1,     1,     1,     1,     3,     6,     6,     6,     7,
       3,     8,     8,     8,     0,     1,     1,     2,     0,     1,
       1,     3,     0,     3,     0,     3,     0,     3,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     1,     1,     0,     1,     3,     1,     2,
       2,     2,     1,     3,     3,     1,     1,     3,     1,     3,
       4,     5,     1,     0,     3,     3,     1,     1,     0,     2,
       2,     2,     2,     0,     2,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     2,     2,     1,
       0,     1,     1,     0,     5,     6,     0,     0,     2,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     1,     2,     1,     2,
       3,     3,     3,     0,     3,     3,     0,     0,     8,     0,
       3,     1,     3,     0,     3,     2,     4,     0,     3,     4,
       4,     0,     0,     0,    16,     8,     7,     0,     0,     0,
       0,     0,    15,     0,     0,     0,     0,    12,     4,     4,
       3,     4,     3,     2,     1,     3,     5,     1,     1,     0,
       1,     1,     0,     2,     0,     0,     3,     0,     2,     5,
       3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,  2304,   920,     0,  2252,     0,     0,     0,     0,     0,
       0,  2254,    99,    58,  1510,  1624,  1625,  1425,  1449,     2,
       0,   920,   149,     0,    70,  1451,     0,  1663,     0,     0,
     920,   399,     0,  1657,     0,     0,   920,  1454,  1650,     0,
     149,  2254,     0,   955,  2087,  1547,     0,     0,     0,  1530,
       0,  2144,  1499,     0,     0,     0,     0,     0,     4,    16,
       0,    35,    21,    25,    11,    15,    10,    33,     6,    49,
      50,    42,     8,    13,    39,     7,     9,    12,    31,    38,
      32,    34,    46,   948,    19,    20,    26,    40,    54,    17,
      51,    48,    18,  1626,    22,    41,    36,    28,    55,    29,
      47,    30,    53,    24,    43,    23,     5,    14,    44,    45,
      37,    56,    27,    52,     0,   787,     0,     0,     0,   810,
     809,     0,     0,     0,   853,   770,  2302,  2303,  2304,   922,
     921,     0,  2136,  2135,   887,  2254,  1759,   905,     0,  1823,
    1824,  1825,  1826,  1827,  1828,  1829,  1774,  1830,  1831,  1833,
    1832,  1834,  1835,  1775,  1776,  1836,  1837,  1838,  1840,  1839,
    1841,  1777,  1778,  1842,  1843,  1844,  1779,  1780,  1845,  1846,
    1781,  1847,  1848,  1849,  1850,  1782,  1852,  1783,  1853,  1854,
    1855,  1856,  1857,  1858,  1784,  1859,  1860,  1861,  1862,  1864,
    1863,  1865,  1866,  1867,  1785,  1868,  1869,  1870,  1871,  1872,
    1873,  1874,  1786,  1875,  1876,  1877,  1893,  1787,  1878,  1881,
    1880,  1879,  1882,  1883,  1885,  1884,  1886,  1788,  1887,  1888,
    1889,  1891,  1890,  1851,  1895,  1896,  1897,  1789,  1892,  1898,
    1894,  2067,  1900,  1899,  1901,  1903,  1902,  1790,  1904,  1791,
    1792,  1905,  1906,  1757,  1907,  1758,  1909,  1910,  1911,  1916,
    1917,  1793,  1908,  1912,  1913,  1914,  1915,  1918,  1794,  1919,
    1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1938,
    1931,  1933,  1934,  1936,  1932,  1937,  1941,  1940,  1942,  1943,
    1944,  1939,  1930,  1935,  1945,  1946,  1929,  1947,  1948,  1949,
    1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1959,  1958,
    1960,  1961,  1962,  1963,  1964,  1966,  1965,  1967,  1968,  1969,
    1971,  1970,  1973,  1974,  1795,  1972,  1975,  1976,  1977,  1978,
    1979,  1980,  1981,  1796,  1797,  1798,  1982,  1983,  1799,  1984,
    1985,  1986,  1800,  1987,  1988,  1990,  1989,  1991,  1992,  1801,
    1802,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,  2001,
    2002,  1763,  2003,  2004,  2006,  2005,  2007,  2008,  2009,  2010,
    2011,  1803,  2012,  1804,  2013,  2014,  1805,  2015,  1806,  2016,
    2017,  1807,  2018,  2019,  2020,  2021,  2022,  2023,  1808,  2024,
    2025,  1809,  2027,  2026,  2028,  1810,  2030,  2031,  1811,  2029,
    1813,  2032,  1812,  1814,  2033,  2034,  2036,  2035,  2037,  2038,
    2039,  1815,  2040,  1816,  2041,  2042,  2043,  2044,  2046,  2045,
    2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,  2056,
    2060,  2061,  2062,  2063,  2057,  2058,  2059,  1817,  2064,  2065,
    2066,  2068,  2069,  2071,  2070,  1818,  1819,  2072,  2073,  1822,
    2074,  2075,  2078,  2076,  2077,  2080,  2079,  2081,  2082,  1820,
    2083,  1821,  2084,   168,  1762,   151,  1764,  1773,     0,   889,
     906,  2255,  2256,   485,     0,     0,     0,   484,   149,  2304,
     104,     0,   481,   482,   730,  1524,     0,  1447,  1447,  1447,
       0,  1447,  1447,     0,  1450,  1447,   149,  1447,     0,     0,
      63,  1632,     0,     0,     0,     0,  1756,     0,  1457,     0,
    1664,  1665,     0,  1667,     0,     0,  2133,     0,     0,     0,
       0,     0,   149,   923,     0,  1508,     0,   885,     0,  2256,
    2267,   949,   953,   965,  2088,  2085,  1609,   874,   874,   874,
     872,   874,  1531,     0,     0,     0,  1508,  1666,  2357,     0,
       0,     0,  2353,     0,  2358,     0,   955,     0,     0,     1,
       3,     0,  1888,  1986,  1622,  1620,  1753,     0,   761,   788,
       0,   766,     0,   764,  1769,  1768,  1767,     0,   777,   776,
     774,     0,   363,   854,     0,     0,  2313,   768,   903,     0,
    2253,     0,   932,   942,   170,     0,    72,     0,     0,     0,
    2259,     0,     0,     0,     0,   103,     0,     0,     0,   100,
     986,   986,  2304,  2306,  2308,   485,   483,   732,   733,   731,
       0,  1528,  1527,  1526,     0,  1524,  1824,  1774,  1835,     0,
    1726,     0,     0,     0,  1234,     0,  1779,     0,  1847,  1849,
    1784,     0,     0,   995,   995,   995,     0,     0,     0,  1866,
    1867,  1735,     0,     0,     0,  1723,  1736,  1900,  1901,     0,
    1725,  1906,     0,     0,     0,     0,  1923,  1733,     0,     0,
    1954,  1956,     0,     0,  1960,  1961,  1962,  1963,  1710,  1050,
       0,   995,  1722,  1732,  1978,  1716,  1987,  1991,  1992,     0,
    2000,     0,     0,     0,  2022,  2025,     0,     0,  2043,     0,
       0,   995,  1709,  2060,  2061,  2062,  2063,     0,  1724,  1817,
    1734,     0,  2074,   995,   995,   995,     0,     0,     0,  2081,
    2084,     0,     0,     0,     0,  1049,     0,  1202,     0,  1228,
    1007,  1013,  1027,     0,  1042,  1060,  1061,  1063,  1157,  1062,
    1068,  1067,  1426,  1720,  1066,  1065,  1721,  1059,  1743,  1762,
    1742,     0,     0,     0,     0,     0,     0,     0,  1605,     0,
       0,     0,     0,  1447,    65,     0,  2178,  2193,  2194,  2190,
    2195,  2213,  2196,  2200,     0,  2192,  2184,     0,  2199,  2188,
    2197,     0,  2182,     0,  2198,  2203,  2214,  2186,  2191,  2170,
       0,  2176,  2180,  1755,  1333,  2147,  2148,     0,    71,  1459,
    1460,  1458,   853,     0,  1662,  1678,     0,     0,     0,   918,
     409,   400,     0,  1604,  1603,     0,  1658,  2268,     0,     0,
     894,  1462,  1509,     0,  1461,  1655,     0,  1654,  1651,  1653,
       0,  2178,  2165,     0,  2262,  2259,  2269,   978,   971,   970,
     973,   974,   977,   975,   976,   972,   969,   986,   966,   968,
    2091,  1569,     0,   666,     0,  1617,     0,  1570,     0,     0,
    1617,     0,  1368,  1607,  1610,     0,  2100,  1585,   729,   728,
       0,   727,  2101,  1603,     0,     0,     0,  1556,  1571,     0,
    1532,  1576,  2102,     0,  1606,     0,  1368,  1617,     0,  1548,
       0,     0,     0,     0,   868,   878,   870,   865,     0,   871,
     867,  1529,  1443,  2370,  2145,   853,  1715,  1714,  1760,  2354,
    1713,  2362,  2364,  2350,  2352,  2359,   951,     0,  2273,    57,
       0,  1629,  2311,  2312,  2310,   682,     0,   995,  1770,  2305,
     152,   775,     0,   364,   152,     0,     0,     0,     0,     0,
     365,   366,   302,     0,   772,     0,     0,   771,  2313,     0,
       0,  1441,     0,     0,   934,   944,   172,   169,   150,     0,
     891,   908,  2258,     0,     0,  2260,  2264,  1048,  1047,     0,
      97,   102,     0,     0,     0,  2232,   101,  2228,  2309,   986,
     485,   986,   986,  2301,     0,  2289,  2296,  2297,  2300,  2299,
    2298,  2295,     0,  2288,  2291,  2292,  2294,  2293,  2313,  2307,
       0,     0,     0,  1511,  1514,  1518,  1522,  1525,     0,     0,
    1338,  1081,  1338,  1338,  1338,  1235,     0,     0,     0,     0,
       0,     0,     0,     0,  1338,     0,  1118,  1091,     0,  1119,
       0,     0,     0,     0,     0,  1729,     0,     0,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1230,  1232,  1742,  1338,     0,     0,  1338,     0,
       0,     0,     0,     0,  1000,     0,  1125,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1338,  1338,
       0,     0,  1338,     0,  1134,     0,  1731,     0,     0,     0,
    1730,     0,     0,  1728,  1727,  1711,     0,  1138,  1140,  1139,
       0,  1338,  1338,     0,     0,  1071,  1070,  1072,  2286,     0,
       0,     0,     0,     0,     0,  1046,  1045,  1044,  1043,     0,
       0,     0,  1051,     0,  1052,  1053,     0,  1054,  1055,  1056,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1073,
       0,     0,     0,  1712,  1166,     0,  1448,  1430,  1436,  1432,
    1605,  1433,  1440,   377,     0,  1437,  2226,  1434,   855,     0,
       0,     0,    64,  1646,  1640,  1642,  1645,  1641,     0,  1647,
    1644,  1643,  2136,  1633,  1635,  1636,  2179,  2177,  2211,  2210,
       0,  2212,  2208,  2201,  2233,  2205,  2233,  2207,  2206,  2233,
    2202,  2209,  2233,  2174,     0,  1334,  1335,     0,  2146,     0,
    1754,     0,     0,  1679,     0,  1680,  1668,  1676,   937,     0,
    1333,  2134,  2137,     0,   410,   407,   405,   418,     0,     0,
      60,    61,     0,   925,     0,   924,   928,     0,     0,     0,
    1465,  1455,  1464,  1656,     0,     0,  2177,  2174,  2263,     0,
    2265,  2280,   954,  2270,   984,   956,   983,     0,   967,  2086,
    2089,  2097,  1613,   665,     0,     0,  1584,  1566,     0,   485,
       0,     0,     0,     0,     0,     0,  1549,     0,     0,   523,
       0,  1575,  1369,  1611,  1612,  1617,     0,     0,  1617,     0,
    1579,  1590,  1580,     0,  1607,     0,  1617,  1544,     0,     0,
    1536,  1541,  1537,     0,  1543,  1542,  1545,  1533,  1534,  1562,
    1591,  1607,  1567,  1574,  1583,     0,  1561,  1568,     0,  1555,
    1581,  1607,  1607,  1617,  1617,   881,   880,   879,   875,   876,
     881,     0,  1269,     0,     0,  2351,  2365,  2349,  2360,  2361,
    2348,   952,  2274,   950,  2275,     0,  1623,  1621,  1630,  1631,
     683,   682,   476,   479,   478,     0,     0,  1772,     0,   767,
       0,  1605,   765,     0,     0,  1605,   313,  1605,   367,   759,
     779,     0,     0,   769,   904,     0,     0,   936,   931,   935,
     933,   724,   723,     0,   943,     0,   173,   175,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    73,    74,    88,   893,   892,   890,
     916,   915,   913,     0,   914,   912,   907,   909,   910,  2257,
    2261,   486,   682,  1605,     0,   305,     0,     0,     0,     0,
       0,     0,     0,     0,  2290,    93,   734,  1516,  1444,  1512,
       0,     0,     0,  1333,     0,     0,  1339,  1338,     0,  1213,
       0,     0,     0,     0,  1236,     0,     0,     0,     0,     0,
       0,     0,  1187,     0,  1213,   996,     0,  1145,     0,     0,
       0,     0,     0,  2286,     0,  1308,  1309,  1310,  1311,  1320,
    1323,  1312,  1313,  1314,  1322,  1315,  1316,  1317,  1324,  1325,
    1326,  1318,  1327,  1321,  1319,  1328,     0,  1307,     0,  1331,
    1329,  1332,  1330,     0,  1208,  1200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1338,     0,     0,
       0,  1338,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1338,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1114,     0,  1745,  1744,
       0,     0,     0,     0,   955,     0,  1075,     0,  1074,     0,
    2103,  1203,  1205,     0,   998,   997,   999,  1010,  1003,  1008,
    1001,  1005,     0,  1057,  1829,  1011,     0,     0,  1039,     0,
    1347,  1040,  1025,  1030,  1031,     0,  1028,  1029,     0,  1033,
       0,  1032,  1036,  1037,  1038,  1041,     0,     0,     0,     0,
    1064,  1069,  1229,   986,  1746,     0,   377,   380,   379,  1438,
     378,  1486,     0,   857,   856,  1435,     0,   855,     0,    66,
      68,  1639,     0,     0,  1648,  2204,     0,  2185,  2189,  2183,
    2187,     0,     0,  2175,     0,  2181,  1337,  1896,  1970,     0,
    1340,  2150,  1452,  2369,  1675,  1677,     0,     0,  1669,     0,
       0,   919,     0,     0,     0,   420,   403,     0,    62,     0,
       0,  1659,     0,     0,     0,     0,   896,  1463,     0,  1652,
       0,     0,     0,     0,     0,  2266,  2282,  2281,  2271,   986,
    1359,   987,   989,   988,  1742,  2091,  2094,  2095,  2098,  2096,
       0,  2093,  2092,  2107,     0,  1615,  1618,  1619,     0,     0,
    1599,  1593,  1592,  1588,  1594,  1589,  1602,  1601,  1600,  1558,
    1557,  1378,  1379,  1377,  1372,  1373,  1376,  1552,  1608,  1598,
    1596,  1586,     0,  1617,  1597,  1595,  1538,  1539,  1540,     0,
    1368,     0,  1617,  1607,     0,  1617,  1617,  1578,  1582,     0,
     869,   878,   866,   873,  1279,  1278,     0,  1243,     0,  1245,
    1242,  1241,  1240,     0,  1278,  2355,  2363,  2367,     0,  1368,
    2279,  2277,   477,  1486,  1486,     0,  1771,     0,     0,     0,
       0,     0,     0,     0,   153,   162,     0,     0,   311,   312,
    1486,   310,   353,   354,   357,   358,   359,     0,     0,     0,
       0,     0,     0,     0,     0,   106,   360,  1486,  1486,   307,
     333,   334,   337,   338,   339,   340,   341,   303,     0,   308,
     682,     0,   781,   783,  2314,  2315,  2316,   888,  1442,  1299,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   917,
     911,    98,   682,  1486,  1486,  1486,  1486,   309,   342,   343,
     346,   347,   348,   349,   352,   350,   351,     0,     0,  1605,
       0,  2229,     0,   115,  2343,     0,     0,   151,   487,   735,
       0,     0,     0,  1340,  1519,  1269,  1523,  1522,  1520,     0,
    1141,     0,  1180,     0,  1182,  1183,  1184,     0,     0,     0,
       0,     0,  1142,     0,  1089,  1143,  1144,     0,     0,     0,
       0,  1186,     0,  1120,     0,     0,  1092,  1093,  1086,  1078,
       0,  1159,     0,     0,  1094,     0,     0,     0,     0,     0,
    1160,  1231,     0,  1233,  1746,     0,  1192,  1147,  1099,     0,
    1190,     0,  1100,  1161,  1162,  1163,  1126,  1149,  1150,     0,
    1165,     0,  1151,     0,     0,     0,     0,  1102,  1196,  1194,
       0,     0,     0,     0,  1198,  1135,  1104,     0,     0,     0,
    1103,     0,     0,     0,     0,     0,     0,     0,  1106,     0,
    1087,  1195,  1197,  1155,     0,  1115,  2283,  2283,     0,  1079,
       0,     0,     0,     0,     0,  1747,  1004,  1009,  1002,  1006,
       0,     0,     0,     0,     0,  1023,  1022,     0,     0,     0,
       0,  1347,  1026,     0,     0,  1176,  1177,  1226,     0,  1431,
    1439,  1484,  1485,  1487,     0,  2227,  1428,  1427,    69,     0,
       0,  1634,  1649,  1637,  2237,     0,  2236,  2222,  2225,  1753,
       0,     0,     0,  2160,  2154,  2161,  2163,  2157,  2162,  2164,
    2155,  2156,  2151,  2158,  1341,  1370,     0,     0,   938,   939,
     942,     0,  2140,  2141,  2139,  2138,   986,   408,   406,  1403,
    1404,  1389,  1390,  1388,  1391,   419,  1392,  1402,     0,   431,
       0,   411,  1661,  1660,     0,   926,   929,   930,   901,   900,
     902,   895,   897,   898,   469,  1469,     0,     0,     0,  1475,
    1456,  1466,   886,     0,     0,     0,     0,     0,   982,  1269,
    1419,   979,   960,  1370,  1360,   959,   990,     0,  2090,     0,
    2057,  2118,     0,     0,     0,     0,     0,  2108,  1614,     0,
    1563,     0,  1587,     0,     0,     0,  1554,     0,  1577,  1535,
    1553,  1340,  1607,  1550,  1551,   883,   882,   877,  1278,  1269,
       0,     0,  1266,  1280,     0,  1280,  1269,  1269,     0,  1269,
    1333,  1275,     0,     0,  2366,  1361,  2278,     0,     0,   763,
     156,   159,   157,     0,   158,     0,     0,   362,   361,     0,
    1605,   355,   110,   109,   111,   112,  1386,  1387,  1383,  1384,
    1382,  1385,   114,   113,   108,   778,     0,     0,     0,  1605,
     335,   314,   315,   318,   319,   320,   851,   851,     0,  1486,
    1486,   851,  1486,     0,     0,  1486,  1486,     0,     0,  1486,
       0,     0,   851,     0,  1486,   849,     0,     0,  1486,  1486,
    1486,  1486,   851,     0,     0,  1486,   397,  1486,     0,     0,
     861,     0,     0,  1486,     0,     0,  1486,  1486,  1486,   795,
     848,   489,   508,   509,   760,   794,   796,   807,   395,     0,
     827,   850,     0,     0,     0,   120,  2319,  1302,     0,  1303,
    1300,  1301,   174,    80,    76,    89,  1396,  1397,  1395,  1393,
    1394,    90,    78,    79,    83,    82,    84,    85,    86,    81,
      87,    77,    91,    92,    75,     0,     0,     0,     0,  1605,
     344,     0,     0,  1486,   304,   321,   322,   325,   326,   327,
     328,   329,   332,   330,   331,     0,  2230,     0,     0,     0,
     298,   297,     0,  2337,     0,     0,   557,    94,   395,   488,
     491,     0,     0,   736,     0,  1445,  1446,  1269,  1359,  1340,
       0,  1333,     0,     0,  1181,  1214,     0,  1237,     0,  1083,
     640,   640,  1224,  1222,   629,   640,  1218,  1223,  1220,     0,
     668,     0,   667,     0,     0,     0,  1188,  1185,     0,     0,
       0,     0,  1211,     0,     0,     0,  1088,     0,  1171,  1193,
    1191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1199,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2287,  2287,  1076,  2104,  2105,
    2106,   755,  1204,     0,  1020,  1016,     0,  1014,  1346,  1035,
    1034,     0,     0,     0,  1024,   987,  1167,   986,     0,  1227,
    1748,   376,   522,  1429,    67,  1638,  2234,     0,     0,     0,
       0,     0,     0,     0,     0,  2149,  1371,  1496,  1761,  1670,
       0,   946,  2142,  2143,     0,   409,     0,   401,   404,     0,
     412,   413,   415,     0,   899,   965,     0,  1488,  1473,  1480,
    1474,     0,     0,     0,  1472,  1738,  1737,  1744,  2269,     0,
       0,     0,     0,  2272,  1340,  1340,  1413,     0,     0,   957,
     962,   958,   961,     0,   985,   994,   993,  1739,  1746,     0,
       0,     0,     0,   670,   669,   678,     0,     0,     0,  2103,
       0,   674,   676,   675,  2113,   673,  1616,  1368,  1573,  1572,
    1375,  1374,     0,  1546,  1565,  1617,     0,  2276,  1273,     0,
    1268,  1267,  1281,     0,  1269,  1280,  1280,     0,  1248,  1247,
    1500,  1503,     0,  1246,  1297,  1271,   965,  2356,  2368,     0,
     681,   680,   521,   677,   520,   161,   160,   166,   167,   382,
     368,   381,   356,   107,   369,   370,   336,     0,   316,   852,
     753,   725,   920,   725,   831,     0,   554,   753,   718,   829,
       0,   920,     0,     0,     0,     0,     0,   920,     0,     0,
       0,  1486,     0,   842,   790,     0,     0,     0,     0,     0,
     843,     0,   791,  1486,     0,     0,     0,     0,     0,   920,
       0,     0,     0,     0,   920,   811,   864,   863,   862,     0,
     920,   920,     0,   514,   515,   516,   513,     0,     0,     0,
     490,   682,   792,   396,   793,   557,     0,   858,   554,   560,
    1749,     0,   130,     0,     0,   780,     0,   123,   121,   132,
       0,     0,   945,     0,   375,   374,   373,   372,   345,     0,
       0,     0,  1605,   323,  2231,     0,     0,  2344,   301,   299,
     300,     0,   176,   541,   542,   540,   539,     0,   385,     0,
    1800,   383,     0,     0,   543,   545,   546,  1681,   682,   492,
     746,   748,   747,   742,   741,    95,  1340,  1380,  1515,  1521,
       0,  1116,  1238,     0,     0,  1215,   684,     0,  1225,   631,
    1217,  1219,  1221,  1082,  1090,  1158,  1085,  1084,     0,     0,
       0,  1123,  1124,  1209,  1212,     0,     0,  1096,     0,  1098,
       0,     0,  1173,  1148,  1164,  1127,  1152,     0,  1101,  1077,
       0,  1128,     0,  1133,  1131,     0,  1105,     0,     0,  1112,
       0,  1110,     0,  1111,     0,  1113,  1154,  1156,  2284,     0,
       0,  1206,  1012,     0,  1021,  1018,     0,  1015,   990,  1178,
    1168,  2235,  2224,  2223,  2238,  2238,  2238,     0,  1342,     0,
    1453,  1681,   940,     0,   941,   987,   428,     0,   435,     0,
     433,   402,     0,   927,   986,  1470,  1482,     0,  1490,     0,
       0,  1467,  1477,     0,     0,     0,  1476,     0,  2167,  2168,
    2166,  1370,  1348,     0,     0,  1424,     0,  1420,   980,     0,
     992,   991,     0,  2120,     0,  2119,  2131,  2132,  2129,  2130,
    2128,  2109,     0,  2115,  2114,     0,     0,     0,  2125,  2116,
       0,     0,  1564,     0,  1559,   884,     0,  1269,  1244,  1269,
    1255,     0,     0,  1269,  1251,  1249,  1253,     0,  1340,     0,
    1270,  1294,   986,  1741,  1362,  1365,   317,   559,   754,   726,
     719,   814,   720,     0,     0,     0,   725,   553,   753,   552,
     555,   734,     0,     0,   501,   498,   833,   504,   812,   802,
     813,   824,   826,     0,   500,   517,     0,     0,   505,   753,
     797,   840,   841,   855,   494,     0,   535,   536,   534,   510,
     518,   496,   497,   835,     0,  1355,  1357,  1365,   503,   502,
     398,   499,     0,   846,   819,     0,   532,   530,   527,   529,
     528,   533,   531,   506,   519,   495,     0,   851,   851,   828,
       0,  1752,     0,   860,   830,     0,   547,   548,     0,     0,
     131,   119,     0,     0,   782,   784,     0,     0,   785,  2321,
       0,  2317,  1304,     0,   306,   371,   324,     0,     0,   187,
     986,     0,   177,   179,   180,     0,     0,     0,   487,   557,
    1683,  1682,   384,   472,   493,     0,  1517,     0,  1513,     0,
    1239,     0,   690,   692,   686,   690,     0,  1216,     0,  1189,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1080,
       0,  1169,     0,     0,     0,     0,     0,     0,  1109,  1107,
    1108,  2285,   756,  1017,     0,  1179,     0,  2243,  2243,  2243,
    1495,  1494,     0,  1493,  1497,     0,   947,     0,     0,     0,
       0,   432,     0,   414,   470,     0,     0,     0,  1491,  1479,
    2273,  1468,  1471,  1746,  2169,   964,     0,  1343,  1423,  1421,
       0,  1414,  1416,  1418,     0,  1740,     0,     0,  2124,  2110,
     679,     0,     0,     0,     0,  2111,     0,  1333,  1274,     0,
    1240,  1269,  1269,     0,  1240,     0,     0,     0,  1502,  1359,
    1504,  1298,     0,  1276,     0,  1366,  1367,  1364,   816,   556,
     753,   721,   722,   734,     0,     0,     0,   801,     0,   908,
       0,   806,   678,   511,   839,   838,   512,     0,   799,     0,
    1358,   798,   821,   804,     0,   832,   859,   698,   625,   574,
     565,   640,   568,   567,   611,   582,   579,   629,   627,   597,
     629,   629,   604,   603,   621,   607,   587,   684,   684,   586,
     624,   684,   608,   606,   610,     0,   612,   629,   617,   605,
     609,   626,   602,   599,   623,   640,   640,   580,   583,   622,
     684,     0,   615,   640,   644,   585,   684,   690,     0,     0,
     640,   642,  1751,   117,   122,   133,   134,   773,  2320,     0,
    2323,     0,     0,   128,   190,   188,   189,     0,   183,   185,
     180,  2331,  2338,     0,     0,  2336,   386,   388,   395,   544,
     473,     0,     0,  1381,  1117,   641,   691,   685,   693,   694,
       0,   689,   687,   690,   630,     0,  1121,  1122,  1210,  1201,
    1146,     0,  1097,  1170,     0,     0,  1153,  1129,  1132,  1130,
    1136,  1137,  1019,     0,     0,  2242,  2240,     0,  2241,  2239,
    2215,     0,  2172,  2173,  2171,  2159,     0,     0,  1671,   416,
     986,   421,     0,   438,   437,   434,  1370,  1481,  1483,  1489,
    1478,     0,  1344,  1359,  1684,  1417,     0,   981,  2122,  2121,
    2123,  2117,     0,     0,     0,     0,  1272,  1256,     0,  1260,
    1265,  1261,     0,  1252,  1250,     0,  1380,  1286,  1287,     0,
       0,  1292,  1296,  1370,  1365,     0,     0,   815,     0,     0,
       0,   845,     0,   858,   803,   825,   847,   644,   920,  1356,
     820,   822,   896,   507,   704,     0,     0,   584,   633,   628,
       0,   633,   633,   593,   611,   588,     0,   684,   601,   592,
     613,   616,   618,   620,   633,     0,   684,   581,   590,     0,
     633,   656,     0,     0,     0,     0,   648,     0,   697,     0,
       0,   659,   561,   645,   647,     0,     0,   614,     0,   570,
       0,   572,     0,     0,   633,     0,   643,   633,     0,   124,
     786,   238,  2322,  2318,     0,   105,  2335,   120,   129,  2345,
     187,     0,     0,     0,   178,   181,  2273,  1681,     0,   391,
       0,  1365,   751,   695,   688,     0,     0,  1172,  1174,  2221,
    2220,  2219,  2216,     0,     0,     0,     0,     0,     0,  2244,
    2246,  1492,     0,     0,     0,   429,     0,   425,   427,     0,
     457,   471,   979,   537,  1352,  1365,     0,  1370,     0,  1692,
    1415,  2127,  2126,  2112,     0,     0,     0,     0,     0,     0,
    1305,  1501,  1282,  1282,  1293,  1277,  1363,   818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   844,  1717,   834,
     836,   800,     0,   805,     0,     0,     0,   699,   700,   705,
     707,     0,     0,   637,   638,   639,   594,   634,   636,     0,
     596,   564,   589,   619,   595,     0,   591,     0,   578,   662,
     661,   995,   654,   664,   524,   526,   525,   652,     0,     0,
     649,   650,   651,   660,   646,   658,   653,     0,     0,     0,
       0,   562,     0,   563,  1750,     0,   126,   264,     0,   250,
     236,     0,     0,     0,   240,   135,   138,   136,     0,   137,
     143,     0,   144,   145,   146,   147,   148,   139,   262,   263,
     142,   140,   141,     0,  1765,     0,  1766,   955,     0,  2327,
     132,   154,   184,     0,     0,  2339,   389,   387,     0,  2269,
     737,     0,   750,     0,   632,  1095,  2217,  2247,  2250,  2248,
    2249,  2251,  2245,     0,     0,   987,     0,   422,   423,     0,
       0,     0,  1486,     0,     0,  1486,  1486,  1486,  1486,   450,
     458,   460,     0,   538,     0,     0,  1349,  1351,  1345,  1405,
       0,     0,     0,     0,  1685,  1687,     0,  1422,     0,  1257,
       0,  1262,     0,  1254,     0,     0,  1290,  1288,   817,     0,
       0,   737,  1719,  1718,   858,     0,   710,   711,   712,     0,
       0,     0,   703,   706,   573,   566,   635,     0,   757,     0,
     577,   663,   995,   657,   684,   690,   684,   690,   125,     0,
     118,     0,     0,   249,   252,     0,     0,   255,   245,   244,
     246,     0,   239,   238,   238,   292,   243,   289,   288,   281,
    2325,     0,     0,  2324,     0,  2346,   186,   986,     0,   393,
     392,  1486,     0,    96,   738,   743,   739,  1365,     0,  1498,
    1506,     0,  1672,     0,   430,   429,   426,     0,     0,     0,
    1486,  1486,     0,     0,     0,     0,     0,   436,   459,  1486,
    1353,  1354,  1365,     0,   963,     0,     0,     0,     0,  1686,
       0,     0,  1693,  1695,     0,     0,     0,  1306,     0,  1283,
       0,     0,     0,     0,   737,   549,   837,     0,   714,     0,
     713,     0,   708,   709,   704,     0,   684,     0,   684,   655,
     569,   571,   575,   576,   127,   265,   276,   279,   271,   251,
       0,     0,     0,   241,   238,     0,   225,   223,   224,   230,
     231,   232,   233,   234,   235,   226,   229,   227,   228,   238,
       0,   195,     0,     0,  2273,     0,     0,     0,   134,   164,
     163,   155,     0,   238,  2332,  2340,  2273,     0,     0,   740,
     749,   752,     0,     0,   671,   417,   424,     0,   446,   448,
     449,   443,     0,   439,   441,   442,   468,     0,     0,  1400,
    1398,  1399,   464,  1401,   465,   463,   461,   454,     0,   452,
       0,  1350,  1406,  1690,  1691,     0,  1688,     0,     0,  1694,
       0,  1259,  1264,  1285,  1284,  1299,     0,   551,   550,     0,
     716,   717,   715,   701,   702,   598,   758,   600,     0,     0,
     238,   272,     0,   247,     0,     0,     0,     0,   193,   295,
       0,   191,   283,   283,  2326,     0,  2328,     0,   116,   165,
    2347,     0,   154,   394,   744,   745,  1505,  1507,     0,  1673,
     440,     0,  1950,     0,   466,   467,     0,   451,     0,   462,
       0,  1689,  1697,  1696,     0,     0,     0,   823,   273,   279,
     269,   277,   238,     0,     0,   237,   256,   291,   194,     0,
     293,     0,   238,     0,   282,   284,   286,  2329,  2330,     0,
    2341,   672,  1684,   447,   444,   445,   457,   456,   453,   986,
       0,  1291,  1289,     0,   270,     0,     0,   268,   248,   253,
     238,     0,   238,   206,   205,     0,   197,   219,   290,     0,
     196,  2333,   238,  1692,   455,     0,     0,  1409,  1411,     0,
     274,     0,   238,     0,   238,     0,   238,     0,     0,     0,
       0,     0,   192,   238,  2342,  1698,   987,  1407,   986,  1560,
       0,   266,   238,   254,   259,   296,     0,   200,   220,   221,
       0,   203,  2334,     0,  1700,  1412,  1410,   238,   238,   255,
     258,   294,     0,     0,   198,   212,   199,   210,   202,     0,
       0,     0,  1707,   238,   238,   260,   218,   216,   238,   207,
     214,   209,     0,   215,   222,   213,     0,   204,  1699,  1702,
       0,     0,  1704,  1705,     0,  1674,     0,   201,   217,   211,
    1706,  1701,     0,  1708,   208,  1703
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    56,    57,    58,    59,    60,    61,  1220,    62,   754,
    1162,  1619,  1620,    63,   497,    64,   949,  1394,  1395,  1396,
      65,  1868,  2975,  1412,   469,   470,  1794,  1795,   973,  2308,
    2635,  3369,  2639,  3516,  3650,  3377,  1812,  2948,  3370,  3371,
    3525,   492,  1866,  1349,  3675,  1774,  3791,  1775,    66,   584,
     947,  1375,  1376,  2961,  2962,  3194,  2963,  3187,  3188,  3189,
    3190,  3922,  3764,  3871,  3923,  3979,  4012,  4018,  4019,  3955,
    4028,  4029,  4030,  4036,  4031,  3956,  4014,  3765,  3766,  3657,
    3767,  3528,  3768,  3661,  3769,  3531,  3770,  3771,  3772,  3773,
    3914,  3774,  3656,  3948,  3761,  3762,  3950,  3994,  4010,  3775,
    3538,  3651,  3858,  3539,  3652,  3909,  3757,  3910,  3943,  3990,
    3758,  3859,  3946,  3862,  3776,  3782,  3924,  3777,  3783,  3778,
    3543,  3668,  3781,  3666,  3780,  3952,  3919,  2312,  2661,   568,
     569,   595,  1859,   570,   961,   921,  1351,  1807,  1808,  2191,
    2192,  2294,  2295,  2296,  1799,  1800,  1801,  1847,  1848,  1849,
    1781,  1782,  1783,  1355,  1778,  1779,   571,   922,   932,  1802,
    1803,  1804,  2300,  1851,  1852,  1853,  1854,  1805,  1609,  1806,
    2550,  2317,  2671,  3386,  2972,  3559,  3796,  2622,  2623,  2602,
      67,   508,   801,  1217,  2070,  1653,  1652,  1218,  2449,  2450,
    2451,  2057,  3251,  1655,  2069,  3415,  3695,  3416,  3417,  2775,
    3577,  2447,  2779,  2780,  3030,  3253,  3420,  3813,  3814,  3815,
    3807,  3808,  3809,  3707,  3828,  3829,  3896,  3936,  3589,  3590,
    3591,  2089,  2455,  3256,  3201,  1841,  1341,  1342,   471,   472,
     473,   592,  2318,  2240,  2319,  2320,  2242,  2243,  2421,  1268,
    3497,  2923,  2899,  3421,  2667,  2673,  2674,  2675,  2676,  2869,
    2870,  2565,  2566,  2628,  2938,  3164,  3320,  3335,  3165,  3166,
    3167,  3168,  3169,  3170,  3171,  2698,  2699,  3476,  3477,  3478,
    2695,  3367,  3352,  3353,  3354,  3492,  2986,  2494,  2495,  3889,
    2503,  2504,  2541,  2823,  2542,  1345,  2987,  3207,  3211,  3355,
    2937,  3314,  3467,  3631,  3468,  3469,  3470,  3742,  2567,  2868,
    2568,  2860,   878,   610,  1869,  1870,  3683,  3684,  3685,  3686,
    2683,  3390,  3391,  2857,  2751,  3637,    68,  1810,   915,   924,
     920,   938,   576,  1360,  1813,  2255,  3177,   558,  2244,  3308,
    3099,  3312,   124,  2245,  2879,  2246,  3088,  3297,  2247,  3112,
    3310,  3462,  2880,  2881,  2248,  2249,  2250,  3098,  3107,  3624,
    2569,   574,  1615,  2934,  2609,    69,  1320,  1315,    70,   889,
     884,   885,  1318,  1319,  1740,  2136,    71,   820,    72,   579,
      73,   587,  1399,    74,  1228,  2081,  2082,  2083,    75,   939,
      76,    77,   588,  1406,  1407,  1408,    78,  1213,   131,    79,
     809,  1223,  1225,  1226,    80,   581,   582,  1368,    81,  1647,
    2048,  2049,   944,   945,  1374,  2774,    82,    83,   548,   521,
     826,   522,   523,  1680,  2101,  3422,   837,   838,   839,  2479,
    1245,  1246,  1247,  2106,  1681,  2484,  1016,   719,   720,   721,
     722,  1110,  1111,  3356,   723,  1120,  1576,   724,   725,   726,
     727,   728,   729,  1603,  2721,  2722,  3001,  2004,  2005,  2006,
     730,  1900,  2708,  1913,   731,  1103,  1561,  1495,  2993,  2713,
    1438,  1883,  2349,  2418,  1978,  1041,  1042,  1006,  1890,  1444,
    1747,  1748,  1749,  1750,  1751,  3076,  3075,  3077,  3435,  3278,
    3437,  3282,  2147,  1752,  1753,  2517,  2837,  2535,  2536,  3293,
    2138,  1754,  2523,  3616,  3290,  3291,  3732,  3731,  3292,  3081,
    3082,  2850,  2851,  2258,  2259,  2260,  3439,  1486,  1487,  1493,
    1197,  1198,  1439,  2045,  2434,  3263,  3426,  1995,  3047,  3424,
    3596,  2251,  2905,  2906,  2103,  2104,  2539,  2854,  3087,  1271,
    3423,  2436,  1714,  1715,  2978,  4017,  2551,  2271,  3822,  2066,
    2067,  3714,  3900,  3966,  3967,  3968,  2805,  2806,  3051,  3052,
    2105,  2476,  2807,  3264,    84,   476,    85,  2423,   940,   941,
    1427,  1428,   742,   489,    86,   498,  2046,    87,   515,  1668,
     792,   813,  1231,  1232,  2090,  2456,  2463,  2091,  2468,  3040,
    2458,  2785,  2786,  2013,  2014,  2459,  2788,  3037,  3022,  3023,
    2770,  3247,    88,   536,  2848,  2530,  2531,  3689,  3690,   814,
      89,   475,   993,  1873,  1431,  1872,   994,   995,  1433,   614,
     615,    90,   533,  1296,  1297,  1298,  1730,    91,   526,   879,
    2507,  1709,   805,  1154,  1275,   882,  1276,  1695,  2120,  1256,
      92,   911,   910,    93,   554,  1337,    94,   755,  1173,  1174,
    1624,  2023,    95,   516,   818,   819,    96,   510,   806,  1661,
      97,   502,    98,    99,   795,  1206,  2771,  3413,  3804,  3932,
    1646,  1207,  2973,  3429,  3604,  3605,  3607,  3722,  3723,  4004,
    4022,  4041,  4042,  4045,   733,   899,   734,  3457,   735,   736,
    2464,  2465,  2855,   737,  3691,   738,  2629,   892,   495,   454,
     565,   900,  2439,   740,  3545,   918,   965,   456,   457,   100,
     840,   525,  1249,  1250,  1251,  1690,  1691,   883,  1983,  1692,
    1693,  2117,  2112,  3059,  2829,  2821,   101,   798,  1175,  1211,
    1212,  2054,   102,   535,   103,  1199,  1640,  1641,  2042,  2433,
    2043,   104,   822,   105,   779,  1634,   780,  1177,   781,   782,
    1189,  1184,  1192,  1186,  3403,  3239,  3240,  2030,  1157,   966,
     967,  1627,  2025,  2026,  3017,  3242,  3409,  3410,   106,   135,
     462,   590,   956,  1239,   107,   108,   109,   110,  1242,  1332,
    2097,  1333,  1334,  1335,  1761,  1678,  2395,  1101,  1555,  2748,
     599,   983,   975,   125,   126,   127,   602,   603,   128,   936,
     937,  2256,  3180,  2641,  2950,  3373,  3374,  3549,  3673,   977,
    3382,  3881,  3983,   978,   979,  2662,  3383,  3678,  3882,  3962,
     980,  2309,  2959,  3551,  3793,   111,   901,   545,  1330,  1325,
    1327,  1757,  2154,   112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3424
static const int yypact[] =
{
    4666,  2343,    86,  1325, -3424,  -144,   180, 39163,   130,  1325,
    1325,   313,  3523, -3424, -3424, -3424, -3424, -3424,  2815, -3424,
   39163,    86, -3424, 21630, -3424, -3424,   598,   163,   702,  1325,
      86, -3424, 39163, -3424,   573,  -138,    86, -3424, -3424,  1325,
   -3424,   313, 39163, -3424,   706, -3424,   973,   983,   759,   661,
     868, -3424, -3424, 39163,  1387,   -99,  1185,  1136, -3424, -3424,
     930, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, 22198, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424,  1198, 39163,  1277, 39163,  1143, -3424,
   -3424, 39163, 33513, 39163,  1349,  1358, -3424, -3424,  1467, -3424,
   -3424,  1325, -3424, -3424, -3424,   313, -3424, -3424, 21630, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,   999, -3424, -3424,  1096, -3424,
   -3424, -3424,  1618,  1442,  1491, 33513, 39163, -3424, -3424,   206,
   -3424,  1155, -3424,  1162,   854,    65, 10661,  1490,  1490,  1490,
    1513,  1490,  1490, 39163, -3424,  1490, -3424,  1490,  1504,  1325,
   -3424, -3424,  3668, 39163,  1363,   478,   -98, 33513,   185, 39163,
   -3424, -3424, 10661, -3424,  1542, 21630, -3424,  1325,  1729,  1611,
     843, 39163, -3424, -3424,  1325,   174,   727, -3424,  4447,   109,
   -3424, -3424, -3424,  2193, -3424, -3424,  4780, -3424, -3424, -3424,
    1237, -3424, -3424, 21630, 39163,  1325,  1559, -3424, -3424,   138,
     138,   138, -3424,   138, -3424,   138, -3424,   -99,  1231, -3424,
   -3424, 39163,   513,   541, -3424, -3424,  1238,   620, -3424,  1290,
   30688, -3424, 39163, -3424, -3424, -3424, -3424,  1492, -3424, -3424,
   -3424,  1066, -3424, -3424,  1338, 39163,  1378, -3424, -3424, 21630,
   -3424,   -14, -3424, -3424,  1260, 39163, -3424, 21630, 21630,   201,
     690,  1243, 39163, 39163,  1682, -3424,  1870, 30688,  1486, -3424,
     811,  1861,  1467,  1898, -3424,  1442, -3424, -3424, -3424, -3424,
    1673, -3424, -3424, -3424, 35208,    65,  1333,  1335,  1346, 14171,
   -3424,  1350,  1365,  1386, 10661,  1391,  1393,  1397,  1438,  1452,
    1477,  1485,  1494,  1508,  1508,  1532,  1545,  1564,  1570,   870,
    1595, -3424,  1600,  1602,  1616, -3424, -3424,  1620,  1622,  1628,
   -3424,  1633,  1636,  1645, 11246,  1649,  1654, -3424, 18785,  1667,
    1669,  1676,  1702,  1711,  1714,  1724,  1734,  1737, -3424, -3424,
   10661,  1743, -3424, -3424,  1746, -3424,  1753,  1758,  1761,  1769,
    1775,  1782,  1789,  1791,  1794,  1802,  1833,  1837,  1839,  1848,
    1855,  1863, -3424,   885,  1868,  1872,  1348,  1875, -3424,  1887,
   -3424,   252,  1889,  1508,  1508,  1508,  1891,  1897,  1899,  1903,
    1905, 14171, 14171, 14171,  7736, -3424, 39163, -3424, 39163,   399,
    3036, -3424,  2422, 14171,   760, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  1401,  1419, -3424, -3424, -3424, -3424, -3424,  1907,
    1398,  1886, 39163, 39163, 39163, 39163, 39163, 33513,  1569, 39163,
   30688, 21630, 39163,  1490,  1510,  3415,  1698,  1659,  1689, -3424,
   -3424, -3424, -3424, -3424,  1788, -3424, -3424,  1655, -3424, -3424,
   -3424,   142, -3424,    89, -3424, -3424, -3424, -3424, -3424, -3424,
    1804,  1603, -3424, -3424,    91, -3424, -3424, 39163, -3424, -3424,
   -3424, -3424,  1349,  1738,   399,  1142,  2164,  2110, 21630, -3424,
     795, -3424,  -163, -3424, -3424,  2065, -3424, -3424, 30688, 21630,
   -3424, -3424, -3424, 19353, -3424, -3424,  2341, -3424,  1818, -3424,
   21630,  1698, -3424,  2114,  2062,   690,  1961, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424,  1927,  2193, -3424,
   -3424, -3424,  2363, -3424,  2076,   674,  2003, -3424,  1939,  2015,
     674, 31253,  2286,   178, -3424,   329, -3424,  2361, -3424, -3424,
    2075, -3424, -3424,  2083,  2086,  2287,  2053, -3424, -3424,   333,
    1536, -3424, -3424,   700, -3424,   568,  2286,   674,   178, -3424,
    2313,  2430,   737,  -146, -3424,   -65, -3424, -3424,  2496, -3424,
   -3424, -3424, -3424, -3424, -3424,  1349, -3424, -3424, -3424,  1994,
   -3424,  2249,  2106, -3424, -3424,    84, -3424,  2009,   711, -3424,
     714, 31818, -3424, -3424, -3424,  2488,  2505,  1508,  2032, -3424,
   -3424, -3424,  2625, -3424, -3424,  2060,  2549,  2549,  2549,  2644,
   -3424, -3424, -3424, 21630, -3424,  2220,  2113, -3424,  1378, 21630,
    -164, -3424, 35773, 21630, -3424,   925, 10661, -3424, -3424,  3128,
      26,   944, -3424,  2618,  2275, -3424, -3424, -3424, -3424,  2526,
   -3424, -3424,  2625,  2584,  2549,  2492,  2118, -3424, -3424, -3424,
    1442, -3424, -3424, -3424,  2528, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  2535, -3424, -3424, -3424, -3424, -3424,  1378, -3424,
   21630, 39163, 21630, -3424,  2131, -3424,  2128, -3424, 10661, 10661,
     297,  2650,  2707,  2707,  2707,   399,  2162, 10661, 10661, 10661,
   10661, 10661, 10661, 10661,   943,  2143, -3424, -3424,  8321, -3424,
    2147, 10661, 10661,  2231, 10661,  1419, 10661, 22766,   825,  3853,
   10661,    93,  2607, 10661, 10661, 10661,  7736,  2207, 10661, 10661,
   22766,  2726,  2153, -3424,  2155,   985, 10661, 10661,  1217, 10661,
   10661, 10661, 10661, 10661, -3424,  8321, -3424, 10661, 10661, 10661,
   10661, 14171, 10661, 10661, 10661, 10661, 10661, 10661,  2707,  2707,
   10661, 10661,  1283,  8321, -3424, 10661,  1419,  2376,  2376, 10661,
    1419,  6566, 10661, -3424, -3424, -3424,  2167, -3424, -3424, -3424,
   22766,  2707,  2707, 10661, 10661,  2650,  2650,  2650, -3424,  7736,
     181,  2171, 10661, 23902,  2156, -3424, -3424, -3424, -3424, 10661,
   10661, 10661, -3424, 14171, -3424, -3424,  2001, -3424, -3424, -3424,
   11831, 14171, 14171,  2173, 14171, 14171, 14171, 14171, 14171,  2513,
   14171, 14171, 14756, 15341, 14171, 14171, 14171, 14171,   805,  2650,
   33513, 14171, 10661, -3424, -3424, 39163, -3424, -3424, -3424,  2174,
    1569, -3424, -3424,   -72,  2617, -3424, -3424,  2178,    92,  2426,
   21630,  2182, -3424, -3424, -3424, -3424, -3424, -3424,  2723, -3424,
   -3424, -3424,  2209,  2189, -3424, -3424, -3424, -3424, -3424, -3424,
    2281, -3424, -3424, -3424,  2197, -3424,  2197, -3424, -3424,  2197,
   -3424, -3424,  2197,   908,  3777, -3424, -3424, 39163, -3424, 39728,
   -3424, 19353,  -144, -3424,  2501, -3424, -3424,  2533, -3424,  2507,
     144,  2210, -3424, 21630, -3424, -3424, -3424,  2432,  1211, 33513,
   -3424, -3424,   146,  2213,  2295,  2223, -3424,  2300, 21630, 21630,
   -3424, -3424, -3424, -3424,   727,    62,  2228,  1049, -3424, 39163,
   -3424,  1312, -3424, -3424, -3424,  2234, -3424, 10661, -3424,  2240,
   -3424,  1464,  2605, -3424,  -144, 10661, -3424, -3424,  2258,  1442,
   39163, 39163, 39163, 21630, 39163, 21630, -3424,  1008,  1008, -3424,
    1685, -3424, -3424, -3424, -3424,   674, 39163, 39163,   674, 30688,
   -3424, -3424, -3424,  2663,   178, 39163,   674, -3424,  2614,  2359,
   -3424, -3424, -3424,  2689, -3424, -3424,  2679,  2269, -3424, -3424,
   -3424,   178, -3424, -3424, -3424, 21630, -3424, -3424,   178, -3424,
   -3424,   178,   178,   674,   674,  2320, -3424, -3424,  2276, -3424,
    2320,  2406,  1099,   138,  2508, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,   705, -3424, -3424, -3424, -3424,
   -3424,    31, -3424, -3424, -3424,  1842,  2748, -3424, 33513,  2017,
     -92,   783,  2017,  1457,  -144,   282, -3424,   282, -3424, -3424,
    2537,   208, 21630, -3424,  2289,  -144, 21630, -3424, -3424, -3424,
   -3424, -3424, -3424,  2294, -3424,  2288,  2293,   399,  2735,  2736,
    2739,  2740,  2744,  2745,  2746,  2750,  2756,  2757,  2758,  2761,
    2764,  2766,  2767,  2772,  2315, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424,  2379, -3424, -3424, -3424, -3424,  2464, -3424,
   -3424, -3424,   115,  1303,  2355,  2378,  2880, 30688,  2755, 39163,
   39163, 39163, 39163, 39163, -3424, -3424, -3424,  2353, -3424,   807,
   39163,  2751, 26168,    94,   106,   347, -3424,  2707,  2357, -3424,
    2358,  2360,  2362, 10661,    46,   152,   886,  1501,  1190,   897,
     199,   245, -3424,  2366,  2367, -3424,   958, -3424,   302,   375,
     975,  1010,  2374, -3424,  2375, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424,  2770, -3424,  1295, -3424,
   -3424, -3424, -3424,  2377, -3424, -3424,  1021,   381,   423,   249,
    2383,   427,  1306,  1366,  2368, 22766, 39163,  2707,  2386,  1039,
    1059,  2707,  2387,   501,  1091,  1374,  1407,  1416,  1113,  1139,
    1157,   507,  1449,  2921,  1168,   509,   677,   691,   697,  1200,
    2388,  2389,   699,   258,  2707,  2394,  1210,   262,  2396,  2397,
    1223,  8906,  9491, 10076,   207,   717, -3424,  2395, -3424,  2155,
    2400,  2402,   280,  1288, -3424,   -99, -3424, 10661, -3424,   104,
     900, -3424,  2544, 39163,  2081,   129, -3424, -3424, -3424, -3424,
   -3424, -3424,   730, -3424,  2407, -3424,  2409,  1691,  2412,  7736,
     162,  2412,  2478,  1820,  1820, 14171,  2805,  2267, 11246,  1017,
   11246,  1017,  2412,  2412,  2412, -3424, 14171,  2421, 14171, 14171,
   -3424,  2650,   399,  2410,   906, 39163,   -72, -3424, -3424, -3424,
   -3424,   105, 30688, -3424, -3424, -3424, 21630,    92, 33513,  2420,
   -3424, -3424,  2619,  3415, 21630, -3424, 39163, -3424, -3424, -3424,
   -3424, 19921, 19921, -3424, 19921, -3424, -3424,   220,   291,  2460,
    2446, -3424, -3424, -3424, -3424, -3424,  2802, 21630, -3424,   -30,
   21630,  2289,  2435,  2435,  1621,  2534, -3424,  2436, -3424, 10661,
    -144, -3424, 30688, 30688, 21630, 21630,   792, -3424,  1470, -3424,
    -144,  2835, 19921, 19921, 19921, -3424, -3424, -3424, -3424, -3424,
    1152, -3424,   399, -3424,  2433, -3424, -3424, -3424, -3424, -3424,
   36338,   107, -3424, -3424,  -144,  2853, -3424,   399,  2448, 39163,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,   -87, -3424, -3424, -3424, -3424,
   -3424, -3424,  2581,   674, -3424, -3424, -3424, -3424, -3424,  2649,
    2286,  1536,   674,   178, 21630,   674,   674, -3424, -3424,  1695,
   -3424,   -65, -3424, -3424, -3424, -3424, 39163,   878,  2594, -3424,
    2450, -3424, -3424, 21630, -3424,  2455, -3424,  2867,  2995,  2286,
   -3424, -3424, -3424,   105,   105,  2729, -3424,  -144,  2580,  2590,
    2591,  2593,  2595,  2628, -3424, -3424,  -144,  -144, -3424, -3424,
     105, -3424,   797, -3424, -3424, -3424, -3424,  -144,  -144,  -144,
    -144,  2215,  -144,  -144,  1555, -3424, -3424,   105,   105, -3424,
    1871, -3424, -3424, -3424, -3424, -3424, -3424, -3424,   986, -3424,
    4132,   435, -3424,  2645, -3424, -3424, -3424, -3424, -3424, 36903,
   -3424, 10661,  2215,  -144,  -144,  1815,  -144,  2215,  -144,  -144,
    -144,  -144,  -144,  2215,  2215,  -144,  -144,  2215,  3128, -3424,
   -3424, -3424,   139,   105,   105,   105,   105, -3424,  1968, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, 33513,  2807,  2049,
     -79, -3424, 39163, -3424, -3424,  1106,  2484,  -137,  2743,  1068,
    2731, 21630,  2523,  2446, -3424,  1099, -3424,  2485, -3424, 12416,
   -3424,  2490, -3424, 10661, -3424, -3424, -3424,   352, 10661, 10661,
    2937,  2127, -3424, 32383, -3424, -3424, -3424, 10661, 32383,  2127,
   10661, -3424,  2494, -3424,  2859,  2861, -3424, -3424, -3424, -3424,
   10661, -3424, 10661, 10661, -3424, 10661, 10661, 10661, 10661, 10661,
   -3424, -3424, 14171, -3424,  2493,  2504, -3424, -3424, -3424,  2509,
   -3424, 10661, -3424, -3424, -3424, -3424, -3424, -3424, -3424, 10661,
   -3424, 10661, -3424, 10661, 10661, 10661, 10661, -3424, -3424, -3424,
   13001, 10661, 10661,  2512, -3424, -3424, -3424, 10661, 10661, 10661,
   -3424, 10661,   219, 10661,  1015, 10661,  1460, 10661, -3424, 10661,
   -3424, -3424, -3424, -3424, 10661, -3424, -3424, -3424,  1574, -3424,
    2495,  2499,  2510, 33513, 10661, -3424, -3424, -3424, -3424, -3424,
     825, 14171,   315,  2514, 14171, -3424,  2478,  2207,  2207,  1725,
    7736,   162,  2478, 10661,  2517,  2506, -3424, 10661, 39163, -3424,
   -3424, -3424, -3424, -3424, 33513, -3424, -3424, -3424, -3424,  2182,
    2841, -3424,  2289, -3424, -3424,  1579, -3424,  2515, -3424,  2518,
    2599,  2601,  2602, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,  2286,  1470,  2603,  2530, -3424,
   -3424,  2550,  2849, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  3072,  2538,
    2435, 39163,   399, -3424,  2608, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424,    41, -3424, -3424,  2539,  2539, 17647, -3424,
   -3424, -3424, -3424,  2781,  2951,  2952,  2955,   714, -3424,   314,
   -3424,   153,  2912,  2286, -3424,  2957, 34078, 26733, -3424,  2547,
    2910,  2551,   105, 28993,  1035, 24469, 29558, -3424, -3424,  1815,
   -3424,   160, -3424,  1685,  1685,  2583, -3424,  2811, -3424, -3424,
   -3424,  2446,   178, -3424, -3424, -3424,  2563, -3424, -3424,   903,
    2918,  2919, -3424,  2800,    42,  2800,   903,   903, 22766,  1099,
     959, -3424,  2215,  2855, -3424, -3424, -3424, 32948, 30123, -3424,
   -3424, -3424, -3424,  3055, -3424,  3056,   880, -3424, -3424,   947,
     783, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424,  1457,   947,   947,   282,
   -3424,   102, -3424, -3424, -3424, -3424,  1879,  3086,  2795,   105,
     105,  3086,   105,  2796,  2797,   105,   105,  2652,  3039,   105,
    2930,  2670,  1806,  2934,   105, -3424,  2672,  3046,   105,   105,
     105,   105,  3086,  2806,  3124,   105, -3424,   105,  2809,  2814,
     171,  2816,  2821,   105,  1319, 39163,   105,   105,   105, -3424,
   -3424,  5465, -3424, -3424, -3424, -3424, -3424, -3424,   922, 20492,
   -3424, -3424,    39,   293,  2662,  1145,  2606, -3424,  2610, -3424,
    2600, -3424,   399, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,  -144,  1621,   947,   947,  1303,
   -3424,  2831,  2989,   105, -3424,  2149, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,  2685, -3424,  2771,  2852,  2620,
   -3424, -3424,   256, -3424,  1240, 21630, 16511, -3424,  2834, -3424,
    2683,   785,   785, -3424, 21630, -3424, -3424,  1099,  2851,  2446,
    2629,    94, 11246,  1294, -3424,   399, 10661,   399,  1703, -3424,
    2626,  2626, -3424, -3424,  2627,  2626,  2986, -3424,  2990,  2630,
   -3424,  2631, -3424,  1337,  2635,  2636,  1401, -3424, 10661, 10661,
    1382,  1403,   586,   747,   777,   324, -3424,  1405,  2982, -3424,
   -3424,  1413,  1420,  1458,  1466,   800,  1478,  1581, 11246,  1496,
     289,   370, -3424,  1509,   809,   819,  1520, 10661,  1522, 10661,
    1547, 10661,  1551,  1560,  1566, -3424, -3424, -3424, -3424, -3424,
   -3424,  2621,   399,  2640, -3424, -3424, 10661, -3424,   760, -3424,
   -3424, 14171,   377,  2641, -3424,   399, -3424, -3424,  2643,  1401,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, 39163,  2651, 27298,
   30688, 30688, 30688,  2647, 10661, -3424, -3424,  2892, -3424, -3424,
   21630,  3025, -3424, -3424, 14171,  2985,  2871, -3424, -3424,  2653,
    2654, -3424, -3424, 30688, -3424,  2193, 22766, -3424,  2655, -3424,
    2655,  1242,  2657,  1592, -3424, -3424, -3424,  2646,  1961,  3065,
   30688, 30688, 30688, -3424,  2446,  2446,   117,  2705,  3021, -3424,
   -3424, -3424, -3424, 37468, -3424, -3424, -3424, -3424,   919, 39163,
    3003, 39163,  7151, -3424, -3424,  3181, 10661, 30688,   -51,   900,
     105, -3424, -3424, -3424, -3424, -3424, -3424,  2286, -3424, -3424,
   -3424, -3424,  2981, -3424, -3424,   674,  1695,  -183, -3424,  1373,
   -3424, -3424, -3424,  3019,   903,  2800,  2800,  3022,  2915,   935,
    2676, -3424,   105, -3424, -3424, -3424,  2193, -3424, -3424, 10661,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424,   986, -3424, -3424,
   23334,   925,    86,   925, -3424,   238,   849, 23334, -3424, -3424,
   23334,    86,  1815,  2215, 23334,  2215, 38033,    86,  -144,  -144,
    2138,   105,  2215, -3424, -3424,  3023, 39163,  3030, 23334, 23334,
   -3424, 33513, -3424,   105,  1347,  2215,  1815,  1815, 23334,    86,
   22766,  1051,  1729,  -144,    86, -3424, -3424, -3424, -3424, 21630,
      86,    86,  2878, -3424, -3424, -3424, -3424,  2215, 33513,  2684,
   -3424,  5663, -3424, -3424, -3424, 17079, 39163,   295,   165, -3424,
    2682,  2895, -3424, 10661, 10661,  2927, 39163,  2938, -3424,  3209,
   39163,  3263, -3424, 36903, -3424, -3424, -3424, -3424, -3424,  2702,
   39163,   947,  2049, -3424, -3424,  1240,  2856, -3424, -3424, -3424,
   -3424,  2947, 39163, -3424, -3424, -3424, -3424,  2836, -3424, 21630,
    3243, -3424,  2858,  1641, -3424, -3424, -3424,   578,  3826, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424,  2446,  3044, -3424, -3424,
    2207, -3424,   399, 10661,  2962, -3424,   196,  2963, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  2713,  2207,
    2207, -3424, -3424,  2862, -3424, 10661, 10661, -3424, 10661, -3424,
     861,  2714,  2738, -3424, -3424, -3424, -3424, 10661, -3424, -3424,
    2207, -3424, 10661, -3424, -3424, 10661, -3424, 10661, 10661, -3424,
    1571, -3424,  1576, -3424,  1584, -3424, -3424, -3424, -3424,  2716,
   39163, -3424, -3424,  1679, -3424, -3424, 10661, -3424, 34078, -3424,
   -3424, -3424, -3424, -3424,   515,   515,   515, 13586,   399,  3171,
   -3424,    79, -3424,  3067, -3424, -3424,  2478,  1332, -3424,  1690,
   -3424, -3424, 39163, -3424,  1927,  2720, -3424,   105, 13586,  2539,
    2858, -3424, -3424,  1242, 22766, 26733, -3424, 30688,  2118,  2118,
    2118,  2286,  3120,  2603,  2603, -3424, 25036, -3424, -3424,  2866,
   -3424, -3424, 27863, -3424,  1079, -3424, -3424, 14171,  1600, -3424,
     399, -3424, 32948, -3424,   399,   105,  2732,  2733, -3424, -3424,
   38598, 10661, -3424,  3166, -3424, -3424,  2730,  1099, -3424,   903,
   -3424,  3087,  3088,   903, -3424, -3424, -3424, 22766,  2446, 13586,
   -3424,    36,  1927,   399,  2737,  1414, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, 10661,  3083,  3089,   925, -3424, 23334, -3424,
   -3424, -3424,   108, 38033, -3424, -3424, -3424, -3424, -3424, -3424,
    2742, -3424, -3424,  1621, -3424, -3424, 30123,  -144, -3424, 23334,
    2742, -3424, -3424,   168, -3424,  -144, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, 38033,  2749, -3424,  1414, -3424, -3424,
   -3424, -3424, 38033, -3424, -3424, 38033, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, 21630,  2000,  1696, -3424,
    1704, -3424, 39163, -3424, -3424, 21630, -3424, -3424,  5369, 39163,
   -3424,   399,  2207,  3245, -3424, -3424,  2869,  -144,  3195, -3424,
    1763, -3424, -3424,  1457, -3424, -3424, -3424,  2872,   293,   -12,
   -3424,  2741,  2752, -3424, -3424,  -144,  2759,  2760,  5465, 17079,
   -3424, -3424, -3424,  3310, -3424,  2762, -3424,  1685, -3424,  1188,
     399,  2763,  3301,   133, -3424,  3301, 32383, -3424,  1786, -3424,
    2768,  2775,   138,  2776,  1586,   873,  1803,  3035,  3104, -3424,
    2956, -3424,  1605,  1212,  1614,  1630,  1634,  1674, -3424, -3424,
   -3424, -3424, -3424, -3424,  1807, -3424,   642,  2782,  2782,  2782,
    1600,   399,  1827, -3424, -3424,  3127, -3424,  2777,  2780,  2783,
   39163, -3424,  2871, -3424,  2234, 22766, 13586,  2785,  2769, -3424,
     711, -3424, -3424,  2765,  2118, -3424,  3304,  3172, -3424, -3424,
   33513,  2779, -3424, -3424,  3066, -3424,   176,  2983, -3424, -3424,
   -3424,   -51,  2870,  2873,   105,   399,  -144,  2103,  2450,  2247,
    2832,   903,   903,  2592,  2833, 10661, 10661,  2817, -3424,  2851,
   -3424, -3424,   772,  2234, 10661, -3424, -3424, -3424,  -102,   399,
   23334, -3424, -3424, -3424,  2825,  3266,  3274, -3424, 23334,  2464,
   39163, -3424,  3181, -3424, -3424, -3424, -3424,  5369, -3424, 22766,
   -3424, -3424, 39163, -3424,  1830, -3424, -3424, -3424, -3424,  2829,
    2830,  2626, -3424, -3424, -3424, -3424, -3424,  2627,  3016, -3424,
    2627,  2627, -3424, -3424, -3424, -3424, -3424,   196,  1472, -3424,
   -3424,   196, -3424, -3424, -3424,   136,  1298,  2627, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,  2626,  2626, -3424, -3424, -3424,
     196,  2843, -3424,  2626,  2804, -3424,  1184,   141,  2844,  2848,
    2626,  2854,  2799, -3424, -3424, -3424, -3424, -3424, -3424, 39163,
   -3424,  1852,  -144,  2927, -3424, -3424, -3424,  2808,  2850, -3424,
   -3424, -3424, -3424, 39163,  5369, -3424, -3424, -3424,  2834, -3424,
   -3424,  1098, 39163, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   32383, -3424, -3424,  3301, -3424,  3057, -3424, -3424, -3424, -3424,
   -3424, 10661, -3424, -3424,  3110,  3259, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424,  2916,  2917, -3424, -3424,  2939, -3424, -3424,
      90,  2144, -3424, -3424, -3424, -3424, 13586,  3205, -3424, -3424,
   -3424, -3424, 39163,  2900, -3424, -3424,   734, -3424, -3424, -3424,
   -3424, 10661, -3424,  2851,  3372, -3424, 25036, -3424, -3424, -3424,
   -3424, -3424,  2868,  2884,  7151,  3437, -3424, -3424,  2911, -3424,
   -3424, -3424,  2935,   399,   399, 39163,  3044, -3424, -3424,   925,
     925, -3424,   772,   734,  1414,  1621,  2871, -3424,  2874,  2898,
   39163, -3424,  2754,   295, -3424, -3424, -3424,  2804,    86, -3424,
   -3424,  2742,    41, -3424,   -62,  3122,  3151, -3424,  -107, -3424,
    2903,  -107,  -107, -3424,  2076, -3424,  2933,   196, -3424, -3424,
    2948, -3424, -3424, -3424,  -107,  2906,   196, -3424, -3424,  3157,
    -107, -3424, 33513,  -144,  2694,  1233, -3424,  2953, -3424,  3391,
    1360,  3273, -3424,  2804, -3424,  3275,  3176, -3424,  3177, -3424,
    3180, -3424,  3182,  3183,  -107,  3185, -3424,  -107, 39163,  3045,
   -3424, 44813, -3424, -3424,  1117, -3424, -3424,  1145, -3424, -3424,
    1531, 39163, 21630,  3101, -3424, -3424,   711,   578,  2858, -3424,
    1859,  1414,  2941, -3424, -3424,  2942,  1678, -3424, -3424, -3424,
   -3424, -3424, -3424,    99,  3184,  2215,  2215,  2215,  2215,  2144,
   -3424, -3424,  2988,  3034, 14171,  3079,  1884, -3424, -3424,  1248,
    2331, -3424,   153, -3424,  1149,  1414, 10661,  2286,   941,  3292,
   -3424, -3424, -3424, -3424,  3281, 10661,  2968, 10661,  2969,  1925,
   -3424, -3424,  3392,  3392, -3424, -3424, -3424, -3424,  1933, 39163,
   39163,  1943,   -53,   -53,   -53,  2071,  2071, -3424, -3424, -3424,
   -3424, -3424,  3344, -3424,  1202,   218, 39163, -3424, -3424,    64,
   -3424,  2987,  2991, -3424, -3424, -3424, -3424,  -107, -3424,   138,
   -3424, -3424, -3424, -3424, -3424,   138, -3424,  2992, -3424, -3424,
   -3424,  1508, -3424, -3424, -3424, -3424, -3424, -3424,  3241,  3020,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424,  2993,  2994,  2996,
    2997, -3424,  2998, -3424, -3424, 10661,  3431,  3013, 39163,   749,
   -3424, 45943, 45943, 39163, -3424, -3424, -3424, -3424,  5233, -3424,
   -3424,   755, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424,  3548, -3424,  2999, -3424, -3424,   -99,  3018,
    3209, -3424, -3424,  5369,  3410, -3424, -3424, -3424,  3002,  1961,
      -2, 39163, -3424,  3254, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, 22766, 21630, -3424,  1621, -3424, -3424, 39163,
    3005,  3090,   105,  3467,  3468,   105,   105,   105,   105,  3009,
    2331, -3424,  3450, -3424,   420, 10661, -3424, -3424,   399,  3217,
    3549,  3550,  3459,  3552,   941, -3424,   -95, -3424,  3454,   399,
   39163,   399, 39163, -3424, 39163,  1169, -3424, -3424, -3424,  1946,
    1953,    -2, -3424, -3424,   295,  3024, -3424, -3424, -3424,   745,
     745,  1955, -3424, -3424, -3424, -3424, -3424,  1958, -3424,  1960,
   -3424, -3424,  1508, -3424,   196,  3301,   196,  3301,   399, 10661,
   -3424, 10661,  3040, -3424, -3424,  3425, 39163, -3424, -3424, -3424,
   -3424, 10661, -3424, 44813, 44813, -3424, -3424, -3424, -3424,  3572,
   -3424,  3026,  1287, -3424,  3476,  2813, -3424, -3424,  5369, -3424,
   -3424,   105,  3250, -3424,    -2, -3424, -3424,  1414,  3027,  3029,
   -3424,   105, -3424,  3028, -3424,  3079, -3424, 14171,   585,  -144,
     105,   105,  2107,  2107,  1621, 33513,  3129, -3424, -3424,   105,
   -3424, -3424,  1414, 39163, -3424,   138,   138,  3569,   138, -3424,
    3570,  3571,   -95, -3424,  1815,  1972,  1981, -3424,  3573, -3424,
    3574,  3041,  3043,  3224,    -2, -3424, -3424,  2871, -3424,  3617,
   -3424,   221, -3424, -3424,    64, 39163,   196,   138,   196, -3424,
   -3424, -3424, -3424, -3424,   399,   399, -3424,    71, -3424, -3424,
    3406,  3488, 10661,   399, 41988,  3038, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, 45378,
   10661, -3424,   755,  3548,   711,  3575,  3284,  3576, -3424, -3424,
   -3424, -3424,  3510, 44813, -3424, -3424,   711,  2215,  1090, -3424,
   -3424, -3424, 22766, 13586,  2138, -3424, -3424,  2014, -3424, -3424,
    2478, -3424, 15926, -3424, -3424, -3424, -3424,  -144,  -144, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  2026, -3424,
   33513, -3424, -3424, -3424, -3424,   138, -3424,   138,   138, -3424,
    3615, -3424, -3424, -3424, -3424, 36903, 36903, -3424, -3424,  2030,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  3073, 10661,
   44813, -3424,  3493, -3424,  3429,  1708,  3375,  3048, -3424,  3049,
     354,  3528, 45943, 45943, -3424,  3296, -3424,  3297, -3424, -3424,
   -3424,  3509, -3424, -3424, -3424, -3424, -3424, -3424, 30123, -3424,
   -3424, 14171,  3062,  3063, -3424, -3424, 33513, -3424,  3129, -3424,
    3068, -3424, -3424, -3424,  3376,  3069,  2033, -3424, -3424,   187,
   -3424,   399, 42553,  3596, 39163, -3424, -3424, -3424, -3424, 10661,
   -3424, 34643, 43118,  3061, -3424, -3424, -3424, -3424, -3424,  3226,
    2813, -3424,  3372, -3424, -3424, -3424,  2331, -3424, -3424,  3071,
    3511, -3424, -3424, 10661, -3424,  3516,  3154, -3424,  3075, -3424,
   44813,  1538, 44813, -3424, -3424,  3470,  3077,  1632, -3424,  3074,
   -3424, -3424, 44813,  3292, -3424, 10661,  3080,  3078, -3424,  2215,
     399,  3613, 44813, 39163, 40293,  3258, 43683,  3495, 39163,  5369,
    3496,  3497, -3424, 44813, -3424,  3465,   399, -3424, -3424, -3424,
    3170, -3424, 40858, -3424,  2487, -3424,  3112, -3424, -3424,  3563,
    2180, -3424, -3424,  3346,  3097, -3424, -3424, 44813, 44813, -3424,
   -3424, -3424, 28428, 10661, -3424,  3133, -3424, -3424, -3424,   714,
    3435, 18215,  3242, 41423, 44248, -3424, -3424, -3424, 25603, -3424,
   -3424, -3424,  3513, -3424,   399, -3424,  1419, -3424, -3424, -3424,
   33513,  2067, -3424, -3424, 22766, -3424, 28428, -3424, -3424, -3424,
   -3424, -3424, 21060,  3029, -3424, -3424
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3424, -3424, -3424,   164, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  1684, -3424, -3424, -3424, -3424, -3424,  1850, -1643,
   -3424, -3424, -3424, -3424, -3424, -3424,   740,  1511,  3094, -3424,
     752, -3424,   328, -3424, -3424, -3424, -2495,   157,   -73, -3424,
   -3424,   311,    29,  2793,  -162, -3423, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,   528,   526, -3424, -3424,   341,
   -3424, -3424, -1216, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424,  -324,  -277, -3424, -3424, -3424, -3424,   112,   355, -3424,
     358, -3424,   359, -3424,   360, -3424,   363,   368,   376,   379,
   -3424,   383, -3424, -3424,  -263, -3424, -3424, -3424, -3424,   384,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424,  -157, -3424, -3424,
       1, -3424, -3424,  -148,   391, -3424,  -110,   393, -3424,   394,
   -3424,   -17, -3424,   -13, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424,  2812, -3424, -3424, -3424,
   -1716, -3424, -3424, -2107,  2413, -3424, -1377, -3424, -3424, -1670,
   -3424, -3424, -1351,   938, -3424, -3424,   597,  -318, -3424, -1308,
   -1707, -1704, -3424, -3424, -3424, -1777, -1765,  -717,  2170, -1093,
   -1987, -3424, -3424, -3424,   386, -3424, -3424, -2246,  1971, -3424,
   -3424, -3424,  1166, -3424, -3424, -3424, -3424,  1340, -3424, -3424,
     996, -1271, -3424, -3424, -3424, -3424, -3424, -3424,   203,   369,
      97, -3424, -3003,   754, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424,   -97,   -19, -3424, -3424,  -100, -3424, -3424,  -140, -3424,
     210, -2039, -3424, -3424, -3424, -3424,  2390, -1170, -3424,  3328,
   -3424,  -492,   835,  1563, -1841, -1729,  -853,  -847, -2530, -3424,
   -3424, -3424, -3424,   512,  1151,  1182,   839,  1561, -2105,  1181,
    1246, -3424, -3424,   715, -3424, -3038, -3424, -3424, -3424,   676,
   -3424,   678, -3424, -3424, -3424,  -632,   641,  -358, -3424,   338,
   -2184, -3424,   510, -3424,   465, -3424,  -517, -1846, -2132, -3424,
   -3424, -3424,   480,   722,  1003, -3424, -2961, -2888, -3424, -3424,
      95, -3424, -3424, -3424,    87, -3424,   361,   202, -3424, -3424,
    -924, -2323, -3424, -3424, -3424, -2579, -2194, -3424,  1965,   151,
    1514, -3009,   276, -2221, -3424,   356, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  1766,  1594,  -990, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -2404,   743, -3424, -3424,  1219, -3424, -3424, -3424,
   -2043,  -482, -1572, -2442, -3424, -3424, -3424, -3424, -3424, -3424,
    1409, -3424, -3424,  2104,  2524, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,   534,  1764, -3424, -3424, -3424,
   -3424, -3424, -3424,   750,  2440, -3424, -3424, -3424,    -3, -3424,
   -3424, -3424, -3424,  2186, -3424, -3424,  2913, -3424, -3424, -3424,
   -3424,  1415,  1809, -3424, -3424, -3424,  -904,  1760,  -532, -1534,
   -3424,  3314, -3424, -3424, -3424, -1296, -1142, -3424,  3031,   439,
   -1732,  2183,  -598, -2376, -3424,  1105,  -627,  2678, -3424, -1063,
    -998, -3424, -3424,  -581, -3424, -3424, -3424,  -564, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  1450,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
    1187, -3424,  1969, -3424,  -436, -3424,  2838, -3424, -3424, -3424,
   -2036, -1567,  1721,  1034, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -2057, -3424, -3424, -3424, -3424, -3424, -3424,
   -1318, -3424, -1556,   429, -3424,   581, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424,    34,  1232,    28, -1863,  -999,  1593, -3424,
   -3424, -1187,  2881, -1808, -3424, -3424, -3424,  1881, -3424, -3424,
   -3424, -3424, -3424,   771, -2262, -1281, -3424, -3424, -2756,  -839,
   -2003,  -801, -3424, -2044,   600, -1735, -1632, -2091,   184, -1028,
   -3424, -3424, -3424, -3424, -3424,  -105, -3424, -3424, -3424,   622,
    1790, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  -558,  -460,
   -3424,  2023,  1874, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  2696,  2669,  1853, -3424, -3424, -2235, -3424, -3424,
    1813, -3424,   866, -2029, -1577,  1114, -3424, -3424,  1121, -2791,
   -3424, -3424, -3424, -3424, -3424, -3424,  1055,  -134,   110,  3377,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424,  2486,  2038,  3302,
   -3424, -3424, -3424, -3424, -3424,  2187, -3424, -3424, -3424, -3424,
   -3424,  2658,  3394,  -522, -1194, -3424,  -694, -3424, -3424,  -818,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  2298,
   -3424, -3424, -3424, -3424, -3424,  2688, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424,  1156,    -1, -3424,   325,   -31, -3424,   212, -3424,
   -3424, -3424,  -117, -3424,  -622,  -899, -1229,   592, -1738,  -767,
    1146,  2690, -2918,  -563, -1066, -1079, -2210,    70, -3424,  2411,
       9,  -728,  -112,    -7, -3309,  -121,  -526, -3424, -1906, -3424,
   -3424, -3424, -3424,  2254, -3424, -3424, -3424, -3424,  1444, -3424,
   -3424, -3424,  1115, -3424,   883,   672, -3424, -3424,  2211, -3424,
    2297, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424,  2711,  3432,  3130, -3424,  2773,
   -3424, -3424, -3424, -3424, -3424,   546, -3424,   707, -3424,    30,
    2548,   939, -3424,  1528,   -61,  -308, -3424,   552, -3424, -3424,
     283,  3445,  3145, -3424, -3424, -3424, -3424, -3424, -2420,  -807,
   -3424, -2464, -3424, -3424, -3424, -3424,  1995,  -961,  2875,  1578,
   -3424, -3424, -3424,    82,  3506,  3507, -3424, -3424,  -175, -3424,
     457, -3424, -3424, -3424, -3424, -3424, -3424, -3424, -3424,  3378,
   -3424, -3424, -3424, -3424,  3379, -3424, -3424, -3424, -3424, -3424,
    3381, -3424, -3424, -3424, -3424, -3424,  1740, -3424, -3424, -3424,
   -3424, -3424, -3424, -3424, -3424
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2314
static const short int yytable[] =
{
     455,   567,   974,   982,   881,  1143,  1336,  1017,  1019,   877,
     959,  1548,  1338,   490,   137,   907,   496,  1025,   491,  1243,
    1976,  1373,  2065,  1649,  1547,   509,  2544,   507,  2506,   950,
     951,  1153,  1266,   514,   919,   520,   453,  1303,  1500,  2758,
     732,  1716,  2435,  1784,  1056,  2017,   537,  2351,  2796,  2462,
    1567,  1272,  2354,  2836,  1759,  1001,  2182,  1575,  3080,  1304,
    1610,  2894,  1343,  1523,  1074,  2328,  2687,  1464,  1344,  3307,
    2672,  1076,  2677,   891,  1080,  1272,  1087,  1088,  1089,  2510,
    2511,  2241,  2301,  2492,  2496,  2498,   556,  2263,  2925,  2528,
    1723,  2564,  2273,   494,  2302,  1043,  2135,  3212,  2279,  2280,
    2481,  2194,  2283,  2519,  2195,  1850,  3402,  1732,   559,  1195,
     455,  2529,  1195,   990,   455,   566,   572,  1735,  1736,  1105,
    1106,  1105,  1106,  1577,  1578,   589,  1797,  1581,  1582,  1583,
    1584,   556,  1586,  1587,  1589,  1591,  1592,  1593,  1594,  1595,
    2944,  1138,  1613,  1340,  1105,  1106,   561,  1095,  1096,  1097,
     563,  3110,  2298,  3208,  2570,  2299,  3385,  2696,  2574,  1139,
    3233,  2700,  1195,   555,   843,   844,  3294,  1105,  1106,  2589,
    1891,  1762,  -762,   896,  3206,  1659,  3323,  3328,  2290,  2598,
    3329,  1888,  2890,  1397,  1305,  1190,  2157,  2158,  2653,  2606,
     843,   844,  1489,  1158,  3330,  1490,  1105,  1106,  2078,  3338,
    2554,  2555,  3184,  2169,  1187,  3359,  3860, -1295,   583,   942,
     577,  3185,  3658,  3659,  1105,  1106,  2982,   114,  1613,  3464,
    2187,  2188,  1105,  1106,  1156,  2863,  2791,  1340,  1140,  2983,
    3681, -2218, -1336,  2051,  1105,  1106,  1196,  3095,  1670,  1196,
    2862,   500, -1295,  2984, -1753,  3258,  1878,  3268,  2803,  2123,
    2011,  1340,  3790,   843,   844,   952,  -474,  1607,  1786,  3295,
    1105,  1106,  1235,   668,  1105,  1106,  2285,  2286,  2287,  2288,
   -1336,   611,  2524,  1105,  1106,   962,  3465,  1105,  1106,  3361,
    -475,  2314,  1224,  2525,  2305,  2970,  2826,  1083,   811,  1196,
    1347,  3451,  3094,  3448,   604,  1105,  1106,  1143,  2863,   789,
    2646,  2647,  1776,  2932,  1105,  1106,  1797,  2508,  2329,  1436,
    1201,  1994,  2827,  1780,  1328,  2633,  2607,  1105,  1106,   116,
    1856,  1814,  3860,  2514,   519,  3394,  2477,  3234,   612,  1313,
    1105,  1106,   897,  3851,  3629,   546,  1316,   136,   129,  1105,
    1106,  3186,  3473,  3425,   594,  3464,  2871,  1365,  1143,  1241,
    2858,   518,  1143,  1230,  1273,   132,   136,  2858,   133,  2052,
    2872, -2152,  1105,  1106,  2876,  2631,  3482,  1105,  1106,  1105,
    1106,  1418,  2658,  1420,  1421,  3486,   788,  3720,  2892,  2893,
     790,  1364,  2058,  1967,  2102,  1105,  1106,  1798,  2903,   138,
    1105,  1106,  1105,  1106,  1277,  2387,  1105,  1106,  1285,  3027,
   -2273,  1274,  3465,   512,  3721,  1317,  1314, -1336,  2478,   458,
    2864,  1398,  2632,  1322,  1105,  1106,   130,  2537,   580,  2113,
    1366,  2306,  1437,  2190,  1755,  1219,  2079,  1150,   989,  3474,
    1815,  2171, -2153,  1606,  1951,  1777,  2151,   812,  1105,  1106,
    3619,  3620,  1105,  1106,  2474,  2634,  1084,   692,   791,  2828,
     613,  1107,   585,  1107,  1108,  3411,  1108,  1717,   566,   572,
    1720,  2933,  2732,  2526,  1462,  3475, -2152,  2840,  1725,  2804,
    2114,  2831,  2659,  1023,  1784,  2558,   572,  1043,  1419,  2679,
    3296,  2874,  3920,   547,  2194,  1608,   783,  2195,  1343,  2971,
     566,   787,   793,  1780,  1344,  1737,  1738,  2124,   556,  1107,
    2193,  1329,  1108,  2849,   807,  2901,  2902,  3790,  1614,  2252,
    3710,  1141,  2241,  1610,  3299,  3676,  1105,  1106,  2301,  2321,
    3466,  2688,  1105,  1106,  1105,  1106,   556,   893,  1107,   953,
    2302,  1108,  2475, -1336,  1760,  1572,  2053, -2153,  3446,  2131,
    1850,   785,  2322,  3092,   909,  2956,  1107,   501,  2012,  1108,
    3096,  2297,  3852,   566,  1107,   923,   598,  1108,  3041,  1343,
    1580,  3682,  2935,  3925,  3925,  1344,  1107,  1798,   455,  1108,
     943,  -182,   556,  1447,  1448,   797,  3260,  1601,   948, -1295,
     556,   556,  3237,  2080,  1614,   960,   923,  1996,  2298,  2527,
     566,  2299,  1107,  1188,  1488,  1108,  1107,  1491,  1999,  1108,
    1492,  2002,  1617,  1502,   934,  1107,  1889,   996,  1108,  1107,
    1366,  1607,  1108,  2865,  1734,  1515,  1516,  1517,  1993,  2648,
     824,  -762,  2572,  2573,  1522,  2575,  1152,  1107,  2578,  2579,
    1108,  3756,  2582,  2967,  1785,  3562,  1107,  2591,   898,  1108,
    3795,  2594,  2595,  2596,  2597,  1191,  1366,  3093,  2601,  1107,
    2603,  1044,  1108, -2218,  2645,  1651,  2612,  1660,  2858,  2617,
    2618,  2619,  1107,  3209,  2955,  1108,  2801,  2802,  3104,  3597,
    1666,  1107,  1762,  1109,  1108,  1109,  1366,  3712, -1336,  2858,
   -2218, -1336,  2608,  3750,   988,  3752,  2557,  3331,  3378,  1786,
    1879,  1979,  1105,  1106,  1107,  2115,  1855,  1108,  1109,  1107,
    3269,  1107,  1108,  3233,  1108,  -474,  1105,  1106,  3311,  1102,
   -1336,  1104,  1105,  1106,  1105,  1106,  2651,  1107,  2509,  -390,
    1108,  1109,  1107,  3360,  1107,  1108,  2985,  1108,  1107,  -475,
    1269,  1108,  1105,  1106,  3849,  1147,   455,  1149,   923,   455,
     566,  1230,   455,   566,   556,  1159,  1107,  3908,  1744,  1108,
    1109,  2462,  1085,  1721,  3102,  1856,  3630,  3751,  3036,  3753,
    2686,   874,  1105,  1106,  1556,  1557,  2304,  1699,  1109,  1230,
    1107,  2866,  1148,  1108,  1107,  1151,  1109,  1108,  1155,   597,
    1200, -2152,  3070,  1897,  2970,  3855,  3074,  3857,  1109,  1898,
    1968,   556,  1105,  1106,  2660,  3738,  3061,   750,  3045,  2448,
     503,   566,   556,  3069,  1278,  1308,   556,  3073,  1286,  2482,
   -2152,  1221,  2556,   556,  1109,  1105,  1106,  3286,  1109,  2552,
    2518,   969,  2564,   808,  1105,  1106,  1140,  1109,  1764,  1899,
    2680,  1109,  1556,  1917,  1105,  1106,  1596,  2974,  2875,  1608,
    2877,  2856,  1952,  3711,   566,  1956,  1957,  2888,  1107,  1109,
    2194,  1108, -2153,  2195,  1107,  2336,  1107,  1108,  1109,  1108,
    2900,  3459,  1784,  1973,  1974,  2253,  2909,   786,  1210,  3298,
    3234,  1109,  2733,  2835,  3811,  2301,   803,   461,  2976,  1227,
    2858, -2153,  2924,  2193,  1109,  2589,  1904,  2302,  1105,  1106,
    1986,  2128,  2241,  1109,  1716,  1716,  1745,  1299,  2405,  2406,
    1746,  1105,  1106,  2997,  1339,  2126,  1818,  2717,  2718,  2863,
    2099,   504,  1105,  1106,  2130,   912,  1109,  2133,  2134,  1254,
    2156,  1109,  3556,  1109,  2368,  3654,   556,  3016,  2404,  1272,
    1880,  3800,   556,  3203,  1758,  1369,   556,  3317,  2515,  1109,
   -1605,  3999,  1923,  3287,  1109,  2298,  1109, -1627,  2299,  2078,
    1109,  1270,  3387,  2734,  2735,  1436,  3831, -2276,  1272,  1905,
    2755,  2756,   970,  2534,   499,  1915,  3235,  2140,  1109,  2841,
    2842,  3336,  3337,  1105,  1106, -1628,  2681,  1195,  3288,  3340,
    1270,  1850,  1562,   556,  1426,   556,  3364,  2297,  2971,  1343,
    1105,  1106,  1109,  2547,  1780,  1344,  1109,  1436,  2409,  2410,
    1400,  3427,   511,  1359,  2887,  2003,   815,  1916,  1780,  1548,
    1797,  1919,  3887,   583,  3279,  3280,  2895,  3663,   954,  1600,
    1044,  -558,  2466,  1977,  1107,  1105,  1106,  1108,  1597,  2403,
    1105,  1106,   607,  1044,  2001,  3274,  1105,  1106,  1107,  2413,
    3079,  1108,  1214,  1301,  1107,  1215,  1107,  1108, -1336,  1108,
    1598,   524,  3034,  1758,  1105,  1106,  2059,   976,   984, -2276,
    1425,  1987,  1429,   596,  1107,  1785,  2022,  1108,  1452,  1548,
    1109,  3655,   926,  3739,  1105,  1106,  1109,  1786,  1109,  3600,
     748,  2714,  2532,  1549,  1980,  1931,  2015,  1631,  1302,  3601,
    2141,  1939,   955,  1943,  1107, -1627,   566,  1108,  1658,  1417,
   -1336,  1401,  2548,  1309,  1196,  1402,  1105,  1106,  2142,  1141,
    1507,   816,  1607,  3236,  2310,  2060,  1310,  1403,   913,  2143,
    3083,   927,   804, -1628,  1107,  3237,  1607,  1108,  1105,  1106,
   -1336,  1855, -1336,   566,  1371,  2311,  2074,  2075,  1604,  3680,
    3213,  2061,  2303,  1122,  2689,   914, -1336,  1107,    43,  2549,
    1108, -1336,  1981,   556,  1105,  1106,  1107,   532,  1372,  1108,
    2176,  3740,  3389,  2908,  3664, -1336,  1107,  3812,  -390,  1108,
    1142, -1336,  1105,  1106,  2116,  1300,  2998,  2079,   817, -1336,
    2011,  1216,  3736,  1105,  1106,   549,   668,  3741,   971, -1336,
    1636,  2389,  1639,  2144,   556,   928,  1856,  1780,   505,  3693,
   -1336,   668,  2304,  1599,  2982, -1336,   556,  2062,  2497,  3238,
     531,  1643,   566,  2682, -1336,  1105,  1106,  2983,  1203,  2177,
    1107,   556,   556,  1108,  -558,  1105,  1106,  1766,  1672,  1436,
    1311,  2984,  1675,  1107,   534,  1255,  1108,  1404,  1105,  1106,
    1684,   843,   844,  1241,  1107,  2178,  1109,  1108,  1988,  2193,
    2144,  3101,  1312,   455,   455,   455,   556,   455,   556,  1098,
    1109,  1944,   874,  1696,  1989,  1706,  1109,  2637,  1109,  1718,
     455,  1798,   566,  2845, -1336,  1945,   874,   550,   455,  2063,
     935,  1946,  2638,  1950,  2226,  1632,  1109,  3602,  2588,  1700,
    1701,  1702,   243,  1704,   245,  1436,    55, -1336,   556,  2145,
    3899,  1969,   551,  1105,  1106,  1107,  1719, -1336,  1108,  1105,
    1106,  2179,   608,  2784,  1724,  3289,  1109,  3665,  1204,  1707,
    3874,  3105,  1107,  1125,  1676,  1108,  2229,   972,  2099,  1405,
     562,  2715,  3883,  1703,  2080,  1705, -1336,  1744,  3785,  1982,
    1608,   566,  1511,   557,  2297,  3494,  1109,  3786,  2754,  3558,
    2663, -1446,  1105,  1106,  1608,   556,  3728,  1107,  2146,   556,
    1108,  2716,  1107,  1796,  3393,  1108,  3495, -2313,  1107,  1109,
     692,  1108,  2100,  1843,  1817,  1733,  1366,  1548,  1109,  3626,
   -1336,  2170,  -558,  2180,  2727,   692,  1107,   609,  1109,  1108,
    2787, -1446,   929,  2737,  2852,  1363,  1023,  1105,  1106,  3729,
    3496, -1336,  1656,  2738,  1633,  1205,  1107,  1463,  1534,  1108,
     566,  1023,   455,   455,   455,  1867,   455,   538,  1105,  1106,
    1105,  1106,   560,   996,  3599,  1877,  1673,  3735,  1105,  1106,
    2408,  2613,  1816,  3085,   529,  1105,  1106,  1677,  1107, -1336,
    3603,  1108,  1109,  2614,  1657,  1424,  2776,   527,  1863,  1864,
    1865,   528,  1024,  1785,   930,  1109,   931,  3221,  2444,   539,
    1107,  2664,  2140,  1108,  2356,  3546,  1109,  1075,  3056,  1892,
    2064,  3580,  3500,  1105,  1106,  1105,  1106,  2362,  2012,  2846,
    1896,  1105,  1106,  1708,  3501,  1745,  1107,  3057,  2007,  1108,
    3581, -1336,  2982,  1105,  1106,  2008,   530,  2018,  1044,  1924,
    1758,  2007, -1336, -1336,  1107,  2983,  2621,  1108,  2812,   575,
    2377,  1105,  1106,  2896,  1780,  1107,  3058,  3730,  1108,  2984,
   -1336,  1548, -1336,  3028,  1105,  1106,   540,  1109,  1366,   843,
    3324,  3086,  2084,  1744,  2907,  1105,  1106,  1105,  1106,  3787,
    3848,  1903, -1336, -1336,  1109,  1633, -1336,  1107,  1287, -1336,
    1108,  3547,  1787,  1105,  1106,   573,  1985,  1107,  1906,  2304,
    1108,  3627,  1105,  1106,  3458,  3029,  1105,  1106,   957,   958,
    1107,  2419,  1855,  1108,  2181,  1105,  1106,  1288,  2303,  1109,
     116,  1105,  1106,  2897,  1109,  2141,  1105,  1106,   585,  2321,
    1109,  1105,  1106,  1907,  1134,  1135,  1136,  1137,  2009,  1105,
    1106,  1105,  1106,  2142,  1914,   566,  3458,   586,  1109,   556,
    4005,   566,  2322,  2615,  2143,  3546,  3546,   556,  1289,  2024,
    1105,  1106,  1927,  1290,  2029,  2029,  1844,  2029,  1109,  1105,
    1106,  2665,  1607,  3840,   589,  1107,  2391,  2859,  1108,  2859,
     556,  1107,  1928,   556,  1108,  1105,  1106,   591,  1686,  1105,
    1106,   605,  3628,  1788,  3502,   566,   566,   556,   556,   467,
    1109,  1243,  3803,  3447,   668,  2029,  2029,  2029,  2832,  2073,
    3568,  3569,  3570,  3571,  1932,  2898,  2084,  3975,   593,  2092,
    3388,  1745,  1109,  2111,  1107,  1746,  2016,  1108,  2144,  1105,
    1106,  2979,  2122,  1105,  1106,   741,  1936,  2834,  1845,  3548,
     745,  2028,  2028,  2118,  2028,   784,  1272,  1991,  1109,  3980,
    2990,  2991,  3594,   752,  2985,  1548,  1687,  2050,  1105,  1106,
    1210,  2666,  1937,  1105,  1106,  3981,  1109,   556,  2466,  1107,
    2059,  3003,  1108,  3595,  1227,  2077,  2291,  1109,  3357,  2139,
    1938,  2411,  2028,  2028,  2028,  3184,   556,  3725,  1716,  3726,
    1107,  1942,  1107,  1108,  3185,  1108,  3931,  3546,  3546,   541,
    1107,  1291,   796,  1108,  1918,  2559,  3358,  1107,  1548,  1109,
    1108,  3204,  2352,  1895,  1142,   800,  2160,  2352,   474,  1109,
     542,  2532,   874,  1947,   488,  2167,  2168,   802,  1918,  2060,
    2086,  2087,  1109,  1955,  2145,  3227,  2172,  2173,  2174,  2175,
     888,  2183,  2184,  1688,  2132,  1107,  1960,  1107,  1108,   543,
    1108,  1789,  2261,  1107,   908,  2061,  1108,  1122,   132,  2003,
    1790,   133,   812,  2150,  2790,  1107,  1791,   787,  1108,   916,
    1292,  1846,  2264,  2265,   933,  2272,   925,  2274,  2275,  2276,
    2277,  2278,   946,  1107,  2281,  2282,  1108,   935,   692,  3332,
     566,  1122,  3333,  2146,   963,  2307,  1107,  1109,  3546,  1108,
    1608,   544,  2401,  1109,   556,  1356,  1357,  1107,  2585,  1107,
    1108,  1975,  1108,  3546,  1023,  2559,   964,  2691,  1911,  1142,
    3276,  2062,   991,  3097,  3186,  1107,   566,  3546,  1108,  1920,
    1142,   566,  1293,  2422,  1107,  1797,   968,  1108,  1107,   843,
     844,  1108,  1415,  1689,  2084,  1371,  1109,  1107,  1763,   114,
    1108,  1792,  2085,  1107,  3108,   998,  1108,   999,  1107,   898,
    2705,  1108,  3111,  1107,  2266,  3113,  1108,  2783,  1000,  1372,
    1079,  1107,  1002,  1107,  1108,  2303,  1108,   886,   887,  -557,
     890,  2326,  2859,  3173,  3694,  1711,  1122,  1003,  2559,  1921,
    1505,  1109,  1107,  2063,  3546,  1108,  1548,  1933,  1142,  2560,
    2838,  1107,  1380,  1381,  1108,  2711,  3546,  3546,  1004,  2787,
    2753,  2825,  1109,  1007,  1109,  1008,   566,  1107,  2585,  1009,
    1108,  1107,  1109,  2267,  1108,  1142,  2712,  1145,  2719,  1109,
    1934,  1142,  2352,  1294,  2500,  2505,  2723,  1125,  1793,  1935,
    1142,  2420,  2985,  2724,  2588,  3699,  3546,   566,  3702,  3703,
    3704,  3705,   970,  3670, -1605,  1371,  3546,  1712,  2086,  2087,
    1010,  1107,  3325,  3162,  1108,  1107,  1295,  1109,  1108,  1109,
    1548,  1125,  1940,  1142,  1011,  1109,  2543,  2352,  1843,  1372,
    1146,  2725,   675,  2907,  3546,  1893,  3546,  1109,   874,  2726,
    1107,  -557,  2088,  1108,  1161,  1107,  3546,  2561,  1108,  1012,
    -557,  2728,  3884,  2886,  2452,  1109,  3546,  1013,  3546,  2559,
    3546,  2587,  3825,  1797,  1176,  2268,  1014,  3546,  1109,  2731,
    2560,  2467,  1780,  1178,  1894,  1142,  3546,  1767,  1371,  1109,
    1015,  1109,  2736,  3218,  1392,  1393,  1105,  1106,  1768,  2486,
    2488,  3546,  3546,  2739,  3797,  2741,   566,  1109,   566,   566,
    1259, -1605,  1372,  1179,  1018,  2485,  1109,  3546,  3546,  1843,
    1109,  1195,  3546,  3817,  3818,  1628,  1125,  1020,  1629,  1109,
    2743,  1630,  3830,  1183,  2745,  1109,  1127,  1128,  2185,  2186,
    1109,  1549,  1193,  2746,  2064,  1109,  1021,  2269,  1185,  2747,
     566,   566,  1022,  1109,  3008,  1109,  1798,  2397,  1142,  3009,
    2340,  1568,  2426,  2427,  2729,  1142,  1260,  3010,  2586,  3220,
    1127,  1128,  -557,  1797,  1109,  2793,  2794,  1026,  2561,  1780,
     641,  2587,  1027,  1109,  1028,  2341,  1180,  1194,  3226,  1440,
    1441,  1442, -1336,  1202,  1261,   843,   844,  3228,  1029,  1109,
    1607,  1453,  1030,  1109,  1031,   827,  2693,  2293,  1713,  1371,
    1032,  3916,  1208,  3229,   134,  1033,  2059,  3230,  1034,  1843,
     459,   460,  1105,  1106,  2968,  2969,  2342,  1035,  2616,  2343,
    1181,  1038,  1508,  1372,  3989,  1512,  1039,  2344,   971,   646,
     506,  2562,  2630,  1109, -1336,  1182,   513,  1109,  1196,  1045,
     517,  1046,  1769,  1001,  -557,  1530,  1531,  3231,  1047,  1535,
    1780,  3565,  3013,  1142,  1130,  1131,  1132,  1133,  1134,  1135,
    1136,  1137,  1109,  3031,  3032,  2060, -1336,  1109,  1550,  1551,
     902,   903,  2996,   904,  1048,   905,  1209,  3115,  2969,  2176,
   -1336,  1844, -1605,  1049,  2644, -1336,  1050,  1607,  1130,  1131,
    1132,  1133,  1134,  1135,  1136,  1137,  1051,  2293,   556,  2630,
    1465,  1466,  1467,  1468,  1469, -1336,  1052,   556,   828,  1053,
    3014,  1770,  1222, -1336,  2176,  1055,   957,   958,  1057,  3404,
     935,   657,  1569, -1336,  1798,  1058,  2140,  2563,  2270,  2031,
    1059,  2032,   578,  1060, -1336,  1771,  3178,  3179,  2177, -1336,
     874,  1061,   743,   744,   114,   746,   747,  1062, -1336,   749,
    1780,   751,  3191,  1845,  1063,  3442,  3443,  3819,  3114,  3214,
    3215,  1064,  1844,  1065,  2178,  -557,  1066,   972,  1607,  2094,
    2095,  2096,  1470,  2177,  1067,  2668,  3222,  1142,   829,  1233,
    3232,  1142,  1262,  1122,  2685,  1132,  1133,  1134,  1135,  1136,
    1137,  3582,  1234,   673,  1772,  1471,  1472,  1473,  1474,  2178,
    3245,  3246,  -557,  3313,  1366,  1068,  2776, -2313, -1336,  1069,
    2024,  1070,  1200,   566,   566,   566,  3405,  3406,  1608,  3583,
    1071,  3407,  3408,   556,  1798,  3375,  2186,  1072,   115,  3820,
    2179, -1336,  3560,  3561,  2345,  1073,   566,   874,  3779,  1549,
    1077, -1336,  1237,  1121,  1078,  2189,   116,  1081,  2563,  2141,
    2764,  2765,  2766,   566,   566,   566,  3210,  3578,  3579,  1082,
    2422,  1086,  1844,  1090, -1605,  2179,  2811,  2142,  1607,  1091,
   -1336,  1092,  2813,  1469,  2815,  1093,  1773,  1094,  2143,  1144,
     566,  1238,  2810,  1241,  1548,  3318,  1846,  2422,  3321,  3322,
    2798,  2799,  2800,  1475,  1244,  1476,  1477,  1478,  3613,  3614,
    2050,  1263,  2180,  1252,  1479,  3334,  3618,  3032,  1253,  1570,
    1400,  1258,   117,  1257, -1336,  1608,  3621,  3561,   874,  3733,
    3561,  1264,  1270,  -557,  1279,  1571,  3734,  3561,  3744,  3745,
    3584,  3746,  3747,  3748,  3747, -1336,  1284,  2180,  1122,  -808,
    1280,  1470,  2289,  2630,  1107,  3841,  3614,  1108,  1281,  2861,
    2630,  1282,  2144,  2630,  3842,  3614,  1283,  2630,  2873,  2882,
    1306,  1265,  1307,  1125,  2883,  1321,  2346,  1474,  1323,  2882,
    3638,  2630,  2630, -1336,   566,  3277,  3638,  2884,  2885,  1324,
    1480,  2630,  1331,  1549,   700,  1326,  2904,  3890,  3891,   118,
    1340,  2912,   556,  1346,  1122,  2033,  1608,  2914,  2915,  3897,
    3898,   566,  2911,  3907,  3032,  3585,  3942,  2643,  2630,  2931,
    1348,  1401,  4008,  4009,  1881,  1402,  2034,  1160,   874,   455,
    3821,  1350,  3586,  2949,  2347, -1336,  2261,  1403,  1481,  1482,
    2035,  4015,  1353,  2954,  3912,  1123,  1354, -1336,  1358,  2036,
    4051,  4052,  3414,  1361,  3587,  2964,   830,   831,   832,   833,
     834,   835,   556,  2348, -1336,  2945, -1336,  1124,  2145,  1362,
    1538,  1539,  1409,   836,  3823,  3823,  1478,  1410,   119,  2913,
    1411,  2140,  1414,  1479,   120,  3053, -1336, -1336,  3622,  3623,
   -1336,  3048,  3049, -1336,  1925,  1416,  2037,  2038,  1929,  3810,
     753,  2543,  1417,  2181,  3018,  3019,  1608,  1422,  2199,  2200,
    3243,  3244,  1127,  1128,  1423,  1430,  1140,  1432,   799,  1436,
     121,  1953,  1443,  1548,  2039,   810,  1455,  2146,  1125,   620,
    1457,  1085,  1494,  2652,  3974,  1504,  3976,  1505,  2181,  2966,
    -682,  -682,  2202,  3012,  1506,  1563,   894,   957,   958,  -682,
    1546,  2486,  1243,  2205,  1558,  1579,  3992,  1404,  1585,  1480,
    1611,  2206,  1612,  1605,  1616,  2352,  1483,  2485,  2199,  2200,
    1618,  1621,  1622,  1623,  1625,  2452,  1109,  1484,  1485,  1626,
    1644,  2208,  2040,   122,  1125,  1645,  1648,  2467,  3043,   620,
     566,  4023,  4024,  1654,  1650,  1340,  3452,  1662,  2209,   566,
    -682,  -682,  2202,   641,  2141,  2420,  1663,  1664,  1482,  -682,
     874,  1665,  1671,  2205,  3810,   566,  3833,  3834,  1679,  3836,
    1126,  2206,  2142,  2111,  1685,  3588,  2214,  3044,  1694,  3341,
    1025,  1076,  1080,  2143,  2041,  1698,  1722,   123,  1726,  -808,
    1549,  2208,  1132,  1133,  1134,  1135,  1136,  1137,  3856,  1405,
    1727,  1728,  1729,  1731,   645,  1340,  3452,  1739,  2209,  1743,
    1741,  2630,   646,   641,  3641,  2352,  2882,  1127,  1128,  1765,
    3342,  1820,  1756,  1366,  3343,  1811,  1819,  1821,  1129,   566,
    1822,  1823,  2630,  1767,  1824,  1825,  2214,   739,   650,  1826,
    1827,  1828,  2217,  3810,  1768,  1829,  3103,  2882,  3592,  1838,
    2218,  1830,  1831,  1832,  3106,  2882,  1833,  2144,  2882,  1834,
     477,  1835,  1836,   739,   645,  2219,  3344,  1837,  1839,   556,
    1857,  1858,   646,  1127,  1128,  3116,  1860,  1875,   556,  3265,
    3281,  1122,  3172,  3789,  1862,  1483,  3901,  1871,  3902,  3903,
    1882,  1884,  1548,  1885,  1902,  1886,  1910,  1485,   650,  1901,
    1922,  2916,  2217,  2917,   657,  4043,  3175,  1908,  1909,  1918,
    2218,  1912,  2630,  3480,  3481,  1548,   478,  2220,  3345,  1926,
    1930,  1948,  1949,  1548,  3195,  2219,  3484,  1954,  1970,   566,
    1958,  1959,  3488,  1971,  2221,  1972,  4043,  1984,  2315, -1058,
    2918,  1990,  1137, -1175,   479,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  2000,  2019,  3117,  3511,  2044,  2020,  3513,
     668,  2919,  2047,  2145,   657,  3749,  3671,  2056,  2071,  2068,
    2093,  3491,  2107,  3254,  -808,   672,   673,  2220,  1549,  2119,
     739,  2121,  2125,  2127,  2149,   739,  2148,  -696,  2225,  2152,
    2153,  2155,  2159,   566,  2221,  2920,  2227,  1122,  1769,  2161,
    2254,  1130,  1131,  1132,  1133,  1134,  1135,  1136,  1137,  2162,
    2163,  2166,  2164,  2292,  2165,   739,  2313,  2327,  3592,  2324,
     668,   480,  2146,  2334,  2330,  3275,  2339,  2357,  2358,  3794,
    2359,   739,  2008,  2630,  2398,   672,   673,  2369,  2399,  2352,
    2417,  2630,  2370,  2882,  3792,  2382,  2425,  2407,  2225,  2400,
    2416,  2443,  1549,  2438,  2428,  2882,  2227,  2429,  1122,  2233,
    2430,  1125,  2431,  2432,  2440,  4037,  2442,  1770,  2445,  2453,
    2446,  2457,   739,   739,   739,   739,  2469,  2470,  2471,   957,
     958,  2472,  2100,  2099,   739,  3346,  2489,  2490,   957,   958,
    2491,  1771,  3347,  2513,  1941,  3053,  2512,  2516,  2520,  2521,
     119,  2522,  2538,  2545,  2546,  2559,   120,  2571,  2576,  2577,
    2581,  2583,  2234,  2580,  2584,  2590,  2592,  2593,  2599,  2233,
    2600,  2604,  3372,  2636,  2605,  2649,  2650,  2235,  2610,  3348,
     794,  1112,  1113,  2611,  2643,  2654,  2964,   -59,  2640,  2655,
    2656,  3376,   481,  2642,   692,  3392,  2226,  2236,  3453,  1758,
    1772,  3454,  2657,   566,  2237,  2720,  1876,  2701,  2694,  2697,
    2750,  2702,   698,  2703,  2704,  2238,  1114,   700,  2706,  2707,
     701,  2543,  2234,  2752,  2757,  1115,  2760,  1125,  2762,  2767,
    2769,  2773,  1214,  2778,  2921,  2795,  2781,  2235,  2782,  2789,
    2792,  2797,  3349,  2808,  2809,  3418,  2814,  2822,  2833,  2839,
    1127,  1128,  2843,  2844,   692,   482,  2889,  2236,  3453,   566,
    2847,  3454,  1116,  2891,  2237,  2943,  2926,  2678,  2940,  3455,
    3456,  2939,   698,  1117,  2922,  2238,  2946,   700,  3440,  2947,
     701,  2951,  1773,  3350,  2953,  2960,  2958,  3888,  1125,  -397,
    2977,  2965,  2084,  3392,  2981,  2988,  2989,  2999,  2992,  3011,
    1118,  3000,  1005,  3024,  3035,  3461,  3026,  3046,  4049,   483,
    3054,  3066,   484,  3067,  3062,  3063,  3090,  3071,  3072,  2252,
    3174,  3084,  3091,  3176,  3192,  2316,  3100,  3182,  3200,  3455,
    3456,   485,  1037,  3109,  3206,   566,  3193,  3351,  3223,  3224,
    3225,  3965,  3196,  3197,  3202,  3241,  3205,  3248,  1054,  3792,
    3261,  3216,  3490,  3246,  2812,  1119,   486,   739,  3217,  3219,
    3249,  3514,  3250,  3266,  3262,  3252,  1127,  1128,  3259,  3267,
    3272,   487,  3270,  3273,  3553,   556, -1258, -1263,  3301,  1131,
    1132,  1133,  1134,  1135,  1136,  1137,  3302,  3319,  3368,  3395,
    3965,  3379,  1100,  1378,  1379,  1380,  1381,  1382,  1383,  3285,
    1384,  1385,  1386,  1387,  1388,  1389,  1390,  3300,  1391,   739,
     739,  3315,  3316,  3397,  3592,  3398,  3399,  3400,   739,   739,
     739,   739,   739,   739,   739,  3339,  3362,  1127,  1128,   739,
    3363,  4032,   739,   739,  3380,   739,  3365,   739,  3412,  3401,
    3428,   739,  3392,  3392,   739,   739,   739,   739,  3419,   739,
     739,  3431,  3554,  3434,  3471,  3436,  3449,   739,   739,  3632,
     739,   739,   739,   739,   739,  4032,   739,  3432,   739,   739,
     739,   739,   739,   739,   739,   739,   739,   739,   739,  3438,
    3450,   739,   739,  3472,   739,  3479,   739,  3357,  3485,  3487,
     739,  3498,   739,   739,  1130,  1131,  1132,  1133,  1134,  1135,
    1136,  1137,  3483,  3499,   739,   739,  3503,  3506,  3505,  3507,
     739,  3653,  3508,   739,  3509,  3510,  3660,  3512,  3515,  3555,
     739,   739,   739,  3563,   739,  3564,  3573,  1392,  1393,  3567,
    3574,   739,   739,   739,  1163,   739,   739,   739,   739,   739,
    3606,   739,   739,   739,   739,   739,   739,   739,   739,  3608,
    3610,  3612,   739,   739,  3392,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  3576,  3625,  3615,  1549,   556,  3642,  3643,
    3634,  3649,  3418,  -267,  3635,  3640,  3644,  3645,  3667,  3646,
    3647,  3672,  3215,  3677,  3826,  3679,  3688,  3697,  3700,  3701,
    3669,  3706,  3698,  3709,  3713,  3715,  3716,  3717,  3718,  3724,
    3756,  3759,  -285,  3440,  3788,  3440,  3737,  3727,  3798,  3784,
    3801,  3805,  1164,  3802,  3827,  3835,  3837,  3838,   463,  3843,
    3844,  2935,  3850,  3845,  1377,  3846,  3863,  3864,  3868,  3876,
    3879,  3904,  3913,  3908,  3915,  3875,  3877,  3917,  3918,  3921,
   -2073,  3927,  3928,  3929,  3692,  3934,  3935,  3940,  3947,  3760,
    3939,  3960,  3941,  3961, -1408,  3971,  3969,  3972,   739,  3973,
    3977,  3978,  3988,  3987,  3982,  3991,   739,  3995,  3997,  4000,
    4001,  4003,  1165,  4007,  4011,  4013,  1434,  1435,  4020,  4021,
     756,   757,  4035,  4038,  4044,  1445,  1446,  4048,  2284,  1449,
    1450,  1451,  3662,  3181,  1166,   981,  1456,  2553,   566,  1458,
    1459,  -808,  1460,  2424,  1461,  3550,  3832,  3674,  3816,  2422,
    3183,  1496,  1497,  1498,  1499,  3878,  1501,  1352,  3381,  3384,
    3930,  3552,  4054,  4016,  1509,  1510,  3526,  1513,  1514,  3527,
    3529,  3530,  -808,  1518,  3532,  1519,  1520,  1521,  3854,  3533,
    1524,  1525,  1526,  1527,  1528,  1529,  4025,  3534,  1532,  1533,
    3535,  1536,  3944,  1537,  3536,  3537,   758,  1540,  3861,  1544,
    1545,  3945,  3540,  3926,  3541,  3542,  3873,  2352,  2910,  3872,
    1809,  1552,  1553,  3557,  1413,  3937,  2010,  1100,  3033,   464,
    1559,  2239,  3696,  3575,   759,  2777,  3255,  1564,  1565,  1566,
     757,  1167,  3806,  3893,  3933,  1549,  3964,   760,  3938,  1168,
    3708,   606,  1842,  3198,  2620,  3445,  2957,  2930,  3199,  2936,
    2627,  2867,  3366,  3303,  3326,  3636,  3327,  3460,  3504,   761,
    1602,   762,  3489,   566,  3306,  3060,  3894,  3895,  3847,  1169,
    3633,  3853,  3743,   763,  2323,  3799,  2684,  3687,  2261,  2261,
    2929,  3639,  2624,  3305,  1742,  2137,  3463,  2454,  1840,  3304,
    2076,  2199,  2200,   764,   739,  2772,  1370,  2473,   119,  2441,
     906,  3593,  2098,  3015,   120,   758,  1170,  2759,  2355,  1248,
    2533,  3068,  3617,  3444,  3906,  2952,  3867,   765,  1503,  3905,
    3309,   566,  2414,  4006,   766,  2202,  3441,  3824,  3430,   566,
    1171,  3867,  2480,   759,  2325,  1454,  2205,  1642,  1667,  2437,
    2460,  3257,  3078,  3039,  2206,  3880,   760,  3949,  1172,  3038,
    4053,   133,  3886,   895,  3957,  2331,  1874,   997,  2129,  4050,
     880,  2021,  1669,   767,  2208,  1682,  1710,  3025,   761,  3719,
     762,  3963,  3985,  1697,  3839,  4055,  3493,  1683,  1340,  2108,
    3042,  2209,   763,  2830,  3271,  3064,  3433,  2055,  1674,  3566,
     823,  1236,   739,   739,   739,  2761,  1465,  1466,  1467,  1468,
    1469,  3572,   764,   465,   825,  1861,  3993,  1635,   739,  2214,
    1240,  3998,  2396,  1554,  2749,   600,   601,     0,     0,   985,
     986,  -808,   987,     0,     0,     0,   765,     0,     0,     0,
     739,     0,     0,   766,     0,     0,   739,     0,     0,   739,
       0,   739,     0,     0,     0,  4033,     0,   739,     0,   739,
     739,     0,     0,     0,  1549,     0,     0,   466,     0,  -480,
     467,     0,     0,     0,  3867,     0,     0,     0,  1470,     0,
       0,     0,   767,   566,  3959,  2217,     0,  1549,     0,  4033,
       0,     0,     0,  2218,     0,  1549,   768,     0,     0,     0,
       0,  1471,  1472,  1473,  1474,     0,  -808,     0,  2219,     0,
       0,     0,     0,     0,   468,   769,     0,     0,     0,     0,
     739,   770,     0,     0,  3984,     0,     0,     0,     0,   771,
       0,     0,     0,     0,     0,     0,  3867,     0,  3867,     0,
       0,     0,     0,     0,     0,  4002,     0,     0,     0,     0,
       0,     0,   772,     0,  3867,     0,     0,     0,     0,     0,
    2220,     0,     0,     0,     0,   773,   774,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,  2221,     0,     0,
       0,     0,     0,     0,     0,  3867,  3867,     0,  2196,     0,
    4047,     0,     0,     0,     0,  2197,  2198,     0,     0,  1475,
       0,  1476,  1477,  1478,     0,   768,   775,  2199,  2200,     0,
    1479,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   769,     0,     0,     0,     0,     0,
     770,  2225,     0,     0,   776,     0,     0,  2201,   771,  2227,
       0,  2202,  2203,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,  2205,     0,     0,     0,   777,     0,   778,     0,
    2206,   772,     0,     0,     0,     0,     0,  2207,     0,  1962,
    1964,  1966,     0,     0,   773,   774,     0,     0,     0,     0,
    2208,     0,   739,     0,     0,     0,  1480,     0,     0,     0,
       0,     0,     0,     0,  1340,     0,     0,  2209,     0,     0,
       0,     0,  2233,     0,  2210,  2211,     0,  1992,     0,     0,
       0,  2212,     0,     0,     0,   775,  1997,     0,  1998,  2213,
       0,     0,     0,  -789,     0,  2214,     0,     0,     0,     0,
       0,     0,     0,     0,  1481,  1482,     0,     0,     0,     0,
     739,     0,     0,   776,   739,     0,     0,     0,     0,   739,
     739,     0,     0,  2215,     0,  2234,     0,     0,   739,     0,
       0,   739,     0,     0,     0,   777,     0,   778,     0,     0,
    2235,   739,     0,   739,   739,     0,   739,   739,   739,   739,
     739,     0,     0,   739,     0,     0,     0,  2072,     0,  2216,
    2236,  2217,   739,     0,     0,     0,     0,  2237,     0,  2218,
     739,     0,   739,     0,   739,   739,   739,   739,  2238,     0,
       0,   739,   739,   739,  2219,     0,     0,     0,   739,   739,
     739,     0,   739,     0,   739,     0,   739,     0,   739,     0,
     739,     0,     0,     0,     0,   739,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   739,     0,     0,     0,     0,
       0,     0,   739,     0,     0,   739,     0,     0,     0,     0,
       0,   739,  1483,     0,   739,     0,  2220,     0,   739,     0,
       0,     0,     0,  1484,  1485,     0,     0,     0,     0,     0,
       0,     0,     0,  2221,     0,     0,     0,  2222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   821,
     757,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2223,     0,     0,     0,     0,
    2224,     0,     0,     0,     0,     0,     0,  2225,     0,     0,
       0,     0,     0,     0,  2226,  2227,     0,     0,     0,  2262,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   758,  2229,  2230,  2231,  2232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2333,  2233,     0,
       0,  2335,     0,   759,     0,     0,  2337,  2338,     0,     0,
       0,     0,     0,     0,     0,  2353,   760,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2360,     0,
    2361,     0,     0,  2363,  2364,  2365,  2366,  2367,   761,     0,
     762,     0,     0,     0,     0,     0,     0,     0,     0,  2371,
       0,  2234,   763,     0,     0,     0,     0,  2372,     0,  2373,
       0,  2374,  2375,  2376,     0,     0,  2235,     0,  2379,  2380,
    2381,     0,   764,     0,     0,  2383,  2384,  2385,     0,  2386,
       0,  2388,     0,  2390,     0,  2392,  2236,  2393,     0,     0,
       0,     0,  2394,  2237,     0,     0,   765,     0,     0,     0,
       0,     0,  2402,   766,  2238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2412,     1,
       2,  2415,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     0,     4,     0,     0,     0,
       5,     0,   767,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     8,  -789,     0,     0,     9,    10,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    11,     0,
       0,     0,     0,   739,     0,     0,     0,   739,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   739,
     739,     0,     0,     0,    13,     0,     0,     0,     0,     0,
       0,     0,    14,    15,    16,     0,     0,     0,     0,   739,
       0,     0,     0,     0,    17,    18,     0,     0,   739,     0,
     739,     0,   739,   841,     0,     0,     0,    19,     0,     0,
       0,     0,     0,   803,   842,     0,     0,   739,     0,    20,
       0,     0,   739,     0,     0,   768,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,   843,   844,     0,
       0,     0,     0,     0,   769,   739,     0,   845,     0,   846,
     770,    22,     0,     0,     0,   739,    23,     0,   771,    24,
       0,     0,     0,     0,   847,     0,   848,     0,   849,     0,
       0,     0,     0,     0,     0,     0,   850,     0,     0,     0,
       0,   772,    25,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   773,   774,     0,     0,     0,     0,
      27,     0,     0,   739,     0,     0,     0,   739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,     0,     0,
       0,    29, -1605,   851,     0,     0,     0,   852,     0,     0,
     853,     0,     0,     0,     0,   775,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     739,     0,     0,     0,     0,     0,     0,   854,     0,   855,
       0,     0,     0,   776,   856,     0,   857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   777,     0,   778,   858,   859,
       0,     0,     0,   860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
    2690,   861,     0,     0,  2692,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,     0,   862,     0,     0,     0,  2709,  2710,    32,     0,
       0,     0,     0,     0,   739,   739,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,  2730,     0,     0,   863,
       0,     0,     0,     0,     0,  2740,     0,  2742,    34,  2744,
       0,    35,     0,    36,     0,     0,    37,     0,     0,    38,
       0,    39,     0,     0,     0,     0,    40,     0,    41,     0,
       0,   864,     0,     0,     0,    42,     0,     0,     0,     0,
      43,   865,     0,     0,   739,     0,     0,     0,    44,     0,
       0,     0,  2768,    45,     0,     0,     0,    46,     0,     0,
       0,     0,   866,     0,     0,     0,   739,   739,     0,   739,
       0,     0,     0,     0,     0,     0,     0,     0,   739,     0,
      47,     0,     0,   739,    48,   867,   739,     0,   739,   739,
       0,     0,     0,     0,     0,     0,   868,   869,     0,     0,
     870,   871,     0,     0,     0,     0,     0,   739,     0,     0,
    2820,     0,     0,     0,  2824,     0,     0,     0,   739,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,     0,   739,
       0,    51,     0,     0,    52,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,  2853,     0,   872,
       0,     0,     0,     0,     0,     0,     0,     0,   739,     0,
       0,   873,     0,     0,    54,     0,     0,     0,     0,     0,
       0,     0,   739,     0,     0,     0,     1,     2,    55,     0,
       0,     0,     0,     0,     0, -2099,     0,     0,     0,   874,
     739,     3,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,   739,     0,   875,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    11,     0,     0,     0,     0,
       0,  2941,  2942,     0,     0,     0,     0,     0,     0,     0,
       0,    12,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2099,     0,     0,     0,     0,     0,   876,     0,
       0,    13,     0,     0,     0,     0,     0,     0,     0,    14,
      15,    16,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    17,    18,     0,     0,     0,     0,     0,     0,     0,
       0,  2980,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    20,     0,     0,     0,
       0,     0,     0,  2994,  2995,     0,     0,     0,     0,     0,
       0,  3118,  3119,    21,     0,  3002,     0,  3120,     0,  3121,
    3004,  3122,  3123,  3005,     0,  3006,  3007,     0,    22,     0,
       0,     0,     0,    23,     0,     0,    24,  3124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3021,     0,   739,     0,    25,
       0,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3021,    27,  3125,     0,
       0,  3126,     0,     0,     0,     0,     0,     0,     0,  3127,
       0,     0,     0,     0,    28,     0,   739,   739,    29,     0,
    2199,  2200,     0,     0,     0,   739,  3128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3065,
       0,     0,     0,  3129,     0,     0,     0,     0,     0,     0,
       0,     0,  -682,  -682,  2202,     0,     0,  3021,     0,     0,
       0,  -682,     0,     0,     0,  2205,  3130,     0,  3131,     0,
       0,  3089,     0,  2206,     0,     0,     0,     0,     0,     0,
    3132,  3133,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2208,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,  1340,     0,     0,
    2209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3134,     0,     0,     0,     0,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    32,     0,     0,  2214,     0,
       0,     0,     0,     0,     0,    33,     0,     0,  3135,     0,
       0,     0,     0,     0,     0,     0,     0,  3136,  3137,     0,
    3138,     0,   739,     0,     0,    34,     0,     0,    35,     0,
      36,     0,     0,    37,     0,     0,    38,     0,    39,     0,
       0,     0,     0,    40,     0,    41,     0,   739,     0,  3139,
    3140,  3141,    42,     0,     0,     0,     0,    43,     0,  2927,
       0,     0,   739,     0,  2217,    44,  2197,  3142,  3143,  3144,
      45,     0,  2218,  3145,    46,   739,  3146,     0,  2199,  2200,
       0,     0,     0,     0,     0,     0,     0,  2219,     0,     0,
       0,     0,  3147,  3148,     0,     0,     0,    47,     0,     0,
       0,    48,     0,     0,  3021,     0,     0,     0,  2201,     0,
       0,     0,  2202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2205,     0,     0,  3149,  3150,     0,     0,
       0,  2206,     0,     0,     0,     0,     0,     0,  2207,  2220,
       0,     0,    49,  3283,  3284,     0,     0,     0,     0,     0,
    3151,  2208,  2853,     0,    50,     0,  2221,     0,    51,     0,
       0,    52,     0,     0,     0,  1340,    53,     0,  2209,     0,
       0,     0,  3544,     0,     0,  2210,     0,     0,     0,     0,
       0,     0,  2928,     0,     0,     0,     0,     0,     0,     0,
    2213,    54,     0,     0,     0,     0,  2214,  3152,     0,     0,
       0,  3153,     0,     0,     0,    55,     0,     0,     0,     0,
    2225,  3154,     0,     0,     0,   739,     0,     0,  2227,     0,
       0,     0,     0,     0,  2215,     0,     0,   739,     0,     0,
       0,     0,     0,     0,     0,     0,   739,     0,   739,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3155,     0,  2217,  3156,     0,     0,  3157,  3158,  3159,  3160,
    2218,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2233,     0,     0,     0,  2219,     0,     0,     0,  3396,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3161,
    3162,     0,     0,     0,  3021,     0,   739,     0,     0,     0,
       0,     0,  3544,  3544,     0,     0,     0,     0,     0,  2853,
    3163,     0,     0,     0,  2234,     0,     0,  2220,     0,     0,
       0,     0,  2820,     0,     0,     0,     0,     0,     0,  2235,
       0,     0,     0,     0,  2221,     0,     0,     0,  2222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2236,
       0,     0,     0,     0,     0,     0,  2237,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2238,     0,     0,
       0,     0,     0,     0,     0,     0,   739,     0,     0,     0,
       0,  2224,     0,     0,     0,     0,     0,     0,  2225,     0,
       0,     0,     0,     0,     0,     0,  2227,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     739,     0,   739,     0,     0,     0,     0,     0,  2230,     0,
       0,     0,   739,     0,  3544,  3544,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2233,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3598,     0,     0,     0,   739,     0,
       0,     0,     0,  3609,     0,  3611,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2235,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   739,     0,  3544,     0,  2236,     0,     0,
       0,     0,     0,     0,  2237,     0,     0,     0,     0,     0,
    3544,   739,     0,  3648,     0,  2238,     0,     0,     0,     0,
       0,     0,     0,     0,  3544,     0,     0,     0,     0,  3885,
       0,     0,     0,     0,   739,     0,     0,     0,     0,     0,
       0,     0,     0,   739,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     739,  3544,     0,  2853,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3544,  3544,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   739,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3544,     0,     0,     0,  3754,     0,  3755,
     739,     0,     0,  3544,     0,     0,     0,     0,     0,  3763,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   739,     0,     0,     0,     0,     0,
       0,  3544,     0,  3544,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3544,     0,     0,   739,     0,     0,     0,
       0,     0,     0,  3544,     0,  3544,     0,  3544,     0,     0,
       0,     0,     0,     0,  3544,     0,     0,     0,     0,     0,
       0,     0,     0,  3544,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3544,  3544,
       0,     0,     0,     0,   739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3544,  3544,     0,     0,     0,  3544,
    3865,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3870,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3021,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3911,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,  3951,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
    1541,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,  3970,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,  3986,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,  4034,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,  1542,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,  1543,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,  2816,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,  2817,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,  2818,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,   670,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,  2819,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
    1098,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,  1099,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,   670,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,  1455,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,  1961,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,  1963,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,   670,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,  1965,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,   670,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,  1036,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,  1573,     0,     0,     0,     0,  1574,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,     0,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,  2332,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
    2378,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,   670,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,  3020,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,   670,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
     654,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,     0,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,  1588,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,     0,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   616,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   617,     0,   147,   148,   149,   150,   151,   618,   153,
       0,   154,     0,     0,   619,   155,   620,   621,   622,   156,
     623,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,   624,   625,   164,     0,   165,   626,   627,
     167,     0,   168,   169,   170,   628,   172,     0,   629,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   630,   185,     0,   186,   631,   632,   187,     0,
       0,   188,   633,   634,     0,   635,   636,     0,   189,   190,
     191,   637,   638,   639,     0,     0,     0,     0,   640,   194,
     641,     0,     0,   642,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,   643,     0,   218,   219,   220,
     644,   645,   221,   222,     0,   223,   224,   225,   226,   646,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   647,   233,   648,   235,     0,   236,     0,   649,
       0,   237,   238,     0,   239,   650,     0,   240,   241,     0,
       0,     0,   651,   243,   244,   245,   652,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,   653,   250,   251,
    1590,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   655,   261,   262,     0,     0,     0,     0,     0,
     656,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,   657,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,   658,   284,   285,   286,   287,   659,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   660,   295,     0,
       0,   661,   297,   662,   298,     0,   299,   663,   664,   665,
     666,   667,   304,   305,   306,   307,     0,   668,   308,   309,
       0,     0,   310,   311,   312,   313,   669,     0,   671,   314,
     315,     0,   672,   673,     0,   316,   317,   318,   674,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,   675,   328,
     329,   330,   331,   332,   676,   334,   335,   336,   677,   678,
     339,   679,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   680,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
     681,   682,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,   683,   371,   372,   373,   374,   375,   684,   377,
     378,   379,     0,   685,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,   686,   687,   403,
     404,     0,   405,   688,   407,   408,   409,   689,   690,   410,
     411,   412,   413,   691,   414,   415,     0,     0,   416,   417,
       0,   692,   418,   419,     0,   693,   694,   695,   696,     0,
       0,     0,     0,     0,   424,   425,   426,     0,   697,   698,
     699,   428,   429,   430,   700,   431,   432,   701,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   702,   441,     0,     0,   703,   704,   705,   706,
     442,     0,     0,   443,   707,     0,   708,   444,   445,   446,
     709,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   710,     0,     0,     0,   711,   712,     0,     0,
       0,     0,   713,   714,     0,     0,   715,   716,     0,   717,
     718,   139,     0,   616,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   617,     0,   147,   148,
     149,   150,   151,   618,   153,     0,   154,     0,     0,   619,
     155,   620,   621,   622,   156,   623,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,   624,   625,
     164,     0,   165,   626,   627,   167,     0,   168,   169,   170,
     628,   172,     0,   629,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   630,   185,     0,
     186,   631,   632,   187,     0,     0,   188,   633,   634,     0,
     635,   636,     0,   189,   190,   191,   637,   638,   639,     0,
       0,     0,     0,   640,   194,   641,     0,     0,   642,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
     643,     0,   218,   219,   220,   644,   645,   221,   222,     0,
     223,   224,   225,   226,   646,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   647,   233,   648,
     235,     0,   236,     0,   649,     0,   237,   238,     0,   239,
     650,     0,   240,   241,     0,     0,     0,   651,   243,   244,
     245,   652,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,   653,   250,   251,   654,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   655,   261,   262,
       0,     0,     0,     0,     0,   656,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,   657,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,   658,   284,   285,
     286,   287,   659,   288,   289,  3892,     0,     0,     0,   291,
     292,   293,   660,   295,     0,     0,   661,   297,   662,   298,
       0,   299,   663,   664,   665,   666,   667,   304,   305,   306,
     307,     0,   668,   308,   309,     0,     0,   310,   311,   312,
     313,   669,     0,   671,   314,   315,     0,   672,   673,     0,
     316,   317,   318,   674,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,   675,   328,   329,   330,   331,   332,   676,
     334,   335,   336,   677,   678,   339,   679,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   680,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,   681,   682,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,   683,   371,   372,
     373,   374,   375,   684,   377,   378,   379,     0,   685,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,   686,   687,   403,   404,     0,   405,   688,   407,
     408,   409,   689,   690,   410,   411,   412,   413,   691,   414,
     415,     0,     0,   416,   417,     0,   692,   418,   419,     0,
     693,   694,   695,   696,     0,     0,     0,     0,     0,   424,
     425,   426,     0,   697,   698,   699,   428,   429,   430,   700,
     431,   432,   701,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   702,   441,     0,
       0,   703,   704,   705,   706,   442,     0,     0,   443,   707,
       0,   708,   444,   445,   446,   709,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   710,     0,     0,
       0,   711,   712,     0,     0,     0,     0,   713,   714,     0,
       0,   715,   716,     0,   717,   718,   139,     0,   140,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   146,     0,   147,   148,   149,   150,   151,   152,   153,
       0,   154,     0,     0,     0,   155,     0,     0,     0,   156,
       0,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,     0,     0,   164,     0,   165,   166,     0,
     167,     0,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,  2560,   184,   185,     0,   186,     0,     0,   187,     0,
       0,   188,     0,     0,     0,     0,     0,     0,   189,   190,
     191,     0,     0,   192,     0,     0,     0,     0,   193,   194,
       0,     0,     0,     0,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,     0,     0,   218,   219,   220,
       0,     0,   221,   222,     0,   223,   224,   225,   226,     0,
       0,   227,     0,     0,     0,   228,   229,     0,   230,  2561,
     231,     0,   232,   233,   234,   235,     0,   236,     0,     0,
       0,   237,   238,     0,   239,     0,     0,   240,   241,     0,
       0,     0,   242,   243,   244,   245,     0,     0,   246,   247,
    1371,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,  1372,     0,   258,   259,     0,     0,
     260,     0,     0,   261,   262,     0,  2669,     0,     0,     0,
     263,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,     0,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,     0,   284,   285,   286,   287,     0,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   294,   295,     0,
       0,   296,   297,     0,   298,     0,   299,     0,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,   308,   309,
       0,     0,   310,   311,   312,   313,     0,     0,     0,   314,
     315,     0,     0,     0,     0,   316,   317,   318,   319,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,     0,   328,
     329,   330,   331,  2670,   333,   334,   335,   336,   337,   338,
     339,     0,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   348,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
       0,     0,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,     0,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,   380,   381,  -395,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,  2563,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,     0,     0,   403,
     404,     0,   405,   406,   407,   408,   409,     0,     0,   410,
     411,   412,   413,     0,   414,   415,     0,     0,   416,   417,
       0,     0,   418,   419,     0,   420,   421,   422,   423,     0,
       0,     0,     0,     0,   424,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,   431,   432,     0,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   440,   441,     0,     0,     0,     0,     0,     0,
     442,     0,     0,   443,     0,     0,     0,   444,   445,   446,
     447,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   452,     0,   139,     0,   140,   141,   142,   143,
     144,     0,     0,     0,     0,     0,   145,     0,     0,   146,
    2626,   147,   148,   149,   150,   151,   152,   153,     0,   154,
       0,     0,     0,   155,     0,     0,     0,   156,     0,     0,
     157,   158,   159,     0,   160,     0,   161,   162,     0,     0,
     163,     0,     0,   164,     0,   165,   166,     0,   167,     0,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,  2560,
     184,   185,     0,   186,     0,     0,   187,     0,     0,   188,
       0,     0,     0,     0,     0,     0,   189,   190,   191,     0,
       0,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,   195,     0,   196,     0,     0,     0,   197,     0,
     198,   199,   200,   201,     0,     0,     0,   202,     0,     0,
     203,   204,   205,     0,     0,     0,   206,     0,   207,   208,
       0,   209,   210,   211,     0,     0,   212,     0,   213,   214,
     215,   216,   217,     0,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,     0,     0,   227,
       0,     0,     0,   228,   229,     0,   230,  2561,   231,     0,
     232,   233,   234,   235,     0,   236,     0,     0,     0,   237,
     238,     0,   239,     0,     0,   240,   241,     0,     0,     0,
     242,   243,   244,   245,     0,     0,   246,   247,  1371,     0,
     248,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,   252,     0,   253,   254,     0,   255,   256,     0,     0,
       0,   257,  1372,     0,   258,   259,     0,     0,   260,     0,
       0,   261,   262,     0,     0,     0,     0,     0,   263,   264,
       0,   265,     0,   266,     0,   267,   268,     0,     0,     0,
       0,     0,     0,     0,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,     0,   282,   283,
       0,   284,   285,   286,   287,     0,   288,   289,   290,     0,
       0,     0,   291,   292,   293,   294,   295,     0,     0,   296,
     297,     0,   298,     0,   299,     0,   300,   301,   302,   303,
     304,   305,   306,   307,     0,     0,   308,   309,     0,     0,
     310,   311,   312,   313,     0,     0,     0,   314,   315,     0,
       0,     0,     0,   316,   317,   318,   319,     0,   320,   321,
     322,   323,     0,   324,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,     0,
       0,   340,   341,   342,     0,   343,     0,   344,   345,   346,
     347,     0,   348,   349,   350,     0,     0,   351,     0,     0,
       0,   352,   353,   354,   355,   356,     0,     0,   357,   358,
     359,     0,   360,   361,     0,   362,   363,   364,     0,     0,
     365,     0,   366,   367,   368,     0,   369,   370,     0,     0,
       0,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,   380,   381,     0,     0,     0,   382,   383,   384,   385,
       0,     0,     0,   386,     0,     0,     0,   387,   388,   389,
     390,     0,   391,   392,   393,   394,   395,  2563,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,     0,   399,
       0,     0,   400,   401,   402,     0,     0,   403,   404,     0,
     405,   406,   407,   408,   409,     0,     0,   410,   411,   412,
     413,     0,   414,   415,     0,     0,   416,   417,     0,     0,
     418,   419,     0,   420,   421,   422,   423,     0,     0,     0,
       0,     0,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,   431,   432,     0,   433,   434,     0,   435,
     436,     0,     0,   437,     0,     0,   438,     0,   439,     0,
     440,   441,     0,     0,     0,     0,     0,     0,   442,     0,
       0,   443,     0,     0,     0,   444,   445,   446,   447,     0,
       0,     0,     0,   448,   449,     0,   450,   451,     0,     0,
     452,     0,   139,     0,   140,   141,   142,   143,   144,     0,
       0,     0,     0,     0,   145,     0,     0,   146,  2626,   147,
     148,   149,   150,   151,   152,   153,     0,   154,     0,     0,
       0,   155,     0,     0,     0,   156,     0,     0,   157,   158,
     159,     0,   160,     0,   161,   162,     0,     0,   163,     0,
       0,   164,     0,   165,   166,     0,   167,     0,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,     0,   182,   183,     0,   184,   185,
       0,   186,     0,     0,   187,     0,     0,   188,     0,     0,
       0,     0,     0,     0,   189,   190,   191,     0,     0,   192,
       0,     0,     0,     0,   193,   194,     0,     0,     0,     0,
     195,     0,   196,     0,     0,     0,   197,     0,   198,   199,
     200,   201,     0,     0,     0,   202,     0,     0,   203,   204,
     205,     0,     0,     0,   206,     0,   207,   208,     0,   209,
     210,   211,     0,     0,   212,     0,   213,   214,   215,   216,
     217,     0,     0,   218,   219,   220,     0,     0,   221,   222,
       0,   223,   224,   225,   226,     0,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,   231,     0,   232,   233,
     234,   235,     0,   236,     0,     0,     0,   237,   238,     0,
     239,     0,     0,   240,   241,     0,     0,     0,   242,   243,
     244,   245,     0,     0,   246,   247,     0,     0,   248,     0,
     249,     0,     0,     0,   250,   251,     0,     0,     0,   252,
       0,   253,   254,     0,   255,   256,     0,     0,     0,   257,
       0,     0,   258,   259,     0,     0,   260,     0,     0,   261,
     262,     0,     0,     0,     0,     0,   263,   264,     0,   265,
       0,   266,     0,   267,   268,     0,     0,     0,     0,     0,
       0,     0,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,     0,   282,   283,     0,   284,
     285,   286,   287,     0,   288,   289,   290,     0,     0,     0,
     291,   292,   293,   294,   295,     0,     0,   296,   297,     0,
     298,     0,   299,     0,   300,   301,   302,   303,   304,   305,
     306,   307,     0,     0,   308,   309,     0,     0,   310,   311,
     312,   313,     0,     0,     0,   314,   315,     0,     0,     0,
       0,   316,   317,   318,   319,     0,   320,   321,   322,   323,
       0,   324,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,   326,   327,     0,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,     0,     0,   340,
     341,   342,     0,   343,     0,   344,   345,   346,   347,     0,
     348,   349,   350,     0,     0,   351,     0,     0,     0,   352,
     353,   354,   355,   356,     0,     0,   357,   358,   359,     0,
     360,   361,     0,   362,   363,   364,     0,     0,   365,     0,
     366,   367,   368,     0,   369,   370,     0,     0,     0,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,   380,
     381,  2084,     0,     0,   382,   383,   384,   385,     0,     0,
       0,   386,     0,     0,     0,   387,   388,   389,   390,     0,
     391,   392,   393,   394,   395,     0,     0,     0,     0,     0,
       0,   396,   397,     0,   398,     0,     0,   399,     0,     0,
     400,   401,   402,     0,     0,   403,   404,     0,   405,   406,
     407,   408,   409,     0,     0,   410,   411,   412,   413,     0,
     414,   415,     0,     0,   416,   417,     0,     0,   418,   419,
       0,   420,   421,   422,   423,     0,     0,     0,     0,     0,
     424,   425,   426,     0,     0,     0,   427,   428,   429,   430,
       0,   431,   432,     0,   433,   434,     0,   435,   436,     0,
       0,   437,     0,     0,   438,     0,   439,     0,   440,   441,
       0,     0,     0,     0,     0,     0,   442,     0,     0,   443,
       0,     0,     0,   444,   445,   446,   447,     0,     0,     0,
       0,   448,   449,     0,   450,   451,     0,     0,   452,     0,
     139,     0,   140,   141,   142,   143,   144,     0,     0,     0,
    2461,     0,   145,     0,     0,   146,   718,   147,   148,   149,
     150,   151,   152,   153,     0,   154,     0,     0,     0,   155,
       0,     0,     0,   156,     0,     0,   157,   158,   159,     0,
     160,     0,   161,   162,     0,     0,   163,     0,     0,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,     0,   184,   185,     0,   186,
       0,     0,   187,     0,     0,   188,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,   192,     0,     0,
       0,     0,   193,   194,     0,     0,     0,     0,   195,     0,
     196,     0,     0,     0,   197,     0,   198,   199,   200,   201,
       0,     0,     0,   202,     0,     0,   203,   204,   205,     0,
       0,     0,   206,     0,   207,   208,     0,   209,   210,   211,
       0,     0,   212,     0,   213,   214,   215,   216,   217,     0,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,     0,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,   231,     0,   232,   233,   234,   235,
       0,   236,     0,     0,     0,   237,   238,     0,   239,     0,
       0,   240,   241,     0,     0,     0,   242,   243,   244,   245,
       0,     0,   246,   247,     0,     0,   248,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,   252,     0,   253,
     254,     0,   255,   256,     0,     0,     0,   257,     0,     0,
     258,   259,     0,     0,   260,     0,     0,   261,   262,     0,
       0,     0,     0,     0,   263,   264,     0,   265,     0,   266,
       0,   267,   268,     0,     0,     0,     0,     0,     0,     0,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,     0,   282,   283,     0,   284,   285,   286,
     287,     0,   288,   289,   290,     0,     0,     0,   291,   292,
     293,   294,   295,     0,     0,   296,   297,     0,   298,     0,
     299,     0,   300,   301,   302,   303,   304,   305,   306,   307,
       0,     0,   308,   309,     0,     0,   310,   311,   312,   313,
       0,     0,     0,   314,   315,     0,     0,     0,     0,   316,
     317,   318,   319,     0,   320,   321,   322,   323,     0,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,     0,     0,   340,   341,   342,
       0,   343,     0,   344,   345,   346,   347,     0,   348,   349,
     350,     0,     0,   351,     0,     0,     0,   352,   353,   354,
     355,   356,     0,     0,   357,   358,   359,     0,   360,   361,
       0,   362,   363,   364,     0,     0,   365,     0,   366,   367,
     368,     0,   369,   370,     0,     0,     0,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,   380,   381,     0,
       0,     0,   382,   383,   384,   385,     0,     0,     0,   386,
       0,     0,     0,   387,   388,   389,   390,     0,   391,   392,
     393,   394,   395,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,     0,   399,     0,     0,   400,   401,
     402,     0,     0,   403,   404,     0,   405,   406,   407,   408,
     409,     0,     0,   410,   411,   412,   413,     0,   414,   415,
       0,     0,   416,   417,     0,     0,   418,   419,     0,   420,
     421,   422,   423,     0,     0,     0,     0,     0,   424,   425,
     426,     0,     0,     0,   427,   428,   429,   430,     0,   431,
     432,     0,   433,   434,     0,   435,   436,     0,     0,   437,
       0,     0,   438,     0,   439,     0,   440,   441,     0,     0,
       0,     0,     0,     0,   442,     0,     0,   443,     0,     0,
       0,   444,   445,   446,   447,     0,     0,     0,     0,   448,
     449,     0,   450,   451,     0,     0,   452,     0,     0,     0,
     139,     0,   140,   141,   142,   143,   144,     0,  4039,     0,
       0,     0,   145,  4040,   718,   146,     0,   147,   148,   149,
     150,   151,   152,   153,     0,   154,     0,     0,     0,   155,
       0,     0,     0,   156,     0,     0,   157,   158,   159,     0,
     160,     0,   161,   162,     0,     0,   163,     0,     0,   164,
       0,   165,   166,     0,   167,     0,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,     0,   184,   185,     0,   186,
       0,     0,   187,     0,     0,   188,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,   192,     0,     0,
       0,     0,   193,   194,     0,     0,     0,     0,   195,     0,
     196,     0,     0,     0,   197,     0,   198,   199,   200,   201,
       0,     0,     0,   202,     0,     0,   203,   204,   205,     0,
       0,     0,   206,     0,   207,   208,     0,   209,   210,   211,
       0,     0,   212,     0,   213,   214,   215,   216,   217,     0,
       0,   218,   219,   220,     0,     0,   221,   222,     0,   223,
     224,   225,   226,     0,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,   231,     0,   232,   233,   234,   235,
       0,   236,     0,     0,     0,   237,   238,     0,   239,     0,
       0,   240,   241,     0,     0,     0,   242,   243,   244,   245,
       0,     0,   246,   247,     0,     0,   248,     0,   249,     0,
       0,     0,   250,   251,     0,     0,     0,   252,     0,   253,
     254,     0,   255,   256,     0,     0,     0,   257,     0,     0,
     258,   259,     0,     0,   260,     0,     0,   261,   262,     0,
       0,     0,     0,     0,   263,   264,     0,   265,     0,   266,
       0,   267,   268,     0,     0,     0,     0,     0,     0,     0,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,     0,   282,   283,     0,   284,   285,   286,
     287,     0,   288,   289,   290,     0,     0,     0,   291,   292,
     293,   294,   295,     0,     0,   296,   297,     0,   298,     0,
     299,     0,   300,   301,   302,   303,   304,   305,   306,   307,
       0,     0,   308,   309,     0,     0,   310,   311,   312,   313,
       0,     0,     0,   314,   315,     0,     0,     0,     0,   316,
     317,   318,   319,     0,   320,   321,   322,   323,     0,   324,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
     326,   327,     0,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,     0,     0,   340,   341,   342,
       0,   343,     0,   344,   345,   346,   347,     0,   348,   349,
     350,     0,     0,   351,     0,     0,     0,   352,   353,   354,
     355,   356,     0,     0,   357,   358,   359,     0,   360,   361,
       0,   362,   363,   364,     0,     0,   365,     0,   366,   367,
     368,     0,   369,   370,     0,     0,     0,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,   380,   381,     0,
       0,     0,   382,   383,   384,   385,     0,     0,     0,   386,
       0,     0,     0,   387,   388,   389,   390,     0,   391,   392,
     393,   394,   395,     0,     0,     0,     0,     0,     0,   396,
     397,     0,   398,     0,     0,   399,     0,     0,   400,   401,
     402,     0,     0,   403,   404,     0,   405,   406,   407,   408,
     409,     0,     0,   410,   411,   412,   413,     0,   414,   415,
       0,     0,   416,   417,     0,     0,   418,   419,     0,   420,
     421,   422,   423,     0,     0,     0,     0,     0,   424,   425,
     426,     0,     0,     0,   427,   428,   429,   430,     0,   431,
     432,     0,   433,   434,     0,   435,   436,     0,     0,   437,
       0,     0,   438,     0,   439,     0,   440,   441,     0,     0,
       0,     0,     0,     0,   442,     0,     0,   443,     0,     0,
       0,   444,   445,   446,   447,     0,     0,     0,     0,   448,
     449,     0,   450,   451,     0,     0,   452,     0,   139,     0,
     140,   141,   142,   143,   144,     0,     0,  1040,     0,     0,
     145,     0,     0,   146,   718,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,  1229,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,     0,   452,     0,   139,     0,   140,   141,
     142,   143,   144,     0,     0,     0,     0,     0,   145,     0,
       0,   146,   493,   147,   148,   149,   150,   151,   152,   153,
       0,   154,     0,     0,     0,   155,     0,     0,     0,   156,
       0,     0,   157,   158,   159,     0,   160,     0,   161,   162,
       0,     0,   163,     0,     0,   164,     0,   165,   166,     0,
     167,     0,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,     0,   184,   185,     0,   186,     0,     0,   187,     0,
       0,   188,     0,     0,     0,     0,     0,     0,   189,   190,
     191,     0,     0,   192,     0,     0,     0,     0,   193,   194,
       0,     0,     0,     0,   195,     0,   196,     0,     0,     0,
     197,     0,   198,   199,   200,   201,     0,     0,     0,   202,
       0,     0,   203,   204,   205,     0,     0,     0,   206,     0,
     207,   208,     0,   209,   210,   211,     0,     0,   212,     0,
     213,   214,   215,   216,   217,     0,     0,   218,   219,   220,
       0,     0,   221,   222,     0,   223,   224,   225,   226,     0,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
     231,     0,   232,   233,   234,   235,     0,   236,     0,     0,
       0,   237,   238,     0,   239,     0,     0,   240,   241,     0,
       0,     0,   242,   243,   244,   245,     0,     0,   246,   247,
       0,     0,   248,     0,   249,     0,     0,     0,   250,   251,
       0,     0,     0,   252,     0,   253,   254,     0,   255,   256,
       0,     0,     0,   257,     0,     0,   258,   259,     0,     0,
     260,     0,     0,   261,   262,     0,     0,     0,     0,     0,
     263,   264,     0,   265,     0,   266,     0,   267,   268,     0,
       0,     0,     0,     0,     0,     0,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,     0,
     282,   283,     0,   284,   285,   286,   287,     0,   288,   289,
     290,     0,     0,     0,   291,   292,   293,   294,   295,     0,
       0,   296,   297,     0,   298,     0,   299,     0,   300,   301,
     302,   303,   304,   305,   306,   307,     0,     0,   308,   309,
       0,     0,   310,   311,   312,   313,     0,     0,     0,   314,
     315,     0,     0,     0,     0,   316,   317,   318,   319,     0,
     320,   321,   322,   323,     0,   324,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   325,   326,   327,     0,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,     0,     0,   340,   341,   342,     0,   343,     0,   344,
     345,   346,   347,     0,   348,   349,   350,     0,     0,   351,
       0,     0,     0,   352,   353,   354,   355,   356,     0,     0,
     357,   358,   359,     0,   360,   361,     0,   362,   363,   364,
       0,     0,   365,     0,   366,   367,   368,     0,   369,   370,
       0,     0,     0,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,   380,   381,     0,     0,     0,   382,   383,
     384,   385,     0,     0,     0,   386,     0,     0,     0,   387,
     388,   389,   390,     0,   391,   392,   393,   394,   395,     0,
       0,     0,     0,     0,     0,   396,   397,     0,   398,     0,
       0,   399,     0,     0,   400,   401,   402,     0,     0,   403,
     404,     0,   405,   406,   407,   408,   409,     0,     0,   410,
     411,   412,   413,     0,   414,   415,     0,     0,   416,   417,
       0,     0,   418,   419,     0,   420,   421,   422,   423,     0,
       0,     0,     0,     0,   424,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,   431,   432,     0,   433,   434,
       0,   435,   436,     0,     0,   437,     0,     0,   438,     0,
     439,     0,   440,   441,     0,     0,     0,     0,     0,     0,
     442,     0,     0,   443,     0,     0,     0,   444,   445,   446,
     447,     0,     0,     0,     0,   448,   449,     0,   450,   451,
       0,     0,   452,     0,     0,     0,     0,   139,  2027,   140,
     141,   142,   143,   144,     0,     0,     0,     0,     0,   145,
     493,     0,   146,     0,   147,   148,   149,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,     0,     0,     0,
     156,     0,     0,   157,   158,   159,     0,   160,     0,   161,
     162,     0,     0,   163,     0,     0,   164,     0,   165,   166,
       0,   167,     0,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,     0,   184,   185,     0,   186,     0,     0,   187,
       0,     0,   188,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,   192,     0,     0,     0,     0,   193,
     194,     0,     0,     0,     0,   195,     0,   196,     0,     0,
       0,   197,     0,   198,   199,   200,   201,     0,     0,     0,
     202,     0,     0,   203,   204,   205,     0,     0,     0,   206,
       0,   207,   208,     0,   209,   210,   211,     0,     0,   212,
       0,   213,   214,   215,   216,   217,     0,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
       0,     0,   227,     0,     0,     0,   228,   229,     0,   230,
       0,   231,     0,   232,   233,   234,   235,     0,   236,     0,
       0,     0,   237,   238,     0,   239,     0,     0,   240,   241,
       0,     0,     0,   242,   243,   244,   245,     0,     0,   246,
     247,     0,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,     0,     0,   252,     0,   253,   254,     0,   255,
     256,     0,     0,     0,   257,     0,     0,   258,   259,     0,
       0,   260,     0,     0,   261,   262,     0,     0,     0,     0,
       0,   263,   264,     0,   265,     0,   266,     0,   267,   268,
       0,     0,     0,     0,     0,     0,     0,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
       0,   282,   283,     0,   284,   285,   286,   287,     0,   288,
     289,   290,     0,     0,     0,   291,   292,   293,   294,   295,
       0,     0,   296,   297,     0,   298,     0,   299,     0,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,   308,
     309,     0,     0,   310,   311,   312,   313,     0,     0,     0,
     314,   315,     0,     0,     0,     0,   316,   317,   318,   319,
       0,   320,   321,   322,   323,     0,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,     0,     0,   340,   341,   342,     0,   343,     0,
     344,   345,   346,   347,     0,   348,   349,   350,     0,     0,
     351,     0,     0,     0,   352,   353,   354,   355,   356,     0,
       0,   357,   358,   359,     0,   360,   361,     0,   362,   363,
     364,     0,     0,   365,     0,   366,   367,   368,     0,   369,
     370,     0,     0,     0,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,   380,   381,     0,     0,     0,   382,
     383,   384,   385,     0,     0,     0,   386,     0,     0,     0,
     387,   388,   389,   390,     0,   391,   392,   393,   394,   395,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,     0,   399,     0,     0,   400,   401,   402,     0,     0,
     403,   404,     0,   405,   406,   407,   408,   409,     0,     0,
     410,   411,   412,   413,     0,   414,   415,     0,     0,   416,
     417,     0,     0,   418,   419,     0,   420,   421,   422,   423,
       0,     0,     0,     0,     0,   424,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,   431,   432,     0,   433,
     434,     0,   435,   436,     0,     0,   437,     0,     0,   438,
       0,   439,     0,   440,   441,     0,     0,     0,     0,     0,
       0,   442,     0,     0,   443,     0,     0,     0,   444,   445,
     446,   447,     0,     0,     0,     0,   448,   449,     0,   450,
     451,     0,     0,   452,     0,   139,     0,   140,   141,   142,
     143,   144,     0,     0,  2625,     0,     0,   145,     0,     0,
     146,  2626,   147,   148,   149,   150,   151,   152,   153,     0,
     154,     0,     0,     0,   155,     0,     0,     0,   156,     0,
       0,   157,   158,   159,     0,   160,     0,   161,   162,     0,
       0,   163,     0,     0,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
       0,   184,   185,     0,   186,     0,     0,   187,     0,     0,
     188,     0,     0,     0,     0,     0,     0,   189,   190,   191,
       0,     0,   192,     0,     0,     0,     0,   193,   194,     0,
       0,     0,     0,   195,     0,   196,     0,     0,     0,   197,
       0,   198,   199,   200,   201,     0,     0,     0,   202,     0,
       0,   203,   204,   205,     0,     0,     0,   206,     0,   207,
     208,     0,   209,   210,   211,     0,     0,   212,     0,   213,
     214,   215,   216,   217,     0,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,     0,     0,
     227,     0,     0,     0,   228,   229,     0,   230,     0,   231,
       0,   232,   233,   234,   235,     0,   236,     0,     0,     0,
     237,   238,     0,   239,     0,     0,   240,   241,     0,     0,
       0,   242,   243,   244,   245,     0,     0,   246,   247,     0,
       0,   248,     0,   249,     0,     0,     0,   250,   251,     0,
       0,     0,   252,     0,   253,   254,     0,   255,   256,     0,
       0,     0,   257,     0,     0,   258,   259,     0,     0,   260,
       0,     0,   261,   262,     0,     0,     0,     0,     0,   263,
     264,     0,   265,     0,   266,     0,   267,   268,     0,     0,
       0,     0,     0,     0,     0,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,     0,   282,
     283,     0,   284,   285,   286,   287,     0,   288,   289,   290,
       0,     0,     0,   291,   292,   293,   294,   295,     0,     0,
     296,   297,     0,   298,     0,   299,     0,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,   308,   309,     0,
       0,   310,   311,   312,   313,     0,     0,     0,   314,   315,
       0,     0,     0,     0,   316,   317,   318,   319,     0,   320,
     321,   322,   323,     0,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,     0,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
       0,     0,   340,   341,   342,     0,   343,     0,   344,   345,
     346,   347,     0,   348,   349,   350,     0,     0,   351,     0,
       0,     0,   352,   353,   354,   355,   356,     0,     0,   357,
     358,   359,     0,   360,   361,     0,   362,   363,   364,     0,
       0,   365,     0,   366,   367,   368,     0,   369,   370,     0,
       0,     0,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,   380,   381,     0,     0,     0,   382,   383,   384,
     385,     0,     0,     0,   386,     0,     0,     0,   387,   388,
     389,   390,     0,   391,   392,   393,   394,   395,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,     0,
     399,     0,     0,   400,   401,   402,     0,     0,   403,   404,
       0,   405,   406,   407,   408,   409,     0,     0,   410,   411,
     412,   413,     0,   414,   415,     0,     0,   416,   417,     0,
       0,   418,   419,     0,   420,   421,   422,   423,     0,     0,
       0,     0,     0,   424,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,   431,   432,     0,   433,   434,     0,
     435,   436,     0,     0,   437,     0,     0,   438,     0,   439,
       0,   440,   441,     0,     0,     0,     0,     0,     0,   442,
       0,     0,   443,     0,     0,     0,   444,   445,   446,   447,
       0,     0,     0,     0,   448,   449,     0,   450,   451,     0,
       0,   452,     0,     0,     0,   139,     0,   140,   141,   142,
     143,   144,     0,     0,     0,     0,     0,   145,  4040,   718,
     146,     0,   147,   148,   149,   150,   151,   152,   153,     0,
     154,     0,     0,     0,   155,     0,     0,     0,   156,     0,
       0,   157,   158,   159,     0,   160,     0,   161,   162,     0,
       0,   163,     0,     0,   164,     0,   165,   166,     0,   167,
       0,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
       0,   184,   185,     0,   186,     0,     0,   187,     0,     0,
     188,     0,     0,     0,     0,     0,     0,   189,   190,   191,
       0,     0,   192,     0,     0,     0,     0,   193,   194,     0,
       0,     0,     0,   195,     0,   196,     0,     0,     0,   197,
       0,   198,   199,   200,   201,     0,     0,     0,   202,     0,
       0,   203,   204,   205,     0,     0,     0,   206,     0,   207,
     208,     0,   209,   210,   211,     0,     0,   212,     0,   213,
     214,   215,   216,   217,     0,     0,   218,   219,   220,     0,
       0,   221,   222,     0,   223,   224,   225,   226,     0,     0,
     227,     0,     0,     0,   228,   229,     0,   230,     0,   231,
       0,   232,   233,   234,   235,     0,   236,     0,     0,     0,
     237,   238,     0,   239,     0,     0,   240,   241,     0,     0,
       0,   242,   243,   244,   245,     0,     0,   246,   247,     0,
       0,   248,     0,   249,     0,     0,     0,   250,   251,     0,
       0,     0,   252,     0,   253,   254,     0,   255,   256,     0,
       0,     0,   257,     0,     0,   258,   259,     0,     0,   260,
       0,     0,   261,   262,     0,     0,     0,     0,     0,   263,
     264,     0,   265,     0,   266,     0,   267,   268,     0,     0,
       0,     0,     0,     0,     0,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,     0,   282,
     283,     0,   284,   285,   286,   287,     0,   288,   289,   290,
       0,     0,     0,   291,   292,   293,   294,   295,     0,     0,
     296,   297,     0,   298,     0,   299,     0,   300,   301,   302,
     303,   304,   305,   306,   307,     0,     0,   308,   309,     0,
       0,   310,   311,   312,   313,     0,     0,     0,   314,   315,
       0,     0,     0,     0,   316,   317,   318,   319,     0,   320,
     321,   322,   323,     0,   324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   325,   326,   327,     0,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
       0,     0,   340,   341,   342,     0,   343,     0,   344,   345,
     346,   347,     0,   348,   349,   350,     0,     0,   351,     0,
       0,     0,   352,   353,   354,   355,   356,     0,     0,   357,
     358,   359,     0,   360,   361,     0,   362,   363,   364,     0,
       0,   365,     0,   366,   367,   368,     0,   369,   370,     0,
       0,     0,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,   380,   381,     0,     0,     0,   382,   383,   384,
     385,     0,     0,     0,   386,     0,     0,     0,   387,   388,
     389,   390,     0,   391,   392,   393,   394,   395,     0,     0,
       0,     0,     0,     0,   396,   397,     0,   398,     0,     0,
     399,     0,     0,   400,   401,   402,     0,     0,   403,   404,
       0,   405,   406,   407,   408,   409,     0,     0,   410,   411,
     412,   413,     0,   414,   415,     0,     0,   416,   417,     0,
       0,   418,   419,     0,   420,   421,   422,   423,     0,     0,
       0,     0,     0,   424,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,   431,   432,     0,   433,   434,     0,
     435,   436,     0,     0,   437,     0,     0,   438,     0,   439,
       0,   440,   441,     0,     0,     0,     0,     0,     0,   442,
       0,     0,   443,     0,     0,     0,   444,   445,   446,   447,
       0,     0,     0,     0,   448,   449,     0,   450,   451,     0,
       0,   452,     0,   139,     0,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,   493,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   552,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   553,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,     0,   452,
       0,   139,     0,   140,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   146,   493,   147,   148,
     149,   150,   151,   152,   153,     0,   154,     0,     0,     0,
     155,     0,     0,     0,   156,     0,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,     0,     0,
     164,     0,   165,   166,     0,   167,     0,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   184,   185,     0,
     186,     0,     0,   187,     0,     0,   188,     0,     0,     0,
       0,     0,     0,   189,   190,   191,     0,     0,   192,     0,
       0,     0,     0,   193,   194,     0,     0,     0,     0,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
       0,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,     0,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   232,   233,   234,
     235,     0,   236,     0,     0,     0,   237,   238,     0,   239,
       0,     0,   240,   241,     0,     0,     0,   242,   243,   244,
     245,     0,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,     0,   250,   251,     0,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,     0,   261,   262,
       0,     0,     0,     0,     0,   263,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,     0,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,     0,   284,   285,
     286,   287,     0,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   294,   295,     0,     0,   296,   297,     0,   298,
       0,   299,     0,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,   308,   309,     0,     0,   310,   311,   312,
     313,     0,     0,     0,   314,   315,     0,     0,     0,     0,
     316,   317,   318,   319,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,     0,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   348,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,     0,     0,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,     0,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,   380,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,     0,     0,   403,   404,     0,   405,   406,   407,
     408,   409,     0,     0,   410,   411,   412,   413,     0,   414,
     415,     0,     0,   416,   417,     0,     0,   418,   419,     0,
     420,   421,   422,   423,     0,     0,     0,     0,     0,   424,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
     431,   432,     0,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   440,   441,     0,
       0,     0,     0,     0,     0,   442,     0,     0,   443,     0,
       0,     0,   444,   445,   446,   447,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   452,     0,   139,
       0,   140,   141,   142,   143,   144,     0,     0,     0,     0,
       0,   145,     0,     0,   146,   718,   147,   148,   149,   150,
     151,   152,   153,     0,   154,     0,     0,     0,   155,     0,
       0,     0,   156,     0,     0,   157,   158,   159,     0,   160,
       0,   161,   162,     0,     0,   163,     0,     0,   164,     0,
     165,   166,     0,   167,     0,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,     0,   184,   185,     0,   186,     0,
       0,   187,     0,     0,   188,     0,     0,     0,     0,     0,
       0,   189,   190,   191,     0,     0,   192,     0,     0,     0,
       0,   193,   194,     0,     0,     0,     0,   195,     0,   196,
       0,     0,     0,   197,     0,   198,   199,   200,   201,     0,
       0,     0,   202,     0,     0,   203,   204,   205,     0,     0,
       0,   206,     0,   207,   208,     0,   209,   210,   211,     0,
       0,   212,     0,   213,   214,   215,   216,   217,     0,     0,
     218,   219,   220,     0,     0,   221,   222,     0,   223,   224,
     225,   226,     0,     0,   227,     0,     0,     0,   228,   229,
       0,   230,     0,   231,     0,   232,   233,   234,   235,     0,
     236,     0,     0,     0,   237,   238,     0,   239,     0,     0,
     240,   241,     0,     0,     0,   242,   243,   244,   245,     0,
       0,   246,   247,     0,     0,   248,     0,   249,     0,     0,
       0,   250,   251,     0,     0,     0,   252,     0,   253,   254,
       0,   255,   256,     0,     0,     0,   257,     0,     0,   258,
     259,     0,     0,   260,     0,     0,   261,   262,     0,     0,
       0,     0,     0,   263,   264,     0,   265,     0,   266,     0,
     267,   268,     0,     0,     0,     0,     0,     0,     0,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,     0,   282,   283,     0,   284,   285,   286,   287,
       0,   288,   289,   290,     0,     0,     0,   291,   292,   293,
     294,   295,     0,     0,   296,   297,     0,   298,     0,   299,
       0,   300,   301,   302,   303,   304,   305,   306,   307,     0,
       0,   308,   309,     0,     0,   310,   311,   312,   313,     0,
       0,     0,   314,   315,     0,     0,     0,     0,   316,   317,
     318,   319,     0,   320,   321,   322,   323,     0,   324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   325,   326,
     327,     0,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,     0,     0,   340,   341,   342,     0,
     343,     0,   344,   345,   346,   347,     0,   348,   349,   350,
       0,     0,   351,     0,     0,     0,   352,   353,   354,   355,
     356,     0,     0,   357,   358,   359,     0,   360,   361,     0,
     362,   363,   364,     0,     0,   365,     0,   366,   367,   368,
       0,   369,   370,     0,     0,     0,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,   380,   381,     0,     0,
       0,   382,   383,   384,   385,     0,     0,     0,   386,     0,
       0,     0,   387,   388,   389,   390,     0,   391,   392,   393,
     394,   395,     0,     0,     0,     0,     0,     0,   396,   397,
       0,   398,     0,     0,   399,     0,     0,   400,   401,   402,
       0,     0,   403,   404,     0,   405,   406,   407,   408,   409,
       0,     0,   410,   411,   412,   413,     0,   414,   415,     0,
       0,   416,   417,     0,     0,   418,   419,     0,   420,   421,
     422,   423,     0,     0,     0,     0,     0,   424,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,   431,   432,
       0,   433,   434,     0,   435,   436,     0,     0,   437,     0,
       0,   438,     0,   439,     0,   440,   441,     0,     0,     0,
       0,     0,     0,   442,     0,     0,   443,     0,     0,     0,
     444,   445,   446,   447,     0,     0,     0,     0,   448,   449,
       0,   450,   451,     0,     0,   452,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,     0,     0,     0,   145,
       0,     0,   146,  2626,   147,   148,   149,   150,   151,   152,
     153,     0,   154,     0,     0,     0,   155,     0,     0,     0,
     156,     0,     0,   157,   158,   159,     0,   160,     0,   161,
     162,     0,     0,   163,     0,     0,   164,     0,   165,   166,
       0,   167,     0,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,     0,   184,   185,     0,   186,     0,     0,   187,
       0,     0,   188,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,   192,     0,     0,     0,     0,   193,
     194,     0,     0,     0,     0,   195,     0,   196,     0,     0,
       0,   197,     0,   198,   199,   200,   201,     0,     0,     0,
     202,     0,     0,   203,   204,   205,     0,     0,     0,   206,
       0,   207,   208,     0,   209,   210,   211,     0,     0,   212,
       0,   213,   214,   215,   216,   217,     0,     0,   218,   219,
     220,     0,     0,   221,   222,     0,   223,   224,   225,   226,
       0,     0,   227,     0,     0,     0,   228,   229,     0,   230,
       0,   231,     0,   232,   233,   234,   235,     0,   236,     0,
       0,     0,   237,   238,     0,   239,     0,     0,   240,   241,
       0,     0,     0,   242,   243,   244,   245,     0,     0,   246,
     247,     0,     0,   248,     0,   249,     0,     0,     0,   250,
     251,     0,     0,     0,   252,     0,   253,   254,     0,   255,
     256,     0,     0,     0,   257,     0,     0,   258,   259,     0,
       0,   260,     0,     0,   261,   262,   564,     0,     0,     0,
       0,   263,   264,     0,   265,     0,   266,     0,   267,   268,
       0,     0,     0,     0,     0,     0,     0,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
       0,   282,   283,     0,   284,   285,   286,   287,     0,   288,
     289,   290,     0,     0,     0,   291,   292,   293,   294,   295,
       0,     0,   296,   297,     0,   298,     0,   299,     0,   300,
     301,   302,   303,   304,   305,   306,   307,     0,     0,   308,
     309,     0,     0,   310,   311,   312,   313,     0,     0,     0,
     314,   315,     0,     0,     0,     0,   316,   317,   318,   319,
       0,   320,   321,   322,   323,     0,   324,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325,   326,   327,     0,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,     0,     0,   340,   341,   342,     0,   343,     0,
     344,   345,   346,   347,     0,   348,   349,   350,     0,     0,
     351,     0,     0,     0,   352,   353,   354,   355,   356,     0,
       0,   357,   358,   359,     0,   360,   361,     0,   362,   363,
     364,     0,     0,   365,     0,   366,   367,   368,     0,   369,
     370,     0,     0,     0,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,   380,   381,     0,     0,     0,   382,
     383,   384,   385,     0,     0,     0,   386,     0,     0,     0,
     387,   388,   389,   390,     0,   391,   392,   393,   394,   395,
       0,     0,     0,     0,     0,     0,   396,   397,     0,   398,
       0,     0,   399,     0,     0,   400,   401,   402,     0,     0,
     403,   404,     0,   405,   406,   407,   408,   409,     0,     0,
     410,   411,   412,   413,     0,   414,   415,     0,     0,   416,
     417,     0,   136,   418,   419,     0,   420,   421,   422,   423,
       0,     0,     0,     0,     0,   424,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,   431,   432,     0,   433,
     434,     0,   435,   436,     0,     0,   437,     0,     0,   438,
       0,   439,     0,   440,   441,     0,     0,     0,     0,     0,
       0,   442,     0,     0,   443,     0,     0,     0,   444,   445,
     446,   447,     0,     0,     0,     0,   448,   449,     0,   450,
     451,     0,     0,   452,   139,     0,   140,   141,   142,   143,
     144,     0,     0,     0,     0,     0,   145,     0,     0,   146,
    1560,   147,   148,   149,   150,   151,   152,   153,     0,   154,
       0,     0,     0,   155,     0,     0,     0,   156,     0,     0,
     157,   158,   159,     0,   160,     0,   161,   162,     0,     0,
     163,     0,     0,   164,     0,   165,   166,     0,   167,     0,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,     0,
     184,   185,     0,   186,     0,     0,   187,     0,     0,   188,
       0,     0,     0,     0,     0,     0,   189,   190,   191,     0,
       0,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,   195,     0,   196,     0,     0,     0,   197,     0,
     198,   199,   200,   201,     0,     0,     0,   202,     0,     0,
     203,   204,   205,     0,     0,     0,   206,     0,   207,   208,
       0,   209,   210,   211,     0,     0,   212,     0,   213,   214,
     215,   216,   217,     0,     0,   218,   219,   220,     0,     0,
     221,   222,     0,   223,   224,   225,   226,     0,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,   231,     0,
     232,   233,   234,   235,     0,   236,     0,     0,     0,   237,
     238,     0,   239,     0,     0,   240,   241,     0,     0,     0,
     242,   243,   244,   245,     0,     0,   246,   247,     0,     0,
     248,     0,   249,     0,     0,     0,   250,   251,     0,     0,
       0,   252,     0,   253,   254,     0,   255,   256,     0,     0,
       0,   257,     0,     0,   258,   259,     0,     0,   260,     0,
       0,   261,   262,   564,     0,     0,     0,     0,   263,   264,
       0,   265,     0,   266,     0,   267,   268,     0,     0,     0,
       0,     0,     0,     0,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,     0,   282,   283,
       0,   284,   285,   286,   287,     0,   288,   289,   290,     0,
       0,     0,   291,   292,   293,   294,   295,     0,     0,   296,
     297,     0,   298,     0,   299,     0,   300,   301,   302,   303,
     304,   305,   306,   307,     0,     0,   308,   309,     0,     0,
     310,   311,   312,   313,     0,     0,     0,   314,   315,     0,
       0,     0,     0,   316,   317,   318,   319,     0,   320,   321,
     322,   323,     0,   324,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,   326,   327,     0,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,     0,
       0,   340,   341,   342,     0,   343,     0,   344,   345,   346,
     347,     0,   348,   349,   350,     0,     0,   351,     0,     0,
       0,   352,   353,   354,   355,   356,     0,     0,   357,   358,
     359,     0,   360,   361,     0,   362,   363,   364,     0,     0,
     365,     0,   366,   367,   368,     0,   369,   370,     0,     0,
       0,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,   380,   381,     0,     0,     0,   382,   383,   384,   385,
       0,     0,     0,   386,     0,     0,     0,   387,   388,   389,
     390,     0,   391,   392,   393,   394,   395,     0,     0,     0,
       0,     0,     0,   396,   397,     0,   398,     0,     0,   399,
       0,     0,   400,   401,   402,     0,     0,   403,   404,     0,
     405,   406,   407,   408,   409,     0,     0,   410,   411,   412,
     413,     0,   414,   415,     0,     0,   416,   417,     0,   136,
     418,   419,     0,   420,   421,   422,   423,     0,     0,     0,
       0,     0,   424,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,   431,   432,     0,   433,   434,     0,   435,
     436,     0,     0,   437,     0,     0,   438,     0,   439,     0,
     440,   441,     0,     0,     0,     0,     0,     0,   442,     0,
       0,   443,     0,     0,     0,   444,   445,   446,   447,     0,
       0,     0,     0,   448,   449,     0,   450,   451,     0,     0,
     452,   139,     0,   140,   141,   142,   143,   144,     0,     0,
       0,     0,     0,   145,     0,     0,   146,  2499,   147,   148,
     149,   150,   151,   152,   153,     0,   154,     0,     0,     0,
     155,     0,     0,     0,   156,     0,     0,   157,   158,   159,
       0,   160,     0,   161,   162,     0,     0,   163,     0,     0,
     164,     0,   165,   166,     0,   167,     0,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,     0,   184,   185,     0,
     186,     0,     0,   187,     0,     0,   188,     0,     0,     0,
       0,     0,     0,   189,   190,   191,     0,     0,   192,     0,
       0,     0,     0,   193,   194,     0,     0,     0,     0,   195,
       0,   196,     0,     0,     0,   197,     0,   198,   199,   200,
     201,     0,     0,     0,   202,     0,     0,   203,   204,   205,
       0,     0,     0,   206,     0,   207,   208,     0,   209,   210,
     211,     0,     0,   212,     0,   213,   214,   215,   216,   217,
       0,     0,   218,   219,   220,     0,     0,   221,   222,     0,
     223,   224,   225,   226,     0,     0,   227,     0,     0,     0,
     228,   229,     0,   230,     0,   231,     0,   232,   233,   234,
     235,     0,   236,     0,     0,     0,   237,   238,     0,   239,
       0,     0,   240,   241,     0,     0,     0,   242,   243,   244,
     245,     0,     0,   246,   247,     0,     0,   248,     0,   249,
       0,     0,     0,   250,   251,     0,     0,     0,   252,     0,
     253,   254,     0,   255,   256,     0,     0,     0,   257,     0,
       0,   258,   259,     0,     0,   260,     0,     0,   261,   262,
     564,     0,     0,     0,     0,   263,   264,     0,   265,     0,
     266,     0,   267,   268,     0,     0,     0,     0,     0,     0,
       0,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,     0,   282,   283,     0,   284,   285,
     286,   287,     0,   288,   289,   290,     0,     0,     0,   291,
     292,   293,   294,   295,     0,     0,   296,   297,     0,   298,
       0,   299,     0,   300,   301,   302,   303,   304,   305,   306,
     307,     0,     0,   308,   309,     0,     0,   310,   311,   312,
     313,     0,     0,     0,   314,   315,     0,     0,     0,     0,
     316,   317,   318,   319,     0,   320,   321,   322,   323,     0,
     324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   326,   327,     0,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,     0,     0,   340,   341,
     342,     0,   343,     0,   344,   345,   346,   347,     0,   348,
     349,   350,     0,     0,   351,     0,     0,     0,   352,   353,
     354,   355,   356,     0,     0,   357,   358,   359,     0,   360,
     361,     0,   362,   363,   364,     0,     0,   365,     0,   366,
     367,   368,     0,   369,   370,     0,     0,     0,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,   380,   381,
       0,     0,     0,   382,   383,   384,   385,     0,     0,     0,
     386,     0,     0,     0,   387,   388,   389,   390,     0,   391,
     392,   393,   394,   395,     0,     0,     0,     0,     0,     0,
     396,   397,     0,   398,     0,     0,   399,     0,     0,   400,
     401,   402,     0,     0,   403,   404,     0,   405,   406,   407,
     408,   409,     0,     0,   410,   411,   412,   413,     0,   414,
     415,     0,     0,   416,   417,     0,   136,   418,   419,     0,
     420,   421,   422,   423,     0,     0,     0,     0,     0,   424,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
     431,   432,     0,   433,   434,     0,   435,   436,     0,     0,
     437,     0,     0,   438,     0,   439,     0,   440,   441,     0,
       0,     0,     0,     0,     0,   442,     0,     0,   443,     0,
       0,     0,   444,   445,   446,   447,     0,     0,     0,     0,
     448,   449,     0,   450,   451,     0,     0,   452,   139,     0,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,  3050,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,     0,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,  4046,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,  1876,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
    2487,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,  2763,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
    3055,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,  2176,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,  2177,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,  2178,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,  2179,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,   957,   958,     0,   314,   315,     0,     0,
    2180,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,  4026,  4015,
    4027,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,  2181,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,  2350,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,  2493,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,  2011,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,   564,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,  2012,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,   136,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,  2501,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
    2502,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,   564,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   136,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,  2350,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,  2493,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,   564,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,   136,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
     917,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,   564,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   136,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,  1267,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,   564,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,   136,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,   896,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,   897,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   898,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,  2350,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,   564,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,   136,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
    2540,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,   564,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   136,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,   564,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,   136,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,  2483,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   136,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,  3953,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,  3954,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,   992,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,  1367,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
    2109,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,  2110,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,  2257,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,   136,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,  2878,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
    2109,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,   225,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,   146,     0,   147,   148,   149,   150,   151,
     152,   153,     0,   154,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,   162,     0,     0,   163,     0,     0,   164,     0,   165,
     166,     0,   167,     0,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,     0,   184,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,   202,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,   207,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,   217,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,   237,   238,     0,   239,     0,     0,   240,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,   251,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,   258,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,   314,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,   323,     0,   324,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,   326,   327,
       0,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,     0,     0,   340,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,   351,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,   361,     0,   362,
     363,   364,     0,     0,   365,     0,   366,   367,   368,     0,
     369,   370,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,   380,   381,     0,     0,     0,
     382,   383,   384,   385,     0,     0,     0,   386,     0,     0,
       0,   387,   388,   389,   390,     0,   391,   392,   393,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,   401,   402,     0,
       0,   403,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,   435,   436,     0,     0,   437,     0,     0,
     438,     0,   439,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,   449,     0,
     450,   451,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,   146,     0,
     147,   148,   149,   150,   151,   152,   153,     0,   154,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,   162,     0,     0,   163,
       0,     0,   164,     0,   165,   166,     0,   167,     0,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,     0,   184,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,   194,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,   202,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,   207,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,   217,     0,     0,   218,   219,   220,     0,     0,   221,
     222,     0,   223,   224,  1637,   226,     0,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,   237,   238,
       0,   239,     0,     0,   240,   241,     0,     0,     0,   242,
     243,   244,   245,     0,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,   251,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,     0,     0,     0,
     257,     0,     0,   258,   259,     0,     0,   260,     0,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
       0,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
    1638,   312,   313,     0,     0,     0,   314,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
     323,     0,   324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,   326,   327,     0,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,     0,     0,
     340,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,   351,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,   361,     0,   362,   363,   364,     0,     0,   365,
       0,   366,   367,   368,     0,   369,   370,     0,     0,     0,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
     380,   381,     0,     0,     0,   382,   383,   384,   385,     0,
       0,     0,   386,     0,     0,     0,   387,   388,   389,   390,
       0,   391,   392,   393,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,   401,   402,     0,     0,   403,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,   435,   436,
       0,     0,   437,     0,     0,   438,     0,   439,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
       0,     0,   448,   449,     0,   450,   451,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,  -257,  -257,
     206,     0,  -257,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
     147,   148,   149,   150,   151,   152,     0,     0,  -287,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,     0,     0,     0,     0,   163,
    3517,     0,   164,     0,   165,     0,     0,     0,     0,   168,
     169,  3518,   171,   172,     0,   173,   174,     0,     0,   176,
       0,   178,   179,   180,   181,     0,   182,   183,     0,     0,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,   203,
     204,   205,     0,  -278,     0,   206,     0,  -278,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,     0,     0,     0,   218,   219,   220,     0,     0,   221,
     222,  3519,   223,   224,   225,   226,     0,     0,     0,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,     0,   238,
       0,     0,     0,     0,     0,   241,     0,     0,     0,   242,
     243,   244,   245,  3520,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,     0,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,  3521,     0,     0,
     257,     0,     0,     0,   259,     0,     0,   260,  3522,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
    -242,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,     0,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
    3523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,     0,     0,   329,   330,   331,
       0,   333,   334,   335,   336,   337,   338,     0,     0,     0,
       0,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,     0,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,     0,     0,   362,     0,   364,  -242,     0,   365,
       0,     0,   367,     0,     0,   369,   370,  3524,     0,     0,
       0,   372,   373,   374,   375,   376,   377,     0,   379,     0,
     380,     0,     0,     0,     0,   382,   383,   384,     0,     0,
       0,     0,   386,     0,     0,     0,   387,     0,   389,     0,
       0,   391,     0,     0,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,     0,   402,     0,     0,     0,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,     0,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,     0,
       0,     0,   437,     0,     0,   438,     0,     0,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,  -278,     0,
    -242,     0,   448,     0,     0,   450,     0,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,  -275,     0,
     206,     0,  -275,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,  -275,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
     147,   148,   149,   150,   151,   152,     0,     0,  -287,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,     0,     0,     0,     0,   163,
    3517,     0,   164,     0,   165,     0,     0,     0,     0,   168,
     169,  3518,   171,   172,     0,   173,   174,     0,     0,   176,
       0,   178,   179,   180,   181,     0,   182,   183,     0,     0,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,  3866,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,     0,     0,     0,   218,   219,   220,     0,     0,   221,
     222,  3519,   223,   224,   225,   226,     0,     0,     0,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,     0,   238,
       0,     0,     0,     0,     0,   241,     0,     0,     0,   242,
     243,   244,   245,  3520,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,     0,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,  3521,     0,     0,
     257,     0,     0,     0,   259,     0,     0,   260,  3522,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
    -242,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,     0,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
    3523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,     0,     0,   329,   330,   331,
       0,   333,   334,   335,   336,   337,   338,     0,     0,     0,
       0,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,     0,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,     0,     0,   362,     0,   364,  -242,     0,   365,
       0,     0,   367,     0,     0,   369,   370,  3524,     0,     0,
       0,   372,   373,   374,   375,   376,   377,     0,   379,     0,
     380,     0,     0,     0,     0,   382,   383,   384,     0,     0,
       0,     0,   386,     0,     0,     0,   387,     0,   389,     0,
       0,   391,     0,     0,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,     0,   402,     0,     0,     0,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,     0,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,     0,
       0,     0,   437,     0,     0,   438,     0,     0,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
    -242,     0,   448,     0,     0,   450,     0,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,  -280,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
     147,   148,   149,   150,   151,   152,     0,     0,  -287,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,     0,     0,     0,     0,   163,
    3517,     0,   164,     0,   165,     0,     0,     0,     0,   168,
     169,  3518,   171,   172,     0,   173,   174,     0,     0,   176,
       0,   178,   179,   180,   181,     0,   182,   183,     0,     0,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,  3958,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,     0,     0,     0,   218,   219,   220,     0,     0,   221,
     222,  3519,   223,   224,   225,   226,     0,     0,     0,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,     0,   238,
       0,     0,     0,     0,     0,   241,     0,     0,     0,   242,
     243,   244,   245,  3520,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,     0,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,  3521,     0,     0,
     257,     0,     0,     0,   259,     0,     0,   260,  3522,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
    -242,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,     0,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
    3523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,     0,     0,   329,   330,   331,
       0,   333,   334,   335,   336,   337,   338,     0,     0,     0,
       0,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,     0,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,     0,     0,   362,     0,   364,  -242,     0,   365,
       0,     0,   367,     0,     0,   369,   370,  3524,     0,     0,
       0,   372,   373,   374,   375,   376,   377,     0,   379,     0,
     380,     0,     0,     0,     0,   382,   383,   384,     0,     0,
       0,     0,   386,     0,     0,     0,   387,     0,   389,     0,
       0,   391,     0,     0,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,     0,   402,     0,     0,     0,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,     0,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,     0,
       0,     0,   437,     0,     0,   438,     0,     0,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
    -242,     0,   448,     0,     0,   450,     0,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,  3996,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
     147,   148,   149,   150,   151,   152,     0,     0,  -287,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,     0,     0,     0,     0,   163,
    3517,     0,   164,     0,   165,     0,     0,     0,     0,   168,
     169,  3518,   171,   172,     0,   173,   174,     0,     0,   176,
       0,   178,   179,   180,   181,     0,   182,   183,     0,     0,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,  -261,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,     0,     0,     0,   218,   219,   220,     0,     0,   221,
     222,  3519,   223,   224,   225,   226,     0,     0,     0,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,     0,   238,
       0,     0,     0,     0,     0,   241,     0,     0,     0,   242,
     243,   244,   245,  3520,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,     0,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,  3521,     0,     0,
     257,     0,     0,     0,   259,     0,     0,   260,  3522,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
    -242,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,     0,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
    3523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,     0,     0,   329,   330,   331,
       0,   333,   334,   335,   336,   337,   338,     0,     0,     0,
       0,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,     0,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,     0,     0,   362,     0,   364,  -242,     0,   365,
       0,     0,   367,     0,     0,   369,   370,  3524,     0,     0,
       0,   372,   373,   374,   375,   376,   377,     0,   379,     0,
     380,     0,     0,     0,     0,   382,   383,   384,     0,     0,
       0,     0,   386,     0,     0,     0,   387,     0,   389,     0,
       0,   391,     0,     0,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,     0,   402,     0,     0,     0,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,     0,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,     0,
       0,     0,   437,     0,     0,   438,     0,     0,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
    -242,     0,   448,     0,     0,   450,     0,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,  -287,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,  3517,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,  3518,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,     0,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,  3519,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,  3520,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,  3521,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,  3522,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,  -242,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,  3523,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,  -242,     0,   365,     0,     0,   367,     0,     0,
     369,   370,  3524,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,  -242,     0,   448,     0,     0,
     450,     0,     0,   139,   452,   140,   141,   142,   143,   144,
       0,     0,     0,     0,     0,   145,     0,     0,     0,     0,
     147,   148,   149,   150,   151,   152,     0,     0,  -287,     0,
       0,     0,   155,     0,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,     0,     0,     0,     0,   163,
    3517,     0,   164,     0,   165,     0,     0,     0,     0,   168,
     169,  3518,   171,   172,     0,   173,   174,     0,     0,   176,
       0,   178,   179,   180,   181,     0,   182,   183,     0,     0,
     185,     0,   186,     0,     0,   187,     0,     0,   188,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
     192,     0,     0,     0,     0,   193,     0,     0,     0,     0,
       0,   195,     0,   196,     0,     0,     0,   197,     0,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,   203,
     204,   205,     0,     0,     0,   206,     0,     0,   208,     0,
     209,   210,   211,     0,     0,   212,     0,   213,   214,   215,
     216,     0,     0,     0,   218,   219,   220,     0,     0,   221,
     222,  3519,   223,   224,   225,   226,     0,     0,     0,     0,
       0,     0,   228,   229,     0,   230,     0,   231,     0,   232,
     233,   234,   235,     0,   236,     0,     0,     0,     0,   238,
       0,     0,     0,     0,     0,   241,     0,     0,     0,   242,
     243,   244,   245,  3520,     0,   246,   247,     0,     0,   248,
       0,   249,     0,     0,     0,   250,     0,     0,     0,     0,
     252,     0,   253,   254,     0,   255,   256,  3521,     0,     0,
     257,     0,     0,     0,   259,     0,     0,   260,  3522,     0,
     261,   262,     0,     0,     0,     0,     0,   263,   264,     0,
     265,     0,   266,     0,   267,   268,     0,     0,     0,     0,
    -242,     0,     0,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,     0,   282,   283,     0,
     284,   285,   286,   287,     0,   288,   289,   290,     0,     0,
       0,   291,   292,   293,   294,   295,     0,     0,   296,   297,
       0,   298,     0,   299,     0,   300,   301,   302,   303,   304,
     305,   306,   307,     0,     0,   308,   309,     0,     0,   310,
     311,   312,   313,     0,     0,     0,     0,   315,     0,     0,
       0,     0,   316,   317,   318,   319,     0,   320,   321,   322,
    3523,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,     0,     0,   329,   330,   331,
       0,   333,   334,   335,   336,   337,   338,     0,     0,     0,
       0,   341,   342,     0,   343,     0,   344,   345,   346,   347,
       0,   348,   349,   350,     0,     0,     0,     0,     0,     0,
     352,   353,   354,   355,   356,     0,     0,   357,   358,   359,
       0,   360,     0,     0,   362,     0,   364,  -242,     0,   365,
       0,     0,   367,     0,     0,   369,   370,  3524,     0,     0,
       0,   372,   373,   374,   375,   376,   377,     0,   379,     0,
     380,     0,     0,     0,     0,   382,   383,   384,     0,     0,
       0,     0,   386,     0,     0,     0,   387,     0,   389,     0,
       0,   391,     0,     0,   394,   395,     0,     0,     0,     0,
       0,     0,   396,   397,     0,   398,     0,     0,   399,     0,
       0,   400,     0,   402,     0,     0,     0,   404,     0,   405,
     406,   407,   408,   409,     0,     0,   410,   411,   412,   413,
       0,   414,   415,     0,     0,   416,   417,     0,     0,   418,
     419,     0,   420,   421,   422,   423,     0,     0,     0,     0,
       0,   424,   425,   426,     0,     0,     0,     0,   428,   429,
     430,     0,   431,   432,     0,   433,   434,     0,     0,     0,
       0,     0,   437,     0,     0,  3869,     0,     0,     0,   440,
     441,     0,     0,     0,     0,     0,     0,   442,     0,     0,
     443,     0,     0,     0,   444,   445,   446,   447,     0,     0,
    -242,     0,   448,     0,     0,   450,     0,     0,   139,   452,
     140,   141,   142,   143,   144,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,   147,   148,   149,   150,   151,
     152,     0,     0,     0,     0,     0,     0,   155,     0,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
       0,     0,     0,     0,   163,     0,     0,   164,     0,   165,
       0,     0,     0,     0,   168,   169,     0,   171,   172,     0,
     173,   174,     0,     0,   176,     0,   178,   179,   180,   181,
       0,   182,   183,     0,     0,   185,     0,   186,     0,     0,
     187,     0,     0,   188,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,   192,     0,     0,     0,     0,
     193,     0,     0,     0,     0,     0,   195,     0,   196,     0,
       0,     0,   197,     0,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,   203,   204,   205,     0,     0,     0,
     206,     0,     0,   208,     0,   209,   210,   211,     0,     0,
     212,     0,   213,   214,   215,   216,     0,     0,     0,   218,
     219,   220,     0,     0,   221,   222,     0,   223,   224,   225,
     226,     0,     0,     0,     0,     0,     0,   228,   229,     0,
     230,     0,   231,     0,   232,   233,   234,   235,     0,   236,
       0,     0,     0,     0,   238,     0,     0,     0,     0,     0,
     241,     0,     0,     0,   242,   243,   244,   245,     0,     0,
     246,   247,     0,     0,   248,     0,   249,     0,     0,     0,
     250,     0,     0,     0,     0,   252,     0,   253,   254,     0,
     255,   256,     0,     0,     0,   257,     0,     0,     0,   259,
       0,     0,   260,     0,     0,   261,   262,     0,     0,     0,
       0,     0,   263,   264,     0,   265,     0,   266,     0,   267,
     268,     0,     0,     0,     0,     0,     0,     0,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,     0,   282,   283,     0,   284,   285,   286,   287,     0,
     288,   289,   290,     0,     0,     0,   291,   292,   293,   294,
     295,     0,     0,   296,   297,     0,   298,     0,   299,     0,
     300,   301,   302,   303,   304,   305,   306,   307,     0,     0,
     308,   309,     0,     0,   310,   311,   312,   313,     0,     0,
       0,     0,   315,     0,     0,     0,     0,   316,   317,   318,
     319,     0,   320,   321,   322,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,     0,   329,   330,   331,     0,   333,   334,   335,   336,
     337,   338,     0,     0,     0,     0,   341,   342,     0,   343,
       0,   344,   345,   346,   347,     0,   348,   349,   350,     0,
       0,     0,     0,     0,     0,   352,   353,   354,   355,   356,
       0,     0,   357,   358,   359,     0,   360,     0,     0,   362,
       0,   364,     0,     0,   365,     0,     0,   367,     0,     0,
     369,   370,     0,     0,     0,     0,   372,   373,   374,   375,
     376,   377,     0,   379,     0,   380,     0,     0,     0,     0,
     382,   383,   384,     0,     0,     0,     0,   386,     0,     0,
       0,   387,     0,   389,     0,     0,   391,     0,     0,   394,
     395,     0,     0,     0,     0,     0,     0,   396,   397,     0,
     398,     0,     0,   399,     0,     0,   400,     0,   402,     0,
       0,     0,   404,     0,   405,   406,   407,   408,   409,     0,
       0,   410,   411,   412,   413,     0,   414,   415,     0,     0,
     416,   417,     0,     0,   418,   419,     0,   420,   421,   422,
     423,     0,     0,     0,     0,     0,   424,   425,   426,     0,
       0,     0,     0,   428,   429,   430,     0,   431,   432,     0,
     433,   434,     0,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   440,   441,     0,     0,     0,     0,
       0,     0,   442,     0,     0,   443,     0,     0,     0,   444,
     445,   446,   447,     0,     0,     0,     0,   448,     0,     0,
     450,     0,     0,     0,   452
};

static const short int yycheck[] =
{
       7,   122,   600,   601,   526,   733,   910,   634,   635,   526,
     591,  1090,   911,    20,     5,   547,    23,   639,    21,   826,
    1554,   945,  1654,  1210,  1090,    32,  2158,    30,  2119,   587,
     588,   748,   850,    36,   560,    42,     7,   876,  1037,  2415,
     476,  1270,  2045,  1351,   671,  1617,    53,  1893,  2468,  2088,
    1113,   852,  1898,  2517,  1335,   619,  1791,  1120,  2849,   877,
    1153,  2591,   915,  1061,   691,  1873,  2328,  1028,   915,  3107,
    2316,   693,  2318,   533,   696,   876,   703,   704,   705,  2123,
    2124,  1810,  1859,  2112,  2113,  2114,    93,  1822,  2618,  2146,
    1284,  2196,  1827,    23,  1859,   658,  1739,  2985,  1833,  1834,
    2103,  1808,  1837,  2139,  1808,  1413,    16,  1301,   115,    18,
     117,  2147,    18,   605,   121,   122,   123,  1311,  1312,    15,
      16,    15,    16,  1121,  1122,    16,    24,  1125,  1126,  1127,
    1128,   138,  1130,  1131,  1132,  1133,  1134,  1135,  1136,  1137,
    2635,   722,    50,   112,    15,    16,   117,   711,   712,   713,
     121,  2907,  1859,    20,  2197,  1859,  3194,  2341,  2201,   723,
      61,  2345,    18,    93,    57,    58,  3084,    15,    16,  2212,
      18,  1341,   141,    35,    33,    29,  3137,  3138,  1848,  2222,
    3141,   135,  2586,   157,   878,    96,  1763,  1764,  2295,    18,
      57,    58,    99,   751,    58,   102,    15,    16,   157,  3160,
    2187,  2188,   214,  1780,    62,  3166,   135,   171,   138,   223,
     128,   223,  3521,  3522,    15,    16,    20,    11,    50,   281,
    1797,  1798,    15,    16,   750,    60,  2461,   112,    66,    33,
     232,   141,   141,   263,    15,    16,   145,   129,   176,   145,
    2563,    78,   206,    47,   342,  3036,  1433,    71,   131,   336,
     145,   112,  3675,    57,    58,    54,   141,   329,  1351,   361,
      15,    16,   820,   316,    15,    16,  1843,  1844,  1845,  1846,
     176,   206,   230,    15,    16,   593,   338,    15,    16,  3167,
     141,   418,   808,   241,   363,   206,   337,    35,   114,   145,
     917,  3300,  2871,  3296,   469,    15,    16,  1025,    60,   114,
    2287,  2288,   394,     8,    15,    16,    24,   147,  1875,    12,
     792,   149,   363,   211,   230,    22,   145,    15,    16,   113,
    1413,   113,   135,  2131,    41,  3213,   173,   228,   263,   475,
      15,    16,   194,   112,   116,   434,   401,   500,   252,    15,
      16,   353,   449,  3261,   465,   281,  2567,   511,  1076,   532,
    2560,    40,  1080,   813,   176,   493,   500,  2567,   496,   389,
    2570,   141,    15,    16,  2574,   326,  3327,    15,    16,    15,
      16,   969,   116,   971,   972,  3336,   497,   472,  2588,  2589,
     195,   939,  1653,   176,  1680,    15,    16,   285,  2598,   209,
      15,    16,    15,    16,    65,   176,    15,    16,    65,  2775,
     583,   223,   338,   541,   499,   470,   552,   263,   255,   279,
     172,   385,   373,   895,    15,    16,   330,  2152,   135,   312,
     584,   500,   125,  1800,  1323,   588,   385,   745,   603,   536,
     222,  1782,   141,  1150,   176,   527,  1754,   263,    15,    16,
    3449,  3450,    15,    16,   130,   152,   194,   500,   263,   500,
     385,   347,   589,   347,   350,  3246,   350,  1275,   465,   466,
    1278,   166,   173,   421,  1027,   572,   246,  2524,  1286,   352,
     363,  2500,   216,   526,  1782,  2191,   483,  1040,   970,  2320,
     582,  2572,   128,   582,  2191,   557,   493,  2191,  1341,   410,
     497,   589,   499,   211,  1341,  1313,  1314,   584,   505,   347,
    1808,   417,   350,  2532,   511,  2596,  2597,  3930,   416,    74,
      90,   349,  2241,  1606,  3093,  3553,    15,    16,  2295,   521,
     582,  2329,    15,    16,    15,    16,   533,   534,   347,   328,
    2295,   350,  2099,   389,  1335,  1116,   566,   246,  3294,  1733,
    1848,    63,   544,  2866,   551,  2652,   347,   384,   443,   350,
     442,  1859,   331,   560,   347,   562,   350,   350,  2793,  1412,
    1124,   563,   397,  3872,  3873,  1412,   347,   285,   575,   350,
     584,   583,   579,  1009,  1010,   505,  3040,  1141,   585,   543,
     587,   588,   483,   542,   416,   592,   593,  1585,  2295,  2145,
     597,  2295,   347,   451,  1030,   350,   347,   504,  1596,   350,
     507,  1599,  1160,  1039,   575,   347,   560,   614,   350,   347,
     584,   329,   350,   375,  1308,  1051,  1052,  1053,  1579,  2289,
     511,   590,  2199,  2200,  1060,  2202,   747,   347,  2205,  2206,
     350,   560,  2209,  2672,  1351,  3391,   347,  2214,   500,   350,
    3678,  2218,  2219,  2220,  2221,   556,   584,  2868,  2225,   347,
    2227,   658,   350,   563,  2286,  1213,  2233,   511,  2868,  2236,
    2237,  2238,   347,   530,  2651,   350,  2474,  2475,  2889,  3425,
    1228,   347,  1842,   569,   350,   569,   584,  3595,   584,  2889,
     590,   590,   511,  3644,   602,  3646,   584,   551,  3183,  1782,
     584,   587,    15,    16,   347,   588,  1413,   350,   569,   347,
     524,   347,   350,    61,   350,   590,    15,    16,  3112,   716,
     566,   718,    15,    16,    15,    16,  2293,   347,   558,   141,
     350,   569,   347,   582,   347,   350,   530,   350,   347,   590,
     851,   350,    15,    16,  3737,   742,   743,   744,   745,   746,
     747,  1201,   749,   750,   751,   752,   347,   560,   434,   350,
     569,  2790,   500,  1279,  2886,  1848,   538,  3645,  2787,  3647,
    2327,   479,    15,    16,   583,   584,  1859,  1259,   569,  1229,
     347,   533,   743,   350,   347,   746,   569,   350,   749,   468,
     787,   561,  2839,   584,   206,  3746,  2843,  3748,   569,   544,
     583,   798,    15,    16,   538,    50,  2825,   486,  2801,  2070,
      98,   808,   809,  2839,   475,    68,   813,  2843,   475,  2105,
     590,   802,  2189,   820,   569,    15,    16,  3079,   569,  2170,
    2138,    10,  2927,   512,    15,    16,    66,   569,  1345,   584,
      45,   569,   583,   584,    15,    16,    31,  2678,  2573,   557,
    2575,  2557,   584,   423,   851,   583,   584,  2582,   347,   569,
    2557,   350,   561,  2557,   347,   503,   347,   350,   569,   350,
    2595,  3303,  2170,   583,   584,   430,  2601,   389,   798,  3090,
     228,   569,   583,  2516,   289,  2652,    33,   564,  2686,   809,
    3090,   590,  2617,  2191,   569,  2928,   584,  2652,    15,    16,
     160,  1730,  2621,   569,  2123,  2124,   582,   197,   583,   584,
     586,    15,    16,    42,   911,  1723,  1366,   583,   584,    60,
     176,   209,    15,    16,  1732,   295,   569,  1735,  1736,   245,
    1759,   569,  3386,   569,  1922,   176,   933,   412,  1991,  1730,
     583,  3687,   939,  2977,   348,   942,   943,  3121,  2132,   569,
     143,  3979,  1505,   171,   569,  2652,   569,   434,  2652,   157,
     569,   246,  3198,   583,   584,    12,  3712,   246,  1759,   584,
     583,   584,   151,  2150,   366,   584,   324,    89,   569,  2525,
    2526,  3155,  3156,    15,    16,   434,   191,    18,   206,  3163,
     246,  2289,  1103,   990,   991,   992,  3170,  2295,   410,  1842,
      15,    16,   569,   113,   211,  1842,   569,    12,  1997,  1998,
      56,  3263,   429,   933,  2581,  1603,   279,   584,   211,  2088,
      24,   584,  3803,   943,  3071,  3072,  2593,   262,   328,  1140,
    1027,   172,  2088,  1555,   347,    15,    16,   350,   223,  1990,
      15,    16,   178,  1040,  1598,  3064,    15,    16,   347,  2000,
    2848,   350,   247,   475,   347,   250,   347,   350,    89,   350,
     245,   345,  2784,   348,    15,    16,   109,   600,   601,   348,
     990,   331,   992,   466,   347,  1782,  1624,   350,   125,  2148,
     569,   322,     6,   328,    15,    16,   569,  2170,   569,   138,
     483,  2362,  2148,  1090,   184,   584,  1612,   179,   520,   148,
     212,   584,   402,   584,   347,   582,  1103,   350,  1219,   584,
     141,   157,   222,   366,   145,   161,    15,    16,   230,   349,
     125,   384,   329,   471,     8,   168,   379,   173,   498,   241,
    2852,    55,   279,   582,   347,   483,   329,   350,    15,    16,
     171,  1848,   173,  1140,   209,    29,  1662,  1663,  1145,  3559,
    2986,   194,  1859,   126,  2331,   525,   187,   347,   434,   202,
     350,   192,   252,  1160,    15,    16,   347,   496,   233,   350,
     109,   416,  3201,   112,   409,   206,   347,   582,   590,   350,
     584,   212,    15,    16,  1691,   475,   315,   385,   451,   220,
     145,   386,  3624,    15,    16,     0,   316,   442,   377,   230,
    1197,   176,  1199,   315,  1201,   129,  2289,   211,   496,  3575,
     241,   316,  2295,   398,    20,   246,  1213,   260,   173,   567,
     451,  1202,  1219,   428,   255,    15,    16,    33,    76,   168,
     347,  1228,  1229,   350,   375,    15,    16,  1348,   179,    12,
     493,    47,  1239,   347,   366,   561,   350,   293,    15,    16,
    1247,    57,    58,   532,   347,   194,   569,   350,   518,  2557,
     315,  2883,   515,  1260,  1261,  1262,  1263,  1264,  1265,   434,
     569,   584,   479,  1254,   534,   257,   569,   122,   569,  1276,
    1277,   285,  1279,   338,   315,   584,   479,   141,  1285,   332,
     469,   584,   137,   584,   362,   377,   569,   346,  2212,  1260,
    1261,  1262,   202,  1264,   204,    12,   582,   338,  1305,   421,
    3830,   584,   372,    15,    16,   347,  1277,   348,   350,    15,
      16,   260,   458,  2455,  1285,   543,   569,   562,   176,   311,
    3784,  2893,   347,   306,    12,   350,   404,   516,   176,   385,
     187,   584,  3796,  1263,   542,  1265,   377,   434,    51,   439,
     557,  1348,   125,   145,  2652,   112,   569,    60,  2411,  3388,
     110,   544,    15,    16,   557,  1362,   187,   347,   480,  1366,
     350,   584,   347,  1354,  3210,   350,   133,   556,   347,   569,
     500,   350,   220,    70,  1365,  1305,   584,  2456,   569,   177,
     421,   584,   533,   332,   584,   500,   347,   533,   569,   350,
    2456,   584,   326,   584,  2536,   938,   526,    15,    16,   230,
     167,   442,   191,   584,   496,   263,   347,   582,   125,   350,
    1417,   526,  1419,  1420,  1421,  1422,  1423,    30,    15,    16,
      15,    16,   145,  1430,  3427,  1432,   377,  3621,    15,    16,
    1994,   112,  1362,    19,   451,    15,    16,   125,   347,   480,
     499,   350,   569,   124,   233,   988,  2444,   474,  1419,  1420,
    1421,   478,   582,  2170,   388,   569,   390,   584,  2056,    72,
     347,   221,    89,   350,  1900,  3371,   569,   582,   389,   583,
     523,   223,   112,    15,    16,    15,    16,  1913,   443,   544,
     583,    15,    16,   475,   124,   582,   347,   408,   582,   350,
     242,   532,    20,    15,    16,   589,   513,  1618,  1505,  1506,
     348,   582,   543,   544,   347,    33,   584,   350,   589,   151,
    1946,    15,    16,   166,   211,   347,   437,   348,   350,    47,
     561,  2600,   563,   191,    15,    16,   139,   569,   584,    57,
      58,   117,   434,   434,  2600,    15,    16,    15,    16,   252,
    3734,   583,   583,   584,   569,   496,   587,   347,    12,   590,
     350,   434,    95,    15,    16,   206,  1563,   347,   583,  2652,
     350,   359,    15,    16,  3302,   233,    15,    16,   325,   326,
     347,  2007,  2289,   350,   523,    15,    16,    41,  2295,   569,
     113,    15,    16,   236,   569,   212,    15,    16,   589,   521,
     569,    15,    16,   583,   577,   578,   579,   580,  1605,    15,
      16,    15,    16,   230,   583,  1612,  3344,   511,   569,  1616,
    3986,  1618,   544,   294,   241,  3521,  3522,  1624,    82,  1626,
      15,    16,   583,    87,  1631,  1632,   323,  1634,   569,    15,
      16,   391,   329,  3724,    16,   347,   176,  2561,   350,  2563,
    1647,   347,   583,  1650,   350,    15,    16,   205,   184,    15,
      16,   496,   450,   196,   294,  1662,  1663,  1664,  1665,   497,
     569,  2468,  3691,  3295,   316,  1672,  1673,  1674,  2507,  1660,
    3405,  3406,  3407,  3408,   583,   328,   434,   139,   187,  1670,
     582,   582,   569,  1690,   347,   586,  1616,   350,   315,    15,
      16,  2690,  1699,    15,    16,   205,   583,  2515,   395,   582,
     187,  1631,  1632,  1694,  1634,   342,  2507,    16,   569,    77,
    2709,  2710,   563,   209,   530,  2794,   252,  1647,    15,    16,
    1650,   481,   583,    15,    16,    93,   569,  1734,  2794,   347,
     109,  2730,   350,   584,  1664,  1665,  1857,   569,   554,  1746,
     583,    16,  1672,  1673,  1674,   214,  1753,  3610,  2977,  3612,
     347,   583,   347,   350,   223,   350,  3888,  3663,  3664,   372,
     347,   225,   220,   350,   576,    69,   582,   347,  2847,   569,
     350,   583,  1893,   583,   584,    46,  1767,  1898,    12,   569,
     393,  2847,   479,   583,    18,  1776,  1777,   176,   576,   168,
     548,   549,   569,   583,   421,   583,  1787,  1788,  1789,  1790,
     563,  1792,  1793,   339,  1734,   347,   583,   347,   350,   422,
     350,   354,  1819,   347,   583,   194,   350,   126,   493,  2417,
     363,   496,   263,  1753,   582,   347,   369,   589,   350,   539,
     294,   528,  1823,  1824,   496,  1826,   344,  1828,  1829,  1830,
    1831,  1832,   582,   347,  1835,  1836,   350,   469,   500,   551,
    1857,   126,   554,   480,   172,  1862,   347,   569,  3764,   350,
     557,   474,  1983,   569,  1871,   927,   928,   347,   172,   347,
     350,   583,   350,  3779,   526,    69,     6,   583,   583,   584,
    3067,   260,   209,  2873,   353,   347,  1893,  3793,   350,   583,
     584,  1898,   356,  2014,   347,    24,   410,   350,   347,    57,
      58,   350,   964,   439,   434,   209,   569,   347,    66,    11,
     350,   454,   442,   347,  2904,   582,   350,   582,   347,   500,
     583,   350,  2912,   347,   109,  2915,   350,  2453,   582,   233,
     582,   347,   582,   347,   350,  2652,   350,   528,   529,    60,
     531,  1871,  2866,  2942,  3576,   260,   126,   582,    69,   583,
     584,   569,   347,   332,  3860,   350,  3035,   583,   584,    80,
     587,   347,   267,   268,   350,   583,  3872,  3873,   582,  3035,
    2406,  2497,   569,   582,   569,   582,  1983,   347,   172,   582,
     350,   347,   569,   168,   350,   584,   583,   589,   583,   569,
     583,   584,  2113,   457,  2115,  2116,   583,   306,   541,   583,
     584,  2008,   530,   583,  2928,  3582,  3912,  2014,  3585,  3586,
    3587,  3588,   151,  3547,   143,   209,  3922,   332,   548,   549,
     582,   347,   550,   551,   350,   347,   490,   569,   350,   569,
    3109,   306,   583,   584,   582,   569,  2157,  2158,    70,   233,
     154,   583,   357,  3109,  3950,   544,  3952,   569,   479,   583,
     347,   172,   582,   350,   544,   347,  3962,   178,   350,   582,
      60,   583,  3797,  2580,  2071,   569,  3972,   582,  3974,    69,
    3976,   375,  3704,    24,   376,   260,   582,  3983,   569,   583,
      80,  2088,   211,   424,   583,   584,  3992,    70,   209,   569,
     582,   569,   583,  2992,   399,   400,    15,    16,    81,  2106,
    2107,  4007,  4008,   583,  3681,   583,  2113,   569,  2115,  2116,
      95,   143,   233,   424,   582,  2106,   569,  4023,  4024,    70,
     569,    18,  4028,  3700,  3701,  1186,   306,   582,  1189,   569,
     583,  1192,  3709,   345,   583,   569,   445,   446,   583,   584,
     569,  2148,   338,   583,   523,   569,   582,   332,   493,   583,
    2157,  2158,   582,   569,   583,   569,   285,   583,   584,   583,
      33,   160,   583,   584,   583,   584,   151,   583,   362,   583,
     445,   446,   172,    24,   569,   583,   584,   582,   178,   211,
     109,   375,   582,   569,   582,    58,   497,   584,   583,  1002,
    1003,  1004,    89,   455,   179,    57,    58,   583,   582,   569,
     329,  1014,   582,   569,   582,    12,   503,   158,   523,   209,
     582,   503,    48,   583,     3,   582,   109,   583,   582,    70,
       9,    10,    15,    16,   583,   584,    99,   582,  2235,   102,
     541,   582,  1045,   233,  3969,  1048,   582,   110,   377,   168,
      29,   362,  2249,   569,   141,   556,    35,   569,   145,   582,
      39,   582,   235,  2817,   375,  1068,  1069,   583,   582,  1072,
     211,   583,   583,   584,   573,   574,   575,   576,   577,   578,
     579,   580,   569,   583,   584,   168,   173,   569,  1091,  1092,
     540,   541,  2718,   543,   582,   545,   176,   583,   584,   109,
     187,   323,   143,   582,  2285,   192,   582,   329,   573,   574,
     575,   576,   577,   578,   579,   580,   582,   158,  2315,  2316,
     103,   104,   105,   106,   107,   212,   582,  2324,   125,   582,
    2756,   304,   257,   220,   109,   582,   325,   326,   582,   185,
     469,   260,   331,   230,   285,   582,    89,   458,   523,  1632,
     582,  1634,   131,   582,   241,   328,   583,   584,   168,   246,
     479,   582,   478,   479,    11,   481,   482,   582,   255,   485,
     211,   487,  2960,   395,   582,  3289,  3290,   260,  2926,   583,
     584,   582,   323,   582,   194,   375,   582,   516,   329,  1672,
    1673,  1674,   175,   168,   582,  2315,   583,   584,   195,    48,
     583,   584,   377,   126,  2324,   575,   576,   577,   578,   579,
     580,    70,   584,   332,   387,   198,   199,   200,   201,   194,
     583,   584,   533,   583,   584,   582,  3414,   556,   315,   582,
    2427,   582,  2429,  2430,  2431,  2432,   282,   283,   557,    98,
     582,   287,   288,  2440,   285,   583,   584,   582,    95,   332,
     260,   338,   583,   584,   317,   582,  2453,   479,  3664,  2456,
     582,   348,   338,    31,   582,   584,   113,   582,   458,   212,
    2430,  2431,  2432,  2470,  2471,  2472,  2983,   583,   584,   582,
    2591,   582,   323,   582,   143,   260,  2483,   230,   329,   582,
     377,   582,  2489,   107,  2491,   582,   469,   582,   241,   582,
    2497,   429,  2483,   532,  3573,  3127,   528,  2618,  3130,  3131,
    2470,  2471,  2472,   296,   577,   298,   299,   300,   583,   584,
    2440,   496,   332,   150,   307,  3147,   583,   584,   442,   518,
      56,   582,   179,   520,   421,   557,   583,   584,   479,   583,
     584,   516,   246,   533,   173,   534,   583,   584,   583,   584,
     209,   583,   584,   583,   584,   442,   493,   332,   126,   206,
     475,   175,   584,  2560,   347,   583,   584,   350,   475,  2562,
    2567,   475,   315,  2570,   583,   584,   279,  2574,  2571,  2576,
     257,   556,   142,   306,  2577,    79,   449,   201,   584,  2586,
    3479,  2588,  2589,   480,  2591,   338,  3485,  2578,  2579,   340,
     383,  2598,   583,  2600,   523,   489,  2599,   583,   584,   256,
     112,  2604,  2609,    98,   126,   145,   557,  2610,  2611,   583,
     584,  2618,  2603,   583,   584,   284,   583,   584,  2625,  2626,
     588,   157,   135,   136,  1437,   161,   166,   753,   479,  2636,
     523,     6,   301,  2640,   507,   532,  2643,   173,   431,   432,
     180,   461,   582,  2650,  3860,   223,    97,   544,     4,   189,
     583,   584,  3250,   433,   323,  2662,   463,   464,   465,   466,
     467,   468,  2669,   536,   561,  2636,   563,   245,   421,   556,
    1077,  1078,    54,   480,  3702,  3703,   300,   402,   335,  2609,
     154,    89,    98,   307,   341,  2806,   583,   584,  3455,  3456,
     587,  2803,  2804,   590,  1507,   203,   236,   237,  1511,  3697,
     489,  2822,   584,   523,  2765,  2766,   557,   179,    25,    26,
    3018,  3019,   445,   446,   179,   584,    66,   589,   507,    12,
     377,  1534,   560,  3802,   264,   514,   583,   480,   306,    35,
     583,   500,   125,   584,  3950,     9,  3952,   584,   523,  2669,
      57,    58,    59,  2750,   589,   589,   535,   325,   326,    66,
     583,  2758,  3559,    70,   583,   582,  3972,   293,   245,   383,
     143,    78,   584,   589,   338,  2886,   559,  2758,    25,    26,
     588,    48,   563,   584,   493,  2782,   569,   570,   571,   582,
     279,    98,   322,   440,   306,   252,   279,  2794,  2795,    35,
    2797,  4007,  4008,   361,   584,   112,   102,   584,   115,  2806,
      57,    58,    59,   109,   212,  2812,   511,   584,   432,    66,
     479,   511,   584,    70,  3812,  2822,  3715,  3716,   584,  3718,
     398,    78,   230,  2830,   584,   494,   143,  2797,   223,    25,
    3452,  3453,  3454,   241,   374,   577,   173,   494,   224,   496,
    2847,    98,   575,   576,   577,   578,   579,   580,  3747,   385,
     491,   162,   173,   584,   160,   112,   102,   537,   115,   453,
     584,  2868,   168,   109,  3491,  2986,  2873,   445,   446,   121,
      66,   583,   364,   584,    70,   338,   582,   584,   456,  2886,
     145,   145,  2889,    70,   145,   145,   143,   476,   194,   145,
     145,   145,   209,  3891,    81,   145,  2887,  2904,  3420,   584,
     217,   145,   145,   145,  2895,  2912,   145,   315,  2915,   145,
      95,   145,   145,   502,   160,   232,   112,   145,   539,  2926,
     565,   543,   168,   445,   446,  2932,    46,   176,  2935,  3050,
     338,   126,  2939,   120,   179,   559,  3835,   584,  3837,  3838,
     583,   583,  4021,   583,   577,   583,   176,   571,   194,   583,
     582,    73,   209,    75,   260,  4021,  2947,   583,   583,   576,
     217,   584,  2969,  3321,  3322,  4044,   151,   284,   164,   583,
     583,   583,   583,  4052,  2965,   232,  3334,   583,   583,  2986,
     584,   584,  3340,   583,   301,   583,  4052,   443,   245,   582,
     112,   582,   580,   583,   179,   573,   574,   575,   576,   577,
     578,   579,   580,   582,   584,  2935,  3364,   561,   389,  3367,
     316,   133,   210,   421,   260,  3642,  3548,   582,   582,   485,
     185,   327,   589,  3030,   209,   331,   332,   284,  3035,   176,
     619,   583,   451,   384,   584,   624,   442,   233,   355,   584,
     173,    46,   313,  3050,   301,   167,   363,   126,   235,   469,
     405,   573,   574,   575,   576,   577,   578,   579,   580,   469,
     469,   433,   469,   256,   469,   654,   582,   544,  3590,   338,
     316,   256,   480,   583,   589,  3066,   139,   583,   219,  3677,
     219,   670,   589,  3090,   589,   331,   332,   583,   589,  3210,
     584,  3098,   583,  3100,  3675,   583,   255,   583,   355,   589,
     583,   252,  3109,   500,   589,  3112,   363,   589,   126,   426,
     511,   306,   511,   511,   584,  4019,   566,   304,    46,   511,
     582,   582,   711,   712,   713,   714,   345,   176,   176,   325,
     326,   176,   220,   176,   723,   331,   589,   227,   325,   326,
     589,   328,   338,   332,   223,  3266,   563,   584,   230,   230,
     335,   351,   297,    98,    98,    69,   341,   362,   362,   362,
     121,   231,   479,   511,   494,   231,   494,   121,   362,   426,
      46,   362,  3179,   511,   360,   344,   187,   494,   362,   375,
     502,   145,   146,   362,   584,   500,  3193,   372,   582,   418,
     338,  3182,   377,   583,   500,  3202,   362,   514,   504,   348,
     387,   507,   582,  3210,   521,   223,   577,   221,   582,   582,
     589,   221,   518,   583,   583,   532,   180,   523,   583,   583,
     526,  3342,   479,   583,   583,   189,   583,   306,   577,   582,
     338,   206,   247,   362,   356,   589,   583,   494,   584,   584,
     583,   176,   438,   538,   223,  3252,   243,    66,   267,   230,
     445,   446,   230,   338,   500,   440,   233,   514,   504,  3266,
     584,   507,   226,   233,   521,   338,   582,   584,   373,   575,
     576,   589,   518,   237,   396,   532,   338,   523,  3285,    70,
     526,    18,   469,   479,   582,   338,   430,  3804,   306,    46,
     246,   455,   434,  3300,   332,   332,   583,   583,   436,   583,
     264,   563,   624,   132,   584,  3308,   239,   187,  4036,   494,
     444,   145,   497,   583,   582,   582,   233,   230,   230,    74,
     451,   584,   233,   128,   583,   582,   584,   455,    18,   575,
     576,   516,   654,   584,    33,  3342,   584,   533,   303,   235,
     384,  3939,   583,   583,   582,   563,   583,   220,   670,  3930,
      46,   583,  3343,   584,   589,   319,   541,   946,   583,   583,
     583,  3368,   582,   584,   192,   582,   445,   446,   583,   303,
     500,   556,   389,   500,  3381,  3382,   544,   544,   112,   574,
     575,   576,   577,   578,   579,   580,   112,   371,   589,   332,
    3988,   583,   714,   265,   266,   267,   268,   269,   270,   582,
     272,   273,   274,   275,   276,   277,   278,   582,   280,   998,
     999,   582,   582,   303,  3936,   156,   500,   500,  1007,  1008,
    1009,  1010,  1011,  1012,  1013,   582,   582,   445,   446,  1018,
     582,  4012,  1021,  1022,   584,  1024,   582,  1026,   233,   500,
      68,  1030,  3449,  3450,  1033,  1034,  1035,  1036,   548,  1038,
    1039,   583,  3382,    16,   332,   544,   582,  1046,  1047,  3466,
    1049,  1050,  1051,  1052,  1053,  4046,  1055,   583,  1057,  1058,
    1059,  1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,   544,
     582,  1070,  1071,   332,  1073,   582,  1075,   554,   582,   332,
    1079,   538,  1081,  1082,   573,   574,   575,   576,   577,   578,
     579,   580,   554,   112,  1093,  1094,   233,   331,   233,   332,
    1099,  3518,   332,  1102,   332,   332,  3523,   332,   473,   418,
    1109,  1110,  1111,   582,  1113,   583,   538,   399,   400,   345,
     496,  1120,  1121,  1122,   119,  1124,  1125,  1126,  1127,  1128,
     248,  1130,  1131,  1132,  1133,  1134,  1135,  1136,  1137,   268,
     582,   582,  1141,  1142,  3561,   573,   574,   575,   576,   577,
     578,   579,   580,   484,   220,   173,  3573,  3574,   327,   549,
     583,   140,  3579,   560,   583,   583,   583,   583,    30,   583,
     583,   563,   584,   173,  3705,   583,   332,   582,   121,   121,
     591,   582,   502,   143,   377,    46,    46,   138,    46,   145,
     560,   176,    30,  3610,   128,  3612,   582,  3614,   358,   583,
     583,   583,   197,   584,   485,    46,    46,    46,    95,    46,
      46,   397,     5,   582,   946,   582,   220,   139,   590,   345,
     120,    16,   139,   560,   205,    60,    60,   262,   590,   111,
     591,   345,   345,   134,  3574,   583,   583,   271,    52,  3656,
     582,   590,   583,   427,   583,   139,   145,   503,  1247,   584,
     190,   584,   584,   583,   590,    52,  1255,   409,   173,   173,
     173,   206,   257,   503,   562,   112,   998,   999,   332,   582,
      12,    13,   549,   248,   442,  1007,  1008,   174,  1838,  1011,
    1012,  1013,  3528,  2953,   279,   601,  1018,  2186,  3705,  1021,
    1022,   178,  1024,  2019,  1026,  3377,  3713,  3550,  3699,  3830,
    2958,  1033,  1034,  1035,  1036,  3788,  1038,   924,  3190,  3193,
    3882,  3380,  4046,  4000,  1046,  1047,  3371,  1049,  1050,  3371,
    3371,  3371,   209,  1055,  3371,  1057,  1058,  1059,  3745,  3371,
    1062,  1063,  1064,  1065,  1066,  1067,  4009,  3371,  1070,  1071,
    3371,  1073,  3909,  1075,  3371,  3371,    88,  1079,  3757,  1081,
    1082,  3909,  3371,  3873,  3371,  3371,  3783,  3888,  2602,  3782,
    1357,  1093,  1094,  3387,   962,  3896,  1606,  1099,  2782,   256,
    1102,  1810,  3579,  3414,   116,  2445,  3032,  1109,  1110,  1111,
      13,   376,  3695,  3812,  3891,  3802,  3936,   129,  3898,   384,
    3590,   473,  1412,  2968,  2241,  3293,  2655,  2625,  2969,  2628,
    2249,  2565,  3171,  3098,  3138,  3477,  3138,  3307,  3353,   151,
    1142,   153,  3342,  3830,  3102,  2822,  3817,  3818,  3733,   414,
    3469,  3744,  3630,   165,  1869,  3684,  2322,  3561,  3845,  3846,
    2621,  3485,  2248,  3100,  1320,  1741,  3312,  2083,  1408,  3099,
    1664,    25,    26,   185,  1443,  2440,   943,  2097,   335,  2050,
     546,  3422,  1679,  2758,   341,    88,   451,  2417,  1899,   838,
    2149,  2837,  3443,  3292,  3846,  2643,  3764,   209,  1040,  3845,
    3109,  3888,  2001,  3988,   216,    59,  3286,  3703,  3266,  3896,
     475,  3779,  2102,   116,  1871,  1014,    70,  1201,  1229,  2046,
    2087,  3035,  2847,  2789,    78,  3793,   129,  3914,   493,  2788,
    4044,   496,  3802,   536,  3921,  1877,  1430,   615,  1731,  4040,
     526,  1623,  1234,   255,    98,  1247,  1268,  2771,   151,  3604,
     153,  3932,  3963,  1255,  3722,  4052,  3344,  1247,   112,  1685,
    2794,   115,   165,  2499,  3061,  2830,  3274,  1650,  1237,  3403,
     518,   821,  1541,  1542,  1543,  2427,   103,   104,   105,   106,
     107,  3409,   185,   440,   519,  1417,  3973,  1194,  1557,   143,
     825,  3978,  1977,  1098,  2396,   469,   469,    -1,    -1,   601,
     601,   458,   601,    -1,    -1,    -1,   209,    -1,    -1,    -1,
    1579,    -1,    -1,   216,    -1,    -1,  1585,    -1,    -1,  1588,
      -1,  1590,    -1,    -1,    -1,  4012,    -1,  1596,    -1,  1598,
    1599,    -1,    -1,    -1,  4021,    -1,    -1,   494,    -1,   496,
     497,    -1,    -1,    -1,  3912,    -1,    -1,    -1,   175,    -1,
      -1,    -1,   255,  4040,  3922,   209,    -1,  4044,    -1,  4046,
      -1,    -1,    -1,   217,    -1,  4052,   378,    -1,    -1,    -1,
      -1,   198,   199,   200,   201,    -1,   533,    -1,   232,    -1,
      -1,    -1,    -1,    -1,   541,   397,    -1,    -1,    -1,    -1,
    1659,   403,    -1,    -1,  3962,    -1,    -1,    -1,    -1,   411,
      -1,    -1,    -1,    -1,    -1,    -1,  3974,    -1,  3976,    -1,
      -1,    -1,    -1,    -1,    -1,  3983,    -1,    -1,    -1,    -1,
      -1,    -1,   434,    -1,  3992,    -1,    -1,    -1,    -1,    -1,
     284,    -1,    -1,    -1,    -1,   447,   448,    -1,    -1,    -1,
      -1,  1443,    -1,    -1,    -1,    -1,    -1,   301,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4023,  4024,    -1,     6,    -1,
    4028,    -1,    -1,    -1,    -1,    13,    14,    -1,    -1,   296,
      -1,   298,   299,   300,    -1,   378,   488,    25,    26,    -1,
     307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,
     403,   355,    -1,    -1,   516,    -1,    -1,    55,   411,   363,
      -1,    59,    60,    -1,    -1,    -1,    64,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    -1,    -1,   538,    -1,   540,    -1,
      78,   434,    -1,    -1,    -1,    -1,    -1,    85,    -1,  1541,
    1542,  1543,    -1,    -1,   447,   448,    -1,    -1,    -1,    -1,
      98,    -1,  1821,    -1,    -1,    -1,   383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   112,    -1,    -1,   115,    -1,    -1,
      -1,    -1,   426,    -1,   122,   123,    -1,  1579,    -1,    -1,
      -1,   129,    -1,    -1,    -1,   488,  1588,    -1,  1590,   137,
      -1,    -1,    -1,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   431,   432,    -1,    -1,    -1,    -1,
    1879,    -1,    -1,   516,  1883,    -1,    -1,    -1,    -1,  1888,
    1889,    -1,    -1,   171,    -1,   479,    -1,    -1,  1897,    -1,
      -1,  1900,    -1,    -1,    -1,   538,    -1,   540,    -1,    -1,
     494,  1910,    -1,  1912,  1913,    -1,  1915,  1916,  1917,  1918,
    1919,    -1,    -1,  1922,    -1,    -1,    -1,  1659,    -1,   207,
     514,   209,  1931,    -1,    -1,    -1,    -1,   521,    -1,   217,
    1939,    -1,  1941,    -1,  1943,  1944,  1945,  1946,   532,    -1,
      -1,  1950,  1951,  1952,   232,    -1,    -1,    -1,  1957,  1958,
    1959,    -1,  1961,    -1,  1963,    -1,  1965,    -1,  1967,    -1,
    1969,    -1,    -1,    -1,    -1,  1974,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1984,    -1,    -1,    -1,    -1,
      -1,    -1,  1991,    -1,    -1,  1994,    -1,    -1,    -1,    -1,
      -1,  2000,   559,    -1,  2003,    -1,   284,    -1,  2007,    -1,
      -1,    -1,    -1,   570,   571,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   301,    -1,    -1,    -1,   305,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    12,
      13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   343,    -1,    -1,    -1,    -1,
     348,    -1,    -1,    -1,    -1,    -1,    -1,   355,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,    -1,    -1,    -1,  1821,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    88,   404,   405,   406,   407,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1879,   426,    -1,
      -1,  1883,    -1,   116,    -1,    -1,  1888,  1889,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1897,   129,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1910,    -1,
    1912,    -1,    -1,  1915,  1916,  1917,  1918,  1919,   151,    -1,
     153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1931,
      -1,   479,   165,    -1,    -1,    -1,    -1,  1939,    -1,  1941,
      -1,  1943,  1944,  1945,    -1,    -1,   494,    -1,  1950,  1951,
    1952,    -1,   185,    -1,    -1,  1957,  1958,  1959,    -1,  1961,
      -1,  1963,    -1,  1965,    -1,  1967,   514,  1969,    -1,    -1,
      -1,    -1,  1974,   521,    -1,    -1,   209,    -1,    -1,    -1,
      -1,    -1,  1984,   216,   532,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2000,    13,
      14,  2003,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,    -1,
      -1,    55,   590,    -1,    -1,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      -1,    -1,    -1,  2332,    -1,    -1,    -1,  2336,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2358,
    2359,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,   117,   118,    -1,    -1,    -1,    -1,  2378,
      -1,    -1,    -1,    -1,   128,   129,    -1,    -1,  2387,    -1,
    2389,    -1,  2391,    23,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,    33,    34,    -1,    -1,  2406,    -1,   153,
      -1,    -1,  2411,    -1,    -1,   378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   170,    57,    58,    -1,
      -1,    -1,    -1,    -1,   397,  2434,    -1,    67,    -1,    69,
     403,   185,    -1,    -1,    -1,  2444,   190,    -1,   411,   193,
      -1,    -1,    -1,    -1,    84,    -1,    86,    -1,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
      -1,   434,   216,    -1,   218,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   447,   448,    -1,    -1,    -1,    -1,
     234,    -1,    -1,  2492,    -1,    -1,    -1,  2496,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,
      -1,   255,   142,   143,    -1,    -1,    -1,   147,    -1,    -1,
     150,    -1,    -1,    -1,    -1,   488,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2539,    -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,   516,   184,    -1,   186,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   538,    -1,   540,   208,   209,
      -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   343,
    2332,   231,    -1,    -1,  2336,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,    -1,
      -1,    -1,   252,    -1,    -1,    -1,  2358,  2359,   372,    -1,
      -1,    -1,    -1,    -1,  2633,  2634,    -1,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2378,    -1,    -1,   279,
      -1,    -1,    -1,    -1,    -1,  2387,    -1,  2389,   402,  2391,
      -1,   405,    -1,   407,    -1,    -1,   410,    -1,    -1,   413,
      -1,   415,    -1,    -1,    -1,    -1,   420,    -1,   422,    -1,
      -1,   311,    -1,    -1,    -1,   429,    -1,    -1,    -1,    -1,
     434,   321,    -1,    -1,  2693,    -1,    -1,    -1,   442,    -1,
      -1,    -1,  2434,   447,    -1,    -1,    -1,   451,    -1,    -1,
      -1,    -1,   342,    -1,    -1,    -1,  2715,  2716,    -1,  2718,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2727,    -1,
     474,    -1,    -1,  2732,   478,   365,  2735,    -1,  2737,  2738,
      -1,    -1,    -1,    -1,    -1,    -1,   376,   377,    -1,    -1,
     380,   381,    -1,    -1,    -1,    -1,    -1,  2756,    -1,    -1,
    2492,    -1,    -1,    -1,  2496,    -1,    -1,    -1,  2767,    -1,
      -1,    -1,    -1,    -1,    -1,   519,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,  2788,
      -1,   535,    -1,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2539,    -1,   439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2817,    -1,
      -1,   451,    -1,    -1,   568,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2831,    -1,    -1,    -1,    13,    14,   582,    -1,
      -1,    -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,   479,
    2849,    28,    -1,    -1,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    -1,    -1,    -1,  2863,    -1,   496,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    55,    -1,
      -1,    -1,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,
      -1,  2633,  2634,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   552,    -1,    -1,    -1,    -1,    -1,   558,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2693,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,
      -1,    -1,    -1,  2715,  2716,    -1,    -1,    -1,    -1,    -1,
      -1,    32,    33,   170,    -1,  2727,    -1,    38,    -1,    40,
    2732,    42,    43,  2735,    -1,  2737,  2738,    -1,   185,    -1,
      -1,    -1,    -1,   190,    -1,    -1,   193,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2767,    -1,  3036,    -1,   216,
      -1,   218,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2788,   234,    99,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   251,    -1,  3075,  3076,   255,    -1,
      25,    26,    -1,    -1,    -1,  3084,   127,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2831,
      -1,    -1,    -1,   144,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    57,    58,    59,    -1,    -1,  2849,    -1,    -1,
      -1,    66,    -1,    -1,    -1,    70,   167,    -1,   169,    -1,
      -1,  2863,    -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,
     181,   182,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   343,   112,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     221,    -1,    -1,    -1,    -1,   362,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   372,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,   382,    -1,    -1,   249,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,    -1,
     261,    -1,  3221,    -1,    -1,   402,    -1,    -1,   405,    -1,
     407,    -1,    -1,   410,    -1,    -1,   413,    -1,   415,    -1,
      -1,    -1,    -1,   420,    -1,   422,    -1,  3246,    -1,   290,
     291,   292,   429,    -1,    -1,    -1,    -1,   434,    -1,     6,
      -1,    -1,  3261,    -1,   209,   442,    13,   308,   309,   310,
     447,    -1,   217,   314,   451,  3274,   317,    -1,    25,    26,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,    -1,    -1,
      -1,    -1,   333,   334,    -1,    -1,    -1,   474,    -1,    -1,
      -1,   478,    -1,    -1,  3036,    -1,    -1,    -1,    55,    -1,
      -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    -1,   367,   368,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    85,   284,
      -1,    -1,   519,  3075,  3076,    -1,    -1,    -1,    -1,    -1,
     391,    98,  3084,    -1,   531,    -1,   301,    -1,   535,    -1,
      -1,   538,    -1,    -1,    -1,   112,   543,    -1,   115,    -1,
      -1,    -1,  3371,    -1,    -1,   122,    -1,    -1,    -1,    -1,
      -1,    -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     137,   568,    -1,    -1,    -1,    -1,   143,   438,    -1,    -1,
      -1,   442,    -1,    -1,    -1,   582,    -1,    -1,    -1,    -1,
     355,   452,    -1,    -1,    -1,  3414,    -1,    -1,   363,    -1,
      -1,    -1,    -1,    -1,   171,    -1,    -1,  3426,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3435,    -1,  3437,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     501,    -1,   209,   504,    -1,    -1,   507,   508,   509,   510,
     217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   426,    -1,    -1,    -1,   232,    -1,    -1,    -1,  3221,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   550,
     551,    -1,    -1,    -1,  3246,    -1,  3515,    -1,    -1,    -1,
      -1,    -1,  3521,  3522,    -1,    -1,    -1,    -1,    -1,  3261,
     571,    -1,    -1,    -1,   479,    -1,    -1,   284,    -1,    -1,
      -1,    -1,  3274,    -1,    -1,    -1,    -1,    -1,    -1,   494,
      -1,    -1,    -1,    -1,   301,    -1,    -1,    -1,   305,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3595,    -1,    -1,    -1,
      -1,   348,    -1,    -1,    -1,    -1,    -1,    -1,   355,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3649,    -1,  3651,    -1,    -1,    -1,    -1,    -1,   405,    -1,
      -1,    -1,  3661,    -1,  3663,  3664,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   426,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3426,    -1,    -1,    -1,  3697,    -1,
      -1,    -1,    -1,  3435,    -1,  3437,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   479,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3762,    -1,  3764,    -1,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,    -1,    -1,    -1,    -1,    -1,
    3779,  3780,    -1,  3515,    -1,   532,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3793,    -1,    -1,    -1,    -1,  3798,
      -1,    -1,    -1,    -1,  3803,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3812,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3859,  3860,    -1,  3595,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3872,  3873,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3891,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3912,    -1,    -1,    -1,  3649,    -1,  3651,
    3919,    -1,    -1,  3922,    -1,    -1,    -1,    -1,    -1,  3661,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3943,    -1,    -1,    -1,    -1,    -1,
      -1,  3950,    -1,  3952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3962,    -1,    -1,  3965,    -1,    -1,    -1,
      -1,    -1,    -1,  3972,    -1,  3974,    -1,  3976,    -1,    -1,
      -1,    -1,    -1,    -1,  3983,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3992,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4007,  4008,
      -1,    -1,    -1,    -1,  4013,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4023,  4024,    -1,    -1,    -1,  4028,
    3762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3780,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3803,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3859,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,  3919,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      44,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,  3943,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,  3965,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,  4013,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,   238,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,   512,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,   338,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
     434,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,   583,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,   176,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,   176,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,   326,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,   326,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    -1,
      -1,    90,    91,    92,    -1,    94,    95,    -1,    97,    98,
      99,   100,   101,   102,    -1,    -1,    -1,    -1,   107,   108,
     109,    -1,    -1,   112,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,   154,    -1,   156,   157,   158,
     159,   160,   161,   162,    -1,   164,   165,   166,   167,   168,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,   188,
      -1,   190,   191,    -1,   193,   194,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,   205,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,   241,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,   260,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,   316,   317,   318,
      -1,    -1,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,    -1,   331,   332,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,   476,   477,   478,
     479,    -1,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,    -1,    -1,   497,   498,
      -1,   500,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,   545,   546,   547,   548,
     549,    -1,    -1,   552,   553,    -1,   555,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,   575,   576,    -1,    -1,
      -1,    -1,   581,   582,    -1,    -1,   585,   586,    -1,   588,
     589,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    -1,    -1,    90,    91,    92,    -1,
      94,    95,    -1,    97,    98,    99,   100,   101,   102,    -1,
      -1,    -1,    -1,   107,   108,   109,    -1,    -1,   112,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
     154,    -1,   156,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,   188,    -1,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,   205,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,   241,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,   260,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,   316,   317,   318,    -1,    -1,   321,   322,   323,
     324,   325,    -1,   327,   328,   329,    -1,   331,   332,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,   421,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,   476,   477,   478,   479,    -1,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,   545,   546,   547,   548,   549,    -1,    -1,   552,   553,
      -1,   555,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,
      -1,   575,   576,    -1,    -1,    -1,    -1,   581,   582,    -1,
      -1,   585,   586,    -1,   588,   589,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    80,    81,    82,    -1,    84,    -1,    -1,    87,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,    -1,    -1,   156,   157,   158,
      -1,    -1,   161,   162,    -1,   164,   165,   166,   167,    -1,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,   178,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,    -1,    -1,   207,   208,
     209,    -1,   211,    -1,   213,    -1,    -1,    -1,   217,   218,
      -1,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,   233,    -1,   235,   236,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,   245,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,   282,   283,   284,   285,    -1,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,    -1,   303,    -1,   305,    -1,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,    -1,   317,   318,
      -1,    -1,   321,   322,   323,   324,    -1,    -1,    -1,   328,
     329,    -1,    -1,    -1,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
      -1,    -1,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,    -1,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,   434,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,   458,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,    -1,    -1,   478,
     479,    -1,   481,   482,   483,   484,   485,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,    -1,   497,   498,
      -1,    -1,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,    -1,    -1,
     519,   520,   521,   522,    -1,   524,   525,    -1,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,    -1,    -1,    -1,    -1,
     549,    -1,    -1,   552,    -1,    -1,    -1,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     589,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,
      61,    62,    63,    64,    65,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    80,
      81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,
     161,   162,    -1,   164,   165,   166,   167,    -1,    -1,   170,
      -1,    -1,    -1,   174,   175,    -1,   177,   178,   179,    -1,
     181,   182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,
     201,   202,   203,   204,    -1,    -1,   207,   208,   209,    -1,
     211,    -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,
      -1,   222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,
      -1,   232,   233,    -1,   235,   236,    -1,    -1,   239,    -1,
      -1,   242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,
      -1,   252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,   282,   283,   284,   285,    -1,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,   297,    -1,    -1,   300,
     301,    -1,   303,    -1,   305,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,
     321,   322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,
      -1,    -1,    -1,   334,   335,   336,   337,    -1,   339,   340,
     341,   342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,
      -1,   392,   393,   394,   395,   396,    -1,    -1,   399,   400,
     401,    -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,
     411,    -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,
      -1,   422,   423,   424,   425,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,    -1,    -1,   437,   438,   439,   440,
      -1,    -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,
     451,    -1,   453,   454,   455,   456,   457,   458,    -1,    -1,
      -1,    -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,
      -1,    -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,
     481,   482,   483,   484,   485,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,
     501,   502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,
      -1,    -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,
     521,   522,    -1,   524,   525,    -1,   527,   528,    -1,   530,
     531,    -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,
     541,   542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,
      -1,   552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,
      -1,    -1,    -1,   564,   565,    -1,   567,   568,    -1,    -1,
     571,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   589,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,    62,
      63,    64,    65,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    75,    76,    -1,    78,    79,    -1,    81,    82,
      -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,
     113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,   152,
     153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,
      -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,    -1,
      -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,   182,
     183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,   202,
     203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,    -1,
     213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,   222,
      -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,
      -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,
      -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,    -1,   279,   280,    -1,   282,
     283,   284,   285,    -1,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,   297,    -1,    -1,   300,   301,    -1,
     303,    -1,   305,    -1,   307,   308,   309,   310,   311,   312,
     313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,   322,
     323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,    -1,
      -1,   334,   335,   336,   337,    -1,   339,   340,   341,   342,
      -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   354,   355,   356,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,    -1,   372,
     373,   374,    -1,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,
     393,   394,   395,   396,    -1,    -1,   399,   400,   401,    -1,
     403,   404,    -1,   406,   407,   408,    -1,    -1,   411,    -1,
     413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,   422,
     423,   424,   425,   426,   427,   428,   429,   430,    -1,   432,
     433,   434,    -1,    -1,   437,   438,   439,   440,    -1,    -1,
      -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,
     453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,
      -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,
     473,   474,   475,    -1,    -1,   478,   479,    -1,   481,   482,
     483,   484,   485,    -1,    -1,   488,   489,   490,   491,    -1,
     493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,   502,
      -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,
     513,   514,   515,    -1,    -1,    -1,   519,   520,   521,   522,
      -1,   524,   525,    -1,   527,   528,    -1,   530,   531,    -1,
      -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,
      -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,   552,
      -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,    -1,
      -1,   564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     583,    -1,    17,    -1,    -1,    20,   589,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      -1,    56,    57,    -1,    59,    -1,    61,    62,    63,    64,
      65,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    -1,    81,    82,    -1,    84,
      -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,
     115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,   153,    -1,
      -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,   164,
     165,   166,   167,    -1,    -1,   170,    -1,    -1,    -1,   174,
     175,    -1,   177,    -1,   179,    -1,   181,   182,   183,   184,
      -1,   186,    -1,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,   204,
      -1,    -1,   207,   208,    -1,    -1,   211,    -1,   213,    -1,
      -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,   224,
     225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,    -1,
     235,   236,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,   254,
      -1,   256,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,   282,   283,   284,
     285,    -1,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,   297,    -1,    -1,   300,   301,    -1,   303,    -1,
     305,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
      -1,    -1,   317,   318,    -1,    -1,   321,   322,   323,   324,
      -1,    -1,    -1,   328,   329,    -1,    -1,    -1,    -1,   334,
     335,   336,   337,    -1,   339,   340,   341,   342,    -1,   344,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,   394,
     395,   396,    -1,    -1,   399,   400,   401,    -1,   403,   404,
      -1,   406,   407,   408,    -1,    -1,   411,    -1,   413,   414,
     415,    -1,   417,   418,    -1,    -1,    -1,   422,   423,   424,
     425,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
      -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,   444,
      -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,   454,
     455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,   464,
     465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,   484,
     485,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,    -1,   497,   498,    -1,    -1,   501,   502,    -1,   504,
     505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,   514,
     515,    -1,    -1,    -1,   519,   520,   521,   522,    -1,   524,
     525,    -1,   527,   528,    -1,   530,   531,    -1,    -1,   534,
      -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,    -1,
      -1,    -1,    -1,    -1,   549,    -1,    -1,   552,    -1,    -1,
      -1,   556,   557,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,    -1,   567,   568,    -1,    -1,   571,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,   583,    -1,
      -1,    -1,    17,   588,   589,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      -1,    56,    57,    -1,    59,    -1,    61,    62,    63,    64,
      65,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      75,    76,    -1,    78,    79,    -1,    81,    82,    -1,    84,
      -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,
      -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,
     115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,   152,   153,    -1,
      -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,   164,
     165,   166,   167,    -1,    -1,   170,    -1,    -1,    -1,   174,
     175,    -1,   177,    -1,   179,    -1,   181,   182,   183,   184,
      -1,   186,    -1,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,   204,
      -1,    -1,   207,   208,    -1,    -1,   211,    -1,   213,    -1,
      -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,   224,
     225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,    -1,
     235,   236,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,   254,
      -1,   256,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,    -1,   279,   280,    -1,   282,   283,   284,
     285,    -1,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,   297,    -1,    -1,   300,   301,    -1,   303,    -1,
     305,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
      -1,    -1,   317,   318,    -1,    -1,   321,   322,   323,   324,
      -1,    -1,    -1,   328,   329,    -1,    -1,    -1,    -1,   334,
     335,   336,   337,    -1,   339,   340,   341,   342,    -1,   344,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,
     355,   356,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,    -1,   372,   373,   374,
      -1,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
     385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,   394,
     395,   396,    -1,    -1,   399,   400,   401,    -1,   403,   404,
      -1,   406,   407,   408,    -1,    -1,   411,    -1,   413,   414,
     415,    -1,   417,   418,    -1,    -1,    -1,   422,   423,   424,
     425,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
      -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,   444,
      -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,   454,
     455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,   464,
     465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,   474,
     475,    -1,    -1,   478,   479,    -1,   481,   482,   483,   484,
     485,    -1,    -1,   488,   489,   490,   491,    -1,   493,   494,
      -1,    -1,   497,   498,    -1,    -1,   501,   502,    -1,   504,
     505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,   514,
     515,    -1,    -1,    -1,   519,   520,   521,   522,    -1,   524,
     525,    -1,   527,   528,    -1,   530,   531,    -1,    -1,   534,
      -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,    -1,
      -1,    -1,    -1,    -1,   549,    -1,    -1,   552,    -1,    -1,
      -1,   556,   557,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,    -1,   567,   568,    -1,    -1,   571,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,   582,    -1,    -1,
      17,    -1,    -1,    20,   589,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,   220,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,    -1,   571,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,   589,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,
      59,    -1,    61,    62,    63,    64,    65,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    75,    76,    -1,    78,
      79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,
      99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,
     119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
     139,   140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,   152,   153,    -1,    -1,   156,   157,   158,
      -1,    -1,   161,   162,    -1,   164,   165,   166,   167,    -1,
      -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,
     179,    -1,   181,   182,   183,   184,    -1,   186,    -1,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,   196,   197,    -1,
      -1,    -1,   201,   202,   203,   204,    -1,    -1,   207,   208,
      -1,    -1,   211,    -1,   213,    -1,    -1,    -1,   217,   218,
      -1,    -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,    -1,    -1,    -1,
     249,   250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,    -1,
     279,   280,    -1,   282,   283,   284,   285,    -1,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,
      -1,   300,   301,    -1,   303,    -1,   305,    -1,   307,   308,
     309,   310,   311,   312,   313,   314,    -1,    -1,   317,   318,
      -1,    -1,   321,   322,   323,   324,    -1,    -1,    -1,   328,
     329,    -1,    -1,    -1,    -1,   334,   335,   336,   337,    -1,
     339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,   355,   356,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,    -1,   372,   373,   374,    -1,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,   385,    -1,    -1,   388,
      -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,   406,   407,   408,
      -1,    -1,   411,    -1,   413,   414,   415,    -1,   417,   418,
      -1,    -1,    -1,   422,   423,   424,   425,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,
     439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,
     449,   450,   451,    -1,   453,   454,   455,   456,   457,    -1,
      -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,
      -1,   470,    -1,    -1,   473,   474,   475,    -1,    -1,   478,
     479,    -1,   481,   482,   483,   484,   485,    -1,    -1,   488,
     489,   490,   491,    -1,   493,   494,    -1,    -1,   497,   498,
      -1,    -1,   501,   502,    -1,   504,   505,   506,   507,    -1,
      -1,    -1,    -1,    -1,   513,   514,   515,    -1,    -1,    -1,
     519,   520,   521,   522,    -1,   524,   525,    -1,   527,   528,
      -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,
     539,    -1,   541,   542,    -1,    -1,    -1,    -1,    -1,    -1,
     549,    -1,    -1,   552,    -1,    -1,    -1,   556,   557,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,
      -1,    -1,   571,    -1,    -1,    -1,    -1,     5,   577,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
     589,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,   167,
      -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,
      -1,   179,    -1,   181,   182,   183,   184,    -1,   186,    -1,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,   197,
      -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,   207,
     208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,   217,
     218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,   227,
     228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,    -1,
      -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,   282,   283,   284,   285,    -1,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
      -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,    -1,    -1,   317,
     318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,    -1,
     328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,   337,
      -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,    -1,    -1,
     388,    -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,
      -1,   399,   400,   401,    -1,   403,   404,    -1,   406,   407,
     408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,   417,
     418,    -1,    -1,    -1,   422,   423,   424,   425,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,
     438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,
     448,   449,   450,   451,    -1,   453,   454,   455,   456,   457,
      -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,
      -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,    -1,
     478,   479,    -1,   481,   482,   483,   484,   485,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,    -1,   497,
     498,    -1,    -1,   501,   502,    -1,   504,   505,   506,   507,
      -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,    -1,
      -1,   519,   520,   521,   522,    -1,   524,   525,    -1,   527,
     528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,
      -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,    -1,
      -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,   557,
     558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,
     568,    -1,    -1,   571,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,   582,    -1,    -1,    17,    -1,    -1,
      20,   589,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,   167,    -1,    -1,
     170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,   179,
      -1,   181,   182,   183,   184,    -1,   186,    -1,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,   196,   197,    -1,    -1,
      -1,   201,   202,   203,   204,    -1,    -1,   207,   208,    -1,
      -1,   211,    -1,   213,    -1,    -1,    -1,   217,   218,    -1,
      -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,    -1,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,    -1,    -1,    -1,   249,
     250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,   282,   283,   284,   285,    -1,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,   303,    -1,   305,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,    -1,    -1,   317,   318,    -1,
      -1,   321,   322,   323,   324,    -1,    -1,    -1,   328,   329,
      -1,    -1,    -1,    -1,   334,   335,   336,   337,    -1,   339,
     340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,    -1,    -1,   388,    -1,
      -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,   399,
     400,   401,    -1,   403,   404,    -1,   406,   407,   408,    -1,
      -1,   411,    -1,   413,   414,   415,    -1,   417,   418,    -1,
      -1,    -1,   422,   423,   424,   425,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,   439,
     440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,   449,
     450,   451,    -1,   453,   454,   455,   456,   457,    -1,    -1,
      -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,    -1,
     470,    -1,    -1,   473,   474,   475,    -1,    -1,   478,   479,
      -1,   481,   482,   483,   484,   485,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,    -1,   497,   498,    -1,
      -1,   501,   502,    -1,   504,   505,   506,   507,    -1,    -1,
      -1,    -1,    -1,   513,   514,   515,    -1,    -1,    -1,   519,
     520,   521,   522,    -1,   524,   525,    -1,   527,   528,    -1,
     530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,   539,
      -1,   541,   542,    -1,    -1,    -1,    -1,    -1,    -1,   549,
      -1,    -1,   552,    -1,    -1,    -1,   556,   557,   558,   559,
      -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,    -1,
      -1,   571,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,   588,   589,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      -1,    61,    62,    63,    64,    65,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,
      -1,   121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,
     140,    -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,   158,    -1,
      -1,   161,   162,    -1,   164,   165,   166,   167,    -1,    -1,
     170,    -1,    -1,    -1,   174,   175,    -1,   177,    -1,   179,
      -1,   181,   182,   183,   184,    -1,   186,    -1,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,   196,   197,    -1,    -1,
      -1,   201,   202,   203,   204,    -1,    -1,   207,   208,    -1,
      -1,   211,    -1,   213,    -1,    -1,    -1,   217,   218,    -1,
      -1,    -1,   222,    -1,   224,   225,    -1,   227,   228,    -1,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,    -1,    -1,    -1,   249,
     250,    -1,   252,    -1,   254,    -1,   256,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,    -1,   279,
     280,    -1,   282,   283,   284,   285,    -1,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,   297,    -1,    -1,
     300,   301,    -1,   303,    -1,   305,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,    -1,    -1,   317,   318,    -1,
      -1,   321,   322,   323,   324,    -1,    -1,    -1,   328,   329,
      -1,    -1,    -1,    -1,   334,   335,   336,   337,    -1,   339,
     340,   341,   342,    -1,   344,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   354,   355,   356,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,    -1,   372,   373,   374,    -1,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,   385,    -1,    -1,   388,    -1,
      -1,    -1,   392,   393,   394,   395,   396,    -1,    -1,   399,
     400,   401,    -1,   403,   404,    -1,   406,   407,   408,    -1,
      -1,   411,    -1,   413,   414,   415,    -1,   417,   418,    -1,
      -1,    -1,   422,   423,   424,   425,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,    -1,    -1,   437,   438,   439,
     440,    -1,    -1,    -1,   444,    -1,    -1,    -1,   448,   449,
     450,   451,    -1,   453,   454,   455,   456,   457,    -1,    -1,
      -1,    -1,    -1,    -1,   464,   465,    -1,   467,    -1,    -1,
     470,    -1,    -1,   473,   474,   475,    -1,    -1,   478,   479,
      -1,   481,   482,   483,   484,   485,    -1,    -1,   488,   489,
     490,   491,    -1,   493,   494,    -1,    -1,   497,   498,    -1,
      -1,   501,   502,    -1,   504,   505,   506,   507,    -1,    -1,
      -1,    -1,    -1,   513,   514,   515,    -1,    -1,    -1,   519,
     520,   521,   522,    -1,   524,   525,    -1,   527,   528,    -1,
     530,   531,    -1,    -1,   534,    -1,    -1,   537,    -1,   539,
      -1,   541,   542,    -1,    -1,    -1,    -1,    -1,    -1,   549,
      -1,    -1,   552,    -1,    -1,    -1,   556,   557,   558,   559,
      -1,    -1,    -1,    -1,   564,   565,    -1,   567,   568,    -1,
      -1,   571,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   589,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,    -1,   571,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   589,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,   167,    -1,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,    -1,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,   282,   283,
     284,   285,    -1,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,    -1,   303,
      -1,   305,    -1,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,    -1,   317,   318,    -1,    -1,   321,   322,   323,
     324,    -1,    -1,    -1,   328,   329,    -1,    -1,    -1,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,    -1,    -1,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,    -1,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
     484,   485,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,    -1,   497,   498,    -1,    -1,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,    -1,    -1,   519,   520,   521,   522,    -1,
     524,   525,    -1,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,   552,    -1,
      -1,    -1,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   589,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,
      56,    57,    -1,    59,    -1,    61,    62,    63,    64,    65,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    75,
      76,    -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,
      -1,    87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,
      -1,    -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,   139,   140,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,   153,    -1,    -1,
     156,   157,   158,    -1,    -1,   161,   162,    -1,   164,   165,
     166,   167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,
      -1,   177,    -1,   179,    -1,   181,   182,   183,   184,    -1,
     186,    -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
     196,   197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,
      -1,   207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,
      -1,   217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,
      -1,   227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,
     236,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
      -1,    -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,
     256,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,    -1,   279,   280,    -1,   282,   283,   284,   285,
      -1,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,   297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,
      -1,   307,   308,   309,   310,   311,   312,   313,   314,    -1,
      -1,   317,   318,    -1,    -1,   321,   322,   323,   324,    -1,
      -1,    -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,
     336,   337,    -1,   339,   340,   341,   342,    -1,   344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,
     356,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,    -1,   372,   373,   374,    -1,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,   385,
      -1,    -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,
     396,    -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,
     406,   407,   408,    -1,    -1,   411,    -1,   413,   414,   415,
      -1,   417,   418,    -1,    -1,    -1,   422,   423,   424,   425,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,    -1,
      -1,   437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,
      -1,    -1,   448,   449,   450,   451,    -1,   453,   454,   455,
     456,   457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,
      -1,   467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,
      -1,    -1,   478,   479,    -1,   481,   482,   483,   484,   485,
      -1,    -1,   488,   489,   490,   491,    -1,   493,   494,    -1,
      -1,   497,   498,    -1,    -1,   501,   502,    -1,   504,   505,
     506,   507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,
      -1,    -1,    -1,   519,   520,   521,   522,    -1,   524,   525,
      -1,   527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,
      -1,   537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,
      -1,    -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,
     556,   557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,
      -1,   567,   568,    -1,    -1,   571,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   589,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,    57,
      -1,    59,    -1,    61,    62,    63,    64,    65,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,    87,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    97,
      98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,    -1,
      -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,   153,    -1,    -1,   156,   157,
     158,    -1,    -1,   161,   162,    -1,   164,   165,   166,   167,
      -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,   177,
      -1,   179,    -1,   181,   182,   183,   184,    -1,   186,    -1,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,   197,
      -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,   207,
     208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,   217,
     218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,   227,
     228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,    -1,
      -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,    -1,   282,   283,   284,   285,    -1,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,   297,
      -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,    -1,    -1,   317,
     318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,    -1,
     328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,   337,
      -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,    -1,   372,   373,   374,    -1,   376,    -1,
     378,   379,   380,   381,    -1,   383,   384,   385,    -1,    -1,
     388,    -1,    -1,    -1,   392,   393,   394,   395,   396,    -1,
      -1,   399,   400,   401,    -1,   403,   404,    -1,   406,   407,
     408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,   417,
     418,    -1,    -1,    -1,   422,   423,   424,   425,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,   437,
     438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,
     448,   449,   450,   451,    -1,   453,   454,   455,   456,   457,
      -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,   467,
      -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,    -1,
     478,   479,    -1,   481,   482,   483,   484,   485,    -1,    -1,
     488,   489,   490,   491,    -1,   493,   494,    -1,    -1,   497,
     498,    -1,   500,   501,   502,    -1,   504,   505,   506,   507,
      -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,    -1,
      -1,   519,   520,   521,   522,    -1,   524,   525,    -1,   527,
     528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,   537,
      -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,    -1,
      -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,   557,
     558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,   567,
     568,    -1,    -1,   571,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     588,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,
      61,    62,    63,    64,    65,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    75,    76,    -1,    78,    79,    -1,
      81,    82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,
      -1,    -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,
     121,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,   152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,
     161,   162,    -1,   164,   165,   166,   167,    -1,    -1,   170,
      -1,    -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,
     181,   182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,
     201,   202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,
     211,    -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,
      -1,   222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,
      -1,   232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,
      -1,   242,   243,   244,    -1,    -1,    -1,    -1,   249,   250,
      -1,   252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,    -1,   279,   280,
      -1,   282,   283,   284,   285,    -1,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,   297,    -1,    -1,   300,
     301,    -1,   303,    -1,   305,    -1,   307,   308,   309,   310,
     311,   312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,
     321,   322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,
      -1,    -1,    -1,   334,   335,   336,   337,    -1,   339,   340,
     341,   342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
      -1,   372,   373,   374,    -1,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,
      -1,   392,   393,   394,   395,   396,    -1,    -1,   399,   400,
     401,    -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,
     411,    -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,
      -1,   422,   423,   424,   425,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,    -1,    -1,   437,   438,   439,   440,
      -1,    -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,
     451,    -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,
      -1,    -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,
      -1,    -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,
     481,   482,   483,   484,   485,    -1,    -1,   488,   489,   490,
     491,    -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,
     501,   502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,
      -1,    -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,
     521,   522,    -1,   524,   525,    -1,   527,   528,    -1,   530,
     531,    -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,
     541,   542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,
      -1,   552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,
      -1,    -1,    -1,   564,   565,    -1,   567,   568,    -1,    -1,
     571,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   588,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    -1,    56,    57,    -1,    59,    -1,    61,    62,    63,
      64,    65,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    75,    76,    -1,    78,    79,    -1,    81,    82,    -1,
      84,    -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    98,    99,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,   113,
      -1,   115,    -1,    -1,    -1,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,   139,   140,    -1,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,   158,    -1,    -1,   161,   162,    -1,
     164,   165,   166,   167,    -1,    -1,   170,    -1,    -1,    -1,
     174,   175,    -1,   177,    -1,   179,    -1,   181,   182,   183,
     184,    -1,   186,    -1,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,   196,   197,    -1,    -1,    -1,   201,   202,   203,
     204,    -1,    -1,   207,   208,    -1,    -1,   211,    -1,   213,
      -1,    -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,
     224,   225,    -1,   227,   228,    -1,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,   239,    -1,    -1,   242,   243,
     244,    -1,    -1,    -1,    -1,   249,   250,    -1,   252,    -1,
     254,    -1,   256,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,    -1,   279,   280,    -1,   282,   283,
     284,   285,    -1,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,   297,    -1,    -1,   300,   301,    -1,   303,
      -1,   305,    -1,   307,   308,   309,   310,   311,   312,   313,
     314,    -1,    -1,   317,   318,    -1,    -1,   321,   322,   323,
     324,    -1,    -1,    -1,   328,   329,    -1,    -1,    -1,    -1,
     334,   335,   336,   337,    -1,   339,   340,   341,   342,    -1,
     344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     354,   355,   356,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,    -1,   372,   373,
     374,    -1,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,   385,    -1,    -1,   388,    -1,    -1,    -1,   392,   393,
     394,   395,   396,    -1,    -1,   399,   400,   401,    -1,   403,
     404,    -1,   406,   407,   408,    -1,    -1,   411,    -1,   413,
     414,   415,    -1,   417,   418,    -1,    -1,    -1,   422,   423,
     424,   425,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,    -1,    -1,   437,   438,   439,   440,    -1,    -1,    -1,
     444,    -1,    -1,    -1,   448,   449,   450,   451,    -1,   453,
     454,   455,   456,   457,    -1,    -1,    -1,    -1,    -1,    -1,
     464,   465,    -1,   467,    -1,    -1,   470,    -1,    -1,   473,
     474,   475,    -1,    -1,   478,   479,    -1,   481,   482,   483,
     484,   485,    -1,    -1,   488,   489,   490,   491,    -1,   493,
     494,    -1,    -1,   497,   498,    -1,   500,   501,   502,    -1,
     504,   505,   506,   507,    -1,    -1,    -1,    -1,    -1,   513,
     514,   515,    -1,    -1,    -1,   519,   520,   521,   522,    -1,
     524,   525,    -1,   527,   528,    -1,   530,   531,    -1,    -1,
     534,    -1,    -1,   537,    -1,   539,    -1,   541,   542,    -1,
      -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,   552,    -1,
      -1,    -1,   556,   557,   558,   559,    -1,    -1,    -1,    -1,
     564,   565,    -1,   567,   568,    -1,    -1,   571,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,   588,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,   584,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,   577,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
     577,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,   577,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
     577,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,   168,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,   260,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,   325,   326,    -1,   328,   329,    -1,    -1,
     332,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,   460,   461,
     462,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,   523,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,   145,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,   443,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,   500,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,   244,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,   500,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      92,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,   244,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,   500,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,   500,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,   244,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,   244,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,   500,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    83,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,   155,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,   176,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,   112,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,   500,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
     112,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,   108,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,   153,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,   170,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,   196,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,   218,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,   328,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,   355,   356,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,    -1,   372,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,   388,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,   406,
     407,   408,    -1,    -1,   411,    -1,   413,   414,   415,    -1,
     417,   418,    -1,    -1,    -1,   422,   423,   424,   425,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,    -1,    -1,
     437,   438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,   449,   450,   451,    -1,   453,   454,   455,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,   474,   475,    -1,
      -1,   478,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,   519,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,   530,   531,    -1,    -1,   534,    -1,    -1,
     537,    -1,   539,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
     567,   568,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    -1,    56,    57,    -1,    59,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,    -1,   164,   165,   166,   167,    -1,    -1,   170,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,   196,   197,    -1,    -1,    -1,   201,
     202,   203,   204,    -1,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,   328,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   355,   356,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,    -1,
     372,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,   388,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,   404,    -1,   406,   407,   408,    -1,    -1,   411,
      -1,   413,   414,   415,    -1,   417,   418,    -1,    -1,    -1,
     422,   423,   424,   425,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,    -1,    -1,   437,   438,   439,   440,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,   449,   450,   451,
      -1,   453,   454,   455,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,   474,   475,    -1,    -1,   478,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,   519,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,   530,   531,
      -1,    -1,   534,    -1,    -1,   537,    -1,   539,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
      -1,    -1,   564,   565,    -1,   567,   568,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,   136,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,   135,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,   201,
     202,   203,   204,   205,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,    -1,   236,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,   367,   368,    -1,    -1,    -1,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,   406,    -1,   408,   409,    -1,   411,
      -1,    -1,   414,    -1,    -1,   417,   418,   419,    -1,    -1,
      -1,   423,   424,   425,   426,   427,   428,    -1,   430,    -1,
     432,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,    -1,   450,    -1,
      -1,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,    -1,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,   560,    -1,
     562,    -1,   564,    -1,    -1,   567,    -1,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,   560,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,   201,
     202,   203,   204,   205,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,    -1,   236,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,   367,   368,    -1,    -1,    -1,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,   406,    -1,   408,   409,    -1,   411,
      -1,    -1,   414,    -1,    -1,   417,   418,   419,    -1,    -1,
      -1,   423,   424,   425,   426,   427,   428,    -1,   430,    -1,
     432,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,    -1,   450,    -1,
      -1,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,    -1,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
     562,    -1,   564,    -1,    -1,   567,    -1,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,   201,
     202,   203,   204,   205,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,    -1,   236,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,   367,   368,    -1,    -1,    -1,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,   406,    -1,   408,   409,    -1,   411,
      -1,    -1,   414,    -1,    -1,   417,   418,   419,    -1,    -1,
      -1,   423,   424,   425,   426,   427,   428,    -1,   430,    -1,
     432,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,    -1,   450,    -1,
      -1,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,    -1,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
     562,    -1,   564,    -1,    -1,   567,    -1,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,   139,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,   139,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,   201,
     202,   203,   204,   205,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,    -1,   236,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,   367,   368,    -1,    -1,    -1,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,   406,    -1,   408,   409,    -1,   411,
      -1,    -1,   414,    -1,    -1,   417,   418,   419,    -1,    -1,
      -1,   423,   424,   425,   426,   427,   428,    -1,   430,    -1,
     432,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,    -1,   450,    -1,
      -1,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,    -1,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
     562,    -1,   564,    -1,    -1,   567,    -1,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    63,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,   163,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,   205,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,   229,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,   240,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,   342,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,   409,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,   419,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,   562,    -1,   564,    -1,    -1,
     567,    -1,    -1,     5,   571,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    -1,    56,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    65,    -1,    67,    68,    -1,    -1,    71,
      -1,    73,    74,    75,    76,    -1,    78,    79,    -1,    -1,
      82,    -1,    84,    -1,    -1,    87,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    98,    99,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
      -1,   113,    -1,   115,    -1,    -1,    -1,   119,    -1,   121,
     122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,   140,    -1,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,   161,
     162,   163,   164,   165,   166,   167,    -1,    -1,    -1,    -1,
      -1,    -1,   174,   175,    -1,   177,    -1,   179,    -1,   181,
     182,   183,   184,    -1,   186,    -1,    -1,    -1,    -1,   191,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,   201,
     202,   203,   204,   205,    -1,   207,   208,    -1,    -1,   211,
      -1,   213,    -1,    -1,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,    -1,   227,   228,   229,    -1,    -1,
     232,    -1,    -1,    -1,   236,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,    -1,    -1,    -1,   249,   250,    -1,
     252,    -1,   254,    -1,   256,   257,    -1,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,    -1,   279,   280,    -1,
     282,   283,   284,   285,    -1,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,   297,    -1,    -1,   300,   301,
      -1,   303,    -1,   305,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,    -1,    -1,   317,   318,    -1,    -1,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,    -1,    -1,
      -1,    -1,   334,   335,   336,   337,    -1,   339,   340,   341,
     342,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
      -1,   363,   364,   365,   366,   367,   368,    -1,    -1,    -1,
      -1,   373,   374,    -1,   376,    -1,   378,   379,   380,   381,
      -1,   383,   384,   385,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,   395,   396,    -1,    -1,   399,   400,   401,
      -1,   403,    -1,    -1,   406,    -1,   408,   409,    -1,   411,
      -1,    -1,   414,    -1,    -1,   417,   418,   419,    -1,    -1,
      -1,   423,   424,   425,   426,   427,   428,    -1,   430,    -1,
     432,    -1,    -1,    -1,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,   444,    -1,    -1,    -1,   448,    -1,   450,    -1,
      -1,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,    -1,
      -1,    -1,   464,   465,    -1,   467,    -1,    -1,   470,    -1,
      -1,   473,    -1,   475,    -1,    -1,    -1,   479,    -1,   481,
     482,   483,   484,   485,    -1,    -1,   488,   489,   490,   491,
      -1,   493,   494,    -1,    -1,   497,   498,    -1,    -1,   501,
     502,    -1,   504,   505,   506,   507,    -1,    -1,    -1,    -1,
      -1,   513,   514,   515,    -1,    -1,    -1,    -1,   520,   521,
     522,    -1,   524,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,   534,    -1,    -1,   537,    -1,    -1,    -1,   541,
     542,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
     552,    -1,    -1,    -1,   556,   557,   558,   559,    -1,    -1,
     562,    -1,   564,    -1,    -1,   567,    -1,    -1,     5,   571,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    -1,    -1,    54,    -1,    56,
      -1,    -1,    -1,    -1,    61,    62,    -1,    64,    65,    -1,
      67,    68,    -1,    -1,    71,    -1,    73,    74,    75,    76,
      -1,    78,    79,    -1,    -1,    82,    -1,    84,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    98,    99,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,    -1,   113,    -1,   115,    -1,
      -1,    -1,   119,    -1,   121,   122,   123,   124,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,   140,    -1,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,   152,    -1,    -1,    -1,   156,
     157,   158,    -1,    -1,   161,   162,    -1,   164,   165,   166,
     167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,    -1,
     177,    -1,   179,    -1,   181,   182,   183,   184,    -1,   186,
      -1,    -1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,   201,   202,   203,   204,    -1,    -1,
     207,   208,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,    -1,   236,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,    -1,
      -1,    -1,   249,   250,    -1,   252,    -1,   254,    -1,   256,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,    -1,   279,   280,    -1,   282,   283,   284,   285,    -1,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
     297,    -1,    -1,   300,   301,    -1,   303,    -1,   305,    -1,
     307,   308,   309,   310,   311,   312,   313,   314,    -1,    -1,
     317,   318,    -1,    -1,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,    -1,    -1,    -1,    -1,   334,   335,   336,
     337,    -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   355,   356,
      -1,    -1,   359,   360,   361,    -1,   363,   364,   365,   366,
     367,   368,    -1,    -1,    -1,    -1,   373,   374,    -1,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,   385,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,   395,   396,
      -1,    -1,   399,   400,   401,    -1,   403,    -1,    -1,   406,
      -1,   408,    -1,    -1,   411,    -1,    -1,   414,    -1,    -1,
     417,   418,    -1,    -1,    -1,    -1,   423,   424,   425,   426,
     427,   428,    -1,   430,    -1,   432,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,   444,    -1,    -1,
      -1,   448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,
     457,    -1,    -1,    -1,    -1,    -1,    -1,   464,   465,    -1,
     467,    -1,    -1,   470,    -1,    -1,   473,    -1,   475,    -1,
      -1,    -1,   479,    -1,   481,   482,   483,   484,   485,    -1,
      -1,   488,   489,   490,   491,    -1,   493,   494,    -1,    -1,
     497,   498,    -1,    -1,   501,   502,    -1,   504,   505,   506,
     507,    -1,    -1,    -1,    -1,    -1,   513,   514,   515,    -1,
      -1,    -1,    -1,   520,   521,   522,    -1,   524,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,
     537,    -1,    -1,    -1,   541,   542,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,    -1,   552,    -1,    -1,    -1,   556,
     557,   558,   559,    -1,    -1,    -1,    -1,   564,    -1,    -1,
     567,    -1,    -1,    -1,   571
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,    13,    14,    28,    30,    34,    48,    49,    55,    59,
      60,    72,    88,   108,   116,   117,   118,   128,   129,   141,
     153,   170,   185,   190,   193,   216,   218,   234,   251,   255,
     343,   362,   372,   382,   402,   405,   407,   410,   413,   415,
     420,   422,   429,   434,   442,   447,   451,   474,   478,   519,
     531,   535,   538,   543,   568,   582,   593,   594,   595,   596,
     597,   598,   600,   605,   607,   612,   640,   772,   908,   947,
     950,   958,   960,   962,   965,   970,   972,   973,   978,   981,
     986,   990,   998,   999,  1146,  1148,  1156,  1159,  1184,  1192,
    1203,  1209,  1222,  1225,  1228,  1234,  1238,  1242,  1244,  1245,
    1291,  1308,  1314,  1316,  1323,  1325,  1350,  1356,  1357,  1358,
    1359,  1407,  1415,  1416,    11,    95,   113,   179,   256,   335,
     341,   377,   440,   494,   924,  1375,  1376,  1377,  1380,   252,
     330,   980,   493,   496,  1310,  1351,   500,  1282,   209,     5,
       7,     8,     9,    10,    11,    17,    20,    22,    23,    24,
      25,    26,    27,    28,    30,    34,    38,    41,    42,    43,
      45,    47,    48,    51,    54,    56,    57,    59,    61,    62,
      63,    64,    65,    67,    68,    70,    71,    72,    73,    74,
      75,    76,    78,    79,    81,    82,    84,    87,    90,    97,
      98,    99,   102,   107,   108,   113,   115,   119,   121,   122,
     123,   124,   128,   131,   132,   133,   137,   139,   140,   142,
     143,   144,   147,   149,   150,   151,   152,   153,   156,   157,
     158,   161,   162,   164,   165,   166,   167,   170,   174,   175,
     177,   179,   181,   182,   183,   184,   186,   190,   191,   193,
     196,   197,   201,   202,   203,   204,   207,   208,   211,   213,
     217,   218,   222,   224,   225,   227,   228,   232,   235,   236,
     239,   242,   243,   249,   250,   252,   254,   256,   257,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   279,   280,   282,   283,   284,   285,   287,   288,
     289,   293,   294,   295,   296,   297,   300,   301,   303,   305,
     307,   308,   309,   310,   311,   312,   313,   314,   317,   318,
     321,   322,   323,   324,   328,   329,   334,   335,   336,   337,
     339,   340,   341,   342,   344,   354,   355,   356,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     372,   373,   374,   376,   378,   379,   380,   381,   383,   384,
     385,   388,   392,   393,   394,   395,   396,   399,   400,   401,
     403,   404,   406,   407,   408,   411,   413,   414,   415,   417,
     418,   422,   423,   424,   425,   426,   427,   428,   429,   430,
     432,   433,   437,   438,   439,   440,   444,   448,   449,   450,
     451,   453,   454,   455,   456,   457,   464,   465,   467,   470,
     473,   474,   475,   478,   479,   481,   482,   483,   484,   485,
     488,   489,   490,   491,   493,   494,   497,   498,   501,   502,
     504,   505,   506,   507,   513,   514,   515,   519,   520,   521,
     522,   524,   525,   527,   528,   530,   531,   534,   537,   539,
     541,   542,   549,   552,   556,   557,   558,   559,   564,   565,
     567,   568,   571,   634,  1281,  1285,  1289,  1290,   279,  1310,
    1310,   564,  1352,    95,   256,   440,   494,   497,   541,   616,
     617,   820,   821,   822,   924,  1193,  1147,    95,   151,   179,
     256,   377,   440,   494,   497,   516,   541,   556,   924,  1155,
    1285,   980,   633,   589,  1279,  1280,  1285,   606,  1157,   366,
      78,   384,  1243,    98,   209,   496,  1310,   980,   773,  1285,
    1239,   429,   541,  1310,   980,  1160,  1235,  1310,   633,  1352,
    1285,  1001,  1003,  1004,   345,  1293,  1210,   474,   478,   451,
     513,   451,   496,  1204,   366,  1315,  1185,  1285,    30,    72,
     139,   372,   393,   422,   474,  1409,   434,   582,  1000,     0,
     141,   372,   157,   361,  1226,  1279,  1285,   145,   919,  1285,
     145,   634,   187,   634,   244,  1282,  1285,  1287,   721,   722,
     725,   748,  1285,   206,   943,   151,   914,  1375,  1310,   961,
    1352,   987,   988,  1279,   641,   589,   511,   963,   974,    16,
    1353,   205,   823,   187,  1287,   723,   748,   633,   350,  1372,
    1376,  1377,  1378,  1379,  1380,   496,   821,   178,   458,   533,
     895,   206,   263,   385,  1201,  1202,     7,    20,    27,    33,
      35,    36,    37,    39,    52,    53,    57,    58,    64,    67,
      81,    85,    86,    91,    92,    94,    95,   100,   101,   102,
     107,   109,   112,   154,   159,   160,   168,   181,   183,   188,
     194,   201,   205,   216,   219,   241,   249,   260,   281,   286,
     296,   300,   302,   306,   307,   308,   309,   310,   316,   325,
     326,   327,   331,   332,   337,   357,   363,   367,   368,   370,
     383,   409,   410,   421,   427,   432,   476,   477,   482,   486,
     487,   492,   500,   504,   505,   506,   507,   517,   518,   519,
     523,   526,   541,   545,   546,   547,   548,   553,   555,   559,
     571,   575,   576,   581,   582,   585,   586,   588,   589,  1019,
    1020,  1021,  1022,  1026,  1029,  1030,  1031,  1032,  1033,  1034,
    1042,  1046,  1056,  1266,  1268,  1270,  1271,  1275,  1277,  1281,
    1285,   205,  1154,  1154,  1154,   187,  1154,  1154,   748,  1154,
     633,  1154,   209,  1310,   601,  1229,    12,    13,    88,   116,
     129,   151,   153,   165,   185,   209,   216,   255,   378,   397,
     403,   411,   434,   447,   448,   488,   516,   538,   540,  1326,
    1328,  1330,  1331,  1285,   342,    63,   389,   589,  1287,   114,
     195,   263,  1162,  1285,  1019,  1246,   220,  1279,  1309,  1310,
      46,   774,   176,    33,   279,  1214,  1240,  1285,   633,   982,
    1310,   114,   263,  1163,  1191,   279,   384,   451,  1236,  1237,
     959,    12,  1324,  1328,   511,  1353,  1002,    12,   125,   195,
     463,   464,   465,   466,   467,   468,   480,  1008,  1009,  1010,
    1292,    23,    34,    57,    58,    67,    69,    84,    86,    88,
      96,   143,   147,   150,   177,   179,   184,   186,   208,   209,
     213,   231,   252,   279,   311,   321,   342,   365,   376,   377,
     380,   381,   439,   451,   479,   496,   558,   868,   894,  1211,
    1214,  1215,  1217,  1299,   952,   953,   952,   952,   563,   951,
     952,  1151,  1279,  1285,  1310,  1191,    35,   194,   500,  1267,
    1283,  1408,  1408,  1408,  1408,  1408,  1003,  1000,   583,  1285,
    1224,  1223,   295,   498,   525,   910,   539,    92,  1287,  1288,
     912,   727,   749,  1285,   911,   344,     6,    55,   129,   326,
     388,   390,   750,   496,   634,   469,  1381,  1382,   913,   971,
    1150,  1151,   223,   584,   994,   995,   582,   642,  1285,   608,
    1150,  1150,    54,   328,   328,   402,  1354,   325,   326,  1025,
    1285,   726,   749,   172,     6,  1288,  1341,  1342,   410,    10,
     151,   377,   516,   620,  1014,  1374,  1382,  1391,  1395,  1396,
    1402,   620,  1014,  1373,  1382,  1391,  1396,  1402,  1375,  1380,
     823,   209,   176,  1194,  1198,  1199,  1285,  1201,   582,   582,
     582,  1029,   582,   582,   582,  1019,  1059,   582,   582,   582,
     582,   582,   582,   582,   582,   582,  1018,  1018,   582,  1018,
     582,   582,   582,   526,   582,  1266,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,  1019,   582,   582,
     582,  1057,  1058,  1275,  1285,   582,   582,   582,   582,   582,
     582,   582,   582,   582,  1019,   582,  1018,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   582,   582,
     582,   582,   582,   582,  1018,   582,  1266,   582,   582,   582,
    1266,   582,   582,    35,   194,   500,   582,  1018,  1018,  1018,
     582,   582,   582,   582,   582,  1029,  1029,  1029,   434,   582,
    1019,  1369,  1285,  1047,  1285,    15,    16,   347,   350,   569,
    1023,  1024,   145,   146,   180,   189,   226,   237,   264,   319,
    1027,    31,   126,   223,   245,   306,   398,   445,   446,   456,
     573,   574,   575,   576,   577,   578,   579,   580,  1025,  1029,
      66,   349,   584,  1283,   582,   589,   154,  1285,   634,  1285,
     749,   634,  1287,   759,  1215,   634,  1288,  1340,  1150,  1285,
    1154,   544,   602,   119,   197,   257,   279,   376,   384,   414,
     451,   475,   493,  1230,  1231,  1310,   376,  1329,   424,   424,
     497,   541,   556,   345,  1333,   493,  1335,    62,   451,  1332,
      96,   556,  1334,   338,   584,    18,   145,  1102,  1103,  1317,
    1285,   943,   455,    76,   176,   263,  1247,  1253,    48,   176,
    1279,  1311,  1312,   979,   247,   250,   386,   775,   779,   588,
     599,  1282,   257,   983,  1288,   984,   985,  1279,   966,   220,
    1151,  1164,  1165,    48,   584,  1150,  1329,   338,   429,  1355,
    1354,   532,  1360,  1361,   577,  1012,  1013,  1014,  1010,  1294,
    1295,  1296,   150,   442,   245,   561,  1221,   520,   582,    95,
     151,   179,   377,   496,   516,   556,  1221,    12,   831,  1287,
     246,  1121,  1123,   176,   223,  1216,  1218,    65,   475,   173,
     475,   475,   475,   279,   493,    65,   475,    12,    41,    82,
      87,   225,   294,   356,   457,   490,  1205,  1206,  1207,   197,
     475,   475,   520,  1121,  1221,  1218,   257,   142,    68,   366,
     379,   493,   515,   475,   552,   949,   401,   470,   954,   955,
     948,    79,   943,   584,   340,  1411,   489,  1412,   230,   417,
    1410,   583,  1361,  1363,  1364,  1365,   998,  1227,  1267,  1285,
     112,   818,   819,   828,   829,   877,    98,  1018,   588,   635,
       6,   728,   635,   582,    97,   745,   745,   745,     4,  1279,
     915,   433,   556,  1382,  1150,   511,   584,   112,   989,  1285,
     988,   209,   233,   892,   996,   643,   644,  1019,   265,   266,
     267,   268,   269,   270,   272,   273,   274,   275,   276,   277,
     278,   280,   399,   400,   609,   610,   611,   157,   385,   964,
      56,   157,   161,   173,   293,   385,   975,   976,   977,    54,
     402,   154,   615,   728,    98,   745,   203,   584,  1014,   823,
    1014,  1014,   179,   179,  1382,  1279,  1285,  1152,  1153,  1279,
     584,  1196,   589,  1200,  1019,  1019,    12,   125,  1052,  1104,
    1052,  1052,  1052,   560,  1061,  1019,  1019,  1056,  1056,  1019,
    1019,  1019,   125,  1052,  1104,   583,  1019,   583,  1019,  1019,
    1019,  1019,  1275,   582,  1369,   103,   104,   105,   106,   107,
     175,   198,   199,   200,   201,   296,   298,   299,   300,   307,
     383,   431,   432,   559,   570,   571,  1099,  1100,  1056,    99,
     102,   504,   507,  1101,   125,  1049,  1019,  1019,  1019,  1019,
    1099,  1019,  1056,  1058,     9,   584,   589,   125,  1052,  1019,
    1019,   125,  1052,  1019,  1019,  1056,  1056,  1056,  1019,  1019,
    1019,  1019,  1056,  1022,  1019,  1019,  1019,  1019,  1019,  1019,
    1052,  1052,  1019,  1019,   125,  1052,  1019,  1019,  1100,  1100,
    1019,    44,   238,   512,  1019,  1019,   583,  1276,  1277,  1285,
    1052,  1052,  1019,  1019,  1370,  1370,   583,   584,   583,  1019,
     588,  1048,  1287,   589,  1019,  1019,  1019,  1021,   160,   331,
     518,   534,  1025,    12,    17,  1021,  1028,  1022,  1022,   582,
    1029,  1022,  1022,  1022,  1022,   245,  1022,  1022,   219,  1022,
     219,  1022,  1022,  1022,  1022,  1022,    31,   223,   245,   398,
    1287,  1029,  1019,  1035,  1285,   589,   759,   329,   557,   760,
     761,   143,   584,    50,   416,   944,   338,  1150,   588,   603,
     604,    48,   563,   584,  1232,   493,   582,  1343,  1343,  1343,
    1343,   179,   377,   496,  1327,  1331,  1285,   166,   322,  1285,
    1318,  1319,  1164,  1282,   279,   252,  1252,   991,   279,  1103,
     584,  1150,   778,   777,   361,   785,   191,   233,  1287,    29,
     511,  1241,   584,   511,   584,   511,  1150,  1165,  1161,  1237,
     176,   584,   179,   377,  1327,  1285,    12,   125,  1367,   584,
    1005,  1016,  1019,  1273,  1285,   584,   184,   252,   339,   439,
    1297,  1298,  1301,  1302,   223,  1219,  1282,  1019,   577,   823,
     634,   634,   634,  1279,   634,  1279,   257,   311,   475,  1213,
    1213,   260,   332,   523,  1124,  1125,  1268,  1221,  1285,   634,
    1221,  1288,   173,  1216,   634,  1221,   224,   491,   162,   173,
    1208,   584,  1216,  1279,  1218,  1216,  1216,  1221,  1221,   537,
     956,   584,   956,   453,   434,   582,   586,  1062,  1063,  1064,
    1065,  1066,  1075,  1076,  1083,  1267,   364,  1413,   348,  1117,
    1123,  1366,   819,    66,   868,   121,  1287,    70,    81,   235,
     304,   328,   387,   469,   637,   639,   394,   527,   746,   747,
     211,   742,   743,   744,   751,   759,   761,    95,   196,   354,
     363,   369,   454,   541,   618,   619,  1282,    24,   285,   736,
     737,   738,   751,   752,   753,   759,   761,   729,   730,   736,
     909,   338,   628,   916,   113,   222,  1279,  1282,  1151,   582,
     583,   584,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   584,   539,
     976,   817,   818,    70,   323,   395,   528,   739,   740,   741,
     751,   755,   756,   757,   758,   759,   761,   565,   543,   724,
      46,  1342,   179,   634,   634,   634,   634,  1285,   613,   896,
     897,   584,  1197,  1195,  1199,   176,   577,  1285,  1103,   584,
     583,  1052,   583,  1053,   583,   583,   583,  1019,   135,   560,
    1060,    18,   583,   544,   583,   583,   583,   584,   544,   584,
    1043,   583,   577,   583,   584,   584,   583,   583,   583,   583,
     176,   583,   584,  1045,   583,   584,   584,   584,   576,   584,
     583,   583,   582,  1275,  1285,  1052,   583,   583,   583,  1052,
     583,   584,   583,   583,   583,   583,   583,   583,   583,   584,
     583,   223,   583,   584,   584,   584,   584,   583,   583,   583,
     584,   176,   584,  1052,   583,   583,   583,   584,   584,   584,
     583,   176,  1019,   176,  1019,   176,  1019,   176,   583,   584,
     583,   583,   583,   583,   584,   583,  1001,  1000,  1056,   587,
     184,   252,   439,  1300,   443,  1285,   160,   331,   518,   534,
     582,    16,  1019,  1369,   149,  1109,  1022,  1019,  1019,  1022,
     582,  1029,  1022,  1014,  1039,  1040,  1041,   582,   589,  1285,
     760,   145,   443,  1175,  1176,  1288,  1279,   944,  1287,   584,
     389,  1231,  1150,  1233,  1285,  1344,  1345,   577,  1279,  1285,
    1339,  1339,  1339,   145,   166,   180,   189,   236,   237,   264,
     322,   374,  1320,  1322,   561,  1105,  1158,   210,   992,   993,
    1279,   263,   389,   566,  1313,  1312,   582,   783,   783,   109,
     168,   194,   260,   332,   523,  1128,  1131,  1132,   485,   786,
     776,   582,  1019,  1282,  1288,  1288,   985,  1279,   157,   385,
     542,   967,   968,   969,   434,   442,   548,   549,   582,   813,
    1166,  1169,  1282,   185,  1339,  1339,  1339,  1362,  1013,   176,
     220,  1006,  1007,  1116,  1117,  1142,  1015,   589,  1295,   112,
     513,  1285,  1304,   312,   363,   588,   868,  1303,  1282,   176,
    1220,   583,  1285,   336,   584,   451,  1221,   384,  1121,  1207,
    1221,  1216,  1279,  1221,  1221,   611,   957,   955,  1082,  1285,
      89,   212,   230,   241,   315,   421,   480,  1074,   442,   584,
    1279,  1082,   584,   173,  1414,    46,  1121,  1176,  1176,   313,
    1282,   469,   469,   469,   469,   469,   433,  1282,  1282,  1176,
     584,   744,  1282,  1282,  1282,  1282,   109,   168,   194,   260,
     332,   523,  1127,  1282,  1282,   583,   584,  1176,  1176,   584,
     738,   731,   732,   751,   752,   753,     6,    13,    14,    25,
      26,    55,    59,    60,    64,    70,    78,    85,    98,   115,
     122,   123,   129,   137,   143,   171,   207,   209,   217,   232,
     284,   301,   305,   343,   348,   355,   362,   363,   392,   404,
     405,   406,   407,   426,   479,   494,   514,   521,   532,   770,
     825,   827,   828,   829,   920,   925,   927,   930,   936,   937,
     938,  1113,    74,   430,   405,   917,  1383,   375,  1095,  1096,
    1097,  1285,  1019,  1127,  1282,  1282,   109,   168,   260,   332,
     523,  1129,  1282,  1127,  1282,  1282,  1282,  1282,  1282,  1127,
    1127,  1282,  1282,  1127,   610,  1176,  1176,  1176,  1176,   584,
     741,  1287,   256,   158,   733,   734,   735,   751,   752,   753,
     754,   757,   758,   759,   761,   363,   500,  1285,   621,  1403,
       8,    29,   719,   582,   418,   245,   582,   763,   824,   826,
     827,   521,   544,   900,   338,  1153,  1279,   544,  1105,  1063,
     589,  1200,   219,  1019,   583,  1019,   503,  1019,  1019,   139,
      33,    58,    99,   102,   110,   317,   449,   507,   536,  1054,
      33,   869,  1287,  1019,   869,  1054,  1056,   583,   219,   219,
    1019,  1019,  1056,  1019,  1019,  1019,  1019,  1019,  1022,   583,
     583,  1019,  1019,  1019,  1019,  1019,  1019,  1056,   219,  1019,
    1019,  1019,   583,  1019,  1019,  1019,  1019,   176,  1019,   176,
    1019,   176,  1019,  1019,  1019,  1368,  1368,   583,   589,   589,
     589,  1287,  1019,  1369,  1021,   583,   584,   583,  1029,  1099,
    1099,    16,  1019,  1369,  1109,  1019,   583,   584,  1055,  1056,
    1285,   830,  1287,  1149,   604,   255,   583,   584,   589,   589,
     511,   511,   511,  1321,  1106,  1122,  1123,  1166,   500,  1284,
     584,   994,   566,   252,  1014,    46,   582,   793,   783,   780,
     781,   782,  1285,   511,   968,   814,  1167,   582,  1172,  1177,
    1172,   583,   813,  1168,  1272,  1273,  1276,  1285,  1170,   345,
     176,   176,   176,   999,   130,  1063,  1143,   173,   255,  1011,
    1142,  1122,  1007,    18,  1017,  1282,  1285,   577,  1285,   589,
     227,   589,  1175,   112,   869,   870,  1175,   173,  1175,   588,
    1287,    33,   112,   872,   873,  1287,  1129,  1212,   147,   558,
    1125,  1125,   563,   332,  1105,  1216,   584,  1077,  1082,  1062,
     230,   230,   351,  1084,   230,   241,   421,  1084,  1075,  1062,
    1187,  1188,  1276,  1064,  1103,  1079,  1080,  1127,   297,  1118,
     112,   874,   876,  1287,   870,    98,    98,   113,   222,   202,
     762,  1128,   744,   619,   762,   762,   738,   584,   732,    69,
      80,   178,   362,   458,   840,   843,   844,   890,   892,   942,
     942,   362,  1176,  1176,   942,  1176,   362,   362,  1176,  1176,
     511,   121,  1176,   231,   494,   172,   362,   375,   892,   942,
     231,  1176,   494,   121,  1176,  1176,  1176,  1176,   942,   362,
      46,  1176,   771,  1176,   362,   360,    18,   145,   511,   946,
     362,   362,  1176,   112,   124,   294,  1285,  1176,  1176,  1176,
     825,   584,   769,   770,   925,   582,   589,   839,   845,  1278,
    1285,   326,   373,    22,   152,   622,   511,   122,   137,   624,
     582,  1385,   583,   584,  1282,  1128,   762,   762,   741,   344,
     187,  1176,   584,   735,   500,   418,   338,   582,   116,   216,
     538,   720,  1397,   110,   221,   391,   481,   836,  1279,   245,
     362,   764,   769,   837,   838,   839,   840,   769,   584,   826,
      45,   191,   428,   902,   902,  1279,  1063,  1116,  1105,  1103,
    1019,   583,  1019,   503,   582,   862,   862,   582,   857,   858,
     862,   221,   221,   583,   583,   583,   583,   583,  1044,  1019,
    1019,   583,   583,  1051,  1117,   584,   584,   583,   584,   583,
     223,  1036,  1037,   583,   583,   583,   583,   584,   583,   583,
    1019,   583,   173,   583,   583,   584,   583,   584,   584,   583,
    1019,   583,  1019,   583,  1019,   583,   583,   583,  1371,  1371,
     589,   906,   583,  1056,  1021,   583,   584,   583,  1015,  1041,
     583,  1345,   577,   577,  1341,  1341,  1341,   582,  1019,   338,
    1182,  1248,   993,   206,   997,   791,  1022,   779,   362,   794,
     795,   583,   584,  1288,  1008,  1173,  1174,  1276,  1178,   584,
     582,  1169,   583,   583,   584,   589,  1360,   176,  1341,  1341,
    1341,  1105,  1105,   131,   352,  1138,  1139,  1144,   538,   223,
    1282,  1285,   589,  1285,   243,  1285,    12,    33,   112,   338,
    1019,  1307,    66,   875,  1019,  1288,   337,   363,   500,  1306,
    1300,  1175,  1121,   267,  1221,   611,  1363,  1078,   587,   230,
    1075,  1084,  1084,   230,   338,   338,   544,   584,  1186,  1175,
    1093,  1094,  1008,  1019,  1119,  1274,   732,   905,  1278,   892,
     893,   980,   893,    60,   172,   375,   533,   842,   891,   841,
     842,   905,  1278,   980,  1129,  1127,  1278,  1127,    12,   926,
     934,   935,  1285,   980,  1282,  1282,   868,  1176,  1127,   233,
     934,   233,  1278,  1278,   830,  1176,   166,   236,   328,   834,
    1127,  1129,  1129,  1278,   980,  1114,  1115,  1276,   112,  1127,
     774,  1282,   980,  1279,   980,   980,    73,    75,   112,   133,
     167,   356,   396,   833,  1127,   830,   582,     6,   129,   938,
     837,  1285,     8,   166,   945,   397,   841,   882,   846,   589,
     373,  1019,  1019,   338,   628,   634,   338,    70,   629,  1285,
    1386,    18,  1096,   582,  1285,   762,   735,   836,   430,  1404,
     338,   645,   646,   648,  1285,   455,  1279,   813,   583,   584,
     206,   410,   766,  1254,   826,   614,  1105,   246,  1126,  1099,
    1019,   332,    20,    33,    47,   530,   868,   878,   332,   583,
    1099,  1099,   436,  1050,  1019,  1019,  1056,    42,   315,   583,
     563,  1038,  1019,  1099,  1019,  1019,  1019,  1019,   583,   583,
     583,   583,  1285,   583,  1056,  1017,   412,  1346,  1346,  1346,
     112,  1019,  1180,  1181,   132,  1254,   239,  1015,   191,   233,
     796,   583,   584,   782,  1012,   584,  1175,  1179,  1180,  1177,
    1171,  1169,  1272,  1285,  1341,  1122,   187,  1110,  1284,  1284,
     588,  1140,  1141,  1287,   444,   577,   389,   408,   437,  1305,
     876,  1175,   582,   582,  1304,  1019,   145,   583,  1065,  1062,
    1075,   230,   230,  1062,  1075,  1068,  1067,  1069,  1188,  1105,
    1181,  1091,  1092,  1012,   584,    19,   117,  1120,   928,  1019,
     233,   233,   893,   905,   897,   129,   442,   926,   939,   922,
     584,  1128,   870,  1282,   905,   944,  1282,   940,   926,   584,
    1120,   926,   931,   926,  1150,   583,  1285,  1279,    32,    33,
      38,    40,    42,    43,    58,    99,   102,   110,   127,   144,
     167,   169,   181,   182,   221,   249,   258,   259,   261,   290,
     291,   292,   308,   309,   310,   314,   317,   333,   334,   367,
     368,   391,   438,   442,   452,   501,   504,   507,   508,   509,
     510,   550,   551,   571,   847,   850,   851,   852,   853,   854,
     855,   856,  1285,  1099,   451,  1282,   128,   918,   583,   584,
    1384,   618,   455,   622,   214,   223,   353,   649,   650,   651,
     652,  1014,   583,   584,   647,  1282,   583,   583,   824,   838,
      18,   816,   582,  1125,   583,   583,    33,   879,    20,   530,
     868,   880,   879,   869,   583,   584,   583,   583,  1267,   583,
     583,   584,   583,   303,   235,   384,   583,   583,   583,   583,
     583,   583,   583,    61,   228,   324,   471,   483,   567,  1337,
    1338,   563,  1347,  1347,  1347,   583,   584,  1183,   220,   583,
     582,   784,   582,   797,  1285,   795,   815,  1174,  1181,   583,
    1363,    46,   192,  1107,  1145,  1287,   584,   303,    71,   524,
     389,  1306,   500,   500,  1175,  1282,  1103,   338,  1071,  1075,
    1075,   338,  1073,  1019,  1019,   582,  1116,   171,   206,   543,
    1086,  1087,  1090,  1081,  1274,   361,   582,   929,   905,   897,
     582,   112,   112,   845,   975,   935,   875,   847,   921,  1115,
     932,   934,   923,   583,   883,   582,   582,   862,   857,   371,
     848,   857,   857,   878,    58,   550,   851,   853,   878,   878,
      58,   551,   551,   554,   857,   849,   862,   862,   878,   582,
     862,    25,    66,    70,   112,   164,   331,   338,   375,   438,
     479,   533,   864,   865,   866,   881,  1025,   554,   582,   878,
     582,   879,   582,   582,   862,   582,   858,   863,   589,   623,
     630,   631,  1285,  1387,  1388,   583,  1282,   627,   628,   583,
     584,   647,  1392,  1398,   648,   847,   765,   769,   582,   813,
     903,   904,  1285,   869,   879,   332,  1019,   303,   156,   500,
     500,   500,    16,  1336,   185,   282,   283,   287,   288,  1348,
    1349,  1181,   233,  1249,  1014,   787,   789,   790,  1285,   548,
     798,   835,  1007,  1122,  1111,  1274,  1108,  1116,    68,  1255,
    1141,   583,   583,  1307,    16,  1070,   544,  1072,   544,  1098,
    1285,  1126,   892,   892,  1087,   835,  1120,  1128,   794,   582,
     582,   903,   102,   504,   507,   575,   576,  1269,  1270,   945,
     864,   980,   933,   967,   281,   338,   582,   884,   886,   887,
     888,   332,   332,   449,   536,   572,   859,   860,   861,   582,
     859,   859,   878,   554,   859,   582,   878,   332,   859,   874,
    1282,   327,   867,  1269,   112,   133,   167,   832,   538,   112,
     112,   124,   294,   233,   866,   233,   331,   332,   332,   332,
     332,   859,   332,   859,  1285,   473,   625,    52,    63,   163,
     205,   229,   240,   342,   419,   632,   670,   672,   673,   674,
     676,   677,   678,   679,   680,   681,   683,   691,   692,   695,
     706,   709,   711,   712,  1281,  1286,  1290,   434,   582,  1389,
     624,  1405,   651,  1285,  1279,   418,  1363,   766,   813,   767,
     583,   584,  1120,   582,   583,   583,  1337,   345,  1127,  1127,
    1127,  1127,  1349,   538,   496,   791,   484,   792,   583,   584,
     223,   242,    70,    98,   209,   284,   301,   323,   494,   810,
     811,   812,  1215,  1011,   563,   584,  1112,  1120,  1019,  1122,
     138,   148,   346,   499,  1256,  1257,   248,  1258,   268,  1019,
     582,  1019,   582,   583,   584,   173,  1085,  1085,   583,   903,
     903,   583,  1271,  1271,   941,   220,   177,   359,   450,   116,
     538,   885,  1285,   888,   583,   583,   861,   907,  1267,   907,
     583,  1018,   327,   549,   583,   583,   583,   583,  1019,   140,
     626,   693,   696,  1285,   176,   322,   684,   671,  1286,  1286,
    1285,   675,   595,   262,   409,   562,   715,    30,   713,   591,
    1001,  1000,   563,  1390,   629,   636,   847,   173,  1399,   583,
    1360,   232,   563,   898,   899,   900,   901,   904,   332,  1189,
    1190,  1276,  1279,  1015,  1128,   788,   790,   582,   502,  1176,
     121,   121,  1176,  1176,  1176,  1176,   582,   805,   812,   143,
      90,   423,  1274,   377,  1133,    46,    46,   138,    46,  1257,
     472,   499,  1259,  1260,   145,  1098,  1098,  1285,   187,   230,
     348,  1089,  1088,   583,   583,   898,   945,   582,    50,   328,
     416,   442,   889,   889,   583,   584,   583,   584,   583,  1018,
     878,   879,   878,   879,  1019,  1019,   560,   698,   702,   176,
    1285,   686,   687,  1019,   654,   669,   670,   672,   674,   676,
     678,   679,   680,   681,   683,   691,   706,   709,   711,   654,
     716,   714,   707,   710,   583,    51,    60,   252,   128,   120,
     637,   638,  1025,  1406,  1014,   847,   768,  1176,   358,   901,
    1120,   583,   584,  1175,  1250,   583,   792,   802,   803,   804,
    1022,   289,   582,   799,   800,   801,  1282,  1176,  1176,   260,
     332,   523,  1130,  1131,  1130,  1128,  1287,   485,   806,   807,
    1176,  1120,  1285,  1267,  1267,    46,  1267,    46,    46,  1260,
    1129,   583,   583,    46,    46,   582,   582,   882,   898,   794,
       5,   112,   331,   886,  1285,   878,  1267,   878,   694,   703,
     135,   702,   705,   220,   139,  1019,   139,   669,   590,   537,
    1019,   655,   715,   713,  1363,    60,   345,    60,   630,   120,
     669,  1393,  1400,  1363,  1127,  1281,  1190,  1181,   868,   871,
     583,   584,   289,   804,  1282,  1282,   808,   583,   584,   830,
    1134,  1267,  1267,  1267,    16,  1095,  1097,   583,   560,   697,
     699,  1019,   654,   139,   682,   205,   503,   262,   590,   718,
     128,   111,   653,   656,   708,  1286,   708,   345,   345,   134,
     636,   870,  1251,   803,   583,   583,   809,  1287,   807,   582,
     271,   583,   583,   700,   699,   705,   704,    52,   685,  1285,
     688,  1019,   717,    83,   155,   661,   667,  1285,   139,   669,
     590,   427,  1401,  1255,   810,  1014,  1135,  1136,  1137,   145,
    1019,   139,   503,   584,   654,   139,   654,   190,   584,   657,
      77,    93,   590,  1394,   669,  1258,  1019,   583,   584,  1127,
     701,    52,   654,  1285,   689,   409,   139,   173,  1285,   847,
     173,   173,   669,   206,  1261,  1015,  1137,   503,   135,   136,
     690,   562,   658,   112,   668,   461,   664,  1127,   659,   660,
     332,   582,  1262,   654,   654,   686,   460,   462,   662,   663,
     664,   666,  1025,  1285,  1019,   549,   665,   998,   248,   583,
     588,  1263,  1264,  1276,   442,  1265,   584,   669,   174,  1283,
    1287,   583,   584,  1189,   663,  1264
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1351 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            if (!thd->bootstrap &&
              (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              MYSQL_YYABORT;
            }
            else
            {
              thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
            }
          }
    break;

  case 3:
#line 1364 "sql_yacc.yy"
    {}
    break;

  case 57:
#line 1429 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX *lex= thd->lex;
            lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
            lex->prepared_stmt_name= (yyvsp[0].lex_str);
          }
    break;

  case 60:
#line 1444 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX *lex= thd->lex;
            lex->sql_command= SQLCOM_PREPARE;
            lex->prepared_stmt_name= (yyvsp[-2].lex_str);
          }
    break;

  case 61:
#line 1454 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX *lex= thd->lex;
            lex->prepared_stmt_code= (yyvsp[0].lex_str);
            lex->prepared_stmt_code_is_varref= FALSE;
          }
    break;

  case 62:
#line 1461 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX *lex= thd->lex;
            lex->prepared_stmt_code= (yyvsp[0].lex_str);
            lex->prepared_stmt_code_is_varref= TRUE;
          }
    break;

  case 63:
#line 1471 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX *lex= thd->lex;
            lex->sql_command= SQLCOM_EXECUTE;
            lex->prepared_stmt_name= (yyvsp[0].lex_str);
          }
    break;

  case 64:
#line 1478 "sql_yacc.yy"
    {}
    break;

  case 69:
#line 1493 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
            if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
          }
    break;

  case 70:
#line 1505 "sql_yacc.yy"
    {
            if (Lex->sphead)
            {
              my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
              MYSQL_YYABORT;
            }
          }
    break;

  case 71:
#line 1513 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->sql_command= SQLCOM_HELP;
            lex->help_arg= (yyvsp[0].lex_str).str;
          }
    break;

  case 72:
#line 1524 "sql_yacc.yy"
    {
            LEX *lex = Lex;
            lex->sql_command = SQLCOM_CHANGE_MASTER;
            bzero((char*) &lex->mi, sizeof(lex->mi));
          }
    break;

  case 73:
#line 1530 "sql_yacc.yy"
    {}
    break;

  case 76:
#line 1540 "sql_yacc.yy"
    {
            Lex->mi.host = (yyvsp[0].lex_str).str;
          }
    break;

  case 77:
#line 1544 "sql_yacc.yy"
    {
            Lex->mi.user = (yyvsp[0].lex_str).str;
          }
    break;

  case 78:
#line 1548 "sql_yacc.yy"
    {
            Lex->mi.password = (yyvsp[0].lex_str).str;
          }
    break;

  case 79:
#line 1552 "sql_yacc.yy"
    {
            Lex->mi.port = (yyvsp[0].ulong_num);
          }
    break;

  case 80:
#line 1556 "sql_yacc.yy"
    {
            Lex->mi.connect_retry = (yyvsp[0].ulong_num);
          }
    break;

  case 81:
#line 1560 "sql_yacc.yy"
    {
            Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
              LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
          }
    break;

  case 82:
#line 1565 "sql_yacc.yy"
    {
            Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
          }
    break;

  case 83:
#line 1569 "sql_yacc.yy"
    {
            Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
          }
    break;

  case 84:
#line 1573 "sql_yacc.yy"
    {
            Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
          }
    break;

  case 85:
#line 1577 "sql_yacc.yy"
    {
            Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
          }
    break;

  case 86:
#line 1581 "sql_yacc.yy"
    {
            Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
          }
    break;

  case 87:
#line 1585 "sql_yacc.yy"
    {
            Lex->mi.ssl_verify_server_cert= (yyvsp[0].ulong_num) ?
              LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
          }
    break;

  case 89:
#line 1594 "sql_yacc.yy"
    {
            Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
          }
    break;

  case 90:
#line 1598 "sql_yacc.yy"
    {
            Lex->mi.pos = (yyvsp[0].ulonglong_number);
            /* 
               If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
               instead of causing subsequent errors. 
               We need to do it in this file, because only there we know that 
               MASTER_LOG_POS has been explicitely specified. On the contrary
               in change_master() (sql_repl.cc) we cannot distinguish between 0
               (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
               whereas we want to distinguish (specified 0 means "read the binlog
               from 0" (4 in fact), unspecified means "don't change the position
               (keep the preceding value)").
            */
            Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
          }
    break;

  case 91:
#line 1614 "sql_yacc.yy"
    {
            Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
          }
    break;

  case 92:
#line 1618 "sql_yacc.yy"
    {
            Lex->mi.relay