#### suite/funcs_1/storedproc/storedproc_master.inc
#
--enable_query_log

let $message= .
              .                         IMPORTANT NOTICE:
              .                         -----------------
              .
              .  FIXME: The .result files are still NOT CHECKED for correctness!
              .
              .  FIXME: Several tests are affected by known problems around DECIMAL
              .  FIXME: and NUMERIC that will be checked again after WL#2984 once
              .  FIXME: has been completed. Some of them are marked in the result.
              .
              . Currently (Dec 06, 2005) this .result file is checked OK for Linux
              . with 5.0.17-bk (ChangeSet@1.1975.1.2, 2005-12-05 18:33:48+01:00).
              . Using the available Windows version 5.0.16 there are differences
              . that can be ignored (e.g. WL#2984).
              .;
--source include/show_msg80.inc

#FIXME-START-------------------------------------------------------------------
#
# remove this section prior releasing the test, then we may stop at the first
# error we get ('passed' or 'not passed' - that's the question).
--disable_abort_on_error

   # having ALWAYS a .reject from the changing TIME makes it easier to work with
   # the GUI diff program until the testcase is finished for pushing.
   #
   # let $message= FIXME: Show some information when / where the .result has been created;
   # --source include/show_msg.inc
   --vertical_results
   # SELECT version(), @@version_compile_os AS 'vers_comp_os', current_date, current_time;

   let $message= FIXME: There are subtests that are switched off due to known bugs:;
   --source include/show_msg.inc
   #set a variable here to be able to switch all crashing sub tests with ONE change HERE.
   #change the corresponding variable to '1' to enable the crashing parts.
   --disable_query_log

   let $check_wl2984= 0;
   eval SELECT $check_wl2984 AS 'WL#2984: DECIMAL and NUMERIC problems with differences on some machines';

   --horizontal_results
   --enable_query_log

# As long as
# Bug#11589: mysqltest, --ps-protocol, strange output, float/double/real with zerofill
# is not fixed, we must switch the ps-protocol for some statements off.
# If this bug is fixed, please
# 1. set the following variable to 0
# 2. check, if the test passes
# 3. remove the workarounds
let $have_bug_11589= 1;
if ($have_bug_11589)
{
   let $message= There are some statements where the ps-protocol is switched off.
                 Bug#11589: mysqltest, --ps-protocol, strange output, float/double/real with zerofill;
   --source include/show_msg80.inc
}

#
#FIXME-END---------------------------------------------------------------------


# prepare a variable to be able to suppress machine dependant diffs
#let $SERVER_NAME= `SELECT DISTINCT host FROM mysql.user WHERE host LIKE "%\%" AND host NOT In ("localhost", "127.0.0.1", "%")`;
# can be used in: --replace_result $SERVER_NAME <SERVER_NAME>

# ------------------------------------------------------------------------------
--source suite/funcs_1/storedproc/load_sp_tb.inc


# ==============================================================================
let $message= Section 3.1.1 - Syntax checks for the CREATE PROCEDURE, CREATE
FUNCTION, ALTER PROCEDURE, ALTER FUNCTION, DROP PROCEDURE, DROP FUNCTION, SHOW
CREATE PROCEDURE, SHOW CREATE FUNCTION, SHOW CREATE PROCEDURE STATUS, SHOW
CREATE FUNCTION STATUS, and CALL statements:;
--source include/show_msg80.inc


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.1:
              ---------------
              Ensure that all clauses that should be supported are supported
              CREATE PROCEDURE;
--source include/show_msg80.inc

USE db_storedproc;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1_thisisaveryverylongname234872934_thisisaveryverylongname234872934;
--enable_warnings

CREATE PROCEDURE sp1_thisisaveryverylongname234872934_thisisaveryverylongname234872934 (f1 char(20) )
            SELECT * from t1 where f2 = f1;
CALL sp1_thisisaveryverylongname234872934_thisisaveryverylongname234872934('aaaa');

--disable_warnings
DROP PROCEDURE IF EXISTS sp1_thisisaveryverylongname234872934_thisisaveryverylongnameabcde;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1_thisisaveryverylongname234872934_thisisaveryverylongnameabcde( f1 tinytext ) language sql deterministic sql security definer comment 'this is simple'
  BEGIN
    set @v1 = f1;
    SELECT @v1, @v1;
END//
delimiter ;//

CALL sp1_thisisaveryverylongname234872934_thisisaveryverylongnameabcde( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 binary ) language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
delimiter ;//

CALL sp1( 34 );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 blob ) language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
delimiter ;//

CALL sp1( 34 );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 int )  language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
delimiter ;//

CALL sp1( 34 );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: SP definition accepted with m>60 in DECIMAL(m,n)
#FIXME --error 4711
CREATE PROCEDURE sp1( f1 decimal(256, 30) ) language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
DROP PROCEDURE IF EXISTS sp1//

# should fail: 66 is not allowed; maximum is 65.
#FIXME --error 4711
CREATE PROCEDURE sp1( f1 decimal(66, 30) ) language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
DROP PROCEDURE IF EXISTS sp1//

CREATE PROCEDURE sp1( f1 decimal(60, 30) ) language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set @v1 = f1;
    SELECT @v1;
END//
delimiter ;//

CALL sp1( 17976931340000 );

if ($check_wl2984)
{
   # switched off due to big differences with (e.g....) sol10-sparc-b
   CALL sp1( 1.797693134e+13 );
   CALL sp1( 1.7976931348623157493578e+308 );

   -- echo FIXME: Following test contains a known problem that will be checked again
   -- echo FIXME: after WL#2984 has been completed:
   -- echo FIXME: values accepted without warning although m>60 in DECIMAL(m,n)

   # check all ...E+100 to E-100
   let $digits= 100;
   while ($digits)
   {
      eval CALL sp1( 0.1234567890987654321e+$digits );
      eval CALL sp1( 0.1234567890987654321e-$digits );
      dec $digits;
   }
   # check the 2 values which cannot be handled easy in the loop:
   eval CALL sp1( 0.1234567890987654321e+0 );
   eval CALL sp1( 0.1234567890987654321e-0 );
}

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 enum("value1", "value1") )  language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    SELECT f1;
END//
delimiter ;//

CALL sp1( "value1" );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 set("value1", "value1") ) language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    SELECT f1;
END//
delimiter ;//

CALL sp1( "value1, value1" );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 enum("value1", "value1") )  language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    SELECT f1;
END//
delimiter ;//

CALL sp1( "value1" );

--replace_column 5 modified 6 created
SHOW PROCEDURE status;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) language sql SELECT f1;

CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) deterministic SELECT f1;
CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) not deterministic SELECT f1;
CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) sql security definer SELECT f1;
CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) sql security invoker SELECT f1;
CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1( f1 text ) comment 'this is simple' SELECT f1;
CALL sp1( 'abc' );

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp1';

# cleanup
DROP PROCEDURE sp1_thisisaveryverylongname234872934_thisisaveryverylongname234872934;
DROP PROCEDURE sp1_thisisaveryverylongname234872934_thisisaveryverylongnameabcde;
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.2:
              ---------------
              Ensure that all clauses that should be supported are supported
              CREATE FUNCTION;
--source include/show_msg80.inc


--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

CREATE FUNCTION fn1 (s char(20)) returns char(50)
    return concat('hello, ', s, '!');
SELECT fn1('world');

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 mediumtext ) returns mediumtext   language sql deterministic sql security definer comment 'this is simple'
  BEGIN
    set @v1 = 'hello';
    set f1 = concat( @v1, f1 );
    return f1;
END//
delimiter ;//

SELECT fn1( ' world');

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set f1 = 1 + f1;
    return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
# 1425: Too big scale 63 specified for column ''. Maximum is 30.
--error 1425
CREATE FUNCTION fn1( f1 decimal(63, 31) ) returns decimal(63, 31) language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set f1 = 1000000 + f1;
    return f1;
END//
delimiter ;//

--error 1305
SELECT fn1( 1.3326e+8 );

delimiter //;
CREATE FUNCTION fn1( f1 decimal(63, 30) ) returns decimal(63, 30) language sql not deterministic sql security invoker comment 'this is simple'
BEGIN
    set f1 = 1000000 + f1;
    return f1;
END//
delimiter ;//

SELECT fn1( 1.3326e+8 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 enum("value1", "value1") ) returns decimal(63, 30)  language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    return f1;
END//
delimiter ;//

SELECT fn1( "value1" );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 set("value1", "value1") ) returns decimal(63, 30) language sql not deterministic sql security invoker comment 'this is simple'
  BEGIN
    return f1;
END//
delimiter ;//

SELECT fn1( "value1, value1" );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint language sql
  BEGIN
      set f1 = 1 + f1;
      return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint deterministic
  BEGIN
      set f1 = 1 + f1;
      return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint not deterministic
  BEGIN
      set f1 = 1 + f1;
      return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint
  sql security definer
  BEGIN
      set f1 = 1 + f1;
      return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint
  sql security invoker
BEGIN
   set f1 = 1 + f1;
   return f1;
END//
delimiter ;//

SELECT fn1( 126 );

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 smallint ) returns smallint
   comment 'this is simple'
BEGIN
   set f1 = 1 + f1;
   return f1;
END//
delimiter ;//

SELECT fn1( 126 );
--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

# cleanup
DROP FUNCTION fn1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.3:
              ---------------
              Ensure that all clauses that should be supported are supported
              SHOW CREATE PROC;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1 (f1 char(20) )
    SELECT * from t1 where f2 = f1;

--replace_column 5 modified 6 created
show CREATE PROCEDURE sp1;

# cleanup
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.4:
              ---------------
show create function;
--source include/show_msg80.inc

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

CREATE FUNCTION fn1 (s char(20)) returns char(50)
   return concat('hello, ', s, '!');

--replace_column 5 modified 6 created
show CREATE FUNCTION fn1;

# cleanup
DROP FUNCTION fn1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.5:
              ---------------
SHOW PROCEDURE status;
--source include/show_msg80.inc


CREATE PROCEDURE sp5()
   SELECT * from t1;

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp5';

# cleanup
DROP PROCEDURE sp5;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.6:
              ---------------
show function status;
--source include/show_msg80.inc


delimiter //;
CREATE FUNCTION fn5(a int) returns int
BEGIN
   set @b = 0.9 * a;
   return @b;
END//
delimiter ;//

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn5';

# cleanup
DROP FUNCTION fn5;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.7:
              ---------------
CALL procedure;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp7a;
DROP PROCEDURE IF EXISTS sp7b;
DROP PROCEDURE IF EXISTS sp7c;
--enable_warnings

CREATE PROCEDURE sp7a(a char(20))
    SELECT * from t1 where t1.f2 = a;

CALL sp7a( 'xyz' );

CREATE PROCEDURE sp7b (a char (20), out b char(20))
    SELECT f1 into b from t1 where t1.f2= a;

CALL sp7b('xyz', @out_param);
SELECT @out_param;

delimiter //;
CREATE PROCEDURE sp7c (a char (20), out b char(20), inout c int)
BEGIN
SELECT f1 into b from t1 where t1.f2=a;
   update t1 set t1.f2=999 where t1.f4=c;
SELECT f2 into c from t1 where t1.f2=999;
END//
delimiter ;//

set @c=1;
CALL sp7c('xyz', @out_param, @c);
SELECT @out_param;
SELECT @c;

# cleanup
DROP PROCEDURE sp7a;
DROP PROCEDURE sp7b;
DROP PROCEDURE sp7c;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.8:
              ---------------
calling function;
--source include/show_msg80.inc


CREATE FUNCTION fn8(a char(20)) returns char(50)
return concat('hello, ', a, '!');
SELECT fn8('world');

# cleanup
DROP FUNCTION fn8;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.9:
              ---------------
drop procedure;
--source include/show_msg80.inc


--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';

--disable_warnings
DROP PROCEDURE IF EXISTS sp9;
--enable_warnings

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';

CREATE PROCEDURE sp9()SELECT * from t1;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';

DROP PROCEDURE sp9;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';

CREATE PROCEDURE sp9()SELECT * from t1;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';

DROP PROCEDURE IF EXISTS sp9;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='sp9';



# ------------------------------------------------------------------------------
let $message= Testcase 4.1.10:
              ----------------
DROP FUNCTION;
--source include/show_msg80.inc

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';

--disable_warnings
DROP FUNCTION IF EXISTS fn10;
--enable_warnings

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';


CREATE FUNCTION fn10() returns int return 100;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';

DROP FUNCTION fn10;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';

CREATE FUNCTION fn10() returns int return 100;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';

DROP FUNCTION IF EXISTS fn10;

--replace_column 13 created 14 modified
SELECT * from mysql.proc where specific_name='fn10' and type='function';


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.11:
              ----------------
alter proc;
--source include/show_msg80.inc


create user 'user_1'@'localhost';
grant execute on db_storedproc.* to 'user_1'@'localhost';
flush privileges;
drop table IF EXISTS mysql.t1;
create table mysql.t1( f1 char );
DROP PROCEDURE IF EXISTS sp11;
CREATE PROCEDURE sp11() insert into mysql.t1 values('a');
--replace_column 13 created 14 modified
SELECT security_type from mysql.proc where specific_name='sp11';

--replace_result $MASTER_MYPORT MYSQL_PORT $MASTER_MYSOCK MYSQL_SOCK
connect (u_1, localhost, user_1, , db_storedproc);
--source suite/funcs_1/include/show_connection.inc

CALL sp11();

connection default;
--source suite/funcs_1/include/show_connection.inc

alter procedure sp11 sql security invoker;
--replace_column 13 created 14 modified
SELECT security_type from mysql.proc where specific_name='sp11';

--replace_result $MASTER_MYPORT MYSQL_PORT $MASTER_MYSOCK MYSQL_SOCK
connection u_1;
--source suite/funcs_1/include/show_connection.inc

--error 1142
CALL sp11();

commit work;
disconnect u_1;
connection default;
--source suite/funcs_1/include/show_connection.inc

alter procedure sp11 sql security definer;
--replace_column 13 created 14 modified
SELECT security_type from mysql.proc where specific_name='sp11';
CALL sp11();

# cleanup
DROP USER 'user_1'@'localhost';
DROP PROCEDURE sp11;
drop table mysql.t1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.12:
              ----------------
alter function;
--source include/show_msg80.inc


CREATE FUNCTION fn12() returns int
 return 100;
SELECT security_type from mysql.proc where specific_name='fn12';
--replace_column 13 created 14 modified
SELECT fn12();

alter function fn12 sql security invoker;
SELECT security_type from mysql.proc where specific_name='fn12';
--replace_column 13 created 14 modified
SELECT fn12();

alter function fn12 sql security definer;
SELECT security_type from mysql.proc where specific_name='fn12';
--replace_column 13 created 14 modified
SELECT fn12();

# cleanup
DROP FUNCTION fn12;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.13:
              ----------------
alter proc;
--source include/show_msg80.inc


DROP PROCEDURE IF EXISTS sp11;
CREATE PROCEDURE sp11()
   SELECT * from t1;

SELECT comment from mysql.proc where specific_name='sp11';
--replace_column 13 created 14 modified
alter procedure sp11 comment 'this is simple';
SELECT comment from mysql.proc where specific_name='sp11';
--replace_column 13 created 14 modified

# cleanup
DROP PROCEDURE sp11;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.14:
              ----------------
alter function;
--source include/show_msg80.inc

DROP FUNCTION IF EXISTS fn12;
CREATE FUNCTION fn12() returns int
    return 100;
  SELECT comment from mysql.proc where specific_name='fn12';
--replace_column 13 created 14 modified

  alter function fn12 comment 'this is simple';
  SELECT comment from mysql.proc where specific_name='fn12';
--replace_column 13 created 14 modified

# cleanup
DROP FUNCTION fn12;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.15:
              ----------------
Ensure that any invalid stored procedure name is never accepted, and that an
appropriate error message is returned when the name is rejected;
--source include/show_msg80.inc


--error 1357
CREATE PROCEDURE sp1()
DROP PROCEDURE sp1;

--error 1064
CREATE PROCEDURE !_sp1( f1 char(20) )
SELECT * from t1 where f2 = f1;

#FIXME: this was what I found in this file ... :
#CREATE PROCEDURE !_sp1( f1 char(20) )
#    SELECT * from t1 where f2 = f1; ^a^kcd '/usr/mysql/mysql-test/t'
#/t'ql/mysql-test
#t]# t@localhost t

--error 0,1064
CREATE PROCEDURE function()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE function;

--error 1064
CREATE PROCEDURE add()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE all()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE alter()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE analyze()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE and()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE as()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE asc()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE asensitive()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE before()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE between()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE bigint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE binary()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE blob()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE both()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE by()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE CALL()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE cascade()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE case()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE change()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE char()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE character()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE check()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE collate()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE column()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE columns()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE columns;

--error 1064
CREATE PROCEDURE condition()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE connection()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE constraint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE continue()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE convert()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE create()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE cross()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE current_date()
  SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE current_time()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE current_timestamp()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE current_user()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE cursor()
  SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE database()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE databases()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE day_hour()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE day_microsecond()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE day_minute()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE day_second()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE dec()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE decimal()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE declare()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE default()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE delayed()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE delete()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE desc()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE describe()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE deterministic()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE distinct()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE distinctrow()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE div()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE double()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE drop()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE dual()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE each()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE else()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE elseif()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE enclosed()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE escaped()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE exists()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE exit()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE explain()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE false()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE fetch()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE fields()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE fields;

--error 1064
CREATE PROCEDURE float()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE for()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE force()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE foreign()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE found()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE found;

--error 1064
CREATE PROCEDURE from()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE fulltext()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE goto()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE goto;

--error 1064
CREATE PROCEDURE grant()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE group()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE having()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE high_priority()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE hour_microsecond()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE hour_minute()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE hour_second()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE if()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE ignore()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE in()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE index()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE infile()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE inner()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE inout()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE insensitive()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE insert()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE int()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE integer()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE interval()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE into()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE is()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE iterate()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE join()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE key()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE keys()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE kill()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE leading()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE leave()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE left()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE like()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE limit()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE lines()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE load()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE localtime()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE localtimestamp()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE lock()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE long()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE longblob()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE longtext()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE loop()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE low_priority()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE match()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE mediumblob()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE mediumint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE mediumtext()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE middleint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE minute_microsecond()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE minute_second()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE mod()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE modifies()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE natural()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE not()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE no_write_to_binlog()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE null()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE numeric()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE on()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE optimize()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE option()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE optionally()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE or()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE order()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE out()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE outer()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE outfile()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE precision()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE primary()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE privileges()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE privileges;

--error 1064
CREATE PROCEDURE procedure()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE purge()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE read()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE reads()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE real()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE references()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE regexp()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE rename()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE repeat()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE replace()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE require()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE restrict()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE return()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE revoke()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE right()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE rlike()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE schema()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE schemas()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE second_microsecond()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE select()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sensitive()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE separator()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE set()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE show()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE smallint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE soname()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE spatial()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE specific()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sql()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sqlexception()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sqlstate()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sqlwarning()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sql_big_result()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sql_calc_found_rows()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE sql_small_result()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE ssl()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE starting()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE straight_join()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE table()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE tables()
   SELECT * from t1 where f2=f1;
DROP PROCEDURE tables;

--error 1064
CREATE PROCEDURE terminated()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE then()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE tinyblob()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE tinyint()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE tinytext()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE to()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE trailing()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE trigger()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE true()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE undo()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE union()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE unique()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE unlock()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE unsigned()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE update()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE usage()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE use()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE using()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE utc_date()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE utc_time()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE utc_timestamp()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE values()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE varbinary()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE varchar()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE varcharacter()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE varying()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE when()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE where()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE while()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE with()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE write()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE xor()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE year_month()
   SELECT * from t1 where f2=f1;

--error 1064
CREATE PROCEDURE zerofill()
   SELECT * from t1 where f2=f1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.15:
              ----------------
Ensure that any invalid function name is never accepted, and that an appropriate
error message is returned when the name is rejected;
--source include/show_msg80.inc


--error 1064
CREATE FUNCTION !_fn1(f1 char) returns char
    return f1;

--error 1064
CREATE FUNCTION char(f1 char) returns char
    return f1;

--error 1064
CREATE FUNCTION char binary(f1 char binary) returns char binary
    return f1;
--error 1064
CREATE FUNCTION char ascii(f1 char ascii) returns char ascii
    return f1;

--error 1064
CREATE FUNCTION char not null(f1 char not null) returns char not null
    return f1;

--error 1064
CREATE FUNCTION char binary not null(f1 char binary not null) returns char binary not null
    return f1;

--error 1064
CREATE FUNCTION char ascii not null(f1 char ascii not null) returns char ascii not null
    return f1;

--error 1064
CREATE FUNCTION tinytext(f1 tinytext) returns tinytext
    return f1;

--error 1064
CREATE FUNCTION text(f1 text) returns text
    return f1;
  DROP FUNCTION text;

--error 1064
CREATE FUNCTION mediumtext(f1 mediumtext) returns mediumtext
    return f1;

--error 1064
CREATE FUNCTION longtext(f1 longtext) returns longtext
    return f1;

--error 1064
CREATE FUNCTION tinytext not null(f1 tinytext not null) returns tinytext not null
    return f1;

--error 1064
CREATE FUNCTION text not null(f1 text not null) returns text not null
    return f1;

--error 1064
CREATE FUNCTION mediumtext not null(f1 mediumtext not null) returns mediumtext not null
    return f1;

--error 1064
CREATE FUNCTION longtext not null(f1 longtext not null) returns longtext not null
    return f1;

--error 1064
CREATE FUNCTION tinyblob(f1 tinyblob) returns tinyblob
    return f1;

--error 1064
CREATE FUNCTION blob(f1 blob) returns blob
    return f1;

--error 1064
CREATE FUNCTION mediumblob(f1 mediumblob) returns mediumblob
    return f1;

--error 1064
CREATE FUNCTION longblob(f1 longblob) returns longblob
    return f1;

--error 1064
CREATE FUNCTION tinyblob not null(f1 tinyblob not null) returns tinyblob not null
    return f1;

--error 1064
CREATE FUNCTION blob not null(f1 blob not null) returns blob not null
    return f1;

--error 1064
CREATE FUNCTION mediumblob not null(f1 mediumblob not null) returns mediumblob not null
    return f1;

--error 1064
CREATE FUNCTION longblob not null(f1 longblob not null) returns longblob not null
    return f1;

--error 1064
CREATE FUNCTION binary(f1 binary) returns binary
    return f1;

--error 1064
CREATE FUNCTION binary not null(f1 binary not null) returns binary not null
    return f1;

--error 1064
CREATE FUNCTION tinyint(f1 tinyint) returns tinyint
    return f1;

--error 1064
CREATE FUNCTION tinyint unsigned(f1 tinyint unsigned) returns tinyint unsigned
    return f1;

--error 1064
CREATE FUNCTION tinyint zerofill(f1 tinyint zerofill) returns tinyint zerofill
    return f1;

--error 1064
CREATE FUNCTION tinyint unsigned zerofill(f1 tinyint unsigned zerofill) returns tinyint unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION smallint(f1 smallint) returns smallint
    return f1;

--error 1064
CREATE FUNCTION smallint unsigned(f1 smallint unsigned) returns smallint unsigned
    return f1;

--error 1064
CREATE FUNCTION smallint zerofill(f1 smallint zerofill) returns smallint zerofill
    return f1;

--error 1064
CREATE FUNCTION smallint unsigned zerofill(f1 smallint unsigned zerofill) returns smallint unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION mediumint(f1 mediumint) returns mediumint
    return f1;

--error 1064
CREATE FUNCTION mediumint unsigned(f1 mediumint unsigned) returns mediumint unsigned
    return f1;

--error 1064
CREATE FUNCTION mediumint zerofill(f1 mediumint zerofill) returns mediumint zerofill
    return f1;

--error 1064
CREATE FUNCTION mediumint unsigned zerofill(f1 mediumint unsigned zerofill) returns mediumint unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION int(f1 int) returns int
    return f1;

--error 1064
CREATE FUNCTION int unsigned(f1 int unsigned) returns int unsigned
    return f1;

--error 1064
CREATE FUNCTION int zerofill(f1 int zerofill) returns int zerofill
    return f1;

--error 1064
CREATE FUNCTION int unsigned zerofill(f1 int unsigned zerofill) returns int unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION bigint(f1 bigint) returns bigint
    return f1;

--error 1064
CREATE FUNCTION bigint unsigned(f1 bigint unsigned) returns bigint unsigned
    return f1;

--error 1064
CREATE FUNCTION bigint zerofill(f1 bigint zerofill) returns bigint zerofill
    return f1;

--error 1064
CREATE FUNCTION bigint unsigned zerofill(f1 bigint unsigned zerofill) returns bigint unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION decimal(f1 decimal) returns decimal
    return f1;

--error 1064
CREATE FUNCTION decimal unsigned(f1 decimal unsigned) returns decimal unsigned
    return f1;

--error 1064
CREATE FUNCTION decimal zerofill(f1 decimal zerofill) returns decimal zerofill
    return f1;

--error 1064
CREATE FUNCTION decimal unsigned zerofill(f1 decimal unsigned zerofill) returns decimal unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION numeric(f1 numeric) returns numeric
    return f1;

--error 1064
CREATE FUNCTION numeric unsigned(f1 numeric unsigned) returns numeric unsigned
    return f1;

--error 1064
CREATE FUNCTION numeric zerofill(f1 numeric zerofill) returns numeric zerofill
    return f1;

--error 1064
CREATE FUNCTION numeric unsigned zerofill(f1 numeric unsigned zerofill) returns numeric unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION real(f1 real) returns real
    return f1;

--error 1064
CREATE FUNCTION real unsigned(f1 real unsigned) returns real unsigned
    return f1;

--error 1064
CREATE FUNCTION real zerofill(f1 real zerofill) returns real zerofill
    return f1;

--error 1064
CREATE FUNCTION real unsigned zerofill(f1 real unsigned zerofill) returns real unsigned zerofill
    return f1;

--error 1064
CREATE FUNCTION float(f1 float) returns float
    return f1;

--error 1064
CREATE FUNCTION float unsigned(f1 float unsigned) returns float unsigned
    return f1;

--error 1064
CREATE FUNCTION float zerofill(f1 float zerofill) returns float zerofill
    return f1;

--error 1064
CREATE FUNCTION float unsigned zerofill(f1 float unsigned zerofill) returns float unsigned zerofill
    return f1;

#FIXME check this is OK:--error 1064
CREATE FUNCTION date(f1 date) returns date
    return f1;
DROP FUNCTION date;

#FIXME check this is OK:--error 1064
CREATE FUNCTION time(f1 time) returns time
    return f1;
DROP FUNCTION time;

#FIXME check this is OK:--error 1064
CREATE FUNCTION datetime(f1 datetime) returns datetime
    return f1;
DROP FUNCTION datetime;

#FIXME check this is OK:--error 1064
CREATE FUNCTION timestamp(f1 timestamp) returns timestamp
    return f1;
DROP FUNCTION timestamp;

#FIXME check this is OK:--error 1064
CREATE FUNCTION year(f1 year) returns year
    return f1;
DROP FUNCTION year;

--error 1064
CREATE FUNCTION year(3)(f1 year(3)) returns year(3)
    return f1;

--error 1064
CREATE FUNCTION year(4)(f1 year(4)) returns year(4)
    return f1;

--error 1064
CREATE FUNCTION enum("1enum", "2enum")(f1 enum("1enum", "2enum")) returns enum("1enum", "2enum")
    return f1;

--error 1064
CREATE FUNCTION set("1set", "2set")(f1 set("1set", "2set")) returns set("1set", "2set")
    return f1;


DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char f1 ) returns char
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char binary f1 ) returns char binary
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char ascii f1 ) returns char ascii
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char not null f1 ) returns char not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char binary not null f1 ) returns char binary not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(char ascii not null f1 ) returns char ascii not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinytext f1 ) returns tinytext
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(text f1 ) returns text
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumtext f1 ) returns mediumtext
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(longtext f1 ) returns longtext
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinytext not null f1 ) returns tinytext not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(text not null f1 ) returns text not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumtext not null f1 ) returns mediumtext not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(longtext not null f1 ) returns longtext not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyblob f1 ) returns tinyblob
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(blob f1 ) returns blob
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumblob f1 ) returns mediumblob
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(longblob f1 ) returns longblob
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyblob not null f1 ) returns tinyblob not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(blob not null f1 ) returns blob not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumblob not null f1 ) returns mediumblob not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(longblob not null f1 ) returns longblob not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(binary f1 ) returns binary
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(binary not null f1 ) returns binary not null
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyint f1 ) returns tinyint
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyint unsigned f1 ) returns tinyint unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyint zerofill f1 ) returns tinyint zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(tinyint unsigned zerofill f1 ) returns tinyint unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(smallint f1 ) returns smallint
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(smallint unsigned f1 ) returns smallint unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(smallint zerofill f1 ) returns smallint zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(smallint unsigned zerofill f1 ) returns smallint unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumint f1 ) returns mediumint
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumint unsigned f1 ) returns mediumint unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumint zerofill f1 ) returns mediumint zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(mediumint unsigned zerofill f1 ) returns mediumint unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(int f1 ) returns int
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(int unsigned f1 ) returns int unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(int zerofill f1 ) returns int zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(int unsigned zerofill f1 ) returns int unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(bigint f1 ) returns bigint
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(bigint unsigned f1 ) returns bigint unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(bigint zerofill f1 ) returns bigint zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(bigint unsigned zerofill f1 ) returns bigint unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(decimal f1 ) returns decimal
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(decimal unsigned f1 ) returns decimal unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(decimal zerofill f1 ) returns decimal zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(decimal unsigned zerofill f1 ) returns decimal unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(numeric f1 ) returns numeric
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(numeric unsigned f1 ) returns numeric unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(numeric zerofill f1 ) returns numeric zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(numeric unsigned zerofill f1 ) returns numeric unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(real f1 ) returns real
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(real unsigned f1 ) returns real unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(real zerofill f1 ) returns real zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(real unsigned zerofill f1 ) returns real unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(float f1 ) returns float
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(float unsigned f1 ) returns float unsigned
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(float zerofill f1 ) returns float zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(float unsigned zerofill f1 ) returns float unsigned zerofill
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(date f1 ) returns date
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(time f1 ) returns time
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(datetime f1 ) returns datetime
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(timestamp f1 ) returns timestamp
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(year f1 ) returns year
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(year(3) f1 ) returns year(3)
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(year(4) f1 ) returns year(4)
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(enum("1enum", "2enum") f1 ) returns enum("1enum", "2enum")
    return f1;

DROP FUNCTION IF EXISTS fn1;
--error 1064
CREATE FUNCTION fn1(set("1set", "2set") f1 ) returns set("1set", "2set")
    return f1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.16:
              ----------------
Ensure that a reference to a non-existent stored procedure is rejected with an
appropriate error message;
--source include/show_msg80.inc

DROP PROCEDURE IF EXISTS sp16;

--error 1305
CALL sp16( 'xyz' );

CREATE DATABASE db1;
USE db1;

delimiter //;
CREATE PROCEDURE sp16()
BEGIN
    set @var1 = 1;
    SELECT @var1;
END//
delimiter ;//

--error 1305
CALL db_storedproc.sp16();

# cleanup
USE db_storedproc;
DROP PROCEDURE db1.sp16;
DROP DATABASE db1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.17:
              ----------------
Ensure that it is possible to drop, create and CALL/execute a procedure and a
function with the same name, even in the same database;
--source include/show_msg80.inc

USE db_storedproc;
DROP FUNCTION IF EXISTS sp1;
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1 ()
BEGIN
    declare x enum( 'db1', 'test' ) default 'test';
    SELECT x;
END//
delimiter ;//

CALL sp1();


CREATE FUNCTION sp1 (y char) returns char return y;
  SELECT sp1( 'a' );

DROP DATABASE IF EXISTS db1;
CREATE DATABASE db1;
USE db1;
CALL db_storedproc.sp1( );
SELECT db_storedproc.sp1( 'a' );

DROP FUNCTION db_storedproc.sp1;
USE db_storedproc;

--error 1305
SELECT sp1('a');

DROP PROCEDURE sp1;

--error 1305
CALL sp1();

--error 1305
SELECT sp1('a');

# cleanup
USE db_storedproc;
DROP DATABASE db1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.18:
              ----------------
Ensure that it is possible to alter a procedure and
a function with the same name, in the same database;
--source include/show_msg80.inc


USE db_storedproc;
DROP PROCEDURE IF EXISTS sp1;
DROP FUNCTION IF EXISTS sp1;
set @x=null; set @y=null;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    set @x= 1;
    SELECT @x;
END//
delimiter ;//

CREATE FUNCTION sp1 () returns int return 2.2;
CALL db_storedproc.sp1();
SELECT db_storedproc.sp1();

DROP DATABASE IF EXISTS db1;
CREATE DATABASE db1;
USE db1;
alter procedure db_storedproc.sp1 sql security invoker;
SELECT name, type, security_type from mysql.proc where db LIKE 'db_storedproc%' and specific_name='sp1';

alter function db_storedproc.sp1 sql security invoker;
SELECT name, type, security_type from mysql.proc where db LIKE 'db_storedproc%' and specific_name='sp1';

CALL db_storedproc.sp1();

SELECT db_storedproc.sp1();

USE db_storedproc;
alter procedure sp1 sql security definer;
CALL db_storedproc.sp1();

SELECT db_storedproc.sp1();

alter function sp1 sql security definer;

SELECT name, type, security_type from mysql.proc where db LIKE 'db_storedproc%' and specific_name='sp1';
CALL db_storedproc.sp1();

SELECT db_storedproc.sp1();

# cleanup
USE db_storedproc;
DROP DATABASE db1;
DROP PROCEDURE db_storedproc.sp1;
DROP FUNCTION db_storedproc.sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.19:
              ----------------
verify altering procedure and function with the same name, does not affect
properties of a procedure and a function with the same name in the different
database.;
--source include/show_msg80.inc


--disable_warnings
DROP DATABASE IF EXISTS db_storedproc_3122;
--enable_warnings

CREATE DATABASE db_storedproc_3122;
USE db_storedproc;
set @x=null;
set @y=null;
DROP PROCEDURE IF EXISTS sp1;
DROP FUNCTION IF EXISTS sp1;
DROP PROCEDURE IF EXISTS db_storedproc_3122.sp1;
DROP FUNCTION IF EXISTS db_storedproc_3122.sp1;
delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    set @x= 1;
    SELECT @x;
END//
delimiter ;//

# FIXME ps-protocol vs. normal difference when returning float instead of double
CREATE FUNCTION db_storedproc_3122.sp1() returns double return 2.2;
CALL sp1();
  SELECT db_storedproc_3122.sp1();
  USE db_storedproc_3122;

delimiter //;
CREATE PROCEDURE sp1 ()
BEGIN
    set @x= 3;
    SELECT @x;
END//
delimiter ;//

CREATE FUNCTION db_storedproc.sp1() returns double return 4.4;
CALL sp1();
SELECT db_storedproc.sp1();

alter procedure db_storedproc_3122.sp1 sql security invoker;
alter function sp1 sql security invoker;

SELECT db, name, type, security_type from mysql.proc where db LIKE 'db_storedproc%' and specific_name='sp1';

CALL db_storedproc.sp1();

SELECT db_storedproc.sp1();
CALL db_storedproc_3122.sp1();
SELECT db_storedproc_3122.sp1();

# clean up
USE db_storedproc;
DROP DATABASE db_storedproc_3122;
DROP FUNCTION db_storedproc.sp1;
DROP PROCEDURE db_storedproc.sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.20:
              ----------------
Ensure that it is possible to alter the comment of a procedure
and a function with the same name, even in the same database;
--source include/show_msg80.inc


USE db_storedproc;
set @x=null;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
DROP FUNCTION IF EXISTS sp1;
--enable_warnings

CREATE PROCEDURE sp1 () set @x= 1;
CREATE FUNCTION sp1 () returns int return 2;

DROP DATABASE IF EXISTS db_storedproc_3122;
CREATE DATABASE db_storedproc_3122;
USE db_storedproc_3122;

CREATE PROCEDURE sp1 () set @x= 3;
CREATE FUNCTION sp1 () returns int return 4;

alter procedure sp1 sql security invoker comment 'this is a procedure';
alter function sp1 sql security invoker comment 'this is a function';

alter procedure sp1 sql security definer;
alter function sp1 sql security definer;
--replace_column 5 modified 6 created
show CREATE PROCEDURE sp1;
--replace_column 5 modified 6 created
show CREATE FUNCTION sp1;

# clean up
USE db_storedproc;
DROP DATABASE db_storedproc_3122;
DROP FUNCTION db_storedproc.sp1;
DROP PROCEDURE db_storedproc.sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.21:
              ----------------
Ensure that it is not possible to create two procedures with same name
in same database;
--source include/show_msg80.inc

USE db_storedproc;
set @x=null;
set @y=null;

--disable_warnings
DROP DATABASE IF EXISTS db1;
--enable_warnings

CREATE DATABASE db1;
DROP PROCEDURE IF EXISTS sp1;
CREATE PROCEDURE sp1 () set @x=1;

--error 1304
CREATE PROCEDURE sp1 () set @x=2;

CALL sp1();
SELECT @x;
USE db1;
--error 1304
CREATE PROCEDURE db_storedproc.sp1 () set @x=3;
CALL db_storedproc.sp1();
  SELECT @x;

DROP PROCEDURE IF EXISTS db_storedproc.sp1;
CREATE PROCEDURE db_storedproc.sp1 () set @x=1;
--error 1304
CREATE PROCEDURE db_storedproc.sp1 () set @x=2;
CALL db_storedproc.sp1();
SELECT @x;

# clean up
USE db_storedproc;
DROP DATABASE db1;
DROP PROCEDURE db_storedproc.sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.1.22:
              ----------------
Ensure that it is not possible to create two functions with same name in the
same database;
--source include/show_msg80.inc

USE db_storedproc;
DROP DATABASE IF EXISTS db1;
CREATE DATABASE db1;
DROP FUNCTION IF EXISTS fn1;
CREATE FUNCTION fn1 () returns int return 1;
--error 1304
CREATE FUNCTION fn1 () returns int return 2;
SELECT fn1();
USE db1;
--error 1304
CREATE FUNCTION db_storedproc.fn1 () returns int return 3;
SELECT db_storedproc.fn1();
DROP FUNCTION IF EXISTS db_storedproc.fn1;
CREATE FUNCTION db_storedproc.fn1 () returns int return 1;
--error 1304
CREATE FUNCTION db_storedproc.fn1 () returns int return 2;
SELECT db_storedproc.fn1();

# clean up
USE db_storedproc;
DROP DATABASE db1;
DROP FUNCTION db_storedproc.fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.23:
              ----------------
Ensure that it is possible to create two or more procedures with the same name,
providing each resides in different databases;
--source include/show_msg80.inc


USE db_storedproc;
set @x=null;
set @y=null;
DROP PROCEDURE IF EXISTS sp1;
CREATE PROCEDURE sp1 () set @x= 1;
DROP DATABASE IF EXISTS test3124;
CREATE DATABASE test3124;
USE test3124;
CREATE PROCEDURE sp1 () set @y= 2;
CALL sp1();
SELECT @x, @y;
USE db_storedproc;
CALL sp1();
SELECT @x, @y;

# clean up
USE db_storedproc;
DROP DATABASE test3124;
DROP PROCEDURE db_storedproc.sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.24:
              ----------------
Ensure that it is possible to create two or more functions with the same name,
providing each resides in different databases.;
--source include/show_msg80.inc


USE db_storedproc;
DROP FUNCTION IF EXISTS f1;
CREATE FUNCTION f1 () returns int return 1;
DROP DATABASE IF EXISTS test3125;
CREATE DATABASE test3125;
USE test3125; CREATE FUNCTION f1 () returns int return 2;
SELECT f1();
USE db_storedproc;
SELECT f1();

# clean up
USE db_storedproc;
DROP DATABASE test3125;
DROP FUNCTION db_storedproc.f1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.25:
              ----------------
Ensure that any invalid function name is never accepted, and that an appropriate
error message is returned when the name is rejected. (invalid func name);
--source include/show_msg80.inc

delimiter //;
--error 1064
CREATE FUNCTION !_fn1( f1 char(20) ) returns int
BEGIN
   SELECT * from t1 where f2 = f1;
   return 1;
END//
delimiter ;//

delimiter //;
--error 1064
CREATE FUNCTION fn1( f1 char(20) ) return int
BEGIN
   SELECT * from t1 where f2 = f1;
   return 1;
END//
delimiter ;//

CREATE FUNCTION fn1() returns int
  return 'a';

--error 1064
CREATE FUNCTION procedure() returns int
  return 1;

--error 1064
CREATE FUNCTION fn1(a char) returns int lang sql return 1;

--error 1064
CREATE FUNCTION fn1(a char) returns int deterministic( return 1);

--error 1064
CREATE FUNCTION fn1(a char) returns int non deterministic return 1;

--error 1064
CREATE FUNCTION fn1(a char) returns int not deterministic comment 'abc' language sql sql security refiner return 1;

# clean up
--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings


# ==============================================================================
#
# test plan section: 4.2 - syntax checks for programming statements - 1
#
# ==============================================================================

# ------------------------------------------------------------------------------
let $message= Testcase 4.1.1:
              ---------------
              Ensure that all clauses that should be supported are supported.
              CREATE PROCEDURE;
--source include/show_msg80.inc


USE db_storedproc;

  set @count = 0;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1(cnt int(20))
BEGIN
    SELECT count(*) into cnt from t2;
    set @count = cnt;
END//
delimiter ;//

CALL sp1( 10 );

  SELECT @count;

# clean up
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.2:
BEGINend;
--source include/show_msg80.inc


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( cnt int(20) )
BEGIN
    SELECT count(*) into cnt from t2;
    set @count = cnt;
    SELECT @count;
END//
delimiter ;//

CALL sp1( 10 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

# missing BEGIN
delimiter //;
--error 1064
CREATE PROCEDURE sp1( cnt int(20) )
    SELECT count(*) into cnt from t2;
    set @count = cnt;
    SELECT @count;
END//
delimiter ;//

--error 1305
CALL sp1( 10 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

# wrong order of BEGIN and END
delimiter //;
--error 1064
CREATE PROCEDURE sp1( cnt int(20) )
END
    SELECT count(*) into cnt from t2;
    set @count = cnt;
    SELECT @count;
BEGIN//
delimiter ;//

--error 1305
CALL sp1( 10 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

# invalid usage of BEGIN + END
delimiter //;
--error 1064
CREATE PROCEDURE sp1( cnt int(20) )
BEGIN
   SELECT count(*) into cnt from t2;
   BEGIN
      BEGIN END;
   BEGIN
   END;
   set @count = cnt;
   SELECT @count;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.4:
              ---------------
Ensure that every BEGIN statement is coupled with a terminating END statement.
(BEGIN with no END);
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x char;
    declare y char;
    SELECT f1, f2 into x, y from t2 limit 1;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase ....:
              --------------
;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  add:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  all:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  alter:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  analyze:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  and:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  as:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  asc:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  asensitive:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  before:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  between:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  bigint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  binary:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  blob:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  both:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  by:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  CALL:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  cascade:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  case:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  change:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  char:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  character:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  check:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  collate:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  column:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  columns:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  condition:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  connection:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  constraint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  continue:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  convert:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  create:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  cross:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  current_date:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  current_time:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  current_timestamp:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  current_user:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  cursor:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  database:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  databases:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  day_hour:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  day_microsecond:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  day_minute:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  day_second:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  dec:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  decimal:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  declare:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  default:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  delayed:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  delete:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  desc:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  describe:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  deterministic:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  distinct:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  distinctrow:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  div:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  double:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
drop:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  dual:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  each:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  else:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  elseif:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  enclosed:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  escaped:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  exists:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  exit:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  explain:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  false:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  fetch:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  fields:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  float:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  for:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  force:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  foreign:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  found:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  from:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  fulltext:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  goto:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  grant:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  group:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  having:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  high_priority:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  hour_microsecond:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  hour_minute:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  hour_second:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  if:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  ignore:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  in:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  index:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  infile:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  inner:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  inout:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  insensitive:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  insert:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  int:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  integer:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  interval:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  into:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  is:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  iterate:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  join:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  key:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  keys:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  kill:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  leading:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  leave:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  left:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  like:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  limit:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  lines:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  load:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  localtime:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  localtimestamp:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  lock:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  long:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  longblob:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  longtext:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  loop:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  low_priority:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  match:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  mediumblob:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  mediumint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  mediumtext:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  middleint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  minute_microsecond:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  minute_second:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  mod:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  modifies:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  natural:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  not:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  no_write_to_binlog:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  null:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  numeric:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  on:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  optimize:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  option:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  optionally:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  or:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  order:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  out:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  outer:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  outfile:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  precision:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  primary:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  privileges:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  procedure:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  purge:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  read:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  reads:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  real:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  references:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  regexp:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  rename:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  repeat:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  replace:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  require:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  restrict:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  return:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  revoke:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  right:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  rlike:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  schema:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  schemas:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  second_microsecond:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  select:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sensitive:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  separator:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  set:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  show:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  smallint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  soname:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  spatial:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  specific:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sql:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sqlexception:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sqlstate:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sqlwarning:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sql_big_result:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sql_calc_found_rows:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  sql_small_result:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  ssl:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  starting:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  straight_join:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  table:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME: is it OK that this now succeeds? --error 1064
CREATE PROCEDURE sp1()
  tables:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  terminated:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  then:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  tinyblob:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  tinyint:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  tinytext:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  to:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  trailing:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  trigger:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  true:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  undo:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  union:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  unique:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1314
CREATE PROCEDURE sp1()
  unlock:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  unsigned:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  update:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  usage:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  use:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  using:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  utc_date:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  utc_time:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  utc_timestamp:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  values:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  varbinary:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  varchar:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  varcharacter:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  varying:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  when:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  where:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  while:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  with:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  write:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  xor:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  year_month:BEGIN
    SELECT @x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
  zerofill:BEGIN
    SELECT @x;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.6:
              ---------------
Ensure that the labels for multiple BEGIN an END work properly;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
CREATE PROCEDURE sp1( )
begin_label: BEGIN
    declare x char;
    declare y char;
    set x = '1';
    set y = '2';
    label1: BEGIN
      declare x char;
      declare y char;
      SELECT f1, f2 into x, y from t2 limit 1;
    END label1;
    set @v1 = x;
    set @v2 = y;
    SELECT @v1, @v2;
END begin_label//
delimiter ;//

CALL sp1();

# clean up
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.7:
              ---------------
Ensure that the labels enclosing each BEGIN/END compound statement must match.;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1310
CREATE PROCEDURE sp1( )
begin1_label: BEGIN
    declare x char;
    declare y char;
    SELECT lf1, f1 into x, y from t2 limit 1;
    begin2_label: BEGIN
      declare x char;
      declare y char;
      SELECT f1, f2 into x, y from t2 limit 1;
    END begin2_changed;
END begin1_changed//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.8:
              ---------------
Ensure that it is possible to put a beginning label at the start of a
BEGIN/END compound statement without also requiring an ending label
at the END of the same statement.;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
    begin_label: BEGIN
    declare x char;
    declare y char;
    SELECT f1, f2 into x, y from t2 limit 1;
END//
delimiter ;//

CALL sp1();

# clean up
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.9:
              ---------------
Ensure that it is not possible to put an ending label at the END of
a BEGIN/END compound statement without also requiring a matching
beginning label at the start of the same statement;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare x char;
    declare y char;
    SELECT f1, f2 into x, y from t2 limit 1;
END begin_label//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.10:
              ----------------
Ensure that every beginning label must END with a colon(:);
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
begin_label BEGIN
   declare x char;
   declare y char;
   SELECT f1, f2 into x, y from t2 limit 1;
END begin_label//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.11:
              ----------------
Ensure that every beginning label with the same scope must be unique. (same label names);
--source include/show_msg80.inc


--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1309
CREATE PROCEDURE sp6( )
begin_samelabel: BEGIN
    declare x char;
    declare y char;
    SELECT f1, f2 into x, y from t2 limit 1;
    begin_samelabel: BEGIN
      declare x char;
      declare y char;
      SELECT f1, f2 into x, y from t2 limit 1;
    END begin_samelabel;
    begin_samelabel: BEGIN
      declare x char;
      declare y char;
      SELECT f1, f2 into x, y from t2 limit 1;
    END begin_samelabel;
END begin_samelabel//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.12:
              ----------------
Ensure that the variables, cursors, conditions, and handlers declared for
a stored procedure (with the declare statement) may only be properly defined;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: DECIMAL(255,255) is not rejected

delimiter //;
CREATE PROCEDURE sp6( )
BEGIN
    declare x char default 'a';
    declare y integer default 1;
    declare z float default 1.1;
    declare a enum("value1", "value2") default 'value1';
    declare b decimal(255, 255) default 1.2e+12;
    declare c mediumtext default 'mediumtext';
    declare d datetime default '2005-02-02 12:12:12';
    declare e char default 'b';
    declare cur1 cursor for SELECT f1 from db_storedproc.t2;
    declare continue handler for sqlstate '02000' set @x2 = 1;
    open cur1;
    fetch cur1 into e;
    SELECT x, y, z, a, b, c, d, e;
    close cur1;
END//
delimiter ;//

CALL sp6();

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6( )
BEGIN
    declare x12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567 char default '0';
    SELECT x12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567;
END//
delimiter ;//

CALL sp6();

# clean up
DROP PROCEDURE sp6;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.13:
              ----------------
Ensure that the variables declared for a stored procedure (with the declare
statement) may only be defined in the correct order.;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare x default '0' char;
    SELECT x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare x char, integer default '0';
    SELECT x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare x1, x2 char, integer default '0', 1;
    SELECT x;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare char x;
   declare char y;
   SELECT f1, f2 into x, y from t2 limit 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare char x, y1 integer default 0;
   declare char y;
   SELECT f1, f2 into x, y from t2 limit 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare x default 'a' char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare condition notable for sqlstate '42s22';
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare condition for notable sqlstate '42s22';
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare condition for sqlstate notable '42s22';
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare condition for sqlstate '42s22' notable;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare cursor cur1 for SELECT f1 from db_storedproc.t2;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare cursor for cur1 SELECT f1 from db_storedproc.t2;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare cursor for SELECT cur1 f1 from db_storedproc.t2;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare handler continue for sqlstate '02000' set @x2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare handler exit for sqlstate '02000' set @x2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6( )
BEGIN
    declare handler undo for sqlstate '02000' set @x2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare char x;
    SELECT f1 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare char binary  x;
    SELECT f2 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare char ascii  x;
    SELECT f3 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinytext  x;
    SELECT f4 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare  x;
    SELECT f5 text  into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumtext  x;
    SELECT f6 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longtext  x;
    SELECT f7 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyblob  x;
    SELECT f8 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare blob x;
    SELECT f9 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumblob  x;
    SELECT f10 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longblob  x;
    SELECT f11 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare binary  x;
    SELECT f12 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint  x;
    SELECT f13 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint unsigned  x;
    SELECT f14 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint zerofill  x;
    SELECT f15 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint unsigned zerofill  x;
    SELECT f16 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint  x;
    SELECT f17 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint unsigned   x;
    SELECT f18 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint zerofill  x;
    SELECT f19 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint unsigned zerofill  x;
    SELECT f20 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint  x;
    SELECT f21 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint unsigned  x;
    SELECT f22 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint zerofill  x;
    SELECT f23 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint unsigned zerofill  x;
    SELECT f24 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int  x;
    SELECT f25 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int unsigned  x;
    SELECT f26 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int zerofill  x;
    SELECT f27 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int unsigned zerofill  x;
    SELECT f28 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint  x;
    SELECT f29 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint unsigned  x;
    elect f30 into x from tb1 limit 9998, 1;
END//
delimiter ;//


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint zerofill  x;
    SELECT f31 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint unsigned zerofill  x;
    SELECT f32 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal  x;
    SELECT f33 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal unsigned  x;
    SELECT f34 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal zerofill  x;
    SELECT f35 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal unsigned zerofill not null  x;
    SELECT f36 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (0) not null  x;
    SELECT f37 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (64) not null  x;
    SELECT f38 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (0) unsigned not null  x;
    SELECT f39 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (64) unsigned not null  x;
    SELECT f40 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (0) zerofill not null  x;
    SELECT f41 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (64) zerofill not null  x;
    SELECT f42 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (0) unsigned zerofill not null  x;
    SELECT f43 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (64) unsigned zerofill not null  x;
    SELECT f44 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (00) not null  x;
    SELECT f45 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (63, 30) not null  x;
    SELECT f46 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (00) unsigned not null  x;
    SELECT f47 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (63, 30) unsigned not null  x;
    SELECT f48 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (00) zerofill not null  x;
    SELECT f49 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (63, 30) zerofill not null  x;
    SELECT f50 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (00) unsigned zerofill not null  x;
    SELECT f51 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal (63, 30) unsigned zerofill not null  x;
    SELECT f52 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric not null  x;
    SELECT f53 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric unsigned not null  x;
    SELECT f54 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric zerofill not null  x;
    SELECT f55 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric unsigned zerofill not null  x;
    SELECT f56 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (0) not null  x;
    SELECT f57 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (64) not nul x;
    SELECT f58 into x from tb1 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (0) unsigned  x;
    SELECT f59 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (64) unsigned  x;
    SELECT f60 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (0) zerofill  x;
    SELECT f61 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (64) zerofill  x;
    SELECT f62 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (0) unsigned zerofill  x;
    SELECT f63 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (64) unsigned zerofill  x;
    SELECT f64 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (00)  x;
    SELECT f65 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (63, 30)  x;
    SELECT f66 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (00) unsigned  x;
    SELECT f67 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (63, 30) unsigned  x;
    SELECT f68 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (00) zerofill  x;
    SELECT f69 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (63, 30) zerofill  x;
    SELECT f70 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (00) unsigned zerofill  x;
    SELECT f71 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric (63, 30) unsigned zerofill  x;
    SELECT f72 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real  x;
    SELECT f73 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real unsigned  x;
    SELECT f74 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real zerofill  x;
    SELECT f75 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real unsigned zerofill  x;
    SELECT f76 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double  x;
    SELECT f77 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double unsigned  x;
    SELECT f78 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double zerofill  x;
    SELECT f79 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double unsigned zerofill  x;
    SELECT f80 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float not null  x;
    SELECT f81 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float unsigned not null  x;
    SELECT f82 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float zerofill not null  x;
    SELECT f83 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float unsigned zerofill not null  x;
    SELECT f84 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(0) not null  x;
    SELECT f85 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(23) not null  x;
    SELECT f86 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(0) unsigned not null  x;
    SELECT f87 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(23) unsigned not null  x;
    SELECT f88 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(0) zerofill not null  x;
    SELECT f89 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(23) zerofill not null  x;
    SELECT f90 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(0) unsigned zerofill not null  x;
    SELECT f91 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(23) unsigned zerofill not null  x;
    SELECT f92 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(24) not null  x;
    SELECT f93 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(53) not null  x;
    SELECT f94 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(24) unsigned not null  x;
    SELECT f95 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(53) unsigned not null  x;
    SELECT f96 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(24) zerofill not null  x;
    SELECT f97 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(53) zerofill not null  x;
    SELECT f98 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(24) unsigned zerofill not null  x;
    SELECT f99 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float(53) unsigned zerofill not null  x;
    SELECT f100 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare date not null  x;
    SELECT f101 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare time not null  x;
    SELECT f102 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare datetime not null  x;
    SELECT f103 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare timestamp not null  x;
    SELECT f104 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare year not null  x;
    SELECT f105 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare year(3) not null  x;
    SELECT f106 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare year(4) not null  x;
    SELECT f107 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare enum("1enum", "2enum") not null  x;
    SELECT f108 into x from tb2 limit 9998, 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare set("1set", "2set") not nul x;
    SELECT f109 into x from tb2 limit 9998, 1;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.14:
              ----------------
Ensure that the handlers declared for a stored procedure (with the declare
statement) may only be defined in the correct order;
--source include/show_msg80.inc


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1337
CREATE PROCEDURE sp1()
BEGIN
   declare continue handler for sqlstate '23000' set @x2 = 1;
   declare x char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1337
CREATE PROCEDURE sp1()
BEGIN
   declare continue handler for sqlstate '23000' set @x2 = 1;
   declare x char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1337
CREATE PROCEDURE sp6( )
BEGIN
    declare cursor1 cursor for SELECT f1 from tb1;
    declare x char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1337
CREATE PROCEDURE sp6( )
BEGIN
    declare cursor1 cursor for SELECT f1 from tb1;
    declare sqlcondition condition for sqlstate '02000';
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1338
CREATE PROCEDURE sp6( )
BEGIN
    declare sqlcondition condition for sqlstate '02000';
    declare continue handler for sqlcondition set @x=1;
    declare cursor1 cursor for SELECT f1 from tb1;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.15:
              ----------------
Ensure that the declare statement can declare multiple variables both separately
and all at once from a variable list. (multiple declaration);
--source include/show_msg80.inc

#FIXME 4.2.15: switched off until bug is fixed:
#FIXME 4.2.15: Bug #14376 MySQL crash on scoped variable (re)initialization
delimiter //;
if (0)
{
   --disable_warnings
   DROP PROCEDURE IF EXISTS sp_14376//
   --enable_warnings
   #--error 4711
   CREATE PROCEDURE sp_14376()
   BEGIN
      DECLARE x1 CHAR(100) DEFAULT 'outer';
      BEGIN
         DECLARE x1 CHAR(100) DEFAULT x1;
      END;
   END//
   CALL sp_14376()//
   DROP PROCEDURE sp_14376()//
}
delimiter ;//


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings


delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z char default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z char ascii default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinytext default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z text default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumtext default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z longtext default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinyblob default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z blob default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumblob default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z longblob default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z binary default null;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinyint default -126;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinyint unsigned default 253;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinyint zerofill default -1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z tinyint unsigned zerofill default 1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z smallint default -32768;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z smallint unsigned default 65535;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z smallint zerofill default -1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z smallint unsigned zerofill default 1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumint default -8388608;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumint unsigned default 16777215;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumint zerofill default -1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z mediumint unsigned zerofill default 1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z int default -2147483648;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z int unsigned default 4294967295;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z int zerofill default -1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z int unsigned zerofill default 1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z bigint default -9223372036854775808;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z bigint unsigned default 18446744073709551615;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z bigint zerofill default -1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z bigint unsigned zerofill default 1;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

#FIXME check again with -3.402823466e+38
let $default_minus38= -34028234660123456789012345678901234567;

delimiter //;
eval CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z decimal default $default_minus38;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z decimal unsigned default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

#FIXME check again with -3.402823466e+38
delimiter //;
eval CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z decimal zerofill default $default_minus38;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z decimal unsigned zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z numeric default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z numeric unsigned default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z numeric zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z numeric unsigned zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed: default (10,0) for DECIMAL not checked

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z real default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z real unsigned default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z real zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z real unsigned zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z float default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z float unsigned default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z float zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z float unsigned zerofill default 1.175494351e-38;
    SELECT x, y, z;
END//
delimiter ;//

--replace_result e-038 e-38
CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z date default '2005-02-02';
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z time default '12:20:12';
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z datetime default '2005-02-02 12:20:12';
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z timestamp default '20050202122012';
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z year default 2005;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z year(3) default 2005;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z year(4) default 2005;
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z enum("1enum", "2enum") default "2enum";
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x, y, z set("1set", "2set") default "2set";
    SELECT x, y, z;
END//
delimiter ;//

CALL sp1();

# clean up
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.16:
              ----------------
Ensure that the declare statement can declare multiple variables both separately
and all at once from a variable list. (multiple declaration).;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6( )
BEGIN
   declare a, b char default '2';
   declare c, d float default 1.3;
   declare e, f text default 'text';
   declare g, h enum("value1", "value2" ) default 'value1';
   declare i, j datetime default '2005-02-02 12:12:12';
   declare k, l blob default 'blob';
   SELECT a, b, c, d, e, f, g, h, k, l;
END//
delimiter ;//

CALL sp6();

# clean up
DROP PROCEDURE sp6;

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.17:
              ----------------
Ensure that the invalid variable declarations are rejected, with an appropriate
error message.;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare @x char;
   SELECT f2 into x from t2 limit 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare add char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare all char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare alter char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare analyze char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare and char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare as char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare asc char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare asensitive char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare before char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare between char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare bigint char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare binary char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare blob char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare both char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare by char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare CALL char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare cascade char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare case char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare change char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare char char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare character char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare check char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare collate char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare column char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

#FIXME: check why _was_ this switched off
delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
   declare columns char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare condition char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare connection char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare constraint char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare continue char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare convert char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare create char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare cross char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare current_date char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare current_time char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare current_timestamp char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare current_user char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare cursor char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare database char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare databases char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare day_hour char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare day_microsecond char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare day_minute char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare day_second char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare dec char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare decimal char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare declare char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare default char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare delayed char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare delete char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare desc char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare describe char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare deterministic char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare distinct char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare distinctrow char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare div char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare double char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare drop char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare dual char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare each char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare else char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare elseif char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare enclosed char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare escaped char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare exists char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare exit char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare explain char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare false char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare fetch char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

#FIXME: check why _was_ this switched off
delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare fields char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare float char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare for char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare force char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare foreign char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

#FIXME: check why _was_ this switched off
delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare found char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare from char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare fulltext char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare goto char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare grant char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare group char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare having char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare high_priority char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare hour_microsecond char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare hour_minute char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare hour_second char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare if char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare ignore char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare in char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare index char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare infile char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare inner char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare inout char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare insensitive char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare insert char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare int char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare integer char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare interval char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare into char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare is char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare iterate char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare join char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare key char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare keys char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare kill char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare leading char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare leave char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare left char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare like char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare limit char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare lines char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare load char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare localtime char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare localtimestamp char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare lock char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare long char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare longblob char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare longtext char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare loop char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare low_priority char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare match char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare mediumblob char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare mediumint char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare mediumtext char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare middleint char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare minute_microsecond char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare minute_second char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare mod char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare modifies char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare natural char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare not char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare no_write_to_binlog char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare null char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare numeric char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare on char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare optimize char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare option char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare optionally char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare or char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare order char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare out char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare outer char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare outfile char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare precision char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare primary char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
   declare privileges char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare procedure char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare purge char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare read char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare reads char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare real char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare references char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare regexp char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare rename char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare repeat char;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare replace char;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
   declare require char;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare restrict char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare return char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare revoke char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare right char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare rlike char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare schema char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare schemas char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare second_microsecond char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare SELECT char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sensitive char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare separator char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare set char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare show char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare smallint char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare soname char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare spatial char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare specific char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sql char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sqlexception char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sqlstate char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sqlwarning char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sql_big_result char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sql_calc_found_rows char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare sql_small_result char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare ssl char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare starting char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare straight_join char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare table char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

#FIXME: check why _was_ this switched off
delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1()
BEGIN
   declare tables char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare terminated char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare then char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare tinyblob char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare tinyint char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare tinytext char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare to char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare trailing char;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare trigger char;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare true char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare undo char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare union char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare unique char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare unlock char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare unsigned char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare update char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare usage char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare USE char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare using char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare utc_date char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare utc_time char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare utc_timestamp char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare values char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare varbinary char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare varchar char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare varcharacter char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare varying char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare when char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare where char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare while char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare with char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare write char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare xor char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare year_month char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare zerofill char;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase :
              ----------
Ensure that every possible type of condition may be declared for a stored procedure
( covered in more detail in handlers section.);
--source include/show_msg80.inc

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
   declare cond1 condition for sqlstate 'HY000';

   declare cond2 condition for sqlstate '23000';

   declare cond3 condition for sqlstate 'HY001';

   declare cond4 condition for sqlstate '08004';

   declare cond5 condition for sqlstate '08S01';

   declare cond6 condition for sqlstate '42000';

   declare cond7 condition for sqlstate '28000';

   declare cond8 condition for sqlstate '3D000';

   declare cond9 condition for sqlstate '42S01';

   declare cond10 condition for sqlstate '42S02';

   declare cond11 condition for sqlstate '42S22';

   declare cond12 condition for sqlstate '21S01';

   declare cond13 condition for sqlstate '42S21';

   declare cond14 condition for sqlstate '42S12';

   declare cond15 condition for sqlstate '22004';

   declare cond16 condition for sqlstate '25000';

   declare cond17 condition for sqlstate '40001';

   declare cond18 condition for sqlstate '21000';

   declare cond19 condition for sqlstate '01000';

   declare cond20 condition for sqlstate '22003';

   declare cond21 condition for sqlstate '22007';

   declare cond22 condition for sqlstate '0A000';

   declare cond23 condition for sqlstate '70100';

   declare cond24 condition for sqlstate '2F005';

   declare cond25 condition for sqlstate '24000';

   declare cond26 condition for sqlstate '02000';

   declare continue handler for cond2 set @x2 = 1;

   declare continue handler for cond1 set @x2 = 1;

   declare continue handler for cond3 set @x2 = 1;

   declare continue handler for cond4 set @x2 = 1;

   declare continue handler for cond5 set @x2 = 1;

   declare continue handler for cond7 set @x2 = 1;

   declare continue handler for cond6 set @x2 = 1;

   declare continue handler for cond8 set @x2 = 1;

   declare continue handler for cond9 set @x2 = 1;

   declare continue handler for cond10 set @x2 = 1;

   declare continue handler for cond11 set @x2 = 1;

   declare continue handler for cond12 set @x2 = 1;

   declare continue handler for cond13 set @x2 = 1;

   declare continue handler for cond14 set @x2 = 1;

   declare continue handler for cond15 set @x2 = 1;

   declare continue handler for cond16 set @x2 = 1;

   declare continue handler for cond17 set @x2 = 1;

   declare continue handler for cond18 set @x2 = 1;

   declare continue handler for cond19 set @x2 = 1;

   declare continue handler for cond20 set @x2 = 1;

   declare continue handler for cond21 set @x2 = 1;

   declare continue handler for cond22 set @x2 = 1;

   declare continue handler for cond23 set @x2 = 1;

   declare continue handler for cond24 set @x2 = 1;

   declare continue handler for cond25 set @x2 = 1;

   declare continue handler for cond26 set @x2 = 1;


   set @x = 1;

   insert into t2 values (1);

   set @x = 2;

   insert into t2 values (1);

   set @x = 3;
END//
delimiter ;//

CALL sp1();

# clean up
DROP PROCEDURE sp1;

# testcase: ensure that invalid condition declarations are rejected, with an appropriate error message.


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare @x char;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare x char1;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare add condition for sqlstate '02000';
    declare exit handler for add set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare all condition for sqlstate '02000';
    declare exit handler for all set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare alter condition for sqlstate '02000';
    declare exit handler for alter set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare analyze condition for sqlstate '02000';
    declare exit handler for analyze set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare and condition for sqlstate '02000';
    declare exit handler for and set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare as condition for sqlstate '02000';
    declare exit handler for as set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare asc condition for sqlstate '02000';
    declare exit handler for asc set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare asensitive condition for sqlstate '02000';
    declare exit handler for asensitive set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare before condition for sqlstate '02000';
    declare exit handler for before set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare between condition for sqlstate '02000';
    declare exit handler for between set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint condition for sqlstate '02000';
    declare exit handler for bigint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare binary condition for sqlstate '02000';
    declare exit handler for binary set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare blob condition for sqlstate '02000';
    declare exit handler for blob set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare both condition for sqlstate '02000';
    declare exit handler for both set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare by condition for sqlstate '02000';
    declare exit handler for by set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare CALL condition for sqlstate '02000';
    declare exit handler for CALL set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cascade condition for sqlstate '02000';
    declare exit handler for cascade set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare case condition for sqlstate '02000';
    declare exit handler for case set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare change condition for sqlstate '02000';
    declare exit handler for change set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare char condition for sqlstate '02000';
    declare exit handler for char set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare character condition for sqlstate '02000';
    declare exit handler for character set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare check condition for sqlstate '02000';
    declare exit handler for check set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare collate condition for sqlstate '02000';
    declare exit handler for collate set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare column condition for sqlstate '02000';
    declare exit handler for column set @var2 = 1;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

#FIXME: check why this is switched off
#--error 1064
#delimiter //;
#CREATE PROCEDURE sp1( )
# BEGIN
#   declare columns condition for sqlstate '02000';
#   declare exit handler for columns set @var2 = 1;
#END//
#delimiter ;//
#DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare condition condition for sqlstate '02000';
    declare exit handler for condition set @var2 = 1;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare connection condition for sqlstate '02000';
    declare exit handler for connection set @var2 = 1;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare constraint condition for sqlstate '02000';
    declare exit handler for constraint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare continue condition for sqlstate '02000';
    declare exit handler for continue set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare convert condition for sqlstate '02000';
    declare exit handler for convert set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare create condition for sqlstate '02000';
    declare exit handler for create set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cross condition for sqlstate '02000';
    declare exit handler for cross set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_date condition for sqlstate '02000';
    declare exit handler for current_date set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_time condition for sqlstate '02000';
    declare exit handler for current_time set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_timestamp condition for sqlstate '02000';
    declare exit handler for current_timestamp set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_user condition for sqlstate '02000';
    declare exit handler for current_user set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cursor condition for sqlstate '02000';
    declare exit handler for cursor set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare database condition for sqlstate '02000';
    declare exit handler for database set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare databases condition for sqlstate '02000';
    declare exit handler for databases set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_hour condition for sqlstate '02000';
    declare exit handler for day_hour set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_microsecond condition for sqlstate '02000';
    declare exit handler for day_microsecond set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_minute condition for sqlstate '02000';
    declare exit handler for day_minute set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_second condition for sqlstate '02000';
    declare exit handler for day_second set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare dec condition for sqlstate '02000';
    declare exit handler for dec set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal condition for sqlstate '02000';
    declare exit handler for decimal set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare declare condition for sqlstate '02000';
    declare exit handler for declare set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare default condition for sqlstate '02000';
    declare exit handler for default set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare delayed condition for sqlstate '02000';
    declare exit handler for delayed set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare delete condition for sqlstate '02000';
    declare exit handler for delete set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare desc condition for sqlstate '02000';
    declare exit handler for desc set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare describe condition for sqlstate '02000';
    declare exit handler for describe set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare deterministic condition for sqlstate '02000';
    declare exit handler for deterministic set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare distinct condition for sqlstate '02000';
    declare exit handler for distinct set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare distinctrow condition for sqlstate '02000';
    declare exit handler for distinctrow set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare div condition for sqlstate '02000';
    declare exit handler for div set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double condition for sqlstate '02000';
    declare exit handler for double set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare drop condition for sqlstate '02000';
    declare exit handler for drop set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare dual condition for sqlstate '02000';
    declare exit handler for dual set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare each condition for sqlstate '02000';
    declare exit handler for each set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare else condition for sqlstate '02000';
    declare exit handler for else set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare elseif condition for sqlstate '02000';
    declare exit handler for elseif set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare enclosed condition for sqlstate '02000';
    declare exit handler for enclosed set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare escaped condition for sqlstate '02000';
    declare exit handler for escaped set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare exists condition for sqlstate '02000';
    declare exit handler for exists set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare exit condition for sqlstate '02000';
    declare exit handler for exit set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare explain condition for sqlstate '02000';
    declare exit handler for explain set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare false condition for sqlstate '02000';
    declare exit handler for false set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare fetch condition for sqlstate '02000';
    declare exit handler for fetch set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1( )
 BEGIN
   declare fields condition for sqlstate '02000';
   declare exit handler for fields set @var2 = 1;
END//
delimiter ;//
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float condition for sqlstate '02000';
    declare exit handler for float set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare for condition for sqlstate '02000';
    declare exit handler for for set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare force condition for sqlstate '02000';
    declare exit handler for force set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare foreign condition for sqlstate '02000';
    declare exit handler for foreign set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME: check why _was_ this switched off
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare found condition for sqlstate '02000';
   declare exit handler for found set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare from condition for sqlstate '02000';
    declare exit handler for from set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare fulltext condition for sqlstate '02000';
    declare exit handler for fulltext set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare goto condition for sqlstate '02000';
    declare exit handler for goto set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare grant condition for sqlstate '02000';
    declare exit handler for grant set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare group condition for sqlstate '02000';
    declare exit handler for group set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare having condition for sqlstate '02000';
    declare exit handler for having set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare high_priority condition for sqlstate '02000';
    declare exit handler for high_priority set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_microsecond condition for sqlstate '02000';
    declare exit handler for hour_microsecond set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_minute condition for sqlstate '02000';
    declare exit handler for hour_minute set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_second condition for sqlstate '02000';
    declare exit handler for hour_second set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare if condition for sqlstate '02000';
    declare exit handler for if set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare ignore condition for sqlstate '02000';
    declare exit handler for ignore set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare in condition for sqlstate '02000';
    declare exit handler for in set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare index condition for sqlstate '02000';
    declare exit handler for index set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare infile condition for sqlstate '02000';
    declare exit handler for infile set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare inner condition for sqlstate '02000';
    declare exit handler for inner set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare inout condition for sqlstate '02000';
    declare exit handler for inout set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare insensitive condition for sqlstate '02000';
    declare exit handler for insensitive set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare insert condition for sqlstate '02000';
    declare exit handler for insert set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int condition for sqlstate '02000';
    declare exit handler for int set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare integer condition for sqlstate '02000';
    declare exit handler for integer set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare interval condition for sqlstate '02000';
    declare exit handler for interval set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare into condition for sqlstate '02000';
    declare exit handler for into set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare is condition for sqlstate '02000';
    declare exit handler for is set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare iterate condition for sqlstate '02000';
    declare exit handler for iterate set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare join condition for sqlstate '02000';
    declare exit handler for join set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare key condition for sqlstate '02000';
    declare exit handler for key set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare keys condition for sqlstate '02000';
    declare exit handler for keys set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare kill condition for sqlstate '02000';
    declare exit handler for kill set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare leading condition for sqlstate '02000';
    declare exit handler for leading set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare leave condition for sqlstate '02000';
    declare exit handler for leave set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare left condition for sqlstate '02000';
    declare exit handler for left set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare like condition for sqlstate '02000';
    declare exit handler for like set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare limit condition for sqlstate '02000';
    declare exit handler for limit set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare lines condition for sqlstate '02000';
    declare exit handler for lines set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare load condition for sqlstate '02000';
    declare exit handler for load set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare localtime condition for sqlstate '02000';
    declare exit handler for localtime set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare localtimestamp condition for sqlstate '02000';
    declare exit handler for localtimestamp set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare lock condition for sqlstate '02000';
    declare exit handler for lock set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare long condition for sqlstate '02000';
    declare exit handler for long set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longblob condition for sqlstate '02000';
    declare exit handler for longblob set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longtext condition for sqlstate '02000';
    declare exit handler for longtext set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare loop condition for sqlstate '02000';
    declare exit handler for loop set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare low_priority condition for sqlstate '02000';
    declare exit handler for low_priority set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare match condition for sqlstate '02000';
    declare exit handler for match set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumblob condition for sqlstate '02000';
    declare exit handler for mediumblob set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint condition for sqlstate '02000';
    declare exit handler for mediumint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumtext condition for sqlstate '02000';
    declare exit handler for mediumtext set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare middleint condition for sqlstate '02000';
    declare exit handler for middleint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare minute_microsecond condition for sqlstate '02000';
    declare exit handler for minute_microsecond set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare minute_second condition for sqlstate '02000';
    declare exit handler for minute_second set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mod condition for sqlstate '02000';
    declare exit handler for mod set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare modifies condition for sqlstate '02000';
    declare exit handler for modifies set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare natural condition for sqlstate '02000';
    declare exit handler for natural set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare not condition for sqlstate '02000';
    declare exit handler for not set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare no_write_to_binlog condition for sqlstate '02000';
    declare exit handler for no_write_to_binlog set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare null condition for sqlstate '02000';
    declare exit handler for null set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric condition for sqlstate '02000';
    declare exit handler for numeric set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare on condition for sqlstate '02000';
    declare exit handler for on set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare optimize condition for sqlstate '02000';
    declare exit handler for optimize set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare option condition for sqlstate '02000';
    declare exit handler for option set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare optionally condition for sqlstate '02000';
    declare exit handler for optionally set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare or condition for sqlstate '02000';
    declare exit handler for or set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare order condition for sqlstate '02000';
    declare exit handler for order set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare out condition for sqlstate '02000';
    declare exit handler for out set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare outer condition for sqlstate '02000';
    declare exit handler for outer set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare outfile condition for sqlstate '02000';
    declare exit handler for outfile set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare precision condition for sqlstate '02000';
    declare exit handler for precision set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare primary condition for sqlstate '02000';
    declare exit handler for primary set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME: why was this switched off ?
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare privileges condition for sqlstate '02000';
   declare exit handler for privileges set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare procedure condition for sqlstate '02000';
    declare exit handler for procedure set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare purge condition for sqlstate '02000';
    declare exit handler for purge set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare read condition for sqlstate '02000';
    declare exit handler for read set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare reads condition for sqlstate '02000';
    declare exit handler for reads set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real condition for sqlstate '02000';
    declare exit handler for real set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare references condition for sqlstate '02000';
    declare exit handler for references set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare regexp condition for sqlstate '02000';
    declare exit handler for regexp set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare rename condition for sqlstate '02000';
    declare exit handler for rename set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare repeat condition for sqlstate '02000';
    declare exit handler for repeat set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare replace condition for sqlstate '02000';
    declare exit handler for replace set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare require condition for sqlstate '02000';
    declare exit handler for require set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare restrict condition for sqlstate '02000';
    declare exit handler for restrict set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare return condition for sqlstate '02000';
    declare exit handler for return set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare revoke condition for sqlstate '02000';
    declare exit handler for revoke set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare right condition for sqlstate '02000';
    declare exit handler for right set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare rlike condition for sqlstate '02000';
    declare exit handler for rlike set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare schema condition for sqlstate '02000';
    declare exit handler for schema set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare schemas condition for sqlstate '02000';
    declare exit handler for schemas set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare second_microsecond condition for sqlstate '02000';
    declare exit handler for second_microsecond set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare SELECT condition for sqlstate '02000';
    declare exit handler for SELECT set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sensitive condition for sqlstate '02000';
    declare exit handler for sensitive set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare separator condition for sqlstate '02000';
    declare exit handler for separator set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare set condition for sqlstate '02000';
    declare exit handler for set set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare show condition for sqlstate '02000';
    declare exit handler for show set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint condition for sqlstate '02000';
    declare exit handler for smallint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare soname condition for sqlstate '02000';
    declare exit handler for soname set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare spatial condition for sqlstate '02000';
    declare exit handler for spatial set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare specific condition for sqlstate '02000';
    declare exit handler for specific set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql condition for sqlstate '02000';
    declare exit handler for sql set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlexception condition for sqlstate '02000';
    declare exit handler for sqlexception set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlstate condition for sqlstate '02000';
    declare exit handler for sqlstate set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlwarning condition for sqlstate '02000';
    declare exit handler for sqlwarning set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_big_result condition for sqlstate '02000';
    declare exit handler for sql_big_result set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_calc_found_rows condition for sqlstate '02000';
    declare exit handler for sql_calc_found_rows set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_small_result condition for sqlstate '02000';
    declare exit handler for sql_small_result set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare ssl condition for sqlstate '02000';
    declare exit handler for ssl set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare starting condition for sqlstate '02000';
    declare exit handler for starting set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare straight_join condition for sqlstate '02000';
    declare exit handler for straight_join set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare table condition for sqlstate '02000';
    declare exit handler for table set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
#FIXME: why was this switched off ?
#FIXME check this is OK:--error 1064
CREATE PROCEDURE sp1( )
BEGIN
   declare tables condition for sqlstate '02000';
   declare exit handler for tables set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare terminated condition for sqlstate '02000';
    declare exit handler for terminated set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare then condition for sqlstate '02000';
    declare exit handler for then set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyblob condition for sqlstate '02000';
    declare exit handler for tinyblob set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint condition for sqlstate '02000';
    declare exit handler for tinyint set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinytext condition for sqlstate '02000';
    declare exit handler for tinytext set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare to condition for sqlstate '02000';
    declare exit handler for to set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare trailing condition for sqlstate '02000';
    declare exit handler for trailing set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare trigger condition for sqlstate '02000';
    declare exit handler for trigger set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare true condition for sqlstate '02000';
    declare exit handler for true set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare undo condition for sqlstate '02000';
    declare exit handler for undo set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare union condition for sqlstate '02000';
    declare exit handler for union set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unique condition for sqlstate '02000';
    declare exit handler for unique set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unlock condition for sqlstate '02000';
    declare exit handler for unlock set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unsigned condition for sqlstate '02000';
    declare exit handler for unsigned set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare update condition for sqlstate '02000';
    declare exit handler for update set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare usage condition for sqlstate '02000';
    declare exit handler for usage set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare USE condition for sqlstate '02000';
    declare exit handler for USE set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare using condition for sqlstate '02000';
    declare exit handler for using set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_date condition for sqlstate '02000';
    declare exit handler for utc_date set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_time condition for sqlstate '02000';
    declare exit handler for utc_time set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_timestamp condition for sqlstate '02000';
    declare exit handler for utc_timestamp set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare values condition for sqlstate '02000';
    declare exit handler for values set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varbinary condition for sqlstate '02000';
    declare exit handler for varbinary set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varchar condition for sqlstate '02000';
    declare exit handler for varchar set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varcharacter condition for sqlstate '02000';
    declare exit handler for varcharacter set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varying condition for sqlstate '02000';
    declare exit handler for varying set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare when condition for sqlstate '02000';
    declare exit handler for when set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare where condition for sqlstate '02000';
    declare exit handler for where set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare while condition for sqlstate '02000';
    declare exit handler for while set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare with condition for sqlstate '02000';
    declare exit handler for with set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare write condition for sqlstate '02000';
    declare exit handler for write set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare xor condition for sqlstate '02000';
    declare exit handler for xor set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare year_month condition for sqlstate '02000';
    declare exit handler for year_month set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare zerofill condition for sqlstate '02000';
    declare exit handler for zerofill set @var2 = 1;
END//
delimiter ;//

# ------------------------------------------------------------------------------
let $message= Testcase :
              ----------
Ensure that every possible type of handler may be declared for
a stored procedure (continue- handler_type ).;
--source include/show_msg80.inc

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '23000' set @x2 = 1;

    set @x = 1;

    insert into t2(f1) values (1);

    set @x = 2;

    insert into t2(f1) values (1);

    set @x = 3;
END//
delimiter ;//

CALL sp1();

# cleanup

DROP PROCEDURE sp1;


# testcase: ensure that every possible type of handler may be declared
#            for a stored procedure (undo - handler_type ).
# ?????????? undo handler not supported as of now


DROP PROCEDURE IF EXISTS handler1;

delimiter //;
--error 1064
CREATE PROCEDURE handler1()
BEGIN
    declare undo handler for sqlstate '23000' set @x2 = 1;

    set @x = 1;

    insert into t values (1);

    set @x = 2;

    insert into t values (1);

    set @x = 3;
END//
delimiter ;//

# testcase: ensure that invalid handler declarations are rejected with an
#            appropriate error message. (continue- handler_type).


DROP PROCEDURE IF EXISTS handler1;

delimiter //;
--error 1064
CREATE PROCEDURE handler1()
BEGIN
    declare continueinv handler for sqlstate '2300' set @x2 = 1;

    set @x = 1;

    insert into t values (1);

    set @x = 2;

    insert into t values (1);

    set @x = 3;
END//
delimiter ;//

# testcase: ensure that invalid handler declarations are rejected with
#            an appropriate error message (undo - handler_type ).


DROP PROCEDURE IF EXISTS handler1;

delimiter //;
--error 1064
CREATE PROCEDURE handler1()
BEGIN
    declare undoinv handler for sqlstate '2300' set @x2 = 1;

    set @x = 1;

    insert into t values (1);

    set @x = 2;

    insert into t values (1);

    set @x = 3;
END//
delimiter ;//

# testcase: ensure that invalid handler declarations are rejected with an
#            appropriate error message (exit- handler_type )


DROP PROCEDURE IF EXISTS handler1;

delimiter //;
--error 1064
CREATE PROCEDURE handler1 ()
BEGIN
    declare exitinv handler for sqlstate '2300' set @x2 = 1;

    set @x = 1;

    insert into t values (1);

    set @x = 2;

    insert into t values (1);

    set @x = 3;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare add handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare all handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare alter handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare analyze handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare and handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare as handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare asc handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare asensitive handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare before handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare between handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare bigint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare binary handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare blob handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare both handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare by handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare CALL handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cascade handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare case handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare change handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare char handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare character handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare check handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare collate handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare column handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare columns handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare condition handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare connection handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare constraint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

#FIXME: check why this is switched off
#--error 1064
#delimiter //;
#CREATE PROCEDURE sp1( )
# BEGIN
#   declare continue handler for sqlstate '02000' set @var2 = 1;
#END//
#delimiter ;//
#DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare convert handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare create handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cross handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_date handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_time handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_timestamp handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare current_user handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare cursor handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare database handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare databases handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_hour handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_microsecond handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_minute handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare day_second handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare dec handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare decimal handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare declare handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare default handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare delayed handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare delete handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare desc handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare describe handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare deterministic handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare distinct handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare distinctrow handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare div handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare double handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare drop handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare dual handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare each handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare else handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare elseif handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare enclosed handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare escaped handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare exists handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

#FIXME: check why this is switched off
#--error 1064
#delimiter //;
#CREATE PROCEDURE sp1( )
# BEGIN
#   declare exit handler for sqlstate '02000' set @var2 = 1;
#END//
#delimiter ;//
#DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare explain handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare false handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare fetch handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare fields handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare float handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare for handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare force handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare foreign handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare found handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare from handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare fulltext handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare goto handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare grant handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare group handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare having handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare high_priority handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_microsecond handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_minute handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare hour_second handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare if handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare ignore handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare in handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare index handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare infile handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare inner handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare inout handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare insensitive handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare insert handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare int handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare integer handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare interval handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare into handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare is handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare iterate handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare join handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare key handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare keys handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare kill handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare leading handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare leave handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare left handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare like handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare limit handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare lines handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare load handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare localtime handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare localtimestamp handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare lock handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare long handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longblob handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare longtext handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare loop handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare low_priority handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare match handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumblob handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mediumtext handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare middleint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare minute_microsecond handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare minute_second handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare mod handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare modifies handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare natural handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare not handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare no_write_to_binlog handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare null handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare numeric handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare on handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare optimize handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare option handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare optionally handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare or handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare order handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare out handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare outer handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare outfile handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare precision handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare primary handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare privileges handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare procedure handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare purge handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare read handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare reads handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare real handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare references handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare regexp handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare rename handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare repeat handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare replace handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare require handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare restrict handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare return handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare revoke handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare right handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare rlike handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare schema handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare schemas handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare second_microsecond handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare SELECT handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sensitive handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare separator handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare set handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare show handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare smallint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare soname handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare spatial handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare specific handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlexception handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlstate handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sqlwarning handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_big_result handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_calc_found_rows handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare sql_small_result handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare ssl handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare starting handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare straight_join handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare table handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tables handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare terminated handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare then handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyblob handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinyint handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare tinytext handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare to handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare trailing handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare trigger handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare true handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare undo handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare union handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unique handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unlock handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare unsigned handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare update handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare usage handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare USE handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare using handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_date handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_time handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare utc_timestamp handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare values handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varbinary handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varchar handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varcharacter handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare varying handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare when handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare where handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare while handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare with handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare write handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare xor handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare year_month handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1064
CREATE PROCEDURE sp1( )
BEGIN
    declare zerofill handler for sqlstate '02000' set @var2 = 1;
END//
delimiter ;//


# ==============================================================================
#
# test plan section: 4.2 - syntax checks for programming statements - 2
#
# ==============================================================================


USE db_storedproc;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.26:;
--source include/show_msg80.inc

# testcase: ensure that the scope of every variable, cursor, condition and handler
#            declared for a stored procedure (with the declare statement) is properly applied.


set @v1='0';
set @v2='0';
--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x char;
    declare y char;
    declare cond1 condition for sqlstate '42000';
    declare cur1 cursor for SELECT f1 from t2 limit 1;
    declare continue handler for cond1 set @x = 4;
    set @x = '1';
    set @y = '2';
    BEGIN
      declare x char;
      declare y char;
      declare cur1 cursor for SELECT f1 from t2 limit 2, 1;
      declare continue handler for sqlstate '42000' set @x = 3;
      open cur1;
      fetch cur1 into y;
      close cur1;
    CALL nonsexist();
      SELECT x, y, @x;
    END;
    open cur1;
    fetch cur1 into y;
    close cur1;
  CALL nonsexist();
    set @v1 = @x;
    set @v2 = y;
END//
delimiter ;//

CALL sp1();
  SELECT @v1, @v2;

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.28:;
--source include/show_msg80.inc

# testcase: ensure that the set statement can assign a value to every local variable
#            declared within a stored procedures definition, as well as to every
#            appropriate global server variable.

set @x=0;
set @y=0;
DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
   declare continue handler for sqlstate '42000' set @x2 = 1;
   set session sort_buffer_size = 10 * 1024 * 1024;
   SELECT @@sort_buffer_size;
   set @x = 4;
   set @y = 3;
   set global sort_buffer_size = 2 * 1024 * 1024;
   SELECT @@sort_buffer_size;
   set @@sort_buffer_size = 10 * 1024 * 1024;
   SELECT @@sort_buffer_size;
END//
delimiter ;//
CALL sp1();
SELECT @x, @y;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.29:;
--source include/show_msg80.inc

# testcase: ensure that the set statement can assign values to variables either
#            separately or multiple variables in a list.


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx char default 'x';
    declare xy char default 'y';
    declare xz char default 'z';
    set @xx = xx, @xy = xy;
    set @xz = xz;
    SELECT @xx, @xy, @xz;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.30:;
--source include/show_msg80.inc

# testcase: ensure that the set statement may assign only those values to a variable
#            that are appropriate for that variables data type definition

# integer data_type.

  set @xx=0;

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx int;
    set xx = 'asd';
    set @xx = xx;
    SELECT @xx;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx int;
    set xx = 5;
    set @xx = xx;
    SELECT @xx;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.31 - a:;
--source include/show_msg80.inc

# character data_type

  set @xx=0;

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx char;
    set xx = 'temp';
    set @xx = xx;
END//
delimiter ;//

CALL sp1();

  SELECT @xx;

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.31 - b:;
--source include/show_msg80.inc

# float data_type

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx float;
    set xx = 'asd';
    SELECT xx;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx float;
    set xx = 1.6;
    SELECT xx;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.31 - c:;
--source include/show_msg80.inc

# datetime data_type

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx datetime;
    set xx = 'asd';
    SELECT xx;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx datetime;
    set xx = '2006-06-06 01:01:01';
    SELECT xx;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.31 - d:;
--source include/show_msg80.inc

# varchar data_type

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx varchar(20);
    set xx = "abcdefghijk";
    SELECT xx;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.31 - e:;
--source include/show_msg80.inc

# tinyint

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx tinyint;
    set xx = 'asd';
    SELECT xx;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare xx tinyint;
    set xx = -125;
    SELECT xx;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.37:;
--source include/show_msg80.inc

# testcase: ensure that the SELECT  into statement that retrieves column values
#            with inappropriate data types for the matching variables in its variable
#            list is rejected, with an appropriate error message.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare x integer; declare y integer;
    SELECT sal, f2 into x, y from t2 limit 1;
    set @x=x; set @y=y;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x char ascii;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinytext;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x text;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumtext;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x longtext;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinyblob;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x blob;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumblob;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x longblob;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x binary;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinyint;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinyint unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinyint zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x tinyint unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x smallint;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x smallint unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x smallint zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x smallint unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumint;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumint unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;
delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumint zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x mediumint unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x int;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x int unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x int zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x int unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x bigint;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x bigint unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x bigint zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x bigint unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x decimal;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x decimal unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x decimal zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x decimal unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x numeric;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x numeric unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x numeric zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x numeric unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x real;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x real unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x real zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x real unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x float;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x float unsigned;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x float zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x float unsigned zerofill;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x date;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x time;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x datetime;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x timestamp;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x year;
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x year(3);
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x year(4);
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x enum("1enum", "2enum");
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare x set("1set", "2set");
    SELECT f1 into x from t2 limit 1;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.38:;
--source include/show_msg80.inc

# testcase: ensure that the declare condition for statement can declare a properly
#            named condition for every possible sqlstate and mysql-specific error code.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare notable condition for sqlstate '42S02';
    declare continue handler for notable set @x2=1;
    set @x = 1;
    insert into t2(f1) values (1);
    set @x = 2;
    insert into t2(f1) values (1);
    set @x = 3;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.39:;
--source include/show_msg80.inc

# testcase: ensure that no two conditions declared with the same scope may have the
#            same condition name (same condition name in same scope)

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1332
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '42000';
    declare cond1 condition for sqlstate '23000';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values(1);
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.41:;
--source include/show_msg80.inc

# testcase: ensure that every sqlstate value declared with a declare  condition for
#            statement is a character string that is 5 character.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '1';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '12';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '123';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '1234';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '123456';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.42:;
--source include/show_msg80.inc

# testcase: ensure that the declare  condition for statement cannot declare a
#            condition for an invalid sqlstate. (bug associated) (Bug#8760)


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate 'abcdefghi';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '42000test';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '00000@#$%^&';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate 'null';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate ' ';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate 1234567890;
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '2005-03-03';
    declare continue handler for cond1 set @var2 = 1;
    insert into tnull values( 1);
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.43:;
--source include/show_msg80.inc

# testcase: ensure that the declare  condition for statement cannot declare a
#            condition for the successful completion sqlstate: 00000. (bug associated)

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare cond1 condition for sqlstate '00000';
    declare continue handler for cond1 set @var2 = 1;
    set @x=1;
    SELECT @var2;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.45:;
--source include/show_msg80.inc

# testcase: ensure that within the same scope, no two handlers may be declared for the same condition.


--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1413
CREATE PROCEDURE handler1 ()
BEGIN
      declare continue handler for sqlstate '23000' set @varr1 = 5;
        declare continue handler for sqlstate '23000' set @varr3 = 7;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS handler1;

delimiter //;
--error 1413
CREATE PROCEDURE handler1 ()
BEGIN
      declare mycondition condition for sqlstate '23000';
    declare continue handler for mycondition set @varr3 = 7;
        declare continue handler for sqlstate '23000' set @varr3 = 7;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.46:;
--source include/show_msg80.inc

# testcase: ensure that every sqlstate value declared with a declare  handler for
#            statement is a character string that is 5 characters long (bug associated).

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '1' set @var2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '12' set @var2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '123' set @var2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '1234' set @var2 = 1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '123456' set @var2 = 1;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.47:;
--source include/show_msg80.inc

# testcase: ensure that the declare  handler for statement cannot declare a condition
#            for an invalid sqlstate. (bug associated)

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1407
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '42s0200test'  set @var2 = 1;
    insert into tnull values( 1);
          SELECT @var2;
END//
delimiter ;//

# cleanup
#drop table IF EXISTS tnull;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.48:;
--source include/show_msg80.inc

# testcase: ensure that the declare  handler for statement cannot declare a condition
#            for the successful completion sqlstate:  00000. (bug associated)

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare continue handler for sqlstate '00000'  set @var2 = 1;
    set @x=1;
          SELECT @var2;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.52:;
--source include/show_msg80.inc

# testcase: ensure that no two cursors in a stored procedure can have the same name.

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1333
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
    declare cur1 cursor for SELECT f1, f2 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newlf1, newf3, newsal;
        set count = count - 1;
            END while;
            close cur1;
    END;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.53:;
--source include/show_msg80.inc

# testcase: ensure that a cursor declaration may not include a SELECT  into statement.

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1323
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, lf1, f3, f4 into @w, @x, @y, @z from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newlf1, newf3, newsal;
        set count = count - 1;
            END while;
            close cur1;
        END;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.54:;
--source include/show_msg80.inc

# testcase: ensure that a cursor declaration that includes an order by
#            claUSE may not be an updateable cursor.

#FIXME: testcase empty / missing

# ------------------------------------------------------------------------------
let $message= Testcase 4.2.55:;
--source include/show_msg80.inc

# testcase: ensure that open <cursor name> fails unless a cursor with
#            the same name has already been declared.

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
--error 1324
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
            while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      close cur1;
    END;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 0;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      BEGIN
        open cur1;
        set count = count - 1;
        while count <> 0 do
          fetch cur1 into newf1, newf2, newf3, newf4;
          set count = count - 1;
        END while;
      END;
      close cur1;
    END;
END//
delimiter ;//

#suppressed (Bug# 8892)
--error 1325
CALL sp1();


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.56:;
--source include/show_msg80.inc

# testcase: ensure that open <cursor name> fails if the same cursor is currently already open.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      close cur1;
    END;
END//
delimiter ;//

--error 1325
CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.57:;
--source include/show_msg80.inc

# testcase: ensure that fetch <cursor name> fails unless a cursor with the same name is already open.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2;
    declare cur2 cursor for SELECT f1, f2 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur2;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      close cur1;
    END;
END//
delimiter ;//

--error 1326
CALL sp1();

# cleanup
DROP PROCEDURE sp1;






# ------------------------------------------------------------------------------
let $message= Testcase 4.2.59:;
--source include/show_msg80.inc

# testcase: ensure that fetch <cursor name> fails with an appropriate error message
#            if it is executed before the cursor has been opened.


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      open cur1;
      close cur1;
    END;
END//
delimiter ;//

--error 1326
CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 0;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    BEGIN
      declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf3, newf4;
        set count = count - 1;
      END while;
      open cur1;
      close cur1;
          END;
    close cur1;
END//
delimiter ;//

--error 1326
CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.60:;
--source include/show_msg80.inc

# testcase: ensure that fetch <cursor name> fails with an appropriate error message
#            if it is executed after the cursor has been closed.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      close cur1;
      set count = count - 1;
          while count <> 0 do
          fetch cur1 into newf1, newf2, newf4, newf3;
              set count = count - 1;
      END while;
        END;
END//
delimiter ;//

--error 1326
CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 0;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    close cur1;
    BEGIN
      declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
      open cur1;
      END;
    fetch cur1 into newf1, newf2, newf3, newf4;
END//
delimiter ;//

--error 1326
CALL sp1();

# cleanup
DROP PROCEDURE sp1;




# ------------------------------------------------------------------------------
let $message= Testcase 4.2.62:;
--source include/show_msg80.inc

# testcase: ensure that fetch <cursor name> fails with an appropriate error message
#            if the data type of the column values being fetched are not appropriate
#            for the matching fetch variables to which the data is being assigned.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf2 char(20);
    declare newf1 date;
    declare cur1 cursor for SELECT f1, f3 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2;
        set @x = newf1;
        set @y = newf2;
        SELECT @x, @y;
        set count = count - 1;
          END while;
      close cur1;
    END;
END//
delimiter ;//

#FIXME check that here NO error occurs: suppressed for bug (Bug# 8702)
#--error 1146
CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.63:;
--source include/show_msg80.inc

# testcase: ensure that close <cursor name> fails unless a cursor with the same name is already open.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      close cur1;
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      close cur1;
    END;
END//
delimiter ;//

--error 1326
CALL sp1();

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 0;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      declare cur1 cursor for SELECT f1, f2, f3, f4 from t2;
      open cur1;
    END;
    close cur1;
END//
delimiter ;//

--error 1326
CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.64:;
--source include/show_msg80.inc

# testcase: ensure that all cursors are closed when a transaction terminates with a commit statement.

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
      BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    BEGIN
      open cur1;
      start transaction;
      fetch cur1 into newf1, newf2, newf4, newf3;
      commit;
      fetch cur1 into newf1, newf2, newf4, newf3;
    END;
END//
delimiter ;//

#FIXME check this error, in 5.0.11 the error occurs. Is this wanted?
# suppressed for bug (Bug#8756)
--error 1329
CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.65:;
--source include/show_msg80.inc

# testcase: ensure that all cursors are closed when a transaction terminates with a rollback statement.


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    BEGIN
      open cur1;
      fetch cur1 into newf1, newf2, newf4, newf3;
      rollback;
      fetch cur1 into newf1, newf2, newf4, newf3;
      commit;
    END;
END//
delimiter ;//

#FIXME check this error, in 5.0.11 the error occurs. Is this wanted?
##suppressed for bug (Bug#8756)
--error 1329
CALL sp1();

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.2.66:;
--source include/show_msg80.inc

# testcase: ensure that the result set of the cursor that has been closed is not
#            longer available to the fetch statement.


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
      close cur1;
      fetch cur1 into newf1, newf2, newf4, newf3;
    END;
END//
delimiter ;//

--error 1326
CALL sp1();

# cleanup
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.2.67:;
--source include/show_msg80.inc

# testcase: ensure that cursor declared within a compound statement is closed when
#            that compound statement ends (without cursor close statement)


DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 20, 10;
    declare continue handler for sqlstate '02000' set done = 1;
    BEGIN
      open cur1;
      set count = count - 1;
      while count <> 0 do
        fetch cur1 into newf1, newf2, newf4, newf3;
        set count = count - 1;
      END while;
    END;
END//
delimiter ;//

CALL sp1();

# cleanup
DROP PROCEDURE sp1;






# ------------------------------------------------------------------------------
let $message= Testcase 4.2.70:;
--source include/show_msg80.inc

# testcase: ensure that multiple cursors, nested within multiple compound statements
#            within a stored procedure always act correctly and return the expected result.

  create table temp1( f1 char(20), f2 char(20), f3 int, f4 char(20) );
  create table temp2( f1 char(20), f2 char(20), f3 int, f4 char(20) );

DROP PROCEDURE IF EXISTS sp1;

delimiter //;
CREATE PROCEDURE sp1( )
BEGIN
    declare done int default 0;
    declare count integer default 20;
    declare newf1 char(20);
    declare newf2 char(20);
    declare newf3 char(20);
    declare newf4 integer;
    declare newf21 char(20);
    declare newf22 char(20);
    declare newf23 char(20);
    declare newf24 integer;
    declare cur1 cursor for SELECT f1, f2, f4, f5 from t2 limit 7, 1;
    declare cur2 cursor for SELECT f1, f2, f4, f5 from t2 limit 15, 1;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    BEGIN
      set count = 10;
      BEGIN
        open cur2;
        while count <> 0 do
          fetch cur1 into newf1, newf2, newf4, newf3;
          set count = count - 1;
        END while;
      END;
      insert into temp1 values(newf1, newf2, newf4, newf3);
      close cur1;
    END;
    BEGIN
      while count <> 0 do
        fetch cur2 into newf21, newf22, newf24, newf23;
        set count = count - 1;
      END while;
    END;
    insert into temp2 values(newf21, newf22, newf24, newf23);
    close cur2;
END//
delimiter ;//

CALL sp1();

SELECT * from temp1;
SELECT * from temp2;

# cleanup
DROP PROCEDURE sp1;
drop table temp1;
drop table temp2;


# ==============================================================================
let $message= Section 3.1.3 - Syntax checks for the stored procedure-specific flow control statements
              .               IF, CASE, LOOP, LEAVE, ITERATE, REPEAT, WHILE:;
--source include/show_msg80.inc

USE db_storedproc;

# ------------------------------------------------------------------------------
let $message= Testcase 4.3.1:;
--source include/show_msg80.inc

# testcase : ensure that all clauses that should be supported are supported

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
--enable_warnings

#FIXME: change back to $engine_type for INNODB and MYISAM, but MEMORY doesn't support this
eval CREATE TABLE res_t3_itisalongname_1381742_itsaverylongname_1381742(
         middleinitial CHAR,
         lastname VARCHAR(50),
         age_averylongfieldname_averylongname_1234569 int,
         COMMENT TEXT) ENGINE=innodb;
#        COMMENT TEXT) ENGINE=$engine_type;

INSERT INTO res_t3_itisalongname_1381742_itsaverylongname_1381742
      VALUES('a', 'aaaaaaaaaabbbbbbbbc', 0, 'default');

delimiter //;
CREATE PROCEDURE sp1(a int)
BEGIN
  declare itisjustaverylargevariablename_xxxxxxxxxxxxxxxxxxxxx char;
  declare itisjustaverylargevarcharvariablename_xxxxxxxxxxxxxxxxxxxxx varchar(100);
  declare itisjustamediumsizeintintegervariablename integer;
  set itisjustaverylargevariablename_xxxxxxxxxxxxxxxxxxxxx = 'b';
  set itisjustaverylargevarcharvariablename_xxxxxxxxxxxxxxxxxxxxx = 'oldmacdonalds)(*&(^^%$&^%$&^%*^)(*^#@$@%';
  set itisjustamediumsizeintintegervariablename = 5;
  set @comment='a';
  label1: loop
    if a>100 then
      set @comment='value of a is greater than 100';
    elseif a<100 then
      if a<50 then
        set @comment='value of a is less than 50';
      elseif a<25 then
        set @comment='value of a is less than 25';
    else
      set @comment='value of a is greater than 50 and less than 100';
    END if;
  else
    set @comment='value of a is 100';
  END if;

  if itisjustamediumsizeintintegervariablename = 0 then leave label1;
  END if;
  insert into res_t3_itisalongname_1381742_itsaverylongname_1381742
     values( itisjustaverylargevariablename_xxxxxxxxxxxxxxxxxxxxx,
        concat(itisjustaverylargevarcharvariablename_xxxxxxxxxxxxxxxxxxxxx, '  ', a),
               a, @comment );
  set itisjustamediumsizeintintegervariablename = itisjustamediumsizeintintegervariablename - 1;
            iterate label1;
  END loop label1;
END//
delimiter ;//

CALL sp1(101);

CALL sp1(100);

CALL sp1(75);

CALL sp1(40);

CALL sp1(20);

CALL sp1(-1);

SELECT * from res_t3_itisalongname_1381742_itsaverylongname_1381742
 ORDER BY middleinitial, lastname, age_averylongfieldname_averylongname_1234569;

# cleanup
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.2:;
--source include/show_msg80.inc

# testcase: ensure that all clauses that should be supported are supported (case, while, repeat)

--disable_warnings
DROP PROCEDURE IF EXISTS sp2;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp2( action char(20) )
BEGIN
   declare v1 char(20);
   declare v2 char(20);
   declare count integer;
   set v1 = 'f1';
   set v2 = 'address';
   set count = 1;
   case when action = 'delete'  then
      insert into t3 values(v1, v2, count);
      delete from t3 where f1=v1;
   when action = 'insert' then
      repeat
         insert into t3 values(v1, v2, count);
         set count = count + 1;
      until count > 5
      END repeat;
      set count = 1;
      label1: repeat
        insert into t3 values(v1, v2, count);
      if count > 5 then leave label1;
            END if;
              set count = count + 1;
      until count > 5
      END repeat;
                set count = 1;
      while count < 5 do
        insert into t3 values(v1, v2, count);
        set count = count + 1;
      END while;
      set count = 1;
      label1: while count < 5 do
        insert into t3 values(v1, v2, count);
        if count > 5 then leave label1;
                END if;
        set count = count + 1;
      END while;
  else
      set @dummystring = 'temp value';
  END case;
END//
delimiter ;//

CALL sp2( 'insert' );
SELECT * from t3 where f3 <=5 && f3 >= 0;

SELECT count(*) from t3;
CALL sp2( 'delete' );
SELECT count(*) from t3;

CALL sp2 ('test');
SELECT @dummystring;

# cleanup
DROP PROCEDURE sp2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.1.2:
              ---------------
Ensure that all sub-clauses that should not be supported are disallowed with
an appropriate error message. (case);
--source include/show_msg80.inc


--disable_warnings
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

create table res_t3_itisalongname_1381742_itsaverylongname_1381742 (name char, address varchar(50), age_averylongfieldname_averylongname_1234569 smallint);

delimiter //;
--error 1064
CREATE PROCEDURE sp3( action char(20) )
BEGIN
label1: case
  when action = 'delete'  then
  delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
else
      set @dummystring = 'temp value';
      iterate label1;
END case label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp3( action char(20) )
BEGIN
label1: BEGIN
  case
  action = 'delete'  then
  delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
  else
      set @dummystring = 'temp value';
      iterate label1;
  END case;
  END label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp3( action char(20) )
BEGIN
case
  when action = 'delete'  then
    delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
  then action = 'truncate'  when
  truncate from res_t3_itisalongname_1381742_itsaverylongname_1381742;
  else
      set @dummystring = 'temp value';
      iterate label1;
  END case;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp3( action char(20) )
BEGIN
declare v1 char(20);
declare v2 char(20);
declare count integer;
set v1 = 'f1';
set v2= 'address';
set count = 1;
case action
  when 'delete'  then
  when 'delete'  then
    delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
  END case;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings


delimiter //;
CREATE PROCEDURE sp3( action char(20) )
BEGIN
   declare count int default 1;
   declare done int default 0;
   declare continue handler for sqlstate 'HY000' set done=1;
   label1: loop
      case
         when action = 'delete'  then
            label3:BEGIN
               delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
            END label3;
         when action = 'insert' then
            label2: while count < 10 do
            BEGIN
               insert into res_t3_itisalongname_1381742_itsaverylongname_1381742
                  values('xxxxxxxxxxxxxxxxxxx', '1231230981(*&(*&)(*&(', count);
               if done=1 then
                  set count=10;
               END if;
            END;
            END while label2;
         else
            set @dummystring = 'temp value';
            iterate label1;
      END case;
      if done=1 then
         leave label1;
      END if;
   END loop label1;
   SELECT count, done;
END//
delimiter ;//

# results in lost connection hence suppressed--error 2013
#CALL sp3('insert');

# cleanup
DROP PROCEDURE sp3;
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.4:;
--source include/show_msg80.inc

# testcase: ensure that all supported sub-clauses are supported only in the correct order (if)

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp4()
BEGIN
declare count int;
  set count = 1;
  label1: loop
    if count > 10 then leave label1;
    else
      set count = count + 1;
    elseif count > 20 then
      leave label1;
    END if;
    iterate label1;
  END loop label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp4()
BEGIN
declare count int;
  set count = 1;
  label1: loop
    else
      set count = count + 1;
    if count > 20 then
      leave label1;
    END if;
    iterate label1;
  END loop label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp4()
BEGIN
declare count int;
  set count = 1;
  label1: loop
    elseif count > 20 then
      leave label1;
    else
      set count=count+1;
    END if;
    iterate label1;
  END loop label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp4()
BEGIN
declare count int;
  set count = 1;
  label1: loop
    END if;
    if count > 20 then
      leave label1;
    else
      set count=count+1;
    iterate label1;
  END loop label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp4()
BEGIN
  declare i int default 10;
  if i > 20 then
    set i=25;
  END if
  declare count int;
  set count = 1;
  label1: loop
    if count > 20 then
      leave label1;
    else
      set count=count+1;
    iterate label1;
  END loop label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp4()
BEGIN
  declare idummy int default 10;
  declare count int;
  set count = 1;
  label1: loop
  BEGIN
    if count < 20 then
      BEGIN
        declare idummy2 int default 10;
        set count=count+1;
      END;
    else
      BEGIN
        SELECT idummy2;
        leave label1;
      END;
    END if;
    iterate label1;
  END;
  END loop label1;
END//
delimiter ;//

--error 1054
CALL sp4();

# cleanup
DROP PROCEDURE sp4;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.5:;
--source include/show_msg80.inc

#test case: ensure that all supported sub-clauses are supported only in the correct order (case)

--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp5()
BEGIN
  declare count integer default 1;
  set count = 1;
  case
  else
    set count = 10;
  when count  = 1 then
    set count =  count + 1;
  END case;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp5(count int)
BEGIN
  when case count = 1 then
    set count = 10;
  when count  = 2 then
    set count =  count + 1;
  END case;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp5(count int)
BEGIN
  END case;
  when count = 1 then
    set count = 10;
  when count  = 2 then
    set count =  count + 1;
  END case;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp5(count int)
BEGIN
  when count = 1 then
    set count = 10;
  case when count  = 2 then
    set count =  count + 1;
  END case;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.6:
              ---------------
Ensure that all supported sub-clauses are supported only in the correct order (repeat).;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1: repeat
    set count1 = count1 + 1;
    if count1 > 5 then leave label1; END if;
  END repeat;
  until count1 > 5
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1:   until count1 > 5
  repeat
    set count1 = count1 + 1;
    if count1 > 5 then leave label1; END if;
  END repeat;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1: END repeat
    set count1 = count1 + 1;
    if count1 > 5 then leave label1; END if;
  until count1 > 5
  repeat;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1: repeat
    set count1 = count1 + 1;
    if count1 > 5 then leave label1; END if;
  END repeat;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1: repeat
    set count1 = count1 + 1;
    if count1 > 5 then leave label1; END if;
  until count1 > 10;
  SELECT count1;
  END repeat;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6()
BEGIN
  declare count1 integer default 1;
  label1: repeat
    set count1 = count1;
  until count1 < 0
  END repeat label1;
  SELECT count1;
END//
delimiter ;//

# results in lost connection hence suppressed--error 2013
# CALL sp6();

# cleanup
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.7:;
--source include/show_msg80.inc

# testcase: ensure that an appropriate error message is returned if a
#        sub claUSE is out-of-order in a stored procedure definition (loop, if, iterate, leave).

--disable_warnings
DROP PROCEDURE IF EXISTS sp7;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp7()
BEGIN
  label1: loop
    set @dummystring = 'temp value';
    if count > 10 then leave label1;
    END if;
    label1 iterate;
  END label1 loop;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp7;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp7()
BEGIN
  label1: END loop;
    set @dummystring = 'temp value';
    if count > 10 then leave label1;
    END if;
    iterate label1;
  loop;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp7;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp7()
BEGIN
  label1: iterate label1;
  loop
    set @dummystring = 'temp value';
    if count > 10 then leave label1;
    END if;

  END loop label1;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.8:;
--source include/show_msg80.inc

# testcase: ensure that an appropriate error message is returned if a sub claUSE is
#        out-of-order in a stored procedure definition. (while)

--disable_warnings
DROP PROCEDURE IF EXISTS sp8;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp8()
BEGIN
  declare v1 int default 5;
  do while v1 > 0
    set v1 = v1 - 1;
    END while;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp8;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp8()
BEGIN
  declare v1 int default 5;
  do v1 > 0 while
    set v1 = v1 - 1;
  END while;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp8;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp8()
BEGIN
  declare v1 int default 5;
  END while;
    set v1 = v1 - 1;
  while v1 > 0 do;
END//
delimiter ;//






# ------------------------------------------------------------------------------
let $message= Testcase 4.3.12:;
--source include/show_msg80.inc

# testcase : ensure that the labels enclosing each loop statement must match

--disable_warnings
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE IF EXISTS sp12;
--enable_warnings

create table res_t3_itisalongname_1381742_itsaverylongname_1381742( f1 char(20), f2 varchar(20), f3 smallint);

delimiter //;
--error 1310
CREATE PROCEDURE sp12( )
BEGIN
  declare count1 integer default 1;
  declare count2 int;
  label1: loop
    if count1 > 2 then leave label1;
    END if;
    insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
    label2: loop
      if count2 > 2 then leave label2;
      END if;
      set count2 = count2 + 1;
    END loop label1;
    set count1 = count1 + 1;
    iterate label1;
  END loop label2;
END//
delimiter ;//

# cleanup
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;



# ------------------------------------------------------------------------------
let $message= Testcase 4.3.13:;
--source include/show_msg80.inc

# ensure that it is possible to put a beginning label at the start of a loop statement
#         without also requiring an ending label at the END of the same statement

--disable_warnings
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE IF EXISTS sp13;
--enable_warnings

create table res_t3_itisalongname_1381742_itsaverylongname_1381742( f1 char(20), f2 varchar(20), f3 smallint);

delimiter //;
CREATE PROCEDURE sp13( )
BEGIN
  declare count1 integer default 1;
  lable1: loop
    if count1 > 2 then leave lable1;
    END if;
    insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
    set count1 = count1 + 1;
    iterate lable1;
  END loop;
END//
delimiter ;//

CALL sp13();
SELECT * from res_t3_itisalongname_1381742_itsaverylongname_1381742;

# cleanup
DROP PROCEDURE sp13;
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.14:;
--source include/show_msg80.inc

# testcase: ensure that it is not possible to put an ending label at the END of a loop statement
#            without also requiring a matching beginning label at the start of the same statement.

--disable_warnings
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE IF EXISTS sp14;
--enable_warnings

create table res_t3_itisalongname_1381742_itsaverylongname_1381742( f1 char(20), f2 varchar(20), f3 smallint);

delimiter //;
--error 1308
CREATE PROCEDURE sp14( )
BEGIN
    declare count1 integer default 1;
    loop
      if count1 > 2 then leave lable1;
      END if;
      insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      set count1 = count1 + 1;
      iterate lable1;
    END loop label1;
END//
delimiter ;//

# cleanup
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.15:;
--source include/show_msg80.inc

# ensure that every beginning label must END with a colon (:)

--disable_warnings
drop table IF EXISTS res_t3_itisalongname_1381742_itsaverylongname_1381742;
DROP PROCEDURE IF EXISTS sp15;
--enable_warnings

create table res_t3_itisalongname_1381742_itsaverylongname_1381742( f1 char(20), f2 varchar(20), f3 smallint);

delimiter //;
--error 1064
CREATE PROCEDURE sp15( )
BEGIN
    declare count1 integer default 1;
    label1 loop
      if count1 > 2 then leave lable1;
      END if;
      insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      set count1 = count1 + 1;
      iterate lable1;
    END loop label1;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.16:
              ----------------
Ensure that every beginning label with the same scope must be unique.;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp16;
--enable_warnings

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

delimiter //;
--error 1309
CREATE PROCEDURE sp16( )
BEGIN
    declare count1 integer default 1;
    declare count2 integer default 1;
    label1: repeat
      set count1 = count1 + 1;
      set count2 = 1;
      label1: repeat
        set count2 = count2 + 1;
        insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( xyz , pqr, count1);
        until count2 > 3
      END repeat label1;
      until count1 > 3
    END repeat label1;
END//
delimiter ;//

--disable_warnings
DROP PROCEDURE IF EXISTS sp16;
--enable_warnings

delimiter //;
--error 1309
CREATE PROCEDURE sp16( )
BEGIN
  declare count1 integer default 1;
  declare count2 integer default 1;
  declare count3 integer default 1;
  label1: repeat
    set count1 = count1 + 1;
    label1: repeat
      set count2 = count2 + 1;
      SELECT count2;
      until count2 > 3
    END repeat label1;
    SELECT count1;
  until count1 > 3
  END repeat label1;
  label1: repeat
    set count3 = count3 + 1;
    SELECT count3;
  until count3 > 3
  END repeat label1;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.17:;
--source include/show_msg80.inc

# testcase: ensure that the repeat statement acts correctly for all variants,
#            including cases where statements are nested.



# ------------------------------------------------------------------------------
let $message= Testcase 4.3.18:;
--source include/show_msg80.inc

# testcase : ensure that the labels enclosing each repeat statement must match.

--disable_warnings
DROP PROCEDURE IF EXISTS sp18;
--enable_warnings

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

delimiter //;
--error 1310
CREATE PROCEDURE sp18( )
BEGIN
    declare count1 integer default 1;
    label1: repeat
      set count1 = count1 + 1;
      insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      until count1 < 3
    END repeat label2;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.19:;
--source include/show_msg80.inc

# testcase: ensure that it is possible to put a beginning label at the start of
#            a repeat statement without also requiring an ending label at the
#            END of the same statement.

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

--disable_warnings
DROP PROCEDURE IF EXISTS sp19;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp19( )
BEGIN
    declare count1 integer default 1;
    label1: repeat
      set count1 = count1 + 1;
      insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      until count1 < 3
    END repeat;
END//
delimiter ;//

CALL sp19();
SELECT * from res_t3_itisalongname_1381742_itsaverylongname_1381742;

# cleanup
DROP PROCEDURE sp19;


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.20:;
--source include/show_msg80.inc

# testcase: ensure that it is not possible to put an ending label at the END of a
#            repeat statement without also requiring a matching beginning label
#            at the start of the same statement.

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

--disable_warnings
DROP PROCEDURE IF EXISTS sp20;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp20( )
BEGIN
    declare count1 integer default 1;
    repeat
      set count1 = count1 + 1;
      insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      until count1 < 3
    END repeat label1;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.21:;
--source include/show_msg80.inc

# ensure that the while statement acts correctly for all variants,
#         including cases where statements are nested



# ------------------------------------------------------------------------------
let $message= Testcase 4.3.22:;
--source include/show_msg80.inc

# testcase: ensure that the labels enclosing each while statement must match.

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

--disable_warnings
DROP PROCEDURE IF EXISTS sp22;
--enable_warnings

delimiter //;
--error 1310
CREATE PROCEDURE sp22( )
BEGIN
    declare count1 integer default 1;
    declare count2 integer default 1;
    while count1 < 3 do
      set count1 = count1 + 1;
      set count2 = 1;
      label1: while count2 < 3 do
        set count2 = count2 + 1;
        insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      END while label2;
    END while;
END//
delimiter ;//


# ------------------------------------------------------------------------------
let $message= Testcase 4.3.23:;
--source include/show_msg80.inc

# testcase: ensure that it is not possible to put an ending label at the END of
#            a while statement without also requiring a matching beginning label
#            at the start of the same statement.

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;

--disable_warnings
DROP PROCEDURE IF EXISTS sp23;
--enable_warnings

delimiter //;
--error 1064
CREATE PROCEDURE sp23( )
BEGIN
    declare count1 integer default 1;
    declare count2 integer default 1;
    while count1 < 3 do
      set count1 = count1 + 1;
      set count2 = 1;
      while count2 < 3 do
        set count2 = count2 + 1;
        insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      END while label1;
    END while;
END//
delimiter ;//




# ------------------------------------------------------------------------------
let $message= Testcase 4.3.25:;
--source include/show_msg80.inc

# testcase: ensure that it is possible to put a beginning label at the start of a
#            while statement without also requiring an ending label at the END of the same statement.

delete from res_t3_itisalongname_1381742_itsaverylongname_1381742;
--disable_warnings
DROP PROCEDURE IF EXISTS sp25;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp25( )
BEGIN
    declare count1 integer default 1;
    declare count2 integer default 1;
    while count1 < 3 do
      set count1 = count1 + 1;
      set count2 = 1;
      label1: while count2 < 3 do
        set count2 = count2 + 1;
        insert into res_t3_itisalongname_1381742_itsaverylongname_1381742 values( 'xyz' , 'pqr', count1);
      END while;
    END while;
END//
delimiter ;//

CALL sp25 ();
SELECT * from res_t3_itisalongname_1381742_itsaverylongname_1381742;

# cleanup
DROP PROCEDURE sp25;
drop table res_t3_itisalongname_1381742_itsaverylongname_1381742;


# ==============================================================================
let $message= Section 3.1.4 - Checks for the global nature of stored procedures:;
--source include/show_msg80.inc

USE db_storedproc;

# ------------------------------------------------------------------------------
let $message= Testcase 4.4.1:;
--source include/show_msg80.inc

# testcase: ensure that, regardless of the database in which it was created,
#            a stored procedure can be called (for a procedure) from any #database

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
DROP DATABASE IF EXISTS d40401;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 ( n char(20) )
BEGIN
    SELECT n;
END//
delimiter ;//

  CREATE DATABASE d40401;
  USE d40401;

CALL db_storedproc.sp1('abcd');

  USE db_storedproc;

# cleanup
DROP PROCEDURE sp1;
DROP DATABASE d40401;


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.2:;
--source include/show_msg80.inc

# testcase: ensure that, regardless of the database in which it was created,
#      a stored procedure can be executed (for a function) from any database.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
DROP FUNCTION IF EXISTS fn11;
DROP DATABASE IF EXISTS d40402;
--enable warnings

delimiter //;
CREATE FUNCTION fn1(n int) returns int
  BEGIN
  declare a int;
  set a = 9 * n;
  return a;
END//
delimiter ;//

  CREATE DATABASE d40402;
  USE d40402;


    SELECT db_storedproc.fn1(100);

    SELECT db_storedproc.fn1(1000);

delimiter //;
CREATE FUNCTION db_storedproc.fn11(n int) returns int
BEGIN
    declare a int;
    set a = 9 * n;
    return a;
END//
delimiter ;//

  SELECT db_storedproc.fn11(100);

  SELECT db_storedproc.fn11(1000);

  USE db_storedproc;

# cleanup
DROP FUNCTION fn1;
DROP FUNCTION fn11;
DROP DATABASE d40402;




# ------------------------------------------------------------------------------
let $message= Testcase 4.4.3:;
--source include/show_msg80.inc

# testcase: ensure that the USE of a stored procedure from a database other than the database in
#      which it was created does not permanently change the database in use.

--disable_warnings
DROP DATABASE IF EXISTS d1;
DROP DATABASE IF EXISTS d2;
--enable_warnings

  CREATE DATABASE d1;
  CREATE DATABASE d2;

  USE d1;

  create table res_t41(a char(5), b char(10));
  insert into res_t41 values('abcde', 'a!@#$%^&*(');

  USE d2;

  create table res_t42(a char(5), b char(10));

  USE d1;

delimiter //;
CREATE PROCEDURE sp2(n char (20))
BEGIN
         SELECT res_t41.a, res_t41.b into @a, @b from res_t41 where res_t41.b = n;
         insert into d2.res_t42 values (@a, @b);
END//
delimiter ;//

  USE d2;

CALL d1.sp2('a!@#$%^&*(');

  show warnings;

  SELECT * from d1.res_t41;
  SELECT * from res_t42;

# cleanup
  USE db_storedproc;
DROP DATABASE d1;
DROP DATABASE d2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.4:;
--source include/show_msg80.inc

# testcase : ensure that the mysql-specific USE <database name> statement is disallowed
#       in a stored procedure.

--disable_warnings
DROP DATABASE IF EXISTS d1;
--enable_warnings

  CREATE DATABASE d1;

  USE d1;

delimiter //;
--error 1314
CREATE PROCEDURE sp3()
BEGIN
    USE d1;
END//
delimiter ;//

# cleanup
  USE db_storedproc;
DROP DATABASE d1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.4.5:;
--source include/show_msg80.inc

# testcase: ensure that when a database is dropped, all stored procedures #created within
#            that database are also cleanly dropped.

--disable_warnings
DROP DATABASE IF EXISTS d1;
--enable_warnings

  CREATE DATABASE d1;

  USE d1;
  create table t43(a char(5), b char(10));
  insert into t43 values('abcde', 'a!@#$%^&*(');

CREATE PROCEDURE d1.sp4()
   SELECT * from d1.t43;

--replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name = 'sp4';

  USE db_storedproc;
DROP DATABASE d1;
  CREATE DATABASE d1;

  USE d1;
  create table t44(a char(5), b char(10));

#FIXME: check why here no rows are shown
--replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name = 'sp4';

# cleanup
  USE db_storedproc;
DROP DATABASE d1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.6:;
--source include/show_msg80.inc

# testcase: ensure that a stored procedure created without a qualifying #database name belongs
#            to the database in USE at creation time.


  USE db_storedproc;

--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

CREATE PROCEDURE sp5()
  SELECT * from db_storedproc.t4 limit 0, 10;

  SELECT db from mysql.proc where specific_name = 'sp5';

# cleanup
DROP PROCEDURE sp5;


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.7:;
--source include/show_msg80.inc

# testcase: ensure that a stored procedure created with a qualifying database
#        name belongs to the database specified.

  USE db_storedproc;

--disable_warnings
drop table IF EXISTS t46;
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

  create table t46(f1 char(20), f2 char(20));
  insert into t46 values ('abcd', 'wxyz');

CREATE PROCEDURE db_storedproc.sp6()
  SELECT * from db_storedproc.t4 limit 0, 10;

  SELECT db from mysql.proc where specific_name = 'sp6';

# cleanup
drop table t46;
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.8:;
--source include/show_msg80.inc

# testcase : ensure that, regardless of the database in which it was created,
#       a procedure can be altered from any database.

--disable_warnings
DROP DATABASE IF EXISTS d1;
DROP DATABASE IF EXISTS d2;
--enable_warnings

  CREATE DATABASE d1;
  CREATE DATABASE d2;

  USE d1;

CREATE PROCEDURE sp8 ( n char(20) ) sql security definer comment 'initial'
  SELECT * from t1 where t1.f1 = n;

  USE d2;
  alter procedure d1.sp8 sql security definer comment 'updated';
--replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name='sp8' and db='d1';


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.9:;
--source include/show_msg80.inc

# testcase :ensure that, regardless of the database in which it was created,
#      a stored procedure can be executed (for a function) from any database.

  USE d1;

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
DROP FUNCTION IF EXISTS fn11;
--enable_warnings

delimiter //;
CREATE FUNCTION d1.fn2(n int) returns int sql security invoker comment 'initial'
BEGIN
    declare a int;
    set a = 0.9 * n;
    return a;
END//
delimiter ;//

  USE d2;
  alter function d1.fn2 sql security definer comment 'updated';
--replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name='fn2' and db='d1';


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.10:;
--source include/show_msg80.inc

# testcase: ensure that, regardless of the database in which it was created,
#      a procedure can be dropped from any database.


  USE d1;

CREATE PROCEDURE sp9 ( n char(20) )
  SELECT * from t1 where t1.f1 = n;

  USE d2;
DROP PROCEDURE d1.sp9; --replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name='sp9' and db='d1';


# ------------------------------------------------------------------------------
let $message= Testcase 4.4.11:;
--source include/show_msg80.inc

# testcase: ensure that, regardless of the database in which it was created,
#      a function can be dropped from any database.


  USE d1;

delimiter //;
CREATE FUNCTION d1.fn3(n int) returns int
BEGIN
    declare a int;
    set a = 0.9 * n;
    return a;
END//
delimiter ;//

  USE d2;
DROP FUNCTION d1.fn3;
--replace_column 13 modified 14 created
  SELECT * from mysql.proc where specific_name='fn3' and db='d1';

# cleanup

  USE db_storedproc;
DROP DATABASE d1;
DROP DATABASE d2;


# ==============================================================================
# test plan section: 4.5 -
# ==============================================================================
let $message= Section 3.1.5 - Parameter use checks:
Functions with all data types;
--source include/show_msg80.inc

#FIXME hpux11
let $plus_20=   1.00e+20;
let $plus_24=   1.00e+24;
let $plus_30=   1.00e+30;
let $plus_36=   1.00e+36;
let $plus_40=   1.00e+40;
let $minus_30= -1.00e+30;
let $minus_36= -1.00e+36;
let $minus_40= -1.00e+40;

let $callvar01m= -1.00e+20;
let $callvar01p=  1.00e+20;
let $callvar02=  -9.22e+18;
let $callvar03=  -9.22e+18;

let $procvar01_m30= -1.00e+30;
let $procvar01_m36= -1.00e+36;
let $procvar01_m40= -1.00e+40;
let $procvar01_20=  1.00e+20;
let $procvar01_24=  1.00e+24;
let $procvar01_30=  1.00e+30;
let $procvar01_36=  1.00e+36;
let $procvar01_40=  1.00e+40;

let $bug_dec_num= 1;

eval SELECT $bug_dec_num as 'bug_dec_num';

if ($bug_dec_num)
{
   let $message=
   .
   FIXME:  There are differences with datatypes DECIMAL and NUMERIC if large
   FIXME:  exponent values are used. The diffs are shown only on some machines like
   FIXME:  AIX52 and HPUX11. Until this has been solved we use numbers that
   FIXME:  *should* be equal to the exponent representation but have no exponents
   FIXME:  and use the specified count of *0*s instead.
   FIXME:  In the source file these tests are marked with the comment  hpux11
   .;
   --source include/show_msg80.inc
   # FIXME values above changed to values below to fix DECIMAL/NUMERIC issues on hpux11

   #################123456789-123456789-123456789-123456789-
   let $plus_20=   100000000000000000000;
   let $plus_24=   1000000000000000000000000;
   let $plus_30=   1000000000000000000000000000000;
   let $plus_36=   1000000000000000000000000000000000000;
   let $plus_40=   10000000000000000000000000000000000000000;
   let $minus_30= -1000000000000000000000000000000;
   let $minus_36= -1000000000000000000000000000000000000;
   let $minus_40= -10000000000000000000000000000000000000000;

   let $procvar_m00=   -1.00e+22;
   let $procvar_00=     1.00e+22;
   let $procvar01_m30= $procvar_m00;
   let $procvar01_m36= $procvar_m00;
   let $procvar01_m40= $procvar_m00;
   let $procvar01_20=  $procvar_00;
   let $procvar01_24=  $procvar_00;
   let $procvar01_30=  $procvar_00;
   let $procvar01_36=  $procvar_00;
   let $procvar01_40=  $procvar_00;
}
let $procvar03= -9.22e+18;
let $procvar05= -9.22e+18;
let $procvar07= -9.22e+18;


--disable_warnings
DROP DATABASE IF EXISTS d1;
--enable_warnings

CREATE DATABASE d1;
USE d1;

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1( f1 bigint) returns bigint
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn1(-9.22e+18);


--disable_warnings
DROP FUNCTION IF EXISTS fn2;
--enable_warnings

delimiter //;
CREATE FUNCTION fn2( f1 bigint unsigned) returns bigint unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn2(1.84e+19);


--disable_warnings
DROP FUNCTION IF EXISTS fn3;
--enable_warnings

delimiter //;
CREATE FUNCTION fn3( f1 bigint unsigned zerofill) returns bigint unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn3(1.84e+17);
--enable_ps_protocol

--disable_warnings
DROP FUNCTION IF EXISTS fn4;
--enable_warnings

delimiter //;
CREATE FUNCTION fn4( f1 bigint zerofill) returns bigint zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn4(-9.22e+15);
--enable_ps_protocol


--disable_warnings
DROP FUNCTION IF EXISTS fn5;
--enable_warnings

delimiter //;
CREATE FUNCTION fn5( f1 decimal) returns decimal
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn5(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn6;
--enable_warnings

delimiter //;
CREATE FUNCTION fn6( f1 decimal (0)) returns decimal (0)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn6(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn7;
--enable_warnings

delimiter //;
CREATE FUNCTION fn7( f1 decimal (0) unsigned) returns decimal (0) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn7(99999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn8;
--enable_warnings

delimiter //;
CREATE FUNCTION fn8( f1 decimal (0) unsigned zerofill) returns decimal (0) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn8(999999999);

--disable_warnings
DROP FUNCTION IF EXISTS fn9;
--enable_warnings

delimiter //;
CREATE FUNCTION fn9( f1 decimal (0) zerofill) returns decimal (0) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn9(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn10;
--enable_warnings

delimiter //;
CREATE FUNCTION fn10( f1 decimal (0, 0)) returns decimal (0, 0)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn10(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn11;
--enable_warnings

delimiter //;
CREATE FUNCTION fn11( f1 decimal (0, 0) unsigned) returns decimal (0, 0) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn11(99999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn12;
--enable_warnings

delimiter //;
CREATE FUNCTION fn12( f1 decimal (0, 0) unsigned zerofill) returns decimal (0, 0) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn12(999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn13;
--enable_warnings

delimiter //;
CREATE FUNCTION fn13( f1 decimal (0, 0) zerofill) returns decimal (0, 0) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn13(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn14;
--enable_warnings

delimiter //;
CREATE FUNCTION fn14( f1 decimal (63, 30)) returns decimal (63, 30)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn14(-1.00e+21);


--disable_warnings
DROP FUNCTION IF EXISTS fn15;
--enable_warnings

delimiter //;
CREATE FUNCTION fn15( f1 decimal (63, 30) unsigned) returns decimal (63, 30) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn15(1.00e+16);


--disable_warnings
DROP FUNCTION IF EXISTS fn16;
--enable_warnings

delimiter //;
CREATE FUNCTION fn16( f1 decimal (63, 30) unsigned zerofill) returns decimal (63, 30) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn16(1.00e+16);


--disable_warnings
DROP FUNCTION IF EXISTS fn17;
--enable_warnings

delimiter //;
CREATE FUNCTION fn17( f1 decimal (63, 30) zerofill) returns decimal (63, 30) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn17(-1.00e+21);


--disable_warnings
DROP FUNCTION IF EXISTS fn18_d;
--enable_warnings

delimiter //;
CREATE FUNCTION fn18_d( f1 decimal (64)) returns decimal (64)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
eval SELECT fn18_d( $minus_30 );


--disable_warnings
DROP FUNCTION IF EXISTS fn19_du;
--enable_warnings

delimiter //;
CREATE FUNCTION fn19_du( f1 decimal (64) unsigned) returns decimal (64) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
eval SELECT fn19_du( $plus_20 );


--disable_warnings
DROP FUNCTION IF EXISTS fn20_duz;
--enable_warnings

delimiter //;
CREATE FUNCTION fn20_duz( f1 decimal (64) unsigned zerofill) returns decimal (64) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
eval SELECT fn20_duz( $plus_24 );


--disable_warnings
DROP FUNCTION IF EXISTS fn21_d_z;
--enable_warnings

delimiter //;
CREATE FUNCTION fn21_d_z( f1 decimal (64) zerofill) returns decimal (64) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn21_d_z(1.00e+00);

--disable_warnings
DROP FUNCTION IF EXISTS fn22;
--enable_warnings

delimiter //;
CREATE FUNCTION fn22( f1 decimal unsigned) returns decimal unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn22(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn23;
--enable_warnings

delimiter //;
CREATE FUNCTION fn23( f1 decimal unsigned zerofill) returns decimal unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn23(1.00e+00);

--disable_warnings
DROP FUNCTION IF EXISTS fn24;
--enable_warnings

delimiter //;
CREATE FUNCTION fn24( f1 decimal zerofill) returns decimal zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn24(-1.00e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn25;
--enable_warnings

delimiter //;
CREATE FUNCTION fn25( f1 double) returns double
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn25(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn26;
--enable_warnings

delimiter //;
CREATE FUNCTION fn26( f1 double unsigned) returns double unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn26(1.00e+00);

--disable_warnings
DROP FUNCTION IF EXISTS fn27;
--enable_warnings

delimiter //;
CREATE FUNCTION fn27( f1 double unsigned zerofill) returns double unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn27(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn28;
--enable_warnings

delimiter //;
CREATE FUNCTION fn28( f1 double zerofill) returns double zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn28(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn29;
--enable_warnings

delimiter //;
CREATE FUNCTION fn29( f1 float) returns float
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn29(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn30;
--enable_warnings

delimiter //;
CREATE FUNCTION fn30( f1 float unsigned) returns float unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn30(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn31;
--enable_warnings

delimiter //;
CREATE FUNCTION fn31( f1 float unsigned zerofill) returns float unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn31(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn32;
--enable_warnings

delimiter //;
CREATE FUNCTION fn32( f1 float zerofill) returns float zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn32(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn33;
--enable_warnings

delimiter //;
CREATE FUNCTION fn33( f1 float(0)) returns float(0)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn33(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn34;
--enable_warnings

delimiter //;
CREATE FUNCTION fn34( f1 float(0) unsigned) returns float(0) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn34(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn35;
--enable_warnings

delimiter //;
CREATE FUNCTION fn35( f1 float(0) unsigned zerofill) returns float(0) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn35(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn36;
--enable_warnings

delimiter //;
CREATE FUNCTION fn36( f1 float(0) zerofill) returns float(0) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn36(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn37;
--enable_warnings

delimiter //;
CREATE FUNCTION fn37( f1 float(23)) returns float(23)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn37(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn38;
--enable_warnings

delimiter //;
CREATE FUNCTION fn38( f1 float(23) unsigned) returns float(23) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn38(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn39;
--enable_warnings

delimiter //;
CREATE FUNCTION fn39( f1 float(23) unsigned zerofill) returns float(23) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn39(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn40;
--enable_warnings

delimiter //;
CREATE FUNCTION fn40( f1 float(23) zerofill) returns float(23) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn40(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn41;
--enable_warnings

delimiter //;
CREATE FUNCTION fn41( f1 float(24)) returns float(24)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn41(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn42;
--enable_warnings

delimiter //;
CREATE FUNCTION fn42( f1 float(24) unsigned) returns float(24) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn42(1.00e+00);

--disable_warnings
DROP FUNCTION IF EXISTS fn43;
--enable_warnings

delimiter //;
CREATE FUNCTION fn43( f1 float(24) unsigned zerofill) returns float(24) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn43(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn44;
--enable_warnings

delimiter //;
CREATE FUNCTION fn44( f1 float(24) zerofill) returns float(24) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn44(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn45;
--enable_warnings

delimiter //;
CREATE FUNCTION fn45( f1 float(53)) returns float(53)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn45(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn46;
--enable_warnings

delimiter //;
CREATE FUNCTION fn46( f1 float(53) unsigned) returns float(53) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn46(1.00e+00);

--disable_warnings
DROP FUNCTION IF EXISTS fn47;
--enable_warnings

delimiter //;
CREATE FUNCTION fn47( f1 float(53) unsigned zerofill) returns float(53) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn47(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn48;
--enable_warnings

delimiter //;
CREATE FUNCTION fn48( f1 float(53) zerofill) returns float(53) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn48(1.00e+00);


--disable_warnings
DROP FUNCTION IF EXISTS fn49;
--enable_warnings

delimiter //;
CREATE FUNCTION fn49( f1 int) returns int
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn49(-2.15e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn50;
--enable_warnings

delimiter //;
CREATE FUNCTION fn50( f1 int unsigned) returns int unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn50(4.29e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn51;
--enable_warnings

delimiter //;
CREATE FUNCTION fn51( f1 int unsigned zerofill) returns int unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn51(4.29e+09);


--disable_warnings
DROP FUNCTION IF EXISTS fn52;
--enable_warnings

delimiter //;
CREATE FUNCTION fn52( f1 int zerofill) returns int zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn52(2.15e+08);
--enable_ps_protocol

--disable_warnings
DROP FUNCTION IF EXISTS fn53;
--enable_warnings

delimiter //;
CREATE FUNCTION fn53( f1 mediumint) returns mediumint
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn53(-8388600);

--disable_warnings
DROP FUNCTION IF EXISTS fn54;
--enable_warnings

delimiter //;
CREATE FUNCTION fn54( f1 mediumint unsigned) returns mediumint unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn54(16777201);


--disable_warnings
DROP FUNCTION IF EXISTS fn55;
--enable_warnings

delimiter //;
CREATE FUNCTION fn55( f1 mediumint unsigned zerofill) returns mediumint unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn55(16777210);


--disable_warnings
DROP FUNCTION IF EXISTS fn56;
--enable_warnings

delimiter //;
CREATE FUNCTION fn56( f1 mediumint zerofill) returns mediumint zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn56(-8388601);
--enable_ps_protocol


--disable_warnings
DROP FUNCTION IF EXISTS fn57;
--enable_warnings

delimiter //;
CREATE FUNCTION fn57( f1 numeric) returns numeric
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn57(-999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn58;
--enable_warnings

delimiter //;
CREATE FUNCTION fn58( f1 numeric (0)) returns numeric (0)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn58(-999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn59;
--enable_warnings

delimiter //;
CREATE FUNCTION fn59( f1 numeric (0) unsigned) returns numeric (0) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn59(9999999999);

--disable_warnings
DROP FUNCTION IF EXISTS fn60;
--enable_warnings

delimiter //;
CREATE FUNCTION fn60( f1 numeric (0) unsigned zerofill) returns numeric (0) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn60(99999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn61;
--enable_warnings

delimiter //;
CREATE FUNCTION fn61( f1 numeric (0) zerofill) returns numeric (0) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn61(-99999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn62;
--enable_warnings

delimiter //;
CREATE FUNCTION fn62( f1 numeric (0, 0)) returns numeric (0, 0)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn62(-999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn63;
--enable_warnings

delimiter //;
CREATE FUNCTION fn63( f1 numeric (0, 0) unsigned) returns numeric (0, 0) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn63(9999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn64;
--enable_warnings

delimiter //;
CREATE FUNCTION fn64( f1 numeric (0, 0) unsigned zerofill) returns numeric (0, 0) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn64(99999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn65;
--enable_warnings

delimiter //;
CREATE FUNCTION fn65( f1 numeric (0, 0) zerofill) returns numeric (0, 0) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn65(-99999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn66;
--enable_warnings

delimiter //;
CREATE FUNCTION fn66( f1 numeric (63, 30)) returns numeric (63, 30)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn66(-1e+36);


--disable_warnings
DROP FUNCTION IF EXISTS fn67;
--enable_warnings

delimiter //;
CREATE FUNCTION fn67( f1 numeric (63, 30) unsigned) returns numeric (63, 30) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn67(1e+36);


--disable_warnings
DROP FUNCTION IF EXISTS fn68;
--enable_warnings

delimiter //;
CREATE FUNCTION fn68( f1 numeric (63, 30) unsigned zerofill) returns numeric (63, 30) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn68(1e+36);


--disable_warnings
DROP FUNCTION IF EXISTS fn69;
--enable_warnings

delimiter //;
CREATE FUNCTION fn69( f1 numeric (63, 30) zerofill) returns numeric (63, 30) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn69(-1e+36);


--disable_warnings
DROP FUNCTION IF EXISTS fn70_n;
--enable_warnings

delimiter //;
CREATE FUNCTION fn70_n( f1 numeric (64)) returns numeric (64)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
#SELECT fn70_n(-1e+40);
eval SELECT fn70_n( $minus_30 );
eval SELECT fn70_n( $minus_40 );


--disable_warnings
DROP FUNCTION IF EXISTS fn71_nu;
--enable_warnings

delimiter //;
CREATE FUNCTION fn71_nu( f1 numeric (64) unsigned) returns numeric (64) unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
#SELECT fn71_nu(1.00e+40);
eval SELECT fn71_nu( $plus_40 );


--disable_warnings
DROP FUNCTION IF EXISTS fn72_nuz;
--enable_warnings

delimiter //;
CREATE FUNCTION fn72_nuz( f1 numeric (64) unsigned zerofill) returns numeric (64) unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
#SELECT fn72_nuz(1.00e+40);
eval SELECT fn72_nuz( $plus_40 );


--disable_warnings
DROP FUNCTION IF EXISTS fn73_n_z;
--enable_warnings

delimiter //;
CREATE FUNCTION fn73_n_z( f1 numeric (64) zerofill) returns numeric (64) zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

#FIXME hpux11
#SELECT fn73_n_z(1.00e+40);
eval SELECT fn73_n_z( $plus_40 );

--disable_warnings
DROP FUNCTION IF EXISTS fn74;
--enable_warnings

delimiter //;
CREATE FUNCTION fn74( f1 numeric unsigned) returns numeric unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn74(999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn75;
--enable_warnings

delimiter //;
CREATE FUNCTION fn75( f1 numeric unsigned zerofill) returns numeric unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn75(999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn76;
--enable_warnings

delimiter //;
CREATE FUNCTION fn76( f1 numeric zerofill) returns numeric zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn76(-999999999);


--disable_warnings
DROP FUNCTION IF EXISTS fn77;
--enable_warnings

delimiter //;
CREATE FUNCTION fn77( f1 real) returns real
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn77(1.1);


--disable_warnings
DROP FUNCTION IF EXISTS fn78;
--enable_warnings

delimiter //;
CREATE FUNCTION fn78( f1 real unsigned) returns real unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn78(1.1);


--disable_warnings
DROP FUNCTION IF EXISTS fn79;
--enable_warnings

delimiter //;
CREATE FUNCTION fn79( f1 real unsigned zerofill) returns real unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn79(1.1);


--disable_warnings
DROP FUNCTION IF EXISTS fn80;
--enable_warnings

delimiter //;
CREATE FUNCTION fn80( f1 real zerofill) returns real zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn80(1.1);


--disable_warnings
DROP FUNCTION IF EXISTS fn81;
--enable_warnings

delimiter //;
CREATE FUNCTION fn81( f1 smallint) returns smallint
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn81(-32701);


--disable_warnings
DROP FUNCTION IF EXISTS fn82;
--enable_warnings

delimiter //;
CREATE FUNCTION fn82( f1 smallint unsigned) returns smallint unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn82(65531);


--disable_warnings
DROP FUNCTION IF EXISTS fn83;
--enable_warnings

delimiter //;
CREATE FUNCTION fn83( f1 smallint unsigned zerofill) returns smallint unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn83(65531);


--disable_warnings
DROP FUNCTION IF EXISTS fn84;
--enable_warnings

delimiter //;
CREATE FUNCTION fn84( f1 smallint zerofill) returns smallint zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn84(-32601);
--enable_ps_protocol


--disable_warnings
DROP FUNCTION IF EXISTS fn85;
--enable_warnings

delimiter //;
CREATE FUNCTION fn85( f1 tinyint) returns tinyint
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn85(-115);


--disable_warnings
DROP FUNCTION IF EXISTS fn86;
--enable_warnings

delimiter //;
CREATE FUNCTION fn86( f1 tinyint unsigned) returns tinyint unsigned
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn86(251);


--disable_warnings
DROP FUNCTION IF EXISTS fn87;
--enable_warnings

delimiter //;
CREATE FUNCTION fn87( f1 tinyint unsigned zerofill) returns tinyint unsigned zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

SELECT fn87(201);


--disable_warnings
DROP FUNCTION IF EXISTS fn88;
--enable_warnings

delimiter //;
CREATE FUNCTION fn88( f1 tinyint zerofill) returns tinyint zerofill
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  return f1;
END//
delimiter ;//

if ($have_bug_11589)
{
--disable_ps_protocol
}
SELECT fn88(-101);
--enable_ps_protocol

--disable_warnings
DROP FUNCTION IF EXISTS fn89;
--enable_warnings


#FIXME why was fn89 switched off ?
delimiter //;
#FIXME: check whether this error 1064 is OK!
--error 1064
CREATE FUNCTION fn89( f1 enum('1enum', '2enum')) returns enum('1enum', '2enum')
BEGIN
 if f1 eq "1enum" then
   set f1 = '2enum';
  else
   set f1 = '1enum';
 END if;
 return f1;
END//
delimiter ;//

#FIXME: this is OK as long as the error 1064 above is OK!
--error 1305
SELECT fn89( '1enum');

--disable_warnings
DROP FUNCTION IF EXISTS fn90;
--enable_warnings


#FIXME: wah was fn90 switched off ?
delimiter //;
#FIXME: check whether this error 1064 is OK!
--error 1064
CREATE FUNCTION fn90( f1 set("1set", "2set")) returns set("1set", "2set")
BEGIN
   if(f1 == "1set") then
      set f1 = "2set";
   else
      set f1 = "1set";
   END if;
   return f1;
END//
delimiter ;//

#FIXME: this is OK as long as the error 1064 above is OK!
--error 1305
SELECT fn90( '1set');


--disable_warnings
DROP FUNCTION IF EXISTS fn91;
--enable_warnings

delimiter //;
CREATE FUNCTION fn91( f1 date) returns date
BEGIN
  set f1 = adddate(f1, interval 31 day);
  return f1;
END//
delimiter ;//

SELECT fn91('1997-12-31');

--disable_warnings
DROP FUNCTION IF EXISTS fn92;
--enable_warnings


delimiter //;
CREATE FUNCTION fn92( f1 time) returns time
BEGIN
  set f1 = addtime(f1, '02:00:00.999998');
  return f1;
END//
delimiter ;//

SELECT fn92( '23:59:59.999999');


--disable_warnings
DROP FUNCTION IF EXISTS fn93;
--enable_warnings


delimiter //;
CREATE FUNCTION fn93( f1 datetime) returns datetime
BEGIN
  set f1 = addtime(f1, '1 1:1:1.000002');
  return f1;
END//
delimiter ;//

SELECT fn93('1997-12-31 23:59:59.999999');

--disable_warnings
DROP FUNCTION IF EXISTS fn94;
--enable_warnings


delimiter //;
CREATE FUNCTION fn94( f1 char) returns char
BEGIN
  set f1 = concat('a', f1);
  return f1;
END//
delimiter ;//

SELECT fn94( 'h');

--disable_warnings
DROP FUNCTION IF EXISTS fn95;
--enable_warnings


delimiter //;
CREATE FUNCTION fn95( f1 char ascii) returns char ascii
BEGIN
  set f1 = concat('a', f1);
  return f1;
END//
delimiter ;//

SELECT fn95('h');


--disable_warnings
DROP FUNCTION IF EXISTS fn96;
--enable_warnings

delimiter //;
#FIXME: check whether this error 1064 is OK!
#--error 1064
CREATE FUNCTION fn96( f1 char binary) returns char binary
BEGIN
  set f1 = concat('a', f1);
  return f1;
END//
delimiter ;//

#FIXME: this is OK as long as the error 1064 above is OK!
#--error 1305
SELECT fn96( 'h');


--disable_warnings
DROP FUNCTION IF EXISTS fn97;
--enable_warnings

delimiter //;
CREATE FUNCTION fn97( f1 longtext) returns longtext
BEGIN
  set f1 = concat('hello', f1);
  return f1;
END//
delimiter ;//

SELECT fn97( 'world');

--disable_warnings
DROP FUNCTION IF EXISTS fn98;
--enable_warnings

delimiter //;
CREATE FUNCTION fn98( f1 mediumtext) returns mediumtext
BEGIN
  set f1 = concat('hello', f1);
  return f1;
END//
delimiter ;//

SELECT fn98( 'world');

--disable_warnings
DROP FUNCTION IF EXISTS fn99;
--enable_warnings

delimiter //;
CREATE FUNCTION fn99( f1 text) returns text
BEGIN
  set f1 = concat('hello', f1);
  return f1;
END//
delimiter ;//

SELECT fn99( 'world');

--disable_warnings
DROP FUNCTION IF EXISTS fn100;
--enable_warnings

delimiter //;
CREATE FUNCTION fn100( f1 tinytext) returns tinytext
BEGIN
  set f1 = concat('hello', f1);
  return f1;
END//
delimiter ;//

SELECT fn100( 'world');

--disable_warnings
DROP FUNCTION IF EXISTS fn101;
--enable_warnings

delimiter //;
CREATE FUNCTION fn101( f1 year) returns year
BEGIN
  set f1 = f1 + 10;
  return f1;
END//
delimiter ;//

SELECT fn101(51);


--disable_warnings
DROP FUNCTION IF EXISTS fn102;
--enable_warnings

delimiter //;
CREATE FUNCTION fn102( f1 year(4)) returns year(4)
BEGIN
  set f1 = f1 + 51;
  return f1;
END//
delimiter ;//

SELECT fn102(1982);


--disable_warnings
DROP FUNCTION IF EXISTS fn103;
--enable_warnings

#FIXME Bug: (Bug#10499)
delimiter //;
#--error 1178
CREATE FUNCTION fn103( f1 geometrycollection) returns geometrycollection
BEGIN
  set f1 = f1;
  return f1;
END//
delimiter ;//

#FIXME Bug: (Bug#10499)
SELECT fn103('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0@');


--disable_warnings
DROP FUNCTION IF EXISTS fn104;
--enable_warnings

#FIXME Bug: (Bug#10499)
delimiter //;
#--error 1178
CREATE FUNCTION fn104( f1 linestring) returns linestring
BEGIN
  set f1 = f1;
  return f1;
END//
delimiter ;//

#FIXME Bug: (Bug#10499)
SELECT fn104('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0@\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0@');


--disable_warnings
DROP FUNCTION IF EXISTS fn105;
--enable_warnings

#FIXME Bug: (Bug#10499)
delimiter //;
#--error 1178
CREATE FUNCTION fn105( f1 point) returns point
BEGIN
  set f1 = f1;
  return f1;
END//
delimiter ;//

#FIXME Bug: (Bug#10499)
SELECT fn105('\0\0\0\0\0\0\0\0\0\0\0\0\04@\0\0\0\0\0\04@');


--disable_warnings
DROP FUNCTION IF EXISTS fn106;
--enable_warnings

#FIXME Bug: (Bug#10499)
delimiter //;
#--error 1178
CREATE FUNCTION fn106( f1 polygon) returns polygon
BEGIN
  set f1 = f1;
  return f1;
END//
delimiter ;//

#FIXME Bug: (Bug#10499)
SELECT fn106('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0@');


--disable_warnings
DROP FUNCTION IF EXISTS fn107;
--enable_warnings

delimiter //;
CREATE FUNCTION fn107( f1 timestamp) returns timestamp
BEGIN
  set f1 = now();
  return f1;
END//
delimiter ;//

--replace_column 1 returned
SELECT fn107(20050510080451);

USE db_storedproc;
DROP DATABASE d1;


# ==============================================================================
# test plan section: 4.5 - stored procs with in, out parameters using all datatypes
# ==============================================================================

--disable_warnings
DROP DATABASE IF EXISTS db1;
--enable_warnings

CREATE DATABASE db1;
USE db1;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1( f1 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp1(-9.22e+18);


--disable_warnings
DROP PROCEDURE IF EXISTS sp2;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp2( f1 bigint unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp2(1.84e+19);


--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp3( f1 bigint unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp3(1.84e+17);


--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp4( f1 bigint zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp4(-9.22e+15);


--disable_warnings
DROP PROCEDURE IF EXISTS sp5;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp5( f1 decimal)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: default (10) for DECIMAL not checked, decimal digits shown although not defined

CALL sp5(-1.00e+09);


--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6( f1 decimal (0))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp6(-1.00e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp7;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp7( f1 decimal (0) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp7(99999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp8;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp8( f1 decimal (0) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp8(999999999);


--disable_warnings
DROP PROCEDURE IF EXISTS sp9;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp9( f1 decimal (0) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp9(-1.00e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp10;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp10( f1 decimal (0, 0))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp10(-1.00e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp11;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp11( f1 decimal (0, 0) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp11(99999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp12;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp12( f1 decimal (0, 0) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp12(999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp13;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp13( f1 decimal (0, 0) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp13(-1.00e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp14;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp14( f1 decimal (63, 30))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: wrong number of decimal digits shown

CALL sp14(-1.00e+21);


--disable_warnings
DROP PROCEDURE IF EXISTS sp15;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp15( f1 decimal (63, 30) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: wrong number of decimal digits shown

CALL sp15(1.00e+16);


--disable_warnings
DROP PROCEDURE IF EXISTS sp16;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp16( f1 decimal (63, 30) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: wrong number of decimal digits shown

CALL sp16(1.00e+16);


--disable_warnings
DROP PROCEDURE IF EXISTS sp17;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp17( f1 decimal (63, 30) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: wrong number of decimal digits shown

CALL sp17(-1.00e+21);

--disable_warnings
DROP PROCEDURE IF EXISTS sp18_d;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp18_d( f1 decimal (64))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp18_d(-1.00e+30);
eval CALL sp18_d( $minus_30 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp19_du;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp19_du( f1 decimal (64) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp19_du(1.00e+20);
eval CALL sp19_du( $plus_20 );
#CALL sp19_du(1.00e+24);
eval CALL sp19_du( $plus_24 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp20_duz;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp20_duz( f1 decimal (64) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

# hpux11
#CALL sp20_duz(1.00e+20);
eval CALL sp20_duz( $plus_20 );
#CALL sp20_duz(1.00e+24);
eval CALL sp20_duz( $plus_24 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp21;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp21( f1 decimal (64) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp21(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp22;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp22( f1 decimal unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp22(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp23;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp23( f1 decimal unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp23(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp24;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp24( f1 decimal zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

-- echo FIXME: Following test contains a known problem that will be checked again
-- echo FIXME: after WL#2984 has been completed:
-- echo FIXME: decimal digits shown although not defined

CALL sp24(-1.00e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp25;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp25( f1 double)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp25(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp26;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp26( f1 double unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp26(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp27;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp27( f1 double unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp27(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp28;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp28( f1 double zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp28(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp29;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp29( f1 float)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp29(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp30;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp30( f1 float unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp30(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp31;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp31( f1 float unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp31(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp32;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp32( f1 float zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp32(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp33;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp33( f1 float(0))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp33(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp34;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp34( f1 float(0) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp34(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp35;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp35( f1 float(0) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp35(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp36;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp36( f1 float(0) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp36(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp37;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp37( f1 float(23))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp37(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp38;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp38( f1 float(23) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp38(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp39;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp39( f1 float(23) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp39(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp40;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp40( f1 float(23) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp40(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp41;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp41( f1 float(24))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp41(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp42;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp42( f1 float(24) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp42(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp43;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp43( f1 float(24) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp43(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp44;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp44( f1 float(24) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp44(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp45;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp45( f1 float(53))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp45(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp46;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp46( f1 float(53) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp46(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp47;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp47( f1 float(53) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp47(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp48;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp48( f1 float(53) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp48(1.00e+00);

--disable_warnings
DROP PROCEDURE IF EXISTS sp49;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp49( f1 int)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp49(-2.15e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp50;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp50( f1 int unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp50(4.29e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp51;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp51( f1 int unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp51(4.29e+09);

--disable_warnings
DROP PROCEDURE IF EXISTS sp52;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp52( f1 int zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp52(2.15e+08);

--disable_warnings
DROP PROCEDURE IF EXISTS sp53;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp53( f1 mediumint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp53(-8388600);

--disable_warnings
DROP PROCEDURE IF EXISTS sp54;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp54( f1 mediumint unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp54(16777201);

--disable_warnings
DROP PROCEDURE IF EXISTS sp55;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp55( f1 mediumint unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp55(16777210);

--disable_warnings
DROP PROCEDURE IF EXISTS sp56;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp56( f1 mediumint zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp56(-8388601);

--disable_warnings
DROP PROCEDURE IF EXISTS sp57;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp57( f1 numeric)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp57(-999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp58;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp58( f1 numeric (0))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp58(-999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp59;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp59( f1 numeric (0) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp59(9999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp60;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp60( f1 numeric (0) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp60(99999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp61;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp61( f1 numeric (0) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp61(-99999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp62;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp62( f1 numeric (0, 0))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp62(-999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp63;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp63( f1 numeric (0, 0) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp63(9999999999);


--disable_warnings
DROP PROCEDURE IF EXISTS sp64;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp64( f1 numeric (0, 0) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp64(99999999);


--disable_warnings
DROP PROCEDURE IF EXISTS sp65;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp65( f1 numeric (0, 0) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp65(-99999999);


--disable_warnings
DROP PROCEDURE IF EXISTS sp66_n;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp66_n( f1 numeric (63, 30))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp66_n(-1e+36);
eval CALL sp66_n( $minus_36 );

--disable_warnings
DROP PROCEDURE IF EXISTS sp67_nu;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp67_nu( f1 numeric (63, 30) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp67_nu(1e+36);
eval CALL sp67_nu( $plus_36 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp68_nuz;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp68_nuz( f1 numeric (63, 30) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp68_nuz(1e+36);
eval CALL sp68_nuz( $plus_36 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp69_n_z;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp69_n_z( f1 numeric (63, 30) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp69_n_z(-1e+36);
eval CALL sp69_n_z( $minus_36 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp70_n;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp70_n( f1 numeric (64))
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp70_n(-1e+40);
eval CALL sp70_n( $minus_40 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp71_nu;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp71_nu( f1 numeric (64) unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp71_nu(1.00e+40);
eval CALL sp71_nu( $plus_40 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp72_nuz;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp72_nuz( f1 numeric (64) unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp72_nuz(1.00e+40);
eval CALL sp72_nuz( $plus_40 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp73_n_z;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp73_n_z( f1 numeric (64) zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

# hpux11
#CALL sp73_n_z(1.00e+40);
eval CALL sp73_n_z( $plus_40 );


--disable_warnings
DROP PROCEDURE IF EXISTS sp74;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp74( f1 numeric unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp74(999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp75;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp75( f1 numeric unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp75(999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp76;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp76( f1 numeric zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp76(-999999999);

--disable_warnings
DROP PROCEDURE IF EXISTS sp77;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp77( f1 real)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp77(1.1);

--disable_warnings
DROP PROCEDURE IF EXISTS sp78;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp78( f1 real unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp78(1.1);

--disable_warnings
DROP PROCEDURE IF EXISTS sp79;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp79( f1 real unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp79(1.1);

--disable_warnings
DROP PROCEDURE IF EXISTS sp80;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp80( f1 real zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp80(1.1);

--disable_warnings
DROP PROCEDURE IF EXISTS sp81;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp81( f1 smallint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp81(-32701);

--disable_warnings
DROP PROCEDURE IF EXISTS sp82;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp82( f1 smallint unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp82(65531);

--disable_warnings
DROP PROCEDURE IF EXISTS sp83;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp83( f1 smallint unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp83(65531);

--disable_warnings
DROP PROCEDURE IF EXISTS sp84;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp84( f1 smallint zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp84(-32601);

--disable_warnings
DROP PROCEDURE IF EXISTS sp85;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp85( f1 tinyint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp85(-115);

--disable_warnings
DROP PROCEDURE IF EXISTS sp86;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp86( f1 tinyint unsigned)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp86(251);

--disable_warnings
DROP PROCEDURE IF EXISTS sp87;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp87( f1 tinyint unsigned zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp87(201);

--disable_warnings
DROP PROCEDURE IF EXISTS sp88;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp88( f1 tinyint zerofill)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
  SELECT f1;
END//
delimiter ;//

CALL sp88(-101);

--disable_warnings
DROP PROCEDURE IF EXISTS sp89;
--enable_warnings

#FIXME: check why this is switched off
#delimiter //;
#CREATE PROCEDURE sp89( f1 enum("1enum", "2enum"))
#BEGIN
# if(f1 == "1enum") { set f1 = "2enum"; } else { set f1 = "1enum"; }
# SELECT f1;
#END//
#delimiter ;//

#CALL sp89( '1enum');

--disable_warnings
DROP PROCEDURE IF EXISTS sp90;
--enable_warnings

#FIXME: check why this is switched off
#delimiter //;
#CREATE PROCEDURE sp90( f1 set("1set", "2set"))
#BEGIN
# if(f1 == "1set") { set f1 = "2set"; } else { set f1 = "1set"; }
# SELECT f1;
#END//
#delimiter ;//

#CALL sp90( '1set');

--disable_warnings
DROP PROCEDURE IF EXISTS sp91;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp91( f1 date)
BEGIN
  set f1 = adddate(f1, interval 31 day);
  SELECT f1;
END//
delimiter ;//

CALL sp91( '1997-12-31');

--disable_warnings
DROP PROCEDURE IF EXISTS sp92;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp92( f1 time)
BEGIN
  set f1 = addtime(f1, '02:00:00.999998');
  SELECT f1;
END//
delimiter ;//

CALL sp92( '23:59:59.999999');

--disable_warnings
DROP PROCEDURE IF EXISTS sp93;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp93( f1 datetime)
BEGIN
  set f1 = addtime(f1, '1 1:1:1.000002');
  SELECT f1;
END//
delimiter ;//

CALL sp93('1997-12-31 23:59:59.999999');

--disable_warnings
DROP PROCEDURE IF EXISTS sp94;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp94( f1 char)
BEGIN
  set f1 = concat('a', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp94( 'h');

--disable_warnings
DROP PROCEDURE IF EXISTS sp95;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp95( f1 char ascii)
BEGIN
  set f1 = concat('a', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp95( 'h');


--disable_warnings
DROP PROCEDURE IF EXISTS sp96;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp96( f1 char binary)
BEGIN
  set f1 = concat('a', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp96( 'h');


--disable_warnings
DROP PROCEDURE IF EXISTS sp97;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp97( f1 longtext)
BEGIN
  set f1 = concat('hello', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp97( 'world');

--disable_warnings
DROP PROCEDURE IF EXISTS sp98;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp98( f1 mediumtext)
BEGIN
  set f1 = concat('hello', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp98( 'world');

--disable_warnings
DROP PROCEDURE IF EXISTS sp99;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp99( f1 text)
BEGIN
  set f1 = concat('hello', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp99( 'world');

--disable_warnings
DROP PROCEDURE IF EXISTS sp100;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp100( f1 tinytext)
BEGIN
  set f1 = concat('hello', f1);
  SELECT f1;
END//
delimiter ;//

CALL sp100( 'world');

--disable_warnings
DROP PROCEDURE IF EXISTS sp101;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp101( f1 year)
BEGIN
  set f1 = f1 + 10;
  SELECT f1;
END//
delimiter ;//

CALL sp101(51);

--disable_warnings
DROP PROCEDURE IF EXISTS sp102;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp102( f1 year(4))
BEGIN
  set f1 = f1 + 51;
  SELECT f1;
END//
delimiter ;//

CALL sp102(1982);

--disable_warnings
DROP PROCEDURE IF EXISTS sp103;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp103( f1 geometrycollection)
BEGIN
  set f1 = f1;
  SELECT f1;
END//
delimiter ;//

CALL sp103('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0@');

--disable_warnings
DROP PROCEDURE IF EXISTS sp104;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp104( f1 linestring)
BEGIN
  set f1 = f1;
  SELECT f1;
END//
delimiter ;//

CALL sp104('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0@\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0@');

--disable_warnings
DROP PROCEDURE IF EXISTS sp105;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp105( f1 point)
BEGIN
  set f1 = f1;
  SELECT f1;
END//
delimiter ;//

CALL sp105('\0\0\0\0\0\0\0\0\0\0\0\0\04@\0\0\0\0\0\04@');

--disable_warnings
DROP PROCEDURE IF EXISTS sp106;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp106( f1 polygon)
BEGIN
  set f1 = f1;
  SELECT f1;
END//
delimiter ;//

CALL sp106('\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\04@\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0 @\0\0\0\0\0\0@\0\0\0\0\0\0@');

--disable_warnings
DROP PROCEDURE IF EXISTS sp107;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp107( f1 timestamp)
BEGIN
  set f1 = now() + 0 + f1;
  SELECT f1;
END//
delimiter ;//

--replace_column 1 returned
CALL sp107(2.00e+13);

USE db_storedproc;
DROP DATABASE db1;


# ==============================================================================
# test plan section: 4.5 - parameter checks - multiple data types in stored procedure and functions
# ==============================================================================

--disable_warnings
DROP DATABASE IF EXISTS db1;
--enable_warnings

CREATE DATABASE db1;
USE db1;

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
delimiter //;
CREATE PROCEDURE sp1( in f1 year, inout f2 year, out f3 year, in f4 year,
                     inout f5 year, out f6 year, in f7 year(4), inout f8 year(4),
                     out f9 year(4), in f10 year(4), inout f11 year(4), out f12 year(4))
BEGIN
  set f1 = f1 + 10; set f2 = f2 + 10; set f3 = f2 + 10;
  set f4 = f4 + 10; set f5 = f5 + 10; set f6 = f5 + 10;
  set f7 = f7 + 51; set f8 = f8 + 51; set f9 = f8 + 51;
  set f10 = f10 + 51; set f11 = f11 + 51; set f12 = f11 + 51;
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute01;
delimiter //;
CREATE PROCEDURE spexecute01()
BEGIN
  declare var1 year;
  declare var2 year;
  declare var3 year;
  declare var4 year;
  declare var5 year(4);
  declare var6 year(4);
  declare var7 year(4);
  declare var8 year(4);
  set var1 = 51;
  set var3 = 51;
  set var5 = 1982;
  set var7 = 1982;
  CALL sp1(51, var1, var2, 51, var3, var4, 1982, var5, var6, 1982, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute01();
DROP PROCEDURE spexecute01;
DROP PROCEDURE sp1;


DROP PROCEDURE IF EXISTS sp2;
delimiter //;
CREATE PROCEDURE sp2( in f1 text, inout f2 text, out f3 text, in f4 text, inout f5 text,
                     out f6 text, in f7 tinytext, inout f8 tinytext, out f9 tinytext,
                     in f10 tinytext, inout f11 tinytext, out f12 tinytext)
BEGIN
  set f1 = concat('hello', f1); set f2 = concat('hello', f2); set f3 = concat('hello', f2);
  set f4 = concat('hello', f4); set f5 = concat('hello', f5); set f6 = concat('hello', f5);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f8);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute02;
delimiter //;
CREATE PROCEDURE spexecute02()
BEGIN
  declare var1 text;
  declare var2 text;
  declare var3 text;
  declare var4 text;
  declare var5 tinytext;
  declare var6 tinytext;
  declare var7 tinytext;
  declare var8 tinytext;
  set var1 =  'world';
  set var3 =  'world';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp2( 'world', var1, var2, 'world', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute02();
DROP PROCEDURE spexecute02;
DROP PROCEDURE sp2;


DROP PROCEDURE IF EXISTS sp3;
delimiter //;
CREATE PROCEDURE sp3( in f1 char, inout f2 char, out f3 char, in f4 char ascii,
                     inout f5 char ascii, out f6 char ascii, in f7 longtext,
                     inout f8 longtext, out f9 longtext, in f10 mediumtext,
                     inout f11 mediumtext, out f12 mediumtext)
BEGIN
  set f1 = concat('a', f1); set f2 = concat('a', f2); set f3 = concat('a', f1);
  set f4 = concat('a', f4); set f5 = concat('a', f5); set f6 = concat('a', f4);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f9);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute03;
delimiter //;
CREATE PROCEDURE spexecute03()
BEGIN
  declare var1 char;
  declare var2 char;
  declare var3 char ascii;
  declare var4 char ascii;
  declare var5 longtext;
  declare var6 longtext;
  declare var7 mediumtext;
  declare var8 mediumtext;
  set var1 =  'h';
  set var3 =  'h';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp3( 'h', var1, var2, 'h', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute03();

DROP PROCEDURE spexecute03;
DROP PROCEDURE sp3;


DROP PROCEDURE IF EXISTS sp4;
delimiter //;
CREATE PROCEDURE sp4( in f1 bigint, inout f2 bigint, out f3 bigint,
                     in f4 bigint, inout f5 bigint, out f6 bigint,
                     in f7 bigint, inout f8 bigint, out f9 bigint,
                     in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
   set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10);
   set f6 = f5;
   set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10);
   set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8;
   set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10);
   set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11;
   set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10);
   set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute04;
delimiter //;
CREATE PROCEDURE spexecute04()
BEGIN
  declare var1 bigint;
  declare var2 bigint;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -9.22e+18;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp4(-9.22e+18, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute04();
DROP PROCEDURE spexecute04;
DROP PROCEDURE sp4;

# sp5 removed

DROP PROCEDURE IF EXISTS sp6;
delimiter //;
CREATE PROCEDURE sp6( in f1 timestamp, inout f2 timestamp, out f3 timestamp, in f4 timestamp, inout f5 timestamp, out f6 timestamp, in f7 timestamp, inout f8 timestamp, out f9 timestamp, in f10 timestamp, inout f11 timestamp, out f12 timestamp)
BEGIN
  set f1 = now() + 0 + f1; set f2 = now() + 0 + f2; set f3 = now() + 0 + f1;
  set f4 = now() + 0 + f4; set f5 = now() + 0 + f5; set f6 = now() + 0 + f5;
  set f7 = now() + 0 + f7; set f8 = now() + 0 + f8; set f9 = now() + 0 + f8;
  set f10 = now() + 0 + f10; set f11 = now() + 0 + f11; set f12 = now() + 0 + f11;
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute06;
delimiter //;
CREATE PROCEDURE spexecute06()
BEGIN
  declare var1 timestamp;
  declare var2 timestamp;
  declare var3 timestamp;
  declare var4 timestamp;
  declare var5 timestamp;
  declare var6 timestamp;
  declare var7 timestamp;
  declare var8 timestamp;
  set var1 = 2.00e+13;
  set var3 = 2.00e+13;
  set var5 = 2.00e+13;
  set var7 = 2.00e+13;
  CALL sp6(2.00e+13, var1, var2, 2.00e+13, var3, var4, 2.00e+13, var5, var6, 2.00e+13, var7, var8);
END//
delimiter ;//

--replace_column 1 returned 2 returned 3 returned 4 returned 5 returned 6 returned 7 returned 8 returned 9 returned 10 returned 11 returned 12 returned
CALL spexecute06();
DROP PROCEDURE spexecute06;
DROP PROCEDURE sp6;


DROP PROCEDURE IF EXISTS sp07;
delimiter //;
CREATE PROCEDURE sp07( IN  f1 BIGINT UNSIGNED,
                     INOUT f2 BIGINT UNSIGNED,
                     OUT   f3 BIGINT UNSIGNED,
                     IN    f4 BIGINT,
                     INOUT f5 BIGINT,
                     OUT   f6 BIGINT,
                     IN    f7 BIGINT,
                     INOUT f8 BIGINT,
                     OUT   f9 BIGINT,
                     IN    f10 BIGINT,
                     INOUT f11 BIGINT,
                     OUT   f12 BIGINT)
BEGIN
   SELECT f1, f2, f3;
   SELECT f4, f5, f6;
   SELECT f7, f8, f9;
   SELECT f10, f11, f12;
   set f3 = f2;
   set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
   set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10);
   set f3 = (f3 * 2); set f3 = (f3 - 10); set f3 = (f3 + 10);
   set f6 = f5;
   set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10);
   set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8;
   set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10);
   set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11;
   set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10);
   set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3;
   SELECT f4, f5, f6;
   SELECT f7, f8, f9;
   SELECT f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute07;
delimiter //;
CREATE PROCEDURE spexecute07()
BEGIN
  declare var1 bigint unsigned;
  declare var2 bigint unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 =  1.84e+19;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  SELECT var1, var2;
  SELECT var3, var4;
  SELECT var5, var6;
  SELECT var7, var8;
  CALL sp07( var1, var1, var2, var3, var3, var4,
             var5, var5, var6, var7, var7, var8 );
  SELECT var1, var2;
  SELECT var3, var4;
  SELECT var5, var6;
  SELECT var7, var8;
END//
delimiter ;//

#let $message= FIXME: CALL of spexecute07 temporarily switched off due to differences
#              FIXME: between Linux and Solaris;
#--source include/show_msg80.inc
#FIXME CALL spexecute07();
CALL spexecute07();
DROP PROCEDURE spexecute07;
DROP PROCEDURE sp07;


DROP PROCEDURE IF EXISTS sp8;
delimiter //;
CREATE PROCEDURE sp8( in   f1 bigint unsigned zerofill,
                     inout f2 bigint unsigned zerofill,
                     out   f3 bigint unsigned zerofill,
                     in    f4 bigint,
                     inout f5 bigint,
                     out   f6 bigint,
                     in    f7 bigint,
                     inout f8 bigint,
                     out   f9 bigint,
                     in    f10 bigint,
                     inout f11 bigint,
                     out   f12 bigint)
BEGIN
   set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
   set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10);
   set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5;
   set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10);
   set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8;
   set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10);
   set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11;
   set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10);
   set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute08;
delimiter //;
CREATE PROCEDURE spexecute08()
BEGIN
   declare var1 bigint unsigned zerofill;
   declare var2 bigint unsigned zerofill;
   declare var3 bigint;
   declare var4 bigint;
   declare var5 bigint;
   declare var6 bigint;
   declare var7 bigint;
   declare var8 bigint;
   set var1 = 1.84e+17;
   set var3 = -9.22e+18;
   set var5 = -9.22e+18;
   set var7 = -9.22e+18;
   CALL sp8(1.84e+17, var1, var2, -9.22e+18, var3, var4,
                      -9.22e+18, var5, var6, -9.22e+18, var7, var8);
   SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute08();
DROP PROCEDURE spexecute08;
DROP PROCEDURE sp8;


DROP PROCEDURE IF EXISTS sp9;
delimiter //;
CREATE PROCEDURE sp9( in   f1 bigint zerofill,
                     inout f2 bigint zerofill,
                     out   f3 bigint zerofill,
                     in    f4 bigint,
                     inout f5 bigint,
                     out   f6 bigint,
                     in    f7 bigint,
                     inout f8 bigint,
                     out   f9 bigint,
                     in    f10 bigint,
                     inout f11 bigint,
                     out   f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10);
   set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10);
   set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5;
   set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10);
   set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8;
   set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10);
   set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11;
   set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10);
   set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute09;
delimiter //;
CREATE PROCEDURE spexecute09()
BEGIN
   declare var1 bigint zerofill;
   declare var2 bigint zerofill;
   declare var3 bigint;
   declare var4 bigint;
   declare var5 bigint;
   declare var6 bigint;
   declare var7 bigint;
   declare var8 bigint;
   set var1 = -9.22e+15;
   set var3 = -9.22e+18;
   set var5 = -9.22e+18;
   set var7 = -9.22e+18;
   CALL sp9(-9.22e+15, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
   SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute09();
DROP PROCEDURE spexecute09;
DROP PROCEDURE sp9;


DROP PROCEDURE IF EXISTS sp10;
delimiter //;
CREATE PROCEDURE sp10( in f1 decimal,
                      inout f2 decimal,
                      out f3 decimal,
                      in f4 bigint,
                      inout f5 bigint,
                      out f6 bigint,
                      in f7 bigint,
                      inout f8 bigint,
                      out f9 bigint,
                      in f10 bigint,
                      inout f11 bigint,
                      out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute10;
delimiter //;
CREATE PROCEDURE spexecute10()
BEGIN
   declare var1 decimal;
   declare var2 decimal;
   declare var3 bigint;
   declare var4 bigint;
   declare var5 bigint;
   declare var6 bigint;
   declare var7 bigint;
   declare var8 bigint;
   set var1 = -1.00e+09;
   set var3 = -9.22e+18;
   set var5 = -9.22e+18;
   set var7 = -9.22e+18;
   CALL sp10(-1.00e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
   SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute10();
DROP PROCEDURE spexecute10;
DROP PROCEDURE sp10;


DROP PROCEDURE IF EXISTS sp11;
delimiter //;
CREATE PROCEDURE sp11( in f1 decimal (0), inout f2 decimal (0), out f3 decimal (0), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute11;
delimiter //;
CREATE PROCEDURE spexecute11()
BEGIN
  declare var1 decimal (0);
  declare var2 decimal (0);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = --1.00e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp11(--1.00e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute11();
DROP PROCEDURE spexecute11;
DROP PROCEDURE sp11;


DROP PROCEDURE IF EXISTS sp12;
delimiter //;
CREATE PROCEDURE sp12( in f1 decimal (0) unsigned, inout f2 decimal (0) unsigned, out f3 decimal (0) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute12;
delimiter //;
CREATE PROCEDURE spexecute12()
BEGIN
  declare var1 decimal (0) unsigned;
  declare var2 decimal (0) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 99999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp12(99999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute12();
DROP PROCEDURE spexecute12;
DROP PROCEDURE sp12;


DROP PROCEDURE IF EXISTS sp13;
delimiter //;
CREATE PROCEDURE sp13( in f1 decimal (0, 0) zerofill, inout f2 decimal (0, 0) zerofill, out f3 decimal (0, 0) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute13;
delimiter //;
CREATE PROCEDURE spexecute13()
BEGIN
  declare var1 decimal (0, 0) zerofill;
  declare var2 decimal (0, 0) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -1.00e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp13(-1.00e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute13();
DROP PROCEDURE spexecute13;
DROP PROCEDURE sp13;


DROP PROCEDURE IF EXISTS sp14;
delimiter //;
CREATE PROCEDURE sp14( in f1 decimal (63, 30), inout f2 decimal (63, 30), out f3 decimal (63, 30), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f3 = f2;
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute14;
delimiter //;
CREATE PROCEDURE spexecute14()
BEGIN
  declare var1 decimal (63, 30);
  declare var2 decimal (63, 30);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -1.00e+21;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp14(-1.00e+21, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute14();
DROP PROCEDURE spexecute14;
DROP PROCEDURE sp14;


DROP PROCEDURE IF EXISTS sp15;
delimiter //;
CREATE PROCEDURE sp15( in f1 double, inout f2 double, out f3 double, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute15;
delimiter //;
CREATE PROCEDURE spexecute15()
BEGIN
  declare var1 double;
  declare var2 double;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp15(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute15();
DROP PROCEDURE spexecute15;
DROP PROCEDURE sp15;


DROP PROCEDURE IF EXISTS sp16;
delimiter //;
CREATE PROCEDURE sp16( in f1 double zerofill, inout f2 double zerofill, out f3 double zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute16;
delimiter //;
CREATE PROCEDURE spexecute16()
BEGIN
  declare var1 double zerofill;
  declare var2 double zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp16(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute16();
DROP PROCEDURE spexecute16;
DROP PROCEDURE sp16;


DROP PROCEDURE IF EXISTS sp17;
delimiter //;
CREATE PROCEDURE sp17( in f1 double unsigned, inout f2 double unsigned, out f3 double unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute17;
delimiter //;
CREATE PROCEDURE spexecute17()
BEGIN
  declare var1 double unsigned;
  declare var2 double unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp17(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute17();
DROP PROCEDURE spexecute17;
DROP PROCEDURE sp17;


DROP PROCEDURE IF EXISTS sp18;
delimiter //;
CREATE PROCEDURE sp18( in f1 double unsigned zerofill, inout f2 double unsigned zerofill, out f3 double unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute18;
delimiter //;
CREATE PROCEDURE spexecute18()
BEGIN
  declare var1 double unsigned zerofill;
  declare var2 double unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp18(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute18();
DROP PROCEDURE spexecute18;
DROP PROCEDURE sp18;


DROP PROCEDURE IF EXISTS sp19;
delimiter //;
CREATE PROCEDURE sp19( in f1 float unsigned, inout f2 float unsigned, out f3 float unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute19;
delimiter //;
CREATE PROCEDURE spexecute19()
BEGIN
  declare var1 float unsigned;
  declare var2 float unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp19(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute19();
DROP PROCEDURE spexecute19;
DROP PROCEDURE sp19;


DROP PROCEDURE IF EXISTS sp20;
delimiter //;
CREATE PROCEDURE sp20( in f1 float unsigned zerofill, inout f2 float unsigned zerofill, out f3 float unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute20;
delimiter //;
CREATE PROCEDURE spexecute20()
BEGIN
  declare var1 float unsigned zerofill;
  declare var2 float unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp20(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute20();
DROP PROCEDURE spexecute20;
DROP PROCEDURE sp20;


DROP PROCEDURE IF EXISTS sp21;
delimiter //;
CREATE PROCEDURE sp21( in f1 float zerofill, inout f2 float zerofill, out f3 float zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute21;
delimiter //;
CREATE PROCEDURE spexecute21()
BEGIN
  declare var1 float zerofill;
  declare var2 float zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp21(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute21();
DROP PROCEDURE spexecute21;
DROP PROCEDURE sp21;


DROP PROCEDURE IF EXISTS sp22;
delimiter //;
CREATE PROCEDURE sp22( in f1 float(0), inout f2 float(0), out f3 float(0), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute22;
delimiter //;
CREATE PROCEDURE spexecute22()
BEGIN
  declare var1 float(0);
  declare var2 float(0);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp22(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute22();
DROP PROCEDURE spexecute22;
DROP PROCEDURE sp22;


DROP PROCEDURE IF EXISTS sp23;
delimiter //;
CREATE PROCEDURE sp23( in f1 numeric, inout f2 numeric, out f3 numeric, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute23;
delimiter //;
CREATE PROCEDURE spexecute23()
BEGIN
  declare var1 numeric;
  declare var2 numeric;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp23(-999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute23();
DROP PROCEDURE spexecute23;
DROP PROCEDURE sp23;


DROP PROCEDURE IF EXISTS sp24;
delimiter //;
CREATE PROCEDURE sp24( in f1 real, inout f2 real, out f3 real, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute24;
delimiter //;
CREATE PROCEDURE spexecute24()
BEGIN
  declare var1 real;
  declare var2 real;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.1;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp24(1.1, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute24();
DROP PROCEDURE spexecute24;
DROP PROCEDURE sp24;


DROP PROCEDURE IF EXISTS sp25;
delimiter //;
CREATE PROCEDURE sp25( in f1 smallint, inout f2 smallint, out f3 smallint, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute25;
delimiter //;
CREATE PROCEDURE spexecute25()
BEGIN
  declare var1 smallint;
  declare var2 smallint;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -32701;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp25(-32701, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute25();
DROP PROCEDURE spexecute25;
DROP PROCEDURE sp25;


DROP PROCEDURE IF EXISTS sp26;
delimiter //;
CREATE PROCEDURE sp26( in f1 date, inout f2 date, out f3 date, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
  set f1 = adddate(f1, interval 31 day); set f2 = adddate(f2, interval 31 day); set f3 = adddate(f2, interval 31 day);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute26;
delimiter //;
CREATE PROCEDURE spexecute26()
BEGIN
  declare var1 date;
  declare var2 date;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 =  '1997-12-31';
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp26( '1997-12-31', var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute26();
DROP PROCEDURE spexecute26;
DROP PROCEDURE sp26;


DROP PROCEDURE IF EXISTS sp27;
delimiter //;
CREATE PROCEDURE sp27( in f1 time, inout f2 time, out f3 time, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
  set f1 = addtime(f1, '02:00:00.999998'); set f2 = addtime(f2, '02:00:00.999998'); set f3 = addtime(f2, '02:00:00.999998');
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute27;
delimiter //;
CREATE PROCEDURE spexecute27()
BEGIN
  declare var1 time;
  declare var2 time;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 =  '23:59:59.999999';
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp27( '23:59:59.999999', var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute27();
DROP PROCEDURE spexecute27;
DROP PROCEDURE sp27;


DROP PROCEDURE IF EXISTS sp28;
delimiter //;
CREATE PROCEDURE sp28( in f1 datetime, inout f2 datetime, out f3 datetime, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
  set f1 = addtime(f1, '1 1:1:1.000002'); set f2 = addtime(f2, '1 1:1:1.000002'); set f3 = addtime(f1, '1 1:1:1.000002');
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute28;
delimiter //;
CREATE PROCEDURE spexecute28()
BEGIN
  declare var1 datetime;
  declare var2 datetime;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = '1997-12-31 23:59:59.999999';
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp28('1997-12-31 23:59:59.999999', var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute28();
DROP PROCEDURE spexecute28;
DROP PROCEDURE sp28;


DROP PROCEDURE IF EXISTS sp29;
delimiter //;
CREATE PROCEDURE sp29( in f1 float(0) unsigned, inout f2 float(0) unsigned, out f3 float(0) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute29;
delimiter //;
CREATE PROCEDURE spexecute29()
BEGIN
  declare var1 float(0) unsigned;
  declare var2 float(0) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp29(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute29();
DROP PROCEDURE spexecute29;
DROP PROCEDURE sp29;


DROP PROCEDURE IF EXISTS sp30;
delimiter //;
CREATE PROCEDURE sp30( in f1 float(0) zerofill, inout f2 float(0) zerofill, out f3 float(0) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute30;
delimiter //;
CREATE PROCEDURE spexecute30()
BEGIN
  declare var1 float(0) zerofill;
  declare var2 float(0) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp30(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute30();
DROP PROCEDURE spexecute30;
DROP PROCEDURE sp30;


DROP PROCEDURE IF EXISTS sp31;
delimiter //;
CREATE PROCEDURE sp31( in f1 float(23), inout f2 float(23), out f3 float(23), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute31;
delimiter //;
CREATE PROCEDURE spexecute31()
BEGIN
  declare var1 float(23);
  declare var2 float(23);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp31(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute31();
DROP PROCEDURE spexecute31;
DROP PROCEDURE sp31;


DROP PROCEDURE IF EXISTS sp32;
delimiter //;
CREATE PROCEDURE sp32( in f1 float(23) unsigned, inout f2 float(23) unsigned, out f3 float(23) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute32;
delimiter //;
CREATE PROCEDURE spexecute32()
BEGIN
  declare var1 float(23) unsigned;
  declare var2 float(23) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp32(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute32();
DROP PROCEDURE spexecute32;
DROP PROCEDURE sp32;


DROP PROCEDURE IF EXISTS sp33;
delimiter //;
CREATE PROCEDURE sp33( in f1 float(23) zerofill, inout f2 float(23) zerofill, out f3 float(23) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute33;
delimiter //;
CREATE PROCEDURE spexecute33()
BEGIN
  declare var1 float(23) zerofill;
  declare var2 float(23) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp33(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute33();
DROP PROCEDURE spexecute33;
DROP PROCEDURE sp33;


DROP PROCEDURE IF EXISTS sp34;
delimiter //;
CREATE PROCEDURE sp34( in f1 float(24), inout f2 float(24), out f3 float(24), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute34;
delimiter //;
CREATE PROCEDURE spexecute34()
BEGIN
  declare var1 float(24);
  declare var2 float(24);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp34(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute34();
DROP PROCEDURE spexecute34;
DROP PROCEDURE sp34;


DROP PROCEDURE IF EXISTS sp35;
delimiter //;
CREATE PROCEDURE sp35( in f1 float(24) unsigned, inout f2 float(24) unsigned, out f3 float(24) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute35;
delimiter //;
CREATE PROCEDURE spexecute35()
BEGIN
  declare var1 float(24) unsigned;
  declare var2 float(24) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp35(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute35();
DROP PROCEDURE spexecute35;
DROP PROCEDURE sp35;


DROP PROCEDURE IF EXISTS sp36;
delimiter //;
CREATE PROCEDURE sp36( in f1 float(24) zerofill, inout f2 float(24) zerofill, out f3 float(24) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute36;
delimiter //;
CREATE PROCEDURE spexecute36()
BEGIN
  declare var1 float(24) zerofill;
  declare var2 float(24) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp36(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute36();
DROP PROCEDURE spexecute36;
DROP PROCEDURE sp36;


DROP PROCEDURE IF EXISTS sp37;
delimiter //;
CREATE PROCEDURE sp37( in f1 float(53), inout f2 float(53), out f3 float(53), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute37;
delimiter //;
CREATE PROCEDURE spexecute37()
BEGIN
  declare var1 float(53);
  declare var2 float(53);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp37(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute37();
DROP PROCEDURE spexecute37;
DROP PROCEDURE sp37;


DROP PROCEDURE IF EXISTS sp38;
delimiter //;
CREATE PROCEDURE sp38( in f1 float(53) unsigned, inout f2 float(53) unsigned, out f3 float(53) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute38;
delimiter //;
CREATE PROCEDURE spexecute38()
BEGIN
  declare var1 float(53) unsigned;
  declare var2 float(53) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp38(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute38();
DROP PROCEDURE spexecute38;
DROP PROCEDURE sp38;


DROP PROCEDURE IF EXISTS sp39;
delimiter //;
CREATE PROCEDURE sp39( in f1 float(53) zerofill, inout f2 float(53) zerofill, out f3 float(53) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute39;
delimiter //;
CREATE PROCEDURE spexecute39()
BEGIN
  declare var1 float(53) zerofill;
  declare var2 float(53) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp39(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute39();
DROP PROCEDURE spexecute39;
DROP PROCEDURE sp39;


DROP PROCEDURE IF EXISTS sp40;
delimiter //;
CREATE PROCEDURE sp40( in f1 real unsigned, inout f2 real unsigned, out f3 real unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute40;
delimiter //;
CREATE PROCEDURE spexecute40()
BEGIN
  declare var1 real unsigned;
  declare var2 real unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.1;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp40(1.1, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute40();
DROP PROCEDURE spexecute40;
DROP PROCEDURE sp40;


DROP PROCEDURE IF EXISTS sp41;
delimiter //;
CREATE PROCEDURE sp41( in f1 real unsigned zerofill, inout f2 real unsigned zerofill, out f3 real unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute41;
delimiter //;
CREATE PROCEDURE spexecute41()
BEGIN
  declare var1 real unsigned zerofill;
  declare var2 real unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.1;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp41(1.1, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute41();
DROP PROCEDURE spexecute41;
DROP PROCEDURE sp41;


DROP PROCEDURE IF EXISTS sp42;
delimiter //;
CREATE PROCEDURE sp42( in f1 real zerofill, inout f2 real zerofill, out f3 real zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute42;
delimiter //;
CREATE PROCEDURE spexecute42()
BEGIN
  declare var1 real zerofill;
  declare var2 real zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.1;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp42(1.1, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute42();
DROP PROCEDURE spexecute42;
DROP PROCEDURE sp42;


DROP PROCEDURE IF EXISTS sp43;
delimiter //;
CREATE PROCEDURE sp43( in f1 numeric (0), inout f2 numeric (0), out f3 numeric (0), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute43;
delimiter //;
CREATE PROCEDURE spexecute43()
BEGIN
  declare var1 numeric (0);
  declare var2 numeric (0);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp43(-999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute43();
DROP PROCEDURE spexecute43;
DROP PROCEDURE sp43;


DROP PROCEDURE IF EXISTS sp44;
delimiter //;
CREATE PROCEDURE sp44( in f1 numeric (0) unsigned, inout f2 numeric (0) unsigned, out f3 numeric (0) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute44;
delimiter //;
CREATE PROCEDURE spexecute44()
BEGIN
  declare var1 numeric (0) unsigned;
  declare var2 numeric (0) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 9999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp44(9999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute44();
DROP PROCEDURE spexecute44;
DROP PROCEDURE sp44;


DROP PROCEDURE IF EXISTS sp45;
delimiter //;
CREATE PROCEDURE sp45( in f1 numeric (0) zerofill, inout f2 numeric (0) zerofill, out f3 numeric (0) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute45;
delimiter //;
CREATE PROCEDURE spexecute45()
BEGIN
  declare var1 numeric (0) zerofill;
  declare var2 numeric (0) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -99999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp45(-99999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute45();
DROP PROCEDURE spexecute45;
DROP PROCEDURE sp45;


DROP PROCEDURE IF EXISTS sp46;
delimiter //;
CREATE PROCEDURE sp46( in f1 numeric (0, 0), inout f2 numeric (0, 0), out f3 numeric (0, 0), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute46;
delimiter //;
CREATE PROCEDURE spexecute46()
BEGIN
  declare var1 numeric (0, 0);
  declare var2 numeric (0, 0);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp46(-999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute46();
DROP PROCEDURE spexecute46;
DROP PROCEDURE sp46;


DROP PROCEDURE IF EXISTS sp47;
delimiter //;
CREATE PROCEDURE sp47( in f1 numeric (0, 0) unsigned, inout f2 numeric (0, 0) unsigned, out f3 numeric (0, 0) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute47;
delimiter //;
CREATE PROCEDURE spexecute47()
BEGIN
  declare var1 numeric (0, 0) unsigned;
  declare var2 numeric (0, 0) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 9999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp47(9999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute47();
DROP PROCEDURE spexecute47;
DROP PROCEDURE sp47;


DROP PROCEDURE IF EXISTS sp48;
delimiter //;
CREATE PROCEDURE sp48( in f1 numeric (0, 0) zerofill, inout f2 numeric (0, 0) zerofill, out f3 numeric (0, 0) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute48;
delimiter //;
CREATE PROCEDURE spexecute48()
BEGIN
  declare var1 numeric (0, 0) zerofill;
  declare var2 numeric (0, 0) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -99999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp48(-99999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute48();
DROP PROCEDURE spexecute48;
DROP PROCEDURE sp48;


DROP PROCEDURE IF EXISTS sp49;
delimiter //;
CREATE PROCEDURE sp49( in f1 numeric unsigned, inout f2 numeric unsigned, out f3 numeric unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute49;
delimiter //;
CREATE PROCEDURE spexecute49()
BEGIN
  declare var1 numeric unsigned;
  declare var2 numeric unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp49(-999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute49();
DROP PROCEDURE spexecute49;
DROP PROCEDURE sp49;


DROP PROCEDURE IF EXISTS sp50;
delimiter //;
CREATE PROCEDURE sp50( in f1 numeric unsigned zerofill, inout f2 numeric unsigned zerofill, out f3 numeric unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute50;
delimiter //;
CREATE PROCEDURE spexecute50()
BEGIN
  declare var1 numeric unsigned zerofill;
  declare var2 numeric unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 9999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp50(9999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute50();
DROP PROCEDURE spexecute50;
DROP PROCEDURE sp50;


DROP PROCEDURE IF EXISTS sp51;
delimiter //;
CREATE PROCEDURE sp51( in f1 numeric zerofill, inout f2 numeric zerofill, out f3 numeric zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute51;
delimiter //;
CREATE PROCEDURE spexecute51()
BEGIN
  declare var1 numeric zerofill;
  declare var2 numeric zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -99999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp51(-99999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute51();
DROP PROCEDURE spexecute51;
DROP PROCEDURE sp51;


DROP PROCEDURE IF EXISTS sp52;
delimiter //;
CREATE PROCEDURE sp52( in f1 numeric (63, 30), inout f2 numeric (63, 30), out f3 numeric (63, 30), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute52;
delimiter //;
eval CREATE PROCEDURE spexecute52()
BEGIN
  declare var1 numeric (63, 30);
  declare var2 numeric (63, 30);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_m36;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp52($callvar01m, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: check later again with E+40
CALL spexecute52();
DROP PROCEDURE spexecute52;
DROP PROCEDURE sp52;


DROP PROCEDURE IF EXISTS sp53;
delimiter //;
CREATE PROCEDURE sp53( in f1 numeric (64), inout f2 numeric (64), out f3 numeric (64), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute53;
delimiter //;
eval CREATE PROCEDURE spexecute53()
BEGIN
  declare var1 numeric (64);
  declare var2 numeric (64);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_m40;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp53($callvar01m, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: check later again with E+40
CALL spexecute53();
DROP PROCEDURE spexecute53;
DROP PROCEDURE sp53;


DROP PROCEDURE IF EXISTS sp54;
delimiter //;
CREATE PROCEDURE sp54( in f1 numeric (64) unsigned, inout f2 numeric (64) unsigned, out f3 numeric (64) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute54;
delimiter //;
eval CREATE PROCEDURE spexecute54()
BEGIN
  declare var1 numeric (64) unsigned;
  declare var2 numeric (64) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_40;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp54($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: check later again with E+40
CALL spexecute54();
DROP PROCEDURE spexecute54;
DROP PROCEDURE sp54;


DROP PROCEDURE IF EXISTS sp55;
delimiter //;
CREATE PROCEDURE sp55( in f1 numeric (64) zerofill, inout f2 numeric (64) zerofill, out f3 numeric (64) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute55;
delimiter //;
eval CREATE PROCEDURE spexecute55()
BEGIN
  declare var1 numeric (64) zerofill;
  declare var2 numeric (64) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_m40;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp55($callvar01m, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: check later again with E+40
CALL spexecute55();
DROP PROCEDURE spexecute55;
DROP PROCEDURE sp55;


DROP PROCEDURE IF EXISTS sp56;
delimiter //;
CREATE PROCEDURE sp56( in f1 year, inout f2 year, out f3 year, in f4 year, inout f5 year, out f6 year, in f7 year, inout f8 year, out f9 year, in f10 year, inout f11 year, out f12 year)
BEGIN
  set f1 = f1 + 10; set f2 = f2 + 10; set f3 = f2 + 10;
  set f4 = f4 + 10; set f5 = f5 + 10; set f6 = f5 + 10;
  set f7 = f7 + 10; set f8 = f8 + 10; set f9 = f8 + 10;
  set f10= f10+ 10; set f11 = f11 + 10; set f12 = f11 + 10;
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute56;
delimiter //;
CREATE PROCEDURE spexecute56()
BEGIN
  declare var1 year;
  declare var2 year;
  declare var3 year;
  declare var4 year;
  declare var5 year;
  declare var6 year;
  declare var7 year;
  declare var8 year;
  set var1 = 51;
  set var3 = 51;
  set var5 = 51;
  set var7 = 51;
  CALL sp56(51, var1, var2, 51, var3, var4, 51, var5, var6, 51, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute56();
DROP PROCEDURE spexecute56;
DROP PROCEDURE sp56;


DROP PROCEDURE IF EXISTS sp57;
delimiter //;
CREATE PROCEDURE sp57( in f1 year(4), inout f2 year(4), out f3 year(4), in f4 year(4), inout f5 year(4), out f6 year(4), in f7 year(4), inout f8 year(4), out f9 year(4), in f10 year(4), inout f11 year(4), out f12 year(4))
BEGIN
  set f1 = f1 + 51; set f2 = f2 + 51; set f3 = f2 + 51;
  set f4 = f4 + 51; set f5 = f5 + 51; set f6 = f5 + 51;
  set f7 = f7 + 51; set f8 = f8 + 51; set f9 = f8 + 51;
  set f10 = f10 + 51; set f11 = f11 + 51; set f12 = f11 + 51;
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute57;
delimiter //;
CREATE PROCEDURE spexecute57()
BEGIN
  declare var1 year(4);
  declare var2 year(4);
  declare var3 year(4);
  declare var4 year(4);
  declare var5 year(4);
  declare var6 year(4);
  declare var7 year(4);
  declare var8 year(4);
  set var1 = 1982;
  set var3 = 1982;
  set var5 = 1982;
  set var7 = 1982;
  CALL sp57(1982, var1, var2, 1982, var3, var4, 1982, var5, var6, 1982, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute57();
DROP PROCEDURE spexecute57;
DROP PROCEDURE sp57;


DROP PROCEDURE IF EXISTS sp58;
delimiter //;
CREATE PROCEDURE sp58( in f1 text, inout f2 text, out f3 text, in f4 text, inout f5 text, out f6 text, in f7 text, inout f8 text, out f9 text, in f10 text, inout f11 text, out f12 text)
BEGIN
  set f1 = concat('hello', f1); set f2 = concat('hello', f2); set f3 = concat('hello', f2);
  set f4 = concat('hello', f4); set f5 = concat('hello', f5); set f6 = concat('hello', f5);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f8);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute58;
delimiter //;
CREATE PROCEDURE spexecute58()
BEGIN
  declare var1 text;
  declare var2 text;
  declare var3 text;
  declare var4 text;
  declare var5 text;
  declare var6 text;
  declare var7 text;
  declare var8 text;
  set var1 =  'world';
  set var3 =  'world';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp58( 'world', var1, var2, 'world', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute58();
DROP PROCEDURE spexecute58;
DROP PROCEDURE sp58;


DROP PROCEDURE IF EXISTS sp59;
delimiter //;
CREATE PROCEDURE sp59( in f1 tinytext, inout f2 tinytext, out f3 tinytext, in f4 tinytext, inout f5 tinytext, out f6 tinytext, in f7 tinytext, inout f8 tinytext, out f9 tinytext, in f10 tinytext, inout f11 tinytext, out f12 tinytext)
BEGIN
  set f1 = concat('hello', f1); set f2 = concat('hello', f2); set f3 = concat('hello', f2);
  set f4 = concat('hello', f4); set f5 = concat('hello', f5); set f6 = concat('hello', f5);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f8);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute59;
delimiter //;
CREATE PROCEDURE spexecute59()
BEGIN
  declare var1 tinytext;
  declare var2 tinytext;
  declare var3 tinytext;
  declare var4 tinytext;
  declare var5 tinytext;
  declare var6 tinytext;
  declare var7 tinytext;
  declare var8 tinytext;
  set var1 =  'world';
  set var3 =  'world';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp59( 'world', var1, var2, 'world', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute59();
DROP PROCEDURE spexecute59;
DROP PROCEDURE sp59;


DROP PROCEDURE IF EXISTS sp60;
delimiter //;
CREATE PROCEDURE sp60( in f1 char, inout f2 char, out f3 char, in f4 char, inout f5 char, out f6 char, in f7 char, inout f8 char, out f9 char, in f10 char, inout f11 char, out f12 char)
BEGIN
  set f1 = concat('a', f1); set f2 = concat('a', f2); set f3 = concat('a', f1);
  set f4 = concat('a', f4); set f5 = concat('a', f5); set f6 = concat('a', f5);
  set f7 = concat('a', f7); set f8 = concat('a', f8); set f9 = concat('a', f8);
  set f10 = concat('a', f10); set f11 = concat('a', f11); set f12 = concat('a', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute60;
delimiter //;
CREATE PROCEDURE spexecute60()
BEGIN
  declare var1 char;
  declare var2 char;
  declare var3 char;
  declare var4 char;
  declare var5 char;
  declare var6 char;
  declare var7 char;
  declare var8 char;
  set var1 =  'h';
  set var3 =  'h';
  set var5 =  'h';
  set var7 =  'h';
  CALL sp60( 'h', var1, var2, 'h', var3, var4, 'h', var5, var6, 'h', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute60();
DROP PROCEDURE spexecute60;
DROP PROCEDURE sp60;


DROP PROCEDURE IF EXISTS sp61;
delimiter //;
CREATE PROCEDURE sp61( in f1 char ascii, inout f2 char ascii, out f3 char ascii, in f4 char ascii, inout f5 char ascii, out f6 char ascii, in f7 char ascii, inout f8 char ascii, out f9 char ascii, in f10 char ascii, inout f11 char ascii, out f12 char ascii)
BEGIN
  set f1 = concat('a', f1); set f2 = concat('a', f2); set f3 = concat('a', f2);
  set f4 = concat('a', f4); set f5 = concat('a', f5); set f6 = concat('a', f4);
  set f7 = concat('a', f7); set f8 = concat('a', f8); set f9 = concat('a', f9);
  set f10 = concat('a', f10); set f11 = concat('a', f11); set f12 = concat('a', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute61;
delimiter //;
CREATE PROCEDURE spexecute61()
BEGIN
  declare var1 char ascii;
  declare var2 char ascii;
  declare var3 char ascii;
  declare var4 char ascii;
  declare var5 char ascii;
  declare var6 char ascii;
  declare var7 char ascii;
  declare var8 char ascii;
  set var1 =  'h';
  set var3 =  'h';
  set var5 =  'h';
  set var7 =  'h';
  CALL sp61( 'h', var1, var2, 'h', var3, var4, 'h', var5, var6, 'h', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute61();

DROP PROCEDURE spexecute61;
DROP PROCEDURE sp61;


DROP PROCEDURE IF EXISTS sp62;
delimiter //;
CREATE PROCEDURE sp62( in f1 longtext, inout f2 longtext, out f3 longtext, in f4 longtext, inout f5 longtext, out f6 longtext, in f7 longtext, inout f8 longtext, out f9 longtext, in f10 longtext, inout f11 longtext, out f12 longtext)
BEGIN
  set f1 = concat('hello', f1); set f2 = concat('hello', f2); set f3 = concat('hello', f2);
  set f4 = concat('hello', f4); set f5 = concat('hello', f5); set f6 = concat('hello', f5);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f8);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute62;
delimiter //;
CREATE PROCEDURE spexecute62()
BEGIN
  declare var1 longtext;
  declare var2 longtext;
  declare var3 longtext;
  declare var4 longtext;
  declare var5 longtext;
  declare var6 longtext;
  declare var7 longtext;
  declare var8 longtext;
  set var1 =  'world';
  set var3 =  'world';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp62( 'world', var1, var2, 'world', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute62();
DROP PROCEDURE spexecute62;
DROP PROCEDURE sp62;


DROP PROCEDURE IF EXISTS sp63;
delimiter //;
CREATE PROCEDURE sp63( in f1 mediumtext, inout f2 mediumtext, out f3 mediumtext, in f4 mediumtext, inout f5 mediumtext, out f6 mediumtext, in f7 mediumtext, inout f8 mediumtext, out f9 mediumtext, in f10 mediumtext, inout f11 mediumtext, out f12 mediumtext)
BEGIN
  set f1 = concat('hello', f1); set f2 = concat('hello', f2); set f3 = concat('hello', f3);
  set f4 = concat('hello', f4); set f5 = concat('hello', f5); set f6 = concat('hello', f5);
  set f7 = concat('hello', f7); set f8 = concat('hello', f8); set f9 = concat('hello', f8);
  set f10 = concat('hello', f10); set f11 = concat('hello', f11); set f12 = concat('hello', f11);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute63;
delimiter //;
CREATE PROCEDURE spexecute63()
BEGIN
  declare var1 mediumtext;
  declare var2 mediumtext;
  declare var3 mediumtext;
  declare var4 mediumtext;
  declare var5 mediumtext;
  declare var6 mediumtext;
  declare var7 mediumtext;
  declare var8 mediumtext;
  set var1 =  'world';
  set var3 =  'world';
  set var5 =  'world';
  set var7 =  'world';
  CALL sp63( 'world', var1, var2, 'world', var3, var4, 'world', var5, var6, 'world', var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute63();

DROP PROCEDURE spexecute63;
DROP PROCEDURE sp63;


DROP PROCEDURE IF EXISTS sp64;
delimiter //;
CREATE PROCEDURE sp64( in f1 decimal, inout f2 decimal, out f3 decimal, in f4 decimal, inout f5 decimal, out f6 decimal, in f7 decimal, inout f8 decimal, out f9 decimal, in f10 decimal, inout f11 decimal, out f12 decimal)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f2 / 2); set f3 = (f2 * 2); set f3 = (f2 - 10); set f3 = (f2 + 10);
   set f4 = (f4 / 2); set f4 = (f4 * 2); set f4 = (f4 - 10); set f4 = (f4 + 10); set f5 = (f5 / 2); set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f5 / 2); set f6 = (f5 * 2); set f6 = (f5 - 10); set f6 = (f5 + 10);
   set f7 = (f7 / 2); set f7 = (f7 * 2); set f7 = (f7 - 10); set f7 = (f7 + 10); set f8 = (f8 / 2); set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f8 / 2); set f9 = (f8 * 2); set f9 = (f8 - 10); set f9 = (f8 + 10);
   set f10 = (f10 / 2); set f10 = (f10 * 2); set f10 = (f10 - 10); set f10 = (f10 + 10); set f11 = (f11 / 2); set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f11 / 2); set f12 = (f11 * 2); set f12 = (f11 - 10); set f12 = (f11 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute64;
delimiter //;
CREATE PROCEDURE spexecute64()
BEGIN
  declare var1 decimal;
  declare var2 decimal;
  declare var3 decimal;
  declare var4 decimal;
  declare var5 decimal;
  declare var6 decimal;
  declare var7 decimal;
  declare var8 decimal;
  set var1 = --1.00e+09;
  set var3 = --1.00e+09;
  set var5 = --1.00e+09;
  set var7 = --1.00e+09;
  CALL sp64(--1.00e+09, var1, var2, --1.00e+09, var3, var4, --1.00e+09, var5, var6, --1.00e+09, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute64();
DROP PROCEDURE spexecute64;
DROP PROCEDURE sp64;


DROP PROCEDURE IF EXISTS sp65;
delimiter //;
CREATE PROCEDURE sp65( in f1 decimal (0, 0) unsigned zerofill, inout f2 decimal (0, 0) unsigned zerofill, out f3 decimal (0, 0) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute65;
delimiter //;
CREATE PROCEDURE spexecute65()
BEGIN
  declare var1 decimal (0, 0) unsigned zerofill;
  declare var2 decimal (0, 0) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 999999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp65(999999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute65();
DROP PROCEDURE spexecute65;
DROP PROCEDURE sp65;


DROP PROCEDURE IF EXISTS sp66;
delimiter //;
CREATE PROCEDURE sp66( in f1 decimal (63, 30) unsigned, inout f2 decimal (63, 30) unsigned, out f3 decimal (63, 30) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute66;
delimiter //;
CREATE PROCEDURE spexecute66()
BEGIN
  declare var1 decimal (63, 30) unsigned;
  declare var2 decimal (63, 30) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+16;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp66(1.00e+16, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute66();
DROP PROCEDURE spexecute66;
DROP PROCEDURE sp66;


DROP PROCEDURE IF EXISTS sp67;
delimiter //;
CREATE PROCEDURE sp67( in f1 decimal (63, 30) unsigned zerofill, inout f2 decimal (63, 30) unsigned zerofill, out f3 decimal (63, 30) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute67;
delimiter //;
CREATE PROCEDURE spexecute67()
BEGIN
  declare var1 decimal (63, 30) unsigned zerofill;
  declare var2 decimal (63, 30) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+16;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp67(1.00e+16, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute67();
DROP PROCEDURE spexecute67;
DROP PROCEDURE sp67;


DROP PROCEDURE IF EXISTS sp68;
delimiter //;
CREATE PROCEDURE sp68( in f1 decimal (63, 30) zerofill, inout f2 decimal (63, 30) zerofill, out f3 decimal (63, 30) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute68;
delimiter //;
CREATE PROCEDURE spexecute68()
BEGIN
  declare var1 decimal (63, 30) zerofill;
  declare var2 decimal (63, 30) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -1.00e+21;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp68(-1.00e+21, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute68();
DROP PROCEDURE spexecute68;
DROP PROCEDURE sp68;


DROP PROCEDURE IF EXISTS sp69;
delimiter //;
CREATE PROCEDURE sp69( in f1 decimal (64), inout f2 decimal (64), out f3 decimal (64), in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute69;
delimiter //;
eval CREATE PROCEDURE spexecute69()
BEGIN
  declare var1 decimal (64);
  declare var2 decimal (64);
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_m30;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp69($callvar01m, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute69();
DROP PROCEDURE spexecute69;
DROP PROCEDURE sp69;


DROP PROCEDURE IF EXISTS sp70;
delimiter //;
CREATE PROCEDURE sp70( in f1 decimal (64) unsigned, inout f2 decimal (64) unsigned, out f3 decimal (64) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute70;
delimiter //;
eval CREATE PROCEDURE spexecute70()
BEGIN
  declare var1 decimal (64) unsigned;
  declare var2 decimal (64) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_20;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp70($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute70();
DROP PROCEDURE spexecute70;
DROP PROCEDURE sp70;


DROP PROCEDURE IF EXISTS sp71;
delimiter //;
CREATE PROCEDURE sp71( in f1 decimal (64) unsigned zerofill, inout f2 decimal (64) unsigned zerofill, out f3 decimal (64) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute71;
delimiter //;
eval CREATE PROCEDURE spexecute71()
BEGIN
  declare var1 decimal (64) unsigned zerofill;
  declare var2 decimal (64) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_24;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp71($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute71();
DROP PROCEDURE spexecute71;
DROP PROCEDURE sp71;


DROP PROCEDURE IF EXISTS sp72;
delimiter //;
CREATE PROCEDURE sp72( in f1 decimal (64) zerofill, inout f2 decimal (64) zerofill, out f3 decimal (64) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute72;
delimiter //;
CREATE PROCEDURE spexecute72()
BEGIN
  declare var1 decimal (64) zerofill;
  declare var2 decimal (64) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp72(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute72();
DROP PROCEDURE spexecute72;
DROP PROCEDURE sp72;


DROP PROCEDURE IF EXISTS sp73;
delimiter //;
CREATE PROCEDURE sp73( in f1 decimal unsigned, inout f2 decimal unsigned, out f3 decimal unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute73;
delimiter //;
CREATE PROCEDURE spexecute73()
BEGIN
  declare var1 decimal unsigned;
  declare var2 decimal unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp73(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute73();
DROP PROCEDURE spexecute73;
DROP PROCEDURE sp73;


DROP PROCEDURE IF EXISTS sp74;
delimiter //;
CREATE PROCEDURE sp74( in f1 decimal unsigned zerofill, inout f2 decimal unsigned zerofill, out f3 decimal unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute74;
delimiter //;
CREATE PROCEDURE spexecute74()
BEGIN
  declare var1 decimal unsigned zerofill;
  declare var2 decimal unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp74(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute74();
DROP PROCEDURE spexecute74;
DROP PROCEDURE sp74;


DROP PROCEDURE IF EXISTS sp75;
delimiter //;
CREATE PROCEDURE sp75( in f1 decimal zerofill, inout f2 decimal zerofill, out f3 decimal zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute75;
delimiter //;
CREATE PROCEDURE spexecute75()
BEGIN
  declare var1 decimal zerofill;
  declare var2 decimal zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -1.00e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp75(-1.00e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute75();
DROP PROCEDURE spexecute75;
DROP PROCEDURE sp75;


DROP PROCEDURE IF EXISTS sp76;
delimiter //;
CREATE PROCEDURE sp76( in f1 float(0) unsigned zerofill, inout f2 float(0) unsigned zerofill, out f3 float(0) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute76;
delimiter //;
CREATE PROCEDURE spexecute76()
BEGIN
  declare var1 float(0) unsigned zerofill;
  declare var2 float(0) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp76(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute76();
DROP PROCEDURE spexecute76;
DROP PROCEDURE sp76;


DROP PROCEDURE IF EXISTS sp77;
delimiter //;
CREATE PROCEDURE sp77( in f1 float(23) unsigned zerofill, inout f2 float(23) unsigned zerofill, out f3 float(23) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute77;
delimiter //;
CREATE PROCEDURE spexecute77()
BEGIN
  declare var1 float(23) unsigned zerofill;
  declare var2 float(23) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp77(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute77();
DROP PROCEDURE spexecute77;
DROP PROCEDURE sp77;


DROP PROCEDURE IF EXISTS sp78;
delimiter //;
CREATE PROCEDURE sp78( in f1 float(24) unsigned zerofill, inout f2 float(24) unsigned zerofill, out f3 float(24) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute78;
delimiter //;
CREATE PROCEDURE spexecute78()
BEGIN
  declare var1 float(24) unsigned zerofill;
  declare var2 float(24) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp78(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute78();
DROP PROCEDURE spexecute78;
DROP PROCEDURE sp78;


DROP PROCEDURE IF EXISTS sp79;
delimiter //;
CREATE PROCEDURE sp79( in f1 float(53) unsigned zerofill, inout f2 float(53) unsigned zerofill, out f3 float(53) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute79;
delimiter //;
CREATE PROCEDURE spexecute79()
BEGIN
  declare var1 float(53) unsigned zerofill;
  declare var2 float(53) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 1.00e+00;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp79(1.00e+00, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute79();
DROP PROCEDURE spexecute79;
DROP PROCEDURE sp79;


DROP PROCEDURE IF EXISTS sp80;
delimiter //;
CREATE PROCEDURE sp80( in f1 int, inout f2 int, out f3 int, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute80;
delimiter //;
CREATE PROCEDURE spexecute80()
BEGIN
  declare var1 int;
  declare var2 int;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -2.15e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp80(-2.15e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute80();
DROP PROCEDURE spexecute80;
DROP PROCEDURE sp80;


DROP PROCEDURE IF EXISTS sp81;
delimiter //;
CREATE PROCEDURE sp81( in f1 int unsigned, inout f2 int unsigned, out f3 int unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute81;
delimiter //;
CREATE PROCEDURE spexecute81()
BEGIN
  declare var1 int unsigned;
  declare var2 int unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 4.29e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp81(4.29e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute81();
DROP PROCEDURE spexecute81;
DROP PROCEDURE sp81;


DROP PROCEDURE IF EXISTS sp82;
delimiter //;
CREATE PROCEDURE sp82( in f1 int unsigned zerofill, inout f2 int unsigned zerofill, out f3 int unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute82;
delimiter //;
CREATE PROCEDURE spexecute82()
BEGIN
  declare var1 int unsigned zerofill;
  declare var2 int unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 4.29e+09;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp82(4.29e+09, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute82();
DROP PROCEDURE spexecute82;
DROP PROCEDURE sp82;


DROP PROCEDURE IF EXISTS sp83;
delimiter //;
CREATE PROCEDURE sp83( in f1 int zerofill, inout f2 int zerofill, out f3 int zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute83;
delimiter //;
CREATE PROCEDURE spexecute83()
BEGIN
  declare var1 int zerofill;
  declare var2 int zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 2.15e+08;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp83(2.15e+08, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute83();
DROP PROCEDURE spexecute83;
DROP PROCEDURE sp83;


DROP PROCEDURE IF EXISTS sp84;
delimiter //;
CREATE PROCEDURE sp84( in f1 mediumint, inout f2 mediumint, out f3 mediumint, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute84;
delimiter //;
CREATE PROCEDURE spexecute84()
BEGIN
  declare var1 mediumint;
  declare var2 mediumint;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -8388600;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp84(-8388600, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute84();
DROP PROCEDURE spexecute84;
DROP PROCEDURE sp84;


DROP PROCEDURE IF EXISTS sp85;
delimiter //;
CREATE PROCEDURE sp85( in f1 mediumint unsigned, inout f2 mediumint unsigned, out f3 mediumint unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute85;
delimiter //;
CREATE PROCEDURE spexecute85()
BEGIN
  declare var1 mediumint unsigned;
  declare var2 mediumint unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 16777201;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp85(16777201, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute85();
DROP PROCEDURE spexecute85;
DROP PROCEDURE sp85;


DROP PROCEDURE IF EXISTS sp86;
delimiter //;
CREATE PROCEDURE sp86( in f1 mediumint unsigned zerofill, inout f2 mediumint unsigned zerofill, out f3 mediumint unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute86;
delimiter //;
CREATE PROCEDURE spexecute86()
BEGIN
  declare var1 mediumint unsigned zerofill;
  declare var2 mediumint unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 16777210;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp86(16777210, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute86();
DROP PROCEDURE spexecute86;
DROP PROCEDURE sp86;


DROP PROCEDURE IF EXISTS sp87;
delimiter //;
CREATE PROCEDURE sp87( in f1 mediumint zerofill, inout f2 mediumint zerofill, out f3 mediumint zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute87;
delimiter //;
CREATE PROCEDURE spexecute87()
BEGIN
  declare var1 mediumint zerofill;
  declare var2 mediumint zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -8388601;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp87(-8388601, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute87();
DROP PROCEDURE spexecute87;
DROP PROCEDURE sp87;


DROP PROCEDURE IF EXISTS sp88;
delimiter //;
CREATE PROCEDURE sp88( in f1 numeric (0) unsigned zerofill, inout f2 numeric (0) unsigned zerofill, out f3 numeric (0) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute88;
delimiter //;
CREATE PROCEDURE spexecute88()
BEGIN
  declare var1 numeric (0) unsigned zerofill;
  declare var2 numeric (0) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 99999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp88(99999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute88();
DROP PROCEDURE spexecute88;
DROP PROCEDURE sp88;


DROP PROCEDURE IF EXISTS sp89;
delimiter //;
CREATE PROCEDURE sp89( in f1 numeric (0, 0) unsigned zerofill, inout f2 numeric (0, 0) unsigned zerofill, out f3 numeric (0, 0) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute89;
delimiter //;
CREATE PROCEDURE spexecute89()
BEGIN
  declare var1 numeric (0, 0) unsigned zerofill;
  declare var2 numeric (0, 0) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 99999999;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp89(99999999, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute89();
DROP PROCEDURE spexecute89;
DROP PROCEDURE sp89;


DROP PROCEDURE IF EXISTS sp90;
delimiter //;
CREATE PROCEDURE sp90( in f1 numeric (63, 30) unsigned, inout f2 numeric (63, 30) unsigned, out f3 numeric (63, 30) unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute90;
delimiter //;
eval CREATE PROCEDURE spexecute90()
BEGIN
  declare var1 numeric (63, 30) unsigned;
  declare var2 numeric (63, 30) unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_36;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp90($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute90();
DROP PROCEDURE spexecute90;
DROP PROCEDURE sp90;


DROP PROCEDURE IF EXISTS sp91;
delimiter //;
CREATE PROCEDURE sp91( in f1 numeric (63, 30) unsigned zerofill, inout f2 numeric (63, 30) unsigned zerofill, out f3 numeric (63, 30) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute91;
delimiter //;
eval CREATE PROCEDURE spexecute91()
BEGIN
  declare var1 numeric (63, 30) unsigned zerofill;
  declare var2 numeric (63, 30) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_36;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp91($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute91();
DROP PROCEDURE spexecute91;
DROP PROCEDURE sp91;


DROP PROCEDURE IF EXISTS sp92;
delimiter //;
CREATE PROCEDURE sp92( in f1 numeric (63, 30) zerofill, inout f2 numeric (63, 30) zerofill, out f3 numeric (63, 30) zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute92;
delimiter //;
eval CREATE PROCEDURE spexecute92()
BEGIN
  declare var1 numeric (63, 30) zerofill;
  declare var2 numeric (63, 30) zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_m36;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp92($callvar01m, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute92();
DROP PROCEDURE spexecute92;
DROP PROCEDURE sp92;


DROP PROCEDURE IF EXISTS sp93;
delimiter //;
CREATE PROCEDURE sp93( in f1 numeric (64) unsigned zerofill, inout f2 numeric (64) unsigned zerofill, out f3 numeric (64) unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute93;
delimiter //;
eval CREATE PROCEDURE spexecute93()
BEGIN
  declare var1 numeric (64) unsigned zerofill;
  declare var2 numeric (64) unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = $procvar01_40;
  set var3 = $procvar03;
  set var5 = $procvar05;
  set var7 = $procvar07;
  CALL sp93($callvar01p, var1, var2, $callvar02, var3, var4, $callvar03, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

#FIXME: hpux11 - check later again with E+40
CALL spexecute93();
DROP PROCEDURE spexecute93;
DROP PROCEDURE sp93;


DROP PROCEDURE IF EXISTS sp94;
delimiter //;
CREATE PROCEDURE sp94( in f1 smallint, inout f2 smallint, out f3 smallint, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute94;
delimiter //;
CREATE PROCEDURE spexecute94()
BEGIN
  declare var1 smallint;
  declare var2 smallint;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -32701;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp94(-32701, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute94();
DROP PROCEDURE spexecute94;
DROP PROCEDURE sp94;


DROP PROCEDURE IF EXISTS sp95;
delimiter //;
CREATE PROCEDURE sp95( in f1 smallint unsigned, inout f2 smallint unsigned, out f3 smallint unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute95;
delimiter //;
CREATE PROCEDURE spexecute95()
BEGIN
  declare var1 smallint unsigned;
  declare var2 smallint unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 65531;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp95(65531, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute95();
DROP PROCEDURE spexecute95;
DROP PROCEDURE sp95;


DROP PROCEDURE IF EXISTS sp96;
delimiter //;
CREATE PROCEDURE sp96( in f1 smallint unsigned zerofill, inout f2 smallint unsigned zerofill, out f3 smallint unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute96;
delimiter //;
CREATE PROCEDURE spexecute96()
BEGIN
  declare var1 smallint unsigned zerofill;
  declare var2 smallint unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 65531;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp96(65531, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute96();
DROP PROCEDURE spexecute96;
DROP PROCEDURE sp96;


DROP PROCEDURE IF EXISTS sp97;
delimiter //;
CREATE PROCEDURE sp97( in f1 smallint zerofill, inout f2 smallint zerofill, out f3 smallint zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute97;
delimiter //;
CREATE PROCEDURE spexecute97()
BEGIN
  declare var1 smallint zerofill;
  declare var2 smallint zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -32601;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp97(-32601, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute97();
DROP PROCEDURE spexecute97;
DROP PROCEDURE sp97;


DROP PROCEDURE IF EXISTS sp98;
delimiter //;
CREATE PROCEDURE sp98( in f1 tinyint, inout f2 tinyint, out f3 tinyint, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute98;
delimiter //;
CREATE PROCEDURE spexecute98()
BEGIN
  declare var1 tinyint;
  declare var2 tinyint;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -115;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp98(-115, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute98();
DROP PROCEDURE spexecute98;
DROP PROCEDURE sp98;


DROP PROCEDURE IF EXISTS sp99;
delimiter //;
CREATE PROCEDURE sp99( in f1 tinyint unsigned, inout f2 tinyint unsigned, out f3 tinyint unsigned, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute99;
delimiter //;
CREATE PROCEDURE spexecute99()
BEGIN
  declare var1 tinyint unsigned;
  declare var2 tinyint unsigned;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 251;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp99(251, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute99();
DROP PROCEDURE spexecute99;
DROP PROCEDURE sp99;


DROP PROCEDURE IF EXISTS sp100;
delimiter //;
CREATE PROCEDURE sp100( in f1 tinyint unsigned zerofill, inout f2 tinyint unsigned zerofill, out f3 tinyint unsigned zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
   SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute100;
delimiter //;
CREATE PROCEDURE spexecute100()
BEGIN
  declare var1 tinyint unsigned zerofill;
  declare var2 tinyint unsigned zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = 201;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp100(201, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute100();
DROP PROCEDURE spexecute100;
DROP PROCEDURE sp100;


DROP PROCEDURE IF EXISTS sp101;
delimiter //;
CREATE PROCEDURE sp101( in f1 tinyint zerofill, inout f2 tinyint zerofill, out f3 tinyint zerofill, in f4 bigint, inout f5 bigint, out f6 bigint, in f7 bigint, inout f8 bigint, out f9 bigint, in f10 bigint, inout f11 bigint, out f12 bigint)
BEGIN
   set f1 = (f1 / 2); set f1 = (f1 * 2); set f1 = (f1 - 10); set f1 = (f1 + 10); set f2 = (f2 / 2); set f2 = (f2 * 2); set f2 = (f2 - 10); set f2 = (f2 + 10); set f3 = (f1 / 2); set f3 = (f1 * 2); set f3 = (f1 - 10); set f3 = (f1 + 10);
   set f6 = f5; set f5 = (f5 * 2); set f5 = (f5 - 10); set f5 = (f5 + 10); set f6 = (f6 * 2); set f6 = (f6 - 10); set f6 = (f6 + 10);
   set f9 = f8; set f8 = (f8 * 2); set f8 = (f8 - 10); set f8 = (f8 + 10); set f9 = (f9 * 2); set f9 = (f9 - 10); set f9 = (f9 + 10);
   set f12 = f11; set f11 = (f11 * 2); set f11 = (f11 - 10); set f11 = (f11 + 10); set f12 = (f12 * 2); set f12 = (f12 - 10); set f12 = (f12 + 10);
  SELECT f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12;
END//
delimiter ;//

DROP PROCEDURE IF EXISTS spexecute101;
delimiter //;
CREATE PROCEDURE spexecute101()
BEGIN
  declare var1 tinyint zerofill;
  declare var2 tinyint zerofill;
  declare var3 bigint;
  declare var4 bigint;
  declare var5 bigint;
  declare var6 bigint;
  declare var7 bigint;
  declare var8 bigint;
  set var1 = -101;
  set var3 = -9.22e+18;
  set var5 = -9.22e+18;
  set var7 = -9.22e+18;
  CALL sp101(-101, var1, var2, -9.22e+18, var3, var4, -9.22e+18, var5, var6, -9.22e+18, var7, var8);
  SELECT var1, var2, var3, var4, var5, var6, var7, var8;
END//
delimiter ;//

CALL spexecute101();
DROP PROCEDURE spexecute101;
DROP PROCEDURE sp101;

USE db_storedproc;
DROP DATABASE db1;



USE db_storedproc;
# ------------------------------------------------------------------------------
let $message= Testcase 4.7.2:
FIXME: a wrong testcase number and/or description has been detected here. This
FIXME: needs to be checked to be sure where the missing testcase is located.
.
check for "allow_invalid_dates" server sql mode
;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp2;
drop table IF EXISTS temp_table;
--enable_warnings

create table temp_table (f1 datetime);

set @@sql_mode = 'allow_invalid_dates';

delimiter //;
CREATE PROCEDURE sp2 ()
BEGIN
    declare a datetime;
    set a = '2005-03-14 01:01:02';
    insert into temp_table values(a);
END//
delimiter ;//

show CREATE PROCEDURE sp2;

set @@sql_mode = 'traditional';

CALL sp2 ();
SELECT * from temp_table;

SELECT @@sql_mode;

# cleanup
DROP PROCEDURE sp2;
drop table temp_table;


# ------------------------------------------------------------------------------
let $message= Testcase 4.7.3:
FIXME: a wrong testcase number and/or description has been detected here. This
FIXME: needs to be checked to be sure where the missing testcase is located.
.
check for *high_not_precedence* server sql mode
;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp3;
--enable_warnings

set @@sql_mode = 'high_not_precedence';

delimiter //;
CREATE PROCEDURE sp3()
BEGIN
    declare a int signed;
    declare b int unsigned;
    set a = -5;
    set b = 5;
    SELECT not 1 between a and b;
END//
delimiter ;//

show CREATE PROCEDURE sp3;

set @@sql_mode='';

CALL sp3();
SELECT @@sql_mode;

# cleanup
DROP PROCEDURE sp3;


# ------------------------------------------------------------------------------
let $message= Testcase 4.7.4:
FIXME: a wrong testcase number and/or description has been detected here. This
FIXME: needs to be checked to be sure where the missing testcase is located.
.
check for combination of server sql modes
;
--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS sp4;
--enable_warnings

#FIXME 4.7.4: check it is correct that having a blank after the comma lets this fail:
--error 1231
set @@sql_mode = 'ansi, error_for_division_by_zero';

# now set the corrent value:
set @@sql_mode = 'ansi,error_for_division_by_zero';

SHOW VARIABLES LIKE 'sql_mode';

delimiter //;
CREATE PROCEDURE sp4()
BEGIN
    declare a int;
    declare b int;
    declare c int;
    set a = 0;
    set b = 1;
    set c = b/a;
    show warnings;
END//
delimiter ;//

show CREATE PROCEDURE sp4;

set @@sql_mode='';

CALL sp4();

# cleanup
DROP PROCEDURE sp4;
set @@sql_mode='';


# ==============================================================================
let $message= Section 3.1.8 - SHOW statement checks:;
--source include/show_msg80.inc


USE db_storedproc;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.1:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a procedure is properly recorded and displayed when a show create
#        procedure statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
DROP PROCEDURE IF EXISTS sp6a;
DROP PROCEDURE IF EXISTS sp6b;
DROP PROCEDURE IF EXISTS sp6c;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6a (i1 longtext, out i2 mediumint , inout i3 longblob, in i4 year, out i5 real)
language sql
BEGIN
   set @x=i1;
   set @y=@x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE sp6b (out i1 longtext, out i2 mediumint , out i3 longblob, out i4 year, out i5 real)
deterministic
BEGIN
   set @x=i1;
   set @y=@x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE sp6c (inout i1 longtext, inout  i2 mediumint , inout i3 longblob, inout  i4 year, inout  i5 real) comment 'this is a comment'
BEGIN
   set @x=i1;
   set @y=@x;
END//
delimiter ;//

show CREATE PROCEDURE sp6a;

show CREATE PROCEDURE sp6b;

show CREATE PROCEDURE sp6c;

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6a';

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6b';

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6c';

# cleanup
DROP PROCEDURE sp6a;
DROP PROCEDURE sp6b;
DROP PROCEDURE sp6c;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.2:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a procedure is properly recorded and displayed when a show procedure
#      status statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x=i1;
      set @y=@x;
END//
delimiter ;//

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6';

# cleanup
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.3:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a procedure is not displayed when a show create function
#      statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x=i1;
    set @y=@x;
END//
delimiter ;//

--error 1305
SHOW CREATE FUNCTION sp6;

# cleanup
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.4:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a procedure is properly recorded and displayed when a show function
#      status statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE FUNCTION sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real) returns longtext
  BEGIN
    set @x=i1;
    set @y=@x;
    return 0;
END//
delimiter ;//

--replace_column 5 modified 6 created
  show  function status like 'sp6';

# cleanup
DROP FUNCTION sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.5:;
--source include/show_msg80.inc

# testcase: ensure that the attempt to execute show CREATE PROCEDURE with the name of a non-existing
#      procedure fails with an appropriate error message.

--disable_warnings
DROP PROCEDURE IF EXISTS sp7;
--enable_warnings

--error 1305
  show CREATE PROCEDURE sp7;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.6:;
--source include/show_msg80.inc

# testcase: ensure that the attempt to execute SHOW PROCEDURE status with the name of a non-existing
#          procedure returns an empty set.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

    show  procedure status like 'sp6';



# ------------------------------------------------------------------------------
let $message= Testcase 4.8.7:;
--source include/show_msg80.inc

# testcase: ensure that an attempt to execute show CREATE PROCEDURE with the name of a function fails
#      with an appropriate error message.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (i1 real) returns real
  BEGIN
    return i1;
END//
delimiter ;//

--error 1305
  show CREATE PROCEDURE fn1;

# cleanup
DROP FUNCTION fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.8:;
--source include/show_msg80.inc

# testcase: ensure that an attempt to execute SHOW PROCEDURE status with the name of a
#        function returns an empty set.


--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (i1 real) returns real
  BEGIN
    return i1;
END//
delimiter ;//

--replace_column 5 modified 6 created
  show  procedure status like 'fn1';

# cleanup
DROP FUNCTION fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.9:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a function is properly recorded and displayed when a
#        show CREATE FUNCTION statement is executed.

# part of 3.1.8.9

# ------------------------------------------------------------------------------
let $message= Testcase 4.8.10:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a function is properly recorded and displayed when a
# SHOW FUNCTION status.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (i1 real) returns real
BEGIN
   return i1;
END//
delimiter ;//

--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';

# cleanup
DROP FUNCTION fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.11:;
--source include/show_msg80.inc

# testcase: ensure that the definition of a function is not displayed when a
#        show CREATE PROCEDURE statement is executed.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (x int) returns int
  BEGIN
    return x;
END//
delimiter ;//

--error 1305
  show CREATE PROCEDURE fn1;

# cleanup
DROP FUNCTION fn1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.8.12:;
--source include/show_msg80.inc

# testcase: ensure that the attempt to execute show CREATE FUNCTION with the name of a
#      non-existing function fails with an appropriate error message.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1(x int) returns int
  BEGIN
            return x;
END//
delimiter ;//

DROP FUNCTION fn1;

--error 1305
  show CREATE FUNCTION fn1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.8.13:;
--source include/show_msg80.inc

# testcase: ensure that the attempt to execute show function status  with the name of a
#      non-existing function returns an empty set.


--disable_warnings
DROP FUNCTION IF EXISTS f1000;
--enable warnings

SHOW FUNCTION STATUS LIKE 'f1000';


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.14:;
--source include/show_msg80.inc

# testcase: ensure that an attempt to execute show CREATE FUNCTION with the name of a procedure
#        fails with an appropriate error message.

--disable_warnings
DROP PROCEDURE IF EXISTS sp1;
--enable_warnibgs

delimiter //;
CREATE PROCEDURE sp1()
BEGIN
    SELECT * from t8;
END//
delimiter ;//

--error 1305
  show CREATE FUNCTION sp1;

# cleanup
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.15:;
--source include/show_msg80.inc

# testcase: ensure that an attempt to execute show function status with the name of a procedure fails with an
#      appropriate error message.


--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x=i1;
    set @y=@x;
END//
delimiter ;//

--replace_column 5 modified 6 created
  show  function status like 'sp6';

# cleanup
DROP PROCEDURE sp6;



# ------------------------------------------------------------------------------
let $message= Testcase 4.8.16:;
--source include/show_msg80.inc

# testcase: ensure that all stored procedure changes made with alter procedure are properly recorded
#      and displayed when a  show CREATE PROCEDURE statement is executed.

# part of 3.1.8.9


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.17:;
--source include/show_msg80.inc

# testcase: ensure that all stored procedure changes made with alter procedure are properly recorded
#      and displayed when a  SHOW PROCEDURE status statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x=i1;
    set @y=@x;
END//
delimiter ;//

  alter procedure sp6 sql security invoker;

  alter procedure sp6 comment  'this is a new comment';

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6';

# cleanup
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.18:;
--source include/show_msg80.inc

# testcase: ensure that all stored procedure changes made with alter function are properly recorded
#        and displayed when a show CREATE FUNCTION statement is executed.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (x int) returns int
  BEGIN
    return x;
END//
delimiter ;//

  alter function fn1 sql security invoker;

  show  create  function  fn1;

# cleanup
DROP FUNCTION fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.19:;
--source include/show_msg80.inc

# testcase: ensure that all function changes made with alter function are properly recorded and
#      displayed when a show  function status statement is executed.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (i1 longtext) returns longtext
  BEGIN
    return i1;
END//
delimiter ;//

  alter function fn1 sql security invoker;
  alter function fn1 comment 'this is a function 3242#@%$#@';

#FIXME: check why here no rows are shown
--replace_column 5 modified 6 created
  show  function status like 'fn1';

# cleanup
DROP FUNCTION fn1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.8.20:;
--source include/show_msg80.inc

# testcase: ensure that all stored procedure changes made with alter procedure are properly
#      recorded and displayed   when a show CREATE PROCEDURE statement is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 int , i2 int)
BEGIN
    set @x=i1;
    set @y=@x;
END//
delimiter ;//

  alter procedure sp6 comment 'this is simple';

  show CREATE PROCEDURE sp6;

# cleanup
DROP PROCEDURE sp6;

# ------------------------------------------------------------------------------
let $message= Testcase 4.8.21:;
--source include/show_msg80.inc

# testcase: ensure that when a stored procedure is dropped, its definition no longer appears when
#      a show CREATE PROCEDURE is executed.

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 int, i2 int)
BEGIN
    set @x=i1;
    set @y=@x;
END//
delimiter ;//

DROP PROCEDURE sp6;

--error 1305
  show CREATE PROCEDURE sp6;

# ------------------------------------------------------------------------------
let $message= Testcase 4.8.22:;
--source include/show_msg80.inc

# testcase: ensure that when a stored procedure is dropped, its definition no longer appears when
#      SHOW PROCEDURE status.


--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x=i3;
    set @y=@x;
END//
delimiter ;//

DROP PROCEDURE sp6;

--replace_column 5 modified 6 created
SHOW PROCEDURE status like 'sp6';


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.23:;
--source include/show_msg80.inc

# testcase: ensure that when a stored procedure is dropped, its definition no longer appears
#      when a statement or a show CREATE FUNCTION statement is executed.

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (x int) returns int
  BEGIN
    return x;
END//
delimiter ;//

DROP FUNCTION fn1;

--error 1305
  show CREATE FUNCTION fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.8.24:;
--source include/show_msg80.inc

# testcase: ensure that when a function is dropped, its definition no longer appears when a
# SHOW FUNCTION status statement is executed.
# suppressed: the test does not display an error message. it just returns an empty set

--disable_warnings
DROP FUNCTION IF EXISTS fn1;
--enable_warnings

delimiter //;
CREATE FUNCTION fn1 (i1 longtext) returns longtext
BEGIN
    return i1;
END//
delimiter ;//

DROP FUNCTION fn1;

#FIXME: check why here no rows are shown
--replace_column 5 modified 6 created
SHOW FUNCTION STATUS LIKE 'fn1';


# ==============================================================================
let $message= Section 3.1.9 - Routine body checks:;
--source include/show_msg80.inc

USE db_storedproc;

# ------------------------------------------------------------------------------
let $message= Testcase 4.9.1:;
--source include/show_msg80.inc

# testcase: verify SELECT sql statements that may be executed by a stored procedure.
#

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x = i3;
    set @a = i5;
    set @y = @x;
    set @b = @a;
    SELECT * from t9 limit 0, 100;
END//
delimiter ;//

CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;


# ------------------------------------------------------------------------------
let $message= Testcase 4.9.2:;
--source include/show_msg80.inc

# testcase: verify insert sql statements that can be executed by a stored procedure.
#

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
drop  table IF EXISTS res_t9;
--enable_warnings

  create table res_t9 (f1 int, f2 char(25), f3 int);

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x = i3;
    set @a = i5;
    set @y = @x;
    set @b = @a;
    insert into res_t9 values (@y, @a, 111);
    SELECT * from res_t9;
END//
delimiter ;//

CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;
drop table res_t9;


# ------------------------------------------------------------------------------
let $message= Testcase 4.9.3:;
--source include/show_msg80.inc

# testcase: verify delete sql statements that may be executed by a stored procedure.
#

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
drop  table IF EXISTS res_t9;
--enable_warnings

  create table res_t9 (f1 int, f2 char(25), f3 int);

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x = i3;
    set @a = i5;
    set @y = @x;
    set @b = @a;
    insert into res_t9 values (@y, @a, 111);
    SELECT * from res_t9;
    delete from res_t9;
    SELECT * from res_t9;
END//
delimiter ;//


CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;
drop table res_t9;


# ------------------------------------------------------------------------------
let $message= Testcase 4.9.4:;
--source include/show_msg80.inc

# testcase: verify update sql statements that may be executed by a stored procedure.
#

--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
drop  table IF EXISTS res_t9;
--enable_warnings

  create table res_t9 (f1 int, f2 char(25), f3 int);

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x = i3;
    set @a = i5;
    set @y = @x;
    set @b = @a;
    insert into res_t9 values (@y, @a, 111);
    SELECT * from res_t9;
    update res_t9 set f2 = 1000 where f2 = 50;
    SELECT * from res_t9;
END//
delimiter ;//

CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;
drop table res_t9;


# ------------------------------------------------------------------------------
let $message= Testcase 4.9.5:;
--source include/show_msg80.inc

# testcase: verify create sql statements that may be executed by a stored procedure
#
--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
drop table IF EXISTS res_t9;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
   set @x = i1;
   set @y = i3;
   set @z = i5;
   set @a = @x;
   set @b = @y;
   set @c = @z;
   create table res_t9(f1 longtext, f2 longblob, f3 real);
   insert into res_t9 values (@a, @b, @c);
   SELECT * from res_t9;
END//
delimiter ;//

#FIXME Bug:  (Bug#9079)
# suppressed: currenlty the table creation from within sproc fails!
#FIXME check why this NOW works--error 1146
CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;
--disable_warnings
drop table IF EXISTS res_t9;
--enable_warnings

# ------------------------------------------------------------------------------
let $message= Testcase 4.9.6:;
--source include/show_msg80.inc

# testcase:  verify select/insert/update/create statements are disallowed in a function.
# updated testcase:  verify select/insert/update/create statements are ALLOWED in a function.
#
DROP FUNCTION IF EXISTS fn1;

delimiter //;
#FIXME: check this is OK: failed: 1415: Not allowed to return a result set from a function
--error 1415
CREATE FUNCTION fn1(i1 longtext) returns longtext
BEGIN
   SELECT * from t9 limit 0, 100;
   return i1;
END//
delimiter ;//

DROP FUNCTION IF EXISTS fn1;
drop table IF EXISTS res_t9;

create table res_t9 (f1 int, f2 char(25), f3 int);
insert into res_t9 values (10, 'abc', 20);

delimiter //;
#FIXME: check this is OK: failed: 1422: Explicit or implicit commit is not allowed in stored function or trigger.
--error 1422
CREATE FUNCTION fn1(i1 longtext) returns longtext
BEGIN
   delete from res_t9;
   drop table res_t9;
   return i1;
END//
delimiter ;//

DROP FUNCTION IF EXISTS fn1;
drop table IF EXISTS res_t9;

delimiter //;
#FIXME: check this is OK: failed: 1422: Explicit or implicit commit is not allowed in stored function or trigger.
--error 1422
CREATE FUNCTION fn1(i1 longtext) returns longtext
BEGIN
    create table res_t9 (f1 longtext, f2 longblob, f3 real);
    drop table res_t9;
    return i1;
END//
delimiter ;//

DROP FUNCTION IF EXISTS fn1;
drop  table IF EXISTS res_t9;

create table res_t9 (f1 int, f2 char(25), f3 int);

delimiter //;
#FIXME: check this is OK: failed: 1422: Explicit or implicit commit is not allowed in stored function or trigger.
--error 1422
CREATE FUNCTION fn1(i1 longtext) returns longtext
BEGIN
   insert into res_t9 values (100, 'abc', 300);
   drop table res_t9;
   return i1;
END//
delimiter ;//

DROP FUNCTION IF EXISTS fn1;
drop  table IF EXISTS res_t9;

create table res_t9 (f1 int, f2 char(25), f3 int);
insert into res_t9 values (10, 'abc', 20);

delimiter //;
#FIXME: check this is OK: failed: 1422: Explicit or implicit commit is not allowed in stored function or trigger.
--error 1422
CREATE FUNCTION fn1(i1 longtext) returns longtext
BEGIN
   update res_t9 set f1 = 20;
   drop table res_t9;
   return i1;
END//
delimiter ;//

# cleanup
drop table res_t9;
DROP FUNCTION IF EXISTS fn1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.9.7:;
--source include/show_msg80.inc

# testcase: verify create index sql statement that may be executed by a stored procedure
#
--disable_warnings
DROP PROCEDURE IF EXISTS sp6;
drop table IF EXISTS res_t9;
--enable_warnings

  create table res_t9 (f1 longtext, f2 longblob, f3 real);

delimiter //;
CREATE PROCEDURE sp6 (i1 longtext, i2 mediumint , i3 longblob, i4 year, i5 real)
BEGIN
    set @x = i1;
    set @y = i3;
    set @z = i5;
    set @a = @x;
    set @b = @y;
    set @c = @z;
    insert into res_t9 values (@a, @b, @c);
    SELECT * from res_t9;
    create index index_1 on res_t9 (f1 (5));
    show index from res_t9;
END//
delimiter ;//

CALL sp6 (10, 20, 30, 40, 50);

# cleanup
DROP PROCEDURE sp6;
drop table res_t9;


# ==============================================================================
#
# test plan section: 4.11 - verify handlers with continue and exit conditions
#
# ==============================================================================
let $message= Section 3.1._ - :;
--source include/show_msg80.inc

USE db_storedproc;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.1:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1318 (er_sp_wrong_no_of_args)
--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for 1318 set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.2:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1305 (er_sp_does_not_exist)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for 1305 set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.3:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1318 (er_sp_wrong_no_of_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @xx=1;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare exit handler for 1318 set @x2 = 1;
    set @x=1;
    set @x2=0;
  CALL sp1 (1);
    set @x=0;
END//
delimiter ;//

CALL h1();

  SELECT @x, @x2;

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.4:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1305 (er_sp_does_not_exist)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare exit handler for 1305 set @x2 = 1;
    set @x=1;
    set @x2=0;
  CALL sp1 (1);
    set @x=0;
END//
delimiter ;//

CALL h1 ();

  SELECT @x, @x2;

# cleanup
DROP PROCEDURE h1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.5:;
--source include/show_msg80.inc

# testcase: verify undo handler for error code 1318 (er_sp_wrong_no_of_args)


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for 1318 set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.6:;
--source include/show_msg80.inc

# testcase: verify undo handler for error code 1305 (er_sp_does_not_exist)


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for 1318 set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.7:;
--source include/show_msg80.inc

# testcase: verify continue handler for sql state 42000 (er_sp_wrong_no_of_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for sqlstate '42000' set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.8:;
--source include/show_msg80.inc

# testcase: verify continue handler for sql state 42000 (er_sp_does_not_exist)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings


delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for sqlstate '42000' set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.9:;
--source include/show_msg80.inc

# testcase: verify exit handler for sql state 42000 (er_sp_wrong_no_of_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @xx=1;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare exit handler for sqlstate '42000' set @x2 = 1;
    set @x=1;
    set @x2=0;
  CALL sp1 (1);
    set @x=0;
END//
delimiter ;//

CALL h1();

  SELECT @x, @x2;

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.10:;
--source include/show_msg80.inc

# testcase: verify exit handler for sql state 42000 (er_sp_does_not_exist)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare exit handler for sqlstate '42000' set @x2 = 1;
    set @x=1;
    set @x2=0;
  CALL sp1 (1);
    set @x=0;
END//
delimiter ;//

CALL h1 ();
  SELECT @x, @x2;

# cleanup
DROP PROCEDURE h1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.11:;
--source include/show_msg80.inc

# testcase: verify undo handler for sql state 42000 (er_sp_wrong_no_of_args)
# ?????????????

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for sqlstate '42000' set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.12:;
--source include/show_msg80.inc

# testcase: verify undo handler for sql state 42000 (er_sp_does_not_exist)


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP PROCEDURE IF EXISTS sp1;
--enable_warnings

delimiter //;
CREATE PROCEDURE sp1 (x int, y int)
BEGIN
    set @y=x;
END//
delimiter ;//

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare continue handler for sqlstate '42000' set @x2 = 1;
    set @x=0;
  CALL sp1 (1);
    set @x=1;
    SELECT @x, @x2;
END//
delimiter ;//

CALL h1 ();

# cleanup
DROP PROCEDURE h1;
DROP PROCEDURE sp1;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.13:;
--source include/show_msg80.inc

# testcase: verify continue handler for sql state 02000 (er_sp_fetch_no_data)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    repeat
      SELECT done;
      fetch cur1 into a, b;
      SELECT done;
      if not done then
        insert into res_t2 values (a, b);
      END if;
    until done END repeat;
    SELECT done;
    close cur1;
END//
delimiter ;//

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.14:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1329 (er_sp_fetch_no_data)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;

  create table res_t1(w char, x char);

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    repeat
      SELECT done;
      fetch cur1 into a, b;
      SELECT done;
      if not done then
        insert into res_t2 values (a, b);
      END if;
    until done END repeat;
    SELECT done;
    close cur1;
END//
delimiter ;//

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.15:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1329 (er_sp_fetch_no_data)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    repeat
      SELECT done;
      set @x=0;
      fetch cur1 into a, b;
      SELECT @x=1;
      if not done then
        insert into res_t2 values (a, b);
      END if;
    until done END repeat;
    SELECT done;
    close cur1;
END//
delimiter ;//

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.16:;
--source include/show_msg80.inc

# testcase: verify exit handler for sql state '02000' (er_sp_fetch_no_data)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '02000' set done = 1;
    open cur1;
    repeat
      SELECT done;
      set @x=0;
      fetch cur1 into a, b;
      SELECT @x=1;
      if not done then
        insert into res_t2 values (a, b);
      END if;
      until done END repeat;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1()

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.17:;
--source include/show_msg80.inc

# testcase: verify continue handler for sql state HY000 (er_sp_wrong_no_of_fetch_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate 'HY000' set done = 1;
    open cur1;
    SELECT done;
    fetch cur1 into a;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.18:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1328 (er_sp_wrong_no_of_fetch_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for 1328 set done = 1;
    open cur1;
    SELECT done;
    fetch cur1 into a;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.19:;
--source include/show_msg80.inc

# testcase: verify exit handler for sql state HY000 (er_sp_wrong_no_of_fetch_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for sqlstate 'HY000' set done = 1;
    open cur1;
    SELECT done;
    set @x=0;
    fetch cur1 into a;
    set @x=1;
    SELECT done, @x;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.20:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1328 (er_sp_wrong_no_of_fetch_args)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for 1328 set done = 1;
    open cur1;
    SELECT done;
    set @x=0;
    fetch cur1 into a;
    set @x=1;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.21:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1325 (er_sp_cursor_already_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for 1325 set done = 1;
    open cur1;
    SELECT done;
    open cur1;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.22:;
--source include/show_msg80.inc

# testcase: verify continue handler for sqlstate 24000 (er_sp_cursor_already_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for 1325 set done = 1;
    open cur1;
    SELECT done;
    open cur1;
    set @x=1;
    SELECT done, @x;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.23:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1325 (er_sp_cursor_already_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for 1325 set done = 1;
    open cur1;
    set @x=0;
    SELECT done;
    open cur1;
    set @x=1;
    SELECT done;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.24:;
--source include/show_msg80.inc

# testcase: verify exit handler for sqlstate 24000 (er_sp_cursor_already_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for sqlstate '24000' set done = 1;
    open cur1;
    set @x=0;
    SELECT done;
    open cur1;
    set @x=1;
    SELECT done, @x;
    close cur1;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.25:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1326 (er_sp_cursor_not_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for 1326 set done = 1;
    set @x=0;
    fetch cur1 into a, b;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;



# ------------------------------------------------------------------------------
let $message= Testcase 4.11.26:;
--source include/show_msg80.inc

# testcase: verify continue handler for sqlstate 24000 (er_sp_cursor_not_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '24000' set done = 1;
    set @x=0;
    fetch cur1 into a, b;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.27:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1326 (er_sp_cursor_not_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for 1326 set done = 1;
    set @x=0;
    fetch cur1 into a, b;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.28:;
--source include/show_msg80.inc

# testcase: verify exit handler for sqlstate 24000 (er_sp_cursor_not_open)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for sqlstate '24000' set done = 1;
    set @x=0;
    fetch cur1 into a, b;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.29:;
--source include/show_msg80.inc

# testcase: verify continue handler for error code 1339 (er_sp_case_not_found)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for 1339 set done = 1;
    set @x=0;
    case @x
          when 1 then set @x=10;
          when 2 then set @x=11;
    END case;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.30:;
--source include/show_msg80.inc

# testcase: verify continue handler for sqlstate 20000 (er_sp_case_not_found)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare continue handler for sqlstate '20000' set done = 1;
    set @x=0;
    case @x
          when 1 then set @x=10;
          when 2 then set @x=11;
    END case;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.31:;
--source include/show_msg80.inc

# testcase: verify exit handler for error code 1339 (er_sp_case_not_found)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for 1339 set done = 1;
    set @x=0;
    case @x
          when 1 then set @x=10;
          when 2 then set @x=11;
    END case;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.32:;
--source include/show_msg80.inc

# testcase: verify exit handler for sqlstate 20000 (er_sp_case_not_found)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
drop table IF EXISTS res_t2;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

  create table res_t2(y char, z char);

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    declare done int default 0;
    declare a, b char;
    declare cur1 cursor for SELECT w, x from res_t1;
    declare exit handler for sqlstate '20000' set done = 1;
    set @x=0;
    case @x
          when 1 then set @x=10;
          when 2 then set @x=11;
    END case;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

CALL h1();

# cleanup
DROP PROCEDURE h1;
drop table res_t1;
drop table res_t2;

# ------------------------------------------------------------------------------
let $message= Testcase 4.11.33:;
--source include/show_msg80.inc

# testcase: ensure that no two conditions declared with the same scope may have the same condition name.
#            (same condition name in same scope)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
--enable_warnings

  create table res_t1(w char, x char);

  insert into res_t1 values('a', 'b');
  insert into res_t1 values('c', 'd');

delimiter //;
--error 1332
CREATE PROCEDURE h1()
BEGIN
      declare condname condition for sqlstate '20000';
    declare done int default 0;
      declare a, b char;
      declare condname condition for sqlstate '20000';
      declare cur1 cursor for SELECT w, x from t1;
    set @x=2;
    case @x
      when 1 then set @x=10;
        when 2 then set @x=11;
    END case;
    set @x=1;
    SELECT done, @x;
END//
delimiter ;//

# cleanup
drop table res_t1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.35:;

# Ensure that every sqlstate value declared with a declare condition for
# statement and declare handler is a character string that is 5 character and
# cannot be an invalid state.;

--source include/show_msg80.inc

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
--enable_warnings

CREATE TABLE res_t1(w INT UNIQUE, x CHAR);

insert into res_t1 values (1, 'a');

delimiter //;

--error 1407
CREATE PROCEDURE h1 ()
begin1_label:BEGIN
   declare condname1 condition for sqlstate '020';
   declare condname2 condition for sqlstate 'wewe';
   declare condname3 condition for 9999;
   declare exit handler for sqlstate '020' set @var1 = 1;
   declare exit handler for sqlstate 'wewe'set @var1 = 1;
   declare exit handler for 9999 set @var1 = 1;
   set @var2 = 1;
   insert into res_t1 values (2, 'b');
   begin2_label: BEGIN
      declare continue handler for sqlstate '90000023' set @var3= 1;
      set @var4 = 1;
      insert into res_t1 values (3, 'c');
   END begin2_label;
END begin1_label//

# FIXME: same statement except the 3 lines containing 'exit'
#-# --error 1407
#-# CREATE PROCEDURE h1 ()
#-# begin1_label:BEGIN
#-#    declare condname1 condition for sqlstate '020';
#-#    declare condname2 condition for sqlstate 'wewe';
#-#    declare condname3 condition for 9999;
#-#    set @var2 = 1;
#-#    insert into res_t1 values (2, 'b');
#-#    begin2_label: BEGIN
#-#       declare continue handler for sqlstate '90000023 set @var3= 1;
#-#       set @var4 = 1;
#-#       insert into res_t1 values (3, 'c');
#-#    END begin2_label;
#-# END begin1_label//
delimiter ;//

# cleanup
drop table res_t1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.36:;
--source include/show_msg80.inc

# testcase: ensure that the declare  condition for statement cannot declare a condition for the successful
#            completion sqlstate:  00000.


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare x1 int default 0;
    BEGIN
        declare condname1 condition for sqlstate '00000';
      declare exit handler for condname1 set @x = 1;
      set x1 = 1;
      set x1 = 2;
    END;
    SELECT @x, x1;
END//
delimiter ;//

# cleanup
DROP PROCEDURE h1;






# ------------------------------------------------------------------------------
let $message= Testcase 4.11.40:;
--source include/show_msg80.inc

# testcase: ensure that within the same scope, no two handlers may be declared for the same condition
# Bug (


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
drop table IF EXISTS res_t1;
--enable_warnings

  create table res_t1(w char unique, x char);
  insert into res_t1 values ('a', 'b');

# suppressed--error for having two similar handlers in the same scope

delimiter //;
#FIXME 3.1.11.40: check whether error 1413 is OK
--error 1413
CREATE PROCEDURE h1 ()
BEGIN
    declare x1, x2, x3, x4, x5 int default 0;
    declare condname1 condition for sqlstate '42000';
    declare condname2 condition for sqlstate '42000';
    declare continue handler for condname1 set x1 = 1;
    declare continue handler for condname1 set x2 = 1;
    declare exit handler for condname1 set x3 = 1;
    declare continue handler for condname2 set x4 = 1;
    declare exit handler for condname2 set x5 = 1;
END//
delimiter ;//

#FIXME 3.1.11.40: CALL h1();

# cleanup
--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings
drop table res_t1;


# ------------------------------------------------------------------------------
let $message= Testcase 4.11.41:;
--source include/show_msg80.inc

# testcase: ensure that the declare  handler for statement cannot declare a condition for the successful
#            completion sqlstate:  00000.
#FIXME Bug: (Bug#8759)

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
--enable_warnings

# supressed should actually fail --error
delimiter //;
CREATE PROCEDURE h1 ()
BEGIN
    declare x1 int default 0;
    BEGIN
        declare condname1 condition for sqlstate '00000';
      declare exit handler for sqlstate '00000' set @x = 1;
      set x1 = 1;
      set x1 = 2;
    END;
    SELECT @x, x1;
END//
delimiter ;//

# cleanup
DROP PROCEDURE IF EXISTS h1;


# ------------------------------------------------------------------------------
# FIXME 3.1.2.53: check numbering difference
let $message= * Testcase 3.1.2.53 (4.11.42):
* Ensure that a handler condition of sqlwarning takes the same action as a
* handler condition defined with an sqlstate that begins with 01.;
--source include/show_msg80.inc


--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP TABLE IF EXISTS res_t1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    DECLARE EXIT HANDLER FOR SQLWARNING SET @done = 1;
    set @done=0;
    set @x=1;
    insert into res_t1 values('xxx', 'yy');
    set @x=0;
END//
delimiter ;//

# table doesn't exist
--error 1146
CALL h1();
SELECT @done, @x;

CREATE TABLE res_t1(w CHAR, x CHAR);
INSERT INTO res_t1 VALUES('a', 'b');
INSERT INTO res_t1 VALUES('c', 'd');

# now table exists
CALL h1();
SELECT @done, @x;

--disable_warnings
DROP PROCEDURE IF EXISTS h1;
DROP TABLE IF EXISTS res_t1;
--enable_warnings

delimiter //;
CREATE PROCEDURE h1()
BEGIN
    DECLARE CONTINUE HANDLER FOR SQLWARNING SET @done = 1;
    set @done=0;
    set @x=0;
    insert into res_t1 values('xxx', 'yy');
    set @x=1;
END//
delimiter ;//

# table doesn't exist
--error 1146
CALL h1();
SELECT @done, @x;

CREATE TABLE res_t1(w CHAR, x CHAR);
INSERT INTO res_t1 VALUES('a', 'b');
INSERT INTO res_t1 VALUES('c', 'd');

# now table exists
CALL h1();
SELECT @done, @x;

# cleanup
DROP PROCEDURE h1;
DROP TABLE res_t1;


# ==============================================================================
# USE the same .inc to cleanup before and after the test
--source suite/funcs_1/storedproc/cleanup_sp_tb.inc

# ==============================================================================
let $message= .                               +++ END OF SCRIPT +++;
--source include/show_msg80.inc
# ==============================================================================
