--echo ---- Partitioning and char data type

--disable_query_log
# DATA DIRECTORY
eval SET @data_dir = 'DATA DIRECTORY =
''/tmp''';
let $data_directory = `select @data_dir`;

#INDEX DIRECTORY
eval SET @indx_dir = 'INDEX DIRECTORY =
''/tmp''';
let $index_directory = `select @indx_dir`;
--enable_query_log

eval create table t1 (a char(255) not null, primary key(a)) engine=$engine 
partition by key (a) (
partition pa1 $data_directory $index_directory max_rows=20 min_rows=2,
partition pa2 $data_directory $index_directory max_rows=30 min_rows=3,
partition pa3 $data_directory $index_directory max_rows=30 min_rows=4,
partition pa4 $data_directory $index_directory max_rows=40 min_rows=2);
show create table t1;
insert into t1 values (repeat('a',255)), ('b'), (repeat('a',128)), (repeat('b',64));
select * from t1;
select * from t1 where a='b';
update t1 set a='bb' where a='b';
delete from t1 where a='bb';
select * from t1;
drop table t1;

eval create table t2 (a char(255) not null, primary key(a)) engine=$engine 
partition by key (a) partitions 27;
show create table t2;
let $count=26;
let $letter=0;
--echo $count inserts;
#--disable_query_log
while ($count)
{
eval insert into t2 values (repeat(char(ascii('a')+$letter),$count+54));
dec $count;
inc $letter;
}
select count(*) from t2;
select * from t2;
drop table t2;

# mleich: Several partitioning functions are no more allowed.
if (0)
{
eval create table t3 (a char(255) not null, primary key(a)) engine=$engine 
partition by range (ascii(a)) subpartition by key (a) subpartitions 4 (
partition pa16 values less than (16),
partition pa32 values less than (32),
partition pa64 values less than (64),
partition pa128 values less than (128),
partition pa256 values less than (256)
);
show create table t3;
let $count=26;
let $letter=0;
--echo $count inserts;
#--disable_query_log
while ($count)
{
eval insert into t3 values (repeat(char(ascii('a')+$letter),$count+54));
dec $count;
inc $letter;
}
select count(*) from t3;
select a from t3;
drop table t3;

eval create table t4 (a char(255) not null, primary key(a)) engine=$engine 
partition by list (ascii(a)) subpartition by key (a) subpartitions 4 (
partition pa16 values in (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),
partition pa32 values in (17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32),
partition pa64 values in (33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64),
partition pa128 values in (65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128),
partition pa256 values in (129,130,131,132,133,134,135,136,137,138,139,140
,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256)
);
show create table t4;
let $count=26;
let $letter=0;
--echo $count inserts;
#--disable_query_log
while ($count)
{
eval insert into t4 values (repeat(char(ascii('a')+$letter),$count+54));
dec $count;
inc $letter;
}
select count(*) from t4;
select a from t4;
drop table t4;
}
# End of tests with disallowed partitioning functions.
