/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

class StorageConnection;
class StorageTable;
class StorageTableShare;
class CmdGen;
class THD;
class my_decimal;

//#define XA_ENABLED

struct st_table_share;
struct StorageIndexDesc;
struct StorageBlob;

class NfsStorageTable : public handler
{
public:
  NfsStorageTable(handlerton *, st_table_share *table_arg);
  ~NfsStorageTable(void);

  virtual int	open(const char *name, int mode, uint test_if_locked);
  virtual const char *table_type(void) const;
  virtual const char **bas_ext(void) const;
  virtual int	close(void);
  virtual ulonglong table_flags(void) const;
  virtual ulong index_flags(uint idx, uint part, bool all_parts) const;

  virtual int   info(uint what);
  virtual uint	max_supported_keys(void) const;
  virtual uint	max_supported_key_length(void) const;
  virtual uint	max_supported_key_part_length(void) const;

  virtual int	rnd_init(bool scan);
  virtual int	rnd_next(byte *buf);
  virtual int	rnd_pos(byte *buf, byte *pos);
  virtual void	position(const byte *record);

  virtual int	create(const char *name, TABLE *form, HA_CREATE_INFO *info);
  virtual THR_LOCK_DATA **store_lock(THD *thd, THR_LOCK_DATA **to,
                                     enum thr_lock_type lock_type);
  virtual int	delete_table(const char *name);
  virtual int	write_row(byte *buff);
  virtual int	update_row(const byte *oldData, byte *newData);
  virtual int	delete_row(const byte *buf);

  virtual int	index_read(byte *buf, const byte *key, uint keyLen,
                         enum ha_rkey_function find_flag);
  virtual int	index_init(uint idx, bool sorted);
  virtual int	index_end(void);
  virtual int	index_next(byte *buf);
  virtual int	index_next_same(byte *buf, const byte *key, uint key_len);

  virtual ha_rows record_in_range(uint index,
                                  key_range *lower, key_range *upper);
  virtual int	rename_table(const char *from, const char *to);
  virtual double read_time(uint index, uint ranges, ha_rows rows);
  virtual int	read_range_first(const key_range *start_key,
                               const key_range *end_key,
                               bool eq_range_arg, bool sorted);
  virtual double scan_time(void);
  virtual int	extra(ha_extra_function operation);
  virtual int	start_stmt(THD *thd, thr_lock_type lock_type);
  virtual int	external_lock(THD* thd, int lock_type);
  virtual const char *index_type(uint key_number);
  virtual void	get_auto_increment(ulonglong offset, ulonglong increment,
                                  ulonglong nb_desired_values,
                                  ulonglong *first_value,
                                  ulonglong *nb_reserved_values);
  virtual bool	get_error_message(int error, String *buf);
  virtual uint8 table_cache_type(void);
  virtual int	add_index(TABLE* table_arg, KEY* key_info, uint num_of_keys);
  virtual bool	check_if_incompatible_data(HA_CREATE_INFO* create_info, uint table_changes);
  virtual int	reset_auto_increment(ulonglong value);
  virtual const COND* cond_push(const COND* cond);

  int			createIndex(const char *schemaName, const char *tableName,
			                 KEY *key, int indexNumber);
  void			getKeyDesc(KEY *keyInfo, StorageIndexDesc *indexInfo);
  void			startTransaction(void);
  bool			threadSwitch(THD *newThread);
  int			threadSwitchError(void);
  int			error(int storageError);
  void			freeActiveBlobs(void);
  const char*	getDbName(const char *tableName);
  void			setIndexes(void);
  int			genType(Field *field, CmdGen *gen);
  void			genKeyFields(KEY *key, CmdGen *gen);
  void			encodeRecord(byte *buf, bool updateFlag);
  void			decodeRecord(byte *buf);
  void			unlockTable(void);

  static int	falcon_init(void *p);
  static int	commit(handlerton *, THD *thd, bool all);
  static int	prepare(handlerton* hton, THD* thd, bool all);
  static int	rollback(handlerton *, THD *thd, bool all);
  static int	savepointSet(handlerton *, THD *thd, void *savePoint);
  static int	savepointRollback(handlerton *, THD *thd, void *savePoint);
  static int	savepointRelease(handlerton *, THD *thd, void *savePoint);
  static void	dropDatabase(handlerton *, char *path);
  static void	shutdown(handlerton *);
  static int	closeConnection(handlerton *, THD *thd);
  static void	logger(int mask, const char *text, void *arg);
  static int	panic(handlerton* hton, ha_panic_function flag);
  static bool	show_status(handlerton* hton, THD* thd, stat_print_fn* print, enum ha_stat_type stat);
  static uint	alter_table_flags(uint flags);
  static int	alter_tablespace(handlerton* hton, THD* thd, st_alter_tablespace* ts_info);

  static int	commit_by_xid(handlerton* hton, XID* xid);
  static int	rollback_by_xid(handlerton* hton, XID* xid);

  /* Turn of table cache for now */
  
  //uint8 table_cache_type() { return HA_CACHE_TBL_TRANSACT; }

  StorageConnection*	storageConnection;
  StorageTable*			storageTable;
  StorageTableShare*	storageShare;
  THR_LOCK_DATA			lockData;			// MySQL lock
  THD					*mySqlThread;
  st_table_share		*share;
  uint					recordLength;
  int					lastRecord;
  int					nextRecord;
  int					indexErrorId;
  int					errorKey;
  StorageBlob			*activeBlobs;
  StorageBlob			*freeBlobs;
  const char			*dbName;
  bool					haveStartKey;
  bool					haveEndKey;
  bool					tableLocked;
  bool					tempTable;
  key_range				startKey;
  key_range				endKey;
};
