/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// Sync.h: interface for the Sync class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SYNC_H__59333A55_BC53_11D2_AB5E_0000C01D2301__INCLUDED_)
#define AFX_SYNC_H__59333A55_BC53_11D2_AB5E_0000C01D2301__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "SynchronizationObject.h"

class LinkedList;

class Sync  
{
public:
	void print (const char* label);
	void findLocks (LinkedList &threads, LinkedList& syncObjects);
	void lock (LockType type, const char *fromWhere);
	//void print(int level);
	void setObject (SynchronizationObject *obj);
	void unlock();
	void lock (LockType type);
	Sync(SynchronizationObject *obj, const char *where);
	virtual ~Sync();

	SynchronizationObject	*syncObject;
	LockType	state;
	LockType	request;
	Sync		*prior;
	const char	*where;
};

#endif // !defined(AFX_SYNC_H__59333A55_BC53_11D2_AB5E_0000C01D2301__INCLUDED_)
