/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _STORAGE_TABLE_H_
#define _STORAGE_TABLE_H_

#include "EncodedDataStream.h"
#include "Stream.h"
#include "IndexKey.h"
#include "SQLException.h"

static const int UpperBound	= 1;
static const int LowerBound = 2;

struct StorageKey {
	int			numberSegments;
	IndexKey	indexKey;
	};

struct StorageBlob {
	unsigned int	length;
	unsigned char	*data;
	int				blobId;
	StorageBlob		*next;
	};

	
class StorageConnection;
class StorageTableShare;
class NfsStorageTable;
class StorageDatabase;
class Index;
class Record;

struct StorageIndexDesc;

class StorageTable
{
public:
	StorageTable(StorageConnection *connection, StorageTableShare *tableShare);
	virtual ~StorageTable(void);

	void			transactionEnded(void);
	void			setRecord(Record* record);
	
	virtual void	setConnection(StorageConnection* connection);
	virtual void	clearIndexBounds(void);
	virtual void	clearRecord(void);
	virtual void	clearBitmap(void);
	virtual int		create(const char *sql, int64 autoIncrementValue);
	virtual int		open(void);
	virtual int		deleteTable(void);
	virtual int		deleteRow(int recordNumber);
	virtual int		setIndex(int numberIndexes, int indexId, StorageIndexDesc* storageIndex);
	virtual int		indexScan();
	virtual int		setIndex(int indexId);
	virtual void	indexEnd(void);
	virtual int		setIndexBound(const unsigned char* key, int keyLength, int which);
	virtual int		storeBlob(StorageBlob* blob);
	virtual void	getBlob(int recordNumber, StorageBlob* blob);
	virtual void	release(StorageBlob* blob);
	virtual int		fetch(int recordNumber);
	virtual void	deleteStorageTable(void);
	virtual void	freeBlob(StorageBlob* blob);
	virtual void	preInsert(void);
	virtual int		insert(void);
	virtual int		next(int recordNumber);
	virtual int		nextIndexed(int recordNumber);
	virtual int		updateRow(int recordNumber);
	virtual const unsigned char* getEncoding(int fieldIndex);
	virtual const char*			 getName(void);
	virtual const char*			 getSchemaName(void);
	virtual int		compareKey(const unsigned char* key, int keyLength);
	virtual int		translateError(SQLException *exception, int defaultStorageError);
	virtual int		isKeyNull(const unsigned char* key, int keyLength);

	JString				name;
	StorageTable		*collision;
	StorageConnection	*storageConnection;
	StorageDatabase		*storageDatabase;
	StorageTableShare	*share;
	NfsStorageTable		*localTable;
	StorageIndexDesc	*currentIndex;
	void				*bitmap;
	StorageKey			lowerKey;
	StorageKey			upperKey;
	StorageKey			*lowerBound;
	StorageKey			*upperBound;
	Record				*record;
	EncodedDataStream	dataStream;
	Stream				insertStream;
	bool				partialKey;
	virtual void setPartialKey(void);
	int alterCheck(void);
};

#endif
