/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


// SRLRecordLocator.cpp: implementation of the SRLRecordLocator class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLRecordLocator.h"
#include "SerialLog.h"
#include "SerialLogControl.h"
#include "SerialLogTransaction.h"
#include "Section.h"
#include "Dbb.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLRecordLocator::SRLRecordLocator()
{
}

SRLRecordLocator::~SRLRecordLocator()
{
}

void SRLRecordLocator::append(TransId transId, int id, int seq, int32 page)
{
	START_RECORD(srlSectionIndex, "SRLRecordLocator::append");

	if (transId)
		{
		SerialLogTransaction *trans = log->getTransaction(transId);
		
		if (trans)
			trans->setPhysicalBlock();
		}

	putInt(id);
	putInt(seq);
	putInt(page);
}

void SRLRecordLocator::read()
{
	sectionId = getInt();
	sequence = getInt();
	pageNumber = getInt();
}

void SRLRecordLocator::pass1()
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLRecordLocator::pass2()
{
	if (log->tracePage == pageNumber)
		print();
		
	int priorState = log->getPageState(pageNumber);
	
	if (log->bumpPageIncarnation(pageNumber, objInUse))
		{
		if (control->isPostFlush())
			log->dbb->redoRecordLocatorPage(sectionId, sequence, pageNumber);
		}
}

void SRLRecordLocator::redo()
{
	if (!log->bumpPageIncarnation(pageNumber, objInUse))
		return;
}


void SRLRecordLocator::print()
{
	logPrint("RecordLocator sectionId %d, sequence %d, pageNumber %d\n",
			sectionId, sequence, pageNumber);
}
