/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// SRLDropTable.cpp: implementation of the SRLDropTable class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLDropTable.h"
#include "SerialLog.h"
#include "SerialLogTransaction.h"
#include "SerialLogControl.h"
#include "Database.h"
#include "Section.h"
#include "Transaction.h"
#include "Log.h"
#include "Sync.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLDropTable::SRLDropTable()
{

}

SRLDropTable::~SRLDropTable()
{

}

void SRLDropTable::append(TransId transId, int section)
{
	Sync syncSections(&log->syncSections, "SRLDropTable::append");
	syncSections.lock(Exclusive);

	START_RECORD(srlDropTable, "SRLDropTable::append");
	SerialLogTransaction *trans = log->getTransaction(transId);
	log->setSectionInactive(section);
	putInt(transId);
	putInt(section);
}

void SRLDropTable::read()
{
	transactionId = getInt();
	sectionId = getInt();
}

void SRLDropTable::pass1()
{
	log->bumpSectionIncarnation(sectionId, objDeleted);
}

void SRLDropTable::pass2(void)
{
	log->bumpSectionIncarnation(sectionId, objDeleted);
}

void SRLDropTable::redo()
{
	if (!log->bumpSectionIncarnation(sectionId, objDeleted))
		return;

	log->database->deleteSection(sectionId, NULL);
}

void SRLDropTable::print()
{
	logPrint("Drop Section %d\n", sectionId);
}

void SRLDropTable::commit(void)
{
	Sync sync(&log->syncSections, "SRLDropTable::commit");
	sync.lock(Exclusive);
	//Log::debug("SRLDropTable::commit: deleting section %d\n", sectionId);
	Section::deleteSection(log->dbb, sectionId, NO_TRANSACTION);
}

void SRLDropTable::rollback(void)
{
}
