/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// SRLData.cpp: implementation of the SRLData class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLData.h"
#include "Stream.h"
#include "SerialLogControl.h"
#include "SerialLogTransaction.h"
#include "Dbb.h"
#include "Transaction.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLData::SRLData()
{

}

SRLData::~SRLData()
{

}

void SRLData::append(Transaction *transaction, int32 sectionId, int32 recordId, Stream *stream)
{
	START_RECORD(srlDataUpdate, "SRLData::append");
	SerialLogTransaction *trans = log->getTransaction(transaction->transactionId);
	trans->transaction = transaction;
	ASSERT(transaction->writePending);
	putInt(transaction->transactionId);
	putInt(sectionId);
	putInt(recordId);
	putStream(stream);
	sync.unlock();
}

void SRLData::read()
{
	transactionId = getInt();
	sectionId = getInt();
	recordId = getInt();
	length = getInt();
	ASSERT(length >= 0);
	data = getData(length);
}

void SRLData::print()
{
	char temp[40];
	logPrint("Data trans %d, section %d, record %d, length %d %s\n",
			transactionId, sectionId, recordId, length, format(length, data, sizeof(temp), temp));
}

void SRLData::pass1()
{
	control->getTransaction(transactionId);
}

void SRLData::redo()
{
	SerialLogTransaction *transaction = control->getTransaction(transactionId);

	if (transaction->state == sltCommitted && log->isSectionActive(sectionId))
		{
		Stream stream;
		stream.putSegment(length, (const char*) data, false);
		log->dbb->updateRecord(sectionId, recordId, &stream, transactionId, false);
		}
		
}

void SRLData::commit()
{
	redo();
}

void SRLData::recoverLimbo(void)
{
}
