/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef __INTERLOCK_H
#define __INTERLOCK_H

#define INTERLOCKED_INCREMENT(variable)	interlockedIncrement (&variable)
#define INTERLOCKED_DECREMENT(variable)	interlockedDecrement (&variable)

#ifdef _WIN32

#define COMPARE_EXCHANGE(target,compare,exchange)\
	(InterlockedCompareExchange(target,exchange,compare)==compare)
#define COMPARE_EXCHANGE_POINTER(target,compare,exchange)\
	(InterlockedCompareExchange((volatile int*) target,(int)exchange,(int)compare)==(int)compare)

#define InterlockedIncrement				_InterlockedIncrement
#define InterlockedDecrement				_InterlockedDecrement

#define InterlockedCompareExchange			_InterlockedCompareExchange

#ifndef InterlockedCompareExchangePointer
//#define InterlockedCompareExchangePointer	_InterlockedCompareExchangePointer
#endif

extern "C" 
	{
	long  InterlockedIncrement(long* lpAddend);
	long  InterlockedDecrement(long* lpAddend);
	long  InterlockedCompareExchange(volatile int *Destination, int Exchange, int Comperand);
	//int InterlockedCompareExchangePointer(volatile int *Destination, int Exchange, int Comperand);
	}

#pragma intrinsic(_InterlockedIncrement)
#pragma intrinsic(_InterlockedDecrement)
#pragma intrinsic(_InterlockedCompareExchange)
//#pragma intrinsic(_InterlockedCompareExchangePointer)
//#pragma intrinsic(_InterlockedCompareExchangePointer)

#endif

#if defined (__i386) || (__x86_64__) || defined (__sparc__)

#define COMPARE_EXCHANGE(target,compare,exchange)\
	(inline_cas(target,compare,exchange))
#define COMPARE_EXCHANGE_POINTER(target,compare,exchange)\
	(inline_cas_pointer((volatile void**)target,(void*)compare,(void*)exchange))

#endif


inline INTERLOCK_TYPE interlockedIncrement(volatile INTERLOCK_TYPE *ptr)
{
#ifndef _WIN32
	INTERLOCK_TYPE ret = 1;
	asm (
		"lock\n\t" "xaddl %0,%1\n\t" 
		: "+r" (ret)
		: "m" (*ptr)
                : "memory"
		);
	return ret + 1;
#else
	return InterlockedIncrement ((long*) ptr);
#endif
}

inline INTERLOCK_TYPE interlockedDecrement(volatile INTERLOCK_TYPE *ptr)
{
#ifndef _WIN32
	INTERLOCK_TYPE ret = -1;
	asm (
		"lock\n\t" "xaddl %0,%1\n\t" 
		: "+r" (ret)
		: "m" (*ptr)
                : "memory"
		);
	return ret - 1;
#else
	return InterlockedDecrement ((long*) ptr);
#endif
}

inline int inline_cas (volatile int *target, int compare, int exchange)
{
#if defined(__i386) || (__x86_64__)
	char ret;

	__asm __volatile ("lock; cmpxchg %2, %1 ; sete %0"
		    : "=q" (ret), "+m" (*(target))
		    : "r" (exchange), "a" (compare)
			: "cc", "memory"); 

	return ret;

#elif defined(__sparc__)
	__asm__ __volatile__(
		       "cas     [%2], %3, %0\n\t"
		    : "=&r" (exchange)
		    : "0" (exchange), "r" (target), "r" (compare)
		    : "memory");
#else
	return -2;
#endif
}

inline char inline_cas_pointer (volatile void **target, void *compare, void *exchange)
{
#if defined(__i386) || defined(__x86_64__)
	char ret;

	__asm __volatile ("lock; cmpxchg %2, %1 ; sete %0"
		    : "=q" (ret), "+m" (*(target))
		    : "r" (exchange), "a" (compare)
			: "cc", "memory"); 

	return ret;

#elif defined(__sparc__)
	__asm__ __volatile__(
		       "casx    [%2], %3, %0\n\t"
		    : "=&r" (exchange)
		    : "0" (exchange), "r" (target), "r" (compare)
		    : "memory");
#else
	return NULL;
#endif
}

#endif
