/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// Bdb.h: interface for the Bdb class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BDB_H__6A019C1C_A340_11D2_AB5A_0000C01D2301__INCLUDED_)
#define AFX_BDB_H__6A019C1C_A340_11D2_AB5A_0000C01D2301__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "SyncObject.h"


static const int BDB_dirty		= 1;
static const int BDB_new		= 2;
static const int BDB_writer		= 4;		// PageWriter wants to hear about this
static const int BDB_register	= 8;		// Register with PageWrite on next release

class Page;
class Cache;
class PagePrecedence;
class Dbb;
class Thread;

class Bdb  
{
public:
	void setWriter();
	bool isHigher (Bdb *bdb);
	void setPrecedence (int32 priorPage);
	void decrementUseCount();
	void incrementUseCount();
	void downGrade (LockType lockType);
	void	release();
	void	addRef(LockType lockType);
	void	mark(TransId transId);
	Bdb();
	~Bdb();

	Cache			*cache;
	Dbb				*dbb;
	int32			pageNumber;
	TransId			transactionId;
	int				age;
	Page			*buffer;
	Bdb				*prior;		/* position in LRU que */
	Bdb				*next;
	Bdb				*hash;		/* hash collision */
	Bdb				*nextDirty;
	Bdb				*priorDirty;
	PagePrecedence	*higher;
	PagePrecedence	*lower;
	Thread			*markingThread;
	SyncObject		syncObject;
	LockType		lockType;
	short			flags;
	bool			flushIt;
	volatile INTERLOCK_TYPE	useCount;
};

#endif // !defined(AFX_BDB_H__6A019C1C_A340_11D2_AB5A_0000C01D2301__INCLUDED_)
