/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CASE_SYM = 306,
     CAST_SYM = 307,
     CHAIN_SYM = 308,
     CHANGE = 309,
     CHANGED = 310,
     CHARSET = 311,
     CHAR_SYM = 312,
     CHECKSUM_SYM = 313,
     CHECK_SYM = 314,
     CIPHER_SYM = 315,
     CLIENT_SYM = 316,
     CLOSE_SYM = 317,
     COALESCE = 318,
     CODE_SYM = 319,
     COLLATE_SYM = 320,
     COLLATION_SYM = 321,
     COLUMNS = 322,
     COLUMN_SYM = 323,
     COMMENT_SYM = 324,
     COMMITTED_SYM = 325,
     COMMIT_SYM = 326,
     COMPACT_SYM = 327,
     COMPLETION_SYM = 328,
     COMPRESSED_SYM = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTINUE_SYM = 336,
     CONTRIBUTORS_SYM = 337,
     CONVERT_SYM = 338,
     COUNT_SYM = 339,
     CREATE = 340,
     CROSS = 341,
     CUBE_SYM = 342,
     CURDATE = 343,
     CURRENT_USER = 344,
     CURSOR_SYM = 345,
     CURTIME = 346,
     DATABASE = 347,
     DATABASES = 348,
     DATAFILE_SYM = 349,
     DATA_SYM = 350,
     DATETIME = 351,
     DATE_ADD_INTERVAL = 352,
     DATE_SUB_INTERVAL = 353,
     DATE_SYM = 354,
     DAY_HOUR_SYM = 355,
     DAY_MICROSECOND_SYM = 356,
     DAY_MINUTE_SYM = 357,
     DAY_SECOND_SYM = 358,
     DAY_SYM = 359,
     DEALLOCATE_SYM = 360,
     DECIMAL_NUM = 361,
     DECIMAL_SYM = 362,
     DECLARE_SYM = 363,
     DEFAULT = 364,
     DEFINER_SYM = 365,
     DELAYED_SYM = 366,
     DELAY_KEY_WRITE_SYM = 367,
     DELETE_SYM = 368,
     DESC = 369,
     DESCRIBE = 370,
     DES_KEY_FILE = 371,
     DETERMINISTIC_SYM = 372,
     DIRECTORY_SYM = 373,
     DISABLE_SYM = 374,
     DISCARD = 375,
     DISK_SYM = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSE = 387,
     ELSEIF_SYM = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     END = 391,
     ENDS_SYM = 392,
     END_OF_INPUT = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EVENT_SYM = 403,
     EVERY_SYM = 404,
     EXECUTE_SYM = 405,
     EXISTS = 406,
     EXIT_SYM = 407,
     EXPANSION_SYM = 408,
     EXTENDED_SYM = 409,
     EXTENT_SIZE_SYM = 410,
     EXTRACT_SYM = 411,
     FALSE_SYM = 412,
     FAST_SYM = 413,
     FETCH_SYM = 414,
     FILE_SYM = 415,
     FIRST_SYM = 416,
     FIXED_SYM = 417,
     FLOAT_NUM = 418,
     FLOAT_SYM = 419,
     FLUSH_SYM = 420,
     FORCE_SYM = 421,
     FOREIGN = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FULL = 427,
     FULLTEXT_SYM = 428,
     FUNCTION_SYM = 429,
     GE = 430,
     GEOMETRYCOLLECTION = 431,
     GEOMETRY_SYM = 432,
     GET_FORMAT = 433,
     GLOBAL_SYM = 434,
     GRANT = 435,
     GRANTS = 436,
     GROUP = 437,
     GROUP_CONCAT_SYM = 438,
     GT_SYM = 439,
     HANDLER_SYM = 440,
     HASH_SYM = 441,
     HAVING = 442,
     HELP_SYM = 443,
     HEX_NUM = 444,
     HIGH_PRIORITY = 445,
     HOST_SYM = 446,
     HOSTS_SYM = 447,
     HOUR_MICROSECOND_SYM = 448,
     HOUR_MINUTE_SYM = 449,
     HOUR_SECOND_SYM = 450,
     HOUR_SYM = 451,
     IDENT = 452,
     IDENTIFIED_SYM = 453,
     IDENT_QUOTED = 454,
     IF = 455,
     IGNORE_SYM = 456,
     IMPORT = 457,
     INDEXES = 458,
     INDEX_SYM = 459,
     INFILE = 460,
     INITIAL_SIZE_SYM = 461,
     INNER_SYM = 462,
     INNOBASE_SYM = 463,
     INOUT_SYM = 464,
     INSENSITIVE_SYM = 465,
     INSERT = 466,
     INSERT_METHOD = 467,
     INSTALL_SYM = 468,
     INTERVAL_SYM = 469,
     INTO = 470,
     INT_SYM = 471,
     INVOKER_SYM = 472,
     IN_SYM = 473,
     IS = 474,
     ISOLATION = 475,
     ISSUER_SYM = 476,
     ITERATE_SYM = 477,
     JOIN_SYM = 478,
     KEYS = 479,
     KEY_BLOCK_SIZE = 480,
     KEY_SYM = 481,
     KILL_SYM = 482,
     LANGUAGE_SYM = 483,
     LAST_SYM = 484,
     LE = 485,
     LEADING = 486,
     LEAVES = 487,
     LEAVE_SYM = 488,
     LEFT = 489,
     LESS_SYM = 490,
     LEVEL_SYM = 491,
     LEX_HOSTNAME = 492,
     LIKE = 493,
     LIMIT = 494,
     LINEAR_SYM = 495,
     LINES = 496,
     LINESTRING = 497,
     LIST_SYM = 498,
     LOAD = 499,
     LOCAL_SYM = 500,
     LOCATOR_SYM = 501,
     LOCKS_SYM = 502,
     LOCK_SYM = 503,
     LOGFILE_SYM = 504,
     LOGS_SYM = 505,
     LONGBLOB = 506,
     LONGTEXT = 507,
     LONG_NUM = 508,
     LONG_SYM = 509,
     LOOP_SYM = 510,
     LOW_PRIORITY = 511,
     LT = 512,
     MASTER_CONNECT_RETRY_SYM = 513,
     MASTER_HOST_SYM = 514,
     MASTER_LOG_FILE_SYM = 515,
     MASTER_LOG_POS_SYM = 516,
     MASTER_PASSWORD_SYM = 517,
     MASTER_PORT_SYM = 518,
     MASTER_SERVER_ID_SYM = 519,
     MASTER_SSL_CAPATH_SYM = 520,
     MASTER_SSL_CA_SYM = 521,
     MASTER_SSL_CERT_SYM = 522,
     MASTER_SSL_CIPHER_SYM = 523,
     MASTER_SSL_KEY_SYM = 524,
     MASTER_SSL_SYM = 525,
     MASTER_SYM = 526,
     MASTER_USER_SYM = 527,
     MATCH = 528,
     MAX_CONNECTIONS_PER_HOUR = 529,
     MAX_QUERIES_PER_HOUR = 530,
     MAX_ROWS = 531,
     MAX_SIZE_SYM = 532,
     MAX_SYM = 533,
     MAX_UPDATES_PER_HOUR = 534,
     MAX_USER_CONNECTIONS_SYM = 535,
     MAX_VALUE_SYM = 536,
     MEDIUMBLOB = 537,
     MEDIUMINT = 538,
     MEDIUMTEXT = 539,
     MEDIUM_SYM = 540,
     MEMORY_SYM = 541,
     MERGE_SYM = 542,
     MICROSECOND_SYM = 543,
     MIGRATE_SYM = 544,
     MINUTE_MICROSECOND_SYM = 545,
     MINUTE_SECOND_SYM = 546,
     MINUTE_SYM = 547,
     MIN_ROWS = 548,
     MIN_SYM = 549,
     MODE_SYM = 550,
     MODIFIES_SYM = 551,
     MODIFY_SYM = 552,
     MOD_SYM = 553,
     MONTH_SYM = 554,
     MULTILINESTRING = 555,
     MULTIPOINT = 556,
     MULTIPOLYGON = 557,
     MUTEX_SYM = 558,
     NAMES_SYM = 559,
     NAME_SYM = 560,
     NATIONAL_SYM = 561,
     NATURAL = 562,
     NCHAR_STRING = 563,
     NCHAR_SYM = 564,
     NDBCLUSTER_SYM = 565,
     NE = 566,
     NEG = 567,
     NEW_SYM = 568,
     NEXT_SYM = 569,
     NODEGROUP_SYM = 570,
     NONE_SYM = 571,
     NOT2_SYM = 572,
     NOT_SYM = 573,
     NOW_SYM = 574,
     NO_SYM = 575,
     NO_WAIT_SYM = 576,
     NO_WRITE_TO_BINLOG = 577,
     NULL_SYM = 578,
     NUM = 579,
     NUMERIC_SYM = 580,
     NVARCHAR_SYM = 581,
     OFFSET_SYM = 582,
     OLD_PASSWORD = 583,
     ON = 584,
     ONE_SHOT_SYM = 585,
     ONE_SYM = 586,
     OPEN_SYM = 587,
     OPTIMIZE = 588,
     OPTIONS_SYM = 589,
     OPTION = 590,
     OPTIONALLY = 591,
     OR2_SYM = 592,
     ORDER_SYM = 593,
     OR_OR_SYM = 594,
     OR_SYM = 595,
     OUTER = 596,
     OUTFILE = 597,
     OUT_SYM = 598,
     OWNER_SYM = 599,
     PACK_KEYS_SYM = 600,
     PARAM_MARKER = 601,
     PARSER_SYM = 602,
     PARTIAL = 603,
     PARTITIONING_SYM = 604,
     PARTITIONS_SYM = 605,
     PARTITION_SYM = 606,
     PASSWORD = 607,
     PHASE_SYM = 608,
     PLUGINS_SYM = 609,
     PLUGIN_SYM = 610,
     POINT_SYM = 611,
     POLYGON = 612,
     PORT_SYM = 613,
     POSITION_SYM = 614,
     PRECISION = 615,
     PREPARE_SYM = 616,
     PRESERVE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RANGE_SYM = 628,
     READS_SYM = 629,
     READ_ONLY_SYM = 630,
     READ_SYM = 631,
     READ_WRITE_SYM = 632,
     REAL = 633,
     REBUILD_SYM = 634,
     RECOVER_SYM = 635,
     REDOFILE_SYM = 636,
     REDO_BUFFER_SIZE_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     REMOVE_SYM = 646,
     RENAME = 647,
     REORGANIZE_SYM = 648,
     REPAIR = 649,
     REPEATABLE_SYM = 650,
     REPEAT_SYM = 651,
     REPLACE = 652,
     REPLICATION = 653,
     REQUIRE_SYM = 654,
     RESET_SYM = 655,
     RESOURCES = 656,
     RESTORE_SYM = 657,
     RESTRICT = 658,
     RESUME_SYM = 659,
     RETURNS_SYM = 660,
     RETURN_SYM = 661,
     REVOKE = 662,
     RIGHT = 663,
     ROLLBACK_SYM = 664,
     ROLLUP_SYM = 665,
     ROUTINE_SYM = 666,
     ROWS_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SCHEDULE_SYM = 672,
     SECOND_MICROSECOND_SYM = 673,
     SECOND_SYM = 674,
     SECURITY_SYM = 675,
     SELECT_SYM = 676,
     SENSITIVE_SYM = 677,
     SEPARATOR_SYM = 678,
     SERIALIZABLE_SYM = 679,
     SERIAL_SYM = 680,
     SESSION_SYM = 681,
     SERVER_SYM = 682,
     SERVER_OPTIONS = 683,
     SET = 684,
     SET_VAR = 685,
     SHARE_SYM = 686,
     SHIFT_LEFT = 687,
     SHIFT_RIGHT = 688,
     SHOW = 689,
     SHUTDOWN = 690,
     SIGNED_SYM = 691,
     SIMPLE_SYM = 692,
     SLAVE = 693,
     SMALLINT = 694,
     SNAPSHOT_SYM = 695,
     SOCKET_SYM = 696,
     SONAME_SYM = 697,
     SOUNDS_SYM = 698,
     SPATIAL_SYM = 699,
     SPECIFIC_SYM = 700,
     SQLEXCEPTION_SYM = 701,
     SQLSTATE_SYM = 702,
     SQLWARNING_SYM = 703,
     SQL_BIG_RESULT = 704,
     SQL_BUFFER_RESULT = 705,
     SQL_CACHE_SYM = 706,
     SQL_CALC_FOUND_ROWS = 707,
     SQL_NO_CACHE_SYM = 708,
     SQL_SMALL_RESULT = 709,
     SQL_SYM = 710,
     SQL_THREAD = 711,
     SSL_SYM = 712,
     STARTING = 713,
     STARTS_SYM = 714,
     START_SYM = 715,
     STATUS_SYM = 716,
     STDDEV_SAMP_SYM = 717,
     STD_SYM = 718,
     STOP_SYM = 719,
     STORAGE_SYM = 720,
     STRAIGHT_JOIN = 721,
     STRING_SYM = 722,
     SUBDATE_SYM = 723,
     SUBJECT_SYM = 724,
     SUBPARTITIONS_SYM = 725,
     SUBPARTITION_SYM = 726,
     SUBSTRING = 727,
     SUM_SYM = 728,
     SUPER_SYM = 729,
     SUSPEND_SYM = 730,
     SYSDATE = 731,
     TABLES = 732,
     TABLESPACE = 733,
     TABLE_REF_PRIORITY = 734,
     TABLE_SYM = 735,
     TEMPORARY = 736,
     TEMPTABLE_SYM = 737,
     TERMINATED = 738,
     TEXT_STRING = 739,
     TEXT_SYM = 740,
     THAN_SYM = 741,
     THEN_SYM = 742,
     TIMESTAMP = 743,
     TIMESTAMP_ADD = 744,
     TIMESTAMP_DIFF = 745,
     TIME_SYM = 746,
     TINYBLOB = 747,
     TINYINT = 748,
     TINYTEXT = 749,
     TO_SYM = 750,
     TRAILING = 751,
     TRANSACTION_SYM = 752,
     TRIGGERS_SYM = 753,
     TRIGGER_SYM = 754,
     TRIM = 755,
     TRUE_SYM = 756,
     TRUNCATE_SYM = 757,
     TYPES_SYM = 758,
     TYPE_SYM = 759,
     UDF_RETURNS_SYM = 760,
     ULONGLONG_NUM = 761,
     UNCOMMITTED_SYM = 762,
     UNDEFINED_SYM = 763,
     UNDERSCORE_CHARSET = 764,
     UNDOFILE_SYM = 765,
     UNDO_BUFFER_SIZE_SYM = 766,
     UNDO_SYM = 767,
     UNICODE_SYM = 768,
     UNINSTALL_SYM = 769,
     UNION_SYM = 770,
     UNIQUE_SYM = 771,
     UNKNOWN_SYM = 772,
     UNLOCK_SYM = 773,
     UNSIGNED = 774,
     UNTIL_SYM = 775,
     UPDATE_SYM = 776,
     UPGRADE_SYM = 777,
     USAGE = 778,
     USER = 779,
     USE_FRM = 780,
     USE_SYM = 781,
     USING = 782,
     UTC_DATE_SYM = 783,
     UTC_TIMESTAMP_SYM = 784,
     UTC_TIME_SYM = 785,
     VALUES = 786,
     VALUE_SYM = 787,
     VARBINARY = 788,
     VARCHAR = 789,
     VARIABLES = 790,
     VARIANCE_SYM = 791,
     VARYING = 792,
     VAR_SAMP_SYM = 793,
     VIEW_SYM = 794,
     WAIT_SYM = 795,
     WARNINGS = 796,
     WEEK_SYM = 797,
     WHEN_SYM = 798,
     WHERE = 799,
     WHILE_SYM = 800,
     WITH = 801,
     WORK_SYM = 802,
     WRAPPER_SYM = 803,
     WRITE_SYM = 804,
     X509_SYM = 805,
     XA_SYM = 806,
     XOR = 807,
     YEAR_MONTH_SYM = 808,
     YEAR_SYM = 809,
     ZEROFILL = 810
   };
#endif
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CASE_SYM 306
#define CAST_SYM 307
#define CHAIN_SYM 308
#define CHANGE 309
#define CHANGED 310
#define CHARSET 311
#define CHAR_SYM 312
#define CHECKSUM_SYM 313
#define CHECK_SYM 314
#define CIPHER_SYM 315
#define CLIENT_SYM 316
#define CLOSE_SYM 317
#define COALESCE 318
#define CODE_SYM 319
#define COLLATE_SYM 320
#define COLLATION_SYM 321
#define COLUMNS 322
#define COLUMN_SYM 323
#define COMMENT_SYM 324
#define COMMITTED_SYM 325
#define COMMIT_SYM 326
#define COMPACT_SYM 327
#define COMPLETION_SYM 328
#define COMPRESSED_SYM 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTINUE_SYM 336
#define CONTRIBUTORS_SYM 337
#define CONVERT_SYM 338
#define COUNT_SYM 339
#define CREATE 340
#define CROSS 341
#define CUBE_SYM 342
#define CURDATE 343
#define CURRENT_USER 344
#define CURSOR_SYM 345
#define CURTIME 346
#define DATABASE 347
#define DATABASES 348
#define DATAFILE_SYM 349
#define DATA_SYM 350
#define DATETIME 351
#define DATE_ADD_INTERVAL 352
#define DATE_SUB_INTERVAL 353
#define DATE_SYM 354
#define DAY_HOUR_SYM 355
#define DAY_MICROSECOND_SYM 356
#define DAY_MINUTE_SYM 357
#define DAY_SECOND_SYM 358
#define DAY_SYM 359
#define DEALLOCATE_SYM 360
#define DECIMAL_NUM 361
#define DECIMAL_SYM 362
#define DECLARE_SYM 363
#define DEFAULT 364
#define DEFINER_SYM 365
#define DELAYED_SYM 366
#define DELAY_KEY_WRITE_SYM 367
#define DELETE_SYM 368
#define DESC 369
#define DESCRIBE 370
#define DES_KEY_FILE 371
#define DETERMINISTIC_SYM 372
#define DIRECTORY_SYM 373
#define DISABLE_SYM 374
#define DISCARD 375
#define DISK_SYM 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSE 387
#define ELSEIF_SYM 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define END 391
#define ENDS_SYM 392
#define END_OF_INPUT 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EVENT_SYM 403
#define EVERY_SYM 404
#define EXECUTE_SYM 405
#define EXISTS 406
#define EXIT_SYM 407
#define EXPANSION_SYM 408
#define EXTENDED_SYM 409
#define EXTENT_SIZE_SYM 410
#define EXTRACT_SYM 411
#define FALSE_SYM 412
#define FAST_SYM 413
#define FETCH_SYM 414
#define FILE_SYM 415
#define FIRST_SYM 416
#define FIXED_SYM 417
#define FLOAT_NUM 418
#define FLOAT_SYM 419
#define FLUSH_SYM 420
#define FORCE_SYM 421
#define FOREIGN 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FULL 427
#define FULLTEXT_SYM 428
#define FUNCTION_SYM 429
#define GE 430
#define GEOMETRYCOLLECTION 431
#define GEOMETRY_SYM 432
#define GET_FORMAT 433
#define GLOBAL_SYM 434
#define GRANT 435
#define GRANTS 436
#define GROUP 437
#define GROUP_CONCAT_SYM 438
#define GT_SYM 439
#define HANDLER_SYM 440
#define HASH_SYM 441
#define HAVING 442
#define HELP_SYM 443
#define HEX_NUM 444
#define HIGH_PRIORITY 445
#define HOST_SYM 446
#define HOSTS_SYM 447
#define HOUR_MICROSECOND_SYM 448
#define HOUR_MINUTE_SYM 449
#define HOUR_SECOND_SYM 450
#define HOUR_SYM 451
#define IDENT 452
#define IDENTIFIED_SYM 453
#define IDENT_QUOTED 454
#define IF 455
#define IGNORE_SYM 456
#define IMPORT 457
#define INDEXES 458
#define INDEX_SYM 459
#define INFILE 460
#define INITIAL_SIZE_SYM 461
#define INNER_SYM 462
#define INNOBASE_SYM 463
#define INOUT_SYM 464
#define INSENSITIVE_SYM 465
#define INSERT 466
#define INSERT_METHOD 467
#define INSTALL_SYM 468
#define INTERVAL_SYM 469
#define INTO 470
#define INT_SYM 471
#define INVOKER_SYM 472
#define IN_SYM 473
#define IS 474
#define ISOLATION 475
#define ISSUER_SYM 476
#define ITERATE_SYM 477
#define JOIN_SYM 478
#define KEYS 479
#define KEY_BLOCK_SIZE 480
#define KEY_SYM 481
#define KILL_SYM 482
#define LANGUAGE_SYM 483
#define LAST_SYM 484
#define LE 485
#define LEADING 486
#define LEAVES 487
#define LEAVE_SYM 488
#define LEFT 489
#define LESS_SYM 490
#define LEVEL_SYM 491
#define LEX_HOSTNAME 492
#define LIKE 493
#define LIMIT 494
#define LINEAR_SYM 495
#define LINES 496
#define LINESTRING 497
#define LIST_SYM 498
#define LOAD 499
#define LOCAL_SYM 500
#define LOCATOR_SYM 501
#define LOCKS_SYM 502
#define LOCK_SYM 503
#define LOGFILE_SYM 504
#define LOGS_SYM 505
#define LONGBLOB 506
#define LONGTEXT 507
#define LONG_NUM 508
#define LONG_SYM 509
#define LOOP_SYM 510
#define LOW_PRIORITY 511
#define LT 512
#define MASTER_CONNECT_RETRY_SYM 513
#define MASTER_HOST_SYM 514
#define MASTER_LOG_FILE_SYM 515
#define MASTER_LOG_POS_SYM 516
#define MASTER_PASSWORD_SYM 517
#define MASTER_PORT_SYM 518
#define MASTER_SERVER_ID_SYM 519
#define MASTER_SSL_CAPATH_SYM 520
#define MASTER_SSL_CA_SYM 521
#define MASTER_SSL_CERT_SYM 522
#define MASTER_SSL_CIPHER_SYM 523
#define MASTER_SSL_KEY_SYM 524
#define MASTER_SSL_SYM 525
#define MASTER_SYM 526
#define MASTER_USER_SYM 527
#define MATCH 528
#define MAX_CONNECTIONS_PER_HOUR 529
#define MAX_QUERIES_PER_HOUR 530
#define MAX_ROWS 531
#define MAX_SIZE_SYM 532
#define MAX_SYM 533
#define MAX_UPDATES_PER_HOUR 534
#define MAX_USER_CONNECTIONS_SYM 535
#define MAX_VALUE_SYM 536
#define MEDIUMBLOB 537
#define MEDIUMINT 538
#define MEDIUMTEXT 539
#define MEDIUM_SYM 540
#define MEMORY_SYM 541
#define MERGE_SYM 542
#define MICROSECOND_SYM 543
#define MIGRATE_SYM 544
#define MINUTE_MICROSECOND_SYM 545
#define MINUTE_SECOND_SYM 546
#define MINUTE_SYM 547
#define MIN_ROWS 548
#define MIN_SYM 549
#define MODE_SYM 550
#define MODIFIES_SYM 551
#define MODIFY_SYM 552
#define MOD_SYM 553
#define MONTH_SYM 554
#define MULTILINESTRING 555
#define MULTIPOINT 556
#define MULTIPOLYGON 557
#define MUTEX_SYM 558
#define NAMES_SYM 559
#define NAME_SYM 560
#define NATIONAL_SYM 561
#define NATURAL 562
#define NCHAR_STRING 563
#define NCHAR_SYM 564
#define NDBCLUSTER_SYM 565
#define NE 566
#define NEG 567
#define NEW_SYM 568
#define NEXT_SYM 569
#define NODEGROUP_SYM 570
#define NONE_SYM 571
#define NOT2_SYM 572
#define NOT_SYM 573
#define NOW_SYM 574
#define NO_SYM 575
#define NO_WAIT_SYM 576
#define NO_WRITE_TO_BINLOG 577
#define NULL_SYM 578
#define NUM 579
#define NUMERIC_SYM 580
#define NVARCHAR_SYM 581
#define OFFSET_SYM 582
#define OLD_PASSWORD 583
#define ON 584
#define ONE_SHOT_SYM 585
#define ONE_SYM 586
#define OPEN_SYM 587
#define OPTIMIZE 588
#define OPTIONS_SYM 589
#define OPTION 590
#define OPTIONALLY 591
#define OR2_SYM 592
#define ORDER_SYM 593
#define OR_OR_SYM 594
#define OR_SYM 595
#define OUTER 596
#define OUTFILE 597
#define OUT_SYM 598
#define OWNER_SYM 599
#define PACK_KEYS_SYM 600
#define PARAM_MARKER 601
#define PARSER_SYM 602
#define PARTIAL 603
#define PARTITIONING_SYM 604
#define PARTITIONS_SYM 605
#define PARTITION_SYM 606
#define PASSWORD 607
#define PHASE_SYM 608
#define PLUGINS_SYM 609
#define PLUGIN_SYM 610
#define POINT_SYM 611
#define POLYGON 612
#define PORT_SYM 613
#define POSITION_SYM 614
#define PRECISION 615
#define PREPARE_SYM 616
#define PRESERVE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RANGE_SYM 628
#define READS_SYM 629
#define READ_ONLY_SYM 630
#define READ_SYM 631
#define READ_WRITE_SYM 632
#define REAL 633
#define REBUILD_SYM 634
#define RECOVER_SYM 635
#define REDOFILE_SYM 636
#define REDO_BUFFER_SIZE_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define REMOVE_SYM 646
#define RENAME 647
#define REORGANIZE_SYM 648
#define REPAIR 649
#define REPEATABLE_SYM 650
#define REPEAT_SYM 651
#define REPLACE 652
#define REPLICATION 653
#define REQUIRE_SYM 654
#define RESET_SYM 655
#define RESOURCES 656
#define RESTORE_SYM 657
#define RESTRICT 658
#define RESUME_SYM 659
#define RETURNS_SYM 660
#define RETURN_SYM 661
#define REVOKE 662
#define RIGHT 663
#define ROLLBACK_SYM 664
#define ROLLUP_SYM 665
#define ROUTINE_SYM 666
#define ROWS_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SCHEDULE_SYM 672
#define SECOND_MICROSECOND_SYM 673
#define SECOND_SYM 674
#define SECURITY_SYM 675
#define SELECT_SYM 676
#define SENSITIVE_SYM 677
#define SEPARATOR_SYM 678
#define SERIALIZABLE_SYM 679
#define SERIAL_SYM 680
#define SESSION_SYM 681
#define SERVER_SYM 682
#define SERVER_OPTIONS 683
#define SET 684
#define SET_VAR 685
#define SHARE_SYM 686
#define SHIFT_LEFT 687
#define SHIFT_RIGHT 688
#define SHOW 689
#define SHUTDOWN 690
#define SIGNED_SYM 691
#define SIMPLE_SYM 692
#define SLAVE 693
#define SMALLINT 694
#define SNAPSHOT_SYM 695
#define SOCKET_SYM 696
#define SONAME_SYM 697
#define SOUNDS_SYM 698
#define SPATIAL_SYM 699
#define SPECIFIC_SYM 700
#define SQLEXCEPTION_SYM 701
#define SQLSTATE_SYM 702
#define SQLWARNING_SYM 703
#define SQL_BIG_RESULT 704
#define SQL_BUFFER_RESULT 705
#define SQL_CACHE_SYM 706
#define SQL_CALC_FOUND_ROWS 707
#define SQL_NO_CACHE_SYM 708
#define SQL_SMALL_RESULT 709
#define SQL_SYM 710
#define SQL_THREAD 711
#define SSL_SYM 712
#define STARTING 713
#define STARTS_SYM 714
#define START_SYM 715
#define STATUS_SYM 716
#define STDDEV_SAMP_SYM 717
#define STD_SYM 718
#define STOP_SYM 719
#define STORAGE_SYM 720
#define STRAIGHT_JOIN 721
#define STRING_SYM 722
#define SUBDATE_SYM 723
#define SUBJECT_SYM 724
#define SUBPARTITIONS_SYM 725
#define SUBPARTITION_SYM 726
#define SUBSTRING 727
#define SUM_SYM 728
#define SUPER_SYM 729
#define SUSPEND_SYM 730
#define SYSDATE 731
#define TABLES 732
#define TABLESPACE 733
#define TABLE_REF_PRIORITY 734
#define TABLE_SYM 735
#define TEMPORARY 736
#define TEMPTABLE_SYM 737
#define TERMINATED 738
#define TEXT_STRING 739
#define TEXT_SYM 740
#define THAN_SYM 741
#define THEN_SYM 742
#define TIMESTAMP 743
#define TIMESTAMP_ADD 744
#define TIMESTAMP_DIFF 745
#define TIME_SYM 746
#define TINYBLOB 747
#define TINYINT 748
#define TINYTEXT 749
#define TO_SYM 750
#define TRAILING 751
#define TRANSACTION_SYM 752
#define TRIGGERS_SYM 753
#define TRIGGER_SYM 754
#define TRIM 755
#define TRUE_SYM 756
#define TRUNCATE_SYM 757
#define TYPES_SYM 758
#define TYPE_SYM 759
#define UDF_RETURNS_SYM 760
#define ULONGLONG_NUM 761
#define UNCOMMITTED_SYM 762
#define UNDEFINED_SYM 763
#define UNDERSCORE_CHARSET 764
#define UNDOFILE_SYM 765
#define UNDO_BUFFER_SIZE_SYM 766
#define UNDO_SYM 767
#define UNICODE_SYM 768
#define UNINSTALL_SYM 769
#define UNION_SYM 770
#define UNIQUE_SYM 771
#define UNKNOWN_SYM 772
#define UNLOCK_SYM 773
#define UNSIGNED 774
#define UNTIL_SYM 775
#define UPDATE_SYM 776
#define UPGRADE_SYM 777
#define USAGE 778
#define USER 779
#define USE_FRM 780
#define USE_SYM 781
#define USING 782
#define UTC_DATE_SYM 783
#define UTC_TIMESTAMP_SYM 784
#define UTC_TIME_SYM 785
#define VALUES 786
#define VALUE_SYM 787
#define VARBINARY 788
#define VARCHAR 789
#define VARIABLES 790
#define VARIANCE_SYM 791
#define VARYING 792
#define VAR_SAMP_SYM 793
#define VIEW_SYM 794
#define WAIT_SYM 795
#define WARNINGS 796
#define WEEK_SYM 797
#define WHEN_SYM 798
#define WHERE 799
#define WHILE_SYM 800
#define WITH 801
#define WORK_SYM 802
#define WRAPPER_SYM 803
#define WRITE_SYM 804
#define X509_SYM 805
#define XA_SYM 806
#define XOR 807
#define YEAR_MONTH_SYM 808
#define YEAR_SYM 809
#define ZEROFILL 810




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "event_data_objects.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#define YYERROR_UNLESS(A)               \
  if (!(A))                             \
  {					\
    yyerror(ER(ER_SYNTAX_ERROR));	\
    YYABORT;				\
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif

/* Helper for parsing "IS [NOT] truth_value" */
inline Item *is_truth_value(THD *thd, Item *A, bool v1, bool v2)
{
  Item *v1_t= new (thd->mem_root) Item_int((char *) (v1 ? "TRUE" : "FALSE"),
                                           v1, 1);
  Item *v1_f= new (thd->mem_root) Item_int((char *) (v1 ? "FALSE" : "TRUE"),
                                           !v1, 1);
  Item *v2_t= new (thd->mem_root) Item_int((char *) (v2 ? "TRUE" : "FALSE"),
                                           v2, 1);
  Item *ifnull= new (thd->mem_root) Item_func_ifnull(A, v2_t);

  return new (thd->mem_root) Item_func_if(ifnull, v1_t, v1_f);
}

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 314 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1534 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 357 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1549 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  533
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43122

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  575
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  832
/* YYNRULES -- Number of rules. */
#define YYNRULES  2317
/* YYNRULES -- Number of states. */
#define YYNSTATES  3972

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   810

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   568,     2,     2,     2,   562,   557,     2,
     565,   566,   560,   559,   567,   558,   572,   561,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   574,   573,
       2,     2,     2,     2,   571,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   563,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   569,   556,   570,   564,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   108,   110,   112,   114,   118,   120,
     122,   127,   129,   132,   133,   138,   139,   142,   146,   148,
     151,   152,   156,   157,   163,   165,   169,   173,   177,   181,
     185,   189,   193,   197,   201,   205,   209,   213,   215,   219,
     223,   227,   231,   232,   240,   241,   254,   255,   262,   263,
     267,   272,   277,   281,   284,   295,   297,   301,   304,   307,
     310,   313,   316,   319,   322,   323,   336,   337,   344,   347,
     348,   350,   352,   353,   356,   357,   360,   361,   363,   367,
     372,   373,   376,   377,   380,   382,   384,   386,   388,   390,
     392,   394,   396,   398,   400,   402,   403,   407,   409,   414,
     415,   416,   417,   418,   419,   432,   433,   436,   437,   440,
     443,   446,   449,   452,   456,   460,   462,   464,   466,   469,
     473,   477,   478,   483,   484,   488,   489,   491,   495,   497,
     498,   500,   504,   506,   507,   511,   512,   514,   518,   520,
     525,   526,   528,   530,   532,   533,   537,   540,   544,   545,
     549,   550,   556,   562,   563,   571,   577,   578,   581,   583,
     585,   587,   591,   593,   597,   598,   600,   602,   604,   606,
     609,   611,   613,   617,   618,   621,   623,   625,   627,   629,
     631,   633,   635,   637,   639,   641,   643,   644,   650,   651,
     654,   655,   659,   660,   663,   666,   669,   672,   673,   680,
     683,   684,   687,   689,   691,   695,   696,   697,   698,   706,
     707,   710,   713,   715,   717,   718,   719,   728,   729,   736,
     738,   741,   743,   746,   747,   748,   755,   756,   757,   764,
     765,   768,   769,   775,   776,   778,   779,   785,   790,   791,
     792,   801,   802,   810,   812,   814,   816,   818,   820,   823,
     828,   834,   835,   840,   845,   850,   854,   858,   861,   864,
     865,   868,   870,   873,   877,   879,   881,   883,   884,   887,
     889,   892,   896,   898,   900,   902,   904,   906,   908,   910,
     912,   913,   916,   918,   921,   925,   927,   929,   931,   933,
     935,   936,   939,   941,   944,   948,   950,   952,   954,   956,
     958,   960,   962,   963,   966,   968,   971,   975,   977,   979,
     981,   984,   987,   990,   992,   994,   996,   998,  1001,  1005,
    1009,  1013,  1017,  1021,  1025,  1029,  1033,  1038,  1039,  1041,
    1043,  1045,  1047,  1049,  1052,  1053,  1058,  1061,  1066,  1067,
    1074,  1075,  1076,  1083,  1084,  1085,  1091,  1092,  1100,  1101,
    1103,  1104,  1108,  1109,  1113,  1114,  1115,  1123,  1129,  1130,
    1135,  1136,  1140,  1141,  1145,  1146,  1148,  1149,  1151,  1153,
    1157,  1159,  1165,  1171,  1172,  1175,  1176,  1177,  1185,  1186,
    1196,  1198,  1202,  1204,  1206,  1207,  1210,  1211,  1215,  1217,
    1221,  1222,  1223,  1224,  1225,  1235,  1237,  1238,  1243,  1249,
    1251,  1253,  1255,  1259,  1263,  1265,  1269,  1271,  1273,  1274,
    1278,  1280,  1284,  1285,  1290,  1292,  1293,  1295,  1298,  1300,
    1304,  1309,  1313,  1317,  1321,  1326,  1331,  1335,  1336,  1337,
    1344,  1345,  1347,  1348,  1350,  1352,  1355,  1357,  1359,  1360,
    1362,  1364,  1367,  1369,  1370,  1374,  1375,  1377,  1379,  1382,
    1384,  1387,  1391,  1395,  1399,  1403,  1407,  1411,  1415,  1419,
    1423,  1427,  1431,  1435,  1439,  1443,  1449,  1451,  1453,  1457,
    1462,  1467,  1470,  1473,  1476,  1480,  1484,  1489,  1494,  1496,
    1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,
    1519,  1520,  1522,  1524,  1526,  1528,  1530,  1532,  1536,  1538,
    1540,  1543,  1546,  1554,  1563,  1572,  1575,  1578,  1579,  1581,
    1584,  1585,  1587,  1590,  1591,  1596,  1600,  1604,  1608,  1610,
    1615,  1617,  1619,  1625,  1628,  1634,  1637,  1642,  1644,  1650,
    1656,  1661,  1665,  1667,  1669,  1672,  1674,  1676,  1679,  1681,
    1683,  1685,  1688,  1692,  1695,  1699,  1702,  1705,  1709,  1713,
    1717,  1718,  1725,  1726,  1733,  1736,  1738,  1740,  1742,  1744,
    1746,  1748,  1750,  1752,  1754,  1756,  1758,  1761,  1764,  1766,
    1769,  1771,  1774,  1778,  1781,  1783,  1785,  1787,  1789,  1791,
    1793,  1795,  1798,  1799,  1803,  1805,  1811,  1812,  1814,  1817,
    1819,  1821,  1823,  1825,  1826,  1830,  1831,  1833,  1834,  1836,
    1839,  1841,  1843,  1846,  1849,  1854,  1856,  1860,  1863,  1865,
    1868,  1871,  1874,  1877,  1879,  1882,  1884,  1886,  1888,  1890,
    1892,  1894,  1896,  1898,  1900,  1902,  1903,  1906,  1908,  1910,
    1911,  1913,  1914,  1917,  1919,  1922,  1926,  1929,  1930,  1932,
    1933,  1935,  1937,  1940,  1941,  1943,  1944,  1949,  1951,  1956,
    1960,  1962,  1963,  1965,  1968,  1970,  1974,  1978,  1981,  1984,
    1987,  1989,  1991,  1994,  1997,  2000,  2002,  2005,  2008,  2011,
    2014,  2016,  2018,  2019,  2021,  2023,  2025,  2027,  2028,  2030,
    2032,  2034,  2035,  2037,  2040,  2041,  2043,  2045,  2048,  2051,
    2054,  2056,  2060,  2064,  2066,  2068,  2070,  2075,  2078,  2080,
    2085,  2086,  2088,  2089,  2092,  2094,  2098,  2099,  2106,  2107,
    2113,  2114,  2120,  2121,  2127,  2128,  2140,  2141,  2151,  2155,
    2160,  2164,  2168,  2176,  2177,  2181,  2183,  2188,  2189,  2193,
    2194,  2197,  2198,  2200,  2201,  2204,  2207,  2210,  2213,  2215,
    2217,  2219,  2223,  2228,  2229,  2237,  2238,  2245,  2246,  2252,
    2253,  2260,  2265,  2267,  2270,  2272,  2274,  2275,  2281,  2282,
    2286,  2289,  2290,  2296,  2297,  2298,  2305,  2307,  2311,  2313,
    2315,  2319,  2322,  2326,  2329,  2334,  2335,  2342,  2343,  2344,
    2353,  2358,  2363,  2367,  2371,  2374,  2377,  2384,  2390,  2394,
    2400,  2402,  2404,  2406,  2407,  2409,  2410,  2412,  2413,  2415,
    2417,  2418,  2421,  2423,  2424,  2426,  2428,  2430,  2431,  2437,
    2441,  2442,  2448,  2452,  2456,  2457,  2461,  2462,  2465,  2467,
    2471,  2472,  2474,  2476,  2477,  2480,  2482,  2486,  2487,  2494,
    2495,  2502,  2503,  2509,  2510,  2512,  2514,  2515,  2522,  2523,
    2525,  2527,  2530,  2532,  2534,  2536,  2537,  2544,  2547,  2548,
    2554,  2555,  2557,  2559,  2562,  2564,  2566,  2568,  2570,  2572,
    2575,  2576,  2583,  2584,  2586,  2588,  2589,  2594,  2595,  2600,
    2605,  2609,  2615,  2617,  2621,  2625,  2629,  2635,  2637,  2641,
    2644,  2646,  2648,  2649,  2656,  2658,  2662,  2666,  2667,  2670,
    2671,  2676,  2677,  2680,  2682,  2685,  2690,  2693,  2697,  2698,
    2702,  2703,  2704,  2711,  2714,  2716,  2718,  2721,  2724,  2733,
    2738,  2739,  2741,  2744,  2746,  2748,  2750,  2752,  2754,  2756,
    2758,  2760,  2762,  2764,  2766,  2767,  2770,  2775,  2779,  2781,
    2783,  2788,  2789,  2790,  2792,  2794,  2795,  2798,  2801,  2803,
    2805,  2806,  2809,  2810,  2814,  2815,  2819,  2823,  2824,  2828,
    2829,  2833,  2836,  2838,  2842,  2847,  2851,  2856,  2860,  2865,
    2867,  2871,  2876,  2880,  2884,  2891,  2893,  2899,  2906,  2912,
    2920,  2927,  2936,  2942,  2949,  2954,  2959,  2965,  2969,  2974,
    2976,  2980,  2982,  2986,  2988,  2992,  2996,  2998,  3002,  3006,
    3011,  3016,  3018,  3022,  3026,  3030,  3034,  3038,  3040,  3044,
    3046,  3048,  3050,  3052,  3054,  3056,  3058,  3060,  3062,  3064,
    3066,  3068,  3070,  3072,  3074,  3076,  3078,  3081,  3083,  3085,
    3087,  3089,  3091,  3095,  3097,  3099,  3101,  3103,  3107,  3110,
    3113,  3116,  3119,  3123,  3127,  3133,  3140,  3145,  3150,  3158,
    3161,  3168,  3174,  3181,  3188,  3193,  3198,  3203,  3205,  3210,
    3217,  3220,  3225,  3230,  3235,  3246,  3253,  3258,  3263,  3270,
    3275,  3280,  3285,  3292,  3297,  3305,  3313,  3321,  3328,  3335,
    3342,  3349,  3353,  3358,  3365,  3374,  3377,  3380,  3385,  3393,
    3401,  3408,  3415,  3418,  3423,  3430,  3437,  3446,  3455,  3462,
    3471,  3478,  3481,  3486,  3495,  3504,  3507,  3510,  3513,  3518,
    3523,  3528,  3533,  3537,  3546,  3551,  3558,  3563,  3568,  3573,
    3580,  3589,  3596,  3601,  3608,  3610,  3617,  3622,  3627,  3632,
    3637,  3642,  3649,  3654,  3655,  3661,  3668,  3671,  3675,  3676,
    3681,  3682,  3686,  3687,  3689,  3690,  3693,  3695,  3699,  3704,
    3709,  3715,  3720,  3725,  3730,  3736,  3741,  3742,  3743,  3751,
    3756,  3762,  3767,  3773,  3778,  3783,  3788,  3793,  3798,  3804,
    3805,  3814,  3815,  3819,  3823,  3825,  3830,  3831,  3833,  3834,
    3837,  3838,  3840,  3841,  3845,  3848,  3852,  3855,  3857,  3860,
    3862,  3865,  3867,  3869,  3871,  3874,  3875,  3877,  3878,  3881,
    3883,  3887,  3889,  3893,  3894,  3897,  3899,  3903,  3904,  3906,
    3907,  3910,  3915,  3921,  3923,  3925,  3927,  3929,  3933,  3937,
    3941,  3942,  3949,  3950,  3957,  3958,  3967,  3972,  3973,  3982,
    3983,  3994,  4001,  4002,  4011,  4012,  4023,  4030,  4032,  4035,
    4038,  4039,  4044,  4045,  4057,  4061,  4068,  4069,  4073,  4074,
    4075,  4081,  4082,  4084,  4085,  4087,  4088,  4091,  4094,  4097,
    4098,  4104,  4105,  4107,  4111,  4113,  4115,  4117,  4121,  4123,
    4125,  4127,  4129,  4131,  4133,  4135,  4137,  4139,  4141,  4143,
    4145,  4147,  4149,  4151,  4153,  4155,  4157,  4159,  4161,  4163,
    4165,  4167,  4169,  4171,  4173,  4174,  4176,  4178,  4179,  4182,
    4183,  4185,  4186,  4187,  4191,  4192,  4193,  4197,  4200,  4201,
    4202,  4207,  4212,  4215,  4216,  4219,  4222,  4226,  4230,  4232,
    4235,  4236,  4238,  4239,  4244,  4249,  4252,  4253,  4255,  4257,
    4258,  4260,  4261,  4263,  4266,  4268,  4272,  4276,  4278,  4280,
    4282,  4284,  4285,  4288,  4290,  4292,  4294,  4296,  4298,  4300,
    4302,  4304,  4306,  4308,  4310,  4312,  4314,  4316,  4318,  4320,
    4322,  4324,  4326,  4328,  4330,  4332,  4334,  4335,  4336,  4343,
    4344,  4346,  4350,  4352,  4355,  4356,  4359,  4363,  4365,  4368,
    4370,  4371,  4375,  4376,  4382,  4385,  4387,  4388,  4392,  4399,
    4400,  4407,  4412,  4417,  4422,  4427,  4433,  4438,  4443,  4449,
    4456,  4461,  4463,  4467,  4469,  4470,  4473,  4474,  4476,  4477,
    4478,  4487,  4488,  4489,  4496,  4497,  4499,  4501,  4503,  4505,
    4507,  4510,  4512,  4514,  4516,  4520,  4525,  4526,  4530,  4534,
    4536,  4539,  4542,  4543,  4547,  4548,  4554,  4558,  4560,  4564,
    4566,  4570,  4572,  4574,  4575,  4577,  4578,  4583,  4584,  4586,
    4590,  4592,  4594,  4596,  4597,  4598,  4605,  4606,  4607,  4619,
    4623,  4625,  4629,  4633,  4635,  4639,  4640,  4642,  4643,  4648,
    4649,  4656,  4657,  4663,  4664,  4671,  4673,  4677,  4681,  4687,
    4688,  4691,  4692,  4695,  4697,  4699,  4701,  4705,  4706,  4708,
    4709,  4713,  4716,  4721,  4726,  4730,  4735,  4740,  4743,  4745,
    4746,  4751,  4752,  4757,  4764,  4781,  4784,  4787,  4788,  4795,
    4801,  4804,  4807,  4810,  4812,  4814,  4816,  4822,  4828,  4831,
    4834,  4838,  4841,  4844,  4847,  4851,  4854,  4857,  4859,  4863,
    4868,  4872,  4876,  4879,  4882,  4886,  4890,  4894,  4898,  4902,
    4906,  4910,  4912,  4914,  4916,  4918,  4920,  4921,  4923,  4924,
    4927,  4928,  4930,  4932,  4934,  4935,  4938,  4939,  4942,  4943,
    4946,  4949,  4950,  4955,  4956,  4961,  4963,  4965,  4966,  4968,
    4970,  4971,  4973,  4975,  4976,  4981,  4985,  4987,  4988,  4992,
    4997,  5000,  5002,  5004,  5006,  5008,  5010,  5012,  5014,  5016,
    5017,  5019,  5020,  5024,  5028,  5030,  5032,  5034,  5037,  5038,
    5042,  5046,  5049,  5052,  5056,  5057,  5059,  5061,  5064,  5065,
    5070,  5076,  5077,  5078,  5079,  5096,  5099,  5100,  5102,  5103,
    5105,  5107,  5108,  5110,  5112,  5113,  5116,  5119,  5121,  5125,
    5130,  5134,  5138,  5139,  5142,  5145,  5147,  5151,  5155,  5156,
    5160,  5161,  5165,  5168,  5172,  5174,  5176,  5179,  5180,  5183,
    5185,  5187,  5190,  5193,  5195,  5197,  5199,  5201,  5203,  5206,
    5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,  5226,  5229,
    5232,  5235,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,
    5256,  5262,  5264,  5266,  5268,  5270,  5272,  5276,  5281,  5287,
    5289,  5295,  5299,  5302,  5304,  5308,  5311,  5313,  5315,  5317,
    5319,  5321,  5323,  5325,  5327,  5329,  5331,  5333,  5335,  5337,
    5339,  5341,  5345,  5348,  5350,  5352,  5354,  5356,  5358,  5360,
    5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,  5378,  5380,
    5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,  5398,  5400,
    5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,  5418,  5420,
    5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,  5438,  5440,
    5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,  5458,  5460,
    5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,  5478,  5480,
    5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496,  5498,  5500,
    5502,  5504,  5506,  5508,  5510,  5512,  5514,  5516,  5518,  5520,
    5522,  5524,  5526,  5528,  5530,  5532,  5534,  5536,  5538,  5540,
    5542,  5544,  5546,  5548,  5550,  5552,  5554,  5556,  5558,  5560,
    5562,  5564,  5566,  5568,  5570,  5572,  5574,  5576,  5578,  5580,
    5582,  5584,  5586,  5588,  5590,  5592,  5594,  5596,  5598,  5600,
    5602,  5604,  5606,  5608,  5610,  5612,  5614,  5616,  5618,  5620,
    5622,  5624,  5626,  5628,  5630,  5632,  5634,  5636,  5638,  5640,
    5642,  5644,  5646,  5648,  5650,  5652,  5654,  5656,  5658,  5660,
    5662,  5664,  5666,  5668,  5670,  5672,  5674,  5676,  5678,  5680,
    5682,  5684,  5686,  5688,  5690,  5692,  5694,  5696,  5698,  5700,
    5702,  5704,  5706,  5708,  5710,  5712,  5714,  5716,  5718,  5720,
    5722,  5724,  5726,  5728,  5730,  5732,  5734,  5736,  5738,  5740,
    5742,  5744,  5746,  5748,  5750,  5752,  5754,  5756,  5758,  5760,
    5762,  5764,  5766,  5768,  5770,  5772,  5774,  5776,  5778,  5780,
    5782,  5784,  5786,  5788,  5790,  5792,  5794,  5796,  5798,  5800,
    5802,  5804,  5806,  5808,  5810,  5812,  5814,  5816,  5818,  5820,
    5822,  5824,  5826,  5828,  5830,  5832,  5834,  5836,  5838,  5840,
    5842,  5844,  5846,  5848,  5850,  5852,  5854,  5856,  5858,  5860,
    5862,  5864,  5866,  5868,  5870,  5872,  5874,  5876,  5878,  5880,
    5882,  5884,  5886,  5888,  5890,  5892,  5894,  5896,  5898,  5900,
    5902,  5904,  5906,  5908,  5910,  5912,  5914,  5916,  5918,  5920,
    5922,  5924,  5926,  5928,  5930,  5932,  5934,  5936,  5938,  5939,
    5944,  5945,  5947,  5949,  5953,  5954,  5957,  5959,  5961,  5963,
    5965,  5966,  5968,  5969,  5971,  5973,  5975,  5976,  5979,  5982,
    5985,  5987,  5990,  5995,  6001,  6006,  6013,  6016,  6020,  6024,
    6028,  6034,  6036,  6040,  6044,  6047,  6050,  6053,  6055,  6057,
    6062,  6067,  6069,  6071,  6073,  6075,  6077,  6078,  6083,  6085,
    6087,  6089,  6093,  6097,  6099,  6101,  6104,  6107,  6108,  6112,
    6117,  6121,  6122,  6130,  6132,  6135,  6137,  6139,  6141,  6143,
    6145,  6147,  6148,  6154,  6156,  6158,  6160,  6162,  6164,  6168,
    6175,  6182,  6189,  6197,  6201,  6210,  6219,  6228,  6229,  6231,
    6233,  6236,  6237,  6239,  6241,  6245,  6246,  6250,  6251,  6255,
    6256,  6260,  6261,  6265,  6267,  6269,  6271,  6273,  6275,  6277,
    6279,  6281,  6283,  6285,  6287,  6290,  6293,  6295,  6299,  6302,
    6305,  6308,  6311,  6314,  6317,  6320,  6323,  6325,  6327,  6328,
    6330,  6334,  6336,  6339,  6342,  6345,  6347,  6351,  6355,  6357,
    6359,  6363,  6365,  6369,  6374,  6380,  6382,  6383,  6387,  6391,
    6393,  6395,  6396,  6399,  6402,  6405,  6408,  6409,  6412,  6415,
    6417,  6420,  6423,  6426,  6429,  6432,  6433,  6437,  6438,  6440,
    6441,  6445,  6448,  6449,  6451,  6454,  6455,  6457,  6462,  6467,
    6473,  6476,  6480,  6481,  6483,  6484,  6489,  6490,  6492,  6494,
    6495,  6498,  6501,  6503,  6504,  6506,  6508,  6513,  6514,  6522,
    6524,  6525,  6526,  6529,  6533,  6535,  6537,  6539,  6541,  6542,
    6546,  6548,  6551,  6553,  6556,  6560,  6564,  6568,  6569,  6571,
    6572,  6576,  6580,  6581,  6590,  6591,  6595,  6597,  6601,  6602,
    6605,  6609,  6615,  6616,  6620,  6625,  6630,  6631,  6646,  6647,
    6654,  6655,  6656,  6657,  6658,  6671,  6676,  6681,  6685,  6690,
    6694,  6697,  6699,  6703,  6709,  6711,  6713,  6714,  6716,  6718,
    6719,  6722,  6723,  6724,  6728,  6729,  6732,  6738
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     576,     0,    -1,   138,    -1,   577,   138,    -1,   578,    -1,
    1350,    -1,   901,    -1,   962,    -1,   952,    -1,   964,    -1,
     629,    -1,   590,    -1,   965,    -1,   954,    -1,  1356,    -1,
     595,    -1,   579,    -1,  1195,    -1,  1223,    -1,  1151,    -1,
    1153,    -1,   583,    -1,  1229,    -1,  1325,    -1,  1316,    -1,
     588,    -1,  1159,    -1,  1405,    -1,  1243,    -1,  1246,    -1,
    1308,    -1,   970,    -1,   980,    -1,   762,    -1,   984,    -1,
     581,    -1,  1239,    -1,  1359,    -1,   973,    -1,   957,    -1,
    1162,    -1,  1235,    -1,   950,    -1,  1323,    -1,  1357,    -1,
    1358,    -1,   992,    -1,  1291,    -1,  1208,    -1,   939,    -1,
     942,    -1,  1206,    -1,  1406,    -1,  1314,    -1,  1187,    -1,
    1245,    -1,  1397,    -1,   580,   361,  1285,    -1,   105,    -1,
     126,    -1,   361,  1285,   171,   582,    -1,  1282,    -1,   571,
    1287,    -1,    -1,   150,  1285,   584,   585,    -1,    -1,   527,
     586,    -1,   586,   567,   587,    -1,   587,    -1,   571,  1287,
      -1,    -1,   188,   589,  1287,    -1,    -1,    54,   271,   495,
     591,   592,    -1,   593,    -1,   592,   567,   593,    -1,   259,
     142,  1282,    -1,   272,   142,  1282,    -1,   262,   142,  1282,
      -1,   263,   142,  1132,    -1,   258,   142,  1132,    -1,   270,
     142,  1132,    -1,   266,   142,  1282,    -1,   265,   142,  1282,
      -1,   267,   142,  1282,    -1,   268,   142,  1282,    -1,   269,
     142,  1282,    -1,   594,    -1,   260,   142,  1282,    -1,   261,
     142,  1134,    -1,   386,   142,  1282,    -1,   387,   142,  1132,
      -1,    -1,    85,   815,   480,   818,  1279,   596,   750,    -1,
      -1,    85,   888,   204,  1285,   890,   329,  1279,   597,   565,
     896,   566,   891,    -1,    -1,    85,    92,   818,  1285,   598,
     812,    -1,    -1,    85,   599,  1373,    -1,    85,   524,   616,
    1341,    -1,    85,   249,   182,   709,    -1,    85,   478,   706,
      -1,    85,   600,    -1,   427,  1287,   167,    95,   548,  1287,
     334,   565,   601,   566,    -1,   602,    -1,   601,   567,   602,
      -1,   524,  1282,    -1,   191,  1282,    -1,    92,  1282,    -1,
     344,  1282,    -1,   352,  1282,    -1,   441,  1282,    -1,   358,
    1132,    -1,    -1,   148,   818,   617,   604,   329,   417,   605,
     610,   607,   612,   125,   613,    -1,    -1,   149,  1013,  1104,
     606,   608,   609,    -1,    22,  1013,    -1,    -1,   134,    -1,
     119,    -1,    -1,   459,  1013,    -1,    -1,   137,  1013,    -1,
      -1,   611,    -1,   329,    73,   362,    -1,   329,    73,   318,
     362,    -1,    -1,    69,  1282,    -1,    -1,   614,   615,    -1,
     660,    -1,   662,    -1,   658,    -1,   679,    -1,   694,    -1,
     664,    -1,   666,    -1,   667,    -1,   668,    -1,   669,    -1,
     671,    -1,    -1,  1285,   572,  1285,    -1,  1285,    -1,   405,
     830,   442,  1282,    -1,    -1,    -1,    -1,    -1,    -1,   565,
     619,   634,   566,   620,   405,   621,   841,   622,   625,   623,
     657,    -1,    -1,   624,   626,    -1,    -1,   625,   627,    -1,
      69,  1282,    -1,   228,   455,    -1,   320,   455,    -1,    80,
     455,    -1,   374,   455,    95,    -1,   296,   455,    95,    -1,
     628,    -1,   626,    -1,   117,    -1,  1031,   117,    -1,   455,
     420,   110,    -1,   455,   420,   217,    -1,    -1,    48,   617,
     630,   631,    -1,    -1,   565,   632,   566,    -1,    -1,   633,
      -1,   633,   567,  1013,    -1,  1013,    -1,    -1,   635,    -1,
     635,   567,   637,    -1,   637,    -1,    -1,  1285,   636,   841,
      -1,    -1,   639,    -1,   639,   567,   640,    -1,   640,    -1,
     641,   636,  1285,   841,    -1,    -1,   218,    -1,   343,    -1,
     209,    -1,    -1,   642,   657,   573,    -1,   657,   573,    -1,
     643,   657,   573,    -1,    -1,   644,   645,   573,    -1,    -1,
     108,   655,   646,   841,   656,    -1,   108,  1285,    76,   168,
     652,    -1,    -1,   108,   650,   185,   168,   647,   651,   657,
      -1,   108,  1285,    90,   168,   648,    -1,    -1,   649,   578,
      -1,   152,    -1,    81,    -1,   654,    -1,   651,   567,   654,
      -1,  1132,    -1,   447,   653,  1283,    -1,    -1,   532,    -1,
     652,    -1,  1285,    -1,   448,    -1,  1031,   169,    -1,   446,
      -1,  1285,    -1,   655,   567,  1285,    -1,    -1,   109,  1013,
      -1,   660,    -1,   662,    -1,   658,    -1,   679,    -1,   694,
      -1,   664,    -1,   666,    -1,   667,    -1,   668,    -1,   669,
      -1,   671,    -1,    -1,   200,   659,   674,   136,   200,    -1,
      -1,   661,   578,    -1,    -1,   406,   663,  1013,    -1,    -1,
     665,   697,    -1,   233,  1286,    -1,   222,  1286,    -1,   332,
    1285,    -1,    -1,   159,   672,  1285,   215,   670,   673,    -1,
      62,  1285,    -1,    -1,   314,   171,    -1,   171,    -1,  1285,
      -1,   673,   567,  1285,    -1,    -1,    -1,    -1,   675,  1013,
     487,   676,   643,   677,   678,    -1,    -1,   133,   674,    -1,
     132,   643,    -1,   680,    -1,   683,    -1,    -1,    -1,    51,
     681,  1013,   682,   685,   693,   136,    51,    -1,    -1,    51,
     684,   686,   693,   136,    51,    -1,   687,    -1,   685,   687,
      -1,   690,    -1,   686,   690,    -1,    -1,    -1,   543,   688,
    1013,   689,   487,   643,    -1,    -1,    -1,   543,   691,  1013,
     692,   487,   643,    -1,    -1,   132,   643,    -1,    -1,  1286,
     574,   695,   697,   696,    -1,    -1,  1286,    -1,    -1,    30,
     698,   644,   642,   136,    -1,   255,   643,   136,   255,    -1,
      -1,    -1,   545,   699,  1013,   125,   700,   643,   136,   545,
      -1,    -1,   396,   643,   520,   701,  1013,   136,   396,    -1,
      29,    -1,     8,    -1,   211,    -1,   521,    -1,   113,    -1,
     735,   737,    -1,   735,    54,   732,   712,    -1,   735,     6,
     732,   707,   716,    -1,    -1,   526,   249,   182,  1285,    -1,
     735,     6,   732,   720,    -1,   735,   126,   732,   720,    -1,
     736,   711,   724,    -1,   736,   711,   728,    -1,     6,   733,
      -1,     6,   734,    -1,    -1,   713,   714,    -1,   715,    -1,
     714,   715,    -1,   714,   567,   715,    -1,   738,    -1,   739,
      -1,   740,    -1,    -1,   717,   718,    -1,   719,    -1,   718,
     719,    -1,   718,   567,   719,    -1,   738,    -1,   739,    -1,
     740,    -1,   741,    -1,   744,    -1,   746,    -1,   748,    -1,
     745,    -1,    -1,   721,   722,    -1,   723,    -1,   722,   723,
      -1,   722,   567,   723,    -1,   738,    -1,   739,    -1,   740,
      -1,   746,    -1,   748,    -1,    -1,   725,   726,    -1,   727,
      -1,   726,   727,    -1,   726,   567,   727,    -1,   738,    -1,
     742,    -1,   743,    -1,   744,    -1,   746,    -1,   748,    -1,
     745,    -1,    -1,   729,   730,    -1,   731,    -1,   730,   731,
      -1,   730,   567,   731,    -1,   738,    -1,   746,    -1,   748,
      -1,    94,  1282,    -1,   510,  1282,    -1,   381,  1282,    -1,
    1285,    -1,  1285,    -1,   375,    -1,   377,    -1,   318,     4,
      -1,   206,  1179,   749,    -1,    24,  1179,   749,    -1,   277,
    1179,   749,    -1,   155,  1179,   749,    -1,   511,  1179,   749,
      -1,   382,  1179,   749,    -1,   315,  1179,  1133,    -1,    69,
    1179,  1282,    -1,  1216,   140,  1179,   825,    -1,    -1,   748,
      -1,   540,    -1,   321,    -1,  1133,    -1,   197,    -1,   565,
     752,    -1,    -1,   819,   759,   751,   756,    -1,   238,  1279,
      -1,   565,   238,  1279,   566,    -1,    -1,   831,   566,   819,
     759,   753,   756,    -1,    -1,    -1,   759,   754,   808,   566,
     755,  1363,    -1,    -1,    -1,  1254,   811,   808,   757,  1360,
      -1,    -1,  1254,   811,   565,   808,   566,   758,  1363,    -1,
      -1,   760,    -1,    -1,   351,   761,   764,    -1,    -1,   351,
     763,   764,    -1,    -1,    -1,    45,   767,   777,   765,   778,
     766,   785,    -1,   771,   226,   565,   772,   566,    -1,    -1,
     771,   186,   768,   775,    -1,    -1,   373,   769,   775,    -1,
      -1,   243,   770,   775,    -1,    -1,   240,    -1,    -1,   773,
      -1,   774,    -1,   773,   567,   774,    -1,  1285,    -1,   565,
    1008,   783,  1009,   566,    -1,   565,  1008,   783,  1009,   566,
      -1,    -1,   350,  1133,    -1,    -1,    -1,   471,    45,   771,
     186,   776,   779,   784,    -1,    -1,   471,    45,   771,   226,
     565,   781,   566,   780,   784,    -1,   782,    -1,   781,   567,
     782,    -1,  1285,    -1,  1023,    -1,    -1,   470,  1133,    -1,
      -1,   565,   786,   566,    -1,   787,    -1,   786,   567,   787,
      -1,    -1,    -1,    -1,    -1,   351,   788,   792,   789,   793,
     790,   805,   791,   800,    -1,  1285,    -1,    -1,   531,   235,
     486,   794,    -1,   531,   218,   565,   797,   566,    -1,   795,
      -1,   796,    -1,   281,    -1,   565,   281,   566,    -1,   565,
     799,   566,    -1,   798,    -1,   797,   567,   798,    -1,   799,
      -1,  1023,    -1,    -1,   565,   801,   566,    -1,   802,    -1,
     801,   567,   802,    -1,    -1,   471,   803,   804,   805,    -1,
    1287,    -1,    -1,   806,    -1,   806,   807,    -1,   807,    -1,
     478,  1179,  1287,    -1,  1216,   140,  1179,   825,    -1,   315,
    1179,  1133,    -1,   276,  1179,  1135,    -1,   293,  1179,  1135,
      -1,    95,   118,  1179,  1282,    -1,   204,   118,  1179,  1282,
      -1,    69,  1179,  1282,    -1,    -1,    -1,   421,   809,  1002,
    1006,   810,   828,    -1,    -1,    18,    -1,    -1,   813,    -1,
     814,    -1,   813,   814,    -1,   824,    -1,   823,    -1,    -1,
     816,    -1,   817,    -1,   817,   816,    -1,   481,    -1,    -1,
     200,  1031,   151,    -1,    -1,   821,    -1,   822,    -1,   822,
     820,    -1,   822,    -1,   822,   821,    -1,   822,   567,   821,
      -1,   140,  1179,   825,    -1,   504,  1179,   825,    -1,   276,
    1179,  1134,    -1,   293,  1179,  1134,    -1,    26,  1179,  1132,
      -1,   352,  1179,  1282,    -1,    69,  1179,  1282,    -1,    25,
    1179,  1134,    -1,   345,  1179,  1132,    -1,   345,  1179,   109,
      -1,    58,  1179,  1132,    -1,   112,  1179,  1132,    -1,   413,
    1179,   826,    -1,   515,  1179,   565,  1155,   566,    -1,   823,
      -1,   824,    -1,   212,  1179,   827,    -1,    95,   118,  1179,
    1282,    -1,   204,   118,  1179,  1282,    -1,   478,  1285,    -1,
     465,   121,    -1,   465,   286,    -1,    77,  1179,  1282,    -1,
     225,  1179,  1132,    -1,   870,   862,  1179,   864,    -1,   870,
      65,  1179,   869,    -1,  1287,    -1,   109,    -1,   162,    -1,
     130,    -1,    74,    -1,   383,    -1,    72,    -1,   320,    -1,
     161,    -1,   229,    -1,  1127,    -1,  1001,  1005,    -1,    -1,
      10,    -1,   467,    -1,   378,    -1,   107,    -1,   216,    -1,
     832,    -1,   831,   567,   832,    -1,   833,    -1,   834,    -1,
     839,   835,    -1,   839,   875,    -1,   883,   898,   890,   565,
     896,   566,   891,    -1,   837,   884,   898,   890,   565,   896,
     566,   891,    -1,   837,   167,   226,   898,   565,   896,   566,
     875,    -1,   838,   835,    -1,   837,   836,    -1,    -1,   836,
      -1,    59,  1013,    -1,    -1,   838,    -1,    79,   898,    -1,
      -1,  1278,   840,   841,   858,    -1,   849,   856,   853,    -1,
     850,   857,   853,    -1,   164,   851,   853,    -1,    38,    -1,
      38,   565,   324,   566,    -1,    42,    -1,    41,    -1,   845,
     565,   324,   566,   871,    -1,   845,   871,    -1,   846,   565,
     324,   566,   872,    -1,   846,   872,    -1,    33,   565,   324,
     566,    -1,    33,    -1,   847,   565,   324,   566,   871,    -1,
     848,   565,   324,   566,   872,    -1,   533,   565,   324,   566,
      -1,   554,   856,   853,    -1,    99,    -1,   491,    -1,   488,
     856,    -1,    96,    -1,   492,    -1,    40,   856,    -1,   844,
      -1,   282,    -1,   251,    -1,   254,   533,    -1,   254,   847,
     871,    -1,   494,   871,    -1,   485,   856,   871,    -1,   284,
     871,    -1,   252,   871,    -1,   107,   851,   853,    -1,   325,
     851,   853,    -1,   162,   851,   853,    -1,    -1,   141,   842,
     565,   900,   566,   871,    -1,    -1,   429,   843,   565,   900,
     566,   871,    -1,   254,   871,    -1,   425,    -1,   177,    -1,
     176,    -1,   356,    -1,   301,    -1,   242,    -1,   300,    -1,
     357,    -1,   302,    -1,    57,    -1,   309,    -1,   306,    57,
      -1,   845,   537,    -1,   534,    -1,   306,   534,    -1,   326,
      -1,   309,   534,    -1,   306,    57,   537,    -1,   309,   537,
      -1,   216,    -1,   493,    -1,   439,    -1,   283,    -1,    32,
      -1,   378,    -1,   124,    -1,   124,   360,    -1,    -1,   565,
     324,   566,    -1,   852,    -1,   565,   324,   567,   324,   566,
      -1,    -1,   854,    -1,   854,   855,    -1,   855,    -1,   436,
      -1,   519,    -1,   555,    -1,    -1,   565,   324,   566,    -1,
      -1,   852,    -1,    -1,   859,    -1,   859,   860,    -1,   860,
      -1,   323,    -1,  1031,   323,    -1,   109,   861,    -1,   329,
     521,   319,  1012,    -1,    25,    -1,   425,   109,   532,    -1,
     874,   226,    -1,   516,    -1,   516,   226,    -1,    69,  1282,
      -1,    65,   867,    -1,   319,  1012,    -1,  1269,    -1,    57,
     429,    -1,    56,    -1,  1287,    -1,    33,    -1,   863,    -1,
     109,    -1,  1287,    -1,    33,    -1,   865,    -1,   109,    -1,
    1287,    -1,    -1,    65,   869,    -1,   867,    -1,   109,    -1,
      -1,   109,    -1,    -1,    20,   872,    -1,    46,    -1,   513,
     872,    -1,   862,   863,   872,    -1,    33,   873,    -1,    -1,
      33,    -1,    -1,    20,    -1,   513,    -1,   862,   863,    -1,
      -1,   364,    -1,    -1,   384,  1279,   876,   877,    -1,   879,
      -1,   565,   878,   566,   879,    -1,   878,   567,  1285,    -1,
    1285,    -1,    -1,   880,    -1,   880,   881,    -1,   881,    -1,
     329,   113,   882,    -1,   329,   521,   882,    -1,   273,   172,
      -1,   273,   348,    -1,   273,   437,    -1,   403,    -1,    49,
      -1,   429,   323,    -1,   320,     5,    -1,   429,   109,    -1,
     885,    -1,   173,   886,    -1,   444,   886,    -1,   364,   226,
      -1,   516,   886,    -1,   226,    -1,   204,    -1,    -1,   885,
      -1,   224,    -1,   204,    -1,   203,    -1,    -1,   516,    -1,
     173,    -1,   444,    -1,    -1,   889,    -1,   889,   893,    -1,
      -1,   892,    -1,   894,    -1,   892,   894,    -1,   527,   895,
      -1,   504,   895,    -1,   893,    -1,   225,  1179,  1132,    -1,
     546,   347,  1281,    -1,    44,    -1,   415,    -1,   186,    -1,
     896,   567,   897,  1125,    -1,   897,  1125,    -1,  1285,    -1,
    1285,   565,   324,   566,    -1,    -1,  1278,    -1,    -1,   572,
    1285,    -1,  1267,    -1,   900,   567,  1267,    -1,    -1,    13,
     935,   480,  1279,   902,   912,    -1,    -1,    13,    92,   911,
     903,   812,    -1,    -1,    13,   366,   617,   904,   624,    -1,
      -1,    13,   174,   617,   905,   624,    -1,    -1,    13,  1379,
    1375,  1380,   539,  1279,   906,  1383,    18,  1385,  1388,    -1,
      -1,    13,   148,   617,   907,   908,   909,   607,   612,   910,
      -1,    13,   478,   708,    -1,    13,   249,   182,   710,    -1,
      13,   478,   705,    -1,    13,   478,   704,    -1,    13,   427,
    1287,   334,   565,   601,   566,    -1,    -1,   329,   417,   605,
      -1,   611,    -1,   329,   417,   605,   611,    -1,    -1,   392,
     495,   617,    -1,    -1,   125,   613,    -1,    -1,  1285,    -1,
      -1,   120,   478,    -1,   202,   478,    -1,   928,   759,    -1,
     928,   917,    -1,   917,    -1,   760,    -1,   919,    -1,   126,
     351,   926,    -1,   379,   351,   972,   918,    -1,    -1,   333,
     351,   972,   918,   913,   972,   967,    -1,    -1,    14,   351,
     972,   918,   914,   967,    -1,    -1,    59,   351,   918,   915,
     967,    -1,    -1,   394,   351,   972,   918,   916,   959,    -1,
      63,   351,   972,  1133,    -1,   922,    -1,   391,   349,    -1,
      12,    -1,   926,    -1,    -1,     6,   351,   972,   920,   921,
      -1,    -1,   565,   786,   566,    -1,   350,  1133,    -1,    -1,
     393,   351,   972,   923,   924,    -1,    -1,    -1,   926,   925,
     215,   565,   786,   566,    -1,   927,    -1,   926,   567,   927,
      -1,  1285,    -1,   930,    -1,   928,   567,   930,    -1,     6,
     934,    -1,   929,   833,   937,    -1,     6,   834,    -1,   929,
     565,   831,   566,    -1,    -1,    54,   934,  1278,   931,   839,
     937,    -1,    -1,    -1,   297,   934,  1278,   932,   841,   858,
     933,   937,    -1,   126,   934,  1278,   936,    -1,   126,   167,
     226,   898,    -1,   126,   364,   226,    -1,   126,   885,  1278,
      -1,   119,   224,    -1,   134,   224,    -1,    13,   934,  1278,
     429,   109,  1269,    -1,    13,   934,  1278,   126,   109,    -1,
     392,   938,  1279,    -1,    83,   495,   862,   864,   868,    -1,
     820,    -1,   166,    -1,  1118,    -1,    -1,    68,    -1,    -1,
     201,    -1,    -1,   403,    -1,    49,    -1,    -1,     8,  1285,
      -1,   161,    -1,    -1,   495,    -1,   142,    -1,    18,    -1,
      -1,   460,   438,   944,   940,   948,    -1,   464,   438,   944,
      -1,    -1,   438,   460,   944,   941,   948,    -1,   438,   464,
     944,    -1,   460,   497,   943,    -1,    -1,   546,    78,   440,
      -1,    -1,   945,   946,    -1,   947,    -1,   946,   567,   947,
      -1,    -1,   456,    -1,   388,    -1,    -1,   520,   949,    -1,
     594,    -1,   949,   567,   594,    -1,    -1,   402,  1310,   951,
    1155,   171,  1282,    -1,    -1,    28,  1310,   953,  1155,   495,
    1282,    -1,    -1,    58,  1310,   955,  1155,   956,    -1,    -1,
     372,    -1,   154,    -1,    -1,   394,   972,  1310,   958,  1155,
     959,    -1,    -1,   960,    -1,   961,    -1,   961,   960,    -1,
     372,    -1,   154,    -1,   525,    -1,    -1,    14,   972,  1310,
     963,  1155,   967,    -1,    34,  1282,    -1,    -1,    59,  1310,
     966,  1155,   967,    -1,    -1,   968,    -1,   969,    -1,   969,
     968,    -1,   372,    -1,   158,    -1,   285,    -1,   154,    -1,
      55,    -1,   168,   522,    -1,    -1,   333,   972,  1310,   971,
    1155,   967,    -1,    -1,   322,    -1,   245,    -1,    -1,   392,
    1310,   974,   977,    -1,    -1,   392,    92,   975,   979,    -1,
     392,   524,   616,   976,    -1,  1288,   495,  1288,    -1,   976,
     567,  1288,   495,  1288,    -1,   978,    -1,   977,   567,   978,
      -1,  1279,   495,  1279,    -1,  1285,   495,  1285,    -1,    47,
     204,   981,   218,   983,    -1,   982,    -1,   981,   567,   982,
      -1,  1279,   988,    -1,  1285,    -1,   109,    -1,    -1,   244,
     204,   215,    47,   985,   986,    -1,   987,    -1,   986,   567,
     987,    -1,  1279,   988,   991,    -1,    -1,   989,   990,    -1,
      -1,   886,   565,  1102,   566,    -1,    -1,   201,   232,    -1,
     993,    -1,   421,   995,    -1,   565,   994,   566,  1363,    -1,
     421,   997,    -1,   565,   994,   566,    -1,    -1,   997,   996,
    1360,    -1,    -1,    -1,   998,  1002,  1006,   999,  1000,  1005,
      -1,  1121,  1127,    -1,  1147,    -1,  1001,    -1,  1147,  1001,
      -1,  1001,  1147,    -1,   171,  1076,  1110,  1115,  1112,  1121,
    1127,  1138,    -1,   171,   127,  1110,  1127,    -1,    -1,  1003,
      -1,  1003,  1004,    -1,  1004,    -1,   466,    -1,   190,    -1,
     122,    -1,   454,    -1,   449,    -1,   450,    -1,   452,    -1,
     453,    -1,   451,    -1,    12,    -1,    -1,   168,   521,    -1,
     248,   218,   431,   295,    -1,  1006,   567,  1007,    -1,  1007,
      -1,   560,    -1,  1008,  1010,  1009,  1011,    -1,    -1,    -1,
    1273,    -1,  1013,    -1,    -1,    18,  1285,    -1,    18,  1282,
      -1,  1285,    -1,  1282,    -1,    -1,   565,   566,    -1,    -1,
    1016,  1014,  1015,    -1,    -1,  1015,  1029,  1016,    -1,  1016,
     552,  1016,    -1,    -1,  1019,  1017,  1018,    -1,    -1,  1018,
    1030,  1019,    -1,   318,  1019,    -1,  1020,    -1,  1021,   219,
     501,    -1,  1021,   219,  1031,   501,    -1,  1021,   219,   157,
      -1,  1021,   219,  1031,   157,    -1,  1021,   219,   517,    -1,
    1021,   219,  1031,   517,    -1,  1021,    -1,  1021,   219,   323,
      -1,  1021,   219,  1031,   323,    -1,  1021,   143,  1022,    -1,
    1021,  1033,  1022,    -1,  1021,  1033,  1034,   565,  1368,   566,
      -1,  1022,    -1,  1023,   218,   565,  1368,   566,    -1,  1023,
    1031,   218,   565,  1368,   566,    -1,  1023,   218,   565,  1013,
     566,    -1,  1023,   218,   565,  1013,   567,  1065,   566,    -1,
    1023,  1031,   218,   565,  1013,   566,    -1,  1023,  1031,   218,
     565,  1013,   567,  1065,   566,    -1,  1023,    31,  1023,    16,
    1022,    -1,  1023,  1031,    31,  1023,    16,  1022,    -1,  1023,
     443,   238,  1023,    -1,  1023,   238,  1036,  1114,    -1,  1023,
    1031,   238,  1036,  1114,    -1,  1023,   385,  1023,    -1,  1023,
    1031,   385,  1023,    -1,  1023,    -1,  1023,   556,  1024,    -1,
    1024,    -1,  1024,   557,  1025,    -1,  1025,    -1,  1025,   432,
    1026,    -1,  1025,   433,  1026,    -1,  1026,    -1,  1026,   559,
    1027,    -1,  1026,   558,  1027,    -1,  1026,   559,  1035,  1104,
      -1,  1026,   558,  1035,  1104,    -1,  1027,    -1,  1027,   560,
    1028,    -1,  1027,   561,  1028,    -1,  1027,   562,  1028,    -1,
    1027,   123,  1028,    -1,  1027,   298,  1028,    -1,  1028,    -1,
    1028,   563,  1036,    -1,  1036,    -1,   340,    -1,   337,    -1,
      16,    -1,    15,    -1,   318,    -1,   317,    -1,   568,    -1,
     317,    -1,   142,    -1,   175,    -1,   184,    -1,   230,    -1,
     257,    -1,   311,    -1,    12,    -1,    17,    -1,   214,  1013,
      -1,  1275,    -1,  1037,    -1,  1038,    -1,  1041,    -1,  1039,
      -1,  1036,    65,  1287,    -1,  1270,    -1,  1268,    -1,  1055,
      -1,  1051,    -1,  1036,   339,  1036,    -1,   559,  1036,    -1,
     558,  1036,    -1,   564,  1036,    -1,  1032,  1036,    -1,   565,
    1368,   566,    -1,   565,  1013,   566,    -1,   565,  1013,   567,
    1065,   566,    -1,   414,   565,  1013,   567,  1065,   566,    -1,
     151,   565,  1368,   566,    -1,   569,  1285,  1013,   570,    -1,
     273,  1068,     9,   565,  1023,  1043,   566,    -1,    33,  1036,
      -1,    52,   565,  1013,    18,  1063,   566,    -1,    51,  1072,
    1074,  1073,   136,    -1,    83,   565,  1013,   567,  1063,   566,
      -1,    83,   565,  1013,   527,   863,   566,    -1,   109,   565,
    1275,   566,    -1,   531,   565,  1276,   566,    -1,  1035,  1104,
     559,  1013,    -1,  1035,    -1,    57,   565,  1065,   566,    -1,
      57,   565,  1065,   527,   863,   566,    -1,    89,  1012,    -1,
      99,   565,  1013,   566,    -1,   104,   565,  1013,   566,    -1,
     196,   565,  1013,   566,    -1,   211,   565,  1013,   567,  1013,
     567,  1013,   567,  1013,   566,    -1,   234,   565,  1013,   567,
    1013,   566,    -1,   292,   565,  1013,   566,    -1,   299,   565,
    1013,   566,    -1,   408,   565,  1013,   567,  1013,   566,    -1,
     419,   565,  1013,   566,    -1,   491,   565,  1013,   566,    -1,
     488,   565,  1013,   566,    -1,   488,   565,  1013,   567,  1013,
     566,    -1,   500,   565,  1013,   566,    -1,   500,   565,   231,
    1013,   171,  1013,   566,    -1,   500,   565,   496,  1013,   171,
    1013,   566,    -1,   500,   565,    43,  1013,   171,  1013,   566,
      -1,   500,   565,   231,   171,  1013,   566,    -1,   500,   565,
     496,   171,  1013,   566,    -1,   500,   565,    43,   171,  1013,
     566,    -1,   500,   565,  1013,   171,  1013,   566,    -1,   524,
     565,   566,    -1,   554,   565,  1013,   566,    -1,     7,   565,
    1013,   567,  1013,   566,    -1,     7,   565,  1013,   567,   214,
    1013,  1104,   566,    -1,    88,  1012,    -1,    91,  1012,    -1,
      91,   565,  1013,   566,    -1,    97,   565,  1013,   567,  1035,
    1104,   566,    -1,    98,   565,  1013,   567,  1035,  1104,   566,
      -1,   156,   565,  1104,   171,  1013,   566,    -1,   178,   565,
    1106,   567,  1013,   566,    -1,   319,  1012,    -1,   319,   565,
    1013,   566,    -1,   359,   565,  1023,   218,  1013,   566,    -1,
     468,   565,  1013,   567,  1013,   566,    -1,   468,   565,  1013,
     567,   214,  1013,  1104,   566,    -1,   472,   565,  1013,   567,
    1013,   567,  1013,   566,    -1,   472,   565,  1013,   567,  1013,
     566,    -1,   472,   565,  1013,   171,  1013,   168,  1013,   566,
      -1,   472,   565,  1013,   171,  1013,   566,    -1,   476,  1012,
      -1,   476,   565,  1013,   566,    -1,   489,   565,  1105,   567,
    1013,   567,  1013,   566,    -1,   490,   565,  1105,   567,  1013,
     567,  1013,   566,    -1,   528,  1012,    -1,   530,  1012,    -1,
     529,  1012,    -1,    20,   565,  1013,   566,    -1,    56,   565,
    1013,   566,    -1,    63,   565,  1065,   566,    -1,    66,   565,
    1013,   566,    -1,    92,   565,   566,    -1,   200,   565,  1013,
     567,  1013,   567,  1013,   566,    -1,   288,   565,  1013,   566,
      -1,   298,   565,  1013,   567,  1013,   566,    -1,   328,   565,
    1013,   566,    -1,   352,   565,  1013,   566,    -1,   370,   565,
    1013,   566,    -1,   396,   565,  1013,   567,  1013,   566,    -1,
     397,   565,  1013,   567,  1013,   567,  1013,   566,    -1,   502,
     565,  1013,   567,  1013,   566,    -1,   542,   565,  1013,   566,
      -1,   542,   565,  1013,   567,  1013,   566,    -1,  1040,    -1,
      80,   565,  1013,   567,  1013,   566,    -1,   176,   565,  1065,
     566,    -1,   242,   565,  1065,   566,    -1,   300,   565,  1065,
     566,    -1,   301,   565,  1065,   566,    -1,   302,   565,  1065,
     566,    -1,   356,   565,  1013,   567,  1013,   566,    -1,   357,
     565,  1065,   566,    -1,    -1,  1281,   565,  1042,  1046,   566,
      -1,  1285,   572,  1285,   565,  1064,   566,    -1,  1044,  1045,
      -1,   218,    41,   295,    -1,    -1,   218,   307,   228,   295,
      -1,    -1,   546,   371,   153,    -1,    -1,  1047,    -1,    -1,
    1048,  1049,    -1,  1050,    -1,  1049,   567,  1050,    -1,  1008,
    1013,  1009,  1011,    -1,    27,   565,  1061,   566,    -1,    27,
     565,   122,  1061,   566,    -1,    36,   565,  1061,   566,    -1,
      37,   565,  1061,   566,    -1,    39,   565,  1061,   566,    -1,
      84,   565,  1109,   560,   566,    -1,    84,   565,  1061,   566,
      -1,    -1,    -1,    84,   565,   122,  1052,  1065,  1053,   566,
      -1,   294,   565,  1061,   566,    -1,   294,   565,   122,  1061,
     566,    -1,   278,   565,  1061,   566,    -1,   278,   565,   122,
    1061,   566,    -1,   463,   565,  1061,   566,    -1,   536,   565,
    1061,   566,    -1,   462,   565,  1061,   566,    -1,   538,   565,
    1061,   566,    -1,   473,   565,  1061,   566,    -1,   473,   565,
     122,  1061,   566,    -1,    -1,   183,   565,  1058,  1054,  1065,
    1060,  1059,   566,    -1,    -1,   571,  1056,  1057,    -1,  1287,
     430,  1013,    -1,  1287,    -1,   571,  1300,  1287,   899,    -1,
      -1,   122,    -1,    -1,   423,  1267,    -1,    -1,  1122,    -1,
      -1,  1109,  1062,  1013,    -1,    33,   856,    -1,    57,   856,
     871,    -1,   309,   856,    -1,   436,    -1,   436,   216,    -1,
     519,    -1,   519,   216,    -1,    99,    -1,   491,    -1,    96,
      -1,   107,   851,    -1,    -1,  1065,    -1,    -1,  1066,  1067,
      -1,  1013,    -1,  1067,   567,  1013,    -1,  1069,    -1,   565,
    1069,   566,    -1,    -1,  1070,  1071,    -1,  1275,    -1,  1071,
     567,  1275,    -1,    -1,  1013,    -1,    -1,   132,  1013,    -1,
     543,  1013,   487,  1013,    -1,  1074,   543,  1013,   487,  1013,
      -1,  1087,    -1,  1078,    -1,  1077,    -1,  1075,    -1,  1077,
     567,  1075,    -1,  1075,  1086,  1075,    -1,  1075,   466,  1087,
      -1,    -1,  1075,  1086,  1075,   329,  1079,  1013,    -1,    -1,
    1075,   466,  1087,   329,  1080,  1013,    -1,    -1,  1075,  1086,
    1075,   527,  1081,   565,  1103,   566,    -1,  1075,   307,   223,
    1087,    -1,    -1,  1075,   234,  1097,   223,  1075,   329,  1082,
    1013,    -1,    -1,  1075,   234,  1097,   223,  1087,  1083,   527,
     565,  1103,   566,    -1,  1075,   307,   234,  1097,   223,  1087,
      -1,    -1,  1075,   408,  1097,   223,  1075,   329,  1084,  1013,
      -1,    -1,  1075,   408,  1097,   223,  1087,  1085,   527,   565,
    1103,   566,    -1,  1075,   307,   408,  1097,   223,  1087,    -1,
     223,    -1,   207,   223,    -1,    86,   223,    -1,    -1,  1088,
    1279,  1108,  1098,    -1,    -1,   569,  1285,  1075,   234,   341,
     223,  1075,   329,  1089,  1013,   570,    -1,  1096,  1095,  1092,
      -1,   565,  1095,  1090,  1363,   566,  1108,    -1,    -1,  1095,
    1091,  1077,    -1,    -1,    -1,  1093,  1002,  1006,  1094,   828,
      -1,    -1,   421,    -1,    -1,   341,    -1,    -1,   526,  1099,
      -1,   166,  1099,    -1,   201,  1099,    -1,    -1,   885,  1100,
     565,  1101,   566,    -1,    -1,  1102,    -1,  1102,   567,  1285,
      -1,  1285,    -1,   364,    -1,  1285,    -1,  1103,   567,  1285,
      -1,  1105,    -1,   100,    -1,   101,    -1,   102,    -1,   103,
      -1,   193,    -1,   194,    -1,   195,    -1,   288,    -1,   290,
      -1,   291,    -1,   418,    -1,   553,    -1,   104,    -1,   542,
      -1,   196,    -1,   170,    -1,   292,    -1,   299,    -1,   370,
      -1,   419,    -1,   554,    -1,    99,    -1,   491,    -1,    96,
      -1,   488,    -1,    -1,    18,    -1,   142,    -1,    -1,  1107,
    1285,    -1,    -1,    12,    -1,    -1,    -1,   544,  1111,  1013,
      -1,    -1,    -1,   187,  1113,  1013,    -1,   146,  1036,    -1,
      -1,    -1,   182,    45,  1116,  1117,    -1,  1116,   567,  1274,
    1125,    -1,  1274,  1125,    -1,    -1,   546,    87,    -1,   546,
     410,    -1,   338,    45,  1119,    -1,  1119,   567,  1120,    -1,
    1120,    -1,  1276,  1125,    -1,    -1,  1122,    -1,    -1,   338,
      45,  1123,  1124,    -1,  1124,   567,  1274,  1125,    -1,  1274,
    1125,    -1,    -1,    19,    -1,   114,    -1,    -1,  1128,    -1,
      -1,  1128,    -1,   239,  1129,    -1,  1130,    -1,  1130,   567,
    1130,    -1,  1130,   327,  1130,    -1,  1268,    -1,   506,    -1,
     253,    -1,   324,    -1,    -1,   239,  1130,    -1,   324,    -1,
     189,    -1,   253,    -1,   506,    -1,   106,    -1,   163,    -1,
     324,    -1,   189,    -1,   253,    -1,   506,    -1,  1136,    -1,
     324,    -1,   506,    -1,   253,    -1,   106,    -1,   163,    -1,
     324,    -1,   506,    -1,   253,    -1,  1136,    -1,  1137,    -1,
     106,    -1,   163,    -1,    -1,    -1,   366,  1285,  1139,   565,
    1140,   566,    -1,    -1,  1141,    -1,  1141,   567,  1142,    -1,
    1142,    -1,  1008,  1013,    -1,    -1,  1144,  1145,    -1,  1145,
     567,  1146,    -1,  1146,    -1,   571,  1287,    -1,  1287,    -1,
      -1,   215,  1148,  1149,    -1,    -1,   342,  1284,  1150,  1255,
    1258,    -1,   128,  1284,    -1,  1143,    -1,    -1,   125,  1152,
    1065,    -1,   126,  1158,  1310,  1157,  1155,   936,    -1,    -1,
     126,   204,  1285,   329,  1279,  1154,    -1,   126,    92,  1157,
    1285,    -1,   126,   174,  1157,   617,    -1,   126,   366,  1157,
     617,    -1,   126,   524,   616,  1340,    -1,   126,   539,  1157,
    1155,   936,    -1,   126,   148,  1157,   617,    -1,   126,   499,
    1157,   617,    -1,   126,   478,   735,   746,   747,    -1,   126,
     249,   182,   736,   746,   747,    -1,   126,   427,  1157,  1287,
      -1,  1156,    -1,  1155,   567,  1156,    -1,  1279,    -1,    -1,
     200,   151,    -1,    -1,   481,    -1,    -1,    -1,   211,  1160,
    1165,   935,  1167,  1161,  1169,  1185,    -1,    -1,    -1,   397,
    1163,  1166,  1167,  1164,  1169,    -1,    -1,   256,    -1,   111,
      -1,   190,    -1,  1194,    -1,   111,    -1,   215,  1168,    -1,
    1168,    -1,  1156,    -1,  1172,    -1,   565,   566,  1172,    -1,
     565,  1171,   566,  1172,    -1,    -1,   429,  1170,  1176,    -1,
    1171,   567,  1272,    -1,  1272,    -1,   531,  1175,    -1,   532,
    1175,    -1,    -1,   808,  1173,  1360,    -1,    -1,   565,   808,
     566,  1174,  1363,    -1,  1175,   567,  1180,    -1,  1180,    -1,
    1176,   567,  1177,    -1,  1177,    -1,  1276,  1178,  1184,    -1,
     142,    -1,   430,    -1,    -1,  1178,    -1,    -1,   565,  1181,
    1182,   566,    -1,    -1,  1183,    -1,  1183,   567,  1184,    -1,
    1184,    -1,  1013,    -1,   109,    -1,    -1,    -1,   329,   129,
    1186,   226,   521,  1192,    -1,    -1,    -1,   521,  1188,  1194,
     935,  1076,   429,  1190,  1189,  1110,  1121,  1131,    -1,  1190,
     567,  1191,    -1,  1191,    -1,  1276,  1178,  1184,    -1,  1192,
     567,  1193,    -1,  1193,    -1,  1276,  1178,  1184,    -1,    -1,
     256,    -1,    -1,   113,  1196,  1204,  1197,    -1,    -1,   171,
    1279,  1198,  1110,  1121,  1131,    -1,    -1,  1201,  1199,   171,
    1076,  1110,    -1,    -1,   171,  1201,  1200,   527,  1076,  1110,
      -1,  1202,    -1,  1201,   567,  1202,    -1,  1285,  1203,  1108,
      -1,  1285,   572,  1285,  1203,  1108,    -1,    -1,   572,   560,
      -1,    -1,  1205,  1204,    -1,   372,    -1,   256,    -1,   201,
      -1,   502,  1207,  1156,    -1,    -1,   480,    -1,    -1,   434,
    1209,  1210,    -1,    93,  1222,    -1,  1218,   477,  1217,  1222,
      -1,  1218,   498,  1217,  1222,    -1,   147,  1217,  1222,    -1,
     480,   461,  1217,  1222,    -1,   332,   477,  1217,  1222,    -1,
    1218,   355,    -1,   354,    -1,    -1,   140,   825,  1211,  1214,
      -1,    -1,   140,    12,  1212,  1214,    -1,  1218,    67,  1219,
    1279,  1217,  1222,    -1,   313,   271,   168,   438,   546,   260,
     142,  1282,    16,   261,   142,  1134,    16,   264,   142,  1132,
      -1,  1215,   250,    -1,   438,   192,    -1,    -1,    34,   147,
    1220,  1221,  1213,  1126,    -1,   887,  1219,  1279,  1217,  1110,
      -1,    68,   503,    -1,   480,   503,    -1,  1216,   139,    -1,
      23,    -1,    82,    -1,   365,    -1,    84,   565,   560,   566,
     541,    -1,    84,   565,   560,   566,   144,    -1,   541,  1126,
      -1,   144,  1126,    -1,  1299,   461,  1222,    -1,   208,   461,
      -1,   303,   461,    -1,  1218,   368,    -1,  1299,   535,  1222,
      -1,   862,  1222,    -1,    66,  1222,    -1,   181,    -1,   181,
     168,  1288,    -1,    85,    92,   818,  1285,    -1,    85,   480,
    1279,    -1,    85,   539,  1279,    -1,   271,   461,    -1,   438,
     461,    -1,    85,   366,   617,    -1,    85,   174,   617,    -1,
     366,   461,  1222,    -1,   174,   461,  1222,    -1,   366,    64,
     617,    -1,   174,    64,   617,    -1,    85,   148,   617,    -1,
     461,    -1,   303,    -1,   250,    -1,   271,    -1,    33,    -1,
      -1,   465,    -1,    -1,  1219,  1285,    -1,    -1,   172,    -1,
     171,    -1,   218,    -1,    -1,   218,  1282,    -1,    -1,   171,
    1134,    -1,    -1,   238,  1282,    -1,   544,  1013,    -1,    -1,
    1226,  1279,  1224,  1228,    -1,    -1,  1226,  1227,  1225,   992,
      -1,   114,    -1,   115,    -1,    -1,   154,    -1,   350,    -1,
      -1,  1267,    -1,  1285,    -1,    -1,   165,   972,  1230,  1231,
      -1,  1231,   567,  1232,    -1,  1232,    -1,    -1,  1310,  1233,
    1234,    -1,   477,   546,   376,   248,    -1,   371,    47,    -1,
     192,    -1,   365,    -1,   250,    -1,   461,    -1,   438,    -1,
     271,    -1,   116,    -1,   401,    -1,    -1,  1155,    -1,    -1,
     400,  1236,  1237,    -1,  1237,   567,  1238,    -1,  1238,    -1,
     438,    -1,   271,    -1,   371,    47,    -1,    -1,   369,  1240,
    1241,    -1,  1215,   250,  1242,    -1,   495,  1282,    -1,    29,
    1013,    -1,   227,  1244,  1013,    -1,    -1,    77,    -1,   371,
      -1,   526,  1285,    -1,    -1,   244,    95,  1247,  1248,    -1,
     244,   480,  1279,   171,   271,    -1,    -1,    -1,    -1,  1253,
    1252,   205,  1284,  1249,  1254,   215,  1250,   480,  1279,  1251,
    1255,  1258,  1261,  1262,  1265,    -1,   171,   271,    -1,    -1,
     245,    -1,    -1,    75,    -1,   256,    -1,    -1,   397,    -1,
     201,    -1,    -1,    67,  1256,    -1,  1256,  1257,    -1,  1257,
      -1,   483,    45,  1267,    -1,   336,   135,    45,  1267,    -1,
     135,    45,  1267,    -1,   145,    45,  1267,    -1,    -1,   241,
    1259,    -1,  1259,  1260,    -1,  1260,    -1,   483,    45,  1267,
      -1,   458,    45,  1267,    -1,    -1,   201,   324,   241,    -1,
      -1,   565,  1263,   566,    -1,   565,   566,    -1,  1263,   567,
    1264,    -1,  1264,    -1,  1276,    -1,   571,  1287,    -1,    -1,
     429,  1192,    -1,  1283,    -1,   308,    -1,   509,   484,    -1,
    1266,  1283,    -1,  1283,    -1,   189,    -1,    35,    -1,   346,
      -1,  1270,    -1,   559,  1271,    -1,   558,  1271,    -1,  1266,
      -1,  1271,    -1,   323,    -1,   157,    -1,   501,    -1,   189,
      -1,    35,    -1,   509,   189,    -1,   509,    35,    -1,    99,
    1266,    -1,   491,  1266,    -1,   488,  1266,    -1,   324,    -1,
     253,    -1,   506,    -1,   106,    -1,   163,    -1,  1276,    -1,
    1273,    -1,  1285,   572,   560,    -1,  1285,   572,  1285,   572,
     560,    -1,  1013,    -1,  1285,    -1,  1277,    -1,  1285,    -1,
    1277,    -1,  1285,   572,  1285,    -1,   572,  1285,   572,  1285,
      -1,  1285,   572,  1285,   572,  1285,    -1,  1285,    -1,  1285,
     572,  1285,   572,  1285,    -1,  1285,   572,  1285,    -1,   572,
    1285,    -1,  1285,    -1,  1285,   572,  1285,    -1,   572,  1285,
      -1,  1285,    -1,   197,    -1,   199,    -1,   484,    -1,   484,
      -1,   484,    -1,  1281,    -1,   375,    -1,  1289,    -1,  1281,
      -1,  1290,    -1,  1285,    -1,  1282,    -1,   237,    -1,  1287,
      -1,  1287,   571,  1287,    -1,    89,  1012,    -1,  1290,    -1,
      20,    -1,    28,    -1,    30,    -1,    46,    -1,    47,    -1,
      56,    -1,    58,    -1,    62,    -1,    69,    -1,    71,    -1,
      80,    -1,   105,    -1,   125,    -1,   136,    -1,   150,    -1,
     165,    -1,   185,    -1,   188,    -1,   191,    -1,   213,    -1,
     228,    -1,   320,    -1,   332,    -1,   334,    -1,   344,    -1,
     347,    -1,   351,    -1,   358,    -1,   361,    -1,   391,    -1,
     394,    -1,   400,    -1,   402,    -1,   409,    -1,   416,    -1,
     420,    -1,   427,    -1,   436,    -1,   441,    -1,   438,    -1,
     442,    -1,   460,    -1,   464,    -1,   502,    -1,   513,    -1,
     514,    -1,   548,    -1,   551,    -1,   522,    -1,     5,    -1,
       7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,
      17,    -1,    22,    -1,    23,    -1,    25,    -1,    24,    -1,
      26,    -1,    27,    -1,    34,    -1,    38,    -1,    42,    -1,
      41,    -1,    44,    -1,    50,    -1,    53,    -1,    55,    -1,
      60,    -1,    61,    -1,    63,    -1,    64,    -1,    66,    -1,
      67,    -1,    70,    -1,    72,    -1,    73,    -1,    74,    -1,
      75,    -1,    78,    -1,    82,    -1,    87,    -1,    95,    -1,
      94,    -1,    96,    -1,    99,    -1,   104,    -1,   110,    -1,
     112,    -1,   116,    -1,   118,    -1,   119,    -1,   120,    -1,
     121,    -1,   128,    -1,   129,    -1,   130,    -1,   137,    -1,
     141,    -1,   140,    -1,   139,    -1,   144,    -1,   146,    -1,
     148,    -1,   147,    -1,   149,    -1,   153,    -1,   154,    -1,
     155,    -1,   158,    -1,   169,    -1,   134,    -1,   172,    -1,
     160,    -1,   161,    -1,   162,    -1,   170,    -1,   177,    -1,
     176,    -1,   178,    -1,   181,    -1,   179,    -1,   186,    -1,
     192,    -1,   196,    -1,   198,    -1,   217,    -1,   202,    -1,
     203,    -1,   206,    -1,   220,    -1,   221,    -1,   208,    -1,
     212,    -1,   225,    -1,   229,    -1,   232,    -1,   235,    -1,
     236,    -1,   242,    -1,   243,    -1,   245,    -1,   247,    -1,
     249,    -1,   250,    -1,   276,    -1,   271,    -1,   259,    -1,
     263,    -1,   260,    -1,   261,    -1,   272,    -1,   262,    -1,
     264,    -1,   258,    -1,   270,    -1,   266,    -1,   265,    -1,
     267,    -1,   268,    -1,   269,    -1,   274,    -1,   275,    -1,
     277,    -1,   279,    -1,   280,    -1,   281,    -1,   285,    -1,
     286,    -1,   287,    -1,   288,    -1,   289,    -1,   292,    -1,
     293,    -1,   297,    -1,   295,    -1,   299,    -1,   300,    -1,
     301,    -1,   302,    -1,   303,    -1,   305,    -1,   304,    -1,
     306,    -1,   309,    -1,   310,    -1,   314,    -1,   313,    -1,
     321,    -1,   315,    -1,   316,    -1,   326,    -1,   327,    -1,
     328,    -1,   330,    -1,   331,    -1,   345,    -1,   348,    -1,
     349,    -1,   350,    -1,   352,    -1,   353,    -1,   355,    -1,
     354,    -1,   356,    -1,   357,    -1,   362,    -1,   363,    -1,
     365,    -1,   367,    -1,   368,    -1,   370,    -1,   371,    -1,
     372,    -1,   379,    -1,   380,    -1,   382,    -1,   381,    -1,
     383,    -1,   386,    -1,   387,    -1,   388,    -1,   390,    -1,
     393,    -1,   395,    -1,   398,    -1,   401,    -1,   404,    -1,
     405,    -1,   410,    -1,   411,    -1,   412,    -1,   413,    -1,
     414,    -1,   415,    -1,   417,    -1,   419,    -1,   425,    -1,
     424,    -1,   426,    -1,   437,    -1,   431,    -1,   435,    -1,
     440,    -1,   443,    -1,   451,    -1,   450,    -1,   453,    -1,
     456,    -1,   459,    -1,   461,    -1,   465,    -1,   467,    -1,
     468,    -1,   469,    -1,   471,    -1,   470,    -1,   474,    -1,
     475,    -1,   477,    -1,   478,    -1,   481,    -1,   482,    -1,
     485,    -1,   486,    -1,   497,    -1,   498,    -1,   488,    -1,
     489,    -1,   490,    -1,   491,    -1,   503,    -1,   504,    -1,
     505,    -1,   174,    -1,   507,    -1,   508,    -1,   511,    -1,
     510,    -1,   517,    -1,   520,    -1,   524,    -1,   525,    -1,
     535,    -1,   539,    -1,   532,    -1,   541,    -1,   540,    -1,
     542,    -1,   547,    -1,   550,    -1,   554,    -1,    -1,   429,
    1293,  1292,  1294,    -1,    -1,   335,    -1,  1295,    -1,  1294,
     567,  1295,    -1,    -1,  1296,  1301,    -1,  1298,    -1,   179,
      -1,   245,    -1,   426,    -1,    -1,   330,    -1,    -1,   179,
      -1,   245,    -1,   426,    -1,    -1,   179,   572,    -1,   245,
     572,    -1,   426,   572,    -1,  1302,    -1,  1298,  1303,    -1,
    1297,  1304,  1178,  1307,    -1,  1297,   497,   220,   236,  1305,
      -1,   571,  1287,  1178,  1013,    -1,   571,   571,  1300,  1304,
    1178,  1307,    -1,   862,   866,    -1,   304,  1178,  1013,    -1,
     304,   864,   868,    -1,   352,  1178,  1306,    -1,   352,   168,
    1288,  1178,  1306,    -1,  1285,    -1,  1285,   572,  1285,    -1,
     109,   572,  1285,    -1,   376,   507,    -1,   376,    70,    -1,
     395,   376,    -1,   424,    -1,   484,    -1,   352,   565,   484,
     566,    -1,   328,   565,   484,   566,    -1,  1013,    -1,   109,
      -1,   329,    -1,    12,    -1,    33,    -1,    -1,   248,  1310,
    1309,  1311,    -1,   480,    -1,   477,    -1,  1312,    -1,  1311,
     567,  1312,    -1,  1279,  1108,  1313,    -1,   376,    -1,   549,
      -1,   256,   549,    -1,   376,   245,    -1,    -1,   518,  1315,
    1310,    -1,   185,  1279,   332,  1108,    -1,   185,  1280,    62,
      -1,    -1,   185,  1280,   376,  1317,  1318,  1110,  1127,    -1,
    1319,    -1,  1285,  1320,    -1,   161,    -1,   314,    -1,   161,
      -1,   314,    -1,   363,    -1,   229,    -1,    -1,  1322,  1321,
     565,  1183,   566,    -1,   142,    -1,   175,    -1,   230,    -1,
     184,    -1,   257,    -1,   407,   616,  1324,    -1,  1328,   329,
    1327,  1339,   171,  1341,    -1,  1328,   329,   174,  1339,   171,
    1341,    -1,  1328,   329,   366,  1339,   171,  1341,    -1,    12,
    1329,   567,   180,   335,   171,  1341,    -1,   180,   616,  1326,
      -1,  1328,   329,  1327,  1339,   495,  1341,  1346,  1347,    -1,
    1328,   329,   174,  1339,   495,  1341,  1346,  1347,    -1,  1328,
     329,   366,  1339,   495,  1341,  1346,  1347,    -1,    -1,   480,
      -1,  1330,    -1,    12,  1329,    -1,    -1,   365,    -1,  1331,
      -1,  1330,   567,  1331,    -1,    -1,   421,  1332,  1343,    -1,
      -1,   211,  1333,  1343,    -1,    -1,   521,  1334,  1343,    -1,
      -1,   384,  1335,  1343,    -1,   113,    -1,   523,    -1,   204,
      -1,    13,    -1,    85,    -1,   126,    -1,   150,    -1,   390,
      -1,   435,    -1,   367,    -1,   160,    -1,   180,   335,    -1,
     434,    93,    -1,   474,    -1,    85,   481,   477,    -1,   248,
     477,    -1,   398,   438,    -1,   398,    61,    -1,    85,   539,
      -1,   434,   539,    -1,    85,   411,    -1,    13,   411,    -1,
      85,   524,    -1,   148,    -1,   499,    -1,    -1,    16,    -1,
    1338,  1336,  1337,    -1,  1338,    -1,   469,   484,    -1,   221,
     484,    -1,    60,   484,    -1,   560,    -1,  1285,   572,   560,
      -1,   560,   572,   560,    -1,  1279,    -1,  1288,    -1,  1340,
     567,  1288,    -1,  1342,    -1,  1341,   567,  1342,    -1,  1288,
     198,    45,   484,    -1,  1288,   198,    45,   352,   484,    -1,
    1288,    -1,    -1,   565,  1344,   566,    -1,  1344,   567,  1345,
      -1,  1345,    -1,  1285,    -1,    -1,   399,  1337,    -1,   399,
     457,    -1,   399,   550,    -1,   399,   316,    -1,    -1,   546,
    1348,    -1,  1348,  1349,    -1,  1349,    -1,   180,   335,    -1,
     275,  1132,    -1,   279,  1132,    -1,   274,  1132,    -1,   280,
    1132,    -1,    -1,    30,  1351,  1352,    -1,    -1,   547,    -1,
      -1,    16,   320,    53,    -1,    16,    53,    -1,    -1,   389,
      -1,   320,   389,    -1,    -1,   416,    -1,    71,  1352,  1353,
    1354,    -1,   409,  1352,  1353,  1354,    -1,   409,  1352,   495,
    1355,  1285,    -1,   416,  1285,    -1,   389,   416,  1285,    -1,
      -1,  1361,    -1,    -1,   515,  1367,  1362,   993,    -1,    -1,
    1361,    -1,  1364,    -1,    -1,  1365,  1366,    -1,  1122,  1126,
      -1,  1128,    -1,    -1,   122,    -1,    12,    -1,   421,  1371,
    1370,  1372,    -1,    -1,   565,  1371,  1368,   566,  1369,  1360,
    1372,    -1,   995,    -1,    -1,    -1,  1375,  1374,    -1,  1376,
    1375,  1381,    -1,  1381,    -1,  1389,    -1,  1391,    -1,   603,
      -1,    -1,   110,   142,  1288,    -1,  1377,    -1,  1377,  1378,
      -1,  1378,    -1,   340,   397,    -1,    11,   142,   508,    -1,
      11,   142,   287,    -1,    11,   142,   482,    -1,    -1,  1378,
      -1,    -1,   455,   420,   110,    -1,   455,   420,   217,    -1,
      -1,  1380,   539,  1279,  1382,  1383,    18,  1385,  1388,    -1,
      -1,   565,  1384,   566,    -1,  1285,    -1,  1384,   567,  1285,
      -1,    -1,  1386,  1387,    -1,   421,  1008,   995,    -1,   565,
    1008,   994,   566,  1363,    -1,    -1,   546,    59,   335,    -1,
     546,    50,    59,   335,    -1,   546,   245,    59,   335,    -1,
      -1,   499,  1008,   617,   702,   703,   329,  1008,  1279,   168,
    1008,   131,   414,  1390,   657,    -1,    -1,   829,  1008,   174,
     617,  1392,   618,    -1,    -1,    -1,    -1,    -1,   366,  1008,
     617,  1393,   565,  1394,   638,   566,  1395,   625,  1396,   657,
      -1,   551,  1399,  1398,  1400,    -1,   551,   136,  1398,  1402,
      -1,   551,   361,  1398,    -1,   551,    71,  1398,  1401,    -1,
     551,   409,  1398,    -1,   551,   380,    -1,  1267,    -1,  1267,
     567,  1267,    -1,  1267,   567,  1267,   567,  1132,    -1,    30,
      -1,   460,    -1,    -1,   223,    -1,   404,    -1,    -1,   331,
     353,    -1,    -1,    -1,   475,  1403,  1404,    -1,    -1,   168,
     289,    -1,   213,   355,  1285,   442,  1282,    -1,   514,   355,
    1285,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1146,  1146,  1160,  1163,  1164,  1169,  1170,  1171,  1172,
    1173,  1174,  1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,
    1183,  1184,  1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,
    1193,  1194,  1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,
    1203,  1204,  1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,
    1213,  1214,  1215,  1216,  1217,  1218,  1219,  1223,  1237,  1238,
    1243,  1257,  1264,  1274,  1273,  1289,  1291,  1295,  1296,  1299,
    1312,  1311,  1330,  1329,  1340,  1341,  1344,  1349,  1354,  1359,
    1364,  1368,  1373,  1377,  1381,  1385,  1389,  1394,  1398,  1402,
    1418,  1422,  1434,  1433,  1460,  1458,  1485,  1484,  1497,  1496,
    1504,  1508,  1512,  1516,  1522,  1531,  1532,  1536,  1541,  1546,
    1551,  1556,  1561,  1566,  1578,  1573,  1620,  1619,  1626,  1632,
    1633,  1638,  1646,  1649,  1655,  1656,  1662,  1663,  1667,  1673,
    1681,  1682,  1690,  1690,  1748,  1749,  1750,  1751,  1752,  1753,
    1754,  1755,  1756,  1757,  1758,  1764,  1778,  1793,  1811,  1838,
    1875,  1881,  1889,  1912,  1837,  1976,  1977,  1981,  1982,  1987,
    1989,  1991,  1993,  1995,  1997,  1999,  2005,  2006,  2007,  2011,
    2015,  2023,  2022,  2035,  2037,  2040,  2042,  2046,  2050,  2057,
    2059,  2063,  2064,  2069,  2088,  2114,  2116,  2120,  2121,  2125,
    2151,  2152,  2153,  2154,  2158,  2159,  2163,  2164,  2169,  2172,
    2199,  2198,  2254,  2269,  2268,  2308,  2332,  2332,  2366,  2367,
    2372,  2393,  2417,  2423,  2438,  2439,  2443,  2447,  2456,  2461,
    2466,  2474,  2489,  2507,  2508,  2512,  2513,  2514,  2515,  2516,
    2517,  2518,  2519,  2520,  2521,  2522,  2526,  2526,  2532,  2532,
    2581,  2580,  2606,  2606,  2620,  2652,  2683,  2702,  2701,  2721,
    2738,  2740,  2741,  2745,  2766,  2789,  2791,  2805,  2789,  2823,
    2825,  2826,  2830,  2831,  2836,  2842,  2835,  2861,  2860,  2876,
    2877,  2881,  2882,  2887,  2891,  2886,  2908,  2912,  2907,  2927,
    2935,  2940,  2939,  2977,  2978,  2983,  2982,  3009,  3020,  3022,
    3019,  3046,  3045,  3063,  3065,  3070,  3072,  3074,  3091,  3096,
    3102,  3109,  3110,  3117,  3124,  3132,  3138,  3144,  3145,  3149,
    3149,  3154,  3155,  3156,  3160,  3161,  3162,  3166,  3166,  3171,
    3172,  3173,  3177,  3178,  3179,  3180,  3181,  3182,  3183,  3184,
    3188,  3188,  3193,  3194,  3195,  3199,  3200,  3201,  3202,  3203,
    3207,  3207,  3212,  3213,  3214,  3218,  3219,  3220,  3221,  3222,
    3223,  3224,  3228,  3228,  3233,  3234,  3235,  3239,  3240,  3241,
    3246,  3253,  3260,  3267,  3276,  3285,  3290,  3295,  3302,  3309,
    3316,  3323,  3330,  3337,  3344,  3356,  3368,  3380,  3382,  3386,
    3391,  3403,  3404,  3455,  3457,  3456,  3459,  3471,  3487,  3486,
    3489,  3491,  3489,  3495,  3497,  3496,  3499,  3498,  3527,  3528,
    3533,  3532,  3558,  3557,  3574,  3574,  3574,  3578,  3585,  3584,
    3588,  3587,  3591,  3590,  3596,  3597,  3602,  3603,  3607,  3608,
    3612,  3623,  3635,  3648,  3649,  3665,  3667,  3666,  3671,  3669,
    3680,  3681,  3685,  3696,  3712,  3713,  3729,  3730,  3753,  3754,
    3759,  3776,  3777,  3778,  3758,  3783,  3794,  3814,  3829,  3847,
    3859,  3875,  3876,  3880,  3890,  3891,  3895,  3912,  3973,  3981,
    4008,  4009,  4014,  4013,  4034,  4039,  4040,  4044,  4045,  4049,
    4051,  4057,  4059,  4061,  4063,  4065,  4067,  4077,  4093,  4076,
    4107,  4108,  4111,  4112,  4115,  4116,  4119,  4120,  4123,  4124,
    4127,  4128,  4131,  4134,  4135,  4137,  4139,  4142,  4143,  4146,
    4147,  4148,  4151,  4152,  4159,  4160,  4161,  4162,  4163,  4164,
    4165,  4180,  4186,  4187,  4188,  4189,  4204,  4205,  4206,  4207,
    4208,  4209,  4210,  4211,  4212,  4213,  4221,  4238,  4254,  4272,
    4273,  4274,  4275,  4276,  4277,  4280,  4281,  4282,  4285,  4286,
    4289,  4290,  4293,  4294,  4295,  4296,  4299,  4300,  4304,  4305,
    4309,  4310,  4317,  4329,  4338,  4355,  4359,  4365,  4367,  4371,
    4375,  4376,  4380,  4385,  4384,  4406,  4407,  4408,  4409,  4411,
    4413,  4415,  4417,  4419,  4421,  4424,  4427,  4430,  4433,  4435,
    4438,  4441,  4442,  4443,  4444,  4457,  4458,  4460,  4462,  4474,
    4476,  4478,  4480,  4481,  4482,  4483,  4484,  4485,  4487,  4489,
    4491,  4491,  4493,  4493,  4495,  4496,  4505,  4506,  4507,  4510,
    4511,  4512,  4513,  4514,  4518,  4522,  4523,  4527,  4528,  4532,
    4533,  4534,  4535,  4536,  4540,  4541,  4542,  4543,  4544,  4547,
    4549,  4550,  4554,  4555,  4556,  4559,  4566,  4567,  4570,  4571,
    4574,  4575,  4576,  4579,  4580,  4583,  4584,  4587,  4588,  4591,
    4592,  4595,  4596,  4597,  4598,  4600,  4601,  4607,  4613,  4619,
    4625,  4626,  4642,  4643,  4647,  4648,  4652,  4660,  4664,  4665,
    4669,  4678,  4682,  4683,  4686,  4696,  4697,  4701,  4702,  4705,
    4706,  4709,  4710,  4711,  4712,  4721,  4722,  4725,  4726,  4729,
    4730,  4731,  4740,  4742,  4744,  4749,  4748,  4760,  4761,  4764,
    4765,  4769,  4770,  4773,  4774,  4777,  4778,  4779,  4780,  4781,
    4784,  4785,  4786,  4787,  4788,  4791,  4792,  4793,  4805,  4806,
    4809,  4810,  4813,  4814,  4818,  4819,  4820,  4823,  4824,  4825,
    4826,  4839,  4851,  4852,  4856,  4857,  4861,  4862,  4866,  4867,
    4871,  4872,  4874,  4888,  4889,  4893,  4896,  4897,  4900,  4901,
    4912,  4913,  4916,  4917,  4920,  4921,  4929,  4928,  4958,  4957,
    4973,  4972,  4991,  4990,  5010,  5008,  5025,  5020,  5073,  5078,
    5083,  5088,  5093,  5102,  5103,  5104,  5105,  5108,  5109,  5120,
    5121,  5125,  5126,  5128,  5129,  5130,  5131,  5133,  5135,  5136,
    5145,  5146,  5150,  5159,  5157,  5168,  5166,  5176,  5175,  5184,
    5182,  5191,  5198,  5202,  5209,  5213,  5218,  5217,  5233,  5234,
    5239,  5248,  5247,  5263,  5268,  5267,  5279,  5280,  5284,  5299,
    5300,  5304,  5312,  5313,  5317,  5322,  5321,  5329,  5338,  5328,
    5350,  5357,  5361,  5368,  5375,  5381,  5387,  5393,  5400,  5420,
    5441,  5446,  5450,  5457,  5458,  5461,  5462,  5466,  5467,  5468,
    5472,  5473,  5474,  5477,  5478,  5479,  5480,  5488,  5487,  5498,
    5506,  5505,  5515,  5525,  5534,  5535,  5542,  5542,  5548,  5549,
    5553,  5554,  5555,  5559,  5560,  5577,  5578,  5583,  5582,  5595,
    5594,  5607,  5606,  5616,  5617,  5618,  5623,  5622,  5634,  5635,
    5638,  5639,  5642,  5643,  5644,  5648,  5647,  5659,  5668,  5667,
    5684,  5685,  5688,  5689,  5692,  5693,  5694,  5695,  5696,  5697,
    5701,  5700,  5712,  5713,  5714,  5719,  5718,  5725,  5724,  5731,
    5738,  5743,  5751,  5752,  5755,  5767,  5778,  5787,  5788,  5791,
    5804,  5805,  5810,  5809,  5819,  5820,  5823,  5836,  5836,  5846,
    5847,  5856,  5857,  5866,  5875,  5877,  5880,  5902,  5906,  5905,
    5925,  5933,  5925,  5939,  5940,  5941,  5942,  5943,  5946,  5948,
    5955,  5957,  5968,  5969,  5972,  5973,  5979,  5980,  5981,  5982,
    5988,  5994,  6000,  6010,  6013,  6015,  6021,  6031,  6032,  6033,
    6046,  6064,  6067,  6070,  6071,  6074,  6075,  6076,  6077,  6078,
    6082,  6083,  6087,  6087,  6104,  6106,  6111,  6112,  6112,  6129,
    6131,  6136,  6137,  6140,  6141,  6142,  6143,  6144,  6145,  6146,
    6149,  6150,  6151,  6152,  6154,  6156,  6159,  6161,  6163,  6167,
    6173,  6177,  6185,  6187,  6193,  6196,  6198,  6200,  6201,  6203,
    6206,  6207,  6210,  6211,  6214,  6216,  6218,  6221,  6222,  6223,
    6225,  6227,  6230,  6231,  6232,  6233,  6234,  6235,  6238,  6239,
    6241,  6241,  6242,  6242,  6243,  6243,  6244,  6244,  6246,  6247,
    6248,  6249,  6250,  6251,  6254,  6255,  6259,  6263,  6264,  6265,
    6266,  6267,  6268,  6276,  6277,  6278,  6279,  6280,  6282,  6283,
    6285,  6287,  6289,  6293,  6294,  6299,  6304,  6308,  6309,  6316,
    6321,  6331,  6333,  6342,  6344,  6356,  6359,  6362,  6380,  6382,
    6384,  6389,  6391,  6393,  6395,  6397,  6399,  6401,  6403,  6405,
    6407,  6409,  6411,  6413,  6415,  6417,  6419,  6421,  6423,  6425,
    6427,  6429,  6434,  6451,  6456,  6458,  6463,  6468,  6473,  6475,
    6477,  6479,  6481,  6486,  6491,  6493,  6498,  6500,  6502,  6504,
    6506,  6508,  6516,  6524,  6526,  6528,  6533,  6538,  6551,  6553,
    6555,  6557,  6559,  6564,  6566,  6568,  6570,  6572,  6582,  6584,
    6586,  6588,  6590,  6599,  6601,  6614,  6620,  6627,  6634,  6641,
    6648,  6655,  6657,  6677,  6676,  6746,  6778,  6780,  6785,  6786,
    6790,  6791,  6795,  6796,  6800,  6800,  6806,  6810,  6817,  6837,
    6839,  6841,  6843,  6845,  6847,  6849,  6852,  6854,  6851,  6857,
    6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,  6880,  6883,
    6882,  6897,  6896,  6911,  6917,  6923,  6936,  6937,  6940,  6941,
    6946,  6949,  6961,  6960,  6976,  6977,  6978,  6979,  6980,  6981,
    6982,  6983,  6984,  6985,  6986,  6990,  6991,  6995,  6995,  7000,
    7001,  7004,  7005,  7008,  7008,  7013,  7014,  7017,  7018,  7021,
    7022,  7025,  7031,  7041,  7042,  7051,  7056,  7057,  7077,  7079,
    7083,  7081,  7098,  7096,  7114,  7112,  7120,  7129,  7127,  7145,
    7144,  7151,  7162,  7160,  7179,  7178,  7190,  7200,  7201,  7202,
    7207,  7207,  7226,  7224,  7243,  7265,  7313,  7312,  7335,  7351,
    7335,  7358,  7362,  7388,  7389,  7392,  7393,  7399,  7406,  7414,
    7414,  7420,  7421,  7425,  7429,  7433,  7439,  7447,  7456,  7457,
    7458,  7459,  7460,  7461,  7462,  7463,  7464,  7465,  7466,  7467,
    7468,  7471,  7472,  7473,  7474,  7475,  7476,  7477,  7478,  7479,
    7483,  7484,  7485,  7486,  7489,  7491,  7492,  7495,  7496,  7499,
    7501,  7505,  7507,  7506,  7520,  7523,  7522,  7537,  7543,  7556,
    7558,  7561,  7563,  7567,  7568,  7581,  7599,  7603,  7604,  7608,
    7621,  7623,  7627,  7626,  7658,  7660,  7664,  7665,  7666,  7671,
    7677,  7681,  7682,  7686,  7690,  7697,  7704,  7713,  7714,  7715,
    7716,  7721,  7725,  7733,  7734,  7735,  7736,  7737,  7738,  7742,
    7743,  7744,  7745,  7746,  7750,  7751,  7752,  7753,  7754,  7758,
    7759,  7760,  7761,  7765,  7770,  7771,  7774,  7777,  7776,  7805,
    7806,  7809,  7810,  7813,  7826,  7826,  7836,  7837,  7841,  7853,
    7886,  7885,  7898,  7897,  7906,  7918,  7929,  7928,  7945,  7952,
    7952,  7963,  7970,  7982,  7994,  7998,  8004,  8010,  8017,  8022,
    8027,  8037,  8038,  8041,  8049,  8050,  8054,  8055,  8063,  8072,
    8062,  8082,  8089,  8081,  8099,  8111,  8112,  8113,  8117,  8118,
    8121,  8122,  8125,  8134,  8135,  8136,  8138,  8137,  8147,  8148,
    8151,  8152,  8153,  8153,  8154,  8154,  8158,  8159,  8162,  8164,
    8167,  8175,  8176,  8180,  8181,  8186,  8185,  8198,  8199,  8202,
    8207,  8215,  8216,  8219,  8221,  8221,  8229,  8238,  8228,  8260,
    8261,  8264,  8271,  8272,  8275,  8284,  8285,  8291,  8290,  8304,
    8303,  8312,  8311,  8319,  8318,  8328,  8329,  8332,  8339,  8352,
    8353,  8357,  8358,  8361,  8362,  8363,  8366,  8376,  8378,  8383,
    8382,  8396,  8403,  8411,  8419,  8427,  8435,  8443,  8451,  8459,
    8458,  8462,  8461,  8464,  8473,  8483,  8487,  8492,  8491,  8496,
    8505,  8510,  8516,  8523,  8528,  8533,  8538,  8540,  8542,  8544,
    8546,  8554,  8566,  8578,  8580,  8588,  8595,  8602,  8612,  8619,
    8625,  8634,  8642,  8646,  8650,  8657,  8664,  8673,  8682,  8692,
    8702,  8710,  8712,  8714,  8718,  8719,  8721,  8723,  8726,  8727,
    8730,  8731,  8734,  8735,  8738,  8739,  8742,  8743,  8745,  8747,
    8750,  8762,  8761,  8775,  8774,  8784,  8785,  8788,  8789,  8790,
    8795,  8796,  8797,  8805,  8804,  8816,  8817,  8820,  8820,  8821,
    8822,  8823,  8824,  8825,  8826,  8827,  8828,  8829,  8830,  8833,
    8834,  8838,  8837,  8846,  8847,  8850,  8851,  8852,  8856,  8855,
    8864,  8868,  8873,  8885,  8894,  8895,  8896,  8901,  8911,  8910,
    8923,  8940,  8951,  8956,  8939,  8969,  8978,  8979,  8982,  8983,
    8995,  8999,  9000,  9001,  9003,  9005,  9008,  9009,  9012,  9017,
    9024,  9029,  9035,  9037,  9040,  9041,  9044,  9049,  9055,  9057,
    9064,  9065,  9066,  9069,  9071,  9076,  9077,  9082,  9083,  9089,
    9094,  9096,  9098,  9103,  9105,  9116,  9129,  9149,  9150,  9151,
    9160,  9161,  9162,  9164,  9165,  9166,  9167,  9168,  9182,  9196,
    9197,  9198,  9201,  9202,  9203,  9204,  9212,  9227,  9228,  9231,
    9237,  9248,  9251,  9285,  9289,  9297,  9301,  9369,  9384,  9408,
    9409,  9425,  9435,  9438,  9439,  9440,  9444,  9448,  9449,  9474,
    9486,  9499,  9511,  9512,  9518,  9527,  9528,  9537,  9538,  9539,
    9542,  9555,  9568,  9582,  9583,  9584,  9585,  9586,  9587,  9588,
    9589,  9590,  9591,  9592,  9593,  9594,  9595,  9596,  9597,  9598,
    9599,  9600,  9601,  9602,  9603,  9604,  9605,  9606,  9607,  9608,
    9609,  9610,  9611,  9612,  9613,  9614,  9615,  9616,  9617,  9618,
    9619,  9620,  9621,  9622,  9623,  9624,  9625,  9626,  9627,  9628,
    9629,  9630,  9631,  9641,  9642,  9643,  9644,  9645,  9646,  9647,
    9648,  9649,  9650,  9651,  9652,  9653,  9654,  9655,  9656,  9657,
    9658,  9659,  9660,  9661,  9662,  9663,  9664,  9665,  9666,  9667,
    9668,  9669,  9670,  9671,  9672,  9673,  9674,  9675,  9676,  9677,
    9678,  9679,  9680,  9681,  9682,  9683,  9684,  9685,  9686,  9687,
    9688,  9689,  9690,  9691,  9692,  9693,  9694,  9695,  9696,  9697,
    9698,  9699,  9700,  9701,  9702,  9703,  9704,  9705,  9706,  9707,
    9708,  9709,  9710,  9711,  9712,  9713,  9714,  9715,  9716,  9717,
    9718,  9719,  9720,  9721,  9722,  9723,  9724,  9725,  9726,  9727,
    9728,  9729,  9730,  9731,  9732,  9733,  9734,  9735,  9736,  9737,
    9738,  9739,  9740,  9741,  9742,  9743,  9744,  9745,  9746,  9747,
    9748,  9749,  9750,  9751,  9752,  9753,  9754,  9755,  9756,  9757,
    9758,  9759,  9760,  9761,  9762,  9763,  9764,  9765,  9766,  9767,
    9768,  9769,  9770,  9771,  9772,  9773,  9774,  9775,  9776,  9777,
    9778,  9779,  9780,  9781,  9782,  9783,  9784,  9785,  9786,  9787,
    9788,  9789,  9790,  9791,  9792,  9793,  9794,  9795,  9796,  9797,
    9798,  9799,  9800,  9801,  9802,  9803,  9804,  9805,  9806,  9807,
    9808,  9809,  9810,  9811,  9812,  9813,  9814,  9815,  9816,  9817,
    9818,  9819,  9820,  9821,  9822,  9823,  9824,  9825,  9826,  9827,
    9828,  9829,  9830,  9831,  9832,  9833,  9834,  9835,  9836,  9837,
    9838,  9839,  9840,  9841,  9842,  9843,  9844,  9845,  9846,  9847,
    9848,  9849,  9850,  9851,  9852,  9853,  9854,  9855,  9856,  9857,
    9858,  9859,  9860,  9861,  9862,  9863,  9864,  9865,  9866,  9867,
    9868,  9869,  9870,  9871,  9872,  9873,  9874,  9875,  9876,  9877,
    9878,  9879,  9880,  9881,  9882,  9883,  9884,  9885,  9892,  9891,
    9905,  9906,  9909,  9910,  9913,  9913,  9985,  9986,  9987,  9988,
    9992,  9993,  9997,  9998,  9999, 10000, 10004, 10005, 10006, 10007,
   10011, 10012, 10015, 10095, 10107, 10111, 10116, 10123, 10138, 10151,
   10172, 10179, 10217, 10260, 10274, 10275, 10276, 10277, 10281, 10282,
   10289, 10298, 10299, 10300, 10301, 10302, 10310, 10309, 10325, 10326,
   10329, 10330, 10333, 10341, 10342, 10343, 10344, 10349, 10348, 10369,
   10381, 10394, 10393, 10416, 10417, 10421, 10422, 10426, 10427, 10428,
   10429, 10431, 10430, 10441, 10442, 10443, 10444, 10445, 10451, 10456,
   10463, 10476, 10488, 10495, 10500, 10508, 10521, 10535, 10537, 10540,
   10541, 10548, 10550, 10554, 10555, 10558, 10558, 10559, 10559, 10560,
   10560, 10561, 10561, 10562, 10563, 10564, 10565, 10566, 10567, 10568,
   10569, 10570, 10571, 10572, 10573, 10574, 10575, 10576, 10577, 10578,
   10579, 10580, 10581, 10582, 10583, 10584, 10585, 10586, 10591, 10592,
   10596, 10597, 10601, 10611, 10621, 10634, 10650, 10663, 10676, 10688,
   10689, 10698, 10699, 10708, 10733, 10735, 10742, 10746, 10749, 10750,
   10753, 10774, 10775, 10779, 10783, 10787, 10794, 10795, 10798, 10799,
   10803, 10804, 10810, 10816, 10822, 10832, 10831, 10841, 10842, 10846,
   10847, 10848, 10852, 10853, 10854, 10858, 10859, 10863, 10873, 10880,
   10890, 10899, 10913, 10914, 10919, 10918, 10953, 10954, 10955, 10959,
   10959, 10983, 10984, 10988, 10989, 10990, 10994, 10999, 10998, 11019,
   11025, 11044, 11060, 11062, 11067, 11069, 11071, 11073, 11085, 11095,
   11108, 11110, 11112, 11117, 11122, 11124, 11126, 11132, 11133, 11139,
   11140, 11142, 11148, 11147, 11162, 11163, 11167, 11172, 11180, 11180,
   11198, 11207, 11220, 11221, 11223, 11225, 11238, 11236, 11310, 11309,
   11319, 11348, 11355, 11362, 11318, 11387, 11391, 11395, 11399, 11403,
   11407, 11413, 11420, 11427, 11436, 11437, 11441, 11442, 11443, 11447,
   11448, 11452, 11453, 11453, 11458, 11459, 11463, 11472
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH",
  "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE",
  "CASCADED", "CASE_SYM", "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED",
  "CHARSET", "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM", "COLLATE_SYM",
  "COLLATION_SYM", "COLUMNS", "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONTAINS_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CREATE", "CROSS", "CUBE_SYM", "CURDATE",
  "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE", "DATABASES",
  "DATAFILE_SYM", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM",
  "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE",
  "DES_KEY_FILE", "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM",
  "DISCARD", "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM",
  "DROP", "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM",
  "EACH_SYM", "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END",
  "ENDS_SYM", "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ",
  "EQUAL_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM",
  "EXPANSION_SYM", "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM",
  "FOREIGN", "FOR_SYM", "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING",
  "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM",
  "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM",
  "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM",
  "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM",
  "INVOKER_SYM", "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM",
  "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM",
  "LANGUAGE_SYM", "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM",
  "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM", "MICROSECOND_SYM",
  "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM",
  "MINUTE_SYM", "MIN_ROWS", "MIN_SYM", "MODE_SYM", "MODIFIES_SYM",
  "MODIFY_SYM", "MOD_SYM", "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT",
  "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM",
  "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE",
  "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM",
  "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM",
  "PACK_KEYS_SYM", "PARAM_MARKER", "PARSER_SYM", "PARTIAL",
  "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD",
  "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON",
  "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM",
  "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR",
  "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM",
  "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SECOND_MICROSECOND_SYM",
  "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM",
  "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM",
  "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM",
  "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SONAME_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SYSDATE", "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "THAN_SYM", "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF",
  "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES", "VALUE_SYM", "VARBINARY",
  "VARCHAR", "VARIABLES", "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM",
  "VIEW_SYM", "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM",
  "XA_SYM", "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'",
  "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','",
  "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'", "$accept", "query",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "@1", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "@2", "change", "@3",
  "master_defs", "master_def", "master_file_def", "create", "@4", "@5",
  "@6", "@7", "server_def", "server_options_list", "server_option",
  "event_tail", "@8", "ev_schedule_time", "@9", "opt_ev_status",
  "ev_starts", "ev_ends", "opt_ev_on_completion", "ev_on_completion",
  "opt_ev_comment", "ev_sql_stmt", "@10", "ev_sql_stmt_inner",
  "clear_privileges", "sp_name", "create_function_tail", "@11", "@12",
  "@13", "@14", "@15", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "@16", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "@17", "@18", "sp_cursor_stmt", "@19",
  "sp_handler_type", "sp_hcond_list", "sp_cond", "opt_value", "sp_hcond",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "@20", "sp_proc_stmt_statement", "@21", "sp_proc_stmt_return", "@22",
  "sp_proc_stmt_unlabeled", "@23", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch", "@24",
  "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list", "sp_if",
  "@25", "@26", "@27", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "@28", "@29", "searched_case_stmt", "@30",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "@31", "@32", "searched_when_clause", "@33", "@34",
  "else_clause_opt", "sp_labeled_control", "@35", "sp_opt_label",
  "sp_unlabeled_control", "@36", "@37", "@38", "@39", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "@41", "tablespace_options",
  "tablespace_option", "alter_tablespace_option_list", "@42",
  "alter_tablespace_options", "alter_tablespace_option",
  "logfile_group_option_list", "@43", "logfile_group_options",
  "logfile_group_option", "alter_logfile_group_option_list", "@44",
  "alter_logfile_group_options", "alter_logfile_group_option",
  "ts_datafile", "lg_undofile", "lg_redofile", "tablespace_name",
  "logfile_group_name", "ts_access_mode", "opt_ts_initial_size",
  "opt_ts_autoextend_size", "opt_ts_max_size", "opt_ts_extent_size",
  "opt_ts_undo_buffer_size", "opt_ts_redo_buffer_size", "opt_ts_nodegroup",
  "opt_ts_comment", "opt_ts_engine", "opt_ts_wait", "ts_wait",
  "size_number", "create2", "@45", "create2a", "@46", "@47", "@48",
  "create3", "@49", "@50", "opt_partitioning", "partitioning", "@51",
  "partition_entry", "@52", "partition", "@53", "@54", "part_type_def",
  "@55", "@56", "@57", "opt_linear", "part_field_list",
  "part_field_item_list", "part_field_item", "part_func", "sub_part_func",
  "opt_no_parts", "opt_sub_part", "@58", "@59", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_no_subparts", "part_defs",
  "part_def_list", "part_definition", "@60", "@61", "@62", "@63",
  "part_name", "opt_part_values", "part_func_max", "max_value_sym",
  "part_range_func", "part_list_func", "part_list_item", "part_bit_expr",
  "opt_sub_partition", "sub_part_list", "sub_part_definition", "@64",
  "sub_name", "opt_part_options", "opt_part_option_list",
  "opt_part_option", "create_select", "@65", "@66", "opt_as",
  "opt_create_database_options", "create_database_options",
  "create_database_option", "opt_table_options", "table_options",
  "table_option", "opt_if_not_exists", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "default_charset", "default_collation",
  "storage_engines", "row_types", "merge_insert_types", "opt_select_from",
  "udf_func_type", "udf_type", "field_list", "field_list_item",
  "column_def", "key_def", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "@67", "type", "@68",
  "@69", "spatial_type", "char", "nchar", "varchar", "nvarchar",
  "int_type", "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "opt_len", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "opt_binary", "opt_bin_mod",
  "opt_bin_charset", "opt_primary", "references", "@70", "opt_ref_list",
  "ref_list", "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext",
  "init_key_options", "key_alg", "key_options", "key_opts",
  "key_using_alg", "key_opt", "btree_or_rtree", "key_list", "key_part",
  "opt_ident", "opt_component", "string_list", "alter", "@71", "@72",
  "@73", "@74", "@75", "@76", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "@77", "@78", "@79", "@80", "remove_partitioning",
  "all_or_alt_part_name_list", "add_partition_rule", "@81",
  "add_part_extra", "reorg_partition_rule", "@82", "reorg_parts_rule",
  "@83", "alt_part_name_list", "alt_part_name_item", "alter_list",
  "add_column", "alter_list_item", "@84", "@85", "@86", "opt_column",
  "opt_ignore", "opt_restrict", "opt_place", "opt_to", "slave", "@87",
  "@88", "start", "start_transaction_opts", "slave_thread_opts", "@89",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@90", "backup", "@91", "checksum", "@92",
  "opt_checksum_type", "repair", "@93", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@94",
  "binlog_base64_event", "check", "@95", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "@96",
  "opt_no_write_to_binlog", "rename", "@97", "@98", "rename_list",
  "table_to_table_list", "table_to_table", "db_to_db", "keycache",
  "keycache_list", "assign_to_keycache", "key_cache_name", "preload",
  "@99", "preload_list", "preload_keys", "cache_keys_spec", "@100",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_init2", "@101", "select_part2", "@102", "@103",
  "select_into", "select_from", "select_options", "select_option_list",
  "select_option", "select_lock_type", "select_item_list", "select_item",
  "remember_name", "remember_end", "select_item2", "select_alias",
  "optional_braces", "expr", "@104", "bool_or_expr", "bool_term", "@105",
  "bool_and_expr", "bool_factor", "bool_test", "bool_pri", "predicate",
  "bit_expr", "bit_term", "bit_factor", "value_expr", "term", "factor",
  "or", "and", "not", "not2", "comp_op", "all_or_any", "interval_expr",
  "simple_expr", "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "geometry_function", "function_call_generic",
  "@106", "fulltext_options", "opt_natural_language_mode",
  "opt_query_expansion", "udf_expr_list", "udf_expr_list2", "@107",
  "udf_expr_list3", "udf_expr", "sum_expr", "@108", "@109", "@110",
  "variable", "@111", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@112",
  "cast_type", "opt_expr_list", "expr_list", "@113", "expr_list2",
  "ident_list_arg", "ident_list", "@114", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@115", "@116", "@117", "@118",
  "@119", "@120", "@121", "normal_join", "table_factor", "@122", "@123",
  "select_derived", "@124", "select_derived2", "@125", "@126",
  "get_select_lex", "select_derived_init", "opt_outer",
  "opt_key_definition", "key_usage_list", "@127", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@128", "having_clause", "@129", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@130", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_clause", "@131", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@132",
  "select_var_list", "select_var_ident", "into", "@133",
  "into_destination", "@134", "do", "@135", "drop", "@136", "table_list",
  "table_name", "if_exists", "opt_temporary", "insert", "@137", "@138",
  "replace", "@139", "@140", "insert_lock_option", "replace_lock_option",
  "insert2", "insert_table", "insert_field_spec", "@141", "fields",
  "insert_values", "@142", "@143", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "no_braces", "@144",
  "opt_values", "values", "expr_or_default", "opt_insert_update", "@145",
  "update", "@146", "@147", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "@148", "single_multi", "@149", "@150", "@151", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "opt_table_sym", "show", "@152", "show_param", "@153",
  "@154", "@155", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "@156", "@157", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "@158",
  "flush_options", "flush_option", "@159", "opt_table_list", "reset",
  "@160", "reset_options", "reset_option", "purge", "@161",
  "purge_options", "purge_option", "kill", "kill_option", "use", "load",
  "@162", "load_data", "@163", "@164", "@165", "opt_local",
  "load_data_lock", "opt_duplicate", "opt_field_term", "field_term_list",
  "field_term", "opt_line_term", "line_term_list", "line_term",
  "opt_ignore_lines", "opt_field_or_var_spec", "fields_or_vars",
  "field_or_var", "opt_load_data_set_spec", "text_literal", "text_string",
  "param_marker", "signed_literal", "literal", "NUM_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "@166",
  "opt_option", "option_value_list", "option_type_value", "@167",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "@168", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "@169",
  "handler", "@170", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "@171", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "@172", "@173", "@174", "@175", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "@176", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@177", "union_opt",
  "union_order_or_limit", "@178", "order_or_limit", "union_option",
  "subselect", "@179", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp_or_event",
  "view_or_trigger_or_sp_or_event_tail", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@180", "view_list_opt",
  "view_list", "view_select", "@181", "view_select_aux",
  "view_check_option", "trigger_tail", "@182", "sp_tail", "@183", "@184",
  "@185", "@186", "@187", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@188",
  "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   124,    38,    45,    43,
      42,    47,    37,    94,   126,    40,    41,    44,    33,   123,
     125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   575,   576,   576,   577,   577,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   578,   578,   578,   578,   579,   580,   580,
     581,   582,   582,   584,   583,   585,   585,   586,   586,   587,
     589,   588,   591,   590,   592,   592,   593,   593,   593,   593,
     593,   593,   593,   593,   593,   593,   593,   593,   594,   594,
     594,   594,   596,   595,   597,   595,   598,   595,   599,   595,
     595,   595,   595,   595,   600,   601,   601,   602,   602,   602,
     602,   602,   602,   602,   604,   603,   606,   605,   605,   607,
     607,   607,   608,   608,   609,   609,   610,   610,   611,   611,
     612,   612,   614,   613,   615,   615,   615,   615,   615,   615,
     615,   615,   615,   615,   615,   616,   617,   617,   618,   619,
     620,   621,   622,   623,   618,   624,   624,   625,   625,   626,
     626,   626,   626,   626,   626,   626,   627,   627,   627,   628,
     628,   630,   629,   631,   631,   632,   632,   633,   633,   634,
     634,   635,   635,   636,   637,   638,   638,   639,   639,   640,
     641,   641,   641,   641,   642,   642,   643,   643,   644,   644,
     646,   645,   645,   647,   645,   645,   649,   648,   650,   650,
     651,   651,   652,   652,   653,   653,   654,   654,   654,   654,
     654,   655,   655,   656,   656,   657,   657,   657,   657,   657,
     657,   657,   657,   657,   657,   657,   659,   658,   661,   660,
     663,   662,   665,   664,   666,   667,   668,   670,   669,   671,
     672,   672,   672,   673,   673,   675,   676,   677,   674,   678,
     678,   678,   679,   679,   681,   682,   680,   684,   683,   685,
     685,   686,   686,   688,   689,   687,   691,   692,   690,   693,
     693,   695,   694,   696,   696,   698,   697,   697,   699,   700,
     697,   701,   697,   702,   702,   703,   703,   703,   704,   705,
     706,   707,   707,   708,   708,   709,   710,   711,   711,   713,
     712,   714,   714,   714,   715,   715,   715,   717,   716,   718,
     718,   718,   719,   719,   719,   719,   719,   719,   719,   719,
     721,   720,   722,   722,   722,   723,   723,   723,   723,   723,
     725,   724,   726,   726,   726,   727,   727,   727,   727,   727,
     727,   727,   729,   728,   730,   730,   730,   731,   731,   731,
     732,   733,   734,   735,   736,   737,   737,   737,   738,   739,
     740,   741,   742,   743,   744,   745,   746,   747,   747,   748,
     748,   749,   749,   750,   751,   750,   750,   750,   753,   752,
     754,   755,   752,   756,   757,   756,   758,   756,   759,   759,
     761,   760,   763,   762,   765,   766,   764,   767,   768,   767,
     769,   767,   770,   767,   771,   771,   772,   772,   773,   773,
     774,   775,   776,   777,   777,   778,   779,   778,   780,   778,
     781,   781,   782,   783,   784,   784,   785,   785,   786,   786,
     788,   789,   790,   791,   787,   792,   793,   793,   793,   794,
     794,   795,   795,   796,   797,   797,   798,   799,   800,   800,
     801,   801,   803,   802,   804,   805,   805,   806,   806,   807,
     807,   807,   807,   807,   807,   807,   807,   809,   810,   808,
     811,   811,   812,   812,   813,   813,   814,   814,   815,   815,
     816,   816,   817,   818,   818,   819,   819,   820,   820,   821,
     821,   821,   822,   822,   822,   822,   822,   822,   822,   822,
     822,   822,   822,   822,   822,   822,   822,   822,   822,   822,
     822,   822,   822,   822,   822,   822,   823,   824,   825,   826,
     826,   826,   826,   826,   826,   827,   827,   827,   828,   828,
     829,   829,   830,   830,   830,   830,   831,   831,   832,   832,
     833,   833,   834,   834,   834,   834,   834,   835,   835,   836,
     837,   837,   838,   840,   839,   841,   841,   841,   841,   841,
     841,   841,   841,   841,   841,   841,   841,   841,   841,   841,
     841,   841,   841,   841,   841,   841,   841,   841,   841,   841,
     841,   841,   841,   841,   841,   841,   841,   841,   841,   841,
     842,   841,   843,   841,   841,   841,   844,   844,   844,   844,
     844,   844,   844,   844,   845,   846,   846,   847,   847,   848,
     848,   848,   848,   848,   849,   849,   849,   849,   849,   850,
     850,   850,   851,   851,   851,   852,   853,   853,   854,   854,
     855,   855,   855,   856,   856,   857,   857,   858,   858,   859,
     859,   860,   860,   860,   860,   860,   860,   860,   860,   860,
     860,   860,   861,   861,   862,   862,   863,   863,   864,   864,
     865,   865,   866,   866,   867,   868,   868,   869,   869,   870,
     870,   871,   871,   871,   871,   871,   871,   872,   872,   873,
     873,   873,   873,   874,   874,   876,   875,   877,   877,   878,
     878,   879,   879,   880,   880,   881,   881,   881,   881,   881,
     882,   882,   882,   882,   882,   883,   883,   883,   884,   884,
     885,   885,   886,   886,   887,   887,   887,   888,   888,   888,
     888,   889,   890,   890,   891,   891,   892,   892,   893,   893,
     894,   894,   894,   895,   895,   895,   896,   896,   897,   897,
     898,   898,   899,   899,   900,   900,   902,   901,   903,   901,
     904,   901,   905,   901,   906,   901,   907,   901,   901,   901,
     901,   901,   901,   908,   908,   908,   908,   909,   909,   910,
     910,   911,   911,   912,   912,   912,   912,   912,   912,   912,
     912,   912,   912,   913,   912,   914,   912,   915,   912,   916,
     912,   912,   912,   917,   918,   918,   920,   919,   921,   921,
     921,   923,   922,   924,   925,   924,   926,   926,   927,   928,
     928,   929,   930,   930,   930,   931,   930,   932,   933,   930,
     930,   930,   930,   930,   930,   930,   930,   930,   930,   930,
     930,   930,   930,   934,   934,   935,   935,   936,   936,   936,
     937,   937,   937,   938,   938,   938,   938,   940,   939,   939,
     941,   939,   939,   942,   943,   943,   945,   944,   946,   946,
     947,   947,   947,   948,   948,   949,   949,   951,   950,   953,
     952,   955,   954,   956,   956,   956,   958,   957,   959,   959,
     960,   960,   961,   961,   961,   963,   962,   964,   966,   965,
     967,   967,   968,   968,   969,   969,   969,   969,   969,   969,
     971,   970,   972,   972,   972,   974,   973,   975,   973,   973,
     976,   976,   977,   977,   978,   979,   980,   981,   981,   982,
     983,   983,   985,   984,   986,   986,   987,   989,   988,   990,
     990,   991,   991,   992,   993,   993,   994,   994,   996,   995,
     998,   999,   997,  1000,  1000,  1000,  1000,  1000,  1001,  1001,
    1002,  1002,  1003,  1003,  1004,  1004,  1004,  1004,  1004,  1004,
    1004,  1004,  1004,  1004,  1005,  1005,  1005,  1006,  1006,  1006,
    1007,  1008,  1009,  1010,  1010,  1011,  1011,  1011,  1011,  1011,
    1012,  1012,  1014,  1013,  1015,  1015,  1016,  1017,  1016,  1018,
    1018,  1019,  1019,  1020,  1020,  1020,  1020,  1020,  1020,  1020,
    1021,  1021,  1021,  1021,  1021,  1021,  1022,  1022,  1022,  1022,
    1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,
    1023,  1023,  1024,  1024,  1025,  1025,  1025,  1026,  1026,  1026,
    1026,  1026,  1027,  1027,  1027,  1027,  1027,  1027,  1028,  1028,
    1029,  1029,  1030,  1030,  1031,  1031,  1032,  1032,  1033,  1033,
    1033,  1033,  1033,  1033,  1034,  1034,  1035,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,  1037,
    1037,  1037,  1037,  1038,  1038,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1039,  1039,
    1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,  1039,
    1039,  1039,  1039,  1039,  1039,  1040,  1040,  1040,  1040,  1040,
    1040,  1040,  1040,  1042,  1041,  1041,  1043,  1043,  1044,  1044,
    1045,  1045,  1046,  1046,  1048,  1047,  1049,  1049,  1050,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1052,  1053,  1051,  1051,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1051,  1051,  1054,
    1051,  1056,  1055,  1057,  1057,  1057,  1058,  1058,  1059,  1059,
    1060,  1060,  1062,  1061,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1064,  1064,  1066,  1065,  1067,
    1067,  1068,  1068,  1070,  1069,  1071,  1071,  1072,  1072,  1073,
    1073,  1074,  1074,  1075,  1075,  1076,  1077,  1077,  1078,  1078,
    1079,  1078,  1080,  1078,  1081,  1078,  1078,  1082,  1078,  1083,
    1078,  1078,  1084,  1078,  1085,  1078,  1078,  1086,  1086,  1086,
    1088,  1087,  1089,  1087,  1087,  1087,  1091,  1090,  1093,  1094,
    1092,  1095,  1096,  1097,  1097,  1098,  1098,  1098,  1098,  1100,
    1099,  1101,  1101,  1102,  1102,  1102,  1103,  1103,  1104,  1104,
    1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,  1104,
    1104,  1105,  1105,  1105,  1105,  1105,  1105,  1105,  1105,  1105,
    1106,  1106,  1106,  1106,  1107,  1107,  1107,  1108,  1108,  1109,
    1109,  1110,  1111,  1110,  1112,  1113,  1112,  1114,  1114,  1115,
    1115,  1116,  1116,  1117,  1117,  1117,  1118,  1119,  1119,  1120,
    1121,  1121,  1123,  1122,  1124,  1124,  1125,  1125,  1125,  1126,
    1126,  1127,  1127,  1128,  1129,  1129,  1129,  1130,  1130,  1130,
    1130,  1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1133,
    1133,  1133,  1133,  1133,  1134,  1134,  1134,  1134,  1134,  1135,
    1135,  1135,  1135,  1136,  1137,  1137,  1138,  1139,  1138,  1140,
    1140,  1141,  1141,  1142,  1144,  1143,  1145,  1145,  1146,  1146,
    1148,  1147,  1150,  1149,  1149,  1149,  1152,  1151,  1153,  1154,
    1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,  1153,
    1153,  1155,  1155,  1156,  1157,  1157,  1158,  1158,  1160,  1161,
    1159,  1163,  1164,  1162,  1165,  1165,  1165,  1165,  1166,  1166,
    1167,  1167,  1168,  1169,  1169,  1169,  1170,  1169,  1171,  1171,
    1172,  1172,  1173,  1172,  1174,  1172,  1175,  1175,  1176,  1176,
    1177,  1178,  1178,  1179,  1179,  1181,  1180,  1182,  1182,  1183,
    1183,  1184,  1184,  1185,  1186,  1185,  1188,  1189,  1187,  1190,
    1190,  1191,  1192,  1192,  1193,  1194,  1194,  1196,  1195,  1198,
    1197,  1199,  1197,  1200,  1197,  1201,  1201,  1202,  1202,  1203,
    1203,  1204,  1204,  1205,  1205,  1205,  1206,  1207,  1207,  1209,
    1208,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1211,
    1210,  1212,  1210,  1210,  1210,  1210,  1210,  1213,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1214,  1214,  1214,  1215,  1215,  1216,  1216,  1217,  1217,
    1218,  1218,  1219,  1219,  1220,  1220,  1221,  1221,  1222,  1222,
    1222,  1224,  1223,  1225,  1223,  1226,  1226,  1227,  1227,  1227,
    1228,  1228,  1228,  1230,  1229,  1231,  1231,  1233,  1232,  1232,
    1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1232,  1234,
    1234,  1236,  1235,  1237,  1237,  1238,  1238,  1238,  1240,  1239,
    1241,  1242,  1242,  1243,  1244,  1244,  1244,  1245,  1247,  1246,
    1246,  1249,  1250,  1251,  1248,  1248,  1252,  1252,  1253,  1253,
    1253,  1254,  1254,  1254,  1255,  1255,  1256,  1256,  1257,  1257,
    1257,  1257,  1258,  1258,  1259,  1259,  1260,  1260,  1261,  1261,
    1262,  1262,  1262,  1263,  1263,  1264,  1264,  1265,  1265,  1266,
    1266,  1266,  1266,  1267,  1267,  1267,  1268,  1269,  1269,  1269,
    1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,  1270,
    1270,  1270,  1271,  1271,  1271,  1271,  1271,  1272,  1272,  1273,
    1273,  1274,  1275,  1275,  1276,  1276,  1277,  1277,  1277,  1278,
    1278,  1278,  1278,  1279,  1279,  1279,  1280,  1281,  1281,  1282,
    1283,  1284,  1285,  1285,  1285,  1286,  1286,  1287,  1287,  1287,
    1288,  1288,  1288,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1292,  1291,
    1293,  1293,  1294,  1294,  1296,  1295,  1297,  1297,  1297,  1297,
    1298,  1298,  1299,  1299,  1299,  1299,  1300,  1300,  1300,  1300,
    1301,  1301,  1302,  1302,  1303,  1303,  1303,  1303,  1303,  1303,
    1303,  1304,  1304,  1304,  1305,  1305,  1305,  1305,  1306,  1306,
    1306,  1307,  1307,  1307,  1307,  1307,  1309,  1308,  1310,  1310,
    1311,  1311,  1312,  1313,  1313,  1313,  1313,  1315,  1314,  1316,
    1316,  1317,  1316,  1318,  1318,  1319,  1319,  1320,  1320,  1320,
    1320,  1321,  1320,  1322,  1322,  1322,  1322,  1322,  1323,  1324,
    1324,  1324,  1324,  1325,  1326,  1326,  1326,  1327,  1327,  1328,
    1328,  1329,  1329,  1330,  1330,  1332,  1331,  1333,  1331,  1334,
    1331,  1335,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,
    1331,  1331,  1331,  1331,  1331,  1331,  1331,  1331,  1336,  1336,
    1337,  1337,  1338,  1338,  1338,  1339,  1339,  1339,  1339,  1340,
    1340,  1341,  1341,  1342,  1342,  1342,  1343,  1343,  1344,  1344,
    1345,  1346,  1346,  1346,  1346,  1346,  1347,  1347,  1348,  1348,
    1349,  1349,  1349,  1349,  1349,  1351,  1350,  1352,  1352,  1353,
    1353,  1353,  1354,  1354,  1354,  1355,  1355,  1356,  1357,  1357,
    1358,  1359,  1360,  1360,  1362,  1361,  1363,  1363,  1363,  1365,
    1364,  1366,  1366,  1367,  1367,  1367,  1368,  1369,  1368,  1370,
    1371,  1372,  1373,  1373,  1374,  1374,  1374,  1374,  1375,  1375,
    1376,  1376,  1376,  1377,  1378,  1378,  1378,  1379,  1379,  1380,
    1380,  1380,  1382,  1381,  1383,  1383,  1384,  1384,  1386,  1385,
    1387,  1387,  1388,  1388,  1388,  1388,  1390,  1389,  1392,  1391,
    1393,  1394,  1395,  1396,  1391,  1397,  1397,  1397,  1397,  1397,
    1397,  1398,  1398,  1398,  1399,  1399,  1400,  1400,  1400,  1401,
    1401,  1402,  1403,  1402,  1404,  1404,  1405,  1406
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     3,     3,
       3,     3,     0,     7,     0,    12,     0,     6,     0,     3,
       4,     4,     3,     2,    10,     1,     3,     2,     2,     2,
       2,     2,     2,     2,     0,    12,     0,     6,     2,     0,
       1,     1,     0,     2,     0,     2,     0,     1,     3,     4,
       0,     2,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     1,     4,     0,
       0,     0,     0,     0,    12,     0,     2,     0,     2,     2,
       2,     2,     2,     3,     3,     1,     1,     1,     2,     3,
       3,     0,     4,     0,     3,     0,     1,     3,     1,     0,
       1,     3,     1,     0,     3,     0,     1,     3,     1,     4,
       0,     1,     1,     1,     0,     3,     2,     3,     0,     3,
       0,     5,     5,     0,     7,     5,     0,     2,     1,     1,
       1,     3,     1,     3,     0,     1,     1,     1,     1,     2,
       1,     1,     3,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     4,     0,     0,
       8,     0,     7,     1,     1,     1,     1,     1,     2,     4,
       5,     0,     4,     4,     4,     3,     3,     2,     2,     0,
       2,     1,     2,     3,     1,     1,     1,     0,     2,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     2,     3,     1,     1,     1,     1,     1,
       0,     2,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     0,     4,     2,     4,     0,     6,
       0,     0,     6,     0,     0,     5,     0,     7,     0,     1,
       0,     3,     0,     3,     0,     0,     7,     5,     0,     4,
       0,     3,     0,     3,     0,     1,     0,     1,     1,     3,
       1,     5,     5,     0,     2,     0,     0,     7,     0,     9,
       1,     3,     1,     1,     0,     2,     0,     3,     1,     3,
       0,     0,     0,     0,     9,     1,     0,     4,     5,     1,
       1,     1,     3,     3,     1,     3,     1,     1,     0,     3,
       1,     3,     0,     4,     1,     0,     1,     2,     1,     3,
       4,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     4,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     2,     7,     8,     8,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     4,     3,     3,     3,     1,     4,
       1,     1,     5,     2,     5,     2,     4,     1,     5,     5,
       4,     3,     1,     1,     2,     1,     1,     2,     1,     1,
       1,     2,     3,     2,     3,     2,     2,     3,     3,     3,
       0,     6,     0,     6,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     3,     1,     5,     0,     1,     2,     1,
       1,     1,     1,     0,     3,     0,     1,     0,     1,     2,
       1,     1,     2,     2,     4,     1,     3,     2,     1,     2,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     0,
       1,     0,     2,     1,     2,     3,     2,     0,     1,     0,
       1,     1,     2,     0,     1,     0,     4,     1,     4,     3,
       1,     0,     1,     2,     1,     3,     3,     2,     2,     2,
       1,     1,     2,     2,     2,     1,     2,     2,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     0,     1,     1,
       1,     0,     1,     2,     0,     1,     1,     2,     2,     2,
       1,     3,     3,     1,     1,     1,     4,     2,     1,     4,
       0,     1,     0,     2,     1,     3,     0,     6,     0,     5,
       0,     5,     0,     5,     0,    11,     0,     9,     3,     4,
       3,     3,     7,     0,     3,     1,     4,     0,     3,     0,
       2,     0,     1,     0,     2,     2,     2,     2,     1,     1,
       1,     3,     4,     0,     7,     0,     6,     0,     5,     0,
       6,     4,     1,     2,     1,     1,     0,     5,     0,     3,
       2,     0,     5,     0,     0,     6,     1,     3,     1,     1,
       3,     2,     3,     2,     4,     0,     6,     0,     0,     8,
       4,     4,     3,     3,     2,     2,     6,     5,     3,     5,
       1,     1,     1,     0,     1,     0,     1,     0,     1,     1,
       0,     2,     1,     0,     1,     1,     1,     0,     5,     3,
       0,     5,     3,     3,     0,     3,     0,     2,     1,     3,
       0,     1,     1,     0,     2,     1,     3,     0,     6,     0,
       6,     0,     5,     0,     1,     1,     0,     6,     0,     1,
       1,     2,     1,     1,     1,     0,     6,     2,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     6,     0,     1,     1,     0,     4,     0,     4,     4,
       3,     5,     1,     3,     3,     3,     5,     1,     3,     2,
       1,     1,     0,     6,     1,     3,     3,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       4,     0,     0,     1,     1,     0,     2,     2,     1,     1,
       0,     2,     0,     3,     0,     3,     3,     0,     3,     0,
       3,     2,     1,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     1,     3,     1,     3,     3,     1,     3,     3,     4,
       4,     1,     3,     3,     3,     3,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     4,     1,     4,     6,
       2,     4,     4,     4,    10,     6,     4,     4,     6,     4,
       4,     4,     6,     4,     7,     7,     7,     6,     6,     6,
       6,     3,     4,     6,     8,     2,     2,     4,     7,     7,
       6,     6,     2,     4,     6,     6,     8,     8,     6,     8,
       6,     2,     4,     8,     8,     2,     2,     2,     4,     4,
       4,     4,     3,     8,     4,     6,     4,     4,     4,     6,
       8,     6,     4,     6,     1,     6,     4,     4,     4,     4,
       4,     6,     4,     0,     5,     6,     2,     3,     0,     4,
       0,     3,     0,     1,     0,     2,     1,     3,     4,     4,
       5,     4,     4,     4,     5,     4,     0,     0,     7,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     1,     0,     3,     2,     3,     2,     1,     2,     1,
       2,     1,     1,     1,     2,     0,     1,     0,     2,     1,
       3,     1,     3,     0,     2,     1,     3,     0,     1,     0,
       2,     4,     5,     1,     1,     1,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     0,    11,     3,     6,     0,     3,     0,     0,
       5,     0,     1,     0,     1,     0,     2,     2,     2,     0,
       5,     0,     1,     3,     1,     1,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     0,     2,     0,
       1,     0,     0,     3,     0,     0,     3,     2,     0,     0,
       4,     4,     2,     0,     2,     2,     3,     3,     1,     2,
       0,     1,     0,     4,     4,     2,     0,     1,     1,     0,
       1,     0,     1,     2,     1,     3,     3,     1,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     0,     6,     0,
       1,     3,     1,     2,     0,     2,     3,     1,     2,     1,
       0,     3,     0,     5,     2,     1,     0,     3,     6,     0,
       6,     4,     4,     4,     4,     5,     4,     4,     5,     6,
       4,     1,     3,     1,     0,     2,     0,     1,     0,     0,
       8,     0,     0,     6,     0,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     3,     4,     0,     3,     3,     1,
       2,     2,     0,     3,     0,     5,     3,     1,     3,     1,
       3,     1,     1,     0,     1,     0,     4,     0,     1,     3,
       1,     1,     1,     0,     0,     6,     0,     0,    11,     3,
       1,     3,     3,     1,     3,     0,     1,     0,     4,     0,
       6,     0,     5,     0,     6,     1,     3,     3,     5,     0,
       2,     0,     2,     1,     1,     1,     3,     0,     1,     0,
       3,     2,     4,     4,     3,     4,     4,     2,     1,     0,
       4,     0,     4,     6,    16,     2,     2,     0,     6,     5,
       2,     2,     2,     1,     1,     1,     5,     5,     2,     2,
       3,     2,     2,     2,     3,     2,     2,     1,     3,     4,
       3,     3,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     0,     1,     0,     2,
       0,     1,     1,     1,     0,     2,     0,     2,     0,     2,
       2,     0,     4,     0,     4,     1,     1,     0,     1,     1,
       0,     1,     1,     0,     4,     3,     1,     0,     3,     4,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     0,     3,     3,     1,     1,     1,     2,     0,     3,
       3,     2,     2,     3,     0,     1,     1,     2,     0,     4,
       5,     0,     0,     0,    16,     2,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     3,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     3,     8,     8,     8,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     0,     1,
       3,     1,     2,     2,     2,     1,     3,     3,     1,     1,
       3,     1,     3,     4,     5,     1,     0,     3,     3,     1,
       1,     0,     2,     2,     2,     2,     0,     2,     2,     1,
       2,     2,     2,     2,     2,     0,     3,     0,     1,     0,
       3,     2,     0,     1,     2,     0,     1,     4,     4,     5,
       2,     3,     0,     1,     0,     4,     0,     1,     1,     0,
       2,     2,     1,     0,     1,     1,     4,     0,     7,     1,
       0,     0,     2,     3,     1,     1,     1,     1,     0,     3,
       1,     2,     1,     2,     3,     3,     3,     0,     1,     0,
       3,     3,     0,     8,     0,     3,     1,     3,     0,     2,
       3,     5,     0,     3,     4,     4,     0,    14,     0,     6,
       0,     0,     0,     0,    12,     4,     4,     3,     4,     3,
       2,     1,     3,     5,     1,     1,     0,     1,     1,     0,
       2,     0,     0,     3,     0,     2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,  2267,   912,     0,  2215,     0,     0,     0,     0,     0,
       0,  2217,    98,    58,  1507,  1605,  1606,  1426,  1446,     2,
       0,   912,   145,     0,    70,  1448,     0,  1644,     0,     0,
     912,   402,     0,  1638,     0,     0,   912,  1451,  1631,     0,
     145,  2217,     0,   950,  2050,  1529,     0,     0,     0,  1527,
       0,  2107,  1496,     0,     0,     0,     0,     0,     4,    16,
       0,    35,    21,    25,    11,    15,    10,    33,     6,    49,
      50,    42,     8,    13,    39,     7,     9,    12,    31,    38,
      32,    34,    46,   943,    19,    20,    26,    40,    54,    17,
      51,    48,    18,  1607,    22,    41,    36,    28,    55,    29,
      47,    30,    53,    24,    43,    23,     5,    14,    44,    45,
      37,    56,    27,    52,     0,   781,     0,     0,   846,     0,
       0,     0,     0,     0,  2268,  2258,   914,   913,     0,  2099,
    2098,   879,  2217,  1739,   897,     0,  1803,  1804,  1805,  1806,
    1807,  1808,  1809,  1754,  1810,  1811,  1813,  1812,  1814,  1815,
    1755,  1756,  1816,  1817,  1819,  1818,  1820,  1757,  1758,  1821,
    1822,  1823,  1759,  1760,  1824,  1825,  1761,  1826,  1827,  1828,
    1829,  1762,  1830,  1763,  1831,  1832,  1833,  1834,  1835,  1764,
    1836,  1837,  1839,  1838,  1840,  1841,  1842,  1765,  1843,  1844,
    1845,  1846,  1847,  1848,  1849,  1766,  1850,  1851,  1852,  1867,
    1767,  1853,  1856,  1855,  1854,  1857,  1858,  1860,  1859,  1861,
    1768,  1862,  1863,  1864,  1865,  1869,  1870,  1871,  1769,  1866,
    1872,  1868,  2030,  1874,  1873,  1875,  1877,  1876,  1770,  1878,
    1771,  1772,  1879,  1880,  1737,  1881,  1738,  1883,  1884,  1885,
    1888,  1889,  1773,  1882,  1886,  1887,  1890,  1774,  1891,  1892,
    1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1910,  1903,
    1905,  1906,  1908,  1904,  1909,  1913,  1912,  1914,  1915,  1916,
    1911,  1902,  1907,  1917,  1918,  1901,  1919,  1920,  1921,  1922,
    1923,  1924,  1925,  1926,  1927,  1928,  1929,  1931,  1930,  1932,
    1933,  1934,  1935,  1936,  1938,  1937,  1939,  1940,  1941,  1943,
    1942,  1945,  1946,  1775,  1944,  1947,  1948,  1949,  1950,  1951,
    1776,  1777,  1778,  1952,  1779,  1953,  1954,  1955,  1780,  1956,
    1957,  1959,  1958,  1960,  1961,  1781,  1782,  1962,  1963,  1964,
    1965,  1966,  1967,  1968,  1969,  1743,  1970,  1971,  1973,  1972,
    1974,  1975,  1976,  1977,  1978,  1783,  1979,  1784,  1980,  1981,
    1785,  1982,  1786,  1983,  1984,  1787,  1985,  1986,  1987,  1988,
    1989,  1990,  1788,  1991,  1992,  1789,  1994,  1993,  1995,  1790,
    1997,  1998,  1791,  1996,  1793,  1999,  1792,  1794,  2000,  2002,
    2001,  2003,  2004,  2005,  1795,  2006,  1796,  2007,  2008,  2009,
    2010,  2012,  2011,  2013,  2014,  2015,  2016,  2017,  2018,  2019,
    2020,  2023,  2024,  2025,  2026,  2021,  2022,  1797,  2027,  2028,
    2029,  2031,  2032,  2034,  2033,  1798,  1799,  2035,  2036,  1802,
    2037,  2038,  2041,  2039,  2040,  2043,  2042,  2044,  2045,  1800,
    2046,  1801,  2047,   171,  1742,   147,  1744,  1753,     0,   881,
     898,  2218,  2219,   493,   729,     0,     0,   730,     0,   492,
     728,   145,  2258,   103,     0,   489,   490,     0,  1521,  1237,
    1444,  1444,  1444,     0,     0,  1444,  1444,     0,  1447,  1444,
     145,  1444,     0,    63,  1613,     0,     0,     0,     0,  1736,
       0,  1454,     0,  1645,  1646,     0,  1648,     0,     0,  2096,
       0,     0,     0,     0,     0,   917,   145,   915,     0,  1505,
       0,   877,     0,  2219,  2230,   944,   948,   960,  2051,  2048,
    1590,   866,   866,   866,   864,   866,  1528,     0,     0,     0,
    1505,  1647,  2304,     0,     0,     0,  2300,     0,  2305,     0,
     950,     0,     0,     1,     3,     0,  1863,  1955,  1603,  1601,
    1733,     0,   758,   782,   766,   762,     0,   760,  1749,  1748,
    1747,     0,   771,   770,   768,     0,   363,     0,     0,  2269,
     895,     0,  2216,     0,   927,   937,   173,     0,    72,     0,
       0,     0,  2222,     0,     0,     0,     0,   102,     0,     0,
       0,    99,   540,  2258,  2260,  2262,   493,   491,     0,  1525,
    1524,  1523,     0,  1521,  1427,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1586,     0,     0,     0,  1444,    65,
       0,  2141,  2156,  2157,  2153,  2158,  2176,  2159,  2163,     0,
    2155,  2147,     0,  2162,  2151,  2160,     0,  2145,     0,  2161,
    2166,  2177,  2149,  2154,  2133,     0,  2139,  2143,  1735,  1334,
    2110,  2111,     0,    71,  1456,  1457,  1455,   845,     0,  1804,
    1754,  1815,     0,  1706,     0,     0,     0,  1247,     0,  1759,
       0,  1826,  1828,  1764,     0,     0,   990,   990,   990,     0,
       0,     0,  1841,  1842,  1715,     0,     0,     0,  1703,  1716,
    1874,  1875,     0,  1705,  1880,     0,     0,     0,     0,  1895,
    1713,  1243,     0,  1926,  1928,     0,     0,  1932,  1933,  1934,
    1935,  1690,  1057,     0,   990,  1702,  1712,  1949,  1696,  1956,
    1960,  1961,     0,  1967,     0,     0,     0,  1989,  1992,     0,
       0,  2009,     0,     0,   990,  1740,  2023,  2024,  2025,  2026,
       0,  1704,  1797,  1714,     0,  2037,   990,   990,   990,     0,
       0,     0,  2044,  2047,     0,     0,     0,     0,  1056,     0,
    1211,     0,  1643,   992,   997,  1002,  1009,  1015,  1029,  1031,
    1033,  1036,  1041,  1047,     0,  1097,  1049,  1068,  1069,  1071,
    1164,  1070,  1076,  1075,  1700,  1074,  1073,  1701,  1067,  1723,
    1742,  1689,  1722,  1658,     0,     0,     0,   910,   414,   403,
       0,  1585,  1584,     0,  1639,  2231,     0,     0,     0,   886,
    1459,  1506,     0,  1458,  1636,     0,  1635,  1632,  1634,     0,
    2141,  2128,     0,  2225,  2222,  2232,   973,   966,   965,   968,
     969,   972,   970,   971,   967,   964,   981,   961,   963,  2054,
    1553,     0,   665,     0,  1598,     0,  1554,     0,     0,  1598,
       0,  1369,  1588,  1591,     0,  2063,  1567,   726,   725,     0,
     724,  2064,  1584,     0,     0,     0,  1538,  1555,     0,  2065,
       0,  1587,     0,  1369,  1598,     0,  1530,     0,     0,     0,
       0,   860,   870,   862,   857,     0,   863,   859,  1526,  1443,
    2317,  2108,   845,  1695,  1694,  2301,  1693,  2309,  2311,  2297,
    2299,  2306,   946,     0,  2236,    57,     0,  1610,  2265,  2266,
    2264,   679,   773,   155,   769,     0,   364,   155,     0,     0,
       0,     0,     0,   365,   366,   298,   756,     0,     0,     0,
       0,     0,  1441,     0,     0,   929,   939,   175,   172,   146,
       0,   883,   900,  2221,     0,     0,  2223,  2227,  1055,  1054,
       0,    96,   101,     0,     0,     0,   990,  1750,  2195,   100,
    2191,  2263,   541,   493,   981,   981,  2257,   981,  2252,     0,
    2254,  2255,  2256,  2269,  2261,     0,   731,     0,  1508,  1511,
    1515,  1519,  1522,  1239,  1238,  1445,  1431,  1436,  1432,     0,
    1586,  1433,  1440,   377,     0,  1437,  2189,  1434,   847,     0,
       0,    64,  1627,  1621,  1623,  1626,  1622,     0,  1628,  1625,
    1624,  2099,  1614,  1616,  1617,  2142,  2140,  2174,  2173,     0,
    2175,  2171,  2164,  2196,  2168,  2196,  2170,  2169,  2196,  2165,
    2172,  2196,  2137,     0,  1335,  1336,     0,  2109,     0,  1734,
       0,     0,     0,     0,  1339,  1089,  1339,  1339,  1339,  1248,
       0,     0,     0,  1237,  1237,     0,     0,     0,  1339,     0,
    1125,  1100,     0,  1126,     0,     0,     0,     0,     0,  1709,
       0,     0,     0,     0,  1237,     0,  1216,     0,     0,     0,
    1066,     0,  1237,  1243,     0,  1241,     0,  1339,     0,     0,
    1339,     0,     0,  1237,  1237,  1237,  1001,     0,  1132,     0,
       0,     0,  1237,     0,     0,     0,     0,     0,     0,     0,
    1339,  1339,     0,     0,  1339,     0,  1141,     0,  1711,     0,
       0,     0,  1710,     0,     0,  1708,  1707,  1691,     0,  1145,
    1147,  1146,     0,  1339,  1339,     0,     0,  1079,  1078,  1080,
    2250,     0,     0,     0,     0,     0,     0,     0,   994,   999,
    1058,     0,  1059,  1060,     0,  1061,  1062,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1081,  1309,  1310,
    1311,  1312,  1321,  1324,  1313,  1314,  1315,  1323,  1316,  1317,
    1318,  1325,  1326,  1327,  1319,  1328,  1322,  1320,  1329,     0,
    1308,     0,     0,  1692,  1173,     0,  1659,     0,  1660,  1649,
    1656,   932,     0,  1334,  2097,  2100,     0,   415,   412,   410,
     423,     0,     0,    60,    61,     0,   918,     0,   919,     0,
     916,   922,     0,     0,     0,  1462,  1452,  1461,  1637,     0,
       0,  2140,  2137,  2226,     0,  2228,  2243,   949,  2233,   979,
     951,   978,     0,   962,  2049,  2052,  2060,  1594,   664,     0,
       0,  1566,  1550,     0,   493,     0,     0,     0,     0,     0,
    1531,  1541,  1539,   528,     0,  1559,  1370,  1592,  1593,  1598,
       0,     0,  1598,     0,  1561,  1572,  1562,     0,  1588,     0,
    1598,  1546,  1573,  1588,  1551,  1558,  1565,     0,  1545,  1552,
       0,  1537,  1563,  1588,  1588,  1598,  1598,   873,   872,   871,
     867,   868,   873,     0,  1280,     0,     0,  2298,  2312,  2296,
    2307,  2308,  2295,   947,  2237,   945,  2238,     0,  1604,  1602,
    1611,  1612,   680,   759,   679,   484,   487,   486,     0,     0,
     775,   777,   763,     0,   352,   761,     0,     0,   330,   309,
     330,   367,   679,  2259,     0,     0,   900,     0,     0,   931,
     926,   930,   928,   721,   720,   723,     0,   938,     0,   176,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    73,    74,    87,   885,
     884,   882,   908,   907,   905,     0,   906,   904,   899,   901,
     902,  2220,  2224,   494,   679,   340,     0,   301,  1752,     0,
       0,     0,     0,     0,     0,     0,     0,  2253,    92,   732,
       0,  1513,  1509,  1519,     0,     0,     0,  1334,     0,  1429,
     377,   380,   379,  1438,   378,  1483,     0,   849,   848,  1435,
     847,     0,    66,    68,  1620,     0,     0,  1629,  2167,     0,
    2148,  2152,  2146,  2150,     0,     0,  2138,     0,  2144,  1338,
    1870,  1942,     0,  1341,  2113,  1449,  2316,     0,     0,  1340,
    1339,     0,  1222,     0,     0,     0,     0,  1249,     0,     0,
       0,     0,     0,     0,     0,  1196,     0,  1222,   991,     0,
    1152,     0,     0,     0,     0,     0,  1722,  2250,     0,     0,
       0,  1332,  1330,  1333,  1331,     0,  1217,  1209,     0,     0,
       0,     0,     0,     0,     0,  1244,  1245,  1339,     0,     0,
       0,  1339,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1339,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1121,     0,  1725,  1724,
       0,     0,     0,     0,   950,     0,  1083,  1237,  1082,     0,
    2066,  1212,  1214,     0,   996,   993,   998,  1012,  1005,  1010,
    1003,  1007,     0,  1064,  1809,  1013,     0,     0,     0,  1348,
    1027,     0,  1030,     0,     0,     0,     0,  1032,  1034,  1035,
    1038,  1097,  1037,  1097,  1045,  1046,  1042,  1043,  1044,  1048,
       0,  1072,  1077,  1184,  1726,  1655,  1657,     0,     0,  1650,
       0,     0,   900,     0,     0,     0,   404,   408,     0,    62,
       0,     0,  1640,     0,     0,     0,     0,     0,   888,  1460,
       0,  1633,     0,     0,     0,     0,     0,  2229,  2245,  2244,
    2234,   981,  1360,   982,   984,   983,  1722,  2054,  2057,  2058,
    2061,  2059,     0,  2056,  2055,  2070,     0,  1596,  1599,  1600,
       0,     0,  1580,  1575,  1574,  1570,  1571,     0,     0,  1379,
    1380,  1378,  1373,  1374,  1377,  1534,  1589,  1579,  1577,  1568,
       0,  1598,  1578,  1576,  1598,  1588,     0,  1598,  1598,  1560,
    1564,     0,   861,   870,   858,   865,  1292,  1291,     0,  1256,
       0,  1255,  1254,  1253,     0,  1291,  2302,  2310,  2314,     0,
    1369,  2242,  2240,   485,  1483,  1483,     0,     0,     0,   119,
       0,     0,     0,     0,     0,     0,     0,   156,   165,     0,
       0,   307,   308,   306,  1586,     0,     0,     0,     0,     0,
       0,     0,     0,   105,   360,   303,  1586,   299,     0,   304,
     843,   843,     0,  1483,  1483,   843,  1483,     0,     0,  1483,
    1483,     0,     0,  1483,     0,     0,   843,     0,  1483,   841,
       0,     0,  1483,  1483,  1483,  1483,   843,     0,     0,  1483,
     400,  1483,     0,     0,   853,     0,     0,  1483,     0,     0,
    1483,  1483,   789,   840,   497,   516,   517,   757,   788,   790,
     802,   398,     0,   819,   842,  2270,  2271,   764,   896,   880,
    1442,     0,   174,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     909,   903,    97,   305,  1586,     0,     0,   317,  1751,     0,
    2192,   114,  2290,     0,     0,  2272,   495,     0,     0,   733,
       0,     0,  1341,     0,  1516,  1280,  1520,  1519,  1517,  1240,
    1430,  1439,  1481,  1482,  1484,     0,  2190,  1428,    69,     0,
       0,  1615,  1630,  1618,  2200,     0,  2199,  2185,  2188,  1733,
       0,     0,     0,  2123,  2117,  2124,  2126,  2120,  2125,  2127,
    2118,  2119,  2114,  2121,  1342,  1371,     0,     0,  1148,     0,
    1189,     0,  1191,  1192,  1193,     0,     0,     0,     0,     0,
    1149,     0,  1098,  1150,  1151,     0,     0,     0,  1237,  1195,
       0,  1127,     0,     0,  1101,  1102,  1094,     0,  1086,     0,
    1166,     0,  1237,  1103,     0,     0,     0,  1167,  1242,     0,
       0,     0,  1201,  1154,  1106,     0,  1199,     0,  1107,  1168,
    1169,  1170,  1133,  1156,  1157,     0,  1172,     0,  1158,     0,
       0,     0,  1237,  1109,  1205,  1203,     0,     0,     0,     0,
    1207,  1142,  1111,     0,     0,     0,  1110,     0,     0,     0,
       0,     0,     0,     0,  1113,     0,  1095,  1204,  1206,  1162,
       0,  1122,  2249,  2251,     0,     0,  1087,     0,     0,     0,
       0,     0,  1727,  1051,  1050,     0,  1053,  1052,     0,  1006,
    1011,  1004,  1008,     0,     0,     0,     0,     0,  1025,  1024,
       0,     0,  1348,  1028,  1040,  1039,  1096,     0,  1183,   981,
    1237,     0,     0,   933,   934,   937,     0,  2103,  2104,  2102,
    2101,   911,   981,   413,   411,  1404,  1405,  1390,  1391,  1389,
    1392,   424,  1393,  1403,   425,     0,   416,  1642,  1641,   925,
       0,   920,   923,   924,   893,   892,   894,   887,   889,   890,
     477,  1466,     0,     0,     0,  1472,  1453,  1463,   878,     0,
       0,     0,     0,     0,   977,  1280,  1420,   974,   955,  1371,
    1361,   954,   985,     0,  2053,     0,  2021,  2081,     0,     0,
       0,     0,     0,  2071,  1595,     0,  1547,     0,  1569,  1583,
    1582,  1581,  1542,  1540,     0,     0,     0,  1536,  1535,  1341,
    1588,  1532,  1533,   875,   874,   869,  1291,  1280,     0,     0,
    1277,  1293,     0,  1293,  1280,  1280,     0,  1280,  1334,  1288,
       0,     0,  2313,  1362,  2241,     0,     0,     0,   128,     0,
       0,   774,     0,   121,   120,   130,   159,   162,   160,     0,
     161,     0,     0,   362,   361,  1483,   353,   354,   357,   358,
     359,   109,   108,   110,   111,  1387,  1388,  1384,  1385,  1383,
    1386,   113,   112,   107,   772,     0,  1483,  1483,   331,   332,
     335,   336,   337,   338,   339,   310,   311,   314,   315,   316,
     844,   750,   722,   912,   722,   823,     0,   557,   750,   715,
     821,     0,   912,     0,     0,     0,     0,     0,   912,     0,
       0,     0,  1483,     0,   834,   784,     0,     0,     0,     0,
       0,   835,     0,   785,  1483,     0,     0,     0,     0,     0,
     912,     0,     0,     0,     0,   912,   803,   856,   855,   854,
       0,   912,   912,     0,   522,   523,   521,     0,     0,   498,
     679,   786,   399,   787,   560,     0,   850,   557,   563,  1729,
    2274,  1305,     0,  1304,   177,    80,    76,    88,  1397,  1398,
    1396,  1394,  1395,    89,    78,    79,    83,    82,    84,    85,
      86,    81,    77,    90,    91,    75,  1483,  1483,  1483,  1483,
     341,   342,   345,   346,   347,   348,   351,   349,   350,     0,
       0,   300,  1586,     0,  2193,     0,     0,   294,   293,     0,
    2288,  2274,     0,   560,    93,   398,   496,   499,   743,   745,
     744,   739,   738,    94,  1280,  1360,  1519,  1341,     0,  1334,
     376,    67,  1619,  2197,     0,     0,     0,     0,     0,     0,
       0,     0,  2112,  1372,  1493,     0,     0,  1190,  1223,     0,
    1250,     0,  1091,   643,   643,  1233,  1231,   632,   643,  1227,
    1232,  1229,     0,   667,     0,   666,     0,     0,     0,  1197,
    1194,     0,     0,  1726,     0,     0,  1220,     0,     0,     0,
    1178,  1246,  1202,  1200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1208,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2246,  2247,
    1084,  2067,  2068,  2069,   752,  1213,   995,  1000,     0,  1022,
    1018,  1237,  1016,  1347,     0,     0,     0,  1026,  1174,     0,
    1185,  1186,     0,  1236,  1728,  1741,  1651,     0,   941,  2105,
    2106,     0,     0,   405,   409,     0,   417,   418,   420,     0,
     891,   960,     0,  1485,  1470,  1477,  1471,     0,     0,     0,
    1469,  1718,  1717,  1724,  2232,     0,     0,     0,     0,  2235,
    1341,  1341,  1414,     0,     0,   952,   957,   953,   956,     0,
     980,   989,   988,  1719,  1726,     0,     0,     0,     0,   669,
     668,   675,     0,     0,     0,  2066,     0,   671,   673,   672,
    2076,   670,  1597,  1369,  1557,  1556,  1376,  1375,     0,  1549,
    1598,     0,  2239,  1286,     0,  1279,  1278,  1294,     0,  1280,
    1293,  1293,     0,  1259,  1258,  1497,  1500,     0,  1257,  1295,
    1284,   960,  2303,  2315,     0,   678,   677,   527,   674,   526,
     129,   118,     0,     0,   776,   778,     0,   779,   164,   163,
     169,   170,     0,  1586,   355,   106,     0,     0,  1586,   333,
       0,   312,   562,   751,   716,   806,   717,     0,     0,     0,
     722,   556,   750,   555,   558,   731,     0,     0,   509,   506,
     825,   512,   804,   797,   805,   816,   818,     0,   508,   524,
       0,     0,   513,   750,   791,   832,   833,   847,   502,     0,
     536,   537,   535,   518,   525,   504,   505,   827,     0,  1356,
    1358,  1366,   511,   510,   401,   507,     0,   838,   811,     0,
     534,   532,   529,   531,   530,   533,   514,   503,     0,   843,
     843,   820,     0,   546,   548,   549,  1732,     0,   852,   822,
       0,   550,   551,     0,     0,     0,     0,   940,     0,     0,
       0,     0,     0,  1586,   343,     0,     0,  1483,   318,   319,
     322,   323,   324,   325,   326,   329,   327,   328,  2194,     0,
    2291,   297,   295,   296,     0,     0,     0,   386,     0,  1780,
     383,   390,     0,   384,   679,   500,     0,  1341,  1381,  1512,
    1518,  2198,  2187,  2186,  2201,  2201,  2201,     0,  1343,     0,
    1450,  1066,  1123,  1251,     0,     0,  1224,   681,     0,  1234,
     634,  1226,  1228,  1230,  1090,  1099,  1165,  1093,  1092,     0,
       0,     0,  1130,  1131,  1218,  1221,     0,     0,  1105,     0,
       0,  1180,  1155,  1171,  1134,  1159,     0,  1108,  1085,  1066,
    1135,     0,  1140,  1138,     0,  1112,     0,     0,  1119,     0,
    1117,     0,  1118,     0,  1120,  1161,  1163,  2232,     0,  1215,
    1014,     0,  1023,  1020,  1237,  1017,   982,   981,  1175,  1661,
     935,     0,   936,   982,   433,   414,   436,   407,     0,   921,
     981,  1467,  1479,     0,  1487,     0,     0,  1464,  1474,     0,
       0,     0,  1473,     0,  2130,  2131,  2129,  1371,  1349,     0,
       0,  1425,     0,  1421,   975,     0,   987,   986,     0,  2083,
       0,  2082,  2094,  2095,  2092,  2093,  2091,  2072,     0,  2078,
    2077,     0,     0,     0,  2088,  2079,     0,     0,  1548,     0,
    1543,   876,     0,  1280,  1293,  1280,  1266,     0,     0,  1280,
    1262,  1260,  1264,     0,  1341,     0,     0,     0,     0,  1281,
     981,  1721,  1363,  1366,   116,   131,   132,   767,   382,   368,
     381,   356,   369,   370,   334,   313,   808,   559,   750,   718,
     719,   731,     0,     0,     0,   795,     0,   900,     0,   801,
     675,   519,   831,   830,   520,     0,   793,     0,  1367,  1368,
    1359,   792,   813,   799,     0,   824,   560,   851,   695,   628,
     577,   568,   643,   571,   570,   614,   585,   582,   632,   630,
     600,   632,   632,   607,   606,   624,   610,   590,   681,   681,
     589,   627,   681,   611,   609,   613,     0,   615,   632,   620,
     608,   612,   629,   605,   602,   626,   643,   643,   583,   586,
     625,   681,     0,   618,   643,   647,   588,   681,   687,     0,
       0,   643,   645,  1731,  2276,     0,  2278,  1303,   375,   374,
     373,   372,   344,     0,   302,     0,  1586,   320,     0,   190,
     981,     0,   149,  2289,  2278,     0,     0,   495,  1661,   501,
       0,  1514,     0,  1510,     0,  2206,  2206,  2206,  1492,  1491,
       0,  1490,  1494,     0,  1252,     0,   687,   689,   683,   687,
       0,  1225,     0,  1198,  1128,  1129,     0,     0,     0,     0,
       0,     0,  1088,     0,  1176,     0,     0,     0,     0,     0,
       0,  1116,  1114,  1115,  2251,   753,  1019,     0,   985,  1187,
    1663,  1662,     0,   942,     0,     0,     0,   406,   419,   478,
       0,     0,     0,  1488,  1476,  2236,  1465,  1468,  1726,  2132,
     959,     0,  1344,  1424,  1422,     0,  1415,  1417,  1419,     0,
    1720,     0,     0,  2087,  2073,   676,     0,     0,     0,     0,
    2074,     0,  1334,  1287,     0,     0,  1253,  1280,  1280,     0,
    1253,     0,     0,     0,  1499,  1360,  1501,  1299,  1297,  1298,
    1296,  1289,     0,  1365,   122,   780,   238,     0,     0,   807,
       0,     0,     0,   837,     0,   900,   850,   798,   817,   839,
     647,   912,  1357,   812,   814,   888,   515,   547,   701,     0,
       0,   587,   636,   631,     0,   636,   636,   596,   614,   591,
       0,   681,   604,   595,   616,   619,   621,   623,   636,     0,
     681,   584,   593,     0,   636,   655,     0,     0,     0,   651,
       0,   694,     0,   658,   564,   648,   650,     0,     0,   617,
       0,   573,   688,     0,   575,     0,     0,   636,     0,   646,
     636,     0,  2275,     0,  2282,     0,     0,   371,   321,   126,
     193,   191,   192,     0,   186,   188,   183,     0,   544,   545,
     543,   542,     0,   179,  2282,   387,     0,   398,   385,   480,
       0,  1366,   748,  1382,     0,     0,  2205,  2203,     0,  2204,
    2202,  2178,     0,  2135,  2136,  2134,  2122,     0,     0,  1124,
     644,   682,   690,   691,     0,   686,   684,   687,   633,     0,
    1219,  1210,  1153,     0,  1177,     0,     0,  1160,  1136,  1139,
    1137,  1143,  1144,  2248,  1021,  1188,  1652,   421,     0,     0,
     440,     0,   438,  1371,  1478,  1480,  1486,  1475,     0,  1345,
    1360,  1664,  1418,     0,   976,  2085,  2084,  2086,  2080,     0,
       0,     0,     0,  1285,  1280,  1267,     0,  1271,  1276,  1272,
       0,  1263,  1261,     0,  1381,     0,  1371,  1366,     0,   124,
     264,     0,   250,   236,     0,     0,     0,   240,   133,   136,
     134,     0,   135,   139,     0,   140,   141,   142,   143,   144,
     137,   262,   263,   138,  1745,     0,  1746,   810,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   836,  1697,   796,
     826,   828,   900,     0,   800,     0,     0,     0,   696,   697,
     702,   704,     0,     0,   640,   641,   642,   597,   637,   639,
       0,   599,   567,   592,   622,   598,     0,   594,     0,   581,
     661,   660,   990,   653,   663,     0,     0,   659,   649,   657,
     652,     0,     0,     0,     0,   565,     0,   566,  1730,  2277,
       0,   765,   981,   981,  2279,   104,   119,   127,  2292,   190,
       0,     0,     0,     0,   180,   182,   183,  2273,   391,   388,
     481,     0,   734,     0,   747,     0,  2184,  2183,  2182,  2179,
       0,     0,     0,     0,     0,     0,  2207,  2209,  1489,     0,
     692,   685,     0,     0,  1179,  1181,     0,   981,   426,     0,
       0,   437,     0,   479,   974,   538,  1353,  1366,     0,  1371,
       0,  1672,  1416,  2090,  2089,  2075,     0,     0,     0,     0,
       0,     0,     0,  1306,  1498,  1301,  1290,  1364,   123,     0,
     117,     0,     0,   249,   252,     0,     0,   255,   245,   244,
     246,     0,   239,   285,   238,   238,   288,   243,   281,   809,
       0,     0,   734,  1699,  1698,   850,   794,     0,   707,   708,
     709,     0,     0,     0,   700,   703,   576,   569,   638,     0,
     754,     0,   580,   662,   990,   656,   681,   687,   681,   687,
       0,     0,     0,   950,     0,   130,   157,   187,     0,   981,
     148,   150,     0,     0,  2236,  1661,     0,   394,  1483,     0,
      95,   735,   740,   736,  1366,     0,  2180,  2210,  2213,  2211,
    2212,  2214,  2208,     0,   635,  1104,     0,     0,   434,     0,
     430,   432,   441,   445,   439,   539,     0,     0,  1350,  1352,
    1346,  1406,     0,     0,     0,     0,  1665,  1667,     0,  1423,
       0,  1282,  1268,     0,  1273,     0,  1265,     0,     0,  1302,
     125,   265,   276,   279,   271,   251,     0,     0,     0,   241,
     198,   238,     0,   227,   225,   226,   230,   231,   232,   233,
     234,   235,   228,   229,   238,     0,     0,     0,   734,   552,
     829,     0,   711,     0,   710,     0,   705,   706,   701,     0,
     681,     0,   681,   654,   572,   574,   578,   579,     0,  2283,
       0,  2280,     0,     0,  2293,   189,     0,     0,   181,   184,
     392,   389,     0,  2232,     0,     0,   737,   746,   749,  1495,
    1503,     0,  1653,   982,     0,   427,   428,     0,   446,  1354,
    1355,  1366,     0,   958,     0,     0,     0,     0,  1666,     0,
       0,  1673,  1675,     0,     0,     0,     0,  1307,  1300,     0,
       0,   238,   272,     0,   247,     0,     0,   194,     0,     0,
     196,   291,     0,   283,   554,   553,     0,   713,   714,   712,
     698,   699,   601,   755,   603,  2284,  2285,  2236,   132,   167,
     166,   158,     0,   238,     0,   151,   396,   395,   741,   742,
       0,     0,  1664,     0,   435,   434,   431,     0,   442,  1351,
    1407,  1670,  1671,     0,  1668,     0,     0,  1674,     0,     0,
    1270,  1275,   273,   279,   269,   277,   238,     0,     0,   237,
     256,     0,   238,     0,   287,   197,     0,   289,   282,   284,
     815,  2281,   115,   168,  2294,  2286,     0,  2236,  1502,  1504,
    1672,   422,   429,     0,     0,   465,     0,  1669,  1677,  1676,
       0,  1283,     0,   270,     0,     0,   268,   248,   253,   238,
     209,   208,     0,   200,   221,   286,     0,   199,     0,   238,
     238,   152,   397,  1678,     0,     0,  1483,     0,     0,  1483,
    1483,  1483,  1483,   443,   466,   468,     0,   981,     0,   274,
       0,   238,     0,   238,     0,     0,     0,     0,     0,   195,
       0,   238,  2287,   157,     0,  1680,     0,   454,   456,   457,
     451,     0,   447,   449,   450,     0,  1483,  1483,     0,     0,
       0,     0,   458,   467,  1483,     0,     0,  1410,  1412,     0,
       0,   266,   238,   254,   259,   203,   222,   223,     0,   206,
     292,     0,   153,     0,     0,  1687,   448,     0,  1922,     0,
     476,     0,     0,  1401,  1399,  1400,   472,  1402,   473,   471,
     469,     0,   444,     0,  1413,  1408,   981,  1544,   238,   238,
     255,   258,     0,     0,   201,   214,   202,   212,   205,     0,
     290,   238,  1679,  1682,     0,     0,  1684,  1685,     0,  1654,
     455,   452,   453,   474,   475,   462,     0,   460,   470,  1411,
     238,   238,   260,   220,   218,   238,   216,   210,     0,   217,
     224,   215,     0,   207,   154,  1686,  1681,     0,  1688,     0,
     459,     0,     0,   204,   219,   213,  1683,   465,   464,   461,
     211,   463
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    56,    57,    58,    59,    60,    61,  1213,    62,   609,
     991,  1432,  1433,    63,   480,    64,   930,  1376,  1377,  1378,
      65,  1846,  2696,  1394,   452,   453,  1742,  1743,   956,  2315,
    2151,  3104,  2155,  3299,  3470,  3396,  1330,  2557,  3105,  3106,
    3308,   475,   433,  2983,  3203,  3647,  3776,  3843,  3921,  1332,
    3644,  1727,  3721,  1728,    66,   566,   928,  1358,  1359,  3403,
    3404,  3400,  3405,  3193,  3194,  3195,  3196,  3762,  3601,  3697,
    3763,  3836,  3912,  3918,  3919,  3802,  3945,  3946,  3952,  3947,
    3803,  3914,  3602,  3603,  3477,  3604,  3311,  3605,  3481,  3606,
    3314,  3607,  3608,  3609,  3610,  3758,  3611,  3476,  3797,  3597,
    3598,  3799,  3874,  3911,  3612,  3321,  3471,  3689,  3322,  3472,
    3753,  3593,  3754,  3792,  3870,  3594,  3690,  3795,  3693,  3613,
    3616,  3768,  3487,  3600,  3615,  3809,  3766,  2319,  2684,   552,
     553,   577,  1837,   554,   942,   904,  1334,  1747,  1748,  2195,
    2196,  2311,  2312,  2668,  2669,  1745,  1746,  2188,  2189,  1833,
    1834,  2300,  2301,  1733,  1734,  2166,  2167,  1338,  1731,  1732,
     555,   905,   915,  2168,  2191,  2192,  2673,  2303,  2304,  2305,
    2306,  2169,  1423,  2170,  2869,  2324,  2988,  2690,  3535,  2986,
    3534,  3208,  3653,  3777,  2261,  2262,  2243,    67,   491,   789,
    2054,  2786,  1210,  2055,  1614,  1613,  1211,  2455,  2456,  2457,
    2043,  3438,  1616,  2453,  3558,  3735,  3559,  3560,  2783,  3665,
    3047,  3261,  3262,  3440,  3668,  3785,  3862,  3562,  3738,  3852,
    3853,  3854,  3846,  3847,  3848,  3902,  3936,  3937,  3959,  3967,
    3823,  3824,  3825,  2075,  2461,  3263,  3411,  1323,  1324,  1325,
     454,   455,   456,   574,  2325,  1793,  2326,  2327,  1795,  1796,
    1262,  2636,  2613,  3443,   957,  3202,  2642,  2643,  2644,  2645,
    2583,  2584,  2206,  2207,  2267,  2653,  2955,  3134,  3149,  2956,
    2957,  2958,  2959,  2960,  2961,  2962,  2719,  2720,  3357,  3358,
    3359,  2716,  3180,  3164,  3165,  3166,  3373,  3010,  2500,  2501,
    2509,  2510,  2546,  2829,  2547,  1328,  3011,  3174,  3235,  3167,
    2652,  3128,  3348,  3503,  3349,  3350,  3351,  3626,  2208,  2582,
    2209,  1356,   865,   457,  1409,  1410,  3540,  3541,  3542,  3543,
    2331,  3210,  3211,  2572,  2769,  3509,    68,  1342,   901,   907,
     903,  2270,   902,  1331,  1719,  2867,   542,  1797,  3121,  3115,
    2887,  3125,  1798,  2593,  1799,  2876,  3109,  1800,  2902,  3123,
    3343,  2594,  2595,  1801,  1802,  1803,  2886,  2895,  3495,  2210,
     123,  1429,  2649,  2250,    69,  1302,  1297,    70,   876,   871,
     872,  1300,  1301,  1692,  2124,    71,   809,    72,   561,    73,
     569,  1381,    74,  1223,  2067,  2068,  2069,    75,   920,    76,
      77,   570,  1388,  1389,  1390,    78,  1206,   128,    79,   798,
     796,  1218,  1220,  1221,  1216,    80,   563,   564,  1350,    81,
    1608,  2033,  2034,   925,   926,  1357,  2782,    82,    83,   532,
     505,   815,   506,   507,  1642,  2087,  3444,   826,   827,   828,
    2485,  1240,  1241,  1242,  2092,  1643,  2490,  1050,  2999,  1138,
    1565,   753,  1139,  1566,   754,   755,   756,   757,   758,   759,
     760,   761,   762,   763,  2005,  2008,  3168,   764,  1148,  1576,
     765,   766,   767,   768,   769,   770,   771,  1603,  2740,  2741,
    3024,  2027,  2028,  2029,  2440,  2441,   772,  1918,  2729,  1932,
     773,  1135,  1561,  1497,  3017,  2734,  1461,  1901,  2372,  2442,
     594,   595,   974,  1074,  1075,  1076,  1505,  1040,  1908,  1467,
    1699,  1700,  1701,  1702,  3092,  3091,  3093,  3458,  3286,  3460,
    3290,  2135,  1703,  1704,  3684,  2522,  2843,  2540,  2541,  3296,
    2126,  1705,  2528,  2859,  3098,  3295,  3588,  2272,  3462,  1189,
    1190,  1495,  1026,  1027,  1462,  1895,  2351,  3270,  3448,  2018,
    3062,  3446,  3568,  1804,  2619,  2620,  2089,  2090,  2544,  2862,
    2900,  1265,  3445,  2353,  1672,  1673,  2993,  3917,  2870,  2283,
    3896,  2052,  2053,  3673,  3786,  3866,  3867,  3868,  2811,  2812,
    3066,  3067,  2091,  2482,  2813,  3271,    84,   459,    85,  1860,
     921,   922,   597,   472,    86,   481,  1896,    87,   499,  1630,
     647,   802,  1226,  1227,  2076,  2462,  2469,  2077,  2474,  3055,
    2464,  2791,  2792,  1864,  1865,  2465,  2794,  3052,  3000,  3001,
    2710,  3228,    88,   520,  2854,  2535,  2536,  3659,  3660,   803,
      89,   458,   968,  1852,  1415,  1851,   969,   970,  1417,   592,
     593,    90,   517,    91,   510,   866,  1668,  1667,  2513,  2112,
     793,   984,  1269,   869,  1270,  1657,  2106,  1251,    92,   897,
     896,    93,   538,  1319,    94,   610,  1002,  1003,  1437,  1873,
      95,   500,   807,   808,    96,   493,   794,  1622,    97,   485,
      98,    99,   783,  1199,  2779,  3436,  3732,  1607,  1200,  3209,
    3451,  3576,  3577,  3579,  3681,  3682,  3845,  3885,  3925,  3926,
    3929,   774,   885,   775,  3337,   776,   777,  2470,  2471,  2863,
     778,  3661,   779,  2268,   879,   478,   434,   549,   781,  2446,
     782,  3325,   947,   948,   436,   437,   100,   829,   509,  1244,
    1245,  1246,  1652,  1653,   870,  2000,  1654,  1655,  2103,  2098,
    3074,  2835,  2827,   101,   786,  1004,  1204,  1205,  2039,   102,
     519,   103,  1028,  1453,  1454,  1892,  2350,  1893,   104,   811,
     105,   634,  1447,   635,  1006,   636,   637,  1018,  1013,  1021,
    1015,  3420,  3220,  3221,  1880,   987,   949,   950,  1440,  1875,
    1876,  2995,  3223,  3426,  3427,   106,   132,   442,   572,   937,
    1234,   107,   108,   109,   110,  1237,  1314,  2083,  1315,  1316,
    1317,  1712,  1640,  1133,  2767,  1993,  1555,  2418,   581,   958,
     559,   583,   584,   124,   125,   959,   960,  2321,  2656,  2965,
    3184,  3185,  3394,  3391,   961,  3810,   962,  2685,  2316,  2979,
    3526,  3723,   111,   887,   529,  1312,  1307,  1309,  1708,  2142,
     112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3187
static const int yypact[] =
{
    4059,   819,  1168,  1193, -3187,  -135,   181, 35992,   105,  1193,
    1193,   -92,   751, -3187, -3187, -3187, -3187, -3187,  1016, -3187,
   35992,  1168, -3187, 18986, -3187, -3187,   599,   185,   302,  1193,
    1168, -3187, 35992, -3187,   522,   390,  1168, -3187, -3187,  1193,
   -3187,   -92, 35992, -3187,   649, -3187,   -83,   -72,   566,   528,
     737, -3187, -3187, 35992,   981,  -112,  1141,  1099, -3187, -3187,
     928, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, 19537, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187,  1285, 35992, 35992, 35992, -3187,  1309,
   35992, 30512, 35992,   977, -3187,  1371, -3187, -3187,  1193, -3187,
   -3187, -3187,   -92, -3187, -3187, 18986, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,   987, -3187, -3187,  1046, -3187,
   -3187, -3187,  1537,  1365, -3187,  1396, 30512, -3187, 35992, -3187,
   -3187, -3187,   834, -3187,  1109, -3187,  1119,  1398,   692, -3187,
    1431,  1431,  1431, 35992,  1424,  1431,  1431, 35992, -3187,  1431,
   -3187,  1431,  1193, -3187, -3187,  2368, 35992,  1316,   405,   -51,
   30512,  1263, 35992, -3187, -3187, 10595, -3187,  1447, 18986, -3187,
    1193,  1619,  1511,   817, 35992, -3187, -3187, -3187,  1193,   215,
     898, -3187,  2519,   147, -3187, -3187, -3187,   652, -3187, -3187,
    5378, -3187, -3187, -3187,  1149, -3187, -3187, 18986, 35992,  1193,
    1443, -3187, -3187,   189,   189,   189, -3187,   189, -3187,   189,
   -3187,  -112,  1121, -3187, -3187, 35992,   442,   452, -3187, -3187,
    1120,   726, -3187, -3187, -3187, -3187, 35992, -3187, -3187, -3187,
   -3187,  1370, -3187, -3187, -3187,  1003, -3187, 18986,  1584,  1286,
   -3187, 18986, -3187,    43, -3187, -3187,  1187, 35992, -3187, 18986,
   18986,   778,    59,  1010, 35992, 35992,  1590, -3187,  1761, 27772,
    1382, -3187,   170,  1371,  1779, -3187,  1365, -3187, 35992, -3187,
   -3187, -3187, 32156,   692, -3187, 10595,  1646, 35992, 35992, 35992,
    1476, 35992, 35992, 30512,  1342, 35992, 27772, 18986,  1431,  1284,
    1846,  1475,  1440,  1052, -3187, -3187, -3187, -3187, -3187,  1486,
   -3187, -3187,  1346, -3187, -3187, -3187,   385, -3187,   111, -3187,
   -3187, -3187, -3187, -3187, -3187,  1518,  1289, -3187, -3187,   126,
   -3187, -3187, 35992, -3187, -3187, -3187, -3187,  1652,  1420,  1301,
    1303,  1306, 13435, -3187,  1313,  1315,  1324, 10595,  1327,  1330,
    1335,  1364,  1366,  1384,  1393,  1402,  1415,  1415,  1418,  1421,
    1434,  1439,   963,  1467, -3187,  1470,  1483,  1490, -3187, -3187,
    1491,  1492,  1493, -3187,  1495,  1498,  1503, 10595,  1504,  1507,
   -3187,  1508,  1509,  1512,  1513,  1514,  1515,  1516,  1517,  1519,
    1526, -3187, -3187, 10595,  1528, -3187, -3187,  1532, -3187,  1533,
    1538,  1539,  1540,  1543,  1544,  1545,  1549,  1551,  1555,  1556,
    1558,  1560,  1561,  1562,  1563, -3187,  1001,  1565,  1566,  1022,
    1567, -3187,  1568, -3187,   217,  1571,  1415,  1415,  1415,  1572,
    1576,  1577,  1578,  1579, 13435, 13435, 13435,  7755, -3187, 35992,
   -3187, 35992, -3187,  1334, -3187, -3187,  1633, -3187,   291,  1390,
    1179,  1088,   277,  1359, 13435,  1894,   745, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187,  1452, -3187, -3187, -3187, -3187, -3187,
    1581, -3187,  1391,   238,  1995,  1900, 18986, -3187,  1224, -3187,
    -148, -3187, -3187,  1815, -3187, -3187, 35992, 27772, 18986, -3187,
   -3187, -3187, 16777, -3187, -3187,  2029, -3187,  1535, -3187, 18986,
    1475, -3187,  1754,  1732,    59,  1634, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  1593,   652, -3187, -3187,
   -3187,  2003, -3187,  1725,    22,  1654, -3187,  1594,   278,    22,
   28320,  1916,  1145, -3187,   214, -3187,  1990, -3187, -3187,  1699,
   -3187, -3187,  1700,  1702,  1893,  1688, -3187, -3187,   267, -3187,
      98, -3187,   527,  1916,    22,  1145, -3187,  1917,  2027,   417,
    -111, -3187,   748, -3187, -3187,  2090, -3187, -3187, -3187, -3187,
   -3187, -3187,  1652, -3187, -3187,  1602, -3187,  1841,  1703, -3187,
   -3187,   110, -3187,  1607,   609, -3187,   736, 28868, -3187, -3187,
   -3187,   118,  1845, -3187, -3187,  2169, -3187, -3187,  1612,  2087,
    2087,  2087,  2183, -3187, -3187, -3187, -3187, 27772,  1769,  1651,
   18986,  -149, -3187, 32704, 18986, -3187,   212, 10595, -3187, -3187,
    1748,   193,   176, -3187,  2138,  1803, -3187, -3187, -3187, -3187,
    2045, -3187, -3187,  2169,  2102,  2087,  1415,  1627,  2001,  1636,
   -3187, -3187, -3187,  1365, -3187, -3187, -3187, -3187, -3187,  1667,
   -3187, -3187, -3187,  1286, -3187, 18986, -3187, 18986, -3187,  1640,
   -3187,  1642, -3187, -3187,  1649, -3187, -3187, -3187, -3187, 18986,
    1342, -3187, -3187,     4,  2078, -3187, -3187,  1657,   104, 18986,
    1650, -3187, -3187, -3187, -3187, -3187, -3187,  2179, -3187, -3187,
   -3187,  1684,  1669, -3187, -3187, -3187, -3187, -3187, -3187,  1767,
   -3187, -3187, -3187,  1680, -3187,  1680, -3187, -3187,  1680, -3187,
   -3187,  1680,   700,  2752, -3187, -3187, 35992, -3187, 36540, -3187,
   16777,  -135, 10595, 10595,  1097,  2181,  2239,  2239,  2239, -3187,
    1709, 10595, 10595, -3187, -3187, 10595, 10595, 10595,  1189,  1689,
   -3187, -3187,  8323, -3187,  1690, 10595, 10595,  1770, 10595,  1452,
   10595, 20088,   772,  1894, -3187,   367,  2139, 10595, 10595, 10595,
   -3187, 10595, -3187, -3187,  2251, -3187, 20088,  1218, 10595, 10595,
    1280, 10595, 10595, -3187, -3187, -3187, -3187,  8323, -3187, 10595,
   10595, 10595, -3187, 13435, 10595, 10595, 10595, 10595, 10595, 10595,
    2239,  2239, 10595, 10595,  1442,  8323, -3187, 10595,  1452,   644,
     644, 10595,  1452,  6619, 10595, -3187, -3187, -3187,  1697, -3187,
   -3187, -3187, 20088,  2239,  2239, 10595, 10595,  2181,  2181,  2181,
   -3187,  7755,  1105,  1701, 10595, 21190,  1693, 10595, -3187, -3187,
   -3187, 13435, -3187, -3187,   773, -3187, -3187, -3187, 11163, 13435,
    1704, 13435, 13435,  2028, 13435,   937, 13435, 13435, 13435, 13435,
   13435, 13435, 13435, 13435, 13435, 13435, 13435,  2181, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  1711,
   -3187, 30512, 13435, -3187, -3187, 35992, -3187,  1997, -3187, -3187,
    2026, -3187,  2002,   177,  1707, -3187, 18986, -3187, -3187, -3187,
    1922,   676, 30512, -3187, -3187,   168, -3187,  1782,  1712,  1783,
    1713, -3187,  1786, 18986, 18986, -3187, -3187, -3187, -3187,   898,
     198,  1715,   925, -3187, 35992, -3187,  1453, -3187, -3187, -3187,
    1718, -3187, 10595, -3187,  1719, -3187,  1206,  2069, -3187,  -135,
   10595, -3187, -3187,  1728,  1365, 35992, 35992, 35992, 18986, 18986,
   -3187, -3187, -3187, -3187,  1147, -3187, -3187, -3187, -3187,    22,
   35992, 35992,    22, 27772, -3187, -3187, -3187,  2121,  1145, 35992,
      22, -3187, -3187,  1145, -3187, -3187, -3187, 18986, -3187, -3187,
    1145, -3187, -3187,  1145,  1145,    22,    22,  1771, -3187, -3187,
    1723, -3187,  1771,  1852,   939,   189,  1940, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187,   596, -3187, -3187,
   -3187, -3187, -3187, -3187,   146, -3187, -3187, -3187,  1542,   194,
   -3187,  1902,  1500,   690, -3187,  1500,   715,  -135, -3187, -3187,
   -3187, -3187,  2093, -3187,   779, 18986,   176,  -135, 18986, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  1731, -3187,  1733,  1734,
   -3187,  2156,  2158,  2160,  2161,  2162,  2164,  2166,  2167,  2168,
    2172,  2177,  2178,  2180,  2182,  2185,  1744, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,  1799, -3187, -3187, -3187, -3187,
    1252, -3187, -3187, -3187,   118, -3187,  1777,  1802, -3187, 30512,
    2284, 27772, 35992, 35992, 35992,  2157, 18986, -3187, -3187,   972,
    2004,  1640, -3187,   684, 35992,  2159, 23388,   131, 10595, -3187,
       4, -3187, -3187, -3187, -3187,   117, 27772, -3187, -3187, -3187,
     104, 30512,  1765, -3187, -3187,  1959,  1846, 18986, -3187, 35992,
   -3187, -3187, -3187, -3187, 17328, 17328, -3187, 17328, -3187, -3187,
     197,   219,  1673,  1792, -3187, -3187, -3187,  1776,  1772, -3187,
    2239,  1778, -3187,  1780,  1784,  1785, 10595,   100,  2327,  1787,
     960,  1788,  1789,  1781,   468, -3187,  1790,  1797, -3187,  1793,
   -3187,  1791,  1794,  1796,  1798,  1800,  1795, -3187,  1804,  2189,
    1805, -3187, -3187, -3187, -3187,  1801, -3187, -3187,  1806,  1807,
    1808,  1809,  1811,  1812,  1814,  1817, -3187,  2239,  1816,  1819,
    1821,  2239,  1822,  1824,  1826,  1827,  1828,  1829,  1830,  1831,
    1832,  1833,  1835,    24,  1836,  1837,  1838,  1839,  1840,  1842,
    1844,  1847,  1848,   204,  2239,  1850,  1851,  1155,  1853,  1854,
    1856,  8891,  9459, 10027,   174,  1857, -3187,  1859, -3187,  1795,
    1861,  1862,  1157,  1863, -3187,   772, -3187, -3187, -3187,  1849,
     918, -3187,  1919, 35992, -3187,  1320,  1698, -3187, -3187, -3187,
   -3187, -3187,   675, -3187,  1834, -3187,  1858,   140,  7755,   803,
    1855, 13435,  1390, 13435,  1865, 13435, 13435,  1179,  1088,  1088,
     277,  1894,   277,  1894,  1359,  1359,  1359,  1359,  1359,  2181,
   10595, -3187,  2181,  1866,  1038, -3187, -3187,  2147, 18986, -3187,
      20, 18986,   176,  1868,  1868,  1199, -3187, -3187,  1869, -3187,
   10595,  -135, -3187, 35992, 27772, 27772, 18986, 18986,   211, -3187,
    1103, -3187,  -135,  2193, 17328, 17328, 17328, -3187, -3187, -3187,
   -3187, -3187,   738, -3187, -3187, -3187,  1867, -3187, -3187, -3187,
   -3187, -3187, 33252,   113, -3187, -3187,  -135,  2192, -3187, -3187,
    1871, 35992, -3187, -3187, -3187, -3187, -3187,   997,   997, -3187,
   -3187, -3187, -3187,   -26, -3187, -3187, -3187, -3187, -3187, -3187,
    1927,    22, -3187, -3187,    22,  1145, 18986,    22,    22, -3187,
   -3187,  1195, -3187,   748, -3187, -3187, -3187, -3187, 35992,  1360,
    1974,  1874, -3187, -3187, 18986, -3187,  1875, -3187,  2244,  2369,
    1916, -3187, -3187, -3187,   117,   117,   611,   285,  1923,  1458,
    -135,  1980,  1991,  1994,  1996,  1999,  2030, -3187, -3187,  -135,
    -135, -3187, -3187, -3187,   938,  -135,  -135,  -135,  -135,  1260,
    -135,  -135,  1164, -3187, -3187, -3187,   222, -3187,   268, -3187,
    1325,  2392,  2108,   117,   117,  2392,   117,  2110,  2111,   117,
     117,  1968,  2346,   117,  2241,  1988,  1275,  2243,   117, -3187,
    1998,  2355,   117,   117,   117,   117,  2392,  2124,  2433,   117,
   -3187,   117,  2129,  2142,   200,  2141,  2146,   117,   873, 35992,
     117,   117, -3187, -3187,  3058, -3187, -3187, -3187, -3187, -3187,
   -3187,   980, 17882, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, 33800, -3187, 10595,  1260,  -135,  -135,   688,  -135,  1260,
    -135,  -135,  -135,  -135,  -135,  1260,  -135,  -135,  1260,  1748,
   -3187, -3187, -3187, -3187,   545, 30512,  2250, -3187, -3187,   -44,
   -3187, -3187, -3187,  1478, 35992, -3187,  3586,   401,   401, -3187,
   18986,  1966,  1792, 23388, -3187,   939, -3187,  1928, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, 30512, -3187, -3187, -3187,  1650,
    2253, -3187,  1937, -3187, -3187,  1170, -3187,  1933, -3187,  1935,
    2013,  2014,  2015, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,  1916,  1103, 11731, -3187,  1945,
   -3187, 10595, -3187, -3187, -3187,  2025, 10595, 10595,  2377,   826,
   -3187, 29416, -3187, -3187, -3187, 10595, 29416,   826, -3187, -3187,
    1949, -3187,  2303,  2303, -3187, -3187, -3187, 35992, -3187, 10595,
   -3187, 10595, -3187, -3187, 10595, 10595, 10595, -3187, -3187, 13435,
   20088,  1953, -3187, -3187, -3187,  1954, -3187, 10595, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, 10595, -3187, 10595, -3187, 10595,
   10595, 10595, -3187, -3187, -3187, -3187, 12299, 10595, 10595,  1955,
   -3187, -3187, -3187, 10595, 10595, 10595, -3187, 10595,  2351, 10595,
    2352, 10595,  2353, 10595, -3187, 10595, -3187, -3187, -3187, -3187,
   10595, -3187, -3187, -3187,  1960,  1961, -3187,  1962,  1963,  1964,
   30512, 10595, -3187, -3187, -3187, 10595, -3187, -3187, 10595, -3187,
   -3187, -3187, -3187,   772, 13435,  1188,  1971, 13435, -3187,  1855,
     141,  7755,   803,  1855, -3187, -3187, -3187,  1972, -3187, -3187,
    1973, 35992,  2041,  1975, -3187, -3187,  1992,  2295, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187,  2073,  1868, 35992, -3187, -3187, -3187,
    2050, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,    90,
   -3187, -3187,  1981,  1981, 15673, -3187, -3187, -3187, -3187,  2212,
    2378,  2379,  2380,   736, -3187,   256, -3187,   172,  2337,  1916,
   -3187,  2382, 31060, 23936, -3187,  1982,  2335,  1984,   117, 26128,
     149, 21740, 26676, -3187, -3187,   688, -3187,   142, -3187, -3187,
   -3187, -3187, -3187, -3187,  1147,  1147,  2011, -3187, -3187,  1792,
    1145, -3187, -3187, -3187,  1993, -3187, -3187,   939,  2338,  2339,
   -3187,  2222,    70,  2222,   939,   939, 20088,   939,   220, -3187,
    1260,  2275, -3187, -3187, -3187, 29964, 27224,  2205, -3187, 10595,
   10595,  2240, 35992, -3187, -3187,  2499, -3187, -3187, -3187,  2475,
   -3187,  2481,  1169, -3187, -3187,   117,   614, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,   715,   117,   117,   213, -3187,
   -3187, -3187, -3187, -3187, -3187,   121, -3187, -3187, -3187, -3187,
   -3187, 20639,  1353,  1168,  1353, -3187,   154,   206, 20639, -3187,
   -3187, 20639,  1168,   688,  1260, 20639,  1260, 34348,  1168,  -135,
    -135,  1708,   117,  1260, -3187, -3187,  2356, 35992,  2357, 20639,
   20639, -3187, 30512, -3187,   117,  1357,  1260,   688,   688, 20639,
    1168, 20088,   971,  1619,  -135,  1168, -3187, -3187, -3187, -3187,
   18986,  1168,  1168,  1387, -3187, -3187, -3187, 30512,  2012, -3187,
    4528, -3187, -3187, -3187, 15122, 35992,   288,   473, -3187,  2009,
    2019, -3187,  1211, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,   117,   117,   117,   117,
     605, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  2252,
    2403, -3187,   336,  2103, -3187,  2259,  2024, -3187, -3187,   190,
   -3187,  2019, 18986, 14571, -3187,  2248, -3187,  1056, -3187, -3187,
   -3187, -3187, -3187, -3187,   939,  2254,   762,  1792,  2031,   131,
   -3187, -3187, -3187, -3187, 35992,  2035, 24484, 27772, 27772, 27772,
    2036, 10595, -3187, -3187,  2261, 10595,  2034, -3187, -3187, 10595,
   -3187,  2115, -3187,  2038,  2038, -3187, -3187,  2042,  2038,  2393,
   -3187,  2396,  2047, -3187,  2049, -3187,  2051,  2055,  2057, -3187,
   -3187,  1894,  1894,  2052,  2060,  2061,  2254,  2062,  2066,  2068,
      45, -3187, -3187, -3187,  2070,  2071,  2072,  2075,  2077,  2076,
    2080, 10595,  2083,    65,  1222, -3187,  2084,  2085,  2086,  2089,
   10595,  2091, 10595,  2092, 10595,  2094,  2095,  2096, -3187, -3187,
   -3187, -3187, -3187, -3187,  2056, -3187,  1334, -3187,  2097, -3187,
   -3187, -3187, -3187,   745, 13435,  1235,  2098, -3187, -3187, 10595,
    2109, -3187,  2099, -3187, -3187, -3187, -3187, 18986,  2434, -3187,
   -3187, 13435,  2611, -3187, -3187,  2114,  2116, -3187, -3187, 27772,
   -3187,   652, 20088, -3187,  2117, -3187,  2117,  -101,  2119,  1243,
   -3187, -3187, -3187,  2105,  1634,  2504, 27772, 27772, 27772, -3187,
    1792,  1792,   706,  2165,  2464, -3187, -3187, -3187, -3187, 34896,
   -3187, -3187, -3187, -3187,  1049, 35992,  2451, 35992,  7187, -3187,
   -3187,  2623, 10595, 27772,   942,   918,   117, -3187, -3187, -3187,
   -3187, -3187, -3187,  1916, -3187, -3187, -3187, -3187,  2429, -3187,
      22,  1195,  -167, -3187,  1477, -3187, -3187, -3187,  2467,   939,
    2222,  2222,  2468,  2363,     3,  2126, -3187,   117,  1360,   686,
   -3187,   652, -3187, -3187, 10595, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  1894,  2621, -3187, -3187,  -135,  2571, -3187, -3187,
   -3187, -3187,  1024,   938, -3187, -3187,  1024,  1024,   222, -3187,
     268, -3187, -3187, -3187, -3187, -3187, -3187, 10595,  2471,  2474,
    1353, -3187, 20639, -3187, -3187, -3187,   148, 34348, -3187, -3187,
   -3187, -3187, -3187, -3187,  2134, -3187, -3187,  1199, -3187, -3187,
   27224,  -135, -3187, 20639,  2134, -3187, -3187,   346, -3187,  -135,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, 34348,  2135,
   -3187,  1406, -3187, -3187, -3187, -3187, 34348, -3187, -3187, 34348,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, 18986,  1244,
    1299, -3187,  1247, -3187, -3187, -3187, -3187, 35992, -3187, -3187,
   18986, -3187, -3187,  5050, 35992, 35992,  2685, -3187, 35992,  -135,
    1199,  1024,  1024,   545, -3187,  2140, 35992,   117,   216, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  2287,
   -3187, -3187, -3187, -3187,  2381,   -82,  2688, -3187, 18986,  2662,
   -3187, -3187,  1272, -3187,  2850, -3187,  2143,  1792,  2470, -3187,
   -3187, -3187, -3187, -3187,  -110,  -110,  -110, 12867, -3187,  2583,
   -3187,  1894, -3187, -3187, 10595,  2390, -3187,   201,  2394, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  2149,
    2150,  2153, -3187, -3187,  2298, -3187, 10595, 10595, -3187,   320,
    2171,  2176, -3187, -3187, -3187, -3187, 10595, -3187, -3187,  1894,
   -3187, 10595, -3187, -3187, 10595, -3187, 10595, 10595, -3187,  2174,
   -3187,  2175, -3187,  2184, -3187, -3187, -3187,  1634, 35992, -3187,
   -3187,  2187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,   663,
   -3187,  2492, -3187, -3187,  1855,  2485,  2163, -3187, 35992, -3187,
    1593,  2195, -3187,   117, 12867,  1981,  2305, -3187, -3187,  -101,
   20088, 23936, -3187, 27772,  1636,  1636,  1636,  1916,  2545,  2041,
    2041, -3187, 22290, -3187, -3187,  2300, -3187, -3187, 25032, -3187,
       8, -3187, -3187, 13435,  1470, -3187, -3187, -3187, 29964, -3187,
   -3187,   117,  2173,  2186, -3187, -3187, 35444, 10595, -3187,  2590,
   -3187, -3187,  2188,   939,  2401,   939, -3187,  2510,  2511,   939,
   -3187, -3187, -3187, 20088,  1792, 12867,  1353,  1353,  1353, -3187,
    1593, -3187,  2196,  1406, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,   -45, -3187, 20639, -3187,
   -3187, -3187,  2191,  2634,  2635, -3187, 20639,  1252, 35992, -3187,
    2623, -3187, -3187, -3187, -3187,  5050, -3187, 20088, -3187, -3187,
   -3187, -3187, 35992, -3187,  1278, -3187, 15122, -3187, -3187, -3187,
    2194,  2199,  2038, -3187, -3187, -3187, -3187, -3187,  2042,  2385,
   -3187,  2042,  2042, -3187, -3187, -3187, -3187, -3187,   201,   295,
   -3187, -3187,   201, -3187, -3187, -3187,   127,  1146,  2042, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  2038,  2038, -3187, -3187,
   -3187,   201,  2203, -3187,  2038,  1058, -3187,   166,   129,  2204,
    2206,  2038,  2207,  2198, -3187,  1283, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187,   715, -3187,  1024,   336, -3187,   285,   710,
   -3187,   811, -3187, -3187, -3187,  2209,  2305,  3058,    82, -3187,
   35992, -3187,  1147, -3187,   304,  2200,  2200,  2200,  1470, -3187,
    1298, -3187, -3187,  2210, -3187,  2211,  2714,   169, -3187,  2714,
   29416, -3187,  1321, -3187, -3187, -3187,   189,  2213,  2214,  2217,
    2453,  2521, -3187,  2389, -3187,  2220,  2221,  2225,  2226,  2229,
    2231, -3187, -3187, -3187, -3187, -3187, -3187,  2232, 31060, -3187,
   -3187, -3187,  2563, -3187,  2234,  1087,  2437, -3187, -3187,  1718,
   20088, 12867,  2235,  2237, -3187,   609, -3187, -3187,  2236,  1636,
   -3187,  2761,  2620, -3187, -3187, 30512,  2245, -3187, -3187,  2515,
   -3187,   158,  2438, -3187, -3187, -3187,   942,  2329,  2331,   117,
   -3187,  -135,  2391,  1874,  2593,  1261,  2290,   939,   939,  1705,
    2292, 10595, 10595,  2257, -3187,  2254, -3187, -3187, -3187, -3187,
   -3187,  1718, 10595, -3187,  2364, -3187, 41472,  1199,  2437, -3187,
    2260,  2262, 35992, -3187,   930,  1252,   288, -3187, -3187, -3187,
    1058,  1168, -3187, -3187,  2134,    90, -3187, -3187,   583,  2500,
    2502, -3187,   496, -3187,  2263,   496,   496, -3187,  1725, -3187,
    2293,   201, -3187, -3187,  2294, -3187, -3187, -3187,   496,  2267,
     201, -3187, -3187,  2509,   496, -3187, 30512,  -135,  1553, -3187,
    2314, -3187,  2727,  2612, -3187,  1058, -3187,  2613,  2517, -3187,
    2520, -3187, -3187,  2524, -3187,  2525,  2526,   496,  2528, -3187,
     496, 35992, -3187, 35992,  2297,   788,  1339, -3187, -3187,  2240,
   -3187, -3187, -3187,  2296,  2274, -3187, -3187, 18986, -3187, -3187,
   -3187, -3187,  2414, 35992,  2297, -3187,  2302,  2248, -3187,  2840,
    1341,  1406,  2299, -3187,  2375,  2376, -3187, -3187,  2386, -3187,
   -3187,   116,  1506, -3187, -3187, -3187, -3187, 12867,  2640, -3187,
   -3187, -3187, -3187, -3187, 29416, -3187, -3187,  2714, -3187,  2537,
   -3187, -3187, -3187, 10595, -3187,  2574,  2719, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  2308,  2312,
   -3187,  1344, -3187,  1311, -3187, -3187, -3187, -3187, 10595, -3187,
    2254,  2815, -3187, 22290, -3187, -3187, -3187, -3187, -3187,  2317,
    2318,  7187,  2869, -3187,   939, -3187,  2360, -3187, -3187, -3187,
    2361, -3187, -3187, 35992,  2470,  2332,  1311,  1406, 10595,  2757,
    2358, 35992,   775, -3187, 42568, 42568, 35992, -3187, -3187, -3187,
   -3187,  4602, -3187, -3187,   155, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,  2322, -3187, -3187,  1349, 35992,
   35992,  1352,   996,   996,   996,   709,   709, -3187, -3187, -3187,
   -3187, -3187,  1252,  2683, -3187,   859,   159, 35992, -3187, -3187,
     630, -3187,  2341,  2344, -3187, -3187, -3187, -3187,   496, -3187,
     189, -3187, -3187, -3187, -3187, -3187,   189, -3187,  2345, -3187,
   -3187, -3187,  1415, -3187, -3187,  2585,  2373, -3187, -3187, -3187,
   -3187,  2347,  2348,  2350,  2354, -3187,  2359, -3187, -3187, -3187,
     991, -3187, -3187, -3187, -3187, -3187,  1458, -3187, -3187,   722,
   35992,  2747,  -135,  2362,  2366, -3187, -3187, -3187, -3187, -3187,
   -3187,   793,   616, 35992, -3187,  2597, -3187, -3187, -3187, -3187,
     251,  2587,  1260,  1260,  1260,  1260,  1506, -3187, -3187,  2402,
   -3187, -3187,  2365,  2370, -3187, -3187,  2444, -3187, -3187, 35992,
   35992, -3187,  2437, -3187,   172, -3187,  1006,  1406, 10595,  1916,
     841,  2684, -3187, -3187, -3187, -3187,  2668,  1714, 10595,  2374,
   10595,  2384,  1358, -3187, -3187, 33800, -3187, -3187, -3187, 10595,
   -3187, 10595,  2387, -3187, -3187,  2763, 35992, -3187, -3187, -3187,
   -3187, 10595, -3187, -3187, 41472, 41472, -3187, -3187, -3187, -3187,
    1368,  1375,   616, -3187, -3187,   288, -3187,  2395, -3187, -3187,
   -3187,   568,   568,  1379, -3187, -3187, -3187, -3187, -3187,  1394,
   -3187,  1399, -3187, -3187,  1415, -3187,   201,  2714,   201,  2714,
    2879,  2606,  2883, -3187,  -112,  2499, -3187, -3187,  5050, -3187,
   -3187, -3187, 35992,  5050,   609,    82,  2305, -3187,   117,  2596,
   -3187,   616, -3187, -3187,  1406,  2399, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, 20088, -3187, -3187, 18986, 13435,  2476,  1404,
   -3187, -3187, -3187, -3187, -3187, -3187,   426, 10595, -3187, -3187,
   -3187,  2581,  2905,  2906,  2817,  2910,   841, -3187,  1044, -3187,
    2819, -3187, -3187, 35992, -3187, 35992, -3187, 35992,  2400,  2405,
   -3187, -3187, -3187,   103, -3187, -3187,  2753,  2831, 10595, -3187,
   -3187, 38732,  2397, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, 42020, 10595,   155,  2589,   616, -3187,
   -3187,  2437, -3187,  2964, -3187,   735, -3187, -3187,   630, 35992,
     201,   189,   201, -3187, -3187, -3187, -3187, -3187,  2639, -3187,
    2641, -3187,  2409,  2852,  1564, -3187,  2847,  2575, -3187, -3187,
   -3187, -3187,  2413,  1634,  1260,   974, -3187, -3187, -3187,  2415,
   -3187,   117, -3187, -3187,  1199, -3187, -3187, 35992,  2450, -3187,
   -3187,  1406, 35992, -3187,   189,   189,  2939,   189, -3187,  2940,
    2941,  1044, -3187,   688, 10595,  1410,  1412, -3187, -3187,  2445,
   10595, 41472, -3187,  2851, -3187,  2789,  2505,  2887,  2736,  2423,
   -3187,  2424,  2872, 42568, -3187, -3187,  1422, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187,   609, -3187, -3187,
   -3187, -3187,  2882, 41472,  2588, -3187, -3187, -3187, -3187, -3187,
   20088, 12867,  2815,  2439, -3187,  2476, -3187,  1180, -3187, -3187,
   -3187, -3187, -3187,   189, -3187,   189,   189, -3187,  2988,  2440,
   -3187, -3187, -3187,   167, -3187, -3187, 39280,  2956, 35992, -3187,
   -3187, 31608, 39828,  2435, -3187, -3187, 10595, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  5050,   609, -3187, -3187,
    2684, -3187, -3187,  2446,  2523,  1057,  2447, -3187, -3187, -3187,
    2749, -3187, 10595, -3187,  2878,  2529, -3187,  2448, -3187, 41472,
   -3187, -3187,  2832,  2452,  1482, -3187,  2449, -3187,  2884, 41472,
   41472, -3187, -3187,  2820, 13435,   546,   117,  2907,  2908,   117,
     117,   117,   117, -3187,  1057, -3187,  2888,  2457,  2885, -3187,
    2973, 41472, 35992, 37088,  2861, 35992,  5050,  2862,  2864, -3187,
    2637, 40376, -3187, -3187,  2710,  2472,  1425, -3187, -3187,  1855,
   -3187, 14003, -3187, -3187, -3187,  -135,   117,   117,  1055,  1055,
    1199, 30512,  2473, -3187,   117, 10595,  2469,  2477, -3187,  1260,
    2554, -3187, 37636, -3187,  1629, -3187, -3187,  2936,   969, -3187,
   -3187,  2501,  1564,  2807, 16224,  2622, -3187, 13435,  2483,  2484,
   -3187,  -135,  -135, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187,  2582, -3187, 30512, -3187, -3187, -3187, -3187, 41472, 41472,
   -3187, -3187, 25580, 10595, -3187,  2527, -3187, -3187, -3187,  4602,
   -3187, 41472, -3187, -3187, 30512,  1436, -3187, -3187, 20088, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  1456, -3187, -3187, -3187,
   38184, 40924, -3187, -3187, -3187, 22840, -3187, -3187,  2886, -3187,
   -3187, -3187,  1452, -3187, -3187, -3187, -3187, 18433,  2415, 30512,
   -3187,  2582, 25580, -3187, -3187, -3187, -3187,  1057, -3187, -3187,
   -3187, -3187
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3187, -3187, -3187, -3186, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  1191, -3187, -3187, -3187, -3187, -3187,  1227, -1579,
   -3187, -3187, -3187, -3187, -3187, -3187,    84,   876, -3187, -3187,
      85, -3187,  -332, -3187, -3187, -3187, -2079,  -460,  -652, -3187,
   -3187,   196,    31, -3187, -3187, -3187, -3187, -3187, -3187,  2170,
    -776, -2760, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187,  -338,  -463, -3187, -3187,  -329, -3187, -3187, -2480, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187,  -807, -3187,  -890,
   -3187, -3187, -1267,   -33, -3187,   -30, -3187,   -28, -3187,   -27,
   -3187,   -25,   -24,   -21,   -20, -3187,   -19, -3187, -3187,  -830,
   -3187, -3187, -3187, -3187,   -18, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  -664, -3187, -3187,  -502, -3187, -3187,  -661,    -9,
   -3187, -3187,  -518, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,  2190, -3187, -3187, -3187,
   -1758, -3187, -3187, -3187, -2388,  1759, -3187, -3187, -1780, -3187,
   -3187, -3187, -2047, -3187, -3187, -3187, -1811,    92, -3187, -3187,
     743,   899, -3187, -1693, -1691, -1678, -3187, -3187, -3187, -2192,
   -2172,  -593,  1681,  -943, -2269, -3187, -3187, -3187, -3187, -3187,
   -3187,  -435, -3187, -3187, -2218,  1760, -3187, -3187, -3187,   860,
   -3187, -3187, -3187, -3187, -3187, -3187,   319, -3187, -3187,   318,
   -1407, -3187, -3187, -3187, -3187, -3187, -3187,  -560,  -449,  -626,
   -3187, -2949,  -331, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187,  -777,  -739, -3187, -3187,  -841, -3187, -3187,
    -846, -3187,  -702, -2020, -3187, -3187, -3187,  1730, -3187,  1810,
   -3187,  2669, -3187,  -456,   143,  1337, -2076, -1254,  -727,  -687,
   -1842, -3187, -3187,  -168, -3187, -3187,   806,   226,  1336, -1656,
     870,   933, -3187, -3187,   254, -3187, -2820, -3187, -3187, -3187,
     218, -3187,   223, -3187, -3187, -3187, -1024,   179, -1281, -3187,
    -214, -2222, -3187,    26, -3187,   -17, -3187,  -504, -1864, -1941,
   -3187, -3187,    -5,   264,   327, -3187, -2761, -2790, -3187, -3187,
    -459, -3187, -3187, -3187,  -471, -3187,  -191,  -342, -3187, -3187,
    -884, -1830, -3187, -3187, -3187, -2303, -3176, -3187,  1752,  -379,
    1317, -2087,  -250, -2081, -3187,  -202, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  1367, -1033, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -2096,   281, -3187, -3187,   912, -3187, -3187, -3187, -1612,
    -347, -1374, -2850, -3187, -3187, -3187, -3187, -3187, -3187,  1143,
   -3187, -3187,  1484,  1873, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187,    46,  1110, -3187, -3187, -3187, -3187,
   -3187, -3187, -1317,  1813, -3187, -3187, -3187,    -3, -3187, -3187,
   -3187, -3187, -3187,  1552, -3187, -3187, -3187,  2256, -3187, -3187,
   -3187, -3187,   734,  1148, -3187, -3187, -3187,  2286,  1101,  -530,
   -1533, -3187,  2655, -3187, -3187, -3187, -1439, -2147, -3187,  2367,
    -252, -2431,  1559,  -935, -2684, -3187,   161,  -659,  2929, -3187,
   -3187, -1044, -3187, -3187,  -653, -3187, -3187, -1075, -1078,  2039,
    2048,   615,   659,   789, -3187, -3187,  -570, -3187, -3187, -3187,
   -1037,  -628, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187,   420, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187,   102, -3187,  1288, -3187,
    -981, -3187, -3187, -3187,  2128, -3187, -3187, -3187, -3187, -3187,
   -2040, -1694,   363, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -2049, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -1522, -3187, -1892, -3187,  -931, -3187, -3187,  -258, -3171,  -937,
     917, -3187, -3187, -1169,  2197, -1776, -3187, -3187, -3187,  1186,
   -3187, -3187, -3187, -3187, -3187,   312, -2246, -1249, -3187, -3187,
   -2726,  -815, -1844,  -805, -3187, -2014,   -84, -1690, -1598, -2061,
    -648, -1828, -3187, -3187, -3187, -3187, -3187,  -694, -3187, -3187,
   -3187,   -60,  1126, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
    -538,  -398,  1077, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  2201,  2000,  1319, -3187, -3187, -2197, -3187, -3187,
    1144, -3187,   171, -2018, -1581,   421, -3187, -3187,   424, -2757,
   -3187, -3187, -3187, -3187, -3187, -3187,   366,  -708,  -507,  2702,
   -3187, -3187, -3187, -3187, -3187, -3187,  2258,  1818, -1676,  2636,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,  1569,
    2718,  -508, -1128, -3187,  -588, -3187, -3187,  -780, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187,  1820, -3187, -3187,
   -3187, -3187, -3187,  2005, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,   451,
    -499, -3187,  -341,  -544, -3187,  -443, -3187, -3187, -3187,  -718,
   -3187,  -662,  -892, -1234,    83, -1775, -1296,   440,  2006, -2944,
    -955, -1094, -1110, -2000,    67, -3187,  2349,     9,  -486,  -763,
      -7, -2966,  -117,  -580, -3187, -1940, -3187, -3187, -3187, -3187,
    1595, -3187, -3187, -3187, -3187,   739, -3187, -3187, -3187,   407,
   -3187,   173,   -35, -3187, -3187,   240, -3187,  1639, -3187, -3187,
   -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187,  2020,  2745,  2443, -3187,  2238, -3187, -3187, -3187,
   -3187, -3187,  -166, -3187,    15, -3187, -1580,  1864,   694, -3187,
     914,  -655,  -944, -3187,  -171, -3187, -3187,   911,  2764,  2454,
   -3187, -3187, -3187, -3187, -3187, -2413,  -808, -3187, -2462, -3187,
   -3187, -3187, -3187,  -966, -3187, -3187,  2144,   235, -3187, -3187,
     -85, -3187, -3187,  -140, -3187,  2712,  2309, -3187,   957, -3187,
     296, -3187, -3187,    75, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187, -3187,  1113, -3187, -3187, -3187, -3187, -3187, -3187,
   -3187, -3187
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2270
static const short int yytable[] =
{
     435,   893,   868,   940,   551,  1320,   864,  1238,  1051,  1053,
    1059,   983,  1548,   473,   134,  1523,   479,  2051,   474,  1403,
    1404,  1992,  1405,  2340,  1035,   492,   986,   490,  1547,  1808,
    1674,   931,   932,   498,  1610,   504,  1266,   886,   886,   886,
    1424,   886,  1355,   886,  2512,  1088,   521,  2374,  1285,  2181,
    1086,  2352,  2377,  2190,  2468,  2197,  1867,  2198,  1266,  1260,
    2842,  2802,  1470,  1471,  1108,  1106,  1567,  1112,  1710,   988,
    2199,  1577,  2554,  1575,  1580,  3120,  2335,  1119,  1120,  1121,
    2498,  2502,  2504,  1490,  1286,  2533,   540,  2524,  1794,  2698,
     477,  1502,  3038,  1564,  2205,  2534,  1488,  2538,  3096,  3044,
    2516,  2517,  1515,  1516,  1517,  2691,  1485,  2693,   543,   435,
     435,  1522,  2123,   435,   550,   556,  1127,  1128,  1129,   878,
    2674,  1506,  1591,  1593,  2275,  3482,  1489,  2585,   540,  2285,
     965,  2604,  3419,  2145,  2146,  2291,  1167,  3103,  2294,  2211,
    2675,  2302,  2717,  2215,  1024,  2186,  2721,   544,   545,  1024,
    1681,   547,  2588,  1427,  2230,  1684,  2014,  2434,  3297,  3328,
     539,  2337,  3172,   571,  2239,  1687,  1688,  3137,  3142,   832,
     833,  3143,  2213,  2214,  1326,  2216,  2615,  2616,  2219,  2220,
     952,  2339,  2223,  2139,  3144,  3483,  3006,  2232,  1155,  3232,
    3152,  2235,  2236,  2237,  2238,  1024,  3171,  1620,  2242,  3007,
    2244,  2573,   565,  2088,  1019,  2549,  2253,  2044,  2573,  2257,
    2258,  2586,  3008,  2577,  1327,  2590,  3231,  1219,  2247,  3236,
    -393,  3006,   832,   833,   883,   832,   833,  1322,  3275,  2606,
    2607,  1382,  1906,  2751,  3007,  3691,   502,  2186,  1024,  2617,
    2186,  2532,  1957,   131,  2064,  2487,  2186,  3008,  1858,   439,
     440,  2695,  1115,  2664, -2181,  1322,  -482,   832,   833,  1862,
    1249,   923,   483,  2739, -1337,  2577,  3340,  1716,  1025,   489,
    2797,  1230,  3501,  1025,  2883,   497,  2036,  1287,  1271,   501,
    2977, -1733,  2882,  3040,  -483,  2296,  2514,  1398,  1193,  2994,
    1281,  1862,  2186,  2529,  3265,  2041,  2647,  2872,  2873,  3691,
    1030,  2114, -1337,  2681,  2530,  3107, -1337,  2149,  2313,   530,
    2132,  3214,   585,  1196,  2790,  3006,  3619,  2503,   953,  1025,
    2070,  2578,  1149,  2981,  3447,  1421,   800,  2165,  3007,   576,
    1383,  1279,  2851,  1310,  1384, -2115,   133,  1343,  3478,  3479,
    2483,  3008,  2248,  2519,  1385,  1983,  1347,  1379,  1236,   133,
    1295,   832,  3138, -1586,  3034,  2564, -1586, -2116, -1337,  3049,
    2186,  3020,  1025,   643,  3214,  2064,   513,   582,   560,  1632,
    1254,  2667,  2574,  -561,  2576,  1967,   438,   511,   884,   935,
    3363,   512,  1346,  2480,  3071,   135, -1337,  1420, -1337,  3367,
    2608,  2481,  2970,  2971,  2860,  1427,  2037,   486,  2187, -2236,
    1161,  2682, -1337,  3072,  1225,  2296,  1116, -1337,  2569,  1197,
    3484,   886,  3685,  1706,  3686,  2637,  1353,  2099,  1348,  2165,
    2484, -1337,  2165,  1212,  1296,   514,  1255, -1337,  2165,  3101,
    2072,  2073,  3073, -1337,  2150, -1337, -2115,  2571,  1354,   550,
    2314,   556,  3705, -1337,   964,  2328,  1016,  3431,   936,  2648,
    2542,  1430,  1256,   531, -1337,   441,   600,  1401, -2116, -1337,
     556,  1386,  2065,  1491,  2796,  2100,  1492,   640, -1337,   638,
    3428,   801,  3215,   550,  2165,   648,  2674,  1424,  2531,  3041,
    2846,   540,   495,  2982,  1290,  3414,   982,   795,  2837,  1675,
    2187,  2667,  1678,  2187,  1198,  2190,  2675,  1402,   963,  2187,
    1683,  2881,  2197,  2019,  2198,  2020,   487,  1428,  2023,  1150,
     540,   880,  1711,  3669,  1311,  1689,  1690,  2199,  2579,  2855,
    3108,   642,  2892,  1579,  2589,  3215,  2591, -1337,   895,  1151,
    2852,  2297,  2577,  2602,  1421,  1304,   954,  1421,  1599,   906,
    1794,  2115,  2165,  1421,  1422,  2187,  2614,  1863,  1387, -1337,
     540,  3485,  2623, -1337,   540,   785,   484,  2119, -1337,  1282,
     929,  2699,   540,   540,  1602,  1380,  1250,   941,   906,  2038,
    -561,  3467,   550,  1193,  1572,  1162,  1995,  2884,  3111,  1863,
    1154,   966,  2573,  2065,  2562,   971, -1337,  2329,  3188,  1994,
     976,   435,   435,  3267,   906,   435,   550,  1326,   435,   550,
     540,  1154,  3056,  2573,  2523,  2566,  2567,  2302,   938,   939,
     924,  1717,  2016,  2187,  2296,  2066,  2972,  3622,  2989,  2670,
    3216,  2671,  1193,  3671,   916,   918,  1193,  3021, -1337,   977,
     978,  2752,  1225,   981,  2672,  1029,   985,  1327,  2847,  2848,
    2697,  2601,   813,  1907,  1257,  3620,  3592,   579,  2454, -1337,
    1020,  2297,  2488,  2609,  2024,  -393,  2025,  1421, -1337,  2890,
    2339,  3145, -2181,  1621,   816,  3276,   606,  1326,  1612,   955,
    2580,  1348,  3706,   725,  2296,  1272,  1152,  1696,   861,  3009,
    3502,   861,  3233,  2515,  2101,  1628, -1337,   861,  2570, -2181,
    3131,  -482,   797,  1679,  3173,  2249,  1154,  1154, -1337, -1337,
    3486,  1117,  1686,  3169,  2807,  2808,  3187,  1327,  3645, -2269,
    3752,  2683,   608,  3649,  3009,  2659,  2660,  2661,  2662,  -483,
    3218,  3569,  -561,  1263,  3150,  3151, -1337,  3635,  1280,  3637,
     787,  3170,  3154,  3953,  1153, -1337,  2066,  3769,   799,  3177,
    1984, -2115,  1134,  1348,  1136, -1586, -1337, -1337,  1172,  1428,
    2880,  2165,  2871,  1422, -1586,  3634,  1422,  3636,  1258,   881,
    1348,  3217,  1422, -2116, -1337,  1348, -1337,  2704,  2705,  2706,
   -2115,  1968,  1291,  3218,   817,  3051,  2468,  -722,  1348,   540,
    2568,   641,   488,  2976,  2674,  1292, -1337, -1337,  2874,  1217,
     550,   540, -2116, -1337,  2278,   540,  3086,  3110,  1661,  1214,
    3090,   861,   540,  2194,  2675,  3085,  3124,  1735,  3009,  3089,
    1191,  2165,  2875,  3076,  1173,   674,  2330,  1259,  3657,   886,
    2165,  1697, -1733,  1017,  1715,  1698,  1225,  3850,  3139,  2953,
     114,   933,  2009,   550,  2809,  1264,  3670,  1163,  1164,  1165,
    1177,  3538,   818,   443,  3708,   114,  1866,  1154, -2239,  3294,
     791,  2279,  2856,  1203,  3219,  1493,  3345,  2650,  1494,  2363,
    2297,  2390,  1617, -1608,  3040,  1222,  1421,   129,  1191,  3712,
     130,  3714,   679, -1609,  1444,  2190,  1422,  2197,  2573,  2198,
    1674,  1674,  2229,  2364,  3720,  2381,  2382,  2857,  3623,  1805,
    1321,  2308,  2199,   589,  1293,  2144,  2804,  2805,  2806,  1872,
   -1734,  2117,  1618,  3345,  2118,  1266,  1736,  2121,  2122,  2085,
     550,   115,  3346,   540,   496,  1294,  1351,   540,  3198,  3190,
    2297,  2991,  2365, -1733,   444,  2366,  1421,  2298,  3191,  2147,
    1568,  3190,  3354,  2367,  1709,  1421,  1181,  2379,   494,  2429,
    3191,  2280,  2841,  1182,   558,  3739,  3474, -2239,   590,  2017,
    1810,  2386,   503,  2086,   482,  -727,  3811,  2022,   540,  3346,
    1413,  2426,   690,  3060,  1548,   653,  3206,   116,  1583,  2539,
    2302,  3624,   540,  2148,  3779,  2670,  3572,  2671,  3213,  3733,
    2472,  2400,   540,  2205,   508,  2391,  3573,  2298,  1283,  3409,
    2672,   565,  2520,   117,  2254,  1916,  1806,  3625,  2010,  2889,
     445, -1734,  1339,  1340,   515,  3614,  1794, -1608,   516,   909,
     861,   522,  2281,   898,  1183,  3355,  3877, -1609,  1562,  1449,
     118,  1452, -1733,   540,  3449,  3331,  1548,  3199,  2230,  3332,
    1284,  3498,  1408,   706,  1412,  1917,   674,  1397,  3287,  3288,
    1456,  3520,  2537,   562,  2060,  2061,  1419,  2428,  2810,  2443,
    3521,  3356,   523,  3192,  1486,  2436,  2299,   910,  3709,  1737,
    3041,  3281,  2969,  1185,   591,  3192,  1445,  1738,   119,  1486,
     861,  1729,  3650,  1739,  1601,  2175,  1709,  2175,  3095,   861,
    2622,  1753,  1754,  3155,  1192,  1422,  2975,   678,   792,  3475,
     938,   939,   518,   679,  2439,  1619,  1569,  1997,   934,  1634,
   -1734,   819,   820,   821,   822,   823,   824,  2451,   460,  1459,
    3397,  3851,  -679,  -679,  1756,  1549,  2299,   524,   825,   683,
    1847,  -679,  3720,  3156,  1236,  1759,  3816,  3157,   550,   911,
    2045,  1548,  2176,  1760,  2176,  2368,  1298,  2735,  1463,  1464,
    1465,   533,  1192,  1848,  2165,  1422,  3237,  2621,  3347,  2102,
    1476,  1762,  3817,  2193,  1422,  1584,  1740,    43,  2177,  2255,
    2177,  2045,  3539,  1998,   461,  1322,  3326,  3158,  1763,   804,
    2700,   234,  2663,   236,   580,  1585,  2011,  3574,   446,  1508,
    1446,  2563,  1512,   690,   550,   120,  1186,  2046,  1604,  3200,
     462,   578,  2012,  1130,  2282,   447,  1768, -1586,  1188,   540,
    1730,  1459,  1530,  1531,  1299,   550,  1535,  3499,   899,  3392,
     604,  3756,  2858,  2047,  2070,   733,   540,   540,  2046,  1460,
     463,  2868,  2178,  3059,  2178,  1550,  1551,  1637, -1733,   448,
    1459,  -488,   449,  2893,   900,  1646,  3522,   534,   701,  1741,
    3727,  2307,  3490,  3491,  3457,  2194,   121,  2109,   435,   435,
     435,   540,   540,   705,   706,  3771,  1853, -1733,  1658,  1421,
    1771,  3818,  2369,  1676,   435,   464,   550,   450,  1772,   805,
    2832,   701,   435,  3258,  1570,   451,  -185,  2048,  3201,  2560,
     540,  1773,  1838,  2670,  -693,  2671,  1662,  1663,  1664,   535,
    1571,  1635,  1459,  2179,  2833,  2179,  3500,   122,  2672,  -845,
    2110,    55,  1677,  -560,   701,  2045, -1734,  1382,  3893,   701,
    1682,  1475,  2200,  3259,  1868,  3812,  1267,  2370,  1355,  3833,
    1355,   912,  1586,  2201,  3575,  1665,  1666,   938,   939,  3841,
     701,  1780,  1774,  3819,  2338, -1734,   806,  1487,   540,  3338,
    1507,   540,   525,  2200,  1999,  2371,  1744,  2128,  2049,  1775,
    3820,  3872,  1548,  3393,  1685,  2427,  1809,  2308,  3536,  2772,
    1696,   526,  2046,  1268,  3326,  3326,  2175,  2200,  2793,  2677,
    3430,  1783,  3821,  2784,   644,   938,   939,   -59,   913,  3894,
     914,  3159,   465,  3338,  -560,  1648,  2561,  3160,  2047,  2433,
     527,  3537,   550,  2200,   550,   435,   435,   435,  3783,   540,
    1669,  1779,  1511,   861,  2201,  1446,  1383,   971,  1781,  1857,
    1384,  -560,  1807,   126,   725,  3784,  3915,  2202,  3333,   550,
    1385,  3334,  3161,  2176,   550,  2898,  2834,   541,  3940,  3941,
     540,   731,  1874,  1841,  1842,  1843,   733,  1879,  1879,   734,
    1879,   528,  2226,   466,  2730,  2731,  2128,   725,  1353,  2177,
    2771,  1649,  2048,   645,  1459,  1363,  1364,   557,  2111,  2630,
    1881,  2631,  1882,  1008,  1207,  1638,  2226,  1208,  2129,  1787,
    1354,  1670,  1057,  1845,   943,  2180,  1847,  2180,  1422,  1353,
     725,   558,  2085,  3162,  2130,   725,  2317,  1911,  3335,  3336,
     127,   546,  -560,   708,   467,  2131,  2632,   468,  2202,  1848,
     980,  1354,  3679,  1353,  1697,  1057,   725,  2318,  1698,  3327,
    1057,  1878,  1878,  2178,  1878,   469,  3652,  2633,  2610,   646,
    2899,  1788,   861,  2049,  2070,  1354,  1912,  3680,  1058,  1353,
    2050,  1057,  2071,  1009,  1789,  3822,  1650,  1386,   598,   599,
     470,   568,   602,   603,  3326,  3326,   605,  2260,   607,  2634,
    1264,  1354,  3566,   571,  2885,   471,  2002,  1353,  3837,   567,
    1790,  3895,  1899,  2128,  1534,   573,  1107,  2129,  2132,  1720,
    3117,  1791,  3838,  3567,  3163,  1639,  1010,  2153,   575,  1354,
    1721,  1374,  1375,  2130,  2179,  2896,  2611,  1111,   653,   586,
    3285,  1011,  2154,  2901,  2131,  2193,  2903,  1209,   832,   833,
     449,   540,   588,  2030,   540,  3571,   601,  1714,  -560,  1941,
    2031,  1157,  1158,  1945,  2030,  2864,  2059,   550,   550,   540,
     540,  2818,  3748,  2694,  1387,  2194,  2227,  1879,  1879,  1879,
    2058,   596,  1651,  1720,  2072,  2073,  1969,   888,   889,  2228,
     890,  2078,   891,  3731,  1721,  2097,  1159,  1160,   639,  2080,
    2081,  2082,  3332,  1671,  2108,   873,   874,  2003,   877,   674,
    2004,  3326,   784,  2228,   788,  2104,  1238,  2132,  2074,  2133,
     129,  1556,  1557,   130,  3326,  2035,  2203,  2612,  1203,   540,
    3146,  3719,   790,  3147,  2129,   989,  3421,   894,  2204,  -560,
    1548,  2127,   642,  1222,  2063,   875,  1355,   540,  2838,   801,
    2130,  1878,  1878,  1878,   908,  2050,  2472,  2307,  1266,  1441,
     678,  2844,  1442,  2006,  2007,  1443,   679,  2600,  2309,  2676,
    2308,  1972,  1973,  1989,  1990,  2677,   917,  2134,  1722,  2156,
    2184,  2185,  3548,  3549,  3550,  3551,  2343,  2344,  2163,  2164,
    2840,   918,   683,  1548,  2171,  2172,  2173,  2174,  1263,  2182,
    2183,  3326,   927,  2120,  2430,  2431,  2229,   944,  1674,  2537,
    -560,  3909,  3910,  3326,   832,   833,  2180,   945,  2133,  2204,
    2635,  2138,  1588,  1589,  3003,  1140,  1141,  2657,  2658,   951,
    3422,  3423,  2256,  3326,  2132,  3424,  3425,  1548,  2753,  2754,
     114,  2128,  1722,  3037,  2375,  2269,  1723,   975,  3339,  2375,
    2128,  2773,  2774,  2621,  2273,   979,   690,   861,  1142,  2799,
    2800,   990,  3026,  2905,  2906,  1883,  3326,  1143,  1590,  1592,
    1724,  1012,  3326,  1014,  2276,  2277,  2134,  2284,   550,  2286,
    2287,  2288,  2289,  2290,  1884,  2292,  2293,   435,  2987,  2906,
    1005,  -560,  2439,   540,  3126,  1348,  2336,  1022,  1885,  3182,
    3183,  1007,  1144,   118,  3361,  3362,  1023,  1886,   550,  3326,
    1723,   701,  1031,  1145,  3226,  3227,  1032,  3365,  1033,  3326,
    3326,  1034,  3372,  3369,  1725,  2320,   705,   706,  1036,  2789,
    1037,   938,   939,  2424,  1724,  2133,  1137,  3238,  3239,  1038,
    1146,  3326,  1041,  3326,  3132,  1042,  3385,  3135,  3136,  3387,
    1043,  3326,  1887,  1888,   550,  3395,  2185,  3412,  3413,   550,
    3441,  3442,  2129,  3283,  3148,  3489,  3442,  2333,  3492,  3413,
    2383,  2129,  1166,  2831,  3586,  3587,  3099,  3100,  2130,  1044,
    1889,  1045,  3326,  1486,  3617,  3413,   725,  2130,  1725,  2131,
    1548,  3618,  3413,  2134,  1147,  3628,  3629,  1156,  2131,  1046,
    1594,  1595,  1596,  1597,  1598,  1726,  2793,  3654,  1047,  1238,
    3630,  3631,   992,  1195,  3728,  3632,  3631,  1048,  3326,  3326,
    3666,  3667,  3097,  3097,  3097,  2193,  3750,  3587,  3751,  3587,
    1049,  3326,  2375,  1052,  2506,  2511,  1054,  1890,  3770,  3442,
    3641,  3886,  3887,   550,  1168,  1169,  1170,  1171,  1172,  1055,
    3326,  3326,  3956,  3957,  1056,  3326,  1361,  1362,  1363,  1364,
    1365,  1366,  2132,  1367,  1368,  1369,  1370,  1371,  1372,  1726,
    1373,  2132,  3960,  3961,  2444,  3496,  1538,  1539,  2548,  2375,
    3897,  3897,  1060,  2677,  3289,  1061,  1891,   725,   993,  3493,
    3494,  3333,  1201,  3581,  3334,  3197,  3063,  3064,  1062,  2458,
    2996,  2997,  3224,  3225,   731,  1063,  1064,  1065,  1066,   733,
    1067,  3938,   734,  1068,  1173,  1215,  3734,  2473,  1069,  1071,
    2307,  1202,  1072,  1073,  1077,  2676,  1228,  1078,  1079,  1080,
    1081,  1082,  1083,  1232,  1084,  2492,  2494,  1174,  1175,  1176,
    1177,  1085,   550,  1087,   550,   550,   994,  1089,  1090,  1750,
    2904,  2491,  1229,  1091,  1092,  1093,  1751,  1752,  1094,  1095,
    1096,  3335,  3336,  2133,  1097,  1263,  1098,   995,  1753,  1754,
    1099,  1100,  2133,  1101,  3240,  1102,  1103,  1104,  1105,  1549,
    1109,  1110,  1113,  1114,  1374,  1375,  1118,  1122,   550,   550,
    1263,  1123,  1124,  1125,  1126,   435,  1194,  1755,  1233,  1236,
    1247,  1756,  1757,  1239,  1248,  1264,  1758,  1252,  1273,  1253,
    1274,  1275,  1759,  1276,  1277,  1278,  1289,  1288,  1303,  1305,
    1760,  2134,  1306,  1313,  1329,  1333,  1761,  1336,  1308,  3907,
    2134,  1337,  1178,  2555,  1179,  1180,  1181,  1341,  1762,  1344,
    1345,  1391,  1392,  1182,  2269,  1035,  1393,  1396,  1399,  1400,
    2575,  2269,  1322,  1401,  2269,  1763,  1406,  1414,  2269,  2587,
    2596,   996,  1764,  1765,  1416,  2597,  1418,   997,  1425,  1766,
    2596,  1431,  2269,  2269,  1426,   550,  1434,  1767,  2598,  2599,
    1435,  -783,  2269,  1768,  1549,  3855,  1436,  2618,  3858,  3859,
    3860,  3861,  2626,   540,  1438,  1439,  1191,   998,  2628,  2629,
     550,  1459,  1466,  2625,  1117,  1478,  1480,  2269,  2646,  1769,
    1504,  1496,  3899,  1546,  1183,  1563,  1581,  1558,  1605,  1578,
    1600,  1606,  1615,  1609,  1611,  3891,  3892,  1623,  1625,  1624,
    1626,  1627,  1633,  3903,   999,  1641,  1647,  1656,  1660,  1680,
    1693,  1691,  1695,  1707,  1718,  1770,  1811,  1771,  1814,  1812,
    1815,  1813,  1816,  1817,  1818,  1772,  1819,  1000,  1820,  1821,
    1822,  1829,  1184,  1185,  1823,   540,  2269,  2627,  1773,  1824,
    1825,  1830,  1826,  1001,  1827,  1835,   130,  1828,  1836,  1839,
    1855,  1844,  1869,  1850,  3699,  1870,  1894,  1874,  1898,  1029,
     550,   550,   550,  1897,  1900,  1909,  1902,  3699,  1915,  2001,
    1903,  1904,  2032,  1910,  1913,  1914,  1919,  1920,  1922,  1921,
    1929,  1923,  1924,  2105,  1925,  2116,  1926,  1927,  1931,  1774,
    1928,  1930,  1933,  2079,  1934,  1935,  1936,  1937,  1938,  1939,
     611,   612,  1942,  2676,  1940,  1943,  1775,  1944,  1946,  2687,
    1776,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954, -1065,
    1955,  1956,  1958,  2136,  1959,  1960,  1961,  1962,  1963,  1024,
    1964,  1154,  2141,  1965,  2143,  1966,  1970,  1971,  2152,  1996,
    1974,  1975,  1976,  2013,  1985,  1986,  1777,  1987,  1988,  1991,
    2021,  1778, -1182,  2042,  2056,  2157,  1186,  2107,  1779,  2093,
     540,  2137,  2140,  1548,  1780,  1781,  2158,  1187,  1188,  2159,
    2162,  2160,   550,   613,  2161,  1549,  3774,  3523,  3524,  2212,
    2200,  2217,  2218,  2221,  2222,  2224,  2225,  2231,  3510,   550,
     550,   550,  1782,  2234,  3510,  2240,  2233, -1337,  2241,  2784,
    2245,   614,  2817,  2375,  1783,  1784,  1785,  1786,  2819,  3699,
    2821,  2246,  2251,  2334,   615,  3806,   550,  2252,  2816,  2310,
    2338,  2342,  3557,  3234,  1348,  2345,  1787,  2346,  2347,  2348,
    2349,  2357,  2359,  2362,  2035,  2380,   616,   687,   617,  2392,
    2393,  2405,  2410,  2412,  2414,  2445,  2419,  2420,   618, -1337,
     886,   810,   612,  1025,  2421,  2422,  2423,  2432,  2438, -1235,
    2450,  2449,  2447,  3842,  2452,  2459,  2463,  2475,   619,  2476,
    2477,  2478,  2086,  2085,  2495,  2496,  2497,  2518,  1788, -1337,
    2521,  2525,  2526,  2527,  2543,  2865,  3699,  2550,  2556,  2553,
    2558,  1789,   620, -1337,  3699,  2269,  2559,  2638, -1337,   621,
    2596,  2654,  2603,  2605,  2655,  2666,  2665,  2678,  2679,  2680,
    2709,  1856,  1709,   550,  3646,  2702,  2269,  1790, -1337,  1780,
    2712,  2707,  2714,  2715,   613,  3699, -1337,  2718,  1791,  2722,
    2891,  2596,  2723,  2724, -1337,  2725,   622,  2726,  2894,  2596,
    1548,  2727,  2596,  2728,  2031, -1337,  2732,  2733,  2768,  2736,
   -1337,   540,   614,  2737,  2738,  2781,  2742,  2743,  2744, -1337,
    2907,  2745,  2747,   540,  2746,   615,  2748,  2963,  2964,  2750,
    2755,  2967,  2756,  2757,  3954,  2758,  2785,  2760,  2762,  2974,
    2764,  2765,  2766,  2770,  2775,  2778,  -783,   616,  2968,   617,
    1059,  1108,  1112,  3699,  3699,  2803,  2777,  2801,  3963,   618,
    2787,   540,  2815,  2788,  2795,  2798,  2814,  2820,  2828,  2839,
    2845,  2849,  2850,  2853,  1716,  3068,  2866,  2878, -1337,   619,
    2879,  2888,  2897,  2966,  2978,  2973,  2984,  -400,  2990,  2992,
    2980,  2548,  3002,  3513,  3005,  3013,  3014,  2908,  3012,  3015,
   -1337,  3016,  3023,   620,  3043,  1207,  2070,  3061,  3046, -1337,
     621,  3069,  3081,  3087,  3088,   623,  3849,  3022,  3077,  3713,
    3031,  3032,  3084,  3113,  3114,  3133,  3222,  3172,  3244,  3245,
    3033,  3078,   624,  3036,  3082,  2985,  3112, -1337,   625,  3129,
    3246,  3035,  3050,  3102,  3130,   612,   626,   622,  3153,  3175,
    3181,  3176,  3178,  3849,  1548,  3205,  3229,  3230,  3256,  3241,
    3242,  2458,  3741,  3742,  3243,  3744,  3247,  3248,  3260,   627,
    3927,  3249,  3250,  2473,  3058,  3251,   550,  3252,  3254, -1337,
    3257,  3266,   628,   629,  3227,   550,  3268,  3269,  2818,  3849,
    3274,  2444,  3273,  3279,  3277,  3280,  3284, -1269,  1548, -1274,
   -1337,   550,  3293,  3298,  3352,  3329,  3353,  3330,  3360,  2097,
    3169,  3364,  3366,  3368,   780,  3375,  3376,   613,  3377,  3379,
    3380,  3399,   630,  3390,  3381,  1238,  1549,  1548,  3382,  3383,
    3384,  3787,  3386,  3788,  3789,  3633,  3402, -1337,  3410,  3416,
    3417,  3432,  3398,  3927,  3415,   614,  3429,   631,  3408,  3434,
    3418,  2269,  3435,  3437,   886,  1753,  1754,  3439,   615,  2269,
     886,  2596,  3450,  3453,  3454,  3456,   623,  3459,  3461,   632,
    1549,   633,  3865,  2375,  3469,  2596,  3488,  3465,  3497,  2269,
     616,  -267,   617,   624,  3514,  3515, -1337,  3506,  1756,   625,
    3507,  3512,   618,  3516,  3517,  3529,  3518,   626, -1337,  1759,
    3519,  3545,  3547,  3553,  3556,  3578,  3239,  1760,  3531,  3580,
    3592,  3554,   619,  3532,  3595, -1337,  3555, -1337,  3638,  3583,
     627,  3639,  3640,  3655,   780,  1762,  3664,  3672,  3272,  3585,
    3674,  3675,  3676,   628,   629,  3677,   620, -1337, -1337,  1322,
    3621,  3683,  1763,   621, -1337,  3658,  3688,  3695,  3694,  3707,
    3700,  3865,  2658,  2650,  3715,  3717,  3716,  3718,  3724,  3726,
    3725,  3737,  3730,  3212,  3743,  3745,  3746,  3757,  3752,  3759,
    1768,  3764,  3760,   630,  3642,  3761,  3765,  3767, -2036,  3773,
     622,   780,  3775,   550,  3790,  3781,   780,  3796,  3807,  3815,
    3791,  3814,  3827,  3828,  3830,  3832,  3831,  3834,   631,  3835,
    3840,  3844,  3839, -1409,  3871,  3856,  3857,  3869,  3864,  3875,
    3878,  2492,  3879,  3880,  3883,  3905,   780,  3884,  3901,  2548,
     632,  3908,   633,  1549,  3906,  3913,  3920,  2491,  3922,  3931,
    3932,  3928,   780,  3935,  1771,  3964,  2295,  3186,   550,  3951,
    2341,  2565,  1772,  3189,  3525,  3643,  3772,  3882,  3533,  3648,
    3527,  3916,  3970,  3309,  3722,  1773,  3310,  1335,  3312,  3313,
    3942,  3315,  3316,  1753,  1754,  3317,  3318,  3319,  3320,  3793,
    3282,  3692,  3794,   780,   780,   780,   780,  3323,  3703,  1749,
    3651,  1861,  1792,  2624,  3045,  3212,  3048,  3736,  3663,  3782,
    3930,  3564,  3889,   780,  -679,  -679,  1756,  2375,  3342,   623,
    3969,  3971,  3863,  -679,  1832,   587,  1774,  1759,  3466,  2692,
    3207,  2259,  3127,  1395,  1713,  1760,   624,  2651,  2266,  2581,
    3116,  3179,   625,  1775,  3508,   886,  3341,  3140,  3378,   550,
     626,  3370,  3141,  1762,  3119,  3075,  3068,  3710,  3704,  3505,
    3627,  1849,  3656,  3544,  3511,  2332,  3371,  1322,  2263,  3118,
    1763,  3344,  2641,   627,  3388,  1694,  3389,  2125,  2062,  2460,
    1352,  2780,  1318,  2448,  2479,   892,   628,   629,   886,   886,
     540,   886,  3565,  1582,  1243,  1779,  3406,  3039,  1768,  3255,
    2084,  1503,  1781,  1831,  1587,  2378,  3083,  3589,  2437,  3122,
    3464,  3898,  3939,  3452,  2486,  2354,  3054,  2466,  3053,  3094,
    3958,  3264,   882,  3778,  1629,  1411,   630,   550,   867,   972,
    3042,  1455,  1854,  3780,  1631,  3678,  3813,  2113,  3747,  3966,
    3057,  3374,  2094,  3079,  2836,  1477,  3455,   812,  1645,  3278,
    2040,   631,  1636,  1231,  3546,  3552,  1871,   886,  2701,   886,
     886,  1448,  1771,  1787,  3401,  1840,   550,   814,  1235,  3253,
    1772,   919,  1407,   632,  1554,   633,   780,  3826,  2686,  3407,
    3204,     0,     0,  1773,     0,     0,  3463,     0,     0,     0,
       0,     0,     0,     0,  3473,     0,     0,     0,     0,  3480,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3722,     0,     0,  1788,  3826,     0,     0,     0,
       0,     0,  3212,  3212,     0,     0,     0,     0,  1789,     0,
       0,     0,     0,     0,  1774,     0,     0,     0,     0,     0,
    3504,     0,  3948,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,     0,     0,  1790,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1791,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   780,   780,     0,     0,     0,     0,     0,     0,     0,
     780,   780,  3948,  3528,   780,   780,   780,     0,     0,     0,
       0,   780,     0,  1779,   780,   780,  3212,   780,     0,   780,
    1781,  3530,     0,     0,   752,     0,   780,   780,   780,     0,
     780,     0,     0,     0,     0,     0,     0,   780,   780,     0,
     780,   780,  3561,  3563,     0,     0,   780,     0,   780,   780,
     780,     0,   780,   780,   780,   780,   780,   780,   780,     0,
       0,   780,   780,     0,   780,     0,   780,     0,  2273,  3826,
     780,     0,   780,   780,     0,     0,  3965,     0,     0,  3596,
       0,  1787,     0,     0,   780,   780,     0,     0,     0,     0,
     780,     0,     0,   780,     0,     0,   780,     0,     0,     0,
     780,     0,     0,     0,     0,     0,     0,   780,   780,     0,
     780,   780,     0,   780,     0,   780,   780,   780,   780,   780,
     780,   780,   780,   780,   780,   780,     0,     0,     0,     0,
       0,     0,     0,  1788,   973,  3406,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1789,     0,     0,     0,
       0,   780,     0,     0,     0,     0,  1549,     0,     0,   540,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1790,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1791,     0,     0,  3463,     0,  3463,     0,
    3687,     0,     0,     0,     0,     0,  1039,     0,     0,     0,
       0,   780,     0,     0,     0,     0,     0,     0,     0,   780,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1753,  1754,     0,     0,     0,  1070,     0,     0,     0,
       0,     0,  3711,  3662,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -679,  -679,  1756,     0,     0,     0,     0,     0,
       0,  -679,     0,     0,     0,  1759,     0,     0,     0,     0,
    3561,     0,     0,  1760,     0,  3740,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1132,     0,     0,     0,
       0,  1762,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1322,     0,     0,  1763,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1549,     0,     0,  1768,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3900,     0,     0,     0,     0,     0,
       0,  3798,     0,     0,  3804,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   780,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1263,     0,     0,     0,
    1771,     0,     0,     0,     0,     0,     0,     0,  1772,     0,
       0,     0,     0,     0,     0,     0,     0,  3955,     0,     0,
       0,  1773,     0,     0,     0,   780,     0,     0,     0,     0,
       0,     0,     0,     0,  2322,  3873,     0,     0,  3876,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3968,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   550,     0,  1360,     0,     0,     0,
       0,     0,  1774,     0,  3890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1549,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     780,   780,   780,     0,     0,     0,   550,     0,     0,     0,
    3933,  3934,     0,     0,     0,  3949,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   550,     0,     0,
       0,  1549,     0,     0,     0,     0,     0,   780,     0,     0,
     780,  1779,   780,     0,   780,   780,     0,     0,  1781,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   780,
    1549,     0,   550,     0,     0,  3949,     0,     0,     0,     0,
       0,  1457,  1458,     0,     0,     0,     0,     0,     0,   780,
    1468,  1469,     0,     0,  1472,  1473,  1474,     0,     0,     0,
       0,  1479,     0,     0,  1481,  1482,     0,  1483,     0,  1484,
       0,     0,     0,     0,     0,     0,  1498,  1499,  1500,  1787,
    1501,     0,     0,     0,     0,     0,     0,  1509,  1510,     0,
    1513,  1514,     0,     0,     0,     0,  1518,     0,  1519,  1520,
    1521,     0,     0,  1524,  1525,  1526,  1527,  1528,  1529,     0,
       0,  1532,  1533,     0,  1536,     0,  1537,     0,     0,     0,
    1540,     0,  1544,  1545,     0,     0,     0,     0,     0,     0,
       0,  1788,     0,     0,  1552,  1553,     0,     0,     0,     0,
    1132,     0,     0,  1559,  1789,     0,     0,     0,     0,     0,
       0,     0,     1,     2,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     3,     0,     4,
    1790,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,  1791,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     8,     0,     0,     0,     9,    10,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      11,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,     0,     0,
       0,  2323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   780,     0,    13,     0,     0,     0,     0,     0,
       0,  1644,    14,    15,    16,     0,     0,     0,     0,  1659,
       0,     0,     0,     0,    17,    18,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    19,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    20,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    22,
       0,     0,     0,     0,    23,     0,   780,    24,     0,     0,
     780,     0,     0,     0,     0,   780,   780,     0,     0,     0,
       0,     0,     0,     0,   780,     0,     0,     0,     0,     0,
      25,     0,    26,     0,     0,     0,     0,     0,   780,     0,
     780,     0,     0,   780,   780,   780,    27,     0,   780,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,     0,     0,    28,   780,     0,   780,    29,   780,   780,
     780,     0,     0,     0,     0,   780,   780,   780,     0,     0,
       0,     0,   780,   780,   780,     0,   780,     0,   780,     0,
     780,     0,   780,     0,   780,     0,     0,     0,     0,   780,
       0,     0,     0,     0,     0,     0,     0,  1859,     0,     0,
     780,     0,     0,     0,   780,     0,     0,   780,     0,     0,
       0,     0,     0,   780,     0,     0,   780,     0,     0,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,  1905,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      32,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    34,     0,
       0,    35,     0,    36,     0,     0,    37,     0,     0,    38,
       0,    39,     0,     0,     0,     0,    40,     0,    41,     0,
    1978,  1980,  1982,     0,     0,    42,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,    45,     0,     0,     0,    46,   780,   780,
       0,     0,     0,     0,     0,     0,     0,  2015,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,     0,     0,     0,     0,     0,  2026,
       0,     0,     0,     0,  2639,     0,     0,     0,     0,     0,
       0,  1751,     0,     0,     0,     0,     0,     0,     0,  2057,
       0,     0,     0,  1753,  1754,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    50,     0,     0,     0,    51,     0,     0,
      52,     0,  1755,     0,     0,    53,  1756,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1759,     0,     0,
       0,     0,     0,     0,     0,  1760,     0,     0,     0,     0,
      54,  1761,     0,     0,     0,     1,     2,     0,     0,     0,
       0,     0,     0,  1762,    55,     0,     0,     0,     0,     0,
       3,     0,     0,     0,     0,     0,     5,  1322,     0,     0,
    1763,     0,     0,     0,     0,     0,     0,  1764,     0,     6,
       7,     0,     0,     0,  2640,     0,     8,     0,     0,     0,
       9,    10,  1767,     0,     0,     0,     0,     0,  1768,     0,
       0,     0,     0,    11,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    12,     0,     0,
       0,     0,     0,     0,  1769,     0,     0,     0,     0,     0,
     780,     0,     0,     0,   780,     0,     0,    13,   780,     0,
       0,     0,     0,     0,     0,    14,    15,    16,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    17,    18,     0,
       0,     0,  1771,     0,     0,     0,     0,     0,     0,     0,
    1772,     0,  2274,     0,     0,     0,     0,     0,     0,     0,
     780,     0,    20,  1773,     0,     0,     0,     0,     0,   780,
       0,   780,     0,   780,     0,     0,     0,    21,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    22,   780,     0,     0,     0,    23,   780,     0,
      24,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     780,     0,     0,     0,  1774,     0,     0,     0,     0,     0,
       0,     0,     0,    25,     0,    26,     0,     0,     0,     0,
       0,  1775,     0,     0,     0,  1776,  2356,     0,     0,    27,
    2358,     0,     0,     0,     0,  2360,  2361,     0,     0,     0,
       0,     0,     0,     0,  2376,     0,    28,   780,     0,     0,
      29,   780,     0,     0,     0,     0,     0,     0,  2384,     0,
    2385,     0,     0,  2387,  2388,  2389,  1778,     0,     0,     0,
       0,     0,     0,  1779,     0,     0,  2394,     0,     0,     0,
    1781,     0,     0,     0,  2395,     0,  2396,     0,  2397,  2398,
    2399,     0,     0,   780,     0,  2402,  2403,  2404,     0,     0,
       0,     0,  2406,  2407,  2408,     0,  2409,     0,  2411,     0,
    2413,     0,  2415,     0,  2416,     0,     0,     0,     0,  2417,
    1784,     0,     0,     0,     0,     0,   780,     0,     0,     0,
    2425,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,  1787,     0,     0,     0,     0,     0,     0,     0,     0,
    2435,     0,     0,    31,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    32,     0,     0,     0,     0,     0,     0,
       0,    33,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    34,     0,  1788,    35,     0,    36,     0,     0,    37,
       0,     0,    38,     0,    39,     0,  1789,     0,     0,    40,
       0,    41,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
       0,    44,  1790,     0,     0,     0,    45,     0,     0,     0,
      46,     0,     0,  1791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,     0,    47,   780,     0,     0,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2551,  2552,
       0,     0,  2909,  2910,     0,   780,   780,     0,  2911,     0,
    2912,  2913,  2914,     0,     0,   780,     0,     0,     0,     0,
     780,     0,     0,   780,    49,   780,   780,  2915,     0,     0,
       0,     0,     0,     0,     0,     0,    50,     0,     0,     0,
      51,     0,     0,    52,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   780,     0,     0,  2916,     0,     0,  2917,
       0,     0,     0,    54,     0,     0,     0,  2918,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    55,     0,     0,
       0,     0,   780,     0,  2919,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,  2920,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   780,     0,     0,     0,     0,     0,
       0,     0,  2921,     0,  2922,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2923,  2924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2708,     0,     0,     0,  2711,     0,     0,     0,  2713,     0,
       0,     0,  2926,     0,     0,     0,     0,     0,     0,     0,
       0,  2927,  2928,     0,  2929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2749,     0,  2930,  2931,  2932,     0,     0,     0,     0,  2759,
       0,  2761,     0,  2763,     0,     0,     0,     0,     0,     0,
    2933,  2934,  2935,     0,     0,     0,  2936,     0,     0,  2937,
       0,     0,     0,     0,     0,     0,     0,     0,  2776,     0,
       0,     0,     0,     0,     0,  2938,  2939,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     780,   830,     0,     0,     0,     0,  2940,  2941,     0,     0,
       0,   791,   831,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2826,  2942,     0,
       0,  2830,     0,     0,   832,   833,     0,     0,     0,     0,
     780,   780,     0,     0,   834,     0,   835,     0,     0,     0,
       0,   780,     0,     0,     0,  3324,     0,     0,     0,     0,
     836,     0,   837,   838,     0,     0,     0,     0,     0,     0,
       0,   839,     0,  2861,     0,  2943,     0,     0,     0,  2944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2945,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2877,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1586,   840,     0,
       0,     0,   841,     0,     0,   842,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2946,     0,     0,  2947,     0,
       0,  2948,  2949,  2950,  2951,     0,     0,     0,     0,     0,
     843,     0,   844,     0,     0,     0,     0,   845,     0,   846,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,   847,   848,  2952,  2953,     0,   849,     0,     0,     0,
       0,     0,   780,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   850,     0,  2954,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   780,     0,     0,
       0,     0,     0,   851,     0,     0,     0,     0,     0,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3004,     0,     0,     0,   780,     0,   852,
       0,     0,     0,  3324,  3324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3018,  3019,     0,     0,     0,
       0,     0,     0,     0,     0,  3025,     0,     0,     0,     0,
    3027,   853,     0,  3028,     0,  3029,  3030,     0,     0,     0,
       0,   854,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     855,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   856,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   857,   858,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3080,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   780,     0,     0,
       0,     0,     0,     0,   859,     0,     0,   780,     0,   780,
       0,     0,     0,     0,     0,     0,   860,     0,   780,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     780,     0,     0,  3324,  3324,     0,     0,     0,     0, -2062,
       0,     0,     0,   861,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   862,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,     0,     0, -2062,     0,     0,   780,     0,     0,   863,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   780,     0,     0,
    3324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3324,   780,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3729,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3291,  3292,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2861,     0,   780,     0,     0,     0,     0,     0,   780,
    3324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3324,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3324,     0,     0,     0,     0,     0,     0,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3324,     0,     0,     0,     0,
       0,  3324,     0,     0,     0,   780,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   780,     0,     0,     0,     0,     0,     0,  3324,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3324,  3324,
       0,     0,     0,   780,     0,     0,     0,     0,     0,     0,
       0,     0,  3433,     0,     0,     0,     0,     0,     0,     0,
    3324,     0,  3324,     0,     0,     0,     0,     0,     0,     0,
    3324,     0,     0,     0,     0,     0,     0,  2861,     0,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2826,     0,     0,     0,   780,     0,     0,     0,     0,     0,
       0,  3324,     0,     0,     0,     0,     0,  3468,     0,     0,
       0,     0,     0,     0,     0,     0,   780,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3324,  3324,     0,
       0,     0,   780,     0,     0,     0,     0,     0,     0,     0,
    3324,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3324,
    3324,     0,     0,     0,  3324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3570,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3582,     0,  3584,
       0,     0,     0,     0,     0,     0,     0,     0,  3590,     0,
    3591,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3599,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2861,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3696,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3702,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3749,     0,     0,     0,     0,     0,  3755,
       0,     0,     0,     0,   136,     0,   649,   138,   139,   140,
     141,     0,     0,     0,     0,     0,   142,     0,     0,   650,
       0,   144,   145,   146,   147,   148,   651,   150,     0,   151,
       0,     0,   652,   152,   653,   654,   655,   153,   656,     0,
     154,   155,  1541,   156,     0,   157,   158,     0,     0,   159,
     657,   658,   160,     0,   161,   659,   660,   163,     0,   164,
     165,   166,   661,   168,     0,   662,   170,     0,   171,   172,
     173,   174,   175,   176,   177,  3808,     0,   178,     0,   663,
       0,   180,   664,   665,     0,     0,   181,   666,   667,     0,
     668,   669,     0,   182,   183,   184,   670,   671,   672,     0,
       0,  3829,     0,   673,   187,   674,     0,     0,   675,   188,
       0,   189,     0,     0,     0,   190,     0,   191,   192,   193,
     194,     0,     0,     0,   195,     0,     0,   196,   197,   198,
       0,     0,     0,   199,     0,   200,   201,     0,   202,   203,
     204,     0,     0,   205,     0,   206,   207,   208,   209,   210,
     676,     0,   211,   212,   213,   677,   678,   214,     0,   215,
     216,   217,   679,     0,   218,     0,     0,     0,   219,   220,
       0,   221,     0,   222,  3904,   680,   224,   681,   226,     0,
     227,     0,   682,     0,   228,   229,     0,   230,   683,     0,
     231,   232,     0,     0,     0,   684,   234,   235,   236,   685,
       0,   237,   238,     0,     0,   239,     0,   240,     0,     0,
     686,   241,   242,   687,     0,     0,   243,     0,     0,   244,
     245,     0,  3950,     0,   246,     0,     0,   247,   248,     0,
    1542,   249,     0,   688,   250,   251,     0,     0,     0,     0,
       0,   689,   253,     0,   254,     0,   255,     0,   256,   257,
       0,     0,   690,     0,     0,     0,     0,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   691,   273,   274,   275,   276,   692,   277,   278,
     279,     0,     0,     0,   280,   281,   282,   693,   284,     0,
       0,   694,   286,   695,   287,     0,   288,   696,   697,   698,
     699,   700,   293,   294,   295,   296,     0,   701,   297,   298,
       0,     0,   299,   300,   301,   302,   702,   703,   704,   303,
     304,     0,   705,   706,     0,   305,   306,   707,     0,   308,
     309,   310,     0,   311,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   312,   313,   708,   314,   315,   316,   317,
     318,   709,   320,   321,   322,   710,   711,   325,   712,     0,
     326,   327,   328,     0,   329,     0,   330,   331,     0,   713,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,   340,     0,     0,   341,   342,   343,     0,   344,
     345,     0,   346,   347,   348,   714,   715,   349,     0,   350,
     351,   352,     0,   353,   354,     0,     0,   716,   355,   356,
     357,   358,   359,   717,   361,   362,   363,     0,   718,   365,
       0,     0,     0,   366,   367,   368,   369,     0,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,     0,   375,
     376,   377,   378,     0,     0,     0,     0,     0,     0,   379,
     380,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,   719,   720,   386,   387,     0,   388,   721,   390,   391,
     392,   722,   723,   393,   394,   724,   395,   396,     0,     0,
     397,   398,     0,   725,   399,   400,     0,   726,   727,   728,
     729,     0,     0,     0,     0,  1543,   405,   406,     0,   730,
     731,   732,   408,   409,   410,   733,   411,   412,   734,   413,
     414,     0,   415,   416,     0,     0,   417,     0,     0,   418,
       0,   419,     0,   735,   421,     0,     0,   736,   737,   738,
     739,   422,     0,     0,   423,   740,     0,   741,   424,   425,
     426,   742,     0,     0,     0,     0,   428,   429,     0,   430,
     431,     0,     0,   743,     0,     0,     0,   744,   745,     0,
       0,     0,     0,   746,   747,     0,     0,   748,   749,     0,
     750,   751,   136,     0,   649,   138,   139,   140,   141,  2822,
       0,     0,     0,     0,   142,     0,     0,   650,     0,   144,
     145,   146,   147,   148,   651,   150,     0,   151,     0,     0,
    2823,   152,   653,   654,   655,   153,   656,     0,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   657,   658,
     160,     0,   161,   659,   660,   163,     0,   164,   165,   166,
     661,   168,     0,   662,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,   663,     0,   180,
     664,   665,     0,     0,   181,   666,   667,     0,   668,   669,
       0,   182,   183,   184,   670,   671,   672,     0,     0,     0,
       0,   673,   187,   674,     0,     0,  2824,   188,     0,   189,
       0,     0,     0,   190,     0,   191,   192,   193,   194,     0,
       0,     0,   195,     0,     0,   196,   197,   198,     0,     0,
       0,   199,     0,   200,   201,     0,   202,   203,   204,     0,
       0,   205,     0,   206,   207,   208,   209,   210,   676,     0,
     211,   212,   213,   677,   678,   214,     0,   215,   216,   217,
     679,     0,   218,     0,     0,     0,   219,   220,     0,   221,
       0,   222,     0,   680,   224,   681,   226,     0,   227,     0,
     682,     0,   228,   229,     0,   230,   683,     0,   231,   232,
       0,     0,     0,   684,   234,   235,   236,   685,     0,   237,
     238,     0,     0,   239,     0,   240,     0,     0,   686,   241,
     242,   687,     0,     0,   243,     0,     0,   244,   245,     0,
       0,     0,   246,     0,     0,   247,   248,     0,     0,   249,
       0,   688,   250,   251,     0,     0,     0,     0,     0,   689,
     253,     0,   254,     0,   255,     0,   256,   257,     0,     0,
     690,     0,     0,     0,     0,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     691,   273,   274,   275,   276,   692,   277,   278,   279,     0,
       0,     0,   280,   281,   282,   693,   284,     0,     0,   694,
     286,   695,   287,     0,   288,   696,   697,   698,   699,   700,
     293,   294,   295,   296,     0,   701,   297,   298,     0,     0,
     299,   300,   301,   302,   702,   703,   704,   303,   304,     0,
     705,   706,     0,   305,   306,   707,  2825,   308,   309,   310,
       0,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   312,   313,   708,   314,   315,   316,   317,   318,   709,
     320,   321,   322,   710,   711,   325,   712,     0,   326,   327,
     328,     0,   329,     0,   330,   331,     0,   713,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
     340,     0,     0,   341,   342,   343,     0,   344,   345,     0,
     346,   347,   348,   714,   715,   349,     0,   350,   351,   352,
       0,   353,   354,     0,     0,   716,   355,   356,   357,   358,
     359,   717,   361,   362,   363,     0,   718,   365,     0,     0,
       0,   366,   367,   368,   369,     0,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,     0,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,   379,   380,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,   719,
     720,   386,   387,     0,   388,   721,   390,   391,   392,   722,
     723,   393,   394,   724,   395,   396,     0,     0,   397,   398,
       0,   725,   399,   400,     0,   726,   727,   728,   729,     0,
       0,     0,     0,     0,   405,   406,     0,   730,   731,   732,
     408,   409,   410,   733,   411,   412,   734,   413,   414,     0,
     415,   416,     0,     0,   417,     0,     0,   418,     0,   419,
       0,   735,   421,     0,     0,   736,   737,   738,   739,   422,
       0,     0,   423,   740,     0,   741,   424,   425,   426,   742,
       0,     0,     0,     0,   428,   429,     0,   430,   431,     0,
       0,   743,     0,     0,     0,   744,   745,     0,     0,     0,
       0,   746,   747,     0,     0,   748,   749,     0,   750,   751,
     136,     0,   649,   138,   139,   140,   141,     0,     0,     0,
       0,     0,   142,     0,     0,   650,     0,   144,   145,   146,
     147,   148,   651,   150,     0,   151,     0,     0,   652,   152,
     653,   654,   655,   153,   656,     0,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   657,   658,   160,     0,
     161,   659,   660,   163,     0,   164,   165,   166,   661,   168,
       0,   662,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,     0,   178,     0,   663,     0,   180,   664,   665,
       0,     0,   181,   666,   667,     0,   668,   669,     0,   182,
     183,   184,   670,   671,   672,     0,     0,     0,     0,   673,
     187,   674,     0,     0,   675,   188,     0,   189,     0,     0,
       0,   190,     0,   191,   192,   193,   194,     0,     0,     0,
     195,     0,     0,   196,   197,   198,     0,     0,     0,   199,
       0,   200,   201,     0,   202,   203,   204,     0,     0,   205,
       0,   206,   207,   208,   209,   210,   676,     0,   211,   212,
     213,   677,   678,   214,     0,   215,   216,   217,   679,     0,
     218,     0,     0,     0,   219,   220,     0,   221,     0,   222,
       0,   680,   224,   681,   226,     0,   227,     0,   682,     0,
     228,   229,     0,   230,   683,     0,   231,   232,     0,     0,
       0,   684,   234,   235,   236,   685,     0,   237,   238,     0,
       0,   239,     0,   240,     0,     0,   686,   241,   242,   687,
       0,     0,   243,     0,     0,   244,   245,     0,     0,     0,
     246,     0,     0,   247,   248,     0,     0,   249,     0,   688,
     250,   251,     0,     0,     0,     0,     0,   689,   253,     0,
     254,     0,   255,     0,   256,   257,     0,     0,   690,     0,
       0,     0,     0,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   691,   273,
     274,   275,   276,   692,   277,   278,   279,     0,     0,     0,
     280,   281,   282,   693,   284,     0,     0,   694,   286,   695,
     287,     0,   288,   696,   697,   698,   699,   700,   293,   294,
     295,   296,     0,   701,   297,   298,     0,     0,   299,   300,
     301,   302,   702,   703,   704,   303,   304,     0,   705,   706,
       0,   305,   306,   707,     0,   308,   309,   310,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   312,
     313,   708,   314,   315,   316,   317,   318,   709,   320,   321,
     322,   710,   711,   325,   712,     0,   326,   327,   328,     0,
     329,     0,   330,   331,     0,   713,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,   340,     0,
       0,   341,   342,   343,     0,   344,   345,     0,   346,   347,
     348,   714,   715,   349,     0,   350,   351,   352,     0,   353,
     354,     0,     0,   716,   355,   356,   357,   358,   359,   717,
     361,   362,   363,     0,   718,   365,  1130,     0,     0,   366,
     367,   368,   369,     0,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,     0,   375,   376,   377,   378,     0,
       0,     0,     0,     0,     0,   379,   380,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,   719,   720,   386,
     387,     0,   388,   721,   390,   391,   392,   722,   723,   393,
     394,   724,   395,   396,     0,     0,   397,   398,     0,   725,
     399,   400,     0,   726,   727,   728,   729,     0,     0,     0,
       0,     0,   405,   406,     0,   730,   731,   732,   408,   409,
     410,   733,   411,   412,   734,   413,   414,     0,   415,   416,
       0,     0,   417,     0,     0,   418,     0,   419,     0,   735,
     421,     0,     0,   736,   737,   738,   739,   422,     0,     0,
     423,   740,     0,   741,   424,   425,   426,   742,     0,     0,
       0,     0,   428,   429,     0,   430,   431,     0,     0,   743,
       0,     0,     0,   744,   745,     0,     0,     0,     0,   746,
    1131,     0,     0,   748,   749,     0,   750,   751,   136,     0,
     649,   138,   139,   140,   141,     0,     0,     0,     0,     0,
     142,     0,     0,   650,     0,   144,   145,   146,   147,   148,
     651,   150,     0,   151,     0,     0,   652,   152,   653,   654,
     655,   153,   656,     0,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   657,   658,   160,     0,   161,   659,
     660,   163,     0,   164,   165,   166,   661,   168,     0,   662,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
       0,   178,     0,   663,     0,   180,   664,   665,     0,     0,
     181,   666,   667,     0,   668,   669,     0,   182,   183,   184,
     670,   671,   672,     0,     0,     0,     0,   673,   187,   674,
       0,     0,   675,   188,     0,   189,     0,     0,     0,   190,
       0,   191,   192,   193,   194,     0,     0,     0,   195,     0,
       0,   196,   197,   198,     0,     0,     0,   199,     0,   200,
     201,     0,   202,   203,   204,     0,     0,   205,     0,   206,
     207,   208,   209,   210,   676,     0,   211,   212,   213,   677,
     678,   214,     0,   215,   216,   217,   679,     0,   218,     0,
       0,     0,   219,   220,     0,   221,     0,   222,     0,   680,
     224,   681,   226,     0,   227,     0,   682,     0,   228,   229,
       0,   230,   683,     0,   231,   232,     0,     0,     0,   684,
     234,   235,   236,   685,     0,   237,   238,     0,     0,   239,
       0,   240,     0,     0,   686,   241,   242,   687,     0,     0,
     243,     0,     0,   244,   245,     0,     0,     0,   246,     0,
       0,   247,   248,     0,     0,   249,     0,   688,   250,   251,
       0,     0,     0,     0,     0,   689,   253,     0,   254,     0,
     255,     0,   256,   257,     0,     0,   690,     0,     0,     0,
       0,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   691,   273,   274,   275,
     276,   692,   277,   278,   279,     0,     0,     0,   280,   281,
     282,   693,   284,     0,     0,   694,   286,   695,   287,     0,
     288,   696,   697,   698,   699,   700,   293,   294,   295,   296,
       0,   701,   297,   298,     0,     0,   299,   300,   301,   302,
     702,   703,   704,   303,   304,     0,   705,   706,     0,   305,
     306,   707,     0,   308,   309,   310,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   312,   313,   708,
     314,   315,   316,   317,   318,   709,   320,   321,   322,   710,
     711,   325,   712,     0,   326,   327,   328,     0,   329,     0,
     330,   331,     0,   713,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,   340,     0,     0,   341,
     342,   343,     0,   344,   345,     0,   346,   347,   348,   714,
     715,   349,     0,   350,   351,   352,     0,   353,   354,     0,
       0,   716,   355,   356,   357,   358,   359,   717,   361,   362,
     363,     0,   718,   365,     0,     0,     0,   366,   367,   368,
     369,     0,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,     0,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,   379,   380,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,   719,   720,   386,   387,     0,
     388,   721,   390,   391,   392,   722,   723,   393,   394,   724,
     395,   396,     0,     0,   397,   398,     0,   725,   399,   400,
       0,   726,   727,   728,   729,     0,     0,     0,     0,     0,
     405,   406,     0,   730,   731,   732,   408,   409,   410,   733,
     411,   412,   734,   413,   414,     0,   415,   416,     0,     0,
     417,     0,     0,   418,     0,   419,     0,   735,   421,     0,
       0,   736,   737,   738,   739,   422,     0,     0,   423,   740,
       0,   741,   424,   425,   426,   742,     0,     0,     0,     0,
     428,   429,     0,   430,   431,     0,     0,   743,     0,     0,
       0,   744,   745,     0,     0,     0,     0,   746,   747,  1478,
       0,   748,   749,     0,   750,   751,   136,     0,   649,   138,
     139,   140,   141,     0,     0,     0,     0,     0,   142,     0,
       0,   650,     0,   144,   145,   146,   147,   148,   651,   150,
       0,   151,     0,     0,   652,   152,   653,   654,   655,   153,
     656,     0,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   657,   658,   160,     0,   161,   659,   660,   163,
       0,   164,   165,   166,   661,   168,     0,   662,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,     0,   178,
       0,   663,     0,   180,   664,   665,     0,     0,   181,   666,
     667,     0,   668,   669,     0,   182,   183,   184,   670,   671,
     672,     0,     0,     0,     0,   673,   187,   674,     0,     0,
     675,   188,     0,   189,     0,     0,     0,   190,     0,   191,
     192,   193,   194,     0,     0,     0,   195,     0,     0,   196,
     197,   198,     0,     0,     0,   199,     0,   200,   201,     0,
     202,   203,   204,     0,     0,   205,     0,   206,   207,   208,
     209,   210,   676,     0,   211,   212,   213,   677,   678,   214,
       0,   215,   216,   217,   679,     0,   218,     0,     0,     0,
     219,   220,  1977,   221,     0,   222,     0,   680,   224,   681,
     226,     0,   227,     0,   682,     0,   228,   229,     0,   230,
     683,     0,   231,   232,     0,     0,     0,   684,   234,   235,
     236,   685,     0,   237,   238,     0,     0,   239,     0,   240,
       0,     0,   686,   241,   242,   687,     0,     0,   243,     0,
       0,   244,   245,     0,     0,     0,   246,     0,     0,   247,
     248,     0,     0,   249,     0,   688,   250,   251,     0,     0,
       0,     0,     0,   689,   253,     0,   254,     0,   255,     0,
     256,   257,     0,     0,   690,     0,     0,     0,     0,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   691,   273,   274,   275,   276,   692,
     277,   278,   279,     0,     0,     0,   280,   281,   282,   693,
     284,     0,     0,   694,   286,   695,   287,     0,   288,   696,
     697,   698,   699,   700,   293,   294,   295,   296,     0,   701,
     297,   298,     0,     0,   299,   300,   301,   302,   702,   703,
     704,   303,   304,     0,   705,   706,     0,   305,   306,   707,
       0,   308,   309,   310,     0,   311,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   312,   313,   708,   314,   315,
     316,   317,   318,   709,   320,   321,   322,   710,   711,   325,
     712,     0,   326,   327,   328,     0,   329,     0,   330,   331,
       0,   713,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,   340,     0,     0,   341,   342,   343,
       0,   344,   345,     0,   346,   347,   348,   714,   715,   349,
       0,   350,   351,   352,     0,   353,   354,     0,     0,   716,
     355,   356,   357,   358,   359,   717,   361,   362,   363,     0,
     718,   365,     0,     0,     0,   366,   367,   368,   369,     0,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
       0,   375,   376,   377,   378,     0,     0,     0,     0,     0,
       0,   379,   380,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,   719,   720,   386,   387,     0,   388,   721,
     390,   391,   392,   722,   723,   393,   394,   724,   395,   396,
       0,     0,   397,   398,     0,   725,   399,   400,     0,   726,
     727,   728,   729,     0,     0,     0,     0,     0,   405,   406,
       0,   730,   731,   732,   408,   409,   410,   733,   411,   412,
     734,   413,   414,     0,   415,   416,     0,     0,   417,     0,
       0,   418,     0,   419,     0,   735,   421,     0,     0,   736,
     737,   738,   739,   422,     0,     0,   423,   740,     0,   741,
     424,   425,   426,   742,     0,     0,     0,     0,   428,   429,
       0,   430,   431,     0,     0,   743,     0,     0,     0,   744,
     745,     0,     0,     0,     0,   746,   747,     0,     0,   748,
     749,     0,   750,   751,   136,     0,   649,   138,   139,   140,
     141,     0,     0,     0,     0,     0,   142,     0,     0,   650,
       0,   144,   145,   146,   147,   148,   651,   150,     0,   151,
       0,     0,   652,   152,   653,   654,   655,   153,   656,     0,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     657,   658,   160,     0,   161,   659,   660,   163,     0,   164,
     165,   166,   661,   168,     0,   662,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,     0,   178,     0,   663,
       0,   180,   664,   665,     0,     0,   181,   666,   667,     0,
     668,   669,     0,   182,   183,   184,   670,   671,   672,     0,
       0,     0,     0,   673,   187,   674,     0,     0,   675,   188,
       0,   189,     0,     0,     0,   190,     0,   191,   192,   193,
     194,     0,     0,     0,   195,     0,     0,   196,   197,   198,
       0,     0,     0,   199,     0,   200,   201,     0,   202,   203,
     204,     0,     0,   205,     0,   206,   207,   208,   209,   210,
     676,     0,   211,   212,   213,   677,   678,   214,     0,   215,
     216,   217,   679,     0,   218,     0,     0,     0,   219,   220,
    1979,   221,     0,   222,     0,   680,   224,   681,   226,     0,
     227,     0,   682,     0,   228,   229,     0,   230,   683,     0,
     231,   232,     0,     0,     0,   684,   234,   235,   236,   685,
       0,   237,   238,     0,     0,   239,     0,   240,     0,     0,
     686,   241,   242,   687,     0,     0,   243,     0,     0,   244,
     245,     0,     0,     0,   246,     0,     0,   247,   248,     0,
       0,   249,     0,   688,   250,   251,     0,     0,     0,     0,
       0,   689,   253,     0,   254,     0,   255,     0,   256,   257,
       0,     0,   690,     0,     0,     0,     0,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   691,   273,   274,   275,   276,   692,   277,   278,
     279,     0,     0,     0,   280,   281,   282,   693,   284,     0,
       0,   694,   286,   695,   287,     0,   288,   696,   697,   698,
     699,   700,   293,   294,   295,   296,     0,   701,   297,   298,
       0,     0,   299,   300,   301,   302,   702,   703,   704,   303,
     304,     0,   705,   706,     0,   305,   306,   707,     0,   308,
     309,   310,     0,   311,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   312,   313,   708,   314,   315,   316,   317,
     318,   709,   320,   321,   322,   710,   711,   325,   712,     0,
     326,   327,   328,     0,   329,     0,   330,   331,     0,   713,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,   340,     0,     0,   341,   342,   343,     0,   344,
     345,     0,   346,   347,   348,   714,   715,   349,     0,   350,
     351,   352,     0,   353,   354,     0,     0,   716,   355,   356,
     357,   358,   359,   717,   361,   362,   363,     0,   718,   365,
       0,     0,     0,   366,   367,   368,   369,     0,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,     0,   375,
     376,   377,   378,     0,     0,     0,     0,     0,     0,   379,
     380,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,   719,   720,   386,   387,     0,   388,   721,   390,   391,
     392,   722,   723,   393,   394,   724,   395,   396,     0,     0,
     397,   398,     0,   725,   399,   400,     0,   726,   727,   728,
     729,     0,     0,     0,     0,     0,   405,   406,     0,   730,
     731,   732,   408,   409,   410,   733,   411,   412,   734,   413,
     414,     0,   415,   416,     0,     0,   417,     0,     0,   418,
       0,   419,     0,   735,   421,     0,     0,   736,   737,   738,
     739,   422,     0,     0,   423,   740,     0,   741,   424,   425,
     426,   742,     0,     0,     0,     0,   428,   429,     0,   430,
     431,     0,     0,   743,     0,     0,     0,   744,   745,     0,
       0,     0,     0,   746,   747,     0,     0,   748,   749,     0,
     750,   751,   136,     0,   649,   138,   139,   140,   141,     0,
       0,     0,     0,     0,   142,     0,     0,   650,     0,   144,
     145,   146,   147,   148,   651,   150,     0,   151,     0,     0,
     652,   152,   653,   654,   655,   153,   656,     0,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   657,   658,
     160,     0,   161,   659,   660,   163,     0,   164,   165,   166,
     661,   168,     0,   662,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,   663,     0,   180,
     664,   665,     0,     0,   181,   666,   667,     0,   668,   669,
       0,   182,   183,   184,   670,   671,   672,     0,     0,     0,
       0,   673,   187,   674,     0,     0,   675,   188,     0,   189,
       0,     0,     0,   190,     0,   191,   192,   193,   194,     0,
       0,     0,   195,     0,     0,   196,   197,   198,     0,     0,
       0,   199,     0,   200,   201,     0,   202,   203,   204,     0,
       0,   205,     0,   206,   207,   208,   209,   210,   676,     0,
     211,   212,   213,   677,   678,   214,     0,   215,   216,   217,
     679,     0,   218,     0,     0,     0,   219,   220,  1981,   221,
       0,   222,     0,   680,   224,   681,   226,     0,   227,     0,
     682,     0,   228,   229,     0,   230,   683,     0,   231,   232,
       0,     0,     0,   684,   234,   235,   236,   685,     0,   237,
     238,     0,     0,   239,     0,   240,     0,     0,   686,   241,
     242,   687,     0,     0,   243,     0,     0,   244,   245,     0,
       0,     0,   246,     0,     0,   247,   248,     0,     0,   249,
       0,   688,   250,   251,     0,     0,     0,     0,     0,   689,
     253,     0,   254,     0,   255,     0,   256,   257,     0,     0,
     690,     0,     0,     0,     0,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     691,   273,   274,   275,   276,   692,   277,   278,   279,     0,
       0,     0,   280,   281,   282,   693,   284,     0,     0,   694,
     286,   695,   287,     0,   288,   696,   697,   698,   699,   700,
     293,   294,   295,   296,     0,   701,   297,   298,     0,     0,
     299,   300,   301,   302,   702,   703,   704,   303,   304,     0,
     705,   706,     0,   305,   306,   707,     0,   308,   309,   310,
       0,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   312,   313,   708,   314,   315,   316,   317,   318,   709,
     320,   321,   322,   710,   711,   325,   712,     0,   326,   327,
     328,     0,   329,     0,   330,   331,     0,   713,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
     340,     0,     0,   341,   342,   343,     0,   344,   345,     0,
     346,   347,   348,   714,   715,   349,     0,   350,   351,   352,
       0,   353,   354,     0,     0,   716,   355,   356,   357,   358,
     359,   717,   361,   362,   363,     0,   718,   365,     0,     0,
       0,   366,   367,   368,   369,     0,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,     0,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,   379,   380,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,   719,
     720,   386,   387,     0,   388,   721,   390,   391,   392,   722,
     723,   393,   394,   724,   395,   396,     0,     0,   397,   398,
       0,   725,   399,   400,     0,   726,   727,   728,   729,     0,
       0,     0,     0,     0,   405,   406,     0,   730,   731,   732,
     408,   409,   410,   733,   411,   412,   734,   413,   414,     0,
     415,   416,     0,     0,   417,     0,     0,   418,     0,   419,
       0,   735,   421,     0,     0,   736,   737,   738,   739,   422,
       0,     0,   423,   740,     0,   741,   424,   425,   426,   742,
       0,     0,     0,     0,   428,   429,     0,   430,   431,     0,
       0,   743,     0,     0,     0,   744,   745,     0,     0,     0,
       0,   746,   747,     0,     0,   748,   749,     0,   750,   751,
     136,     0,   649,   138,   139,   140,   141,     0,     0,     0,
       0,     0,   142,     0,     0,   650,     0,   144,   145,   146,
     147,   148,   651,   150,     0,   151,     0,     0,   652,   152,
     653,   654,   655,   153,   656,     0,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   657,   658,   160,     0,
     161,   659,   660,   163,     0,   164,   165,   166,   661,   168,
       0,   662,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,     0,   178,     0,   663,     0,   180,   664,   665,
       0,     0,   181,   666,   667,     0,   668,   669,     0,   182,
     183,   184,   670,   671,   672,     0,     0,     0,     0,   673,
     187,   674,     0,     0,   675,   188,     0,   189,     0,     0,
       0,   190,     0,   191,   192,   193,   194,     0,     0,     0,
     195,     0,     0,   196,   197,   198,     0,     0,     0,   199,
       0,   200,   201,     0,   202,   203,   204,     0,     0,   205,
       0,   206,   207,   208,   209,   210,   676,     0,   211,   212,
     213,   677,   678,   214,     0,   215,   216,   217,   679,     0,
     218,     0,     0,     0,   219,   220,     0,   221,     0,   222,
       0,   680,   224,   681,   226,     0,   227,     0,   682,     0,
     228,   229,     0,   230,   683,     0,   231,   232,     0,     0,
       0,   684,   234,   235,   236,   685,     0,   237,   238,     0,
       0,   239,     0,   240,     0,     0,   686,   241,   242,   687,
       0,     0,   243,     0,     0,   244,   245,     0,     0,     0,
     246,     0,     0,   247,   248,     0,     0,   249,     0,   688,
     250,   251,     0,     0,     0,     0,     0,   689,   253,     0,
     254,     0,   255,     0,   256,   257,     0,     0,   690,     0,
       0,     0,     0,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   691,   273,
     274,   275,   276,   692,   277,   278,   279,     0,     0,     0,
     280,   281,   282,   693,   284,     0,     0,   694,   286,   695,
     287,     0,   288,   696,   697,   698,   699,   700,   293,   294,
     295,   296,     0,   701,   297,   298,     0,     0,   299,   300,
     301,   302,   702,   703,   704,   303,   304,     0,   705,   706,
       0,   305,   306,   707,     0,   308,   309,   310,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   312,
     313,   708,   314,   315,   316,   317,   318,   709,   320,   321,
     322,   710,   711,   325,   712,     0,   326,   327,   328,     0,
     329,     0,   330,   331,     0,   713,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,   340,     0,
       0,   341,   342,   343,     0,   344,   345,     0,   346,   347,
     348,   714,   715,   349,     0,   350,   351,   352,     0,   353,
     354,     0,     0,   716,   355,   356,   357,   358,   359,   717,
     361,   362,   363,     0,   718,   365,     0,     0,     0,   366,
     367,   368,   369,     0,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,     0,   375,   376,   377,   378,     0,
       0,     0,     0,     0,     0,   379,   380,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,   719,   720,   386,
     387,     0,   388,   721,   390,   391,   392,   722,   723,   393,
     394,   724,   395,   396,     0,     0,   397,   398,     0,   725,
     399,   400,     0,   726,   727,   728,   729,     0,     0,     0,
       0,     0,   405,   406,     0,   730,   731,   732,   408,   409,
     410,   733,   411,   412,   734,   413,   414,     0,   415,   416,
       0,     0,   417,     0,     0,   418,     0,   419,     0,   735,
     421,     0,     0,   736,   737,   738,   739,   422,     0,     0,
     423,   740,     0,   741,   424,   425,   426,   742,     0,     0,
       0,     0,   428,   429,     0,   430,   431,     0,     0,   743,
       0,     0,     0,   744,   745,     0,     0,     0,     0,   746,
     747,     0,     0,   748,   749,     0,   750,   751,   136,     0,
     649,   138,   139,   140,   141,  1573,     0,     0,     0,     0,
    1574,     0,     0,   650,     0,   144,   145,   146,   147,   148,
     651,   150,     0,   151,     0,     0,   652,   152,   653,   654,
     655,   153,   656,     0,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   657,   658,   160,     0,   161,   659,
     660,   163,     0,   164,   165,   166,   661,   168,     0,   662,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
       0,   178,     0,   663,     0,   180,   664,   665,     0,     0,
     181,   666,   667,     0,   668,   669,     0,   182,   183,   184,
     670,   671,   672,     0,     0,     0,     0,   673,   187,   674,
       0,     0,   675,   188,     0,   189,     0,     0,     0,   190,
       0,   191,   192,   193,   194,     0,     0,     0,   195,     0,
       0,   196,   197,   198,     0,     0,     0,   199,     0,   200,
     201,     0,   202,   203,   204,     0,     0,   205,     0,   206,
     207,   208,   209,   210,   676,     0,   211,   212,   213,   677,
     678,   214,     0,   215,   216,   217,   679,     0,   218,     0,
       0,     0,   219,   220,     0,   221,     0,   222,     0,   680,
     224,   681,   226,     0,   227,     0,   682,     0,   228,   229,
       0,   230,   683,     0,   231,   232,     0,     0,     0,   684,
     234,   235,   236,   685,     0,   237,   238,     0,     0,   239,
       0,   240,     0,     0,   686,   241,   242,   687,     0,     0,
     243,     0,     0,   244,   245,     0,     0,     0,   246,     0,
       0,   247,   248,     0,     0,   249,     0,   688,   250,   251,
       0,     0,     0,     0,     0,   689,   253,     0,   254,     0,
     255,     0,   256,   257,     0,     0,   690,     0,     0,     0,
       0,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   691,   273,   274,   275,
     276,   692,   277,   278,   279,     0,     0,     0,   280,   281,
     282,   693,   284,     0,     0,   694,   286,   695,   287,     0,
     288,   696,   697,   698,   699,   700,   293,   294,   295,   296,
       0,   701,   297,   298,     0,     0,   299,   300,   301,   302,
     702,     0,   704,   303,   304,     0,   705,   706,     0,   305,
     306,   707,     0,   308,   309,   310,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   312,   313,   708,
     314,   315,   316,   317,   318,   709,   320,   321,   322,   710,
     711,   325,   712,     0,   326,   327,   328,     0,   329,     0,
     330,   331,     0,   713,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,   340,     0,     0,   341,
     342,   343,     0,   344,   345,     0,   346,   347,   348,   714,
     715,   349,     0,   350,   351,   352,     0,   353,   354,     0,
       0,   716,   355,   356,   357,   358,   359,   717,   361,   362,
     363,     0,   718,   365,     0,     0,     0,   366,   367,   368,
     369,     0,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,     0,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,   379,   380,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,   719,   720,   386,   387,     0,
     388,   721,   390,   391,   392,   722,   723,   393,   394,   724,
     395,   396,     0,     0,   397,   398,     0,   725,   399,   400,
       0,   726,   727,   728,   729,     0,     0,     0,     0,     0,
     405,   406,     0,   730,   731,   732,   408,   409,   410,   733,
     411,   412,   734,   413,   414,     0,   415,   416,     0,     0,
     417,     0,     0,   418,     0,   419,     0,   735,   421,     0,
       0,   736,   737,   738,   739,   422,     0,     0,   423,   740,
       0,   741,   424,   425,   426,   742,     0,     0,     0,     0,
     428,   429,     0,   430,   431,     0,     0,   743,     0,     0,
       0,   744,   745,     0,     0,     0,     0,   746,   747,     0,
       0,   748,   749,     0,   750,   751,   136,     0,   649,   138,
     139,   140,   141,     0,     0,     0,     0,     0,   142,     0,
       0,   650,     0,   144,   145,   146,   147,   148,   651,   150,
       0,   151,     0,     0,   652,   152,   653,   654,   655,   153,
     656,     0,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   657,   658,   160,     0,   161,   659,   660,   163,
       0,   164,   165,   166,   661,   168,     0,   662,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,     0,   178,
       0,   663,     0,   180,   664,   665,     0,     0,   181,   666,
     667,     0,   668,   669,     0,   182,   183,   184,   670,   671,
     672,     0,     0,     0,     0,   673,   187,   674,     0,     0,
     675,   188,     0,   189,     0,     0,     0,   190,     0,   191,
     192,   193,   194,     0,     0,     0,   195,     0,     0,   196,
     197,   198,     0,     0,     0,   199,     0,   200,   201,     0,
     202,   203,   204,     0,     0,   205,     0,   206,   207,   208,
     209,   210,   676,     0,   211,   212,   213,   677,   678,   214,
       0,   215,   216,   217,   679,     0,   218,     0,     0,     0,
     219,   220,     0,   221,     0,   222,     0,   680,   224,   681,
     226,     0,   227,     0,   682,     0,   228,   229,     0,   230,
     683,     0,   231,   232,     0,     0,     0,   684,   234,   235,
     236,   685,     0,   237,   238,     0,     0,   239,     0,   240,
       0,     0,   686,   241,   242,  2355,     0,     0,   243,     0,
       0,   244,   245,     0,     0,     0,   246,     0,     0,   247,
     248,     0,     0,   249,     0,   688,   250,   251,     0,     0,
       0,     0,     0,   689,   253,     0,   254,     0,   255,     0,
     256,   257,     0,     0,   690,     0,     0,     0,     0,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   691,   273,   274,   275,   276,   692,
     277,   278,   279,     0,     0,     0,   280,   281,   282,   693,
     284,     0,     0,   694,   286,   695,   287,     0,   288,   696,
     697,   698,   699,   700,   293,   294,   295,   296,     0,   701,
     297,   298,     0,     0,   299,   300,   301,   302,   702,   703,
     704,   303,   304,     0,   705,   706,     0,   305,   306,   707,
       0,   308,   309,   310,     0,   311,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   312,   313,   708,   314,   315,
     316,   317,   318,   709,   320,   321,   322,   710,   711,   325,
     712,     0,   326,   327,   328,     0,   329,     0,   330,   331,
       0,   713,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,   340,     0,     0,   341,   342,   343,
       0,   344,   345,     0,   346,   347,   348,   714,   715,   349,
       0,   350,   351,   352,     0,   353,   354,     0,     0,   716,
     355,   356,   357,   358,   359,   717,   361,   362,   363,     0,
     718,   365,     0,     0,     0,   366,   367,   368,   369,     0,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
       0,   375,   376,   377,   378,     0,     0,     0,     0,     0,
       0,   379,   380,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,   719,   720,   386,   387,     0,   388,   721,
     390,   391,   392,   722,   723,   393,   394,   724,   395,   396,
       0,     0,   397,   398,     0,   725,   399,   400,     0,   726,
     727,   728,   729,     0,     0,     0,     0,     0,   405,   406,
       0,   730,   731,   732,   408,   409,   410,   733,   411,   412,
     734,   413,   414,     0,   415,   416,     0,     0,   417,     0,
       0,   418,     0,   419,     0,   735,   421,     0,     0,   736,
     737,   738,   739,   422,     0,     0,   423,   740,     0,   741,
     424,   425,   426,   742,     0,     0,     0,     0,   428,   429,
       0,   430,   431,     0,     0,   743,     0,     0,     0,   744,
     745,     0,     0,     0,     0,   746,   747,     0,     0,   748,
     749,     0,   750,   751,   136,     0,   649,   138,   139,   140,
     141,     0,     0,     0,     0,     0,   142,     0,     0,   650,
       0,   144,   145,   146,   147,   148,   651,   150,     0,   151,
       0,     0,   652,   152,   653,   654,   655,   153,   656,     0,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     657,   658,   160,     0,   161,   659,   660,   163,     0,   164,
     165,   166,   661,   168,     0,   662,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,     0,   178,     0,   663,
       0,   180,   664,   665,     0,     0,   181,   666,   667,     0,
     668,   669,     0,   182,   183,   184,   670,   671,   672,     0,
       0,     0,     0,   673,   187,   674,     0,     0,   675,   188,
       0,   189,     0,     0,     0,   190,     0,   191,   192,   193,
     194,     0,     0,     0,   195,     0,     0,   196,   197,   198,
       0,     0,     0,   199,     0,   200,   201,     0,   202,   203,
     204,     0,     0,   205,     0,   206,   207,   208,   209,   210,
     676,     0,   211,   212,   213,   677,   678,   214,     0,   215,
     216,   217,   679,     0,   218,     0,     0,     0,   219,   220,
       0,   221,     0,   222,     0,   680,   224,   681,   226,     0,
     227,     0,   682,     0,   228,   229,     0,   230,   683,     0,
     231,   232,     0,     0,     0,   684,   234,   235,   236,   685,
       0,   237,   238,     0,     0,   239,     0,   240,     0,     0,
     686,   241,   242,  2401,     0,     0,   243,     0,     0,   244,
     245,     0,     0,     0,   246,     0,     0,   247,   248,     0,
       0,   249,     0,   688,   250,   251,     0,     0,     0,     0,
       0,   689,   253,     0,   254,     0,   255,     0,   256,   257,
       0,     0,   690,     0,     0,     0,     0,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   691,   273,   274,   275,   276,   692,   277,   278,
     279,     0,     0,     0,   280,   281,   282,   693,   284,     0,
       0,   694,   286,   695,   287,     0,   288,   696,   697,   698,
     699,   700,   293,   294,   295,   296,     0,   701,   297,   298,
       0,     0,   299,   300,   301,   302,   702,   703,   704,   303,
     304,     0,   705,   706,     0,   305,   306,   707,     0,   308,
     309,   310,     0,   311,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   312,   313,   708,   314,   315,   316,   317,
     318,   709,   320,   321,   322,   710,   711,   325,   712,     0,
     326,   327,   328,     0,   329,     0,   330,   331,     0,   713,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,   340,     0,     0,   341,   342,   343,     0,   344,
     345,     0,   346,   347,   348,   714,   715,   349,     0,   350,
     351,   352,     0,   353,   354,     0,     0,   716,   355,   356,
     357,   358,   359,   717,   361,   362,   363,     0,   718,   365,
       0,     0,     0,   366,   367,   368,   369,     0,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,     0,   375,
     376,   377,   378,     0,     0,     0,     0,     0,     0,   379,
     380,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,   719,   720,   386,   387,     0,   388,   721,   390,   391,
     392,   722,   723,   393,   394,   724,   395,   396,     0,     0,
     397,   398,     0,   725,   399,   400,     0,   726,   727,   728,
     729,     0,     0,     0,     0,     0,   405,   406,     0,   730,
     731,   732,   408,   409,   410,   733,   411,   412,   734,   413,
     414,     0,   415,   416,     0,     0,   417,     0,     0,   418,
       0,   419,     0,   735,   421,     0,     0,   736,   737,   738,
     739,   422,     0,     0,   423,   740,     0,   741,   424,   425,
     426,   742,     0,     0,     0,     0,   428,   429,     0,   430,
     431,     0,     0,   743,     0,     0,     0,   744,   745,     0,
       0,     0,     0,   746,   747,     0,     0,   748,   749,     0,
     750,   751,   136,     0,   649,   138,   139,   140,   141,     0,
       0,     0,     0,     0,   142,     0,     0,   650,     0,   144,
     145,   146,   147,   148,   651,   150,     0,   151,     0,     0,
     652,   152,   653,   654,   655,   153,   656,     0,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   657,   658,
     160,     0,   161,   659,   660,   163,     0,   164,   165,   166,
     661,   168,     0,   662,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,   663,     0,   180,
     664,   665,     0,     0,   181,   666,   667,     0,   668,   669,
       0,   182,   183,   184,   670,   671,   672,     0,     0,     0,
       0,   673,   187,   674,     0,     0,  2998,   188,     0,   189,
       0,     0,     0,   190,     0,   191,   192,   193,   194,     0,
       0,     0,   195,     0,     0,   196,   197,   198,     0,     0,
       0,   199,     0,   200,   201,     0,   202,   203,   204,     0,
       0,   205,     0,   206,   207,   208,   209,   210,   676,     0,
     211,   212,   213,   677,   678,   214,     0,   215,   216,   217,
     679,     0,   218,     0,     0,     0,   219,   220,     0,   221,
       0,   222,     0,   680,   224,   681,   226,     0,   227,     0,
     682,     0,   228,   229,     0,   230,   683,     0,   231,   232,
       0,     0,     0,   684,   234,   235,   236,   685,     0,   237,
     238,     0,     0,   239,     0,   240,     0,     0,   686,   241,
     242,   687,     0,     0,   243,     0,     0,   244,   245,     0,
       0,     0,   246,     0,     0,   247,   248,     0,     0,   249,
       0,   688,   250,   251,     0,     0,     0,     0,     0,   689,
     253,     0,   254,     0,   255,     0,   256,   257,     0,     0,
     690,     0,     0,     0,     0,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     691,   273,   274,   275,   276,   692,   277,   278,   279,     0,
       0,     0,   280,   281,   282,   693,   284,     0,     0,   694,
     286,   695,   287,     0,   288,   696,   697,   698,   699,   700,
     293,   294,   295,   296,     0,   701,   297,   298,     0,     0,
     299,   300,   301,   302,   702,   703,   704,   303,   304,     0,
     705,   706,     0,   305,   306,   707,     0,   308,   309,   310,
       0,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   312,   313,   708,   314,   315,   316,   317,   318,   709,
     320,   321,   322,   710,   711,   325,   712,     0,   326,   327,
     328,     0,   329,     0,   330,   331,     0,   713,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
     340,     0,     0,   341,   342,   343,     0,   344,   345,     0,
     346,   347,   348,   714,   715,   349,     0,   350,   351,   352,
       0,   353,   354,     0,     0,   716,   355,   356,   357,   358,
     359,   717,   361,   362,   363,     0,   718,   365,     0,     0,
       0,   366,   367,   368,   369,     0,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,     0,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,   379,   380,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,   719,
     720,   386,   387,     0,   388,   721,   390,   391,   392,   722,
     723,   393,   394,   724,   395,   396,     0,     0,   397,   398,
       0,   725,   399,   400,     0,   726,   727,   728,   729,     0,
       0,     0,     0,     0,   405,   406,     0,   730,   731,   732,
     408,   409,   410,   733,   411,   412,   734,   413,   414,     0,
     415,   416,     0,     0,   417,     0,     0,   418,     0,   419,
       0,   735,   421,     0,     0,   736,   737,   738,   739,   422,
       0,     0,   423,   740,     0,   741,   424,   425,   426,   742,
       0,     0,     0,     0,   428,   429,     0,   430,   431,     0,
       0,   743,     0,     0,     0,   744,   745,     0,     0,     0,
       0,   746,   747,     0,     0,   748,   749,     0,   750,   751,
     136,     0,   649,   138,   139,   140,   141,     0,     0,     0,
       0,     0,   142,     0,     0,   650,     0,   144,   145,   146,
     147,   148,   651,   150,     0,   151,     0,     0,   652,   152,
     653,   654,   655,   153,   656,     0,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   657,   658,   160,     0,
     161,   659,   660,   163,     0,   164,   165,   166,   661,   168,
       0,   662,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,     0,   178,     0,   663,     0,   180,   664,   665,
       0,     0,   181,   666,   667,     0,   668,   669,     0,   182,
     183,   184,   670,   671,   672,     0,     0,     0,     0,   673,
     187,   674,     0,     0,   675,   188,     0,   189,     0,     0,
       0,   190,     0,   191,   192,   193,   194,     0,     0,     0,
     195,     0,     0,   196,   197,   198,     0,     0,     0,   199,
       0,   200,   201,     0,   202,   203,   204,     0,     0,   205,
       0,   206,   207,   208,   209,   210,   676,     0,   211,   212,
     213,   677,   678,   214,     0,   215,   216,   217,   679,     0,
     218,     0,     0,     0,   219,   220,     0,   221,     0,   222,
       0,   680,   224,   681,   226,     0,   227,     0,   682,     0,
     228,   229,     0,   230,   683,     0,   231,   232,     0,     0,
       0,   684,   234,   235,   236,   685,     0,   237,   238,     0,
       0,   239,     0,   240,     0,     0,   686,   241,   242,   687,
       0,     0,   243,     0,     0,   244,   245,     0,     0,     0,
     246,     0,     0,   247,   248,     0,     0,   249,     0,   688,
     250,   251,     0,     0,     0,     0,     0,   689,   253,     0,
     254,     0,   255,     0,   256,   257,     0,     0,   690,     0,
       0,     0,     0,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   691,   273,
     274,   275,   276,   692,   277,   278,   279,     0,     0,     0,
     280,   281,   282,   693,   284,     0,     0,   694,   286,   695,
     287,     0,   288,   696,   697,   698,   699,   700,   293,   294,
     295,   296,     0,   701,   297,   298,     0,     0,   299,   300,
     301,   302,   702,     0,   704,   303,   304,     0,   705,   706,
       0,   305,   306,   707,     0,   308,   309,   310,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   312,
     313,   708,   314,   315,   316,   317,   318,   709,   320,   321,
     322,   710,   711,   325,   712,     0,   326,   327,   328,     0,
     329,     0,   330,   331,     0,   713,   333,   334,     0,     0,
     335,     0,     0,     0,   336,   337,   338,   339,   340,     0,
       0,   341,   342,   343,     0,   344,   345,     0,   346,   347,
     348,   714,   715,   349,     0,   350,   351,   352,     0,   353,
     354,     0,     0,   716,   355,   356,   357,   358,   359,   717,
     361,   362,   363,     0,   718,   365,     0,     0,     0,   366,
     367,   368,   369,     0,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,     0,   375,   376,   377,   378,     0,
       0,     0,     0,     0,     0,   379,   380,     0,   381,     0,
       0,   382,     0,     0,   383,   384,   385,   719,   720,   386,
     387,     0,   388,   721,   390,   391,   392,   722,   723,   393,
     394,   724,   395,   396,     0,     0,   397,   398,     0,   725,
     399,   400,     0,   726,   727,   728,   729,     0,     0,     0,
       0,     0,   405,   406,     0,   730,   731,   732,   408,   409,
     410,   733,   411,   412,   734,   413,   414,     0,   415,   416,
       0,     0,   417,     0,     0,   418,     0,   419,     0,   735,
     421,     0,     0,   736,   737,   738,   739,   422,     0,     0,
     423,   740,     0,   741,   424,   425,   426,   742,     0,     0,
       0,     0,   428,   429,     0,   430,   431,     0,     0,   743,
       0,     0,     0,   744,   745,     0,     0,     0,     0,   746,
     747,     0,     0,   748,   749,     0,   750,   751,   136,     0,
     649,   138,   139,   140,   141,     0,     0,     0,     0,     0,
     142,     0,     0,   650,     0,   144,   145,   146,   147,   148,
     651,   150,     0,   151,     0,     0,   652,   152,   653,   654,
     655,   153,   656,     0,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   657,   658,   160,     0,   161,   659,
     660,   163,     0,   164,   165,   166,   661,   168,     0,   662,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
       0,   178,     0,   663,     0,   180,   664,   665,     0,     0,
     181,   666,   667,     0,   668,   669,     0,   182,   183,   184,
     670,   671,   672,     0,     0,     0,     0,   673,   187,   674,
       0,     0,   675,   188,     0,   189,     0,     0,     0,   190,
       0,   191,   192,   193,   194,     0,     0,     0,   195,     0,
       0,   196,   197,   198,     0,     0,     0,   199,     0,   200,
     201,     0,   202,   203,   204,     0,     0,   205,     0,   206,
     207,   208,   209,   210,   676,     0,   211,   212,   213,   677,
     678,   214,     0,   215,   216,   217,   679,     0,   218,     0,
       0,     0,   219,   220,     0,   221,     0,   222,     0,   680,
     224,   681,   226,     0,   227,     0,   682,     0,   228,   229,
       0,   230,   683,     0,   231,   232,     0,     0,     0,   684,
     234,   235,   236,   685,     0,   237,   238,     0,     0,   239,
       0,   240,     0,     0,   686,   241,   242,   687,     0,     0,
     243,     0,     0,   244,   245,     0,     0,     0,   246,     0,
       0,   247,   248,     0,     0,   249,     0,   688,   250,   251,
       0,     0,     0,     0,     0,   689,   253,     0,   254,     0,
     255,     0,   256,   257,     0,     0,   690,     0,     0,     0,
       0,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   691,   273,   274,   275,
     276,   692,   277,   278,  3888,     0,     0,     0,   280,   281,
     282,   693,   284,     0,     0,   694,   286,   695,   287,     0,
     288,   696,   697,   698,   699,   700,   293,   294,   295,   296,
       0,   701,   297,   298,     0,     0,   299,   300,   301,   302,
     702,     0,   704,   303,   304,     0,   705,   706,     0,   305,
     306,   707,     0,   308,   309,   310,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   312,   313,   708,
     314,   315,   316,   317,   318,   709,   320,   321,   322,   710,
     711,   325,   712,     0,   326,   327,   328,     0,   329,     0,
     330,   331,     0,   713,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,   340,     0,     0,   341,
     342,   343,     0,   344,   345,     0,   346,   347,   348,   714,
     715,   349,     0,   350,   351,   352,     0,   353,   354,     0,
       0,   716,   355,   356,   357,   358,   359,   717,   361,   362,
     363,     0,   718,   365,     0,     0,     0,   366,   367,   368,
     369,     0,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,     0,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,   379,   380,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,   719,   720,   386,   387,     0,
     388,   721,   390,   391,   392,   722,   723,   393,   394,   724,
     395,   396,     0,     0,   397,   398,     0,   725,   399,   400,
       0,   726,   727,   728,   729,     0,     0,     0,     0,     0,
     405,   406,     0,   730,   731,   732,   408,   409,   410,   733,
     411,   412,   734,   413,   414,     0,   415,   416,     0,     0,
     417,     0,     0,   418,     0,   419,     0,   735,   421,     0,
       0,   736,   737,   738,   739,   422,     0,     0,   423,   740,
       0,   741,   424,   425,   426,   742,     0,     0,     0,     0,
     428,   429,     0,   430,   431,     0,     0,   743,     0,     0,
       0,   744,   745,     0,     0,     0,     0,   746,   747,     0,
       0,   748,   749,     0,   750,   751,   136,     0,   137,   138,
     139,   140,   141,     0,     0,     0,     0,     0,   142,     0,
       0,   143,     0,   144,   145,   146,   147,   148,   149,   150,
       0,   151,     0,     0,     0,   152,     0,     0,     0,   153,
       0,     0,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,     0,   161,   162,     0,   163,
       0,   164,   165,   166,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,     0,   178,
    2201,   179,     0,   180,     0,     0,     0,     0,   181,     0,
       0,     0,     0,     0,     0,   182,   183,   184,     0,     0,
     185,     0,     0,     0,     0,   186,   187,     0,     0,     0,
       0,   188,     0,   189,     0,     0,     0,   190,     0,   191,
     192,   193,   194,     0,     0,     0,   195,     0,     0,   196,
     197,   198,     0,     0,     0,   199,     0,   200,   201,     0,
     202,   203,   204,     0,     0,   205,     0,   206,   207,   208,
     209,   210,     0,     0,   211,   212,   213,     0,     0,   214,
       0,   215,   216,   217,     0,     0,   218,     0,     0,     0,
     219,   220,     0,   221,  2202,   222,     0,   223,   224,   225,
     226,     0,   227,     0,     0,     0,   228,   229,     0,   230,
       0,     0,   231,   232,     0,     0,     0,   233,   234,   235,
     236,     0,     0,   237,   238,  1353,     0,   239,     0,   240,
       0,     0,     0,   241,   242,     0,     0,     0,   243,     0,
       0,   244,   245,     0,     0,     0,   246,  1354,     0,   247,
     248,     0,     0,   249,     0,     0,   250,   251,     0,  2688,
       0,     0,     0,   252,   253,     0,   254,     0,   255,     0,
     256,   257,     0,     0,     0,     0,     0,     0,     0,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,     0,   273,   274,   275,   276,     0,
     277,   278,   279,     0,     0,     0,   280,   281,   282,   283,
     284,     0,     0,   285,   286,     0,   287,     0,   288,     0,
     289,   290,   291,   292,   293,   294,   295,   296,     0,     0,
     297,   298,     0,     0,   299,   300,   301,   302,     0,     0,
       0,   303,   304,     0,     0,     0,     0,   305,   306,   307,
       0,   308,   309,   310,     0,   311,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   312,   313,     0,   314,   315,
     316,   317,  2689,   319,   320,   321,   322,   323,   324,   325,
       0,     0,   326,   327,   328,     0,   329,     0,   330,   331,
       0,   332,   333,   334,     0,     0,   335,     0,     0,     0,
     336,   337,   338,   339,   340,     0,     0,   341,   342,   343,
       0,   344,   345,     0,   346,   347,   348,     0,     0,   349,
       0,   350,   351,   352,     0,   353,   354,     0,     0,     0,
     355,   356,   357,   358,   359,   360,   361,   362,   363,     0,
     364,   365,  -398,     0,     0,   366,   367,   368,   369,     0,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
       0,   375,   376,   377,   378,  2204,     0,     0,     0,     0,
       0,   379,   380,     0,   381,     0,     0,   382,     0,     0,
     383,   384,   385,     0,     0,   386,   387,     0,   388,   389,
     390,   391,   392,     0,     0,   393,   394,     0,   395,   396,
       0,     0,   397,   398,     0,     0,   399,   400,     0,   401,
     402,   403,   404,     0,     0,     0,     0,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,   411,   412,
       0,   413,   414,     0,   415,   416,     0,     0,   417,     0,
       0,   418,     0,   419,     0,   420,   421,     0,     0,     0,
       0,     0,     0,   422,     0,     0,   423,     0,     0,     0,
     424,   425,   426,   427,     0,     0,     0,     0,   428,   429,
       0,   430,   431,     0,     0,   432,     0,   136,     0,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,   143,  2265,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,  2201,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,  2202,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,  1353,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,  1354,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,  2204,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,     0,   432,     0,   136,     0,
     137,   138,   139,   140,   141,     0,     0,     0,     0,     0,
     142,     0,     0,   143,  2265,   144,   145,   146,   147,   148,
     149,   150,     0,   151,     0,     0,     0,   152,     0,     0,
       0,   153,     0,     0,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,     0,     0,   160,     0,   161,   162,
       0,   163,     0,   164,   165,   166,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
       0,   178,     0,   179,     0,   180,     0,     0,     0,     0,
     181,     0,     0,     0,     0,     0,     0,   182,   183,   184,
       0,     0,   185,     0,     0,     0,     0,   186,   187,     0,
       0,     0,     0,   188,     0,   189,     0,     0,     0,   190,
       0,   191,   192,   193,   194,     0,     0,     0,   195,     0,
       0,   196,   197,   198,     0,     0,     0,   199,     0,   200,
     201,     0,   202,   203,   204,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,   211,   212,   213,     0,
       0,   214,     0,   215,   216,   217,     0,     0,   218,     0,
       0,     0,   219,   220,     0,   221,     0,   222,     0,   223,
     224,   225,   226,     0,   227,     0,     0,     0,   228,   229,
       0,   230,     0,     0,   231,   232,     0,     0,     0,   233,
     234,   235,   236,     0,     0,   237,   238,     0,     0,   239,
       0,   240,     0,     0,     0,   241,   242,     0,     0,     0,
     243,     0,     0,   244,   245,     0,     0,     0,   246,     0,
       0,   247,   248,     0,     0,   249,     0,     0,   250,   251,
       0,     0,     0,     0,     0,   252,   253,     0,   254,     0,
     255,     0,   256,   257,     0,     0,     0,     0,     0,     0,
       0,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,     0,   273,   274,   275,
     276,     0,   277,   278,   279,     0,     0,     0,   280,   281,
     282,   283,   284,     0,     0,   285,   286,     0,   287,     0,
     288,     0,   289,   290,   291,   292,   293,   294,   295,   296,
       0,     0,   297,   298,     0,     0,   299,   300,   301,   302,
       0,     0,     0,   303,   304,     0,     0,     0,     0,   305,
     306,   307,     0,   308,   309,   310,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   312,   313,     0,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,     0,     0,   326,   327,   328,     0,   329,     0,
     330,   331,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,   340,     0,     0,   341,
     342,   343,     0,   344,   345,     0,   346,   347,   348,     0,
       0,   349,     0,   350,   351,   352,     0,   353,   354,     0,
       0,     0,   355,   356,   357,   358,   359,   360,   361,   362,
     363,     0,   364,   365,  2070,     0,     0,   366,   367,   368,
     369,     0,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,     0,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,   379,   380,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,   386,   387,     0,
     388,   389,   390,   391,   392,     0,     0,   393,   394,     0,
     395,   396,     0,     0,   397,   398,     0,     0,   399,   400,
       0,   401,   402,   403,   404,     0,     0,     0,     0,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
     411,   412,     0,   413,   414,     0,   415,   416,     0,     0,
     417,     0,     0,   418,     0,   419,     0,   420,   421,     0,
       0,     0,     0,     0,     0,   422,     0,     0,   423,     0,
       0,     0,   424,   425,   426,   427,     0,     0,     0,     0,
     428,   429,     0,   430,   431,     0,     0,   432,     0,   136,
       0,   137,   138,   139,   140,   141,     0,     0,     0,  2467,
       0,   142,     0,     0,   143,   751,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,     0,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,     0,   432,     0,
       0,     0,   136,     0,   137,   138,   139,   140,   141,     0,
    3923,     0,     0,     0,   142,  3924,   751,   143,     0,   144,
     145,   146,   147,   148,   149,   150,     0,   151,     0,     0,
       0,   152,     0,     0,     0,   153,     0,     0,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,   162,     0,   163,     0,   164,   165,   166,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,   179,     0,   180,
       0,     0,     0,     0,   181,     0,     0,     0,     0,     0,
       0,   182,   183,   184,     0,     0,   185,     0,     0,     0,
       0,   186,   187,     0,     0,     0,     0,   188,     0,   189,
       0,     0,     0,   190,     0,   191,   192,   193,   194,     0,
       0,     0,   195,     0,     0,   196,   197,   198,     0,     0,
       0,   199,     0,   200,   201,     0,   202,   203,   204,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
     211,   212,   213,     0,     0,   214,     0,   215,   216,   217,
       0,     0,   218,     0,     0,     0,   219,   220,     0,   221,
       0,   222,     0,   223,   224,   225,   226,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,     0,   231,   232,
       0,     0,     0,   233,   234,   235,   236,     0,     0,   237,
     238,     0,     0,   239,     0,   240,     0,     0,     0,   241,
     242,     0,  1224,     0,   243,     0,     0,   244,   245,     0,
       0,     0,   246,     0,     0,   247,   248,     0,     0,   249,
       0,     0,   250,   251,     0,     0,     0,     0,     0,   252,
     253,     0,   254,     0,   255,     0,   256,   257,     0,     0,
       0,     0,     0,     0,     0,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
       0,   273,   274,   275,   276,     0,   277,   278,   279,     0,
       0,     0,   280,   281,   282,   283,   284,     0,     0,   285,
     286,     0,   287,     0,   288,     0,   289,   290,   291,   292,
     293,   294,   295,   296,     0,     0,   297,   298,     0,     0,
     299,   300,   301,   302,     0,     0,     0,   303,   304,     0,
       0,     0,     0,   305,   306,   307,     0,   308,   309,   310,
       0,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   312,   313,     0,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,     0,     0,   326,   327,
     328,     0,   329,     0,   330,   331,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
     340,     0,     0,   341,   342,   343,     0,   344,   345,     0,
     346,   347,   348,     0,     0,   349,     0,   350,   351,   352,
       0,   353,   354,     0,     0,     0,   355,   356,   357,   358,
     359,   360,   361,   362,   363,     0,   364,   365,     0,     0,
       0,   366,   367,   368,   369,     0,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,     0,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,   379,   380,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,   386,   387,     0,   388,   389,   390,   391,   392,     0,
       0,   393,   394,     0,   395,   396,     0,     0,   397,   398,
       0,     0,   399,   400,     0,   401,   402,   403,   404,     0,
       0,     0,     0,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,   411,   412,     0,   413,   414,     0,
     415,   416,     0,     0,   417,     0,     0,   418,     0,   419,
       0,   420,   421,     0,     0,     0,     0,     0,     0,   422,
       0,     0,   423,     0,     0,     0,   424,   425,   426,   427,
       0,     0,     0,     0,   428,   429,     0,   430,   431,     0,
       0,   432,     0,   136,     0,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,   143,   476,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,     0,   432,     0,     0,     0,     0,   136,  1877,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
     476,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,     0,   432,     0,   136,     0,
     137,   138,   139,   140,   141,     0,     0,  2264,     0,     0,
     142,     0,     0,   143,  2265,   144,   145,   146,   147,   148,
     149,   150,     0,   151,     0,     0,     0,   152,     0,     0,
       0,   153,     0,     0,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,     0,     0,   160,     0,   161,   162,
       0,   163,     0,   164,   165,   166,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
       0,   178,     0,   179,     0,   180,     0,     0,     0,     0,
     181,     0,     0,     0,     0,     0,     0,   182,   183,   184,
       0,     0,   185,     0,     0,     0,     0,   186,   187,     0,
       0,     0,     0,   188,     0,   189,     0,     0,     0,   190,
       0,   191,   192,   193,   194,     0,     0,     0,   195,     0,
       0,   196,   197,   198,     0,     0,     0,   199,     0,   200,
     201,     0,   202,   203,   204,     0,     0,   205,     0,   206,
     207,   208,   209,   210,     0,     0,   211,   212,   213,     0,
       0,   214,     0,   215,   216,   217,     0,     0,   218,     0,
       0,     0,   219,   220,     0,   221,     0,   222,     0,   223,
     224,   225,   226,     0,   227,     0,     0,     0,   228,   229,
       0,   230,     0,     0,   231,   232,     0,     0,     0,   233,
     234,   235,   236,     0,     0,   237,   238,     0,     0,   239,
       0,   240,     0,     0,     0,   241,   242,     0,     0,     0,
     243,     0,     0,   244,   245,     0,     0,     0,   246,     0,
       0,   247,   248,     0,     0,   249,     0,     0,   250,   251,
       0,     0,     0,     0,     0,   252,   253,     0,   254,     0,
     255,     0,   256,   257,     0,     0,     0,     0,     0,     0,
       0,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,     0,   273,   274,   275,
     276,     0,   277,   278,   279,     0,     0,     0,   280,   281,
     282,   283,   284,     0,     0,   285,   286,     0,   287,     0,
     288,     0,   289,   290,   291,   292,   293,   294,   295,   296,
       0,     0,   297,   298,     0,     0,   299,   300,   301,   302,
       0,     0,     0,   303,   304,     0,     0,     0,     0,   305,
     306,   307,     0,   308,   309,   310,     0,   311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   312,   313,     0,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,     0,     0,   326,   327,   328,     0,   329,     0,
     330,   331,     0,   332,   333,   334,     0,     0,   335,     0,
       0,     0,   336,   337,   338,   339,   340,     0,     0,   341,
     342,   343,     0,   344,   345,     0,   346,   347,   348,     0,
       0,   349,     0,   350,   351,   352,     0,   353,   354,     0,
       0,     0,   355,   356,   357,   358,   359,   360,   361,   362,
     363,     0,   364,   365,     0,     0,     0,   366,   367,   368,
     369,     0,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,     0,   375,   376,   377,   378,     0,     0,     0,
       0,     0,     0,   379,   380,     0,   381,     0,     0,   382,
       0,     0,   383,   384,   385,     0,     0,   386,   387,     0,
     388,   389,   390,   391,   392,     0,     0,   393,   394,     0,
     395,   396,     0,     0,   397,   398,     0,     0,   399,   400,
       0,   401,   402,   403,   404,     0,     0,     0,     0,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
     411,   412,     0,   413,   414,     0,   415,   416,     0,     0,
     417,     0,     0,   418,     0,   419,     0,   420,   421,     0,
       0,     0,     0,     0,     0,   422,     0,     0,   423,     0,
       0,     0,   424,   425,   426,   427,     0,     0,     0,     0,
     428,   429,     0,   430,   431,     0,     0,   432,     0,     0,
       0,   136,     0,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,  3924,   751,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
       0,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,     0,
     432,     0,   136,     0,   137,   138,   139,   140,   141,     0,
       0,     0,     0,     0,   142,     0,     0,   143,   476,   144,
     145,   146,   147,   148,   149,   150,     0,   151,     0,     0,
       0,   152,     0,     0,     0,   153,     0,     0,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,   162,     0,   163,     0,   164,   165,   166,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,     0,   178,     0,   179,     0,   180,
       0,     0,     0,     0,   181,     0,     0,     0,     0,     0,
       0,   182,   183,   184,     0,     0,   185,     0,     0,     0,
       0,   186,   187,     0,     0,     0,     0,   188,     0,   189,
       0,     0,     0,   190,     0,   191,   192,   193,   194,     0,
       0,     0,   195,     0,     0,   196,   197,   198,     0,     0,
       0,   199,     0,   200,   201,     0,   202,   203,   204,     0,
       0,   205,     0,   206,   207,   208,   209,   210,     0,     0,
     211,   536,   213,     0,     0,   214,     0,   215,   216,   217,
       0,     0,   218,     0,     0,     0,   219,   220,     0,   221,
       0,   222,     0,   223,   224,   225,   226,     0,   227,     0,
       0,     0,   228,   229,     0,   230,     0,     0,   231,   232,
       0,     0,     0,   233,   234,   235,   236,     0,     0,   237,
     238,     0,     0,   239,     0,   240,     0,     0,     0,   241,
     242,     0,     0,     0,   243,     0,     0,   244,   245,     0,
       0,     0,   246,     0,     0,   247,   248,     0,     0,   249,
       0,     0,   250,   251,     0,     0,     0,     0,     0,   252,
     253,     0,   254,     0,   255,     0,   256,   257,     0,     0,
       0,     0,     0,     0,     0,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
       0,   273,   274,   275,   276,     0,   277,   278,   279,     0,
       0,     0,   280,   281,   282,   283,   284,     0,     0,   285,
     286,     0,   287,     0,   288,     0,   289,   290,   291,   292,
     293,   294,   295,   296,     0,     0,   297,   298,     0,     0,
     299,   300,   301,   302,     0,     0,     0,   303,   304,     0,
       0,     0,     0,   305,   306,   307,     0,   308,   309,   310,
       0,   311,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   312,   313,     0,   314,   315,   316,   537,   318,   319,
     320,   321,   322,   323,   324,   325,     0,     0,   326,   327,
     328,     0,   329,     0,   330,   331,     0,   332,   333,   334,
       0,     0,   335,     0,     0,     0,   336,   337,   338,   339,
     340,     0,     0,   341,   342,   343,     0,   344,   345,     0,
     346,   347,   348,     0,     0,   349,     0,   350,   351,   352,
       0,   353,   354,     0,     0,     0,   355,   356,   357,   358,
     359,   360,   361,   362,   363,     0,   364,   365,     0,     0,
       0,   366,   367,   368,   369,     0,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,     0,   375,   376,   377,
     378,     0,     0,     0,     0,     0,     0,   379,   380,     0,
     381,     0,     0,   382,     0,     0,   383,   384,   385,     0,
       0,   386,   387,     0,   388,   389,   390,   391,   392,     0,
       0,   393,   394,     0,   395,   396,     0,     0,   397,   398,
       0,     0,   399,   400,     0,   401,   402,   403,   404,     0,
       0,     0,     0,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,   411,   412,     0,   413,   414,     0,
     415,   416,     0,     0,   417,     0,     0,   418,     0,   419,
       0,   420,   421,     0,     0,     0,     0,     0,     0,   422,
       0,     0,   423,     0,     0,     0,   424,   425,   426,   427,
       0,     0,     0,     0,   428,   429,     0,   430,   431,     0,
       0,   432,     0,   136,     0,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,   143,   476,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,     0,   432,     0,   136,     0,   137,   138,   139,   140,
     141,     0,     0,     0,     0,     0,   142,     0,     0,   143,
     751,   144,   145,   146,   147,   148,   149,   150,     0,   151,
       0,     0,     0,   152,     0,     0,     0,   153,     0,     0,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,     0,   161,   162,     0,   163,     0,   164,
     165,   166,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,     0,   178,     0,   179,
       0,   180,     0,     0,     0,     0,   181,     0,     0,     0,
       0,     0,     0,   182,   183,   184,     0,     0,   185,     0,
       0,     0,     0,   186,   187,     0,     0,     0,     0,   188,
       0,   189,     0,     0,     0,   190,     0,   191,   192,   193,
     194,     0,     0,     0,   195,     0,     0,   196,   197,   198,
       0,     0,     0,   199,     0,   200,   201,     0,   202,   203,
     204,     0,     0,   205,     0,   206,   207,   208,   209,   210,
       0,     0,   211,   212,   213,     0,     0,   214,     0,   215,
     216,   217,     0,     0,   218,     0,     0,     0,   219,   220,
       0,   221,     0,   222,     0,   223,   224,   225,   226,     0,
     227,     0,     0,     0,   228,   229,     0,   230,     0,     0,
     231,   232,     0,     0,     0,   233,   234,   235,   236,     0,
       0,   237,   238,     0,     0,   239,     0,   240,     0,     0,
       0,   241,   242,     0,     0,     0,   243,     0,     0,   244,
     245,     0,     0,     0,   246,     0,     0,   247,   248,     0,
       0,   249,     0,     0,   250,   251,     0,     0,     0,     0,
       0,   252,   253,     0,   254,     0,   255,     0,   256,   257,
       0,     0,     0,     0,     0,     0,     0,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,     0,   273,   274,   275,   276,     0,   277,   278,
     279,     0,     0,     0,   280,   281,   282,   283,   284,     0,
       0,   285,   286,     0,   287,     0,   288,     0,   289,   290,
     291,   292,   293,   294,   295,   296,     0,     0,   297,   298,
       0,     0,   299,   300,   301,   302,     0,     0,     0,   303,
     304,     0,     0,     0,     0,   305,   306,   307,     0,   308,
     309,   310,     0,   311,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   312,   313,     0,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,     0,     0,
     326,   327,   328,     0,   329,     0,   330,   331,     0,   332,
     333,   334,     0,     0,   335,     0,     0,     0,   336,   337,
     338,   339,   340,     0,     0,   341,   342,   343,     0,   344,
     345,     0,   346,   347,   348,     0,     0,   349,     0,   350,
     351,   352,     0,   353,   354,     0,     0,     0,   355,   356,
     357,   358,   359,   360,   361,   362,   363,     0,   364,   365,
       0,     0,     0,   366,   367,   368,   369,     0,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,     0,   375,
     376,   377,   378,     0,     0,     0,     0,     0,     0,   379,
     380,     0,   381,     0,     0,   382,     0,     0,   383,   384,
     385,     0,     0,   386,   387,     0,   388,   389,   390,   391,
     392,     0,     0,   393,   394,     0,   395,   396,     0,     0,
     397,   398,     0,     0,   399,   400,     0,   401,   402,   403,
     404,     0,     0,     0,     0,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,   411,   412,     0,   413,
     414,     0,   415,   416,     0,     0,   417,     0,     0,   418,
       0,   419,     0,   420,   421,     0,     0,     0,     0,     0,
       0,   422,     0,     0,   423,     0,     0,     0,   424,   425,
     426,   427,     0,     0,     0,     0,   428,   429,     0,   430,
     431,     0,     0,   432,     0,   136,     0,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
     143,  2265,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,   548,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,   133,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,     0,   432,   136,     0,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
     143,  1560,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,   548,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,   133,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,     0,   432,   136,     0,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
     143,  2505,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,   548,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,   133,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,     0,   432,   136,     0,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
       0,  3065,   144,   145,   146,   147,   148,   149,     0,     0,
    -242,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,     0,     0,     0,     0,
     159,  3300,     0,   160,     0,   161,     0,     0,     0,     0,
     164,   165,  3301,   167,   168,     0,   169,   170,     0,     0,
     172,     0,   174,   175,   176,   177,     0,     0,   178,     0,
       0,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,     0,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
       0,     0,     0,   211,   212,   213,     0,     0,   214,  3302,
     215,   216,   217,     0,     0,     0,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,     0,   229,     0,     0,     0,
       0,     0,   232,     0,     0,     0,   233,   234,   235,   236,
    3303,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,     0,     0,     0,     0,   243,     0,     0,
     244,   245,  3304,     0,     0,   246,     0,     0,     0,   248,
       0,     0,   249,  3305,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,  -242,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
       0,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,  3306,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   313,     0,     0,   315,   316,
     317,     0,   319,   320,   321,   322,   323,   324,     0,     0,
       0,     0,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,     0,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,     0,     0,   346,     0,   348,  -242,     0,   349,     0,
       0,   351,     0,     0,   353,   354,  3307,     0,     0,     0,
     356,   357,   358,   359,   360,   361,     0,   363,     0,   364,
       0,     0,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   370,     0,     0,     0,   371,     0,   373,     0,     0,
     375,     0,     0,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
       0,   385,     0,     0,     0,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,     0,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,     0,     0,     0,     0,   417,     0,     0,
     418,     0,     0,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,  -242,     0,   428,     0,     0,
     430,     0,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,  3962,   143,     0,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,   136,   432,   137,   138,   139,   140,   141,  1856,     0,
       0,     0,     0,   142,     0,     0,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
       0,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,   136,
     432,   137,   138,   139,   140,   141,  2493,     0,     0,     0,
       0,   142,     0,     0,   143,     0,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,     0,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,   136,   432,   137,
     138,   139,   140,   141,  2703,     0,     0,     0,     0,   142,
       0,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,   136,   432,   137,   138,   139,
     140,   141,  3070,     0,     0,     0,     0,   142,     0,     0,
     143,     0,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,  2175,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,  2176,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,  2177,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,  2178,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,   938,   939,     0,
     303,   304,     0,     0,  2179,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,  3943,  3915,  3944,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,  2180,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,   143,     0,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,  2373,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,  2499,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
    1862,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,   548,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,  1863,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,   133,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,  2507,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,  2508,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,   548,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
     133,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,   143,     0,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,  2373,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,  2499,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,   548,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,   133,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,   946,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,   548,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,   133,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,   136,   432,   137,   138,   139,
     140,   141,  1261,     0,     0,     0,     0,   142,     0,     0,
     143,     0,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,   548,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,   133,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,   143,     0,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,   883,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,   884,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,   725,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,  2373,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,   548,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
     133,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,   143,     0,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,  2545,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,   548,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,   133,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,   548,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,   133,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,   136,   432,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,  2489,     0,
     143,     0,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,   133,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,   143,     0,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,  3800,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
    3801,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,   967,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
       0,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,   143,     0,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,  1349,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,  2095,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,  2096,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,   136,   432,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
     143,     0,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,   216,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,  2271,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,   136,   432,   137,   138,   139,   140,   141,
    2592,     0,     0,     0,     0,   142,     0,     0,   143,     0,
     144,   145,   146,   147,   148,   149,   150,     0,   151,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,   162,     0,   163,     0,   164,   165,
     166,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,     0,   178,     0,   179,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,   187,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,   195,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,   200,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,   210,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,   218,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,   228,   229,     0,   230,     0,     0,   231,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,   242,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,   247,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,   303,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
     310,     0,   311,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,     0,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,     0,     0,   326,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,   335,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,   345,
       0,   346,   347,   348,     0,     0,   349,     0,   350,   351,
     352,     0,   353,   354,     0,     0,     0,   355,   356,   357,
     358,   359,   360,   361,   362,   363,     0,   364,   365,     0,
       0,     0,   366,   367,   368,   369,     0,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,     0,   375,   376,
     377,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,   384,   385,
       0,     0,   386,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,   415,   416,     0,     0,   417,     0,     0,   418,     0,
     419,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,   429,     0,   430,   431,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,   143,     0,   144,   145,
     146,   147,   148,   149,   150,     0,   151,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,   162,     0,   163,     0,   164,   165,   166,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,     0,   178,     0,   179,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,   187,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,   195,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,   200,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,   210,     0,     0,   211,
     212,   213,     0,     0,   214,     0,   215,   216,   217,     0,
       0,   218,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,   228,   229,     0,   230,     0,     0,   231,   232,     0,
       0,     0,   233,   234,   235,   236,     0,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,   242,
       0,     0,     0,   243,     0,     0,   244,   245,     0,     0,
       0,   246,     0,     0,   247,   248,     0,     0,   249,     0,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,     0,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,   303,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,   310,     0,
     311,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     312,   313,     0,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,     0,     0,   326,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,   335,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,   345,     0,   346,
     347,   348,     0,     0,   349,     0,   350,   351,   352,     0,
     353,   354,     0,     0,     0,   355,   356,   357,   358,   359,
     360,   361,   362,   363,     0,   364,   365,     0,     0,     0,
     366,   367,   368,   369,     0,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,     0,   375,   376,   377,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,   384,   385,     0,     0,
     386,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
     133,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,   415,
     416,     0,     0,   417,     0,     0,   418,     0,   419,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,     0,     0,   428,   429,     0,   430,   431,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,   143,     0,   144,   145,   146,   147,
     148,   149,   150,     0,   151,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
     162,     0,   163,     0,   164,   165,   166,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,     0,   178,     0,   179,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,   187,
       0,     0,     0,  2095,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,   195,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
     200,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,   210,     0,     0,   211,   212,   213,
       0,     0,   214,     0,   215,   216,   217,     0,     0,   218,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,   228,
     229,     0,   230,     0,     0,   231,   232,     0,     0,     0,
     233,   234,   235,   236,     0,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,   242,     0,     0,
       0,   243,     0,     0,   244,   245,     0,     0,     0,   246,
       0,     0,   247,   248,     0,     0,   249,     0,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,     0,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,   303,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,   310,     0,   311,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   312,   313,
       0,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,     0,     0,   326,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,   335,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,   345,     0,   346,   347,   348,
       0,     0,   349,     0,   350,   351,   352,     0,   353,   354,
       0,     0,     0,   355,   356,   357,   358,   359,   360,   361,
     362,   363,     0,   364,   365,     0,     0,     0,   366,   367,
     368,   369,     0,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,     0,   375,   376,   377,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,   384,   385,     0,     0,   386,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,   415,   416,     0,
       0,   417,     0,     0,   418,     0,   419,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,     0,
       0,   428,   429,     0,   430,   431,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,   143,     0,   144,   145,   146,   147,   148,   149,
     150,     0,   151,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,   162,     0,
     163,     0,   164,   165,   166,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,     0,
     178,     0,   179,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,   187,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,   195,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,   200,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,   210,     0,     0,   211,   212,   213,     0,     0,
     214,     0,   215,   216,   217,     0,     0,   218,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,   228,   229,     0,
     230,     0,     0,   231,   232,     0,     0,     0,   233,   234,
     235,   236,     0,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,   242,     0,     0,     0,   243,
       0,     0,   244,   245,     0,     0,     0,   246,     0,     0,
     247,   248,     0,     0,   249,     0,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,     0,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,   303,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,   310,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   312,   313,     0,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,     0,     0,   326,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,   335,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,   345,     0,   346,   347,   348,     0,     0,
     349,     0,   350,   351,   352,     0,   353,   354,     0,     0,
       0,   355,   356,   357,   358,   359,   360,   361,   362,   363,
       0,   364,   365,     0,     0,     0,   366,   367,   368,   369,
       0,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,     0,   375,   376,   377,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,   384,   385,     0,     0,   386,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,   415,   416,     0,     0,   417,
       0,     0,   418,     0,   419,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,     0,     0,   428,
     429,     0,   430,   431,     0,   136,   432,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
     143,     0,   144,   145,   146,   147,   148,   149,   150,     0,
     151,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,   162,     0,   163,     0,
     164,   165,   166,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,     0,   178,     0,
     179,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,   187,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,   195,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,   200,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
     210,     0,     0,   211,   212,   213,     0,     0,   214,     0,
     215,  1450,   217,     0,     0,   218,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,   228,   229,     0,   230,     0,
       0,   231,   232,     0,     0,     0,   233,   234,   235,   236,
       0,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,   242,     0,     0,     0,   243,     0,     0,
     244,   245,     0,     0,     0,   246,     0,     0,   247,   248,
       0,     0,   249,     0,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,     0,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,  1451,   301,   302,     0,     0,     0,
     303,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,   310,     0,   311,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   312,   313,     0,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,     0,
       0,   326,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,   335,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,   345,     0,   346,   347,   348,     0,     0,   349,     0,
     350,   351,   352,     0,   353,   354,     0,     0,     0,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,   364,
     365,     0,     0,     0,   366,   367,   368,   369,     0,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,     0,
     375,   376,   377,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
     384,   385,     0,     0,   386,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,   415,   416,     0,     0,   417,     0,     0,
     418,     0,   419,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,     0,     0,   428,   429,     0,
     430,   431,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     144,   145,   146,   147,   148,   149,     0,     0,  -242,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,     0,     0,     0,     0,   159,  3300,
       0,   160,     0,   161,     0,     0,     0,     0,   164,   165,
    3301,   167,   168,     0,   169,   170,     0,     0,   172,     0,
     174,   175,   176,   177,     0,     0,   178,     0,     0,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,   196,   197,   198,     0,
    -257,  -257,   199,     0,  -257,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,     0,     0,
       0,   211,   212,   213,     0,     0,   214,  3302,   215,   216,
     217,     0,     0,     0,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,     0,   229,     0,     0,     0,     0,     0,
     232,     0,     0,     0,   233,   234,   235,   236,  3303,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,     0,     0,     0,     0,   243,     0,     0,   244,   245,
    3304,     0,     0,   246,     0,     0,     0,   248,     0,     0,
     249,  3305,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,  -242,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,     0,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
    3306,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,     0,     0,   315,   316,   317,     0,
     319,   320,   321,   322,   323,   324,     0,     0,     0,     0,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,     0,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,     0,
       0,   346,     0,   348,  -242,     0,   349,     0,     0,   351,
       0,     0,   353,   354,  3307,     0,     0,     0,   356,   357,
     358,   359,   360,   361,     0,   363,     0,   364,     0,     0,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   370,
       0,     0,     0,   371,     0,   373,     0,     0,   375,     0,
       0,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,     0,   385,
       0,     0,     0,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
       0,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,     0,     0,     0,     0,   417,     0,     0,   418,     0,
       0,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,  -242,     0,   428,     0,     0,   430,     0,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   144,   145,
     146,   147,   148,   149,     0,     0,  -242,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,     0,     0,     0,     0,   159,  3300,     0,   160,
       0,   161,     0,     0,     0,     0,   164,   165,  3301,   167,
     168,     0,   169,   170,     0,     0,   172,     0,   174,   175,
     176,   177,     0,     0,   178,     0,     0,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,     0,     0,     0,   196,   197,   198,     0,  -278,     0,
     199,     0,  -278,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,     0,     0,     0,   211,
     212,   213,     0,     0,   214,  3302,   215,   216,   217,     0,
       0,     0,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,     0,   229,     0,     0,     0,     0,     0,   232,     0,
       0,     0,   233,   234,   235,   236,  3303,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,     0,
       0,     0,     0,   243,     0,     0,   244,   245,  3304,     0,
       0,   246,     0,     0,     0,   248,     0,     0,   249,  3305,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,  -242,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,     0,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,  3306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   313,     0,     0,   315,   316,   317,     0,   319,   320,
     321,   322,   323,   324,     0,     0,     0,     0,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,     0,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,     0,     0,   346,
       0,   348,  -242,     0,   349,     0,     0,   351,     0,     0,
     353,   354,  3307,     0,     0,     0,   356,   357,   358,   359,
     360,   361,     0,   363,     0,   364,     0,     0,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   370,     0,     0,
       0,   371,     0,   373,     0,     0,   375,     0,     0,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,     0,   385,     0,     0,
       0,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
       0,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,     0,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,     0,
       0,     0,     0,   417,     0,     0,   418,     0,     0,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,  -278,
       0,  -242,     0,   428,     0,     0,   430,     0,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,   144,   145,   146,   147,
     148,   149,     0,     0,  -242,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3300,     0,   160,     0,   161,
       0,     0,     0,     0,   164,   165,  3301,   167,   168,     0,
     169,   170,     0,     0,   172,     0,   174,   175,   176,   177,
       0,     0,   178,     0,     0,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,     0,
       0,     0,   196,   197,   198,     0,  -275,     0,   199,     0,
    -275,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,     0,     0,     0,   211,   212,   213,
       0,     0,   214,  3302,   215,   216,   217,     0,     0,     0,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,     0,
     229,     0,     0,     0,     0,     0,   232,     0,     0,     0,
     233,   234,   235,   236,  3303,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,     0,     0,     0,
       0,   243,     0,     0,   244,   245,  3304,     0,     0,   246,
       0,     0,     0,   248,     0,     0,   249,  3305,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,  -242,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,     0,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,  3306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
       0,     0,   315,   316,   317,     0,   319,   320,   321,   322,
     323,   324,     0,     0,     0,     0,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,     0,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,     0,     0,   346,     0,   348,
    -242,     0,   349,     0,     0,   351,     0,     0,   353,   354,
    3307,     0,     0,     0,   356,   357,   358,   359,   360,   361,
       0,   363,     0,   364,     0,     0,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   370,     0,     0,     0,   371,
       0,   373,     0,     0,   375,     0,     0,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,     0,   385,     0,     0,     0,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,     0,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,     0,     0,     0,
       0,   417,     0,     0,   418,     0,     0,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,  -275,     0,  -242,
       0,   428,     0,     0,   430,     0,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,   144,   145,   146,   147,   148,   149,
       0,     0,  -242,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3300,     0,   160,     0,   161,     0,     0,
       0,     0,   164,   165,  3301,   167,   168,     0,   169,   170,
       0,     0,   172,     0,   174,   175,   176,   177,     0,     0,
     178,     0,     0,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,  3698,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,     0,     0,     0,   211,   212,   213,     0,     0,
     214,  3302,   215,   216,   217,     0,     0,     0,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,     0,   229,     0,
       0,     0,     0,     0,   232,     0,     0,     0,   233,   234,
     235,   236,  3303,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,     0,     0,     0,     0,   243,
       0,     0,   244,   245,  3304,     0,     0,   246,     0,     0,
       0,   248,     0,     0,   249,  3305,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,  -242,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,     0,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,  3306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,     0,     0,
     315,   316,   317,     0,   319,   320,   321,   322,   323,   324,
       0,     0,     0,     0,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,     0,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,     0,     0,   346,     0,   348,  -242,     0,
     349,     0,     0,   351,     0,     0,   353,   354,  3307,     0,
       0,     0,   356,   357,   358,   359,   360,   361,     0,   363,
       0,   364,     0,     0,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   370,     0,     0,     0,   371,     0,   373,
       0,     0,   375,     0,     0,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,     0,   385,     0,     0,     0,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,     0,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,     0,     0,     0,     0,   417,
       0,     0,   418,     0,     0,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,  -242,     0,   428,
       0,     0,   430,     0,     0,   136,   432,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   144,   145,   146,   147,   148,   149,     0,     0,
    -242,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,     0,     0,     0,     0,
     159,  3300,     0,   160,     0,   161,     0,     0,     0,     0,
     164,   165,  3301,   167,   168,     0,   169,   170,     0,     0,
     172,     0,   174,   175,   176,   177,     0,     0,   178,     0,
       0,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,  -280,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
       0,     0,     0,   211,   212,   213,     0,     0,   214,  3302,
     215,   216,   217,     0,     0,     0,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,     0,   229,     0,     0,     0,
       0,     0,   232,     0,     0,     0,   233,   234,   235,   236,
    3303,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,     0,     0,     0,     0,   243,     0,     0,
     244,   245,  3304,     0,     0,   246,     0,     0,     0,   248,
       0,     0,   249,  3305,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,  -242,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
       0,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,  3306,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   313,     0,     0,   315,   316,
     317,     0,   319,   320,   321,   322,   323,   324,     0,     0,
       0,     0,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,     0,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,     0,     0,   346,     0,   348,  -242,     0,   349,     0,
       0,   351,     0,     0,   353,   354,  3307,     0,     0,     0,
     356,   357,   358,   359,   360,   361,     0,   363,     0,   364,
       0,     0,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   370,     0,     0,     0,   371,     0,   373,     0,     0,
     375,     0,     0,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
       0,   385,     0,     0,     0,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,     0,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,     0,     0,     0,     0,   417,     0,     0,
     418,     0,     0,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,  -242,     0,   428,     0,     0,
     430,     0,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     144,   145,   146,   147,   148,   149,     0,     0,  -242,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,     0,     0,     0,     0,   159,  3300,
       0,   160,     0,   161,     0,     0,     0,     0,   164,   165,
    3301,   167,   168,     0,   169,   170,     0,     0,   172,     0,
     174,   175,   176,   177,     0,     0,   178,     0,     0,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,  3805,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,     0,     0,
       0,   211,   212,   213,     0,     0,   214,  3302,   215,   216,
     217,     0,     0,     0,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,     0,   229,     0,     0,     0,     0,     0,
     232,     0,     0,     0,   233,   234,   235,   236,  3303,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,     0,     0,     0,     0,   243,     0,     0,   244,   245,
    3304,     0,     0,   246,     0,     0,     0,   248,     0,     0,
     249,  3305,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,  -242,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,     0,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
    3306,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,     0,     0,   315,   316,   317,     0,
     319,   320,   321,   322,   323,   324,     0,     0,     0,     0,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,     0,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,     0,
       0,   346,     0,   348,  -242,     0,   349,     0,     0,   351,
       0,     0,   353,   354,  3307,     0,     0,     0,   356,   357,
     358,   359,   360,   361,     0,   363,     0,   364,     0,     0,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   370,
       0,     0,     0,   371,     0,   373,     0,     0,   375,     0,
       0,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,     0,   385,
       0,     0,     0,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
       0,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,     0,     0,     0,     0,   417,     0,     0,   418,     0,
       0,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,  -242,     0,   428,     0,     0,   430,     0,
       0,   136,   432,   137,   138,   139,   140,   141,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   144,   145,
     146,   147,   148,   149,     0,     0,  -242,     0,     0,     0,
     152,     0,     0,     0,   153,     0,     0,   154,   155,     0,
     156,     0,     0,     0,     0,     0,   159,  3300,     0,   160,
       0,   161,     0,     0,     0,     0,   164,   165,  3301,   167,
     168,     0,   169,   170,     0,     0,   172,     0,   174,   175,
     176,   177,     0,     0,   178,     0,     0,     0,   180,     0,
       0,     0,     0,   181,     0,     0,     0,     0,     0,     0,
     182,   183,   184,     0,     0,   185,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,   188,     0,   189,     0,
       0,     0,   190,     0,   191,   192,   193,   194,     0,     0,
       0,     0,     0,     0,   196,   197,   198,     0,     0,     0,
     199,     0,  3881,   201,     0,   202,   203,   204,     0,     0,
     205,     0,   206,   207,   208,   209,     0,     0,     0,   211,
     212,   213,     0,     0,   214,  3302,   215,   216,   217,     0,
       0,     0,     0,     0,     0,   219,   220,     0,   221,     0,
     222,     0,   223,   224,   225,   226,     0,   227,     0,     0,
       0,     0,   229,     0,     0,     0,     0,     0,   232,     0,
       0,     0,   233,   234,   235,   236,  3303,     0,   237,   238,
       0,     0,   239,     0,   240,     0,     0,     0,   241,     0,
       0,     0,     0,   243,     0,     0,   244,   245,  3304,     0,
       0,   246,     0,     0,     0,   248,     0,     0,   249,  3305,
       0,   250,   251,     0,     0,     0,     0,     0,   252,   253,
       0,   254,     0,   255,     0,   256,   257,     0,     0,     0,
       0,  -242,     0,     0,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,     0,
     273,   274,   275,   276,     0,   277,   278,   279,     0,     0,
       0,   280,   281,   282,   283,   284,     0,     0,   285,   286,
       0,   287,     0,   288,     0,   289,   290,   291,   292,   293,
     294,   295,   296,     0,     0,   297,   298,     0,     0,   299,
     300,   301,   302,     0,     0,     0,     0,   304,     0,     0,
       0,     0,   305,   306,   307,     0,   308,   309,  3306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   313,     0,     0,   315,   316,   317,     0,   319,   320,
     321,   322,   323,   324,     0,     0,     0,     0,   327,   328,
       0,   329,     0,   330,   331,     0,   332,   333,   334,     0,
       0,     0,     0,     0,     0,   336,   337,   338,   339,   340,
       0,     0,   341,   342,   343,     0,   344,     0,     0,   346,
       0,   348,  -242,     0,   349,     0,     0,   351,     0,     0,
     353,   354,  3307,     0,     0,     0,   356,   357,   358,   359,
     360,   361,     0,   363,     0,   364,     0,     0,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   370,     0,     0,
       0,   371,     0,   373,     0,     0,   375,     0,     0,   378,
       0,     0,     0,     0,     0,     0,   379,   380,     0,   381,
       0,     0,   382,     0,     0,   383,     0,   385,     0,     0,
       0,   387,     0,   388,   389,   390,   391,   392,     0,     0,
     393,   394,     0,   395,   396,     0,     0,   397,   398,     0,
       0,   399,   400,     0,   401,   402,   403,   404,     0,     0,
       0,     0,     0,   405,   406,     0,     0,     0,     0,   408,
     409,   410,     0,   411,   412,     0,   413,   414,     0,     0,
       0,     0,     0,   417,     0,     0,   418,     0,     0,     0,
     420,   421,     0,     0,     0,     0,     0,     0,   422,     0,
       0,   423,     0,     0,     0,   424,   425,   426,   427,     0,
       0,  -242,     0,   428,     0,     0,   430,     0,     0,   136,
     432,   137,   138,   139,   140,   141,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,   144,   145,   146,   147,
     148,   149,     0,     0,  -242,     0,     0,     0,   152,     0,
       0,     0,   153,     0,     0,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3300,     0,   160,     0,   161,
       0,     0,     0,     0,   164,   165,  3301,   167,   168,     0,
     169,   170,     0,     0,   172,     0,   174,   175,   176,   177,
       0,     0,   178,     0,     0,     0,   180,     0,     0,     0,
       0,   181,     0,     0,     0,     0,     0,     0,   182,   183,
     184,     0,     0,   185,     0,     0,     0,     0,   186,     0,
       0,     0,     0,     0,   188,     0,   189,     0,     0,     0,
     190,     0,   191,   192,   193,   194,     0,     0,     0,     0,
       0,     0,   196,   197,   198,     0,     0,     0,   199,     0,
    -261,   201,     0,   202,   203,   204,     0,     0,   205,     0,
     206,   207,   208,   209,     0,     0,     0,   211,   212,   213,
       0,     0,   214,  3302,   215,   216,   217,     0,     0,     0,
       0,     0,     0,   219,   220,     0,   221,     0,   222,     0,
     223,   224,   225,   226,     0,   227,     0,     0,     0,     0,
     229,     0,     0,     0,     0,     0,   232,     0,     0,     0,
     233,   234,   235,   236,  3303,     0,   237,   238,     0,     0,
     239,     0,   240,     0,     0,     0,   241,     0,     0,     0,
       0,   243,     0,     0,   244,   245,  3304,     0,     0,   246,
       0,     0,     0,   248,     0,     0,   249,  3305,     0,   250,
     251,     0,     0,     0,     0,     0,   252,   253,     0,   254,
       0,   255,     0,   256,   257,     0,     0,     0,     0,  -242,
       0,     0,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,     0,   273,   274,
     275,   276,     0,   277,   278,   279,     0,     0,     0,   280,
     281,   282,   283,   284,     0,     0,   285,   286,     0,   287,
       0,   288,     0,   289,   290,   291,   292,   293,   294,   295,
     296,     0,     0,   297,   298,     0,     0,   299,   300,   301,
     302,     0,     0,     0,     0,   304,     0,     0,     0,     0,
     305,   306,   307,     0,   308,   309,  3306,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   313,
       0,     0,   315,   316,   317,     0,   319,   320,   321,   322,
     323,   324,     0,     0,     0,     0,   327,   328,     0,   329,
       0,   330,   331,     0,   332,   333,   334,     0,     0,     0,
       0,     0,     0,   336,   337,   338,   339,   340,     0,     0,
     341,   342,   343,     0,   344,     0,     0,   346,     0,   348,
    -242,     0,   349,     0,     0,   351,     0,     0,   353,   354,
    3307,     0,     0,     0,   356,   357,   358,   359,   360,   361,
       0,   363,     0,   364,     0,     0,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   370,     0,     0,     0,   371,
       0,   373,     0,     0,   375,     0,     0,   378,     0,     0,
       0,     0,     0,     0,   379,   380,     0,   381,     0,     0,
     382,     0,     0,   383,     0,   385,     0,     0,     0,   387,
       0,   388,   389,   390,   391,   392,     0,     0,   393,   394,
       0,   395,   396,     0,     0,   397,   398,     0,     0,   399,
     400,     0,   401,   402,   403,   404,     0,     0,     0,     0,
       0,   405,   406,     0,     0,     0,     0,   408,   409,   410,
       0,   411,   412,     0,   413,   414,     0,     0,     0,     0,
       0,   417,     0,     0,   418,     0,     0,     0,   420,   421,
       0,     0,     0,     0,     0,     0,   422,     0,     0,   423,
       0,     0,     0,   424,   425,   426,   427,     0,     0,  -242,
       0,   428,     0,     0,   430,     0,     0,   136,   432,   137,
     138,   139,   140,   141,     0,     0,     0,     0,     0,   142,
       0,     0,     0,     0,   144,   145,   146,   147,   148,   149,
       0,     0,  -242,     0,     0,     0,   152,     0,     0,     0,
     153,     0,     0,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3300,     0,   160,     0,   161,     0,     0,
       0,     0,   164,   165,  3301,   167,   168,     0,   169,   170,
       0,     0,   172,     0,   174,   175,   176,   177,     0,     0,
     178,     0,     0,     0,   180,     0,     0,     0,     0,   181,
       0,     0,     0,     0,     0,     0,   182,   183,   184,     0,
       0,   185,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,   188,     0,   189,     0,     0,     0,   190,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,     0,
     196,   197,   198,     0,     0,     0,   199,     0,     0,   201,
       0,   202,   203,   204,     0,     0,   205,     0,   206,   207,
     208,   209,     0,     0,     0,   211,   212,   213,     0,     0,
     214,  3302,   215,   216,   217,     0,     0,     0,     0,     0,
       0,   219,   220,     0,   221,     0,   222,     0,   223,   224,
     225,   226,     0,   227,     0,     0,     0,     0,   229,     0,
       0,     0,     0,     0,   232,     0,     0,     0,   233,   234,
     235,   236,  3303,     0,   237,   238,     0,     0,   239,     0,
     240,     0,     0,     0,   241,     0,     0,     0,     0,   243,
       0,     0,   244,   245,  3304,     0,     0,   246,     0,     0,
       0,   248,     0,     0,   249,  3305,     0,   250,   251,     0,
       0,     0,     0,     0,   252,   253,     0,   254,     0,   255,
       0,   256,   257,     0,     0,     0,     0,  -242,     0,     0,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,     0,   273,   274,   275,   276,
       0,   277,   278,   279,     0,     0,     0,   280,   281,   282,
     283,   284,     0,     0,   285,   286,     0,   287,     0,   288,
       0,   289,   290,   291,   292,   293,   294,   295,   296,     0,
       0,   297,   298,     0,     0,   299,   300,   301,   302,     0,
       0,     0,     0,   304,     0,     0,     0,     0,   305,   306,
     307,     0,   308,   309,  3306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   313,     0,     0,
     315,   316,   317,     0,   319,   320,   321,   322,   323,   324,
       0,     0,     0,     0,   327,   328,     0,   329,     0,   330,
     331,     0,   332,   333,   334,     0,     0,     0,     0,     0,
       0,   336,   337,   338,   339,   340,     0,     0,   341,   342,
     343,     0,   344,     0,     0,   346,     0,   348,  -242,     0,
     349,     0,     0,   351,     0,     0,   353,   354,  3307,     0,
       0,     0,   356,   357,   358,   359,   360,   361,     0,   363,
       0,   364,     0,     0,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   370,     0,     0,     0,   371,     0,   373,
       0,     0,   375,     0,     0,   378,     0,     0,     0,     0,
       0,     0,   379,   380,     0,   381,     0,     0,   382,     0,
       0,   383,     0,   385,     0,     0,     0,   387,     0,   388,
     389,   390,   391,   392,     0,     0,   393,   394,     0,   395,
     396,     0,     0,   397,   398,     0,     0,   399,   400,     0,
     401,   402,   403,   404,     0,     0,     0,     0,     0,   405,
     406,     0,     0,     0,     0,   408,   409,   410,     0,   411,
     412,     0,   413,   414,     0,     0,     0,     0,     0,   417,
       0,     0,   418,     0,     0,     0,   420,   421,     0,     0,
       0,     0,     0,     0,   422,     0,     0,   423,     0,     0,
       0,   424,   425,   426,   427,     0,     0,  -242,     0,   428,
       0,     0,   430,     0,     0,   136,   432,   137,   138,   139,
     140,   141,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   144,   145,   146,   147,   148,   149,     0,     0,
    -242,     0,     0,     0,   152,     0,     0,     0,   153,     0,
       0,   154,   155,     0,   156,     0,     0,     0,     0,     0,
     159,  3300,     0,   160,     0,   161,     0,     0,     0,     0,
     164,   165,  3301,   167,   168,     0,   169,   170,     0,     0,
     172,     0,   174,   175,   176,   177,     0,     0,   178,     0,
       0,     0,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,   182,   183,   184,     0,     0,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
     188,     0,   189,     0,     0,     0,   190,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,     0,   196,   197,
     198,     0,     0,     0,   199,     0,     0,   201,     0,   202,
     203,   204,     0,     0,   205,     0,   206,   207,   208,   209,
       0,     0,     0,   211,   212,   213,     0,     0,   214,  3302,
     215,   216,   217,     0,     0,     0,     0,     0,     0,   219,
     220,     0,   221,     0,   222,     0,   223,   224,   225,   226,
       0,   227,     0,     0,     0,     0,   229,     0,     0,     0,
       0,     0,   232,     0,     0,     0,   233,   234,   235,   236,
    3303,     0,   237,   238,     0,     0,   239,     0,   240,     0,
       0,     0,   241,     0,     0,     0,     0,   243,     0,     0,
     244,   245,  3304,     0,     0,   246,     0,     0,     0,   248,
       0,     0,   249,  3305,     0,   250,   251,     0,     0,     0,
       0,     0,   252,   253,     0,   254,     0,   255,     0,   256,
     257,     0,     0,     0,     0,  -242,     0,     0,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,     0,   273,   274,   275,   276,     0,   277,
     278,   279,     0,     0,     0,   280,   281,   282,   283,   284,
       0,     0,   285,   286,     0,   287,     0,   288,     0,   289,
     290,   291,   292,   293,   294,   295,   296,     0,     0,   297,
     298,     0,     0,   299,   300,   301,   302,     0,     0,     0,
       0,   304,     0,     0,     0,     0,   305,   306,   307,     0,
     308,   309,  3306,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   313,     0,     0,   315,   316,
     317,     0,   319,   320,   321,   322,   323,   324,     0,     0,
       0,     0,   327,   328,     0,   329,     0,   330,   331,     0,
     332,   333,   334,     0,     0,     0,     0,     0,     0,   336,
     337,   338,   339,   340,     0,     0,   341,   342,   343,     0,
     344,     0,     0,   346,     0,   348,  -242,     0,   349,     0,
       0,   351,     0,     0,   353,   354,  3307,     0,     0,     0,
     356,   357,   358,   359,   360,   361,     0,   363,     0,   364,
       0,     0,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   370,     0,     0,     0,   371,     0,   373,     0,     0,
     375,     0,     0,   378,     0,     0,     0,     0,     0,     0,
     379,   380,     0,   381,     0,     0,   382,     0,     0,   383,
       0,   385,     0,     0,     0,   387,     0,   388,   389,   390,
     391,   392,     0,     0,   393,   394,     0,   395,   396,     0,
       0,   397,   398,     0,     0,   399,   400,     0,   401,   402,
     403,   404,     0,     0,     0,     0,     0,   405,   406,     0,
       0,     0,     0,   408,   409,   410,     0,   411,   412,     0,
     413,   414,     0,     0,     0,     0,     0,   417,     0,     0,
    3701,     0,     0,     0,   420,   421,     0,     0,     0,     0,
       0,     0,   422,     0,     0,   423,     0,     0,     0,   424,
     425,   426,   427,     0,     0,  -242,     0,   428,     0,     0,
     430,     0,     0,   136,   432,   137,   138,   139,   140,   141,
       0,     0,     0,     0,     0,   142,     0,     0,     0,     0,
     144,   145,   146,   147,   148,   149,     0,     0,     0,     0,
       0,     0,   152,     0,     0,     0,   153,     0,     0,   154,
     155,     0,   156,     0,     0,     0,     0,     0,   159,     0,
       0,   160,     0,   161,     0,     0,     0,     0,   164,   165,
       0,   167,   168,     0,   169,   170,     0,     0,   172,     0,
     174,   175,   176,   177,     0,     0,   178,     0,     0,     0,
     180,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   182,   183,   184,     0,     0,   185,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,   188,     0,
     189,     0,     0,     0,   190,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,   196,   197,   198,     0,
       0,     0,   199,     0,     0,   201,     0,   202,   203,   204,
       0,     0,   205,     0,   206,   207,   208,   209,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,   215,   216,
     217,     0,     0,     0,     0,     0,     0,   219,   220,     0,
     221,     0,   222,     0,   223,   224,   225,   226,     0,   227,
       0,     0,     0,     0,   229,     0,     0,     0,     0,     0,
     232,     0,     0,     0,   233,   234,   235,   236,     0,     0,
     237,   238,     0,     0,   239,     0,   240,     0,     0,     0,
     241,     0,     0,     0,     0,   243,     0,     0,   244,   245,
       0,     0,     0,   246,     0,     0,     0,   248,     0,     0,
     249,     0,     0,   250,   251,     0,     0,     0,     0,     0,
     252,   253,     0,   254,     0,   255,     0,   256,   257,     0,
       0,     0,     0,     0,     0,     0,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,     0,   273,   274,   275,   276,     0,   277,   278,   279,
       0,     0,     0,   280,   281,   282,   283,   284,     0,     0,
     285,   286,     0,   287,     0,   288,     0,   289,   290,   291,
     292,   293,   294,   295,   296,     0,     0,   297,   298,     0,
       0,   299,   300,   301,   302,     0,     0,     0,     0,   304,
       0,     0,     0,     0,   305,   306,   307,     0,   308,   309,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   313,     0,     0,   315,   316,   317,     0,
     319,   320,   321,   322,   323,   324,     0,     0,     0,     0,
     327,   328,     0,   329,     0,   330,   331,     0,   332,   333,
     334,     0,     0,     0,     0,     0,     0,   336,   337,   338,
     339,   340,     0,     0,   341,   342,   343,     0,   344,     0,
       0,   346,     0,   348,     0,     0,   349,     0,     0,   351,
       0,     0,   353,   354,     0,     0,     0,     0,   356,   357,
     358,   359,   360,   361,     0,   363,     0,   364,     0,     0,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   370,
       0,     0,     0,   371,     0,   373,     0,     0,   375,     0,
       0,   378,     0,     0,     0,     0,     0,     0,   379,   380,
       0,   381,     0,     0,   382,     0,     0,   383,     0,   385,
       0,     0,     0,   387,     0,   388,   389,   390,   391,   392,
       0,     0,   393,   394,     0,   395,   396,     0,     0,   397,
     398,     0,     0,   399,   400,     0,   401,   402,   403,   404,
       0,     0,     0,     0,     0,   405,   406,     0,     0,     0,
       0,   408,   409,   410,     0,   411,   412,     0,   413,   414,
       0,     0,     0,     0,     0,   417,     0,     0,   418,     0,
       0,     0,   420,   421,     0,     0,     0,     0,     0,     0,
     422,     0,     0,   423,     0,     0,     0,   424,   425,   426,
     427,     0,     0,     0,     0,   428,     0,     0,   430,     0,
       0,     0,   432
};

static const short int yycheck[] =
{
       7,   531,   510,   573,   121,   897,   510,   815,   667,   668,
     672,   604,  1122,    20,     5,  1093,    23,  1615,    21,   954,
     955,  1554,   957,  1865,   652,    32,   606,    30,  1122,  1346,
    1264,   569,   570,    36,  1203,    42,   841,   523,   524,   525,
     983,   527,   926,   529,  2105,   704,    53,  1911,   863,  1739,
     703,  1895,  1916,  1746,  2074,  1748,  1430,  1748,   863,   839,
    2522,  2474,  1043,  1044,   726,   724,  1141,   729,  1317,   607,
    1748,  1149,  2151,  1148,  1152,  2895,  1852,   736,   737,   738,
    2098,  2099,  2100,  1064,   864,  2134,    93,  2127,  1342,  2335,
      23,  1072,  2776,  1137,  1750,  2135,  1062,  2137,  2855,  2783,
    2114,  2115,  1083,  1084,  1085,  2323,  1061,  2325,   115,   116,
     117,  1092,  1691,   120,   121,   122,   744,   745,   746,   517,
    2312,  1076,  1159,  1160,  1814,  3311,  1063,  2208,   135,  1819,
     586,  2227,    16,  1714,  1715,  1825,   764,  2863,  1828,  1751,
    2312,  1834,  2364,  1755,    18,    24,  2368,   116,   117,    18,
    1278,   120,  2213,    49,  1766,  1283,    16,    16,  3102,  3108,
      93,  1855,    33,    16,  1776,  1293,  1294,  2928,  2929,    56,
      57,  2932,  1753,  1754,   901,  1756,  2237,  2238,  1759,  1760,
      10,  1857,  1763,  1705,    57,    30,    20,  1768,   758,    20,
    2951,  1772,  1773,  1774,  1775,    18,  2957,    29,  1779,    33,
    1781,  2201,   135,  1642,    93,  2146,  1787,  1614,  2208,  1790,
    1791,  2211,    46,    59,   901,  2215,  3006,   797,    18,  3009,
     138,    20,    56,    57,    35,    56,    57,   109,    70,  2229,
    2230,    55,   132,   168,    33,   132,    40,    24,    18,  2239,
      24,  2133,   218,     3,   154,  2089,    24,    46,  1417,     9,
      10,  2327,    35,  2300,   138,   109,   138,    56,    57,   142,
     238,   218,    77,   218,   138,    59,  3116,    73,   142,    29,
    2467,   809,   113,   142,   126,    35,   256,   865,    64,    39,
    2668,   332,  2585,   201,   138,    69,   144,   946,   774,   399,
     192,   142,    24,   223,  3051,  1612,     8,  2566,  2567,   132,
     647,   327,   171,   113,   234,   350,    86,    22,   352,   421,
     307,    60,   452,    75,  2461,    20,  3492,   168,   148,   142,
     421,   167,    31,   405,  3268,   321,   111,   206,    33,   446,
     154,    64,   329,   223,   158,   138,   484,   917,  3304,  3305,
     168,    46,   142,  2119,   168,   171,   495,   154,   515,   484,
     461,    56,    57,   140,  2767,  2166,   140,   138,   138,  2790,
      24,    41,   142,   480,    60,   154,   438,   452,   128,   171,
      92,   155,  2202,   167,  2204,   171,   271,   460,   189,   320,
    3141,   464,   920,   127,   376,   204,   166,   980,   168,  3150,
    2232,  2085,  2661,  2662,  2541,    49,   376,    95,   277,   566,
     123,   211,   182,   395,   802,    69,   189,   187,  2188,   171,
     255,   897,  3583,  1305,  3585,  2257,   204,   304,   567,   206,
     248,   201,   206,   571,   535,   497,   148,   207,   206,  2860,
     531,   532,   424,   256,   149,   215,   239,  2195,   226,   446,
     484,   448,  3618,   223,   584,    44,    61,  3237,   389,   161,
    2140,   989,   174,   565,   234,   547,   463,   567,   239,   239,
     467,   285,   372,    96,   565,   352,    99,    62,   248,   476,
    3227,   256,   221,   480,   206,   482,  2668,  1420,   408,   397,
    2529,   488,    92,   565,    67,  3211,   603,   494,  2506,  1269,
     277,   155,  1272,   277,   256,  2188,  2668,   953,   583,   277,
    1280,  2582,  2195,  1581,  2195,  1583,   204,   403,  1586,   218,
     517,   518,  1317,    87,   404,  1295,  1296,  2195,   364,  2537,
     565,   572,  2603,  1151,  2214,   221,  2216,   307,   535,   238,
     527,   315,    59,  2223,   321,   882,   366,   321,  1166,   546,
    1794,   567,   206,   321,   540,   277,  2236,   430,   372,   329,
     557,   396,  2242,   376,   561,   488,   371,  1685,   338,   461,
     567,  2337,   569,   570,  1192,   372,   544,   574,   575,   549,
     364,  3297,   579,  1059,  1144,   298,  1557,   429,  2881,   430,
     556,   588,  2582,   372,  2165,   592,   366,   186,  2976,  1555,
     597,   598,   599,  3055,   601,   602,   603,  1324,   605,   606,
     607,   556,  2799,  2603,  2126,  2186,  2187,  2300,   317,   318,
     567,   417,  1578,   277,    69,   525,  2663,    49,  2694,  2312,
     316,  2312,  1108,  3567,   557,   455,  1112,   307,   408,   598,
     599,   566,  1030,   602,  2312,   642,   605,  1324,  2530,  2531,
    2334,  2222,   495,   543,   366,  3495,   543,   451,  2055,   429,
     539,   315,  2091,  2234,  1591,   573,  1593,   321,   527,  2600,
    2336,   534,   546,   495,    12,   507,   470,  1394,  1206,   499,
     516,   567,  3621,   484,    69,   461,   385,   421,   465,   513,
     521,   465,   513,   541,   571,  1223,   466,   465,   567,   573,
    2912,   573,   496,  1273,   565,   495,   556,   556,   567,   573,
     545,   484,  1290,   537,  2480,  2481,  2975,  1394,  3528,   539,
     543,   521,   472,  3533,   513,  2296,  2297,  2298,  2299,   573,
     469,  3447,   516,   840,  2946,  2947,   549,  3517,   461,  3519,
     490,   565,  2954,  3919,   443,   515,   525,  3703,   498,  2961,
     566,   544,   749,   567,   751,   140,   526,   527,   104,   403,
    2580,   206,  2563,   540,   140,  3516,   540,  3518,   480,   519,
     567,   457,   540,   544,   544,   567,   546,  2347,  2348,  2349,
     573,   567,   355,   469,   122,  2793,  2796,   565,   567,   786,
     567,   376,   480,   567,  2976,   368,   566,   567,  2568,   796,
     797,   798,   573,   573,   106,   802,  2845,  2878,  1254,   790,
    2849,   465,   809,  1746,  2976,  2845,  2902,    92,   513,  2849,
      65,   206,  2570,  2831,   170,   106,   415,   539,  3544,  1305,
     206,   565,   138,   438,  1328,   569,  1224,   281,   533,   534,
      11,    53,   157,   840,   128,   239,   410,   560,   561,   562,
     196,   225,   190,    92,   109,    11,  1426,   556,   239,  3095,
      33,   163,   166,   786,   550,   488,   273,   384,   491,    33,
     315,  1939,   186,   421,   201,   798,   321,   477,    65,  3630,
     480,  3632,   163,   421,   174,  2568,   540,  2570,  2878,  2570,
    2114,  2115,  1766,    57,  3644,  1922,  1923,   201,   320,   110,
     897,  1834,  2570,   201,   477,  1710,  2476,  2477,  2478,  1437,
     138,  1681,   226,   273,  1684,  1710,   191,  1687,  1688,   171,
     917,    92,   329,   920,   524,   498,   923,   924,   107,   209,
     315,  2697,    96,   239,   173,    99,   321,   382,   218,   318,
     157,   209,   436,   107,   338,   321,   292,  1918,   416,  2014,
     218,   253,  2521,   299,   110,  3671,   171,   338,   256,   146,
    1348,  1932,    41,   215,   355,   204,  3776,  1585,   965,   329,
     967,  2005,   253,  2807,  2074,    35,  2986,   148,    31,  2138,
    2663,   403,   979,   362,  3731,  2668,   135,  2668,  2992,  3663,
    2074,  1962,   989,  2639,   335,  1940,   145,   382,   461,  3207,
    2668,   924,  2120,   174,   121,   527,   217,   429,   323,  2597,
     249,   239,   910,   911,   438,  3485,  2260,   565,   480,     6,
     465,    30,   324,   287,   370,   519,  3836,   565,  1135,  1026,
     201,  1028,   338,  1030,  3270,  3112,  2136,   216,  2640,    99,
     503,   172,   965,   324,   967,   567,   106,   945,  3087,  3088,
    1031,    50,  2136,   132,  1624,  1625,   979,  2013,   342,  2030,
      59,   555,    71,   343,  1061,  2021,   511,    54,   323,   344,
     397,  3079,  2660,   419,   372,   343,   366,   352,   249,  1076,
     465,   381,  3534,   358,  1191,   106,   338,   106,  2854,   465,
     109,    25,    26,    25,   339,   540,  2667,   157,   271,   314,
     317,   318,   355,   163,  2029,  1212,   323,   179,   320,   174,
     338,   449,   450,   451,   452,   453,   454,  2042,    92,    12,
    3189,   565,    56,    57,    58,  1122,   511,   136,   466,   189,
     504,    65,  3882,    65,   515,    69,    69,    69,  1135,   126,
     106,  2241,   163,    77,   163,   309,   388,  2386,  1036,  1037,
    1038,     0,   339,   527,   206,   540,  3010,  2241,   565,  1653,
    1048,    95,    95,  1746,   540,   218,   441,   421,   189,   286,
     189,   106,   546,   245,   148,   109,  3106,   109,   112,   271,
    2339,   197,   567,   199,   340,   238,   501,   336,   427,  1077,
     480,   567,  1080,   253,  1191,   366,   542,   163,  1195,   378,
     174,   448,   517,   421,   506,   444,   140,   140,   554,  1206,
     510,    12,  1100,  1101,   456,  1212,  1104,   348,   482,   421,
     467,  3691,   526,   189,   421,   506,  1223,  1224,   163,   122,
     204,   197,   253,  2803,   253,  1123,  1124,  1234,   544,   478,
      12,   480,   481,  2607,   508,  1242,   245,   138,   308,   524,
    3653,  1834,  3329,  3330,  3284,  2188,   427,   250,  1255,  1256,
    1257,  1258,  1259,   323,   324,  3717,   572,   573,  1249,   321,
     204,   204,   436,  1270,  1271,   249,  1273,   516,   212,   371,
     328,   308,  1279,   186,   501,   524,   566,   253,   467,   110,
    1287,   225,  1399,  2976,   226,  2976,  1255,  1256,  1257,   361,
     517,   366,    12,   324,   352,   324,   437,   478,  2976,   480,
     303,   565,  1271,    59,   308,   106,   544,    55,   253,   308,
    1279,   122,    68,   226,  1431,  3777,   171,   491,  2202,  3799,
    2204,   318,   385,    79,   483,  1258,  1259,   317,   318,  3809,
     308,   351,   276,   276,   572,   573,   438,   565,  1345,  3114,
     122,  1348,   361,    68,   426,   519,  1337,    86,   324,   293,
     293,  3831,  2462,   565,  1287,  2008,  1347,  2300,   565,  2434,
     421,   380,   163,   218,  3304,  3305,   106,    68,  2462,  2312,
    3234,   391,   315,  2451,   111,   317,   318,   361,   375,   324,
     377,   323,   366,  3158,    59,   179,   217,   329,   189,  2017,
     409,  3411,  1399,    68,  1401,  1402,  1403,  1404,   218,  1406,
     253,   345,   122,   465,    79,   480,   154,  1414,   352,  1416,
     158,   167,  1345,   245,   484,   235,   447,   173,   488,  1426,
     168,   491,   364,   163,  1431,    19,   484,   142,  3908,  3909,
    1437,   501,  1439,  1402,  1403,  1404,   506,  1444,  1445,   509,
    1447,   460,   167,   427,  2381,  2382,    86,   484,   204,   189,
    2431,   245,   253,   190,    12,   260,   261,   480,   461,    72,
    1445,    74,  1447,   411,   240,    12,   167,   243,   207,   413,
     226,   324,   509,  1406,   575,   506,   504,   506,   540,   204,
     484,   110,   171,   425,   223,   484,     8,   527,   558,   559,
     322,   182,   167,   346,   478,   234,   109,   481,   173,   527,
     601,   226,   458,   204,   565,   509,   484,    29,   569,  3107,
     509,  1444,  1445,   253,  1447,   499,  3536,   130,   161,   256,
     114,   465,   465,   324,   421,   226,   566,   483,   565,   204,
     506,   509,   429,   481,   478,   478,   330,   285,   461,   462,
     524,   495,   465,   466,  3484,  3485,   469,   567,   471,   162,
     239,   226,   546,    16,  2587,   539,  1563,   204,    76,   572,
     504,   506,  1460,    86,   122,   200,   565,   207,   307,    69,
    2887,   515,    90,   567,   516,   122,   524,   119,   182,   226,
      80,   386,   387,   223,   324,  2618,   229,   565,    35,   480,
     329,   539,   134,  2626,   234,  2188,  2629,   373,    56,    57,
     481,  1608,   204,   565,  1611,  3449,   182,    65,   364,  1507,
     572,   432,   433,  1511,   565,  2552,  1623,  1624,  1625,  1626,
    1627,   572,  3683,   567,   372,  2568,   351,  1634,  1635,  1636,
    1621,   200,   426,    69,   531,   532,  1534,   524,   525,   364,
     527,  1632,   529,  3661,    80,  1652,   558,   559,   332,  1634,
    1635,  1636,    99,   506,  1661,   512,   513,   337,   515,   106,
     340,  3601,   215,   364,    45,  1656,  2474,   307,   565,   408,
     477,   566,   567,   480,  3614,  1608,   351,   320,  1611,  1686,
     534,   117,   171,   537,   207,   608,   180,   566,   444,   364,
    2800,  1698,   572,  1626,  1627,   546,  2580,  1704,  2513,   256,
     223,  1634,  1635,  1636,   334,   506,  2800,  2300,  2513,  1015,
     157,   234,  1018,    15,    16,  1021,   163,  2221,  1835,  2312,
    2663,   566,   567,   566,   567,  2668,   142,   466,   228,  1720,
     566,   567,  3422,  3423,  3424,  3425,   566,   567,  1729,  1730,
    2520,   455,   189,  2853,  1735,  1736,  1737,  1738,  1865,  1740,
    1741,  3691,   565,  1686,   566,   567,  2640,   167,  2992,  2853,
     516,   132,   133,  3703,    56,    57,   506,     6,   408,   444,
     383,  1704,  1157,  1158,  2711,   142,   143,   566,   567,   397,
     274,   275,  1789,  3723,   307,   279,   280,  2897,   566,   567,
      11,    86,   228,  2774,  1911,  1802,   296,   151,  3115,  1916,
      86,   566,   567,  2897,  1811,   329,   253,   465,   175,   566,
     567,   527,  2749,   566,   567,   142,  3756,   184,  1159,  1160,
     320,   335,  3762,   477,  1815,  1816,   466,  1818,  1835,  1820,
    1821,  1822,  1823,  1824,   161,  1826,  1827,  1844,   566,   567,
     365,   516,  2777,  1850,   566,   567,  1853,   329,   175,   566,
     567,   411,   219,   201,  3135,  3136,   567,   184,  1865,  3799,
     296,   308,   442,   230,   566,   567,   565,  3148,   565,  3809,
    3810,   565,   319,  3154,   374,  1844,   323,   324,   565,  2459,
     565,   317,   318,  2000,   320,   408,   552,   566,   567,   565,
     257,  3831,   565,  3833,  2918,   565,  3177,  2921,  2922,  3180,
     565,  3841,   229,   230,  1911,   566,   567,   566,   567,  1916,
     566,   567,   207,  3082,  2938,   566,   567,  1850,   566,   567,
    1927,   207,   563,  2503,   566,   567,  2857,  2858,   223,   565,
     257,   565,  3872,  1940,   566,   567,   484,   223,   374,   234,
    3050,   566,   567,   466,   311,   566,   567,   557,   234,   565,
    1161,  1162,  1163,  1164,  1165,   455,  3050,  3538,   565,  2767,
     566,   567,   116,   572,  3654,   566,   567,   565,  3908,  3909,
     566,   567,  2856,  2857,  2858,  2568,   566,   567,   566,   567,
     565,  3921,  2099,   565,  2101,  2102,   565,   314,   566,   567,
    3523,   566,   567,  2000,   100,   101,   102,   103,   104,   565,
    3940,  3941,   566,   567,   565,  3945,   258,   259,   260,   261,
     262,   263,   307,   265,   266,   267,   268,   269,   270,   455,
     272,   307,   566,   567,  2031,  3342,  1109,  1110,  2145,  2146,
    3858,  3859,   565,  2976,   329,   565,   363,   484,   192,  3335,
    3336,   488,    47,   329,   491,  2980,  2809,  2810,   565,  2056,
    2705,  2706,  2996,  2997,   501,   565,   565,   565,   565,   506,
     565,  3903,   509,   565,   170,   250,  3664,  2074,   565,   565,
    2663,   171,   565,   565,   565,  2668,    47,   565,   565,   565,
     565,   565,   565,   329,   565,  2092,  2093,   193,   194,   195,
     196,   565,  2099,   565,  2101,  2102,   250,   565,   565,     6,
    2638,  2092,   567,   565,   565,   565,    13,    14,   565,   565,
     565,   558,   559,   408,   565,  2232,   565,   271,    25,    26,
     565,   565,   408,   565,  3016,   565,   565,   565,   565,  2136,
     565,   565,   565,   565,   386,   387,   565,   565,  2145,  2146,
    2257,   565,   565,   565,   565,  2152,   565,    54,   416,   515,
     147,    58,    59,   560,   429,   239,    63,   503,   168,   565,
     461,   461,    69,   461,   271,   477,   139,   250,    78,   567,
      77,   466,   331,   566,   329,     6,    83,   565,   475,  3869,
     466,    94,   288,  2152,   290,   291,   292,     4,    95,   420,
     539,    53,   389,   299,  2201,  2823,   151,    95,   571,   198,
    2203,  2208,   109,   567,  2211,   112,   539,   567,  2215,  2212,
    2217,   365,   119,   120,   572,  2218,   567,   371,   140,   126,
    2227,   571,  2229,  2230,   567,  2232,    47,   134,  2219,  2220,
     546,   138,  2239,   140,  2241,  3816,   567,  2240,  3819,  3820,
    3821,  3822,  2245,  2250,   477,   565,    65,   401,  2251,  2252,
    2257,    12,   543,  2244,   484,   566,   566,  2264,  2265,   166,
       9,   122,  3860,   566,   370,   572,   238,   566,   271,   565,
     559,   245,   350,   271,   567,  3856,  3857,   495,   495,   567,
     567,   495,   567,  3864,   438,   567,   567,   218,   560,   168,
     567,   520,   440,   353,   392,   202,   565,   204,   142,   566,
     142,   567,   142,   142,   142,   212,   142,   461,   142,   142,
     142,   567,   418,   419,   142,  2322,  2323,  2250,   225,   142,
     142,   522,   142,   477,   142,   548,   480,   142,   526,    45,
     171,   174,   567,   329,  3601,   376,   544,  2344,   566,  2346,
    2347,  2348,  2349,   567,   566,    18,   566,  3614,   567,   430,
     566,   566,   205,   566,   566,   566,   566,   560,   567,   566,
     171,   567,   566,   171,   566,   438,   566,   572,   567,   276,
     566,   566,   566,   180,   567,   567,   567,   566,   566,   565,
      12,    13,   566,  2976,   567,   566,   293,   566,   566,  2322,
     297,   567,   566,   566,   566,   566,   566,   566,   566,   565,
     567,   566,   566,   429,   567,   567,   567,   567,   566,    18,
     566,   556,   168,   566,    45,   567,   566,   566,   495,   570,
     567,   567,   566,   565,   567,   566,   333,   566,   566,   566,
     565,   338,   566,   565,   565,   455,   542,   566,   345,   572,
    2447,   567,   567,  3553,   351,   352,   455,   553,   554,   455,
     420,   455,  2459,    85,   455,  2462,  3723,  3392,  3393,   351,
      68,   351,   351,   495,   118,   224,   478,   224,  3360,  2476,
    2477,  2478,   379,   118,  3366,   351,   478,    86,    45,  3557,
     351,   113,  2489,  2600,   391,   392,   393,   394,  2495,  3756,
    2497,   349,   351,   527,   126,  3762,  2503,   351,  2489,   249,
     572,   248,  3437,  3007,   567,   572,   413,   572,   495,   495,
     495,   566,   487,   136,  2447,   566,   148,   214,   150,   566,
     566,   566,   171,   171,   171,   484,   566,   566,   160,   138,
    3016,    12,    13,   142,   572,   572,   572,   566,   566,   566,
     245,   549,   567,  3810,   471,   495,   565,   335,   180,   171,
     171,   171,   215,   171,   572,   220,   572,   546,   465,   168,
     567,   223,   223,   341,   289,  2556,  3833,   362,    69,   329,
      95,   478,   204,   182,  3841,  2582,    95,   565,   187,   211,
    2587,   572,   226,   226,   565,   182,   334,   484,   329,   565,
     329,   560,   338,  2600,  3529,   560,  2603,   504,   207,   351,
     566,   565,   487,   565,    85,  3872,   215,   565,   515,   216,
    2601,  2618,   216,   566,   223,   566,   248,   566,  2609,  2626,
    3730,   566,  2629,   566,   572,   234,   566,   566,   572,   567,
     239,  2638,   113,   567,   566,   201,   566,   566,   566,   248,
    2647,   566,   566,  2650,   567,   126,   566,  2654,  2655,   566,
     566,  2658,   567,   567,  3921,   566,    45,   566,   566,  2666,
     566,   566,   566,   566,   566,   566,   573,   148,  2659,   150,
    3332,  3333,  3334,  3940,  3941,   171,   567,   572,  3945,   160,
     566,  2688,   218,   567,   567,   566,   521,   236,    65,   260,
     223,   223,   329,   567,    73,  2812,   125,   226,   307,   180,
     226,   567,   567,    18,   417,   565,    18,    45,   565,   239,
     329,  2828,   129,  3372,   324,   566,   566,  2650,   324,   566,
     329,   423,   546,   204,   232,   240,   421,   182,   565,   338,
     211,   431,   142,   223,   223,   367,  3814,   566,   565,  3631,
     566,   566,   341,   109,   109,   360,   546,    33,   295,   228,
     566,   565,   384,   566,   566,  2688,   565,   366,   390,   565,
     371,  2768,   567,   567,   565,    13,   398,   248,   565,   565,
     572,   565,   565,  3851,  3884,   566,   566,   566,   215,   566,
     566,  2788,  3674,  3675,   567,  3677,   566,   566,   351,   421,
    3884,   566,   566,  2800,  2801,   566,  2803,   566,   566,   408,
     566,   566,   434,   435,   567,  2812,    45,   187,   572,  3887,
     295,  2818,   567,   484,   376,   484,   223,   527,  3928,   527,
     429,  2828,   565,   459,   324,   565,   324,   565,   565,  2836,
     537,   537,   565,   324,   485,   521,   109,    85,   226,   226,
     323,   567,   474,   546,   324,  3653,  2853,  3957,   324,   324,
     324,  3743,   324,  3745,  3746,  3514,   442,   466,    18,   484,
     484,   324,   566,  3957,   565,   113,   226,   499,   566,   295,
     484,  2878,   153,   565,  3360,    25,    26,   565,   126,  2886,
    3366,  2888,    67,   566,   566,    16,   367,   527,   527,   521,
    2897,   523,  3827,  3010,   137,  2902,   574,   565,   215,  2906,
     148,   543,   150,   384,   319,   532,   515,   566,    58,   390,
     566,   566,   160,   566,   566,   168,   566,   398,   527,    69,
     566,   324,   335,   521,   480,   241,   567,    77,   566,   261,
     543,   566,   180,   567,   171,   544,   566,   546,    59,   565,
     421,   335,    59,   347,   595,    95,   470,   366,  3065,   565,
      45,    45,   135,   434,   435,    45,   204,   566,   567,   109,
     565,   142,   112,   211,   573,   566,   566,   136,   215,     5,
     573,  3906,   567,   384,   335,   566,   335,   125,   131,   566,
     405,   531,   567,  2990,    45,    45,    45,   136,   543,   200,
     140,   255,   487,   474,  3524,   108,   573,   125,   574,   117,
     248,   652,   414,  3010,    16,   566,   657,    51,   573,   486,
     570,   565,   565,   264,   136,   567,   487,   185,   499,   567,
     136,   201,   573,   566,    51,   118,   118,   142,   140,   168,
     168,  3038,   168,   396,   324,   566,   687,   565,   565,  3156,
     521,   487,   523,  3050,   567,   109,   545,  3038,   241,   566,
     566,   429,   703,   471,   204,   169,  1829,  2973,  3065,   532,
    1869,  2185,   212,  2978,  3396,  3525,  3718,  3843,  3406,  3532,
    3399,  3878,  3962,  3106,  3644,   225,  3106,   907,  3106,  3106,
    3910,  3106,  3106,    25,    26,  3106,  3106,  3106,  3106,  3753,
    3081,  3593,  3753,   744,   745,   746,   747,  3106,  3616,  1340,
    3535,  1420,  1342,  2243,  2785,  3112,  2788,  3667,  3557,  3735,
    3887,  3442,  3851,   764,    56,    57,    58,  3234,  3121,   367,
    3961,  3967,  3824,    65,  1394,   456,   276,    69,  3296,  2323,
    2987,  1794,  2906,   943,  1324,    77,   384,  2267,  1802,  2206,
    2886,  2962,   390,   293,  3358,  3631,  3120,  2929,  3165,  3156,
     398,  3156,  2929,    95,  2890,  2828,  3273,  3628,  3617,  3350,
    3502,  1409,  3541,  3413,  3366,  1848,  3157,   109,  1801,  2888,
     112,  3125,  2260,   421,  3181,  1302,  3183,  1693,  1626,  2069,
     924,  2447,   896,  2035,  2083,   530,   434,   435,  3674,  3675,
    3197,  3677,  3444,  1154,   827,   345,  3203,  2777,   140,  3038,
    1641,  1073,   352,  1390,  1156,  1917,  2843,  3465,  2022,  2897,
    3294,  3859,  3906,  3273,  2088,  1896,  2795,  2073,  2794,  2853,
    3928,  3050,   520,  3730,  1224,   967,   474,  3234,   510,   593,
    2779,  1030,  1414,  3732,  1229,  3576,  3780,  1668,  3681,  3957,
    2800,  3158,  1647,  2836,  2505,  1048,  3281,   502,  1242,  3076,
    1611,   499,  1232,   810,  3420,  3426,  1436,  3743,  2344,  3745,
    3746,  1023,   204,   413,  3197,  1401,  3273,   503,   814,  3034,
     212,   559,   963,   521,  1130,   523,   927,  3785,  2321,  3204,
    2984,    -1,    -1,   225,    -1,    -1,  3293,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3301,    -1,    -1,    -1,    -1,  3306,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3882,    -1,    -1,   465,  3824,    -1,    -1,    -1,
      -1,    -1,  3329,  3330,    -1,    -1,    -1,    -1,   478,    -1,
      -1,    -1,    -1,    -1,   276,    -1,    -1,    -1,    -1,    -1,
    3347,    -1,  3912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   293,    -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1032,  1033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1041,  1042,  3962,  3400,  1045,  1046,  1047,    -1,    -1,    -1,
      -1,  1052,    -1,   345,  1055,  1056,  3413,  1058,    -1,  1060,
     352,  3402,    -1,    -1,   485,    -1,  1067,  1068,  1069,    -1,
    1071,    -1,    -1,    -1,    -1,    -1,    -1,  1078,  1079,    -1,
    1081,  1082,  3439,  3440,    -1,    -1,  1087,    -1,  1089,  1090,
    1091,    -1,  1093,  1094,  1095,  1096,  1097,  1098,  1099,    -1,
      -1,  1102,  1103,    -1,  1105,    -1,  1107,    -1,  3465,  3967,
    1111,    -1,  1113,  1114,    -1,    -1,  3952,    -1,    -1,  3476,
      -1,   413,    -1,    -1,  1125,  1126,    -1,    -1,    -1,    -1,
    1131,    -1,    -1,  1134,    -1,    -1,  1137,    -1,    -1,    -1,
    1141,    -1,    -1,    -1,    -1,    -1,    -1,  1148,  1149,    -1,
    1151,  1152,    -1,  1154,    -1,  1156,  1157,  1158,  1159,  1160,
    1161,  1162,  1163,  1164,  1165,  1166,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   465,   595,  3532,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
      -1,  1192,    -1,    -1,    -1,    -1,  3553,    -1,    -1,  3556,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   515,    -1,    -1,  3583,    -1,  3585,    -1,
    3587,    -1,    -1,    -1,    -1,    -1,   657,    -1,    -1,    -1,
      -1,  1242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1250,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    26,    -1,    -1,    -1,   687,    -1,    -1,    -1,
      -1,    -1,  3629,  3556,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    56,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    65,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,
    3667,    -1,    -1,    77,    -1,  3672,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   747,    -1,    -1,    -1,
      -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,    -1,   112,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3730,    -1,    -1,   140,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3861,    -1,    -1,    -1,    -1,    -1,
      -1,  3758,    -1,    -1,  3761,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1418,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3903,    -1,    -1,    -1,
     204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3924,    -1,    -1,
      -1,   225,    -1,    -1,    -1,  1466,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   238,  3832,    -1,    -1,  3835,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3959,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3861,    -1,   927,    -1,    -1,    -1,
      -1,    -1,   276,    -1,  3855,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3884,    -1,   293,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1541,  1542,  1543,    -1,    -1,    -1,  3903,    -1,    -1,    -1,
    3891,  3892,    -1,    -1,    -1,  3912,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3924,    -1,    -1,
      -1,  3928,    -1,    -1,    -1,    -1,    -1,  1578,    -1,    -1,
    1581,   345,  1583,    -1,  1585,  1586,    -1,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1600,
    3957,    -1,  3959,    -1,    -1,  3962,    -1,    -1,    -1,    -1,
      -1,  1032,  1033,    -1,    -1,    -1,    -1,    -1,    -1,  1620,
    1041,  1042,    -1,    -1,  1045,  1046,  1047,    -1,    -1,    -1,
      -1,  1052,    -1,    -1,  1055,  1056,    -1,  1058,    -1,  1060,
      -1,    -1,    -1,    -1,    -1,    -1,  1067,  1068,  1069,   413,
    1071,    -1,    -1,    -1,    -1,    -1,    -1,  1078,  1079,    -1,
    1081,  1082,    -1,    -1,    -1,    -1,  1087,    -1,  1089,  1090,
    1091,    -1,    -1,  1094,  1095,  1096,  1097,  1098,  1099,    -1,
      -1,  1102,  1103,    -1,  1105,    -1,  1107,    -1,    -1,    -1,
    1111,    -1,  1113,  1114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   465,    -1,    -1,  1125,  1126,    -1,    -1,    -1,    -1,
    1131,    -1,    -1,  1134,   478,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,    30,
     504,    -1,    -1,    34,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   515,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    -1,    -1,    54,    -1,    -1,    -1,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,
      -1,   565,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1813,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,  1242,   113,   114,   115,    -1,    -1,    -1,    -1,  1250,
      -1,    -1,    -1,    -1,   125,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   180,
      -1,    -1,    -1,    -1,   185,    -1,  1897,   188,    -1,    -1,
    1901,    -1,    -1,    -1,    -1,  1906,  1907,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1915,    -1,    -1,    -1,    -1,    -1,
     211,    -1,   213,    -1,    -1,    -1,    -1,    -1,  1929,    -1,
    1931,    -1,    -1,  1934,  1935,  1936,   227,    -1,  1939,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,
      -1,    -1,    -1,   244,  1955,    -1,  1957,   248,  1959,  1960,
    1961,    -1,    -1,    -1,    -1,  1966,  1967,  1968,    -1,    -1,
      -1,    -1,  1973,  1974,  1975,    -1,  1977,    -1,  1979,    -1,
    1981,    -1,  1983,    -1,  1985,    -1,    -1,    -1,    -1,  1990,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1418,    -1,    -1,
    2001,    -1,    -1,    -1,  2005,    -1,    -1,  2008,    -1,    -1,
      -1,    -1,    -1,  2014,    -1,    -1,  2017,    -1,    -1,    -1,
    2021,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,    -1,    -1,  1466,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,    -1,
      -1,   392,    -1,   394,    -1,    -1,   397,    -1,    -1,   400,
      -1,   402,    -1,    -1,    -1,    -1,   407,    -1,   409,    -1,
    1541,  1542,  1543,    -1,    -1,   416,    -1,    -1,    -1,    -1,
     421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   429,    -1,
      -1,    -1,    -1,   434,    -1,    -1,    -1,   438,  2149,  2150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1578,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   460,
      -1,    -1,    -1,   464,    -1,    -1,    -1,    -1,    -1,  1600,
      -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,
      -1,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1620,
      -1,    -1,    -1,    25,    26,    -1,    -1,    -1,    -1,    -1,
      -1,   502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   514,    -1,    -1,    -1,   518,    -1,    -1,
     521,    -1,    54,    -1,    -1,   526,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,
     551,    83,    -1,    -1,    -1,    13,    14,    -1,    -1,    -1,
      -1,    -1,    -1,    95,   565,    -1,    -1,    -1,    -1,    -1,
      28,    -1,    -1,    -1,    -1,    -1,    34,   109,    -1,    -1,
     112,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    47,
      48,    -1,    -1,    -1,   126,    -1,    54,    -1,    -1,    -1,
      58,    59,   134,    -1,    -1,    -1,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,
    2351,    -1,    -1,    -1,  2355,    -1,    -1,   105,  2359,    -1,
      -1,    -1,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,   126,    -1,
      -1,    -1,   204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     212,    -1,  1813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2401,    -1,   150,   225,    -1,    -1,    -1,    -1,    -1,  2410,
      -1,  2412,    -1,  2414,    -1,    -1,    -1,   165,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   180,  2434,    -1,    -1,    -1,   185,  2439,    -1,
     188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2451,    -1,    -1,    -1,   276,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   211,    -1,   213,    -1,    -1,    -1,    -1,
      -1,   293,    -1,    -1,    -1,   297,  1897,    -1,    -1,   227,
    1901,    -1,    -1,    -1,    -1,  1906,  1907,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1915,    -1,   244,  2498,    -1,    -1,
     248,  2502,    -1,    -1,    -1,    -1,    -1,    -1,  1929,    -1,
    1931,    -1,    -1,  1934,  1935,  1936,   338,    -1,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,  1947,    -1,    -1,    -1,
     352,    -1,    -1,    -1,  1955,    -1,  1957,    -1,  1959,  1960,
    1961,    -1,    -1,  2544,    -1,  1966,  1967,  1968,    -1,    -1,
      -1,    -1,  1973,  1974,  1975,    -1,  1977,    -1,  1979,    -1,
    1981,    -1,  1983,    -1,  1985,    -1,    -1,    -1,    -1,  1990,
     392,    -1,    -1,    -1,    -1,    -1,  2577,    -1,    -1,    -1,
    2001,    -1,    -1,    -1,    -1,   333,    -1,    -1,    -1,    -1,
      -1,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2021,    -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   389,    -1,   465,   392,    -1,   394,    -1,    -1,   397,
      -1,    -1,   400,    -1,   402,    -1,   478,    -1,    -1,   407,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,
      -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   429,   504,    -1,    -1,    -1,   434,    -1,    -1,    -1,
     438,    -1,    -1,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2707,    -1,    -1,    -1,
      -1,    -1,   460,  2714,    -1,    -1,   464,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2149,  2150,
      -1,    -1,    32,    33,    -1,  2736,  2737,    -1,    38,    -1,
      40,    41,    42,    -1,    -1,  2746,    -1,    -1,    -1,    -1,
    2751,    -1,    -1,  2754,   502,  2756,  2757,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   514,    -1,    -1,    -1,
     518,    -1,    -1,   521,    -1,    -1,    -1,    -1,   526,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2794,    -1,    -1,    96,    -1,    -1,    99,
      -1,    -1,    -1,   551,    -1,    -1,    -1,   107,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,    -1,    -1,
      -1,    -1,  2823,    -1,   124,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2855,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   162,    -1,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   176,   177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2351,    -1,    -1,    -1,  2355,    -1,    -1,    -1,  2359,    -1,
      -1,    -1,   242,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   251,   252,    -1,   254,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2401,    -1,   282,   283,   284,    -1,    -1,    -1,    -1,  2410,
      -1,  2412,    -1,  2414,    -1,    -1,    -1,    -1,    -1,    -1,
     300,   301,   302,    -1,    -1,    -1,   306,    -1,    -1,   309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2439,    -1,
      -1,    -1,    -1,    -1,    -1,   325,   326,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3051,    23,    -1,    -1,    -1,    -1,   356,   357,    -1,    -1,
      -1,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2498,   378,    -1,
      -1,  2502,    -1,    -1,    56,    57,    -1,    -1,    -1,    -1,
    3091,  3092,    -1,    -1,    66,    -1,    68,    -1,    -1,    -1,
      -1,  3102,    -1,    -1,    -1,  3106,    -1,    -1,    -1,    -1,
      82,    -1,    84,    85,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    -1,  2544,    -1,   425,    -1,    -1,    -1,   429,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2577,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   485,    -1,    -1,   488,    -1,
      -1,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     172,    -1,   174,    -1,    -1,    -1,    -1,   179,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3227,    -1,    -1,    -1,
      -1,   203,   204,   533,   534,    -1,   208,    -1,    -1,    -1,
      -1,    -1,  3243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   224,    -1,   554,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3268,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
    3281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2714,    -1,    -1,    -1,  3298,    -1,   271,
      -1,    -1,    -1,  3304,  3305,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2736,  2737,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2746,    -1,    -1,    -1,    -1,
    2751,   303,    -1,  2754,    -1,  2756,  2757,    -1,    -1,    -1,
      -1,   313,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   365,   366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3448,    -1,    -1,
      -1,    -1,    -1,    -1,   426,    -1,    -1,  3458,    -1,  3460,
      -1,    -1,    -1,    -1,    -1,    -1,   438,    -1,  3469,    -1,
    3471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3481,    -1,    -1,  3484,  3485,    -1,    -1,    -1,    -1,   461,
      -1,    -1,    -1,   465,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   480,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3557,    -1,    -1,    -1,
      -1,    -1,    -1,   535,    -1,    -1,  3567,    -1,    -1,   541,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3598,    -1,    -1,
    3601,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3614,  3615,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3655,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3091,  3092,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3102,    -1,  3684,    -1,    -1,    -1,    -1,    -1,  3690,
    3691,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3703,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3723,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3756,    -1,    -1,    -1,    -1,
      -1,  3762,    -1,    -1,    -1,  3766,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3792,    -1,    -1,    -1,    -1,    -1,    -1,  3799,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3809,  3810,
      -1,    -1,    -1,  3814,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3831,    -1,  3833,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3841,    -1,    -1,    -1,    -1,    -1,    -1,  3268,    -1,    -1,
    3851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3281,    -1,    -1,    -1,  3865,    -1,    -1,    -1,    -1,    -1,
      -1,  3872,    -1,    -1,    -1,    -1,    -1,  3298,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3887,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3908,  3909,    -1,
      -1,    -1,  3913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3940,
    3941,    -1,    -1,    -1,  3945,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3448,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3458,    -1,  3460,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3469,    -1,
    3471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3481,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3567,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3598,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3615,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3684,    -1,    -1,    -1,    -1,    -1,  3690,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    53,    -1,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,  3766,    -1,    78,    -1,    80,
      -1,    82,    83,    84,    -1,    -1,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    99,    -1,
      -1,  3792,    -1,   104,   105,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,   150,
     151,    -1,   153,   154,   155,   156,   157,   158,    -1,   160,
     161,   162,   163,    -1,   165,    -1,    -1,    -1,   169,   170,
      -1,   172,    -1,   174,  3865,   176,   177,   178,   179,    -1,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,   192,    -1,    -1,    -1,   196,   197,   198,   199,   200,
      -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,
     211,   212,   213,   214,    -1,    -1,   217,    -1,    -1,   220,
     221,    -1,  3913,    -1,   225,    -1,    -1,   228,   229,    -1,
     231,   232,    -1,   234,   235,   236,    -1,    -1,    -1,    -1,
      -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,   250,
      -1,    -1,   253,    -1,    -1,    -1,    -1,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,
      -1,   292,   293,   294,   295,    -1,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
      -1,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,    -1,   323,   324,    -1,   326,   327,   328,    -1,   330,
     331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,
     381,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,   395,   396,   397,   398,    -1,   400,
     401,   402,    -1,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,   419,   420,
      -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,
     451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,
     461,   462,   463,   464,   465,    -1,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,    -1,    -1,
     481,   482,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,    -1,   496,   497,   498,    -1,   500,
     501,   502,   503,   504,   505,   506,   507,   508,   509,   510,
     511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,
      -1,   522,    -1,   524,   525,    -1,    -1,   528,   529,   530,
     531,   532,    -1,    -1,   535,   536,    -1,   538,   539,   540,
     541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,
     551,    -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,    -1,   564,   565,    -1,    -1,   568,   569,    -1,
     571,   572,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      53,    -1,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,
      83,    84,    -1,    -1,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    99,    -1,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,   136,   137,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,   150,   151,    -1,
     153,   154,   155,   156,   157,   158,    -1,   160,   161,   162,
     163,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,
      -1,   174,    -1,   176,   177,   178,   179,    -1,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,   192,
      -1,    -1,    -1,   196,   197,   198,   199,   200,    -1,   202,
     203,    -1,    -1,   206,    -1,   208,    -1,    -1,   211,   212,
     213,   214,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,
      -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,
      -1,   234,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,
     253,    -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
      -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,   292,
     293,   294,   295,    -1,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,    -1,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,    -1,
     323,   324,    -1,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
      -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,   395,   396,   397,   398,    -1,   400,   401,   402,
      -1,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,   419,   420,    -1,    -1,
      -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,
     453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,   462,
     463,   464,   465,    -1,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,    -1,    -1,   481,   482,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,    -1,    -1,   497,   498,    -1,   500,   501,   502,
     503,   504,   505,   506,   507,   508,   509,   510,   511,    -1,
     513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,
      -1,   524,   525,    -1,    -1,   528,   529,   530,   531,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
      -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,
      -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
      -1,   564,   565,    -1,    -1,   568,   569,    -1,   571,   572,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    53,    -1,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    -1,    82,    83,    84,
      -1,    -1,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    99,    -1,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
      -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,   150,   151,    -1,   153,   154,
     155,   156,   157,   158,    -1,   160,   161,   162,   163,    -1,
     165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,
      -1,   176,   177,   178,   179,    -1,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,   192,    -1,    -1,
      -1,   196,   197,   198,   199,   200,    -1,   202,   203,    -1,
      -1,   206,    -1,   208,    -1,    -1,   211,   212,   213,   214,
      -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,
     225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,   234,
     235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,
     245,    -1,   247,    -1,   249,   250,    -1,    -1,   253,    -1,
      -1,    -1,    -1,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,    -1,    -1,
     285,   286,   287,   288,   289,    -1,    -1,   292,   293,   294,
     295,    -1,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,    -1,   323,   324,
      -1,   326,   327,   328,    -1,   330,   331,   332,    -1,   334,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,
     375,    -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
     395,   396,   397,   398,    -1,   400,   401,   402,    -1,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,    -1,   419,   420,   421,    -1,    -1,   424,
     425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,    -1,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,
      -1,   456,    -1,    -1,   459,   460,   461,   462,   463,   464,
     465,    -1,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,    -1,    -1,   481,   482,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
      -1,    -1,   497,   498,    -1,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,    -1,   513,   514,
      -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,
     525,    -1,    -1,   528,   529,   530,   531,   532,    -1,    -1,
     535,   536,    -1,   538,   539,   540,   541,   542,    -1,    -1,
      -1,    -1,   547,   548,    -1,   550,   551,    -1,    -1,   554,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,    -1,    -1,   568,   569,    -1,   571,   572,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    53,    -1,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    -1,    82,    83,    84,    -1,    -1,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    99,    -1,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,   150,   151,    -1,   153,   154,   155,   156,
     157,   158,    -1,   160,   161,   162,   163,    -1,   165,    -1,
      -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,
     177,   178,   179,    -1,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,   192,    -1,    -1,    -1,   196,
     197,   198,   199,   200,    -1,   202,   203,    -1,    -1,   206,
      -1,   208,    -1,    -1,   211,   212,   213,   214,    -1,    -1,
     217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,
      -1,   228,   229,    -1,    -1,   232,    -1,   234,   235,   236,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
     247,    -1,   249,   250,    -1,    -1,   253,    -1,    -1,    -1,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,    -1,    -1,   285,   286,
     287,   288,   289,    -1,    -1,   292,   293,   294,   295,    -1,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,    -1,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,    -1,   323,   324,    -1,   326,
     327,   328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,
      -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,
     427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,
      -1,    -1,   459,   460,   461,   462,   463,   464,   465,    -1,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,    -1,    -1,   481,   482,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,
     497,   498,    -1,   500,   501,   502,   503,   504,   505,   506,
     507,   508,   509,   510,   511,    -1,   513,   514,    -1,    -1,
     517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,
      -1,   528,   529,   530,   531,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,    -1,    -1,    -1,    -1,
     547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,    -1,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    53,    -1,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    -1,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    -1,    82,    83,    84,    -1,    -1,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      99,    -1,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,   150,   151,    -1,   153,   154,   155,   156,   157,   158,
      -1,   160,   161,   162,   163,    -1,   165,    -1,    -1,    -1,
     169,   170,   171,   172,    -1,   174,    -1,   176,   177,   178,
     179,    -1,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,
     199,   200,    -1,   202,   203,    -1,    -1,   206,    -1,   208,
      -1,    -1,   211,   212,   213,   214,    -1,    -1,   217,    -1,
      -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,
     229,    -1,    -1,   232,    -1,   234,   235,   236,    -1,    -1,
      -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,
     249,   250,    -1,    -1,   253,    -1,    -1,    -1,    -1,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,    -1,    -1,   285,   286,   287,   288,
     289,    -1,    -1,   292,   293,   294,   295,    -1,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,    -1,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,    -1,   323,   324,    -1,   326,   327,   328,
      -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,
     379,   380,   381,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,   395,   396,   397,   398,
      -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,    -1,
     419,   420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
      -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,
      -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,
     459,   460,   461,   462,   463,   464,   465,    -1,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
      -1,    -1,   481,   482,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,
      -1,   500,   501,   502,   503,   504,   505,   506,   507,   508,
     509,   510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,
      -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,   528,
     529,   530,   531,   532,    -1,    -1,   535,   536,    -1,   538,
     539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,
      -1,   550,   551,    -1,    -1,   554,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,    -1,   568,
     569,    -1,   571,   572,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    53,    -1,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      -1,    82,    83,    84,    -1,    -1,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    99,    -1,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,   150,
     151,    -1,   153,   154,   155,   156,   157,   158,    -1,   160,
     161,   162,   163,    -1,   165,    -1,    -1,    -1,   169,   170,
     171,   172,    -1,   174,    -1,   176,   177,   178,   179,    -1,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,   192,    -1,    -1,    -1,   196,   197,   198,   199,   200,
      -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,
     211,   212,   213,   214,    -1,    -1,   217,    -1,    -1,   220,
     221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,
      -1,   232,    -1,   234,   235,   236,    -1,    -1,    -1,    -1,
      -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,   250,
      -1,    -1,   253,    -1,    -1,    -1,    -1,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,
      -1,   292,   293,   294,   295,    -1,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
      -1,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,    -1,   323,   324,    -1,   326,   327,   328,    -1,   330,
     331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,
     381,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,   395,   396,   397,   398,    -1,   400,
     401,   402,    -1,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,   419,   420,
      -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,
     451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,
     461,   462,   463,   464,   465,    -1,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,    -1,    -1,
     481,   482,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,   500,
     501,   502,   503,   504,   505,   506,   507,   508,   509,   510,
     511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,
      -1,   522,    -1,   524,   525,    -1,    -1,   528,   529,   530,
     531,   532,    -1,    -1,   535,   536,    -1,   538,   539,   540,
     541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,
     551,    -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,    -1,   564,   565,    -1,    -1,   568,   569,    -1,
     571,   572,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      53,    -1,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,
      83,    84,    -1,    -1,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    99,    -1,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,   136,   137,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,   150,   151,    -1,
     153,   154,   155,   156,   157,   158,    -1,   160,   161,   162,
     163,    -1,   165,    -1,    -1,    -1,   169,   170,   171,   172,
      -1,   174,    -1,   176,   177,   178,   179,    -1,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,   192,
      -1,    -1,    -1,   196,   197,   198,   199,   200,    -1,   202,
     203,    -1,    -1,   206,    -1,   208,    -1,    -1,   211,   212,
     213,   214,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,
      -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,
      -1,   234,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,
     253,    -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
      -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,   292,
     293,   294,   295,    -1,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,    -1,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,    -1,
     323,   324,    -1,   326,   327,   328,    -1,   330,   331,   332,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
      -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,   395,   396,   397,   398,    -1,   400,   401,   402,
      -1,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,   419,   420,    -1,    -1,
      -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,
     453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,   462,
     463,   464,   465,    -1,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,    -1,    -1,   481,   482,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,    -1,    -1,   497,   498,    -1,   500,   501,   502,
     503,   504,   505,   506,   507,   508,   509,   510,   511,    -1,
     513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,
      -1,   524,   525,    -1,    -1,   528,   529,   530,   531,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
      -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,
      -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
      -1,   564,   565,    -1,    -1,   568,   569,    -1,   571,   572,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    53,    -1,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    -1,    82,    83,    84,
      -1,    -1,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    99,    -1,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
      -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,   150,   151,    -1,   153,   154,
     155,   156,   157,   158,    -1,   160,   161,   162,   163,    -1,
     165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,
      -1,   176,   177,   178,   179,    -1,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,   192,    -1,    -1,
      -1,   196,   197,   198,   199,   200,    -1,   202,   203,    -1,
      -1,   206,    -1,   208,    -1,    -1,   211,   212,   213,   214,
      -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,
     225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,   234,
     235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,
     245,    -1,   247,    -1,   249,   250,    -1,    -1,   253,    -1,
      -1,    -1,    -1,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,    -1,    -1,
     285,   286,   287,   288,   289,    -1,    -1,   292,   293,   294,
     295,    -1,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,    -1,   323,   324,
      -1,   326,   327,   328,    -1,   330,   331,   332,    -1,   334,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,
     375,    -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
     395,   396,   397,   398,    -1,   400,   401,   402,    -1,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,
     425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,    -1,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,
      -1,   456,    -1,    -1,   459,   460,   461,   462,   463,   464,
     465,    -1,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,    -1,    -1,   481,   482,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
      -1,    -1,   497,   498,    -1,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,    -1,   513,   514,
      -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,
     525,    -1,    -1,   528,   529,   530,   531,   532,    -1,    -1,
     535,   536,    -1,   538,   539,   540,   541,   542,    -1,    -1,
      -1,    -1,   547,   548,    -1,   550,   551,    -1,    -1,   554,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,    -1,    -1,   568,   569,    -1,   571,   572,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    53,    -1,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    -1,    82,    83,    84,    -1,    -1,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    99,    -1,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,   150,   151,    -1,   153,   154,   155,   156,
     157,   158,    -1,   160,   161,   162,   163,    -1,   165,    -1,
      -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,
     177,   178,   179,    -1,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,   192,    -1,    -1,    -1,   196,
     197,   198,   199,   200,    -1,   202,   203,    -1,    -1,   206,
      -1,   208,    -1,    -1,   211,   212,   213,   214,    -1,    -1,
     217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,
      -1,   228,   229,    -1,    -1,   232,    -1,   234,   235,   236,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
     247,    -1,   249,   250,    -1,    -1,   253,    -1,    -1,    -1,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,    -1,    -1,   285,   286,
     287,   288,   289,    -1,    -1,   292,   293,   294,   295,    -1,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,    -1,    -1,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,    -1,   323,   324,    -1,   326,
     327,   328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,
      -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,
     427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,
      -1,    -1,   459,   460,   461,   462,   463,   464,   465,    -1,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,    -1,    -1,   481,   482,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,
     497,   498,    -1,   500,   501,   502,   503,   504,   505,   506,
     507,   508,   509,   510,   511,    -1,   513,   514,    -1,    -1,
     517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,
      -1,   528,   529,   530,   531,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,    -1,    -1,    -1,    -1,
     547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
      -1,   568,   569,    -1,   571,   572,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    51,    52,    53,    -1,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    -1,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      -1,    80,    -1,    82,    83,    84,    -1,    -1,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      99,    -1,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,   150,   151,    -1,   153,   154,   155,   156,   157,   158,
      -1,   160,   161,   162,   163,    -1,   165,    -1,    -1,    -1,
     169,   170,    -1,   172,    -1,   174,    -1,   176,   177,   178,
     179,    -1,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,
     199,   200,    -1,   202,   203,    -1,    -1,   206,    -1,   208,
      -1,    -1,   211,   212,   213,   214,    -1,    -1,   217,    -1,
      -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,
     229,    -1,    -1,   232,    -1,   234,   235,   236,    -1,    -1,
      -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,
     249,   250,    -1,    -1,   253,    -1,    -1,    -1,    -1,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,    -1,    -1,   285,   286,   287,   288,
     289,    -1,    -1,   292,   293,   294,   295,    -1,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,    -1,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,    -1,   323,   324,    -1,   326,   327,   328,
      -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,
     379,   380,   381,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,   395,   396,   397,   398,
      -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,    -1,
     419,   420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
      -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,
      -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,
     459,   460,   461,   462,   463,   464,   465,    -1,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
      -1,    -1,   481,   482,    -1,   484,   485,   486,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,
      -1,   500,   501,   502,   503,   504,   505,   506,   507,   508,
     509,   510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,
      -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,   528,
     529,   530,   531,   532,    -1,    -1,   535,   536,    -1,   538,
     539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,
      -1,   550,   551,    -1,    -1,   554,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,    -1,   564,   565,    -1,    -1,   568,
     569,    -1,   571,   572,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      51,    52,    53,    -1,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      -1,    82,    83,    84,    -1,    -1,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    99,    -1,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,   150,
     151,    -1,   153,   154,   155,   156,   157,   158,    -1,   160,
     161,   162,   163,    -1,   165,    -1,    -1,    -1,   169,   170,
      -1,   172,    -1,   174,    -1,   176,   177,   178,   179,    -1,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,   192,    -1,    -1,    -1,   196,   197,   198,   199,   200,
      -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,
     211,   212,   213,   214,    -1,    -1,   217,    -1,    -1,   220,
     221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,
      -1,   232,    -1,   234,   235,   236,    -1,    -1,    -1,    -1,
      -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,   250,
      -1,    -1,   253,    -1,    -1,    -1,    -1,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,
      -1,   292,   293,   294,   295,    -1,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
      -1,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,    -1,   323,   324,    -1,   326,   327,   328,    -1,   330,
     331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,
     381,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,   395,   396,   397,   398,    -1,   400,
     401,   402,    -1,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,   419,   420,
      -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,
     451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,
     461,   462,   463,   464,   465,    -1,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,    -1,    -1,
     481,   482,    -1,   484,   485,   486,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,   500,
     501,   502,   503,   504,   505,   506,   507,   508,   509,   510,
     511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,
      -1,   522,    -1,   524,   525,    -1,    -1,   528,   529,   530,
     531,   532,    -1,    -1,   535,   536,    -1,   538,   539,   540,
     541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,
     551,    -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,    -1,   564,   565,    -1,    -1,   568,   569,    -1,
     571,   572,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,    52,
      53,    -1,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,
      83,    84,    -1,    -1,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    99,    -1,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,   136,   137,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,   150,   151,    -1,
     153,   154,   155,   156,   157,   158,    -1,   160,   161,   162,
     163,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,
      -1,   174,    -1,   176,   177,   178,   179,    -1,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,   192,
      -1,    -1,    -1,   196,   197,   198,   199,   200,    -1,   202,
     203,    -1,    -1,   206,    -1,   208,    -1,    -1,   211,   212,
     213,   214,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,
      -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,
      -1,   234,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,
     253,    -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
      -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,   292,
     293,   294,   295,    -1,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,    -1,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,    -1,
     323,   324,    -1,   326,   327,   328,    -1,   330,   331,   332,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
      -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,   395,   396,   397,   398,    -1,   400,   401,   402,
      -1,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,   419,   420,    -1,    -1,
      -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,
     453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,   462,
     463,   464,   465,    -1,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,    -1,    -1,   481,   482,
      -1,   484,   485,   486,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,    -1,    -1,   497,   498,    -1,   500,   501,   502,
     503,   504,   505,   506,   507,   508,   509,   510,   511,    -1,
     513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,
      -1,   524,   525,    -1,    -1,   528,   529,   530,   531,   532,
      -1,    -1,   535,   536,    -1,   538,   539,   540,   541,   542,
      -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,
      -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
      -1,   564,   565,    -1,    -1,   568,   569,    -1,   571,   572,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    51,    52,    53,    -1,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    -1,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    78,    -1,    80,    -1,    82,    83,    84,
      -1,    -1,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    99,    -1,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
      -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,   150,   151,    -1,   153,   154,
     155,   156,   157,   158,    -1,   160,   161,   162,   163,    -1,
     165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,
      -1,   176,   177,   178,   179,    -1,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,   192,    -1,    -1,
      -1,   196,   197,   198,   199,   200,    -1,   202,   203,    -1,
      -1,   206,    -1,   208,    -1,    -1,   211,   212,   213,   214,
      -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,
     225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,   234,
     235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,
     245,    -1,   247,    -1,   249,   250,    -1,    -1,   253,    -1,
      -1,    -1,    -1,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,    -1,    -1,
     285,   286,   287,   288,   289,    -1,    -1,   292,   293,   294,
     295,    -1,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,    -1,    -1,   313,   314,
     315,   316,   317,    -1,   319,   320,   321,    -1,   323,   324,
      -1,   326,   327,   328,    -1,   330,   331,   332,    -1,   334,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,
     375,    -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,   391,    -1,   393,   394,
     395,   396,   397,   398,    -1,   400,   401,   402,    -1,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,
     425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,    -1,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,
      -1,   456,    -1,    -1,   459,   460,   461,   462,   463,   464,
     465,    -1,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,    -1,    -1,   481,   482,    -1,   484,
     485,   486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
      -1,    -1,   497,   498,    -1,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,    -1,   513,   514,
      -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,
     525,    -1,    -1,   528,   529,   530,   531,   532,    -1,    -1,
     535,   536,    -1,   538,   539,   540,   541,   542,    -1,    -1,
      -1,    -1,   547,   548,    -1,   550,   551,    -1,    -1,   554,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,    -1,    -1,   568,   569,    -1,   571,   572,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    51,    52,    53,    -1,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    -1,    82,    83,    84,    -1,    -1,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    99,    -1,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,   150,   151,    -1,   153,   154,   155,   156,
     157,   158,    -1,   160,   161,   162,   163,    -1,   165,    -1,
      -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,
     177,   178,   179,    -1,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,   192,    -1,    -1,    -1,   196,
     197,   198,   199,   200,    -1,   202,   203,    -1,    -1,   206,
      -1,   208,    -1,    -1,   211,   212,   213,   214,    -1,    -1,
     217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,
      -1,   228,   229,    -1,    -1,   232,    -1,   234,   235,   236,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
     247,    -1,   249,   250,    -1,    -1,   253,    -1,    -1,    -1,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,    -1,    -1,   285,   286,
     287,   288,   289,    -1,    -1,   292,   293,   294,   295,    -1,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,    -1,    -1,   313,   314,   315,   316,
     317,    -1,   319,   320,   321,    -1,   323,   324,    -1,   326,
     327,   328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,
      -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,
     427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,
      -1,    -1,   459,   460,   461,   462,   463,   464,   465,    -1,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,    -1,    -1,   481,   482,    -1,   484,   485,   486,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,
     497,   498,    -1,   500,   501,   502,   503,   504,   505,   506,
     507,   508,   509,   510,   511,    -1,   513,   514,    -1,    -1,
     517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,
      -1,   528,   529,   530,   531,   532,    -1,    -1,   535,   536,
      -1,   538,   539,   540,   541,   542,    -1,    -1,    -1,    -1,
     547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,    -1,   564,   565,    -1,
      -1,   568,   569,    -1,   571,   572,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    -1,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    78,
      79,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,
      99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,
      -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,
      -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,   176,   177,   178,
     179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,
      -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,
     199,    -1,    -1,   202,   203,   204,    -1,   206,    -1,   208,
      -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,
      -1,   220,   221,    -1,    -1,    -1,   225,   226,    -1,   228,
     229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,   238,
      -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,    -1,
     279,   280,   281,    -1,    -1,    -1,   285,   286,   287,   288,
     289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,
     299,   300,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,
      -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,
      -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
      -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,
     379,   380,   381,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,   398,
      -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,
     409,   410,   411,   412,   413,   414,   415,   416,   417,    -1,
     419,   420,   421,    -1,    -1,   424,   425,   426,   427,    -1,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
      -1,   440,   441,   442,   443,   444,    -1,    -1,    -1,    -1,
      -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,
     459,   460,   461,    -1,    -1,   464,   465,    -1,   467,   468,
     469,   470,   471,    -1,    -1,   474,   475,    -1,   477,   478,
      -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,
      -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,   508,
      -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,
      -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,
      -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,
     539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,
      -1,   550,   551,    -1,    -1,   554,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   572,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    79,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,   173,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,   204,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,   226,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,   444,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,    -1,   554,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   572,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,
      -1,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,
      -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,
      -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,   150,    -1,    -1,   153,   154,   155,    -1,
      -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,
      -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,
     177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,
      -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,
     197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,
      -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,
     217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,
      -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
     247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,
     287,   288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,   316,
      -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,
     327,   328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,
      -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,   395,    -1,
      -1,   398,    -1,   400,   401,   402,    -1,   404,   405,    -1,
      -1,    -1,   409,   410,   411,   412,   413,   414,   415,   416,
     417,    -1,   419,   420,   421,    -1,    -1,   424,   425,   426,
     427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,
      -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,
     467,   468,   469,   470,   471,    -1,    -1,   474,   475,    -1,
     477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,
     497,   498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,
     507,   508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,
     517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,
      -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,
      -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,
     547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   566,
      -1,    17,    -1,    -1,    20,   572,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
     566,    -1,    -1,    -1,    17,   571,   572,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,
      53,    -1,    55,    56,    -1,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,
      -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,
      -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,   136,   137,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,   150,    -1,    -1,
     153,   154,   155,    -1,    -1,   158,    -1,   160,   161,   162,
      -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,
      -1,   174,    -1,   176,   177,   178,   179,    -1,   181,    -1,
      -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,
      -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,
     203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,   220,   221,    -1,
      -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,    -1,   279,   280,   281,    -1,
      -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,   292,
     293,    -1,   295,    -1,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,
      -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,   332,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,    -1,   361,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
      -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,   395,    -1,    -1,   398,    -1,   400,   401,   402,
      -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,   419,   420,    -1,    -1,
      -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,
     453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,
      -1,   464,   465,    -1,   467,   468,   469,   470,   471,    -1,
      -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,   482,
      -1,    -1,   485,   486,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,
     503,   504,   505,    -1,   507,   508,    -1,   510,   511,    -1,
     513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,
      -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,
      -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,
      -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,
      -1,   554,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   572,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,    -1,   554,    -1,    -1,    -1,    -1,     5,   560,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
     572,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,    -1,   554,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,   565,    -1,    -1,
      17,    -1,    -1,    20,   572,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,
      -1,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    -1,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,
      -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,
      -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,
      -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,   150,    -1,    -1,   153,   154,   155,    -1,
      -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,
      -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,
     177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,
      -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,
     197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,
      -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,
     217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,
      -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,
      -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,
     247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,
     287,   288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,
     297,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,   316,
      -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,
     327,   328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,
      -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,   391,    -1,   393,   394,   395,    -1,
      -1,   398,    -1,   400,   401,   402,    -1,   404,   405,    -1,
      -1,    -1,   409,   410,   411,   412,   413,   414,   415,   416,
     417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,
     427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,
      -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,
     467,   468,   469,   470,   471,    -1,    -1,   474,   475,    -1,
     477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,
     497,   498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,
     507,   508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,
     517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,
      -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,
      -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,
     547,   548,    -1,   550,   551,    -1,    -1,   554,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,   571,   572,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
      -1,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,    -1,
     554,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   572,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,
      53,    -1,    55,    56,    -1,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    -1,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,
      -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,
      -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,
      -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,   136,   137,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,   150,    -1,    -1,
     153,   154,   155,    -1,    -1,   158,    -1,   160,   161,   162,
      -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,
      -1,   174,    -1,   176,   177,   178,   179,    -1,   181,    -1,
      -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,
      -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,
     203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,
     213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,
      -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,
      -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,
     243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,    -1,   279,   280,   281,    -1,
      -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,   292,
     293,    -1,   295,    -1,   297,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,
     313,   314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,
      -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,   332,
      -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   344,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,    -1,   361,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
      -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,
     393,   394,   395,    -1,    -1,   398,    -1,   400,   401,   402,
      -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,   412,
     413,   414,   415,   416,   417,    -1,   419,   420,    -1,    -1,
      -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,    -1,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,
     453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,
      -1,   464,   465,    -1,   467,   468,   469,   470,   471,    -1,
      -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,   482,
      -1,    -1,   485,   486,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,
     503,   504,   505,    -1,   507,   508,    -1,   510,   511,    -1,
     513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,
      -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,
      -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,
      -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,
      -1,   554,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   572,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,    -1,   554,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     572,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    78,    -1,    80,
      -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,
      -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,
      -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,   150,
      -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,
     161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,
      -1,   172,    -1,   174,    -1,   176,   177,   178,   179,    -1,
     181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,
     191,   192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,
      -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,
      -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,
     221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,
      -1,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,
      -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,   250,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,    -1,   279,   280,
     281,    -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,
      -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,    -1,   309,   310,
      -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,
     321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,
     331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,    -1,
     361,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,
     381,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
     391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,
     401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,   419,   420,
      -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,
     451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,
     461,    -1,    -1,   464,   465,    -1,   467,   468,   469,   470,
     471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,
     481,   482,    -1,    -1,   485,   486,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,
      -1,   502,   503,   504,   505,    -1,   507,   508,    -1,   510,
     511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,
      -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,
      -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,
     541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,
     551,    -1,    -1,   554,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   572,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,    -1,   554,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   571,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,    -1,   554,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   571,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,    -1,   554,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,   571,    22,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    51,    -1,    53,    -1,    55,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    -1,
      70,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,    -1,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,
      -1,    -1,   192,    -1,    -1,    -1,   196,   197,   198,   199,
     200,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,   222,    -1,    -1,   225,    -1,    -1,    -1,   229,
      -1,    -1,   232,   233,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
      -1,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,   356,   357,    -1,    -1,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,   395,   396,    -1,   398,    -1,
      -1,   401,    -1,    -1,   404,   405,   406,    -1,    -1,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,    -1,   419,
      -1,    -1,    -1,    -1,   424,   425,   426,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,   437,    -1,    -1,
     440,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
      -1,   461,    -1,    -1,    -1,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,    -1,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,
     520,    -1,    -1,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,   545,    -1,   547,    -1,    -1,
     550,    -1,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,   567,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,     5,   554,     7,     8,     9,    10,    11,   560,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
      -1,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,     5,
     554,     7,     8,     9,    10,    11,   560,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,     5,   554,     7,
       8,     9,    10,    11,   560,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,     5,   554,     7,     8,     9,
      10,    11,   560,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,   163,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,   189,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,   253,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,   317,   318,    -1,
     320,   321,    -1,    -1,   324,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,   446,   447,   448,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
     142,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,   237,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    89,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,     5,   554,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,   237,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,   189,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,   484,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,   237,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,   237,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,   484,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,   237,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,   484,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,     5,   554,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,   484,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    81,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
     152,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,   171,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
      -1,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,     5,   554,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,   364,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,     5,   554,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,   105,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,   150,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,   165,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,   185,   186,    -1,   188,    -1,    -1,   191,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   213,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,   228,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,   320,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,   334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,    -1,   361,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,   375,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,   391,
      -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,   401,
     402,    -1,   404,   405,    -1,    -1,    -1,   409,   410,   411,
     412,   413,   414,   415,   416,   417,    -1,   419,   420,    -1,
      -1,    -1,   424,   425,   426,   427,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,   436,   437,   438,    -1,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,   460,   461,
      -1,    -1,   464,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
     502,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,   513,   514,    -1,    -1,   517,    -1,    -1,   520,    -1,
     522,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,   548,    -1,   550,   551,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,   105,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,    -1,   160,   161,   162,    -1,
      -1,   165,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,   185,   186,    -1,   188,    -1,    -1,   191,   192,    -1,
      -1,    -1,   196,   197,   198,   199,    -1,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,   213,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,    -1,    -1,
      -1,   225,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,   320,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
     334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     344,   345,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,    -1,    -1,   361,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,   375,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,   391,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,   401,   402,    -1,
     404,   405,    -1,    -1,    -1,   409,   410,   411,   412,   413,
     414,   415,   416,   417,    -1,   419,   420,    -1,    -1,    -1,
     424,   425,   426,   427,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,    -1,   440,   441,   442,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,   460,   461,    -1,    -1,
     464,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
     484,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,   502,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,   513,
     514,    -1,    -1,   517,    -1,    -1,   520,    -1,   522,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,    -1,    -1,   547,   548,    -1,   550,   551,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    80,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,   105,
      -1,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,   150,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,    -1,   160,   161,   162,    -1,    -1,   165,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,   185,
     186,    -1,   188,    -1,    -1,   191,   192,    -1,    -1,    -1,
     196,   197,   198,   199,    -1,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,   213,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,    -1,    -1,    -1,   225,
      -1,    -1,   228,   229,    -1,    -1,   232,    -1,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,   320,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,   334,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,    -1,   361,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,   375,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,   391,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,   401,   402,    -1,   404,   405,
      -1,    -1,    -1,   409,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,   419,   420,    -1,    -1,    -1,   424,   425,
     426,   427,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,    -1,   440,   441,   442,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,   460,   461,    -1,    -1,   464,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,   502,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,   513,   514,    -1,
      -1,   517,    -1,    -1,   520,    -1,   522,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,    -1,
      -1,   547,   548,    -1,   550,   551,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    80,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   105,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,   150,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,    -1,   160,   161,   162,    -1,    -1,   165,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,   185,   186,    -1,
     188,    -1,    -1,   191,   192,    -1,    -1,    -1,   196,   197,
     198,   199,    -1,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,   213,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,    -1,    -1,    -1,   225,    -1,    -1,
     228,   229,    -1,    -1,   232,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,   320,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,   334,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,    -1,   361,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,   375,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,   391,    -1,   393,   394,   395,    -1,    -1,
     398,    -1,   400,   401,   402,    -1,   404,   405,    -1,    -1,
      -1,   409,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,   419,   420,    -1,    -1,    -1,   424,   425,   426,   427,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,
     438,    -1,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,   460,   461,    -1,    -1,   464,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,   502,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,   513,   514,    -1,    -1,   517,
      -1,    -1,   520,    -1,   522,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,    -1,    -1,   547,
     548,    -1,   550,   551,    -1,     5,   554,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      80,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
     150,    -1,    -1,   153,   154,   155,    -1,    -1,   158,    -1,
     160,   161,   162,    -1,    -1,   165,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,   185,   186,    -1,   188,    -1,
      -1,   191,   192,    -1,    -1,    -1,   196,   197,   198,   199,
      -1,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,   213,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,    -1,    -1,    -1,   225,    -1,    -1,   228,   229,
      -1,    -1,   232,    -1,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
     320,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,   334,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   344,   345,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
      -1,   361,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,   375,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,   391,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,   401,   402,    -1,   404,   405,    -1,    -1,    -1,   409,
     410,   411,   412,   413,   414,   415,   416,   417,    -1,   419,
     420,    -1,    -1,    -1,   424,   425,   426,   427,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,    -1,
     440,   441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
     460,   461,    -1,    -1,   464,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,   502,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,   513,   514,    -1,    -1,   517,    -1,    -1,
     520,    -1,   522,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,    -1,    -1,   547,   548,    -1,
     550,   551,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    51,
      -1,    53,    -1,    55,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    -1,    70,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
     132,   133,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,   159,   160,   161,
     162,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,
     192,    -1,    -1,    -1,   196,   197,   198,   199,   200,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
     222,    -1,    -1,   225,    -1,    -1,    -1,   229,    -1,    -1,
     232,   233,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,   255,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,    -1,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,   356,   357,    -1,    -1,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,   395,   396,    -1,   398,    -1,    -1,   401,
      -1,    -1,   404,   405,   406,    -1,    -1,    -1,   410,   411,
     412,   413,   414,   415,    -1,   417,    -1,   419,    -1,    -1,
      -1,    -1,   424,   425,   426,    -1,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,    -1,   437,    -1,    -1,   440,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,    -1,   461,
      -1,    -1,    -1,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
      -1,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,   520,    -1,
      -1,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,   545,    -1,   547,    -1,    -1,   550,    -1,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    51,    -1,    53,
      -1,    55,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    -1,    70,    -1,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,   132,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,   159,   160,   161,   162,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,   196,   197,   198,   199,   200,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,   222,    -1,
      -1,   225,    -1,    -1,    -1,   229,    -1,    -1,   232,   233,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,   255,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,    -1,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   345,    -1,    -1,   348,   349,   350,    -1,   352,   353,
     354,   355,   356,   357,    -1,    -1,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,   395,   396,    -1,   398,    -1,    -1,   401,    -1,    -1,
     404,   405,   406,    -1,    -1,    -1,   410,   411,   412,   413,
     414,   415,    -1,   417,    -1,   419,    -1,    -1,    -1,    -1,
     424,   425,   426,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,    -1,   437,    -1,    -1,   440,    -1,    -1,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,    -1,   461,    -1,    -1,
      -1,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
      -1,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,    -1,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,    -1,
      -1,    -1,    -1,   517,    -1,    -1,   520,    -1,    -1,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,   543,
      -1,   545,    -1,   547,    -1,    -1,   550,    -1,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    51,    -1,    53,    -1,    55,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    -1,    70,    -1,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    -1,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,    -1,
      -1,    -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,   132,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,   159,   160,   161,   162,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,    -1,
     186,    -1,    -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,
     196,   197,   198,   199,   200,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,   222,    -1,    -1,   225,
      -1,    -1,    -1,   229,    -1,    -1,   232,   233,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,   255,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,    -1,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
     356,   357,    -1,    -1,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,   395,
     396,    -1,   398,    -1,    -1,   401,    -1,    -1,   404,   405,
     406,    -1,    -1,    -1,   410,   411,   412,   413,   414,   415,
      -1,   417,    -1,   419,    -1,    -1,    -1,    -1,   424,   425,
     426,    -1,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
      -1,   437,    -1,    -1,   440,    -1,    -1,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,    -1,   461,    -1,    -1,    -1,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,    -1,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,    -1,    -1,    -1,
      -1,   517,    -1,    -1,   520,    -1,    -1,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,   543,    -1,   545,
      -1,   547,    -1,    -1,   550,    -1,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    -1,    -1,
      -1,    -1,    50,    51,    -1,    53,    -1,    55,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    -1,    70,    -1,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,   159,   160,   161,   162,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,    -1,   186,    -1,
      -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,   196,   197,
     198,   199,   200,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,   222,    -1,    -1,   225,    -1,    -1,
      -1,   229,    -1,    -1,   232,   233,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,   255,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,    -1,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
      -1,    -1,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,   395,   396,    -1,
     398,    -1,    -1,   401,    -1,    -1,   404,   405,   406,    -1,
      -1,    -1,   410,   411,   412,   413,   414,   415,    -1,   417,
      -1,   419,    -1,    -1,    -1,    -1,   424,   425,   426,    -1,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,    -1,   437,
      -1,    -1,   440,    -1,    -1,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,    -1,   461,    -1,    -1,    -1,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,    -1,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,    -1,    -1,    -1,    -1,   517,
      -1,    -1,   520,    -1,    -1,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,   545,    -1,   547,
      -1,    -1,   550,    -1,    -1,     5,   554,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    51,    -1,    53,    -1,    55,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    -1,
      70,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,   136,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,    -1,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,
      -1,    -1,   192,    -1,    -1,    -1,   196,   197,   198,   199,
     200,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,   222,    -1,    -1,   225,    -1,    -1,    -1,   229,
      -1,    -1,   232,   233,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
      -1,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,   356,   357,    -1,    -1,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,   395,   396,    -1,   398,    -1,
      -1,   401,    -1,    -1,   404,   405,   406,    -1,    -1,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,    -1,   419,
      -1,    -1,    -1,    -1,   424,   425,   426,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,   437,    -1,    -1,
     440,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
      -1,   461,    -1,    -1,    -1,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,    -1,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,
     520,    -1,    -1,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,   545,    -1,   547,    -1,    -1,
     550,    -1,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    51,
      -1,    53,    -1,    55,    -1,    -1,    -1,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    -1,    -1,    70,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,   136,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,   159,   160,   161,
     162,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,
     192,    -1,    -1,    -1,   196,   197,   198,   199,   200,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
     222,    -1,    -1,   225,    -1,    -1,    -1,   229,    -1,    -1,
     232,   233,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,   255,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,    -1,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,   356,   357,    -1,    -1,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,   395,   396,    -1,   398,    -1,    -1,   401,
      -1,    -1,   404,   405,   406,    -1,    -1,    -1,   410,   411,
     412,   413,   414,   415,    -1,   417,    -1,   419,    -1,    -1,
      -1,    -1,   424,   425,   426,    -1,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,    -1,   437,    -1,    -1,   440,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,    -1,   461,
      -1,    -1,    -1,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
      -1,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,   520,    -1,
      -1,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,   545,    -1,   547,    -1,    -1,   550,    -1,
      -1,     5,   554,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    -1,
      44,    -1,    -1,    -1,    -1,    -1,    50,    51,    -1,    53,
      -1,    55,    -1,    -1,    -1,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    -1,    -1,    70,    -1,    72,    73,
      74,    75,    -1,    -1,    78,    -1,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    96,    -1,    -1,    99,    -1,    -1,    -1,    -1,
     104,    -1,    -1,    -1,    -1,    -1,   110,    -1,   112,    -1,
      -1,    -1,   116,    -1,   118,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,   136,   137,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,    -1,    -1,   153,
     154,   155,    -1,    -1,   158,   159,   160,   161,   162,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,   172,    -1,
     174,    -1,   176,   177,   178,   179,    -1,   181,    -1,    -1,
      -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,   196,   197,   198,   199,   200,    -1,   202,   203,
      -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,   217,    -1,    -1,   220,   221,   222,    -1,
      -1,   225,    -1,    -1,    -1,   229,    -1,    -1,   232,   233,
      -1,   235,   236,    -1,    -1,    -1,    -1,    -1,   242,   243,
      -1,   245,    -1,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,   255,    -1,    -1,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,    -1,   279,   280,   281,    -1,    -1,
      -1,   285,   286,   287,   288,   289,    -1,    -1,   292,   293,
      -1,   295,    -1,   297,    -1,   299,   300,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,    -1,   313,
     314,   315,   316,    -1,    -1,    -1,    -1,   321,    -1,    -1,
      -1,    -1,   326,   327,   328,    -1,   330,   331,   332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   345,    -1,    -1,   348,   349,   350,    -1,   352,   353,
     354,   355,   356,   357,    -1,    -1,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
      -1,   395,   396,    -1,   398,    -1,    -1,   401,    -1,    -1,
     404,   405,   406,    -1,    -1,    -1,   410,   411,   412,   413,
     414,   415,    -1,   417,    -1,   419,    -1,    -1,    -1,    -1,
     424,   425,   426,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,    -1,   437,    -1,    -1,   440,    -1,    -1,   443,
      -1,    -1,    -1,    -1,    -1,    -1,   450,   451,    -1,   453,
      -1,    -1,   456,    -1,    -1,   459,    -1,   461,    -1,    -1,
      -1,   465,    -1,   467,   468,   469,   470,   471,    -1,    -1,
     474,   475,    -1,   477,   478,    -1,    -1,   481,   482,    -1,
      -1,   485,   486,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,    -1,    -1,   497,   498,    -1,    -1,    -1,    -1,   503,
     504,   505,    -1,   507,   508,    -1,   510,   511,    -1,    -1,
      -1,    -1,    -1,   517,    -1,    -1,   520,    -1,    -1,    -1,
     524,   525,    -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,
      -1,   535,    -1,    -1,    -1,   539,   540,   541,   542,    -1,
      -1,   545,    -1,   547,    -1,    -1,   550,    -1,    -1,     5,
     554,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    51,    -1,    53,    -1,    55,
      -1,    -1,    -1,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    -1,    -1,    70,    -1,    72,    73,    74,    75,
      -1,    -1,    78,    -1,    -1,    -1,    82,    -1,    -1,    -1,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    94,    95,
      96,    -1,    -1,    99,    -1,    -1,    -1,    -1,   104,    -1,
      -1,    -1,    -1,    -1,   110,    -1,   112,    -1,    -1,    -1,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
     136,   137,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,    -1,    -1,   153,   154,   155,
      -1,    -1,   158,   159,   160,   161,   162,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,   172,    -1,   174,    -1,
     176,   177,   178,   179,    -1,   181,    -1,    -1,    -1,    -1,
     186,    -1,    -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,
     196,   197,   198,   199,   200,    -1,   202,   203,    -1,    -1,
     206,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,    -1,
      -1,   217,    -1,    -1,   220,   221,   222,    -1,    -1,   225,
      -1,    -1,    -1,   229,    -1,    -1,   232,   233,    -1,   235,
     236,    -1,    -1,    -1,    -1,    -1,   242,   243,    -1,   245,
      -1,   247,    -1,   249,   250,    -1,    -1,    -1,    -1,   255,
      -1,    -1,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,    -1,   279,   280,   281,    -1,    -1,    -1,   285,
     286,   287,   288,   289,    -1,    -1,   292,   293,    -1,   295,
      -1,   297,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,    -1,   313,   314,   315,
     316,    -1,    -1,    -1,    -1,   321,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,   330,   331,   332,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
     356,   357,    -1,    -1,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,    -1,   395,
     396,    -1,   398,    -1,    -1,   401,    -1,    -1,   404,   405,
     406,    -1,    -1,    -1,   410,   411,   412,   413,   414,   415,
      -1,   417,    -1,   419,    -1,    -1,    -1,    -1,   424,   425,
     426,    -1,    -1,    -1,    -1,   431,    -1,    -1,    -1,   435,
      -1,   437,    -1,    -1,   440,    -1,    -1,   443,    -1,    -1,
      -1,    -1,    -1,    -1,   450,   451,    -1,   453,    -1,    -1,
     456,    -1,    -1,   459,    -1,   461,    -1,    -1,    -1,   465,
      -1,   467,   468,   469,   470,   471,    -1,    -1,   474,   475,
      -1,   477,   478,    -1,    -1,   481,   482,    -1,    -1,   485,
     486,    -1,   488,   489,   490,   491,    -1,    -1,    -1,    -1,
      -1,   497,   498,    -1,    -1,    -1,    -1,   503,   504,   505,
      -1,   507,   508,    -1,   510,   511,    -1,    -1,    -1,    -1,
      -1,   517,    -1,    -1,   520,    -1,    -1,    -1,   524,   525,
      -1,    -1,    -1,    -1,    -1,    -1,   532,    -1,    -1,   535,
      -1,    -1,    -1,   539,   540,   541,   542,    -1,    -1,   545,
      -1,   547,    -1,    -1,   550,    -1,    -1,     5,   554,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,    27,
      -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    -1,    44,    -1,    -1,    -1,
      -1,    -1,    50,    51,    -1,    53,    -1,    55,    -1,    -1,
      -1,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      -1,    -1,    70,    -1,    72,    73,    74,    75,    -1,    -1,
      78,    -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    94,    95,    96,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    -1,   110,    -1,   112,    -1,    -1,    -1,   116,    -1,
     118,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,   137,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,    -1,    -1,   153,   154,   155,    -1,    -1,
     158,   159,   160,   161,   162,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,   172,    -1,   174,    -1,   176,   177,
     178,   179,    -1,   181,    -1,    -1,    -1,    -1,   186,    -1,
      -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,   196,   197,
     198,   199,   200,    -1,   202,   203,    -1,    -1,   206,    -1,
     208,    -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,   217,
      -1,    -1,   220,   221,   222,    -1,    -1,   225,    -1,    -1,
      -1,   229,    -1,    -1,   232,   233,    -1,   235,   236,    -1,
      -1,    -1,    -1,    -1,   242,   243,    -1,   245,    -1,   247,
      -1,   249,   250,    -1,    -1,    -1,    -1,   255,    -1,    -1,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
      -1,   279,   280,   281,    -1,    -1,    -1,   285,   286,   287,
     288,   289,    -1,    -1,   292,   293,    -1,   295,    -1,   297,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,    -1,   313,   314,   315,   316,    -1,
      -1,    -1,    -1,   321,    -1,    -1,    -1,    -1,   326,   327,
     328,    -1,   330,   331,   332,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
      -1,    -1,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,   395,   396,    -1,
     398,    -1,    -1,   401,    -1,    -1,   404,   405,   406,    -1,
      -1,    -1,   410,   411,   412,   413,   414,   415,    -1,   417,
      -1,   419,    -1,    -1,    -1,    -1,   424,   425,   426,    -1,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,    -1,   437,
      -1,    -1,   440,    -1,    -1,   443,    -1,    -1,    -1,    -1,
      -1,    -1,   450,   451,    -1,   453,    -1,    -1,   456,    -1,
      -1,   459,    -1,   461,    -1,    -1,    -1,   465,    -1,   467,
     468,   469,   470,   471,    -1,    -1,   474,   475,    -1,   477,
     478,    -1,    -1,   481,   482,    -1,    -1,   485,   486,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,    -1,    -1,   497,
     498,    -1,    -1,    -1,    -1,   503,   504,   505,    -1,   507,
     508,    -1,   510,   511,    -1,    -1,    -1,    -1,    -1,   517,
      -1,    -1,   520,    -1,    -1,    -1,   524,   525,    -1,    -1,
      -1,    -1,    -1,    -1,   532,    -1,    -1,   535,    -1,    -1,
      -1,   539,   540,   541,   542,    -1,    -1,   545,    -1,   547,
      -1,    -1,   550,    -1,    -1,     5,   554,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    26,    27,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,
      50,    51,    -1,    53,    -1,    55,    -1,    -1,    -1,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    -1,    -1,
      70,    -1,    72,    73,    74,    75,    -1,    -1,    78,    -1,
      -1,    -1,    82,    -1,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    94,    95,    96,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
     110,    -1,   112,    -1,    -1,    -1,   116,    -1,   118,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,   137,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,    -1,    -1,   153,   154,   155,    -1,    -1,   158,   159,
     160,   161,   162,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,   172,    -1,   174,    -1,   176,   177,   178,   179,
      -1,   181,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,
      -1,    -1,   192,    -1,    -1,    -1,   196,   197,   198,   199,
     200,    -1,   202,   203,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,    -1,   217,    -1,    -1,
     220,   221,   222,    -1,    -1,   225,    -1,    -1,    -1,   229,
      -1,    -1,   232,   233,    -1,   235,   236,    -1,    -1,    -1,
      -1,    -1,   242,   243,    -1,   245,    -1,   247,    -1,   249,
     250,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,    -1,   279,
     280,   281,    -1,    -1,    -1,   285,   286,   287,   288,   289,
      -1,    -1,   292,   293,    -1,   295,    -1,   297,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,    -1,   313,   314,   315,   316,    -1,    -1,    -1,
      -1,   321,    -1,    -1,    -1,    -1,   326,   327,   328,    -1,
     330,   331,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,   356,   357,    -1,    -1,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,   395,   396,    -1,   398,    -1,
      -1,   401,    -1,    -1,   404,   405,   406,    -1,    -1,    -1,
     410,   411,   412,   413,   414,   415,    -1,   417,    -1,   419,
      -1,    -1,    -1,    -1,   424,   425,   426,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,   437,    -1,    -1,
     440,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,
     450,   451,    -1,   453,    -1,    -1,   456,    -1,    -1,   459,
      -1,   461,    -1,    -1,    -1,   465,    -1,   467,   468,   469,
     470,   471,    -1,    -1,   474,   475,    -1,   477,   478,    -1,
      -1,   481,   482,    -1,    -1,   485,   486,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,    -1,    -1,   497,   498,    -1,
      -1,    -1,    -1,   503,   504,   505,    -1,   507,   508,    -1,
     510,   511,    -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,
     520,    -1,    -1,    -1,   524,   525,    -1,    -1,    -1,    -1,
      -1,    -1,   532,    -1,    -1,   535,    -1,    -1,    -1,   539,
     540,   541,   542,    -1,    -1,   545,    -1,   547,    -1,    -1,
     550,    -1,    -1,     5,   554,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    -1,    -1,    -1,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    -1,    -1,    70,    -1,
      72,    73,    74,    75,    -1,    -1,    78,    -1,    -1,    -1,
      82,    -1,    -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    94,    95,    96,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,    -1,
     112,    -1,    -1,    -1,   116,    -1,   118,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,   137,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,    -1,
      -1,   153,   154,   155,    -1,    -1,   158,    -1,   160,   161,
     162,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
     172,    -1,   174,    -1,   176,   177,   178,   179,    -1,   181,
      -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,
     192,    -1,    -1,    -1,   196,   197,   198,   199,    -1,    -1,
     202,   203,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,    -1,    -1,   217,    -1,    -1,   220,   221,
      -1,    -1,    -1,   225,    -1,    -1,    -1,   229,    -1,    -1,
     232,    -1,    -1,   235,   236,    -1,    -1,    -1,    -1,    -1,
     242,   243,    -1,   245,    -1,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,    -1,   279,   280,   281,
      -1,    -1,    -1,   285,   286,   287,   288,   289,    -1,    -1,
     292,   293,    -1,   295,    -1,   297,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
      -1,   313,   314,   315,   316,    -1,    -1,    -1,    -1,   321,
      -1,    -1,    -1,    -1,   326,   327,   328,    -1,   330,   331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,   356,   357,    -1,    -1,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,   395,    -1,    -1,   398,    -1,    -1,   401,
      -1,    -1,   404,   405,    -1,    -1,    -1,    -1,   410,   411,
     412,   413,   414,   415,    -1,   417,    -1,   419,    -1,    -1,
      -1,    -1,   424,   425,   426,    -1,    -1,    -1,    -1,   431,
      -1,    -1,    -1,   435,    -1,   437,    -1,    -1,   440,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,   450,   451,
      -1,   453,    -1,    -1,   456,    -1,    -1,   459,    -1,   461,
      -1,    -1,    -1,   465,    -1,   467,   468,   469,   470,   471,
      -1,    -1,   474,   475,    -1,   477,   478,    -1,    -1,   481,
     482,    -1,    -1,   485,   486,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,    -1,    -1,   497,   498,    -1,    -1,    -1,
      -1,   503,   504,   505,    -1,   507,   508,    -1,   510,   511,
      -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,   520,    -1,
      -1,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
     532,    -1,    -1,   535,    -1,    -1,    -1,   539,   540,   541,
     542,    -1,    -1,    -1,    -1,   547,    -1,    -1,   550,    -1,
      -1,    -1,   554
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,    13,    14,    28,    30,    34,    47,    48,    54,    58,
      59,    71,    85,   105,   113,   114,   115,   125,   126,   138,
     150,   165,   180,   185,   188,   211,   213,   227,   244,   248,
     333,   351,   361,   369,   389,   392,   394,   397,   400,   402,
     407,   409,   416,   421,   429,   434,   438,   460,   464,   502,
     514,   518,   521,   526,   551,   565,   576,   577,   578,   579,
     580,   581,   583,   588,   590,   595,   629,   762,   901,   939,
     942,   950,   952,   954,   957,   962,   964,   965,   970,   973,
     980,   984,   992,   993,  1151,  1153,  1159,  1162,  1187,  1195,
    1206,  1208,  1223,  1226,  1229,  1235,  1239,  1243,  1245,  1246,
    1291,  1308,  1314,  1316,  1323,  1325,  1350,  1356,  1357,  1358,
    1359,  1397,  1405,  1406,    11,    92,   148,   174,   201,   249,
     366,   427,   478,   935,  1378,  1379,   245,   322,   972,   477,
     480,  1310,  1351,   484,  1282,   204,     5,     7,     8,     9,
      10,    11,    17,    20,    22,    23,    24,    25,    26,    27,
      28,    30,    34,    38,    41,    42,    44,    46,    47,    50,
      53,    55,    56,    58,    60,    61,    62,    63,    64,    66,
      67,    69,    70,    71,    72,    73,    74,    75,    78,    80,
      82,    87,    94,    95,    96,    99,   104,   105,   110,   112,
     116,   118,   119,   120,   121,   125,   128,   129,   130,   134,
     136,   137,   139,   140,   141,   144,   146,   147,   148,   149,
     150,   153,   154,   155,   158,   160,   161,   162,   165,   169,
     170,   172,   174,   176,   177,   178,   179,   181,   185,   186,
     188,   191,   192,   196,   197,   198,   199,   202,   203,   206,
     208,   212,   213,   217,   220,   221,   225,   228,   229,   232,
     235,   236,   242,   243,   245,   247,   249,   250,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   279,   280,   281,
     285,   286,   287,   288,   289,   292,   293,   295,   297,   299,
     300,   301,   302,   303,   304,   305,   306,   309,   310,   313,
     314,   315,   316,   320,   321,   326,   327,   328,   330,   331,
     332,   334,   344,   345,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   361,   362,   363,   365,
     367,   368,   370,   371,   372,   375,   379,   380,   381,   382,
     383,   386,   387,   388,   390,   391,   393,   394,   395,   398,
     400,   401,   402,   404,   405,   409,   410,   411,   412,   413,
     414,   415,   416,   417,   419,   420,   424,   425,   426,   427,
     431,   435,   436,   437,   438,   440,   441,   442,   443,   450,
     451,   453,   456,   459,   460,   461,   464,   465,   467,   468,
     469,   470,   471,   474,   475,   477,   478,   481,   482,   485,
     486,   488,   489,   490,   491,   497,   498,   502,   503,   504,
     505,   507,   508,   510,   511,   513,   514,   517,   520,   522,
     524,   525,   532,   535,   539,   540,   541,   542,   547,   548,
     550,   551,   554,   617,  1281,  1285,  1289,  1290,   271,  1310,
    1310,   547,  1352,    92,   173,   249,   427,   444,   478,   481,
     516,   524,   599,   600,   815,   816,   817,   888,  1196,  1152,
      92,   148,   174,   204,   249,   366,   427,   478,   481,   499,
     524,   539,  1158,  1285,   972,   616,   572,  1279,  1280,  1285,
     589,  1160,   355,    77,   371,  1244,    95,   204,   480,  1310,
     972,   763,  1285,  1240,   416,    92,   524,  1310,   972,  1163,
    1236,  1310,   616,  1352,  1285,   995,   997,   998,   335,  1293,
    1209,   460,   464,   438,   497,   438,   480,  1207,   355,  1315,
    1188,  1285,    30,    71,   136,   361,   380,   409,   460,  1399,
     421,   565,   994,     0,   138,   361,   154,   350,  1227,  1279,
    1285,   142,   911,  1285,   617,   617,   182,   617,   237,  1282,
    1285,  1287,   704,   705,   708,   735,  1285,   480,   110,  1375,
    1310,   953,  1352,   981,   982,  1279,   630,   572,   495,   955,
     966,    16,  1353,   200,   818,   182,  1287,   706,   735,   616,
     340,  1373,  1375,  1376,  1377,  1378,   480,   816,   204,   201,
     256,   372,  1204,  1205,  1065,  1066,   200,  1157,  1157,  1157,
    1285,   182,  1157,  1157,   735,  1157,   616,  1157,  1310,   584,
    1230,    12,    13,    85,   113,   126,   148,   150,   160,   180,
     204,   211,   248,   367,   384,   390,   398,   421,   434,   435,
     474,   499,   521,   523,  1326,  1328,  1330,  1331,  1285,   332,
      62,   376,   572,  1287,   111,   190,   256,  1165,  1285,     7,
      20,    27,    33,    35,    36,    37,    39,    51,    52,    56,
      57,    63,    66,    80,    83,    84,    88,    89,    91,    92,
      97,    98,    99,   104,   106,   109,   151,   156,   157,   163,
     176,   178,   183,   189,   196,   200,   211,   214,   234,   242,
     253,   273,   278,   288,   292,   294,   298,   299,   300,   301,
     302,   308,   317,   318,   319,   323,   324,   328,   346,   352,
     356,   357,   359,   370,   396,   397,   408,   414,   419,   462,
     463,   468,   472,   473,   476,   484,   488,   489,   490,   491,
     500,   501,   502,   506,   509,   524,   528,   529,   530,   531,
     536,   538,   542,   554,   558,   559,   564,   565,   568,   569,
     571,   572,  1013,  1016,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1032,  1035,  1036,  1037,  1038,  1039,
    1040,  1041,  1051,  1055,  1266,  1268,  1270,  1271,  1275,  1277,
    1281,  1283,  1285,  1247,   215,  1279,  1309,  1310,    45,   764,
     171,    33,   271,  1215,  1241,  1285,   975,   616,   974,  1310,
     111,   256,  1166,  1194,   271,   371,   438,  1237,  1238,   951,
      12,  1324,  1328,   495,  1353,   996,    12,   122,   190,   449,
     450,   451,   452,   453,   454,   466,  1002,  1003,  1004,  1292,
      23,    34,    56,    57,    66,    68,    82,    84,    85,    93,
     140,   144,   147,   172,   174,   179,   181,   203,   204,   208,
     224,   245,   271,   303,   313,   332,   354,   365,   366,   426,
     438,   465,   480,   541,   862,   887,  1210,  1215,  1216,  1218,
    1299,   944,   945,   944,   944,   546,   943,   944,  1156,  1279,
    1285,  1310,  1194,    35,   189,  1267,  1283,  1398,  1398,  1398,
    1398,  1398,   997,   994,   566,  1285,  1225,  1224,   287,   482,
     508,   903,   907,   905,   710,   736,  1285,   904,   334,     6,
      54,   126,   318,   375,   377,   737,  1279,   142,   455,  1380,
     963,  1155,  1156,   218,   567,   988,   989,   565,   631,  1285,
     591,  1155,  1155,    53,   320,   320,   389,  1354,   317,   318,
    1031,  1285,   709,   736,   167,     6,    89,  1287,  1288,  1341,
    1342,   397,    10,   148,   366,   499,   603,   829,  1374,  1380,
    1381,  1389,  1391,  1375,  1378,   818,  1285,   171,  1197,  1201,
    1202,  1285,  1204,  1013,  1067,   151,  1285,   617,   617,   329,
     736,   617,  1287,   746,  1216,   617,  1288,  1340,  1155,  1157,
     527,   585,   116,   192,   250,   271,   365,   371,   401,   438,
     461,   477,  1231,  1232,  1310,   365,  1329,   411,   411,   481,
     524,   539,   335,  1333,   477,  1335,    61,   438,  1332,    93,
     539,  1334,   329,   567,    18,   142,  1107,  1108,  1317,  1285,
     935,   442,   565,   565,   565,  1036,   565,   565,   565,  1013,
    1072,   565,   565,   565,   565,   565,   565,   565,   565,   565,
    1012,  1012,   565,  1012,   565,   565,   565,   509,   565,  1266,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
    1013,   565,   565,   565,  1068,  1069,  1070,   565,   565,   565,
     565,   565,   565,   565,   565,   565,  1019,   565,  1012,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,  1012,   565,  1266,   565,
     565,   565,  1266,   565,   565,    35,   189,   484,   565,  1012,
    1012,  1012,   565,   565,   565,   565,   565,  1036,  1036,  1036,
     421,   565,  1013,  1368,  1285,  1056,  1285,   552,  1014,  1017,
     142,   143,   175,   184,   219,   230,   257,   311,  1033,    31,
     218,   238,   385,   443,   556,  1031,   557,   432,   433,   558,
     559,   123,   298,   560,   561,   562,   563,  1036,   100,   101,
     102,   103,   104,   170,   193,   194,   195,   196,   288,   290,
     291,   292,   299,   370,   418,   419,   542,   553,   554,  1104,
    1105,    65,   339,  1283,   565,   572,    75,   171,   256,  1248,
    1253,    47,   171,  1279,  1311,  1312,   971,   240,   243,   373,
     767,   771,   571,   582,  1282,   250,   979,  1285,   976,  1288,
     977,   978,  1279,   958,   215,  1156,  1167,  1168,    47,   567,
    1155,  1329,   329,   416,  1355,  1354,   515,  1360,  1361,   560,
    1006,  1007,  1008,  1004,  1294,  1295,  1296,   147,   429,   238,
     544,  1222,   503,   565,    92,   148,   174,   366,   480,   539,
    1222,    12,   825,  1287,   239,  1126,  1128,   171,   218,  1217,
    1219,    64,   461,   168,   461,   461,   461,   271,   477,    64,
     461,   192,   461,   461,   503,  1126,  1222,  1219,   250,   139,
      67,   355,   368,   477,   498,   461,   535,   941,   388,   456,
     946,   947,   940,    78,   935,   567,   331,  1401,   475,  1402,
     223,   404,  1400,   566,  1361,  1363,  1364,  1365,   992,  1228,
    1267,  1285,   109,   812,   813,   814,   823,   824,   870,   329,
     611,   908,   624,     6,   711,   624,   565,    94,   732,   732,
     732,     4,   902,  1288,   420,   539,  1155,   495,   567,   109,
     983,  1285,   982,   204,   226,   885,   886,   990,   632,   633,
    1013,   258,   259,   260,   261,   262,   263,   265,   266,   267,
     268,   269,   270,   272,   386,   387,   592,   593,   594,   154,
     372,   956,    55,   154,   158,   168,   285,   372,   967,   968,
     969,    53,   389,   151,   598,   711,    95,   732,  1012,   571,
     198,   567,   818,  1008,  1008,  1008,   539,  1381,  1279,   889,
     890,  1201,  1279,  1285,   567,  1199,   572,  1203,   567,  1279,
     746,   321,   540,   747,   748,   140,   567,    49,   403,   936,
    1155,   571,   586,   587,    47,   546,   567,  1233,   477,   565,
    1343,  1343,  1343,  1343,   174,   366,   480,  1327,  1331,  1285,
     161,   314,  1285,  1318,  1319,  1167,  1282,  1013,  1013,    12,
     122,  1061,  1109,  1061,  1061,  1061,   543,  1074,  1013,  1013,
    1065,  1065,  1013,  1013,  1013,   122,  1061,  1109,   566,  1013,
     566,  1013,  1013,  1013,  1013,  1275,  1285,   565,  1368,  1104,
    1065,    96,    99,   488,   491,  1106,   122,  1058,  1013,  1013,
    1013,  1013,  1065,  1069,     9,  1071,  1275,   122,  1061,  1013,
    1013,   122,  1061,  1013,  1013,  1065,  1065,  1065,  1013,  1013,
    1013,  1013,  1065,  1023,  1013,  1013,  1013,  1013,  1013,  1013,
    1061,  1061,  1013,  1013,   122,  1061,  1013,  1013,  1105,  1105,
    1013,    43,   231,   496,  1013,  1013,   566,  1276,  1277,  1285,
    1061,  1061,  1013,  1013,  1371,  1371,   566,   567,   566,  1013,
     571,  1057,  1287,   572,  1016,  1015,  1018,  1022,   157,   323,
     501,   517,  1031,    12,    17,  1022,  1034,  1023,   565,  1036,
    1023,   238,  1024,    31,   218,   238,   385,  1025,  1026,  1026,
    1027,  1035,  1027,  1035,  1028,  1028,  1028,  1028,  1028,  1036,
     559,  1287,  1036,  1042,  1285,   271,   245,  1252,   985,   271,
    1108,   567,  1155,   770,   769,   350,   777,   186,   226,  1287,
      29,   495,  1242,   495,   567,   495,   567,   495,  1155,  1168,
    1164,  1238,   171,   567,   174,   366,  1327,  1285,    12,   122,
    1367,   567,   999,  1010,  1013,  1273,  1285,   567,   179,   245,
     330,   426,  1297,  1298,  1301,  1302,   218,  1220,  1282,  1013,
     560,   818,   617,   617,   617,  1279,  1279,  1212,  1211,   253,
     324,   506,  1129,  1130,  1268,  1222,  1285,   617,  1222,  1288,
     168,  1217,   617,  1222,  1217,  1279,  1219,  1217,  1217,  1222,
    1222,   520,   948,   567,   948,   440,   421,   565,   569,  1075,
    1076,  1077,  1078,  1087,  1088,  1096,  1267,   353,  1403,   338,
    1122,  1128,  1366,   814,    65,   862,    73,   417,   392,   909,
      69,    80,   228,   296,   320,   374,   455,   626,   628,   381,
     510,   733,   734,   728,   729,    92,   191,   344,   352,   358,
     441,   524,   601,   602,  1282,   720,   721,   712,   713,   720,
       6,    13,    14,    25,    26,    54,    58,    59,    63,    69,
      77,    83,    95,   112,   119,   120,   126,   134,   140,   166,
     202,   204,   212,   225,   276,   293,   297,   333,   338,   345,
     351,   352,   379,   391,   392,   393,   394,   413,   465,   478,
     504,   515,   760,   820,   822,   823,   824,   912,   917,   919,
     922,   928,   929,   930,  1118,   110,   217,  1279,   967,  1282,
    1156,   565,   566,   567,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   567,
     522,   968,   812,   724,   725,   548,   526,   707,  1287,    45,
    1342,   617,   617,   617,   174,  1279,   596,   504,   527,   893,
     329,  1200,  1198,   572,  1202,   171,   560,  1285,  1108,  1013,
    1154,   747,   142,   430,  1178,  1179,  1288,   936,  1287,   567,
     376,  1232,  1155,  1234,  1285,  1344,  1345,   560,  1279,  1285,
    1339,  1339,  1339,   142,   161,   175,   184,   229,   230,   257,
     314,   363,  1320,  1322,   544,  1110,  1161,   567,   566,  1061,
     566,  1062,   566,   566,   566,  1013,   132,   543,  1073,    18,
     566,   527,   566,   566,   566,   567,   527,   567,  1052,   566,
     560,   566,   567,   567,   566,   566,   566,   572,   566,   171,
     566,   567,  1054,   566,   567,   567,   567,   566,   566,   565,
     567,  1061,   566,   566,   566,  1061,   566,   567,   566,   566,
     566,   566,   566,   566,   566,   567,   566,   218,   566,   567,
     567,   567,   567,   566,   566,   566,   567,   171,   567,  1061,
     566,   566,   566,   567,   567,   567,   566,   171,  1013,   171,
    1013,   171,  1013,   171,   566,   567,   566,   566,   566,   566,
     567,   566,   995,  1370,  1368,  1065,   570,   179,   245,   426,
    1300,   430,  1285,   337,   340,  1029,    15,    16,  1030,   157,
     323,   501,   517,   565,    16,  1013,  1368,   146,  1114,  1023,
    1023,   565,  1036,  1023,  1104,  1104,  1013,  1046,  1047,  1048,
     565,   572,   205,   986,   987,  1279,   256,   376,   549,  1313,
    1312,   967,   565,   775,   775,   106,   163,   189,   253,   324,
     506,  1133,  1136,  1137,   765,   768,   565,  1013,  1282,  1285,
    1288,  1288,   978,  1279,   154,   372,   525,   959,   960,   961,
     421,   429,   531,   532,   565,   808,  1169,  1172,  1282,   180,
    1339,  1339,  1339,  1362,  1007,   171,   215,  1000,  1001,  1121,
    1122,  1147,  1009,   572,  1295,   109,   497,  1285,  1304,   304,
     352,   571,   862,  1303,  1282,   171,  1221,   566,  1285,   250,
     303,   461,  1214,  1214,   327,   567,   438,  1222,  1222,  1217,
    1279,  1222,  1222,   594,   949,   947,  1095,  1285,    86,   207,
     223,   234,   307,   408,   466,  1086,   429,   567,  1279,  1095,
     567,   168,  1404,    45,  1126,  1179,  1179,   318,   362,    22,
     149,   605,   495,   119,   134,   607,  1282,   455,   455,   455,
     455,   455,   420,  1282,  1282,   206,   730,   731,   738,   746,
     748,  1282,  1282,  1282,  1282,   106,   163,   189,   253,   324,
     506,  1132,  1282,  1282,   566,   567,    24,   277,   722,   723,
     738,   739,   740,   746,   748,   714,   715,   738,   739,   740,
      68,    79,   173,   351,   444,   834,   837,   838,   883,   885,
     934,   934,   351,  1179,  1179,   934,  1179,   351,   351,  1179,
    1179,   495,   118,  1179,   224,   478,   167,   351,   364,   885,
     934,   224,  1179,   478,   118,  1179,  1179,  1179,  1179,   934,
     351,    45,  1179,   761,  1179,   351,   349,    18,   142,   495,
     938,   351,   351,  1179,   121,   286,  1285,  1179,  1179,   820,
     567,   759,   760,   917,   565,   572,   833,   839,  1278,  1285,
     906,   364,  1102,  1285,  1013,  1132,  1282,  1282,   106,   163,
     253,   324,   506,  1134,  1282,  1132,  1282,  1282,  1282,  1282,
    1282,  1132,  1282,  1282,  1132,   593,    69,   315,   382,   511,
     726,   727,   738,   742,   743,   744,   745,   746,   748,  1287,
     249,   716,   717,   352,   484,   604,  1393,     8,    29,   702,
     617,  1382,   238,   565,   750,   819,   821,   822,    44,   186,
     415,   895,   895,  1279,   527,  1110,  1285,  1076,   572,  1203,
     825,   587,   248,   566,   567,   572,   572,   495,   495,   495,
    1321,  1111,  1127,  1128,  1169,   214,  1013,   566,  1013,   487,
    1013,  1013,   136,    33,    57,    96,    99,   107,   309,   436,
     491,   519,  1063,    33,   863,  1287,  1013,   863,  1063,  1065,
     566,  1035,  1035,  1285,  1013,  1013,  1065,  1013,  1013,  1013,
    1023,  1275,   566,   566,  1013,  1013,  1013,  1013,  1013,  1013,
    1065,   214,  1013,  1013,  1013,   566,  1013,  1013,  1013,  1013,
     171,  1013,   171,  1013,   171,  1013,  1013,  1013,  1372,   566,
     566,   572,   572,   572,  1287,  1013,  1016,  1019,  1368,  1022,
     566,   567,   566,  1036,    16,  1013,  1368,  1114,   566,  1008,
    1049,  1050,  1064,  1065,  1285,   484,  1284,   567,   988,   549,
     245,  1008,   471,   778,   775,   772,   773,   774,  1285,   495,
     960,   809,  1170,   565,  1175,  1180,  1175,   566,   808,  1171,
    1272,  1273,  1276,  1285,  1173,   335,   171,   171,   171,   993,
     127,  1076,  1148,   168,   248,  1005,  1147,  1127,  1001,    18,
    1011,  1282,  1285,   560,  1285,   572,   220,   572,  1178,   109,
     863,   864,  1178,   168,  1178,   571,  1287,    33,   109,   865,
     866,  1287,  1134,  1213,   144,   541,  1130,  1130,   546,  1110,
    1217,   567,  1090,  1095,  1075,   223,   223,   341,  1097,   223,
     234,   408,  1097,  1087,  1075,  1190,  1191,  1276,  1075,  1108,
    1092,  1093,  1132,   289,  1123,   109,   867,   869,  1287,   864,
     362,  1013,  1013,   329,   611,   617,    69,   612,    95,    95,
     110,   217,  1179,   567,   731,   602,  1179,  1179,   567,   723,
     567,   715,   898,  1278,   886,   972,   886,    59,   167,   364,
     516,   836,   884,   835,   836,   898,  1278,   972,  1134,  1132,
    1278,  1132,    12,   918,   926,   927,  1285,   972,  1282,  1282,
     862,  1179,  1132,   226,   926,   226,  1278,  1278,   825,  1179,
     161,   229,   320,   827,  1132,  1134,  1134,  1278,   972,  1119,
    1120,  1276,   109,  1132,   764,  1282,   972,  1279,   972,   972,
      72,    74,   109,   130,   162,   383,   826,   825,   565,     6,
     126,   930,   831,   832,   833,   834,  1285,     8,   161,   937,
     384,   835,   875,   840,   572,   565,  1383,   566,   567,  1179,
    1179,  1179,  1179,   567,   727,   334,   182,   155,   718,   719,
     738,   739,   740,   741,   744,   745,   746,   748,   484,   329,
     565,   113,   211,   521,   703,  1392,  1383,  1279,   238,   351,
     752,   759,   831,   759,   567,   821,   597,  1076,  1121,  1110,
    1108,  1345,   560,   560,  1341,  1341,  1341,   565,  1013,   329,
    1185,  1013,   566,  1013,   487,   565,   856,   856,   565,   851,
     852,   856,   216,   216,   566,   566,   566,   566,   566,  1053,
    1104,  1104,   566,   566,  1060,  1122,   567,   567,   566,   218,
    1043,  1044,   566,   566,   566,   566,   567,   566,   566,  1013,
     566,   168,   566,   566,   567,   566,   567,   567,   566,  1013,
     566,  1013,   566,  1013,   566,   566,   566,  1369,   572,   899,
     566,  1065,  1022,   566,   567,   566,  1013,   567,   566,  1249,
     987,   201,   991,   783,  1023,    45,   766,   566,   567,  1288,
    1002,  1176,  1177,  1276,  1181,   567,   565,  1172,   566,   566,
     567,   572,  1360,   171,  1341,  1341,  1341,  1110,  1110,   128,
     342,  1143,  1144,  1149,   521,   218,  1282,  1285,   572,  1285,
     236,  1285,    12,    33,   109,   329,  1013,  1307,    65,   868,
    1013,  1288,   328,   352,   484,  1306,  1300,  1178,  1126,   260,
    1222,   594,  1363,  1091,   234,   223,  1087,  1097,  1097,   223,
     329,   329,   527,   567,  1189,  1178,   166,   201,   526,  1098,
    1002,  1013,  1124,  1274,  1104,  1282,   125,   910,   197,   749,
    1133,   731,   749,   749,   723,   715,   920,  1013,   226,   226,
     886,   898,   890,   126,   429,   918,   931,   915,   567,  1133,
     864,  1282,   898,   936,  1282,   932,   918,   567,    19,   114,
    1125,   918,   923,   918,  1155,   566,   567,  1285,  1279,    32,
      33,    38,    40,    41,    42,    57,    96,    99,   107,   124,
     141,   162,   164,   176,   177,   216,   242,   251,   252,   254,
     282,   283,   284,   300,   301,   302,   306,   309,   325,   326,
     356,   357,   378,   425,   429,   439,   485,   488,   491,   492,
     493,   494,   533,   534,   554,   841,   844,   845,   846,   847,
     848,   849,   850,  1285,  1285,  1384,    18,  1285,  1282,  1133,
     749,   749,   727,   565,  1285,  1179,   567,   719,   417,  1394,
     329,   405,   565,   618,    18,  1279,   754,   566,   751,   821,
     565,  1110,   239,  1131,   399,  1346,  1346,  1346,   109,  1013,
    1183,  1184,   129,  1104,  1013,   324,    20,    33,    46,   513,
     862,   871,   324,   566,   566,   566,   423,  1059,  1013,  1013,
      41,   307,   566,   546,  1045,  1013,  1104,  1013,  1013,  1013,
    1013,   566,   566,   566,  1360,  1285,   566,  1065,  1009,  1050,
     201,   397,  1254,   232,  1009,   771,   565,   785,   774,  1006,
     567,  1178,  1182,  1183,  1180,  1174,  1172,  1272,  1285,  1341,
    1127,   182,  1115,  1284,  1284,   571,  1145,  1146,  1287,   431,
     560,   376,   395,   424,  1305,   869,  1178,   565,   565,  1304,
    1013,   142,   566,  1077,   341,  1075,  1087,   223,   223,  1075,
    1087,  1080,  1079,  1081,  1191,  1110,  1184,   885,  1099,  1099,
    1099,  1006,   567,  1125,   606,   613,   614,   350,   565,   921,
     898,   890,   565,   109,   109,   914,   839,   967,   927,   868,
     841,   913,  1120,   924,   926,   916,   566,   832,   876,   565,
     565,   856,   851,   360,   842,   851,   851,   871,    57,   533,
     845,   847,   871,   871,    57,   534,   534,   537,   851,   843,
     856,   856,   871,   565,   856,    25,    65,    69,   109,   323,
     329,   364,   425,   516,   858,   859,   860,   874,  1031,   537,
     565,   871,    33,   565,   872,   565,   565,   856,   565,   852,
     857,   572,   566,   567,  1385,  1386,   601,   749,   719,   605,
     209,   218,   343,   638,   639,   640,   641,  1008,   107,   216,
     378,   467,   830,   619,  1385,   566,   808,   819,   756,  1254,
     896,   897,  1285,  1130,    60,   221,   316,   457,   469,   550,
    1337,  1338,   546,  1347,  1347,  1347,   566,   567,  1186,   566,
     566,   872,    20,   513,   862,   873,   872,   863,   566,   567,
    1267,   566,   566,   567,   295,   228,   371,   566,   566,   566,
     566,   566,   566,  1372,   566,  1011,   215,   566,   186,   226,
     351,   786,   787,   810,  1177,  1184,   566,  1363,    45,   187,
    1112,  1150,  1287,   567,   295,    70,   507,   376,  1306,   484,
     484,  1178,  1282,  1108,   223,   329,  1083,  1087,  1087,   329,
    1085,  1013,  1013,   565,  1121,  1100,  1094,  1274,   459,   608,
      51,    62,   159,   200,   222,   233,   332,   406,   615,   658,
     660,   661,   662,   664,   665,   666,   667,   668,   669,   671,
     679,   680,   683,   694,  1281,  1286,  1290,  1133,   786,   565,
     565,   896,    99,   488,   491,   558,   559,  1269,  1270,   967,
     937,   858,   972,   925,   959,   273,   329,   565,   877,   879,
     880,   881,   324,   324,   436,   519,   555,   853,   854,   855,
     565,   853,   853,   871,   537,   853,   565,   871,   324,   853,
     867,  1282,   319,   861,  1269,   521,   109,   226,   860,   226,
     323,   324,   324,   324,   324,   853,   324,   853,  1285,  1285,
     546,  1388,   421,   565,  1387,   566,   610,   611,   566,   567,
     636,  1279,   442,   634,   635,   637,  1285,  1388,   566,   759,
      18,   811,   566,   567,  1125,   565,   484,   484,   484,    16,
    1336,   180,   274,   275,   279,   280,  1348,  1349,  1184,   226,
     863,   872,   324,  1013,   295,   153,  1250,   565,   776,   565,
     788,   566,   567,   828,  1001,  1127,  1116,  1274,  1113,  1121,
      67,  1255,  1146,   566,   566,  1307,    16,  1075,  1082,   527,
    1084,   527,  1103,  1285,  1131,   565,   828,  1125,  1013,   137,
     609,   681,   684,  1285,   171,   314,   672,   659,  1286,  1286,
    1285,   663,   578,    30,   255,   396,   545,   697,   574,   566,
     896,   896,   566,  1271,  1271,   933,   967,   215,   172,   348,
     437,   113,   521,   878,  1285,   881,   566,   566,   855,   900,
    1267,   900,   566,  1012,   319,   532,   566,   566,   566,   566,
      50,    59,   245,  1008,  1008,   607,  1395,   640,  1285,   168,
    1282,   566,   567,   636,   755,   753,   565,   808,   225,   546,
     891,   892,   893,   894,   897,   324,  1337,   335,  1132,  1132,
    1132,  1132,  1349,   521,   566,   566,   480,  1008,   779,   781,
     782,  1285,   792,  1285,   787,  1005,   546,   567,  1117,  1125,
    1013,  1127,   135,   145,   336,   483,  1256,  1257,   241,  1258,
     261,   329,  1013,   565,  1013,   565,   566,   567,  1101,  1102,
    1013,  1013,   543,   686,   690,   171,  1285,   674,   675,  1013,
     698,   643,   657,   658,   660,   662,   664,   666,   667,   668,
     669,   671,   679,   694,   643,   699,   695,   566,   566,   891,
     937,   565,    49,   320,   403,   429,   882,   882,   566,   567,
     566,   567,   566,  1012,   871,   872,   871,   872,    59,   335,
      59,   995,   994,   612,   625,   841,  1008,   620,   637,   841,
    1363,   756,   808,   757,  1179,   347,   894,  1125,   566,  1192,
    1193,  1276,  1279,   783,   470,   784,   566,   567,   789,    87,
     410,  1274,   366,  1138,    45,    45,   135,    45,  1257,   458,
     483,  1259,  1260,   142,  1089,  1103,  1103,  1285,   566,   682,
     691,   132,   690,   693,   215,   136,  1013,   644,   136,   657,
     573,   520,  1013,   697,   875,   891,   786,     5,   109,   323,
     879,  1285,   871,  1267,   871,   335,   335,   566,   125,   117,
     626,   627,  1031,  1396,   131,   405,   566,  1360,  1132,  1281,
     567,  1178,  1251,  1009,  1133,   780,   782,   531,   793,  1125,
    1285,  1267,  1267,    45,  1267,    45,    45,  1260,  1134,  1013,
     566,   566,   543,   685,   687,  1013,   643,   136,   670,   200,
     487,   108,   642,   645,   255,   573,   701,   125,   696,  1286,
     566,  1363,   613,   117,   657,   414,   621,   758,  1193,  1184,
    1255,   566,   784,   218,   235,   790,  1139,  1267,  1267,  1267,
      16,   570,   688,   687,   693,   692,    51,   673,  1285,   676,
      81,   152,   650,   655,  1285,   136,   657,   573,  1013,   700,
    1390,   841,  1363,  1258,   565,   486,    69,    95,   204,   276,
     293,   315,   478,   805,   806,   807,  1216,   565,   264,  1013,
     136,   487,   567,   643,   185,   567,   646,    76,    90,   573,
     136,   643,   657,   622,   201,  1261,   797,   798,   799,  1023,
     281,   565,   794,   795,   796,  1179,   118,   118,  1179,  1179,
    1179,  1179,   791,   807,   140,  1008,  1140,  1141,  1142,   142,
     689,    51,   643,  1285,   677,   168,  1285,   841,   168,   168,
     396,   136,   625,   324,   565,  1262,   566,   567,   281,   799,
    1282,  1179,  1179,   253,   324,   506,  1135,  1136,  1135,  1133,
    1287,   565,   800,  1179,  1013,   566,   567,  1132,   487,   132,
     133,   678,   647,   109,   656,   447,   652,  1132,   648,   649,
     545,   623,   241,   566,   571,  1263,  1264,  1276,   429,  1265,
     798,   566,   566,  1282,  1282,   471,   801,   802,   825,  1142,
     643,   643,   674,   446,   448,   651,   652,   654,  1031,  1285,
    1013,   532,   653,   578,   657,  1287,   566,   567,  1192,   803,
     566,   567,   567,   657,   169,  1283,  1264,   804,  1287,   802,
     654,   805
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1147 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1160 "sql_yacc.yy"
    {}
    break;

  case 57:
#line 1224 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1244 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 61:
#line 1258 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 62:
#line 1265 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 63:
#line 1274 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 64:
#line 1286 "sql_yacc.yy"
    {}
    break;

  case 69:
#line 1300 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              YYABORT;
        }
    break;

  case 70:
#line 1312 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           YYABORT;
         }
       }
    break;

  case 71:
#line 1320 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 72:
#line 1330 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 73:
#line 1336 "sql_yacc.yy"
    {}
    break;

  case 76:
#line 1345 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 77:
#line 1350 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 78:
#line 1355 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 79:
#line 1360 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 80:
#line 1365 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 81:
#line 1369 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 82:
#line 1374 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 83:
#line 1378 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 84:
#line 1382 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 85:
#line 1386 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 86:
#line 1390 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 88:
#line 1399 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 89:
#line 1403 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 90:
#line 1419 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 91:
#line 1423 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 92:
#line 1434 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 (using_update_log ?
						  TL_READ_NO_INSERT:
						  TL_READ)))
	    YYABORT;
	  lex->create_list.empty();
	  lex->key_list.empty();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	  lex->name.str= 0;
          lex->name.length= 0;
         lex->like_name= 0;
	}
    break;

  case 93:
#line 1457 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 94:
#line 1460 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table),
							NULL,
							TL_OPTION_UPDATING))
	      YYABORT;
	    lex->create_list.empty();
	    lex->key_list.empty();
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 95:
#line 1473 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    if ((yyvsp[-10].key_type) != Key::FULLTEXT && lex->key_create_info.parser_name.str)
	    {
	      yyerror(ER(ER_SYNTAX_ERROR));
	      YYABORT;
	    }
	    lex->key_list.push_back(new Key((yyvsp[-10].key_type), (yyvsp[-8].lex_str).str, &lex->key_create_info, 0,
					   lex->col_list));
	    lex->col_list.empty();
	  }
    break;

  case 96:
#line 1485 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 97:
#line 1490 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name= (yyvsp[-2].lex_str);
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 98:
#line 1497 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 99:
#line 1503 "sql_yacc.yy"
    {}
    break;

  case 100:
#line 1505 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 101:
#line 1509 "sql_yacc.yy"
    {
            Lex->alter_tablespace_info->ts_cmd_type= CREATE_LOGFILE_GROUP;
          }
    break;

  case 102:
#line 1513 "sql_yacc.yy"
    {
            Lex->alter_tablespace_info->ts_cmd_type= CREATE_TABLESPACE;
          }
    break;

  case 103:
#line 1517 "sql_yacc.yy"
    {
	    Lex->sql_command= SQLCOM_CREATE_SERVER;
          }
    break;

  case 104:
#line 1523 "sql_yacc.yy"
    {
          Lex->server_options.server_name= (yyvsp[-8].lex_str).str;
          Lex->server_options.server_name_length= (yyvsp[-8].lex_str).length;
          Lex->server_options.scheme= (yyvsp[-4].lex_str).str;
        }
    break;

  case 107:
#line 1537 "sql_yacc.yy"
    {
          Lex->server_options.username= (yyvsp[0].lex_str).str;
        }
    break;

  case 108:
#line 1542 "sql_yacc.yy"
    {
          Lex->server_options.host= (yyvsp[0].lex_str).str;
        }
    break;

  case 109:
#line 1547 "sql_yacc.yy"
    {
          Lex->server_options.db= (yyvsp[0].lex_str).str;
        }
    break;

  case 110:
#line 1552 "sql_yacc.yy"
    {
          Lex->server_options.owner= (yyvsp[0].lex_str).str;
        }
    break;

  case 111:
#line 1557 "sql_yacc.yy"
    {
          Lex->server_options.password= (yyvsp[0].lex_str).str;
        }
    break;

  case 112:
#line 1562 "sql_yacc.yy"
    {
          Lex->server_options.socket= (yyvsp[0].lex_str).str;
        }
    break;

  case 113:
#line 1567 "sql_yacc.yy"
    {
          Lex->server_options.port= (yyvsp[0].ulong_num);
        }
    break;

  case 114:
#line 1578 "sql_yacc.yy"
    {
            Lex->create_info.options= (yyvsp[-1].num);

            if (!(Lex->event_parse_data= Event_parse_data::new_instance(YYTHD)))
              YYABORT;
            Lex->event_parse_data->identifier= (yyvsp[0].spname);

            /*
              We have to turn of CLIENT_MULTI_QUERIES while parsing a
              stored procedure, otherwise yylex will chop it into pieces
              at each ';'.
            */
            (yyval.ulong_num)= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
            YYTHD->client_capabilities &= (~CLIENT_MULTI_QUERIES);

            Lex->sql_command= SQLCOM_CREATE_EVENT;
            /* We need that for disallowing subqueries */
          }
    break;

  case 115:
#line 1601 "sql_yacc.yy"
    {
            /*
              Restore flag if it was cleared above
              $1 - EVENT_SYM
              $2 - opt_if_not_exists
              $3 - sp_name
              $4 - the block above
            */
            YYTHD->client_capabilities |= (yyvsp[-8].ulong_num);

            /*
              sql_command is set here because some rules in ev_sql_stmt
              can overwrite it
            */
            Lex->sql_command= SQLCOM_CREATE_EVENT;
          }
    break;

  case 116:
#line 1620 "sql_yacc.yy"
    {
            Lex->event_parse_data->item_expression= (yyvsp[-1].item);
            Lex->event_parse_data->interval= (yyvsp[0].interval);
          }
    break;

  case 118:
#line 1627 "sql_yacc.yy"
    {
            Lex->event_parse_data->item_execute_at= (yyvsp[0].item);
          }
    break;

  case 119:
#line 1632 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 120:
#line 1634 "sql_yacc.yy"
    {
            Lex->event_parse_data->status= Event_parse_data::ENABLED;
            (yyval.num)= 1;
          }
    break;

  case 121:
#line 1639 "sql_yacc.yy"
    {
            Lex->event_parse_data->status= Event_parse_data::DISABLED;
            (yyval.num)= 1;
          }
    break;

  case 122:
#line 1646 "sql_yacc.yy"
    {
            Lex->event_parse_data->item_starts= new Item_func_now_local();
          }
    break;

  case 123:
#line 1650 "sql_yacc.yy"
    {
            Lex->event_parse_data->item_starts= (yyvsp[0].item);
          }
    break;

  case 125:
#line 1657 "sql_yacc.yy"
    {
            Lex->event_parse_data->item_ends= (yyvsp[0].item);
          }
    break;

  case 126:
#line 1662 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 128:
#line 1668 "sql_yacc.yy"
    {
            Lex->event_parse_data->on_completion=
                                  Event_parse_data::ON_COMPLETION_PRESERVE;
            (yyval.num)= 1;
          }
    break;

  case 129:
#line 1674 "sql_yacc.yy"
    {
            Lex->event_parse_data->on_completion=
                                  Event_parse_data::ON_COMPLETION_DROP;
            (yyval.num)= 1;
          }
    break;

  case 130:
#line 1681 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 131:
#line 1683 "sql_yacc.yy"
    {
            Lex->comment= Lex->event_parse_data->comment= (yyvsp[0].lex_str);
            (yyval.num)= 1;
          }
    break;

  case 132:
#line 1690 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            /*
              This stops the following :
              - CREATE EVENT ... DO CREATE EVENT ...;
              - ALTER  EVENT ... DO CREATE EVENT ...;
              - CREATE EVENT ... DO ALTER EVENT DO ....;
              - CREATE PROCEDURE ... BEGIN CREATE EVENT ... END|
              This allows:
              - CREATE EVENT ... DO DROP EVENT yyy;
              - CREATE EVENT ... DO ALTER EVENT yyy;
                (the nested ALTER EVENT can have anything but DO clause)
              - ALTER  EVENT ... DO ALTER EVENT yyy;
                (the nested ALTER EVENT can have anything but DO clause)
              - ALTER  EVENT ... DO DROP EVENT yyy;
              - CREATE PROCEDURE ... BEGIN ALTER EVENT ... END|
                (the nested ALTER EVENT can have anything but DO clause)
              - CREATE PROCEDURE ... BEGIN DROP EVENT ... END|
            */
            if (lex->sphead)
            {
              my_error(ER_EVENT_RECURSIVITY_FORBIDDEN, MYF(0));
              YYABORT;
            }
              
            if (!(lex->sphead= new sp_head()))
              YYABORT;

            lex->sphead->reset_thd_mem_root(YYTHD);
            lex->sphead->init(lex);
            lex->sphead->init_sp_name(YYTHD, Lex->event_parse_data->identifier);

            lex->sphead->m_type= TYPE_ENUM_PROCEDURE;

            bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
            lex->sphead->m_chistics= &lex->sp_chistics;

            lex->sphead->m_body_begin= lex->ptr;
            
            Lex->event_parse_data->body_begin= lex->ptr;

          }
    break;

  case 133:
#line 1734 "sql_yacc.yy"
    {
            LEX *lex=Lex;

            /* return back to the original memory root ASAP */
            lex->sphead->init_strings(YYTHD, lex);
            lex->sphead->restore_thd_mem_root(YYTHD);

            lex->sp_chistics.suid= SP_IS_SUID;  //always the definer!

            Lex->event_parse_data->init_body(YYTHD);
          }
    break;

  case 145:
#line 1764 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 146:
#line 1779 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name(&(yyvsp[-2].lex_str)))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str));
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 147:
#line 1794 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str));
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 148:
#line 1812 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                DEFINER is a concept meaningful when interpreting SQL code.
                UDF functions are compiled.
                Using DEFINER with UDF has therefore no semantic,
                and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              YYABORT;
            }
            if (is_native_function(thd, & lex->spname->m_name))
            {
              my_error(ER_NATIVE_FCT_NAME_COLLISION, MYF(0),
                       lex->spname->m_name.str);
              YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 149:
#line 1838 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(YYTHD);
	    sp->init(lex);
            sp->init_sp_name(YYTHD, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	      We have to turn off CLIENT_MULTI_QUERIES while parsing a
	      stored procedure, otherwise yylex will chop it into pieces
	      at each ';'.
	    */
            (yyval.ulong_num)= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
	    YYTHD->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lex->tok_start+1;
	  }
    break;

  case 150:
#line 1875 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_param_end= lex->tok_start;
	  }
    break;

  case 151:
#line 1881 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 152:
#line 1889 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
            /*
              This was disabled in 5.1.12. See bug #20701
              When collation support in SP is implemented, then this test
              should be removed.
            */
            if (((yyvsp[0].num) == MYSQL_TYPE_STRING || (yyvsp[0].num) == MYSQL_TYPE_VARCHAR)
                && (lex->type & BINCMP_FLAG))
            {
              my_error(ER_NOT_SUPPORTED_YET, MYF(0), "return value collation");
              YYABORT;
            }

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 153:
#line 1912 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lex->tok_start;
	  }
    break;

  case 154:
#line 1919 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(thd, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              YYABORT;
            }
            if (is_native_function(thd, & sp->m_name))
            {
              /*
                This warning will be printed when
                [1] A client query is parsed,
                [2] A stored function is loaded by db_load_routine.
                Printing the warning for [2] is intentional, to cover the
                following scenario:
                - A user define a SF 'foo' using MySQL 5.N
                - An application uses select foo(), and works.
                - MySQL 5.{N+1} defines a new native function 'foo', as
                part of a new feature.
                - MySQL 5.{N+1} documentation is updated, and should mention
                that there is a potential incompatible change in case of
                existing stored function named 'foo'.
                - The user deploys 5.{N+1}. At this point, 'select foo()'
                means something different, and the user code is most likely
                broken (it's only safe if the code is 'select db.foo()').
                With a warning printed when the SF is loaded (which has to occur
                before the call), the warning will provide a hint explaining
                the root cause of a later failure of 'select foo()'.
                With no warning printed, the user code will fail with no
                apparent reason.
                Printing a warning each time db_load_routine is executed for
                an ambiguous function is annoying, since that can happen a lot,
                but in practice should not happen unless there *are* name
                collisions.
                If a collision exists, it should not be silenced but fixed.
              */
              push_warning_printf(thd,
                                  MYSQL_ERROR::WARN_LEVEL_NOTE,
                                  ER_NATIVE_FCT_NAME_COLLISION,
                                  ER(ER_NATIVE_FCT_NAME_COLLISION),
                                  sp->m_name.str);
            }
	    /* Restore flag if it was cleared above */
	    thd->client_capabilities |= (yyvsp[-10].ulong_num);
	    sp->restore_thd_mem_root(thd);
	  }
    break;

  case 155:
#line 1976 "sql_yacc.yy"
    {}
    break;

  case 156:
#line 1977 "sql_yacc.yy"
    {}
    break;

  case 157:
#line 1981 "sql_yacc.yy"
    {}
    break;

  case 158:
#line 1982 "sql_yacc.yy"
    {}
    break;

  case 159:
#line 1988 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 160:
#line 1990 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 161:
#line 1992 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 162:
#line 1994 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 163:
#line 1996 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 164:
#line 1998 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 165:
#line 2000 "sql_yacc.yy"
    { }
    break;

  case 166:
#line 2005 "sql_yacc.yy"
    { }
    break;

  case 167:
#line 2006 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 168:
#line 2007 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 169:
#line 2012 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 170:
#line 2016 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 171:
#line 2023 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 172:
#line 2031 "sql_yacc.yy"
    {}
    break;

  case 177:
#line 2047 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 178:
#line 2051 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 183:
#line 2069 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 184:
#line 2089 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 189:
#line 2126 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 190:
#line 2151 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 191:
#line 2152 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 192:
#line 2153 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 193:
#line 2154 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 194:
#line 2158 "sql_yacc.yy"
    {}
    break;

  case 196:
#line 2163 "sql_yacc.yy"
    {}
    break;

  case 198:
#line 2169 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 199:
#line 2173 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 200:
#line 2199 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 201:
#line 2207 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 202:
#line 2255 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 203:
#line 2269 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	    sp->m_flags|= sp_head::IN_HANDLER;
	  }
    break;

  case 204:
#line 2282 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);
	    sp->m_flags&= ~sp_head::IN_HANDLER;
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    ctx->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 205:
#line 2309 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 206:
#line 2332 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /*
	      We use statement here just be able to get a better
	      error message. Using 'select' works too, but will then
	      result in a generic "syntax error" if a non-select
	      statement is given.
	    */
	  }
    break;

  case 207:
#line 2343 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT &&
	       !(sql_command_flags[lex->sql_command] & CF_STATUS_COMMAND))
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 208:
#line 2366 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 209:
#line 2367 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 210:
#line 2373 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= 1;
	    }
	  }
    break;

  case 211:
#line 2394 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
	        (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= (yyvsp[-2].num) + 1;
	    }
	  }
    break;

  case 212:
#line 2418 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 213:
#line 2424 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 214:
#line 2438 "sql_yacc.yy"
    {}
    break;

  case 215:
#line 2439 "sql_yacc.yy"
    {}
    break;

  case 216:
#line 2444 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 217:
#line 2448 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	  }
    break;

  case 218:
#line 2457 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 219:
#line 2462 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 220:
#line 2467 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 221:
#line 2475 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 222:
#line 2490 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 223:
#line 2507 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 224:
#line 2508 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 236:
#line 2526 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 237:
#line 2528 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 238:
#line 2532 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->reset_lex(YYTHD);
	    lex->sphead->m_tmp_query= lex->tok_start;
	  }
    break;

  case 239:
#line 2539 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lex->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lex->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(YYTHD->mem_root,
                                           (char *)sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(YYTHD);
          }
    break;

  case 240:
#line 2581 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 241:
#line 2583 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 242:
#line 2606 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 243:
#line 2612 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 244:
#line 2621 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 245:
#line 2653 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 246:
#line 2684 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 247:
#line 2702 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 248:
#line 2717 "sql_yacc.yy"
    { }
    break;

  case 249:
#line 2722 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 253:
#line 2746 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 254:
#line 2767 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 255:
#line 2789 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 256:
#line 2791 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 257:
#line 2805 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 258:
#line 2816 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 264:
#line 2836 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 265:
#line 2842 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 266:
#line 2853 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 267:
#line 2861 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 268:
#line 2869 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 273:
#line 2887 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 274:
#line 2891 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 275:
#line 2900 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 276:
#line 2908 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 277:
#line 2912 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 278:
#line 2919 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 279:
#line 2927 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 281:
#line 2940 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 282:
#line 2958 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 283:
#line 2977 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 284:
#line 2978 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 285:
#line 2983 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context();
	  }
    break;

  case 286:
#line 2995 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 287:
#line 3011 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 288:
#line 3020 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 289:
#line 3022 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 290:
#line 3036 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 291:
#line 3046 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 292:
#line 3048 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 293:
#line 3064 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 294:
#line 3066 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 295:
#line 3071 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 296:
#line 3073 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 297:
#line 3075 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 301:
#line 3109 "sql_yacc.yy"
    {}
    break;

  case 302:
#line 3111 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->logfile_group_name= (yyvsp[0].lex_str).str;
          }
    break;

  case 303:
#line 3120 "sql_yacc.yy"
    { 
	    Lex->alter_tablespace_info->ts_alter_tablespace_type= ALTER_TABLESPACE_ADD_FILE; 
          }
    break;

  case 304:
#line 3127 "sql_yacc.yy"
    { 
	    Lex->alter_tablespace_info->ts_alter_tablespace_type= ALTER_TABLESPACE_DROP_FILE; 
          }
    break;

  case 309:
#line 3149 "sql_yacc.yy"
    {}
    break;

  case 317:
#line 3166 "sql_yacc.yy"
    {}
    break;

  case 330:
#line 3188 "sql_yacc.yy"
    {}
    break;

  case 340:
#line 3207 "sql_yacc.yy"
    {}
    break;

  case 352:
#line 3228 "sql_yacc.yy"
    {}
    break;

  case 360:
#line 3247 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->data_file_name= (yyvsp[0].lex_str).str;
          }
    break;

  case 361:
#line 3254 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->undo_file_name= (yyvsp[0].lex_str).str;
          }
    break;

  case 362:
#line 3261 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->redo_file_name= (yyvsp[0].lex_str).str;
          }
    break;

  case 363:
#line 3268 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info= new st_alter_tablespace();
            lex->alter_tablespace_info->tablespace_name= (yyvsp[0].lex_str).str;
            lex->sql_command= SQLCOM_ALTER_TABLESPACE;
          }
    break;

  case 364:
#line 3277 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info= new st_alter_tablespace();
            lex->alter_tablespace_info->logfile_group_name= (yyvsp[0].lex_str).str;
            lex->sql_command= SQLCOM_ALTER_TABLESPACE;
          }
    break;

  case 365:
#line 3286 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->ts_access_mode= TS_READ_ONLY;
          }
    break;

  case 366:
#line 3291 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->ts_access_mode= TS_READ_WRITE;
          }
    break;

  case 367:
#line 3296 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->ts_access_mode= TS_NOT_ACCESSIBLE;
          }
    break;

  case 368:
#line 3303 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->initial_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 369:
#line 3310 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->autoextend_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 370:
#line 3317 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->max_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 371:
#line 3324 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->extent_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 372:
#line 3331 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->undo_buffer_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 373:
#line 3338 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->redo_buffer_size= (yyvsp[0].ulonglong_number);
          }
    break;

  case 374:
#line 3345 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->alter_tablespace_info->nodegroup_id != UNDEF_NODEGROUP)
            {
              my_error(ER_FILEGROUP_OPTION_ONLY_ONCE,MYF(0),"NODEGROUP");
              YYABORT;
            }
            lex->alter_tablespace_info->nodegroup_id= (yyvsp[0].ulong_num);
          }
    break;

  case 375:
#line 3357 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->alter_tablespace_info->ts_comment != NULL)
            {
              my_error(ER_FILEGROUP_OPTION_ONLY_ONCE,MYF(0),"COMMENT");
              YYABORT;
            }
            lex->alter_tablespace_info->ts_comment= (yyvsp[0].lex_str).str;
          }
    break;

  case 376:
#line 3369 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (lex->alter_tablespace_info->storage_engine != NULL)
            {
              my_error(ER_FILEGROUP_OPTION_ONLY_ONCE,MYF(0),
                       "STORAGE ENGINE");
              YYABORT;
            }
            lex->alter_tablespace_info->storage_engine= (yyvsp[0].db_type);
          }
    break;

  case 379:
#line 3387 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->alter_tablespace_info->wait_until_completed= TRUE;
          }
    break;

  case 380:
#line 3392 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (!(lex->alter_tablespace_info->wait_until_completed))
            {
              my_error(ER_FILEGROUP_OPTION_ONLY_ONCE,MYF(0),"NO_WAIT");
              YYABORT;
            }
            lex->alter_tablespace_info->wait_until_completed= FALSE;
          }
    break;

  case 381:
#line 3403 "sql_yacc.yy"
    { (yyval.ulonglong_number)= (yyvsp[0].ulong_num);}
    break;

  case 382:
#line 3405 "sql_yacc.yy"
    {
            ulonglong number;
            uint text_shift_number= 0;
            longlong prefix_number;
            char *start_ptr= (yyvsp[0].lex_str).str;
            uint str_len= (yyvsp[0].lex_str).length;
            char *end_ptr= start_ptr + str_len;
            int error;
            prefix_number= my_strtoll10(start_ptr, &end_ptr, &error);
            if ((start_ptr + str_len - 1) == end_ptr)
            {
              switch (end_ptr[0])
              {
                case 'g':
                case 'G':
                  text_shift_number+=10;
                case 'm':
                case 'M':
                  text_shift_number+=10;
                case 'k':
                case 'K':
                  text_shift_number+=10;
                  break;
                default:
                {
                  my_error(ER_WRONG_SIZE_NUMBER, MYF(0));
                  YYABORT;
                }
              }
              if (prefix_number >> 31)
              {
                my_error(ER_SIZE_OVERFLOW_ERROR, MYF(0));
                YYABORT;
              }
              number= prefix_number << text_shift_number;
            }
            else
            {
              my_error(ER_WRONG_SIZE_NUMBER, MYF(0));
              YYABORT;
            }
            (yyval.ulonglong_number)= number;
          }
    break;

  case 383:
#line 3455 "sql_yacc.yy"
    {}
    break;

  case 384:
#line 3457 "sql_yacc.yy"
    {}
    break;

  case 385:
#line 3458 "sql_yacc.yy"
    {}
    break;

  case 386:
#line 3460 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->like_name= (yyvsp[0].table)))
              YYABORT;
            if ((yyvsp[0].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[0].table)->db.str), &((yyvsp[0].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 387:
#line 3472 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->like_name= (yyvsp[-1].table)))
              YYABORT;
            if ((yyvsp[-1].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[-1].table)->db.str), &((yyvsp[-1].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 388:
#line 3487 "sql_yacc.yy"
    {}
    break;

  case 389:
#line 3488 "sql_yacc.yy"
    {}
    break;

  case 390:
#line 3489 "sql_yacc.yy"
    {}
    break;

  case 391:
#line 3491 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 392:
#line 3491 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3495 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3497 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 395:
#line 3497 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3499 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 397:
#line 3499 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3527 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3533 "sql_yacc.yy"
    {
#ifdef WITH_PARTITION_STORAGE_ENGINE
          LEX *lex= Lex;
          lex->part_info= new partition_info();
          if (!lex->part_info)
          {
            mem_alloc_error(sizeof(partition_info));
            YYABORT;
          }
          if (lex->sql_command == SQLCOM_ALTER_TABLE)
          {
            lex->alter_info.flags|= ALTER_PARTITION;
          }
#else
          my_error(ER_FEATURE_DISABLED, MYF(0),
       	           "partitioning", "--with-partition");
          YYABORT;
#endif

        }
    break;

  case 402:
#line 3558 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          if (!lex->part_info)
          {
            yyerror(ER(ER_PARTITION_ENTRY_ERROR));
            YYABORT;
          }
          /*
            We enter here when opening the frm file to translate
            partition info string into part_info data structure.
          */
        }
    break;

  case 403:
#line 3570 "sql_yacc.yy"
    {}
    break;

  case 404:
#line 3574 "sql_yacc.yy"
    {}
    break;

  case 405:
#line 3574 "sql_yacc.yy"
    {}
    break;

  case 407:
#line 3579 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          lex->part_info->list_of_part_fields= TRUE;
          lex->part_info->part_type= HASH_PARTITION;
        }
    break;

  case 408:
#line 3585 "sql_yacc.yy"
    { Lex->part_info->part_type= HASH_PARTITION; }
    break;

  case 409:
#line 3586 "sql_yacc.yy"
    {}
    break;

  case 410:
#line 3588 "sql_yacc.yy"
    { Lex->part_info->part_type= RANGE_PARTITION; }
    break;

  case 411:
#line 3589 "sql_yacc.yy"
    {}
    break;

  case 412:
#line 3591 "sql_yacc.yy"
    { Lex->part_info->part_type= LIST_PARTITION; }
    break;

  case 413:
#line 3592 "sql_yacc.yy"
    {}
    break;

  case 414:
#line 3596 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3598 "sql_yacc.yy"
    { Lex->part_info->linear_hash_ind= TRUE;}
    break;

  case 416:
#line 3602 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3603 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3607 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3608 "sql_yacc.yy"
    {}
    break;

  case 420:
#line 3613 "sql_yacc.yy"
    {
          if (Lex->part_info->part_field_list.push_back((yyvsp[0].lex_str).str))
          {
            mem_alloc_error(1);
            YYABORT;
          }
        }
    break;

  case 421:
#line 3624 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          uint expr_len= (uint)((yyvsp[-1].simple_string) - (yyvsp[-3].simple_string)) - 1;
          lex->part_info->list_of_part_fields= FALSE;
          lex->part_info->part_expr= (yyvsp[-2].item);
          lex->part_info->part_func_string= (char* ) sql_memdup((yyvsp[-3].simple_string)+1, expr_len);
          lex->part_info->part_func_len= expr_len;
        }
    break;

  case 422:
#line 3636 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          uint expr_len= (uint)((yyvsp[-1].simple_string) - (yyvsp[-3].simple_string)) - 1;
          lex->part_info->list_of_subpart_fields= FALSE;
          lex->part_info->subpart_expr= (yyvsp[-2].item);
          lex->part_info->subpart_func_string= (char* ) sql_memdup((yyvsp[-3].simple_string)+1, expr_len);        
          lex->part_info->subpart_func_len= expr_len;
        }
    break;

  case 423:
#line 3648 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3650 "sql_yacc.yy"
    { 
          uint no_parts= (yyvsp[0].ulong_num);
          LEX *lex= Lex;
          if (no_parts == 0)
          {
            my_error(ER_NO_PARTS_ERROR, MYF(0), "partitions");
            YYABORT;
          }

          lex->part_info->no_parts= no_parts;
          lex->part_info->use_default_no_partitions= FALSE;
        }
    break;

  case 425:
#line 3665 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3667 "sql_yacc.yy"
    { Lex->part_info->subpart_type= HASH_PARTITION; }
    break;

  case 427:
#line 3668 "sql_yacc.yy"
    {}
    break;

  case 428:
#line 3671 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          lex->part_info->subpart_type= HASH_PARTITION;
          lex->part_info->list_of_subpart_fields= TRUE;
        }
    break;

  case 429:
#line 3676 "sql_yacc.yy"
    {}
    break;

  case 430:
#line 3680 "sql_yacc.yy"
    {}
    break;

  case 431:
#line 3681 "sql_yacc.yy"
    {}
    break;

  case 432:
#line 3686 "sql_yacc.yy"
    {
          if (Lex->part_info->subpart_field_list.push_back((yyvsp[0].lex_str).str))
          {
            mem_alloc_error(1);
            YYABORT;
          }
        }
    break;

  case 433:
#line 3697 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          bool not_corr_func;
          not_corr_func= !lex->safe_to_cache_query;
          lex->safe_to_cache_query= 1;
          if (not_corr_func)
          {
            yyerror(ER(ER_CONST_EXPR_IN_PARTITION_FUNC_ERROR));
            YYABORT;
          }
          (yyval.item)=(yyvsp[0].item);
        }
    break;

  case 434:
#line 3712 "sql_yacc.yy"
    {}
    break;

  case 435:
#line 3714 "sql_yacc.yy"
    {
          uint no_parts= (yyvsp[0].ulong_num);
          LEX *lex= Lex;
          if (no_parts == 0)
          {
            my_error(ER_NO_PARTS_ERROR, MYF(0), "subpartitions");
            YYABORT;
          }
          lex->part_i