/*
  +----------------------------------------------------------------------+
  | PHP Version 6                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2007 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Georg Richter <georg@mysql.com>                             |
  |          Andrey Hristov <andrey@mysql.com>                           |
  |          Ulf Wendel <uwendel@mysql.com>                              |
  +----------------------------------------------------------------------+

*/

/* Global types and definitions*/
#define MYSQL_NO_DATA			MYSQLND_NO_DATA
#define MYSQL_DATA_TRUNCATED	MYSQLND_DATA_TRUNCATED
#define MYSQL_STMT				MYSQLND_STMT
#define MYSQL_FIELD				MYSQLND_FIELD
#define MYSQL_RES				MYSQLND_RES
#define MYSQL_ROW				MYSQLND_ROW
#define MYSQL					MYSQLND
#define my_bool					zend_bool
#define my_ulonglong			mynd_ulonglong

#define MYSQL_VERSION_ID		MYSQLND_VERSION_ID
#define MYSQL_SERVER_VERSION	MYSQLND_VERSION
#define MYSQL_ERRMSG_SIZE		MYSQLND_ERRMSG_SIZE
#define SQLSTATE_LENGTH			MYSQLND_SQLSTATE_LENGTH

#define SERVER_QUERY_NO_GOOD_INDEX_USED	MYSQLND_SERVER_QUERY_NO_GOOD_INDEX_USED	
#define SERVER_QUERY_NO_INDEX_USED		MYSQLND_SERVER_QUERY_NO_INDEX_USED


/* functions */
#define mysql_affected_rows(r)			mysqlnd_affected_rows((r))
#define mysql_autocommit(r,m)			mysqlnd_autocommit((r),(m))
#define mysql_change_user(r,a,b,c)		mysqlnd_change_user((r), (a), (b), (c))
#define mysql_close(r)					mysqlnd_close((r), MYSQLND_CLOSE_EXPLICIT)
#define mysql_commit(r)					mysqlnd_commit((r))
#define mysql_data_seek(r,o)			mysqlnd_data_seek((r),(o))
#define mysql_dump_debug_info(r)		mysqlnd_dump_debug_info((r))
#define mysql_errno(r)					mysqlnd_errno((r))
#define mysql_error(r)					mysqlnd_error((r))
#define mysql_fetch_field(r)			mysqlnd_fetch_field((r))
#define mysql_fetch_field_direct(r,o)	mysqlnd_fetch_field_direct((r), (o))
#define mysql_fetch_lengths(r)			mysqlnd_fetch_lengths((r))
#define mysql_fetch_row(r)				mysqlnd_fetch_row((r))
#define mysql_field_count(r)			mysqlnd_field_count((r))
#define mysql_field_seek(r,o)			mysqlnd_field_seek((r), (o))
#define mysql_field_tell(r)				mysqlnd_field_tell((r))
#define mysql_init(a)					mysqlnd_init((a))
#define mysql_insert_id(r)				mysqlnd_insert_id((r))
#define mysql_kill(r,n)					mysqlnd_kill((r), (n))
#define mysql_more_results(r)			mysqlnd_more_results((r))
#define mysql_next_result(r)			mysqlnd_next_result((r))
#define mysql_num_fields(r)				mysqlnd_num_fields((r))
#define mysql_num_rows(r)				mysqlnd_num_rows((r))
#define mysql_ping(r)					mysqlnd_ping((r))
#define mysql_real_escape_string(r,a,b,c) mysqlnd_real_escape_string((r), (a), (b), (c))
#define mysql_real_query(r,a,b)			mysqlnd_query((r), (a), (b))
#define mysql_rollback(r)				mysqlnd_rollback((r))
#define mysql_select_db(r,a)			mysqlnd_select_db((r), (a) ,strlen((a)))
#define mysql_set_server_option(r,o)	mysqlnd_set_server_option((r), (o))
#define mysql_set_character_set(r,a)	mysqlnd_set_charset((r), (a))
#define mysql_sqlstate(r)				mysqlnd_sqlstate((r))
#define mysql_stmt_affected_rows(s)		mysqlnd_stmt_affected_rows((s))
#define mysql_stmt_field_count(s)		mysqlnd_stmt_field_count((s))
#define mysql_stmt_param_count(s)		mysqlnd_stmt_param_count((s))
#define mysql_stmt_num_rows(s)			mysqlnd_stmt_num_rows((s))
#define mysql_stmt_insert_id(s)			mysqlnd_stmt_insert_id((s))
#define mysql_stmt_close(s)				mysqlnd_stmt_close((s))
#define mysql_stmt_errno(s)				mysqlnd_stmt_errno((s))
#define mysql_stmt_error(s)				mysqlnd_stmt_error((s))
#define mysql_stmt_sqlstate(s)			mysqlnd_stmt_sqlstate((s))
#define mysql_stmt_prepare(s,q,l)		mysqlnd_stmt_prepare((s), (q), (l))
#define mysql_stmt_execute(s)			mysqlnd_stmt_execute((s))
#define mysql_stmt_reset(s)				mysqlnd_stmt_reset((s))
#define mysql_stmt_store_result(s)		mysqlnd_stmt_store_result((s))
#define mysql_stmt_free_result(s)		mysqlnd_stmt_free_result((s))
#define mysql_stmt_data_seek(s,r)		mysqlnd_stmt_data_seek((s), (r))
#define mysql_stmt_send_long_data(s,p,d,l) mysqlnd_stmt_send_long_data((s), (p), (d), (l))
#define mysql_stmt_attr_get(s,a,v)		mysqlnd_stmt_attr_get((s), (a), (v))
#define mysql_stmt_attr_set(s,a,v)		mysqlnd_stmt_attr_set((s), (a), (v))
#define mysql_stmt_param_metadata(s)	mysqlnd_stmt_param_metadata((s))
#define mysql_stmt_result_metadata(s)	mysqlnd_stmt_result_metadata((s))
#define mysql_thread_safe()				mysqlnd_thread_safe()
#define mysql_info(r)					mysqlnd_info((r))
#define mysql_options(r,a,b)			mysqlnd_options((r), (a), (b))
#define mysql_stmt_init(r)				mysqlnd_stmt_init((r))
#define mysql_free_result(r)			mysqlnd_free_result((r), FALSE)
#define mysql_store_result(r)			mysqlnd_store_result((r))
#define mysql_use_result(r)				mysqlnd_use_result((r))
#define mysql_thread_id(r)				mysqlnd_thread_id((r))
#define mysql_get_client_info()		MYSQLND_VERSION	
#define mysql_get_client_version()		MYSQLND_VERSION_ID
#define mysql_get_host_info(r)			mysqlnd_get_host_info((r))
#define mysql_get_proto_info(r)			mysqlnd_get_proto_info((r))
#define mysql_get_server_info(r)		mysqlnd_get_server_info((r))
#define mysql_get_server_version(r)		mysqlnd_get_server_version((r))
#define mysql_warning_count(r)			mysqlnd_warning_count((r))

/* Here comes non-libmysql API to have less ifdefs in mysqli*/
#define MYSQLI_CLOSE_EXPLICIT			MYSQLND_CLOSE_EXPLICIT
#define MYSQLI_CLOSE_IMPLICIT			MYSQLND_CLOSE_IMPLICIT
#define MYSQLI_CLOSE_DISCONNECTED		MYSQLND_CLOSE_DISCONNECTED

#define mysqli_result_is_unbuffered(r)	((r)->unbuf)
#define mysqli_server_status(c)			(c)->upsert_status.server_status
#define mysqli_stmt_warning_count(s)	mysqlnd_stmt_warning_count((s))
#define mysqli_stmt_server_status(s)	(s)->upsert_status.server_status
#define mysqli_stmt_get_connection(s)	(s)->conn
#define mysqli_close(c, how)			mysqlnd_close((c), (how))
#define mysqli_stmt_close(c, implicit)	mysqlnd_stmt_close((c), (implicit))
#define mysqli_free_result(r, implicit)	mysqlnd_free_result((r), (implicit))

