--TEST--
mysqli_query()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";

    $tmp    = NULL;   
    $link   = NULL;    

    if (!is_null($tmp = @mysqli_query()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    if (!is_null($tmp = @mysqli_query($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    require('table.inc');

    if (TRUE !== ($tmp = @mysqli_query($link, "set names utf8")))
        printf("[002.5] Expecting TRUE, got %s/%s\n", gettype($tmp), $tmp);

    if (NULL !== ($tmp = @mysqli_query($link, "SELECT 1 AS колона", MYSQLI_USE_RESULT, "foo")))
        printf("[003] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    if (false !== ($tmp = mysqli_query($link, 'това не е ескюел')))
        printf("[004] Expecting boolean/false, got %s/%s\n", gettype($tmp), $tmp);

    if (false !== ($tmp = mysqli_query($link, 'SELECT "това е ескюел, но със обратна наклонена и g"\g')))
        printf("[005] Expecting boolean/false, got %s/%s\n", gettype($tmp), $tmp);        

    if ((0 === mysqli_errno($link)) || ('' == mysqli_error($link)))
        printf("[006] mysqli_errno()/mysqli_error should return some error\n");

    if (!$res = mysqli_query($link, 'SELECT "това ескюел, но с точка и запетая" AS правилен ; '))
        printf("[007] [%d] %s\n", mysqli_errno($link), mysqli_error($link));

    var_dump(mysqli_fetch_assoc($res));    
    mysqli_free_result($res);

    if (false !== ($res = mysqli_query($link, 'SELECT "това ескюел, но с точка и запетая" AS правилен ; SHOW VARIABLES')))
        printf("[008] [%d] %s\n", mysqli_errno($link), mysqli_error($link));

    if (mysqli_get_server_version($link) > 50000) {
        // let's try to play with stored procedures
        mysqli_query($link, 'DROP PROCEDURE IF EXISTS процедурка');
        if (mysqli_query($link, 'CREATE PROCEDURE процедурка(OUT версия VARCHAR(25)) BEGIN SELECT VERSION() INTO версия; END;')) {
            $res = mysqli_query($link, 'CALL процедурка(@version)');    
            $res = mysqli_query($link, 'SELECT @version AS п_версия');

            $tmp = mysqli_fetch_assoc($res);
            if (!is_array($tmp) || empty($tmp) || !isset($tmp['п_версия']) || ('' == $tmp['п_версия'])) {
              printf("[008a] Expecting array [%d] %s\n", mysqli_errno($link), mysqli_error($link));
              var_dump($tmp);
            }

            mysqli_free_result($res);
        } else {
            printf("[009] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        }

        mysqli_query($link, 'DROP FUNCTION IF EXISTS функцийка');
        if (mysqli_query($link, 'CREATE FUNCTION функцийка( параметър_версия VARCHAR(25)) RETURNS VARCHAR(25) DETERMINISTIC RETURN параметър_версия;')) {
            $res = mysqli_query($link, 'SELECT функцийка(VERSION()) AS ф_версия'); 

            $tmp = mysqli_fetch_assoc($res);
            if (!is_array($tmp) || empty($tmp) || !isset($tmp['ф_версия']) || ('' == $tmp['ф_версия'])) {
              printf("[009a] Expecting array [%d] %s\n", mysqli_errno($link), mysqli_error($link));
              var_dump($tmp);
            }

            mysqli_free_result($res);
        } else {
            printf("[010] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        }
    }

    mysqli_close($link);

    if (NULL !== ($tmp = mysqli_query($link, "SELECT id FROM test")))
        printf("[011] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    print "done!";
?>
--EXPECTF--
array(1) {
  ["правилен"]=>
  string(59) "това ескюел, но с точка и запетая"
}

Warning: mysqli_query(): Couldn't fetch mysqli in %s on line %d
done! 
--UEXPECTF--
array(1) {
  [u"правилен"]=>
  unicode(33) "това ескюел, но с точка и запетая"
}

Warning: mysqli_query(): Couldn't fetch mysqli in %s on line %d
done! 
