--TEST--
mysqli_stmt_close()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
<?php die("skip: PS support not complete"); ?>
--FILE--
<?php
    include "connect.inc";

    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_stmt_close()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_stmt_close($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);         
        
    require('table.inc');    
    
    if (!$stmt = mysqli_stmt_init($link))
        printf("[003] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    
    // Yes, amazing, eh? AFAIK a work around of a constructor bug...
    if (!is_null($tmp = mysqli_stmt_close($stmt))) 
        printf("[004] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);   

    if (!mysqli_stmt_prepare($stmt, "SELECT id, label FROM test"))
        printf("[005] [%d] %s\n", mysqli_stmt_errno($stmt), mysqli_stmt_error($stmt));        
    
    if (true !== ($tmp = mysqli_stmt_close($stmt))) 
        printf("[006] Expecting boolean/true, got %s/%s\n", gettype($tmp), $tmp);
    
    if (!is_null($tmp = mysqli_stmt_close($stmt))) 
        printf("[007] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!$stmt = mysqli_stmt_init($link))
        printf("[008] [%d] %s\n", mysqli_errno($link), mysqli_error($link));        
        
    if (!mysqli_stmt_prepare($stmt, "SELECT id, label FROM test"))
        printf("[009] [%d] %s\n", mysqli_stmt_errno($stmt), mysqli_stmt_error($stmt));
        
    mysqli_kill($link, mysqli_thread_id($link));
        
    if (true !== ($tmp = mysqli_stmt_close($stmt))) 
        printf("[011] Expecting boolean/true, got %s/%s\n", gettype($tmp), $tmp);
    
    mysqli_close($link);   
        
    print "done!";
?>
--EXPECTF--
Warning: mysqli_stmt_close(): invalid object or resource mysqli_stmt
 in %s on line %d

Warning: mysqli_stmt_close(): Couldn't fetch mysqli_stmt in %s on line %d
done! 