--TEST--
mysqli_query()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_query()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_query($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    require('table.inc');
    
    if (NULL !== ($tmp = @mysqli_query($link, "SELECT 1 AS a", MYSQLI_USE_RESULT, "foo")))
        printf("[003] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
    
    if (false !== ($tmp = mysqli_query($link, 'THIS IS NOT SQL')))
        printf("[004] Expecting boolean/false, got %s/%s\n", gettype($tmp), $tmp);
        
    if (false !== ($tmp = mysqli_query($link, 'SELECT "this is sql but with backslash g"\g')))
        printf("[005] Expecting boolean/false, got %s/%s\n", gettype($tmp), $tmp);        
        
    if ((0 === mysqli_errno($link)) || ('' == mysqli_error($link)))
        printf("[006] mysqli_errno()/mysqli_error should return some error\n");
        
    if (!$res = mysqli_query($link, 'SELECT "this is sql but with semicolon" AS valid ; '))
        printf("[007] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    
    var_dump(mysqli_fetch_assoc($res));    
    mysqli_free_result($res);
        
    if (false !== ($res = mysqli_query($link, 'SELECT "this is sql but with semicolon" AS valid ; SHOW VARIABLES')))
        printf("[008] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    if (mysqli_get_server_version($link) > 50000) {
        // let's try to play with stored procedures
        mysqli_query($link, 'DROP PROCEDURE IF EXISTS p');
        if (mysqli_query($link, 'CREATE PROCEDURE p(OUT ver_param VARCHAR(25)) BEGIN SELECT VERSION() INTO ver_param; END;')) {
            $res = mysqli_query($link, 'CALL p(@version)');    
            $res = mysqli_query($link, 'SELECT @version AS p_version');
            var_dump(mysqli_fetch_assoc($res));            
            mysqli_free_result($res);
        } else {
            printf("[009] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        }
        
        mysqli_query($link, 'DROP FUNCTION IF EXISTS f');
        if (mysqli_query($link, 'CREATE FUNCTION f( ver_param VARCHAR(25)) RETURNS VARCHAR(25) DETERMINISTIC RETURN ver_param;')) {
            $res = mysqli_query($link, 'SELECT f(VERSION()) AS f_version');            
            var_dump(mysqli_fetch_assoc($res));
            mysqli_free_result($res);
        } else {
            printf("[010] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        }
    }
    
    mysqli_close($link);
    
    if (NULL !== ($tmp = mysqli_query($link, "SELECT id FROM test")))
        printf("[011] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
    
    print "done!";
?>
--EXPECTF--
array(1) {
  ["valid"]=>
  string(30) "this is sql but with semicolon"
}
array(1) {
  ["p_version"]=>
  string(%d) "%s"
}
array(1) {
  ["f_version"]=>
  string(%d) "%s"
}

Warning: mysqli_query(): Couldn't fetch mysqli in %s on line %d
done! 