--TEST--
Interface of the class mysqli
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    require('connect.inc');
    require('table.inc');
        
    $mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket);
    $mysqli_result = $mysqli->query('SELECT * FROM test');
    $row = $mysqli_result->fetch_row();
    
    $link = mysqli_connect($host, $user, $passwd, $db, $port, $socket);
    $res = mysqli_query($link, 'SELECT * FROM test');
    assert(mysqli_fetch_row($res) === $row);   
    
    printf("Parent class:\n");
    var_dump(get_parent_class($mysqli_result));

    printf("\nMethods:\n");
    $methods = get_class_methods($mysqli_result);
    sort($methods);
    foreach ($methods as $k => $method)
      printf("%s\n", $method);
    
    printf("\nClass variables:\n");    
    $variables = get_class_vars(get_class($mysqli_result));
    sort($variables);
    foreach ($variables as $k => $var)
      printf("%s\n", $var);
    
    printf("\nObject variables:\n");
    $variables = get_object_vars($mysqli_result);
    foreach ($variables as $k => $var)
      printf("%s\n", $var);
      
    printf("\nMagic, magic properties:\n");
    
    assert(mysqli_field_tell($res) === $mysqli_result->current_field);
    printf("mysqli_result->current_field = %s\n", $mysqli_result->current_field);
    
    assert(mysqli_field_count($link) === $mysqli_result->field_count);
    printf("mysqli_result->field_count = %s\n", $mysqli_result->field_count);
    
    assert(mysqli_fetch_lengths($res) === $mysqli_result->lengths);    
    printf("mysqli_result->lengths -> %s\n", (is_array($mysqli_result->lengths)) ? implode(' ', $mysqli_result->lengths) : 'n/a');
    
    assert(mysqli_num_rows($res) === $mysqli_result->num_rows);
    printf("mysqli_result->num_rows = %s\n", $mysqli_result->num_rows);
    
    assert(in_array($mysqli_result->type, array(MYSQLI_STORE_RESULT, MYSQLI_USE_RESULT)));
    printf("mysqli_result->type = %s\n", (MYSQLI_STORE_RESULT == $mysqli_result->type) ? 'store' : 'use');
    
    print "done!";
?>
--EXPECTF--
Parent class:
bool(false)

Methods:
__construct
close
data_seek
fetch_all
fetch_array
fetch_assoc
fetch_field
fetch_field_direct
fetch_fields
fetch_object
fetch_row
field_count
field_seek
free
free_result

Class variables:

Object variables:

Magic, magic properties:
mysqli_result->current_field = 0
mysqli_result->field_count = 2
mysqli_result->lengths -> 1 1
mysqli_result->num_rows = 6
mysqli_result->type = store
done!
