--TEST--
mysqli_cache_stats(), mysqli->cache_stats()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";   
    include "table.inc";
    
    if (!is_null($tmp = @mysqli_get_cache_stats($link)))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    if (!$res = mysqli_query($link, "SELECT id, label FROM test"))
        printf("[002] SELECT failed, [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    while ($row = mysqli_fetch_assoc($res)) 
        ;
        
    if (!$res = mysqli_query($link, "SELECT id, label FROM test"))
        printf("[003] SELECT failed, [%d] %s\n", mysqli_errno($link), mysqli_error($link));
        
    while ($result[] = mysqli_fetch_assoc($res)) 
        ;

    $stats = mysqli_get_cache_stats();
    if (empty($stats))
        printf("[004] Cache statistics should not be empty\n");
    
    mysqli_close($link);
   
    $new_stats = mysqli_get_cache_stats();
	/* references aren't identical */
	$stats["references"] = $new_stats["references"] = NULL;
    if ($new_stats !== $stats) {
        printf("[005] Cache statistics should be identical\n");
        var_dump($stats);
        var_dump($new_stats);        
    }
    /*
    if (!$mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket))
        printf("[006] Connect failed, [%d] %s\n", mysqli_connect_errno(), mysqli_connect_error());

    $new_stats = $mysql->get_cache_stats();
    if ($new_stats !== $stats) {
        printf("[007] Cache statistics should be identical\n");
        var_dump($stats);
        var_dump($new_stats);        
    }    
        
    if (!$res = $mysqli->query('SELECT id, label FROM test'))
        printf("[008] SELECT failed, [%d] %s\n", $mysqli->errno, $mysqli->error);
    
    while ($row = $res->fetch_row()) 
        ;
        
    
    $new_stats = $mysql->get_cache_stats();
    if ($new_stats !== $stats) {
        printf("[009] Cache statistics should not be identical\n");
        var_dump($stats);
        var_dump($new_stats);        
    }
    
    $mysqli->close();
    */
    print "done!\n";    
?>
--EXPECTF--
done!
