/* Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved.

   The MySQL Connector/ODBC is licensed under the terms of the GPLv2
   <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most
   MySQL Connectors. There are special exceptions to the terms and
   conditions of the GPLv2 as it is applied to this software, see the
   FLOSS License Exception
   <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation; version 2 of the License.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
   for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#include "MYODBCUtil.h"

#define MYODBCUTILWRITEDATASOURCESTR_DELIM  \
        if ( nIndex )                       \
        {                                   \
            if ( nIndex >= nMaxLen )        \
                return FALSE;               \
            pszStr[nIndex] = cDelim;        \
            nIndex++;                       \
        }

/*!
  \brief    Formulates a connection string reflecting any user modifications.

            The string can be used to pass back to SQLDriverConnect.
*/  
BOOL MYODBCUtilWriteDataSourceStr( MYODBCUTIL_DATASOURCE *pDataSource, MYODBCUTIL_DELIM nDelim, char *pszStr, SQLSMALLINT nMaxLen )
{
    int     nIndex      = 0;
    char    cDelim      = ';';

    if ( nMaxLen < 2 )
        return FALSE;

    switch ( nDelim )
    {
        case MYODBCUTIL_DELIM_NULL:
            cDelim = '\0';
            break;
        case MYODBCUTIL_DELIM_SEMI:
        case MYODBCUTIL_DELIM_BOTH:
            break;
    }

    pszStr[nIndex] = '\0';

    if ( pDataSource->pszDATABASE )
    {
        if ( !MYODBCUtilInsertStr( pszStr, "DATABASE=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszDATABASE, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszDESCRIPTION )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "DESCRIPTION=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszDESCRIPTION, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszDRIVER )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "DRIVER=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszDRIVER, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszDSN )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "DSN=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszDSN, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszOPTION )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "OPTION=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszOPTION, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->bINTERACTIVE )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "INTERACTIVE=1", nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszPASSWORD )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "PWD=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszPASSWORD, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszPORT )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "PORT=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszPORT, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSERVER )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SERVER=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSERVER, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSOCKET )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SOCKET=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSOCKET, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSTMT )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "STMT=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSTMT, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszUSER )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "UID=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszUSER, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLCA )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLCA=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLCA, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLCAPATH )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLCAPATH=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLCAPATH, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLCERT )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLCERT=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLCERT, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLCIPHER )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLCIPHER=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLCIPHER, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLKEY )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLKEY=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLKEY, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if ( pDataSource->pszSSLVERIFY )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;

        if ( !MYODBCUtilInsertStr( pszStr, "SSLVERIFY=", nMaxLen, &nIndex ) )
            return FALSE;
        if ( !MYODBCUtilInsertStr( pszStr, pDataSource->pszSSLVERIFY, nMaxLen, &nIndex ) )
            return FALSE;
    }

    if (pDataSource->pszCHARSET)
    {
      MYODBCUTILWRITEDATASOURCESTR_DELIM;

      if (!MYODBCUtilInsertStr(pszStr, "CHARSET=", nMaxLen, &nIndex))
        return FALSE;
      if (!MYODBCUtilInsertStr(pszStr, pDataSource->pszCHARSET, nMaxLen,
                               &nIndex))
        return FALSE;
    }

    if (pDataSource->pszREADTIMEOUT)
    {
      MYODBCUTILWRITEDATASOURCESTR_DELIM;

      if (!MYODBCUtilInsertStr(pszStr, "READTIMEOUT=", nMaxLen, &nIndex))
        return FALSE;
      if (!MYODBCUtilInsertStr(pszStr, pDataSource->pszREADTIMEOUT, nMaxLen,
                               &nIndex))
        return FALSE;
    }

    if (pDataSource->pszWRITETIMEOUT)
    {
      MYODBCUTILWRITEDATASOURCESTR_DELIM;

      if (!MYODBCUtilInsertStr(pszStr, "WRITETIMEOUT=", nMaxLen, &nIndex))
        return FALSE;
      if (!MYODBCUtilInsertStr(pszStr, pDataSource->pszWRITETIMEOUT, nMaxLen,
                               &nIndex))
        return FALSE;
    }

    if ( nDelim == MYODBCUTIL_DELIM_NULL )
    {
        MYODBCUTILWRITEDATASOURCESTR_DELIM;
        MYODBCUTILWRITEDATASOURCESTR_DELIM;
    }

    return TRUE;
}


/* It is a copy of previous function, but it does not write the string, but
   only calculates required space(w/out terminating Null) */
SQLSMALLINT MYODBCUtilWriteDataSourceStrLen( MYODBCUTIL_DATASOURCE *pDataSource, MYODBCUTIL_DELIM nDelim)
{
    int         nIndex= 0;
    SQLSMALLINT delim_len= 1, result= 0;

    if ( pDataSource->pszDATABASE )
    {
         result+= strlen("DATABASE=") + strlen(pDataSource->pszDATABASE) + delim_len;
    }

    if ( pDataSource->pszDESCRIPTION )
    {
        result+= strlen("DESCRIPTION=") + strlen(pDataSource->pszDESCRIPTION) + delim_len;
    }

    if ( pDataSource->pszDRIVER )
    {
        result+= strlen("DRIVER=");
        result+= strlen(pDataSource->pszDRIVER);
    }

    if ( pDataSource->pszDSN )
    {
        result+= strlen("DSN=") + strlen(pDataSource->pszDSN) + delim_len;
    }

    if ( pDataSource->pszOPTION )
    {
        result+= strlen("OPTION=");
        result+= strlen(pDataSource->pszOPTION) + delim_len;
    }

    if ( pDataSource->bINTERACTIVE )
    {
        result+= strlen("INTERACTIVE=1") + delim_len;
    }

    if ( pDataSource->pszPASSWORD )
    {
        result+= strlen("PWD=");
        result+= strlen(pDataSource->pszPASSWORD) + delim_len;
    }

    if ( pDataSource->pszPORT )
    {
        result+= strlen("PORT=");
        result+= strlen(pDataSource->pszPORT) + delim_len;
    }

    if ( pDataSource->pszSERVER )
    {
        result+= strlen("SERVER=");
        result+= strlen(pDataSource->pszSERVER) + delim_len;
    }

    if ( pDataSource->pszSOCKET )
    {
        result+= strlen("SOCKET=");
        result+= strlen(pDataSource->pszSOCKET) + delim_len;
    }

    if ( pDataSource->pszSTMT )
    {
        result+= strlen("STMT=");
        result+= strlen(pDataSource->pszSTMT) + delim_len;
    }

    if ( pDataSource->pszUSER )
    {
        result+= strlen("UID=");
        result+= strlen(pDataSource->pszUSER) + delim_len;
    }

    if ( pDataSource->pszSSLCA )
    {
        result+= strlen("SSLCA=");
        result+= strlen(pDataSource->pszSSLCA) + delim_len;
    }

    if ( pDataSource->pszSSLCAPATH )
    {
        result+= strlen("SSLCAPATH=");
        result+= strlen(pDataSource->pszSSLCAPATH) + delim_len;
    }

    if ( pDataSource->pszSSLCERT )
    {
        result+= strlen("SSLCERT=");
        result+= strlen(pDataSource->pszSSLCERT) + delim_len;
    }

    if ( pDataSource->pszSSLCIPHER )
    {
        result+= strlen("SSLCIPHER=");
        result+= strlen(pDataSource->pszSSLCIPHER) + delim_len;
    }

    if ( pDataSource->pszSSLKEY )
    {
        result+= strlen("SSLKEY=");
        result+= strlen(pDataSource->pszSSLKEY) + delim_len;
    }

    if ( pDataSource->pszSSLVERIFY )
    {
        result+= strlen("SSLVERIFY=");
        result+= strlen(pDataSource->pszSSLVERIFY) + delim_len;
    }

    if (pDataSource->pszCHARSET)
    {

      result+= strlen("CHARSET=");
        
      result+= strlen(pDataSource->pszCHARSET) + delim_len;
        
    }

    if (pDataSource->pszREADTIMEOUT)
    {

      result+= strlen("READTIMEOUT=");
        
      result+= strlen(pDataSource->pszREADTIMEOUT) + delim_len;
        
    }

    if (pDataSource->pszWRITETIMEOUT)
    {

      result+= strlen("WRITETIMEOUT=");
        
      result+= strlen(pDataSource->pszWRITETIMEOUT) + delim_len;
        
    }

    /* Deducting last delimeter*/
    if (result)
    {
      --result;
    }

    /* If NULL is a delimeter - adding 2 of them at the end*/
    if ( nDelim == MYODBCUTIL_DELIM_NULL )
    {
      result+= 2;
    }

    return result;
}
