/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;

public class PossibleMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    CompilationUnitDeclaration parsedUnit;
    public SearchDocument document;
    private String sourceFileName;
    private char[] source;

    public PossibleMatch(MatchLocator locator, IResource resource, Openable openable, SearchDocument document) {
        this.resource = resource;
        this.openable = openable;
        this.document = document;
        this.nodeSet = new MatchingNodeSet();
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public void cleanUp() {
        this.source = null;
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)obj).compoundName);
    }

    public char[] getContents() {
        if (this.source != null) {
            return this.source;
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return null;
            }
            SourceMapper sourceMapper = this.openable.getSourceMapper();
            IType type = ((ClassFile)this.openable).getType();
            this.source = sourceMapper.findSource(type, fileName);
            return this.source;
        }
        this.source = this.document.getCharContents();
        return this.source;
    }

    public char[] getFileName() {
        return this.openable.getElementName().toCharArray();
    }

    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, length - 1);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.resource.getFullPath().lastSegment();
            char[] mainTypeName = fileName.substring(0, fileName.length() - 5).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
            }
            String simpleName = fileName.substring(0, fileName.length() - 5);
            String pkgName = this.openable.getParent().getElementName();
            if (pkgName.length() == 0) {
                return simpleName.toCharArray();
            }
            return (String.valueOf(pkgName) + '.' + simpleName).toCharArray();
        }
        return null;
    }

    private String getSourceFileName() {
        IType type;
        ClassFileReader reader;
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        SourceMapper sourceMapper = this.openable.getSourceMapper();
        if (sourceMapper != null && (reader = MatchLocator.classFileReader(type = ((ClassFile)this.openable).getType())) != null) {
            this.sourceFileName = sourceMapper.findSourceFileName(type, reader);
        }
        return this.sourceFileName;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }
}

