/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.UTFDataFormatException;
import org.eclipse.jdt.internal.core.index.impl.CodeByteStream;
import org.eclipse.jdt.internal.core.index.impl.IndexBlock;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;
import org.eclipse.jdt.internal.core.util.Util;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getWord();
        return true;
    }

    private void encodeEntry(WordEntry entry) {
        char[] word = entry.getWord();
        int prefixLen = this.prevWord == null ? 0 : Util.prefixLength(this.prevWord, word);
        this.writeCodeStream.writeByte(prefixLen);
        this.writeCodeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        this.writeCodeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            this.writeCodeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, prefixLength);
                System.arraycopy(word, 0, temp, prefixLength, word.length);
                word = temp;
            }
            if (word.length == 0) {
                return false;
            }
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

