/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.plugins.DefaultPlugin;
import org.eclipse.core.internal.plugins.InternalPlatform;
import org.eclipse.core.internal.plugins.Library;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.plugins.PluginPrerequisite;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PluginDescriptor
implements IPluginDescriptor {
    private boolean active = false;
    private volatile boolean activePending = false;
    private boolean deactivated = false;
    protected Plugin pluginObject = null;
    private Bundle bundleOsgi;
    private PluginClassLoader classLoader;
    static final String PLUGIN_URL = "platform:/plugin/";
    static final String VERSION_SEPARATOR = "_";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public synchronized void doPluginDeactivation() {
        this.pluginObject = null;
        this.active = false;
        this.activePending = false;
        this.deactivated = false;
    }

    private static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    public IExtension getExtension(String id) {
        IExtension[] exts = this.getExtensions();
        int i = 0;
        while (i < exts.length) {
            if (exts[i].getSimpleIdentifier().equals(id)) {
                return exts[i];
            }
            ++i;
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensionPoint(this.getId(), extensionPointId);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensionPoints(this.getId());
    }

    public IExtension[] getExtensions() {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getRegistry().getExtensions(this.getId());
    }

    public URL getInstallURL() {
        try {
            return new URL(PLUGIN_URL + this.toString() + "/");
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public URL getInstallURLInternal() {
        try {
            return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().resolve(this.getInstallURL());
        }
        catch (IOException iOException) {
            try {
                return new URL(this.bundleOsgi.getEntry("plugin.xml"), ".");
            }
            catch (IOException io) {
                io.printStackTrace();
                return this.getInstallURL();
            }
        }
    }

    public String getLabel() {
        return this.getResourceString((String)this.bundleOsgi.getHeaders().get("Bundle-Name"));
    }

    public ClassLoader getPluginClassLoader() {
        PluginDescriptor pluginDescriptor = this;
        synchronized (pluginDescriptor) {
            if (this.classLoader == null) {
                this.classLoader = new PluginClassLoader(this);
            }
        }
        return this.classLoader;
    }

    public String getFileFromURL(URL target) {
        String protocol = target.getProtocol();
        if (protocol.equals("file")) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return this.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public IPluginPrerequisite[] getPluginPrerequisites() {
        return this.getPluginResolvedPrerequisites();
    }

    public PluginRegistry getPluginRegistry() {
        return (PluginRegistry)InternalPlatform.getPluginRegistry();
    }

    public String getProviderName() {
        String providerName = (String)this.bundleOsgi.getHeaders().get("Bundle-Vendor");
        if (providerName == null) {
            return "";
        }
        return this.getResourceString(providerName);
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getResourceBundle(this.bundleOsgi);
    }

    public String getResourceString(String value) {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getResourceString(this.bundleOsgi, value);
    }

    public String getResourceString(String value, ResourceBundle b) {
        return org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getResourceString(this.bundleOsgi, value, b);
    }

    public ILibrary[] getRuntimeLibraries() {
        if (!this.isLegacy()) {
            return new ILibrary[0];
        }
        ArrayList allLibraries = new ArrayList();
        ArrayList<Bundle> allBundes = new ArrayList<Bundle>();
        allBundes.add(this.bundleOsgi);
        Bundle[] fragments = this.bundleOsgi.getFragments();
        if (fragments != null) {
            allBundes.addAll(Arrays.asList(fragments));
        }
        Iterator iter = allBundes.iterator();
        while (iter.hasNext()) {
            Bundle element = (Bundle)iter.next();
            String classpath = (String)element.getHeaders().get("Bundle-Classpath");
            if (classpath == null) continue;
            allLibraries.addAll(this.splitClasspath(classpath));
        }
        return allLibraries.toArray(new ILibrary[allLibraries.size()]);
    }

    private ArrayList splitClasspath(String classpath) {
        StringTokenizer tokens = new StringTokenizer(classpath, ",");
        ArrayList<Library> libraries = new ArrayList<Library>(tokens.countTokens());
        while (tokens.hasMoreElements()) {
            String element = (String)tokens.nextElement();
            libraries.add(new Library(element.trim()));
        }
        return libraries;
    }

    public String getUniqueIdentifier() {
        return this.getId();
    }

    public static String getUniqueIdentifierFromString(String pluginString) {
        int ix = pluginString.indexOf(VERSION_SEPARATOR);
        return ix == -1 ? pluginString : pluginString.substring(0, ix);
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        String version = (String)this.bundleOsgi.getHeaders().get("Bundle-Version");
        if (version == null) {
            return new PluginVersionIdentifier("1.0.0");
        }
        try {
            return new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return new PluginVersionIdentifier("1.0.0");
        }
    }

    public static PluginVersionIdentifier getVersionIdentifierFromString(String pluginString) {
        return new PluginVersionIdentifier(pluginString);
    }

    public IPluginPrerequisite[] getPluginResolvedPrerequisites() {
        if (!this.isLegacy()) {
            return new IPluginPrerequisite[0];
        }
        String prereqs = (String)this.bundleOsgi.getHeaders().get("Require-Bundle");
        if (prereqs == null) {
            return new IPluginPrerequisite[0];
        }
        HashSet<String> allRequired = new HashSet<String>();
        try {
            ManifestElement[] elements = ManifestElement.parseBasicCommaSeparation((String)"Require-Bundle", (String)prereqs);
            int i = 0;
            while (i < elements.length) {
                allRequired.add(elements[i].getValue());
                allRequired.addAll(this.collectRequired(elements[i].getValue()));
                ++i;
            }
        }
        catch (BundleException bundleException) {
            return new IPluginPrerequisite[0];
        }
        IPluginPrerequisite[] resolvedPrerequisites = new IPluginPrerequisite[allRequired.size()];
        int i = 0;
        Iterator iter = allRequired.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            resolvedPrerequisites[i++] = new PluginPrerequisite(org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getBundle(element));
        }
        return resolvedPrerequisites;
    }

    private Set collectRequired(String requiredId) {
        String requiredBundle = (String)org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getBundle(requiredId).getHeaders().get("Require-Bundle");
        HashSet<String> recursiveRequired = new HashSet<String>(3);
        try {
            ManifestElement[] entries = ManifestElement.parseBasicCommaSeparation((String)"Require-Bundle", (String)requiredBundle);
            if (entries == null) {
                return recursiveRequired;
            }
            int i = 0;
            while (i < entries.length) {
                String reexport = entries[i].getAttribute("provide-packages");
                if ("true".equalsIgnoreCase(reexport)) {
                    recursiveRequired.add(entries[i].getValue());
                    recursiveRequired.addAll(this.collectRequired(entries[i].getValue()));
                }
                ++i;
            }
        }
        catch (BundleException bundleException) {
            return recursiveRequired;
        }
        return recursiveRequired;
    }

    boolean hasActivationStarted() {
        return this.activePending || this.active;
    }

    public synchronized boolean isPluginActivated() {
        return this.active;
    }

    public boolean isPluginDeactivated() {
        return this.deactivated;
    }

    private void logError(IStatus status) {
        org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getLog(org.eclipse.core.internal.runtime.InternalPlatform.getDefault().getBundle("org.eclipse.core.runtime")).log(status);
    }

    private boolean pluginActivationEnter() throws CoreException {
        if (this.deactivated) {
            String errorMsg = Policy.bind("plugin.pluginDisabled", this.getId());
            this.throwException(errorMsg, null);
        }
        if (this.active || this.activePending) {
            return false;
        }
        this.activePending = true;
        return true;
    }

    private void pluginActivationExit(boolean errorExit) {
        if (errorExit) {
            this.active = false;
            this.deactivated = true;
        } else {
            this.active = true;
        }
        this.activePending = false;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.core.runtime", 2, message, exception);
        this.logError(status);
        throw new CoreException(status);
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + VERSION_SEPARATOR + this.getVersionIdentifier().toString();
    }

    public final URL find(IPath path) {
        return FindSupport.find(this.bundleOsgi, path);
    }

    public final URL find(IPath path, Map override) {
        return FindSupport.find(this.bundleOsgi, path, override);
    }

    public Plugin getPlugin() throws CoreException {
        if (this.pluginObject == null) {
            this.doPluginActivation();
        }
        return this.pluginObject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void doPluginActivation() throws CoreException {
        if ((this.bundleOsgi.getState() & 0x2C) == 0) {
            throw new IllegalArgumentException();
        }
        if (this.bundleOsgi.getState() == 4) {
            try {
                this.bundleOsgi.start();
            }
            catch (BundleException e) {
                this.throwException(Policy.bind("plugin.startupProblems", e.toString()), e);
            }
        }
        if (this.pluginObject != null) {
            return;
        }
        boolean errorExit = true;
        if (!this.pluginActivationEnter()) {
            if (!this.active) return;
            if (this.pluginObject != null) return;
            this.active = false;
            this.pluginObject = new DefaultPlugin(this);
            this.active = true;
            return;
        }
        try {
            this.internalDoPluginActivation();
            errorExit = false;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.pluginActivationExit(errorExit);
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.pluginActivationExit(errorExit);
            return;
        }
    }

    private String getPluginClass() {
        return (String)this.bundleOsgi.getHeaders().get("Plugin-class");
    }

    private String getId() {
        return this.bundleOsgi.getGlobalName();
    }

    private void internalDoPluginActivation() throws CoreException {
        String errorMsg;
        Class<?> runtimeClass;
        String pluginClassName;
        block15: {
            pluginClassName = this.getPluginClass();
            runtimeClass = null;
            try {
                if (pluginClassName == null || pluginClassName.equals("")) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.core.internal.plugins.DefaultPlugin;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    runtimeClass = clazz;
                    break block15;
                }
                runtimeClass = this.bundleOsgi.loadClass(pluginClassName);
            }
            catch (ClassNotFoundException e) {
                errorMsg = Policy.bind("plugin.loadClassError", this.getId(), pluginClassName);
                this.throwException(errorMsg, e);
            }
        }
        Constructor<?> construct = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.core.runtime.IPluginDescriptor;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            construct = runtimeClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException eNoConstructor) {
            errorMsg = Policy.bind("plugin.instantiateClassError", this.getId(), pluginClassName);
            this.throwException(errorMsg, eNoConstructor);
        }
        try {
            this.pluginObject = (Plugin)construct.newInstance(this);
        }
        catch (ClassCastException e) {
            errorMsg = Policy.bind("plugin.notPluginClass", pluginClassName);
            this.throwException(errorMsg, e);
        }
        catch (Exception e) {
            errorMsg = Policy.bind("plugin.instantiateClassError", this.getId(), pluginClassName);
            this.throwException(errorMsg, e);
        }
    }

    public PluginDescriptor(Bundle b) {
        this.bundleOsgi = b;
        if ((b.getState() & 0x20) != 0) {
            this.active = true;
        }
    }

    public boolean isLegacy() {
        return new Boolean((String)this.bundleOsgi.getHeaders().get("Legacy"));
    }

    public Bundle getBundle() {
        return this.bundleOsgi;
    }

    public String getLocation() {
        return this.getInstallURLInternal().toExternalForm();
    }

    public void setPlugin(Plugin object) {
        this.pluginObject = object;
    }

    public synchronized void setActive() {
        this.active = true;
    }
}

