/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.IWeaver;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.FastMatchInfo;

public class BcelWeaver
implements IWeaver {
    private BcelWorld world;
    private CrosscuttingMembersSet xcutSet;
    private IProgressListener progressListener = null;
    private double progressMade;
    private double progressPerClassFile;
    private boolean inReweavableMode = false;
    private List addedClasses = new ArrayList();
    private List deletedTypenames = new ArrayList();
    private Manifest manifest = null;
    private boolean needToReweaveWorld = false;
    private List shadowMungerList = null;
    private List typeMungerList = null;
    private List declareParentsList = null;
    private ZipOutputStream zipOutputStream;
    private Set alreadyConfirmedReweavableState;
    private static final String WEAVER_MANIFEST_VERSION = "1.0";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String WEAVER_CREATED_BY = "AspectJ Compiler";

    public BcelWeaver(BcelWorld world) {
        this.world = world;
        this.xcutSet = world.getCrosscuttingMembersSet();
    }

    public BcelWeaver() {
        this(new BcelWorld());
    }

    public void setShadowMungers(List l) {
        this.shadowMungerList = l;
    }

    public void addLibraryAspect(String aspectName) {
        ResolvedTypeX type = this.world.resolve(aspectName);
        if (!type.isAspect()) {
            throw new RuntimeException("unimplemented");
        }
        this.xcutSet.addOrReplaceAspect(type);
    }

    public void addLibraryJarFile(File inFile) throws IOException {
        ZipEntry entry;
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inFile));
        ArrayList<ResolvedTypeX.Name> addedAspects = new ArrayList<ResolvedTypeX.Name>();
        while ((entry = inStream.getNextEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            ClassParser parser = new ClassParser(new ByteArrayInputStream(FileUtil.readAsByteArray(inStream)), entry.getName());
            JavaClass jc = parser.parse();
            inStream.closeEntry();
            ResolvedTypeX.Name type = this.world.addSourceObjectType(jc).getResolvedTypeX();
            if (!((ResolvedTypeX)type).isAspect()) continue;
            addedAspects.add(type);
        }
        inStream.close();
        Iterator i = addedAspects.iterator();
        while (i.hasNext()) {
            ResolvedTypeX aspectX = (ResolvedTypeX)i.next();
            this.xcutSet.addOrReplaceAspect(aspectX);
        }
    }

    public List addDirectoryContents(File inFile, File outDir) throws IOException {
        ArrayList<UnwovenClassFile> addedClassFiles = new ArrayList<UnwovenClassFile>();
        File[] files = FileUtil.listFiles(inFile, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory();
                return accept;
            }
        });
        int i = 0;
        while (i < files.length) {
            addedClassFiles.add(this.addClassFile(files[i], inFile, outDir));
            ++i;
        }
        return addedClassFiles;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List addJarFile(File inFile, File outDir, boolean canBeDirectory) {
        ZipInputStream inStream;
        ArrayList<UnwovenClassFile> addedClassFiles;
        block13: {
            ZipEntry entry;
            addedClassFiles = new ArrayList<UnwovenClassFile>();
            this.needToReweaveWorld = true;
            inStream = null;
            if (inFile.isDirectory() && canBeDirectory) {
                addedClassFiles.addAll(this.addDirectoryContents(inFile, outDir));
                break block13;
            }
            inStream = new JarInputStream(new FileInputStream(inFile));
            this.addManifest(((JarInputStream)inStream).getManifest());
            while ((entry = ((JarInputStream)inStream).getNextEntry()) != null) {
                byte[] bytes = FileUtil.readAsByteArray(inStream);
                String filename = entry.getName();
                UnwovenClassFile classFile = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
                if (filename.endsWith(".class")) {
                    this.addClassFile(classFile);
                    addedClassFiles.add(classFile);
                }
                inStream.closeEntry();
            }
            inStream.close();
        }
        Object var11_14 = null;
        if (inStream == null) return addedClassFiles;
        try {
            inStream.close();
            return addedClassFiles;
        }
        catch (IOException ex2) {
            Message message2 = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex2.getMessage() + ")", new SourceLocation(inFile, 0), true);
            this.world.getMessageHandler().handleMessage(message2);
        }
        return addedClassFiles;
        {
            catch (FileNotFoundException ex) {
                Message message = new Message("Could not find input jar file " + inFile.getPath() + ", ignoring", new SourceLocation(inFile, 0), false);
                this.world.getMessageHandler().handleMessage(message);
                Object var11_15 = null;
                if (inStream == null) return addedClassFiles;
                try {
                    inStream.close();
                    return addedClassFiles;
                }
                catch (IOException ex2) {
                    Message message2 = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex2.getMessage() + ")", new SourceLocation(inFile, 0), true);
                    this.world.getMessageHandler().handleMessage(message2);
                }
                return addedClassFiles;
            }
            catch (IOException ex) {
                Message message = new Message("Could not read input jar file " + inFile.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(inFile, 0), true);
                this.world.getMessageHandler().handleMessage(message);
                Object var11_16 = null;
                if (inStream == null) return addedClassFiles;
                try {
                    inStream.close();
                    return addedClassFiles;
                }
                catch (IOException ex2) {
                    Message message2 = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex2.getMessage() + ")", new SourceLocation(inFile, 0), true);
                    this.world.getMessageHandler().handleMessage(message2);
                }
                return addedClassFiles;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException ex2) {
                Message message2 = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex2.getMessage() + ")", new SourceLocation(inFile, 0), true);
                this.world.getMessageHandler().handleMessage(message2);
            }
            throw throwable;
        }
    }

    public boolean needToReweaveWorld() {
        return this.needToReweaveWorld;
    }

    public void addClassFile(UnwovenClassFile classFile) {
        this.addedClasses.add(classFile);
        this.world.addSourceObjectType(classFile.getJavaClass());
    }

    public UnwovenClassFile addClassFile(File classFile, File inPathDir, File outDir) throws IOException {
        FileInputStream fis = new FileInputStream(classFile);
        byte[] bytes = FileUtil.readAsByteArray(fis);
        String filename = classFile.getAbsolutePath().substring(inPathDir.getAbsolutePath().length() + 1);
        UnwovenClassFile ucf = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
        if (filename.endsWith(".class")) {
            this.addClassFile(ucf);
        }
        fis.close();
        return ucf;
    }

    public void deleteClassFile(String typename) {
        this.deletedTypenames.add(typename);
        this.world.deleteSourceObjectType(TypeX.forName(typename));
    }

    public void prepareForWeave() {
        String name;
        this.needToReweaveWorld = false;
        Iterator i = this.addedClasses.iterator();
        while (i.hasNext()) {
            UnwovenClassFile jc = (UnwovenClassFile)i.next();
            name = jc.getClassName();
            ResolvedTypeX type = this.world.resolve(name);
            if (!type.isAspect()) continue;
            this.needToReweaveWorld |= this.xcutSet.addOrReplaceAspect(type);
        }
        Iterator i2 = this.deletedTypenames.iterator();
        while (i2.hasNext()) {
            name = (String)i2.next();
            if (!this.xcutSet.deleteAspect(TypeX.forName(name))) continue;
            this.needToReweaveWorld = true;
        }
        this.shadowMungerList = this.xcutSet.getShadowMungers();
        this.typeMungerList = this.xcutSet.getTypeMungers();
        this.declareParentsList = this.xcutSet.getDeclareParents();
        Collections.sort(this.shadowMungerList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
    }

    public void addManifest(Manifest newManifest) {
        if (this.manifest == null) {
            this.manifest = newManifest;
        }
    }

    public Manifest getManifest(boolean shouldCreate) {
        if (this.manifest == null && shouldCreate) {
            this.manifest = new Manifest();
            Attributes attributes = this.manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, WEAVER_MANIFEST_VERSION);
            attributes.put(CREATED_BY, WEAVER_CREATED_BY);
        }
        return this.manifest;
    }

    public Collection weave(File file) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(file);
        this.zipOutputStream = new ZipOutputStream(os);
        this.prepareForWeave();
        Collection c = this.weave(new IClassFileProvider(){

            public Iterator getClassFileIterator() {
                return BcelWeaver.this.addedClasses.iterator();
            }

            public IWeaveRequestor getRequestor() {
                return new IWeaveRequestor(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void acceptResult(UnwovenClassFile result) {
                        try {
                            BcelWeaver.access$200(3.access$100(this.this$1), result.filename, result.bytes);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    public void processingReweavableState() {
                    }

                    public void addingTypeMungers() {
                    }

                    public void weavingAspects() {
                    }

                    public void weavingClasses() {
                    }

                    public void weaveCompleted() {
                    }
                };
            }

            static /* synthetic */ BcelWeaver access$100(3 x0) {
                return x0.BcelWeaver.this;
            }
        });
        this.zipOutputStream.close();
        return c;
    }

    public Collection weave(IClassFileProvider input) throws IOException {
        ArrayList<String> wovenClassNames = new ArrayList<String>();
        IWeaveRequestor requestor = input.getRequestor();
        requestor.processingReweavableState();
        this.prepareToProcessReweavableState();
        Iterator i = input.getClassFileIterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i.next();
            String className = classFile.getClassName();
            BcelObjectType classType = this.getClassType(className);
            this.processReweavableStateIfPresent(className, classType);
        }
        requestor.addingTypeMungers();
        Iterator i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i2.next();
            String className = classFile.getClassName();
            this.addTypeMungers(className);
        }
        requestor.weavingAspects();
        Iterator i3 = input.getClassFileIterator();
        while (i3.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i3.next();
            String className = classFile.getClassName();
            BcelObjectType classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (!classType.isAspect()) continue;
            this.weaveAndNotify(classFile, classType, requestor);
            wovenClassNames.add(className);
        }
        requestor.weavingClasses();
        Iterator i4 = input.getClassFileIterator();
        while (i4.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i4.next();
            String className = classFile.getClassName();
            BcelObjectType classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (classType.isAspect()) continue;
            this.weaveAndNotify(classFile, classType, requestor);
            wovenClassNames.add(className);
        }
        this.addedClasses = new ArrayList();
        this.deletedTypenames = new ArrayList();
        requestor.weaveCompleted();
        return wovenClassNames;
    }

    public void prepareToProcessReweavableState() {
        if (this.inReweavableMode) {
            this.world.showMessage(IMessage.INFO, "weaver operating in reweavable mode.  Need to verify any required types exist.", null, null);
        }
        this.alreadyConfirmedReweavableState = new HashSet();
    }

    public void processReweavableStateIfPresent(String className, BcelObjectType classType) {
        WeaverStateInfo wsi = classType.getWeaverState();
        if (wsi != null && wsi.isReweavable()) {
            this.world.showMessage(IMessage.INFO, "processing reweavable type " + className + ": " + classType.getSourceLocation().getSourceFile(), null, null);
            Set aspectsPreviouslyInWorld = wsi.getAspectsAffectingType();
            if (aspectsPreviouslyInWorld != null) {
                Iterator iter = aspectsPreviouslyInWorld.iterator();
                while (iter.hasNext()) {
                    boolean exists;
                    String requiredTypeName = (String)iter.next();
                    if (this.alreadyConfirmedReweavableState.contains(requiredTypeName)) continue;
                    ResolvedTypeX rtx = this.world.resolve(TypeX.forName(requiredTypeName), true);
                    boolean bl = exists = rtx != ResolvedTypeX.MISSING;
                    if (!exists) {
                        this.world.showMessage(IMessage.ERROR, "type " + requiredTypeName + " is needed by reweavable type " + className, classType.getSourceLocation(), null);
                        continue;
                    }
                    if (!this.world.getMessageHandler().isIgnoring(IMessage.INFO)) {
                        this.world.showMessage(IMessage.INFO, "successfully verified type " + requiredTypeName + " exists.  Originates from " + rtx.getSourceLocation().getSourceFile(), null, null);
                    }
                    this.alreadyConfirmedReweavableState.add(requiredTypeName);
                }
            }
            classType.setJavaClass(Utility.makeJavaClass(classType.getJavaClass().getFileName(), wsi.getUnwovenClassFileData()));
        } else {
            classType.resetState();
        }
    }

    private void weaveAndNotify(UnwovenClassFile classFile, BcelObjectType classType, IWeaveRequestor requestor) throws IOException {
        LazyClassGen clazz = this.weaveWithoutDump(classFile, classType);
        classType.finishedWith();
        if (clazz != null) {
            UnwovenClassFile[] newClasses = this.getClassFilesFor(clazz);
            int i = 0;
            while (i < newClasses.length) {
                requestor.acceptResult(newClasses[i]);
                ++i;
            }
        } else {
            requestor.acceptResult(classFile);
        }
    }

    public BcelObjectType getClassType(String forClass) {
        return BcelWorld.getBcelObjectType(this.world.resolve(forClass));
    }

    public void addTypeMungers(String typeName) {
        this.weave(this.world.resolve(typeName));
    }

    public UnwovenClassFile[] getClassFilesFor(LazyClassGen clazz) {
        List childClasses = clazz.getChildClasses(this.world);
        UnwovenClassFile[] ret = new UnwovenClassFile[1 + childClasses.size()];
        ret[0] = new UnwovenClassFile(clazz.getFileName(), clazz.getJavaClass(this.world).getBytes());
        int index = 1;
        Iterator iter = childClasses.iterator();
        while (iter.hasNext()) {
            UnwovenClassFile.ChildClass element = (UnwovenClassFile.ChildClass)iter.next();
            UnwovenClassFile childClass = new UnwovenClassFile(clazz.getFileName() + "$" + element.name, element.bytes);
            ret[index++] = childClass;
        }
        return ret;
    }

    public void weave(ResolvedTypeX onType) {
        onType.clearInterTypeMungers();
        Iterator i = this.declareParentsList.iterator();
        while (i.hasNext()) {
            DeclareParents p = (DeclareParents)i.next();
            List newParents = p.findMatchingNewParents(onType);
            if (newParents.isEmpty()) continue;
            BcelObjectType classType = BcelWorld.getBcelObjectType(onType);
            Iterator j = newParents.iterator();
            while (j.hasNext()) {
                ResolvedTypeX newParent = (ResolvedTypeX)j.next();
                if (newParent.isClass()) {
                    this.world.showMessage(IMessage.ERROR, "can't use declare parents to change superclass of binary form '" + onType.getName() + "' (implementation limitation)", p.getSourceLocation(), null);
                    continue;
                }
                classType.addParent(newParent);
                NewParentTypeMunger newParentMunger = new NewParentTypeMunger(newParent);
                onType.addInterTypeMunger(new BcelTypeMunger(newParentMunger, this.xcutSet.findAspectDeclaringParents(p)));
            }
        }
        Iterator i2 = this.typeMungerList.iterator();
        while (i2.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i2.next();
            if (!m.matches(onType)) continue;
            onType.addInterTypeMunger(m);
        }
    }

    public LazyClassGen weaveWithoutDump(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        return this.weave(classFile, classType, false);
    }

    LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        LazyClassGen ret = this.weave(classFile, classType, true);
        if (this.progressListener != null) {
            this.progressMade += this.progressPerClassFile;
            this.progressListener.setProgress(this.progressMade);
            this.progressListener.setText("woven: " + classFile.getFilename());
        }
        return ret;
    }

    private LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType, boolean dump) throws IOException {
        if (classType.isSynthetic()) {
            if (dump) {
                this.dumpUnchanged(classFile);
            }
            return null;
        }
        List shadowMungers = this.fastMatch(this.shadowMungerList, classType.getResolvedTypeX());
        List typeMungers = classType.getResolvedTypeX().getInterTypeMungers();
        classType.getResolvedTypeX().checkInterTypeMungers();
        LazyClassGen clazz = null;
        if (shadowMungers.size() > 0 || typeMungers.size() > 0 || classType.isAspect()) {
            clazz = classType.getLazyClassGen();
            try {
                boolean isChanged = BcelClassWeaver.weave(this.world, clazz, shadowMungers, typeMungers);
                if (isChanged) {
                    if (dump) {
                        this.dump(classFile, clazz);
                    }
                    return clazz;
                }
            }
            catch (RuntimeException re) {
                System.err.println("trouble in: ");
                throw re;
            }
            catch (Error re) {
                System.err.println("trouble in: ");
                clazz.print(System.err);
                throw re;
            }
        }
        if (dump) {
            this.dumpUnchanged(classFile);
            return clazz;
        }
        return null;
    }

    private void dumpUnchanged(UnwovenClassFile classFile) throws IOException {
        if (this.zipOutputStream != null) {
            this.writeZipEntry(this.getEntryName(classFile.getJavaClass().getClassName()), classFile.getBytes());
        } else {
            classFile.writeUnchangedBytes();
        }
    }

    private String getEntryName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private void dump(UnwovenClassFile classFile, LazyClassGen clazz) throws IOException {
        if (this.zipOutputStream != null) {
            String mainClassName = classFile.getJavaClass().getClassName();
            this.writeZipEntry(this.getEntryName(mainClassName), clazz.getJavaClass(this.world).getBytes());
            if (!clazz.getChildClasses(this.world).isEmpty()) {
                Iterator i = clazz.getChildClasses(this.world).iterator();
                while (i.hasNext()) {
                    UnwovenClassFile.ChildClass c = (UnwovenClassFile.ChildClass)i.next();
                    this.writeZipEntry(this.getEntryName(mainClassName + "$" + c.name), c.bytes);
                }
            }
        } else {
            classFile.writeWovenBytes(clazz.getJavaClass(this.world).getBytes(), clazz.getChildClasses(this.world));
        }
    }

    private void writeZipEntry(String name, byte[] bytes) throws IOException {
        ZipEntry newEntry = new ZipEntry(name);
        this.zipOutputStream.putNextEntry(newEntry);
        this.zipOutputStream.write(bytes);
        this.zipOutputStream.closeEntry();
    }

    private List fastMatch(List list, ResolvedTypeX type) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        FastMatchInfo info = new FastMatchInfo(type, null);
        ArrayList<ShadowMunger> result = new ArrayList<ShadowMunger>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            if (!munger.getPointcut().fastMatch(info).maybeTrue()) continue;
            result.add(munger);
        }
        return result;
    }

    public void setProgressListener(IProgressListener listener, double previousProgress, double progressPerClassFile) {
        this.progressListener = listener;
        this.progressMade = previousProgress;
        this.progressPerClassFile = progressPerClassFile;
    }

    public void setReweavableMode(boolean mode, boolean compress) {
        this.inReweavableMode = mode;
        WeaverStateInfo.setReweavableModeDefaults(mode, compress);
        BcelClassWeaver.setReweavableMode(mode, compress);
    }

    public boolean isReweavable() {
        return this.inReweavableMode;
    }

    static /* synthetic */ void access$200(BcelWeaver x0, String x1, byte[] x2) throws IOException {
        x0.writeZipEntry(x1, x2);
    }
}

