/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.IdentityTokenizedCoalesceChecker;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPoolManager {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager = C3P0PooledConnectionPoolManager.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager);
    private static final boolean POOL_EVENT_SUPPORT = false;
    private static final CoalesceChecker COALESCE_CHECKER = IdentityTokenizedCoalesceChecker.INSTANCE;
    static final Coalescer COALESCER = CoalescerFactory.createCoalescer(COALESCE_CHECKER, true, false);
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    ThreadPoolAsynchronousRunner taskRunner;
    Timer timer;
    ResourcePoolFactory rpfact;
    Map authsToPools;
    final ConnectionPoolDataSource cpds;
    final Map propNamesToReadMethods;
    final Map flatPropertyOverrides;
    final Map userOverrides;
    final DbAuth defaultAuth;
    int num_task_threads = 3;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager;

    private synchronized void poolsInit() {
        this.timer = new Timer(true);
        this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, this.timer);
        this.rpfact = BasicResourcePoolFactory.createNoEventSupportInstance(this.taskRunner, this.timer);
        this.authsToPools = new HashMap();
    }

    private void poolsDestroy() {
        this.poolsDestroy(true);
    }

    private synchronized void poolsDestroy(boolean close_outstanding_connections) {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)ii.next()).close(close_outstanding_connections);
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a pool!", e);
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        this.taskRunner = null;
        this.timer = null;
        this.rpfact = null;
        this.authsToPools = null;
    }

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource cpds, Map flatPropertyOverrides, Map forceUserOverrides, int num_task_threads) throws SQLException {
        try {
            this.cpds = cpds;
            this.flatPropertyOverrides = flatPropertyOverrides;
            this.num_task_threads = num_task_threads;
            DbAuth auth = null;
            if (flatPropertyOverrides != null) {
                String overrideUser = (String)flatPropertyOverrides.get("overrideDefaultUser");
                String overridePassword = (String)flatPropertyOverrides.get("overrideDefaultPassword");
                if (overrideUser == null) {
                    overrideUser = (String)flatPropertyOverrides.get("user");
                    overridePassword = (String)flatPropertyOverrides.get("password");
                }
                if (overrideUser != null) {
                    auth = new DbAuth(overrideUser, overridePassword);
                }
            }
            if (auth == null) {
                auth = C3P0ImplUtils.findAuth(cpds);
            }
            this.defaultAuth = auth;
            HashMap<String, Method> tmp = new HashMap<String, Method>();
            BeanInfo bi = Introspector.getBeanInfo(cpds.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            PropertyDescriptor pd = null;
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                pd = pds[i];
                String name = pd.getName();
                Method m = pd.getReadMethod();
                if (m == null) continue;
                tmp.put(name, m);
            }
            this.propNamesToReadMethods = tmp;
            if (forceUserOverrides == null) {
                Method uom = (Method)this.propNamesToReadMethods.get("userOverridesAsString");
                if (uom != null) {
                    Map uo;
                    String uoas = (String)uom.invoke((Object)cpds, null);
                    this.userOverrides = uo = C3P0ImplUtils.parseUserOverridesAsString(uoas);
                } else {
                    this.userOverrides = Collections.EMPTY_MAP;
                }
            } else {
                this.userOverrides = forceUserOverrides;
            }
            this.poolsInit();
        }
        catch (Exception e) {
            logger.log(MLevel.FINE, null, e);
            throw SqlUtils.toSQLException(e);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(String username, String password) throws SQLException {
        return this.getPool(new DbAuth(username, password));
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth auth) throws SQLException {
        C3P0PooledConnectionPool out = (C3P0PooledConnectionPool)this.authsToPools.get(auth);
        if (out == null) {
            out = this.createPooledConnectionPool(auth);
            this.authsToPools.put(auth, out);
        }
        return out;
    }

    public synchronized Set getManagedAuths() {
        return Collections.unmodifiableSet(this.authsToPools.keySet());
    }

    public synchronized int getNumManagedAuths() {
        return this.authsToPools.size();
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized int getNumIdleConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumIdleConnections();
        }
        return out;
    }

    public synchronized int getNumBusyConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumBusyConnections();
        }
        return out;
    }

    public synchronized int getNumConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumConnections();
        }
        return out;
    }

    public synchronized int getNumUnclosedOrphanedConnectionsAllAuths() throws SQLException {
        int out = 0;
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            out += ((C3P0PooledConnectionPool)ii.next()).getNumUnclosedOrphanedConnections();
        }
        return out;
    }

    public synchronized void softResetAllAuths() throws SQLException {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            ((C3P0PooledConnectionPool)ii.next()).reset();
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean close_outstanding_connections) {
        if (this.authsToPools != null) {
            this.poolsDestroy(close_outstanding_connections);
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private Object getObject(String propName, String userName) {
        String out;
        block7: {
            Map specificUserOverrides;
            out = null;
            if (userName != null && (specificUserOverrides = (Map)this.userOverrides.get(userName)) != null) {
                out = specificUserOverrides.get(propName);
            }
            if (out == null && this.flatPropertyOverrides != null) {
                out = (String)this.flatPropertyOverrides.get(propName);
            }
            if (out == null) {
                try {
                    Object readProp;
                    Method m = (Method)this.propNamesToReadMethods.get(propName);
                    if (m != null && (readProp = m.invoke((Object)this.cpds, null)) != null) {
                        out = readProp.toString();
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(MLevel.WARNING)) break block7;
                    logger.log(MLevel.WARNING, "An exception occurred while trying to read property '" + propName + "' from ConnectionPoolDataSource: " + this.cpds + ". Default config value will be used.", e);
                }
            }
        }
        if (out == null) {
            out = C3P0Config.getUnspecifiedUserProperty(propName, null);
        }
        return out;
    }

    private String getString(String propName, String userName) {
        Object o = this.getObject(propName, userName);
        return o == null ? null : o.toString();
    }

    private int getInt(String propName, String userName) throws Exception {
        Object o = this.getObject(propName, userName);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new Exception("Unexpected object found for putative int property '" + propName + "': " + o);
    }

    private boolean getBoolean(String propName, String userName) throws Exception {
        Object o = this.getObject(propName, userName);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return BooleanUtils.parseBoolean((String)o);
        }
        throw new Exception("Unexpected object found for putative boolean property '" + propName + "': " + o);
    }

    public String getAutomaticTestTable(String userName) {
        return this.getString("automaticTestTable", userName);
    }

    public String getPreferredTestQuery(String userName) {
        return this.getString("preferredTestQuery", userName);
    }

    public int getMinPoolSize(String userName) {
        try {
            return this.getInt("minPoolSize", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.minPoolSize();
        }
    }

    private int getMaxPoolSize(String userName) {
        try {
            return this.getInt("maxPoolSize", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.maxPoolSize();
        }
    }

    private int getMaxStatements(String userName) {
        try {
            return this.getInt("maxStatements", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.maxStatements();
        }
    }

    private int getMaxStatementsPerConnection(String userName) {
        try {
            return this.getInt("maxStatementsPerConnection", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.maxStatementsPerConnection();
        }
    }

    private int getAcquireIncrement(String userName) {
        try {
            return this.getInt("acquireIncrement", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.acquireIncrement();
        }
    }

    private int getAcquireRetryAttempts(String userName) {
        try {
            return this.getInt("acquireRetryAttempts", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.acquireRetryAttempts();
        }
    }

    private int getAcquireRetryDelay(String userName) {
        try {
            return this.getInt("acquireRetryDelay", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.acquireRetryDelay();
        }
    }

    private boolean getBreakAfterAcquireFailure(String userName) {
        try {
            return this.getBoolean("breakAfterAcquireFailure", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", e);
            }
            return C3P0Defaults.breakAfterAcquireFailure();
        }
    }

    private int getCheckoutTimeout(String userName) {
        try {
            return this.getInt("checkoutTimeout", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.checkoutTimeout();
        }
    }

    private int getIdleConnectionTestPeriod(String userName) {
        try {
            return this.getInt("idleConnectionTestPeriod", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.idleConnectionTestPeriod();
        }
    }

    private int getMaxIdleTime(String userName) {
        try {
            return this.getInt("maxIdleTime", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", e);
            }
            return C3P0Defaults.maxIdleTime();
        }
    }

    private boolean getTestConnectionOnCheckout(String userName) {
        try {
            return this.getBoolean("testConnectionOnCheckout", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", e);
            }
            return C3P0Defaults.testConnectionOnCheckout();
        }
    }

    private boolean getTestConnectionOnCheckin(String userName) {
        try {
            return this.getBoolean("testConnectionOnCheckin", userName);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", e);
            }
            return C3P0Defaults.testConnectionOnCheckin();
        }
    }

    public String getConnectionTesterClassName(String userName) {
        return this.getString("connectionTesterClassName", userName);
    }

    private ConnectionTester getConnectionTester(String userName) {
        return C3P0Registry.getConnectionTester(this.getConnectionTesterClassName(userName));
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth auth) throws SQLException {
        String realTestQuery;
        String userName = auth.getUser();
        String automaticTestTable = this.getAutomaticTestTable(userName);
        if (automaticTestTable != null) {
            realTestQuery = this.initializeAutomaticTestTable(automaticTestTable);
            if (this.getPreferredTestQuery(userName) != null && logger.isLoggable(MLevel.WARNING)) {
                logger.logp(MLevel.WARNING, (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager = C3P0PooledConnectionPoolManager.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager).getName(), "createPooledConnectionPool", "[c3p0] Both automaticTestTable and preferredTestQuery have been set! Using automaticTestTable, and ignoring preferredTestQuery. Real test query is ''{0}''.", realTestQuery);
            }
        } else {
            realTestQuery = this.getPreferredTestQuery(userName);
        }
        C3P0PooledConnectionPool out = new C3P0PooledConnectionPool(this.cpds, auth, this.getMinPoolSize(userName), this.getMaxPoolSize(userName), this.getAcquireIncrement(userName), this.getAcquireRetryAttempts(userName), this.getAcquireRetryDelay(userName), this.getBreakAfterAcquireFailure(userName), this.getCheckoutTimeout(userName), this.getIdleConnectionTestPeriod(userName), this.getMaxIdleTime(userName), this.getTestConnectionOnCheckout(userName), this.getTestConnectionOnCheckin(userName), this.getMaxStatements(userName), this.getMaxStatementsPerConnection(userName), this.getConnectionTester(userName), realTestQuery, this.rpfact, this.taskRunner);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initializeAutomaticTestTable(String automaticTestTable) throws SQLException {
        String string;
        PooledConnection throwawayPooledConnection = this.cpds.getPooledConnection();
        Connection c = null;
        PreparedStatement testStmt = null;
        PreparedStatement createStmt = null;
        ResultSet mdrs = null;
        ResultSet rs = null;
        try {
            c = throwawayPooledConnection.getConnection();
            DatabaseMetaData dmd = c.getMetaData();
            String q = dmd.getIdentifierQuoteString();
            String quotedTableName = q + automaticTestTable + q;
            String out = "SELECT * FROM " + quotedTableName;
            mdrs = dmd.getTables(null, null, automaticTestTable, new String[]{"TABLE"});
            boolean exists = mdrs.next();
            if (exists) {
                testStmt = c.prepareStatement(out);
                rs = testStmt.executeQuery();
                boolean has_rows = rs.next();
                if (has_rows) {
                    throw new SQLException("automatic test table '" + automaticTestTable + "' contains rows, and it should not! Please set this " + "parameter to the name of a table c3p0 can create on its own, " + "that is not used elsewhere in the database!");
                }
            } else {
                String createSql = "CREATE TABLE " + quotedTableName + " ( a CHAR(1) )";
                try {
                    createStmt = c.prepareStatement(createSql);
                    createStmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "An attempt to create an automatic test table failed. Create SQL: " + createSql, e);
                    }
                    throw e;
                }
            }
            string = out;
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ResultSetUtils.attemptClose(mdrs);
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(testStmt);
            StatementUtils.attemptClose(createStmt);
            ConnectionUtils.attemptClose(c);
            try {
                if (throwawayPooledConnection != null) {
                    throwawayPooledConnection.close();
                }
            }
            catch (Exception e) {
                logger.log(MLevel.WARNING, "A PooledConnection failed to close.", e);
            }
            throw throwable;
        }
        ResultSetUtils.attemptClose(mdrs);
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(testStmt);
        StatementUtils.attemptClose(createStmt);
        ConnectionUtils.attemptClose(c);
        try {
            if (throwawayPooledConnection != null) {
                throwawayPooledConnection.close();
            }
        }
        catch (Exception e) {
            logger.log(MLevel.WARNING, "A PooledConnection failed to close.", e);
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

