/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class NamedPipeSocketFactory
implements SocketFactory {
    private static final String NAMED_PIPE_PROP_NAME = "namedPipePath";
    private Socket namedPipeSocket;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public Socket afterHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.namedPipeSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.namedPipeSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    public Socket connect(String string, int n, Properties properties) throws SocketException, IOException {
        void props;
        String string2 = string;
        int n2 = n;
        Properties properties2 = properties;
        Object[] objectArray = new Object[]{string2, Conversions.intObject((int)n2), properties2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String namedPipePath = props.getProperty(NAMED_PIPE_PROP_NAME);
        if (namedPipePath == null) {
            namedPipePath = "\\\\.\\pipe\\MySQL";
        } else if (namedPipePath.length() == 0) {
            throw new SocketException(String.valueOf(Messages.getString("NamedPipeSocketFactory.2")) + NAMED_PIPE_PROP_NAME + Messages.getString("NamedPipeSocketFactory.3"));
        }
        Socket socket = this.namedPipeSocket = new NamedPipeSocket(namedPipePath);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    static {
        Factory factory = new Factory("NamedPipeSocketFactory.java", Class.forName("com.mysql.jdbc.NamedPipeSocketFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterHandshake-com.mysql.jdbc.NamedPipeSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 189);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeHandshake-com.mysql.jdbc.NamedPipeSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 196);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-com.mysql.jdbc.NamedPipeSocketFactory-java.lang.String:int:java.util.Properties:-host:portNumber:props:-java.net.SocketException:java.io.IOException:-java.net.Socket-"), 204);
    }

    class NamedPipeSocket
    extends Socket {
        private boolean isClosed = false;
        private RandomAccessFile namedPipeFile;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        NamedPipeSocket(String filePath) throws IOException {
            if (filePath == null || filePath.length() == 0) {
                throw new IOException(Messages.getString("NamedPipeSocketFactory.4"));
            }
            this.namedPipeFile = new RandomAccessFile(filePath, "rw");
        }

        public synchronized void close() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.namedPipeFile.close();
            this.isClosed = true;
            Object var2_2 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
        }

        public InputStream getInputStream() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(this.namedPipeFile);
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(randomAccessFileInputStream, joinPoint);
            return randomAccessFileInputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(this.namedPipeFile);
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(randomAccessFileOutputStream, joinPoint);
            return randomAccessFileOutputStream;
        }

        public boolean isClosed() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            boolean bl = this.isClosed;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }

        static {
            Factory factory = new Factory("NamedPipeSocketFactory.java", Class.forName("com.mysql.jdbc.NamedPipeSocketFactory$NamedPipeSocket"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-close-com.mysql.jdbc.NamedPipeSocketFactory$NamedPipeSocket---java.io.IOException:-void-"), 64);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getInputStream-com.mysql.jdbc.NamedPipeSocketFactory$NamedPipeSocket---java.io.IOException:-java.io.InputStream-"), 72);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOutputStream-com.mysql.jdbc.NamedPipeSocketFactory$NamedPipeSocket---java.io.IOException:-java.io.OutputStream-"), 79);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isClosed-com.mysql.jdbc.NamedPipeSocketFactory$NamedPipeSocket----boolean-"), 86);
        }
    }

    class RandomAccessFileInputStream
    extends InputStream {
        RandomAccessFile raFile;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;
        private static final JoinPoint.StaticPart ajc$tjp_4;

        RandomAccessFileInputStream(RandomAccessFile file) {
            this.raFile = file;
        }

        public int available() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            int n = -1;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
            return -1;
        }

        public void close() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.raFile.close();
            Object var2_2 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
        }

        public int read() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            int n = this.raFile.read();
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public int read(byte[] byArray) throws IOException {
            void b;
            byte[] byArray2 = byArray;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)byArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            int n = this.raFile.read((byte[])b);
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            void len;
            void off;
            void b;
            byte[] byArray2 = byArray;
            int n3 = n;
            int n4 = n2;
            Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            int n5 = this.raFile.read((byte[])b, (int)off, (int)len);
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n5), joinPoint);
            return n5;
        }

        static {
            Factory factory = new Factory("NamedPipeSocketFactory.java", Class.forName("com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-available-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream---java.io.IOException:-int-"), 104);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream---java.io.IOException:-void-"), 111);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream---java.io.IOException:-int-"), 118);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream-[B:-b:-java.io.IOException:-int-"), 125);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileInputStream-[B:int:int:-b:off:len:-java.io.IOException:-int-"), 132);
        }
    }

    class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile raFile;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        RandomAccessFileOutputStream(RandomAccessFile file) {
            this.raFile = file;
        }

        public void close() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.raFile.close();
            Object var2_2 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
        }

        /*
         * WARNING - void declaration
         */
        public void write(byte[] byArray) throws IOException {
            void b;
            byte[] byArray2 = byArray;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)byArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.raFile.write((byte[])b);
            Object var4_4 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
        }

        /*
         * WARNING - void declaration
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            void len;
            void off;
            void b;
            byte[] byArray2 = byArray;
            int n3 = n;
            int n4 = n2;
            Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            this.raFile.write((byte[])b, (int)off, (int)len);
            Object var9_9 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
        }

        public void write(int n) throws IOException {
            int n2 = n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            Object var4_4 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
        }

        static {
            Factory factory = new Factory("NamedPipeSocketFactory.java", Class.forName("com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileOutputStream"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileOutputStream---java.io.IOException:-void-"), 150);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-write-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileOutputStream-[B:-b:-java.io.IOException:-void-"), 157);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-write-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileOutputStream-[B:int:int:-b:off:len:-java.io.IOException:-void-"), 164);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-write-com.mysql.jdbc.NamedPipeSocketFactory$RandomAccessFileOutputStream-int:-b:-java.io.IOException:-void-"), 171);
        }
    }
}

