/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.trace.Tracer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private Connection currentConn;
    private List hostList;
    private Map liveConnections;
    private Map connectionsToHostsMap;
    private long[] responseTimes;
    private Map hostsToListIndexMap;
    boolean inTransaction = false;
    long transactionStartTime = 0L;
    Properties localProps;
    boolean isClosed = false;
    BalanceStrategy balancer;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    static {
        Factory factory = new Factory("LoadBalancingConnectionProxy.java", Class.forName("com.mysql.jdbc.LoadBalancingConnectionProxy"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-createConnectionForHost-com.mysql.jdbc.LoadBalancingConnectionProxy-java.lang.String:-hostPortSpec:-java.sql.SQLException:-com.mysql.jdbc.Connection-"), 306);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-dealWithInvocationException-com.mysql.jdbc.LoadBalancingConnectionProxy-java.lang.reflect.InvocationTargetException:-e:-java.sql.SQLException:java.lang.Throwable:java.lang.reflect.InvocationTargetException:-void-"), 339);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$2-com.mysql.jdbc.LoadBalancingConnectionProxy-com.mysql.jdbc.LoadBalancingConnectionProxy:-arg0:--java.util.Map-"), 233);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$3-com.mysql.jdbc.LoadBalancingConnectionProxy-com.mysql.jdbc.LoadBalancingConnectionProxy:java.lang.String:-arg0:arg1:--com.mysql.jdbc.Connection-"), 304);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-invalidateCurrentConnection-com.mysql.jdbc.LoadBalancingConnectionProxy---java.sql.SQLException:-void-"), 367);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-invoke-com.mysql.jdbc.LoadBalancingConnectionProxy-java.lang.Object:java.lang.reflect.Method:[Ljava.lang.Object;:-proxy:method:args:-java.lang.Throwable:-java.lang.Object-"), 386);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-pickNewConnection-com.mysql.jdbc.LoadBalancingConnectionProxy---java.sql.SQLException:-void-"), 462);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-proxyIfInterfaceIsJdbc-com.mysql.jdbc.LoadBalancingConnectionProxy-java.lang.Object:java.lang.Class:-toProxy:clazz:--java.lang.Object-"), 486);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getLocalTimeBestResolution-com.mysql.jdbc.LoadBalancingConnectionProxy----long-"), 509);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-doPing-com.mysql.jdbc.LoadBalancingConnectionProxy---java.sql.SQLException:-void-"), 526);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$0-com.mysql.jdbc.LoadBalancingConnectionProxy-com.mysql.jdbc.LoadBalancingConnectionProxy:-arg0:--[J-"), 237);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$1-com.mysql.jdbc.LoadBalancingConnectionProxy-com.mysql.jdbc.LoadBalancingConnectionProxy:-arg0:--java.util.List-"), 231);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.System");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            getLocalTimeMethod = clazz.getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    LoadBalancingConnectionProxy(List hosts, Properties props) throws SQLException {
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap(numHosts);
        this.connectionsToHostsMap = new HashMap(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap(numHosts);
        int i = 0;
        while (i < numHosts) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
            ++i;
        }
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        if ("random".equals(strategy)) {
            this.balancer = new RandomBalanceStrategy();
        } else if ("bestResponseTime".equals(strategy)) {
            this.balancer = new BestResponseTimeBalanceStrategy();
        } else {
            throw SQLError.createSQLException(Messages.getString("InvalidLoadBalanceStrategy", new Object[]{strategy}), "S1009");
        }
        this.pickNewConnection();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Connection createConnectionForHost(String string) throws SQLException {
        void hostPortSpec;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair((String)hostPortSpec);
        if (hostPortPair[1] == null) {
            hostPortPair[1] = "3306";
        }
        connProps.setProperty("HOST", (String)hostPortSpec);
        connProps.setProperty("PORT", hostPortPair[1]);
        Connection conn = new Connection((String)hostPortSpec, Integer.parseInt(hostPortPair[1]), connProps, connProps.getProperty("DBNAME"), "jdbc:mysql://" + hostPortPair[0] + ":" + hostPortPair[1] + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        Connection connection = conn;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection, joinPoint);
        return connection;
    }

    /*
     * WARNING - void declaration
     */
    void dealWithInvocationException(InvocationTargetException invocationTargetException) throws SQLException, Throwable, InvocationTargetException {
        void e;
        InvocationTargetException invocationTargetException2 = invocationTargetException;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)invocationTargetException2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Throwable t = e.getTargetException();
        if (t != null) {
            String sqlState;
            if (t instanceof SQLException && (sqlState = ((SQLException)t).getSQLState()) != null && sqlState.startsWith("08")) {
                this.invalidateCurrentConnection();
            }
            throw t;
        }
        throw e;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void invalidateCurrentConnection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            if (!this.currentConn.isClosed()) {
                this.currentConn.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
            this.connectionsToHostsMap.remove(this.currentConn);
            throw throwable;
        }
        {
            Object var1_4 = null;
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
        }
        this.connectionsToHostsMap.remove(this.currentConn);
        Object var4_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_5, joinPoint);
    }

    /*
     * Exception decompiling
     */
    public Object invoke(Object var1_1, Method var2_2, Object[] var3_3) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [0 : 382->385)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void pickNewConnection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection();
        } else {
            Connection newConn = this.balancer.pickConnection();
            newConn.setTransactionIsolation(this.currentConn.getTransactionIsolation());
            newConn.setAutoCommit(this.currentConn.getAutoCommit());
            this.currentConn = newConn;
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    Object proxyIfInterfaceIsJdbc(Object object, Class clazz) {
        void toProxy;
        String packageName;
        void clazz2;
        Object object2 = object;
        Class clazz3 = clazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)object2, (Object)clazz3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Class<?>[] interfaces = clazz2.getInterfaces();
        int i = 0;
        void var9_9 = i < interfaces.length ? ("java.sql".equals(packageName = interfaces[i].getPackage().getName()) || "javax.sql".equals(packageName) ? Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfaces, (InvocationHandler)new ConnectionErrorFiringInvocationHandler(toProxy)) : this.proxyIfInterfaceIsJdbc(toProxy, interfaces[i])) : toProxy;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
        return var9_9;
    }

    private static long getLocalTimeBestResolution() {
        long l;
        JoinPoint joinPoint;
        block5: {
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (getLocalTimeMethod != null) {
                try {
                    l = (Long)getLocalTimeMethod.invoke(null, null);
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            l = System.currentTimeMillis();
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    public synchronized void doPing() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Iterator allConns = this.liveConnections.values().iterator();
        while (allConns.hasNext()) {
            ((Connection)allConns.next()).ping();
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    static /* synthetic */ long[] access$0(LoadBalancingConnectionProxy loadBalancingConnectionProxy) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy2 = loadBalancingConnectionProxy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null, (Object)loadBalancingConnectionProxy2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long[] lArray = loadBalancingConnectionProxy.responseTimes;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(lArray, joinPoint);
        return loadBalancingConnectionProxy.responseTimes;
    }

    static /* synthetic */ List access$1(LoadBalancingConnectionProxy loadBalancingConnectionProxy) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy2 = loadBalancingConnectionProxy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)loadBalancingConnectionProxy2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        List list = loadBalancingConnectionProxy.hostList;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(list, joinPoint);
        return list;
    }

    static /* synthetic */ Map access$2(LoadBalancingConnectionProxy loadBalancingConnectionProxy) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy2 = loadBalancingConnectionProxy;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)loadBalancingConnectionProxy2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Map map = loadBalancingConnectionProxy.liveConnections;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(map, joinPoint);
        return map;
    }

    static /* synthetic */ Connection access$3(LoadBalancingConnectionProxy loadBalancingConnectionProxy, String string) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy2 = loadBalancingConnectionProxy;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)loadBalancingConnectionProxy2, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Connection connection = loadBalancingConnectionProxy.createConnectionForHost(string);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection, joinPoint);
        return connection;
    }

    interface BalanceStrategy {
        public Connection pickConnection() throws SQLException;
    }

    class BestResponseTimeBalanceStrategy
    implements BalanceStrategy {
        private static final JoinPoint.StaticPart ajc$tjp_0;

        BestResponseTimeBalanceStrategy() {
        }

        public Connection pickConnection() throws SQLException {
            Connection connection;
            JoinPoint joinPoint;
            block19: {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                long minResponseTime = Long.MAX_VALUE;
                int bestHostIndex = 0;
                long[] localResponseTimes = new long[LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this).length];
                long[] lArray = LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this);
                synchronized (lArray) {
                    System.arraycopy(LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this), 0, localResponseTimes, 0, LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this).length);
                }
                SQLException ex = null;
                int attempts = 0;
                while (attempts < 1200) {
                    block18: {
                        int i2 = 0;
                        while (i2 < localResponseTimes.length) {
                            long candidateResponseTime = localResponseTimes[i2];
                            if (candidateResponseTime < minResponseTime) {
                                if (candidateResponseTime == 0L) {
                                    bestHostIndex = i2;
                                    break;
                                }
                                bestHostIndex = i2;
                                minResponseTime = candidateResponseTime;
                            }
                            ++i2;
                        }
                        if (bestHostIndex == localResponseTimes.length - 1) {
                            long[] i2 = LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this);
                            synchronized (i2) {
                                System.arraycopy(LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this), 0, localResponseTimes, 0, LoadBalancingConnectionProxy.access$0(LoadBalancingConnectionProxy.this).length);
                            }
                        }
                        String bestHost = (String)LoadBalancingConnectionProxy.access$1(LoadBalancingConnectionProxy.this).get(bestHostIndex);
                        Connection conn = (Connection)LoadBalancingConnectionProxy.access$2(LoadBalancingConnectionProxy.this).get(bestHost);
                        if (conn == null) {
                            try {
                                conn = LoadBalancingConnectionProxy.access$3(LoadBalancingConnectionProxy.this, bestHost);
                            }
                            catch (SQLException sqlEx) {
                                ex = sqlEx;
                                if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                                    localResponseTimes[bestHostIndex] = Long.MAX_VALUE;
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    break block18;
                                }
                                throw sqlEx;
                            }
                        }
                        connection = conn;
                        break block19;
                    }
                    ++attempts;
                }
                if (ex != null) {
                    throw ex;
                }
                connection = null;
            }
            Connection connection2 = connection;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection2, joinPoint);
            return connection;
        }

        static {
            Factory factory = new Factory("LoadBalancingConnectionProxy.java", Class.forName("com.mysql.jdbc.LoadBalancingConnectionProxy$BestResponseTimeBalanceStrategy"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-pickConnection-com.mysql.jdbc.LoadBalancingConnectionProxy$BestResponseTimeBalanceStrategy---java.sql.SQLException:-com.mysql.jdbc.Connection-"), 79);
        }
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;
        private static final JoinPoint.StaticPart ajc$tjp_0;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        /*
         * WARNING - void declaration
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2 = object;
            Method method2 = method;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[]{object2, method2, objectArray2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray3);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            Object result = null;
            try {
                void args;
                void method3;
                result = method3.invoke(this.invokeOn, (Object[])args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            Object object3 = result;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(object3, joinPoint);
            return object3;
        }

        static {
            Factory factory = new Factory("LoadBalancingConnectionProxy.java", Class.forName("com.mysql.jdbc.LoadBalancingConnectionProxy$ConnectionErrorFiringInvocationHandler"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-invoke-com.mysql.jdbc.LoadBalancingConnectionProxy$ConnectionErrorFiringInvocationHandler-java.lang.Object:java.lang.reflect.Method:[Ljava.lang.Object;:-proxy:method:args:-java.lang.Throwable:-java.lang.Object-"), 165);
        }
    }

    class RandomBalanceStrategy
    implements BalanceStrategy {
        private static final JoinPoint.StaticPart ajc$tjp_0;

        RandomBalanceStrategy() {
        }

        public Connection pickConnection() throws SQLException {
            Connection connection;
            JoinPoint joinPoint;
            block10: {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                int random = (int)(Math.random() * (double)LoadBalancingConnectionProxy.access$1(LoadBalancingConnectionProxy.this).size());
                if (random == LoadBalancingConnectionProxy.access$1(LoadBalancingConnectionProxy.this).size()) {
                    --random;
                }
                String hostPortSpec = (String)LoadBalancingConnectionProxy.access$1(LoadBalancingConnectionProxy.this).get(random);
                SQLException ex = null;
                int attempts = 0;
                while (attempts < 1200) {
                    block9: {
                        Connection conn = (Connection)LoadBalancingConnectionProxy.access$2(LoadBalancingConnectionProxy.this).get(hostPortSpec);
                        if (conn == null) {
                            try {
                                conn = LoadBalancingConnectionProxy.access$3(LoadBalancingConnectionProxy.this, hostPortSpec);
                            }
                            catch (SQLException sqlEx) {
                                ex = sqlEx;
                                if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    break block9;
                                }
                                throw sqlEx;
                            }
                        }
                        connection = conn;
                        break block10;
                    }
                    ++attempts;
                }
                if (ex != null) {
                    throw ex;
                }
                connection = null;
            }
            Connection connection2 = connection;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection2, joinPoint);
            return connection;
        }

        static {
            Factory factory = new Factory("LoadBalancingConnectionProxy.java", Class.forName("com.mysql.jdbc.LoadBalancingConnectionProxy$RandomBalanceStrategy"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-pickConnection-com.mysql.jdbc.LoadBalancingConnectionProxy$RandomBalanceStrategy---java.sql.SQLException:-com.mysql.jdbc.Connection-"), 184);
        }
    }
}

