/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension2;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.SlaveDocumentEvent;

public final class ChildDocument
extends AbstractDocument {
    private IDocument fParentDocument;
    private IDocumentExtension fExtension;
    private IDocumentExtension2 fExtension2;
    private Position fRange;
    private DocumentEvent fParentEvent;
    private DocumentEvent fEvent;
    private boolean fIsUpdating = false;
    private String fExpectedContent;
    private int fRememberedLength;
    private boolean fIsAutoExpanding = false;

    public ChildDocument(IDocument parentDocument, Position range) {
        this.fParentDocument = parentDocument;
        if (this.fParentDocument instanceof IDocumentExtension) {
            this.fExtension = (IDocumentExtension)((Object)this.fParentDocument);
        }
        if (this.fParentDocument instanceof IDocumentExtension2) {
            this.fExtension2 = (IDocumentExtension2)((Object)this.fParentDocument);
        }
        this.fRange = range;
        TextStore s = new TextStore();
        DefaultLineTracker tracker = new DefaultLineTracker();
        tracker.set(s.get(0, this.fRange.getLength()));
        this.setTextStore(s);
        this.setLineTracker(tracker);
        this.completeInitialization();
    }

    public void setParentDocumentRange(int offset, int length) throws BadLocationException {
        if (offset < 0 || length < 0 || offset + length > this.fParentDocument.getLength()) {
            throw new BadLocationException();
        }
        this.fRange.setOffset(offset);
        this.fRange.setLength(length);
        this.getTracker().set(this.fParentDocument.get(offset, length));
    }

    public IDocument getParentDocument() {
        return this.fParentDocument;
    }

    public Position getParentDocumentRange() {
        return this.fRange;
    }

    public DocumentEvent normalize(DocumentEvent event) {
        int delta = event.getOffset() - this.fRange.getOffset();
        if (this.isAutoExpandEvent(event)) {
            if (delta < 0) {
                int eventEndOffset = event.getOffset() + event.getLength();
                if (eventEndOffset <= this.fRange.getOffset()) {
                    StringBuffer buffer = new StringBuffer();
                    if (event.getText() != null) {
                        buffer.append(event.getText());
                    }
                    try {
                        buffer.append(this.fParentDocument.get(eventEndOffset, -delta - event.getLength()));
                    }
                    catch (BadLocationException badLocationException) {}
                    return new SlaveDocumentEvent(this, 0, 0, buffer.toString(), event);
                }
                int length = Math.min(eventEndOffset - this.fRange.getOffset(), this.fRange.getLength());
                return new SlaveDocumentEvent(this, 0, length, event.getText(), event);
            }
            int rangeEndOffset = this.fRange.getOffset() + this.fRange.getLength();
            if (event.getOffset() >= rangeEndOffset) {
                StringBuffer buffer = new StringBuffer();
                try {
                    buffer.append(this.fParentDocument.get(rangeEndOffset, event.getOffset() - rangeEndOffset));
                }
                catch (BadLocationException badLocationException) {}
                if (event.getText() != null) {
                    buffer.append(event.getText());
                }
                return new SlaveDocumentEvent(this, this.fRange.getLength(), 0, buffer.toString(), event);
            }
            int offset = event.getOffset() - this.fRange.getOffset();
            int length = Math.min(rangeEndOffset - event.getOffset(), event.getLength());
            return new SlaveDocumentEvent(this, offset, length, event.getText(), event);
        }
        if (this.fRange.overlapsWith(event.fOffset, event.fLength)) {
            int length;
            int offset = delta < 0 ? 0 : delta;
            int n = length = delta < 0 ? event.fLength + delta : event.fLength;
            if (offset + length > this.fRange.getLength()) {
                length = this.fRange.getLength() - offset;
            }
            return new SlaveDocumentEvent(this, offset, length, event.fText, event);
        }
        return null;
    }

    public void parentDocumentAboutToBeChanged(DocumentEvent event) {
        this.fParentEvent = event;
        this.fEvent = this.normalize(event);
        if (this.fEvent != null) {
            StringBuffer buffer = new StringBuffer(this.get());
            this.fRememberedLength = buffer.length();
            buffer.replace(this.fEvent.fOffset, this.fEvent.fOffset + this.fEvent.fLength, this.fEvent.fText == null ? "" : this.fEvent.fText);
            this.fExpectedContent = buffer.toString();
            this.delayedFireDocumentAboutToBeChanged();
        }
    }

    public void parentDocumentChanged(DocumentEvent event) {
        if (!this.fIsUpdating && event == this.fParentEvent && this.fEvent != null) {
            try {
                if (!this.fExpectedContent.equals(this.get())) {
                    this.fEvent.fOffset = 0;
                    this.fEvent.fLength = this.fRememberedLength;
                    this.fEvent.fText = this.get();
                }
                this.fRememberedLength = 0;
                this.fExpectedContent = null;
                this.getTracker().replace(this.fEvent.fOffset, this.fEvent.fLength, this.fEvent.fText);
                this.fireDocumentChanged(this.fEvent);
            }
            catch (BadLocationException badLocationException) {
                Assert.isLegal(false);
            }
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
    }

    private void delayedFireDocumentAboutToBeChanged() {
        super.fireDocumentAboutToBeChanged(this.fEvent);
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        super.fireDocumentChanged(this.fEvent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replace(int offset, int length, String text) throws BadLocationException {
        try {
            block9: {
                this.fIsUpdating = true;
                if (this.fExtension != null) {
                    this.fExtension.stopPostNotificationProcessing();
                }
                if (offset < 0) throw new BadLocationException();
                if (length < 0) throw new BadLocationException();
                if (offset + length > this.getLength()) {
                    throw new BadLocationException();
                }
                DocumentEvent event = new DocumentEvent(this, offset, length, text);
                this.fireDocumentAboutToBeChanged(event);
                try {
                    if (this.fExtension2 != null) {
                        this.fExtension2.stopListenerNotification();
                    }
                    this.getStore().replace(offset, length, text);
                    this.getTracker().replace(offset, length, text);
                    this.updateDocumentStructures(this.fEvent);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (this.fExtension2 == null) throw throwable;
                    this.fExtension2.resumeListenerNotification();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    if (this.fExtension2 == null) break block9;
                    this.fExtension2.resumeListenerNotification();
                }
            }
            this.doFireDocumentChanged(this.fEvent);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) throw throwable;
            this.fExtension.resumePostNotificationProcessing();
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) return;
            this.fExtension.resumePostNotificationProcessing();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(String text) {
        try {
            block8: {
                this.fIsUpdating = true;
                if (this.fExtension != null) {
                    this.fExtension.stopPostNotificationProcessing();
                }
                int length = this.getStore().getLength();
                DocumentEvent event = new DocumentEvent(this, 0, length, text);
                this.fireDocumentAboutToBeChanged(event);
                try {
                    if (this.fExtension2 != null) {
                        this.fExtension2.stopListenerNotification();
                    }
                    this.getStore().set(text);
                    this.getTracker().set(text);
                    this.updateDocumentStructures(this.fEvent);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (this.fExtension2 == null) throw throwable;
                    this.fExtension2.resumeListenerNotification();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    if (this.fExtension2 == null) break block8;
                    this.fExtension2.resumeListenerNotification();
                }
            }
            this.doFireDocumentChanged(this.fEvent);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) throw throwable;
            this.fExtension.resumePostNotificationProcessing();
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.fIsUpdating = false;
            if (this.fExtension == null) return;
            this.fExtension.resumePostNotificationProcessing();
            return;
        }
    }

    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (!this.fIsUpdating) {
            throw new UnsupportedOperationException();
        }
        super.registerPostNotificationReplace(owner, replace);
    }

    public void setAutoExpandMode(boolean autoExpand) {
        this.fIsAutoExpanding = autoExpand;
    }

    public boolean isAutoExpandEvent(DocumentEvent event) {
        return this.fIsAutoExpanding;
    }

    class TextStore
    implements ITextStore {
        TextStore() {
        }

        public void set(String txt) {
            try {
                ChildDocument.this.fParentDocument.replace(ChildDocument.this.fRange.getOffset(), ChildDocument.this.fRange.getLength(), txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int offset, int length, String txt) {
            try {
                ChildDocument.this.fParentDocument.replace(ChildDocument.this.fRange.getOffset() + offset, length, txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getLength() {
            return ChildDocument.this.fRange.getLength();
        }

        public String get(int offset, int length) {
            try {
                return ChildDocument.this.fParentDocument.get(ChildDocument.this.fRange.getOffset() + offset, length);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public char get(int offset) {
            try {
                return ChildDocument.this.fParentDocument.getChar(ChildDocument.this.fRange.getOffset() + offset);
            }
            catch (BadLocationException badLocationException) {
                return '\u0000';
            }
        }
    }
}

