/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Label {
    public CodeStream codeStream;
    static final int POS_NOT_SET = -1;
    public int position = -1;
    public int[] forwardReferences = new int[10];
    public int forwardReferenceCount = 0;
    private boolean isWide = false;

    public Label() {
    }

    public Label(CodeStream codeStream) {
        this.codeStream = codeStream;
    }

    void addForwardReference(int iPos) {
        int length = this.forwardReferences.length;
        if (this.forwardReferenceCount >= length) {
            this.forwardReferences = new int[2 * length];
            System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, length);
        }
        this.forwardReferences[this.forwardReferenceCount++] = iPos;
    }

    public void appendForwardReferencesFrom(Label otherLabel) {
        int otherCount = otherLabel.forwardReferenceCount;
        if (otherCount == 0) {
            return;
        }
        int neededSpace = otherCount + this.forwardReferenceCount;
        int length = this.forwardReferences.length;
        if (neededSpace >= length) {
            this.forwardReferences = new int[neededSpace];
            System.arraycopy(this.forwardReferences, 0, this.forwardReferences, 0, this.forwardReferenceCount);
        }
        System.arraycopy(otherLabel.forwardReferences, 0, this.forwardReferences, this.forwardReferenceCount, otherCount);
        this.forwardReferenceCount = neededSpace;
    }

    void branch() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 2;
            this.codeStream.classFileOffset += 2;
        } else {
            int offset = this.position - this.codeStream.position + 1;
            if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE);
            }
            this.codeStream.writeSignedShort(offset);
        }
    }

    void branchWide() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.isWide = true;
            this.codeStream.position += 4;
            this.codeStream.classFileOffset += 4;
        } else {
            this.codeStream.writeSignedWord(this.position - this.codeStream.position + 1);
        }
    }

    public boolean hasForwardReferences() {
        return this.forwardReferenceCount != 0;
    }

    public void inlineForwardReferencesFromLabelsTargeting(int gotoLocation) {
        Label[] labels = this.codeStream.labels;
        int i = this.codeStream.countLabels - 1;
        while (i >= 0) {
            Label label = labels[i];
            if (label.position != gotoLocation || !label.isStandardLabel()) break;
            this.appendForwardReferencesFrom(label);
            --i;
        }
    }

    public boolean isStandardLabel() {
        return true;
    }

    public void place() {
        if (this.position == -1) {
            this.position = this.codeStream.position;
            this.codeStream.addLabel(this);
            int oldPosition = this.position;
            boolean isOptimizedBranch = false;
            if (this.forwardReferenceCount != 0) {
                boolean bl = isOptimizedBranch = this.forwardReferences[this.forwardReferenceCount - 1] + 2 == this.position && this.codeStream.bCodeStream[this.codeStream.classFileOffset - 3] == -89;
                if (isOptimizedBranch) {
                    this.codeStream.position = this.position -= 3;
                    this.codeStream.classFileOffset -= 3;
                    --this.forwardReferenceCount;
                    int index = this.codeStream.pcToSourceMapSize - 2;
                    if (this.codeStream.lastEntryPC == oldPosition) {
                        this.codeStream.lastEntryPC = this.position;
                    }
                    if (index >= 0 && this.codeStream.pcToSourceMap[index] == this.position) {
                        this.codeStream.pcToSourceMapSize -= 2;
                    }
                    if (this.codeStream.generateLocalVariableTableAttributes) {
                        LocalVariableBinding[] locals = this.codeStream.locals;
                        int i = 0;
                        int max = locals.length;
                        while (i < max) {
                            LocalVariableBinding local = locals[i];
                            if (local != null && local.initializationCount > 0) {
                                if (local.initializationPCs[(local.initializationCount - 1 << 1) + 1] == oldPosition) {
                                    local.initializationPCs[(local.initializationCount - 1 << 1) + 1] = this.position;
                                }
                                if (local.initializationPCs[local.initializationCount - 1 << 1] == oldPosition) {
                                    local.initializationPCs[local.initializationCount - 1 << 1] = this.position;
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            int i = 0;
            while (i < this.forwardReferenceCount) {
                int offset = this.position - this.forwardReferences[i] + 1;
                if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                    throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE);
                }
                if (this.codeStream.wideMode) {
                    if (this.isWide) {
                        this.codeStream.writeSignedWord(this.forwardReferences[i], offset);
                    } else {
                        this.codeStream.writeSignedShort(this.forwardReferences[i], offset);
                    }
                } else {
                    this.codeStream.writeSignedShort(this.forwardReferences[i], offset);
                }
                ++i;
            }
            if (isOptimizedBranch) {
                i = 0;
                while (i < this.codeStream.countLabels) {
                    Label label = this.codeStream.labels[i];
                    if (oldPosition == label.position) {
                        label.position = this.position;
                        if (label instanceof CaseLabel) {
                            int offset = this.position - ((CaseLabel)label).instructionPosition;
                            int j = 0;
                            while (j < label.forwardReferenceCount) {
                                int forwardPosition = label.forwardReferences[j];
                                this.codeStream.writeSignedWord(forwardPosition, offset);
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < label.forwardReferenceCount) {
                                int forwardPosition = label.forwardReferences[j];
                                int offset = this.position - forwardPosition + 1;
                                if (Math.abs(offset) > Short.MAX_VALUE && !this.codeStream.wideMode) {
                                    throw new AbortMethod(CodeStream.RESTART_IN_WIDE_MODE);
                                }
                                if (this.codeStream.wideMode) {
                                    if (this.isWide) {
                                        this.codeStream.writeSignedWord(forwardPosition, offset);
                                    } else {
                                        this.codeStream.writeSignedShort(forwardPosition, offset);
                                    }
                                } else {
                                    this.codeStream.writeSignedShort(forwardPosition, offset);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public String toString() {
        String basic = this.getClass().getName();
        basic = basic.substring(basic.lastIndexOf(46) + 1);
        StringBuffer buffer = new StringBuffer(basic);
        buffer.append('@').append(Integer.toHexString(this.hashCode()));
        buffer.append("(position=").append(this.position);
        buffer.append(", forwards = [");
        int i = 0;
        while (i < this.forwardReferenceCount - 1) {
            buffer.append(String.valueOf(this.forwardReferences[i]) + ", ");
            ++i;
        }
        if (this.forwardReferenceCount >= 1) {
            buffer.append(this.forwardReferences[this.forwardReferenceCount - 1]);
        }
        buffer.append("] )");
        return buffer.toString();
    }

    public void resetStateForCodeGeneration() {
        this.position = -1;
        this.forwardReferenceCount = 0;
    }
}

