/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static ResourceBundle bundle;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final char[] DOUBLE_QUOTES;
    public static final char[] SINGLE_QUOTE;
    public String[] classpaths;
    public String destinationPath;
    public String[] encodings;
    public PrintWriter err;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public boolean generatePackagesStructure;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalWarningsCount;
    public long lineCount;
    public String log;
    public boolean noWarn = false;
    public Map options;
    public PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public boolean showProgress = false;
    public boolean systemExitWhenFinished = true;
    public long startTime;
    public boolean timing = false;
    public boolean verbose = false;

    static {
        Main.relocalize();
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished) {
        this.out = outWriter;
        this.err = errWriter;
        this.systemExitWhenFinished = systemExitWhenFinished;
        this.options = new CompilerOptions().getMap();
    }

    public static String bind(String id) {
        return Main.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Main.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Main.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block13: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException e) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            int length = message.length();
            int start = -1;
            int end = length;
            output = null;
            while ((end = message.indexOf(123, start)) > -1) {
                if (output == null) {
                    output = new StringBuffer(80);
                }
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(message.substring(end + 1, start));
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException nfe) {
                        String argId = message.substring(end + 1, start);
                        boolean done = false;
                        if (!id.equals(argId)) {
                            String argMessage = null;
                            try {
                                argMessage = bundle.getString(argId);
                                output.append(argMessage);
                                done = true;
                            }
                            catch (MissingResourceException missingResourceException) {
                                // empty catch block
                            }
                        }
                        if (done) continue;
                        output.append(message.substring(end + 1, start + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    continue;
                }
                output.append(message.substring(end, length));
                break block13;
            }
            if (output == null) {
                return message;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }

    public static boolean compile(String commandLine) {
        return Main.compile(commandLine, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String commandLine, PrintWriter outWriter, PrintWriter errWriter) {
        return new Main(outWriter, errWriter, false).compile(Main.tokenize(commandLine));
    }

    public static void main(String[] argv) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(argv);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String[] tokenize(String commandLine) {
        int count = 0;
        String[] arguments = new String[10];
        StringTokenizer tokenizer = new StringTokenizer(commandLine, " \"", true);
        String token = "";
        boolean insideQuotes = false;
        boolean startNewToken = true;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(" ")) {
                if (insideQuotes) {
                    int n = count - 1;
                    arguments[n] = String.valueOf(arguments[n]) + token;
                    startNewToken = false;
                    continue;
                }
                startNewToken = true;
                continue;
            }
            if (token.equals("\"")) {
                if (!insideQuotes && startNewToken) {
                    if (count == arguments.length) {
                        String[] stringArray = arguments;
                        arguments = new String[count * 2];
                        System.arraycopy(stringArray, 0, arguments, 0, count);
                    }
                    arguments[count++] = "";
                }
                insideQuotes = !insideQuotes;
                startNewToken = false;
                continue;
            }
            if (insideQuotes) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else if (token.length() > 0 && !startNewToken) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else {
                String trimmedToken;
                if (count == arguments.length) {
                    String[] stringArray = arguments;
                    arguments = new String[count * 2];
                    System.arraycopy(stringArray, 0, arguments, 0, count);
                }
                if ((trimmedToken = token.trim()).length() != 0) {
                    arguments[count++] = trimmedToken;
                }
            }
            startNewToken = false;
        }
        String[] stringArray = arguments;
        arguments = new String[count];
        System.arraycopy(stringArray, 0, arguments, 0, count);
        return arguments;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] argv) {
        try {
            try {
                this.configure(argv);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.out.println(Main.bind("progress.compiling"));
                    }
                    int i = 0;
                    while (true) {
                        if (i >= this.repetitions) {
                            if (!this.showProgress) break;
                            this.out.println();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.out.flush();
                            this.out.println(Main.bind("compile.repetition", String.valueOf(i + 1), String.valueOf(this.repetitions)));
                        }
                        this.performCompilation();
                        ++i;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.out.flush();
                    this.err.flush();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException e) {
                this.err.println(e.getMessage());
                this.err.println("------------------------");
                this.printUsage();
                if (this.systemExitWhenFinished) {
                    System.exit(-1);
                }
                Object var3_6 = null;
                this.out.flush();
                this.err.flush();
                if (this.log != null) {
                    this.err.close();
                }
                return false;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                if (this.systemExitWhenFinished) {
                    this.out.flush();
                    this.err.flush();
                    if (this.log != null) {
                        this.err.close();
                    }
                    System.exit(-1);
                }
                Object var3_7 = null;
                this.out.flush();
                this.err.flush();
                if (this.log != null) {
                    this.err.close();
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.err.close();
            }
            throw throwable;
        }
        {
            Object var3_9 = null;
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.err.close();
            }
            return this.globalErrorsCount == 0;
        }
    }

    public void configure(String[] argv) throws InvalidInputException {
        int i;
        if (argv == null || argv.length == 0) {
            this.printUsage();
            return;
        }
        boolean InsideClasspath = true;
        int InsideDestinationPath = 2;
        int TargetSetting = 4;
        int InsideLog = 8;
        int InsideRepetition = 16;
        int InsideSource = 32;
        int InsideDefaultEncoding = 64;
        int InsideBootClasspath = 128;
        boolean Default = false;
        String[] bootclasspaths = null;
        int DEFAULT_SIZE_CLASSPATH = 4;
        int pathCount = 0;
        int bootclasspathCount = 0;
        int index = -1;
        int filesCount = 0;
        int argCount = argv.length;
        int mode = 0;
        this.repetitions = 0;
        boolean printUsageRequired = false;
        boolean printVersionRequired = false;
        boolean didSpecifyCompliance = false;
        boolean didSpecifyDefaultEncoding = false;
        boolean didSpecifyTarget = false;
        boolean didSpecifyDeprecation = false;
        boolean didSpecifyWarnings = false;
        String customEncoding = null;
        String currentArg = "";
        boolean needExpansion = false;
        int i2 = 0;
        while (i2 < argCount) {
            if (argv[i2].startsWith("@")) {
                needExpansion = true;
                break;
            }
            ++i2;
        }
        String[] newCommandLineArgs = null;
        if (needExpansion) {
            newCommandLineArgs = new String[argCount];
            index = 0;
            i = 0;
            while (i < argCount) {
                String[] newArgs = null;
                String arg = argv[i].trim();
                if (arg.startsWith("@")) {
                    try {
                        String line;
                        LineNumberReader reader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(arg.substring(1)), null))));
                        StringBuffer buffer = new StringBuffer();
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line).append(" ");
                        }
                        newArgs = Main.tokenize(buffer.toString());
                    }
                    catch (IOException e) {
                        throw new InvalidInputException(Main.bind("configure.invalidexpansionargumentname", arg));
                    }
                }
                if (newArgs != null) {
                    int newCommandLineArgsLength = newCommandLineArgs.length;
                    int newArgsLength = newArgs.length;
                    String[] stringArray = newCommandLineArgs;
                    newCommandLineArgs = new String[newCommandLineArgsLength + newArgsLength - 1];
                    System.arraycopy(stringArray, 0, newCommandLineArgs, 0, index);
                    System.arraycopy(newArgs, 0, newCommandLineArgs, index, newArgsLength);
                    index += newArgsLength;
                } else {
                    newCommandLineArgs[index++] = arg;
                }
                ++i;
            }
            index = -1;
        } else {
            newCommandLineArgs = argv;
            i = 0;
            while (i < argCount) {
                newCommandLineArgs[i] = newCommandLineArgs[i].trim();
                ++i;
            }
        }
        argCount = newCommandLineArgs.length;
        while (++index < argCount) {
            File dir;
            if (customEncoding != null) {
                throw new InvalidInputException(Main.bind("configure.unexpectedCustomEncoding", currentArg, customEncoding));
            }
            currentArg = newCommandLineArgs[index];
            customEncoding = null;
            if (currentArg.endsWith("]")) {
                int encodingStart = currentArg.indexOf(91) + 1;
                int encodingEnd = currentArg.length() - 1;
                if (encodingStart >= 1) {
                    if (encodingStart < encodingEnd) {
                        customEncoding = currentArg.substring(encodingStart, encodingEnd);
                        try {
                            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), customEncoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", customEncoding));
                        }
                    }
                    currentArg = currentArg.substring(0, encodingStart - 1);
                }
            }
            if (currentArg.endsWith(".java")) {
                if (this.filenames == null) {
                    this.filenames = new String[argCount - index];
                    this.encodings = new String[argCount - index];
                } else if (filesCount == this.filenames.length) {
                    int length = this.filenames.length;
                    this.filenames = new String[length + argCount - index];
                    System.arraycopy(this.filenames, 0, this.filenames, 0, length);
                    this.encodings = new String[length + argCount - index];
                    System.arraycopy(this.encodings, 0, this.encodings, 0, length);
                }
                this.filenames[filesCount] = currentArg;
                this.encodings[filesCount++] = customEncoding;
                customEncoding = null;
                mode = 0;
                continue;
            }
            if (currentArg.equals("-log")) {
                if (this.log != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateLog", currentArg));
                }
                mode = 8;
                continue;
            }
            if (currentArg.equals("-repeat")) {
                if (this.repetitions > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateRepeat", currentArg));
                }
                mode = 16;
                continue;
            }
            if (currentArg.equals("-source")) {
                mode = 32;
                continue;
            }
            if (currentArg.equals("-encoding")) {
                mode = 64;
                continue;
            }
            if (currentArg.equals("-1.3")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-1.4")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-d")) {
                if (this.destinationPath != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateOutputPath", currentArg));
                }
                mode = 2;
                this.generatePackagesStructure = true;
                continue;
            }
            if (currentArg.equals("-classpath") || currentArg.equals("-cp")) {
                if (pathCount == 0) {
                    this.classpaths = new String[DEFAULT_SIZE_CLASSPATH];
                }
                mode = 1;
                continue;
            }
            if (currentArg.equals("-bootclasspath")) {
                if (bootclasspathCount > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateBootClasspath", currentArg));
                }
                bootclasspaths = new String[DEFAULT_SIZE_CLASSPATH];
                mode = 128;
                continue;
            }
            if (currentArg.equals("-progress")) {
                mode = 0;
                this.showProgress = true;
                continue;
            }
            if (currentArg.equals("-proceedOnError")) {
                mode = 0;
                this.proceedOnError = true;
                continue;
            }
            if (currentArg.equals("-time")) {
                mode = 0;
                this.timing = true;
                continue;
            }
            if (currentArg.equals("-version") || currentArg.equals("-v")) {
                this.printVersion();
                this.proceed = false;
                return;
            }
            if (currentArg.equals("-showversion")) {
                printVersionRequired = true;
                continue;
            }
            if ("-deprecation".equals(currentArg)) {
                didSpecifyDeprecation = true;
                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (currentArg.equals("-help") || currentArg.equals("-?")) {
                printUsageRequired = true;
                continue;
            }
            if (currentArg.equals("-noExit")) {
                mode = 0;
                this.systemExitWhenFinished = false;
                continue;
            }
            if (currentArg.equals("-verbose")) {
                mode = 0;
                this.verbose = true;
                continue;
            }
            if (currentArg.equals("-referenceInfo")) {
                mode = 0;
                this.produceRefInfo = true;
                continue;
            }
            if (currentArg.startsWith("-g")) {
                mode = 0;
                String debugOption = currentArg;
                int length = currentArg.length();
                if (length == 2) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    continue;
                }
                if (length > 3) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                    if (length == 7 && debugOption.equals("-g:none")) continue;
                    StringTokenizer tokenizer = new StringTokenizer(debugOption.substring(3, debugOption.length()), ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("vars")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            continue;
                        }
                        if (token.equals("lines")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            continue;
                        }
                        if (token.equals("source")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue;
                        }
                        throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
                    }
                    continue;
                }
                throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
            }
            if (currentArg.startsWith("-nowarn")) {
                this.disableWarnings();
                mode = 0;
                continue;
            }
            if (currentArg.startsWith("-warn")) {
                boolean isEnabling;
                int warnTokenStart;
                mode = 0;
                String warningOption = currentArg;
                int length = currentArg.length();
                if (length == 10 && warningOption.equals("-warn:none")) {
                    this.disableWarnings();
                    continue;
                }
                if (length < 6) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningConfiguration", warningOption));
                }
                switch (warningOption.charAt(6)) {
                    case '+': {
                        warnTokenStart = 7;
                        isEnabling = true;
                        break;
                    }
                    case '-': {
                        warnTokenStart = 7;
                        isEnabling = false;
                        break;
                    }
                    default: {
                        warnTokenStart = 6;
                        if (!didSpecifyWarnings) {
                            this.disableWarnings();
                        }
                        isEnabling = true;
                    }
                }
                StringTokenizer tokenizer = new StringTokenizer(warningOption.substring(warnTokenStart, warningOption.length()), ",");
                int tokenCounter = 0;
                if (didSpecifyDeprecation) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                }
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ++tokenCounter;
                    if (token.equals("constructorName")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("pkgDefaultMethod") || token.equals("packageDefaultMethod")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("maskedCatchBlock") || token.equals("maskedCatchBlocks")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("deprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                        continue;
                    }
                    if (token.equals("allDeprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", isEnabling ? "enabled" : "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", isEnabling ? "enabled" : "disabled");
                        continue;
                    }
                    if (token.equals("unusedLocal") || token.equals("unusedLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedArgument") || token.equals("unusedArguments")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedImport") || token.equals("unusedImports")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedPrivate")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("localHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("fieldHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("specialParamHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", isEnabling ? "enabled" : "disabled");
                        continue;
                    }
                    if (token.equals("conditionAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("syntheticAccess")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("nls")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("staticReceiver")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("indirectStatic")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("noEffectAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("intfNonInherited") || token.equals("interfaceNonInherited")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("charConcat") || token.equals("noImplicitStringConversion")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("semicolon")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.superfluousSemicolon", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("emptyBlock")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("uselessTypeCheck")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("javadoc")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", isEnabling ? "enabled" : "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", isEnabling ? "private" : "public");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", isEnabling ? "private" : "public");
                        continue;
                    }
                    if (token.equals("allJavadoc")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", isEnabling ? "enabled" : "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", isEnabling ? "private" : "public");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", isEnabling ? "private" : "public");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.startsWith("tasks")) {
                        String taskTags = "";
                        int start = token.indexOf(40);
                        int end = token.indexOf(41);
                        if (start >= 0 && end >= 0 && start < end) {
                            taskTags = token.substring(start + 1, end).trim();
                            taskTags = taskTags.replace('|', ',');
                        }
                        if (taskTags.length() == 0) {
                            throw new InvalidInputException(Main.bind("configure.invalidTaskTag", token));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.taskTags", isEnabling ? taskTags : "");
                        continue;
                    }
                    if (token.equals("assertIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("finally")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedThrown")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unqualifiedField")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    throw new InvalidInputException(Main.bind("configure.invalidWarning", token));
                }
                if (tokenCounter == 0) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningOption", currentArg));
                }
                didSpecifyWarnings = true;
                continue;
            }
            if (currentArg.equals("-target")) {
                mode = 4;
                continue;
            }
            if (currentArg.equals("-preserveAllLocals")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                continue;
            }
            if (mode == 4) {
                didSpecifyTarget = true;
                if (currentArg.equals("1.1")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                } else if (currentArg.equals("1.2")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    if (didSpecifyCompliance && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) <= 0x2F0000L) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                } else {
                    throw new InvalidInputException(Main.bind("configure.targetJDK", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 8) {
                this.log = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 16) {
                try {
                    this.repetitions = Integer.parseInt(currentArg);
                    if (this.repetitions <= 0) {
                        throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                    }
                }
                catch (NumberFormatException e) {
                    throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 32) {
                if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                } else {
                    throw new InvalidInputException(Main.bind("configure.source", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 64) {
                if (didSpecifyDefaultEncoding) {
                    throw new InvalidInputException(Main.bind("configure.duplicateDefaultEncoding", currentArg));
                }
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), currentArg);
                }
                catch (UnsupportedEncodingException e) {
                    throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", currentArg));
                }
                this.options.put("org.eclipse.jdt.core.encoding", currentArg);
                didSpecifyDefaultEncoding = true;
                mode = 0;
                continue;
            }
            if (mode == 2) {
                this.destinationPath = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 1) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    int length = this.classpaths.length;
                    if (length <= pathCount) {
                        this.classpaths = new String[length * 2];
                        System.arraycopy(this.classpaths, 0, this.classpaths, 0, length);
                    }
                    this.classpaths[pathCount++] = tokenizer.nextToken();
                }
                mode = 0;
                continue;
            }
            if (mode == 128) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    int length = bootclasspaths.length;
                    if (length <= bootclasspathCount) {
                        String[] stringArray = bootclasspaths;
                        bootclasspaths = new String[length * 2];
                        System.arraycopy(stringArray, 0, bootclasspaths, 0, length);
                    }
                    bootclasspaths[bootclasspathCount++] = tokenizer.nextToken();
                }
                mode = 0;
                continue;
            }
            if ((currentArg = currentArg.replace('/', File.separatorChar)).endsWith(File.separator)) {
                currentArg = currentArg.substring(0, currentArg.length() - File.separator.length());
            }
            if (!(dir = new File(currentArg)).isDirectory()) {
                throw new InvalidInputException(Main.bind("configure.directoryNotExist", currentArg));
            }
            FileFinder finder = new FileFinder();
            try {
                finder.find(dir, ".JAVA", this.verbose);
            }
            catch (Exception e) {
                throw new InvalidInputException(Main.bind("configure.IOError", currentArg));
            }
            if (this.filenames != null) {
                String[] results = finder.resultFiles;
                int length = results.length;
                this.filenames = new String[length + filesCount];
                System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
                this.encodings = new String[length + filesCount];
                System.arraycopy(this.encodings, 0, this.encodings, 0, filesCount);
                System.arraycopy(results, 0, this.filenames, filesCount, length);
                int i3 = 0;
                while (i3 < length) {
                    this.encodings[filesCount + i3] = customEncoding;
                    ++i3;
                }
                filesCount += length;
                customEncoding = null;
            } else {
                this.filenames = finder.resultFiles;
                filesCount = this.filenames.length;
                this.encodings = new String[filesCount];
                int i4 = 0;
                while (i4 < filesCount) {
                    this.encodings[i4] = customEncoding;
                    ++i4;
                }
                customEncoding = null;
            }
            mode = 0;
        }
        if (printUsageRequired || this.hasNoFiles(filesCount)) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (printVersionRequired) {
            this.printVersion();
        }
        if (filesCount != 0) {
            this.filenames = new String[filesCount];
            System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
        }
        if (pathCount == 0) {
            String classProp = System.getProperty("java.class.path");
            if (classProp == null || classProp.length() == 0) {
                this.err.println(Main.bind("configure.noClasspath"));
                classProp = System.getProperty("user.dir");
            }
            StringTokenizer tokenizer = new StringTokenizer(classProp, File.pathSeparator);
            this.classpaths = new String[tokenizer.countTokens() + 1];
            while (tokenizer.hasMoreTokens()) {
                this.classpaths[pathCount++] = tokenizer.nextToken();
            }
            this.classpaths[pathCount++] = System.getProperty("user.dir");
        }
        if (bootclasspathCount == 0) {
            String javaversion = System.getProperty("java.version");
            if (javaversion != null && javaversion.equalsIgnoreCase("1.1.8")) {
                this.err.println(Main.bind("configure.requiresJDK1.2orAbove"));
                this.proceed = false;
                return;
            }
            String javaVMName = System.getProperty("java.vm.name");
            if (javaVMName != null && javaVMName.equalsIgnoreCase("J9")) {
                File javaHomeFile;
                String javaHome = System.getProperty("java.home");
                if (javaHome != null && (javaHomeFile = new File(javaHome)).exists()) {
                    try {
                        javaHomeFile = new File(javaHomeFile.getCanonicalPath());
                        File defaultLibrary = new File(javaHomeFile, "lib" + File.separator + "jclMax" + File.separator + "classes.zip");
                        File locales = new File(javaHomeFile, "lib" + File.separator + "jclMax" + File.separator + "locale.zip");
                        File charconv = new File(javaHomeFile, "lib" + File.separator + "charconv.zip");
                        bootclasspaths = new String[]{defaultLibrary.getAbsolutePath(), locales.getAbsolutePath(), charconv.getAbsolutePath()};
                        bootclasspathCount = 3;
                    }
                    catch (IOException e) {}
                }
            } else {
                File javaHomeFile;
                String javaHome = System.getProperty("java.home");
                if (javaHome != null && (javaHomeFile = new File(javaHome)).exists()) {
                    try {
                        javaHomeFile = new File(javaHomeFile.getCanonicalPath());
                        File[] systemLibrariesJars = this.getFilesFrom(new File(javaHomeFile, "lib"), ".jar");
                        int length = systemLibrariesJars.length;
                        bootclasspaths = new String[length];
                        int i5 = 0;
                        while (i5 < length) {
                            bootclasspaths[bootclasspathCount++] = systemLibrariesJars[i5].getAbsolutePath();
                            ++i5;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.log != null) {
            try {
                this.err = new PrintWriter(new FileOutputStream(this.log, false));
            }
            catch (IOException e) {
                throw new InvalidInputException(Main.bind("configure.cannotOpenLog"));
            }
        } else {
            this.showProgress = false;
        }
        if (this.classpaths == null) {
            this.classpaths = new String[0];
        }
        String[] newclasspaths = null;
        newclasspaths = pathCount + bootclasspathCount != this.classpaths.length ? new String[pathCount + bootclasspathCount] : this.classpaths;
        System.arraycopy(this.classpaths, 0, newclasspaths, bootclasspathCount, pathCount);
        if (bootclasspathCount != 0) {
            System.arraycopy(bootclasspaths, 0, newclasspaths, 0, bootclasspathCount);
        }
        this.classpaths = newclasspaths;
        int i6 = 0;
        int max = this.classpaths.length;
        while (i6 < max) {
            File file = new File(this.classpaths[i6]);
            if (!file.exists()) {
                this.out.println(Main.bind("configure.incorrectClasspath", this.classpaths[i6]));
            }
            ++i6;
        }
        if (this.destinationPath == null) {
            this.generatePackagesStructure = false;
        } else if ("none".equals(this.destinationPath)) {
            this.destinationPath = null;
        }
        if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.source")) >= 0x300000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) < 0x300000L && didSpecifyTarget) {
            throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource14", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")));
        }
        if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x300000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) >= 0x300000L && didSpecifyTarget) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
            if (!didSpecifyCompliance) {
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            }
            if (!didSpecifyTarget) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            }
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4") && !this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4")) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
        }
        if (!didSpecifyTarget) {
            if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.3")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4")) {
                if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            }
        }
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
    }

    private boolean hasNoFiles(int filesCount) {
        return false;
    }

    private void disableWarnings() {
        Object[] entries = this.options.entrySet().toArray();
        int i = 0;
        int max = entries.length;
        while (i < max) {
            Map.Entry entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++i;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(CharOperation.subarray(fileName, 0, lastIndex));
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int unitLineCount = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)unitLineCount;
                    this.lineDelta += unitLineCount;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.out.print('.');
                        this.lineDelta = 0;
                    }
                }
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    IProblem[] problems = compilationResult.getAllProblems();
                    int count = problems.length;
                    int localErrorCount = 0;
                    char[] unitSource = compilationResult.compilationUnit.getContents();
                    int i = 0;
                    while (i < count) {
                        if (problems[i] != null) {
                            ++Main.this.globalProblemsCount;
                            if (localErrorCount == 0) {
                                Main.this.err.println("----------");
                            }
                            Main.this.err.print(String.valueOf(Main.this.globalProblemsCount) + ". " + (problems[i].isError() ? Main.bind("requestor.error") : Main.bind("requestor.warning")));
                            if (problems[i].isError()) {
                                ++Main.this.globalErrorsCount;
                            } else {
                                ++Main.this.globalWarningsCount;
                            }
                            Main.this.err.print(" ");
                            Main.this.err.print(Main.bind("requestor.in", new String(problems[i].getOriginatingFileName())));
                            try {
                                Main.this.err.println(((DefaultProblem)problems[i]).errorReportSource(unitSource));
                                Main.this.err.println(problems[i].getMessage());
                            }
                            catch (Exception e) {
                                Main.this.err.println(Main.bind("requestor.notRetrieveErrorMessage", problems[i].toString()));
                            }
                            Main.this.err.println("----------");
                            if (problems[i].isError()) {
                                ++localErrorCount;
                            }
                        }
                        ++i;
                    }
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && localErrorCount > 0) {
                        Main.this.printStats();
                        Main.this.err.flush();
                        Main.this.out.flush();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int fileCount = this.filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        HashtableOfObject knownFileNames = new HashtableOfObject(fileCount);
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int i = 0;
        while (i < fileCount) {
            char[] charName = this.filenames[i].toCharArray();
            if (knownFileNames.get(charName) != null) {
                throw new InvalidInputException(Main.bind("unit.more", this.filenames[i]));
            }
            knownFileNames.put(charName, charName);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new InvalidInputException(Main.bind("unit.missing", this.filenames[i]));
            }
            String encoding = this.encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, this.filenames[i], encoding);
            ++i;
        }
        return units;
    }

    private File[] getFilesFrom(File f, final String extension) {
        return f.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public FileSystem getLibraryAccess() {
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(this.classpaths, this.filenames, defaultEncoding);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public void outputClassFiles(CompilationResult unitResult) {
        block6: {
            Enumeration classFiles;
            block7: {
                if (unitResult == null || unitResult.hasErrors() && !this.proceedOnError) break block6;
                classFiles = unitResult.compiledTypes.elements();
                if (this.generatePackagesStructure) break block7;
                while (classFiles.hasMoreElements()) {
                    this.destinationPath = this.extractDestinationPathFromSourceFile(unitResult);
                    ClassFile classFile = (ClassFile)classFiles.nextElement();
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                    CharOperation.replace(relativeName, '/', File.separatorChar);
                    try {
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, new String(relativeName), classFile.getBytes());
                    }
                    catch (IOException e) {
                        String fileName = String.valueOf(this.destinationPath) + new String(relativeName);
                        e.printStackTrace();
                        this.err.println(Main.bind("output.noClassFileCreated", fileName));
                    }
                    ++this.exportedClassFilesCounter;
                }
                break block6;
            }
            if (this.destinationPath == null) break block6;
            while (classFiles.hasMoreElements()) {
                ClassFile classFile = (ClassFile)classFiles.nextElement();
                char[] filename = classFile.fileName();
                int length = filename.length;
                char[] relativeName = new char[length + 6];
                System.arraycopy(filename, 0, relativeName, 0, length);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                CharOperation.replace(relativeName, '/', File.separatorChar);
                try {
                    ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, new String(relativeName), classFile.getBytes());
                }
                catch (IOException e) {
                    String fileName = String.valueOf(this.destinationPath) + new String(relativeName);
                    e.printStackTrace();
                    this.err.println(Main.bind("output.noClassFileCreated", fileName));
                }
                ++this.exportedClassFilesCounter;
            }
        }
    }

    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem environment = this.getLibraryAccess();
        Compiler batchCompiler = new Compiler(environment, this.getHandlingPolicy(), this.options, this.getBatchRequestor(), this.getProblemFactory());
        CompilerOptions compilerOptions = batchCompiler.options;
        compilerOptions.setVerboseMode(this.verbose);
        compilerOptions.produceReferenceInfo(this.produceRefInfo);
        batchCompiler.compile(this.getCompilationUnits());
        this.printStats();
        environment.cleanup();
    }

    public void printStats() {
        if (this.timing) {
            long time = System.currentTimeMillis() - this.startTime;
            if (this.lineCount != 0L) {
                this.out.println(Main.bind("compile.instantTime", new String[]{String.valueOf(this.lineCount), String.valueOf(time), String.valueOf((double)((int)((double)this.lineCount * 10000.0 / (double)time)) / 10.0)}));
            } else {
                this.out.println(Main.bind("compile.totalTime", String.valueOf(time)));
            }
        }
        if (this.globalProblemsCount > 0) {
            if (this.globalProblemsCount == 1) {
                this.err.print(Main.bind("compile.oneProblem"));
            } else {
                this.err.print(Main.bind("compile.severalProblems", String.valueOf(this.globalProblemsCount)));
            }
            this.err.print(" (");
            if (this.globalErrorsCount > 0) {
                if (this.globalErrorsCount == 1) {
                    this.err.print(Main.bind("compile.oneError"));
                } else {
                    this.err.print(Main.bind("compile.severalErrors", String.valueOf(this.globalErrorsCount)));
                }
            }
            if (this.globalWarningsCount > 0) {
                if (this.globalErrorsCount > 0) {
                    this.err.print(", ");
                }
                if (this.globalWarningsCount == 1) {
                    this.err.print(Main.bind("compile.oneWarning"));
                } else {
                    this.err.print(Main.bind("compile.severalWarnings", String.valueOf(this.globalWarningsCount)));
                }
            }
            this.err.println(")");
        }
        if (this.exportedClassFilesCounter != 0 && (this.showProgress || this.timing || this.verbose)) {
            if (this.exportedClassFilesCounter == 1) {
                this.out.println(Main.bind("compile.oneClassFileGenerated"));
            } else {
                this.out.println(Main.bind("compile.severalClassFilesGenerated", String.valueOf(this.exportedClassFilesCounter)));
            }
        }
    }

    public void printUsage() {
        this.out.println(Main.bind("misc.usage"));
        this.out.flush();
        this.err.flush();
    }

    public void printVersion() {
        this.out.println(Main.bind("misc.version"));
        this.out.flush();
        this.err.flush();
    }
}

