/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public Label breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int caseCount = 0;
    public int blockStart;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
        this.breakLabel = new Label();
        SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
        FlowInfo caseInits = FlowInfo.DEAD_END;
        this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        int caseIndex = 0;
        if (this.statements != null) {
            boolean didAlreadyComplain = false;
            int i = 0;
            int max = this.statements.length;
            while (i < max) {
                Statement statement = this.statements[i];
                if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                    ++caseIndex;
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                } else if (statement == this.defaultCase) {
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                }
                if (!statement.complainIfUnreachable(caseInits, this.scope, didAlreadyComplain)) {
                    caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                } else {
                    didAlreadyComplain = true;
                }
                ++i;
            }
        }
        if (this.defaultCase == null) {
            flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            return flowInfo;
        }
        UnconditionalFlowInfo mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        int[] sortedIndexes = new int[this.caseCount];
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.breakLabel.codeStream = codeStream;
        CaseLabel[] caseLabels = new CaseLabel[this.caseCount];
        int[] constants = new int[this.caseCount];
        boolean needSwitch = this.caseCount != 0;
        int i = 0;
        while (i < this.caseCount) {
            constants[i] = this.cases[i].constantExpression.constant.intValue();
            this.cases[i].targetLabel = caseLabels[i] = new CaseLabel(codeStream);
            ++i;
        }
        i = 0;
        while (i < this.caseCount) {
            sortedIndexes[i] = i;
            ++i;
        }
        int[] localKeysCopy = new int[this.caseCount];
        System.arraycopy(constants, 0, localKeysCopy, 0, this.caseCount);
        CodeStream.sort(localKeysCopy, 0, this.caseCount - 1, sortedIndexes);
        CaseLabel defaultLabel = new CaseLabel(codeStream);
        if (this.defaultCase != null) {
            this.defaultCase.targetLabel = defaultLabel;
        }
        this.expression.generateCode(currentScope, codeStream, needSwitch);
        if (needSwitch) {
            int max = localKeysCopy[this.caseCount - 1];
            int min = localKeysCopy[0];
            if ((long)((double)this.caseCount * 2.5) > (long)max - (long)min) {
                if (max > 0x7FFF0000 && currentScope.environment().options.complianceLevel < 0x300000L) {
                    codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
                } else {
                    codeStream.tableswitch(defaultLabel, min, max, constants, sortedIndexes, caseLabels);
                }
            } else {
                codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
            }
            codeStream.updateLastRecordedEndPC(codeStream.position);
        }
        int caseIndex = 0;
        if (this.statements != null) {
            int i2 = 0;
            int maxCases = this.statements.length;
            while (i2 < maxCases) {
                Statement statement = this.statements[i2];
                if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                    if (this.preSwitchInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        ++caseIndex;
                    }
                } else if (statement == this.defaultCase && this.preSwitchInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                }
                statement.generateCode(this.scope, codeStream);
                ++i2;
            }
        }
        this.breakLabel.place();
        if (this.defaultCase == null) {
            defaultLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        if (this.scope != currentScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(indent, output);
                } else {
                    this.statements[i].printStatement(indent + 2, output);
                }
                ++i;
            }
        }
        output.append("\n");
        return ASTNode.printIndent(indent, output).append('}');
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope upperScope) {
        TypeBinding testType = this.expression.resolveType(upperScope);
        if (testType == null) {
            return;
        }
        this.expression.implicitWidening(testType, testType);
        if (!this.expression.isConstantValueOfTypeAssignableToType(testType, BaseTypes.IntBinding) && !testType.isCompatibleWith(BaseTypes.IntBinding)) {
            upperScope.problemReporter().incorrectSwitchType(this.expression, testType);
            return;
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope);
            int length = this.statements.length;
            this.cases = new CaseStatement[length];
            int[] casesValues = new int[length];
            CaseStatement[] duplicateCaseStatements = null;
            int duplicateCaseStatementsCounter = 0;
            int counter = 0;
            int i = 0;
            while (i < length) {
                Statement statement = this.statements[i];
                Constant constant = statement.resolveCase(this.scope, testType, this);
                if (constant != null && constant != ASTNode.NotAConstant) {
                    int key = constant.intValue();
                    int j = 0;
                    while (j < counter) {
                        if (casesValues[j] == key) {
                            CaseStatement currentCaseStatement = (CaseStatement)statement;
                            if (duplicateCaseStatements == null) {
                                this.scope.problemReporter().duplicateCase(this.cases[j]);
                                this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                duplicateCaseStatements = new CaseStatement[length];
                                duplicateCaseStatements[duplicateCaseStatementsCounter++] = this.cases[j];
                                duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                            } else {
                                boolean found = false;
                                int k = 2;
                                while (k < duplicateCaseStatementsCounter) {
                                    if (duplicateCaseStatements[k] == statement) {
                                        found = true;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!found) {
                                    this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                    duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                }
                            }
                        }
                        ++j;
                    }
                    casesValues[counter++] = key;
                }
                ++i;
            }
        } else if ((this.bits & 8) != 0) {
            upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.breakLabel.hasForwardReferences()) {
            label.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

