/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Statement;

public class TryStatement
extends Statement {
    private Block body = null;
    private ASTNode.NodeList catchClauses;
    private Block optionalFinallyBody;
    static /* synthetic */ Class class$0;

    TryStatement(AST ast) {
        super(ast);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CatchClause");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.catchClauses = new ASTNode.NodeList(true, clazz);
        this.optionalFinallyBody = null;
    }

    public int getNodeType() {
        return 54;
    }

    ASTNode clone(AST target) {
        TryStatement result = new TryStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setBody((Block)this.getBody().clone(target));
        result.catchClauses().addAll(ASTNode.copySubtrees(target, this.catchClauses()));
        result.setFinally((Block)ASTNode.copySubtree(target, this.getFinally()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getBody());
            this.acceptChildren(visitor, this.catchClauses);
            this.acceptChild(visitor, this.getFinally());
        }
        visitor.endVisit(this);
    }

    public Block getBody() {
        if (this.body == null) {
            long count = this.getAST().modificationCount();
            this.setBody(new Block(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.body, body, true);
        this.body = body;
    }

    public List catchClauses() {
        return this.catchClauses;
    }

    public Block getFinally() {
        return this.optionalFinallyBody;
    }

    public void setFinally(Block block) {
        this.replaceChild(this.optionalFinallyBody, block, true);
        this.optionalFinallyBody = block;
    }

    int memSize() {
        return super.memSize() + 12;
    }

    int treeSize() {
        return this.memSize() + (this.body == null ? 0 : this.getBody().treeSize()) + this.catchClauses.listSize() + (this.optionalFinallyBody == null ? 0 : this.getFinally().treeSize());
    }
}

