/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.HashMap;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;

public class ProjectDescription
extends ModelObject
implements IProjectDescription {
    private static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ICommand[] EMPTY_COMMAND_ARRAY = new ICommand[0];
    protected IPath location = null;
    protected IProject[] projects = EMPTY_PROJECT_ARRAY;
    protected String[] natures = EMPTY_STRING_ARRAY;
    protected ICommand[] buildSpec = EMPTY_COMMAND_ARRAY;
    protected HashMap linkDescriptions = null;
    protected String comment = "";
    protected static boolean isWriting = false;
    protected static boolean isReading = false;

    public Object clone() {
        ProjectDescription clone = (ProjectDescription)super.clone();
        clone.linkDescriptions = null;
        return clone;
    }

    public ICommand[] getBuildSpec() {
        return this.getBuildSpec(true);
    }

    public ICommand[] getBuildSpec(boolean makeCopy) {
        if (this.buildSpec == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        return makeCopy ? (ICommand[])this.buildSpec.clone() : this.buildSpec;
    }

    public String getComment() {
        return this.comment;
    }

    public IPath getLocation() {
        return this.location;
    }

    public IPath getLinkLocation(String name) {
        if (this.linkDescriptions == null) {
            return null;
        }
        LinkDescription desc = (LinkDescription)this.linkDescriptions.get(name);
        return desc == null ? null : desc.getLocation();
    }

    public HashMap getLinks() {
        return this.linkDescriptions;
    }

    public String[] getNatureIds() {
        return this.getNatureIds(true);
    }

    public String[] getNatureIds(boolean makeCopy) {
        if (this.natures == null) {
            return EMPTY_STRING_ARRAY;
        }
        return makeCopy ? (String[])this.natures.clone() : this.natures;
    }

    public IProject[] getReferencedProjects() {
        return this.getReferencedProjects(true);
    }

    public IProject[] getReferencedProjects(boolean makeCopy) {
        if (this.projects == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        return makeCopy ? (IProject[])this.projects.clone() : this.projects;
    }

    public boolean hasNature(String natureID) {
        String[] natureIDs = this.getNatureIds(false);
        int i = 0;
        while (i < natureIDs.length) {
            if (natureIDs[i].equals(natureID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ICommand newCommand() {
        return new BuildCommand();
    }

    public void setBuildSpec(ICommand[] value) {
        Assert.isLegal(value != null);
        this.buildSpec = (ICommand[])value.clone();
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setLinkLocation(String name, LinkDescription description) {
        if (description != null) {
            if (this.linkDescriptions == null) {
                this.linkDescriptions = new HashMap(10);
            }
            this.linkDescriptions.put(name, description);
        } else if (this.linkDescriptions != null) {
            this.linkDescriptions.remove(name);
            if (this.linkDescriptions.size() == 0) {
                this.linkDescriptions = null;
            }
        }
    }

    public void setLinkDescriptions(HashMap linkDescriptions) {
        this.linkDescriptions = linkDescriptions;
    }

    public void setName(String value) {
        super.setName(value);
    }

    public void setNatureIds(String[] value) {
        this.natures = (String[])value.clone();
    }

    public void setReferencedProjects(IProject[] value) {
        Assert.isLegal(value != null);
        IProject[] result = new IProject[value.length];
        int count = 0;
        int i = 0;
        while (i < value.length) {
            IProject project = value[i];
            boolean found = false;
            int j = 0;
            while (j < value.length) {
                if (i != j && project.equals(value[j])) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                result[count++] = project;
            }
            ++i;
        }
        this.projects = new IProject[count];
        System.arraycopy(result, 0, this.projects, 0, count);
    }
}

