/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourceTree;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class Project
extends Container
implements IProject {
    protected Project(IPath path, Workspace container) {
        super(path, container);
    }

    protected MultiStatus basicSetDescription(ProjectDescription description) {
        String message = Policy.bind("resources.projectDesc");
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 568, message, null);
        ProjectDescription current = this.internalGetDescription();
        current.setComment(description.getComment());
        current.setBuildSpec(description.getBuildSpec(true));
        Object[] oldReferences = current.getReferencedProjects();
        Object[] newReferences = description.getReferencedProjects();
        if (!Arrays.equals(oldReferences, newReferences)) {
            current.setReferencedProjects(description.getReferencedProjects(true));
            this.workspace.flushBuildOrder();
        }
        this.workspace.getNatureManager().configureNatures(this, current, description, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int kind, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        block8: {
            block7: {
                try {
                    block10: {
                        block9: {
                            this.workspace.prepareOperation(this.workspace.getRoot(), monitor);
                            ResourceInfo info = this.getResourceInfo(false, false);
                            int flags = this.getFlags(info);
                            if (!this.exists(flags, true)) break block9;
                            if (this.isOpen(flags)) break block10;
                        }
                        Object var7_7 = null;
                        if (this.workspace.getElementTree().isImmutable()) {
                            this.workspace.newWorkingTree();
                        }
                        break block7;
                    }
                    this.workspace.beginOperation(true);
                    this.workspace.getBuildManager().build(this, kind, builderName, args, monitor);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (this.workspace.getElementTree().isImmutable()) {
                        this.workspace.newWorkingTree();
                    }
                    this.workspace.endOperation(this.workspace.getRoot(), false, null);
                    throw throwable;
                }
            }
            this.workspace.endOperation(this.workspace.getRoot(), false, null);
            return;
        }
        Object var7_9 = null;
        if (this.workspace.getElementTree().isImmutable()) {
            this.workspace.newWorkingTree();
        }
        this.workspace.endOperation(this.workspace.getRoot(), false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        block8: {
            block7: {
                try {
                    block10: {
                        block9: {
                            this.workspace.prepareOperation(this.workspace.getRoot(), monitor);
                            ResourceInfo info = this.getResourceInfo(false, false);
                            int flags = this.getFlags(info);
                            if (!this.exists(flags, true)) break block9;
                            if (this.isOpen(flags)) break block10;
                        }
                        Object var5_5 = null;
                        if (this.workspace.getElementTree().isImmutable()) {
                            this.workspace.newWorkingTree();
                        }
                        break block7;
                    }
                    this.workspace.beginOperation(true);
                    this.workspace.getBuildManager().build(this, trigger, monitor);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (this.workspace.getElementTree().isImmutable()) {
                        this.workspace.newWorkingTree();
                    }
                    this.workspace.endOperation(this.workspace.getRoot(), false, null);
                    throw throwable;
                }
            }
            this.workspace.endOperation(this.workspace.getRoot(), false, null);
            return;
        }
        Object var5_7 = null;
        if (this.workspace.getElementTree().isImmutable()) {
            this.workspace.newWorkingTree();
        }
        this.workspace.endOperation(this.workspace.getRoot(), false, null);
    }

    public void checkAccessible(int flags) throws CoreException {
        super.checkAccessible(flags);
        if (!this.isOpen(flags)) {
            String message = Policy.bind("resources.mustBeOpen", this.getFullPath().toString());
            throw new ResourceException(372, this.getFullPath(), message, null);
        }
    }

    protected void checkDescription(IProject project, IProjectDescription desc, boolean moving) throws CoreException {
        IPath location = desc.getLocation();
        if (location == null) {
            return;
        }
        String message = Policy.bind("resources.invalidProjDesc");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 77, message, null);
        status.merge(this.workspace.validateName(desc.getName(), 4));
        if (moving) {
            IPath sourceLocation = this.internalGetDescription().getLocation();
            if (sourceLocation == null || !sourceLocation.equals(location)) {
                status.merge(this.workspace.validateProjectLocation(project, location));
            }
        } else {
            status.merge(this.workspace.validateProjectLocation(project, location));
        }
        if (!status.isOK()) {
            throw new ResourceException(status);
        }
        desc.setLocation(new Path(location.toFile().getAbsolutePath()));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            block11: {
                block10: {
                    String msg = Policy.bind("resources.closing.1", this.getFullPath().toString());
                    monitor.beginTask(msg, Policy.totalWork);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(1, this));
                    this.workspace.prepareOperation(this, monitor);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    int flags = this.getFlags(info);
                    this.checkExists(flags, true);
                    monitor.subTask(msg);
                    if (this.isOpen(flags)) break block10;
                    Object var7_6 = null;
                    this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                    Object var9_9 = null;
                    monitor.done();
                    return;
                }
                this.workspace.beginOperation(true);
                this.workspace.flushBuildOrder();
                IProgressMonitor sub = Policy.subMonitorFor(monitor, Policy.opWork / 2, 2);
                IStatus saveStatus = this.workspace.getSaveManager().save(3, this, sub);
                this.internalClose();
                monitor.worked(Policy.opWork / 2);
                if (saveStatus == null || saveStatus.isOK()) break block11;
                throw new ResourceException(saveStatus);
            }
            Object var7_8 = null;
            this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            {
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                    throw throwable;
                }
            }
            Object var9_11 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
    }

    public void copy(IProjectDescription destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(destination);
        this.internalCopy(destination, updateFlags, monitor);
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (destination.segmentCount() == 1) {
            String projectName = destination.segment(0);
            IProjectDescription desc = this.getDescription();
            desc.setName(projectName);
            desc.setLocation(null);
            this.internalCopy(desc, updateFlags, monitor);
        } else {
            this.checkCopyRequirements(destination, 4, updateFlags);
        }
    }

    protected void copyMetaArea(IProject source, IProject destination, IProgressMonitor monitor) throws CoreException {
        File oldMetaArea = this.workspace.getMetaArea().locationFor(source).toFile();
        File newMetaArea = this.workspace.getMetaArea().locationFor(destination).toFile();
        this.getLocalManager().getStore().copy(oldMetaArea, newMetaArea, 2, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("resources.create"), Policy.totalWork);
            this.checkValidPath(this.path, 4, false);
            try {
                try {
                    this.workspace.prepareOperation(this, monitor);
                    this.checkDoesNotExist();
                    if (description != null) {
                        this.checkDescription(this, description, false);
                    }
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(8, this));
                    this.workspace.beginOperation(true);
                    this.workspace.createResource(this, false);
                    this.workspace.getMetaArea().create(this);
                    ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, true);
                    ProjectDescription desc = description == null ? new ProjectDescription() : (ProjectDescription)((ProjectDescription)description).clone();
                    desc.setName(this.getName());
                    info.setDescription(desc);
                    try {
                        if (this.getLocalManager().hasSavedProject(this)) {
                            this.updateDescription();
                            this.workspace.getMetaArea().writeLocation(this);
                        } else {
                            this.writeDescription(1);
                        }
                    }
                    catch (CoreException e) {
                        this.workspace.deleteResource(this);
                        throw e;
                    }
                    info.setModificationStamp(-1L);
                    this.workspace.getSaveManager().requestSnapshot();
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var6_9 = null;
                this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
            monitor.done();
            return;
        }
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        this.create(null, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags, monitor);
    }

    protected void fixupAfterMoveSource() throws CoreException {
        this.workspace.deleteResource(this);
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.delete(updateFlags |= deleteContent ? 4 : 8, monitor);
    }

    public IProjectDescription getDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return (IProjectDescription)((ProjectInfo)info).getDescription().clone();
    }

    public IProjectNature getNature(String natureID) throws CoreException {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        IProjectNature nature = info.getNature(natureID);
        if (nature == null) {
            if (!this.hasNature(natureID)) {
                return null;
            }
            nature = this.workspace.getNatureManager().createNature(this, natureID);
            info.setNature(natureID, nature);
        }
        return nature;
    }

    public IContainer getParent() {
        return this.workspace.getRoot();
    }

    public IPath getPluginWorkingLocation(IPluginDescriptor plugin) {
        if (!this.exists()) {
            return null;
        }
        IPath result = this.workspace.getMetaArea().getWorkingLocation(this, plugin);
        result.toFile().mkdirs();
        return result;
    }

    public IProject getProject() {
        return this;
    }

    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    public IPath getRawLocation() {
        ProjectDescription description = this.internalGetDescription();
        return description == null ? null : description.getLocation();
    }

    public IProject[] getReferencedProjects() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        return ((ProjectInfo)info).getDescription().getReferencedProjects(true);
    }

    public IProject[] getReferencingProjects() {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(projects.length);
        int i = 0;
        while (i < projects.length) {
            Project project = (Project)projects[i];
            if (project.isAccessible()) {
                IProject[] references = project.internalGetDescription().getReferencedProjects(false);
                int j = 0;
                while (j < references.length) {
                    if (references[j].equals(this)) {
                        result.add(projects[i]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public int getType() {
        return 4;
    }

    public boolean hasNature(String natureID) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        ProjectDescription desc = this.internalGetDescription();
        if (desc == null) {
            this.checkAccessible(-1);
        }
        return desc.hasNature(natureID);
    }

    protected void internalClose() throws CoreException {
        this.workspace.flushBuildOrder();
        this.getMarkerManager().removeMarkers(this, 2);
        IResource[] members = this.members(3);
        int i = 0;
        while (i < members.length) {
            Resource member = (Resource)members[i];
            this.workspace.deleteResource(member);
            ++i;
        }
        ResourceInfo info = this.getResourceInfo(false, true);
        info.clear(1);
        info.clearSessionProperties();
        info.setModificationStamp(-1L);
        info.setSyncInfo(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalCopy(IProjectDescription destDesc, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.copying", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            String destName = destDesc.getName();
            IPath destPath = new Path(destName).makeAbsolute();
            Project destination = (Project)this.workspace.getRoot().getProject(destName);
            ISchedulingRule rule = Rules.copyRule(this, destination);
            try {
                try {
                    this.workspace.prepareOperation(rule, monitor);
                    this.assertCopyRequirements(destPath, 4, updateFlags);
                    this.checkDescription(destination, destDesc, false);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(4, this, destination, updateFlags));
                    this.workspace.beginOperation(true);
                    this.getLocalManager().refresh(this, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                    this.getPropertyManager().closePropertyStore(this);
                    this.copyMetaArea(this, destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    this.internalCopyProjectOnly(destination, Policy.subMonitorFor(monitor, Policy.opWork * 5 / 100));
                    destination.internalSetDescription(destDesc, false);
                    message = Policy.bind("resources.copyProblem");
                    MultiStatus problems = new MultiStatus("org.eclipse.core.resources", 566, message, null);
                    IResource[] children = this.members(2);
                    int childCount = children.length;
                    int childWork = childCount > 1 ? Policy.opWork * 50 / 100 / (childCount - 1) : 0;
                    int i = 0;
                    while (true) {
                        if (i >= childCount) {
                            try {
                                destination.writeDescription(1);
                                break;
                            }
                            catch (CoreException e) {
                                try {
                                    destination.delete((updateFlags & 1) != 0, null);
                                    throw e;
                                }
                                catch (CoreException coreException) {}
                                throw e;
                            }
                        }
                        IResource child = children[i];
                        if (!this.isProjectDescriptionFile(child)) {
                            try {
                                child.copy(destPath.append(child.getName()), updateFlags, Policy.subMonitorFor(monitor, childWork));
                            }
                            catch (CoreException e) {
                                problems.merge(e.getStatus());
                            }
                        }
                        ++i;
                    }
                    monitor.worked(Policy.opWork * 10 / 100);
                    monitor.subTask(Policy.bind("resources.updating"));
                    this.getLocalManager().refresh(destination, 2, true, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                    if (!problems.isOK()) {
                        throw new ResourceException(problems);
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var16_20 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var18_23 = null;
            monitor.done();
            return;
        }
    }

    protected void internalCopyProjectOnly(IResource destination, IProgressMonitor monitor) throws CoreException {
        this.getPropertyManager().closePropertyStore(this);
        this.workspace.copyTree(this, destination.getFullPath(), 0, 0, false);
        this.getPropertyManager().copy(this, destination, 0);
        ProjectInfo info = (ProjectInfo)((Resource)destination).getResourceInfo(false, true);
        info.setBuilders(null);
        info.clearNatures();
        info.setMarkers(null);
        info.clearSessionProperties();
    }

    public ProjectDescription internalGetDescription() {
        ProjectInfo info = (ProjectInfo)this.getResourceInfo(false, false);
        if (info == null) {
            return null;
        }
        return info.getDescription();
    }

    void internalSetDescription(IProjectDescription value, boolean incrementContentId) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, true);
        ((ProjectInfo)info).setDescription((ProjectDescription)value);
        if (incrementContentId) {
            info.incrementContentId();
            if (info.getModificationStamp() != -1L) {
                this.workspace.updateModificationStamp(info);
            }
        }
    }

    public void internalSetLocal(boolean flag, int depth) throws CoreException {
        if (depth == 0) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(this, false);
        int i = 0;
        while (i < children.length) {
            ((Resource)children[i]).internalSetLocal(flag, depth);
            ++i;
        }
    }

    public boolean isAccessible() {
        return this.isOpen();
    }

    public boolean isLocal(int depth) {
        return this.isLocal(-1, depth);
    }

    public boolean isLocal(int flags, int depth) {
        if (depth == 0) {
            return true;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = this.getChildren(this, false);
        int i = 0;
        while (i < children.length) {
            if (!children[i].isLocal(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isNatureEnabled(String natureId) throws CoreException {
        this.checkAccessible(this.getFlags(this.getResourceInfo(false, false)));
        return this.workspace.getNatureManager().isNatureEnabled(this, natureId);
    }

    public boolean isOpen() {
        ResourceInfo info = this.getResourceInfo(false, false);
        return this.isOpen(this.getFlags(info));
    }

    public boolean isOpen(int flags) {
        return flags != -1 && ResourceInfo.isSet(flags, 1);
    }

    protected boolean isProjectDescriptionFile(IResource resource) {
        return resource.getType() == 1 && resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".project");
    }

    public void move(IProjectDescription destination, boolean force, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(destination);
        this.move(destination, force ? 1 : 0, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(description);
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.moving", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            IProject destination = this.workspace.getRoot().getProject(description.getName());
            ISchedulingRule rule = Rules.moveRule(this, destination);
            try {
                block13: {
                    try {
                        this.workspace.prepareOperation(rule, monitor);
                        if (!this.getName().equals(description.getName())) {
                            IPath destPath = Path.ROOT.append(description.getName());
                            this.assertMoveRequirements(destPath, 4, updateFlags);
                        }
                        this.checkDescription(destination, description, true);
                        this.workspace.beginOperation(true);
                        message = Policy.bind("resources.moveProblem");
                        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 4, message, null);
                        WorkManager workManager = this.workspace.getWorkManager();
                        ResourceTree tree = new ResourceTree(workManager.getLock(), status, updateFlags);
                        IMoveDeleteHook hook = this.workspace.getMoveDeleteHook();
                        this.workspace.broadcastEvent(LifecycleEvent.newEvent(64, this, destination, updateFlags));
                        int depth = 0;
                        try {
                            depth = workManager.beginUnprotected();
                            if (!hook.moveProject(tree, this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2))) {
                                tree.standardMoveProject(this, description, updateFlags, Policy.subMonitorFor(monitor, Policy.opWork / 2));
                            }
                            Object var12_15 = null;
                            workManager.endUnprotected(depth);
                            tree.makeInvalid();
                            if (tree.getStatus().isOK()) break block13;
                            throw new ResourceException(tree.getStatus());
                        }
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            workManager.endUnprotected(depth);
                            throw throwable;
                        }
                    }
                    catch (OperationCanceledException e) {
                        this.workspace.getWorkManager().operationCanceled();
                        throw e;
                    }
                }
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            Object var16_21 = null;
            monitor.done();
            return;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            monitor.done();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            ProjectInfo info;
            block12: {
                String msg = Policy.bind("resources.opening.1", this.getFullPath().toString());
                monitor.beginTask(msg, Policy.totalWork);
                monitor.subTask(msg);
                this.workspace.prepareOperation(this, monitor);
                info = (ProjectInfo)this.getResourceInfo(false, false);
                int flags = this.getFlags(info);
                this.checkExists(flags, true);
                if (!this.isOpen(flags)) break block12;
                Object var5_6 = null;
                this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                Object var7_9 = null;
                monitor.done();
                return;
            }
            this.workspace.beginOperation(true);
            this.workspace.flushBuildOrder();
            info = (ProjectInfo)this.getResourceInfo(false, true);
            info.set(1);
            if (info.isSet(16)) {
                this.workspace.getSaveManager().restore(this, Policy.subMonitorFor(monitor, Policy.opWork * 30 / 100));
            } else {
                info.set(16);
                this.reconcileLinks(info.getDescription());
                this.workspace.updateModificationStamp(info);
            }
            this.startup();
            monitor.worked(Policy.opWork * 20 / 100);
            this.refreshLocal(2, Policy.subMonitorFor(monitor, Policy.opWork * 50 / 100));
            Object var5_8 = null;
            this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            {
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                    throw throwable;
                }
            }
            Object var7_11 = null;
            monitor.done();
            return;
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            throw throwable;
        }
    }

    public IStatus reconcileLinks(ProjectDescription newDescription) {
        HashMap newLinks = newDescription.getLinks();
        IResource[] children = null;
        try {
            children = this.members();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String msg = Policy.bind("links.errorLinkReconcile");
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 76, msg, null);
        int i = 0;
        while (i < children.length) {
            Resource oldLink = (Resource)children[i];
            if (oldLink.isLinked()) {
                LinkDescription newLink = null;
                if (newLinks != null) {
                    newLink = (LinkDescription)newLinks.get(oldLink.getName());
                }
                if (newLink == null || !newLink.getLocation().equals(oldLink.getLocation()) || newLink.getType() != oldLink.getType()) {
                    try {
                        oldLink.delete(0, null);
                    }
                    catch (CoreException e) {
                        status.merge(e.getStatus());
                    }
                }
            }
            ++i;
        }
        if (newLinks == null) {
            return status;
        }
        Iterator it = newLinks.values().iterator();
        while (it.hasNext()) {
            LinkDescription newLink = (LinkDescription)it.next();
            IResource existing = this.findMember(newLink.getName());
            if (existing != null) {
                if (existing.isLinked()) continue;
                status.add(new ResourceStatus(367, existing.getFullPath(), msg));
                continue;
            }
            try {
                Resource toLink = newLink.getType() == 1 ? (Resource)((Object)this.getFile(newLink.getName())) : (Resource)((Object)this.getFolder(newLink.getName()));
                toLink.createLink(newLink.getLocation(), 16, null);
            }
            catch (CoreException e) {
                status.merge(e.getStatus());
            }
        }
        return status;
    }

    protected void renameMetaArea(IProject source, IProject destination, IProgressMonitor monitor) throws CoreException {
        File oldMetaArea = this.workspace.getMetaArea().locationFor(source).toFile();
        File newMetaArea = this.workspace.getMetaArea().locationFor(destination).toFile();
        this.getLocalManager().getStore().move(oldMetaArea, newMetaArea, false, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDescription(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("resources.setDesc"), Policy.totalWork);
            IWorkspaceRoot rule = this.workspace.getRoot();
            try {
                this.workspace.prepareOperation(rule, monitor);
                ResourceInfo info = this.getResourceInfo(false, false);
                this.checkAccessible(this.getFlags(info));
                this.checkDescription(this, description, false);
                boolean hadSavedDescription = true;
                if ((updateFlags & 1) == 0 && (hadSavedDescription = this.getLocalManager().hasSavedProject(this)) && !this.getLocalManager().isDescriptionSynchronized(this)) {
                    String message = Policy.bind("resources.projectDescSync", this.getName());
                    throw new ResourceException(274, this.getFullPath(), message, null);
                }
                if (!hadSavedDescription) {
                    hadSavedDescription = this.workspace.getMetaArea().hasSavedProject(this);
                }
                this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                this.workspace.beginOperation(true);
                MultiStatus status = this.basicSetDescription((ProjectDescription)description);
                if (hadSavedDescription && !status.isOK()) {
                    throw new CoreException(status);
                }
                this.writeDescription(this.internalGetDescription(), updateFlags);
                info = this.getResourceInfo(false, true);
                info.incrementContentId();
                this.workspace.updateModificationStamp(info);
                if (!hadSavedDescription) {
                    String msg = Policy.bind("resources.missingProjectMetaRepaired", this.getName());
                    status.merge(new ResourceStatus(234, this.getFullPath(), msg));
                }
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var9_12 = null;
                this.workspace.endOperation(rule, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_15 = null;
            monitor.done();
            return;
        }
    }

    public void setDescription(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        this.setDescription(description, 2, monitor);
    }

    protected void startup() throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        this.workspace.broadcastEvent(LifecycleEvent.newEvent(32, this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void touch(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resource.touch", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            try {
                try {
                    this.workspace.prepareOperation(this, monitor);
                    this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
                    this.workspace.beginOperation(true);
                    super.touch(Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.workspace.endOperation(this, true, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
            monitor.done();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateDescription() throws CoreException {
        if (ProjectDescription.isWriting) {
            return;
        }
        ProjectDescription.isReading = true;
        try {
            this.workspace.broadcastEvent(LifecycleEvent.newEvent(2, this));
            ProjectDescription description = this.getLocalManager().read(this, false);
            if (this.isOpen()) {
                this.reconcileLinks(description);
            }
            this.internalSetDescription(description, true);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ProjectDescription.isReading = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            ProjectDescription.isReading = false;
            return;
        }
    }

    public void writeDescription(int updateFlags) throws CoreException {
        this.writeDescription(this.internalGetDescription(), updateFlags);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDescription(IProjectDescription description, int updateFlags) throws CoreException {
        if (ProjectDescription.isReading) {
            return;
        }
        ProjectDescription.isWriting = true;
        try {
            this.getLocalManager().internalWrite(this, description, updateFlags);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ProjectDescription.isWriting = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            ProjectDescription.isWriting = false;
            return;
        }
    }
}

