/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ImplicitJobs {
    private final Map threadJobs = new HashMap(20);
    private ThreadJob jobCache = null;
    protected JobManager manager;

    ImplicitJobs(JobManager manager) {
        this.manager = manager;
    }

    void begin(ISchedulingRule rule, IProgressMonitor monitor) {
        ThreadJob threadJob;
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            Thread currentThread = Thread.currentThread();
            threadJob = (ThreadJob)this.threadJobs.get(currentThread);
            if (threadJob != null) {
                threadJob.push(rule);
                return;
            }
            if (rule == null) {
                return;
            }
            Job realJob = this.manager.currentJob();
            if (realJob != null && realJob.getRule() != null) {
                threadJob = this.newThreadJob(realJob.getRule());
            } else {
                threadJob = this.newThreadJob(rule);
                threadJob.acquireRule = true;
            }
            threadJob.setThread(currentThread);
            this.threadJobs.put(currentThread, threadJob);
            threadJob.push(rule);
        }
        if (threadJob.acquireRule) {
            if (this.manager.runNow(threadJob)) {
                this.manager.getLockManager().addLockThread(Thread.currentThread(), rule);
            } else {
                threadJob.joinRun(monitor);
            }
        }
    }

    synchronized void end(ISchedulingRule rule) {
        Thread currentThread = Thread.currentThread();
        ThreadJob threadJob = (ThreadJob)this.threadJobs.get(currentThread);
        if (threadJob == null) {
            Assert.isLegal(rule == null, "endRule without matching beginRule: " + rule);
        } else if (threadJob.pop(rule)) {
            this.threadJobs.remove(currentThread);
            if (threadJob.acquireRule) {
                this.manager.getLockManager().removeLockThread(Thread.currentThread(), threadJob.getRule());
            }
            if (threadJob.running) {
                this.manager.endJob(threadJob, Status.OK_STATUS, threadJob.queued);
            }
            this.recycle(threadJob);
        }
    }

    Job jobForThread(Thread thread) {
        return (Job)this.threadJobs.get(thread);
    }

    private ThreadJob newThreadJob(ISchedulingRule rule) {
        if (this.jobCache != null) {
            ThreadJob job = this.jobCache;
            job.setRule(rule);
            job.running = false;
            job.acquireRule = false;
            this.jobCache = null;
            return job;
        }
        return new ThreadJob(rule);
    }

    private void recycle(ThreadJob job) {
        if (this.jobCache == null && job.recycle()) {
            this.jobCache = job;
        }
    }

    class ThreadJob
    extends Job {
        private RuntimeException lastPush = null;
        protected boolean queued = false;
        private ISchedulingRule[] ruleStack;
        protected boolean running = false;
        private int top;
        protected boolean acquireRule = false;

        ThreadJob(ISchedulingRule rule) {
            super("Implicit job");
            this.setSystem(true);
            this.setPriority(10);
            this.setRule(rule);
            this.ruleStack = new ISchedulingRule[2];
            this.top = -1;
        }

        private void illegalPop(ISchedulingRule rule) {
            StringBuffer buf = new StringBuffer("Attempted to endRule: ");
            buf.append(rule);
            if (this.top >= 0 && this.top < this.ruleStack.length) {
                buf.append(", does not match most recent begin: ");
                buf.append(this.ruleStack[this.top]);
            } else if (this.top < 0) {
                buf.append(", but there was no matching beginRule");
            } else {
                buf.append(", but the rule stack was out of bounds: " + this.top);
            }
            buf.append(".  See log for trace information if rule tracing is enabled.");
            String msg = buf.toString();
            if (JobManager.DEBUG) {
                System.out.println(msg);
                RuntimeException t = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
                Status error = new Status(4, "org.eclipse.core.runtime", 1, msg, t);
                InternalPlatform.getDefault().log(error);
            }
            Assert.isLegal(false, msg);
        }

        private void illegalPush(ISchedulingRule pushRule, ISchedulingRule baseRule) {
            StringBuffer buf = new StringBuffer("Attempted to beginRule: ");
            buf.append(pushRule);
            buf.append(", does not match outer scope rule: ");
            buf.append(baseRule);
            String msg = buf.toString();
            if (JobManager.DEBUG) {
                System.out.println(msg);
                Status error = new Status(4, "org.eclipse.core.runtime", 1, msg, new IllegalArgumentException());
                InternalPlatform.getDefault().log(error);
            }
            Assert.isLegal(false, msg);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void joinRun(IProgressMonitor monitor) {
            block9: {
                Thread blocker;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.running = false;
                InternalJob blockingJob = ImplicitJobs.this.manager.findBlockingJob(this);
                Thread thread = blocker = blockingJob == null ? null : blockingJob.getThread();
                if (ImplicitJobs.this.manager.getLockManager().aboutToWait(blocker)) break block9;
                try {
                    this.reportBlocked(monitor, blockingJob);
                    this.queued = true;
                    this.schedule();
                    while (!this.running) {
                        if (this.isCanceled(monitor)) {
                            this.running = !this.cancel();
                            throw new OperationCanceledException();
                        }
                        blocker = ImplicitJobs.this.manager.getBlockingThread(this);
                        if (!ImplicitJobs.this.manager.getLockManager().aboutToWait(blocker)) {
                            try {
                                this.wait(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.reportUnblocked(monitor);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    this.reportUnblocked(monitor);
                }
            }
            ImplicitJobs.this.manager.getLockManager().aboutToRelease();
            this.running = true;
            this.setThread(Thread.currentThread());
        }

        private boolean isCanceled(IProgressMonitor monitor) {
            try {
                return monitor.isCanceled();
            }
            catch (RuntimeException e) {
                String msg = Policy.bind("jobs.internalError");
                Status status = new Status(4, "org.eclipse.core.runtime", 2, msg, e);
                InternalPlatform.getDefault().log(status);
                return false;
            }
        }

        boolean pop(ISchedulingRule rule) {
            if (this.top < 0 || this.ruleStack[this.top] != rule) {
                this.illegalPop(rule);
            }
            this.ruleStack[this.top--] = null;
            return this.top < 0;
        }

        void push(ISchedulingRule rule) {
            ISchedulingRule baseRule = this.getRule();
            if (++this.top >= this.ruleStack.length) {
                ISchedulingRule[] newStack = new ISchedulingRule[this.ruleStack.length * 2];
                System.arraycopy(this.ruleStack, 0, newStack, 0, this.ruleStack.length);
                this.ruleStack = newStack;
            }
            this.ruleStack[this.top] = rule;
            if (JobManager.DEBUG_BEGIN_END) {
                this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
            }
            if (baseRule != null && rule != null && !baseRule.contains(rule)) {
                this.illegalPush(rule, baseRule);
            }
        }

        public boolean recycle() {
            if (this.getState() != 0) {
                return false;
            }
            this.acquireRule = false;
            this.queued = false;
            this.running = false;
            this.setRule(null);
            this.setThread(null);
            if (this.ruleStack.length != 2) {
                this.ruleStack = new ISchedulingRule[2];
            } else {
                this.ruleStack[1] = null;
                this.ruleStack[0] = null;
            }
            this.top = -1;
            return true;
        }

        private void reportBlocked(IProgressMonitor monitor, InternalJob blockingJob) {
            ImplicitJobs.this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
            if (!(monitor instanceof IProgressMonitorWithBlocking)) {
                return;
            }
            String msg = blockingJob == null || blockingJob instanceof ThreadJob ? Policy.bind("jobs.blocked0") : Policy.bind("jobs.blocked1", blockingJob.getName());
            Status reason = new Status(1, "org.eclipse.core.runtime", 1, msg, null);
            ((IProgressMonitorWithBlocking)monitor).setBlocked(reason);
        }

        private void reportUnblocked(IProgressMonitor monitor) {
            if (this.running) {
                ImplicitJobs.this.manager.getLockManager().addLockThread(Thread.currentThread(), this.getRule());
                ImplicitJobs.this.manager.getLockManager().resumeSuspendedLocks(Thread.currentThread());
            } else {
                ImplicitJobs.this.manager.getLockManager().removeLockWaitThread(Thread.currentThread(), this.getRule());
            }
            if (monitor instanceof IProgressMonitorWithBlocking) {
                ((IProgressMonitorWithBlocking)monitor).clearBlocked();
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            ThreadJob threadJob = this;
            synchronized (threadJob) {
                this.running = true;
                this.notifyAll();
            }
            return Job.ASYNC_FINISH;
        }
    }
}

