/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.tools.ajdoc.Declaration;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.tools.ajdoc.SymbolManager;

class HtmlDecorator {
    static List visibleFileList = new ArrayList();
    static Hashtable declIDTable = null;
    static SymbolManager symbolManager = null;
    static File rootDir = null;

    HtmlDecorator() {
    }

    static void decorateHTMLFromInputFiles(Hashtable table, File newRootDir, SymbolManager sm, File[] inputFiles, String docModifier) throws IOException {
        rootDir = newRootDir;
        declIDTable = table;
        symbolManager = sm;
        int i = 0;
        while (i < inputFiles.length) {
            HtmlDecorator.decorateHTMLFromDecls(symbolManager.getDeclarations(inputFiles[i].getCanonicalPath()), rootDir.getCanonicalPath() + "/", docModifier, false);
            ++i;
        }
    }

    static void decorateHTMLFromDecls(Declaration[] decls, String base, String docModifier, boolean exceededNestingLevel) throws IOException {
        if (decls != null) {
            int i = 0;
            while (i < decls.length) {
                Declaration decl = decls[i];
                HtmlDecorator.decorateHTMLFromDecl(decl, base, docModifier, exceededNestingLevel);
                ++i;
            }
        }
    }

    static void decorateHTMLFromDecl(Declaration decl, String base, String docModifier, boolean exceededNestingLevel) throws IOException {
        boolean nestedClass = false;
        if (decl.isType()) {
            boolean decorateFile = true;
            if (docModifier.equals("private") || docModifier.equals("package") && decl.getModifiers().indexOf("private") == -1 || docModifier.equals("protected") && (decl.getModifiers().indexOf("protected") != -1 || decl.getModifiers().indexOf("public") != -1) || docModifier.equals("public") && decl.getModifiers().indexOf("public") != -1) {
                visibleFileList.add(decl.getSignature());
                String packageName = decl.getPackageName();
                String filename = "";
                if (packageName != null) {
                    int index1 = base.lastIndexOf("/");
                    int index2 = base.lastIndexOf(".");
                    String currFileClass = "";
                    if (index1 > -1 && index2 > 0 && index1 < index2) {
                        currFileClass = base.substring(index1 + 1, index2);
                    }
                    if (currFileClass.equals(decl.getDeclaringType())) {
                        nestedClass = true;
                        packageName = packageName.replace('.', '/');
                        String newBase = "";
                        if (base.lastIndexOf("/") > 0) {
                            newBase = base.substring(0, base.lastIndexOf("/"));
                        }
                        String signature = HtmlDecorator.constructNestedTypeName(decl.getNode());
                        filename = newBase + "/" + packageName + "/" + currFileClass + signature + ".html";
                    } else {
                        packageName = packageName.replace('.', '/');
                        filename = base + packageName + "/" + decl.getSignature() + ".html";
                    }
                } else {
                    filename = base + decl.getSignature() + ".html";
                }
                if (!exceededNestingLevel) {
                    HtmlDecorator.decorateHTMLFile(new File(filename));
                    HtmlDecorator.decorateHTMLFromDecls(decl.getDeclarations(), base + decl.getSignature() + ".", docModifier, nestedClass);
                } else {
                    System.out.println("Warning: can not generate documentation for nested inner class: " + decl.getSignature());
                }
            }
        }
    }

    private static String constructNestedTypeName(IProgramElement node) {
        if (node.getParent().getKind().isSourceFile()) {
            return node.getName();
        }
        String nodeName = "";
        if (node.getKind().isType()) {
            nodeName = nodeName + '.' + node.getName();
        }
        return HtmlDecorator.constructNestedTypeName(node.getParent()) + nodeName;
    }

    static void decorateHTMLFile(File file) throws IOException {
        System.out.println("> Decorating " + file.getCanonicalPath() + "...");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer fileContents = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            fileContents.append(line + "\n");
            line = reader.readLine();
        }
        boolean isSecond = false;
        int index = 0;
        while (true) {
            IProgramElement decl;
            String contents = fileContents.toString();
            int start = contents.indexOf("__AJDECLID:", index);
            int end = contents.indexOf(":__", index);
            if (start == -1) {
                decl = null;
            } else {
                if (end == -1) {
                    throw new Error("Malformed DeclID.");
                }
                String tid = contents.substring(start + "__AJDECLID:".length(), end);
                decl = (IProgramElement)declIDTable.get(tid);
                index = start;
            }
            if (decl == null) break;
            fileContents.delete(start, end + ":__".length());
            if (decl.getKind().isType()) {
                isSecond = true;
                HtmlDecorator.addAspectDocumentation(decl, fileContents, index);
                continue;
            }
            HtmlDecorator.decorateMemberDocumentation(decl, fileContents, index);
        }
        int classStartIndex = fileContents.toString().indexOf("<BR>\nClass");
        if (classStartIndex != -1 && fileContents.toString().indexOf("Advises:") != -1) {
            int classEndIndex = fileContents.toString().indexOf("</H2>", classStartIndex);
            if (classStartIndex != -1 && classEndIndex != -1) {
                String classLine = fileContents.toString().substring(classStartIndex, classEndIndex);
                String aspectLine = "<BR>\nAspect " + classLine.substring(11, classLine.length());
                fileContents.delete(classStartIndex, classEndIndex);
                fileContents.insert(classStartIndex, aspectLine);
            }
        }
        file.delete();
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(fileContents.toString().getBytes());
    }

    static void addAspectDocumentation(IProgramElement node, StringBuffer fileBuffer, int index) {
        ArrayList<IProgramElement> pointcuts = new ArrayList<IProgramElement>();
        ArrayList<IProgramElement> advice = new ArrayList<IProgramElement>();
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement member = (IProgramElement)it.next();
            if (member.getKind().equals(IProgramElement.Kind.POINTCUT)) {
                pointcuts.add(member);
                continue;
            }
            if (!member.getKind().equals(IProgramElement.Kind.ADVICE)) continue;
            advice.add(member);
        }
        if (pointcuts.size() > 0) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, pointcuts, "Pointcut Summary", index);
            HtmlDecorator.insertDeclarationsDetails(fileBuffer, pointcuts, "Pointcut Detail", index);
        }
        if (advice.size() > 0) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, advice, "Advice Summary", index);
            HtmlDecorator.insertDeclarationsDetails(fileBuffer, advice, "Advice Detail", index);
        }
    }

    static void insertDeclarationsSummary(StringBuffer fileBuffer, List decls, String kind, int index) {
        int insertIndex = HtmlDecorator.findSummaryIndex(fileBuffer, index);
        String tableHead = "<!-- ======== " + kind.toUpperCase() + " ======= -->\n\n" + "<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"1\"" + "CELLSPACING=\"0\"><TR><TD COLSPAN=2 BGCOLOR=\"#CCCCFF\">" + "<FONT SIZE=\"+2\"><B>" + kind + "</B></FONT></TD></TR>\n";
        fileBuffer.insert(insertIndex, tableHead);
        insertIndex += tableHead.length();
        int i = 0;
        while (i < decls.size()) {
            IProgramElement decl = (IProgramElement)decls.get(i);
            String comment = HtmlDecorator.generateSummaryComment(decl);
            String entry = "";
            if (kind.equals("Advice Summary")) {
                entry = entry + "<TR><TD><A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>" + HtmlDecorator.generateAdviceSignatures(decl) + "</TT></A><BR>&nbsp;";
                if (!comment.equals("")) {
                    entry = entry + comment + "<P>";
                }
                entry = entry + HtmlDecorator.generateAffects(decl, false) + "</TD>" + "</TR><TD>\n";
            } else if (kind.equals("Pointcut Summary")) {
                entry = entry + "<TR><TD WIDTH=\"1%\"><FONT SIZE=-1><TT>" + HtmlDecorator.genAccessibility(decl) + "</TT></FONT>" + "</TD>\n" + "<TD>" + "<TT><A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + decl.toLabelString() + "</A></TT><BR>&nbsp;";
                if (!comment.equals("")) {
                    entry = entry + comment + "<P>";
                }
                entry = entry + "</TR></TD>\n";
            } else if (kind.equals("Introduction Summary")) {
                entry = entry + "<TR><TD WIDTH=\"1%\"><FONT SIZE=-1><TT>" + decl.getModifiers() + "</TT></FONT>" + "</TD>" + "<TD>" + "<A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>introduction " + decl.toLabelString() + "</TT></A><P>" + HtmlDecorator.generateIntroductionSignatures(decl, false) + HtmlDecorator.generateAffects(decl, true);
            }
            fileBuffer.insert(insertIndex, entry);
            insertIndex += entry.length();
            ++i;
        }
        String tableTail = "</TABLE><P>&nbsp;\n";
        fileBuffer.insert(insertIndex, tableTail);
        insertIndex += tableTail.length();
    }

    private static String genAccessibility(IProgramElement decl) {
        if (decl.getAccessibility().equals(IProgramElement.Accessibility.PACKAGE)) {
            return "(package private)";
        }
        return decl.getAccessibility().toString();
    }

    static void insertDeclarationsDetails(StringBuffer fileBuffer, List decls, String kind, int index) {
        int insertIndex = HtmlDecorator.findDetailsIndex(fileBuffer, index);
        String detailsHeading = "<P>&nbsp;\n<!-- ======== " + kind.toUpperCase() + " SUMMARY ======= -->\n\n" + "<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">\n" + "<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n" + "<TD COLSPAN=1><FONT SIZE=\"+2\">\n" + "<B>" + kind + "</B></FONT></TD>\n" + "</TR>\n" + "</TABLE>";
        fileBuffer.insert(insertIndex, detailsHeading);
        insertIndex += detailsHeading.length();
        int i = 0;
        while (i < decls.size()) {
            IProgramElement decl = (IProgramElement)decls.get(i);
            String entry = "";
            entry = entry + "<A NAME=\"" + HtmlDecorator.generateHREFName(decl) + "\"><!-- --></A>\n";
            if (kind.equals("Advice Detail")) {
                entry = entry + "<H3>" + decl.getName() + "</H3><P>";
                entry = entry + "<TT>" + HtmlDecorator.generateAdviceSignatures(decl) + "</TT>\n" + "<P>" + HtmlDecorator.generateDetailsComment(decl) + "<P>" + HtmlDecorator.generateAffects(decl, false);
            } else if (kind.equals("Pointcut Detail")) {
                entry = entry + "<H3>" + decl.toLabelString() + "</H3><P>" + HtmlDecorator.generateDetailsComment(decl);
            } else if (kind.equals("Introduction Detail")) {
                entry = entry + "<H3>introduction " + decl.toLabelString() + "</H3><P>";
                entry = entry + HtmlDecorator.generateIntroductionSignatures(decl, true) + HtmlDecorator.generateAffects(decl, true) + HtmlDecorator.generateDetailsComment(decl);
            }
            entry = i != decls.size() - 1 ? entry + "<P><HR>\n" : entry + "<P>";
            fileBuffer.insert(insertIndex, entry);
            insertIndex += entry.length();
            ++i;
        }
    }

    static int findSummaryIndex(StringBuffer fileBuffer, int index) {
        int index2;
        String fbs = fileBuffer.toString();
        String MARKER_1 = "<!-- =========== FIELD SUMMARY =========== -->";
        String MARKER_2 = "<!-- ======== CONSTRUCTOR SUMMARY ======== -->";
        int index1 = fbs.indexOf(MARKER_1, index);
        if (index1 < (index2 = fbs.indexOf(MARKER_2, index))) {
            return index1;
        }
        return index2;
    }

    static int findDetailsIndex(StringBuffer fileBuffer, int index) {
        String fbs = fileBuffer.toString();
        String MARKER_1 = "<!-- ========= CONSTRUCTOR DETAIL ======== -->";
        String MARKER_2 = "<!-- ============ FIELD DETAIL =========== -->";
        String MARKER_3 = "<!-- ============ METHOD DETAIL ========== -->";
        int index1 = fbs.indexOf(MARKER_1, index);
        int index2 = fbs.indexOf(MARKER_2, index);
        int index3 = fbs.indexOf(MARKER_3, index);
        if (index1 < index2 && index1 < index3) {
            return index1;
        }
        if (index2 < index1 && index2 < index3) {
            return index2;
        }
        return index3;
    }

    static void decorateMemberDocumentation(IProgramElement node, StringBuffer fileContentsBuffer, int index) {
        List targets = StructureUtil.getTargets(node, IRelationship.Kind.ADVICE);
        if (targets != null && !targets.isEmpty()) {
            String prevName = "";
            String adviceDoc = "<TABLE WIDTH=\"100%\" BGCOLOR=#FFFFFF><TR><TD width=\"15%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>&nbsp;Advised&nbsp;by:</font></b></td><td>";
            String relativePackagePath = HtmlDecorator.getRelativePathFromHere(node.getPackageName().replace('.', '/') + "/");
            ArrayList<String> addedNames = new ArrayList<String>();
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                String currHandle = (String)it.next();
                IProgramElement currDecl = AsmManager.getDefault().getHierarchy().findElementForHandle(currHandle);
                String packagePath = "";
                if (currDecl.getPackageName() != null && !currDecl.getPackageName().equals("")) {
                    packagePath = currDecl.getPackageName().replace('.', '/') + "/";
                }
                String hrefName = "";
                String hrefLink = "";
                hrefLink = relativePackagePath + packagePath;
                if (currDecl.getPackageName() != null) {
                    hrefName = currDecl.getPackageName().replace('.', '/');
                }
                hrefName = hrefName + "/" + currDecl.getParent().toLinkLabelString() + "." + currDecl.getName();
                hrefLink = hrefLink + currDecl.getParent().toLinkLabelString() + ".html" + "#" + currDecl.toLabelString();
                if (addedNames.contains(hrefName)) continue;
                adviceDoc = adviceDoc + "<A HREF=\"" + hrefLink + "\"><tt>" + hrefName.replace('/', '.') + "</tt></A>";
                if (it.hasNext()) {
                    adviceDoc = adviceDoc + ", ";
                }
                addedNames.add(hrefName);
            }
            adviceDoc = adviceDoc + "</TR></TD></TABLE>\n";
            fileContentsBuffer.insert(index, adviceDoc);
        }
    }

    static String generateAffects(IProgramElement decl, boolean isIntroduction) {
        List targets = StructureUtil.getTargets(decl, IRelationship.Kind.ADVICE);
        if (targets == null) {
            return null;
        }
        ArrayList packageList = new ArrayList();
        String entry = "<TABLE WIDTH=\"100%\" BGCOLOR=#FFFFFF><TR><TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>&nbsp;Advises:</b></font></td><td>";
        String relativePackagePath = HtmlDecorator.getRelativePathFromHere(decl.getPackageName().replace('.', '/') + "/");
        ArrayList<String> addedNames = new ArrayList<String>();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            String currHandle = (String)it.next();
            IProgramElement currDecl = AsmManager.getDefault().getHierarchy().findElementForHandle(currHandle);
            if (currDecl.getKind().equals(IProgramElement.Kind.CODE)) {
                currDecl = currDecl.getParent();
            }
            if (currDecl == null || StructureUtil.isAnonymous(currDecl.getParent())) continue;
            String packagePath = "";
            if (currDecl.getPackageName() != null && !currDecl.getPackageName().equals("")) {
                packagePath = currDecl.getPackageName().replace('.', '/') + "/";
            }
            String typeSignature = HtmlDecorator.constructNestedTypeName(currDecl);
            String hrefName = packagePath + typeSignature;
            String hrefLink = relativePackagePath + packagePath + typeSignature + ".html";
            if (!currDecl.getKind().isType()) {
                hrefName = hrefName + '.' + currDecl.getName();
                hrefLink = hrefLink + "#" + currDecl.toLabelString();
            }
            if (addedNames.contains(hrefName)) continue;
            entry = entry + "<A HREF=\"" + hrefLink + "\"><tt>" + hrefName.replace('/', '.') + "</tt></A>";
            if (it.hasNext()) {
                entry = entry + ", ";
            }
            addedNames.add(hrefName);
        }
        entry = entry + "</B></FONT></TD></TR></TABLE>\n</TR></TD>\n";
        return entry;
    }

    private static String getRelativePathFromHere(String packagePath) {
        StringBuffer result = new StringBuffer("");
        if (packagePath != null && packagePath.indexOf("/") != -1) {
            StringTokenizer sTok = new StringTokenizer(packagePath, "/", false);
            while (sTok.hasMoreTokens()) {
                sTok.nextToken();
                result.append("../");
            }
        }
        return result.toString();
    }

    static String generateIntroductionSignatures(IProgramElement decl, boolean isDetails) {
        return "<not implemented>";
    }

    static String generateAdviceSignatures(IProgramElement decl) {
        return "<B>" + decl.toLabelString() + "</B>";
    }

    static String generateSummaryComment(IProgramElement decl) {
        String COMMENT_INDENT = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        String formattedComment = HtmlDecorator.getFormattedComment(decl);
        int periodIndex = formattedComment.indexOf(46);
        if (formattedComment.equals("")) {
            return "";
        }
        if (periodIndex != -1) {
            return COMMENT_INDENT + formattedComment.substring(0, periodIndex + 1);
        }
        return COMMENT_INDENT + formattedComment;
    }

    static String generateDetailsComment(IProgramElement decl) {
        return HtmlDecorator.getFormattedComment(decl);
    }

    static String generateHREFName(IProgramElement decl) {
        String hrefLink = decl.toLabelString();
        return hrefLink;
    }

    static String generateAffectsHREFLink(String declaringType) {
        String link = rootDir.getAbsolutePath() + "/" + declaringType + ".html";
        return link;
    }

    static String getFormattedComment(IProgramElement decl) {
        String comment = decl.getFormalComment();
        if (comment == null) {
            return "";
        }
        String formattedComment = "";
        int startIndex = comment.indexOf("/**");
        int endIndex = comment.indexOf("*/");
        startIndex = startIndex == -1 ? 0 : (startIndex += 3);
        if (endIndex == -1) {
            endIndex = comment.length();
        }
        comment = comment.substring(startIndex, endIndex);
        BufferedReader reader = new BufferedReader(new StringReader(comment));
        try {
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                int i = 0;
                while (i < line.length()) {
                    if (line.charAt(0) != '*') break;
                    line = line.substring(1, line.length());
                    ++i;
                }
                formattedComment = formattedComment + line;
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new Error("Couldn't format comment for declaration: " + decl.getName());
        }
        return formattedComment;
    }
}

